/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.zzh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
implements Result,
SafeParcelable {
    private final int zzCY;
    private final List<Subscription> zzamW;
    private final Status zzOt;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new zzh();

    ListSubscriptionsResult(int versionCode, List<Subscription> subscriptions, Status status) {
        this.zzCY = versionCode;
        this.zzamW = subscriptions;
        this.zzOt = status;
    }

    public ListSubscriptionsResult(List<Subscription> subscriptions, Status status) {
        this.zzCY = 3;
        this.zzamW = Collections.unmodifiableList(subscriptions);
        this.zzOt = zzu.zzb(status, (Object)"status");
    }

    public static ListSubscriptionsResult zzN(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.zzamW;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : this.zzamW) {
            if (!dataType.equals(subscription.zzqM())) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Status getStatus() {
        return this.zzOt;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ListSubscriptionsResult && this.zzb((ListSubscriptionsResult)that);
    }

    private boolean zzb(ListSubscriptionsResult listSubscriptionsResult) {
        return this.zzOt.equals(listSubscriptionsResult.zzOt) && zzt.equal(this.zzamW, listSubscriptionsResult.zzamW);
    }

    public int hashCode() {
        return zzt.hashCode(this.zzOt, this.zzamW);
    }

    public String toString() {
        return zzt.zzt(this).zzg("status", this.zzOt).zzg("subscriptions", this.zzamW).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

