/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.internal.zzx;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zze;
import com.google.android.gms.drive.metadata.internal.zzh;
import com.google.android.gms.internal.zzlo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
implements SafeParcelable {
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzh();
    final int zzCY;
    final Bundle zzagI;

    MetadataBundle(int versionCode, Bundle valueBundle) {
        this.zzCY = versionCode;
        this.zzagI = zzu.zzu(valueBundle);
        this.zzagI.setClassLoader(this.getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.zzagI.keySet()) {
            if (zze.zzcw(string2) != null) continue;
            arrayList.add(string2);
            zzx.zzu("MetadataBundle", "Ignored unknown metadata field in bundle: " + string2);
        }
        for (String string2 : arrayList) {
            this.zzagI.remove(string2);
        }
    }

    private MetadataBundle(Bundle valueBundle) {
        this(1, valueBundle);
    }

    public static MetadataBundle zzpX() {
        return new MetadataBundle(new Bundle());
    }

    public static MetadataBundle zza(MetadataBundle metadataBundle) {
        return new MetadataBundle(new Bundle(metadataBundle.zzagI));
    }

    public static <T> MetadataBundle zza(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zzpX();
        metadataBundle.zzb(metadataField, t);
        return metadataBundle;
    }

    public <T> void zzb(MetadataField<T> metadataField, T t) {
        if (zze.zzcw(metadataField.getName()) == null) {
            throw new IllegalArgumentException("Unregistered field: " + metadataField.getName());
        }
        metadataField.zza(t, this.zzagI);
    }

    public <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzi(this.zzagI);
    }

    public boolean zzc(MetadataField<?> metadataField) {
        return this.zzagI.containsKey(metadataField.getName());
    }

    public Set<MetadataField<?>> zzpY() {
        HashSet hashSet = new HashSet();
        for (String string2 : this.zzagI.keySet()) {
            hashSet.add(zze.zzcw(string2));
        }
        return hashSet;
    }

    public void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzlo.zzaho);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(context.getCacheDir());
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        for (String string2 : this.zzagI.keySet()) {
            n2 = n2 * 31 + this.zzagI.get(string2).hashCode();
        }
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetadataBundle)) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)obj;
        Set set = this.zzagI.keySet();
        if (!set.equals(metadataBundle.zzagI.keySet())) {
            return false;
        }
        for (String string2 : set) {
            if (zzt.equal(this.zzagI.get(string2), metadataBundle.zzagI.get(string2))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MetadataBundle [values=" + this.zzagI + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

