/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.RemoteException;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzi;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzhh;

@zzgd
public abstract class zzd
extends zzhh
implements zzc.zza {
    private final AdRequestInfoParcel zzxm;
    private final zzc.zza zzCi;
    private final Object zzqt = new Object();
    private AdResponseParcel zzBt;

    public zzd(AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
        this.zzxm = adRequestInfoParcel;
        this.zzCi = zza2;
    }

    public abstract void zzfv();

    public abstract zzi zzfw();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzBt = adResponseParcel;
            this.zzqt.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdP() {
        try {
            zzi zzi2 = this.zzfw();
            if (zzi2 == null) {
                AdResponseParcel adResponseParcel = new AdResponseParcel(0);
                this.zzCi.zzb(adResponseParcel);
            } else if (this.zza(zzi2, this.zzxm)) {
                this.zzi(zzo.zzbz().elapsedRealtime());
            }
        }
        finally {
            this.zzfv();
        }
    }

    @Override
    public final void onStop() {
        this.zzfv();
    }

    boolean zza(zzi zzi2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzi2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service.", remoteException);
            zzo.zzby().zzc(remoteException, true);
        }
        catch (NullPointerException nullPointerException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", nullPointerException);
            zzo.zzby().zzc(nullPointerException, true);
        }
        catch (SecurityException securityException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", securityException);
            zzo.zzby().zzc(securityException, true);
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", throwable);
            zzo.zzby().zzc(throwable, true);
        }
        this.zzCi.zzb(new AdResponseParcel(0));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzi(long l) {
        Object object = this.zzqt;
        synchronized (object) {
            do {
                if (this.zzBt == null) continue;
                this.zzCi.zzb(this.zzBt);
                return;
            } while (this.zze(l));
            if (this.zzBt != null) {
                this.zzCi.zzb(this.zzBt);
            } else {
                this.zzCi.zzb(new AdResponseParcel(0));
            }
            return;
        }
    }

    protected boolean zze(long l) {
        long l2 = 60000L - (zzo.zzbz().elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzqt.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    @zzgd
    public static class zzb
    extends zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private Context mContext;
        private AdRequestInfoParcel zzxm;
        private final zzc.zza zzCi;
        private final Object zzqt = new Object();
        protected zze zzCj;

        public zzb(Context context, AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
            super(adRequestInfoParcel, zza2);
            this.mContext = context;
            this.zzxm = adRequestInfoParcel;
            this.zzCi = zza2;
            this.zzCj = new zze(context, this, this, adRequestInfoParcel.zzpJ.zzGI);
            this.connect();
        }

        protected void connect() {
            this.zzCj.zznJ();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzi zzfw() {
            Object object = this.zzqt;
            synchronized (object) {
                try {
                    return this.zzCj.zzfy();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzfv() {
            Object object = this.zzqt;
            synchronized (object) {
                if (this.zzCj.isConnected() || this.zzCj.isConnecting()) {
                    this.zzCj.disconnect();
                }
                Binder.flushPendingCommands();
            }
        }

        zzhh zzfx() {
            return new zza(this.mContext, this.zzxm, this.zzCi);
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            com.google.android.gms.ads.internal.util.client.zzb.zzay("Cannot connect to remote service, fallback to local instance.");
            zzhh zzhh2 = this.zzfx();
            zzhh2.zzgi();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzo.zzbv().zza(this.mContext, this.zzxm.zzpJ.zzGG, "gmob-apps", bundle, true);
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.zzgi();
        }

        @Override
        public void onConnectionSuspended(int cause) {
            com.google.android.gms.ads.internal.util.client.zzb.zzay("Disconnected from remote ad request service.");
        }
    }

    @zzgd
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
            super(adRequestInfoParcel, zza2);
            this.mContext = context;
        }

        @Override
        public zzi zzfw() {
            zzbr zzbr2 = new zzbr(zzbz.zztD.get());
            return zzgf.zza(this.mContext, zzbr2, zzge.zzfC());
        }

        @Override
        public void zzfv() {
        }
    }
}

