/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions
implements SafeParcelable {
    public static final zzh CREATOR = new zzh();
    private final int zzCY;
    private final List<LatLng> zzaDA;
    private float zzaDf = 10.0f;
    private int mColor = -16777216;
    private float zzaDa = 0.0f;
    private boolean zzaDb = true;
    private boolean zzaDC = false;

    public PolylineOptions() {
        this.zzCY = 1;
        this.zzaDA = new ArrayList<LatLng>();
    }

    PolylineOptions(int versionCode, List points, float width, int color2, float zIndex, boolean visible, boolean geodesic) {
        this.zzCY = versionCode;
        this.zzaDA = points;
        this.zzaDf = width;
        this.mColor = color2;
        this.zzaDa = zIndex;
        this.zzaDb = visible;
        this.zzaDC = geodesic;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzh.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public PolylineOptions add(LatLng point) {
        this.zzaDA.add(point);
        return this;
    }

    public PolylineOptions add(LatLng ... points) {
        this.zzaDA.addAll(Arrays.asList(points));
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.zzaDA.add(latLng);
        }
        return this;
    }

    public PolylineOptions width(float width) {
        this.zzaDf = width;
        return this;
    }

    public PolylineOptions color(int color2) {
        this.mColor = color2;
        return this;
    }

    public PolylineOptions zIndex(float zIndex) {
        this.zzaDa = zIndex;
        return this;
    }

    public PolylineOptions visible(boolean visible) {
        this.zzaDb = visible;
        return this;
    }

    public PolylineOptions geodesic(boolean geodesic) {
        this.zzaDC = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzaDA;
    }

    public float getWidth() {
        return this.zzaDf;
    }

    public int getColor() {
        return this.mColor;
    }

    public float getZIndex() {
        return this.zzaDa;
    }

    public boolean isVisible() {
        return this.zzaDb;
    }

    public boolean isGeodesic() {
        return this.zzaDC;
    }
}

