/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DailyTotalRequest;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataInsertRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmf;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzng;

public class zznb
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient client, DataSet dataSet) {
        return this.zza(client, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzu.zzb(dataSet, (Object)"Must set the data set");
        zzu.zza(!dataSet.getDataPoints().isEmpty(), (Object)"Cannot use an empty data set");
        zzu.zzb(dataSet.getDataSource().zzqB(), (Object)"Must set the app package name for the data source");
        return googleApiClient.zza(new zzlz.zzc(googleApiClient){

            @Override
            protected void zza(zzlz zzlz2) throws RemoteException {
                zzng zzng2 = new zzng(this);
                String string2 = zzlz2.getContext().getPackageName();
                ((zzmk)zzlz2.zznM()).zza(new DataInsertRequest(dataSet, zzng2, string2, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient client, final DataDeleteRequest request) {
        return client.zza(new zzlz.zzc(client){

            @Override
            protected void zza(zzlz zzlz2) throws RemoteException {
                zzng zzng2 = new zzng(this);
                String string2 = zzlz2.getContext().getPackageName();
                ((zzmk)zzlz2.zznM()).zza(new DataDeleteRequest(request, zzng2, string2));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient client, final DataReadRequest request) {
        return client.zza(new zzlz.zza<DataReadResult>(client){

            @Override
            protected void zza(zzlz zzlz2) throws RemoteException {
                zza zza2 = new zza(this);
                String string2 = zzlz2.getContext().getPackageName();
                ((zzmk)zzlz2.zznM()).zza(new DataReadRequest(request, zza2, string2));
            }

            protected DataReadResult zzD(Status status) {
                return DataReadResult.zza(status, request);
            }

            @Override
            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzD(x0);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient client, final DataType dataType) {
        return client.zza(new zzlz.zza<DailyTotalResult>(client){

            @Override
            protected void zza(zzlz zzlz2) throws RemoteException {
                zzme.zza zza2 = new zzme.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.setResult(dailyTotalResult);
                    }
                };
                String string2 = zzlz2.getContext().getPackageName();
                DailyTotalRequest dailyTotalRequest = new DailyTotalRequest(zza2, dataType, string2);
                ((zzmk)zzlz2.zznM()).zza(dailyTotalRequest);
            }

            protected DailyTotalResult zzE(Status status) {
                return DailyTotalResult.zzK(status);
            }

            @Override
            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzE(x0);
            }
        });
    }

    private static class zza
    extends zzmf.zza {
        private final zza.zzb<DataReadResult> zzOs;
        private int zzalm = 0;
        private DataReadResult zzaln = null;

        private zza(zza.zzb<DataReadResult> zzb2) {
            this.zzOs = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                Log.v((String)"Fitness", (String)"Received batch result");
                if (this.zzaln == null) {
                    this.zzaln = dataReadResult;
                } else {
                    this.zzaln.zzb(dataReadResult);
                }
                ++this.zzalm;
                if (this.zzalm == this.zzaln.zzrt()) {
                    this.zzOs.zzm(this.zzaln);
                }
            }
        }
    }
}

