/*
 * Copyright 2010-2018 Max Kellermann <max.kellermann@gmail.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * FOUNDATION OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef JAVA_STRING_HXX
#define JAVA_STRING_HXX

#include "Ref.hxx"

#include <jni.h>

#include <stddef.h>

namespace Java {
	/**
	 * Wrapper for a local "jstring" reference.
	 */
	class String : public LocalRef<jstring> {
	public:
		String(JNIEnv *env, jstring value)
			:LocalRef<jstring>(env, value) {}

		String(JNIEnv *_env, const char *_value)
			:LocalRef<jstring>(_env, _env->NewStringUTF(_value)) {}

		/**
		 * Copy the value to the specified buffer.  Truncates
		 * the value if it does not fit into the buffer.
		 *
		 * @return a pointer to the terminating null byte,
		 * nullptr on error
		 */
		static char *CopyTo(JNIEnv *env, jstring value,
				    char *buffer, size_t max_size);

		/**
		 * Copy the value to the specified buffer.  Truncates
		 * the value if it does not fit into the buffer.
		 *
		 * @return a pointer to the terminating null byte,
		 * nullptr on error
		 */
		char *CopyTo(JNIEnv *env, char *buffer, size_t max_size) {
			return CopyTo(env, Get(), buffer, max_size);
		}
	};
}

#endif
