from enum import Enum

# Used for the --wrap-mode command-line argument
#
# Special wrap modes:
#   nofallback: Don't download wraps for dependency() fallbacks
#   nodownload: Don't download wraps for all subproject() calls
#
# subprojects are used for two purposes:
# 1. To download and build dependencies by using .wrap
#    files if they are not provided by the system. This is
#    usually expressed via dependency(..., fallback: ...).
# 2. To download and build 'copylibs' which are meant to be
#    used by copying into your project. This is always done
#    with an explicit subproject() call.
#
# --wrap-mode=nofallback will never do (1)
# --wrap-mode=nodownload will do neither (1) nor (2)
#
# If you are building from a release tarball, you should be
# able to safely use 'nodownload' since upstream is
# expected to ship all required sources with the tarball.
#
# If you are building from a git repository, you will want
# to use 'nofallback' so that any 'copylib' wraps will be
# download as subprojects.
#
# --wrap-mode=forcefallback will ignore external dependencies,
# even if they match the version requirements, and automatically
# use the fallback if one was provided. This is useful for example
# to make sure a project builds when using the fallbacks.
#
# Note that these options do not affect subprojects that
# are git submodules since those are only usable in git
# repositories, and you almost always want to download them.
class WrapMode(Enum):
    default = 1
    nofallback = 2
    nodownload = 3
    forcefallback = 4

    def __str__(self):
        return self.name
