R"SKSL(

// defines built-in functions supported by SkSL when running on a GPU

$genType radians($genType degrees);
$genType sin($genType angle);
$genType cos($genType angle);
$genType tan($genType angle);
$genType asin($genType x);
$genType acos($genType x);
$genType atan($genType y, $genType x);
$genType atan($genType y_over_x);
$genType sinh($genType x);
$genType cosh($genType x);
$genType tanh($genType x);
$genType asinh($genType x);
$genType acosh($genType x);
$genType atanh($genType x);
$genType pow($genType x, $genType y);
$genType exp($genType x);
$genType log($genType x);
$genType exp2($genType x);
$genType log2($genType x);
$genType sqrt($genType x);
$genHType radians($genHType degrees);
$genHType sin($genHType angle);
$genHType cos($genHType angle);
$genHType tan($genHType angle);
$genHType asin($genHType x);
$genHType acos($genHType x);
$genHType atan($genHType y, $genHType x);
$genHType atan($genHType y_over_x);
$genHType sinh($genHType x);
$genHType cosh($genHType x);
$genHType tanh($genHType x);
$genHType asinh($genHType x);
$genHType acosh($genHType x);
$genHType atanh($genHType x);
$genHType pow($genHType x, $genHType y);
$genHType exp($genHType x);
$genHType log($genHType x);
$genHType exp2($genHType x);
$genHType log2($genHType x);
$genHType sqrt($genHType x);
$genType inversesqrt($genType x);
$genType abs($genType x);
$genHType abs($genHType x);
$genIType abs($genIType x);
$genType sign($genType x);
$genHType sign($genHType x);
$genIType sign($genIType x);
$genType floor($genType x);
$genHType floor($genHType x);
$genType trunc($genType x);
$genHType trunc($genHType x);
$genType round($genType x);
$genHType round($genHType x);
$genType roundEven($genType x);
$genHType roundEven($genHType x);
$genType ceil($genType x);
$genHType ceil($genHType x);
$genType fract($genType x);
$genHType fract($genHType x);
$genType mod($genType x, float y);
$genType mod($genType x, $genType y);
$genHType mod($genHType x, half y);
$genHType mod($genHType x, $genType y);
$genType modf($genType x, out $genType i);
$genHType modf($genHType x, out $genHType i);
$genType min($genType x, $genType y);
$genType min($genType x, float y);
$genHType min($genHType x, $genHType y);
$genHType min($genHType x, half y);
$genIType min($genIType x, $genIType y);
$genIType min($genIType x, int y);
$genType max($genType x, $genType y);
$genType max($genType x, float y);
$genHType max($genHType x, $genHType y);
$genHType max($genHType x, half y);
$genIType max($genIType x, $genIType y);
$genIType max($genIType x, int y);
$genType clamp($genType x, $genType minVal, $genType maxVal);
$genType clamp($genType x, float minVal, float maxVal);
$genHType clamp($genHType x, $genHType minVal, $genHType maxVal);
$genHType clamp($genHType x, half minVal, half maxVal);
$genIType clamp($genIType x, $genIType minVal, $genIType maxVal);
$genIType clamp($genIType x, int minVal, int maxVal);
$genType saturate($genType x);
$genHType saturate($genHType x);
$genType mix($genType x, $genType y, $genType a);
$genType mix($genType x, $genType y, float a);
$genHType mix($genHType x, $genHType y, $genHType a);
$genHType mix($genHType x, $genHType y, half a);
$genType mix($genType x, $genType y, $genBType a);
$genHType mix($genHType x, $genHType y, $genBType a);
$genIType mix($genIType x, $genIType y, $genBType a);
$genBType mix($genBType x, $genBType y, $genBType a);
$genType step($genType edge, $genType x);
$genType step(float edge, $genType x);
$genHType step($genHType edge, $genHType x);
$genHType step(half edge, $genHType x);
$genType smoothstep($genType edge0, $genType edge1, $genType x);
$genType smoothstep(float edge0, float edge1, $genType x);
$genHType smoothstep($genHType edge0, $genHType edge1, $genHType x);
$genHType smoothstep(half edge0, half edge1, $genHType x);
$genBType isnan($genType x);
$genBType isnan($genDType x);
$genBType isinf($genType x);
$genBType isinf($genDType x);
$genIType floatBitsToInt($genType value);
$genType intBitsTofloat($genIType value);
$genType uintBitsTofloat($genUType value);
$genType fma($genType a, $genType b, $genType c);
$genHType fma($genHType a, $genHType b, $genHType c);
$genDType fma($genDType a, $genDType b, $genDType c);
sk_has_side_effects $genType frexp($genType x, out $genIType exp);
$genType ldexp($genType x, in $genIType exp);
uint packUnorm2x16(float2 v);
uint packSnorm2x16(float2 v);
uint packUnorm4x8(float4 v);
uint packSnorm4x8(float4 v);
float2 unpackUnorm2x16(uint p);
float2 unpackSnorm2x16(uint p);
float4 unpackUnorm4x8(uint p);
float4 unpackSnorm4x8(uint p);
uint2 unpackDouble2x32(double v);
uint packHalf2x16(float2 v);
float2 unpackHalf2x16(uint v);
float length($genType x);
half length($genHType x);
double length($genDType x);
float distance($genType p0, $genType p1);
half distance($genHType p0, $genHType p1);
double distance($genDType p0, $genDType p1);
float dot($genType x, $genType y);
half dot($genHType x, $genHType y);
double dot($genDType x, $genDType y);
float3 cross(float3 x, float3 y);
half3 cross(half3 x, half3 y);
double3 cross(double3 x, double3 y);
$genType normalize($genType x);
$genHType normalize($genHType x);
$genDType normalize($genDType x);
float4 ftransform();
$genType faceforward($genType N, $genType I, $genType Nref);
$genHType faceforward($genHType N, $genHType I, $genHType Nref);
$genDType faceforward($genDType N, $genDType I, $genDType Nref);
$genType reflect($genType I, $genType N);
$genHType reflect($genHType I, $genHType N);
$genDType reflect($genDType I, $genDType N);
$genType refract($genType I, $genType N, float eta);
$genHType refract($genHType I, $genHType N, float eta);
$genDType refract($genDType I, $genDType N, float eta);
$mat matrixCompMult($mat x, $mat y);
float2x2 outerProduct(float2 c, float2 r);
float3x3 outerProduct(float3 c, float3 r);
float4x3 outerProduct(float4 c, float4 r);
float2x3 outerProduct(float3 c, float2 r);
float3x2 outerProduct(float2 c, float3 r);
float2x4 outerProduct(float4 c, float2 r);
float4x2 outerProduct(float2 c, float4 r);
float3x4 outerProduct(float4 c, float3 r);
float4x3 outerProduct(float3 c, float4 r);
half2x2 outerProduct(half2 c, half2 r);
half3x3 outerProduct(half3 c, half3 r);
half4x3 outerProduct(half4 c, half4 r);
half2x3 outerProduct(half3 c, half2 r);
half3x2 outerProduct(half2 c, half3 r);
half2x4 outerProduct(half4 c, half2 r);
half4x2 outerProduct(half2 c, half4 r);
half3x4 outerProduct(half4 c, half3 r);
half4x3 outerProduct(half3 c, half4 r);
float2x2 transpose(float2x2 m);
float3x3 transpose(float3x3 m);
float4x4 transpose(float4x4 m);
float2x3 transpose(float3x2 m);
float3x2 transpose(float2x3 m);
float2x4 transpose(float4x2 m);
float4x2 transpose(float2x4 m);
float3x4 transpose(float4x3 m);
float4x3 transpose(float3x4 m);
half2x2 transpose(half2x2 m);
half3x3 transpose(half3x3 m);
half4x4 transpose(half4x4 m);
half2x3 transpose(half3x2 m);
half3x2 transpose(half2x3 m);
half2x4 transpose(half4x2 m);
half4x2 transpose(half2x4 m);
half3x4 transpose(half4x3 m);
half4x3 transpose(half3x4 m);
float determinant(float2x2 m);
float determinant(float3x3 m);
float determinant(float4x4 m);
half determinant(half2x2 m);
half determinant(half3x3 m);
half determinant(half4x4 m);
float2x2 inverse(float2x2 m);
float3x3 inverse(float3x3 m);
float4x4 inverse(float4x4 m);
half2x2 inverse(half2x2 m);
half3x3 inverse(half3x3 m);
half4x4 inverse(half4x4 m);
$bvec lessThan($vec x, $vec y);
$bvec lessThan($hvec x, $hvec y);
$bvec lessThan($dvec x, $dvec y);
$bvec lessThan($ivec x, $ivec y);
$bvec lessThan($svec x, $svec y);
$bvec lessThan($usvec x, $usvec y);
$bvec lessThan($uvec x, $uvec y);
$bvec lessThanEqual($vec x, $vec y);
$bvec lessThanEqual($hvec x, $hvec y);
$bvec lessThanEqual($dvec x, $dvec y);
$bvec lessThanEqual($ivec x, $ivec y);
$bvec lessThanEqual($uvec x, $uvec y);
$bvec lessThanEqual($svec x, $svec y);
$bvec lessThanEqual($usvec x, $usvec y);
$bvec greaterThan($vec x, $vec y);
$bvec greaterThan($hvec x, $hvec y);
$bvec greaterThan($dvec x, $dvec y);
$bvec greaterThan($ivec x, $ivec y);
$bvec greaterThan($uvec x, $uvec y);
$bvec greaterThan($svec x, $svec y);
$bvec greaterThan($usvec x, $usvec y);
$bvec greaterThanEqual($vec x, $vec y);
$bvec greaterThanEqual($hvec x, $hvec y);
$bvec greaterThanEqual($dvec x, $dvec y);
$bvec greaterThanEqual($ivec x, $ivec y);
$bvec greaterThanEqual($uvec x, $uvec y);
$bvec greaterThanEqual($svec x, $svec y);
$bvec greaterThanEqual($usvec x, $usvec y);
$bvec equal($vec x, $vec y);
$bvec equal($hvec x, $hvec y);
$bvec equal($dvec x, $dvec y);
$bvec equal($ivec x, $ivec y);
$bvec equal($uvec x, $uvec y);
$bvec equal($svec x, $svec y);
$bvec equal($usvec x, $usvec y);
$bvec equal($bvec x, $bvec y);
$bvec notEqual($vec x, $vec y);
$bvec notEqual($hvec x, $hvec y);
$bvec notEqual($dvec x, $dvec y);
$bvec notEqual($ivec x, $ivec y);
$bvec notEqual($uvec x, $uvec y);
$bvec notEqual($svec x, $svec y);
$bvec notEqual($usvec x, $usvec y);
$bvec notEqual($bvec x, $bvec y);
bool any($bvec x);
bool all($bvec x);
$bvec not($bvec x);

$genIType bitCount($genIType value);
$genIType bitCount($genUType value);
$genIType findLSB($genIType value);
$genIType findLSB($genUType value);
$genIType findMSB($genIType value);
$genIType findMSB($genUType value);

sampler2D makeSampler2D(texture2D texture, sampler sampler);
int2 textureSize($gsampler2DRect sampler);

half4 sample($gsampler1D sampler, float P);
half4 sample($gsampler1D sampler, float P, float bias);
half4 sample($gsampler2D sampler, float2 P);
// The above currently only expand to handle the float/fixed case. So we also declare this integer
// version of sample().
int4 sample(isampler2D sampler, float2 P);
half4 sample(samplerExternalOES sampler, float2 P, float bias);
half4 sample(samplerExternalOES sampler, float2 P);

half4 sample($gsampler2DRect sampler, float2 P);
half4 sample($gsampler2DRect sampler, float3 P);

// Currently we do not support the generic types of loading subpassInput so we have some explicit
// versions that we currently use
float4 subpassLoad(subpassInput subpass);
float4 subpassLoad(subpassInputMS subpass, int sample);

half4 sample($gsampler1D sampler, float2 P);
half4 sample($gsampler1D sampler, float2 P, float bias);
half4 sample($gsampler2D sampler, float3 P);
half4 sample($gsampler2D sampler, float3 P, float bias);

float4 imageLoad(image2D image, int2 P);
int4 imageLoad(iimage2D image, int2 P);
$genType dFdx($genType p);
$genType dFdy($genType p);
$genHType dFdx($genHType p);
$genHType dFdy($genHType p);
$genType fwidth($genType p);
$genHType fwidth($genHType p);
float interpolateAtSample(float interpolant, int sample);
float2 interpolateAtSample(float2 interpolant, int sample);
float3 interpolateAtSample(float3 interpolant, int sample);
float4 interpolateAtSample(float4 interpolant, int sample);
float interpolateAtOffset(float interpolant, float2 offset);
float2 interpolateAtOffset(float2 interpolant, float2 offset);
float3 interpolateAtOffset(float3 interpolant, float2 offset);
float4 interpolateAtOffset(float4 interpolant, float2 offset);
)SKSL"
