/*
 * Copyright (C) 2018 Damir Porobic <damir.porobic@gmx.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KIMAGEANNOTATOR_NUMBERMANAGERTEST_H
#define KIMAGEANNOTATOR_NUMBERMANAGERTEST_H

#include <QtTest>
#include <src/annotations/misc/NumberManager.h>

using kImageAnnotator::NumberManager;
using kImageAnnotator::AnnotationNumber;
using kImageAnnotator::AnnotationTextProperties;

#include "src/annotations/misc/NumberManager.h"

class NumberManagerTest : public QObject
{
Q_OBJECT

private    slots:
	void TestAddItem_Should_TriggerNumberUpdate();
	void TestUpdateNumbers_Should_BeTriggered_When_ItemIsHidden();
	void TestFirstNumberChanged_Should_TriggerUpdateOfAllNumber();
};

#endif // KIMAGEANNOTATOR_NUMBERMANAGERTEST_H
