/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class NegatedColorScheme
extends BaseColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme origScheme;

    public NegatedColorScheme(ColorScheme origScheme) {
        this.origScheme = origScheme;
        this.foregroundColor = SubstanceColorUtilities.invertColor(origScheme.getForegroundColor());
        this.mainUltraDarkColor = SubstanceColorUtilities.invertColor(origScheme.getUltraDarkColor());
        this.mainDarkColor = SubstanceColorUtilities.invertColor(origScheme.getDarkColor());
        this.mainMidColor = SubstanceColorUtilities.invertColor(origScheme.getMidColor());
        this.mainLightColor = SubstanceColorUtilities.invertColor(origScheme.getLightColor());
        this.mainExtraLightColor = SubstanceColorUtilities.invertColor(origScheme.getExtraLightColor());
        this.mainUltraLightColor = SubstanceColorUtilities.invertColor(origScheme.getUltraLightColor());
        this.id = "Negated " + SubstanceCoreUtilities.getSchemeId(origScheme);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public ColorScheme getOrigScheme() {
        return this.origScheme;
    }
}

