
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


#ifndef HDR_layBrowser
#define HDR_layBrowser

#include "config.h"

#include "layPlugin.h"

class QCloseEvent;

namespace lay
{

class LayoutView;
class MainWindow;

class KLAYOUT_DLL Browser
  : public QDialog, 
    public lay::Plugin
{
public:
  /**
   *  @brief Constructor 
   */
  Browser (lay::MainWindow *main, lay::LayoutView *view, const char *name = "", Qt::WFlags fl = Qt::Window /*adds minimize button for example*/);

  /**
   *  @brief Destructor
   */
  virtual ~Browser ();

  /**
   *  @brief Activation event
   *
   *  This method can be overloaded by derived classes to provide actions
   *  for activation of the dialog, like setup of the controls etc.
   *  This handler is called immediately before the dialog becomes visible.
   *  The 'active' method allows to query if the dialog is active.
   */
  virtual void activated () 
  {
    //  the default implementation does nothing.
  }

  /**
   *  @brief Deactivation event
   *
   *  The handler is called if the dialog becomes deactivated, either by
   *  request of the view or by closing the dialog. This method is supposed
   *  to release all resources related to the browsing, i.e. view objects etc.
   */
  virtual void deactivated () 
  {
    //  the default implementation does nothing.
  }
  
  /**
   *  @brief Tell if the dialog is active
   */
  bool active () const
  {
    return m_active;
  }

  /** 
   *  @brief Return the pointer to the layout view 
   */
  lay::LayoutView *view () 
  {
    return mp_view;
  }

  /** 
   *  @brief Return the pointer to the main window
   */
  lay::MainWindow *main_window () 
  {
    return mp_main_window;
  }

  /**
   *  @brief Activate the dialog
   *
   *  Calls activated() before the dialog is shown. show() can be used too
   *  but will not activate the dialog.
   */
  void activate ();

  /**
   *  @brief Deactivate the dialog
   *
   *  Calls deactivated() after the dialog is hidden. hide() can be used too
   *  but will not deactivate the dialog.
   */
  void deactivate ();

  /**
   *  @brief implementation of the lay::Plugin interface: obtain a pointer to the lay::Browser interface
   */
  lay::Browser *browser_interface ()
  {
    return this;
  }

private:
  bool m_active;
  lay::LayoutView *mp_view;
  lay::MainWindow *mp_main_window;

  void closeEvent (QCloseEvent *);
  void accept ();
};

}

#endif

