
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQt.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQt_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// namespace Qt

class Qt_Namespace { };

namespace gsi
{
gsi::Class<Qt_Namespace> decl_Qt_Namespace ("Qt",
  gsi::Methods(),
  "@qt\n@brief This class represents the Qt namespace");
}


//  Implementation of the enum wrapper class for Qt::AlignmentFlag
namespace qt_gsi
{

static Qt_AlignmentFlag_Enum *c_1_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignLeft); }
static Qt_AlignmentFlag_Enum *c_2_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignLeading); }
static Qt_AlignmentFlag_Enum *c_3_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignRight); }
static Qt_AlignmentFlag_Enum *c_4_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignTrailing); }
static Qt_AlignmentFlag_Enum *c_5_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignHCenter); }
static Qt_AlignmentFlag_Enum *c_6_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignJustify); }
static Qt_AlignmentFlag_Enum *c_7_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignAbsolute); }
static Qt_AlignmentFlag_Enum *c_8_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignHorizontal_Mask); }
static Qt_AlignmentFlag_Enum *c_9_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignTop); }
static Qt_AlignmentFlag_Enum *c_10_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignBottom); }
static Qt_AlignmentFlag_Enum *c_11_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignVCenter); }
static Qt_AlignmentFlag_Enum *c_12_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignVertical_Mask); }
static Qt_AlignmentFlag_Enum *c_13_Qt_AlignmentFlag_Enum () { return new Qt_AlignmentFlag_Enum (Qt::AlignCenter); }

static gsi::Methods mkdefs_Qt_AlignmentFlag () {
  return
    gsi::constant ("AlignLeft", &qt_gsi::c_1_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignLeft") +
    gsi::constant ("AlignLeading", &qt_gsi::c_2_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignLeading") +
    gsi::constant ("AlignRight", &qt_gsi::c_3_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignRight") +
    gsi::constant ("AlignTrailing", &qt_gsi::c_4_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignTrailing") +
    gsi::constant ("AlignHCenter", &qt_gsi::c_5_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignHCenter") +
    gsi::constant ("AlignJustify", &qt_gsi::c_6_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignJustify") +
    gsi::constant ("AlignAbsolute", &qt_gsi::c_7_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignAbsolute") +
    gsi::constant ("AlignHorizontal_Mask", &qt_gsi::c_8_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignHorizontal_Mask") +
    gsi::constant ("AlignTop", &qt_gsi::c_9_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignTop") +
    gsi::constant ("AlignBottom", &qt_gsi::c_10_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignBottom") +
    gsi::constant ("AlignVCenter", &qt_gsi::c_11_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignVCenter") +
    gsi::constant ("AlignVertical_Mask", &qt_gsi::c_12_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignVertical_Mask") +
    gsi::constant ("AlignCenter", &qt_gsi::c_13_Qt_AlignmentFlag_Enum, "@brief Enum constant Qt::AlignCenter");
}

static std::string to_s_Qt_AlignmentFlag_Enum (const Qt_AlignmentFlag_Enum *e)
{
  if (e->value () == Qt::AlignLeft) { return tl::sprintf ("AlignLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignLeading) { return tl::sprintf ("AlignLeading (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignRight) { return tl::sprintf ("AlignRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignTrailing) { return tl::sprintf ("AlignTrailing (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignHCenter) { return tl::sprintf ("AlignHCenter (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignJustify) { return tl::sprintf ("AlignJustify (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignAbsolute) { return tl::sprintf ("AlignAbsolute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignHorizontal_Mask) { return tl::sprintf ("AlignHorizontal_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignTop) { return tl::sprintf ("AlignTop (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignBottom) { return tl::sprintf ("AlignBottom (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignVCenter) { return tl::sprintf ("AlignVCenter (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignVertical_Mask) { return tl::sprintf ("AlignVertical_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlignCenter) { return tl::sprintf ("AlignCenter (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_AlignmentFlag_Enum (const Qt_AlignmentFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_AlignmentFlag_Enum *from_i_Qt_AlignmentFlag_Enum (unsigned int i)
{
  return new Qt_AlignmentFlag_Enum ((Qt::AlignmentFlag) i);
}

static bool equalQt_AlignmentFlag_Enum (const Qt_AlignmentFlag_Enum *e, Qt_AlignmentFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_AlignmentFlag_Enum (const Qt_AlignmentFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_AlignmentFlag_Enums oropQt_AlignmentFlag_Enums (const Qt_AlignmentFlag_Enums *e, const Qt_AlignmentFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_AlignmentFlag_Enums andopQt_AlignmentFlag_Enums (const Qt_AlignmentFlag_Enums *e, const Qt_AlignmentFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_AlignmentFlag_Enums xoropQt_AlignmentFlag_Enums (const Qt_AlignmentFlag_Enums *e, const Qt_AlignmentFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_AlignmentFlag_Enums (const Qt_AlignmentFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::AlignLeft)) { if (!l.empty ()) l += "|"; l += "AlignLeft"; }
  if (e->testFlag (Qt::AlignLeading)) { if (!l.empty ()) l += "|"; l += "AlignLeading"; }
  if (e->testFlag (Qt::AlignRight)) { if (!l.empty ()) l += "|"; l += "AlignRight"; }
  if (e->testFlag (Qt::AlignTrailing)) { if (!l.empty ()) l += "|"; l += "AlignTrailing"; }
  if (e->testFlag (Qt::AlignHCenter)) { if (!l.empty ()) l += "|"; l += "AlignHCenter"; }
  if (e->testFlag (Qt::AlignJustify)) { if (!l.empty ()) l += "|"; l += "AlignJustify"; }
  if (e->testFlag (Qt::AlignAbsolute)) { if (!l.empty ()) l += "|"; l += "AlignAbsolute"; }
  if (e->testFlag (Qt::AlignHorizontal_Mask)) { if (!l.empty ()) l += "|"; l += "AlignHorizontal_Mask"; }
  if (e->testFlag (Qt::AlignTop)) { if (!l.empty ()) l += "|"; l += "AlignTop"; }
  if (e->testFlag (Qt::AlignBottom)) { if (!l.empty ()) l += "|"; l += "AlignBottom"; }
  if (e->testFlag (Qt::AlignVCenter)) { if (!l.empty ()) l += "|"; l += "AlignVCenter"; }
  if (e->testFlag (Qt::AlignVertical_Mask)) { if (!l.empty ()) l += "|"; l += "AlignVertical_Mask"; }
  if (e->testFlag (Qt::AlignCenter)) { if (!l.empty ()) l += "|"; l += "AlignCenter"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_AlignmentFlag_Enums (const Qt_AlignmentFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_AlignmentFlag_Enums (const Qt_AlignmentFlag_Enums *e, const Qt_AlignmentFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_AlignmentFlag_Enums> decl_Qt_AlignmentFlag_Enums ("Qt_QFlags_AlignmentFlag",
  gsi::method_ext ("|", &qt_gsi::oropQt_AlignmentFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_AlignmentFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_AlignmentFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_AlignmentFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_AlignmentFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_AlignmentFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::AlignmentFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_AlignmentFlag_Enum> decl_Qt_AlignmentFlag_Enum (decl_Qt_AlignmentFlag_Enums, "Qt_AlignmentFlag",
  qt_gsi::mkdefs_Qt_AlignmentFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_AlignmentFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_AlignmentFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_AlignmentFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_AlignmentFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_AlignmentFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::AlignmentFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_AlignmentFlag_Enum_in_parent (qt_gsi::mkdefs_Qt_AlignmentFlag ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_AlignmentFlag_Enum_as_child (decl_Qt_AlignmentFlag_Enum, "AlignmentFlag");

}


//  Implementation of the enum wrapper class for Qt::AnchorAttribute
namespace qt_gsi
{

static Qt_AnchorAttribute_Enum *c_1_Qt_AnchorAttribute_Enum () { return new Qt_AnchorAttribute_Enum (Qt::AnchorName); }
static Qt_AnchorAttribute_Enum *c_2_Qt_AnchorAttribute_Enum () { return new Qt_AnchorAttribute_Enum (Qt::AnchorHref); }

static gsi::Methods mkdefs_Qt_AnchorAttribute () {
  return
    gsi::constant ("AnchorName", &qt_gsi::c_1_Qt_AnchorAttribute_Enum, "@brief Enum constant Qt::AnchorName") +
    gsi::constant ("AnchorHref", &qt_gsi::c_2_Qt_AnchorAttribute_Enum, "@brief Enum constant Qt::AnchorHref");
}

static std::string to_s_Qt_AnchorAttribute_Enum (const Qt_AnchorAttribute_Enum *e)
{
  if (e->value () == Qt::AnchorName) { return tl::sprintf ("AnchorName (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AnchorHref) { return tl::sprintf ("AnchorHref (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_AnchorAttribute_Enum (const Qt_AnchorAttribute_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_AnchorAttribute_Enum *from_i_Qt_AnchorAttribute_Enum (unsigned int i)
{
  return new Qt_AnchorAttribute_Enum ((Qt::AnchorAttribute) i);
}

static bool equalQt_AnchorAttribute_Enum (const Qt_AnchorAttribute_Enum *e, Qt_AnchorAttribute_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_AnchorAttribute_Enum (const Qt_AnchorAttribute_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_AnchorAttribute_Enums oropQt_AnchorAttribute_Enums (const Qt_AnchorAttribute_Enums *e, const Qt_AnchorAttribute_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_AnchorAttribute_Enums andopQt_AnchorAttribute_Enums (const Qt_AnchorAttribute_Enums *e, const Qt_AnchorAttribute_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_AnchorAttribute_Enums xoropQt_AnchorAttribute_Enums (const Qt_AnchorAttribute_Enums *e, const Qt_AnchorAttribute_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_AnchorAttribute_Enums (const Qt_AnchorAttribute_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::AnchorName)) { if (!l.empty ()) l += "|"; l += "AnchorName"; }
  if (e->testFlag (Qt::AnchorHref)) { if (!l.empty ()) l += "|"; l += "AnchorHref"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_AnchorAttribute_Enums (const Qt_AnchorAttribute_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_AnchorAttribute_Enums (const Qt_AnchorAttribute_Enums *e, const Qt_AnchorAttribute_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_AnchorAttribute_Enums> decl_Qt_AnchorAttribute_Enums ("Qt_QFlags_AnchorAttribute",
  gsi::method_ext ("|", &qt_gsi::oropQt_AnchorAttribute_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_AnchorAttribute_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_AnchorAttribute_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_AnchorAttribute_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_AnchorAttribute_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_AnchorAttribute_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::AnchorAttribute> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_AnchorAttribute_Enum> decl_Qt_AnchorAttribute_Enum (decl_Qt_AnchorAttribute_Enums, "Qt_AnchorAttribute",
  qt_gsi::mkdefs_Qt_AnchorAttribute () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_AnchorAttribute_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_AnchorAttribute_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_AnchorAttribute_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_AnchorAttribute_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_AnchorAttribute_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::AnchorAttribute enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_AnchorAttribute_Enum_in_parent (qt_gsi::mkdefs_Qt_AnchorAttribute ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_AnchorAttribute_Enum_as_child (decl_Qt_AnchorAttribute_Enum, "AnchorAttribute");

}


//  Implementation of the enum wrapper class for Qt::AnchorPoint
namespace qt_gsi
{

static Qt_AnchorPoint_Enum *c_1_Qt_AnchorPoint_Enum () { return new Qt_AnchorPoint_Enum (Qt::AnchorLeft); }
static Qt_AnchorPoint_Enum *c_2_Qt_AnchorPoint_Enum () { return new Qt_AnchorPoint_Enum (Qt::AnchorHorizontalCenter); }
static Qt_AnchorPoint_Enum *c_3_Qt_AnchorPoint_Enum () { return new Qt_AnchorPoint_Enum (Qt::AnchorRight); }
static Qt_AnchorPoint_Enum *c_4_Qt_AnchorPoint_Enum () { return new Qt_AnchorPoint_Enum (Qt::AnchorTop); }
static Qt_AnchorPoint_Enum *c_5_Qt_AnchorPoint_Enum () { return new Qt_AnchorPoint_Enum (Qt::AnchorVerticalCenter); }
static Qt_AnchorPoint_Enum *c_6_Qt_AnchorPoint_Enum () { return new Qt_AnchorPoint_Enum (Qt::AnchorBottom); }

static gsi::Methods mkdefs_Qt_AnchorPoint () {
  return
    gsi::constant ("AnchorLeft", &qt_gsi::c_1_Qt_AnchorPoint_Enum, "@brief Enum constant Qt::AnchorLeft") +
    gsi::constant ("AnchorHorizontalCenter", &qt_gsi::c_2_Qt_AnchorPoint_Enum, "@brief Enum constant Qt::AnchorHorizontalCenter") +
    gsi::constant ("AnchorRight", &qt_gsi::c_3_Qt_AnchorPoint_Enum, "@brief Enum constant Qt::AnchorRight") +
    gsi::constant ("AnchorTop", &qt_gsi::c_4_Qt_AnchorPoint_Enum, "@brief Enum constant Qt::AnchorTop") +
    gsi::constant ("AnchorVerticalCenter", &qt_gsi::c_5_Qt_AnchorPoint_Enum, "@brief Enum constant Qt::AnchorVerticalCenter") +
    gsi::constant ("AnchorBottom", &qt_gsi::c_6_Qt_AnchorPoint_Enum, "@brief Enum constant Qt::AnchorBottom");
}

static std::string to_s_Qt_AnchorPoint_Enum (const Qt_AnchorPoint_Enum *e)
{
  if (e->value () == Qt::AnchorLeft) { return tl::sprintf ("AnchorLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AnchorHorizontalCenter) { return tl::sprintf ("AnchorHorizontalCenter (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AnchorRight) { return tl::sprintf ("AnchorRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AnchorTop) { return tl::sprintf ("AnchorTop (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AnchorVerticalCenter) { return tl::sprintf ("AnchorVerticalCenter (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AnchorBottom) { return tl::sprintf ("AnchorBottom (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_AnchorPoint_Enum (const Qt_AnchorPoint_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_AnchorPoint_Enum *from_i_Qt_AnchorPoint_Enum (unsigned int i)
{
  return new Qt_AnchorPoint_Enum ((Qt::AnchorPoint) i);
}

static bool equalQt_AnchorPoint_Enum (const Qt_AnchorPoint_Enum *e, Qt_AnchorPoint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_AnchorPoint_Enum (const Qt_AnchorPoint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_AnchorPoint_Enums oropQt_AnchorPoint_Enums (const Qt_AnchorPoint_Enums *e, const Qt_AnchorPoint_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_AnchorPoint_Enums andopQt_AnchorPoint_Enums (const Qt_AnchorPoint_Enums *e, const Qt_AnchorPoint_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_AnchorPoint_Enums xoropQt_AnchorPoint_Enums (const Qt_AnchorPoint_Enums *e, const Qt_AnchorPoint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_AnchorPoint_Enums (const Qt_AnchorPoint_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::AnchorLeft)) { if (!l.empty ()) l += "|"; l += "AnchorLeft"; }
  if (e->testFlag (Qt::AnchorHorizontalCenter)) { if (!l.empty ()) l += "|"; l += "AnchorHorizontalCenter"; }
  if (e->testFlag (Qt::AnchorRight)) { if (!l.empty ()) l += "|"; l += "AnchorRight"; }
  if (e->testFlag (Qt::AnchorTop)) { if (!l.empty ()) l += "|"; l += "AnchorTop"; }
  if (e->testFlag (Qt::AnchorVerticalCenter)) { if (!l.empty ()) l += "|"; l += "AnchorVerticalCenter"; }
  if (e->testFlag (Qt::AnchorBottom)) { if (!l.empty ()) l += "|"; l += "AnchorBottom"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_AnchorPoint_Enums (const Qt_AnchorPoint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_AnchorPoint_Enums (const Qt_AnchorPoint_Enums *e, const Qt_AnchorPoint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_AnchorPoint_Enums> decl_Qt_AnchorPoint_Enums ("Qt_QFlags_AnchorPoint",
  gsi::method_ext ("|", &qt_gsi::oropQt_AnchorPoint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_AnchorPoint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_AnchorPoint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_AnchorPoint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_AnchorPoint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_AnchorPoint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::AnchorPoint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_AnchorPoint_Enum> decl_Qt_AnchorPoint_Enum (decl_Qt_AnchorPoint_Enums, "Qt_AnchorPoint",
  qt_gsi::mkdefs_Qt_AnchorPoint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_AnchorPoint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_AnchorPoint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_AnchorPoint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_AnchorPoint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_AnchorPoint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::AnchorPoint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_AnchorPoint_Enum_in_parent (qt_gsi::mkdefs_Qt_AnchorPoint ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_AnchorPoint_Enum_as_child (decl_Qt_AnchorPoint_Enum, "AnchorPoint");

}


//  Implementation of the enum wrapper class for Qt::ApplicationAttribute
namespace qt_gsi
{

static Qt_ApplicationAttribute_Enum *c_1_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_ImmediateWidgetCreation); }
static Qt_ApplicationAttribute_Enum *c_2_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_MSWindowsUseDirect3DByDefault); }
static Qt_ApplicationAttribute_Enum *c_3_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_DontShowIconsInMenus); }
static Qt_ApplicationAttribute_Enum *c_4_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_NativeWindows); }
static Qt_ApplicationAttribute_Enum *c_5_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_DontCreateNativeWidgetSiblings); }
static Qt_ApplicationAttribute_Enum *c_6_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_MacPluginApplication); }
static Qt_ApplicationAttribute_Enum *c_7_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_DontUseNativeMenuBar); }
static Qt_ApplicationAttribute_Enum *c_8_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_MacDontSwapCtrlAndMeta); }
static Qt_ApplicationAttribute_Enum *c_9_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_S60DontConstructApplicationPanes); }
static Qt_ApplicationAttribute_Enum *c_10_Qt_ApplicationAttribute_Enum () { return new Qt_ApplicationAttribute_Enum (Qt::AA_AttributeCount); }

static gsi::Methods mkdefs_Qt_ApplicationAttribute () {
  return
    gsi::constant ("AA_ImmediateWidgetCreation", &qt_gsi::c_1_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_ImmediateWidgetCreation") +
    gsi::constant ("AA_MSWindowsUseDirect3DByDefault", &qt_gsi::c_2_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_MSWindowsUseDirect3DByDefault") +
    gsi::constant ("AA_DontShowIconsInMenus", &qt_gsi::c_3_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_DontShowIconsInMenus") +
    gsi::constant ("AA_NativeWindows", &qt_gsi::c_4_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_NativeWindows") +
    gsi::constant ("AA_DontCreateNativeWidgetSiblings", &qt_gsi::c_5_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_DontCreateNativeWidgetSiblings") +
    gsi::constant ("AA_MacPluginApplication", &qt_gsi::c_6_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_MacPluginApplication") +
    gsi::constant ("AA_DontUseNativeMenuBar", &qt_gsi::c_7_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_DontUseNativeMenuBar") +
    gsi::constant ("AA_MacDontSwapCtrlAndMeta", &qt_gsi::c_8_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_MacDontSwapCtrlAndMeta") +
    gsi::constant ("AA_S60DontConstructApplicationPanes", &qt_gsi::c_9_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_S60DontConstructApplicationPanes") +
    gsi::constant ("AA_AttributeCount", &qt_gsi::c_10_Qt_ApplicationAttribute_Enum, "@brief Enum constant Qt::AA_AttributeCount");
}

static std::string to_s_Qt_ApplicationAttribute_Enum (const Qt_ApplicationAttribute_Enum *e)
{
  if (e->value () == Qt::AA_ImmediateWidgetCreation) { return tl::sprintf ("AA_ImmediateWidgetCreation (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AA_MSWindowsUseDirect3DByDefault) { return tl::sprintf ("AA_MSWindowsUseDirect3DByDefault (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AA_DontShowIconsInMenus) { return tl::sprintf ("AA_DontShowIconsInMenus (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AA_NativeWindows) { return tl::sprintf ("AA_NativeWindows (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AA_DontCreateNativeWidgetSiblings) { return tl::sprintf ("AA_DontCreateNativeWidgetSiblings (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AA_MacPluginApplication) { return tl::sprintf ("AA_MacPluginApplication (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AA_DontUseNativeMenuBar) { return tl::sprintf ("AA_DontUseNativeMenuBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AA_MacDontSwapCtrlAndMeta) { return tl::sprintf ("AA_MacDontSwapCtrlAndMeta (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AA_S60DontConstructApplicationPanes) { return tl::sprintf ("AA_S60DontConstructApplicationPanes (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AA_AttributeCount) { return tl::sprintf ("AA_AttributeCount (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ApplicationAttribute_Enum (const Qt_ApplicationAttribute_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ApplicationAttribute_Enum *from_i_Qt_ApplicationAttribute_Enum (unsigned int i)
{
  return new Qt_ApplicationAttribute_Enum ((Qt::ApplicationAttribute) i);
}

static bool equalQt_ApplicationAttribute_Enum (const Qt_ApplicationAttribute_Enum *e, Qt_ApplicationAttribute_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ApplicationAttribute_Enum (const Qt_ApplicationAttribute_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ApplicationAttribute_Enums oropQt_ApplicationAttribute_Enums (const Qt_ApplicationAttribute_Enums *e, const Qt_ApplicationAttribute_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ApplicationAttribute_Enums andopQt_ApplicationAttribute_Enums (const Qt_ApplicationAttribute_Enums *e, const Qt_ApplicationAttribute_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ApplicationAttribute_Enums xoropQt_ApplicationAttribute_Enums (const Qt_ApplicationAttribute_Enums *e, const Qt_ApplicationAttribute_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ApplicationAttribute_Enums (const Qt_ApplicationAttribute_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::AA_ImmediateWidgetCreation)) { if (!l.empty ()) l += "|"; l += "AA_ImmediateWidgetCreation"; }
  if (e->testFlag (Qt::AA_MSWindowsUseDirect3DByDefault)) { if (!l.empty ()) l += "|"; l += "AA_MSWindowsUseDirect3DByDefault"; }
  if (e->testFlag (Qt::AA_DontShowIconsInMenus)) { if (!l.empty ()) l += "|"; l += "AA_DontShowIconsInMenus"; }
  if (e->testFlag (Qt::AA_NativeWindows)) { if (!l.empty ()) l += "|"; l += "AA_NativeWindows"; }
  if (e->testFlag (Qt::AA_DontCreateNativeWidgetSiblings)) { if (!l.empty ()) l += "|"; l += "AA_DontCreateNativeWidgetSiblings"; }
  if (e->testFlag (Qt::AA_MacPluginApplication)) { if (!l.empty ()) l += "|"; l += "AA_MacPluginApplication"; }
  if (e->testFlag (Qt::AA_DontUseNativeMenuBar)) { if (!l.empty ()) l += "|"; l += "AA_DontUseNativeMenuBar"; }
  if (e->testFlag (Qt::AA_MacDontSwapCtrlAndMeta)) { if (!l.empty ()) l += "|"; l += "AA_MacDontSwapCtrlAndMeta"; }
  if (e->testFlag (Qt::AA_S60DontConstructApplicationPanes)) { if (!l.empty ()) l += "|"; l += "AA_S60DontConstructApplicationPanes"; }
  if (e->testFlag (Qt::AA_AttributeCount)) { if (!l.empty ()) l += "|"; l += "AA_AttributeCount"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ApplicationAttribute_Enums (const Qt_ApplicationAttribute_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ApplicationAttribute_Enums (const Qt_ApplicationAttribute_Enums *e, const Qt_ApplicationAttribute_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ApplicationAttribute_Enums> decl_Qt_ApplicationAttribute_Enums ("Qt_QFlags_ApplicationAttribute",
  gsi::method_ext ("|", &qt_gsi::oropQt_ApplicationAttribute_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ApplicationAttribute_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ApplicationAttribute_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ApplicationAttribute_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ApplicationAttribute_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ApplicationAttribute_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ApplicationAttribute> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ApplicationAttribute_Enum> decl_Qt_ApplicationAttribute_Enum (decl_Qt_ApplicationAttribute_Enums, "Qt_ApplicationAttribute",
  qt_gsi::mkdefs_Qt_ApplicationAttribute () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ApplicationAttribute_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ApplicationAttribute_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ApplicationAttribute_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ApplicationAttribute_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ApplicationAttribute_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ApplicationAttribute enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ApplicationAttribute_Enum_in_parent (qt_gsi::mkdefs_Qt_ApplicationAttribute ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ApplicationAttribute_Enum_as_child (decl_Qt_ApplicationAttribute_Enum, "ApplicationAttribute");

}


//  Implementation of the enum wrapper class for Qt::ArrowType
namespace qt_gsi
{

static Qt_ArrowType_Enum *c_1_Qt_ArrowType_Enum () { return new Qt_ArrowType_Enum (Qt::NoArrow); }
static Qt_ArrowType_Enum *c_2_Qt_ArrowType_Enum () { return new Qt_ArrowType_Enum (Qt::UpArrow); }
static Qt_ArrowType_Enum *c_3_Qt_ArrowType_Enum () { return new Qt_ArrowType_Enum (Qt::DownArrow); }
static Qt_ArrowType_Enum *c_4_Qt_ArrowType_Enum () { return new Qt_ArrowType_Enum (Qt::LeftArrow); }
static Qt_ArrowType_Enum *c_5_Qt_ArrowType_Enum () { return new Qt_ArrowType_Enum (Qt::RightArrow); }

static gsi::Methods mkdefs_Qt_ArrowType () {
  return
    gsi::constant ("NoArrow", &qt_gsi::c_1_Qt_ArrowType_Enum, "@brief Enum constant Qt::NoArrow") +
    gsi::constant ("UpArrow", &qt_gsi::c_2_Qt_ArrowType_Enum, "@brief Enum constant Qt::UpArrow") +
    gsi::constant ("DownArrow", &qt_gsi::c_3_Qt_ArrowType_Enum, "@brief Enum constant Qt::DownArrow") +
    gsi::constant ("LeftArrow", &qt_gsi::c_4_Qt_ArrowType_Enum, "@brief Enum constant Qt::LeftArrow") +
    gsi::constant ("RightArrow", &qt_gsi::c_5_Qt_ArrowType_Enum, "@brief Enum constant Qt::RightArrow");
}

static std::string to_s_Qt_ArrowType_Enum (const Qt_ArrowType_Enum *e)
{
  if (e->value () == Qt::NoArrow) { return tl::sprintf ("NoArrow (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UpArrow) { return tl::sprintf ("UpArrow (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DownArrow) { return tl::sprintf ("DownArrow (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LeftArrow) { return tl::sprintf ("LeftArrow (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RightArrow) { return tl::sprintf ("RightArrow (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ArrowType_Enum (const Qt_ArrowType_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ArrowType_Enum *from_i_Qt_ArrowType_Enum (unsigned int i)
{
  return new Qt_ArrowType_Enum ((Qt::ArrowType) i);
}

static bool equalQt_ArrowType_Enum (const Qt_ArrowType_Enum *e, Qt_ArrowType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ArrowType_Enum (const Qt_ArrowType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ArrowType_Enums oropQt_ArrowType_Enums (const Qt_ArrowType_Enums *e, const Qt_ArrowType_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ArrowType_Enums andopQt_ArrowType_Enums (const Qt_ArrowType_Enums *e, const Qt_ArrowType_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ArrowType_Enums xoropQt_ArrowType_Enums (const Qt_ArrowType_Enums *e, const Qt_ArrowType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ArrowType_Enums (const Qt_ArrowType_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoArrow)) { if (!l.empty ()) l += "|"; l += "NoArrow"; }
  if (e->testFlag (Qt::UpArrow)) { if (!l.empty ()) l += "|"; l += "UpArrow"; }
  if (e->testFlag (Qt::DownArrow)) { if (!l.empty ()) l += "|"; l += "DownArrow"; }
  if (e->testFlag (Qt::LeftArrow)) { if (!l.empty ()) l += "|"; l += "LeftArrow"; }
  if (e->testFlag (Qt::RightArrow)) { if (!l.empty ()) l += "|"; l += "RightArrow"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ArrowType_Enums (const Qt_ArrowType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ArrowType_Enums (const Qt_ArrowType_Enums *e, const Qt_ArrowType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ArrowType_Enums> decl_Qt_ArrowType_Enums ("Qt_QFlags_ArrowType",
  gsi::method_ext ("|", &qt_gsi::oropQt_ArrowType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ArrowType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ArrowType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ArrowType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ArrowType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ArrowType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ArrowType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ArrowType_Enum> decl_Qt_ArrowType_Enum (decl_Qt_ArrowType_Enums, "Qt_ArrowType",
  qt_gsi::mkdefs_Qt_ArrowType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ArrowType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ArrowType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ArrowType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ArrowType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ArrowType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ArrowType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ArrowType_Enum_in_parent (qt_gsi::mkdefs_Qt_ArrowType ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ArrowType_Enum_as_child (decl_Qt_ArrowType_Enum, "ArrowType");

}


//  Implementation of the enum wrapper class for Qt::AspectRatioMode
namespace qt_gsi
{

static Qt_AspectRatioMode_Enum *c_1_Qt_AspectRatioMode_Enum () { return new Qt_AspectRatioMode_Enum (Qt::IgnoreAspectRatio); }
static Qt_AspectRatioMode_Enum *c_2_Qt_AspectRatioMode_Enum () { return new Qt_AspectRatioMode_Enum (Qt::KeepAspectRatio); }
static Qt_AspectRatioMode_Enum *c_3_Qt_AspectRatioMode_Enum () { return new Qt_AspectRatioMode_Enum (Qt::KeepAspectRatioByExpanding); }

static gsi::Methods mkdefs_Qt_AspectRatioMode () {
  return
    gsi::constant ("IgnoreAspectRatio", &qt_gsi::c_1_Qt_AspectRatioMode_Enum, "@brief Enum constant Qt::IgnoreAspectRatio") +
    gsi::constant ("KeepAspectRatio", &qt_gsi::c_2_Qt_AspectRatioMode_Enum, "@brief Enum constant Qt::KeepAspectRatio") +
    gsi::constant ("KeepAspectRatioByExpanding", &qt_gsi::c_3_Qt_AspectRatioMode_Enum, "@brief Enum constant Qt::KeepAspectRatioByExpanding");
}

static std::string to_s_Qt_AspectRatioMode_Enum (const Qt_AspectRatioMode_Enum *e)
{
  if (e->value () == Qt::IgnoreAspectRatio) { return tl::sprintf ("IgnoreAspectRatio (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::KeepAspectRatio) { return tl::sprintf ("KeepAspectRatio (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::KeepAspectRatioByExpanding) { return tl::sprintf ("KeepAspectRatioByExpanding (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_AspectRatioMode_Enum (const Qt_AspectRatioMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_AspectRatioMode_Enum *from_i_Qt_AspectRatioMode_Enum (unsigned int i)
{
  return new Qt_AspectRatioMode_Enum ((Qt::AspectRatioMode) i);
}

static bool equalQt_AspectRatioMode_Enum (const Qt_AspectRatioMode_Enum *e, Qt_AspectRatioMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_AspectRatioMode_Enum (const Qt_AspectRatioMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_AspectRatioMode_Enums oropQt_AspectRatioMode_Enums (const Qt_AspectRatioMode_Enums *e, const Qt_AspectRatioMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_AspectRatioMode_Enums andopQt_AspectRatioMode_Enums (const Qt_AspectRatioMode_Enums *e, const Qt_AspectRatioMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_AspectRatioMode_Enums xoropQt_AspectRatioMode_Enums (const Qt_AspectRatioMode_Enums *e, const Qt_AspectRatioMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_AspectRatioMode_Enums (const Qt_AspectRatioMode_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::IgnoreAspectRatio)) { if (!l.empty ()) l += "|"; l += "IgnoreAspectRatio"; }
  if (e->testFlag (Qt::KeepAspectRatio)) { if (!l.empty ()) l += "|"; l += "KeepAspectRatio"; }
  if (e->testFlag (Qt::KeepAspectRatioByExpanding)) { if (!l.empty ()) l += "|"; l += "KeepAspectRatioByExpanding"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_AspectRatioMode_Enums (const Qt_AspectRatioMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_AspectRatioMode_Enums (const Qt_AspectRatioMode_Enums *e, const Qt_AspectRatioMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_AspectRatioMode_Enums> decl_Qt_AspectRatioMode_Enums ("Qt_QFlags_AspectRatioMode",
  gsi::method_ext ("|", &qt_gsi::oropQt_AspectRatioMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_AspectRatioMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_AspectRatioMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_AspectRatioMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_AspectRatioMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_AspectRatioMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::AspectRatioMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_AspectRatioMode_Enum> decl_Qt_AspectRatioMode_Enum (decl_Qt_AspectRatioMode_Enums, "Qt_AspectRatioMode",
  qt_gsi::mkdefs_Qt_AspectRatioMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_AspectRatioMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_AspectRatioMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_AspectRatioMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_AspectRatioMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_AspectRatioMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::AspectRatioMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_AspectRatioMode_Enum_in_parent (qt_gsi::mkdefs_Qt_AspectRatioMode ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_AspectRatioMode_Enum_as_child (decl_Qt_AspectRatioMode_Enum, "AspectRatioMode");

}


//  Implementation of the enum wrapper class for Qt::Axis
namespace qt_gsi
{

static Qt_Axis_Enum *c_1_Qt_Axis_Enum () { return new Qt_Axis_Enum (Qt::XAxis); }
static Qt_Axis_Enum *c_2_Qt_Axis_Enum () { return new Qt_Axis_Enum (Qt::YAxis); }
static Qt_Axis_Enum *c_3_Qt_Axis_Enum () { return new Qt_Axis_Enum (Qt::ZAxis); }

static gsi::Methods mkdefs_Qt_Axis () {
  return
    gsi::constant ("XAxis", &qt_gsi::c_1_Qt_Axis_Enum, "@brief Enum constant Qt::XAxis") +
    gsi::constant ("YAxis", &qt_gsi::c_2_Qt_Axis_Enum, "@brief Enum constant Qt::YAxis") +
    gsi::constant ("ZAxis", &qt_gsi::c_3_Qt_Axis_Enum, "@brief Enum constant Qt::ZAxis");
}

static std::string to_s_Qt_Axis_Enum (const Qt_Axis_Enum *e)
{
  if (e->value () == Qt::XAxis) { return tl::sprintf ("XAxis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::YAxis) { return tl::sprintf ("YAxis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ZAxis) { return tl::sprintf ("ZAxis (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_Axis_Enum (const Qt_Axis_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_Axis_Enum *from_i_Qt_Axis_Enum (unsigned int i)
{
  return new Qt_Axis_Enum ((Qt::Axis) i);
}

static bool equalQt_Axis_Enum (const Qt_Axis_Enum *e, Qt_Axis_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_Axis_Enum (const Qt_Axis_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_Axis_Enums oropQt_Axis_Enums (const Qt_Axis_Enums *e, const Qt_Axis_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_Axis_Enums andopQt_Axis_Enums (const Qt_Axis_Enums *e, const Qt_Axis_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_Axis_Enums xoropQt_Axis_Enums (const Qt_Axis_Enums *e, const Qt_Axis_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_Axis_Enums (const Qt_Axis_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::XAxis)) { if (!l.empty ()) l += "|"; l += "XAxis"; }
  if (e->testFlag (Qt::YAxis)) { if (!l.empty ()) l += "|"; l += "YAxis"; }
  if (e->testFlag (Qt::ZAxis)) { if (!l.empty ()) l += "|"; l += "ZAxis"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_Axis_Enums (const Qt_Axis_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_Axis_Enums (const Qt_Axis_Enums *e, const Qt_Axis_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_Axis_Enums> decl_Qt_Axis_Enums ("Qt_QFlags_Axis",
  gsi::method_ext ("|", &qt_gsi::oropQt_Axis_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_Axis_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_Axis_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Axis_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Axis_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_Axis_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::Axis> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_Axis_Enum> decl_Qt_Axis_Enum (decl_Qt_Axis_Enums, "Qt_Axis",
  qt_gsi::mkdefs_Qt_Axis () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Axis_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Axis_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_Axis_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_Axis_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_Axis_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::Axis enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_Axis_Enum_in_parent (qt_gsi::mkdefs_Qt_Axis ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_Axis_Enum_as_child (decl_Qt_Axis_Enum, "Axis");

}


//  Implementation of the enum wrapper class for Qt::BGMode
namespace qt_gsi
{

static Qt_BGMode_Enum *c_1_Qt_BGMode_Enum () { return new Qt_BGMode_Enum (Qt::TransparentMode); }
static Qt_BGMode_Enum *c_2_Qt_BGMode_Enum () { return new Qt_BGMode_Enum (Qt::OpaqueMode); }

static gsi::Methods mkdefs_Qt_BGMode () {
  return
    gsi::constant ("TransparentMode", &qt_gsi::c_1_Qt_BGMode_Enum, "@brief Enum constant Qt::TransparentMode") +
    gsi::constant ("OpaqueMode", &qt_gsi::c_2_Qt_BGMode_Enum, "@brief Enum constant Qt::OpaqueMode");
}

static std::string to_s_Qt_BGMode_Enum (const Qt_BGMode_Enum *e)
{
  if (e->value () == Qt::TransparentMode) { return tl::sprintf ("TransparentMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::OpaqueMode) { return tl::sprintf ("OpaqueMode (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_BGMode_Enum (const Qt_BGMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_BGMode_Enum *from_i_Qt_BGMode_Enum (unsigned int i)
{
  return new Qt_BGMode_Enum ((Qt::BGMode) i);
}

static bool equalQt_BGMode_Enum (const Qt_BGMode_Enum *e, Qt_BGMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_BGMode_Enum (const Qt_BGMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_BGMode_Enums oropQt_BGMode_Enums (const Qt_BGMode_Enums *e, const Qt_BGMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_BGMode_Enums andopQt_BGMode_Enums (const Qt_BGMode_Enums *e, const Qt_BGMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_BGMode_Enums xoropQt_BGMode_Enums (const Qt_BGMode_Enums *e, const Qt_BGMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_BGMode_Enums (const Qt_BGMode_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::TransparentMode)) { if (!l.empty ()) l += "|"; l += "TransparentMode"; }
  if (e->testFlag (Qt::OpaqueMode)) { if (!l.empty ()) l += "|"; l += "OpaqueMode"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_BGMode_Enums (const Qt_BGMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_BGMode_Enums (const Qt_BGMode_Enums *e, const Qt_BGMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_BGMode_Enums> decl_Qt_BGMode_Enums ("Qt_QFlags_BGMode",
  gsi::method_ext ("|", &qt_gsi::oropQt_BGMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_BGMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_BGMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_BGMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_BGMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_BGMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::BGMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_BGMode_Enum> decl_Qt_BGMode_Enum (decl_Qt_BGMode_Enums, "Qt_BGMode",
  qt_gsi::mkdefs_Qt_BGMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_BGMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_BGMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_BGMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_BGMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_BGMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::BGMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_BGMode_Enum_in_parent (qt_gsi::mkdefs_Qt_BGMode ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_BGMode_Enum_as_child (decl_Qt_BGMode_Enum, "BGMode");

}


//  Implementation of the enum wrapper class for Qt::BrushStyle
namespace qt_gsi
{

static Qt_BrushStyle_Enum *c_1_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::NoBrush); }
static Qt_BrushStyle_Enum *c_2_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::SolidPattern); }
static Qt_BrushStyle_Enum *c_3_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::Dense1Pattern); }
static Qt_BrushStyle_Enum *c_4_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::Dense2Pattern); }
static Qt_BrushStyle_Enum *c_5_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::Dense3Pattern); }
static Qt_BrushStyle_Enum *c_6_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::Dense4Pattern); }
static Qt_BrushStyle_Enum *c_7_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::Dense5Pattern); }
static Qt_BrushStyle_Enum *c_8_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::Dense6Pattern); }
static Qt_BrushStyle_Enum *c_9_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::Dense7Pattern); }
static Qt_BrushStyle_Enum *c_10_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::HorPattern); }
static Qt_BrushStyle_Enum *c_11_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::VerPattern); }
static Qt_BrushStyle_Enum *c_12_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::CrossPattern); }
static Qt_BrushStyle_Enum *c_13_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::BDiagPattern); }
static Qt_BrushStyle_Enum *c_14_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::FDiagPattern); }
static Qt_BrushStyle_Enum *c_15_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::DiagCrossPattern); }
static Qt_BrushStyle_Enum *c_16_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::LinearGradientPattern); }
static Qt_BrushStyle_Enum *c_17_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::RadialGradientPattern); }
static Qt_BrushStyle_Enum *c_18_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::ConicalGradientPattern); }
static Qt_BrushStyle_Enum *c_19_Qt_BrushStyle_Enum () { return new Qt_BrushStyle_Enum (Qt::TexturePattern); }

static gsi::Methods mkdefs_Qt_BrushStyle () {
  return
    gsi::constant ("NoBrush", &qt_gsi::c_1_Qt_BrushStyle_Enum, "@brief Enum constant Qt::NoBrush") +
    gsi::constant ("SolidPattern", &qt_gsi::c_2_Qt_BrushStyle_Enum, "@brief Enum constant Qt::SolidPattern") +
    gsi::constant ("Dense1Pattern", &qt_gsi::c_3_Qt_BrushStyle_Enum, "@brief Enum constant Qt::Dense1Pattern") +
    gsi::constant ("Dense2Pattern", &qt_gsi::c_4_Qt_BrushStyle_Enum, "@brief Enum constant Qt::Dense2Pattern") +
    gsi::constant ("Dense3Pattern", &qt_gsi::c_5_Qt_BrushStyle_Enum, "@brief Enum constant Qt::Dense3Pattern") +
    gsi::constant ("Dense4Pattern", &qt_gsi::c_6_Qt_BrushStyle_Enum, "@brief Enum constant Qt::Dense4Pattern") +
    gsi::constant ("Dense5Pattern", &qt_gsi::c_7_Qt_BrushStyle_Enum, "@brief Enum constant Qt::Dense5Pattern") +
    gsi::constant ("Dense6Pattern", &qt_gsi::c_8_Qt_BrushStyle_Enum, "@brief Enum constant Qt::Dense6Pattern") +
    gsi::constant ("Dense7Pattern", &qt_gsi::c_9_Qt_BrushStyle_Enum, "@brief Enum constant Qt::Dense7Pattern") +
    gsi::constant ("HorPattern", &qt_gsi::c_10_Qt_BrushStyle_Enum, "@brief Enum constant Qt::HorPattern") +
    gsi::constant ("VerPattern", &qt_gsi::c_11_Qt_BrushStyle_Enum, "@brief Enum constant Qt::VerPattern") +
    gsi::constant ("CrossPattern", &qt_gsi::c_12_Qt_BrushStyle_Enum, "@brief Enum constant Qt::CrossPattern") +
    gsi::constant ("BDiagPattern", &qt_gsi::c_13_Qt_BrushStyle_Enum, "@brief Enum constant Qt::BDiagPattern") +
    gsi::constant ("FDiagPattern", &qt_gsi::c_14_Qt_BrushStyle_Enum, "@brief Enum constant Qt::FDiagPattern") +
    gsi::constant ("DiagCrossPattern", &qt_gsi::c_15_Qt_BrushStyle_Enum, "@brief Enum constant Qt::DiagCrossPattern") +
    gsi::constant ("LinearGradientPattern", &qt_gsi::c_16_Qt_BrushStyle_Enum, "@brief Enum constant Qt::LinearGradientPattern") +
    gsi::constant ("RadialGradientPattern", &qt_gsi::c_17_Qt_BrushStyle_Enum, "@brief Enum constant Qt::RadialGradientPattern") +
    gsi::constant ("ConicalGradientPattern", &qt_gsi::c_18_Qt_BrushStyle_Enum, "@brief Enum constant Qt::ConicalGradientPattern") +
    gsi::constant ("TexturePattern", &qt_gsi::c_19_Qt_BrushStyle_Enum, "@brief Enum constant Qt::TexturePattern");
}

static std::string to_s_Qt_BrushStyle_Enum (const Qt_BrushStyle_Enum *e)
{
  if (e->value () == Qt::NoBrush) { return tl::sprintf ("NoBrush (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SolidPattern) { return tl::sprintf ("SolidPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Dense1Pattern) { return tl::sprintf ("Dense1Pattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Dense2Pattern) { return tl::sprintf ("Dense2Pattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Dense3Pattern) { return tl::sprintf ("Dense3Pattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Dense4Pattern) { return tl::sprintf ("Dense4Pattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Dense5Pattern) { return tl::sprintf ("Dense5Pattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Dense6Pattern) { return tl::sprintf ("Dense6Pattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Dense7Pattern) { return tl::sprintf ("Dense7Pattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::HorPattern) { return tl::sprintf ("HorPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::VerPattern) { return tl::sprintf ("VerPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CrossPattern) { return tl::sprintf ("CrossPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BDiagPattern) { return tl::sprintf ("BDiagPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::FDiagPattern) { return tl::sprintf ("FDiagPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DiagCrossPattern) { return tl::sprintf ("DiagCrossPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LinearGradientPattern) { return tl::sprintf ("LinearGradientPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RadialGradientPattern) { return tl::sprintf ("RadialGradientPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ConicalGradientPattern) { return tl::sprintf ("ConicalGradientPattern (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TexturePattern) { return tl::sprintf ("TexturePattern (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_BrushStyle_Enum (const Qt_BrushStyle_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_BrushStyle_Enum *from_i_Qt_BrushStyle_Enum (unsigned int i)
{
  return new Qt_BrushStyle_Enum ((Qt::BrushStyle) i);
}

static bool equalQt_BrushStyle_Enum (const Qt_BrushStyle_Enum *e, Qt_BrushStyle_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_BrushStyle_Enum (const Qt_BrushStyle_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_BrushStyle_Enums oropQt_BrushStyle_Enums (const Qt_BrushStyle_Enums *e, const Qt_BrushStyle_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_BrushStyle_Enums andopQt_BrushStyle_Enums (const Qt_BrushStyle_Enums *e, const Qt_BrushStyle_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_BrushStyle_Enums xoropQt_BrushStyle_Enums (const Qt_BrushStyle_Enums *e, const Qt_BrushStyle_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_BrushStyle_Enums (const Qt_BrushStyle_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoBrush)) { if (!l.empty ()) l += "|"; l += "NoBrush"; }
  if (e->testFlag (Qt::SolidPattern)) { if (!l.empty ()) l += "|"; l += "SolidPattern"; }
  if (e->testFlag (Qt::Dense1Pattern)) { if (!l.empty ()) l += "|"; l += "Dense1Pattern"; }
  if (e->testFlag (Qt::Dense2Pattern)) { if (!l.empty ()) l += "|"; l += "Dense2Pattern"; }
  if (e->testFlag (Qt::Dense3Pattern)) { if (!l.empty ()) l += "|"; l += "Dense3Pattern"; }
  if (e->testFlag (Qt::Dense4Pattern)) { if (!l.empty ()) l += "|"; l += "Dense4Pattern"; }
  if (e->testFlag (Qt::Dense5Pattern)) { if (!l.empty ()) l += "|"; l += "Dense5Pattern"; }
  if (e->testFlag (Qt::Dense6Pattern)) { if (!l.empty ()) l += "|"; l += "Dense6Pattern"; }
  if (e->testFlag (Qt::Dense7Pattern)) { if (!l.empty ()) l += "|"; l += "Dense7Pattern"; }
  if (e->testFlag (Qt::HorPattern)) { if (!l.empty ()) l += "|"; l += "HorPattern"; }
  if (e->testFlag (Qt::VerPattern)) { if (!l.empty ()) l += "|"; l += "VerPattern"; }
  if (e->testFlag (Qt::CrossPattern)) { if (!l.empty ()) l += "|"; l += "CrossPattern"; }
  if (e->testFlag (Qt::BDiagPattern)) { if (!l.empty ()) l += "|"; l += "BDiagPattern"; }
  if (e->testFlag (Qt::FDiagPattern)) { if (!l.empty ()) l += "|"; l += "FDiagPattern"; }
  if (e->testFlag (Qt::DiagCrossPattern)) { if (!l.empty ()) l += "|"; l += "DiagCrossPattern"; }
  if (e->testFlag (Qt::LinearGradientPattern)) { if (!l.empty ()) l += "|"; l += "LinearGradientPattern"; }
  if (e->testFlag (Qt::RadialGradientPattern)) { if (!l.empty ()) l += "|"; l += "RadialGradientPattern"; }
  if (e->testFlag (Qt::ConicalGradientPattern)) { if (!l.empty ()) l += "|"; l += "ConicalGradientPattern"; }
  if (e->testFlag (Qt::TexturePattern)) { if (!l.empty ()) l += "|"; l += "TexturePattern"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_BrushStyle_Enums (const Qt_BrushStyle_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_BrushStyle_Enums (const Qt_BrushStyle_Enums *e, const Qt_BrushStyle_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_BrushStyle_Enums> decl_Qt_BrushStyle_Enums ("Qt_QFlags_BrushStyle",
  gsi::method_ext ("|", &qt_gsi::oropQt_BrushStyle_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_BrushStyle_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_BrushStyle_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_BrushStyle_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_BrushStyle_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_BrushStyle_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::BrushStyle> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_BrushStyle_Enum> decl_Qt_BrushStyle_Enum (decl_Qt_BrushStyle_Enums, "Qt_BrushStyle",
  qt_gsi::mkdefs_Qt_BrushStyle () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_BrushStyle_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_BrushStyle_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_BrushStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_BrushStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_BrushStyle_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::BrushStyle enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_BrushStyle_Enum_in_parent (qt_gsi::mkdefs_Qt_BrushStyle ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_BrushStyle_Enum_as_child (decl_Qt_BrushStyle_Enum, "BrushStyle");

}


//  Implementation of the enum wrapper class for Qt::CaseSensitivity
namespace qt_gsi
{

static Qt_CaseSensitivity_Enum *c_1_Qt_CaseSensitivity_Enum () { return new Qt_CaseSensitivity_Enum (Qt::CaseInsensitive); }
static Qt_CaseSensitivity_Enum *c_2_Qt_CaseSensitivity_Enum () { return new Qt_CaseSensitivity_Enum (Qt::CaseSensitive); }

static gsi::Methods mkdefs_Qt_CaseSensitivity () {
  return
    gsi::constant ("CaseInsensitive", &qt_gsi::c_1_Qt_CaseSensitivity_Enum, "@brief Enum constant Qt::CaseInsensitive") +
    gsi::constant ("CaseSensitive", &qt_gsi::c_2_Qt_CaseSensitivity_Enum, "@brief Enum constant Qt::CaseSensitive");
}

static std::string to_s_Qt_CaseSensitivity_Enum (const Qt_CaseSensitivity_Enum *e)
{
  if (e->value () == Qt::CaseInsensitive) { return tl::sprintf ("CaseInsensitive (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CaseSensitive) { return tl::sprintf ("CaseSensitive (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_CaseSensitivity_Enum (const Qt_CaseSensitivity_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_CaseSensitivity_Enum *from_i_Qt_CaseSensitivity_Enum (unsigned int i)
{
  return new Qt_CaseSensitivity_Enum ((Qt::CaseSensitivity) i);
}

static bool equalQt_CaseSensitivity_Enum (const Qt_CaseSensitivity_Enum *e, Qt_CaseSensitivity_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_CaseSensitivity_Enum (const Qt_CaseSensitivity_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_CaseSensitivity_Enums oropQt_CaseSensitivity_Enums (const Qt_CaseSensitivity_Enums *e, const Qt_CaseSensitivity_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_CaseSensitivity_Enums andopQt_CaseSensitivity_Enums (const Qt_CaseSensitivity_Enums *e, const Qt_CaseSensitivity_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_CaseSensitivity_Enums xoropQt_CaseSensitivity_Enums (const Qt_CaseSensitivity_Enums *e, const Qt_CaseSensitivity_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_CaseSensitivity_Enums (const Qt_CaseSensitivity_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::CaseInsensitive)) { if (!l.empty ()) l += "|"; l += "CaseInsensitive"; }
  if (e->testFlag (Qt::CaseSensitive)) { if (!l.empty ()) l += "|"; l += "CaseSensitive"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_CaseSensitivity_Enums (const Qt_CaseSensitivity_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_CaseSensitivity_Enums (const Qt_CaseSensitivity_Enums *e, const Qt_CaseSensitivity_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_CaseSensitivity_Enums> decl_Qt_CaseSensitivity_Enums ("Qt_QFlags_CaseSensitivity",
  gsi::method_ext ("|", &qt_gsi::oropQt_CaseSensitivity_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_CaseSensitivity_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_CaseSensitivity_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_CaseSensitivity_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_CaseSensitivity_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_CaseSensitivity_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::CaseSensitivity> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_CaseSensitivity_Enum> decl_Qt_CaseSensitivity_Enum (decl_Qt_CaseSensitivity_Enums, "Qt_CaseSensitivity",
  qt_gsi::mkdefs_Qt_CaseSensitivity () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_CaseSensitivity_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_CaseSensitivity_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_CaseSensitivity_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_CaseSensitivity_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_CaseSensitivity_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::CaseSensitivity enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_CaseSensitivity_Enum_in_parent (qt_gsi::mkdefs_Qt_CaseSensitivity ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_CaseSensitivity_Enum_as_child (decl_Qt_CaseSensitivity_Enum, "CaseSensitivity");

}


//  Implementation of the enum wrapper class for Qt::CheckState
namespace qt_gsi
{

static Qt_CheckState_Enum *c_1_Qt_CheckState_Enum () { return new Qt_CheckState_Enum (Qt::Unchecked); }
static Qt_CheckState_Enum *c_2_Qt_CheckState_Enum () { return new Qt_CheckState_Enum (Qt::PartiallyChecked); }
static Qt_CheckState_Enum *c_3_Qt_CheckState_Enum () { return new Qt_CheckState_Enum (Qt::Checked); }

static gsi::Methods mkdefs_Qt_CheckState () {
  return
    gsi::constant ("Unchecked", &qt_gsi::c_1_Qt_CheckState_Enum, "@brief Enum constant Qt::Unchecked") +
    gsi::constant ("PartiallyChecked", &qt_gsi::c_2_Qt_CheckState_Enum, "@brief Enum constant Qt::PartiallyChecked") +
    gsi::constant ("Checked", &qt_gsi::c_3_Qt_CheckState_Enum, "@brief Enum constant Qt::Checked");
}

static std::string to_s_Qt_CheckState_Enum (const Qt_CheckState_Enum *e)
{
  if (e->value () == Qt::Unchecked) { return tl::sprintf ("Unchecked (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::PartiallyChecked) { return tl::sprintf ("PartiallyChecked (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Checked) { return tl::sprintf ("Checked (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_CheckState_Enum (const Qt_CheckState_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_CheckState_Enum *from_i_Qt_CheckState_Enum (unsigned int i)
{
  return new Qt_CheckState_Enum ((Qt::CheckState) i);
}

static bool equalQt_CheckState_Enum (const Qt_CheckState_Enum *e, Qt_CheckState_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_CheckState_Enum (const Qt_CheckState_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_CheckState_Enums oropQt_CheckState_Enums (const Qt_CheckState_Enums *e, const Qt_CheckState_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_CheckState_Enums andopQt_CheckState_Enums (const Qt_CheckState_Enums *e, const Qt_CheckState_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_CheckState_Enums xoropQt_CheckState_Enums (const Qt_CheckState_Enums *e, const Qt_CheckState_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_CheckState_Enums (const Qt_CheckState_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::Unchecked)) { if (!l.empty ()) l += "|"; l += "Unchecked"; }
  if (e->testFlag (Qt::PartiallyChecked)) { if (!l.empty ()) l += "|"; l += "PartiallyChecked"; }
  if (e->testFlag (Qt::Checked)) { if (!l.empty ()) l += "|"; l += "Checked"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_CheckState_Enums (const Qt_CheckState_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_CheckState_Enums (const Qt_CheckState_Enums *e, const Qt_CheckState_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_CheckState_Enums> decl_Qt_CheckState_Enums ("Qt_QFlags_CheckState",
  gsi::method_ext ("|", &qt_gsi::oropQt_CheckState_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_CheckState_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_CheckState_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_CheckState_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_CheckState_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_CheckState_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::CheckState> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_CheckState_Enum> decl_Qt_CheckState_Enum (decl_Qt_CheckState_Enums, "Qt_CheckState",
  qt_gsi::mkdefs_Qt_CheckState () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_CheckState_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_CheckState_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_CheckState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_CheckState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_CheckState_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::CheckState enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_CheckState_Enum_in_parent (qt_gsi::mkdefs_Qt_CheckState ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_CheckState_Enum_as_child (decl_Qt_CheckState_Enum, "CheckState");

}


//  Implementation of the enum wrapper class for Qt::ClipOperation
namespace qt_gsi
{

static Qt_ClipOperation_Enum *c_1_Qt_ClipOperation_Enum () { return new Qt_ClipOperation_Enum (Qt::NoClip); }
static Qt_ClipOperation_Enum *c_2_Qt_ClipOperation_Enum () { return new Qt_ClipOperation_Enum (Qt::ReplaceClip); }
static Qt_ClipOperation_Enum *c_3_Qt_ClipOperation_Enum () { return new Qt_ClipOperation_Enum (Qt::IntersectClip); }
static Qt_ClipOperation_Enum *c_4_Qt_ClipOperation_Enum () { return new Qt_ClipOperation_Enum (Qt::UniteClip); }

static gsi::Methods mkdefs_Qt_ClipOperation () {
  return
    gsi::constant ("NoClip", &qt_gsi::c_1_Qt_ClipOperation_Enum, "@brief Enum constant Qt::NoClip") +
    gsi::constant ("ReplaceClip", &qt_gsi::c_2_Qt_ClipOperation_Enum, "@brief Enum constant Qt::ReplaceClip") +
    gsi::constant ("IntersectClip", &qt_gsi::c_3_Qt_ClipOperation_Enum, "@brief Enum constant Qt::IntersectClip") +
    gsi::constant ("UniteClip", &qt_gsi::c_4_Qt_ClipOperation_Enum, "@brief Enum constant Qt::UniteClip");
}

static std::string to_s_Qt_ClipOperation_Enum (const Qt_ClipOperation_Enum *e)
{
  if (e->value () == Qt::NoClip) { return tl::sprintf ("NoClip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ReplaceClip) { return tl::sprintf ("ReplaceClip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::IntersectClip) { return tl::sprintf ("IntersectClip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UniteClip) { return tl::sprintf ("UniteClip (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ClipOperation_Enum (const Qt_ClipOperation_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ClipOperation_Enum *from_i_Qt_ClipOperation_Enum (unsigned int i)
{
  return new Qt_ClipOperation_Enum ((Qt::ClipOperation) i);
}

static bool equalQt_ClipOperation_Enum (const Qt_ClipOperation_Enum *e, Qt_ClipOperation_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ClipOperation_Enum (const Qt_ClipOperation_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ClipOperation_Enums oropQt_ClipOperation_Enums (const Qt_ClipOperation_Enums *e, const Qt_ClipOperation_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ClipOperation_Enums andopQt_ClipOperation_Enums (const Qt_ClipOperation_Enums *e, const Qt_ClipOperation_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ClipOperation_Enums xoropQt_ClipOperation_Enums (const Qt_ClipOperation_Enums *e, const Qt_ClipOperation_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ClipOperation_Enums (const Qt_ClipOperation_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoClip)) { if (!l.empty ()) l += "|"; l += "NoClip"; }
  if (e->testFlag (Qt::ReplaceClip)) { if (!l.empty ()) l += "|"; l += "ReplaceClip"; }
  if (e->testFlag (Qt::IntersectClip)) { if (!l.empty ()) l += "|"; l += "IntersectClip"; }
  if (e->testFlag (Qt::UniteClip)) { if (!l.empty ()) l += "|"; l += "UniteClip"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ClipOperation_Enums (const Qt_ClipOperation_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ClipOperation_Enums (const Qt_ClipOperation_Enums *e, const Qt_ClipOperation_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ClipOperation_Enums> decl_Qt_ClipOperation_Enums ("Qt_QFlags_ClipOperation",
  gsi::method_ext ("|", &qt_gsi::oropQt_ClipOperation_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ClipOperation_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ClipOperation_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ClipOperation_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ClipOperation_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ClipOperation_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ClipOperation> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ClipOperation_Enum> decl_Qt_ClipOperation_Enum (decl_Qt_ClipOperation_Enums, "Qt_ClipOperation",
  qt_gsi::mkdefs_Qt_ClipOperation () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ClipOperation_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ClipOperation_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ClipOperation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ClipOperation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ClipOperation_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ClipOperation enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ClipOperation_Enum_in_parent (qt_gsi::mkdefs_Qt_ClipOperation ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ClipOperation_Enum_as_child (decl_Qt_ClipOperation_Enum, "ClipOperation");

}


//  Implementation of the enum wrapper class for Qt::ConnectionType
namespace qt_gsi
{

static Qt_ConnectionType_Enum *c_1_Qt_ConnectionType_Enum () { return new Qt_ConnectionType_Enum (Qt::AutoConnection); }
static Qt_ConnectionType_Enum *c_2_Qt_ConnectionType_Enum () { return new Qt_ConnectionType_Enum (Qt::DirectConnection); }
static Qt_ConnectionType_Enum *c_3_Qt_ConnectionType_Enum () { return new Qt_ConnectionType_Enum (Qt::QueuedConnection); }
static Qt_ConnectionType_Enum *c_4_Qt_ConnectionType_Enum () { return new Qt_ConnectionType_Enum (Qt::AutoCompatConnection); }
static Qt_ConnectionType_Enum *c_5_Qt_ConnectionType_Enum () { return new Qt_ConnectionType_Enum (Qt::BlockingQueuedConnection); }
static Qt_ConnectionType_Enum *c_6_Qt_ConnectionType_Enum () { return new Qt_ConnectionType_Enum (Qt::UniqueConnection); }

static gsi::Methods mkdefs_Qt_ConnectionType () {
  return
    gsi::constant ("AutoConnection", &qt_gsi::c_1_Qt_ConnectionType_Enum, "@brief Enum constant Qt::AutoConnection") +
    gsi::constant ("DirectConnection", &qt_gsi::c_2_Qt_ConnectionType_Enum, "@brief Enum constant Qt::DirectConnection") +
    gsi::constant ("QueuedConnection", &qt_gsi::c_3_Qt_ConnectionType_Enum, "@brief Enum constant Qt::QueuedConnection") +
    gsi::constant ("AutoCompatConnection", &qt_gsi::c_4_Qt_ConnectionType_Enum, "@brief Enum constant Qt::AutoCompatConnection") +
    gsi::constant ("BlockingQueuedConnection", &qt_gsi::c_5_Qt_ConnectionType_Enum, "@brief Enum constant Qt::BlockingQueuedConnection") +
    gsi::constant ("UniqueConnection", &qt_gsi::c_6_Qt_ConnectionType_Enum, "@brief Enum constant Qt::UniqueConnection");
}

static std::string to_s_Qt_ConnectionType_Enum (const Qt_ConnectionType_Enum *e)
{
  if (e->value () == Qt::AutoConnection) { return tl::sprintf ("AutoConnection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DirectConnection) { return tl::sprintf ("DirectConnection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::QueuedConnection) { return tl::sprintf ("QueuedConnection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AutoCompatConnection) { return tl::sprintf ("AutoCompatConnection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BlockingQueuedConnection) { return tl::sprintf ("BlockingQueuedConnection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UniqueConnection) { return tl::sprintf ("UniqueConnection (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ConnectionType_Enum (const Qt_ConnectionType_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ConnectionType_Enum *from_i_Qt_ConnectionType_Enum (unsigned int i)
{
  return new Qt_ConnectionType_Enum ((Qt::ConnectionType) i);
}

static bool equalQt_ConnectionType_Enum (const Qt_ConnectionType_Enum *e, Qt_ConnectionType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ConnectionType_Enum (const Qt_ConnectionType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ConnectionType_Enums oropQt_ConnectionType_Enums (const Qt_ConnectionType_Enums *e, const Qt_ConnectionType_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ConnectionType_Enums andopQt_ConnectionType_Enums (const Qt_ConnectionType_Enums *e, const Qt_ConnectionType_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ConnectionType_Enums xoropQt_ConnectionType_Enums (const Qt_ConnectionType_Enums *e, const Qt_ConnectionType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ConnectionType_Enums (const Qt_ConnectionType_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::AutoConnection)) { if (!l.empty ()) l += "|"; l += "AutoConnection"; }
  if (e->testFlag (Qt::DirectConnection)) { if (!l.empty ()) l += "|"; l += "DirectConnection"; }
  if (e->testFlag (Qt::QueuedConnection)) { if (!l.empty ()) l += "|"; l += "QueuedConnection"; }
  if (e->testFlag (Qt::AutoCompatConnection)) { if (!l.empty ()) l += "|"; l += "AutoCompatConnection"; }
  if (e->testFlag (Qt::BlockingQueuedConnection)) { if (!l.empty ()) l += "|"; l += "BlockingQueuedConnection"; }
  if (e->testFlag (Qt::UniqueConnection)) { if (!l.empty ()) l += "|"; l += "UniqueConnection"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ConnectionType_Enums (const Qt_ConnectionType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ConnectionType_Enums (const Qt_ConnectionType_Enums *e, const Qt_ConnectionType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ConnectionType_Enums> decl_Qt_ConnectionType_Enums ("Qt_QFlags_ConnectionType",
  gsi::method_ext ("|", &qt_gsi::oropQt_ConnectionType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ConnectionType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ConnectionType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ConnectionType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ConnectionType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ConnectionType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ConnectionType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ConnectionType_Enum> decl_Qt_ConnectionType_Enum (decl_Qt_ConnectionType_Enums, "Qt_ConnectionType",
  qt_gsi::mkdefs_Qt_ConnectionType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ConnectionType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ConnectionType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ConnectionType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ConnectionType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ConnectionType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ConnectionType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ConnectionType_Enum_in_parent (qt_gsi::mkdefs_Qt_ConnectionType ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ConnectionType_Enum_as_child (decl_Qt_ConnectionType_Enum, "ConnectionType");

}


//  Implementation of the enum wrapper class for Qt::ContextMenuPolicy
namespace qt_gsi
{

static Qt_ContextMenuPolicy_Enum *c_1_Qt_ContextMenuPolicy_Enum () { return new Qt_ContextMenuPolicy_Enum (Qt::NoContextMenu); }
static Qt_ContextMenuPolicy_Enum *c_2_Qt_ContextMenuPolicy_Enum () { return new Qt_ContextMenuPolicy_Enum (Qt::DefaultContextMenu); }
static Qt_ContextMenuPolicy_Enum *c_3_Qt_ContextMenuPolicy_Enum () { return new Qt_ContextMenuPolicy_Enum (Qt::ActionsContextMenu); }
static Qt_ContextMenuPolicy_Enum *c_4_Qt_ContextMenuPolicy_Enum () { return new Qt_ContextMenuPolicy_Enum (Qt::CustomContextMenu); }
static Qt_ContextMenuPolicy_Enum *c_5_Qt_ContextMenuPolicy_Enum () { return new Qt_ContextMenuPolicy_Enum (Qt::PreventContextMenu); }

static gsi::Methods mkdefs_Qt_ContextMenuPolicy () {
  return
    gsi::constant ("NoContextMenu", &qt_gsi::c_1_Qt_ContextMenuPolicy_Enum, "@brief Enum constant Qt::NoContextMenu") +
    gsi::constant ("DefaultContextMenu", &qt_gsi::c_2_Qt_ContextMenuPolicy_Enum, "@brief Enum constant Qt::DefaultContextMenu") +
    gsi::constant ("ActionsContextMenu", &qt_gsi::c_3_Qt_ContextMenuPolicy_Enum, "@brief Enum constant Qt::ActionsContextMenu") +
    gsi::constant ("CustomContextMenu", &qt_gsi::c_4_Qt_ContextMenuPolicy_Enum, "@brief Enum constant Qt::CustomContextMenu") +
    gsi::constant ("PreventContextMenu", &qt_gsi::c_5_Qt_ContextMenuPolicy_Enum, "@brief Enum constant Qt::PreventContextMenu");
}

static std::string to_s_Qt_ContextMenuPolicy_Enum (const Qt_ContextMenuPolicy_Enum *e)
{
  if (e->value () == Qt::NoContextMenu) { return tl::sprintf ("NoContextMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DefaultContextMenu) { return tl::sprintf ("DefaultContextMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ActionsContextMenu) { return tl::sprintf ("ActionsContextMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CustomContextMenu) { return tl::sprintf ("CustomContextMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::PreventContextMenu) { return tl::sprintf ("PreventContextMenu (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ContextMenuPolicy_Enum (const Qt_ContextMenuPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ContextMenuPolicy_Enum *from_i_Qt_ContextMenuPolicy_Enum (unsigned int i)
{
  return new Qt_ContextMenuPolicy_Enum ((Qt::ContextMenuPolicy) i);
}

static bool equalQt_ContextMenuPolicy_Enum (const Qt_ContextMenuPolicy_Enum *e, Qt_ContextMenuPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ContextMenuPolicy_Enum (const Qt_ContextMenuPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ContextMenuPolicy_Enums oropQt_ContextMenuPolicy_Enums (const Qt_ContextMenuPolicy_Enums *e, const Qt_ContextMenuPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ContextMenuPolicy_Enums andopQt_ContextMenuPolicy_Enums (const Qt_ContextMenuPolicy_Enums *e, const Qt_ContextMenuPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ContextMenuPolicy_Enums xoropQt_ContextMenuPolicy_Enums (const Qt_ContextMenuPolicy_Enums *e, const Qt_ContextMenuPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ContextMenuPolicy_Enums (const Qt_ContextMenuPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoContextMenu)) { if (!l.empty ()) l += "|"; l += "NoContextMenu"; }
  if (e->testFlag (Qt::DefaultContextMenu)) { if (!l.empty ()) l += "|"; l += "DefaultContextMenu"; }
  if (e->testFlag (Qt::ActionsContextMenu)) { if (!l.empty ()) l += "|"; l += "ActionsContextMenu"; }
  if (e->testFlag (Qt::CustomContextMenu)) { if (!l.empty ()) l += "|"; l += "CustomContextMenu"; }
  if (e->testFlag (Qt::PreventContextMenu)) { if (!l.empty ()) l += "|"; l += "PreventContextMenu"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ContextMenuPolicy_Enums (const Qt_ContextMenuPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ContextMenuPolicy_Enums (const Qt_ContextMenuPolicy_Enums *e, const Qt_ContextMenuPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ContextMenuPolicy_Enums> decl_Qt_ContextMenuPolicy_Enums ("Qt_QFlags_ContextMenuPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQt_ContextMenuPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ContextMenuPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ContextMenuPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ContextMenuPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ContextMenuPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ContextMenuPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ContextMenuPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ContextMenuPolicy_Enum> decl_Qt_ContextMenuPolicy_Enum (decl_Qt_ContextMenuPolicy_Enums, "Qt_ContextMenuPolicy",
  qt_gsi::mkdefs_Qt_ContextMenuPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ContextMenuPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ContextMenuPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ContextMenuPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ContextMenuPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ContextMenuPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ContextMenuPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ContextMenuPolicy_Enum_in_parent (qt_gsi::mkdefs_Qt_ContextMenuPolicy ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ContextMenuPolicy_Enum_as_child (decl_Qt_ContextMenuPolicy_Enum, "ContextMenuPolicy");

}


//  Implementation of the enum wrapper class for Qt::CoordinateSystem
namespace qt_gsi
{

static Qt_CoordinateSystem_Enum *c_1_Qt_CoordinateSystem_Enum () { return new Qt_CoordinateSystem_Enum (Qt::DeviceCoordinates); }
static Qt_CoordinateSystem_Enum *c_2_Qt_CoordinateSystem_Enum () { return new Qt_CoordinateSystem_Enum (Qt::LogicalCoordinates); }

static gsi::Methods mkdefs_Qt_CoordinateSystem () {
  return
    gsi::constant ("DeviceCoordinates", &qt_gsi::c_1_Qt_CoordinateSystem_Enum, "@brief Enum constant Qt::DeviceCoordinates") +
    gsi::constant ("LogicalCoordinates", &qt_gsi::c_2_Qt_CoordinateSystem_Enum, "@brief Enum constant Qt::LogicalCoordinates");
}

static std::string to_s_Qt_CoordinateSystem_Enum (const Qt_CoordinateSystem_Enum *e)
{
  if (e->value () == Qt::DeviceCoordinates) { return tl::sprintf ("DeviceCoordinates (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LogicalCoordinates) { return tl::sprintf ("LogicalCoordinates (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_CoordinateSystem_Enum (const Qt_CoordinateSystem_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_CoordinateSystem_Enum *from_i_Qt_CoordinateSystem_Enum (unsigned int i)
{
  return new Qt_CoordinateSystem_Enum ((Qt::CoordinateSystem) i);
}

static bool equalQt_CoordinateSystem_Enum (const Qt_CoordinateSystem_Enum *e, Qt_CoordinateSystem_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_CoordinateSystem_Enum (const Qt_CoordinateSystem_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_CoordinateSystem_Enums oropQt_CoordinateSystem_Enums (const Qt_CoordinateSystem_Enums *e, const Qt_CoordinateSystem_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_CoordinateSystem_Enums andopQt_CoordinateSystem_Enums (const Qt_CoordinateSystem_Enums *e, const Qt_CoordinateSystem_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_CoordinateSystem_Enums xoropQt_CoordinateSystem_Enums (const Qt_CoordinateSystem_Enums *e, const Qt_CoordinateSystem_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_CoordinateSystem_Enums (const Qt_CoordinateSystem_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::DeviceCoordinates)) { if (!l.empty ()) l += "|"; l += "DeviceCoordinates"; }
  if (e->testFlag (Qt::LogicalCoordinates)) { if (!l.empty ()) l += "|"; l += "LogicalCoordinates"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_CoordinateSystem_Enums (const Qt_CoordinateSystem_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_CoordinateSystem_Enums (const Qt_CoordinateSystem_Enums *e, const Qt_CoordinateSystem_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_CoordinateSystem_Enums> decl_Qt_CoordinateSystem_Enums ("Qt_QFlags_CoordinateSystem",
  gsi::method_ext ("|", &qt_gsi::oropQt_CoordinateSystem_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_CoordinateSystem_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_CoordinateSystem_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_CoordinateSystem_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_CoordinateSystem_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_CoordinateSystem_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::CoordinateSystem> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_CoordinateSystem_Enum> decl_Qt_CoordinateSystem_Enum (decl_Qt_CoordinateSystem_Enums, "Qt_CoordinateSystem",
  qt_gsi::mkdefs_Qt_CoordinateSystem () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_CoordinateSystem_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_CoordinateSystem_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_CoordinateSystem_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_CoordinateSystem_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_CoordinateSystem_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::CoordinateSystem enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_CoordinateSystem_Enum_in_parent (qt_gsi::mkdefs_Qt_CoordinateSystem ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_CoordinateSystem_Enum_as_child (decl_Qt_CoordinateSystem_Enum, "CoordinateSystem");

}


//  Implementation of the enum wrapper class for Qt::Corner
namespace qt_gsi
{

static Qt_Corner_Enum *c_1_Qt_Corner_Enum () { return new Qt_Corner_Enum (Qt::TopLeftCorner); }
static Qt_Corner_Enum *c_2_Qt_Corner_Enum () { return new Qt_Corner_Enum (Qt::TopRightCorner); }
static Qt_Corner_Enum *c_3_Qt_Corner_Enum () { return new Qt_Corner_Enum (Qt::BottomLeftCorner); }
static Qt_Corner_Enum *c_4_Qt_Corner_Enum () { return new Qt_Corner_Enum (Qt::BottomRightCorner); }

static gsi::Methods mkdefs_Qt_Corner () {
  return
    gsi::constant ("TopLeftCorner", &qt_gsi::c_1_Qt_Corner_Enum, "@brief Enum constant Qt::TopLeftCorner") +
    gsi::constant ("TopRightCorner", &qt_gsi::c_2_Qt_Corner_Enum, "@brief Enum constant Qt::TopRightCorner") +
    gsi::constant ("BottomLeftCorner", &qt_gsi::c_3_Qt_Corner_Enum, "@brief Enum constant Qt::BottomLeftCorner") +
    gsi::constant ("BottomRightCorner", &qt_gsi::c_4_Qt_Corner_Enum, "@brief Enum constant Qt::BottomRightCorner");
}

static std::string to_s_Qt_Corner_Enum (const Qt_Corner_Enum *e)
{
  if (e->value () == Qt::TopLeftCorner) { return tl::sprintf ("TopLeftCorner (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TopRightCorner) { return tl::sprintf ("TopRightCorner (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BottomLeftCorner) { return tl::sprintf ("BottomLeftCorner (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BottomRightCorner) { return tl::sprintf ("BottomRightCorner (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_Corner_Enum (const Qt_Corner_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_Corner_Enum *from_i_Qt_Corner_Enum (unsigned int i)
{
  return new Qt_Corner_Enum ((Qt::Corner) i);
}

static bool equalQt_Corner_Enum (const Qt_Corner_Enum *e, Qt_Corner_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_Corner_Enum (const Qt_Corner_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_Corner_Enums oropQt_Corner_Enums (const Qt_Corner_Enums *e, const Qt_Corner_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_Corner_Enums andopQt_Corner_Enums (const Qt_Corner_Enums *e, const Qt_Corner_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_Corner_Enums xoropQt_Corner_Enums (const Qt_Corner_Enums *e, const Qt_Corner_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_Corner_Enums (const Qt_Corner_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::TopLeftCorner)) { if (!l.empty ()) l += "|"; l += "TopLeftCorner"; }
  if (e->testFlag (Qt::TopRightCorner)) { if (!l.empty ()) l += "|"; l += "TopRightCorner"; }
  if (e->testFlag (Qt::BottomLeftCorner)) { if (!l.empty ()) l += "|"; l += "BottomLeftCorner"; }
  if (e->testFlag (Qt::BottomRightCorner)) { if (!l.empty ()) l += "|"; l += "BottomRightCorner"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_Corner_Enums (const Qt_Corner_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_Corner_Enums (const Qt_Corner_Enums *e, const Qt_Corner_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_Corner_Enums> decl_Qt_Corner_Enums ("Qt_QFlags_Corner",
  gsi::method_ext ("|", &qt_gsi::oropQt_Corner_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_Corner_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_Corner_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Corner_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Corner_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_Corner_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::Corner> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_Corner_Enum> decl_Qt_Corner_Enum (decl_Qt_Corner_Enums, "Qt_Corner",
  qt_gsi::mkdefs_Qt_Corner () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Corner_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Corner_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_Corner_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_Corner_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_Corner_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::Corner enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_Corner_Enum_in_parent (qt_gsi::mkdefs_Qt_Corner ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_Corner_Enum_as_child (decl_Qt_Corner_Enum, "Corner");

}


//  Implementation of the enum wrapper class for Qt::CursorShape
namespace qt_gsi
{

static Qt_CursorShape_Enum *c_1_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::ArrowCursor); }
static Qt_CursorShape_Enum *c_2_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::UpArrowCursor); }
static Qt_CursorShape_Enum *c_3_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::CrossCursor); }
static Qt_CursorShape_Enum *c_4_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::WaitCursor); }
static Qt_CursorShape_Enum *c_5_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::IBeamCursor); }
static Qt_CursorShape_Enum *c_6_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::SizeVerCursor); }
static Qt_CursorShape_Enum *c_7_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::SizeHorCursor); }
static Qt_CursorShape_Enum *c_8_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::SizeBDiagCursor); }
static Qt_CursorShape_Enum *c_9_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::SizeFDiagCursor); }
static Qt_CursorShape_Enum *c_10_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::SizeAllCursor); }
static Qt_CursorShape_Enum *c_11_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::BlankCursor); }
static Qt_CursorShape_Enum *c_12_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::SplitVCursor); }
static Qt_CursorShape_Enum *c_13_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::SplitHCursor); }
static Qt_CursorShape_Enum *c_14_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::PointingHandCursor); }
static Qt_CursorShape_Enum *c_15_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::ForbiddenCursor); }
static Qt_CursorShape_Enum *c_16_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::WhatsThisCursor); }
static Qt_CursorShape_Enum *c_17_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::BusyCursor); }
static Qt_CursorShape_Enum *c_18_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::OpenHandCursor); }
static Qt_CursorShape_Enum *c_19_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::ClosedHandCursor); }
static Qt_CursorShape_Enum *c_20_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::LastCursor); }
static Qt_CursorShape_Enum *c_21_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::BitmapCursor); }
static Qt_CursorShape_Enum *c_22_Qt_CursorShape_Enum () { return new Qt_CursorShape_Enum (Qt::CustomCursor); }

static gsi::Methods mkdefs_Qt_CursorShape () {
  return
    gsi::constant ("ArrowCursor", &qt_gsi::c_1_Qt_CursorShape_Enum, "@brief Enum constant Qt::ArrowCursor") +
    gsi::constant ("UpArrowCursor", &qt_gsi::c_2_Qt_CursorShape_Enum, "@brief Enum constant Qt::UpArrowCursor") +
    gsi::constant ("CrossCursor", &qt_gsi::c_3_Qt_CursorShape_Enum, "@brief Enum constant Qt::CrossCursor") +
    gsi::constant ("WaitCursor", &qt_gsi::c_4_Qt_CursorShape_Enum, "@brief Enum constant Qt::WaitCursor") +
    gsi::constant ("IBeamCursor", &qt_gsi::c_5_Qt_CursorShape_Enum, "@brief Enum constant Qt::IBeamCursor") +
    gsi::constant ("SizeVerCursor", &qt_gsi::c_6_Qt_CursorShape_Enum, "@brief Enum constant Qt::SizeVerCursor") +
    gsi::constant ("SizeHorCursor", &qt_gsi::c_7_Qt_CursorShape_Enum, "@brief Enum constant Qt::SizeHorCursor") +
    gsi::constant ("SizeBDiagCursor", &qt_gsi::c_8_Qt_CursorShape_Enum, "@brief Enum constant Qt::SizeBDiagCursor") +
    gsi::constant ("SizeFDiagCursor", &qt_gsi::c_9_Qt_CursorShape_Enum, "@brief Enum constant Qt::SizeFDiagCursor") +
    gsi::constant ("SizeAllCursor", &qt_gsi::c_10_Qt_CursorShape_Enum, "@brief Enum constant Qt::SizeAllCursor") +
    gsi::constant ("BlankCursor", &qt_gsi::c_11_Qt_CursorShape_Enum, "@brief Enum constant Qt::BlankCursor") +
    gsi::constant ("SplitVCursor", &qt_gsi::c_12_Qt_CursorShape_Enum, "@brief Enum constant Qt::SplitVCursor") +
    gsi::constant ("SplitHCursor", &qt_gsi::c_13_Qt_CursorShape_Enum, "@brief Enum constant Qt::SplitHCursor") +
    gsi::constant ("PointingHandCursor", &qt_gsi::c_14_Qt_CursorShape_Enum, "@brief Enum constant Qt::PointingHandCursor") +
    gsi::constant ("ForbiddenCursor", &qt_gsi::c_15_Qt_CursorShape_Enum, "@brief Enum constant Qt::ForbiddenCursor") +
    gsi::constant ("WhatsThisCursor", &qt_gsi::c_16_Qt_CursorShape_Enum, "@brief Enum constant Qt::WhatsThisCursor") +
    gsi::constant ("BusyCursor", &qt_gsi::c_17_Qt_CursorShape_Enum, "@brief Enum constant Qt::BusyCursor") +
    gsi::constant ("OpenHandCursor", &qt_gsi::c_18_Qt_CursorShape_Enum, "@brief Enum constant Qt::OpenHandCursor") +
    gsi::constant ("ClosedHandCursor", &qt_gsi::c_19_Qt_CursorShape_Enum, "@brief Enum constant Qt::ClosedHandCursor") +
    gsi::constant ("LastCursor", &qt_gsi::c_20_Qt_CursorShape_Enum, "@brief Enum constant Qt::LastCursor") +
    gsi::constant ("BitmapCursor", &qt_gsi::c_21_Qt_CursorShape_Enum, "@brief Enum constant Qt::BitmapCursor") +
    gsi::constant ("CustomCursor", &qt_gsi::c_22_Qt_CursorShape_Enum, "@brief Enum constant Qt::CustomCursor");
}

static std::string to_s_Qt_CursorShape_Enum (const Qt_CursorShape_Enum *e)
{
  if (e->value () == Qt::ArrowCursor) { return tl::sprintf ("ArrowCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UpArrowCursor) { return tl::sprintf ("UpArrowCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CrossCursor) { return tl::sprintf ("CrossCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WaitCursor) { return tl::sprintf ("WaitCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::IBeamCursor) { return tl::sprintf ("IBeamCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SizeVerCursor) { return tl::sprintf ("SizeVerCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SizeHorCursor) { return tl::sprintf ("SizeHorCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SizeBDiagCursor) { return tl::sprintf ("SizeBDiagCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SizeFDiagCursor) { return tl::sprintf ("SizeFDiagCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SizeAllCursor) { return tl::sprintf ("SizeAllCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BlankCursor) { return tl::sprintf ("BlankCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SplitVCursor) { return tl::sprintf ("SplitVCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SplitHCursor) { return tl::sprintf ("SplitHCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::PointingHandCursor) { return tl::sprintf ("PointingHandCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ForbiddenCursor) { return tl::sprintf ("ForbiddenCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WhatsThisCursor) { return tl::sprintf ("WhatsThisCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BusyCursor) { return tl::sprintf ("BusyCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::OpenHandCursor) { return tl::sprintf ("OpenHandCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ClosedHandCursor) { return tl::sprintf ("ClosedHandCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LastCursor) { return tl::sprintf ("LastCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BitmapCursor) { return tl::sprintf ("BitmapCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CustomCursor) { return tl::sprintf ("CustomCursor (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_CursorShape_Enum (const Qt_CursorShape_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_CursorShape_Enum *from_i_Qt_CursorShape_Enum (unsigned int i)
{
  return new Qt_CursorShape_Enum ((Qt::CursorShape) i);
}

static bool equalQt_CursorShape_Enum (const Qt_CursorShape_Enum *e, Qt_CursorShape_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_CursorShape_Enum (const Qt_CursorShape_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_CursorShape_Enums oropQt_CursorShape_Enums (const Qt_CursorShape_Enums *e, const Qt_CursorShape_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_CursorShape_Enums andopQt_CursorShape_Enums (const Qt_CursorShape_Enums *e, const Qt_CursorShape_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_CursorShape_Enums xoropQt_CursorShape_Enums (const Qt_CursorShape_Enums *e, const Qt_CursorShape_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_CursorShape_Enums (const Qt_CursorShape_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::ArrowCursor)) { if (!l.empty ()) l += "|"; l += "ArrowCursor"; }
  if (e->testFlag (Qt::UpArrowCursor)) { if (!l.empty ()) l += "|"; l += "UpArrowCursor"; }
  if (e->testFlag (Qt::CrossCursor)) { if (!l.empty ()) l += "|"; l += "CrossCursor"; }
  if (e->testFlag (Qt::WaitCursor)) { if (!l.empty ()) l += "|"; l += "WaitCursor"; }
  if (e->testFlag (Qt::IBeamCursor)) { if (!l.empty ()) l += "|"; l += "IBeamCursor"; }
  if (e->testFlag (Qt::SizeVerCursor)) { if (!l.empty ()) l += "|"; l += "SizeVerCursor"; }
  if (e->testFlag (Qt::SizeHorCursor)) { if (!l.empty ()) l += "|"; l += "SizeHorCursor"; }
  if (e->testFlag (Qt::SizeBDiagCursor)) { if (!l.empty ()) l += "|"; l += "SizeBDiagCursor"; }
  if (e->testFlag (Qt::SizeFDiagCursor)) { if (!l.empty ()) l += "|"; l += "SizeFDiagCursor"; }
  if (e->testFlag (Qt::SizeAllCursor)) { if (!l.empty ()) l += "|"; l += "SizeAllCursor"; }
  if (e->testFlag (Qt::BlankCursor)) { if (!l.empty ()) l += "|"; l += "BlankCursor"; }
  if (e->testFlag (Qt::SplitVCursor)) { if (!l.empty ()) l += "|"; l += "SplitVCursor"; }
  if (e->testFlag (Qt::SplitHCursor)) { if (!l.empty ()) l += "|"; l += "SplitHCursor"; }
  if (e->testFlag (Qt::PointingHandCursor)) { if (!l.empty ()) l += "|"; l += "PointingHandCursor"; }
  if (e->testFlag (Qt::ForbiddenCursor)) { if (!l.empty ()) l += "|"; l += "ForbiddenCursor"; }
  if (e->testFlag (Qt::WhatsThisCursor)) { if (!l.empty ()) l += "|"; l += "WhatsThisCursor"; }
  if (e->testFlag (Qt::BusyCursor)) { if (!l.empty ()) l += "|"; l += "BusyCursor"; }
  if (e->testFlag (Qt::OpenHandCursor)) { if (!l.empty ()) l += "|"; l += "OpenHandCursor"; }
  if (e->testFlag (Qt::ClosedHandCursor)) { if (!l.empty ()) l += "|"; l += "ClosedHandCursor"; }
  if (e->testFlag (Qt::LastCursor)) { if (!l.empty ()) l += "|"; l += "LastCursor"; }
  if (e->testFlag (Qt::BitmapCursor)) { if (!l.empty ()) l += "|"; l += "BitmapCursor"; }
  if (e->testFlag (Qt::CustomCursor)) { if (!l.empty ()) l += "|"; l += "CustomCursor"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_CursorShape_Enums (const Qt_CursorShape_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_CursorShape_Enums (const Qt_CursorShape_Enums *e, const Qt_CursorShape_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_CursorShape_Enums> decl_Qt_CursorShape_Enums ("Qt_QFlags_CursorShape",
  gsi::method_ext ("|", &qt_gsi::oropQt_CursorShape_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_CursorShape_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_CursorShape_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_CursorShape_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_CursorShape_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_CursorShape_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::CursorShape> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_CursorShape_Enum> decl_Qt_CursorShape_Enum (decl_Qt_CursorShape_Enums, "Qt_CursorShape",
  qt_gsi::mkdefs_Qt_CursorShape () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_CursorShape_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_CursorShape_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_CursorShape_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_CursorShape_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_CursorShape_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::CursorShape enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_CursorShape_Enum_in_parent (qt_gsi::mkdefs_Qt_CursorShape ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_CursorShape_Enum_as_child (decl_Qt_CursorShape_Enum, "CursorShape");

}


//  Implementation of the enum wrapper class for Qt::DateFormat
namespace qt_gsi
{

static Qt_DateFormat_Enum *c_1_Qt_DateFormat_Enum () { return new Qt_DateFormat_Enum (Qt::TextDate); }
static Qt_DateFormat_Enum *c_2_Qt_DateFormat_Enum () { return new Qt_DateFormat_Enum (Qt::ISODate); }
static Qt_DateFormat_Enum *c_3_Qt_DateFormat_Enum () { return new Qt_DateFormat_Enum (Qt::SystemLocaleDate); }
static Qt_DateFormat_Enum *c_4_Qt_DateFormat_Enum () { return new Qt_DateFormat_Enum (Qt::LocalDate); }
static Qt_DateFormat_Enum *c_5_Qt_DateFormat_Enum () { return new Qt_DateFormat_Enum (Qt::LocaleDate); }
static Qt_DateFormat_Enum *c_6_Qt_DateFormat_Enum () { return new Qt_DateFormat_Enum (Qt::SystemLocaleShortDate); }
static Qt_DateFormat_Enum *c_7_Qt_DateFormat_Enum () { return new Qt_DateFormat_Enum (Qt::SystemLocaleLongDate); }
static Qt_DateFormat_Enum *c_8_Qt_DateFormat_Enum () { return new Qt_DateFormat_Enum (Qt::DefaultLocaleShortDate); }
static Qt_DateFormat_Enum *c_9_Qt_DateFormat_Enum () { return new Qt_DateFormat_Enum (Qt::DefaultLocaleLongDate); }

static gsi::Methods mkdefs_Qt_DateFormat () {
  return
    gsi::constant ("TextDate", &qt_gsi::c_1_Qt_DateFormat_Enum, "@brief Enum constant Qt::TextDate") +
    gsi::constant ("ISODate", &qt_gsi::c_2_Qt_DateFormat_Enum, "@brief Enum constant Qt::ISODate") +
    gsi::constant ("SystemLocaleDate", &qt_gsi::c_3_Qt_DateFormat_Enum, "@brief Enum constant Qt::SystemLocaleDate") +
    gsi::constant ("LocalDate", &qt_gsi::c_4_Qt_DateFormat_Enum, "@brief Enum constant Qt::LocalDate") +
    gsi::constant ("LocaleDate", &qt_gsi::c_5_Qt_DateFormat_Enum, "@brief Enum constant Qt::LocaleDate") +
    gsi::constant ("SystemLocaleShortDate", &qt_gsi::c_6_Qt_DateFormat_Enum, "@brief Enum constant Qt::SystemLocaleShortDate") +
    gsi::constant ("SystemLocaleLongDate", &qt_gsi::c_7_Qt_DateFormat_Enum, "@brief Enum constant Qt::SystemLocaleLongDate") +
    gsi::constant ("DefaultLocaleShortDate", &qt_gsi::c_8_Qt_DateFormat_Enum, "@brief Enum constant Qt::DefaultLocaleShortDate") +
    gsi::constant ("DefaultLocaleLongDate", &qt_gsi::c_9_Qt_DateFormat_Enum, "@brief Enum constant Qt::DefaultLocaleLongDate");
}

static std::string to_s_Qt_DateFormat_Enum (const Qt_DateFormat_Enum *e)
{
  if (e->value () == Qt::TextDate) { return tl::sprintf ("TextDate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ISODate) { return tl::sprintf ("ISODate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SystemLocaleDate) { return tl::sprintf ("SystemLocaleDate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LocalDate) { return tl::sprintf ("LocalDate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LocaleDate) { return tl::sprintf ("LocaleDate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SystemLocaleShortDate) { return tl::sprintf ("SystemLocaleShortDate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SystemLocaleLongDate) { return tl::sprintf ("SystemLocaleLongDate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DefaultLocaleShortDate) { return tl::sprintf ("DefaultLocaleShortDate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DefaultLocaleLongDate) { return tl::sprintf ("DefaultLocaleLongDate (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_DateFormat_Enum (const Qt_DateFormat_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_DateFormat_Enum *from_i_Qt_DateFormat_Enum (unsigned int i)
{
  return new Qt_DateFormat_Enum ((Qt::DateFormat) i);
}

static bool equalQt_DateFormat_Enum (const Qt_DateFormat_Enum *e, Qt_DateFormat_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_DateFormat_Enum (const Qt_DateFormat_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_DateFormat_Enums oropQt_DateFormat_Enums (const Qt_DateFormat_Enums *e, const Qt_DateFormat_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_DateFormat_Enums andopQt_DateFormat_Enums (const Qt_DateFormat_Enums *e, const Qt_DateFormat_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_DateFormat_Enums xoropQt_DateFormat_Enums (const Qt_DateFormat_Enums *e, const Qt_DateFormat_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_DateFormat_Enums (const Qt_DateFormat_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::TextDate)) { if (!l.empty ()) l += "|"; l += "TextDate"; }
  if (e->testFlag (Qt::ISODate)) { if (!l.empty ()) l += "|"; l += "ISODate"; }
  if (e->testFlag (Qt::SystemLocaleDate)) { if (!l.empty ()) l += "|"; l += "SystemLocaleDate"; }
  if (e->testFlag (Qt::LocalDate)) { if (!l.empty ()) l += "|"; l += "LocalDate"; }
  if (e->testFlag (Qt::LocaleDate)) { if (!l.empty ()) l += "|"; l += "LocaleDate"; }
  if (e->testFlag (Qt::SystemLocaleShortDate)) { if (!l.empty ()) l += "|"; l += "SystemLocaleShortDate"; }
  if (e->testFlag (Qt::SystemLocaleLongDate)) { if (!l.empty ()) l += "|"; l += "SystemLocaleLongDate"; }
  if (e->testFlag (Qt::DefaultLocaleShortDate)) { if (!l.empty ()) l += "|"; l += "DefaultLocaleShortDate"; }
  if (e->testFlag (Qt::DefaultLocaleLongDate)) { if (!l.empty ()) l += "|"; l += "DefaultLocaleLongDate"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_DateFormat_Enums (const Qt_DateFormat_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_DateFormat_Enums (const Qt_DateFormat_Enums *e, const Qt_DateFormat_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_DateFormat_Enums> decl_Qt_DateFormat_Enums ("Qt_QFlags_DateFormat",
  gsi::method_ext ("|", &qt_gsi::oropQt_DateFormat_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_DateFormat_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_DateFormat_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DateFormat_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DateFormat_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_DateFormat_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::DateFormat> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_DateFormat_Enum> decl_Qt_DateFormat_Enum (decl_Qt_DateFormat_Enums, "Qt_DateFormat",
  qt_gsi::mkdefs_Qt_DateFormat () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DateFormat_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DateFormat_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_DateFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_DateFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_DateFormat_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::DateFormat enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_DateFormat_Enum_in_parent (qt_gsi::mkdefs_Qt_DateFormat ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_DateFormat_Enum_as_child (decl_Qt_DateFormat_Enum, "DateFormat");

}


//  Implementation of the enum wrapper class for Qt::DayOfWeek
namespace qt_gsi
{

static Qt_DayOfWeek_Enum *c_1_Qt_DayOfWeek_Enum () { return new Qt_DayOfWeek_Enum (Qt::Monday); }
static Qt_DayOfWeek_Enum *c_2_Qt_DayOfWeek_Enum () { return new Qt_DayOfWeek_Enum (Qt::Tuesday); }
static Qt_DayOfWeek_Enum *c_3_Qt_DayOfWeek_Enum () { return new Qt_DayOfWeek_Enum (Qt::Wednesday); }
static Qt_DayOfWeek_Enum *c_4_Qt_DayOfWeek_Enum () { return new Qt_DayOfWeek_Enum (Qt::Thursday); }
static Qt_DayOfWeek_Enum *c_5_Qt_DayOfWeek_Enum () { return new Qt_DayOfWeek_Enum (Qt::Friday); }
static Qt_DayOfWeek_Enum *c_6_Qt_DayOfWeek_Enum () { return new Qt_DayOfWeek_Enum (Qt::Saturday); }
static Qt_DayOfWeek_Enum *c_7_Qt_DayOfWeek_Enum () { return new Qt_DayOfWeek_Enum (Qt::Sunday); }

static gsi::Methods mkdefs_Qt_DayOfWeek () {
  return
    gsi::constant ("Monday", &qt_gsi::c_1_Qt_DayOfWeek_Enum, "@brief Enum constant Qt::Monday") +
    gsi::constant ("Tuesday", &qt_gsi::c_2_Qt_DayOfWeek_Enum, "@brief Enum constant Qt::Tuesday") +
    gsi::constant ("Wednesday", &qt_gsi::c_3_Qt_DayOfWeek_Enum, "@brief Enum constant Qt::Wednesday") +
    gsi::constant ("Thursday", &qt_gsi::c_4_Qt_DayOfWeek_Enum, "@brief Enum constant Qt::Thursday") +
    gsi::constant ("Friday", &qt_gsi::c_5_Qt_DayOfWeek_Enum, "@brief Enum constant Qt::Friday") +
    gsi::constant ("Saturday", &qt_gsi::c_6_Qt_DayOfWeek_Enum, "@brief Enum constant Qt::Saturday") +
    gsi::constant ("Sunday", &qt_gsi::c_7_Qt_DayOfWeek_Enum, "@brief Enum constant Qt::Sunday");
}

static std::string to_s_Qt_DayOfWeek_Enum (const Qt_DayOfWeek_Enum *e)
{
  if (e->value () == Qt::Monday) { return tl::sprintf ("Monday (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Tuesday) { return tl::sprintf ("Tuesday (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Wednesday) { return tl::sprintf ("Wednesday (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Thursday) { return tl::sprintf ("Thursday (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Friday) { return tl::sprintf ("Friday (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Saturday) { return tl::sprintf ("Saturday (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Sunday) { return tl::sprintf ("Sunday (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_DayOfWeek_Enum (const Qt_DayOfWeek_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_DayOfWeek_Enum *from_i_Qt_DayOfWeek_Enum (unsigned int i)
{
  return new Qt_DayOfWeek_Enum ((Qt::DayOfWeek) i);
}

static bool equalQt_DayOfWeek_Enum (const Qt_DayOfWeek_Enum *e, Qt_DayOfWeek_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_DayOfWeek_Enum (const Qt_DayOfWeek_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_DayOfWeek_Enums oropQt_DayOfWeek_Enums (const Qt_DayOfWeek_Enums *e, const Qt_DayOfWeek_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_DayOfWeek_Enums andopQt_DayOfWeek_Enums (const Qt_DayOfWeek_Enums *e, const Qt_DayOfWeek_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_DayOfWeek_Enums xoropQt_DayOfWeek_Enums (const Qt_DayOfWeek_Enums *e, const Qt_DayOfWeek_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_DayOfWeek_Enums (const Qt_DayOfWeek_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::Monday)) { if (!l.empty ()) l += "|"; l += "Monday"; }
  if (e->testFlag (Qt::Tuesday)) { if (!l.empty ()) l += "|"; l += "Tuesday"; }
  if (e->testFlag (Qt::Wednesday)) { if (!l.empty ()) l += "|"; l += "Wednesday"; }
  if (e->testFlag (Qt::Thursday)) { if (!l.empty ()) l += "|"; l += "Thursday"; }
  if (e->testFlag (Qt::Friday)) { if (!l.empty ()) l += "|"; l += "Friday"; }
  if (e->testFlag (Qt::Saturday)) { if (!l.empty ()) l += "|"; l += "Saturday"; }
  if (e->testFlag (Qt::Sunday)) { if (!l.empty ()) l += "|"; l += "Sunday"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_DayOfWeek_Enums (const Qt_DayOfWeek_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_DayOfWeek_Enums (const Qt_DayOfWeek_Enums *e, const Qt_DayOfWeek_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_DayOfWeek_Enums> decl_Qt_DayOfWeek_Enums ("Qt_QFlags_DayOfWeek",
  gsi::method_ext ("|", &qt_gsi::oropQt_DayOfWeek_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_DayOfWeek_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_DayOfWeek_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DayOfWeek_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DayOfWeek_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_DayOfWeek_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::DayOfWeek> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_DayOfWeek_Enum> decl_Qt_DayOfWeek_Enum (decl_Qt_DayOfWeek_Enums, "Qt_DayOfWeek",
  qt_gsi::mkdefs_Qt_DayOfWeek () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DayOfWeek_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DayOfWeek_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_DayOfWeek_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_DayOfWeek_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_DayOfWeek_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::DayOfWeek enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_DayOfWeek_Enum_in_parent (qt_gsi::mkdefs_Qt_DayOfWeek ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_DayOfWeek_Enum_as_child (decl_Qt_DayOfWeek_Enum, "DayOfWeek");

}


//  Implementation of the enum wrapper class for Qt::DockWidgetArea
namespace qt_gsi
{

static Qt_DockWidgetArea_Enum *c_1_Qt_DockWidgetArea_Enum () { return new Qt_DockWidgetArea_Enum (Qt::LeftDockWidgetArea); }
static Qt_DockWidgetArea_Enum *c_2_Qt_DockWidgetArea_Enum () { return new Qt_DockWidgetArea_Enum (Qt::RightDockWidgetArea); }
static Qt_DockWidgetArea_Enum *c_3_Qt_DockWidgetArea_Enum () { return new Qt_DockWidgetArea_Enum (Qt::TopDockWidgetArea); }
static Qt_DockWidgetArea_Enum *c_4_Qt_DockWidgetArea_Enum () { return new Qt_DockWidgetArea_Enum (Qt::BottomDockWidgetArea); }
static Qt_DockWidgetArea_Enum *c_5_Qt_DockWidgetArea_Enum () { return new Qt_DockWidgetArea_Enum (Qt::DockWidgetArea_Mask); }
static Qt_DockWidgetArea_Enum *c_6_Qt_DockWidgetArea_Enum () { return new Qt_DockWidgetArea_Enum (Qt::AllDockWidgetAreas); }
static Qt_DockWidgetArea_Enum *c_7_Qt_DockWidgetArea_Enum () { return new Qt_DockWidgetArea_Enum (Qt::NoDockWidgetArea); }

static gsi::Methods mkdefs_Qt_DockWidgetArea () {
  return
    gsi::constant ("LeftDockWidgetArea", &qt_gsi::c_1_Qt_DockWidgetArea_Enum, "@brief Enum constant Qt::LeftDockWidgetArea") +
    gsi::constant ("RightDockWidgetArea", &qt_gsi::c_2_Qt_DockWidgetArea_Enum, "@brief Enum constant Qt::RightDockWidgetArea") +
    gsi::constant ("TopDockWidgetArea", &qt_gsi::c_3_Qt_DockWidgetArea_Enum, "@brief Enum constant Qt::TopDockWidgetArea") +
    gsi::constant ("BottomDockWidgetArea", &qt_gsi::c_4_Qt_DockWidgetArea_Enum, "@brief Enum constant Qt::BottomDockWidgetArea") +
    gsi::constant ("DockWidgetArea_Mask", &qt_gsi::c_5_Qt_DockWidgetArea_Enum, "@brief Enum constant Qt::DockWidgetArea_Mask") +
    gsi::constant ("AllDockWidgetAreas", &qt_gsi::c_6_Qt_DockWidgetArea_Enum, "@brief Enum constant Qt::AllDockWidgetAreas") +
    gsi::constant ("NoDockWidgetArea", &qt_gsi::c_7_Qt_DockWidgetArea_Enum, "@brief Enum constant Qt::NoDockWidgetArea");
}

static std::string to_s_Qt_DockWidgetArea_Enum (const Qt_DockWidgetArea_Enum *e)
{
  if (e->value () == Qt::LeftDockWidgetArea) { return tl::sprintf ("LeftDockWidgetArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RightDockWidgetArea) { return tl::sprintf ("RightDockWidgetArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TopDockWidgetArea) { return tl::sprintf ("TopDockWidgetArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BottomDockWidgetArea) { return tl::sprintf ("BottomDockWidgetArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DockWidgetArea_Mask) { return tl::sprintf ("DockWidgetArea_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AllDockWidgetAreas) { return tl::sprintf ("AllDockWidgetAreas (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NoDockWidgetArea) { return tl::sprintf ("NoDockWidgetArea (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_DockWidgetArea_Enum (const Qt_DockWidgetArea_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_DockWidgetArea_Enum *from_i_Qt_DockWidgetArea_Enum (unsigned int i)
{
  return new Qt_DockWidgetArea_Enum ((Qt::DockWidgetArea) i);
}

static bool equalQt_DockWidgetArea_Enum (const Qt_DockWidgetArea_Enum *e, Qt_DockWidgetArea_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_DockWidgetArea_Enum (const Qt_DockWidgetArea_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_DockWidgetArea_Enums oropQt_DockWidgetArea_Enums (const Qt_DockWidgetArea_Enums *e, const Qt_DockWidgetArea_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_DockWidgetArea_Enums andopQt_DockWidgetArea_Enums (const Qt_DockWidgetArea_Enums *e, const Qt_DockWidgetArea_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_DockWidgetArea_Enums xoropQt_DockWidgetArea_Enums (const Qt_DockWidgetArea_Enums *e, const Qt_DockWidgetArea_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_DockWidgetArea_Enums (const Qt_DockWidgetArea_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::LeftDockWidgetArea)) { if (!l.empty ()) l += "|"; l += "LeftDockWidgetArea"; }
  if (e->testFlag (Qt::RightDockWidgetArea)) { if (!l.empty ()) l += "|"; l += "RightDockWidgetArea"; }
  if (e->testFlag (Qt::TopDockWidgetArea)) { if (!l.empty ()) l += "|"; l += "TopDockWidgetArea"; }
  if (e->testFlag (Qt::BottomDockWidgetArea)) { if (!l.empty ()) l += "|"; l += "BottomDockWidgetArea"; }
  if (e->testFlag (Qt::DockWidgetArea_Mask)) { if (!l.empty ()) l += "|"; l += "DockWidgetArea_Mask"; }
  if (e->testFlag (Qt::AllDockWidgetAreas)) { if (!l.empty ()) l += "|"; l += "AllDockWidgetAreas"; }
  if (e->testFlag (Qt::NoDockWidgetArea)) { if (!l.empty ()) l += "|"; l += "NoDockWidgetArea"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_DockWidgetArea_Enums (const Qt_DockWidgetArea_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_DockWidgetArea_Enums (const Qt_DockWidgetArea_Enums *e, const Qt_DockWidgetArea_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_DockWidgetArea_Enums> decl_Qt_DockWidgetArea_Enums ("Qt_QFlags_DockWidgetArea",
  gsi::method_ext ("|", &qt_gsi::oropQt_DockWidgetArea_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_DockWidgetArea_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_DockWidgetArea_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DockWidgetArea_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DockWidgetArea_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_DockWidgetArea_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::DockWidgetArea> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_DockWidgetArea_Enum> decl_Qt_DockWidgetArea_Enum (decl_Qt_DockWidgetArea_Enums, "Qt_DockWidgetArea",
  qt_gsi::mkdefs_Qt_DockWidgetArea () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DockWidgetArea_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DockWidgetArea_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_DockWidgetArea_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_DockWidgetArea_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_DockWidgetArea_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::DockWidgetArea enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_DockWidgetArea_Enum_in_parent (qt_gsi::mkdefs_Qt_DockWidgetArea ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_DockWidgetArea_Enum_as_child (decl_Qt_DockWidgetArea_Enum, "DockWidgetArea");

}


//  Implementation of the enum wrapper class for Qt::DockWidgetAreaSizes
namespace qt_gsi
{

static Qt_DockWidgetAreaSizes_Enum *c_1_Qt_DockWidgetAreaSizes_Enum () { return new Qt_DockWidgetAreaSizes_Enum (Qt::NDockWidgetAreas); }

static gsi::Methods mkdefs_Qt_DockWidgetAreaSizes () {
  return
    gsi::constant ("NDockWidgetAreas", &qt_gsi::c_1_Qt_DockWidgetAreaSizes_Enum, "@brief Enum constant Qt::NDockWidgetAreas");
}

static std::string to_s_Qt_DockWidgetAreaSizes_Enum (const Qt_DockWidgetAreaSizes_Enum *e)
{
  if (e->value () == Qt::NDockWidgetAreas) { return tl::sprintf ("NDockWidgetAreas (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_DockWidgetAreaSizes_Enum (const Qt_DockWidgetAreaSizes_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_DockWidgetAreaSizes_Enum *from_i_Qt_DockWidgetAreaSizes_Enum (unsigned int i)
{
  return new Qt_DockWidgetAreaSizes_Enum ((Qt::DockWidgetAreaSizes) i);
}

static bool equalQt_DockWidgetAreaSizes_Enum (const Qt_DockWidgetAreaSizes_Enum *e, Qt_DockWidgetAreaSizes_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_DockWidgetAreaSizes_Enum (const Qt_DockWidgetAreaSizes_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_DockWidgetAreaSizes_Enums oropQt_DockWidgetAreaSizes_Enums (const Qt_DockWidgetAreaSizes_Enums *e, const Qt_DockWidgetAreaSizes_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_DockWidgetAreaSizes_Enums andopQt_DockWidgetAreaSizes_Enums (const Qt_DockWidgetAreaSizes_Enums *e, const Qt_DockWidgetAreaSizes_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_DockWidgetAreaSizes_Enums xoropQt_DockWidgetAreaSizes_Enums (const Qt_DockWidgetAreaSizes_Enums *e, const Qt_DockWidgetAreaSizes_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_DockWidgetAreaSizes_Enums (const Qt_DockWidgetAreaSizes_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NDockWidgetAreas)) { if (!l.empty ()) l += "|"; l += "NDockWidgetAreas"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_DockWidgetAreaSizes_Enums (const Qt_DockWidgetAreaSizes_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_DockWidgetAreaSizes_Enums (const Qt_DockWidgetAreaSizes_Enums *e, const Qt_DockWidgetAreaSizes_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_DockWidgetAreaSizes_Enums> decl_Qt_DockWidgetAreaSizes_Enums ("Qt_QFlags_DockWidgetAreaSizes",
  gsi::method_ext ("|", &qt_gsi::oropQt_DockWidgetAreaSizes_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_DockWidgetAreaSizes_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_DockWidgetAreaSizes_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DockWidgetAreaSizes_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DockWidgetAreaSizes_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_DockWidgetAreaSizes_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::DockWidgetAreaSizes> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_DockWidgetAreaSizes_Enum> decl_Qt_DockWidgetAreaSizes_Enum (decl_Qt_DockWidgetAreaSizes_Enums, "Qt_DockWidgetAreaSizes",
  qt_gsi::mkdefs_Qt_DockWidgetAreaSizes () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DockWidgetAreaSizes_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DockWidgetAreaSizes_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_DockWidgetAreaSizes_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_DockWidgetAreaSizes_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_DockWidgetAreaSizes_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::DockWidgetAreaSizes enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_DockWidgetAreaSizes_Enum_in_parent (qt_gsi::mkdefs_Qt_DockWidgetAreaSizes ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_DockWidgetAreaSizes_Enum_as_child (decl_Qt_DockWidgetAreaSizes_Enum, "DockWidgetAreaSizes");

}


//  Implementation of the enum wrapper class for Qt::DropAction
namespace qt_gsi
{

static Qt_DropAction_Enum *c_1_Qt_DropAction_Enum () { return new Qt_DropAction_Enum (Qt::CopyAction); }
static Qt_DropAction_Enum *c_2_Qt_DropAction_Enum () { return new Qt_DropAction_Enum (Qt::MoveAction); }
static Qt_DropAction_Enum *c_3_Qt_DropAction_Enum () { return new Qt_DropAction_Enum (Qt::LinkAction); }
static Qt_DropAction_Enum *c_4_Qt_DropAction_Enum () { return new Qt_DropAction_Enum (Qt::ActionMask); }
static Qt_DropAction_Enum *c_5_Qt_DropAction_Enum () { return new Qt_DropAction_Enum (Qt::TargetMoveAction); }
static Qt_DropAction_Enum *c_6_Qt_DropAction_Enum () { return new Qt_DropAction_Enum (Qt::IgnoreAction); }

static gsi::Methods mkdefs_Qt_DropAction () {
  return
    gsi::constant ("CopyAction", &qt_gsi::c_1_Qt_DropAction_Enum, "@brief Enum constant Qt::CopyAction") +
    gsi::constant ("MoveAction", &qt_gsi::c_2_Qt_DropAction_Enum, "@brief Enum constant Qt::MoveAction") +
    gsi::constant ("LinkAction", &qt_gsi::c_3_Qt_DropAction_Enum, "@brief Enum constant Qt::LinkAction") +
    gsi::constant ("ActionMask", &qt_gsi::c_4_Qt_DropAction_Enum, "@brief Enum constant Qt::ActionMask") +
    gsi::constant ("TargetMoveAction", &qt_gsi::c_5_Qt_DropAction_Enum, "@brief Enum constant Qt::TargetMoveAction") +
    gsi::constant ("IgnoreAction", &qt_gsi::c_6_Qt_DropAction_Enum, "@brief Enum constant Qt::IgnoreAction");
}

static std::string to_s_Qt_DropAction_Enum (const Qt_DropAction_Enum *e)
{
  if (e->value () == Qt::CopyAction) { return tl::sprintf ("CopyAction (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MoveAction) { return tl::sprintf ("MoveAction (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LinkAction) { return tl::sprintf ("LinkAction (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ActionMask) { return tl::sprintf ("ActionMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TargetMoveAction) { return tl::sprintf ("TargetMoveAction (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::IgnoreAction) { return tl::sprintf ("IgnoreAction (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_DropAction_Enum (const Qt_DropAction_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_DropAction_Enum *from_i_Qt_DropAction_Enum (unsigned int i)
{
  return new Qt_DropAction_Enum ((Qt::DropAction) i);
}

static bool equalQt_DropAction_Enum (const Qt_DropAction_Enum *e, Qt_DropAction_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_DropAction_Enum (const Qt_DropAction_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_DropAction_Enums oropQt_DropAction_Enums (const Qt_DropAction_Enums *e, const Qt_DropAction_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_DropAction_Enums andopQt_DropAction_Enums (const Qt_DropAction_Enums *e, const Qt_DropAction_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_DropAction_Enums xoropQt_DropAction_Enums (const Qt_DropAction_Enums *e, const Qt_DropAction_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_DropAction_Enums (const Qt_DropAction_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::CopyAction)) { if (!l.empty ()) l += "|"; l += "CopyAction"; }
  if (e->testFlag (Qt::MoveAction)) { if (!l.empty ()) l += "|"; l += "MoveAction"; }
  if (e->testFlag (Qt::LinkAction)) { if (!l.empty ()) l += "|"; l += "LinkAction"; }
  if (e->testFlag (Qt::ActionMask)) { if (!l.empty ()) l += "|"; l += "ActionMask"; }
  if (e->testFlag (Qt::TargetMoveAction)) { if (!l.empty ()) l += "|"; l += "TargetMoveAction"; }
  if (e->testFlag (Qt::IgnoreAction)) { if (!l.empty ()) l += "|"; l += "IgnoreAction"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_DropAction_Enums (const Qt_DropAction_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_DropAction_Enums (const Qt_DropAction_Enums *e, const Qt_DropAction_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_DropAction_Enums> decl_Qt_DropAction_Enums ("Qt_QFlags_DropAction",
  gsi::method_ext ("|", &qt_gsi::oropQt_DropAction_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_DropAction_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_DropAction_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DropAction_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DropAction_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_DropAction_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::DropAction> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_DropAction_Enum> decl_Qt_DropAction_Enum (decl_Qt_DropAction_Enums, "Qt_DropAction",
  qt_gsi::mkdefs_Qt_DropAction () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_DropAction_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_DropAction_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_DropAction_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_DropAction_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_DropAction_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::DropAction enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_DropAction_Enum_in_parent (qt_gsi::mkdefs_Qt_DropAction ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_DropAction_Enum_as_child (decl_Qt_DropAction_Enum, "DropAction");

}


//  Implementation of the enum wrapper class for Qt::EventPriority
namespace qt_gsi
{

static Qt_EventPriority_Enum *c_1_Qt_EventPriority_Enum () { return new Qt_EventPriority_Enum (Qt::HighEventPriority); }
static Qt_EventPriority_Enum *c_2_Qt_EventPriority_Enum () { return new Qt_EventPriority_Enum (Qt::NormalEventPriority); }
static Qt_EventPriority_Enum *c_3_Qt_EventPriority_Enum () { return new Qt_EventPriority_Enum (Qt::LowEventPriority); }

static gsi::Methods mkdefs_Qt_EventPriority () {
  return
    gsi::constant ("HighEventPriority", &qt_gsi::c_1_Qt_EventPriority_Enum, "@brief Enum constant Qt::HighEventPriority") +
    gsi::constant ("NormalEventPriority", &qt_gsi::c_2_Qt_EventPriority_Enum, "@brief Enum constant Qt::NormalEventPriority") +
    gsi::constant ("LowEventPriority", &qt_gsi::c_3_Qt_EventPriority_Enum, "@brief Enum constant Qt::LowEventPriority");
}

static std::string to_s_Qt_EventPriority_Enum (const Qt_EventPriority_Enum *e)
{
  if (e->value () == Qt::HighEventPriority) { return tl::sprintf ("HighEventPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NormalEventPriority) { return tl::sprintf ("NormalEventPriority (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LowEventPriority) { return tl::sprintf ("LowEventPriority (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_EventPriority_Enum (const Qt_EventPriority_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_EventPriority_Enum *from_i_Qt_EventPriority_Enum (unsigned int i)
{
  return new Qt_EventPriority_Enum ((Qt::EventPriority) i);
}

static bool equalQt_EventPriority_Enum (const Qt_EventPriority_Enum *e, Qt_EventPriority_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_EventPriority_Enum (const Qt_EventPriority_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_EventPriority_Enums oropQt_EventPriority_Enums (const Qt_EventPriority_Enums *e, const Qt_EventPriority_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_EventPriority_Enums andopQt_EventPriority_Enums (const Qt_EventPriority_Enums *e, const Qt_EventPriority_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_EventPriority_Enums xoropQt_EventPriority_Enums (const Qt_EventPriority_Enums *e, const Qt_EventPriority_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_EventPriority_Enums (const Qt_EventPriority_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::HighEventPriority)) { if (!l.empty ()) l += "|"; l += "HighEventPriority"; }
  if (e->testFlag (Qt::NormalEventPriority)) { if (!l.empty ()) l += "|"; l += "NormalEventPriority"; }
  if (e->testFlag (Qt::LowEventPriority)) { if (!l.empty ()) l += "|"; l += "LowEventPriority"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_EventPriority_Enums (const Qt_EventPriority_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_EventPriority_Enums (const Qt_EventPriority_Enums *e, const Qt_EventPriority_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_EventPriority_Enums> decl_Qt_EventPriority_Enums ("Qt_QFlags_EventPriority",
  gsi::method_ext ("|", &qt_gsi::oropQt_EventPriority_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_EventPriority_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_EventPriority_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_EventPriority_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_EventPriority_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_EventPriority_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::EventPriority> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_EventPriority_Enum> decl_Qt_EventPriority_Enum (decl_Qt_EventPriority_Enums, "Qt_EventPriority",
  qt_gsi::mkdefs_Qt_EventPriority () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_EventPriority_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_EventPriority_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_EventPriority_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_EventPriority_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_EventPriority_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::EventPriority enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_EventPriority_Enum_in_parent (qt_gsi::mkdefs_Qt_EventPriority ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_EventPriority_Enum_as_child (decl_Qt_EventPriority_Enum, "EventPriority");

}


//  Implementation of the enum wrapper class for Qt::FillRule
namespace qt_gsi
{

static Qt_FillRule_Enum *c_1_Qt_FillRule_Enum () { return new Qt_FillRule_Enum (Qt::OddEvenFill); }
static Qt_FillRule_Enum *c_2_Qt_FillRule_Enum () { return new Qt_FillRule_Enum (Qt::WindingFill); }

static gsi::Methods mkdefs_Qt_FillRule () {
  return
    gsi::constant ("OddEvenFill", &qt_gsi::c_1_Qt_FillRule_Enum, "@brief Enum constant Qt::OddEvenFill") +
    gsi::constant ("WindingFill", &qt_gsi::c_2_Qt_FillRule_Enum, "@brief Enum constant Qt::WindingFill");
}

static std::string to_s_Qt_FillRule_Enum (const Qt_FillRule_Enum *e)
{
  if (e->value () == Qt::OddEvenFill) { return tl::sprintf ("OddEvenFill (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindingFill) { return tl::sprintf ("WindingFill (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_FillRule_Enum (const Qt_FillRule_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_FillRule_Enum *from_i_Qt_FillRule_Enum (unsigned int i)
{
  return new Qt_FillRule_Enum ((Qt::FillRule) i);
}

static bool equalQt_FillRule_Enum (const Qt_FillRule_Enum *e, Qt_FillRule_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_FillRule_Enum (const Qt_FillRule_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_FillRule_Enums oropQt_FillRule_Enums (const Qt_FillRule_Enums *e, const Qt_FillRule_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_FillRule_Enums andopQt_FillRule_Enums (const Qt_FillRule_Enums *e, const Qt_FillRule_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_FillRule_Enums xoropQt_FillRule_Enums (const Qt_FillRule_Enums *e, const Qt_FillRule_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_FillRule_Enums (const Qt_FillRule_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::OddEvenFill)) { if (!l.empty ()) l += "|"; l += "OddEvenFill"; }
  if (e->testFlag (Qt::WindingFill)) { if (!l.empty ()) l += "|"; l += "WindingFill"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_FillRule_Enums (const Qt_FillRule_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_FillRule_Enums (const Qt_FillRule_Enums *e, const Qt_FillRule_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_FillRule_Enums> decl_Qt_FillRule_Enums ("Qt_QFlags_FillRule",
  gsi::method_ext ("|", &qt_gsi::oropQt_FillRule_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_FillRule_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_FillRule_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_FillRule_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_FillRule_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_FillRule_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::FillRule> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_FillRule_Enum> decl_Qt_FillRule_Enum (decl_Qt_FillRule_Enums, "Qt_FillRule",
  qt_gsi::mkdefs_Qt_FillRule () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_FillRule_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_FillRule_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_FillRule_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_FillRule_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_FillRule_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::FillRule enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_FillRule_Enum_in_parent (qt_gsi::mkdefs_Qt_FillRule ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_FillRule_Enum_as_child (decl_Qt_FillRule_Enum, "FillRule");

}


//  Implementation of the enum wrapper class for Qt::FocusPolicy
namespace qt_gsi
{

static Qt_FocusPolicy_Enum *c_1_Qt_FocusPolicy_Enum () { return new Qt_FocusPolicy_Enum (Qt::NoFocus); }
static Qt_FocusPolicy_Enum *c_2_Qt_FocusPolicy_Enum () { return new Qt_FocusPolicy_Enum (Qt::TabFocus); }
static Qt_FocusPolicy_Enum *c_3_Qt_FocusPolicy_Enum () { return new Qt_FocusPolicy_Enum (Qt::ClickFocus); }
static Qt_FocusPolicy_Enum *c_4_Qt_FocusPolicy_Enum () { return new Qt_FocusPolicy_Enum (Qt::StrongFocus); }
static Qt_FocusPolicy_Enum *c_5_Qt_FocusPolicy_Enum () { return new Qt_FocusPolicy_Enum (Qt::WheelFocus); }

static gsi::Methods mkdefs_Qt_FocusPolicy () {
  return
    gsi::constant ("NoFocus", &qt_gsi::c_1_Qt_FocusPolicy_Enum, "@brief Enum constant Qt::NoFocus") +
    gsi::constant ("TabFocus", &qt_gsi::c_2_Qt_FocusPolicy_Enum, "@brief Enum constant Qt::TabFocus") +
    gsi::constant ("ClickFocus", &qt_gsi::c_3_Qt_FocusPolicy_Enum, "@brief Enum constant Qt::ClickFocus") +
    gsi::constant ("StrongFocus", &qt_gsi::c_4_Qt_FocusPolicy_Enum, "@brief Enum constant Qt::StrongFocus") +
    gsi::constant ("WheelFocus", &qt_gsi::c_5_Qt_FocusPolicy_Enum, "@brief Enum constant Qt::WheelFocus");
}

static std::string to_s_Qt_FocusPolicy_Enum (const Qt_FocusPolicy_Enum *e)
{
  if (e->value () == Qt::NoFocus) { return tl::sprintf ("NoFocus (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TabFocus) { return tl::sprintf ("TabFocus (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ClickFocus) { return tl::sprintf ("ClickFocus (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::StrongFocus) { return tl::sprintf ("StrongFocus (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WheelFocus) { return tl::sprintf ("WheelFocus (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_FocusPolicy_Enum (const Qt_FocusPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_FocusPolicy_Enum *from_i_Qt_FocusPolicy_Enum (unsigned int i)
{
  return new Qt_FocusPolicy_Enum ((Qt::FocusPolicy) i);
}

static bool equalQt_FocusPolicy_Enum (const Qt_FocusPolicy_Enum *e, Qt_FocusPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_FocusPolicy_Enum (const Qt_FocusPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_FocusPolicy_Enums oropQt_FocusPolicy_Enums (const Qt_FocusPolicy_Enums *e, const Qt_FocusPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_FocusPolicy_Enums andopQt_FocusPolicy_Enums (const Qt_FocusPolicy_Enums *e, const Qt_FocusPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_FocusPolicy_Enums xoropQt_FocusPolicy_Enums (const Qt_FocusPolicy_Enums *e, const Qt_FocusPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_FocusPolicy_Enums (const Qt_FocusPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoFocus)) { if (!l.empty ()) l += "|"; l += "NoFocus"; }
  if (e->testFlag (Qt::TabFocus)) { if (!l.empty ()) l += "|"; l += "TabFocus"; }
  if (e->testFlag (Qt::ClickFocus)) { if (!l.empty ()) l += "|"; l += "ClickFocus"; }
  if (e->testFlag (Qt::StrongFocus)) { if (!l.empty ()) l += "|"; l += "StrongFocus"; }
  if (e->testFlag (Qt::WheelFocus)) { if (!l.empty ()) l += "|"; l += "WheelFocus"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_FocusPolicy_Enums (const Qt_FocusPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_FocusPolicy_Enums (const Qt_FocusPolicy_Enums *e, const Qt_FocusPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_FocusPolicy_Enums> decl_Qt_FocusPolicy_Enums ("Qt_QFlags_FocusPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQt_FocusPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_FocusPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_FocusPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_FocusPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_FocusPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_FocusPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::FocusPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_FocusPolicy_Enum> decl_Qt_FocusPolicy_Enum (decl_Qt_FocusPolicy_Enums, "Qt_FocusPolicy",
  qt_gsi::mkdefs_Qt_FocusPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_FocusPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_FocusPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_FocusPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_FocusPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_FocusPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::FocusPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_FocusPolicy_Enum_in_parent (qt_gsi::mkdefs_Qt_FocusPolicy ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_FocusPolicy_Enum_as_child (decl_Qt_FocusPolicy_Enum, "FocusPolicy");

}


//  Implementation of the enum wrapper class for Qt::FocusReason
namespace qt_gsi
{

static Qt_FocusReason_Enum *c_1_Qt_FocusReason_Enum () { return new Qt_FocusReason_Enum (Qt::MouseFocusReason); }
static Qt_FocusReason_Enum *c_2_Qt_FocusReason_Enum () { return new Qt_FocusReason_Enum (Qt::TabFocusReason); }
static Qt_FocusReason_Enum *c_3_Qt_FocusReason_Enum () { return new Qt_FocusReason_Enum (Qt::BacktabFocusReason); }
static Qt_FocusReason_Enum *c_4_Qt_FocusReason_Enum () { return new Qt_FocusReason_Enum (Qt::ActiveWindowFocusReason); }
static Qt_FocusReason_Enum *c_5_Qt_FocusReason_Enum () { return new Qt_FocusReason_Enum (Qt::PopupFocusReason); }
static Qt_FocusReason_Enum *c_6_Qt_FocusReason_Enum () { return new Qt_FocusReason_Enum (Qt::ShortcutFocusReason); }
static Qt_FocusReason_Enum *c_7_Qt_FocusReason_Enum () { return new Qt_FocusReason_Enum (Qt::MenuBarFocusReason); }
static Qt_FocusReason_Enum *c_8_Qt_FocusReason_Enum () { return new Qt_FocusReason_Enum (Qt::OtherFocusReason); }
static Qt_FocusReason_Enum *c_9_Qt_FocusReason_Enum () { return new Qt_FocusReason_Enum (Qt::NoFocusReason); }

static gsi::Methods mkdefs_Qt_FocusReason () {
  return
    gsi::constant ("MouseFocusReason", &qt_gsi::c_1_Qt_FocusReason_Enum, "@brief Enum constant Qt::MouseFocusReason") +
    gsi::constant ("TabFocusReason", &qt_gsi::c_2_Qt_FocusReason_Enum, "@brief Enum constant Qt::TabFocusReason") +
    gsi::constant ("BacktabFocusReason", &qt_gsi::c_3_Qt_FocusReason_Enum, "@brief Enum constant Qt::BacktabFocusReason") +
    gsi::constant ("ActiveWindowFocusReason", &qt_gsi::c_4_Qt_FocusReason_Enum, "@brief Enum constant Qt::ActiveWindowFocusReason") +
    gsi::constant ("PopupFocusReason", &qt_gsi::c_5_Qt_FocusReason_Enum, "@brief Enum constant Qt::PopupFocusReason") +
    gsi::constant ("ShortcutFocusReason", &qt_gsi::c_6_Qt_FocusReason_Enum, "@brief Enum constant Qt::ShortcutFocusReason") +
    gsi::constant ("MenuBarFocusReason", &qt_gsi::c_7_Qt_FocusReason_Enum, "@brief Enum constant Qt::MenuBarFocusReason") +
    gsi::constant ("OtherFocusReason", &qt_gsi::c_8_Qt_FocusReason_Enum, "@brief Enum constant Qt::OtherFocusReason") +
    gsi::constant ("NoFocusReason", &qt_gsi::c_9_Qt_FocusReason_Enum, "@brief Enum constant Qt::NoFocusReason");
}

static std::string to_s_Qt_FocusReason_Enum (const Qt_FocusReason_Enum *e)
{
  if (e->value () == Qt::MouseFocusReason) { return tl::sprintf ("MouseFocusReason (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TabFocusReason) { return tl::sprintf ("TabFocusReason (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BacktabFocusReason) { return tl::sprintf ("BacktabFocusReason (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ActiveWindowFocusReason) { return tl::sprintf ("ActiveWindowFocusReason (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::PopupFocusReason) { return tl::sprintf ("PopupFocusReason (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ShortcutFocusReason) { return tl::sprintf ("ShortcutFocusReason (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MenuBarFocusReason) { return tl::sprintf ("MenuBarFocusReason (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::OtherFocusReason) { return tl::sprintf ("OtherFocusReason (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NoFocusReason) { return tl::sprintf ("NoFocusReason (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_FocusReason_Enum (const Qt_FocusReason_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_FocusReason_Enum *from_i_Qt_FocusReason_Enum (unsigned int i)
{
  return new Qt_FocusReason_Enum ((Qt::FocusReason) i);
}

static bool equalQt_FocusReason_Enum (const Qt_FocusReason_Enum *e, Qt_FocusReason_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_FocusReason_Enum (const Qt_FocusReason_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_FocusReason_Enums oropQt_FocusReason_Enums (const Qt_FocusReason_Enums *e, const Qt_FocusReason_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_FocusReason_Enums andopQt_FocusReason_Enums (const Qt_FocusReason_Enums *e, const Qt_FocusReason_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_FocusReason_Enums xoropQt_FocusReason_Enums (const Qt_FocusReason_Enums *e, const Qt_FocusReason_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_FocusReason_Enums (const Qt_FocusReason_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::MouseFocusReason)) { if (!l.empty ()) l += "|"; l += "MouseFocusReason"; }
  if (e->testFlag (Qt::TabFocusReason)) { if (!l.empty ()) l += "|"; l += "TabFocusReason"; }
  if (e->testFlag (Qt::BacktabFocusReason)) { if (!l.empty ()) l += "|"; l += "BacktabFocusReason"; }
  if (e->testFlag (Qt::ActiveWindowFocusReason)) { if (!l.empty ()) l += "|"; l += "ActiveWindowFocusReason"; }
  if (e->testFlag (Qt::PopupFocusReason)) { if (!l.empty ()) l += "|"; l += "PopupFocusReason"; }
  if (e->testFlag (Qt::ShortcutFocusReason)) { if (!l.empty ()) l += "|"; l += "ShortcutFocusReason"; }
  if (e->testFlag (Qt::MenuBarFocusReason)) { if (!l.empty ()) l += "|"; l += "MenuBarFocusReason"; }
  if (e->testFlag (Qt::OtherFocusReason)) { if (!l.empty ()) l += "|"; l += "OtherFocusReason"; }
  if (e->testFlag (Qt::NoFocusReason)) { if (!l.empty ()) l += "|"; l += "NoFocusReason"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_FocusReason_Enums (const Qt_FocusReason_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_FocusReason_Enums (const Qt_FocusReason_Enums *e, const Qt_FocusReason_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_FocusReason_Enums> decl_Qt_FocusReason_Enums ("Qt_QFlags_FocusReason",
  gsi::method_ext ("|", &qt_gsi::oropQt_FocusReason_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_FocusReason_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_FocusReason_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_FocusReason_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_FocusReason_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_FocusReason_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::FocusReason> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_FocusReason_Enum> decl_Qt_FocusReason_Enum (decl_Qt_FocusReason_Enums, "Qt_FocusReason",
  qt_gsi::mkdefs_Qt_FocusReason () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_FocusReason_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_FocusReason_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_FocusReason_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_FocusReason_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_FocusReason_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::FocusReason enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_FocusReason_Enum_in_parent (qt_gsi::mkdefs_Qt_FocusReason ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_FocusReason_Enum_as_child (decl_Qt_FocusReason_Enum, "FocusReason");

}


//  Implementation of the enum wrapper class for Qt::GestureFlag
namespace qt_gsi
{

static Qt_GestureFlag_Enum *c_1_Qt_GestureFlag_Enum () { return new Qt_GestureFlag_Enum (Qt::DontStartGestureOnChildren); }
static Qt_GestureFlag_Enum *c_2_Qt_GestureFlag_Enum () { return new Qt_GestureFlag_Enum (Qt::ReceivePartialGestures); }

static gsi::Methods mkdefs_Qt_GestureFlag () {
  return
    gsi::constant ("DontStartGestureOnChildren", &qt_gsi::c_1_Qt_GestureFlag_Enum, "@brief Enum constant Qt::DontStartGestureOnChildren") +
    gsi::constant ("ReceivePartialGestures", &qt_gsi::c_2_Qt_GestureFlag_Enum, "@brief Enum constant Qt::ReceivePartialGestures");
}

static std::string to_s_Qt_GestureFlag_Enum (const Qt_GestureFlag_Enum *e)
{
  if (e->value () == Qt::DontStartGestureOnChildren) { return tl::sprintf ("DontStartGestureOnChildren (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ReceivePartialGestures) { return tl::sprintf ("ReceivePartialGestures (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_GestureFlag_Enum (const Qt_GestureFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_GestureFlag_Enum *from_i_Qt_GestureFlag_Enum (unsigned int i)
{
  return new Qt_GestureFlag_Enum ((Qt::GestureFlag) i);
}

static bool equalQt_GestureFlag_Enum (const Qt_GestureFlag_Enum *e, Qt_GestureFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_GestureFlag_Enum (const Qt_GestureFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_GestureFlag_Enums oropQt_GestureFlag_Enums (const Qt_GestureFlag_Enums *e, const Qt_GestureFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_GestureFlag_Enums andopQt_GestureFlag_Enums (const Qt_GestureFlag_Enums *e, const Qt_GestureFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_GestureFlag_Enums xoropQt_GestureFlag_Enums (const Qt_GestureFlag_Enums *e, const Qt_GestureFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_GestureFlag_Enums (const Qt_GestureFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::DontStartGestureOnChildren)) { if (!l.empty ()) l += "|"; l += "DontStartGestureOnChildren"; }
  if (e->testFlag (Qt::ReceivePartialGestures)) { if (!l.empty ()) l += "|"; l += "ReceivePartialGestures"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_GestureFlag_Enums (const Qt_GestureFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_GestureFlag_Enums (const Qt_GestureFlag_Enums *e, const Qt_GestureFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_GestureFlag_Enums> decl_Qt_GestureFlag_Enums ("Qt_QFlags_GestureFlag",
  gsi::method_ext ("|", &qt_gsi::oropQt_GestureFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_GestureFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_GestureFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_GestureFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_GestureFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_GestureFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::GestureFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_GestureFlag_Enum> decl_Qt_GestureFlag_Enum (decl_Qt_GestureFlag_Enums, "Qt_GestureFlag",
  qt_gsi::mkdefs_Qt_GestureFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_GestureFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_GestureFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_GestureFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_GestureFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_GestureFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::GestureFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_GestureFlag_Enum_in_parent (qt_gsi::mkdefs_Qt_GestureFlag ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_GestureFlag_Enum_as_child (decl_Qt_GestureFlag_Enum, "GestureFlag");

}


//  Implementation of the enum wrapper class for Qt::GestureState
namespace qt_gsi
{

static Qt_GestureState_Enum *c_1_Qt_GestureState_Enum () { return new Qt_GestureState_Enum (Qt::NoGesture); }
static Qt_GestureState_Enum *c_2_Qt_GestureState_Enum () { return new Qt_GestureState_Enum (Qt::GestureStarted); }
static Qt_GestureState_Enum *c_3_Qt_GestureState_Enum () { return new Qt_GestureState_Enum (Qt::GestureUpdated); }
static Qt_GestureState_Enum *c_4_Qt_GestureState_Enum () { return new Qt_GestureState_Enum (Qt::GestureFinished); }
static Qt_GestureState_Enum *c_5_Qt_GestureState_Enum () { return new Qt_GestureState_Enum (Qt::GestureCanceled); }

static gsi::Methods mkdefs_Qt_GestureState () {
  return
    gsi::constant ("NoGesture", &qt_gsi::c_1_Qt_GestureState_Enum, "@brief Enum constant Qt::NoGesture") +
    gsi::constant ("GestureStarted", &qt_gsi::c_2_Qt_GestureState_Enum, "@brief Enum constant Qt::GestureStarted") +
    gsi::constant ("GestureUpdated", &qt_gsi::c_3_Qt_GestureState_Enum, "@brief Enum constant Qt::GestureUpdated") +
    gsi::constant ("GestureFinished", &qt_gsi::c_4_Qt_GestureState_Enum, "@brief Enum constant Qt::GestureFinished") +
    gsi::constant ("GestureCanceled", &qt_gsi::c_5_Qt_GestureState_Enum, "@brief Enum constant Qt::GestureCanceled");
}

static std::string to_s_Qt_GestureState_Enum (const Qt_GestureState_Enum *e)
{
  if (e->value () == Qt::NoGesture) { return tl::sprintf ("NoGesture (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::GestureStarted) { return tl::sprintf ("GestureStarted (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::GestureUpdated) { return tl::sprintf ("GestureUpdated (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::GestureFinished) { return tl::sprintf ("GestureFinished (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::GestureCanceled) { return tl::sprintf ("GestureCanceled (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_GestureState_Enum (const Qt_GestureState_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_GestureState_Enum *from_i_Qt_GestureState_Enum (unsigned int i)
{
  return new Qt_GestureState_Enum ((Qt::GestureState) i);
}

static bool equalQt_GestureState_Enum (const Qt_GestureState_Enum *e, Qt_GestureState_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_GestureState_Enum (const Qt_GestureState_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_GestureState_Enums oropQt_GestureState_Enums (const Qt_GestureState_Enums *e, const Qt_GestureState_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_GestureState_Enums andopQt_GestureState_Enums (const Qt_GestureState_Enums *e, const Qt_GestureState_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_GestureState_Enums xoropQt_GestureState_Enums (const Qt_GestureState_Enums *e, const Qt_GestureState_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_GestureState_Enums (const Qt_GestureState_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoGesture)) { if (!l.empty ()) l += "|"; l += "NoGesture"; }
  if (e->testFlag (Qt::GestureStarted)) { if (!l.empty ()) l += "|"; l += "GestureStarted"; }
  if (e->testFlag (Qt::GestureUpdated)) { if (!l.empty ()) l += "|"; l += "GestureUpdated"; }
  if (e->testFlag (Qt::GestureFinished)) { if (!l.empty ()) l += "|"; l += "GestureFinished"; }
  if (e->testFlag (Qt::GestureCanceled)) { if (!l.empty ()) l += "|"; l += "GestureCanceled"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_GestureState_Enums (const Qt_GestureState_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_GestureState_Enums (const Qt_GestureState_Enums *e, const Qt_GestureState_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_GestureState_Enums> decl_Qt_GestureState_Enums ("Qt_QFlags_GestureState",
  gsi::method_ext ("|", &qt_gsi::oropQt_GestureState_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_GestureState_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_GestureState_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_GestureState_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_GestureState_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_GestureState_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::GestureState> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_GestureState_Enum> decl_Qt_GestureState_Enum (decl_Qt_GestureState_Enums, "Qt_GestureState",
  qt_gsi::mkdefs_Qt_GestureState () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_GestureState_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_GestureState_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_GestureState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_GestureState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_GestureState_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::GestureState enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_GestureState_Enum_in_parent (qt_gsi::mkdefs_Qt_GestureState ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_GestureState_Enum_as_child (decl_Qt_GestureState_Enum, "GestureState");

}


//  Implementation of the enum wrapper class for Qt::GestureType
namespace qt_gsi
{

static Qt_GestureType_Enum *c_1_Qt_GestureType_Enum () { return new Qt_GestureType_Enum (Qt::TapGesture); }
static Qt_GestureType_Enum *c_2_Qt_GestureType_Enum () { return new Qt_GestureType_Enum (Qt::TapAndHoldGesture); }
static Qt_GestureType_Enum *c_3_Qt_GestureType_Enum () { return new Qt_GestureType_Enum (Qt::PanGesture); }
static Qt_GestureType_Enum *c_4_Qt_GestureType_Enum () { return new Qt_GestureType_Enum (Qt::PinchGesture); }
static Qt_GestureType_Enum *c_5_Qt_GestureType_Enum () { return new Qt_GestureType_Enum (Qt::SwipeGesture); }
static Qt_GestureType_Enum *c_6_Qt_GestureType_Enum () { return new Qt_GestureType_Enum (Qt::CustomGesture); }
static Qt_GestureType_Enum *c_7_Qt_GestureType_Enum () { return new Qt_GestureType_Enum (Qt::LastGestureType); }

static gsi::Methods mkdefs_Qt_GestureType () {
  return
    gsi::constant ("TapGesture", &qt_gsi::c_1_Qt_GestureType_Enum, "@brief Enum constant Qt::TapGesture") +
    gsi::constant ("TapAndHoldGesture", &qt_gsi::c_2_Qt_GestureType_Enum, "@brief Enum constant Qt::TapAndHoldGesture") +
    gsi::constant ("PanGesture", &qt_gsi::c_3_Qt_GestureType_Enum, "@brief Enum constant Qt::PanGesture") +
    gsi::constant ("PinchGesture", &qt_gsi::c_4_Qt_GestureType_Enum, "@brief Enum constant Qt::PinchGesture") +
    gsi::constant ("SwipeGesture", &qt_gsi::c_5_Qt_GestureType_Enum, "@brief Enum constant Qt::SwipeGesture") +
    gsi::constant ("CustomGesture", &qt_gsi::c_6_Qt_GestureType_Enum, "@brief Enum constant Qt::CustomGesture") +
    gsi::constant ("LastGestureType", &qt_gsi::c_7_Qt_GestureType_Enum, "@brief Enum constant Qt::LastGestureType");
}

static std::string to_s_Qt_GestureType_Enum (const Qt_GestureType_Enum *e)
{
  if (e->value () == Qt::TapGesture) { return tl::sprintf ("TapGesture (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TapAndHoldGesture) { return tl::sprintf ("TapAndHoldGesture (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::PanGesture) { return tl::sprintf ("PanGesture (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::PinchGesture) { return tl::sprintf ("PinchGesture (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SwipeGesture) { return tl::sprintf ("SwipeGesture (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CustomGesture) { return tl::sprintf ("CustomGesture (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LastGestureType) { return tl::sprintf ("LastGestureType (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_GestureType_Enum (const Qt_GestureType_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_GestureType_Enum *from_i_Qt_GestureType_Enum (unsigned int i)
{
  return new Qt_GestureType_Enum ((Qt::GestureType) i);
}

static bool equalQt_GestureType_Enum (const Qt_GestureType_Enum *e, Qt_GestureType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_GestureType_Enum (const Qt_GestureType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_GestureType_Enums oropQt_GestureType_Enums (const Qt_GestureType_Enums *e, const Qt_GestureType_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_GestureType_Enums andopQt_GestureType_Enums (const Qt_GestureType_Enums *e, const Qt_GestureType_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_GestureType_Enums xoropQt_GestureType_Enums (const Qt_GestureType_Enums *e, const Qt_GestureType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_GestureType_Enums (const Qt_GestureType_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::TapGesture)) { if (!l.empty ()) l += "|"; l += "TapGesture"; }
  if (e->testFlag (Qt::TapAndHoldGesture)) { if (!l.empty ()) l += "|"; l += "TapAndHoldGesture"; }
  if (e->testFlag (Qt::PanGesture)) { if (!l.empty ()) l += "|"; l += "PanGesture"; }
  if (e->testFlag (Qt::PinchGesture)) { if (!l.empty ()) l += "|"; l += "PinchGesture"; }
  if (e->testFlag (Qt::SwipeGesture)) { if (!l.empty ()) l += "|"; l += "SwipeGesture"; }
  if (e->testFlag (Qt::CustomGesture)) { if (!l.empty ()) l += "|"; l += "CustomGesture"; }
  if (e->testFlag (Qt::LastGestureType)) { if (!l.empty ()) l += "|"; l += "LastGestureType"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_GestureType_Enums (const Qt_GestureType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_GestureType_Enums (const Qt_GestureType_Enums *e, const Qt_GestureType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_GestureType_Enums> decl_Qt_GestureType_Enums ("Qt_QFlags_GestureType",
  gsi::method_ext ("|", &qt_gsi::oropQt_GestureType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_GestureType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_GestureType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_GestureType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_GestureType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_GestureType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::GestureType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_GestureType_Enum> decl_Qt_GestureType_Enum (decl_Qt_GestureType_Enums, "Qt_GestureType",
  qt_gsi::mkdefs_Qt_GestureType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_GestureType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_GestureType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_GestureType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_GestureType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_GestureType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::GestureType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_GestureType_Enum_in_parent (qt_gsi::mkdefs_Qt_GestureType ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_GestureType_Enum_as_child (decl_Qt_GestureType_Enum, "GestureType");

}


//  Implementation of the enum wrapper class for Qt::GlobalColor
namespace qt_gsi
{

static Qt_GlobalColor_Enum *c_1_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::color0); }
static Qt_GlobalColor_Enum *c_2_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::color1); }
static Qt_GlobalColor_Enum *c_3_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::black); }
static Qt_GlobalColor_Enum *c_4_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::white); }
static Qt_GlobalColor_Enum *c_5_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::darkGray); }
static Qt_GlobalColor_Enum *c_6_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::gray); }
static Qt_GlobalColor_Enum *c_7_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::lightGray); }
static Qt_GlobalColor_Enum *c_8_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::red); }
static Qt_GlobalColor_Enum *c_9_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::green); }
static Qt_GlobalColor_Enum *c_10_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::blue); }
static Qt_GlobalColor_Enum *c_11_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::cyan); }
static Qt_GlobalColor_Enum *c_12_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::magenta); }
static Qt_GlobalColor_Enum *c_13_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::yellow); }
static Qt_GlobalColor_Enum *c_14_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::darkRed); }
static Qt_GlobalColor_Enum *c_15_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::darkGreen); }
static Qt_GlobalColor_Enum *c_16_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::darkBlue); }
static Qt_GlobalColor_Enum *c_17_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::darkCyan); }
static Qt_GlobalColor_Enum *c_18_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::darkMagenta); }
static Qt_GlobalColor_Enum *c_19_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::darkYellow); }
static Qt_GlobalColor_Enum *c_20_Qt_GlobalColor_Enum () { return new Qt_GlobalColor_Enum (Qt::transparent); }

static gsi::Methods mkdefs_Qt_GlobalColor () {
  return
    gsi::constant ("color0", &qt_gsi::c_1_Qt_GlobalColor_Enum, "@brief Enum constant Qt::color0") +
    gsi::constant ("color1", &qt_gsi::c_2_Qt_GlobalColor_Enum, "@brief Enum constant Qt::color1") +
    gsi::constant ("black", &qt_gsi::c_3_Qt_GlobalColor_Enum, "@brief Enum constant Qt::black") +
    gsi::constant ("white", &qt_gsi::c_4_Qt_GlobalColor_Enum, "@brief Enum constant Qt::white") +
    gsi::constant ("darkGray", &qt_gsi::c_5_Qt_GlobalColor_Enum, "@brief Enum constant Qt::darkGray") +
    gsi::constant ("gray", &qt_gsi::c_6_Qt_GlobalColor_Enum, "@brief Enum constant Qt::gray") +
    gsi::constant ("lightGray", &qt_gsi::c_7_Qt_GlobalColor_Enum, "@brief Enum constant Qt::lightGray") +
    gsi::constant ("red", &qt_gsi::c_8_Qt_GlobalColor_Enum, "@brief Enum constant Qt::red") +
    gsi::constant ("green", &qt_gsi::c_9_Qt_GlobalColor_Enum, "@brief Enum constant Qt::green") +
    gsi::constant ("blue", &qt_gsi::c_10_Qt_GlobalColor_Enum, "@brief Enum constant Qt::blue") +
    gsi::constant ("cyan", &qt_gsi::c_11_Qt_GlobalColor_Enum, "@brief Enum constant Qt::cyan") +
    gsi::constant ("magenta", &qt_gsi::c_12_Qt_GlobalColor_Enum, "@brief Enum constant Qt::magenta") +
    gsi::constant ("yellow", &qt_gsi::c_13_Qt_GlobalColor_Enum, "@brief Enum constant Qt::yellow") +
    gsi::constant ("darkRed", &qt_gsi::c_14_Qt_GlobalColor_Enum, "@brief Enum constant Qt::darkRed") +
    gsi::constant ("darkGreen", &qt_gsi::c_15_Qt_GlobalColor_Enum, "@brief Enum constant Qt::darkGreen") +
    gsi::constant ("darkBlue", &qt_gsi::c_16_Qt_GlobalColor_Enum, "@brief Enum constant Qt::darkBlue") +
    gsi::constant ("darkCyan", &qt_gsi::c_17_Qt_GlobalColor_Enum, "@brief Enum constant Qt::darkCyan") +
    gsi::constant ("darkMagenta", &qt_gsi::c_18_Qt_GlobalColor_Enum, "@brief Enum constant Qt::darkMagenta") +
    gsi::constant ("darkYellow", &qt_gsi::c_19_Qt_GlobalColor_Enum, "@brief Enum constant Qt::darkYellow") +
    gsi::constant ("transparent", &qt_gsi::c_20_Qt_GlobalColor_Enum, "@brief Enum constant Qt::transparent");
}

static std::string to_s_Qt_GlobalColor_Enum (const Qt_GlobalColor_Enum *e)
{
  if (e->value () == Qt::color0) { return tl::sprintf ("color0 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::color1) { return tl::sprintf ("color1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::black) { return tl::sprintf ("black (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::white) { return tl::sprintf ("white (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::darkGray) { return tl::sprintf ("darkGray (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::gray) { return tl::sprintf ("gray (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::lightGray) { return tl::sprintf ("lightGray (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::red) { return tl::sprintf ("red (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::green) { return tl::sprintf ("green (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::blue) { return tl::sprintf ("blue (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::cyan) { return tl::sprintf ("cyan (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::magenta) { return tl::sprintf ("magenta (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::yellow) { return tl::sprintf ("yellow (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::darkRed) { return tl::sprintf ("darkRed (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::darkGreen) { return tl::sprintf ("darkGreen (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::darkBlue) { return tl::sprintf ("darkBlue (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::darkCyan) { return tl::sprintf ("darkCyan (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::darkMagenta) { return tl::sprintf ("darkMagenta (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::darkYellow) { return tl::sprintf ("darkYellow (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::transparent) { return tl::sprintf ("transparent (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_GlobalColor_Enum (const Qt_GlobalColor_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_GlobalColor_Enum *from_i_Qt_GlobalColor_Enum (unsigned int i)
{
  return new Qt_GlobalColor_Enum ((Qt::GlobalColor) i);
}

static bool equalQt_GlobalColor_Enum (const Qt_GlobalColor_Enum *e, Qt_GlobalColor_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_GlobalColor_Enum (const Qt_GlobalColor_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_GlobalColor_Enums oropQt_GlobalColor_Enums (const Qt_GlobalColor_Enums *e, const Qt_GlobalColor_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_GlobalColor_Enums andopQt_GlobalColor_Enums (const Qt_GlobalColor_Enums *e, const Qt_GlobalColor_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_GlobalColor_Enums xoropQt_GlobalColor_Enums (const Qt_GlobalColor_Enums *e, const Qt_GlobalColor_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_GlobalColor_Enums (const Qt_GlobalColor_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::color0)) { if (!l.empty ()) l += "|"; l += "color0"; }
  if (e->testFlag (Qt::color1)) { if (!l.empty ()) l += "|"; l += "color1"; }
  if (e->testFlag (Qt::black)) { if (!l.empty ()) l += "|"; l += "black"; }
  if (e->testFlag (Qt::white)) { if (!l.empty ()) l += "|"; l += "white"; }
  if (e->testFlag (Qt::darkGray)) { if (!l.empty ()) l += "|"; l += "darkGray"; }
  if (e->testFlag (Qt::gray)) { if (!l.empty ()) l += "|"; l += "gray"; }
  if (e->testFlag (Qt::lightGray)) { if (!l.empty ()) l += "|"; l += "lightGray"; }
  if (e->testFlag (Qt::red)) { if (!l.empty ()) l += "|"; l += "red"; }
  if (e->testFlag (Qt::green)) { if (!l.empty ()) l += "|"; l += "green"; }
  if (e->testFlag (Qt::blue)) { if (!l.empty ()) l += "|"; l += "blue"; }
  if (e->testFlag (Qt::cyan)) { if (!l.empty ()) l += "|"; l += "cyan"; }
  if (e->testFlag (Qt::magenta)) { if (!l.empty ()) l += "|"; l += "magenta"; }
  if (e->testFlag (Qt::yellow)) { if (!l.empty ()) l += "|"; l += "yellow"; }
  if (e->testFlag (Qt::darkRed)) { if (!l.empty ()) l += "|"; l += "darkRed"; }
  if (e->testFlag (Qt::darkGreen)) { if (!l.empty ()) l += "|"; l += "darkGreen"; }
  if (e->testFlag (Qt::darkBlue)) { if (!l.empty ()) l += "|"; l += "darkBlue"; }
  if (e->testFlag (Qt::darkCyan)) { if (!l.empty ()) l += "|"; l += "darkCyan"; }
  if (e->testFlag (Qt::darkMagenta)) { if (!l.empty ()) l += "|"; l += "darkMagenta"; }
  if (e->testFlag (Qt::darkYellow)) { if (!l.empty ()) l += "|"; l += "darkYellow"; }
  if (e->testFlag (Qt::transparent)) { if (!l.empty ()) l += "|"; l += "transparent"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_GlobalColor_Enums (const Qt_GlobalColor_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_GlobalColor_Enums (const Qt_GlobalColor_Enums *e, const Qt_GlobalColor_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_GlobalColor_Enums> decl_Qt_GlobalColor_Enums ("Qt_QFlags_GlobalColor",
  gsi::method_ext ("|", &qt_gsi::oropQt_GlobalColor_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_GlobalColor_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_GlobalColor_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_GlobalColor_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_GlobalColor_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_GlobalColor_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::GlobalColor> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_GlobalColor_Enum> decl_Qt_GlobalColor_Enum (decl_Qt_GlobalColor_Enums, "Qt_GlobalColor",
  qt_gsi::mkdefs_Qt_GlobalColor () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_GlobalColor_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_GlobalColor_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_GlobalColor_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_GlobalColor_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_GlobalColor_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::GlobalColor enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_GlobalColor_Enum_in_parent (qt_gsi::mkdefs_Qt_GlobalColor ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_GlobalColor_Enum_as_child (decl_Qt_GlobalColor_Enum, "GlobalColor");

}


//  Implementation of the enum wrapper class for Qt::HitTestAccuracy
namespace qt_gsi
{

static Qt_HitTestAccuracy_Enum *c_1_Qt_HitTestAccuracy_Enum () { return new Qt_HitTestAccuracy_Enum (Qt::ExactHit); }
static Qt_HitTestAccuracy_Enum *c_2_Qt_HitTestAccuracy_Enum () { return new Qt_HitTestAccuracy_Enum (Qt::FuzzyHit); }

static gsi::Methods mkdefs_Qt_HitTestAccuracy () {
  return
    gsi::constant ("ExactHit", &qt_gsi::c_1_Qt_HitTestAccuracy_Enum, "@brief Enum constant Qt::ExactHit") +
    gsi::constant ("FuzzyHit", &qt_gsi::c_2_Qt_HitTestAccuracy_Enum, "@brief Enum constant Qt::FuzzyHit");
}

static std::string to_s_Qt_HitTestAccuracy_Enum (const Qt_HitTestAccuracy_Enum *e)
{
  if (e->value () == Qt::ExactHit) { return tl::sprintf ("ExactHit (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::FuzzyHit) { return tl::sprintf ("FuzzyHit (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_HitTestAccuracy_Enum (const Qt_HitTestAccuracy_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_HitTestAccuracy_Enum *from_i_Qt_HitTestAccuracy_Enum (unsigned int i)
{
  return new Qt_HitTestAccuracy_Enum ((Qt::HitTestAccuracy) i);
}

static bool equalQt_HitTestAccuracy_Enum (const Qt_HitTestAccuracy_Enum *e, Qt_HitTestAccuracy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_HitTestAccuracy_Enum (const Qt_HitTestAccuracy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_HitTestAccuracy_Enums oropQt_HitTestAccuracy_Enums (const Qt_HitTestAccuracy_Enums *e, const Qt_HitTestAccuracy_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_HitTestAccuracy_Enums andopQt_HitTestAccuracy_Enums (const Qt_HitTestAccuracy_Enums *e, const Qt_HitTestAccuracy_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_HitTestAccuracy_Enums xoropQt_HitTestAccuracy_Enums (const Qt_HitTestAccuracy_Enums *e, const Qt_HitTestAccuracy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_HitTestAccuracy_Enums (const Qt_HitTestAccuracy_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::ExactHit)) { if (!l.empty ()) l += "|"; l += "ExactHit"; }
  if (e->testFlag (Qt::FuzzyHit)) { if (!l.empty ()) l += "|"; l += "FuzzyHit"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_HitTestAccuracy_Enums (const Qt_HitTestAccuracy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_HitTestAccuracy_Enums (const Qt_HitTestAccuracy_Enums *e, const Qt_HitTestAccuracy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_HitTestAccuracy_Enums> decl_Qt_HitTestAccuracy_Enums ("Qt_QFlags_HitTestAccuracy",
  gsi::method_ext ("|", &qt_gsi::oropQt_HitTestAccuracy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_HitTestAccuracy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_HitTestAccuracy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_HitTestAccuracy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_HitTestAccuracy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_HitTestAccuracy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::HitTestAccuracy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_HitTestAccuracy_Enum> decl_Qt_HitTestAccuracy_Enum (decl_Qt_HitTestAccuracy_Enums, "Qt_HitTestAccuracy",
  qt_gsi::mkdefs_Qt_HitTestAccuracy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_HitTestAccuracy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_HitTestAccuracy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_HitTestAccuracy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_HitTestAccuracy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_HitTestAccuracy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::HitTestAccuracy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_HitTestAccuracy_Enum_in_parent (qt_gsi::mkdefs_Qt_HitTestAccuracy ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_HitTestAccuracy_Enum_as_child (decl_Qt_HitTestAccuracy_Enum, "HitTestAccuracy");

}


//  Implementation of the enum wrapper class for Qt::ImageConversionFlag
namespace qt_gsi
{

static Qt_ImageConversionFlag_Enum *c_1_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::ColorMode_Mask); }
static Qt_ImageConversionFlag_Enum *c_2_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::AutoColor); }
static Qt_ImageConversionFlag_Enum *c_3_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::ColorOnly); }
static Qt_ImageConversionFlag_Enum *c_4_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::MonoOnly); }
static Qt_ImageConversionFlag_Enum *c_5_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::AlphaDither_Mask); }
static Qt_ImageConversionFlag_Enum *c_6_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::ThresholdAlphaDither); }
static Qt_ImageConversionFlag_Enum *c_7_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::OrderedAlphaDither); }
static Qt_ImageConversionFlag_Enum *c_8_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::DiffuseAlphaDither); }
static Qt_ImageConversionFlag_Enum *c_9_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::NoAlpha); }
static Qt_ImageConversionFlag_Enum *c_10_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::Dither_Mask); }
static Qt_ImageConversionFlag_Enum *c_11_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::DiffuseDither); }
static Qt_ImageConversionFlag_Enum *c_12_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::OrderedDither); }
static Qt_ImageConversionFlag_Enum *c_13_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::ThresholdDither); }
static Qt_ImageConversionFlag_Enum *c_14_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::DitherMode_Mask); }
static Qt_ImageConversionFlag_Enum *c_15_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::AutoDither); }
static Qt_ImageConversionFlag_Enum *c_16_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::PreferDither); }
static Qt_ImageConversionFlag_Enum *c_17_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::AvoidDither); }
static Qt_ImageConversionFlag_Enum *c_18_Qt_ImageConversionFlag_Enum () { return new Qt_ImageConversionFlag_Enum (Qt::NoOpaqueDetection); }

static gsi::Methods mkdefs_Qt_ImageConversionFlag () {
  return
    gsi::constant ("ColorMode_Mask", &qt_gsi::c_1_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::ColorMode_Mask") +
    gsi::constant ("AutoColor", &qt_gsi::c_2_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::AutoColor") +
    gsi::constant ("ColorOnly", &qt_gsi::c_3_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::ColorOnly") +
    gsi::constant ("MonoOnly", &qt_gsi::c_4_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::MonoOnly") +
    gsi::constant ("AlphaDither_Mask", &qt_gsi::c_5_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::AlphaDither_Mask") +
    gsi::constant ("ThresholdAlphaDither", &qt_gsi::c_6_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::ThresholdAlphaDither") +
    gsi::constant ("OrderedAlphaDither", &qt_gsi::c_7_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::OrderedAlphaDither") +
    gsi::constant ("DiffuseAlphaDither", &qt_gsi::c_8_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::DiffuseAlphaDither") +
    gsi::constant ("NoAlpha", &qt_gsi::c_9_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::NoAlpha") +
    gsi::constant ("Dither_Mask", &qt_gsi::c_10_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::Dither_Mask") +
    gsi::constant ("DiffuseDither", &qt_gsi::c_11_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::DiffuseDither") +
    gsi::constant ("OrderedDither", &qt_gsi::c_12_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::OrderedDither") +
    gsi::constant ("ThresholdDither", &qt_gsi::c_13_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::ThresholdDither") +
    gsi::constant ("DitherMode_Mask", &qt_gsi::c_14_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::DitherMode_Mask") +
    gsi::constant ("AutoDither", &qt_gsi::c_15_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::AutoDither") +
    gsi::constant ("PreferDither", &qt_gsi::c_16_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::PreferDither") +
    gsi::constant ("AvoidDither", &qt_gsi::c_17_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::AvoidDither") +
    gsi::constant ("NoOpaqueDetection", &qt_gsi::c_18_Qt_ImageConversionFlag_Enum, "@brief Enum constant Qt::NoOpaqueDetection");
}

static std::string to_s_Qt_ImageConversionFlag_Enum (const Qt_ImageConversionFlag_Enum *e)
{
  if (e->value () == Qt::ColorMode_Mask) { return tl::sprintf ("ColorMode_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AutoColor) { return tl::sprintf ("AutoColor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ColorOnly) { return tl::sprintf ("ColorOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MonoOnly) { return tl::sprintf ("MonoOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AlphaDither_Mask) { return tl::sprintf ("AlphaDither_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ThresholdAlphaDither) { return tl::sprintf ("ThresholdAlphaDither (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::OrderedAlphaDither) { return tl::sprintf ("OrderedAlphaDither (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DiffuseAlphaDither) { return tl::sprintf ("DiffuseAlphaDither (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NoAlpha) { return tl::sprintf ("NoAlpha (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Dither_Mask) { return tl::sprintf ("Dither_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DiffuseDither) { return tl::sprintf ("DiffuseDither (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::OrderedDither) { return tl::sprintf ("OrderedDither (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ThresholdDither) { return tl::sprintf ("ThresholdDither (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DitherMode_Mask) { return tl::sprintf ("DitherMode_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AutoDither) { return tl::sprintf ("AutoDither (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::PreferDither) { return tl::sprintf ("PreferDither (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AvoidDither) { return tl::sprintf ("AvoidDither (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NoOpaqueDetection) { return tl::sprintf ("NoOpaqueDetection (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ImageConversionFlag_Enum (const Qt_ImageConversionFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ImageConversionFlag_Enum *from_i_Qt_ImageConversionFlag_Enum (unsigned int i)
{
  return new Qt_ImageConversionFlag_Enum ((Qt::ImageConversionFlag) i);
}

static bool equalQt_ImageConversionFlag_Enum (const Qt_ImageConversionFlag_Enum *e, Qt_ImageConversionFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ImageConversionFlag_Enum (const Qt_ImageConversionFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ImageConversionFlag_Enums oropQt_ImageConversionFlag_Enums (const Qt_ImageConversionFlag_Enums *e, const Qt_ImageConversionFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ImageConversionFlag_Enums andopQt_ImageConversionFlag_Enums (const Qt_ImageConversionFlag_Enums *e, const Qt_ImageConversionFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ImageConversionFlag_Enums xoropQt_ImageConversionFlag_Enums (const Qt_ImageConversionFlag_Enums *e, const Qt_ImageConversionFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ImageConversionFlag_Enums (const Qt_ImageConversionFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::ColorMode_Mask)) { if (!l.empty ()) l += "|"; l += "ColorMode_Mask"; }
  if (e->testFlag (Qt::AutoColor)) { if (!l.empty ()) l += "|"; l += "AutoColor"; }
  if (e->testFlag (Qt::ColorOnly)) { if (!l.empty ()) l += "|"; l += "ColorOnly"; }
  if (e->testFlag (Qt::MonoOnly)) { if (!l.empty ()) l += "|"; l += "MonoOnly"; }
  if (e->testFlag (Qt::AlphaDither_Mask)) { if (!l.empty ()) l += "|"; l += "AlphaDither_Mask"; }
  if (e->testFlag (Qt::ThresholdAlphaDither)) { if (!l.empty ()) l += "|"; l += "ThresholdAlphaDither"; }
  if (e->testFlag (Qt::OrderedAlphaDither)) { if (!l.empty ()) l += "|"; l += "OrderedAlphaDither"; }
  if (e->testFlag (Qt::DiffuseAlphaDither)) { if (!l.empty ()) l += "|"; l += "DiffuseAlphaDither"; }
  if (e->testFlag (Qt::NoAlpha)) { if (!l.empty ()) l += "|"; l += "NoAlpha"; }
  if (e->testFlag (Qt::Dither_Mask)) { if (!l.empty ()) l += "|"; l += "Dither_Mask"; }
  if (e->testFlag (Qt::DiffuseDither)) { if (!l.empty ()) l += "|"; l += "DiffuseDither"; }
  if (e->testFlag (Qt::OrderedDither)) { if (!l.empty ()) l += "|"; l += "OrderedDither"; }
  if (e->testFlag (Qt::ThresholdDither)) { if (!l.empty ()) l += "|"; l += "ThresholdDither"; }
  if (e->testFlag (Qt::DitherMode_Mask)) { if (!l.empty ()) l += "|"; l += "DitherMode_Mask"; }
  if (e->testFlag (Qt::AutoDither)) { if (!l.empty ()) l += "|"; l += "AutoDither"; }
  if (e->testFlag (Qt::PreferDither)) { if (!l.empty ()) l += "|"; l += "PreferDither"; }
  if (e->testFlag (Qt::AvoidDither)) { if (!l.empty ()) l += "|"; l += "AvoidDither"; }
  if (e->testFlag (Qt::NoOpaqueDetection)) { if (!l.empty ()) l += "|"; l += "NoOpaqueDetection"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ImageConversionFlag_Enums (const Qt_ImageConversionFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ImageConversionFlag_Enums (const Qt_ImageConversionFlag_Enums *e, const Qt_ImageConversionFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ImageConversionFlag_Enums> decl_Qt_ImageConversionFlag_Enums ("Qt_QFlags_ImageConversionFlag",
  gsi::method_ext ("|", &qt_gsi::oropQt_ImageConversionFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ImageConversionFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ImageConversionFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ImageConversionFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ImageConversionFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ImageConversionFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ImageConversionFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ImageConversionFlag_Enum> decl_Qt_ImageConversionFlag_Enum (decl_Qt_ImageConversionFlag_Enums, "Qt_ImageConversionFlag",
  qt_gsi::mkdefs_Qt_ImageConversionFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ImageConversionFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ImageConversionFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ImageConversionFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ImageConversionFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ImageConversionFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ImageConversionFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ImageConversionFlag_Enum_in_parent (qt_gsi::mkdefs_Qt_ImageConversionFlag ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ImageConversionFlag_Enum_as_child (decl_Qt_ImageConversionFlag_Enum, "ImageConversionFlag");

}


//  Implementation of the enum wrapper class for Qt::Initialization
namespace qt_gsi
{

static Qt_Initialization_Enum *c_1_Qt_Initialization_Enum () { return new Qt_Initialization_Enum (Qt::Uninitialized); }

static gsi::Methods mkdefs_Qt_Initialization () {
  return
    gsi::constant ("Uninitialized", &qt_gsi::c_1_Qt_Initialization_Enum, "@brief Enum constant Qt::Uninitialized");
}

static std::string to_s_Qt_Initialization_Enum (const Qt_Initialization_Enum *e)
{
  if (e->value () == Qt::Uninitialized) { return tl::sprintf ("Uninitialized (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_Initialization_Enum (const Qt_Initialization_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_Initialization_Enum *from_i_Qt_Initialization_Enum (unsigned int i)
{
  return new Qt_Initialization_Enum ((Qt::Initialization) i);
}

static bool equalQt_Initialization_Enum (const Qt_Initialization_Enum *e, Qt_Initialization_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_Initialization_Enum (const Qt_Initialization_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_Initialization_Enums oropQt_Initialization_Enums (const Qt_Initialization_Enums *e, const Qt_Initialization_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_Initialization_Enums andopQt_Initialization_Enums (const Qt_Initialization_Enums *e, const Qt_Initialization_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_Initialization_Enums xoropQt_Initialization_Enums (const Qt_Initialization_Enums *e, const Qt_Initialization_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_Initialization_Enums (const Qt_Initialization_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::Uninitialized)) { if (!l.empty ()) l += "|"; l += "Uninitialized"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_Initialization_Enums (const Qt_Initialization_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_Initialization_Enums (const Qt_Initialization_Enums *e, const Qt_Initialization_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_Initialization_Enums> decl_Qt_Initialization_Enums ("Qt_QFlags_Initialization",
  gsi::method_ext ("|", &qt_gsi::oropQt_Initialization_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_Initialization_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_Initialization_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Initialization_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Initialization_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_Initialization_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::Initialization> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_Initialization_Enum> decl_Qt_Initialization_Enum (decl_Qt_Initialization_Enums, "Qt_Initialization",
  qt_gsi::mkdefs_Qt_Initialization () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Initialization_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Initialization_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_Initialization_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_Initialization_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_Initialization_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::Initialization enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_Initialization_Enum_in_parent (qt_gsi::mkdefs_Qt_Initialization ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_Initialization_Enum_as_child (decl_Qt_Initialization_Enum, "Initialization");

}


//  Implementation of the enum wrapper class for Qt::InputMethodHint
namespace qt_gsi
{

static Qt_InputMethodHint_Enum *c_1_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhNone); }
static Qt_InputMethodHint_Enum *c_2_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhHiddenText); }
static Qt_InputMethodHint_Enum *c_3_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhNoAutoUppercase); }
static Qt_InputMethodHint_Enum *c_4_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhPreferNumbers); }
static Qt_InputMethodHint_Enum *c_5_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhPreferUppercase); }
static Qt_InputMethodHint_Enum *c_6_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhPreferLowercase); }
static Qt_InputMethodHint_Enum *c_7_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhNoPredictiveText); }
static Qt_InputMethodHint_Enum *c_8_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhDigitsOnly); }
static Qt_InputMethodHint_Enum *c_9_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhFormattedNumbersOnly); }
static Qt_InputMethodHint_Enum *c_10_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhUppercaseOnly); }
static Qt_InputMethodHint_Enum *c_11_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhLowercaseOnly); }
static Qt_InputMethodHint_Enum *c_12_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhDialableCharactersOnly); }
static Qt_InputMethodHint_Enum *c_13_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhEmailCharactersOnly); }
static Qt_InputMethodHint_Enum *c_14_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhUrlCharactersOnly); }
static Qt_InputMethodHint_Enum *c_15_Qt_InputMethodHint_Enum () { return new Qt_InputMethodHint_Enum (Qt::ImhExclusiveInputMask); }

static gsi::Methods mkdefs_Qt_InputMethodHint () {
  return
    gsi::constant ("ImhNone", &qt_gsi::c_1_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhNone") +
    gsi::constant ("ImhHiddenText", &qt_gsi::c_2_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhHiddenText") +
    gsi::constant ("ImhNoAutoUppercase", &qt_gsi::c_3_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhNoAutoUppercase") +
    gsi::constant ("ImhPreferNumbers", &qt_gsi::c_4_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhPreferNumbers") +
    gsi::constant ("ImhPreferUppercase", &qt_gsi::c_5_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhPreferUppercase") +
    gsi::constant ("ImhPreferLowercase", &qt_gsi::c_6_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhPreferLowercase") +
    gsi::constant ("ImhNoPredictiveText", &qt_gsi::c_7_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhNoPredictiveText") +
    gsi::constant ("ImhDigitsOnly", &qt_gsi::c_8_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhDigitsOnly") +
    gsi::constant ("ImhFormattedNumbersOnly", &qt_gsi::c_9_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhFormattedNumbersOnly") +
    gsi::constant ("ImhUppercaseOnly", &qt_gsi::c_10_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhUppercaseOnly") +
    gsi::constant ("ImhLowercaseOnly", &qt_gsi::c_11_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhLowercaseOnly") +
    gsi::constant ("ImhDialableCharactersOnly", &qt_gsi::c_12_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhDialableCharactersOnly") +
    gsi::constant ("ImhEmailCharactersOnly", &qt_gsi::c_13_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhEmailCharactersOnly") +
    gsi::constant ("ImhUrlCharactersOnly", &qt_gsi::c_14_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhUrlCharactersOnly") +
    gsi::constant ("ImhExclusiveInputMask", &qt_gsi::c_15_Qt_InputMethodHint_Enum, "@brief Enum constant Qt::ImhExclusiveInputMask");
}

static std::string to_s_Qt_InputMethodHint_Enum (const Qt_InputMethodHint_Enum *e)
{
  if (e->value () == Qt::ImhNone) { return tl::sprintf ("ImhNone (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhHiddenText) { return tl::sprintf ("ImhHiddenText (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhNoAutoUppercase) { return tl::sprintf ("ImhNoAutoUppercase (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhPreferNumbers) { return tl::sprintf ("ImhPreferNumbers (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhPreferUppercase) { return tl::sprintf ("ImhPreferUppercase (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhPreferLowercase) { return tl::sprintf ("ImhPreferLowercase (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhNoPredictiveText) { return tl::sprintf ("ImhNoPredictiveText (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhDigitsOnly) { return tl::sprintf ("ImhDigitsOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhFormattedNumbersOnly) { return tl::sprintf ("ImhFormattedNumbersOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhUppercaseOnly) { return tl::sprintf ("ImhUppercaseOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhLowercaseOnly) { return tl::sprintf ("ImhLowercaseOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhDialableCharactersOnly) { return tl::sprintf ("ImhDialableCharactersOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhEmailCharactersOnly) { return tl::sprintf ("ImhEmailCharactersOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhUrlCharactersOnly) { return tl::sprintf ("ImhUrlCharactersOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImhExclusiveInputMask) { return tl::sprintf ("ImhExclusiveInputMask (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_InputMethodHint_Enum (const Qt_InputMethodHint_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_InputMethodHint_Enum *from_i_Qt_InputMethodHint_Enum (unsigned int i)
{
  return new Qt_InputMethodHint_Enum ((Qt::InputMethodHint) i);
}

static bool equalQt_InputMethodHint_Enum (const Qt_InputMethodHint_Enum *e, Qt_InputMethodHint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_InputMethodHint_Enum (const Qt_InputMethodHint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_InputMethodHint_Enums oropQt_InputMethodHint_Enums (const Qt_InputMethodHint_Enums *e, const Qt_InputMethodHint_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_InputMethodHint_Enums andopQt_InputMethodHint_Enums (const Qt_InputMethodHint_Enums *e, const Qt_InputMethodHint_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_InputMethodHint_Enums xoropQt_InputMethodHint_Enums (const Qt_InputMethodHint_Enums *e, const Qt_InputMethodHint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_InputMethodHint_Enums (const Qt_InputMethodHint_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::ImhNone)) { if (!l.empty ()) l += "|"; l += "ImhNone"; }
  if (e->testFlag (Qt::ImhHiddenText)) { if (!l.empty ()) l += "|"; l += "ImhHiddenText"; }
  if (e->testFlag (Qt::ImhNoAutoUppercase)) { if (!l.empty ()) l += "|"; l += "ImhNoAutoUppercase"; }
  if (e->testFlag (Qt::ImhPreferNumbers)) { if (!l.empty ()) l += "|"; l += "ImhPreferNumbers"; }
  if (e->testFlag (Qt::ImhPreferUppercase)) { if (!l.empty ()) l += "|"; l += "ImhPreferUppercase"; }
  if (e->testFlag (Qt::ImhPreferLowercase)) { if (!l.empty ()) l += "|"; l += "ImhPreferLowercase"; }
  if (e->testFlag (Qt::ImhNoPredictiveText)) { if (!l.empty ()) l += "|"; l += "ImhNoPredictiveText"; }
  if (e->testFlag (Qt::ImhDigitsOnly)) { if (!l.empty ()) l += "|"; l += "ImhDigitsOnly"; }
  if (e->testFlag (Qt::ImhFormattedNumbersOnly)) { if (!l.empty ()) l += "|"; l += "ImhFormattedNumbersOnly"; }
  if (e->testFlag (Qt::ImhUppercaseOnly)) { if (!l.empty ()) l += "|"; l += "ImhUppercaseOnly"; }
  if (e->testFlag (Qt::ImhLowercaseOnly)) { if (!l.empty ()) l += "|"; l += "ImhLowercaseOnly"; }
  if (e->testFlag (Qt::ImhDialableCharactersOnly)) { if (!l.empty ()) l += "|"; l += "ImhDialableCharactersOnly"; }
  if (e->testFlag (Qt::ImhEmailCharactersOnly)) { if (!l.empty ()) l += "|"; l += "ImhEmailCharactersOnly"; }
  if (e->testFlag (Qt::ImhUrlCharactersOnly)) { if (!l.empty ()) l += "|"; l += "ImhUrlCharactersOnly"; }
  if (e->testFlag (Qt::ImhExclusiveInputMask)) { if (!l.empty ()) l += "|"; l += "ImhExclusiveInputMask"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_InputMethodHint_Enums (const Qt_InputMethodHint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_InputMethodHint_Enums (const Qt_InputMethodHint_Enums *e, const Qt_InputMethodHint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_InputMethodHint_Enums> decl_Qt_InputMethodHint_Enums ("Qt_QFlags_InputMethodHint",
  gsi::method_ext ("|", &qt_gsi::oropQt_InputMethodHint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_InputMethodHint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_InputMethodHint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_InputMethodHint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_InputMethodHint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_InputMethodHint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::InputMethodHint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_InputMethodHint_Enum> decl_Qt_InputMethodHint_Enum (decl_Qt_InputMethodHint_Enums, "Qt_InputMethodHint",
  qt_gsi::mkdefs_Qt_InputMethodHint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_InputMethodHint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_InputMethodHint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_InputMethodHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_InputMethodHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_InputMethodHint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::InputMethodHint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_InputMethodHint_Enum_in_parent (qt_gsi::mkdefs_Qt_InputMethodHint ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_InputMethodHint_Enum_as_child (decl_Qt_InputMethodHint_Enum, "InputMethodHint");

}


//  Implementation of the enum wrapper class for Qt::InputMethodQuery
namespace qt_gsi
{

static Qt_InputMethodQuery_Enum *c_1_Qt_InputMethodQuery_Enum () { return new Qt_InputMethodQuery_Enum (Qt::ImMicroFocus); }
static Qt_InputMethodQuery_Enum *c_2_Qt_InputMethodQuery_Enum () { return new Qt_InputMethodQuery_Enum (Qt::ImFont); }
static Qt_InputMethodQuery_Enum *c_3_Qt_InputMethodQuery_Enum () { return new Qt_InputMethodQuery_Enum (Qt::ImCursorPosition); }
static Qt_InputMethodQuery_Enum *c_4_Qt_InputMethodQuery_Enum () { return new Qt_InputMethodQuery_Enum (Qt::ImSurroundingText); }
static Qt_InputMethodQuery_Enum *c_5_Qt_InputMethodQuery_Enum () { return new Qt_InputMethodQuery_Enum (Qt::ImCurrentSelection); }
static Qt_InputMethodQuery_Enum *c_6_Qt_InputMethodQuery_Enum () { return new Qt_InputMethodQuery_Enum (Qt::ImMaximumTextLength); }
static Qt_InputMethodQuery_Enum *c_7_Qt_InputMethodQuery_Enum () { return new Qt_InputMethodQuery_Enum (Qt::ImAnchorPosition); }

static gsi::Methods mkdefs_Qt_InputMethodQuery () {
  return
    gsi::constant ("ImMicroFocus", &qt_gsi::c_1_Qt_InputMethodQuery_Enum, "@brief Enum constant Qt::ImMicroFocus") +
    gsi::constant ("ImFont", &qt_gsi::c_2_Qt_InputMethodQuery_Enum, "@brief Enum constant Qt::ImFont") +
    gsi::constant ("ImCursorPosition", &qt_gsi::c_3_Qt_InputMethodQuery_Enum, "@brief Enum constant Qt::ImCursorPosition") +
    gsi::constant ("ImSurroundingText", &qt_gsi::c_4_Qt_InputMethodQuery_Enum, "@brief Enum constant Qt::ImSurroundingText") +
    gsi::constant ("ImCurrentSelection", &qt_gsi::c_5_Qt_InputMethodQuery_Enum, "@brief Enum constant Qt::ImCurrentSelection") +
    gsi::constant ("ImMaximumTextLength", &qt_gsi::c_6_Qt_InputMethodQuery_Enum, "@brief Enum constant Qt::ImMaximumTextLength") +
    gsi::constant ("ImAnchorPosition", &qt_gsi::c_7_Qt_InputMethodQuery_Enum, "@brief Enum constant Qt::ImAnchorPosition");
}

static std::string to_s_Qt_InputMethodQuery_Enum (const Qt_InputMethodQuery_Enum *e)
{
  if (e->value () == Qt::ImMicroFocus) { return tl::sprintf ("ImMicroFocus (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImFont) { return tl::sprintf ("ImFont (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImCursorPosition) { return tl::sprintf ("ImCursorPosition (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImSurroundingText) { return tl::sprintf ("ImSurroundingText (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImCurrentSelection) { return tl::sprintf ("ImCurrentSelection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImMaximumTextLength) { return tl::sprintf ("ImMaximumTextLength (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ImAnchorPosition) { return tl::sprintf ("ImAnchorPosition (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_InputMethodQuery_Enum (const Qt_InputMethodQuery_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_InputMethodQuery_Enum *from_i_Qt_InputMethodQuery_Enum (unsigned int i)
{
  return new Qt_InputMethodQuery_Enum ((Qt::InputMethodQuery) i);
}

static bool equalQt_InputMethodQuery_Enum (const Qt_InputMethodQuery_Enum *e, Qt_InputMethodQuery_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_InputMethodQuery_Enum (const Qt_InputMethodQuery_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_InputMethodQuery_Enums oropQt_InputMethodQuery_Enums (const Qt_InputMethodQuery_Enums *e, const Qt_InputMethodQuery_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_InputMethodQuery_Enums andopQt_InputMethodQuery_Enums (const Qt_InputMethodQuery_Enums *e, const Qt_InputMethodQuery_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_InputMethodQuery_Enums xoropQt_InputMethodQuery_Enums (const Qt_InputMethodQuery_Enums *e, const Qt_InputMethodQuery_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_InputMethodQuery_Enums (const Qt_InputMethodQuery_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::ImMicroFocus)) { if (!l.empty ()) l += "|"; l += "ImMicroFocus"; }
  if (e->testFlag (Qt::ImFont)) { if (!l.empty ()) l += "|"; l += "ImFont"; }
  if (e->testFlag (Qt::ImCursorPosition)) { if (!l.empty ()) l += "|"; l += "ImCursorPosition"; }
  if (e->testFlag (Qt::ImSurroundingText)) { if (!l.empty ()) l += "|"; l += "ImSurroundingText"; }
  if (e->testFlag (Qt::ImCurrentSelection)) { if (!l.empty ()) l += "|"; l += "ImCurrentSelection"; }
  if (e->testFlag (Qt::ImMaximumTextLength)) { if (!l.empty ()) l += "|"; l += "ImMaximumTextLength"; }
  if (e->testFlag (Qt::ImAnchorPosition)) { if (!l.empty ()) l += "|"; l += "ImAnchorPosition"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_InputMethodQuery_Enums (const Qt_InputMethodQuery_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_InputMethodQuery_Enums (const Qt_InputMethodQuery_Enums *e, const Qt_InputMethodQuery_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_InputMethodQuery_Enums> decl_Qt_InputMethodQuery_Enums ("Qt_QFlags_InputMethodQuery",
  gsi::method_ext ("|", &qt_gsi::oropQt_InputMethodQuery_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_InputMethodQuery_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_InputMethodQuery_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_InputMethodQuery_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_InputMethodQuery_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_InputMethodQuery_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::InputMethodQuery> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_InputMethodQuery_Enum> decl_Qt_InputMethodQuery_Enum (decl_Qt_InputMethodQuery_Enums, "Qt_InputMethodQuery",
  qt_gsi::mkdefs_Qt_InputMethodQuery () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_InputMethodQuery_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_InputMethodQuery_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_InputMethodQuery_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_InputMethodQuery_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_InputMethodQuery_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::InputMethodQuery enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_InputMethodQuery_Enum_in_parent (qt_gsi::mkdefs_Qt_InputMethodQuery ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_InputMethodQuery_Enum_as_child (decl_Qt_InputMethodQuery_Enum, "InputMethodQuery");

}


//  Implementation of the enum wrapper class for Qt::ItemDataRole
namespace qt_gsi
{

static Qt_ItemDataRole_Enum *c_1_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::DisplayRole); }
static Qt_ItemDataRole_Enum *c_2_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::DecorationRole); }
static Qt_ItemDataRole_Enum *c_3_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::EditRole); }
static Qt_ItemDataRole_Enum *c_4_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::ToolTipRole); }
static Qt_ItemDataRole_Enum *c_5_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::StatusTipRole); }
static Qt_ItemDataRole_Enum *c_6_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::WhatsThisRole); }
static Qt_ItemDataRole_Enum *c_7_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::FontRole); }
static Qt_ItemDataRole_Enum *c_8_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::TextAlignmentRole); }
static Qt_ItemDataRole_Enum *c_9_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::BackgroundColorRole); }
static Qt_ItemDataRole_Enum *c_10_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::BackgroundRole); }
static Qt_ItemDataRole_Enum *c_11_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::TextColorRole); }
static Qt_ItemDataRole_Enum *c_12_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::ForegroundRole); }
static Qt_ItemDataRole_Enum *c_13_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::CheckStateRole); }
static Qt_ItemDataRole_Enum *c_14_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::AccessibleTextRole); }
static Qt_ItemDataRole_Enum *c_15_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::AccessibleDescriptionRole); }
static Qt_ItemDataRole_Enum *c_16_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::SizeHintRole); }
static Qt_ItemDataRole_Enum *c_17_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::DisplayPropertyRole); }
static Qt_ItemDataRole_Enum *c_18_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::DecorationPropertyRole); }
static Qt_ItemDataRole_Enum *c_19_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::ToolTipPropertyRole); }
static Qt_ItemDataRole_Enum *c_20_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::StatusTipPropertyRole); }
static Qt_ItemDataRole_Enum *c_21_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::WhatsThisPropertyRole); }
static Qt_ItemDataRole_Enum *c_22_Qt_ItemDataRole_Enum () { return new Qt_ItemDataRole_Enum (Qt::UserRole); }

static gsi::Methods mkdefs_Qt_ItemDataRole () {
  return
    gsi::constant ("DisplayRole", &qt_gsi::c_1_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::DisplayRole") +
    gsi::constant ("DecorationRole", &qt_gsi::c_2_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::DecorationRole") +
    gsi::constant ("EditRole", &qt_gsi::c_3_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::EditRole") +
    gsi::constant ("ToolTipRole", &qt_gsi::c_4_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::ToolTipRole") +
    gsi::constant ("StatusTipRole", &qt_gsi::c_5_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::StatusTipRole") +
    gsi::constant ("WhatsThisRole", &qt_gsi::c_6_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::WhatsThisRole") +
    gsi::constant ("FontRole", &qt_gsi::c_7_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::FontRole") +
    gsi::constant ("TextAlignmentRole", &qt_gsi::c_8_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::TextAlignmentRole") +
    gsi::constant ("BackgroundColorRole", &qt_gsi::c_9_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::BackgroundColorRole") +
    gsi::constant ("BackgroundRole", &qt_gsi::c_10_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::BackgroundRole") +
    gsi::constant ("TextColorRole", &qt_gsi::c_11_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::TextColorRole") +
    gsi::constant ("ForegroundRole", &qt_gsi::c_12_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::ForegroundRole") +
    gsi::constant ("CheckStateRole", &qt_gsi::c_13_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::CheckStateRole") +
    gsi::constant ("AccessibleTextRole", &qt_gsi::c_14_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::AccessibleTextRole") +
    gsi::constant ("AccessibleDescriptionRole", &qt_gsi::c_15_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::AccessibleDescriptionRole") +
    gsi::constant ("SizeHintRole", &qt_gsi::c_16_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::SizeHintRole") +
    gsi::constant ("DisplayPropertyRole", &qt_gsi::c_17_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::DisplayPropertyRole") +
    gsi::constant ("DecorationPropertyRole", &qt_gsi::c_18_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::DecorationPropertyRole") +
    gsi::constant ("ToolTipPropertyRole", &qt_gsi::c_19_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::ToolTipPropertyRole") +
    gsi::constant ("StatusTipPropertyRole", &qt_gsi::c_20_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::StatusTipPropertyRole") +
    gsi::constant ("WhatsThisPropertyRole", &qt_gsi::c_21_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::WhatsThisPropertyRole") +
    gsi::constant ("UserRole", &qt_gsi::c_22_Qt_ItemDataRole_Enum, "@brief Enum constant Qt::UserRole");
}

static std::string to_s_Qt_ItemDataRole_Enum (const Qt_ItemDataRole_Enum *e)
{
  if (e->value () == Qt::DisplayRole) { return tl::sprintf ("DisplayRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DecorationRole) { return tl::sprintf ("DecorationRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::EditRole) { return tl::sprintf ("EditRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ToolTipRole) { return tl::sprintf ("ToolTipRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::StatusTipRole) { return tl::sprintf ("StatusTipRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WhatsThisRole) { return tl::sprintf ("WhatsThisRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::FontRole) { return tl::sprintf ("FontRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextAlignmentRole) { return tl::sprintf ("TextAlignmentRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BackgroundColorRole) { return tl::sprintf ("BackgroundColorRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BackgroundRole) { return tl::sprintf ("BackgroundRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextColorRole) { return tl::sprintf ("TextColorRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ForegroundRole) { return tl::sprintf ("ForegroundRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CheckStateRole) { return tl::sprintf ("CheckStateRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AccessibleTextRole) { return tl::sprintf ("AccessibleTextRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AccessibleDescriptionRole) { return tl::sprintf ("AccessibleDescriptionRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SizeHintRole) { return tl::sprintf ("SizeHintRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DisplayPropertyRole) { return tl::sprintf ("DisplayPropertyRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DecorationPropertyRole) { return tl::sprintf ("DecorationPropertyRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ToolTipPropertyRole) { return tl::sprintf ("ToolTipPropertyRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::StatusTipPropertyRole) { return tl::sprintf ("StatusTipPropertyRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WhatsThisPropertyRole) { return tl::sprintf ("WhatsThisPropertyRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UserRole) { return tl::sprintf ("UserRole (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ItemDataRole_Enum (const Qt_ItemDataRole_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ItemDataRole_Enum *from_i_Qt_ItemDataRole_Enum (unsigned int i)
{
  return new Qt_ItemDataRole_Enum ((Qt::ItemDataRole) i);
}

static bool equalQt_ItemDataRole_Enum (const Qt_ItemDataRole_Enum *e, Qt_ItemDataRole_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ItemDataRole_Enum (const Qt_ItemDataRole_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ItemDataRole_Enums oropQt_ItemDataRole_Enums (const Qt_ItemDataRole_Enums *e, const Qt_ItemDataRole_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ItemDataRole_Enums andopQt_ItemDataRole_Enums (const Qt_ItemDataRole_Enums *e, const Qt_ItemDataRole_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ItemDataRole_Enums xoropQt_ItemDataRole_Enums (const Qt_ItemDataRole_Enums *e, const Qt_ItemDataRole_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ItemDataRole_Enums (const Qt_ItemDataRole_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::DisplayRole)) { if (!l.empty ()) l += "|"; l += "DisplayRole"; }
  if (e->testFlag (Qt::DecorationRole)) { if (!l.empty ()) l += "|"; l += "DecorationRole"; }
  if (e->testFlag (Qt::EditRole)) { if (!l.empty ()) l += "|"; l += "EditRole"; }
  if (e->testFlag (Qt::ToolTipRole)) { if (!l.empty ()) l += "|"; l += "ToolTipRole"; }
  if (e->testFlag (Qt::StatusTipRole)) { if (!l.empty ()) l += "|"; l += "StatusTipRole"; }
  if (e->testFlag (Qt::WhatsThisRole)) { if (!l.empty ()) l += "|"; l += "WhatsThisRole"; }
  if (e->testFlag (Qt::FontRole)) { if (!l.empty ()) l += "|"; l += "FontRole"; }
  if (e->testFlag (Qt::TextAlignmentRole)) { if (!l.empty ()) l += "|"; l += "TextAlignmentRole"; }
  if (e->testFlag (Qt::BackgroundColorRole)) { if (!l.empty ()) l += "|"; l += "BackgroundColorRole"; }
  if (e->testFlag (Qt::BackgroundRole)) { if (!l.empty ()) l += "|"; l += "BackgroundRole"; }
  if (e->testFlag (Qt::TextColorRole)) { if (!l.empty ()) l += "|"; l += "TextColorRole"; }
  if (e->testFlag (Qt::ForegroundRole)) { if (!l.empty ()) l += "|"; l += "ForegroundRole"; }
  if (e->testFlag (Qt::CheckStateRole)) { if (!l.empty ()) l += "|"; l += "CheckStateRole"; }
  if (e->testFlag (Qt::AccessibleTextRole)) { if (!l.empty ()) l += "|"; l += "AccessibleTextRole"; }
  if (e->testFlag (Qt::AccessibleDescriptionRole)) { if (!l.empty ()) l += "|"; l += "AccessibleDescriptionRole"; }
  if (e->testFlag (Qt::SizeHintRole)) { if (!l.empty ()) l += "|"; l += "SizeHintRole"; }
  if (e->testFlag (Qt::DisplayPropertyRole)) { if (!l.empty ()) l += "|"; l += "DisplayPropertyRole"; }
  if (e->testFlag (Qt::DecorationPropertyRole)) { if (!l.empty ()) l += "|"; l += "DecorationPropertyRole"; }
  if (e->testFlag (Qt::ToolTipPropertyRole)) { if (!l.empty ()) l += "|"; l += "ToolTipPropertyRole"; }
  if (e->testFlag (Qt::StatusTipPropertyRole)) { if (!l.empty ()) l += "|"; l += "StatusTipPropertyRole"; }
  if (e->testFlag (Qt::WhatsThisPropertyRole)) { if (!l.empty ()) l += "|"; l += "WhatsThisPropertyRole"; }
  if (e->testFlag (Qt::UserRole)) { if (!l.empty ()) l += "|"; l += "UserRole"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ItemDataRole_Enums (const Qt_ItemDataRole_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ItemDataRole_Enums (const Qt_ItemDataRole_Enums *e, const Qt_ItemDataRole_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ItemDataRole_Enums> decl_Qt_ItemDataRole_Enums ("Qt_QFlags_ItemDataRole",
  gsi::method_ext ("|", &qt_gsi::oropQt_ItemDataRole_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ItemDataRole_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ItemDataRole_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ItemDataRole_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ItemDataRole_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ItemDataRole_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ItemDataRole> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ItemDataRole_Enum> decl_Qt_ItemDataRole_Enum (decl_Qt_ItemDataRole_Enums, "Qt_ItemDataRole",
  qt_gsi::mkdefs_Qt_ItemDataRole () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ItemDataRole_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ItemDataRole_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ItemDataRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ItemDataRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ItemDataRole_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ItemDataRole enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ItemDataRole_Enum_in_parent (qt_gsi::mkdefs_Qt_ItemDataRole ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ItemDataRole_Enum_as_child (decl_Qt_ItemDataRole_Enum, "ItemDataRole");

}


//  Implementation of the enum wrapper class for Qt::ItemFlag
namespace qt_gsi
{

static Qt_ItemFlag_Enum *c_1_Qt_ItemFlag_Enum () { return new Qt_ItemFlag_Enum (Qt::NoItemFlags); }
static Qt_ItemFlag_Enum *c_2_Qt_ItemFlag_Enum () { return new Qt_ItemFlag_Enum (Qt::ItemIsSelectable); }
static Qt_ItemFlag_Enum *c_3_Qt_ItemFlag_Enum () { return new Qt_ItemFlag_Enum (Qt::ItemIsEditable); }
static Qt_ItemFlag_Enum *c_4_Qt_ItemFlag_Enum () { return new Qt_ItemFlag_Enum (Qt::ItemIsDragEnabled); }
static Qt_ItemFlag_Enum *c_5_Qt_ItemFlag_Enum () { return new Qt_ItemFlag_Enum (Qt::ItemIsDropEnabled); }
static Qt_ItemFlag_Enum *c_6_Qt_ItemFlag_Enum () { return new Qt_ItemFlag_Enum (Qt::ItemIsUserCheckable); }
static Qt_ItemFlag_Enum *c_7_Qt_ItemFlag_Enum () { return new Qt_ItemFlag_Enum (Qt::ItemIsEnabled); }
static Qt_ItemFlag_Enum *c_8_Qt_ItemFlag_Enum () { return new Qt_ItemFlag_Enum (Qt::ItemIsTristate); }

static gsi::Methods mkdefs_Qt_ItemFlag () {
  return
    gsi::constant ("NoItemFlags", &qt_gsi::c_1_Qt_ItemFlag_Enum, "@brief Enum constant Qt::NoItemFlags") +
    gsi::constant ("ItemIsSelectable", &qt_gsi::c_2_Qt_ItemFlag_Enum, "@brief Enum constant Qt::ItemIsSelectable") +
    gsi::constant ("ItemIsEditable", &qt_gsi::c_3_Qt_ItemFlag_Enum, "@brief Enum constant Qt::ItemIsEditable") +
    gsi::constant ("ItemIsDragEnabled", &qt_gsi::c_4_Qt_ItemFlag_Enum, "@brief Enum constant Qt::ItemIsDragEnabled") +
    gsi::constant ("ItemIsDropEnabled", &qt_gsi::c_5_Qt_ItemFlag_Enum, "@brief Enum constant Qt::ItemIsDropEnabled") +
    gsi::constant ("ItemIsUserCheckable", &qt_gsi::c_6_Qt_ItemFlag_Enum, "@brief Enum constant Qt::ItemIsUserCheckable") +
    gsi::constant ("ItemIsEnabled", &qt_gsi::c_7_Qt_ItemFlag_Enum, "@brief Enum constant Qt::ItemIsEnabled") +
    gsi::constant ("ItemIsTristate", &qt_gsi::c_8_Qt_ItemFlag_Enum, "@brief Enum constant Qt::ItemIsTristate");
}

static std::string to_s_Qt_ItemFlag_Enum (const Qt_ItemFlag_Enum *e)
{
  if (e->value () == Qt::NoItemFlags) { return tl::sprintf ("NoItemFlags (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ItemIsSelectable) { return tl::sprintf ("ItemIsSelectable (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ItemIsEditable) { return tl::sprintf ("ItemIsEditable (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ItemIsDragEnabled) { return tl::sprintf ("ItemIsDragEnabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ItemIsDropEnabled) { return tl::sprintf ("ItemIsDropEnabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ItemIsUserCheckable) { return tl::sprintf ("ItemIsUserCheckable (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ItemIsEnabled) { return tl::sprintf ("ItemIsEnabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ItemIsTristate) { return tl::sprintf ("ItemIsTristate (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ItemFlag_Enum (const Qt_ItemFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ItemFlag_Enum *from_i_Qt_ItemFlag_Enum (unsigned int i)
{
  return new Qt_ItemFlag_Enum ((Qt::ItemFlag) i);
}

static bool equalQt_ItemFlag_Enum (const Qt_ItemFlag_Enum *e, Qt_ItemFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ItemFlag_Enum (const Qt_ItemFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ItemFlag_Enums oropQt_ItemFlag_Enums (const Qt_ItemFlag_Enums *e, const Qt_ItemFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ItemFlag_Enums andopQt_ItemFlag_Enums (const Qt_ItemFlag_Enums *e, const Qt_ItemFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ItemFlag_Enums xoropQt_ItemFlag_Enums (const Qt_ItemFlag_Enums *e, const Qt_ItemFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ItemFlag_Enums (const Qt_ItemFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoItemFlags)) { if (!l.empty ()) l += "|"; l += "NoItemFlags"; }
  if (e->testFlag (Qt::ItemIsSelectable)) { if (!l.empty ()) l += "|"; l += "ItemIsSelectable"; }
  if (e->testFlag (Qt::ItemIsEditable)) { if (!l.empty ()) l += "|"; l += "ItemIsEditable"; }
  if (e->testFlag (Qt::ItemIsDragEnabled)) { if (!l.empty ()) l += "|"; l += "ItemIsDragEnabled"; }
  if (e->testFlag (Qt::ItemIsDropEnabled)) { if (!l.empty ()) l += "|"; l += "ItemIsDropEnabled"; }
  if (e->testFlag (Qt::ItemIsUserCheckable)) { if (!l.empty ()) l += "|"; l += "ItemIsUserCheckable"; }
  if (e->testFlag (Qt::ItemIsEnabled)) { if (!l.empty ()) l += "|"; l += "ItemIsEnabled"; }
  if (e->testFlag (Qt::ItemIsTristate)) { if (!l.empty ()) l += "|"; l += "ItemIsTristate"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ItemFlag_Enums (const Qt_ItemFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ItemFlag_Enums (const Qt_ItemFlag_Enums *e, const Qt_ItemFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ItemFlag_Enums> decl_Qt_ItemFlag_Enums ("Qt_QFlags_ItemFlag",
  gsi::method_ext ("|", &qt_gsi::oropQt_ItemFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ItemFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ItemFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ItemFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ItemFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ItemFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ItemFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ItemFlag_Enum> decl_Qt_ItemFlag_Enum (decl_Qt_ItemFlag_Enums, "Qt_ItemFlag",
  qt_gsi::mkdefs_Qt_ItemFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ItemFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ItemFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ItemFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ItemFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ItemFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ItemFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ItemFlag_Enum_in_parent (qt_gsi::mkdefs_Qt_ItemFlag ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ItemFlag_Enum_as_child (decl_Qt_ItemFlag_Enum, "ItemFlag");

}


//  Implementation of the enum wrapper class for Qt::ItemSelectionMode
namespace qt_gsi
{

static Qt_ItemSelectionMode_Enum *c_1_Qt_ItemSelectionMode_Enum () { return new Qt_ItemSelectionMode_Enum (Qt::ContainsItemShape); }
static Qt_ItemSelectionMode_Enum *c_2_Qt_ItemSelectionMode_Enum () { return new Qt_ItemSelectionMode_Enum (Qt::IntersectsItemShape); }
static Qt_ItemSelectionMode_Enum *c_3_Qt_ItemSelectionMode_Enum () { return new Qt_ItemSelectionMode_Enum (Qt::ContainsItemBoundingRect); }
static Qt_ItemSelectionMode_Enum *c_4_Qt_ItemSelectionMode_Enum () { return new Qt_ItemSelectionMode_Enum (Qt::IntersectsItemBoundingRect); }

static gsi::Methods mkdefs_Qt_ItemSelectionMode () {
  return
    gsi::constant ("ContainsItemShape", &qt_gsi::c_1_Qt_ItemSelectionMode_Enum, "@brief Enum constant Qt::ContainsItemShape") +
    gsi::constant ("IntersectsItemShape", &qt_gsi::c_2_Qt_ItemSelectionMode_Enum, "@brief Enum constant Qt::IntersectsItemShape") +
    gsi::constant ("ContainsItemBoundingRect", &qt_gsi::c_3_Qt_ItemSelectionMode_Enum, "@brief Enum constant Qt::ContainsItemBoundingRect") +
    gsi::constant ("IntersectsItemBoundingRect", &qt_gsi::c_4_Qt_ItemSelectionMode_Enum, "@brief Enum constant Qt::IntersectsItemBoundingRect");
}

static std::string to_s_Qt_ItemSelectionMode_Enum (const Qt_ItemSelectionMode_Enum *e)
{
  if (e->value () == Qt::ContainsItemShape) { return tl::sprintf ("ContainsItemShape (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::IntersectsItemShape) { return tl::sprintf ("IntersectsItemShape (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ContainsItemBoundingRect) { return tl::sprintf ("ContainsItemBoundingRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::IntersectsItemBoundingRect) { return tl::sprintf ("IntersectsItemBoundingRect (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ItemSelectionMode_Enum (const Qt_ItemSelectionMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ItemSelectionMode_Enum *from_i_Qt_ItemSelectionMode_Enum (unsigned int i)
{
  return new Qt_ItemSelectionMode_Enum ((Qt::ItemSelectionMode) i);
}

static bool equalQt_ItemSelectionMode_Enum (const Qt_ItemSelectionMode_Enum *e, Qt_ItemSelectionMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ItemSelectionMode_Enum (const Qt_ItemSelectionMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ItemSelectionMode_Enums oropQt_ItemSelectionMode_Enums (const Qt_ItemSelectionMode_Enums *e, const Qt_ItemSelectionMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ItemSelectionMode_Enums andopQt_ItemSelectionMode_Enums (const Qt_ItemSelectionMode_Enums *e, const Qt_ItemSelectionMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ItemSelectionMode_Enums xoropQt_ItemSelectionMode_Enums (const Qt_ItemSelectionMode_Enums *e, const Qt_ItemSelectionMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ItemSelectionMode_Enums (const Qt_ItemSelectionMode_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::ContainsItemShape)) { if (!l.empty ()) l += "|"; l += "ContainsItemShape"; }
  if (e->testFlag (Qt::IntersectsItemShape)) { if (!l.empty ()) l += "|"; l += "IntersectsItemShape"; }
  if (e->testFlag (Qt::ContainsItemBoundingRect)) { if (!l.empty ()) l += "|"; l += "ContainsItemBoundingRect"; }
  if (e->testFlag (Qt::IntersectsItemBoundingRect)) { if (!l.empty ()) l += "|"; l += "IntersectsItemBoundingRect"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ItemSelectionMode_Enums (const Qt_ItemSelectionMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ItemSelectionMode_Enums (const Qt_ItemSelectionMode_Enums *e, const Qt_ItemSelectionMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ItemSelectionMode_Enums> decl_Qt_ItemSelectionMode_Enums ("Qt_QFlags_ItemSelectionMode",
  gsi::method_ext ("|", &qt_gsi::oropQt_ItemSelectionMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ItemSelectionMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ItemSelectionMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ItemSelectionMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ItemSelectionMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ItemSelectionMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ItemSelectionMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ItemSelectionMode_Enum> decl_Qt_ItemSelectionMode_Enum (decl_Qt_ItemSelectionMode_Enums, "Qt_ItemSelectionMode",
  qt_gsi::mkdefs_Qt_ItemSelectionMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ItemSelectionMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ItemSelectionMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ItemSelectionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ItemSelectionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ItemSelectionMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ItemSelectionMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ItemSelectionMode_Enum_in_parent (qt_gsi::mkdefs_Qt_ItemSelectionMode ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ItemSelectionMode_Enum_as_child (decl_Qt_ItemSelectionMode_Enum, "ItemSelectionMode");

}


//  Implementation of the enum wrapper class for Qt::Key
namespace qt_gsi
{

static Qt_Key_Enum *c_1_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Escape); }
static Qt_Key_Enum *c_2_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Tab); }
static Qt_Key_Enum *c_3_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Backtab); }
static Qt_Key_Enum *c_4_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Backspace); }
static Qt_Key_Enum *c_5_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Return); }
static Qt_Key_Enum *c_6_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Enter); }
static Qt_Key_Enum *c_7_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Insert); }
static Qt_Key_Enum *c_8_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Delete); }
static Qt_Key_Enum *c_9_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Pause); }
static Qt_Key_Enum *c_10_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Print); }
static Qt_Key_Enum *c_11_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_SysReq); }
static Qt_Key_Enum *c_12_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Clear); }
static Qt_Key_Enum *c_13_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Home); }
static Qt_Key_Enum *c_14_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_End); }
static Qt_Key_Enum *c_15_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Left); }
static Qt_Key_Enum *c_16_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Up); }
static Qt_Key_Enum *c_17_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Right); }
static Qt_Key_Enum *c_18_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Down); }
static Qt_Key_Enum *c_19_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_PageUp); }
static Qt_Key_Enum *c_20_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_PageDown); }
static Qt_Key_Enum *c_21_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Shift); }
static Qt_Key_Enum *c_22_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Control); }
static Qt_Key_Enum *c_23_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Meta); }
static Qt_Key_Enum *c_24_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Alt); }
static Qt_Key_Enum *c_25_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_CapsLock); }
static Qt_Key_Enum *c_26_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_NumLock); }
static Qt_Key_Enum *c_27_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ScrollLock); }
static Qt_Key_Enum *c_28_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F1); }
static Qt_Key_Enum *c_29_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F2); }
static Qt_Key_Enum *c_30_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F3); }
static Qt_Key_Enum *c_31_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F4); }
static Qt_Key_Enum *c_32_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F5); }
static Qt_Key_Enum *c_33_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F6); }
static Qt_Key_Enum *c_34_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F7); }
static Qt_Key_Enum *c_35_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F8); }
static Qt_Key_Enum *c_36_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F9); }
static Qt_Key_Enum *c_37_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F10); }
static Qt_Key_Enum *c_38_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F11); }
static Qt_Key_Enum *c_39_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F12); }
static Qt_Key_Enum *c_40_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F13); }
static Qt_Key_Enum *c_41_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F14); }
static Qt_Key_Enum *c_42_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F15); }
static Qt_Key_Enum *c_43_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F16); }
static Qt_Key_Enum *c_44_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F17); }
static Qt_Key_Enum *c_45_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F18); }
static Qt_Key_Enum *c_46_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F19); }
static Qt_Key_Enum *c_47_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F20); }
static Qt_Key_Enum *c_48_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F21); }
static Qt_Key_Enum *c_49_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F22); }
static Qt_Key_Enum *c_50_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F23); }
static Qt_Key_Enum *c_51_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F24); }
static Qt_Key_Enum *c_52_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F25); }
static Qt_Key_Enum *c_53_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F26); }
static Qt_Key_Enum *c_54_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F27); }
static Qt_Key_Enum *c_55_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F28); }
static Qt_Key_Enum *c_56_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F29); }
static Qt_Key_Enum *c_57_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F30); }
static Qt_Key_Enum *c_58_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F31); }
static Qt_Key_Enum *c_59_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F32); }
static Qt_Key_Enum *c_60_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F33); }
static Qt_Key_Enum *c_61_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F34); }
static Qt_Key_Enum *c_62_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F35); }
static Qt_Key_Enum *c_63_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Super_L); }
static Qt_Key_Enum *c_64_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Super_R); }
static Qt_Key_Enum *c_65_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Menu); }
static Qt_Key_Enum *c_66_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hyper_L); }
static Qt_Key_Enum *c_67_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hyper_R); }
static Qt_Key_Enum *c_68_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Help); }
static Qt_Key_Enum *c_69_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Direction_L); }
static Qt_Key_Enum *c_70_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Direction_R); }
static Qt_Key_Enum *c_71_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Space); }
static Qt_Key_Enum *c_72_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Any); }
static Qt_Key_Enum *c_73_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Exclam); }
static Qt_Key_Enum *c_74_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_QuoteDbl); }
static Qt_Key_Enum *c_75_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_NumberSign); }
static Qt_Key_Enum *c_76_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dollar); }
static Qt_Key_Enum *c_77_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Percent); }
static Qt_Key_Enum *c_78_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ampersand); }
static Qt_Key_Enum *c_79_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Apostrophe); }
static Qt_Key_Enum *c_80_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ParenLeft); }
static Qt_Key_Enum *c_81_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ParenRight); }
static Qt_Key_Enum *c_82_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Asterisk); }
static Qt_Key_Enum *c_83_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Plus); }
static Qt_Key_Enum *c_84_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Comma); }
static Qt_Key_Enum *c_85_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Minus); }
static Qt_Key_Enum *c_86_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Period); }
static Qt_Key_Enum *c_87_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Slash); }
static Qt_Key_Enum *c_88_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_0); }
static Qt_Key_Enum *c_89_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_1); }
static Qt_Key_Enum *c_90_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_2); }
static Qt_Key_Enum *c_91_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_3); }
static Qt_Key_Enum *c_92_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_4); }
static Qt_Key_Enum *c_93_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_5); }
static Qt_Key_Enum *c_94_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_6); }
static Qt_Key_Enum *c_95_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_7); }
static Qt_Key_Enum *c_96_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_8); }
static Qt_Key_Enum *c_97_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_9); }
static Qt_Key_Enum *c_98_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Colon); }
static Qt_Key_Enum *c_99_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Semicolon); }
static Qt_Key_Enum *c_100_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Less); }
static Qt_Key_Enum *c_101_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Equal); }
static Qt_Key_Enum *c_102_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Greater); }
static Qt_Key_Enum *c_103_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Question); }
static Qt_Key_Enum *c_104_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_At); }
static Qt_Key_Enum *c_105_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_A); }
static Qt_Key_Enum *c_106_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_B); }
static Qt_Key_Enum *c_107_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_C); }
static Qt_Key_Enum *c_108_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_D); }
static Qt_Key_Enum *c_109_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_E); }
static Qt_Key_Enum *c_110_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_F); }
static Qt_Key_Enum *c_111_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_G); }
static Qt_Key_Enum *c_112_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_H); }
static Qt_Key_Enum *c_113_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_I); }
static Qt_Key_Enum *c_114_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_J); }
static Qt_Key_Enum *c_115_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_K); }
static Qt_Key_Enum *c_116_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_L); }
static Qt_Key_Enum *c_117_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_M); }
static Qt_Key_Enum *c_118_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_N); }
static Qt_Key_Enum *c_119_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_O); }
static Qt_Key_Enum *c_120_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_P); }
static Qt_Key_Enum *c_121_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Q); }
static Qt_Key_Enum *c_122_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_R); }
static Qt_Key_Enum *c_123_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_S); }
static Qt_Key_Enum *c_124_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_T); }
static Qt_Key_Enum *c_125_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_U); }
static Qt_Key_Enum *c_126_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_V); }
static Qt_Key_Enum *c_127_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_W); }
static Qt_Key_Enum *c_128_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_X); }
static Qt_Key_Enum *c_129_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Y); }
static Qt_Key_Enum *c_130_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Z); }
static Qt_Key_Enum *c_131_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_BracketLeft); }
static Qt_Key_Enum *c_132_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Backslash); }
static Qt_Key_Enum *c_133_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_BracketRight); }
static Qt_Key_Enum *c_134_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AsciiCircum); }
static Qt_Key_Enum *c_135_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Underscore); }
static Qt_Key_Enum *c_136_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_QuoteLeft); }
static Qt_Key_Enum *c_137_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_BraceLeft); }
static Qt_Key_Enum *c_138_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Bar); }
static Qt_Key_Enum *c_139_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_BraceRight); }
static Qt_Key_Enum *c_140_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AsciiTilde); }
static Qt_Key_Enum *c_141_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_nobreakspace); }
static Qt_Key_Enum *c_142_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_exclamdown); }
static Qt_Key_Enum *c_143_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_cent); }
static Qt_Key_Enum *c_144_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_sterling); }
static Qt_Key_Enum *c_145_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_currency); }
static Qt_Key_Enum *c_146_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_yen); }
static Qt_Key_Enum *c_147_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_brokenbar); }
static Qt_Key_Enum *c_148_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_section); }
static Qt_Key_Enum *c_149_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_diaeresis); }
static Qt_Key_Enum *c_150_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_copyright); }
static Qt_Key_Enum *c_151_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ordfeminine); }
static Qt_Key_Enum *c_152_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_guillemotleft); }
static Qt_Key_Enum *c_153_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_notsign); }
static Qt_Key_Enum *c_154_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_hyphen); }
static Qt_Key_Enum *c_155_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_registered); }
static Qt_Key_Enum *c_156_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_macron); }
static Qt_Key_Enum *c_157_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_degree); }
static Qt_Key_Enum *c_158_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_plusminus); }
static Qt_Key_Enum *c_159_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_twosuperior); }
static Qt_Key_Enum *c_160_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_threesuperior); }
static Qt_Key_Enum *c_161_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_acute); }
static Qt_Key_Enum *c_162_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_mu); }
static Qt_Key_Enum *c_163_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_paragraph); }
static Qt_Key_Enum *c_164_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_periodcentered); }
static Qt_Key_Enum *c_165_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_cedilla); }
static Qt_Key_Enum *c_166_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_onesuperior); }
static Qt_Key_Enum *c_167_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_masculine); }
static Qt_Key_Enum *c_168_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_guillemotright); }
static Qt_Key_Enum *c_169_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_onequarter); }
static Qt_Key_Enum *c_170_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_onehalf); }
static Qt_Key_Enum *c_171_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_threequarters); }
static Qt_Key_Enum *c_172_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_questiondown); }
static Qt_Key_Enum *c_173_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Agrave); }
static Qt_Key_Enum *c_174_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Aacute); }
static Qt_Key_Enum *c_175_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Acircumflex); }
static Qt_Key_Enum *c_176_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Atilde); }
static Qt_Key_Enum *c_177_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Adiaeresis); }
static Qt_Key_Enum *c_178_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Aring); }
static Qt_Key_Enum *c_179_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AE); }
static Qt_Key_Enum *c_180_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ccedilla); }
static Qt_Key_Enum *c_181_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Egrave); }
static Qt_Key_Enum *c_182_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Eacute); }
static Qt_Key_Enum *c_183_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ecircumflex); }
static Qt_Key_Enum *c_184_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ediaeresis); }
static Qt_Key_Enum *c_185_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Igrave); }
static Qt_Key_Enum *c_186_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Iacute); }
static Qt_Key_Enum *c_187_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Icircumflex); }
static Qt_Key_Enum *c_188_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Idiaeresis); }
static Qt_Key_Enum *c_189_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ETH); }
static Qt_Key_Enum *c_190_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ntilde); }
static Qt_Key_Enum *c_191_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ograve); }
static Qt_Key_Enum *c_192_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Oacute); }
static Qt_Key_Enum *c_193_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ocircumflex); }
static Qt_Key_Enum *c_194_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Otilde); }
static Qt_Key_Enum *c_195_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Odiaeresis); }
static Qt_Key_Enum *c_196_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_multiply); }
static Qt_Key_Enum *c_197_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ooblique); }
static Qt_Key_Enum *c_198_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ugrave); }
static Qt_Key_Enum *c_199_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Uacute); }
static Qt_Key_Enum *c_200_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Ucircumflex); }
static Qt_Key_Enum *c_201_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Udiaeresis); }
static Qt_Key_Enum *c_202_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Yacute); }
static Qt_Key_Enum *c_203_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_THORN); }
static Qt_Key_Enum *c_204_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ssharp); }
static Qt_Key_Enum *c_205_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_division); }
static Qt_Key_Enum *c_206_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ydiaeresis); }
static Qt_Key_Enum *c_207_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AltGr); }
static Qt_Key_Enum *c_208_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Multi_key); }
static Qt_Key_Enum *c_209_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Codeinput); }
static Qt_Key_Enum *c_210_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_SingleCandidate); }
static Qt_Key_Enum *c_211_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MultipleCandidate); }
static Qt_Key_Enum *c_212_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_PreviousCandidate); }
static Qt_Key_Enum *c_213_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Mode_switch); }
static Qt_Key_Enum *c_214_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Kanji); }
static Qt_Key_Enum *c_215_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Muhenkan); }
static Qt_Key_Enum *c_216_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Henkan); }
static Qt_Key_Enum *c_217_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Romaji); }
static Qt_Key_Enum *c_218_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hiragana); }
static Qt_Key_Enum *c_219_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Katakana); }
static Qt_Key_Enum *c_220_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hiragana_Katakana); }
static Qt_Key_Enum *c_221_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Zenkaku); }
static Qt_Key_Enum *c_222_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hankaku); }
static Qt_Key_Enum *c_223_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Zenkaku_Hankaku); }
static Qt_Key_Enum *c_224_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Touroku); }
static Qt_Key_Enum *c_225_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Massyo); }
static Qt_Key_Enum *c_226_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Kana_Lock); }
static Qt_Key_Enum *c_227_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Kana_Shift); }
static Qt_Key_Enum *c_228_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Eisu_Shift); }
static Qt_Key_Enum *c_229_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Eisu_toggle); }
static Qt_Key_Enum *c_230_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul); }
static Qt_Key_Enum *c_231_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_Start); }
static Qt_Key_Enum *c_232_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_End); }
static Qt_Key_Enum *c_233_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_Hanja); }
static Qt_Key_Enum *c_234_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_Jamo); }
static Qt_Key_Enum *c_235_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_Romaja); }
static Qt_Key_Enum *c_236_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_Jeonja); }
static Qt_Key_Enum *c_237_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_Banja); }
static Qt_Key_Enum *c_238_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_PreHanja); }
static Qt_Key_Enum *c_239_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_PostHanja); }
static Qt_Key_Enum *c_240_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangul_Special); }
static Qt_Key_Enum *c_241_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Grave); }
static Qt_Key_Enum *c_242_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Acute); }
static Qt_Key_Enum *c_243_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Circumflex); }
static Qt_Key_Enum *c_244_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Tilde); }
static Qt_Key_Enum *c_245_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Macron); }
static Qt_Key_Enum *c_246_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Breve); }
static Qt_Key_Enum *c_247_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Abovedot); }
static Qt_Key_Enum *c_248_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Diaeresis); }
static Qt_Key_Enum *c_249_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Abovering); }
static Qt_Key_Enum *c_250_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Doubleacute); }
static Qt_Key_Enum *c_251_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Caron); }
static Qt_Key_Enum *c_252_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Cedilla); }
static Qt_Key_Enum *c_253_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Ogonek); }
static Qt_Key_Enum *c_254_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Iota); }
static Qt_Key_Enum *c_255_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Voiced_Sound); }
static Qt_Key_Enum *c_256_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Semivoiced_Sound); }
static Qt_Key_Enum *c_257_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Belowdot); }
static Qt_Key_Enum *c_258_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Hook); }
static Qt_Key_Enum *c_259_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Dead_Horn); }
static Qt_Key_Enum *c_260_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Back); }
static Qt_Key_Enum *c_261_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Forward); }
static Qt_Key_Enum *c_262_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Stop); }
static Qt_Key_Enum *c_263_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Refresh); }
static Qt_Key_Enum *c_264_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_VolumeDown); }
static Qt_Key_Enum *c_265_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_VolumeMute); }
static Qt_Key_Enum *c_266_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_VolumeUp); }
static Qt_Key_Enum *c_267_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_BassBoost); }
static Qt_Key_Enum *c_268_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_BassUp); }
static Qt_Key_Enum *c_269_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_BassDown); }
static Qt_Key_Enum *c_270_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_TrebleUp); }
static Qt_Key_Enum *c_271_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_TrebleDown); }
static Qt_Key_Enum *c_272_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MediaPlay); }
static Qt_Key_Enum *c_273_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MediaStop); }
static Qt_Key_Enum *c_274_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MediaPrevious); }
static Qt_Key_Enum *c_275_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MediaNext); }
static Qt_Key_Enum *c_276_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MediaRecord); }
static Qt_Key_Enum *c_277_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_HomePage); }
static Qt_Key_Enum *c_278_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Favorites); }
static Qt_Key_Enum *c_279_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Search); }
static Qt_Key_Enum *c_280_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Standby); }
static Qt_Key_Enum *c_281_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_OpenUrl); }
static Qt_Key_Enum *c_282_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LaunchMail); }
static Qt_Key_Enum *c_283_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LaunchMedia); }
static Qt_Key_Enum *c_284_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch0); }
static Qt_Key_Enum *c_285_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch1); }
static Qt_Key_Enum *c_286_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch2); }
static Qt_Key_Enum *c_287_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch3); }
static Qt_Key_Enum *c_288_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch4); }
static Qt_Key_Enum *c_289_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch5); }
static Qt_Key_Enum *c_290_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch6); }
static Qt_Key_Enum *c_291_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch7); }
static Qt_Key_Enum *c_292_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch8); }
static Qt_Key_Enum *c_293_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Launch9); }
static Qt_Key_Enum *c_294_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LaunchA); }
static Qt_Key_Enum *c_295_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LaunchB); }
static Qt_Key_Enum *c_296_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LaunchC); }
static Qt_Key_Enum *c_297_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LaunchD); }
static Qt_Key_Enum *c_298_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LaunchE); }
static Qt_Key_Enum *c_299_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LaunchF); }
static Qt_Key_Enum *c_300_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MonBrightnessUp); }
static Qt_Key_Enum *c_301_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MonBrightnessDown); }
static Qt_Key_Enum *c_302_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_KeyboardLightOnOff); }
static Qt_Key_Enum *c_303_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_KeyboardBrightnessUp); }
static Qt_Key_Enum *c_304_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_KeyboardBrightnessDown); }
static Qt_Key_Enum *c_305_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_PowerOff); }
static Qt_Key_Enum *c_306_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_WakeUp); }
static Qt_Key_Enum *c_307_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Eject); }
static Qt_Key_Enum *c_308_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ScreenSaver); }
static Qt_Key_Enum *c_309_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_WWW); }
static Qt_Key_Enum *c_310_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Memo); }
static Qt_Key_Enum *c_311_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LightBulb); }
static Qt_Key_Enum *c_312_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Shop); }
static Qt_Key_Enum *c_313_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_History); }
static Qt_Key_Enum *c_314_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AddFavorite); }
static Qt_Key_Enum *c_315_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_HotLinks); }
static Qt_Key_Enum *c_316_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_BrightnessAdjust); }
static Qt_Key_Enum *c_317_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Finance); }
static Qt_Key_Enum *c_318_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Community); }
static Qt_Key_Enum *c_319_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AudioRewind); }
static Qt_Key_Enum *c_320_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_BackForward); }
static Qt_Key_Enum *c_321_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ApplicationLeft); }
static Qt_Key_Enum *c_322_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ApplicationRight); }
static Qt_Key_Enum *c_323_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Book); }
static Qt_Key_Enum *c_324_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_CD); }
static Qt_Key_Enum *c_325_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Calculator); }
static Qt_Key_Enum *c_326_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ToDoList); }
static Qt_Key_Enum *c_327_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ClearGrab); }
static Qt_Key_Enum *c_328_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Close); }
static Qt_Key_Enum *c_329_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Copy); }
static Qt_Key_Enum *c_330_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Cut); }
static Qt_Key_Enum *c_331_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Display); }
static Qt_Key_Enum *c_332_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_DOS); }
static Qt_Key_Enum *c_333_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Documents); }
static Qt_Key_Enum *c_334_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Excel); }
static Qt_Key_Enum *c_335_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Explorer); }
static Qt_Key_Enum *c_336_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Game); }
static Qt_Key_Enum *c_337_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Go); }
static Qt_Key_Enum *c_338_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_iTouch); }
static Qt_Key_Enum *c_339_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_LogOff); }
static Qt_Key_Enum *c_340_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Market); }
static Qt_Key_Enum *c_341_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Meeting); }
static Qt_Key_Enum *c_342_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MenuKB); }
static Qt_Key_Enum *c_343_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MenuPB); }
static Qt_Key_Enum *c_344_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MySites); }
static Qt_Key_Enum *c_345_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_News); }
static Qt_Key_Enum *c_346_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_OfficeHome); }
static Qt_Key_Enum *c_347_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Option); }
static Qt_Key_Enum *c_348_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Paste); }
static Qt_Key_Enum *c_349_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Phone); }
static Qt_Key_Enum *c_350_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Calendar); }
static Qt_Key_Enum *c_351_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Reply); }
static Qt_Key_Enum *c_352_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Reload); }
static Qt_Key_Enum *c_353_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_RotateWindows); }
static Qt_Key_Enum *c_354_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_RotationPB); }
static Qt_Key_Enum *c_355_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_RotationKB); }
static Qt_Key_Enum *c_356_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Save); }
static Qt_Key_Enum *c_357_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Send); }
static Qt_Key_Enum *c_358_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Spell); }
static Qt_Key_Enum *c_359_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_SplitScreen); }
static Qt_Key_Enum *c_360_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Support); }
static Qt_Key_Enum *c_361_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_TaskPane); }
static Qt_Key_Enum *c_362_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Terminal); }
static Qt_Key_Enum *c_363_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Tools); }
static Qt_Key_Enum *c_364_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Travel); }
static Qt_Key_Enum *c_365_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Video); }
static Qt_Key_Enum *c_366_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Word); }
static Qt_Key_Enum *c_367_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Xfer); }
static Qt_Key_Enum *c_368_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ZoomIn); }
static Qt_Key_Enum *c_369_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ZoomOut); }
static Qt_Key_Enum *c_370_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Away); }
static Qt_Key_Enum *c_371_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Messenger); }
static Qt_Key_Enum *c_372_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_WebCam); }
static Qt_Key_Enum *c_373_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MailForward); }
static Qt_Key_Enum *c_374_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Pictures); }
static Qt_Key_Enum *c_375_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Music); }
static Qt_Key_Enum *c_376_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Battery); }
static Qt_Key_Enum *c_377_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Bluetooth); }
static Qt_Key_Enum *c_378_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_WLAN); }
static Qt_Key_Enum *c_379_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_UWB); }
static Qt_Key_Enum *c_380_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AudioForward); }
static Qt_Key_Enum *c_381_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AudioRepeat); }
static Qt_Key_Enum *c_382_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AudioRandomPlay); }
static Qt_Key_Enum *c_383_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Subtitle); }
static Qt_Key_Enum *c_384_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_AudioCycleTrack); }
static Qt_Key_Enum *c_385_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Time); }
static Qt_Key_Enum *c_386_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hibernate); }
static Qt_Key_Enum *c_387_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_View); }
static Qt_Key_Enum *c_388_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_TopMenu); }
static Qt_Key_Enum *c_389_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_PowerDown); }
static Qt_Key_Enum *c_390_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Suspend); }
static Qt_Key_Enum *c_391_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_ContrastAdjust); }
static Qt_Key_Enum *c_392_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_MediaLast); }
static Qt_Key_Enum *c_393_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Select); }
static Qt_Key_Enum *c_394_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Yes); }
static Qt_Key_Enum *c_395_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_No); }
static Qt_Key_Enum *c_396_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Cancel); }
static Qt_Key_Enum *c_397_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Printer); }
static Qt_Key_Enum *c_398_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Execute); }
static Qt_Key_Enum *c_399_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Sleep); }
static Qt_Key_Enum *c_400_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Play); }
static Qt_Key_Enum *c_401_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Zoom); }
static Qt_Key_Enum *c_402_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Context1); }
static Qt_Key_Enum *c_403_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Context2); }
static Qt_Key_Enum *c_404_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Context3); }
static Qt_Key_Enum *c_405_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Context4); }
static Qt_Key_Enum *c_406_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Call); }
static Qt_Key_Enum *c_407_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Hangup); }
static Qt_Key_Enum *c_408_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_Flip); }
static Qt_Key_Enum *c_409_Qt_Key_Enum () { return new Qt_Key_Enum (Qt::Key_unknown); }

static gsi::Methods mkdefs_Qt_Key () {
  return
    gsi::constant ("Key_Escape", &qt_gsi::c_1_Qt_Key_Enum, "@brief Enum constant Qt::Key_Escape") +
    gsi::constant ("Key_Tab", &qt_gsi::c_2_Qt_Key_Enum, "@brief Enum constant Qt::Key_Tab") +
    gsi::constant ("Key_Backtab", &qt_gsi::c_3_Qt_Key_Enum, "@brief Enum constant Qt::Key_Backtab") +
    gsi::constant ("Key_Backspace", &qt_gsi::c_4_Qt_Key_Enum, "@brief Enum constant Qt::Key_Backspace") +
    gsi::constant ("Key_Return", &qt_gsi::c_5_Qt_Key_Enum, "@brief Enum constant Qt::Key_Return") +
    gsi::constant ("Key_Enter", &qt_gsi::c_6_Qt_Key_Enum, "@brief Enum constant Qt::Key_Enter") +
    gsi::constant ("Key_Insert", &qt_gsi::c_7_Qt_Key_Enum, "@brief Enum constant Qt::Key_Insert") +
    gsi::constant ("Key_Delete", &qt_gsi::c_8_Qt_Key_Enum, "@brief Enum constant Qt::Key_Delete") +
    gsi::constant ("Key_Pause", &qt_gsi::c_9_Qt_Key_Enum, "@brief Enum constant Qt::Key_Pause") +
    gsi::constant ("Key_Print", &qt_gsi::c_10_Qt_Key_Enum, "@brief Enum constant Qt::Key_Print") +
    gsi::constant ("Key_SysReq", &qt_gsi::c_11_Qt_Key_Enum, "@brief Enum constant Qt::Key_SysReq") +
    gsi::constant ("Key_Clear", &qt_gsi::c_12_Qt_Key_Enum, "@brief Enum constant Qt::Key_Clear") +
    gsi::constant ("Key_Home", &qt_gsi::c_13_Qt_Key_Enum, "@brief Enum constant Qt::Key_Home") +
    gsi::constant ("Key_End", &qt_gsi::c_14_Qt_Key_Enum, "@brief Enum constant Qt::Key_End") +
    gsi::constant ("Key_Left", &qt_gsi::c_15_Qt_Key_Enum, "@brief Enum constant Qt::Key_Left") +
    gsi::constant ("Key_Up", &qt_gsi::c_16_Qt_Key_Enum, "@brief Enum constant Qt::Key_Up") +
    gsi::constant ("Key_Right", &qt_gsi::c_17_Qt_Key_Enum, "@brief Enum constant Qt::Key_Right") +
    gsi::constant ("Key_Down", &qt_gsi::c_18_Qt_Key_Enum, "@brief Enum constant Qt::Key_Down") +
    gsi::constant ("Key_PageUp", &qt_gsi::c_19_Qt_Key_Enum, "@brief Enum constant Qt::Key_PageUp") +
    gsi::constant ("Key_PageDown", &qt_gsi::c_20_Qt_Key_Enum, "@brief Enum constant Qt::Key_PageDown") +
    gsi::constant ("Key_Shift", &qt_gsi::c_21_Qt_Key_Enum, "@brief Enum constant Qt::Key_Shift") +
    gsi::constant ("Key_Control", &qt_gsi::c_22_Qt_Key_Enum, "@brief Enum constant Qt::Key_Control") +
    gsi::constant ("Key_Meta", &qt_gsi::c_23_Qt_Key_Enum, "@brief Enum constant Qt::Key_Meta") +
    gsi::constant ("Key_Alt", &qt_gsi::c_24_Qt_Key_Enum, "@brief Enum constant Qt::Key_Alt") +
    gsi::constant ("Key_CapsLock", &qt_gsi::c_25_Qt_Key_Enum, "@brief Enum constant Qt::Key_CapsLock") +
    gsi::constant ("Key_NumLock", &qt_gsi::c_26_Qt_Key_Enum, "@brief Enum constant Qt::Key_NumLock") +
    gsi::constant ("Key_ScrollLock", &qt_gsi::c_27_Qt_Key_Enum, "@brief Enum constant Qt::Key_ScrollLock") +
    gsi::constant ("Key_F1", &qt_gsi::c_28_Qt_Key_Enum, "@brief Enum constant Qt::Key_F1") +
    gsi::constant ("Key_F2", &qt_gsi::c_29_Qt_Key_Enum, "@brief Enum constant Qt::Key_F2") +
    gsi::constant ("Key_F3", &qt_gsi::c_30_Qt_Key_Enum, "@brief Enum constant Qt::Key_F3") +
    gsi::constant ("Key_F4", &qt_gsi::c_31_Qt_Key_Enum, "@brief Enum constant Qt::Key_F4") +
    gsi::constant ("Key_F5", &qt_gsi::c_32_Qt_Key_Enum, "@brief Enum constant Qt::Key_F5") +
    gsi::constant ("Key_F6", &qt_gsi::c_33_Qt_Key_Enum, "@brief Enum constant Qt::Key_F6") +
    gsi::constant ("Key_F7", &qt_gsi::c_34_Qt_Key_Enum, "@brief Enum constant Qt::Key_F7") +
    gsi::constant ("Key_F8", &qt_gsi::c_35_Qt_Key_Enum, "@brief Enum constant Qt::Key_F8") +
    gsi::constant ("Key_F9", &qt_gsi::c_36_Qt_Key_Enum, "@brief Enum constant Qt::Key_F9") +
    gsi::constant ("Key_F10", &qt_gsi::c_37_Qt_Key_Enum, "@brief Enum constant Qt::Key_F10") +
    gsi::constant ("Key_F11", &qt_gsi::c_38_Qt_Key_Enum, "@brief Enum constant Qt::Key_F11") +
    gsi::constant ("Key_F12", &qt_gsi::c_39_Qt_Key_Enum, "@brief Enum constant Qt::Key_F12") +
    gsi::constant ("Key_F13", &qt_gsi::c_40_Qt_Key_Enum, "@brief Enum constant Qt::Key_F13") +
    gsi::constant ("Key_F14", &qt_gsi::c_41_Qt_Key_Enum, "@brief Enum constant Qt::Key_F14") +
    gsi::constant ("Key_F15", &qt_gsi::c_42_Qt_Key_Enum, "@brief Enum constant Qt::Key_F15") +
    gsi::constant ("Key_F16", &qt_gsi::c_43_Qt_Key_Enum, "@brief Enum constant Qt::Key_F16") +
    gsi::constant ("Key_F17", &qt_gsi::c_44_Qt_Key_Enum, "@brief Enum constant Qt::Key_F17") +
    gsi::constant ("Key_F18", &qt_gsi::c_45_Qt_Key_Enum, "@brief Enum constant Qt::Key_F18") +
    gsi::constant ("Key_F19", &qt_gsi::c_46_Qt_Key_Enum, "@brief Enum constant Qt::Key_F19") +
    gsi::constant ("Key_F20", &qt_gsi::c_47_Qt_Key_Enum, "@brief Enum constant Qt::Key_F20") +
    gsi::constant ("Key_F21", &qt_gsi::c_48_Qt_Key_Enum, "@brief Enum constant Qt::Key_F21") +
    gsi::constant ("Key_F22", &qt_gsi::c_49_Qt_Key_Enum, "@brief Enum constant Qt::Key_F22") +
    gsi::constant ("Key_F23", &qt_gsi::c_50_Qt_Key_Enum, "@brief Enum constant Qt::Key_F23") +
    gsi::constant ("Key_F24", &qt_gsi::c_51_Qt_Key_Enum, "@brief Enum constant Qt::Key_F24") +
    gsi::constant ("Key_F25", &qt_gsi::c_52_Qt_Key_Enum, "@brief Enum constant Qt::Key_F25") +
    gsi::constant ("Key_F26", &qt_gsi::c_53_Qt_Key_Enum, "@brief Enum constant Qt::Key_F26") +
    gsi::constant ("Key_F27", &qt_gsi::c_54_Qt_Key_Enum, "@brief Enum constant Qt::Key_F27") +
    gsi::constant ("Key_F28", &qt_gsi::c_55_Qt_Key_Enum, "@brief Enum constant Qt::Key_F28") +
    gsi::constant ("Key_F29", &qt_gsi::c_56_Qt_Key_Enum, "@brief Enum constant Qt::Key_F29") +
    gsi::constant ("Key_F30", &qt_gsi::c_57_Qt_Key_Enum, "@brief Enum constant Qt::Key_F30") +
    gsi::constant ("Key_F31", &qt_gsi::c_58_Qt_Key_Enum, "@brief Enum constant Qt::Key_F31") +
    gsi::constant ("Key_F32", &qt_gsi::c_59_Qt_Key_Enum, "@brief Enum constant Qt::Key_F32") +
    gsi::constant ("Key_F33", &qt_gsi::c_60_Qt_Key_Enum, "@brief Enum constant Qt::Key_F33") +
    gsi::constant ("Key_F34", &qt_gsi::c_61_Qt_Key_Enum, "@brief Enum constant Qt::Key_F34") +
    gsi::constant ("Key_F35", &qt_gsi::c_62_Qt_Key_Enum, "@brief Enum constant Qt::Key_F35") +
    gsi::constant ("Key_Super_L", &qt_gsi::c_63_Qt_Key_Enum, "@brief Enum constant Qt::Key_Super_L") +
    gsi::constant ("Key_Super_R", &qt_gsi::c_64_Qt_Key_Enum, "@brief Enum constant Qt::Key_Super_R") +
    gsi::constant ("Key_Menu", &qt_gsi::c_65_Qt_Key_Enum, "@brief Enum constant Qt::Key_Menu") +
    gsi::constant ("Key_Hyper_L", &qt_gsi::c_66_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hyper_L") +
    gsi::constant ("Key_Hyper_R", &qt_gsi::c_67_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hyper_R") +
    gsi::constant ("Key_Help", &qt_gsi::c_68_Qt_Key_Enum, "@brief Enum constant Qt::Key_Help") +
    gsi::constant ("Key_Direction_L", &qt_gsi::c_69_Qt_Key_Enum, "@brief Enum constant Qt::Key_Direction_L") +
    gsi::constant ("Key_Direction_R", &qt_gsi::c_70_Qt_Key_Enum, "@brief Enum constant Qt::Key_Direction_R") +
    gsi::constant ("Key_Space", &qt_gsi::c_71_Qt_Key_Enum, "@brief Enum constant Qt::Key_Space") +
    gsi::constant ("Key_Any", &qt_gsi::c_72_Qt_Key_Enum, "@brief Enum constant Qt::Key_Any") +
    gsi::constant ("Key_Exclam", &qt_gsi::c_73_Qt_Key_Enum, "@brief Enum constant Qt::Key_Exclam") +
    gsi::constant ("Key_QuoteDbl", &qt_gsi::c_74_Qt_Key_Enum, "@brief Enum constant Qt::Key_QuoteDbl") +
    gsi::constant ("Key_NumberSign", &qt_gsi::c_75_Qt_Key_Enum, "@brief Enum constant Qt::Key_NumberSign") +
    gsi::constant ("Key_Dollar", &qt_gsi::c_76_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dollar") +
    gsi::constant ("Key_Percent", &qt_gsi::c_77_Qt_Key_Enum, "@brief Enum constant Qt::Key_Percent") +
    gsi::constant ("Key_Ampersand", &qt_gsi::c_78_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ampersand") +
    gsi::constant ("Key_Apostrophe", &qt_gsi::c_79_Qt_Key_Enum, "@brief Enum constant Qt::Key_Apostrophe") +
    gsi::constant ("Key_ParenLeft", &qt_gsi::c_80_Qt_Key_Enum, "@brief Enum constant Qt::Key_ParenLeft") +
    gsi::constant ("Key_ParenRight", &qt_gsi::c_81_Qt_Key_Enum, "@brief Enum constant Qt::Key_ParenRight") +
    gsi::constant ("Key_Asterisk", &qt_gsi::c_82_Qt_Key_Enum, "@brief Enum constant Qt::Key_Asterisk") +
    gsi::constant ("Key_Plus", &qt_gsi::c_83_Qt_Key_Enum, "@brief Enum constant Qt::Key_Plus") +
    gsi::constant ("Key_Comma", &qt_gsi::c_84_Qt_Key_Enum, "@brief Enum constant Qt::Key_Comma") +
    gsi::constant ("Key_Minus", &qt_gsi::c_85_Qt_Key_Enum, "@brief Enum constant Qt::Key_Minus") +
    gsi::constant ("Key_Period", &qt_gsi::c_86_Qt_Key_Enum, "@brief Enum constant Qt::Key_Period") +
    gsi::constant ("Key_Slash", &qt_gsi::c_87_Qt_Key_Enum, "@brief Enum constant Qt::Key_Slash") +
    gsi::constant ("Key_0", &qt_gsi::c_88_Qt_Key_Enum, "@brief Enum constant Qt::Key_0") +
    gsi::constant ("Key_1", &qt_gsi::c_89_Qt_Key_Enum, "@brief Enum constant Qt::Key_1") +
    gsi::constant ("Key_2", &qt_gsi::c_90_Qt_Key_Enum, "@brief Enum constant Qt::Key_2") +
    gsi::constant ("Key_3", &qt_gsi::c_91_Qt_Key_Enum, "@brief Enum constant Qt::Key_3") +
    gsi::constant ("Key_4", &qt_gsi::c_92_Qt_Key_Enum, "@brief Enum constant Qt::Key_4") +
    gsi::constant ("Key_5", &qt_gsi::c_93_Qt_Key_Enum, "@brief Enum constant Qt::Key_5") +
    gsi::constant ("Key_6", &qt_gsi::c_94_Qt_Key_Enum, "@brief Enum constant Qt::Key_6") +
    gsi::constant ("Key_7", &qt_gsi::c_95_Qt_Key_Enum, "@brief Enum constant Qt::Key_7") +
    gsi::constant ("Key_8", &qt_gsi::c_96_Qt_Key_Enum, "@brief Enum constant Qt::Key_8") +
    gsi::constant ("Key_9", &qt_gsi::c_97_Qt_Key_Enum, "@brief Enum constant Qt::Key_9") +
    gsi::constant ("Key_Colon", &qt_gsi::c_98_Qt_Key_Enum, "@brief Enum constant Qt::Key_Colon") +
    gsi::constant ("Key_Semicolon", &qt_gsi::c_99_Qt_Key_Enum, "@brief Enum constant Qt::Key_Semicolon") +
    gsi::constant ("Key_Less", &qt_gsi::c_100_Qt_Key_Enum, "@brief Enum constant Qt::Key_Less") +
    gsi::constant ("Key_Equal", &qt_gsi::c_101_Qt_Key_Enum, "@brief Enum constant Qt::Key_Equal") +
    gsi::constant ("Key_Greater", &qt_gsi::c_102_Qt_Key_Enum, "@brief Enum constant Qt::Key_Greater") +
    gsi::constant ("Key_Question", &qt_gsi::c_103_Qt_Key_Enum, "@brief Enum constant Qt::Key_Question") +
    gsi::constant ("Key_At", &qt_gsi::c_104_Qt_Key_Enum, "@brief Enum constant Qt::Key_At") +
    gsi::constant ("Key_A", &qt_gsi::c_105_Qt_Key_Enum, "@brief Enum constant Qt::Key_A") +
    gsi::constant ("Key_B", &qt_gsi::c_106_Qt_Key_Enum, "@brief Enum constant Qt::Key_B") +
    gsi::constant ("Key_C", &qt_gsi::c_107_Qt_Key_Enum, "@brief Enum constant Qt::Key_C") +
    gsi::constant ("Key_D", &qt_gsi::c_108_Qt_Key_Enum, "@brief Enum constant Qt::Key_D") +
    gsi::constant ("Key_E", &qt_gsi::c_109_Qt_Key_Enum, "@brief Enum constant Qt::Key_E") +
    gsi::constant ("Key_F", &qt_gsi::c_110_Qt_Key_Enum, "@brief Enum constant Qt::Key_F") +
    gsi::constant ("Key_G", &qt_gsi::c_111_Qt_Key_Enum, "@brief Enum constant Qt::Key_G") +
    gsi::constant ("Key_H", &qt_gsi::c_112_Qt_Key_Enum, "@brief Enum constant Qt::Key_H") +
    gsi::constant ("Key_I", &qt_gsi::c_113_Qt_Key_Enum, "@brief Enum constant Qt::Key_I") +
    gsi::constant ("Key_J", &qt_gsi::c_114_Qt_Key_Enum, "@brief Enum constant Qt::Key_J") +
    gsi::constant ("Key_K", &qt_gsi::c_115_Qt_Key_Enum, "@brief Enum constant Qt::Key_K") +
    gsi::constant ("Key_L", &qt_gsi::c_116_Qt_Key_Enum, "@brief Enum constant Qt::Key_L") +
    gsi::constant ("Key_M", &qt_gsi::c_117_Qt_Key_Enum, "@brief Enum constant Qt::Key_M") +
    gsi::constant ("Key_N", &qt_gsi::c_118_Qt_Key_Enum, "@brief Enum constant Qt::Key_N") +
    gsi::constant ("Key_O", &qt_gsi::c_119_Qt_Key_Enum, "@brief Enum constant Qt::Key_O") +
    gsi::constant ("Key_P", &qt_gsi::c_120_Qt_Key_Enum, "@brief Enum constant Qt::Key_P") +
    gsi::constant ("Key_Q", &qt_gsi::c_121_Qt_Key_Enum, "@brief Enum constant Qt::Key_Q") +
    gsi::constant ("Key_R", &qt_gsi::c_122_Qt_Key_Enum, "@brief Enum constant Qt::Key_R") +
    gsi::constant ("Key_S", &qt_gsi::c_123_Qt_Key_Enum, "@brief Enum constant Qt::Key_S") +
    gsi::constant ("Key_T", &qt_gsi::c_124_Qt_Key_Enum, "@brief Enum constant Qt::Key_T") +
    gsi::constant ("Key_U", &qt_gsi::c_125_Qt_Key_Enum, "@brief Enum constant Qt::Key_U") +
    gsi::constant ("Key_V", &qt_gsi::c_126_Qt_Key_Enum, "@brief Enum constant Qt::Key_V") +
    gsi::constant ("Key_W", &qt_gsi::c_127_Qt_Key_Enum, "@brief Enum constant Qt::Key_W") +
    gsi::constant ("Key_X", &qt_gsi::c_128_Qt_Key_Enum, "@brief Enum constant Qt::Key_X") +
    gsi::constant ("Key_Y", &qt_gsi::c_129_Qt_Key_Enum, "@brief Enum constant Qt::Key_Y") +
    gsi::constant ("Key_Z", &qt_gsi::c_130_Qt_Key_Enum, "@brief Enum constant Qt::Key_Z") +
    gsi::constant ("Key_BracketLeft", &qt_gsi::c_131_Qt_Key_Enum, "@brief Enum constant Qt::Key_BracketLeft") +
    gsi::constant ("Key_Backslash", &qt_gsi::c_132_Qt_Key_Enum, "@brief Enum constant Qt::Key_Backslash") +
    gsi::constant ("Key_BracketRight", &qt_gsi::c_133_Qt_Key_Enum, "@brief Enum constant Qt::Key_BracketRight") +
    gsi::constant ("Key_AsciiCircum", &qt_gsi::c_134_Qt_Key_Enum, "@brief Enum constant Qt::Key_AsciiCircum") +
    gsi::constant ("Key_Underscore", &qt_gsi::c_135_Qt_Key_Enum, "@brief Enum constant Qt::Key_Underscore") +
    gsi::constant ("Key_QuoteLeft", &qt_gsi::c_136_Qt_Key_Enum, "@brief Enum constant Qt::Key_QuoteLeft") +
    gsi::constant ("Key_BraceLeft", &qt_gsi::c_137_Qt_Key_Enum, "@brief Enum constant Qt::Key_BraceLeft") +
    gsi::constant ("Key_Bar", &qt_gsi::c_138_Qt_Key_Enum, "@brief Enum constant Qt::Key_Bar") +
    gsi::constant ("Key_BraceRight", &qt_gsi::c_139_Qt_Key_Enum, "@brief Enum constant Qt::Key_BraceRight") +
    gsi::constant ("Key_AsciiTilde", &qt_gsi::c_140_Qt_Key_Enum, "@brief Enum constant Qt::Key_AsciiTilde") +
    gsi::constant ("Key_nobreakspace", &qt_gsi::c_141_Qt_Key_Enum, "@brief Enum constant Qt::Key_nobreakspace") +
    gsi::constant ("Key_exclamdown", &qt_gsi::c_142_Qt_Key_Enum, "@brief Enum constant Qt::Key_exclamdown") +
    gsi::constant ("Key_cent", &qt_gsi::c_143_Qt_Key_Enum, "@brief Enum constant Qt::Key_cent") +
    gsi::constant ("Key_sterling", &qt_gsi::c_144_Qt_Key_Enum, "@brief Enum constant Qt::Key_sterling") +
    gsi::constant ("Key_currency", &qt_gsi::c_145_Qt_Key_Enum, "@brief Enum constant Qt::Key_currency") +
    gsi::constant ("Key_yen", &qt_gsi::c_146_Qt_Key_Enum, "@brief Enum constant Qt::Key_yen") +
    gsi::constant ("Key_brokenbar", &qt_gsi::c_147_Qt_Key_Enum, "@brief Enum constant Qt::Key_brokenbar") +
    gsi::constant ("Key_section", &qt_gsi::c_148_Qt_Key_Enum, "@brief Enum constant Qt::Key_section") +
    gsi::constant ("Key_diaeresis", &qt_gsi::c_149_Qt_Key_Enum, "@brief Enum constant Qt::Key_diaeresis") +
    gsi::constant ("Key_copyright", &qt_gsi::c_150_Qt_Key_Enum, "@brief Enum constant Qt::Key_copyright") +
    gsi::constant ("Key_ordfeminine", &qt_gsi::c_151_Qt_Key_Enum, "@brief Enum constant Qt::Key_ordfeminine") +
    gsi::constant ("Key_guillemotleft", &qt_gsi::c_152_Qt_Key_Enum, "@brief Enum constant Qt::Key_guillemotleft") +
    gsi::constant ("Key_notsign", &qt_gsi::c_153_Qt_Key_Enum, "@brief Enum constant Qt::Key_notsign") +
    gsi::constant ("Key_hyphen", &qt_gsi::c_154_Qt_Key_Enum, "@brief Enum constant Qt::Key_hyphen") +
    gsi::constant ("Key_registered", &qt_gsi::c_155_Qt_Key_Enum, "@brief Enum constant Qt::Key_registered") +
    gsi::constant ("Key_macron", &qt_gsi::c_156_Qt_Key_Enum, "@brief Enum constant Qt::Key_macron") +
    gsi::constant ("Key_degree", &qt_gsi::c_157_Qt_Key_Enum, "@brief Enum constant Qt::Key_degree") +
    gsi::constant ("Key_plusminus", &qt_gsi::c_158_Qt_Key_Enum, "@brief Enum constant Qt::Key_plusminus") +
    gsi::constant ("Key_twosuperior", &qt_gsi::c_159_Qt_Key_Enum, "@brief Enum constant Qt::Key_twosuperior") +
    gsi::constant ("Key_threesuperior", &qt_gsi::c_160_Qt_Key_Enum, "@brief Enum constant Qt::Key_threesuperior") +
    gsi::constant ("Key_acute", &qt_gsi::c_161_Qt_Key_Enum, "@brief Enum constant Qt::Key_acute") +
    gsi::constant ("Key_mu", &qt_gsi::c_162_Qt_Key_Enum, "@brief Enum constant Qt::Key_mu") +
    gsi::constant ("Key_paragraph", &qt_gsi::c_163_Qt_Key_Enum, "@brief Enum constant Qt::Key_paragraph") +
    gsi::constant ("Key_periodcentered", &qt_gsi::c_164_Qt_Key_Enum, "@brief Enum constant Qt::Key_periodcentered") +
    gsi::constant ("Key_cedilla", &qt_gsi::c_165_Qt_Key_Enum, "@brief Enum constant Qt::Key_cedilla") +
    gsi::constant ("Key_onesuperior", &qt_gsi::c_166_Qt_Key_Enum, "@brief Enum constant Qt::Key_onesuperior") +
    gsi::constant ("Key_masculine", &qt_gsi::c_167_Qt_Key_Enum, "@brief Enum constant Qt::Key_masculine") +
    gsi::constant ("Key_guillemotright", &qt_gsi::c_168_Qt_Key_Enum, "@brief Enum constant Qt::Key_guillemotright") +
    gsi::constant ("Key_onequarter", &qt_gsi::c_169_Qt_Key_Enum, "@brief Enum constant Qt::Key_onequarter") +
    gsi::constant ("Key_onehalf", &qt_gsi::c_170_Qt_Key_Enum, "@brief Enum constant Qt::Key_onehalf") +
    gsi::constant ("Key_threequarters", &qt_gsi::c_171_Qt_Key_Enum, "@brief Enum constant Qt::Key_threequarters") +
    gsi::constant ("Key_questiondown", &qt_gsi::c_172_Qt_Key_Enum, "@brief Enum constant Qt::Key_questiondown") +
    gsi::constant ("Key_Agrave", &qt_gsi::c_173_Qt_Key_Enum, "@brief Enum constant Qt::Key_Agrave") +
    gsi::constant ("Key_Aacute", &qt_gsi::c_174_Qt_Key_Enum, "@brief Enum constant Qt::Key_Aacute") +
    gsi::constant ("Key_Acircumflex", &qt_gsi::c_175_Qt_Key_Enum, "@brief Enum constant Qt::Key_Acircumflex") +
    gsi::constant ("Key_Atilde", &qt_gsi::c_176_Qt_Key_Enum, "@brief Enum constant Qt::Key_Atilde") +
    gsi::constant ("Key_Adiaeresis", &qt_gsi::c_177_Qt_Key_Enum, "@brief Enum constant Qt::Key_Adiaeresis") +
    gsi::constant ("Key_Aring", &qt_gsi::c_178_Qt_Key_Enum, "@brief Enum constant Qt::Key_Aring") +
    gsi::constant ("Key_AE", &qt_gsi::c_179_Qt_Key_Enum, "@brief Enum constant Qt::Key_AE") +
    gsi::constant ("Key_Ccedilla", &qt_gsi::c_180_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ccedilla") +
    gsi::constant ("Key_Egrave", &qt_gsi::c_181_Qt_Key_Enum, "@brief Enum constant Qt::Key_Egrave") +
    gsi::constant ("Key_Eacute", &qt_gsi::c_182_Qt_Key_Enum, "@brief Enum constant Qt::Key_Eacute") +
    gsi::constant ("Key_Ecircumflex", &qt_gsi::c_183_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ecircumflex") +
    gsi::constant ("Key_Ediaeresis", &qt_gsi::c_184_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ediaeresis") +
    gsi::constant ("Key_Igrave", &qt_gsi::c_185_Qt_Key_Enum, "@brief Enum constant Qt::Key_Igrave") +
    gsi::constant ("Key_Iacute", &qt_gsi::c_186_Qt_Key_Enum, "@brief Enum constant Qt::Key_Iacute") +
    gsi::constant ("Key_Icircumflex", &qt_gsi::c_187_Qt_Key_Enum, "@brief Enum constant Qt::Key_Icircumflex") +
    gsi::constant ("Key_Idiaeresis", &qt_gsi::c_188_Qt_Key_Enum, "@brief Enum constant Qt::Key_Idiaeresis") +
    gsi::constant ("Key_ETH", &qt_gsi::c_189_Qt_Key_Enum, "@brief Enum constant Qt::Key_ETH") +
    gsi::constant ("Key_Ntilde", &qt_gsi::c_190_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ntilde") +
    gsi::constant ("Key_Ograve", &qt_gsi::c_191_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ograve") +
    gsi::constant ("Key_Oacute", &qt_gsi::c_192_Qt_Key_Enum, "@brief Enum constant Qt::Key_Oacute") +
    gsi::constant ("Key_Ocircumflex", &qt_gsi::c_193_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ocircumflex") +
    gsi::constant ("Key_Otilde", &qt_gsi::c_194_Qt_Key_Enum, "@brief Enum constant Qt::Key_Otilde") +
    gsi::constant ("Key_Odiaeresis", &qt_gsi::c_195_Qt_Key_Enum, "@brief Enum constant Qt::Key_Odiaeresis") +
    gsi::constant ("Key_multiply", &qt_gsi::c_196_Qt_Key_Enum, "@brief Enum constant Qt::Key_multiply") +
    gsi::constant ("Key_Ooblique", &qt_gsi::c_197_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ooblique") +
    gsi::constant ("Key_Ugrave", &qt_gsi::c_198_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ugrave") +
    gsi::constant ("Key_Uacute", &qt_gsi::c_199_Qt_Key_Enum, "@brief Enum constant Qt::Key_Uacute") +
    gsi::constant ("Key_Ucircumflex", &qt_gsi::c_200_Qt_Key_Enum, "@brief Enum constant Qt::Key_Ucircumflex") +
    gsi::constant ("Key_Udiaeresis", &qt_gsi::c_201_Qt_Key_Enum, "@brief Enum constant Qt::Key_Udiaeresis") +
    gsi::constant ("Key_Yacute", &qt_gsi::c_202_Qt_Key_Enum, "@brief Enum constant Qt::Key_Yacute") +
    gsi::constant ("Key_THORN", &qt_gsi::c_203_Qt_Key_Enum, "@brief Enum constant Qt::Key_THORN") +
    gsi::constant ("Key_ssharp", &qt_gsi::c_204_Qt_Key_Enum, "@brief Enum constant Qt::Key_ssharp") +
    gsi::constant ("Key_division", &qt_gsi::c_205_Qt_Key_Enum, "@brief Enum constant Qt::Key_division") +
    gsi::constant ("Key_ydiaeresis", &qt_gsi::c_206_Qt_Key_Enum, "@brief Enum constant Qt::Key_ydiaeresis") +
    gsi::constant ("Key_AltGr", &qt_gsi::c_207_Qt_Key_Enum, "@brief Enum constant Qt::Key_AltGr") +
    gsi::constant ("Key_Multi_key", &qt_gsi::c_208_Qt_Key_Enum, "@brief Enum constant Qt::Key_Multi_key") +
    gsi::constant ("Key_Codeinput", &qt_gsi::c_209_Qt_Key_Enum, "@brief Enum constant Qt::Key_Codeinput") +
    gsi::constant ("Key_SingleCandidate", &qt_gsi::c_210_Qt_Key_Enum, "@brief Enum constant Qt::Key_SingleCandidate") +
    gsi::constant ("Key_MultipleCandidate", &qt_gsi::c_211_Qt_Key_Enum, "@brief Enum constant Qt::Key_MultipleCandidate") +
    gsi::constant ("Key_PreviousCandidate", &qt_gsi::c_212_Qt_Key_Enum, "@brief Enum constant Qt::Key_PreviousCandidate") +
    gsi::constant ("Key_Mode_switch", &qt_gsi::c_213_Qt_Key_Enum, "@brief Enum constant Qt::Key_Mode_switch") +
    gsi::constant ("Key_Kanji", &qt_gsi::c_214_Qt_Key_Enum, "@brief Enum constant Qt::Key_Kanji") +
    gsi::constant ("Key_Muhenkan", &qt_gsi::c_215_Qt_Key_Enum, "@brief Enum constant Qt::Key_Muhenkan") +
    gsi::constant ("Key_Henkan", &qt_gsi::c_216_Qt_Key_Enum, "@brief Enum constant Qt::Key_Henkan") +
    gsi::constant ("Key_Romaji", &qt_gsi::c_217_Qt_Key_Enum, "@brief Enum constant Qt::Key_Romaji") +
    gsi::constant ("Key_Hiragana", &qt_gsi::c_218_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hiragana") +
    gsi::constant ("Key_Katakana", &qt_gsi::c_219_Qt_Key_Enum, "@brief Enum constant Qt::Key_Katakana") +
    gsi::constant ("Key_Hiragana_Katakana", &qt_gsi::c_220_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hiragana_Katakana") +
    gsi::constant ("Key_Zenkaku", &qt_gsi::c_221_Qt_Key_Enum, "@brief Enum constant Qt::Key_Zenkaku") +
    gsi::constant ("Key_Hankaku", &qt_gsi::c_222_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hankaku") +
    gsi::constant ("Key_Zenkaku_Hankaku", &qt_gsi::c_223_Qt_Key_Enum, "@brief Enum constant Qt::Key_Zenkaku_Hankaku") +
    gsi::constant ("Key_Touroku", &qt_gsi::c_224_Qt_Key_Enum, "@brief Enum constant Qt::Key_Touroku") +
    gsi::constant ("Key_Massyo", &qt_gsi::c_225_Qt_Key_Enum, "@brief Enum constant Qt::Key_Massyo") +
    gsi::constant ("Key_Kana_Lock", &qt_gsi::c_226_Qt_Key_Enum, "@brief Enum constant Qt::Key_Kana_Lock") +
    gsi::constant ("Key_Kana_Shift", &qt_gsi::c_227_Qt_Key_Enum, "@brief Enum constant Qt::Key_Kana_Shift") +
    gsi::constant ("Key_Eisu_Shift", &qt_gsi::c_228_Qt_Key_Enum, "@brief Enum constant Qt::Key_Eisu_Shift") +
    gsi::constant ("Key_Eisu_toggle", &qt_gsi::c_229_Qt_Key_Enum, "@brief Enum constant Qt::Key_Eisu_toggle") +
    gsi::constant ("Key_Hangul", &qt_gsi::c_230_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul") +
    gsi::constant ("Key_Hangul_Start", &qt_gsi::c_231_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_Start") +
    gsi::constant ("Key_Hangul_End", &qt_gsi::c_232_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_End") +
    gsi::constant ("Key_Hangul_Hanja", &qt_gsi::c_233_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_Hanja") +
    gsi::constant ("Key_Hangul_Jamo", &qt_gsi::c_234_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_Jamo") +
    gsi::constant ("Key_Hangul_Romaja", &qt_gsi::c_235_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_Romaja") +
    gsi::constant ("Key_Hangul_Jeonja", &qt_gsi::c_236_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_Jeonja") +
    gsi::constant ("Key_Hangul_Banja", &qt_gsi::c_237_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_Banja") +
    gsi::constant ("Key_Hangul_PreHanja", &qt_gsi::c_238_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_PreHanja") +
    gsi::constant ("Key_Hangul_PostHanja", &qt_gsi::c_239_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_PostHanja") +
    gsi::constant ("Key_Hangul_Special", &qt_gsi::c_240_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangul_Special") +
    gsi::constant ("Key_Dead_Grave", &qt_gsi::c_241_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Grave") +
    gsi::constant ("Key_Dead_Acute", &qt_gsi::c_242_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Acute") +
    gsi::constant ("Key_Dead_Circumflex", &qt_gsi::c_243_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Circumflex") +
    gsi::constant ("Key_Dead_Tilde", &qt_gsi::c_244_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Tilde") +
    gsi::constant ("Key_Dead_Macron", &qt_gsi::c_245_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Macron") +
    gsi::constant ("Key_Dead_Breve", &qt_gsi::c_246_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Breve") +
    gsi::constant ("Key_Dead_Abovedot", &qt_gsi::c_247_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Abovedot") +
    gsi::constant ("Key_Dead_Diaeresis", &qt_gsi::c_248_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Diaeresis") +
    gsi::constant ("Key_Dead_Abovering", &qt_gsi::c_249_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Abovering") +
    gsi::constant ("Key_Dead_Doubleacute", &qt_gsi::c_250_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Doubleacute") +
    gsi::constant ("Key_Dead_Caron", &qt_gsi::c_251_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Caron") +
    gsi::constant ("Key_Dead_Cedilla", &qt_gsi::c_252_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Cedilla") +
    gsi::constant ("Key_Dead_Ogonek", &qt_gsi::c_253_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Ogonek") +
    gsi::constant ("Key_Dead_Iota", &qt_gsi::c_254_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Iota") +
    gsi::constant ("Key_Dead_Voiced_Sound", &qt_gsi::c_255_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Voiced_Sound") +
    gsi::constant ("Key_Dead_Semivoiced_Sound", &qt_gsi::c_256_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Semivoiced_Sound") +
    gsi::constant ("Key_Dead_Belowdot", &qt_gsi::c_257_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Belowdot") +
    gsi::constant ("Key_Dead_Hook", &qt_gsi::c_258_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Hook") +
    gsi::constant ("Key_Dead_Horn", &qt_gsi::c_259_Qt_Key_Enum, "@brief Enum constant Qt::Key_Dead_Horn") +
    gsi::constant ("Key_Back", &qt_gsi::c_260_Qt_Key_Enum, "@brief Enum constant Qt::Key_Back") +
    gsi::constant ("Key_Forward", &qt_gsi::c_261_Qt_Key_Enum, "@brief Enum constant Qt::Key_Forward") +
    gsi::constant ("Key_Stop", &qt_gsi::c_262_Qt_Key_Enum, "@brief Enum constant Qt::Key_Stop") +
    gsi::constant ("Key_Refresh", &qt_gsi::c_263_Qt_Key_Enum, "@brief Enum constant Qt::Key_Refresh") +
    gsi::constant ("Key_VolumeDown", &qt_gsi::c_264_Qt_Key_Enum, "@brief Enum constant Qt::Key_VolumeDown") +
    gsi::constant ("Key_VolumeMute", &qt_gsi::c_265_Qt_Key_Enum, "@brief Enum constant Qt::Key_VolumeMute") +
    gsi::constant ("Key_VolumeUp", &qt_gsi::c_266_Qt_Key_Enum, "@brief Enum constant Qt::Key_VolumeUp") +
    gsi::constant ("Key_BassBoost", &qt_gsi::c_267_Qt_Key_Enum, "@brief Enum constant Qt::Key_BassBoost") +
    gsi::constant ("Key_BassUp", &qt_gsi::c_268_Qt_Key_Enum, "@brief Enum constant Qt::Key_BassUp") +
    gsi::constant ("Key_BassDown", &qt_gsi::c_269_Qt_Key_Enum, "@brief Enum constant Qt::Key_BassDown") +
    gsi::constant ("Key_TrebleUp", &qt_gsi::c_270_Qt_Key_Enum, "@brief Enum constant Qt::Key_TrebleUp") +
    gsi::constant ("Key_TrebleDown", &qt_gsi::c_271_Qt_Key_Enum, "@brief Enum constant Qt::Key_TrebleDown") +
    gsi::constant ("Key_MediaPlay", &qt_gsi::c_272_Qt_Key_Enum, "@brief Enum constant Qt::Key_MediaPlay") +
    gsi::constant ("Key_MediaStop", &qt_gsi::c_273_Qt_Key_Enum, "@brief Enum constant Qt::Key_MediaStop") +
    gsi::constant ("Key_MediaPrevious", &qt_gsi::c_274_Qt_Key_Enum, "@brief Enum constant Qt::Key_MediaPrevious") +
    gsi::constant ("Key_MediaNext", &qt_gsi::c_275_Qt_Key_Enum, "@brief Enum constant Qt::Key_MediaNext") +
    gsi::constant ("Key_MediaRecord", &qt_gsi::c_276_Qt_Key_Enum, "@brief Enum constant Qt::Key_MediaRecord") +
    gsi::constant ("Key_HomePage", &qt_gsi::c_277_Qt_Key_Enum, "@brief Enum constant Qt::Key_HomePage") +
    gsi::constant ("Key_Favorites", &qt_gsi::c_278_Qt_Key_Enum, "@brief Enum constant Qt::Key_Favorites") +
    gsi::constant ("Key_Search", &qt_gsi::c_279_Qt_Key_Enum, "@brief Enum constant Qt::Key_Search") +
    gsi::constant ("Key_Standby", &qt_gsi::c_280_Qt_Key_Enum, "@brief Enum constant Qt::Key_Standby") +
    gsi::constant ("Key_OpenUrl", &qt_gsi::c_281_Qt_Key_Enum, "@brief Enum constant Qt::Key_OpenUrl") +
    gsi::constant ("Key_LaunchMail", &qt_gsi::c_282_Qt_Key_Enum, "@brief Enum constant Qt::Key_LaunchMail") +
    gsi::constant ("Key_LaunchMedia", &qt_gsi::c_283_Qt_Key_Enum, "@brief Enum constant Qt::Key_LaunchMedia") +
    gsi::constant ("Key_Launch0", &qt_gsi::c_284_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch0") +
    gsi::constant ("Key_Launch1", &qt_gsi::c_285_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch1") +
    gsi::constant ("Key_Launch2", &qt_gsi::c_286_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch2") +
    gsi::constant ("Key_Launch3", &qt_gsi::c_287_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch3") +
    gsi::constant ("Key_Launch4", &qt_gsi::c_288_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch4") +
    gsi::constant ("Key_Launch5", &qt_gsi::c_289_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch5") +
    gsi::constant ("Key_Launch6", &qt_gsi::c_290_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch6") +
    gsi::constant ("Key_Launch7", &qt_gsi::c_291_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch7") +
    gsi::constant ("Key_Launch8", &qt_gsi::c_292_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch8") +
    gsi::constant ("Key_Launch9", &qt_gsi::c_293_Qt_Key_Enum, "@brief Enum constant Qt::Key_Launch9") +
    gsi::constant ("Key_LaunchA", &qt_gsi::c_294_Qt_Key_Enum, "@brief Enum constant Qt::Key_LaunchA") +
    gsi::constant ("Key_LaunchB", &qt_gsi::c_295_Qt_Key_Enum, "@brief Enum constant Qt::Key_LaunchB") +
    gsi::constant ("Key_LaunchC", &qt_gsi::c_296_Qt_Key_Enum, "@brief Enum constant Qt::Key_LaunchC") +
    gsi::constant ("Key_LaunchD", &qt_gsi::c_297_Qt_Key_Enum, "@brief Enum constant Qt::Key_LaunchD") +
    gsi::constant ("Key_LaunchE", &qt_gsi::c_298_Qt_Key_Enum, "@brief Enum constant Qt::Key_LaunchE") +
    gsi::constant ("Key_LaunchF", &qt_gsi::c_299_Qt_Key_Enum, "@brief Enum constant Qt::Key_LaunchF") +
    gsi::constant ("Key_MonBrightnessUp", &qt_gsi::c_300_Qt_Key_Enum, "@brief Enum constant Qt::Key_MonBrightnessUp") +
    gsi::constant ("Key_MonBrightnessDown", &qt_gsi::c_301_Qt_Key_Enum, "@brief Enum constant Qt::Key_MonBrightnessDown") +
    gsi::constant ("Key_KeyboardLightOnOff", &qt_gsi::c_302_Qt_Key_Enum, "@brief Enum constant Qt::Key_KeyboardLightOnOff") +
    gsi::constant ("Key_KeyboardBrightnessUp", &qt_gsi::c_303_Qt_Key_Enum, "@brief Enum constant Qt::Key_KeyboardBrightnessUp") +
    gsi::constant ("Key_KeyboardBrightnessDown", &qt_gsi::c_304_Qt_Key_Enum, "@brief Enum constant Qt::Key_KeyboardBrightnessDown") +
    gsi::constant ("Key_PowerOff", &qt_gsi::c_305_Qt_Key_Enum, "@brief Enum constant Qt::Key_PowerOff") +
    gsi::constant ("Key_WakeUp", &qt_gsi::c_306_Qt_Key_Enum, "@brief Enum constant Qt::Key_WakeUp") +
    gsi::constant ("Key_Eject", &qt_gsi::c_307_Qt_Key_Enum, "@brief Enum constant Qt::Key_Eject") +
    gsi::constant ("Key_ScreenSaver", &qt_gsi::c_308_Qt_Key_Enum, "@brief Enum constant Qt::Key_ScreenSaver") +
    gsi::constant ("Key_WWW", &qt_gsi::c_309_Qt_Key_Enum, "@brief Enum constant Qt::Key_WWW") +
    gsi::constant ("Key_Memo", &qt_gsi::c_310_Qt_Key_Enum, "@brief Enum constant Qt::Key_Memo") +
    gsi::constant ("Key_LightBulb", &qt_gsi::c_311_Qt_Key_Enum, "@brief Enum constant Qt::Key_LightBulb") +
    gsi::constant ("Key_Shop", &qt_gsi::c_312_Qt_Key_Enum, "@brief Enum constant Qt::Key_Shop") +
    gsi::constant ("Key_History", &qt_gsi::c_313_Qt_Key_Enum, "@brief Enum constant Qt::Key_History") +
    gsi::constant ("Key_AddFavorite", &qt_gsi::c_314_Qt_Key_Enum, "@brief Enum constant Qt::Key_AddFavorite") +
    gsi::constant ("Key_HotLinks", &qt_gsi::c_315_Qt_Key_Enum, "@brief Enum constant Qt::Key_HotLinks") +
    gsi::constant ("Key_BrightnessAdjust", &qt_gsi::c_316_Qt_Key_Enum, "@brief Enum constant Qt::Key_BrightnessAdjust") +
    gsi::constant ("Key_Finance", &qt_gsi::c_317_Qt_Key_Enum, "@brief Enum constant Qt::Key_Finance") +
    gsi::constant ("Key_Community", &qt_gsi::c_318_Qt_Key_Enum, "@brief Enum constant Qt::Key_Community") +
    gsi::constant ("Key_AudioRewind", &qt_gsi::c_319_Qt_Key_Enum, "@brief Enum constant Qt::Key_AudioRewind") +
    gsi::constant ("Key_BackForward", &qt_gsi::c_320_Qt_Key_Enum, "@brief Enum constant Qt::Key_BackForward") +
    gsi::constant ("Key_ApplicationLeft", &qt_gsi::c_321_Qt_Key_Enum, "@brief Enum constant Qt::Key_ApplicationLeft") +
    gsi::constant ("Key_ApplicationRight", &qt_gsi::c_322_Qt_Key_Enum, "@brief Enum constant Qt::Key_ApplicationRight") +
    gsi::constant ("Key_Book", &qt_gsi::c_323_Qt_Key_Enum, "@brief Enum constant Qt::Key_Book") +
    gsi::constant ("Key_CD", &qt_gsi::c_324_Qt_Key_Enum, "@brief Enum constant Qt::Key_CD") +
    gsi::constant ("Key_Calculator", &qt_gsi::c_325_Qt_Key_Enum, "@brief Enum constant Qt::Key_Calculator") +
    gsi::constant ("Key_ToDoList", &qt_gsi::c_326_Qt_Key_Enum, "@brief Enum constant Qt::Key_ToDoList") +
    gsi::constant ("Key_ClearGrab", &qt_gsi::c_327_Qt_Key_Enum, "@brief Enum constant Qt::Key_ClearGrab") +
    gsi::constant ("Key_Close", &qt_gsi::c_328_Qt_Key_Enum, "@brief Enum constant Qt::Key_Close") +
    gsi::constant ("Key_Copy", &qt_gsi::c_329_Qt_Key_Enum, "@brief Enum constant Qt::Key_Copy") +
    gsi::constant ("Key_Cut", &qt_gsi::c_330_Qt_Key_Enum, "@brief Enum constant Qt::Key_Cut") +
    gsi::constant ("Key_Display", &qt_gsi::c_331_Qt_Key_Enum, "@brief Enum constant Qt::Key_Display") +
    gsi::constant ("Key_DOS", &qt_gsi::c_332_Qt_Key_Enum, "@brief Enum constant Qt::Key_DOS") +
    gsi::constant ("Key_Documents", &qt_gsi::c_333_Qt_Key_Enum, "@brief Enum constant Qt::Key_Documents") +
    gsi::constant ("Key_Excel", &qt_gsi::c_334_Qt_Key_Enum, "@brief Enum constant Qt::Key_Excel") +
    gsi::constant ("Key_Explorer", &qt_gsi::c_335_Qt_Key_Enum, "@brief Enum constant Qt::Key_Explorer") +
    gsi::constant ("Key_Game", &qt_gsi::c_336_Qt_Key_Enum, "@brief Enum constant Qt::Key_Game") +
    gsi::constant ("Key_Go", &qt_gsi::c_337_Qt_Key_Enum, "@brief Enum constant Qt::Key_Go") +
    gsi::constant ("Key_iTouch", &qt_gsi::c_338_Qt_Key_Enum, "@brief Enum constant Qt::Key_iTouch") +
    gsi::constant ("Key_LogOff", &qt_gsi::c_339_Qt_Key_Enum, "@brief Enum constant Qt::Key_LogOff") +
    gsi::constant ("Key_Market", &qt_gsi::c_340_Qt_Key_Enum, "@brief Enum constant Qt::Key_Market") +
    gsi::constant ("Key_Meeting", &qt_gsi::c_341_Qt_Key_Enum, "@brief Enum constant Qt::Key_Meeting") +
    gsi::constant ("Key_MenuKB", &qt_gsi::c_342_Qt_Key_Enum, "@brief Enum constant Qt::Key_MenuKB") +
    gsi::constant ("Key_MenuPB", &qt_gsi::c_343_Qt_Key_Enum, "@brief Enum constant Qt::Key_MenuPB") +
    gsi::constant ("Key_MySites", &qt_gsi::c_344_Qt_Key_Enum, "@brief Enum constant Qt::Key_MySites") +
    gsi::constant ("Key_News", &qt_gsi::c_345_Qt_Key_Enum, "@brief Enum constant Qt::Key_News") +
    gsi::constant ("Key_OfficeHome", &qt_gsi::c_346_Qt_Key_Enum, "@brief Enum constant Qt::Key_OfficeHome") +
    gsi::constant ("Key_Option", &qt_gsi::c_347_Qt_Key_Enum, "@brief Enum constant Qt::Key_Option") +
    gsi::constant ("Key_Paste", &qt_gsi::c_348_Qt_Key_Enum, "@brief Enum constant Qt::Key_Paste") +
    gsi::constant ("Key_Phone", &qt_gsi::c_349_Qt_Key_Enum, "@brief Enum constant Qt::Key_Phone") +
    gsi::constant ("Key_Calendar", &qt_gsi::c_350_Qt_Key_Enum, "@brief Enum constant Qt::Key_Calendar") +
    gsi::constant ("Key_Reply", &qt_gsi::c_351_Qt_Key_Enum, "@brief Enum constant Qt::Key_Reply") +
    gsi::constant ("Key_Reload", &qt_gsi::c_352_Qt_Key_Enum, "@brief Enum constant Qt::Key_Reload") +
    gsi::constant ("Key_RotateWindows", &qt_gsi::c_353_Qt_Key_Enum, "@brief Enum constant Qt::Key_RotateWindows") +
    gsi::constant ("Key_RotationPB", &qt_gsi::c_354_Qt_Key_Enum, "@brief Enum constant Qt::Key_RotationPB") +
    gsi::constant ("Key_RotationKB", &qt_gsi::c_355_Qt_Key_Enum, "@brief Enum constant Qt::Key_RotationKB") +
    gsi::constant ("Key_Save", &qt_gsi::c_356_Qt_Key_Enum, "@brief Enum constant Qt::Key_Save") +
    gsi::constant ("Key_Send", &qt_gsi::c_357_Qt_Key_Enum, "@brief Enum constant Qt::Key_Send") +
    gsi::constant ("Key_Spell", &qt_gsi::c_358_Qt_Key_Enum, "@brief Enum constant Qt::Key_Spell") +
    gsi::constant ("Key_SplitScreen", &qt_gsi::c_359_Qt_Key_Enum, "@brief Enum constant Qt::Key_SplitScreen") +
    gsi::constant ("Key_Support", &qt_gsi::c_360_Qt_Key_Enum, "@brief Enum constant Qt::Key_Support") +
    gsi::constant ("Key_TaskPane", &qt_gsi::c_361_Qt_Key_Enum, "@brief Enum constant Qt::Key_TaskPane") +
    gsi::constant ("Key_Terminal", &qt_gsi::c_362_Qt_Key_Enum, "@brief Enum constant Qt::Key_Terminal") +
    gsi::constant ("Key_Tools", &qt_gsi::c_363_Qt_Key_Enum, "@brief Enum constant Qt::Key_Tools") +
    gsi::constant ("Key_Travel", &qt_gsi::c_364_Qt_Key_Enum, "@brief Enum constant Qt::Key_Travel") +
    gsi::constant ("Key_Video", &qt_gsi::c_365_Qt_Key_Enum, "@brief Enum constant Qt::Key_Video") +
    gsi::constant ("Key_Word", &qt_gsi::c_366_Qt_Key_Enum, "@brief Enum constant Qt::Key_Word") +
    gsi::constant ("Key_Xfer", &qt_gsi::c_367_Qt_Key_Enum, "@brief Enum constant Qt::Key_Xfer") +
    gsi::constant ("Key_ZoomIn", &qt_gsi::c_368_Qt_Key_Enum, "@brief Enum constant Qt::Key_ZoomIn") +
    gsi::constant ("Key_ZoomOut", &qt_gsi::c_369_Qt_Key_Enum, "@brief Enum constant Qt::Key_ZoomOut") +
    gsi::constant ("Key_Away", &qt_gsi::c_370_Qt_Key_Enum, "@brief Enum constant Qt::Key_Away") +
    gsi::constant ("Key_Messenger", &qt_gsi::c_371_Qt_Key_Enum, "@brief Enum constant Qt::Key_Messenger") +
    gsi::constant ("Key_WebCam", &qt_gsi::c_372_Qt_Key_Enum, "@brief Enum constant Qt::Key_WebCam") +
    gsi::constant ("Key_MailForward", &qt_gsi::c_373_Qt_Key_Enum, "@brief Enum constant Qt::Key_MailForward") +
    gsi::constant ("Key_Pictures", &qt_gsi::c_374_Qt_Key_Enum, "@brief Enum constant Qt::Key_Pictures") +
    gsi::constant ("Key_Music", &qt_gsi::c_375_Qt_Key_Enum, "@brief Enum constant Qt::Key_Music") +
    gsi::constant ("Key_Battery", &qt_gsi::c_376_Qt_Key_Enum, "@brief Enum constant Qt::Key_Battery") +
    gsi::constant ("Key_Bluetooth", &qt_gsi::c_377_Qt_Key_Enum, "@brief Enum constant Qt::Key_Bluetooth") +
    gsi::constant ("Key_WLAN", &qt_gsi::c_378_Qt_Key_Enum, "@brief Enum constant Qt::Key_WLAN") +
    gsi::constant ("Key_UWB", &qt_gsi::c_379_Qt_Key_Enum, "@brief Enum constant Qt::Key_UWB") +
    gsi::constant ("Key_AudioForward", &qt_gsi::c_380_Qt_Key_Enum, "@brief Enum constant Qt::Key_AudioForward") +
    gsi::constant ("Key_AudioRepeat", &qt_gsi::c_381_Qt_Key_Enum, "@brief Enum constant Qt::Key_AudioRepeat") +
    gsi::constant ("Key_AudioRandomPlay", &qt_gsi::c_382_Qt_Key_Enum, "@brief Enum constant Qt::Key_AudioRandomPlay") +
    gsi::constant ("Key_Subtitle", &qt_gsi::c_383_Qt_Key_Enum, "@brief Enum constant Qt::Key_Subtitle") +
    gsi::constant ("Key_AudioCycleTrack", &qt_gsi::c_384_Qt_Key_Enum, "@brief Enum constant Qt::Key_AudioCycleTrack") +
    gsi::constant ("Key_Time", &qt_gsi::c_385_Qt_Key_Enum, "@brief Enum constant Qt::Key_Time") +
    gsi::constant ("Key_Hibernate", &qt_gsi::c_386_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hibernate") +
    gsi::constant ("Key_View", &qt_gsi::c_387_Qt_Key_Enum, "@brief Enum constant Qt::Key_View") +
    gsi::constant ("Key_TopMenu", &qt_gsi::c_388_Qt_Key_Enum, "@brief Enum constant Qt::Key_TopMenu") +
    gsi::constant ("Key_PowerDown", &qt_gsi::c_389_Qt_Key_Enum, "@brief Enum constant Qt::Key_PowerDown") +
    gsi::constant ("Key_Suspend", &qt_gsi::c_390_Qt_Key_Enum, "@brief Enum constant Qt::Key_Suspend") +
    gsi::constant ("Key_ContrastAdjust", &qt_gsi::c_391_Qt_Key_Enum, "@brief Enum constant Qt::Key_ContrastAdjust") +
    gsi::constant ("Key_MediaLast", &qt_gsi::c_392_Qt_Key_Enum, "@brief Enum constant Qt::Key_MediaLast") +
    gsi::constant ("Key_Select", &qt_gsi::c_393_Qt_Key_Enum, "@brief Enum constant Qt::Key_Select") +
    gsi::constant ("Key_Yes", &qt_gsi::c_394_Qt_Key_Enum, "@brief Enum constant Qt::Key_Yes") +
    gsi::constant ("Key_No", &qt_gsi::c_395_Qt_Key_Enum, "@brief Enum constant Qt::Key_No") +
    gsi::constant ("Key_Cancel", &qt_gsi::c_396_Qt_Key_Enum, "@brief Enum constant Qt::Key_Cancel") +
    gsi::constant ("Key_Printer", &qt_gsi::c_397_Qt_Key_Enum, "@brief Enum constant Qt::Key_Printer") +
    gsi::constant ("Key_Execute", &qt_gsi::c_398_Qt_Key_Enum, "@brief Enum constant Qt::Key_Execute") +
    gsi::constant ("Key_Sleep", &qt_gsi::c_399_Qt_Key_Enum, "@brief Enum constant Qt::Key_Sleep") +
    gsi::constant ("Key_Play", &qt_gsi::c_400_Qt_Key_Enum, "@brief Enum constant Qt::Key_Play") +
    gsi::constant ("Key_Zoom", &qt_gsi::c_401_Qt_Key_Enum, "@brief Enum constant Qt::Key_Zoom") +
    gsi::constant ("Key_Context1", &qt_gsi::c_402_Qt_Key_Enum, "@brief Enum constant Qt::Key_Context1") +
    gsi::constant ("Key_Context2", &qt_gsi::c_403_Qt_Key_Enum, "@brief Enum constant Qt::Key_Context2") +
    gsi::constant ("Key_Context3", &qt_gsi::c_404_Qt_Key_Enum, "@brief Enum constant Qt::Key_Context3") +
    gsi::constant ("Key_Context4", &qt_gsi::c_405_Qt_Key_Enum, "@brief Enum constant Qt::Key_Context4") +
    gsi::constant ("Key_Call", &qt_gsi::c_406_Qt_Key_Enum, "@brief Enum constant Qt::Key_Call") +
    gsi::constant ("Key_Hangup", &qt_gsi::c_407_Qt_Key_Enum, "@brief Enum constant Qt::Key_Hangup") +
    gsi::constant ("Key_Flip", &qt_gsi::c_408_Qt_Key_Enum, "@brief Enum constant Qt::Key_Flip") +
    gsi::constant ("Key_unknown", &qt_gsi::c_409_Qt_Key_Enum, "@brief Enum constant Qt::Key_unknown");
}

static std::string to_s_Qt_Key_Enum (const Qt_Key_Enum *e)
{
  if (e->value () == Qt::Key_Escape) { return tl::sprintf ("Key_Escape (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Tab) { return tl::sprintf ("Key_Tab (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Backtab) { return tl::sprintf ("Key_Backtab (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Backspace) { return tl::sprintf ("Key_Backspace (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Return) { return tl::sprintf ("Key_Return (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Enter) { return tl::sprintf ("Key_Enter (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Insert) { return tl::sprintf ("Key_Insert (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Delete) { return tl::sprintf ("Key_Delete (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Pause) { return tl::sprintf ("Key_Pause (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Print) { return tl::sprintf ("Key_Print (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_SysReq) { return tl::sprintf ("Key_SysReq (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Clear) { return tl::sprintf ("Key_Clear (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Home) { return tl::sprintf ("Key_Home (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_End) { return tl::sprintf ("Key_End (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Left) { return tl::sprintf ("Key_Left (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Up) { return tl::sprintf ("Key_Up (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Right) { return tl::sprintf ("Key_Right (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Down) { return tl::sprintf ("Key_Down (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_PageUp) { return tl::sprintf ("Key_PageUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_PageDown) { return tl::sprintf ("Key_PageDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Shift) { return tl::sprintf ("Key_Shift (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Control) { return tl::sprintf ("Key_Control (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Meta) { return tl::sprintf ("Key_Meta (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Alt) { return tl::sprintf ("Key_Alt (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_CapsLock) { return tl::sprintf ("Key_CapsLock (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_NumLock) { return tl::sprintf ("Key_NumLock (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ScrollLock) { return tl::sprintf ("Key_ScrollLock (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F1) { return tl::sprintf ("Key_F1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F2) { return tl::sprintf ("Key_F2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F3) { return tl::sprintf ("Key_F3 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F4) { return tl::sprintf ("Key_F4 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F5) { return tl::sprintf ("Key_F5 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F6) { return tl::sprintf ("Key_F6 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F7) { return tl::sprintf ("Key_F7 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F8) { return tl::sprintf ("Key_F8 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F9) { return tl::sprintf ("Key_F9 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F10) { return tl::sprintf ("Key_F10 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F11) { return tl::sprintf ("Key_F11 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F12) { return tl::sprintf ("Key_F12 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F13) { return tl::sprintf ("Key_F13 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F14) { return tl::sprintf ("Key_F14 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F15) { return tl::sprintf ("Key_F15 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F16) { return tl::sprintf ("Key_F16 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F17) { return tl::sprintf ("Key_F17 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F18) { return tl::sprintf ("Key_F18 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F19) { return tl::sprintf ("Key_F19 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F20) { return tl::sprintf ("Key_F20 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F21) { return tl::sprintf ("Key_F21 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F22) { return tl::sprintf ("Key_F22 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F23) { return tl::sprintf ("Key_F23 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F24) { return tl::sprintf ("Key_F24 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F25) { return tl::sprintf ("Key_F25 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F26) { return tl::sprintf ("Key_F26 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F27) { return tl::sprintf ("Key_F27 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F28) { return tl::sprintf ("Key_F28 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F29) { return tl::sprintf ("Key_F29 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F30) { return tl::sprintf ("Key_F30 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F31) { return tl::sprintf ("Key_F31 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F32) { return tl::sprintf ("Key_F32 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F33) { return tl::sprintf ("Key_F33 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F34) { return tl::sprintf ("Key_F34 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F35) { return tl::sprintf ("Key_F35 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Super_L) { return tl::sprintf ("Key_Super_L (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Super_R) { return tl::sprintf ("Key_Super_R (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Menu) { return tl::sprintf ("Key_Menu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hyper_L) { return tl::sprintf ("Key_Hyper_L (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hyper_R) { return tl::sprintf ("Key_Hyper_R (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Help) { return tl::sprintf ("Key_Help (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Direction_L) { return tl::sprintf ("Key_Direction_L (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Direction_R) { return tl::sprintf ("Key_Direction_R (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Space) { return tl::sprintf ("Key_Space (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Any) { return tl::sprintf ("Key_Any (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Exclam) { return tl::sprintf ("Key_Exclam (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_QuoteDbl) { return tl::sprintf ("Key_QuoteDbl (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_NumberSign) { return tl::sprintf ("Key_NumberSign (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dollar) { return tl::sprintf ("Key_Dollar (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Percent) { return tl::sprintf ("Key_Percent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ampersand) { return tl::sprintf ("Key_Ampersand (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Apostrophe) { return tl::sprintf ("Key_Apostrophe (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ParenLeft) { return tl::sprintf ("Key_ParenLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ParenRight) { return tl::sprintf ("Key_ParenRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Asterisk) { return tl::sprintf ("Key_Asterisk (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Plus) { return tl::sprintf ("Key_Plus (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Comma) { return tl::sprintf ("Key_Comma (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Minus) { return tl::sprintf ("Key_Minus (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Period) { return tl::sprintf ("Key_Period (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Slash) { return tl::sprintf ("Key_Slash (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_0) { return tl::sprintf ("Key_0 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_1) { return tl::sprintf ("Key_1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_2) { return tl::sprintf ("Key_2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_3) { return tl::sprintf ("Key_3 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_4) { return tl::sprintf ("Key_4 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_5) { return tl::sprintf ("Key_5 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_6) { return tl::sprintf ("Key_6 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_7) { return tl::sprintf ("Key_7 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_8) { return tl::sprintf ("Key_8 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_9) { return tl::sprintf ("Key_9 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Colon) { return tl::sprintf ("Key_Colon (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Semicolon) { return tl::sprintf ("Key_Semicolon (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Less) { return tl::sprintf ("Key_Less (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Equal) { return tl::sprintf ("Key_Equal (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Greater) { return tl::sprintf ("Key_Greater (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Question) { return tl::sprintf ("Key_Question (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_At) { return tl::sprintf ("Key_At (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_A) { return tl::sprintf ("Key_A (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_B) { return tl::sprintf ("Key_B (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_C) { return tl::sprintf ("Key_C (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_D) { return tl::sprintf ("Key_D (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_E) { return tl::sprintf ("Key_E (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_F) { return tl::sprintf ("Key_F (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_G) { return tl::sprintf ("Key_G (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_H) { return tl::sprintf ("Key_H (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_I) { return tl::sprintf ("Key_I (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_J) { return tl::sprintf ("Key_J (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_K) { return tl::sprintf ("Key_K (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_L) { return tl::sprintf ("Key_L (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_M) { return tl::sprintf ("Key_M (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_N) { return tl::sprintf ("Key_N (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_O) { return tl::sprintf ("Key_O (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_P) { return tl::sprintf ("Key_P (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Q) { return tl::sprintf ("Key_Q (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_R) { return tl::sprintf ("Key_R (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_S) { return tl::sprintf ("Key_S (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_T) { return tl::sprintf ("Key_T (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_U) { return tl::sprintf ("Key_U (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_V) { return tl::sprintf ("Key_V (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_W) { return tl::sprintf ("Key_W (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_X) { return tl::sprintf ("Key_X (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Y) { return tl::sprintf ("Key_Y (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Z) { return tl::sprintf ("Key_Z (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_BracketLeft) { return tl::sprintf ("Key_BracketLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Backslash) { return tl::sprintf ("Key_Backslash (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_BracketRight) { return tl::sprintf ("Key_BracketRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AsciiCircum) { return tl::sprintf ("Key_AsciiCircum (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Underscore) { return tl::sprintf ("Key_Underscore (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_QuoteLeft) { return tl::sprintf ("Key_QuoteLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_BraceLeft) { return tl::sprintf ("Key_BraceLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Bar) { return tl::sprintf ("Key_Bar (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_BraceRight) { return tl::sprintf ("Key_BraceRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AsciiTilde) { return tl::sprintf ("Key_AsciiTilde (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_nobreakspace) { return tl::sprintf ("Key_nobreakspace (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_exclamdown) { return tl::sprintf ("Key_exclamdown (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_cent) { return tl::sprintf ("Key_cent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_sterling) { return tl::sprintf ("Key_sterling (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_currency) { return tl::sprintf ("Key_currency (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_yen) { return tl::sprintf ("Key_yen (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_brokenbar) { return tl::sprintf ("Key_brokenbar (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_section) { return tl::sprintf ("Key_section (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_diaeresis) { return tl::sprintf ("Key_diaeresis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_copyright) { return tl::sprintf ("Key_copyright (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ordfeminine) { return tl::sprintf ("Key_ordfeminine (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_guillemotleft) { return tl::sprintf ("Key_guillemotleft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_notsign) { return tl::sprintf ("Key_notsign (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_hyphen) { return tl::sprintf ("Key_hyphen (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_registered) { return tl::sprintf ("Key_registered (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_macron) { return tl::sprintf ("Key_macron (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_degree) { return tl::sprintf ("Key_degree (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_plusminus) { return tl::sprintf ("Key_plusminus (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_twosuperior) { return tl::sprintf ("Key_twosuperior (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_threesuperior) { return tl::sprintf ("Key_threesuperior (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_acute) { return tl::sprintf ("Key_acute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_mu) { return tl::sprintf ("Key_mu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_paragraph) { return tl::sprintf ("Key_paragraph (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_periodcentered) { return tl::sprintf ("Key_periodcentered (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_cedilla) { return tl::sprintf ("Key_cedilla (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_onesuperior) { return tl::sprintf ("Key_onesuperior (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_masculine) { return tl::sprintf ("Key_masculine (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_guillemotright) { return tl::sprintf ("Key_guillemotright (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_onequarter) { return tl::sprintf ("Key_onequarter (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_onehalf) { return tl::sprintf ("Key_onehalf (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_threequarters) { return tl::sprintf ("Key_threequarters (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_questiondown) { return tl::sprintf ("Key_questiondown (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Agrave) { return tl::sprintf ("Key_Agrave (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Aacute) { return tl::sprintf ("Key_Aacute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Acircumflex) { return tl::sprintf ("Key_Acircumflex (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Atilde) { return tl::sprintf ("Key_Atilde (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Adiaeresis) { return tl::sprintf ("Key_Adiaeresis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Aring) { return tl::sprintf ("Key_Aring (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AE) { return tl::sprintf ("Key_AE (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ccedilla) { return tl::sprintf ("Key_Ccedilla (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Egrave) { return tl::sprintf ("Key_Egrave (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Eacute) { return tl::sprintf ("Key_Eacute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ecircumflex) { return tl::sprintf ("Key_Ecircumflex (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ediaeresis) { return tl::sprintf ("Key_Ediaeresis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Igrave) { return tl::sprintf ("Key_Igrave (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Iacute) { return tl::sprintf ("Key_Iacute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Icircumflex) { return tl::sprintf ("Key_Icircumflex (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Idiaeresis) { return tl::sprintf ("Key_Idiaeresis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ETH) { return tl::sprintf ("Key_ETH (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ntilde) { return tl::sprintf ("Key_Ntilde (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ograve) { return tl::sprintf ("Key_Ograve (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Oacute) { return tl::sprintf ("Key_Oacute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ocircumflex) { return tl::sprintf ("Key_Ocircumflex (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Otilde) { return tl::sprintf ("Key_Otilde (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Odiaeresis) { return tl::sprintf ("Key_Odiaeresis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_multiply) { return tl::sprintf ("Key_multiply (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ooblique) { return tl::sprintf ("Key_Ooblique (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ugrave) { return tl::sprintf ("Key_Ugrave (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Uacute) { return tl::sprintf ("Key_Uacute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Ucircumflex) { return tl::sprintf ("Key_Ucircumflex (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Udiaeresis) { return tl::sprintf ("Key_Udiaeresis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Yacute) { return tl::sprintf ("Key_Yacute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_THORN) { return tl::sprintf ("Key_THORN (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ssharp) { return tl::sprintf ("Key_ssharp (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_division) { return tl::sprintf ("Key_division (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ydiaeresis) { return tl::sprintf ("Key_ydiaeresis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AltGr) { return tl::sprintf ("Key_AltGr (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Multi_key) { return tl::sprintf ("Key_Multi_key (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Codeinput) { return tl::sprintf ("Key_Codeinput (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_SingleCandidate) { return tl::sprintf ("Key_SingleCandidate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MultipleCandidate) { return tl::sprintf ("Key_MultipleCandidate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_PreviousCandidate) { return tl::sprintf ("Key_PreviousCandidate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Mode_switch) { return tl::sprintf ("Key_Mode_switch (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Kanji) { return tl::sprintf ("Key_Kanji (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Muhenkan) { return tl::sprintf ("Key_Muhenkan (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Henkan) { return tl::sprintf ("Key_Henkan (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Romaji) { return tl::sprintf ("Key_Romaji (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hiragana) { return tl::sprintf ("Key_Hiragana (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Katakana) { return tl::sprintf ("Key_Katakana (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hiragana_Katakana) { return tl::sprintf ("Key_Hiragana_Katakana (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Zenkaku) { return tl::sprintf ("Key_Zenkaku (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hankaku) { return tl::sprintf ("Key_Hankaku (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Zenkaku_Hankaku) { return tl::sprintf ("Key_Zenkaku_Hankaku (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Touroku) { return tl::sprintf ("Key_Touroku (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Massyo) { return tl::sprintf ("Key_Massyo (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Kana_Lock) { return tl::sprintf ("Key_Kana_Lock (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Kana_Shift) { return tl::sprintf ("Key_Kana_Shift (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Eisu_Shift) { return tl::sprintf ("Key_Eisu_Shift (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Eisu_toggle) { return tl::sprintf ("Key_Eisu_toggle (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul) { return tl::sprintf ("Key_Hangul (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_Start) { return tl::sprintf ("Key_Hangul_Start (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_End) { return tl::sprintf ("Key_Hangul_End (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_Hanja) { return tl::sprintf ("Key_Hangul_Hanja (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_Jamo) { return tl::sprintf ("Key_Hangul_Jamo (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_Romaja) { return tl::sprintf ("Key_Hangul_Romaja (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_Jeonja) { return tl::sprintf ("Key_Hangul_Jeonja (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_Banja) { return tl::sprintf ("Key_Hangul_Banja (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_PreHanja) { return tl::sprintf ("Key_Hangul_PreHanja (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_PostHanja) { return tl::sprintf ("Key_Hangul_PostHanja (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangul_Special) { return tl::sprintf ("Key_Hangul_Special (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Grave) { return tl::sprintf ("Key_Dead_Grave (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Acute) { return tl::sprintf ("Key_Dead_Acute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Circumflex) { return tl::sprintf ("Key_Dead_Circumflex (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Tilde) { return tl::sprintf ("Key_Dead_Tilde (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Macron) { return tl::sprintf ("Key_Dead_Macron (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Breve) { return tl::sprintf ("Key_Dead_Breve (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Abovedot) { return tl::sprintf ("Key_Dead_Abovedot (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Diaeresis) { return tl::sprintf ("Key_Dead_Diaeresis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Abovering) { return tl::sprintf ("Key_Dead_Abovering (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Doubleacute) { return tl::sprintf ("Key_Dead_Doubleacute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Caron) { return tl::sprintf ("Key_Dead_Caron (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Cedilla) { return tl::sprintf ("Key_Dead_Cedilla (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Ogonek) { return tl::sprintf ("Key_Dead_Ogonek (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Iota) { return tl::sprintf ("Key_Dead_Iota (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Voiced_Sound) { return tl::sprintf ("Key_Dead_Voiced_Sound (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Semivoiced_Sound) { return tl::sprintf ("Key_Dead_Semivoiced_Sound (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Belowdot) { return tl::sprintf ("Key_Dead_Belowdot (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Hook) { return tl::sprintf ("Key_Dead_Hook (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Dead_Horn) { return tl::sprintf ("Key_Dead_Horn (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Back) { return tl::sprintf ("Key_Back (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Forward) { return tl::sprintf ("Key_Forward (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Stop) { return tl::sprintf ("Key_Stop (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Refresh) { return tl::sprintf ("Key_Refresh (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_VolumeDown) { return tl::sprintf ("Key_VolumeDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_VolumeMute) { return tl::sprintf ("Key_VolumeMute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_VolumeUp) { return tl::sprintf ("Key_VolumeUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_BassBoost) { return tl::sprintf ("Key_BassBoost (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_BassUp) { return tl::sprintf ("Key_BassUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_BassDown) { return tl::sprintf ("Key_BassDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_TrebleUp) { return tl::sprintf ("Key_TrebleUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_TrebleDown) { return tl::sprintf ("Key_TrebleDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MediaPlay) { return tl::sprintf ("Key_MediaPlay (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MediaStop) { return tl::sprintf ("Key_MediaStop (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MediaPrevious) { return tl::sprintf ("Key_MediaPrevious (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MediaNext) { return tl::sprintf ("Key_MediaNext (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MediaRecord) { return tl::sprintf ("Key_MediaRecord (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_HomePage) { return tl::sprintf ("Key_HomePage (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Favorites) { return tl::sprintf ("Key_Favorites (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Search) { return tl::sprintf ("Key_Search (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Standby) { return tl::sprintf ("Key_Standby (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_OpenUrl) { return tl::sprintf ("Key_OpenUrl (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LaunchMail) { return tl::sprintf ("Key_LaunchMail (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LaunchMedia) { return tl::sprintf ("Key_LaunchMedia (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch0) { return tl::sprintf ("Key_Launch0 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch1) { return tl::sprintf ("Key_Launch1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch2) { return tl::sprintf ("Key_Launch2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch3) { return tl::sprintf ("Key_Launch3 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch4) { return tl::sprintf ("Key_Launch4 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch5) { return tl::sprintf ("Key_Launch5 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch6) { return tl::sprintf ("Key_Launch6 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch7) { return tl::sprintf ("Key_Launch7 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch8) { return tl::sprintf ("Key_Launch8 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Launch9) { return tl::sprintf ("Key_Launch9 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LaunchA) { return tl::sprintf ("Key_LaunchA (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LaunchB) { return tl::sprintf ("Key_LaunchB (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LaunchC) { return tl::sprintf ("Key_LaunchC (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LaunchD) { return tl::sprintf ("Key_LaunchD (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LaunchE) { return tl::sprintf ("Key_LaunchE (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LaunchF) { return tl::sprintf ("Key_LaunchF (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MonBrightnessUp) { return tl::sprintf ("Key_MonBrightnessUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MonBrightnessDown) { return tl::sprintf ("Key_MonBrightnessDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_KeyboardLightOnOff) { return tl::sprintf ("Key_KeyboardLightOnOff (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_KeyboardBrightnessUp) { return tl::sprintf ("Key_KeyboardBrightnessUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_KeyboardBrightnessDown) { return tl::sprintf ("Key_KeyboardBrightnessDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_PowerOff) { return tl::sprintf ("Key_PowerOff (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_WakeUp) { return tl::sprintf ("Key_WakeUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Eject) { return tl::sprintf ("Key_Eject (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ScreenSaver) { return tl::sprintf ("Key_ScreenSaver (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_WWW) { return tl::sprintf ("Key_WWW (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Memo) { return tl::sprintf ("Key_Memo (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LightBulb) { return tl::sprintf ("Key_LightBulb (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Shop) { return tl::sprintf ("Key_Shop (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_History) { return tl::sprintf ("Key_History (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AddFavorite) { return tl::sprintf ("Key_AddFavorite (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_HotLinks) { return tl::sprintf ("Key_HotLinks (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_BrightnessAdjust) { return tl::sprintf ("Key_BrightnessAdjust (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Finance) { return tl::sprintf ("Key_Finance (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Community) { return tl::sprintf ("Key_Community (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AudioRewind) { return tl::sprintf ("Key_AudioRewind (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_BackForward) { return tl::sprintf ("Key_BackForward (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ApplicationLeft) { return tl::sprintf ("Key_ApplicationLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ApplicationRight) { return tl::sprintf ("Key_ApplicationRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Book) { return tl::sprintf ("Key_Book (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_CD) { return tl::sprintf ("Key_CD (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Calculator) { return tl::sprintf ("Key_Calculator (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ToDoList) { return tl::sprintf ("Key_ToDoList (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ClearGrab) { return tl::sprintf ("Key_ClearGrab (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Close) { return tl::sprintf ("Key_Close (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Copy) { return tl::sprintf ("Key_Copy (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Cut) { return tl::sprintf ("Key_Cut (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Display) { return tl::sprintf ("Key_Display (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_DOS) { return tl::sprintf ("Key_DOS (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Documents) { return tl::sprintf ("Key_Documents (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Excel) { return tl::sprintf ("Key_Excel (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Explorer) { return tl::sprintf ("Key_Explorer (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Game) { return tl::sprintf ("Key_Game (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Go) { return tl::sprintf ("Key_Go (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_iTouch) { return tl::sprintf ("Key_iTouch (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_LogOff) { return tl::sprintf ("Key_LogOff (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Market) { return tl::sprintf ("Key_Market (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Meeting) { return tl::sprintf ("Key_Meeting (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MenuKB) { return tl::sprintf ("Key_MenuKB (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MenuPB) { return tl::sprintf ("Key_MenuPB (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MySites) { return tl::sprintf ("Key_MySites (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_News) { return tl::sprintf ("Key_News (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_OfficeHome) { return tl::sprintf ("Key_OfficeHome (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Option) { return tl::sprintf ("Key_Option (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Paste) { return tl::sprintf ("Key_Paste (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Phone) { return tl::sprintf ("Key_Phone (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Calendar) { return tl::sprintf ("Key_Calendar (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Reply) { return tl::sprintf ("Key_Reply (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Reload) { return tl::sprintf ("Key_Reload (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_RotateWindows) { return tl::sprintf ("Key_RotateWindows (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_RotationPB) { return tl::sprintf ("Key_RotationPB (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_RotationKB) { return tl::sprintf ("Key_RotationKB (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Save) { return tl::sprintf ("Key_Save (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Send) { return tl::sprintf ("Key_Send (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Spell) { return tl::sprintf ("Key_Spell (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_SplitScreen) { return tl::sprintf ("Key_SplitScreen (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Support) { return tl::sprintf ("Key_Support (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_TaskPane) { return tl::sprintf ("Key_TaskPane (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Terminal) { return tl::sprintf ("Key_Terminal (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Tools) { return tl::sprintf ("Key_Tools (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Travel) { return tl::sprintf ("Key_Travel (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Video) { return tl::sprintf ("Key_Video (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Word) { return tl::sprintf ("Key_Word (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Xfer) { return tl::sprintf ("Key_Xfer (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ZoomIn) { return tl::sprintf ("Key_ZoomIn (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ZoomOut) { return tl::sprintf ("Key_ZoomOut (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Away) { return tl::sprintf ("Key_Away (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Messenger) { return tl::sprintf ("Key_Messenger (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_WebCam) { return tl::sprintf ("Key_WebCam (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MailForward) { return tl::sprintf ("Key_MailForward (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Pictures) { return tl::sprintf ("Key_Pictures (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Music) { return tl::sprintf ("Key_Music (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Battery) { return tl::sprintf ("Key_Battery (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Bluetooth) { return tl::sprintf ("Key_Bluetooth (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_WLAN) { return tl::sprintf ("Key_WLAN (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_UWB) { return tl::sprintf ("Key_UWB (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AudioForward) { return tl::sprintf ("Key_AudioForward (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AudioRepeat) { return tl::sprintf ("Key_AudioRepeat (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AudioRandomPlay) { return tl::sprintf ("Key_AudioRandomPlay (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Subtitle) { return tl::sprintf ("Key_Subtitle (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_AudioCycleTrack) { return tl::sprintf ("Key_AudioCycleTrack (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Time) { return tl::sprintf ("Key_Time (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hibernate) { return tl::sprintf ("Key_Hibernate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_View) { return tl::sprintf ("Key_View (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_TopMenu) { return tl::sprintf ("Key_TopMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_PowerDown) { return tl::sprintf ("Key_PowerDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Suspend) { return tl::sprintf ("Key_Suspend (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_ContrastAdjust) { return tl::sprintf ("Key_ContrastAdjust (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_MediaLast) { return tl::sprintf ("Key_MediaLast (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Select) { return tl::sprintf ("Key_Select (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Yes) { return tl::sprintf ("Key_Yes (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_No) { return tl::sprintf ("Key_No (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Cancel) { return tl::sprintf ("Key_Cancel (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Printer) { return tl::sprintf ("Key_Printer (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Execute) { return tl::sprintf ("Key_Execute (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Sleep) { return tl::sprintf ("Key_Sleep (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Play) { return tl::sprintf ("Key_Play (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Zoom) { return tl::sprintf ("Key_Zoom (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Context1) { return tl::sprintf ("Key_Context1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Context2) { return tl::sprintf ("Key_Context2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Context3) { return tl::sprintf ("Key_Context3 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Context4) { return tl::sprintf ("Key_Context4 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Call) { return tl::sprintf ("Key_Call (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Hangup) { return tl::sprintf ("Key_Hangup (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_Flip) { return tl::sprintf ("Key_Flip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Key_unknown) { return tl::sprintf ("Key_unknown (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_Key_Enum (const Qt_Key_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_Key_Enum *from_i_Qt_Key_Enum (unsigned int i)
{
  return new Qt_Key_Enum ((Qt::Key) i);
}

static bool equalQt_Key_Enum (const Qt_Key_Enum *e, Qt_Key_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_Key_Enum (const Qt_Key_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_Key_Enums oropQt_Key_Enums (const Qt_Key_Enums *e, const Qt_Key_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_Key_Enums andopQt_Key_Enums (const Qt_Key_Enums *e, const Qt_Key_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_Key_Enums xoropQt_Key_Enums (const Qt_Key_Enums *e, const Qt_Key_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_Key_Enums (const Qt_Key_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::Key_Escape)) { if (!l.empty ()) l += "|"; l += "Key_Escape"; }
  if (e->testFlag (Qt::Key_Tab)) { if (!l.empty ()) l += "|"; l += "Key_Tab"; }
  if (e->testFlag (Qt::Key_Backtab)) { if (!l.empty ()) l += "|"; l += "Key_Backtab"; }
  if (e->testFlag (Qt::Key_Backspace)) { if (!l.empty ()) l += "|"; l += "Key_Backspace"; }
  if (e->testFlag (Qt::Key_Return)) { if (!l.empty ()) l += "|"; l += "Key_Return"; }
  if (e->testFlag (Qt::Key_Enter)) { if (!l.empty ()) l += "|"; l += "Key_Enter"; }
  if (e->testFlag (Qt::Key_Insert)) { if (!l.empty ()) l += "|"; l += "Key_Insert"; }
  if (e->testFlag (Qt::Key_Delete)) { if (!l.empty ()) l += "|"; l += "Key_Delete"; }
  if (e->testFlag (Qt::Key_Pause)) { if (!l.empty ()) l += "|"; l += "Key_Pause"; }
  if (e->testFlag (Qt::Key_Print)) { if (!l.empty ()) l += "|"; l += "Key_Print"; }
  if (e->testFlag (Qt::Key_SysReq)) { if (!l.empty ()) l += "|"; l += "Key_SysReq"; }
  if (e->testFlag (Qt::Key_Clear)) { if (!l.empty ()) l += "|"; l += "Key_Clear"; }
  if (e->testFlag (Qt::Key_Home)) { if (!l.empty ()) l += "|"; l += "Key_Home"; }
  if (e->testFlag (Qt::Key_End)) { if (!l.empty ()) l += "|"; l += "Key_End"; }
  if (e->testFlag (Qt::Key_Left)) { if (!l.empty ()) l += "|"; l += "Key_Left"; }
  if (e->testFlag (Qt::Key_Up)) { if (!l.empty ()) l += "|"; l += "Key_Up"; }
  if (e->testFlag (Qt::Key_Right)) { if (!l.empty ()) l += "|"; l += "Key_Right"; }
  if (e->testFlag (Qt::Key_Down)) { if (!l.empty ()) l += "|"; l += "Key_Down"; }
  if (e->testFlag (Qt::Key_PageUp)) { if (!l.empty ()) l += "|"; l += "Key_PageUp"; }
  if (e->testFlag (Qt::Key_PageDown)) { if (!l.empty ()) l += "|"; l += "Key_PageDown"; }
  if (e->testFlag (Qt::Key_Shift)) { if (!l.empty ()) l += "|"; l += "Key_Shift"; }
  if (e->testFlag (Qt::Key_Control)) { if (!l.empty ()) l += "|"; l += "Key_Control"; }
  if (e->testFlag (Qt::Key_Meta)) { if (!l.empty ()) l += "|"; l += "Key_Meta"; }
  if (e->testFlag (Qt::Key_Alt)) { if (!l.empty ()) l += "|"; l += "Key_Alt"; }
  if (e->testFlag (Qt::Key_CapsLock)) { if (!l.empty ()) l += "|"; l += "Key_CapsLock"; }
  if (e->testFlag (Qt::Key_NumLock)) { if (!l.empty ()) l += "|"; l += "Key_NumLock"; }
  if (e->testFlag (Qt::Key_ScrollLock)) { if (!l.empty ()) l += "|"; l += "Key_ScrollLock"; }
  if (e->testFlag (Qt::Key_F1)) { if (!l.empty ()) l += "|"; l += "Key_F1"; }
  if (e->testFlag (Qt::Key_F2)) { if (!l.empty ()) l += "|"; l += "Key_F2"; }
  if (e->testFlag (Qt::Key_F3)) { if (!l.empty ()) l += "|"; l += "Key_F3"; }
  if (e->testFlag (Qt::Key_F4)) { if (!l.empty ()) l += "|"; l += "Key_F4"; }
  if (e->testFlag (Qt::Key_F5)) { if (!l.empty ()) l += "|"; l += "Key_F5"; }
  if (e->testFlag (Qt::Key_F6)) { if (!l.empty ()) l += "|"; l += "Key_F6"; }
  if (e->testFlag (Qt::Key_F7)) { if (!l.empty ()) l += "|"; l += "Key_F7"; }
  if (e->testFlag (Qt::Key_F8)) { if (!l.empty ()) l += "|"; l += "Key_F8"; }
  if (e->testFlag (Qt::Key_F9)) { if (!l.empty ()) l += "|"; l += "Key_F9"; }
  if (e->testFlag (Qt::Key_F10)) { if (!l.empty ()) l += "|"; l += "Key_F10"; }
  if (e->testFlag (Qt::Key_F11)) { if (!l.empty ()) l += "|"; l += "Key_F11"; }
  if (e->testFlag (Qt::Key_F12)) { if (!l.empty ()) l += "|"; l += "Key_F12"; }
  if (e->testFlag (Qt::Key_F13)) { if (!l.empty ()) l += "|"; l += "Key_F13"; }
  if (e->testFlag (Qt::Key_F14)) { if (!l.empty ()) l += "|"; l += "Key_F14"; }
  if (e->testFlag (Qt::Key_F15)) { if (!l.empty ()) l += "|"; l += "Key_F15"; }
  if (e->testFlag (Qt::Key_F16)) { if (!l.empty ()) l += "|"; l += "Key_F16"; }
  if (e->testFlag (Qt::Key_F17)) { if (!l.empty ()) l += "|"; l += "Key_F17"; }
  if (e->testFlag (Qt::Key_F18)) { if (!l.empty ()) l += "|"; l += "Key_F18"; }
  if (e->testFlag (Qt::Key_F19)) { if (!l.empty ()) l += "|"; l += "Key_F19"; }
  if (e->testFlag (Qt::Key_F20)) { if (!l.empty ()) l += "|"; l += "Key_F20"; }
  if (e->testFlag (Qt::Key_F21)) { if (!l.empty ()) l += "|"; l += "Key_F21"; }
  if (e->testFlag (Qt::Key_F22)) { if (!l.empty ()) l += "|"; l += "Key_F22"; }
  if (e->testFlag (Qt::Key_F23)) { if (!l.empty ()) l += "|"; l += "Key_F23"; }
  if (e->testFlag (Qt::Key_F24)) { if (!l.empty ()) l += "|"; l += "Key_F24"; }
  if (e->testFlag (Qt::Key_F25)) { if (!l.empty ()) l += "|"; l += "Key_F25"; }
  if (e->testFlag (Qt::Key_F26)) { if (!l.empty ()) l += "|"; l += "Key_F26"; }
  if (e->testFlag (Qt::Key_F27)) { if (!l.empty ()) l += "|"; l += "Key_F27"; }
  if (e->testFlag (Qt::Key_F28)) { if (!l.empty ()) l += "|"; l += "Key_F28"; }
  if (e->testFlag (Qt::Key_F29)) { if (!l.empty ()) l += "|"; l += "Key_F29"; }
  if (e->testFlag (Qt::Key_F30)) { if (!l.empty ()) l += "|"; l += "Key_F30"; }
  if (e->testFlag (Qt::Key_F31)) { if (!l.empty ()) l += "|"; l += "Key_F31"; }
  if (e->testFlag (Qt::Key_F32)) { if (!l.empty ()) l += "|"; l += "Key_F32"; }
  if (e->testFlag (Qt::Key_F33)) { if (!l.empty ()) l += "|"; l += "Key_F33"; }
  if (e->testFlag (Qt::Key_F34)) { if (!l.empty ()) l += "|"; l += "Key_F34"; }
  if (e->testFlag (Qt::Key_F35)) { if (!l.empty ()) l += "|"; l += "Key_F35"; }
  if (e->testFlag (Qt::Key_Super_L)) { if (!l.empty ()) l += "|"; l += "Key_Super_L"; }
  if (e->testFlag (Qt::Key_Super_R)) { if (!l.empty ()) l += "|"; l += "Key_Super_R"; }
  if (e->testFlag (Qt::Key_Menu)) { if (!l.empty ()) l += "|"; l += "Key_Menu"; }
  if (e->testFlag (Qt::Key_Hyper_L)) { if (!l.empty ()) l += "|"; l += "Key_Hyper_L"; }
  if (e->testFlag (Qt::Key_Hyper_R)) { if (!l.empty ()) l += "|"; l += "Key_Hyper_R"; }
  if (e->testFlag (Qt::Key_Help)) { if (!l.empty ()) l += "|"; l += "Key_Help"; }
  if (e->testFlag (Qt::Key_Direction_L)) { if (!l.empty ()) l += "|"; l += "Key_Direction_L"; }
  if (e->testFlag (Qt::Key_Direction_R)) { if (!l.empty ()) l += "|"; l += "Key_Direction_R"; }
  if (e->testFlag (Qt::Key_Space)) { if (!l.empty ()) l += "|"; l += "Key_Space"; }
  if (e->testFlag (Qt::Key_Any)) { if (!l.empty ()) l += "|"; l += "Key_Any"; }
  if (e->testFlag (Qt::Key_Exclam)) { if (!l.empty ()) l += "|"; l += "Key_Exclam"; }
  if (e->testFlag (Qt::Key_QuoteDbl)) { if (!l.empty ()) l += "|"; l += "Key_QuoteDbl"; }
  if (e->testFlag (Qt::Key_NumberSign)) { if (!l.empty ()) l += "|"; l += "Key_NumberSign"; }
  if (e->testFlag (Qt::Key_Dollar)) { if (!l.empty ()) l += "|"; l += "Key_Dollar"; }
  if (e->testFlag (Qt::Key_Percent)) { if (!l.empty ()) l += "|"; l += "Key_Percent"; }
  if (e->testFlag (Qt::Key_Ampersand)) { if (!l.empty ()) l += "|"; l += "Key_Ampersand"; }
  if (e->testFlag (Qt::Key_Apostrophe)) { if (!l.empty ()) l += "|"; l += "Key_Apostrophe"; }
  if (e->testFlag (Qt::Key_ParenLeft)) { if (!l.empty ()) l += "|"; l += "Key_ParenLeft"; }
  if (e->testFlag (Qt::Key_ParenRight)) { if (!l.empty ()) l += "|"; l += "Key_ParenRight"; }
  if (e->testFlag (Qt::Key_Asterisk)) { if (!l.empty ()) l += "|"; l += "Key_Asterisk"; }
  if (e->testFlag (Qt::Key_Plus)) { if (!l.empty ()) l += "|"; l += "Key_Plus"; }
  if (e->testFlag (Qt::Key_Comma)) { if (!l.empty ()) l += "|"; l += "Key_Comma"; }
  if (e->testFlag (Qt::Key_Minus)) { if (!l.empty ()) l += "|"; l += "Key_Minus"; }
  if (e->testFlag (Qt::Key_Period)) { if (!l.empty ()) l += "|"; l += "Key_Period"; }
  if (e->testFlag (Qt::Key_Slash)) { if (!l.empty ()) l += "|"; l += "Key_Slash"; }
  if (e->testFlag (Qt::Key_0)) { if (!l.empty ()) l += "|"; l += "Key_0"; }
  if (e->testFlag (Qt::Key_1)) { if (!l.empty ()) l += "|"; l += "Key_1"; }
  if (e->testFlag (Qt::Key_2)) { if (!l.empty ()) l += "|"; l += "Key_2"; }
  if (e->testFlag (Qt::Key_3)) { if (!l.empty ()) l += "|"; l += "Key_3"; }
  if (e->testFlag (Qt::Key_4)) { if (!l.empty ()) l += "|"; l += "Key_4"; }
  if (e->testFlag (Qt::Key_5)) { if (!l.empty ()) l += "|"; l += "Key_5"; }
  if (e->testFlag (Qt::Key_6)) { if (!l.empty ()) l += "|"; l += "Key_6"; }
  if (e->testFlag (Qt::Key_7)) { if (!l.empty ()) l += "|"; l += "Key_7"; }
  if (e->testFlag (Qt::Key_8)) { if (!l.empty ()) l += "|"; l += "Key_8"; }
  if (e->testFlag (Qt::Key_9)) { if (!l.empty ()) l += "|"; l += "Key_9"; }
  if (e->testFlag (Qt::Key_Colon)) { if (!l.empty ()) l += "|"; l += "Key_Colon"; }
  if (e->testFlag (Qt::Key_Semicolon)) { if (!l.empty ()) l += "|"; l += "Key_Semicolon"; }
  if (e->testFlag (Qt::Key_Less)) { if (!l.empty ()) l += "|"; l += "Key_Less"; }
  if (e->testFlag (Qt::Key_Equal)) { if (!l.empty ()) l += "|"; l += "Key_Equal"; }
  if (e->testFlag (Qt::Key_Greater)) { if (!l.empty ()) l += "|"; l += "Key_Greater"; }
  if (e->testFlag (Qt::Key_Question)) { if (!l.empty ()) l += "|"; l += "Key_Question"; }
  if (e->testFlag (Qt::Key_At)) { if (!l.empty ()) l += "|"; l += "Key_At"; }
  if (e->testFlag (Qt::Key_A)) { if (!l.empty ()) l += "|"; l += "Key_A"; }
  if (e->testFlag (Qt::Key_B)) { if (!l.empty ()) l += "|"; l += "Key_B"; }
  if (e->testFlag (Qt::Key_C)) { if (!l.empty ()) l += "|"; l += "Key_C"; }
  if (e->testFlag (Qt::Key_D)) { if (!l.empty ()) l += "|"; l += "Key_D"; }
  if (e->testFlag (Qt::Key_E)) { if (!l.empty ()) l += "|"; l += "Key_E"; }
  if (e->testFlag (Qt::Key_F)) { if (!l.empty ()) l += "|"; l += "Key_F"; }
  if (e->testFlag (Qt::Key_G)) { if (!l.empty ()) l += "|"; l += "Key_G"; }
  if (e->testFlag (Qt::Key_H)) { if (!l.empty ()) l += "|"; l += "Key_H"; }
  if (e->testFlag (Qt::Key_I)) { if (!l.empty ()) l += "|"; l += "Key_I"; }
  if (e->testFlag (Qt::Key_J)) { if (!l.empty ()) l += "|"; l += "Key_J"; }
  if (e->testFlag (Qt::Key_K)) { if (!l.empty ()) l += "|"; l += "Key_K"; }
  if (e->testFlag (Qt::Key_L)) { if (!l.empty ()) l += "|"; l += "Key_L"; }
  if (e->testFlag (Qt::Key_M)) { if (!l.empty ()) l += "|"; l += "Key_M"; }
  if (e->testFlag (Qt::Key_N)) { if (!l.empty ()) l += "|"; l += "Key_N"; }
  if (e->testFlag (Qt::Key_O)) { if (!l.empty ()) l += "|"; l += "Key_O"; }
  if (e->testFlag (Qt::Key_P)) { if (!l.empty ()) l += "|"; l += "Key_P"; }
  if (e->testFlag (Qt::Key_Q)) { if (!l.empty ()) l += "|"; l += "Key_Q"; }
  if (e->testFlag (Qt::Key_R)) { if (!l.empty ()) l += "|"; l += "Key_R"; }
  if (e->testFlag (Qt::Key_S)) { if (!l.empty ()) l += "|"; l += "Key_S"; }
  if (e->testFlag (Qt::Key_T)) { if (!l.empty ()) l += "|"; l += "Key_T"; }
  if (e->testFlag (Qt::Key_U)) { if (!l.empty ()) l += "|"; l += "Key_U"; }
  if (e->testFlag (Qt::Key_V)) { if (!l.empty ()) l += "|"; l += "Key_V"; }
  if (e->testFlag (Qt::Key_W)) { if (!l.empty ()) l += "|"; l += "Key_W"; }
  if (e->testFlag (Qt::Key_X)) { if (!l.empty ()) l += "|"; l += "Key_X"; }
  if (e->testFlag (Qt::Key_Y)) { if (!l.empty ()) l += "|"; l += "Key_Y"; }
  if (e->testFlag (Qt::Key_Z)) { if (!l.empty ()) l += "|"; l += "Key_Z"; }
  if (e->testFlag (Qt::Key_BracketLeft)) { if (!l.empty ()) l += "|"; l += "Key_BracketLeft"; }
  if (e->testFlag (Qt::Key_Backslash)) { if (!l.empty ()) l += "|"; l += "Key_Backslash"; }
  if (e->testFlag (Qt::Key_BracketRight)) { if (!l.empty ()) l += "|"; l += "Key_BracketRight"; }
  if (e->testFlag (Qt::Key_AsciiCircum)) { if (!l.empty ()) l += "|"; l += "Key_AsciiCircum"; }
  if (e->testFlag (Qt::Key_Underscore)) { if (!l.empty ()) l += "|"; l += "Key_Underscore"; }
  if (e->testFlag (Qt::Key_QuoteLeft)) { if (!l.empty ()) l += "|"; l += "Key_QuoteLeft"; }
  if (e->testFlag (Qt::Key_BraceLeft)) { if (!l.empty ()) l += "|"; l += "Key_BraceLeft"; }
  if (e->testFlag (Qt::Key_Bar)) { if (!l.empty ()) l += "|"; l += "Key_Bar"; }
  if (e->testFlag (Qt::Key_BraceRight)) { if (!l.empty ()) l += "|"; l += "Key_BraceRight"; }
  if (e->testFlag (Qt::Key_AsciiTilde)) { if (!l.empty ()) l += "|"; l += "Key_AsciiTilde"; }
  if (e->testFlag (Qt::Key_nobreakspace)) { if (!l.empty ()) l += "|"; l += "Key_nobreakspace"; }
  if (e->testFlag (Qt::Key_exclamdown)) { if (!l.empty ()) l += "|"; l += "Key_exclamdown"; }
  if (e->testFlag (Qt::Key_cent)) { if (!l.empty ()) l += "|"; l += "Key_cent"; }
  if (e->testFlag (Qt::Key_sterling)) { if (!l.empty ()) l += "|"; l += "Key_sterling"; }
  if (e->testFlag (Qt::Key_currency)) { if (!l.empty ()) l += "|"; l += "Key_currency"; }
  if (e->testFlag (Qt::Key_yen)) { if (!l.empty ()) l += "|"; l += "Key_yen"; }
  if (e->testFlag (Qt::Key_brokenbar)) { if (!l.empty ()) l += "|"; l += "Key_brokenbar"; }
  if (e->testFlag (Qt::Key_section)) { if (!l.empty ()) l += "|"; l += "Key_section"; }
  if (e->testFlag (Qt::Key_diaeresis)) { if (!l.empty ()) l += "|"; l += "Key_diaeresis"; }
  if (e->testFlag (Qt::Key_copyright)) { if (!l.empty ()) l += "|"; l += "Key_copyright"; }
  if (e->testFlag (Qt::Key_ordfeminine)) { if (!l.empty ()) l += "|"; l += "Key_ordfeminine"; }
  if (e->testFlag (Qt::Key_guillemotleft)) { if (!l.empty ()) l += "|"; l += "Key_guillemotleft"; }
  if (e->testFlag (Qt::Key_notsign)) { if (!l.empty ()) l += "|"; l += "Key_notsign"; }
  if (e->testFlag (Qt::Key_hyphen)) { if (!l.empty ()) l += "|"; l += "Key_hyphen"; }
  if (e->testFlag (Qt::Key_registered)) { if (!l.empty ()) l += "|"; l += "Key_registered"; }
  if (e->testFlag (Qt::Key_macron)) { if (!l.empty ()) l += "|"; l += "Key_macron"; }
  if (e->testFlag (Qt::Key_degree)) { if (!l.empty ()) l += "|"; l += "Key_degree"; }
  if (e->testFlag (Qt::Key_plusminus)) { if (!l.empty ()) l += "|"; l += "Key_plusminus"; }
  if (e->testFlag (Qt::Key_twosuperior)) { if (!l.empty ()) l += "|"; l += "Key_twosuperior"; }
  if (e->testFlag (Qt::Key_threesuperior)) { if (!l.empty ()) l += "|"; l += "Key_threesuperior"; }
  if (e->testFlag (Qt::Key_acute)) { if (!l.empty ()) l += "|"; l += "Key_acute"; }
  if (e->testFlag (Qt::Key_mu)) { if (!l.empty ()) l += "|"; l += "Key_mu"; }
  if (e->testFlag (Qt::Key_paragraph)) { if (!l.empty ()) l += "|"; l += "Key_paragraph"; }
  if (e->testFlag (Qt::Key_periodcentered)) { if (!l.empty ()) l += "|"; l += "Key_periodcentered"; }
  if (e->testFlag (Qt::Key_cedilla)) { if (!l.empty ()) l += "|"; l += "Key_cedilla"; }
  if (e->testFlag (Qt::Key_onesuperior)) { if (!l.empty ()) l += "|"; l += "Key_onesuperior"; }
  if (e->testFlag (Qt::Key_masculine)) { if (!l.empty ()) l += "|"; l += "Key_masculine"; }
  if (e->testFlag (Qt::Key_guillemotright)) { if (!l.empty ()) l += "|"; l += "Key_guillemotright"; }
  if (e->testFlag (Qt::Key_onequarter)) { if (!l.empty ()) l += "|"; l += "Key_onequarter"; }
  if (e->testFlag (Qt::Key_onehalf)) { if (!l.empty ()) l += "|"; l += "Key_onehalf"; }
  if (e->testFlag (Qt::Key_threequarters)) { if (!l.empty ()) l += "|"; l += "Key_threequarters"; }
  if (e->testFlag (Qt::Key_questiondown)) { if (!l.empty ()) l += "|"; l += "Key_questiondown"; }
  if (e->testFlag (Qt::Key_Agrave)) { if (!l.empty ()) l += "|"; l += "Key_Agrave"; }
  if (e->testFlag (Qt::Key_Aacute)) { if (!l.empty ()) l += "|"; l += "Key_Aacute"; }
  if (e->testFlag (Qt::Key_Acircumflex)) { if (!l.empty ()) l += "|"; l += "Key_Acircumflex"; }
  if (e->testFlag (Qt::Key_Atilde)) { if (!l.empty ()) l += "|"; l += "Key_Atilde"; }
  if (e->testFlag (Qt::Key_Adiaeresis)) { if (!l.empty ()) l += "|"; l += "Key_Adiaeresis"; }
  if (e->testFlag (Qt::Key_Aring)) { if (!l.empty ()) l += "|"; l += "Key_Aring"; }
  if (e->testFlag (Qt::Key_AE)) { if (!l.empty ()) l += "|"; l += "Key_AE"; }
  if (e->testFlag (Qt::Key_Ccedilla)) { if (!l.empty ()) l += "|"; l += "Key_Ccedilla"; }
  if (e->testFlag (Qt::Key_Egrave)) { if (!l.empty ()) l += "|"; l += "Key_Egrave"; }
  if (e->testFlag (Qt::Key_Eacute)) { if (!l.empty ()) l += "|"; l += "Key_Eacute"; }
  if (e->testFlag (Qt::Key_Ecircumflex)) { if (!l.empty ()) l += "|"; l += "Key_Ecircumflex"; }
  if (e->testFlag (Qt::Key_Ediaeresis)) { if (!l.empty ()) l += "|"; l += "Key_Ediaeresis"; }
  if (e->testFlag (Qt::Key_Igrave)) { if (!l.empty ()) l += "|"; l += "Key_Igrave"; }
  if (e->testFlag (Qt::Key_Iacute)) { if (!l.empty ()) l += "|"; l += "Key_Iacute"; }
  if (e->testFlag (Qt::Key_Icircumflex)) { if (!l.empty ()) l += "|"; l += "Key_Icircumflex"; }
  if (e->testFlag (Qt::Key_Idiaeresis)) { if (!l.empty ()) l += "|"; l += "Key_Idiaeresis"; }
  if (e->testFlag (Qt::Key_ETH)) { if (!l.empty ()) l += "|"; l += "Key_ETH"; }
  if (e->testFlag (Qt::Key_Ntilde)) { if (!l.empty ()) l += "|"; l += "Key_Ntilde"; }
  if (e->testFlag (Qt::Key_Ograve)) { if (!l.empty ()) l += "|"; l += "Key_Ograve"; }
  if (e->testFlag (Qt::Key_Oacute)) { if (!l.empty ()) l += "|"; l += "Key_Oacute"; }
  if (e->testFlag (Qt::Key_Ocircumflex)) { if (!l.empty ()) l += "|"; l += "Key_Ocircumflex"; }
  if (e->testFlag (Qt::Key_Otilde)) { if (!l.empty ()) l += "|"; l += "Key_Otilde"; }
  if (e->testFlag (Qt::Key_Odiaeresis)) { if (!l.empty ()) l += "|"; l += "Key_Odiaeresis"; }
  if (e->testFlag (Qt::Key_multiply)) { if (!l.empty ()) l += "|"; l += "Key_multiply"; }
  if (e->testFlag (Qt::Key_Ooblique)) { if (!l.empty ()) l += "|"; l += "Key_Ooblique"; }
  if (e->testFlag (Qt::Key_Ugrave)) { if (!l.empty ()) l += "|"; l += "Key_Ugrave"; }
  if (e->testFlag (Qt::Key_Uacute)) { if (!l.empty ()) l += "|"; l += "Key_Uacute"; }
  if (e->testFlag (Qt::Key_Ucircumflex)) { if (!l.empty ()) l += "|"; l += "Key_Ucircumflex"; }
  if (e->testFlag (Qt::Key_Udiaeresis)) { if (!l.empty ()) l += "|"; l += "Key_Udiaeresis"; }
  if (e->testFlag (Qt::Key_Yacute)) { if (!l.empty ()) l += "|"; l += "Key_Yacute"; }
  if (e->testFlag (Qt::Key_THORN)) { if (!l.empty ()) l += "|"; l += "Key_THORN"; }
  if (e->testFlag (Qt::Key_ssharp)) { if (!l.empty ()) l += "|"; l += "Key_ssharp"; }
  if (e->testFlag (Qt::Key_division)) { if (!l.empty ()) l += "|"; l += "Key_division"; }
  if (e->testFlag (Qt::Key_ydiaeresis)) { if (!l.empty ()) l += "|"; l += "Key_ydiaeresis"; }
  if (e->testFlag (Qt::Key_AltGr)) { if (!l.empty ()) l += "|"; l += "Key_AltGr"; }
  if (e->testFlag (Qt::Key_Multi_key)) { if (!l.empty ()) l += "|"; l += "Key_Multi_key"; }
  if (e->testFlag (Qt::Key_Codeinput)) { if (!l.empty ()) l += "|"; l += "Key_Codeinput"; }
  if (e->testFlag (Qt::Key_SingleCandidate)) { if (!l.empty ()) l += "|"; l += "Key_SingleCandidate"; }
  if (e->testFlag (Qt::Key_MultipleCandidate)) { if (!l.empty ()) l += "|"; l += "Key_MultipleCandidate"; }
  if (e->testFlag (Qt::Key_PreviousCandidate)) { if (!l.empty ()) l += "|"; l += "Key_PreviousCandidate"; }
  if (e->testFlag (Qt::Key_Mode_switch)) { if (!l.empty ()) l += "|"; l += "Key_Mode_switch"; }
  if (e->testFlag (Qt::Key_Kanji)) { if (!l.empty ()) l += "|"; l += "Key_Kanji"; }
  if (e->testFlag (Qt::Key_Muhenkan)) { if (!l.empty ()) l += "|"; l += "Key_Muhenkan"; }
  if (e->testFlag (Qt::Key_Henkan)) { if (!l.empty ()) l += "|"; l += "Key_Henkan"; }
  if (e->testFlag (Qt::Key_Romaji)) { if (!l.empty ()) l += "|"; l += "Key_Romaji"; }
  if (e->testFlag (Qt::Key_Hiragana)) { if (!l.empty ()) l += "|"; l += "Key_Hiragana"; }
  if (e->testFlag (Qt::Key_Katakana)) { if (!l.empty ()) l += "|"; l += "Key_Katakana"; }
  if (e->testFlag (Qt::Key_Hiragana_Katakana)) { if (!l.empty ()) l += "|"; l += "Key_Hiragana_Katakana"; }
  if (e->testFlag (Qt::Key_Zenkaku)) { if (!l.empty ()) l += "|"; l += "Key_Zenkaku"; }
  if (e->testFlag (Qt::Key_Hankaku)) { if (!l.empty ()) l += "|"; l += "Key_Hankaku"; }
  if (e->testFlag (Qt::Key_Zenkaku_Hankaku)) { if (!l.empty ()) l += "|"; l += "Key_Zenkaku_Hankaku"; }
  if (e->testFlag (Qt::Key_Touroku)) { if (!l.empty ()) l += "|"; l += "Key_Touroku"; }
  if (e->testFlag (Qt::Key_Massyo)) { if (!l.empty ()) l += "|"; l += "Key_Massyo"; }
  if (e->testFlag (Qt::Key_Kana_Lock)) { if (!l.empty ()) l += "|"; l += "Key_Kana_Lock"; }
  if (e->testFlag (Qt::Key_Kana_Shift)) { if (!l.empty ()) l += "|"; l += "Key_Kana_Shift"; }
  if (e->testFlag (Qt::Key_Eisu_Shift)) { if (!l.empty ()) l += "|"; l += "Key_Eisu_Shift"; }
  if (e->testFlag (Qt::Key_Eisu_toggle)) { if (!l.empty ()) l += "|"; l += "Key_Eisu_toggle"; }
  if (e->testFlag (Qt::Key_Hangul)) { if (!l.empty ()) l += "|"; l += "Key_Hangul"; }
  if (e->testFlag (Qt::Key_Hangul_Start)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_Start"; }
  if (e->testFlag (Qt::Key_Hangul_End)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_End"; }
  if (e->testFlag (Qt::Key_Hangul_Hanja)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_Hanja"; }
  if (e->testFlag (Qt::Key_Hangul_Jamo)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_Jamo"; }
  if (e->testFlag (Qt::Key_Hangul_Romaja)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_Romaja"; }
  if (e->testFlag (Qt::Key_Hangul_Jeonja)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_Jeonja"; }
  if (e->testFlag (Qt::Key_Hangul_Banja)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_Banja"; }
  if (e->testFlag (Qt::Key_Hangul_PreHanja)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_PreHanja"; }
  if (e->testFlag (Qt::Key_Hangul_PostHanja)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_PostHanja"; }
  if (e->testFlag (Qt::Key_Hangul_Special)) { if (!l.empty ()) l += "|"; l += "Key_Hangul_Special"; }
  if (e->testFlag (Qt::Key_Dead_Grave)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Grave"; }
  if (e->testFlag (Qt::Key_Dead_Acute)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Acute"; }
  if (e->testFlag (Qt::Key_Dead_Circumflex)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Circumflex"; }
  if (e->testFlag (Qt::Key_Dead_Tilde)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Tilde"; }
  if (e->testFlag (Qt::Key_Dead_Macron)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Macron"; }
  if (e->testFlag (Qt::Key_Dead_Breve)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Breve"; }
  if (e->testFlag (Qt::Key_Dead_Abovedot)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Abovedot"; }
  if (e->testFlag (Qt::Key_Dead_Diaeresis)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Diaeresis"; }
  if (e->testFlag (Qt::Key_Dead_Abovering)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Abovering"; }
  if (e->testFlag (Qt::Key_Dead_Doubleacute)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Doubleacute"; }
  if (e->testFlag (Qt::Key_Dead_Caron)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Caron"; }
  if (e->testFlag (Qt::Key_Dead_Cedilla)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Cedilla"; }
  if (e->testFlag (Qt::Key_Dead_Ogonek)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Ogonek"; }
  if (e->testFlag (Qt::Key_Dead_Iota)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Iota"; }
  if (e->testFlag (Qt::Key_Dead_Voiced_Sound)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Voiced_Sound"; }
  if (e->testFlag (Qt::Key_Dead_Semivoiced_Sound)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Semivoiced_Sound"; }
  if (e->testFlag (Qt::Key_Dead_Belowdot)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Belowdot"; }
  if (e->testFlag (Qt::Key_Dead_Hook)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Hook"; }
  if (e->testFlag (Qt::Key_Dead_Horn)) { if (!l.empty ()) l += "|"; l += "Key_Dead_Horn"; }
  if (e->testFlag (Qt::Key_Back)) { if (!l.empty ()) l += "|"; l += "Key_Back"; }
  if (e->testFlag (Qt::Key_Forward)) { if (!l.empty ()) l += "|"; l += "Key_Forward"; }
  if (e->testFlag (Qt::Key_Stop)) { if (!l.empty ()) l += "|"; l += "Key_Stop"; }
  if (e->testFlag (Qt::Key_Refresh)) { if (!l.empty ()) l += "|"; l += "Key_Refresh"; }
  if (e->testFlag (Qt::Key_VolumeDown)) { if (!l.empty ()) l += "|"; l += "Key_VolumeDown"; }
  if (e->testFlag (Qt::Key_VolumeMute)) { if (!l.empty ()) l += "|"; l += "Key_VolumeMute"; }
  if (e->testFlag (Qt::Key_VolumeUp)) { if (!l.empty ()) l += "|"; l += "Key_VolumeUp"; }
  if (e->testFlag (Qt::Key_BassBoost)) { if (!l.empty ()) l += "|"; l += "Key_BassBoost"; }
  if (e->testFlag (Qt::Key_BassUp)) { if (!l.empty ()) l += "|"; l += "Key_BassUp"; }
  if (e->testFlag (Qt::Key_BassDown)) { if (!l.empty ()) l += "|"; l += "Key_BassDown"; }
  if (e->testFlag (Qt::Key_TrebleUp)) { if (!l.empty ()) l += "|"; l += "Key_TrebleUp"; }
  if (e->testFlag (Qt::Key_TrebleDown)) { if (!l.empty ()) l += "|"; l += "Key_TrebleDown"; }
  if (e->testFlag (Qt::Key_MediaPlay)) { if (!l.empty ()) l += "|"; l += "Key_MediaPlay"; }
  if (e->testFlag (Qt::Key_MediaStop)) { if (!l.empty ()) l += "|"; l += "Key_MediaStop"; }
  if (e->testFlag (Qt::Key_MediaPrevious)) { if (!l.empty ()) l += "|"; l += "Key_MediaPrevious"; }
  if (e->testFlag (Qt::Key_MediaNext)) { if (!l.empty ()) l += "|"; l += "Key_MediaNext"; }
  if (e->testFlag (Qt::Key_MediaRecord)) { if (!l.empty ()) l += "|"; l += "Key_MediaRecord"; }
  if (e->testFlag (Qt::Key_HomePage)) { if (!l.empty ()) l += "|"; l += "Key_HomePage"; }
  if (e->testFlag (Qt::Key_Favorites)) { if (!l.empty ()) l += "|"; l += "Key_Favorites"; }
  if (e->testFlag (Qt::Key_Search)) { if (!l.empty ()) l += "|"; l += "Key_Search"; }
  if (e->testFlag (Qt::Key_Standby)) { if (!l.empty ()) l += "|"; l += "Key_Standby"; }
  if (e->testFlag (Qt::Key_OpenUrl)) { if (!l.empty ()) l += "|"; l += "Key_OpenUrl"; }
  if (e->testFlag (Qt::Key_LaunchMail)) { if (!l.empty ()) l += "|"; l += "Key_LaunchMail"; }
  if (e->testFlag (Qt::Key_LaunchMedia)) { if (!l.empty ()) l += "|"; l += "Key_LaunchMedia"; }
  if (e->testFlag (Qt::Key_Launch0)) { if (!l.empty ()) l += "|"; l += "Key_Launch0"; }
  if (e->testFlag (Qt::Key_Launch1)) { if (!l.empty ()) l += "|"; l += "Key_Launch1"; }
  if (e->testFlag (Qt::Key_Launch2)) { if (!l.empty ()) l += "|"; l += "Key_Launch2"; }
  if (e->testFlag (Qt::Key_Launch3)) { if (!l.empty ()) l += "|"; l += "Key_Launch3"; }
  if (e->testFlag (Qt::Key_Launch4)) { if (!l.empty ()) l += "|"; l += "Key_Launch4"; }
  if (e->testFlag (Qt::Key_Launch5)) { if (!l.empty ()) l += "|"; l += "Key_Launch5"; }
  if (e->testFlag (Qt::Key_Launch6)) { if (!l.empty ()) l += "|"; l += "Key_Launch6"; }
  if (e->testFlag (Qt::Key_Launch7)) { if (!l.empty ()) l += "|"; l += "Key_Launch7"; }
  if (e->testFlag (Qt::Key_Launch8)) { if (!l.empty ()) l += "|"; l += "Key_Launch8"; }
  if (e->testFlag (Qt::Key_Launch9)) { if (!l.empty ()) l += "|"; l += "Key_Launch9"; }
  if (e->testFlag (Qt::Key_LaunchA)) { if (!l.empty ()) l += "|"; l += "Key_LaunchA"; }
  if (e->testFlag (Qt::Key_LaunchB)) { if (!l.empty ()) l += "|"; l += "Key_LaunchB"; }
  if (e->testFlag (Qt::Key_LaunchC)) { if (!l.empty ()) l += "|"; l += "Key_LaunchC"; }
  if (e->testFlag (Qt::Key_LaunchD)) { if (!l.empty ()) l += "|"; l += "Key_LaunchD"; }
  if (e->testFlag (Qt::Key_LaunchE)) { if (!l.empty ()) l += "|"; l += "Key_LaunchE"; }
  if (e->testFlag (Qt::Key_LaunchF)) { if (!l.empty ()) l += "|"; l += "Key_LaunchF"; }
  if (e->testFlag (Qt::Key_MonBrightnessUp)) { if (!l.empty ()) l += "|"; l += "Key_MonBrightnessUp"; }
  if (e->testFlag (Qt::Key_MonBrightnessDown)) { if (!l.empty ()) l += "|"; l += "Key_MonBrightnessDown"; }
  if (e->testFlag (Qt::Key_KeyboardLightOnOff)) { if (!l.empty ()) l += "|"; l += "Key_KeyboardLightOnOff"; }
  if (e->testFlag (Qt::Key_KeyboardBrightnessUp)) { if (!l.empty ()) l += "|"; l += "Key_KeyboardBrightnessUp"; }
  if (e->testFlag (Qt::Key_KeyboardBrightnessDown)) { if (!l.empty ()) l += "|"; l += "Key_KeyboardBrightnessDown"; }
  if (e->testFlag (Qt::Key_PowerOff)) { if (!l.empty ()) l += "|"; l += "Key_PowerOff"; }
  if (e->testFlag (Qt::Key_WakeUp)) { if (!l.empty ()) l += "|"; l += "Key_WakeUp"; }
  if (e->testFlag (Qt::Key_Eject)) { if (!l.empty ()) l += "|"; l += "Key_Eject"; }
  if (e->testFlag (Qt::Key_ScreenSaver)) { if (!l.empty ()) l += "|"; l += "Key_ScreenSaver"; }
  if (e->testFlag (Qt::Key_WWW)) { if (!l.empty ()) l += "|"; l += "Key_WWW"; }
  if (e->testFlag (Qt::Key_Memo)) { if (!l.empty ()) l += "|"; l += "Key_Memo"; }
  if (e->testFlag (Qt::Key_LightBulb)) { if (!l.empty ()) l += "|"; l += "Key_LightBulb"; }
  if (e->testFlag (Qt::Key_Shop)) { if (!l.empty ()) l += "|"; l += "Key_Shop"; }
  if (e->testFlag (Qt::Key_History)) { if (!l.empty ()) l += "|"; l += "Key_History"; }
  if (e->testFlag (Qt::Key_AddFavorite)) { if (!l.empty ()) l += "|"; l += "Key_AddFavorite"; }
  if (e->testFlag (Qt::Key_HotLinks)) { if (!l.empty ()) l += "|"; l += "Key_HotLinks"; }
  if (e->testFlag (Qt::Key_BrightnessAdjust)) { if (!l.empty ()) l += "|"; l += "Key_BrightnessAdjust"; }
  if (e->testFlag (Qt::Key_Finance)) { if (!l.empty ()) l += "|"; l += "Key_Finance"; }
  if (e->testFlag (Qt::Key_Community)) { if (!l.empty ()) l += "|"; l += "Key_Community"; }
  if (e->testFlag (Qt::Key_AudioRewind)) { if (!l.empty ()) l += "|"; l += "Key_AudioRewind"; }
  if (e->testFlag (Qt::Key_BackForward)) { if (!l.empty ()) l += "|"; l += "Key_BackForward"; }
  if (e->testFlag (Qt::Key_ApplicationLeft)) { if (!l.empty ()) l += "|"; l += "Key_ApplicationLeft"; }
  if (e->testFlag (Qt::Key_ApplicationRight)) { if (!l.empty ()) l += "|"; l += "Key_ApplicationRight"; }
  if (e->testFlag (Qt::Key_Book)) { if (!l.empty ()) l += "|"; l += "Key_Book"; }
  if (e->testFlag (Qt::Key_CD)) { if (!l.empty ()) l += "|"; l += "Key_CD"; }
  if (e->testFlag (Qt::Key_Calculator)) { if (!l.empty ()) l += "|"; l += "Key_Calculator"; }
  if (e->testFlag (Qt::Key_ToDoList)) { if (!l.empty ()) l += "|"; l += "Key_ToDoList"; }
  if (e->testFlag (Qt::Key_ClearGrab)) { if (!l.empty ()) l += "|"; l += "Key_ClearGrab"; }
  if (e->testFlag (Qt::Key_Close)) { if (!l.empty ()) l += "|"; l += "Key_Close"; }
  if (e->testFlag (Qt::Key_Copy)) { if (!l.empty ()) l += "|"; l += "Key_Copy"; }
  if (e->testFlag (Qt::Key_Cut)) { if (!l.empty ()) l += "|"; l += "Key_Cut"; }
  if (e->testFlag (Qt::Key_Display)) { if (!l.empty ()) l += "|"; l += "Key_Display"; }
  if (e->testFlag (Qt::Key_DOS)) { if (!l.empty ()) l += "|"; l += "Key_DOS"; }
  if (e->testFlag (Qt::Key_Documents)) { if (!l.empty ()) l += "|"; l += "Key_Documents"; }
  if (e->testFlag (Qt::Key_Excel)) { if (!l.empty ()) l += "|"; l += "Key_Excel"; }
  if (e->testFlag (Qt::Key_Explorer)) { if (!l.empty ()) l += "|"; l += "Key_Explorer"; }
  if (e->testFlag (Qt::Key_Game)) { if (!l.empty ()) l += "|"; l += "Key_Game"; }
  if (e->testFlag (Qt::Key_Go)) { if (!l.empty ()) l += "|"; l += "Key_Go"; }
  if (e->testFlag (Qt::Key_iTouch)) { if (!l.empty ()) l += "|"; l += "Key_iTouch"; }
  if (e->testFlag (Qt::Key_LogOff)) { if (!l.empty ()) l += "|"; l += "Key_LogOff"; }
  if (e->testFlag (Qt::Key_Market)) { if (!l.empty ()) l += "|"; l += "Key_Market"; }
  if (e->testFlag (Qt::Key_Meeting)) { if (!l.empty ()) l += "|"; l += "Key_Meeting"; }
  if (e->testFlag (Qt::Key_MenuKB)) { if (!l.empty ()) l += "|"; l += "Key_MenuKB"; }
  if (e->testFlag (Qt::Key_MenuPB)) { if (!l.empty ()) l += "|"; l += "Key_MenuPB"; }
  if (e->testFlag (Qt::Key_MySites)) { if (!l.empty ()) l += "|"; l += "Key_MySites"; }
  if (e->testFlag (Qt::Key_News)) { if (!l.empty ()) l += "|"; l += "Key_News"; }
  if (e->testFlag (Qt::Key_OfficeHome)) { if (!l.empty ()) l += "|"; l += "Key_OfficeHome"; }
  if (e->testFlag (Qt::Key_Option)) { if (!l.empty ()) l += "|"; l += "Key_Option"; }
  if (e->testFlag (Qt::Key_Paste)) { if (!l.empty ()) l += "|"; l += "Key_Paste"; }
  if (e->testFlag (Qt::Key_Phone)) { if (!l.empty ()) l += "|"; l += "Key_Phone"; }
  if (e->testFlag (Qt::Key_Calendar)) { if (!l.empty ()) l += "|"; l += "Key_Calendar"; }
  if (e->testFlag (Qt::Key_Reply)) { if (!l.empty ()) l += "|"; l += "Key_Reply"; }
  if (e->testFlag (Qt::Key_Reload)) { if (!l.empty ()) l += "|"; l += "Key_Reload"; }
  if (e->testFlag (Qt::Key_RotateWindows)) { if (!l.empty ()) l += "|"; l += "Key_RotateWindows"; }
  if (e->testFlag (Qt::Key_RotationPB)) { if (!l.empty ()) l += "|"; l += "Key_RotationPB"; }
  if (e->testFlag (Qt::Key_RotationKB)) { if (!l.empty ()) l += "|"; l += "Key_RotationKB"; }
  if (e->testFlag (Qt::Key_Save)) { if (!l.empty ()) l += "|"; l += "Key_Save"; }
  if (e->testFlag (Qt::Key_Send)) { if (!l.empty ()) l += "|"; l += "Key_Send"; }
  if (e->testFlag (Qt::Key_Spell)) { if (!l.empty ()) l += "|"; l += "Key_Spell"; }
  if (e->testFlag (Qt::Key_SplitScreen)) { if (!l.empty ()) l += "|"; l += "Key_SplitScreen"; }
  if (e->testFlag (Qt::Key_Support)) { if (!l.empty ()) l += "|"; l += "Key_Support"; }
  if (e->testFlag (Qt::Key_TaskPane)) { if (!l.empty ()) l += "|"; l += "Key_TaskPane"; }
  if (e->testFlag (Qt::Key_Terminal)) { if (!l.empty ()) l += "|"; l += "Key_Terminal"; }
  if (e->testFlag (Qt::Key_Tools)) { if (!l.empty ()) l += "|"; l += "Key_Tools"; }
  if (e->testFlag (Qt::Key_Travel)) { if (!l.empty ()) l += "|"; l += "Key_Travel"; }
  if (e->testFlag (Qt::Key_Video)) { if (!l.empty ()) l += "|"; l += "Key_Video"; }
  if (e->testFlag (Qt::Key_Word)) { if (!l.empty ()) l += "|"; l += "Key_Word"; }
  if (e->testFlag (Qt::Key_Xfer)) { if (!l.empty ()) l += "|"; l += "Key_Xfer"; }
  if (e->testFlag (Qt::Key_ZoomIn)) { if (!l.empty ()) l += "|"; l += "Key_ZoomIn"; }
  if (e->testFlag (Qt::Key_ZoomOut)) { if (!l.empty ()) l += "|"; l += "Key_ZoomOut"; }
  if (e->testFlag (Qt::Key_Away)) { if (!l.empty ()) l += "|"; l += "Key_Away"; }
  if (e->testFlag (Qt::Key_Messenger)) { if (!l.empty ()) l += "|"; l += "Key_Messenger"; }
  if (e->testFlag (Qt::Key_WebCam)) { if (!l.empty ()) l += "|"; l += "Key_WebCam"; }
  if (e->testFlag (Qt::Key_MailForward)) { if (!l.empty ()) l += "|"; l += "Key_MailForward"; }
  if (e->testFlag (Qt::Key_Pictures)) { if (!l.empty ()) l += "|"; l += "Key_Pictures"; }
  if (e->testFlag (Qt::Key_Music)) { if (!l.empty ()) l += "|"; l += "Key_Music"; }
  if (e->testFlag (Qt::Key_Battery)) { if (!l.empty ()) l += "|"; l += "Key_Battery"; }
  if (e->testFlag (Qt::Key_Bluetooth)) { if (!l.empty ()) l += "|"; l += "Key_Bluetooth"; }
  if (e->testFlag (Qt::Key_WLAN)) { if (!l.empty ()) l += "|"; l += "Key_WLAN"; }
  if (e->testFlag (Qt::Key_UWB)) { if (!l.empty ()) l += "|"; l += "Key_UWB"; }
  if (e->testFlag (Qt::Key_AudioForward)) { if (!l.empty ()) l += "|"; l += "Key_AudioForward"; }
  if (e->testFlag (Qt::Key_AudioRepeat)) { if (!l.empty ()) l += "|"; l += "Key_AudioRepeat"; }
  if (e->testFlag (Qt::Key_AudioRandomPlay)) { if (!l.empty ()) l += "|"; l += "Key_AudioRandomPlay"; }
  if (e->testFlag (Qt::Key_Subtitle)) { if (!l.empty ()) l += "|"; l += "Key_Subtitle"; }
  if (e->testFlag (Qt::Key_AudioCycleTrack)) { if (!l.empty ()) l += "|"; l += "Key_AudioCycleTrack"; }
  if (e->testFlag (Qt::Key_Time)) { if (!l.empty ()) l += "|"; l += "Key_Time"; }
  if (e->testFlag (Qt::Key_Hibernate)) { if (!l.empty ()) l += "|"; l += "Key_Hibernate"; }
  if (e->testFlag (Qt::Key_View)) { if (!l.empty ()) l += "|"; l += "Key_View"; }
  if (e->testFlag (Qt::Key_TopMenu)) { if (!l.empty ()) l += "|"; l += "Key_TopMenu"; }
  if (e->testFlag (Qt::Key_PowerDown)) { if (!l.empty ()) l += "|"; l += "Key_PowerDown"; }
  if (e->testFlag (Qt::Key_Suspend)) { if (!l.empty ()) l += "|"; l += "Key_Suspend"; }
  if (e->testFlag (Qt::Key_ContrastAdjust)) { if (!l.empty ()) l += "|"; l += "Key_ContrastAdjust"; }
  if (e->testFlag (Qt::Key_MediaLast)) { if (!l.empty ()) l += "|"; l += "Key_MediaLast"; }
  if (e->testFlag (Qt::Key_Select)) { if (!l.empty ()) l += "|"; l += "Key_Select"; }
  if (e->testFlag (Qt::Key_Yes)) { if (!l.empty ()) l += "|"; l += "Key_Yes"; }
  if (e->testFlag (Qt::Key_No)) { if (!l.empty ()) l += "|"; l += "Key_No"; }
  if (e->testFlag (Qt::Key_Cancel)) { if (!l.empty ()) l += "|"; l += "Key_Cancel"; }
  if (e->testFlag (Qt::Key_Printer)) { if (!l.empty ()) l += "|"; l += "Key_Printer"; }
  if (e->testFlag (Qt::Key_Execute)) { if (!l.empty ()) l += "|"; l += "Key_Execute"; }
  if (e->testFlag (Qt::Key_Sleep)) { if (!l.empty ()) l += "|"; l += "Key_Sleep"; }
  if (e->testFlag (Qt::Key_Play)) { if (!l.empty ()) l += "|"; l += "Key_Play"; }
  if (e->testFlag (Qt::Key_Zoom)) { if (!l.empty ()) l += "|"; l += "Key_Zoom"; }
  if (e->testFlag (Qt::Key_Context1)) { if (!l.empty ()) l += "|"; l += "Key_Context1"; }
  if (e->testFlag (Qt::Key_Context2)) { if (!l.empty ()) l += "|"; l += "Key_Context2"; }
  if (e->testFlag (Qt::Key_Context3)) { if (!l.empty ()) l += "|"; l += "Key_Context3"; }
  if (e->testFlag (Qt::Key_Context4)) { if (!l.empty ()) l += "|"; l += "Key_Context4"; }
  if (e->testFlag (Qt::Key_Call)) { if (!l.empty ()) l += "|"; l += "Key_Call"; }
  if (e->testFlag (Qt::Key_Hangup)) { if (!l.empty ()) l += "|"; l += "Key_Hangup"; }
  if (e->testFlag (Qt::Key_Flip)) { if (!l.empty ()) l += "|"; l += "Key_Flip"; }
  if (e->testFlag (Qt::Key_unknown)) { if (!l.empty ()) l += "|"; l += "Key_unknown"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_Key_Enums (const Qt_Key_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_Key_Enums (const Qt_Key_Enums *e, const Qt_Key_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_Key_Enums> decl_Qt_Key_Enums ("Qt_QFlags_Key",
  gsi::method_ext ("|", &qt_gsi::oropQt_Key_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_Key_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_Key_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Key_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Key_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_Key_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::Key> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_Key_Enum> decl_Qt_Key_Enum (decl_Qt_Key_Enums, "Qt_Key",
  qt_gsi::mkdefs_Qt_Key () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Key_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Key_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_Key_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_Key_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_Key_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::Key enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_Key_Enum_in_parent (qt_gsi::mkdefs_Qt_Key ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_Key_Enum_as_child (decl_Qt_Key_Enum, "Key");

}


//  Implementation of the enum wrapper class for Qt::KeyboardModifier
namespace qt_gsi
{

static Qt_KeyboardModifier_Enum *c_1_Qt_KeyboardModifier_Enum () { return new Qt_KeyboardModifier_Enum (Qt::NoModifier); }
static Qt_KeyboardModifier_Enum *c_2_Qt_KeyboardModifier_Enum () { return new Qt_KeyboardModifier_Enum (Qt::ShiftModifier); }
static Qt_KeyboardModifier_Enum *c_3_Qt_KeyboardModifier_Enum () { return new Qt_KeyboardModifier_Enum (Qt::ControlModifier); }
static Qt_KeyboardModifier_Enum *c_4_Qt_KeyboardModifier_Enum () { return new Qt_KeyboardModifier_Enum (Qt::AltModifier); }
static Qt_KeyboardModifier_Enum *c_5_Qt_KeyboardModifier_Enum () { return new Qt_KeyboardModifier_Enum (Qt::MetaModifier); }
static Qt_KeyboardModifier_Enum *c_6_Qt_KeyboardModifier_Enum () { return new Qt_KeyboardModifier_Enum (Qt::KeypadModifier); }
static Qt_KeyboardModifier_Enum *c_7_Qt_KeyboardModifier_Enum () { return new Qt_KeyboardModifier_Enum (Qt::GroupSwitchModifier); }
static Qt_KeyboardModifier_Enum *c_8_Qt_KeyboardModifier_Enum () { return new Qt_KeyboardModifier_Enum (Qt::KeyboardModifierMask); }

static gsi::Methods mkdefs_Qt_KeyboardModifier () {
  return
    gsi::constant ("NoModifier", &qt_gsi::c_1_Qt_KeyboardModifier_Enum, "@brief Enum constant Qt::NoModifier") +
    gsi::constant ("ShiftModifier", &qt_gsi::c_2_Qt_KeyboardModifier_Enum, "@brief Enum constant Qt::ShiftModifier") +
    gsi::constant ("ControlModifier", &qt_gsi::c_3_Qt_KeyboardModifier_Enum, "@brief Enum constant Qt::ControlModifier") +
    gsi::constant ("AltModifier", &qt_gsi::c_4_Qt_KeyboardModifier_Enum, "@brief Enum constant Qt::AltModifier") +
    gsi::constant ("MetaModifier", &qt_gsi::c_5_Qt_KeyboardModifier_Enum, "@brief Enum constant Qt::MetaModifier") +
    gsi::constant ("KeypadModifier", &qt_gsi::c_6_Qt_KeyboardModifier_Enum, "@brief Enum constant Qt::KeypadModifier") +
    gsi::constant ("GroupSwitchModifier", &qt_gsi::c_7_Qt_KeyboardModifier_Enum, "@brief Enum constant Qt::GroupSwitchModifier") +
    gsi::constant ("KeyboardModifierMask", &qt_gsi::c_8_Qt_KeyboardModifier_Enum, "@brief Enum constant Qt::KeyboardModifierMask");
}

static std::string to_s_Qt_KeyboardModifier_Enum (const Qt_KeyboardModifier_Enum *e)
{
  if (e->value () == Qt::NoModifier) { return tl::sprintf ("NoModifier (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ShiftModifier) { return tl::sprintf ("ShiftModifier (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ControlModifier) { return tl::sprintf ("ControlModifier (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AltModifier) { return tl::sprintf ("AltModifier (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MetaModifier) { return tl::sprintf ("MetaModifier (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::KeypadModifier) { return tl::sprintf ("KeypadModifier (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::GroupSwitchModifier) { return tl::sprintf ("GroupSwitchModifier (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::KeyboardModifierMask) { return tl::sprintf ("KeyboardModifierMask (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_KeyboardModifier_Enum (const Qt_KeyboardModifier_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_KeyboardModifier_Enum *from_i_Qt_KeyboardModifier_Enum (unsigned int i)
{
  return new Qt_KeyboardModifier_Enum ((Qt::KeyboardModifier) i);
}

static bool equalQt_KeyboardModifier_Enum (const Qt_KeyboardModifier_Enum *e, Qt_KeyboardModifier_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_KeyboardModifier_Enum (const Qt_KeyboardModifier_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_KeyboardModifier_Enums oropQt_KeyboardModifier_Enums (const Qt_KeyboardModifier_Enums *e, const Qt_KeyboardModifier_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_KeyboardModifier_Enums andopQt_KeyboardModifier_Enums (const Qt_KeyboardModifier_Enums *e, const Qt_KeyboardModifier_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_KeyboardModifier_Enums xoropQt_KeyboardModifier_Enums (const Qt_KeyboardModifier_Enums *e, const Qt_KeyboardModifier_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_KeyboardModifier_Enums (const Qt_KeyboardModifier_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoModifier)) { if (!l.empty ()) l += "|"; l += "NoModifier"; }
  if (e->testFlag (Qt::ShiftModifier)) { if (!l.empty ()) l += "|"; l += "ShiftModifier"; }
  if (e->testFlag (Qt::ControlModifier)) { if (!l.empty ()) l += "|"; l += "ControlModifier"; }
  if (e->testFlag (Qt::AltModifier)) { if (!l.empty ()) l += "|"; l += "AltModifier"; }
  if (e->testFlag (Qt::MetaModifier)) { if (!l.empty ()) l += "|"; l += "MetaModifier"; }
  if (e->testFlag (Qt::KeypadModifier)) { if (!l.empty ()) l += "|"; l += "KeypadModifier"; }
  if (e->testFlag (Qt::GroupSwitchModifier)) { if (!l.empty ()) l += "|"; l += "GroupSwitchModifier"; }
  if (e->testFlag (Qt::KeyboardModifierMask)) { if (!l.empty ()) l += "|"; l += "KeyboardModifierMask"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_KeyboardModifier_Enums (const Qt_KeyboardModifier_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_KeyboardModifier_Enums (const Qt_KeyboardModifier_Enums *e, const Qt_KeyboardModifier_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_KeyboardModifier_Enums> decl_Qt_KeyboardModifier_Enums ("Qt_QFlags_KeyboardModifier",
  gsi::method_ext ("|", &qt_gsi::oropQt_KeyboardModifier_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_KeyboardModifier_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_KeyboardModifier_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_KeyboardModifier_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_KeyboardModifier_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_KeyboardModifier_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::KeyboardModifier> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_KeyboardModifier_Enum> decl_Qt_KeyboardModifier_Enum (decl_Qt_KeyboardModifier_Enums, "Qt_KeyboardModifier",
  qt_gsi::mkdefs_Qt_KeyboardModifier () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_KeyboardModifier_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_KeyboardModifier_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_KeyboardModifier_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_KeyboardModifier_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_KeyboardModifier_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::KeyboardModifier enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_KeyboardModifier_Enum_in_parent (qt_gsi::mkdefs_Qt_KeyboardModifier ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_KeyboardModifier_Enum_as_child (decl_Qt_KeyboardModifier_Enum, "KeyboardModifier");

}


//  Implementation of the enum wrapper class for Qt::LayoutDirection
namespace qt_gsi
{

static Qt_LayoutDirection_Enum *c_1_Qt_LayoutDirection_Enum () { return new Qt_LayoutDirection_Enum (Qt::LeftToRight); }
static Qt_LayoutDirection_Enum *c_2_Qt_LayoutDirection_Enum () { return new Qt_LayoutDirection_Enum (Qt::RightToLeft); }

static gsi::Methods mkdefs_Qt_LayoutDirection () {
  return
    gsi::constant ("LeftToRight", &qt_gsi::c_1_Qt_LayoutDirection_Enum, "@brief Enum constant Qt::LeftToRight") +
    gsi::constant ("RightToLeft", &qt_gsi::c_2_Qt_LayoutDirection_Enum, "@brief Enum constant Qt::RightToLeft");
}

static std::string to_s_Qt_LayoutDirection_Enum (const Qt_LayoutDirection_Enum *e)
{
  if (e->value () == Qt::LeftToRight) { return tl::sprintf ("LeftToRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RightToLeft) { return tl::sprintf ("RightToLeft (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_LayoutDirection_Enum (const Qt_LayoutDirection_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_LayoutDirection_Enum *from_i_Qt_LayoutDirection_Enum (unsigned int i)
{
  return new Qt_LayoutDirection_Enum ((Qt::LayoutDirection) i);
}

static bool equalQt_LayoutDirection_Enum (const Qt_LayoutDirection_Enum *e, Qt_LayoutDirection_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_LayoutDirection_Enum (const Qt_LayoutDirection_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_LayoutDirection_Enums oropQt_LayoutDirection_Enums (const Qt_LayoutDirection_Enums *e, const Qt_LayoutDirection_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_LayoutDirection_Enums andopQt_LayoutDirection_Enums (const Qt_LayoutDirection_Enums *e, const Qt_LayoutDirection_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_LayoutDirection_Enums xoropQt_LayoutDirection_Enums (const Qt_LayoutDirection_Enums *e, const Qt_LayoutDirection_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_LayoutDirection_Enums (const Qt_LayoutDirection_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::LeftToRight)) { if (!l.empty ()) l += "|"; l += "LeftToRight"; }
  if (e->testFlag (Qt::RightToLeft)) { if (!l.empty ()) l += "|"; l += "RightToLeft"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_LayoutDirection_Enums (const Qt_LayoutDirection_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_LayoutDirection_Enums (const Qt_LayoutDirection_Enums *e, const Qt_LayoutDirection_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_LayoutDirection_Enums> decl_Qt_LayoutDirection_Enums ("Qt_QFlags_LayoutDirection",
  gsi::method_ext ("|", &qt_gsi::oropQt_LayoutDirection_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_LayoutDirection_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_LayoutDirection_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_LayoutDirection_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_LayoutDirection_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_LayoutDirection_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::LayoutDirection> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_LayoutDirection_Enum> decl_Qt_LayoutDirection_Enum (decl_Qt_LayoutDirection_Enums, "Qt_LayoutDirection",
  qt_gsi::mkdefs_Qt_LayoutDirection () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_LayoutDirection_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_LayoutDirection_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_LayoutDirection_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_LayoutDirection_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_LayoutDirection_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::LayoutDirection enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_LayoutDirection_Enum_in_parent (qt_gsi::mkdefs_Qt_LayoutDirection ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_LayoutDirection_Enum_as_child (decl_Qt_LayoutDirection_Enum, "LayoutDirection");

}


//  Implementation of the enum wrapper class for Qt::MaskMode
namespace qt_gsi
{

static Qt_MaskMode_Enum *c_1_Qt_MaskMode_Enum () { return new Qt_MaskMode_Enum (Qt::MaskInColor); }
static Qt_MaskMode_Enum *c_2_Qt_MaskMode_Enum () { return new Qt_MaskMode_Enum (Qt::MaskOutColor); }

static gsi::Methods mkdefs_Qt_MaskMode () {
  return
    gsi::constant ("MaskInColor", &qt_gsi::c_1_Qt_MaskMode_Enum, "@brief Enum constant Qt::MaskInColor") +
    gsi::constant ("MaskOutColor", &qt_gsi::c_2_Qt_MaskMode_Enum, "@brief Enum constant Qt::MaskOutColor");
}

static std::string to_s_Qt_MaskMode_Enum (const Qt_MaskMode_Enum *e)
{
  if (e->value () == Qt::MaskInColor) { return tl::sprintf ("MaskInColor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MaskOutColor) { return tl::sprintf ("MaskOutColor (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_MaskMode_Enum (const Qt_MaskMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_MaskMode_Enum *from_i_Qt_MaskMode_Enum (unsigned int i)
{
  return new Qt_MaskMode_Enum ((Qt::MaskMode) i);
}

static bool equalQt_MaskMode_Enum (const Qt_MaskMode_Enum *e, Qt_MaskMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_MaskMode_Enum (const Qt_MaskMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_MaskMode_Enums oropQt_MaskMode_Enums (const Qt_MaskMode_Enums *e, const Qt_MaskMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_MaskMode_Enums andopQt_MaskMode_Enums (const Qt_MaskMode_Enums *e, const Qt_MaskMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_MaskMode_Enums xoropQt_MaskMode_Enums (const Qt_MaskMode_Enums *e, const Qt_MaskMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_MaskMode_Enums (const Qt_MaskMode_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::MaskInColor)) { if (!l.empty ()) l += "|"; l += "MaskInColor"; }
  if (e->testFlag (Qt::MaskOutColor)) { if (!l.empty ()) l += "|"; l += "MaskOutColor"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_MaskMode_Enums (const Qt_MaskMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_MaskMode_Enums (const Qt_MaskMode_Enums *e, const Qt_MaskMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_MaskMode_Enums> decl_Qt_MaskMode_Enums ("Qt_QFlags_MaskMode",
  gsi::method_ext ("|", &qt_gsi::oropQt_MaskMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_MaskMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_MaskMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_MaskMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_MaskMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_MaskMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::MaskMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_MaskMode_Enum> decl_Qt_MaskMode_Enum (decl_Qt_MaskMode_Enums, "Qt_MaskMode",
  qt_gsi::mkdefs_Qt_MaskMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_MaskMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_MaskMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_MaskMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_MaskMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_MaskMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::MaskMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_MaskMode_Enum_in_parent (qt_gsi::mkdefs_Qt_MaskMode ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_MaskMode_Enum_as_child (decl_Qt_MaskMode_Enum, "MaskMode");

}


//  Implementation of the enum wrapper class for Qt::MatchFlag
namespace qt_gsi
{

static Qt_MatchFlag_Enum *c_1_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchExactly); }
static Qt_MatchFlag_Enum *c_2_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchContains); }
static Qt_MatchFlag_Enum *c_3_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchStartsWith); }
static Qt_MatchFlag_Enum *c_4_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchEndsWith); }
static Qt_MatchFlag_Enum *c_5_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchRegExp); }
static Qt_MatchFlag_Enum *c_6_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchWildcard); }
static Qt_MatchFlag_Enum *c_7_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchFixedString); }
static Qt_MatchFlag_Enum *c_8_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchCaseSensitive); }
static Qt_MatchFlag_Enum *c_9_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchWrap); }
static Qt_MatchFlag_Enum *c_10_Qt_MatchFlag_Enum () { return new Qt_MatchFlag_Enum (Qt::MatchRecursive); }

static gsi::Methods mkdefs_Qt_MatchFlag () {
  return
    gsi::constant ("MatchExactly", &qt_gsi::c_1_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchExactly") +
    gsi::constant ("MatchContains", &qt_gsi::c_2_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchContains") +
    gsi::constant ("MatchStartsWith", &qt_gsi::c_3_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchStartsWith") +
    gsi::constant ("MatchEndsWith", &qt_gsi::c_4_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchEndsWith") +
    gsi::constant ("MatchRegExp", &qt_gsi::c_5_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchRegExp") +
    gsi::constant ("MatchWildcard", &qt_gsi::c_6_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchWildcard") +
    gsi::constant ("MatchFixedString", &qt_gsi::c_7_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchFixedString") +
    gsi::constant ("MatchCaseSensitive", &qt_gsi::c_8_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchCaseSensitive") +
    gsi::constant ("MatchWrap", &qt_gsi::c_9_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchWrap") +
    gsi::constant ("MatchRecursive", &qt_gsi::c_10_Qt_MatchFlag_Enum, "@brief Enum constant Qt::MatchRecursive");
}

static std::string to_s_Qt_MatchFlag_Enum (const Qt_MatchFlag_Enum *e)
{
  if (e->value () == Qt::MatchExactly) { return tl::sprintf ("MatchExactly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MatchContains) { return tl::sprintf ("MatchContains (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MatchStartsWith) { return tl::sprintf ("MatchStartsWith (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MatchEndsWith) { return tl::sprintf ("MatchEndsWith (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MatchRegExp) { return tl::sprintf ("MatchRegExp (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MatchWildcard) { return tl::sprintf ("MatchWildcard (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MatchFixedString) { return tl::sprintf ("MatchFixedString (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MatchCaseSensitive) { return tl::sprintf ("MatchCaseSensitive (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MatchWrap) { return tl::sprintf ("MatchWrap (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MatchRecursive) { return tl::sprintf ("MatchRecursive (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_MatchFlag_Enum (const Qt_MatchFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_MatchFlag_Enum *from_i_Qt_MatchFlag_Enum (unsigned int i)
{
  return new Qt_MatchFlag_Enum ((Qt::MatchFlag) i);
}

static bool equalQt_MatchFlag_Enum (const Qt_MatchFlag_Enum *e, Qt_MatchFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_MatchFlag_Enum (const Qt_MatchFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_MatchFlag_Enums oropQt_MatchFlag_Enums (const Qt_MatchFlag_Enums *e, const Qt_MatchFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_MatchFlag_Enums andopQt_MatchFlag_Enums (const Qt_MatchFlag_Enums *e, const Qt_MatchFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_MatchFlag_Enums xoropQt_MatchFlag_Enums (const Qt_MatchFlag_Enums *e, const Qt_MatchFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_MatchFlag_Enums (const Qt_MatchFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::MatchExactly)) { if (!l.empty ()) l += "|"; l += "MatchExactly"; }
  if (e->testFlag (Qt::MatchContains)) { if (!l.empty ()) l += "|"; l += "MatchContains"; }
  if (e->testFlag (Qt::MatchStartsWith)) { if (!l.empty ()) l += "|"; l += "MatchStartsWith"; }
  if (e->testFlag (Qt::MatchEndsWith)) { if (!l.empty ()) l += "|"; l += "MatchEndsWith"; }
  if (e->testFlag (Qt::MatchRegExp)) { if (!l.empty ()) l += "|"; l += "MatchRegExp"; }
  if (e->testFlag (Qt::MatchWildcard)) { if (!l.empty ()) l += "|"; l += "MatchWildcard"; }
  if (e->testFlag (Qt::MatchFixedString)) { if (!l.empty ()) l += "|"; l += "MatchFixedString"; }
  if (e->testFlag (Qt::MatchCaseSensitive)) { if (!l.empty ()) l += "|"; l += "MatchCaseSensitive"; }
  if (e->testFlag (Qt::MatchWrap)) { if (!l.empty ()) l += "|"; l += "MatchWrap"; }
  if (e->testFlag (Qt::MatchRecursive)) { if (!l.empty ()) l += "|"; l += "MatchRecursive"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_MatchFlag_Enums (const Qt_MatchFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_MatchFlag_Enums (const Qt_MatchFlag_Enums *e, const Qt_MatchFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_MatchFlag_Enums> decl_Qt_MatchFlag_Enums ("Qt_QFlags_MatchFlag",
  gsi::method_ext ("|", &qt_gsi::oropQt_MatchFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_MatchFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_MatchFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_MatchFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_MatchFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_MatchFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::MatchFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_MatchFlag_Enum> decl_Qt_MatchFlag_Enum (decl_Qt_MatchFlag_Enums, "Qt_MatchFlag",
  qt_gsi::mkdefs_Qt_MatchFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_MatchFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_MatchFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_MatchFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_MatchFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_MatchFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::MatchFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_MatchFlag_Enum_in_parent (qt_gsi::mkdefs_Qt_MatchFlag ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_MatchFlag_Enum_as_child (decl_Qt_MatchFlag_Enum, "MatchFlag");

}


//  Implementation of the enum wrapper class for Qt::Modifier
namespace qt_gsi
{

static Qt_Modifier_Enum *c_1_Qt_Modifier_Enum () { return new Qt_Modifier_Enum (Qt::META); }
static Qt_Modifier_Enum *c_2_Qt_Modifier_Enum () { return new Qt_Modifier_Enum (Qt::SHIFT); }
static Qt_Modifier_Enum *c_3_Qt_Modifier_Enum () { return new Qt_Modifier_Enum (Qt::CTRL); }
static Qt_Modifier_Enum *c_4_Qt_Modifier_Enum () { return new Qt_Modifier_Enum (Qt::ALT); }
static Qt_Modifier_Enum *c_5_Qt_Modifier_Enum () { return new Qt_Modifier_Enum (Qt::MODIFIER_MASK); }
static Qt_Modifier_Enum *c_6_Qt_Modifier_Enum () { return new Qt_Modifier_Enum (Qt::UNICODE_ACCEL); }

static gsi::Methods mkdefs_Qt_Modifier () {
  return
    gsi::constant ("META", &qt_gsi::c_1_Qt_Modifier_Enum, "@brief Enum constant Qt::META") +
    gsi::constant ("SHIFT", &qt_gsi::c_2_Qt_Modifier_Enum, "@brief Enum constant Qt::SHIFT") +
    gsi::constant ("CTRL", &qt_gsi::c_3_Qt_Modifier_Enum, "@brief Enum constant Qt::CTRL") +
    gsi::constant ("ALT", &qt_gsi::c_4_Qt_Modifier_Enum, "@brief Enum constant Qt::ALT") +
    gsi::constant ("MODIFIER_MASK", &qt_gsi::c_5_Qt_Modifier_Enum, "@brief Enum constant Qt::MODIFIER_MASK") +
    gsi::constant ("UNICODE_ACCEL", &qt_gsi::c_6_Qt_Modifier_Enum, "@brief Enum constant Qt::UNICODE_ACCEL");
}

static std::string to_s_Qt_Modifier_Enum (const Qt_Modifier_Enum *e)
{
  if (e->value () == Qt::META) { return tl::sprintf ("META (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SHIFT) { return tl::sprintf ("SHIFT (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CTRL) { return tl::sprintf ("CTRL (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ALT) { return tl::sprintf ("ALT (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MODIFIER_MASK) { return tl::sprintf ("MODIFIER_MASK (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UNICODE_ACCEL) { return tl::sprintf ("UNICODE_ACCEL (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_Modifier_Enum (const Qt_Modifier_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_Modifier_Enum *from_i_Qt_Modifier_Enum (unsigned int i)
{
  return new Qt_Modifier_Enum ((Qt::Modifier) i);
}

static bool equalQt_Modifier_Enum (const Qt_Modifier_Enum *e, Qt_Modifier_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_Modifier_Enum (const Qt_Modifier_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_Modifier_Enums oropQt_Modifier_Enums (const Qt_Modifier_Enums *e, const Qt_Modifier_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_Modifier_Enums andopQt_Modifier_Enums (const Qt_Modifier_Enums *e, const Qt_Modifier_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_Modifier_Enums xoropQt_Modifier_Enums (const Qt_Modifier_Enums *e, const Qt_Modifier_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_Modifier_Enums (const Qt_Modifier_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::META)) { if (!l.empty ()) l += "|"; l += "META"; }
  if (e->testFlag (Qt::SHIFT)) { if (!l.empty ()) l += "|"; l += "SHIFT"; }
  if (e->testFlag (Qt::CTRL)) { if (!l.empty ()) l += "|"; l += "CTRL"; }
  if (e->testFlag (Qt::ALT)) { if (!l.empty ()) l += "|"; l += "ALT"; }
  if (e->testFlag (Qt::MODIFIER_MASK)) { if (!l.empty ()) l += "|"; l += "MODIFIER_MASK"; }
  if (e->testFlag (Qt::UNICODE_ACCEL)) { if (!l.empty ()) l += "|"; l += "UNICODE_ACCEL"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_Modifier_Enums (const Qt_Modifier_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_Modifier_Enums (const Qt_Modifier_Enums *e, const Qt_Modifier_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_Modifier_Enums> decl_Qt_Modifier_Enums ("Qt_QFlags_Modifier",
  gsi::method_ext ("|", &qt_gsi::oropQt_Modifier_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_Modifier_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_Modifier_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Modifier_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Modifier_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_Modifier_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::Modifier> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_Modifier_Enum> decl_Qt_Modifier_Enum (decl_Qt_Modifier_Enums, "Qt_Modifier",
  qt_gsi::mkdefs_Qt_Modifier () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Modifier_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Modifier_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_Modifier_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_Modifier_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_Modifier_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::Modifier enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_Modifier_Enum_in_parent (qt_gsi::mkdefs_Qt_Modifier ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_Modifier_Enum_as_child (decl_Qt_Modifier_Enum, "Modifier");

}


//  Implementation of the enum wrapper class for Qt::MouseButton
namespace qt_gsi
{

static Qt_MouseButton_Enum *c_1_Qt_MouseButton_Enum () { return new Qt_MouseButton_Enum (Qt::NoButton); }
static Qt_MouseButton_Enum *c_2_Qt_MouseButton_Enum () { return new Qt_MouseButton_Enum (Qt::LeftButton); }
static Qt_MouseButton_Enum *c_3_Qt_MouseButton_Enum () { return new Qt_MouseButton_Enum (Qt::RightButton); }
static Qt_MouseButton_Enum *c_4_Qt_MouseButton_Enum () { return new Qt_MouseButton_Enum (Qt::MidButton); }
static Qt_MouseButton_Enum *c_5_Qt_MouseButton_Enum () { return new Qt_MouseButton_Enum (Qt::XButton1); }
static Qt_MouseButton_Enum *c_6_Qt_MouseButton_Enum () { return new Qt_MouseButton_Enum (Qt::XButton2); }
static Qt_MouseButton_Enum *c_7_Qt_MouseButton_Enum () { return new Qt_MouseButton_Enum (Qt::MouseButtonMask); }

static gsi::Methods mkdefs_Qt_MouseButton () {
  return
    gsi::constant ("NoButton", &qt_gsi::c_1_Qt_MouseButton_Enum, "@brief Enum constant Qt::NoButton") +
    gsi::constant ("LeftButton", &qt_gsi::c_2_Qt_MouseButton_Enum, "@brief Enum constant Qt::LeftButton") +
    gsi::constant ("RightButton", &qt_gsi::c_3_Qt_MouseButton_Enum, "@brief Enum constant Qt::RightButton") +
    gsi::constant ("MidButton", &qt_gsi::c_4_Qt_MouseButton_Enum, "@brief Enum constant Qt::MidButton") +
    gsi::constant ("XButton1", &qt_gsi::c_5_Qt_MouseButton_Enum, "@brief Enum constant Qt::XButton1") +
    gsi::constant ("XButton2", &qt_gsi::c_6_Qt_MouseButton_Enum, "@brief Enum constant Qt::XButton2") +
    gsi::constant ("MouseButtonMask", &qt_gsi::c_7_Qt_MouseButton_Enum, "@brief Enum constant Qt::MouseButtonMask");
}

static std::string to_s_Qt_MouseButton_Enum (const Qt_MouseButton_Enum *e)
{
  if (e->value () == Qt::NoButton) { return tl::sprintf ("NoButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LeftButton) { return tl::sprintf ("LeftButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RightButton) { return tl::sprintf ("RightButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MidButton) { return tl::sprintf ("MidButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::XButton1) { return tl::sprintf ("XButton1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::XButton2) { return tl::sprintf ("XButton2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MouseButtonMask) { return tl::sprintf ("MouseButtonMask (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_MouseButton_Enum (const Qt_MouseButton_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_MouseButton_Enum *from_i_Qt_MouseButton_Enum (unsigned int i)
{
  return new Qt_MouseButton_Enum ((Qt::MouseButton) i);
}

static bool equalQt_MouseButton_Enum (const Qt_MouseButton_Enum *e, Qt_MouseButton_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_MouseButton_Enum (const Qt_MouseButton_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_MouseButton_Enums oropQt_MouseButton_Enums (const Qt_MouseButton_Enums *e, const Qt_MouseButton_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_MouseButton_Enums andopQt_MouseButton_Enums (const Qt_MouseButton_Enums *e, const Qt_MouseButton_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_MouseButton_Enums xoropQt_MouseButton_Enums (const Qt_MouseButton_Enums *e, const Qt_MouseButton_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_MouseButton_Enums (const Qt_MouseButton_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoButton)) { if (!l.empty ()) l += "|"; l += "NoButton"; }
  if (e->testFlag (Qt::LeftButton)) { if (!l.empty ()) l += "|"; l += "LeftButton"; }
  if (e->testFlag (Qt::RightButton)) { if (!l.empty ()) l += "|"; l += "RightButton"; }
  if (e->testFlag (Qt::MidButton)) { if (!l.empty ()) l += "|"; l += "MidButton"; }
  if (e->testFlag (Qt::XButton1)) { if (!l.empty ()) l += "|"; l += "XButton1"; }
  if (e->testFlag (Qt::XButton2)) { if (!l.empty ()) l += "|"; l += "XButton2"; }
  if (e->testFlag (Qt::MouseButtonMask)) { if (!l.empty ()) l += "|"; l += "MouseButtonMask"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_MouseButton_Enums (const Qt_MouseButton_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_MouseButton_Enums (const Qt_MouseButton_Enums *e, const Qt_MouseButton_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_MouseButton_Enums> decl_Qt_MouseButton_Enums ("Qt_QFlags_MouseButton",
  gsi::method_ext ("|", &qt_gsi::oropQt_MouseButton_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_MouseButton_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_MouseButton_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_MouseButton_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_MouseButton_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_MouseButton_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::MouseButton> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_MouseButton_Enum> decl_Qt_MouseButton_Enum (decl_Qt_MouseButton_Enums, "Qt_MouseButton",
  qt_gsi::mkdefs_Qt_MouseButton () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_MouseButton_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_MouseButton_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_MouseButton_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_MouseButton_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_MouseButton_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::MouseButton enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_MouseButton_Enum_in_parent (qt_gsi::mkdefs_Qt_MouseButton ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_MouseButton_Enum_as_child (decl_Qt_MouseButton_Enum, "MouseButton");

}


//  Implementation of the enum wrapper class for Qt::NavigationMode
namespace qt_gsi
{

static Qt_NavigationMode_Enum *c_1_Qt_NavigationMode_Enum () { return new Qt_NavigationMode_Enum (Qt::NavigationModeNone); }
static Qt_NavigationMode_Enum *c_2_Qt_NavigationMode_Enum () { return new Qt_NavigationMode_Enum (Qt::NavigationModeKeypadTabOrder); }
static Qt_NavigationMode_Enum *c_3_Qt_NavigationMode_Enum () { return new Qt_NavigationMode_Enum (Qt::NavigationModeKeypadDirectional); }
static Qt_NavigationMode_Enum *c_4_Qt_NavigationMode_Enum () { return new Qt_NavigationMode_Enum (Qt::NavigationModeCursorAuto); }
static Qt_NavigationMode_Enum *c_5_Qt_NavigationMode_Enum () { return new Qt_NavigationMode_Enum (Qt::NavigationModeCursorForceVisible); }

static gsi::Methods mkdefs_Qt_NavigationMode () {
  return
    gsi::constant ("NavigationModeNone", &qt_gsi::c_1_Qt_NavigationMode_Enum, "@brief Enum constant Qt::NavigationModeNone") +
    gsi::constant ("NavigationModeKeypadTabOrder", &qt_gsi::c_2_Qt_NavigationMode_Enum, "@brief Enum constant Qt::NavigationModeKeypadTabOrder") +
    gsi::constant ("NavigationModeKeypadDirectional", &qt_gsi::c_3_Qt_NavigationMode_Enum, "@brief Enum constant Qt::NavigationModeKeypadDirectional") +
    gsi::constant ("NavigationModeCursorAuto", &qt_gsi::c_4_Qt_NavigationMode_Enum, "@brief Enum constant Qt::NavigationModeCursorAuto") +
    gsi::constant ("NavigationModeCursorForceVisible", &qt_gsi::c_5_Qt_NavigationMode_Enum, "@brief Enum constant Qt::NavigationModeCursorForceVisible");
}

static std::string to_s_Qt_NavigationMode_Enum (const Qt_NavigationMode_Enum *e)
{
  if (e->value () == Qt::NavigationModeNone) { return tl::sprintf ("NavigationModeNone (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NavigationModeKeypadTabOrder) { return tl::sprintf ("NavigationModeKeypadTabOrder (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NavigationModeKeypadDirectional) { return tl::sprintf ("NavigationModeKeypadDirectional (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NavigationModeCursorAuto) { return tl::sprintf ("NavigationModeCursorAuto (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NavigationModeCursorForceVisible) { return tl::sprintf ("NavigationModeCursorForceVisible (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_NavigationMode_Enum (const Qt_NavigationMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_NavigationMode_Enum *from_i_Qt_NavigationMode_Enum (unsigned int i)
{
  return new Qt_NavigationMode_Enum ((Qt::NavigationMode) i);
}

static bool equalQt_NavigationMode_Enum (const Qt_NavigationMode_Enum *e, Qt_NavigationMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_NavigationMode_Enum (const Qt_NavigationMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_NavigationMode_Enums oropQt_NavigationMode_Enums (const Qt_NavigationMode_Enums *e, const Qt_NavigationMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_NavigationMode_Enums andopQt_NavigationMode_Enums (const Qt_NavigationMode_Enums *e, const Qt_NavigationMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_NavigationMode_Enums xoropQt_NavigationMode_Enums (const Qt_NavigationMode_Enums *e, const Qt_NavigationMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_NavigationMode_Enums (const Qt_NavigationMode_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NavigationModeNone)) { if (!l.empty ()) l += "|"; l += "NavigationModeNone"; }
  if (e->testFlag (Qt::NavigationModeKeypadTabOrder)) { if (!l.empty ()) l += "|"; l += "NavigationModeKeypadTabOrder"; }
  if (e->testFlag (Qt::NavigationModeKeypadDirectional)) { if (!l.empty ()) l += "|"; l += "NavigationModeKeypadDirectional"; }
  if (e->testFlag (Qt::NavigationModeCursorAuto)) { if (!l.empty ()) l += "|"; l += "NavigationModeCursorAuto"; }
  if (e->testFlag (Qt::NavigationModeCursorForceVisible)) { if (!l.empty ()) l += "|"; l += "NavigationModeCursorForceVisible"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_NavigationMode_Enums (const Qt_NavigationMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_NavigationMode_Enums (const Qt_NavigationMode_Enums *e, const Qt_NavigationMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_NavigationMode_Enums> decl_Qt_NavigationMode_Enums ("Qt_QFlags_NavigationMode",
  gsi::method_ext ("|", &qt_gsi::oropQt_NavigationMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_NavigationMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_NavigationMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_NavigationMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_NavigationMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_NavigationMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::NavigationMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_NavigationMode_Enum> decl_Qt_NavigationMode_Enum (decl_Qt_NavigationMode_Enums, "Qt_NavigationMode",
  qt_gsi::mkdefs_Qt_NavigationMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_NavigationMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_NavigationMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_NavigationMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_NavigationMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_NavigationMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::NavigationMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_NavigationMode_Enum_in_parent (qt_gsi::mkdefs_Qt_NavigationMode ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_NavigationMode_Enum_as_child (decl_Qt_NavigationMode_Enum, "NavigationMode");

}


//  Implementation of the enum wrapper class for Qt::Orientation
namespace qt_gsi
{

static Qt_Orientation_Enum *c_1_Qt_Orientation_Enum () { return new Qt_Orientation_Enum (Qt::Horizontal); }
static Qt_Orientation_Enum *c_2_Qt_Orientation_Enum () { return new Qt_Orientation_Enum (Qt::Vertical); }

static gsi::Methods mkdefs_Qt_Orientation () {
  return
    gsi::constant ("Horizontal", &qt_gsi::c_1_Qt_Orientation_Enum, "@brief Enum constant Qt::Horizontal") +
    gsi::constant ("Vertical", &qt_gsi::c_2_Qt_Orientation_Enum, "@brief Enum constant Qt::Vertical");
}

static std::string to_s_Qt_Orientation_Enum (const Qt_Orientation_Enum *e)
{
  if (e->value () == Qt::Horizontal) { return tl::sprintf ("Horizontal (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Vertical) { return tl::sprintf ("Vertical (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_Orientation_Enum (const Qt_Orientation_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_Orientation_Enum *from_i_Qt_Orientation_Enum (unsigned int i)
{
  return new Qt_Orientation_Enum ((Qt::Orientation) i);
}

static bool equalQt_Orientation_Enum (const Qt_Orientation_Enum *e, Qt_Orientation_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_Orientation_Enum (const Qt_Orientation_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_Orientation_Enums oropQt_Orientation_Enums (const Qt_Orientation_Enums *e, const Qt_Orientation_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_Orientation_Enums andopQt_Orientation_Enums (const Qt_Orientation_Enums *e, const Qt_Orientation_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_Orientation_Enums xoropQt_Orientation_Enums (const Qt_Orientation_Enums *e, const Qt_Orientation_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_Orientation_Enums (const Qt_Orientation_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::Horizontal)) { if (!l.empty ()) l += "|"; l += "Horizontal"; }
  if (e->testFlag (Qt::Vertical)) { if (!l.empty ()) l += "|"; l += "Vertical"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_Orientation_Enums (const Qt_Orientation_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_Orientation_Enums (const Qt_Orientation_Enums *e, const Qt_Orientation_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_Orientation_Enums> decl_Qt_Orientation_Enums ("Qt_QFlags_Orientation",
  gsi::method_ext ("|", &qt_gsi::oropQt_Orientation_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_Orientation_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_Orientation_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Orientation_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Orientation_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_Orientation_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::Orientation> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_Orientation_Enum> decl_Qt_Orientation_Enum (decl_Qt_Orientation_Enums, "Qt_Orientation",
  qt_gsi::mkdefs_Qt_Orientation () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_Orientation_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_Orientation_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_Orientation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_Orientation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_Orientation_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::Orientation enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_Orientation_Enum_in_parent (qt_gsi::mkdefs_Qt_Orientation ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_Orientation_Enum_as_child (decl_Qt_Orientation_Enum, "Orientation");

}


//  Implementation of the enum wrapper class for Qt::PenCapStyle
namespace qt_gsi
{

static Qt_PenCapStyle_Enum *c_1_Qt_PenCapStyle_Enum () { return new Qt_PenCapStyle_Enum (Qt::FlatCap); }
static Qt_PenCapStyle_Enum *c_2_Qt_PenCapStyle_Enum () { return new Qt_PenCapStyle_Enum (Qt::SquareCap); }
static Qt_PenCapStyle_Enum *c_3_Qt_PenCapStyle_Enum () { return new Qt_PenCapStyle_Enum (Qt::RoundCap); }
static Qt_PenCapStyle_Enum *c_4_Qt_PenCapStyle_Enum () { return new Qt_PenCapStyle_Enum (Qt::MPenCapStyle); }

static gsi::Methods mkdefs_Qt_PenCapStyle () {
  return
    gsi::constant ("FlatCap", &qt_gsi::c_1_Qt_PenCapStyle_Enum, "@brief Enum constant Qt::FlatCap") +
    gsi::constant ("SquareCap", &qt_gsi::c_2_Qt_PenCapStyle_Enum, "@brief Enum constant Qt::SquareCap") +
    gsi::constant ("RoundCap", &qt_gsi::c_3_Qt_PenCapStyle_Enum, "@brief Enum constant Qt::RoundCap") +
    gsi::constant ("MPenCapStyle", &qt_gsi::c_4_Qt_PenCapStyle_Enum, "@brief Enum constant Qt::MPenCapStyle");
}

static std::string to_s_Qt_PenCapStyle_Enum (const Qt_PenCapStyle_Enum *e)
{
  if (e->value () == Qt::FlatCap) { return tl::sprintf ("FlatCap (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SquareCap) { return tl::sprintf ("SquareCap (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RoundCap) { return tl::sprintf ("RoundCap (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MPenCapStyle) { return tl::sprintf ("MPenCapStyle (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_PenCapStyle_Enum (const Qt_PenCapStyle_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_PenCapStyle_Enum *from_i_Qt_PenCapStyle_Enum (unsigned int i)
{
  return new Qt_PenCapStyle_Enum ((Qt::PenCapStyle) i);
}

static bool equalQt_PenCapStyle_Enum (const Qt_PenCapStyle_Enum *e, Qt_PenCapStyle_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_PenCapStyle_Enum (const Qt_PenCapStyle_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_PenCapStyle_Enums oropQt_PenCapStyle_Enums (const Qt_PenCapStyle_Enums *e, const Qt_PenCapStyle_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_PenCapStyle_Enums andopQt_PenCapStyle_Enums (const Qt_PenCapStyle_Enums *e, const Qt_PenCapStyle_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_PenCapStyle_Enums xoropQt_PenCapStyle_Enums (const Qt_PenCapStyle_Enums *e, const Qt_PenCapStyle_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_PenCapStyle_Enums (const Qt_PenCapStyle_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::FlatCap)) { if (!l.empty ()) l += "|"; l += "FlatCap"; }
  if (e->testFlag (Qt::SquareCap)) { if (!l.empty ()) l += "|"; l += "SquareCap"; }
  if (e->testFlag (Qt::RoundCap)) { if (!l.empty ()) l += "|"; l += "RoundCap"; }
  if (e->testFlag (Qt::MPenCapStyle)) { if (!l.empty ()) l += "|"; l += "MPenCapStyle"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_PenCapStyle_Enums (const Qt_PenCapStyle_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_PenCapStyle_Enums (const Qt_PenCapStyle_Enums *e, const Qt_PenCapStyle_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_PenCapStyle_Enums> decl_Qt_PenCapStyle_Enums ("Qt_QFlags_PenCapStyle",
  gsi::method_ext ("|", &qt_gsi::oropQt_PenCapStyle_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_PenCapStyle_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_PenCapStyle_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_PenCapStyle_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_PenCapStyle_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_PenCapStyle_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::PenCapStyle> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_PenCapStyle_Enum> decl_Qt_PenCapStyle_Enum (decl_Qt_PenCapStyle_Enums, "Qt_PenCapStyle",
  qt_gsi::mkdefs_Qt_PenCapStyle () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_PenCapStyle_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_PenCapStyle_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_PenCapStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_PenCapStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_PenCapStyle_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::PenCapStyle enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_PenCapStyle_Enum_in_parent (qt_gsi::mkdefs_Qt_PenCapStyle ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_PenCapStyle_Enum_as_child (decl_Qt_PenCapStyle_Enum, "PenCapStyle");

}


//  Implementation of the enum wrapper class for Qt::PenJoinStyle
namespace qt_gsi
{

static Qt_PenJoinStyle_Enum *c_1_Qt_PenJoinStyle_Enum () { return new Qt_PenJoinStyle_Enum (Qt::MiterJoin); }
static Qt_PenJoinStyle_Enum *c_2_Qt_PenJoinStyle_Enum () { return new Qt_PenJoinStyle_Enum (Qt::BevelJoin); }
static Qt_PenJoinStyle_Enum *c_3_Qt_PenJoinStyle_Enum () { return new Qt_PenJoinStyle_Enum (Qt::RoundJoin); }
static Qt_PenJoinStyle_Enum *c_4_Qt_PenJoinStyle_Enum () { return new Qt_PenJoinStyle_Enum (Qt::SvgMiterJoin); }
static Qt_PenJoinStyle_Enum *c_5_Qt_PenJoinStyle_Enum () { return new Qt_PenJoinStyle_Enum (Qt::MPenJoinStyle); }

static gsi::Methods mkdefs_Qt_PenJoinStyle () {
  return
    gsi::constant ("MiterJoin", &qt_gsi::c_1_Qt_PenJoinStyle_Enum, "@brief Enum constant Qt::MiterJoin") +
    gsi::constant ("BevelJoin", &qt_gsi::c_2_Qt_PenJoinStyle_Enum, "@brief Enum constant Qt::BevelJoin") +
    gsi::constant ("RoundJoin", &qt_gsi::c_3_Qt_PenJoinStyle_Enum, "@brief Enum constant Qt::RoundJoin") +
    gsi::constant ("SvgMiterJoin", &qt_gsi::c_4_Qt_PenJoinStyle_Enum, "@brief Enum constant Qt::SvgMiterJoin") +
    gsi::constant ("MPenJoinStyle", &qt_gsi::c_5_Qt_PenJoinStyle_Enum, "@brief Enum constant Qt::MPenJoinStyle");
}

static std::string to_s_Qt_PenJoinStyle_Enum (const Qt_PenJoinStyle_Enum *e)
{
  if (e->value () == Qt::MiterJoin) { return tl::sprintf ("MiterJoin (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BevelJoin) { return tl::sprintf ("BevelJoin (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RoundJoin) { return tl::sprintf ("RoundJoin (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SvgMiterJoin) { return tl::sprintf ("SvgMiterJoin (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MPenJoinStyle) { return tl::sprintf ("MPenJoinStyle (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_PenJoinStyle_Enum (const Qt_PenJoinStyle_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_PenJoinStyle_Enum *from_i_Qt_PenJoinStyle_Enum (unsigned int i)
{
  return new Qt_PenJoinStyle_Enum ((Qt::PenJoinStyle) i);
}

static bool equalQt_PenJoinStyle_Enum (const Qt_PenJoinStyle_Enum *e, Qt_PenJoinStyle_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_PenJoinStyle_Enum (const Qt_PenJoinStyle_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_PenJoinStyle_Enums oropQt_PenJoinStyle_Enums (const Qt_PenJoinStyle_Enums *e, const Qt_PenJoinStyle_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_PenJoinStyle_Enums andopQt_PenJoinStyle_Enums (const Qt_PenJoinStyle_Enums *e, const Qt_PenJoinStyle_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_PenJoinStyle_Enums xoropQt_PenJoinStyle_Enums (const Qt_PenJoinStyle_Enums *e, const Qt_PenJoinStyle_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_PenJoinStyle_Enums (const Qt_PenJoinStyle_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::MiterJoin)) { if (!l.empty ()) l += "|"; l += "MiterJoin"; }
  if (e->testFlag (Qt::BevelJoin)) { if (!l.empty ()) l += "|"; l += "BevelJoin"; }
  if (e->testFlag (Qt::RoundJoin)) { if (!l.empty ()) l += "|"; l += "RoundJoin"; }
  if (e->testFlag (Qt::SvgMiterJoin)) { if (!l.empty ()) l += "|"; l += "SvgMiterJoin"; }
  if (e->testFlag (Qt::MPenJoinStyle)) { if (!l.empty ()) l += "|"; l += "MPenJoinStyle"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_PenJoinStyle_Enums (const Qt_PenJoinStyle_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_PenJoinStyle_Enums (const Qt_PenJoinStyle_Enums *e, const Qt_PenJoinStyle_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_PenJoinStyle_Enums> decl_Qt_PenJoinStyle_Enums ("Qt_QFlags_PenJoinStyle",
  gsi::method_ext ("|", &qt_gsi::oropQt_PenJoinStyle_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_PenJoinStyle_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_PenJoinStyle_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_PenJoinStyle_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_PenJoinStyle_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_PenJoinStyle_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::PenJoinStyle> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_PenJoinStyle_Enum> decl_Qt_PenJoinStyle_Enum (decl_Qt_PenJoinStyle_Enums, "Qt_PenJoinStyle",
  qt_gsi::mkdefs_Qt_PenJoinStyle () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_PenJoinStyle_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_PenJoinStyle_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_PenJoinStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_PenJoinStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_PenJoinStyle_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::PenJoinStyle enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_PenJoinStyle_Enum_in_parent (qt_gsi::mkdefs_Qt_PenJoinStyle ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_PenJoinStyle_Enum_as_child (decl_Qt_PenJoinStyle_Enum, "PenJoinStyle");

}


//  Implementation of the enum wrapper class for Qt::PenStyle
namespace qt_gsi
{

static Qt_PenStyle_Enum *c_1_Qt_PenStyle_Enum () { return new Qt_PenStyle_Enum (Qt::NoPen); }
static Qt_PenStyle_Enum *c_2_Qt_PenStyle_Enum () { return new Qt_PenStyle_Enum (Qt::SolidLine); }
static Qt_PenStyle_Enum *c_3_Qt_PenStyle_Enum () { return new Qt_PenStyle_Enum (Qt::DashLine); }
static Qt_PenStyle_Enum *c_4_Qt_PenStyle_Enum () { return new Qt_PenStyle_Enum (Qt::DotLine); }
static Qt_PenStyle_Enum *c_5_Qt_PenStyle_Enum () { return new Qt_PenStyle_Enum (Qt::DashDotLine); }
static Qt_PenStyle_Enum *c_6_Qt_PenStyle_Enum () { return new Qt_PenStyle_Enum (Qt::DashDotDotLine); }
static Qt_PenStyle_Enum *c_7_Qt_PenStyle_Enum () { return new Qt_PenStyle_Enum (Qt::CustomDashLine); }
static Qt_PenStyle_Enum *c_8_Qt_PenStyle_Enum () { return new Qt_PenStyle_Enum (Qt::MPenStyle); }

static gsi::Methods mkdefs_Qt_PenStyle () {
  return
    gsi::constant ("NoPen", &qt_gsi::c_1_Qt_PenStyle_Enum, "@brief Enum constant Qt::NoPen") +
    gsi::constant ("SolidLine", &qt_gsi::c_2_Qt_PenStyle_Enum, "@brief Enum constant Qt::SolidLine") +
    gsi::constant ("DashLine", &qt_gsi::c_3_Qt_PenStyle_Enum, "@brief Enum constant Qt::DashLine") +
    gsi::constant ("DotLine", &qt_gsi::c_4_Qt_PenStyle_Enum, "@brief Enum constant Qt::DotLine") +
    gsi::constant ("DashDotLine", &qt_gsi::c_5_Qt_PenStyle_Enum, "@brief Enum constant Qt::DashDotLine") +
    gsi::constant ("DashDotDotLine", &qt_gsi::c_6_Qt_PenStyle_Enum, "@brief Enum constant Qt::DashDotDotLine") +
    gsi::constant ("CustomDashLine", &qt_gsi::c_7_Qt_PenStyle_Enum, "@brief Enum constant Qt::CustomDashLine") +
    gsi::constant ("MPenStyle", &qt_gsi::c_8_Qt_PenStyle_Enum, "@brief Enum constant Qt::MPenStyle");
}

static std::string to_s_Qt_PenStyle_Enum (const Qt_PenStyle_Enum *e)
{
  if (e->value () == Qt::NoPen) { return tl::sprintf ("NoPen (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SolidLine) { return tl::sprintf ("SolidLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DashLine) { return tl::sprintf ("DashLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DotLine) { return tl::sprintf ("DotLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DashDotLine) { return tl::sprintf ("DashDotLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DashDotDotLine) { return tl::sprintf ("DashDotDotLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CustomDashLine) { return tl::sprintf ("CustomDashLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MPenStyle) { return tl::sprintf ("MPenStyle (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_PenStyle_Enum (const Qt_PenStyle_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_PenStyle_Enum *from_i_Qt_PenStyle_Enum (unsigned int i)
{
  return new Qt_PenStyle_Enum ((Qt::PenStyle) i);
}

static bool equalQt_PenStyle_Enum (const Qt_PenStyle_Enum *e, Qt_PenStyle_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_PenStyle_Enum (const Qt_PenStyle_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_PenStyle_Enums oropQt_PenStyle_Enums (const Qt_PenStyle_Enums *e, const Qt_PenStyle_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_PenStyle_Enums andopQt_PenStyle_Enums (const Qt_PenStyle_Enums *e, const Qt_PenStyle_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_PenStyle_Enums xoropQt_PenStyle_Enums (const Qt_PenStyle_Enums *e, const Qt_PenStyle_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_PenStyle_Enums (const Qt_PenStyle_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoPen)) { if (!l.empty ()) l += "|"; l += "NoPen"; }
  if (e->testFlag (Qt::SolidLine)) { if (!l.empty ()) l += "|"; l += "SolidLine"; }
  if (e->testFlag (Qt::DashLine)) { if (!l.empty ()) l += "|"; l += "DashLine"; }
  if (e->testFlag (Qt::DotLine)) { if (!l.empty ()) l += "|"; l += "DotLine"; }
  if (e->testFlag (Qt::DashDotLine)) { if (!l.empty ()) l += "|"; l += "DashDotLine"; }
  if (e->testFlag (Qt::DashDotDotLine)) { if (!l.empty ()) l += "|"; l += "DashDotDotLine"; }
  if (e->testFlag (Qt::CustomDashLine)) { if (!l.empty ()) l += "|"; l += "CustomDashLine"; }
  if (e->testFlag (Qt::MPenStyle)) { if (!l.empty ()) l += "|"; l += "MPenStyle"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_PenStyle_Enums (const Qt_PenStyle_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_PenStyle_Enums (const Qt_PenStyle_Enums *e, const Qt_PenStyle_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_PenStyle_Enums> decl_Qt_PenStyle_Enums ("Qt_QFlags_PenStyle",
  gsi::method_ext ("|", &qt_gsi::oropQt_PenStyle_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_PenStyle_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_PenStyle_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_PenStyle_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_PenStyle_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_PenStyle_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::PenStyle> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_PenStyle_Enum> decl_Qt_PenStyle_Enum (decl_Qt_PenStyle_Enums, "Qt_PenStyle",
  qt_gsi::mkdefs_Qt_PenStyle () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_PenStyle_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_PenStyle_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_PenStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_PenStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_PenStyle_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::PenStyle enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_PenStyle_Enum_in_parent (qt_gsi::mkdefs_Qt_PenStyle ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_PenStyle_Enum_as_child (decl_Qt_PenStyle_Enum, "PenStyle");

}


//  Implementation of the enum wrapper class for Qt::ScrollBarPolicy
namespace qt_gsi
{

static Qt_ScrollBarPolicy_Enum *c_1_Qt_ScrollBarPolicy_Enum () { return new Qt_ScrollBarPolicy_Enum (Qt::ScrollBarAsNeeded); }
static Qt_ScrollBarPolicy_Enum *c_2_Qt_ScrollBarPolicy_Enum () { return new Qt_ScrollBarPolicy_Enum (Qt::ScrollBarAlwaysOff); }
static Qt_ScrollBarPolicy_Enum *c_3_Qt_ScrollBarPolicy_Enum () { return new Qt_ScrollBarPolicy_Enum (Qt::ScrollBarAlwaysOn); }

static gsi::Methods mkdefs_Qt_ScrollBarPolicy () {
  return
    gsi::constant ("ScrollBarAsNeeded", &qt_gsi::c_1_Qt_ScrollBarPolicy_Enum, "@brief Enum constant Qt::ScrollBarAsNeeded") +
    gsi::constant ("ScrollBarAlwaysOff", &qt_gsi::c_2_Qt_ScrollBarPolicy_Enum, "@brief Enum constant Qt::ScrollBarAlwaysOff") +
    gsi::constant ("ScrollBarAlwaysOn", &qt_gsi::c_3_Qt_ScrollBarPolicy_Enum, "@brief Enum constant Qt::ScrollBarAlwaysOn");
}

static std::string to_s_Qt_ScrollBarPolicy_Enum (const Qt_ScrollBarPolicy_Enum *e)
{
  if (e->value () == Qt::ScrollBarAsNeeded) { return tl::sprintf ("ScrollBarAsNeeded (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ScrollBarAlwaysOff) { return tl::sprintf ("ScrollBarAlwaysOff (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ScrollBarAlwaysOn) { return tl::sprintf ("ScrollBarAlwaysOn (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ScrollBarPolicy_Enum (const Qt_ScrollBarPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ScrollBarPolicy_Enum *from_i_Qt_ScrollBarPolicy_Enum (unsigned int i)
{
  return new Qt_ScrollBarPolicy_Enum ((Qt::ScrollBarPolicy) i);
}

static bool equalQt_ScrollBarPolicy_Enum (const Qt_ScrollBarPolicy_Enum *e, Qt_ScrollBarPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ScrollBarPolicy_Enum (const Qt_ScrollBarPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ScrollBarPolicy_Enums oropQt_ScrollBarPolicy_Enums (const Qt_ScrollBarPolicy_Enums *e, const Qt_ScrollBarPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ScrollBarPolicy_Enums andopQt_ScrollBarPolicy_Enums (const Qt_ScrollBarPolicy_Enums *e, const Qt_ScrollBarPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ScrollBarPolicy_Enums xoropQt_ScrollBarPolicy_Enums (const Qt_ScrollBarPolicy_Enums *e, const Qt_ScrollBarPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ScrollBarPolicy_Enums (const Qt_ScrollBarPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::ScrollBarAsNeeded)) { if (!l.empty ()) l += "|"; l += "ScrollBarAsNeeded"; }
  if (e->testFlag (Qt::ScrollBarAlwaysOff)) { if (!l.empty ()) l += "|"; l += "ScrollBarAlwaysOff"; }
  if (e->testFlag (Qt::ScrollBarAlwaysOn)) { if (!l.empty ()) l += "|"; l += "ScrollBarAlwaysOn"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ScrollBarPolicy_Enums (const Qt_ScrollBarPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ScrollBarPolicy_Enums (const Qt_ScrollBarPolicy_Enums *e, const Qt_ScrollBarPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ScrollBarPolicy_Enums> decl_Qt_ScrollBarPolicy_Enums ("Qt_QFlags_ScrollBarPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQt_ScrollBarPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ScrollBarPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ScrollBarPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ScrollBarPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ScrollBarPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ScrollBarPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ScrollBarPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ScrollBarPolicy_Enum> decl_Qt_ScrollBarPolicy_Enum (decl_Qt_ScrollBarPolicy_Enums, "Qt_ScrollBarPolicy",
  qt_gsi::mkdefs_Qt_ScrollBarPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ScrollBarPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ScrollBarPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ScrollBarPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ScrollBarPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ScrollBarPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ScrollBarPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ScrollBarPolicy_Enum_in_parent (qt_gsi::mkdefs_Qt_ScrollBarPolicy ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ScrollBarPolicy_Enum_as_child (decl_Qt_ScrollBarPolicy_Enum, "ScrollBarPolicy");

}


//  Implementation of the enum wrapper class for Qt::ShortcutContext
namespace qt_gsi
{

static Qt_ShortcutContext_Enum *c_1_Qt_ShortcutContext_Enum () { return new Qt_ShortcutContext_Enum (Qt::WidgetShortcut); }
static Qt_ShortcutContext_Enum *c_2_Qt_ShortcutContext_Enum () { return new Qt_ShortcutContext_Enum (Qt::WindowShortcut); }
static Qt_ShortcutContext_Enum *c_3_Qt_ShortcutContext_Enum () { return new Qt_ShortcutContext_Enum (Qt::ApplicationShortcut); }
static Qt_ShortcutContext_Enum *c_4_Qt_ShortcutContext_Enum () { return new Qt_ShortcutContext_Enum (Qt::WidgetWithChildrenShortcut); }

static gsi::Methods mkdefs_Qt_ShortcutContext () {
  return
    gsi::constant ("WidgetShortcut", &qt_gsi::c_1_Qt_ShortcutContext_Enum, "@brief Enum constant Qt::WidgetShortcut") +
    gsi::constant ("WindowShortcut", &qt_gsi::c_2_Qt_ShortcutContext_Enum, "@brief Enum constant Qt::WindowShortcut") +
    gsi::constant ("ApplicationShortcut", &qt_gsi::c_3_Qt_ShortcutContext_Enum, "@brief Enum constant Qt::ApplicationShortcut") +
    gsi::constant ("WidgetWithChildrenShortcut", &qt_gsi::c_4_Qt_ShortcutContext_Enum, "@brief Enum constant Qt::WidgetWithChildrenShortcut");
}

static std::string to_s_Qt_ShortcutContext_Enum (const Qt_ShortcutContext_Enum *e)
{
  if (e->value () == Qt::WidgetShortcut) { return tl::sprintf ("WidgetShortcut (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowShortcut) { return tl::sprintf ("WindowShortcut (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ApplicationShortcut) { return tl::sprintf ("ApplicationShortcut (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WidgetWithChildrenShortcut) { return tl::sprintf ("WidgetWithChildrenShortcut (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ShortcutContext_Enum (const Qt_ShortcutContext_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ShortcutContext_Enum *from_i_Qt_ShortcutContext_Enum (unsigned int i)
{
  return new Qt_ShortcutContext_Enum ((Qt::ShortcutContext) i);
}

static bool equalQt_ShortcutContext_Enum (const Qt_ShortcutContext_Enum *e, Qt_ShortcutContext_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ShortcutContext_Enum (const Qt_ShortcutContext_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ShortcutContext_Enums oropQt_ShortcutContext_Enums (const Qt_ShortcutContext_Enums *e, const Qt_ShortcutContext_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ShortcutContext_Enums andopQt_ShortcutContext_Enums (const Qt_ShortcutContext_Enums *e, const Qt_ShortcutContext_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ShortcutContext_Enums xoropQt_ShortcutContext_Enums (const Qt_ShortcutContext_Enums *e, const Qt_ShortcutContext_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ShortcutContext_Enums (const Qt_ShortcutContext_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::WidgetShortcut)) { if (!l.empty ()) l += "|"; l += "WidgetShortcut"; }
  if (e->testFlag (Qt::WindowShortcut)) { if (!l.empty ()) l += "|"; l += "WindowShortcut"; }
  if (e->testFlag (Qt::ApplicationShortcut)) { if (!l.empty ()) l += "|"; l += "ApplicationShortcut"; }
  if (e->testFlag (Qt::WidgetWithChildrenShortcut)) { if (!l.empty ()) l += "|"; l += "WidgetWithChildrenShortcut"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ShortcutContext_Enums (const Qt_ShortcutContext_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ShortcutContext_Enums (const Qt_ShortcutContext_Enums *e, const Qt_ShortcutContext_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ShortcutContext_Enums> decl_Qt_ShortcutContext_Enums ("Qt_QFlags_ShortcutContext",
  gsi::method_ext ("|", &qt_gsi::oropQt_ShortcutContext_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ShortcutContext_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ShortcutContext_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ShortcutContext_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ShortcutContext_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ShortcutContext_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ShortcutContext> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ShortcutContext_Enum> decl_Qt_ShortcutContext_Enum (decl_Qt_ShortcutContext_Enums, "Qt_ShortcutContext",
  qt_gsi::mkdefs_Qt_ShortcutContext () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ShortcutContext_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ShortcutContext_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ShortcutContext_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ShortcutContext_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ShortcutContext_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ShortcutContext enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ShortcutContext_Enum_in_parent (qt_gsi::mkdefs_Qt_ShortcutContext ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ShortcutContext_Enum_as_child (decl_Qt_ShortcutContext_Enum, "ShortcutContext");

}


//  Implementation of the enum wrapper class for Qt::SizeHint
namespace qt_gsi
{

static Qt_SizeHint_Enum *c_1_Qt_SizeHint_Enum () { return new Qt_SizeHint_Enum (Qt::MinimumSize); }
static Qt_SizeHint_Enum *c_2_Qt_SizeHint_Enum () { return new Qt_SizeHint_Enum (Qt::PreferredSize); }
static Qt_SizeHint_Enum *c_3_Qt_SizeHint_Enum () { return new Qt_SizeHint_Enum (Qt::MaximumSize); }
static Qt_SizeHint_Enum *c_4_Qt_SizeHint_Enum () { return new Qt_SizeHint_Enum (Qt::MinimumDescent); }
static Qt_SizeHint_Enum *c_5_Qt_SizeHint_Enum () { return new Qt_SizeHint_Enum (Qt::NSizeHints); }

static gsi::Methods mkdefs_Qt_SizeHint () {
  return
    gsi::constant ("MinimumSize", &qt_gsi::c_1_Qt_SizeHint_Enum, "@brief Enum constant Qt::MinimumSize") +
    gsi::constant ("PreferredSize", &qt_gsi::c_2_Qt_SizeHint_Enum, "@brief Enum constant Qt::PreferredSize") +
    gsi::constant ("MaximumSize", &qt_gsi::c_3_Qt_SizeHint_Enum, "@brief Enum constant Qt::MaximumSize") +
    gsi::constant ("MinimumDescent", &qt_gsi::c_4_Qt_SizeHint_Enum, "@brief Enum constant Qt::MinimumDescent") +
    gsi::constant ("NSizeHints", &qt_gsi::c_5_Qt_SizeHint_Enum, "@brief Enum constant Qt::NSizeHints");
}

static std::string to_s_Qt_SizeHint_Enum (const Qt_SizeHint_Enum *e)
{
  if (e->value () == Qt::MinimumSize) { return tl::sprintf ("MinimumSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::PreferredSize) { return tl::sprintf ("PreferredSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MaximumSize) { return tl::sprintf ("MaximumSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MinimumDescent) { return tl::sprintf ("MinimumDescent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NSizeHints) { return tl::sprintf ("NSizeHints (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_SizeHint_Enum (const Qt_SizeHint_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_SizeHint_Enum *from_i_Qt_SizeHint_Enum (unsigned int i)
{
  return new Qt_SizeHint_Enum ((Qt::SizeHint) i);
}

static bool equalQt_SizeHint_Enum (const Qt_SizeHint_Enum *e, Qt_SizeHint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_SizeHint_Enum (const Qt_SizeHint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_SizeHint_Enums oropQt_SizeHint_Enums (const Qt_SizeHint_Enums *e, const Qt_SizeHint_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_SizeHint_Enums andopQt_SizeHint_Enums (const Qt_SizeHint_Enums *e, const Qt_SizeHint_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_SizeHint_Enums xoropQt_SizeHint_Enums (const Qt_SizeHint_Enums *e, const Qt_SizeHint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_SizeHint_Enums (const Qt_SizeHint_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::MinimumSize)) { if (!l.empty ()) l += "|"; l += "MinimumSize"; }
  if (e->testFlag (Qt::PreferredSize)) { if (!l.empty ()) l += "|"; l += "PreferredSize"; }
  if (e->testFlag (Qt::MaximumSize)) { if (!l.empty ()) l += "|"; l += "MaximumSize"; }
  if (e->testFlag (Qt::MinimumDescent)) { if (!l.empty ()) l += "|"; l += "MinimumDescent"; }
  if (e->testFlag (Qt::NSizeHints)) { if (!l.empty ()) l += "|"; l += "NSizeHints"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_SizeHint_Enums (const Qt_SizeHint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_SizeHint_Enums (const Qt_SizeHint_Enums *e, const Qt_SizeHint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_SizeHint_Enums> decl_Qt_SizeHint_Enums ("Qt_QFlags_SizeHint",
  gsi::method_ext ("|", &qt_gsi::oropQt_SizeHint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_SizeHint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_SizeHint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_SizeHint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_SizeHint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_SizeHint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::SizeHint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_SizeHint_Enum> decl_Qt_SizeHint_Enum (decl_Qt_SizeHint_Enums, "Qt_SizeHint",
  qt_gsi::mkdefs_Qt_SizeHint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_SizeHint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_SizeHint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_SizeHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_SizeHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_SizeHint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::SizeHint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_SizeHint_Enum_in_parent (qt_gsi::mkdefs_Qt_SizeHint ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_SizeHint_Enum_as_child (decl_Qt_SizeHint_Enum, "SizeHint");

}


//  Implementation of the enum wrapper class for Qt::SizeMode
namespace qt_gsi
{

static Qt_SizeMode_Enum *c_1_Qt_SizeMode_Enum () { return new Qt_SizeMode_Enum (Qt::AbsoluteSize); }
static Qt_SizeMode_Enum *c_2_Qt_SizeMode_Enum () { return new Qt_SizeMode_Enum (Qt::RelativeSize); }

static gsi::Methods mkdefs_Qt_SizeMode () {
  return
    gsi::constant ("AbsoluteSize", &qt_gsi::c_1_Qt_SizeMode_Enum, "@brief Enum constant Qt::AbsoluteSize") +
    gsi::constant ("RelativeSize", &qt_gsi::c_2_Qt_SizeMode_Enum, "@brief Enum constant Qt::RelativeSize");
}

static std::string to_s_Qt_SizeMode_Enum (const Qt_SizeMode_Enum *e)
{
  if (e->value () == Qt::AbsoluteSize) { return tl::sprintf ("AbsoluteSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RelativeSize) { return tl::sprintf ("RelativeSize (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_SizeMode_Enum (const Qt_SizeMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_SizeMode_Enum *from_i_Qt_SizeMode_Enum (unsigned int i)
{
  return new Qt_SizeMode_Enum ((Qt::SizeMode) i);
}

static bool equalQt_SizeMode_Enum (const Qt_SizeMode_Enum *e, Qt_SizeMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_SizeMode_Enum (const Qt_SizeMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_SizeMode_Enums oropQt_SizeMode_Enums (const Qt_SizeMode_Enums *e, const Qt_SizeMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_SizeMode_Enums andopQt_SizeMode_Enums (const Qt_SizeMode_Enums *e, const Qt_SizeMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_SizeMode_Enums xoropQt_SizeMode_Enums (const Qt_SizeMode_Enums *e, const Qt_SizeMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_SizeMode_Enums (const Qt_SizeMode_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::AbsoluteSize)) { if (!l.empty ()) l += "|"; l += "AbsoluteSize"; }
  if (e->testFlag (Qt::RelativeSize)) { if (!l.empty ()) l += "|"; l += "RelativeSize"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_SizeMode_Enums (const Qt_SizeMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_SizeMode_Enums (const Qt_SizeMode_Enums *e, const Qt_SizeMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_SizeMode_Enums> decl_Qt_SizeMode_Enums ("Qt_QFlags_SizeMode",
  gsi::method_ext ("|", &qt_gsi::oropQt_SizeMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_SizeMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_SizeMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_SizeMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_SizeMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_SizeMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::SizeMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_SizeMode_Enum> decl_Qt_SizeMode_Enum (decl_Qt_SizeMode_Enums, "Qt_SizeMode",
  qt_gsi::mkdefs_Qt_SizeMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_SizeMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_SizeMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_SizeMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_SizeMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_SizeMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::SizeMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_SizeMode_Enum_in_parent (qt_gsi::mkdefs_Qt_SizeMode ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_SizeMode_Enum_as_child (decl_Qt_SizeMode_Enum, "SizeMode");

}


//  Implementation of the enum wrapper class for Qt::SortOrder
namespace qt_gsi
{

static Qt_SortOrder_Enum *c_1_Qt_SortOrder_Enum () { return new Qt_SortOrder_Enum (Qt::AscendingOrder); }
static Qt_SortOrder_Enum *c_2_Qt_SortOrder_Enum () { return new Qt_SortOrder_Enum (Qt::DescendingOrder); }

static gsi::Methods mkdefs_Qt_SortOrder () {
  return
    gsi::constant ("AscendingOrder", &qt_gsi::c_1_Qt_SortOrder_Enum, "@brief Enum constant Qt::AscendingOrder") +
    gsi::constant ("DescendingOrder", &qt_gsi::c_2_Qt_SortOrder_Enum, "@brief Enum constant Qt::DescendingOrder");
}

static std::string to_s_Qt_SortOrder_Enum (const Qt_SortOrder_Enum *e)
{
  if (e->value () == Qt::AscendingOrder) { return tl::sprintf ("AscendingOrder (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::DescendingOrder) { return tl::sprintf ("DescendingOrder (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_SortOrder_Enum (const Qt_SortOrder_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_SortOrder_Enum *from_i_Qt_SortOrder_Enum (unsigned int i)
{
  return new Qt_SortOrder_Enum ((Qt::SortOrder) i);
}

static bool equalQt_SortOrder_Enum (const Qt_SortOrder_Enum *e, Qt_SortOrder_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_SortOrder_Enum (const Qt_SortOrder_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_SortOrder_Enums oropQt_SortOrder_Enums (const Qt_SortOrder_Enums *e, const Qt_SortOrder_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_SortOrder_Enums andopQt_SortOrder_Enums (const Qt_SortOrder_Enums *e, const Qt_SortOrder_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_SortOrder_Enums xoropQt_SortOrder_Enums (const Qt_SortOrder_Enums *e, const Qt_SortOrder_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_SortOrder_Enums (const Qt_SortOrder_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::AscendingOrder)) { if (!l.empty ()) l += "|"; l += "AscendingOrder"; }
  if (e->testFlag (Qt::DescendingOrder)) { if (!l.empty ()) l += "|"; l += "DescendingOrder"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_SortOrder_Enums (const Qt_SortOrder_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_SortOrder_Enums (const Qt_SortOrder_Enums *e, const Qt_SortOrder_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_SortOrder_Enums> decl_Qt_SortOrder_Enums ("Qt_QFlags_SortOrder",
  gsi::method_ext ("|", &qt_gsi::oropQt_SortOrder_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_SortOrder_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_SortOrder_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_SortOrder_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_SortOrder_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_SortOrder_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::SortOrder> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_SortOrder_Enum> decl_Qt_SortOrder_Enum (decl_Qt_SortOrder_Enums, "Qt_SortOrder",
  qt_gsi::mkdefs_Qt_SortOrder () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_SortOrder_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_SortOrder_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_SortOrder_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_SortOrder_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_SortOrder_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::SortOrder enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_SortOrder_Enum_in_parent (qt_gsi::mkdefs_Qt_SortOrder ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_SortOrder_Enum_as_child (decl_Qt_SortOrder_Enum, "SortOrder");

}


//  Implementation of the enum wrapper class for Qt::TextElideMode
namespace qt_gsi
{

static Qt_TextElideMode_Enum *c_1_Qt_TextElideMode_Enum () { return new Qt_TextElideMode_Enum (Qt::ElideLeft); }
static Qt_TextElideMode_Enum *c_2_Qt_TextElideMode_Enum () { return new Qt_TextElideMode_Enum (Qt::ElideRight); }
static Qt_TextElideMode_Enum *c_3_Qt_TextElideMode_Enum () { return new Qt_TextElideMode_Enum (Qt::ElideMiddle); }
static Qt_TextElideMode_Enum *c_4_Qt_TextElideMode_Enum () { return new Qt_TextElideMode_Enum (Qt::ElideNone); }

static gsi::Methods mkdefs_Qt_TextElideMode () {
  return
    gsi::constant ("ElideLeft", &qt_gsi::c_1_Qt_TextElideMode_Enum, "@brief Enum constant Qt::ElideLeft") +
    gsi::constant ("ElideRight", &qt_gsi::c_2_Qt_TextElideMode_Enum, "@brief Enum constant Qt::ElideRight") +
    gsi::constant ("ElideMiddle", &qt_gsi::c_3_Qt_TextElideMode_Enum, "@brief Enum constant Qt::ElideMiddle") +
    gsi::constant ("ElideNone", &qt_gsi::c_4_Qt_TextElideMode_Enum, "@brief Enum constant Qt::ElideNone");
}

static std::string to_s_Qt_TextElideMode_Enum (const Qt_TextElideMode_Enum *e)
{
  if (e->value () == Qt::ElideLeft) { return tl::sprintf ("ElideLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ElideRight) { return tl::sprintf ("ElideRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ElideMiddle) { return tl::sprintf ("ElideMiddle (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ElideNone) { return tl::sprintf ("ElideNone (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_TextElideMode_Enum (const Qt_TextElideMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_TextElideMode_Enum *from_i_Qt_TextElideMode_Enum (unsigned int i)
{
  return new Qt_TextElideMode_Enum ((Qt::TextElideMode) i);
}

static bool equalQt_TextElideMode_Enum (const Qt_TextElideMode_Enum *e, Qt_TextElideMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_TextElideMode_Enum (const Qt_TextElideMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_TextElideMode_Enums oropQt_TextElideMode_Enums (const Qt_TextElideMode_Enums *e, const Qt_TextElideMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_TextElideMode_Enums andopQt_TextElideMode_Enums (const Qt_TextElideMode_Enums *e, const Qt_TextElideMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_TextElideMode_Enums xoropQt_TextElideMode_Enums (const Qt_TextElideMode_Enums *e, const Qt_TextElideMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_TextElideMode_Enums (const Qt_TextElideMode_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::ElideLeft)) { if (!l.empty ()) l += "|"; l += "ElideLeft"; }
  if (e->testFlag (Qt::ElideRight)) { if (!l.empty ()) l += "|"; l += "ElideRight"; }
  if (e->testFlag (Qt::ElideMiddle)) { if (!l.empty ()) l += "|"; l += "ElideMiddle"; }
  if (e->testFlag (Qt::ElideNone)) { if (!l.empty ()) l += "|"; l += "ElideNone"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_TextElideMode_Enums (const Qt_TextElideMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_TextElideMode_Enums (const Qt_TextElideMode_Enums *e, const Qt_TextElideMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_TextElideMode_Enums> decl_Qt_TextElideMode_Enums ("Qt_QFlags_TextElideMode",
  gsi::method_ext ("|", &qt_gsi::oropQt_TextElideMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_TextElideMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_TextElideMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TextElideMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TextElideMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_TextElideMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::TextElideMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_TextElideMode_Enum> decl_Qt_TextElideMode_Enum (decl_Qt_TextElideMode_Enums, "Qt_TextElideMode",
  qt_gsi::mkdefs_Qt_TextElideMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TextElideMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TextElideMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_TextElideMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_TextElideMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_TextElideMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::TextElideMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_TextElideMode_Enum_in_parent (qt_gsi::mkdefs_Qt_TextElideMode ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_TextElideMode_Enum_as_child (decl_Qt_TextElideMode_Enum, "TextElideMode");

}


//  Implementation of the enum wrapper class for Qt::TextFlag
namespace qt_gsi
{

static Qt_TextFlag_Enum *c_1_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextSingleLine); }
static Qt_TextFlag_Enum *c_2_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextDontClip); }
static Qt_TextFlag_Enum *c_3_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextExpandTabs); }
static Qt_TextFlag_Enum *c_4_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextShowMnemonic); }
static Qt_TextFlag_Enum *c_5_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextWordWrap); }
static Qt_TextFlag_Enum *c_6_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextWrapAnywhere); }
static Qt_TextFlag_Enum *c_7_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextDontPrint); }
static Qt_TextFlag_Enum *c_8_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextIncludeTrailingSpaces); }
static Qt_TextFlag_Enum *c_9_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextHideMnemonic); }
static Qt_TextFlag_Enum *c_10_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextJustificationForced); }
static Qt_TextFlag_Enum *c_11_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextForceLeftToRight); }
static Qt_TextFlag_Enum *c_12_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextForceRightToLeft); }
static Qt_TextFlag_Enum *c_13_Qt_TextFlag_Enum () { return new Qt_TextFlag_Enum (Qt::TextLongestVariant); }

static gsi::Methods mkdefs_Qt_TextFlag () {
  return
    gsi::constant ("TextSingleLine", &qt_gsi::c_1_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextSingleLine") +
    gsi::constant ("TextDontClip", &qt_gsi::c_2_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextDontClip") +
    gsi::constant ("TextExpandTabs", &qt_gsi::c_3_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextExpandTabs") +
    gsi::constant ("TextShowMnemonic", &qt_gsi::c_4_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextShowMnemonic") +
    gsi::constant ("TextWordWrap", &qt_gsi::c_5_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextWordWrap") +
    gsi::constant ("TextWrapAnywhere", &qt_gsi::c_6_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextWrapAnywhere") +
    gsi::constant ("TextDontPrint", &qt_gsi::c_7_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextDontPrint") +
    gsi::constant ("TextIncludeTrailingSpaces", &qt_gsi::c_8_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextIncludeTrailingSpaces") +
    gsi::constant ("TextHideMnemonic", &qt_gsi::c_9_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextHideMnemonic") +
    gsi::constant ("TextJustificationForced", &qt_gsi::c_10_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextJustificationForced") +
    gsi::constant ("TextForceLeftToRight", &qt_gsi::c_11_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextForceLeftToRight") +
    gsi::constant ("TextForceRightToLeft", &qt_gsi::c_12_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextForceRightToLeft") +
    gsi::constant ("TextLongestVariant", &qt_gsi::c_13_Qt_TextFlag_Enum, "@brief Enum constant Qt::TextLongestVariant");
}

static std::string to_s_Qt_TextFlag_Enum (const Qt_TextFlag_Enum *e)
{
  if (e->value () == Qt::TextSingleLine) { return tl::sprintf ("TextSingleLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextDontClip) { return tl::sprintf ("TextDontClip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextExpandTabs) { return tl::sprintf ("TextExpandTabs (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextShowMnemonic) { return tl::sprintf ("TextShowMnemonic (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextWordWrap) { return tl::sprintf ("TextWordWrap (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextWrapAnywhere) { return tl::sprintf ("TextWrapAnywhere (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextDontPrint) { return tl::sprintf ("TextDontPrint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextIncludeTrailingSpaces) { return tl::sprintf ("TextIncludeTrailingSpaces (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextHideMnemonic) { return tl::sprintf ("TextHideMnemonic (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextJustificationForced) { return tl::sprintf ("TextJustificationForced (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextForceLeftToRight) { return tl::sprintf ("TextForceLeftToRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextForceRightToLeft) { return tl::sprintf ("TextForceRightToLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextLongestVariant) { return tl::sprintf ("TextLongestVariant (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_TextFlag_Enum (const Qt_TextFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_TextFlag_Enum *from_i_Qt_TextFlag_Enum (unsigned int i)
{
  return new Qt_TextFlag_Enum ((Qt::TextFlag) i);
}

static bool equalQt_TextFlag_Enum (const Qt_TextFlag_Enum *e, Qt_TextFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_TextFlag_Enum (const Qt_TextFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_TextFlag_Enums oropQt_TextFlag_Enums (const Qt_TextFlag_Enums *e, const Qt_TextFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_TextFlag_Enums andopQt_TextFlag_Enums (const Qt_TextFlag_Enums *e, const Qt_TextFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_TextFlag_Enums xoropQt_TextFlag_Enums (const Qt_TextFlag_Enums *e, const Qt_TextFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_TextFlag_Enums (const Qt_TextFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::TextSingleLine)) { if (!l.empty ()) l += "|"; l += "TextSingleLine"; }
  if (e->testFlag (Qt::TextDontClip)) { if (!l.empty ()) l += "|"; l += "TextDontClip"; }
  if (e->testFlag (Qt::TextExpandTabs)) { if (!l.empty ()) l += "|"; l += "TextExpandTabs"; }
  if (e->testFlag (Qt::TextShowMnemonic)) { if (!l.empty ()) l += "|"; l += "TextShowMnemonic"; }
  if (e->testFlag (Qt::TextWordWrap)) { if (!l.empty ()) l += "|"; l += "TextWordWrap"; }
  if (e->testFlag (Qt::TextWrapAnywhere)) { if (!l.empty ()) l += "|"; l += "TextWrapAnywhere"; }
  if (e->testFlag (Qt::TextDontPrint)) { if (!l.empty ()) l += "|"; l += "TextDontPrint"; }
  if (e->testFlag (Qt::TextIncludeTrailingSpaces)) { if (!l.empty ()) l += "|"; l += "TextIncludeTrailingSpaces"; }
  if (e->testFlag (Qt::TextHideMnemonic)) { if (!l.empty ()) l += "|"; l += "TextHideMnemonic"; }
  if (e->testFlag (Qt::TextJustificationForced)) { if (!l.empty ()) l += "|"; l += "TextJustificationForced"; }
  if (e->testFlag (Qt::TextForceLeftToRight)) { if (!l.empty ()) l += "|"; l += "TextForceLeftToRight"; }
  if (e->testFlag (Qt::TextForceRightToLeft)) { if (!l.empty ()) l += "|"; l += "TextForceRightToLeft"; }
  if (e->testFlag (Qt::TextLongestVariant)) { if (!l.empty ()) l += "|"; l += "TextLongestVariant"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_TextFlag_Enums (const Qt_TextFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_TextFlag_Enums (const Qt_TextFlag_Enums *e, const Qt_TextFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_TextFlag_Enums> decl_Qt_TextFlag_Enums ("Qt_QFlags_TextFlag",
  gsi::method_ext ("|", &qt_gsi::oropQt_TextFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_TextFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_TextFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TextFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TextFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_TextFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::TextFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_TextFlag_Enum> decl_Qt_TextFlag_Enum (decl_Qt_TextFlag_Enums, "Qt_TextFlag",
  qt_gsi::mkdefs_Qt_TextFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TextFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TextFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_TextFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_TextFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_TextFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::TextFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_TextFlag_Enum_in_parent (qt_gsi::mkdefs_Qt_TextFlag ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_TextFlag_Enum_as_child (decl_Qt_TextFlag_Enum, "TextFlag");

}


//  Implementation of the enum wrapper class for Qt::TextFormat
namespace qt_gsi
{

static Qt_TextFormat_Enum *c_1_Qt_TextFormat_Enum () { return new Qt_TextFormat_Enum (Qt::PlainText); }
static Qt_TextFormat_Enum *c_2_Qt_TextFormat_Enum () { return new Qt_TextFormat_Enum (Qt::RichText); }
static Qt_TextFormat_Enum *c_3_Qt_TextFormat_Enum () { return new Qt_TextFormat_Enum (Qt::AutoText); }
static Qt_TextFormat_Enum *c_4_Qt_TextFormat_Enum () { return new Qt_TextFormat_Enum (Qt::LogText); }

static gsi::Methods mkdefs_Qt_TextFormat () {
  return
    gsi::constant ("PlainText", &qt_gsi::c_1_Qt_TextFormat_Enum, "@brief Enum constant Qt::PlainText") +
    gsi::constant ("RichText", &qt_gsi::c_2_Qt_TextFormat_Enum, "@brief Enum constant Qt::RichText") +
    gsi::constant ("AutoText", &qt_gsi::c_3_Qt_TextFormat_Enum, "@brief Enum constant Qt::AutoText") +
    gsi::constant ("LogText", &qt_gsi::c_4_Qt_TextFormat_Enum, "@brief Enum constant Qt::LogText");
}

static std::string to_s_Qt_TextFormat_Enum (const Qt_TextFormat_Enum *e)
{
  if (e->value () == Qt::PlainText) { return tl::sprintf ("PlainText (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RichText) { return tl::sprintf ("RichText (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AutoText) { return tl::sprintf ("AutoText (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LogText) { return tl::sprintf ("LogText (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_TextFormat_Enum (const Qt_TextFormat_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_TextFormat_Enum *from_i_Qt_TextFormat_Enum (unsigned int i)
{
  return new Qt_TextFormat_Enum ((Qt::TextFormat) i);
}

static bool equalQt_TextFormat_Enum (const Qt_TextFormat_Enum *e, Qt_TextFormat_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_TextFormat_Enum (const Qt_TextFormat_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_TextFormat_Enums oropQt_TextFormat_Enums (const Qt_TextFormat_Enums *e, const Qt_TextFormat_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_TextFormat_Enums andopQt_TextFormat_Enums (const Qt_TextFormat_Enums *e, const Qt_TextFormat_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_TextFormat_Enums xoropQt_TextFormat_Enums (const Qt_TextFormat_Enums *e, const Qt_TextFormat_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_TextFormat_Enums (const Qt_TextFormat_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::PlainText)) { if (!l.empty ()) l += "|"; l += "PlainText"; }
  if (e->testFlag (Qt::RichText)) { if (!l.empty ()) l += "|"; l += "RichText"; }
  if (e->testFlag (Qt::AutoText)) { if (!l.empty ()) l += "|"; l += "AutoText"; }
  if (e->testFlag (Qt::LogText)) { if (!l.empty ()) l += "|"; l += "LogText"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_TextFormat_Enums (const Qt_TextFormat_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_TextFormat_Enums (const Qt_TextFormat_Enums *e, const Qt_TextFormat_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_TextFormat_Enums> decl_Qt_TextFormat_Enums ("Qt_QFlags_TextFormat",
  gsi::method_ext ("|", &qt_gsi::oropQt_TextFormat_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_TextFormat_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_TextFormat_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TextFormat_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TextFormat_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_TextFormat_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::TextFormat> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_TextFormat_Enum> decl_Qt_TextFormat_Enum (decl_Qt_TextFormat_Enums, "Qt_TextFormat",
  qt_gsi::mkdefs_Qt_TextFormat () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TextFormat_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TextFormat_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_TextFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_TextFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_TextFormat_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::TextFormat enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_TextFormat_Enum_in_parent (qt_gsi::mkdefs_Qt_TextFormat ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_TextFormat_Enum_as_child (decl_Qt_TextFormat_Enum, "TextFormat");

}


//  Implementation of the enum wrapper class for Qt::TextInteractionFlag
namespace qt_gsi
{

static Qt_TextInteractionFlag_Enum *c_1_Qt_TextInteractionFlag_Enum () { return new Qt_TextInteractionFlag_Enum (Qt::NoTextInteraction); }
static Qt_TextInteractionFlag_Enum *c_2_Qt_TextInteractionFlag_Enum () { return new Qt_TextInteractionFlag_Enum (Qt::TextSelectableByMouse); }
static Qt_TextInteractionFlag_Enum *c_3_Qt_TextInteractionFlag_Enum () { return new Qt_TextInteractionFlag_Enum (Qt::TextSelectableByKeyboard); }
static Qt_TextInteractionFlag_Enum *c_4_Qt_TextInteractionFlag_Enum () { return new Qt_TextInteractionFlag_Enum (Qt::LinksAccessibleByMouse); }
static Qt_TextInteractionFlag_Enum *c_5_Qt_TextInteractionFlag_Enum () { return new Qt_TextInteractionFlag_Enum (Qt::LinksAccessibleByKeyboard); }
static Qt_TextInteractionFlag_Enum *c_6_Qt_TextInteractionFlag_Enum () { return new Qt_TextInteractionFlag_Enum (Qt::TextEditable); }
static Qt_TextInteractionFlag_Enum *c_7_Qt_TextInteractionFlag_Enum () { return new Qt_TextInteractionFlag_Enum (Qt::TextEditorInteraction); }
static Qt_TextInteractionFlag_Enum *c_8_Qt_TextInteractionFlag_Enum () { return new Qt_TextInteractionFlag_Enum (Qt::TextBrowserInteraction); }

static gsi::Methods mkdefs_Qt_TextInteractionFlag () {
  return
    gsi::constant ("NoTextInteraction", &qt_gsi::c_1_Qt_TextInteractionFlag_Enum, "@brief Enum constant Qt::NoTextInteraction") +
    gsi::constant ("TextSelectableByMouse", &qt_gsi::c_2_Qt_TextInteractionFlag_Enum, "@brief Enum constant Qt::TextSelectableByMouse") +
    gsi::constant ("TextSelectableByKeyboard", &qt_gsi::c_3_Qt_TextInteractionFlag_Enum, "@brief Enum constant Qt::TextSelectableByKeyboard") +
    gsi::constant ("LinksAccessibleByMouse", &qt_gsi::c_4_Qt_TextInteractionFlag_Enum, "@brief Enum constant Qt::LinksAccessibleByMouse") +
    gsi::constant ("LinksAccessibleByKeyboard", &qt_gsi::c_5_Qt_TextInteractionFlag_Enum, "@brief Enum constant Qt::LinksAccessibleByKeyboard") +
    gsi::constant ("TextEditable", &qt_gsi::c_6_Qt_TextInteractionFlag_Enum, "@brief Enum constant Qt::TextEditable") +
    gsi::constant ("TextEditorInteraction", &qt_gsi::c_7_Qt_TextInteractionFlag_Enum, "@brief Enum constant Qt::TextEditorInteraction") +
    gsi::constant ("TextBrowserInteraction", &qt_gsi::c_8_Qt_TextInteractionFlag_Enum, "@brief Enum constant Qt::TextBrowserInteraction");
}

static std::string to_s_Qt_TextInteractionFlag_Enum (const Qt_TextInteractionFlag_Enum *e)
{
  if (e->value () == Qt::NoTextInteraction) { return tl::sprintf ("NoTextInteraction (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextSelectableByMouse) { return tl::sprintf ("TextSelectableByMouse (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextSelectableByKeyboard) { return tl::sprintf ("TextSelectableByKeyboard (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LinksAccessibleByMouse) { return tl::sprintf ("LinksAccessibleByMouse (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LinksAccessibleByKeyboard) { return tl::sprintf ("LinksAccessibleByKeyboard (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextEditable) { return tl::sprintf ("TextEditable (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextEditorInteraction) { return tl::sprintf ("TextEditorInteraction (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TextBrowserInteraction) { return tl::sprintf ("TextBrowserInteraction (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_TextInteractionFlag_Enum (const Qt_TextInteractionFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_TextInteractionFlag_Enum *from_i_Qt_TextInteractionFlag_Enum (unsigned int i)
{
  return new Qt_TextInteractionFlag_Enum ((Qt::TextInteractionFlag) i);
}

static bool equalQt_TextInteractionFlag_Enum (const Qt_TextInteractionFlag_Enum *e, Qt_TextInteractionFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_TextInteractionFlag_Enum (const Qt_TextInteractionFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_TextInteractionFlag_Enums oropQt_TextInteractionFlag_Enums (const Qt_TextInteractionFlag_Enums *e, const Qt_TextInteractionFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_TextInteractionFlag_Enums andopQt_TextInteractionFlag_Enums (const Qt_TextInteractionFlag_Enums *e, const Qt_TextInteractionFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_TextInteractionFlag_Enums xoropQt_TextInteractionFlag_Enums (const Qt_TextInteractionFlag_Enums *e, const Qt_TextInteractionFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_TextInteractionFlag_Enums (const Qt_TextInteractionFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoTextInteraction)) { if (!l.empty ()) l += "|"; l += "NoTextInteraction"; }
  if (e->testFlag (Qt::TextSelectableByMouse)) { if (!l.empty ()) l += "|"; l += "TextSelectableByMouse"; }
  if (e->testFlag (Qt::TextSelectableByKeyboard)) { if (!l.empty ()) l += "|"; l += "TextSelectableByKeyboard"; }
  if (e->testFlag (Qt::LinksAccessibleByMouse)) { if (!l.empty ()) l += "|"; l += "LinksAccessibleByMouse"; }
  if (e->testFlag (Qt::LinksAccessibleByKeyboard)) { if (!l.empty ()) l += "|"; l += "LinksAccessibleByKeyboard"; }
  if (e->testFlag (Qt::TextEditable)) { if (!l.empty ()) l += "|"; l += "TextEditable"; }
  if (e->testFlag (Qt::TextEditorInteraction)) { if (!l.empty ()) l += "|"; l += "TextEditorInteraction"; }
  if (e->testFlag (Qt::TextBrowserInteraction)) { if (!l.empty ()) l += "|"; l += "TextBrowserInteraction"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_TextInteractionFlag_Enums (const Qt_TextInteractionFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_TextInteractionFlag_Enums (const Qt_TextInteractionFlag_Enums *e, const Qt_TextInteractionFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_TextInteractionFlag_Enums> decl_Qt_TextInteractionFlag_Enums ("Qt_QFlags_TextInteractionFlag",
  gsi::method_ext ("|", &qt_gsi::oropQt_TextInteractionFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_TextInteractionFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_TextInteractionFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TextInteractionFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TextInteractionFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_TextInteractionFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::TextInteractionFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_TextInteractionFlag_Enum> decl_Qt_TextInteractionFlag_Enum (decl_Qt_TextInteractionFlag_Enums, "Qt_TextInteractionFlag",
  qt_gsi::mkdefs_Qt_TextInteractionFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TextInteractionFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TextInteractionFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_TextInteractionFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_TextInteractionFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_TextInteractionFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::TextInteractionFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_TextInteractionFlag_Enum_in_parent (qt_gsi::mkdefs_Qt_TextInteractionFlag ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_TextInteractionFlag_Enum_as_child (decl_Qt_TextInteractionFlag_Enum, "TextInteractionFlag");

}


//  Implementation of the enum wrapper class for Qt::TileRule
namespace qt_gsi
{

static Qt_TileRule_Enum *c_1_Qt_TileRule_Enum () { return new Qt_TileRule_Enum (Qt::StretchTile); }
static Qt_TileRule_Enum *c_2_Qt_TileRule_Enum () { return new Qt_TileRule_Enum (Qt::RepeatTile); }
static Qt_TileRule_Enum *c_3_Qt_TileRule_Enum () { return new Qt_TileRule_Enum (Qt::RoundTile); }

static gsi::Methods mkdefs_Qt_TileRule () {
  return
    gsi::constant ("StretchTile", &qt_gsi::c_1_Qt_TileRule_Enum, "@brief Enum constant Qt::StretchTile") +
    gsi::constant ("RepeatTile", &qt_gsi::c_2_Qt_TileRule_Enum, "@brief Enum constant Qt::RepeatTile") +
    gsi::constant ("RoundTile", &qt_gsi::c_3_Qt_TileRule_Enum, "@brief Enum constant Qt::RoundTile");
}

static std::string to_s_Qt_TileRule_Enum (const Qt_TileRule_Enum *e)
{
  if (e->value () == Qt::StretchTile) { return tl::sprintf ("StretchTile (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RepeatTile) { return tl::sprintf ("RepeatTile (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RoundTile) { return tl::sprintf ("RoundTile (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_TileRule_Enum (const Qt_TileRule_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_TileRule_Enum *from_i_Qt_TileRule_Enum (unsigned int i)
{
  return new Qt_TileRule_Enum ((Qt::TileRule) i);
}

static bool equalQt_TileRule_Enum (const Qt_TileRule_Enum *e, Qt_TileRule_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_TileRule_Enum (const Qt_TileRule_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_TileRule_Enums oropQt_TileRule_Enums (const Qt_TileRule_Enums *e, const Qt_TileRule_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_TileRule_Enums andopQt_TileRule_Enums (const Qt_TileRule_Enums *e, const Qt_TileRule_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_TileRule_Enums xoropQt_TileRule_Enums (const Qt_TileRule_Enums *e, const Qt_TileRule_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_TileRule_Enums (const Qt_TileRule_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::StretchTile)) { if (!l.empty ()) l += "|"; l += "StretchTile"; }
  if (e->testFlag (Qt::RepeatTile)) { if (!l.empty ()) l += "|"; l += "RepeatTile"; }
  if (e->testFlag (Qt::RoundTile)) { if (!l.empty ()) l += "|"; l += "RoundTile"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_TileRule_Enums (const Qt_TileRule_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_TileRule_Enums (const Qt_TileRule_Enums *e, const Qt_TileRule_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_TileRule_Enums> decl_Qt_TileRule_Enums ("Qt_QFlags_TileRule",
  gsi::method_ext ("|", &qt_gsi::oropQt_TileRule_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_TileRule_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_TileRule_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TileRule_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TileRule_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_TileRule_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::TileRule> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_TileRule_Enum> decl_Qt_TileRule_Enum (decl_Qt_TileRule_Enums, "Qt_TileRule",
  qt_gsi::mkdefs_Qt_TileRule () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TileRule_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TileRule_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_TileRule_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_TileRule_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_TileRule_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::TileRule enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_TileRule_Enum_in_parent (qt_gsi::mkdefs_Qt_TileRule ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_TileRule_Enum_as_child (decl_Qt_TileRule_Enum, "TileRule");

}


//  Implementation of the enum wrapper class for Qt::TimeSpec
namespace qt_gsi
{

static Qt_TimeSpec_Enum *c_1_Qt_TimeSpec_Enum () { return new Qt_TimeSpec_Enum (Qt::LocalTime); }
static Qt_TimeSpec_Enum *c_2_Qt_TimeSpec_Enum () { return new Qt_TimeSpec_Enum (Qt::UTC); }
static Qt_TimeSpec_Enum *c_3_Qt_TimeSpec_Enum () { return new Qt_TimeSpec_Enum (Qt::OffsetFromUTC); }

static gsi::Methods mkdefs_Qt_TimeSpec () {
  return
    gsi::constant ("LocalTime", &qt_gsi::c_1_Qt_TimeSpec_Enum, "@brief Enum constant Qt::LocalTime") +
    gsi::constant ("UTC", &qt_gsi::c_2_Qt_TimeSpec_Enum, "@brief Enum constant Qt::UTC") +
    gsi::constant ("OffsetFromUTC", &qt_gsi::c_3_Qt_TimeSpec_Enum, "@brief Enum constant Qt::OffsetFromUTC");
}

static std::string to_s_Qt_TimeSpec_Enum (const Qt_TimeSpec_Enum *e)
{
  if (e->value () == Qt::LocalTime) { return tl::sprintf ("LocalTime (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UTC) { return tl::sprintf ("UTC (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::OffsetFromUTC) { return tl::sprintf ("OffsetFromUTC (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_TimeSpec_Enum (const Qt_TimeSpec_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_TimeSpec_Enum *from_i_Qt_TimeSpec_Enum (unsigned int i)
{
  return new Qt_TimeSpec_Enum ((Qt::TimeSpec) i);
}

static bool equalQt_TimeSpec_Enum (const Qt_TimeSpec_Enum *e, Qt_TimeSpec_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_TimeSpec_Enum (const Qt_TimeSpec_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_TimeSpec_Enums oropQt_TimeSpec_Enums (const Qt_TimeSpec_Enums *e, const Qt_TimeSpec_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_TimeSpec_Enums andopQt_TimeSpec_Enums (const Qt_TimeSpec_Enums *e, const Qt_TimeSpec_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_TimeSpec_Enums xoropQt_TimeSpec_Enums (const Qt_TimeSpec_Enums *e, const Qt_TimeSpec_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_TimeSpec_Enums (const Qt_TimeSpec_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::LocalTime)) { if (!l.empty ()) l += "|"; l += "LocalTime"; }
  if (e->testFlag (Qt::UTC)) { if (!l.empty ()) l += "|"; l += "UTC"; }
  if (e->testFlag (Qt::OffsetFromUTC)) { if (!l.empty ()) l += "|"; l += "OffsetFromUTC"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_TimeSpec_Enums (const Qt_TimeSpec_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_TimeSpec_Enums (const Qt_TimeSpec_Enums *e, const Qt_TimeSpec_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_TimeSpec_Enums> decl_Qt_TimeSpec_Enums ("Qt_QFlags_TimeSpec",
  gsi::method_ext ("|", &qt_gsi::oropQt_TimeSpec_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_TimeSpec_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_TimeSpec_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TimeSpec_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TimeSpec_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_TimeSpec_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::TimeSpec> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_TimeSpec_Enum> decl_Qt_TimeSpec_Enum (decl_Qt_TimeSpec_Enums, "Qt_TimeSpec",
  qt_gsi::mkdefs_Qt_TimeSpec () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TimeSpec_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TimeSpec_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_TimeSpec_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_TimeSpec_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_TimeSpec_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::TimeSpec enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_TimeSpec_Enum_in_parent (qt_gsi::mkdefs_Qt_TimeSpec ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_TimeSpec_Enum_as_child (decl_Qt_TimeSpec_Enum, "TimeSpec");

}


//  Implementation of the enum wrapper class for Qt::ToolBarArea
namespace qt_gsi
{

static Qt_ToolBarArea_Enum *c_1_Qt_ToolBarArea_Enum () { return new Qt_ToolBarArea_Enum (Qt::LeftToolBarArea); }
static Qt_ToolBarArea_Enum *c_2_Qt_ToolBarArea_Enum () { return new Qt_ToolBarArea_Enum (Qt::RightToolBarArea); }
static Qt_ToolBarArea_Enum *c_3_Qt_ToolBarArea_Enum () { return new Qt_ToolBarArea_Enum (Qt::TopToolBarArea); }
static Qt_ToolBarArea_Enum *c_4_Qt_ToolBarArea_Enum () { return new Qt_ToolBarArea_Enum (Qt::BottomToolBarArea); }
static Qt_ToolBarArea_Enum *c_5_Qt_ToolBarArea_Enum () { return new Qt_ToolBarArea_Enum (Qt::ToolBarArea_Mask); }
static Qt_ToolBarArea_Enum *c_6_Qt_ToolBarArea_Enum () { return new Qt_ToolBarArea_Enum (Qt::AllToolBarAreas); }
static Qt_ToolBarArea_Enum *c_7_Qt_ToolBarArea_Enum () { return new Qt_ToolBarArea_Enum (Qt::NoToolBarArea); }

static gsi::Methods mkdefs_Qt_ToolBarArea () {
  return
    gsi::constant ("LeftToolBarArea", &qt_gsi::c_1_Qt_ToolBarArea_Enum, "@brief Enum constant Qt::LeftToolBarArea") +
    gsi::constant ("RightToolBarArea", &qt_gsi::c_2_Qt_ToolBarArea_Enum, "@brief Enum constant Qt::RightToolBarArea") +
    gsi::constant ("TopToolBarArea", &qt_gsi::c_3_Qt_ToolBarArea_Enum, "@brief Enum constant Qt::TopToolBarArea") +
    gsi::constant ("BottomToolBarArea", &qt_gsi::c_4_Qt_ToolBarArea_Enum, "@brief Enum constant Qt::BottomToolBarArea") +
    gsi::constant ("ToolBarArea_Mask", &qt_gsi::c_5_Qt_ToolBarArea_Enum, "@brief Enum constant Qt::ToolBarArea_Mask") +
    gsi::constant ("AllToolBarAreas", &qt_gsi::c_6_Qt_ToolBarArea_Enum, "@brief Enum constant Qt::AllToolBarAreas") +
    gsi::constant ("NoToolBarArea", &qt_gsi::c_7_Qt_ToolBarArea_Enum, "@brief Enum constant Qt::NoToolBarArea");
}

static std::string to_s_Qt_ToolBarArea_Enum (const Qt_ToolBarArea_Enum *e)
{
  if (e->value () == Qt::LeftToolBarArea) { return tl::sprintf ("LeftToolBarArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RightToolBarArea) { return tl::sprintf ("RightToolBarArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TopToolBarArea) { return tl::sprintf ("TopToolBarArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BottomToolBarArea) { return tl::sprintf ("BottomToolBarArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ToolBarArea_Mask) { return tl::sprintf ("ToolBarArea_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::AllToolBarAreas) { return tl::sprintf ("AllToolBarAreas (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::NoToolBarArea) { return tl::sprintf ("NoToolBarArea (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ToolBarArea_Enum (const Qt_ToolBarArea_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ToolBarArea_Enum *from_i_Qt_ToolBarArea_Enum (unsigned int i)
{
  return new Qt_ToolBarArea_Enum ((Qt::ToolBarArea) i);
}

static bool equalQt_ToolBarArea_Enum (const Qt_ToolBarArea_Enum *e, Qt_ToolBarArea_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ToolBarArea_Enum (const Qt_ToolBarArea_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ToolBarArea_Enums oropQt_ToolBarArea_Enums (const Qt_ToolBarArea_Enums *e, const Qt_ToolBarArea_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ToolBarArea_Enums andopQt_ToolBarArea_Enums (const Qt_ToolBarArea_Enums *e, const Qt_ToolBarArea_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ToolBarArea_Enums xoropQt_ToolBarArea_Enums (const Qt_ToolBarArea_Enums *e, const Qt_ToolBarArea_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ToolBarArea_Enums (const Qt_ToolBarArea_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::LeftToolBarArea)) { if (!l.empty ()) l += "|"; l += "LeftToolBarArea"; }
  if (e->testFlag (Qt::RightToolBarArea)) { if (!l.empty ()) l += "|"; l += "RightToolBarArea"; }
  if (e->testFlag (Qt::TopToolBarArea)) { if (!l.empty ()) l += "|"; l += "TopToolBarArea"; }
  if (e->testFlag (Qt::BottomToolBarArea)) { if (!l.empty ()) l += "|"; l += "BottomToolBarArea"; }
  if (e->testFlag (Qt::ToolBarArea_Mask)) { if (!l.empty ()) l += "|"; l += "ToolBarArea_Mask"; }
  if (e->testFlag (Qt::AllToolBarAreas)) { if (!l.empty ()) l += "|"; l += "AllToolBarAreas"; }
  if (e->testFlag (Qt::NoToolBarArea)) { if (!l.empty ()) l += "|"; l += "NoToolBarArea"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ToolBarArea_Enums (const Qt_ToolBarArea_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ToolBarArea_Enums (const Qt_ToolBarArea_Enums *e, const Qt_ToolBarArea_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ToolBarArea_Enums> decl_Qt_ToolBarArea_Enums ("Qt_QFlags_ToolBarArea",
  gsi::method_ext ("|", &qt_gsi::oropQt_ToolBarArea_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ToolBarArea_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ToolBarArea_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ToolBarArea_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ToolBarArea_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ToolBarArea_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ToolBarArea> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ToolBarArea_Enum> decl_Qt_ToolBarArea_Enum (decl_Qt_ToolBarArea_Enums, "Qt_ToolBarArea",
  qt_gsi::mkdefs_Qt_ToolBarArea () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ToolBarArea_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ToolBarArea_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ToolBarArea_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ToolBarArea_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ToolBarArea_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ToolBarArea enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ToolBarArea_Enum_in_parent (qt_gsi::mkdefs_Qt_ToolBarArea ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ToolBarArea_Enum_as_child (decl_Qt_ToolBarArea_Enum, "ToolBarArea");

}


//  Implementation of the enum wrapper class for Qt::ToolBarAreaSizes
namespace qt_gsi
{

static Qt_ToolBarAreaSizes_Enum *c_1_Qt_ToolBarAreaSizes_Enum () { return new Qt_ToolBarAreaSizes_Enum (Qt::NToolBarAreas); }

static gsi::Methods mkdefs_Qt_ToolBarAreaSizes () {
  return
    gsi::constant ("NToolBarAreas", &qt_gsi::c_1_Qt_ToolBarAreaSizes_Enum, "@brief Enum constant Qt::NToolBarAreas");
}

static std::string to_s_Qt_ToolBarAreaSizes_Enum (const Qt_ToolBarAreaSizes_Enum *e)
{
  if (e->value () == Qt::NToolBarAreas) { return tl::sprintf ("NToolBarAreas (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ToolBarAreaSizes_Enum (const Qt_ToolBarAreaSizes_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ToolBarAreaSizes_Enum *from_i_Qt_ToolBarAreaSizes_Enum (unsigned int i)
{
  return new Qt_ToolBarAreaSizes_Enum ((Qt::ToolBarAreaSizes) i);
}

static bool equalQt_ToolBarAreaSizes_Enum (const Qt_ToolBarAreaSizes_Enum *e, Qt_ToolBarAreaSizes_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ToolBarAreaSizes_Enum (const Qt_ToolBarAreaSizes_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ToolBarAreaSizes_Enums oropQt_ToolBarAreaSizes_Enums (const Qt_ToolBarAreaSizes_Enums *e, const Qt_ToolBarAreaSizes_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ToolBarAreaSizes_Enums andopQt_ToolBarAreaSizes_Enums (const Qt_ToolBarAreaSizes_Enums *e, const Qt_ToolBarAreaSizes_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ToolBarAreaSizes_Enums xoropQt_ToolBarAreaSizes_Enums (const Qt_ToolBarAreaSizes_Enums *e, const Qt_ToolBarAreaSizes_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ToolBarAreaSizes_Enums (const Qt_ToolBarAreaSizes_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NToolBarAreas)) { if (!l.empty ()) l += "|"; l += "NToolBarAreas"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ToolBarAreaSizes_Enums (const Qt_ToolBarAreaSizes_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ToolBarAreaSizes_Enums (const Qt_ToolBarAreaSizes_Enums *e, const Qt_ToolBarAreaSizes_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ToolBarAreaSizes_Enums> decl_Qt_ToolBarAreaSizes_Enums ("Qt_QFlags_ToolBarAreaSizes",
  gsi::method_ext ("|", &qt_gsi::oropQt_ToolBarAreaSizes_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ToolBarAreaSizes_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ToolBarAreaSizes_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ToolBarAreaSizes_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ToolBarAreaSizes_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ToolBarAreaSizes_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ToolBarAreaSizes> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ToolBarAreaSizes_Enum> decl_Qt_ToolBarAreaSizes_Enum (decl_Qt_ToolBarAreaSizes_Enums, "Qt_ToolBarAreaSizes",
  qt_gsi::mkdefs_Qt_ToolBarAreaSizes () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ToolBarAreaSizes_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ToolBarAreaSizes_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ToolBarAreaSizes_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ToolBarAreaSizes_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ToolBarAreaSizes_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ToolBarAreaSizes enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ToolBarAreaSizes_Enum_in_parent (qt_gsi::mkdefs_Qt_ToolBarAreaSizes ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ToolBarAreaSizes_Enum_as_child (decl_Qt_ToolBarAreaSizes_Enum, "ToolBarAreaSizes");

}


//  Implementation of the enum wrapper class for Qt::ToolButtonStyle
namespace qt_gsi
{

static Qt_ToolButtonStyle_Enum *c_1_Qt_ToolButtonStyle_Enum () { return new Qt_ToolButtonStyle_Enum (Qt::ToolButtonIconOnly); }
static Qt_ToolButtonStyle_Enum *c_2_Qt_ToolButtonStyle_Enum () { return new Qt_ToolButtonStyle_Enum (Qt::ToolButtonTextOnly); }
static Qt_ToolButtonStyle_Enum *c_3_Qt_ToolButtonStyle_Enum () { return new Qt_ToolButtonStyle_Enum (Qt::ToolButtonTextBesideIcon); }
static Qt_ToolButtonStyle_Enum *c_4_Qt_ToolButtonStyle_Enum () { return new Qt_ToolButtonStyle_Enum (Qt::ToolButtonTextUnderIcon); }
static Qt_ToolButtonStyle_Enum *c_5_Qt_ToolButtonStyle_Enum () { return new Qt_ToolButtonStyle_Enum (Qt::ToolButtonFollowStyle); }

static gsi::Methods mkdefs_Qt_ToolButtonStyle () {
  return
    gsi::constant ("ToolButtonIconOnly", &qt_gsi::c_1_Qt_ToolButtonStyle_Enum, "@brief Enum constant Qt::ToolButtonIconOnly") +
    gsi::constant ("ToolButtonTextOnly", &qt_gsi::c_2_Qt_ToolButtonStyle_Enum, "@brief Enum constant Qt::ToolButtonTextOnly") +
    gsi::constant ("ToolButtonTextBesideIcon", &qt_gsi::c_3_Qt_ToolButtonStyle_Enum, "@brief Enum constant Qt::ToolButtonTextBesideIcon") +
    gsi::constant ("ToolButtonTextUnderIcon", &qt_gsi::c_4_Qt_ToolButtonStyle_Enum, "@brief Enum constant Qt::ToolButtonTextUnderIcon") +
    gsi::constant ("ToolButtonFollowStyle", &qt_gsi::c_5_Qt_ToolButtonStyle_Enum, "@brief Enum constant Qt::ToolButtonFollowStyle");
}

static std::string to_s_Qt_ToolButtonStyle_Enum (const Qt_ToolButtonStyle_Enum *e)
{
  if (e->value () == Qt::ToolButtonIconOnly) { return tl::sprintf ("ToolButtonIconOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ToolButtonTextOnly) { return tl::sprintf ("ToolButtonTextOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ToolButtonTextBesideIcon) { return tl::sprintf ("ToolButtonTextBesideIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ToolButtonTextUnderIcon) { return tl::sprintf ("ToolButtonTextUnderIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ToolButtonFollowStyle) { return tl::sprintf ("ToolButtonFollowStyle (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_ToolButtonStyle_Enum (const Qt_ToolButtonStyle_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_ToolButtonStyle_Enum *from_i_Qt_ToolButtonStyle_Enum (unsigned int i)
{
  return new Qt_ToolButtonStyle_Enum ((Qt::ToolButtonStyle) i);
}

static bool equalQt_ToolButtonStyle_Enum (const Qt_ToolButtonStyle_Enum *e, Qt_ToolButtonStyle_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_ToolButtonStyle_Enum (const Qt_ToolButtonStyle_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_ToolButtonStyle_Enums oropQt_ToolButtonStyle_Enums (const Qt_ToolButtonStyle_Enums *e, const Qt_ToolButtonStyle_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_ToolButtonStyle_Enums andopQt_ToolButtonStyle_Enums (const Qt_ToolButtonStyle_Enums *e, const Qt_ToolButtonStyle_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_ToolButtonStyle_Enums xoropQt_ToolButtonStyle_Enums (const Qt_ToolButtonStyle_Enums *e, const Qt_ToolButtonStyle_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_ToolButtonStyle_Enums (const Qt_ToolButtonStyle_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::ToolButtonIconOnly)) { if (!l.empty ()) l += "|"; l += "ToolButtonIconOnly"; }
  if (e->testFlag (Qt::ToolButtonTextOnly)) { if (!l.empty ()) l += "|"; l += "ToolButtonTextOnly"; }
  if (e->testFlag (Qt::ToolButtonTextBesideIcon)) { if (!l.empty ()) l += "|"; l += "ToolButtonTextBesideIcon"; }
  if (e->testFlag (Qt::ToolButtonTextUnderIcon)) { if (!l.empty ()) l += "|"; l += "ToolButtonTextUnderIcon"; }
  if (e->testFlag (Qt::ToolButtonFollowStyle)) { if (!l.empty ()) l += "|"; l += "ToolButtonFollowStyle"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_ToolButtonStyle_Enums (const Qt_ToolButtonStyle_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_ToolButtonStyle_Enums (const Qt_ToolButtonStyle_Enums *e, const Qt_ToolButtonStyle_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_ToolButtonStyle_Enums> decl_Qt_ToolButtonStyle_Enums ("Qt_QFlags_ToolButtonStyle",
  gsi::method_ext ("|", &qt_gsi::oropQt_ToolButtonStyle_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_ToolButtonStyle_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_ToolButtonStyle_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ToolButtonStyle_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ToolButtonStyle_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_ToolButtonStyle_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::ToolButtonStyle> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_ToolButtonStyle_Enum> decl_Qt_ToolButtonStyle_Enum (decl_Qt_ToolButtonStyle_Enums, "Qt_ToolButtonStyle",
  qt_gsi::mkdefs_Qt_ToolButtonStyle () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_ToolButtonStyle_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_ToolButtonStyle_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_ToolButtonStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_ToolButtonStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_ToolButtonStyle_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::ToolButtonStyle enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ToolButtonStyle_Enum_in_parent (qt_gsi::mkdefs_Qt_ToolButtonStyle ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ToolButtonStyle_Enum_as_child (decl_Qt_ToolButtonStyle_Enum, "ToolButtonStyle");

}


//  Implementation of the enum wrapper class for Qt::TouchPointState
namespace qt_gsi
{

static Qt_TouchPointState_Enum *c_1_Qt_TouchPointState_Enum () { return new Qt_TouchPointState_Enum (Qt::TouchPointPressed); }
static Qt_TouchPointState_Enum *c_2_Qt_TouchPointState_Enum () { return new Qt_TouchPointState_Enum (Qt::TouchPointMoved); }
static Qt_TouchPointState_Enum *c_3_Qt_TouchPointState_Enum () { return new Qt_TouchPointState_Enum (Qt::TouchPointStationary); }
static Qt_TouchPointState_Enum *c_4_Qt_TouchPointState_Enum () { return new Qt_TouchPointState_Enum (Qt::TouchPointReleased); }
static Qt_TouchPointState_Enum *c_5_Qt_TouchPointState_Enum () { return new Qt_TouchPointState_Enum (Qt::TouchPointStateMask); }
static Qt_TouchPointState_Enum *c_6_Qt_TouchPointState_Enum () { return new Qt_TouchPointState_Enum (Qt::TouchPointPrimary); }

static gsi::Methods mkdefs_Qt_TouchPointState () {
  return
    gsi::constant ("TouchPointPressed", &qt_gsi::c_1_Qt_TouchPointState_Enum, "@brief Enum constant Qt::TouchPointPressed") +
    gsi::constant ("TouchPointMoved", &qt_gsi::c_2_Qt_TouchPointState_Enum, "@brief Enum constant Qt::TouchPointMoved") +
    gsi::constant ("TouchPointStationary", &qt_gsi::c_3_Qt_TouchPointState_Enum, "@brief Enum constant Qt::TouchPointStationary") +
    gsi::constant ("TouchPointReleased", &qt_gsi::c_4_Qt_TouchPointState_Enum, "@brief Enum constant Qt::TouchPointReleased") +
    gsi::constant ("TouchPointStateMask", &qt_gsi::c_5_Qt_TouchPointState_Enum, "@brief Enum constant Qt::TouchPointStateMask") +
    gsi::constant ("TouchPointPrimary", &qt_gsi::c_6_Qt_TouchPointState_Enum, "@brief Enum constant Qt::TouchPointPrimary");
}

static std::string to_s_Qt_TouchPointState_Enum (const Qt_TouchPointState_Enum *e)
{
  if (e->value () == Qt::TouchPointPressed) { return tl::sprintf ("TouchPointPressed (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TouchPointMoved) { return tl::sprintf ("TouchPointMoved (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TouchPointStationary) { return tl::sprintf ("TouchPointStationary (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TouchPointReleased) { return tl::sprintf ("TouchPointReleased (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TouchPointStateMask) { return tl::sprintf ("TouchPointStateMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TouchPointPrimary) { return tl::sprintf ("TouchPointPrimary (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_TouchPointState_Enum (const Qt_TouchPointState_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_TouchPointState_Enum *from_i_Qt_TouchPointState_Enum (unsigned int i)
{
  return new Qt_TouchPointState_Enum ((Qt::TouchPointState) i);
}

static bool equalQt_TouchPointState_Enum (const Qt_TouchPointState_Enum *e, Qt_TouchPointState_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_TouchPointState_Enum (const Qt_TouchPointState_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_TouchPointState_Enums oropQt_TouchPointState_Enums (const Qt_TouchPointState_Enums *e, const Qt_TouchPointState_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_TouchPointState_Enums andopQt_TouchPointState_Enums (const Qt_TouchPointState_Enums *e, const Qt_TouchPointState_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_TouchPointState_Enums xoropQt_TouchPointState_Enums (const Qt_TouchPointState_Enums *e, const Qt_TouchPointState_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_TouchPointState_Enums (const Qt_TouchPointState_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::TouchPointPressed)) { if (!l.empty ()) l += "|"; l += "TouchPointPressed"; }
  if (e->testFlag (Qt::TouchPointMoved)) { if (!l.empty ()) l += "|"; l += "TouchPointMoved"; }
  if (e->testFlag (Qt::TouchPointStationary)) { if (!l.empty ()) l += "|"; l += "TouchPointStationary"; }
  if (e->testFlag (Qt::TouchPointReleased)) { if (!l.empty ()) l += "|"; l += "TouchPointReleased"; }
  if (e->testFlag (Qt::TouchPointStateMask)) { if (!l.empty ()) l += "|"; l += "TouchPointStateMask"; }
  if (e->testFlag (Qt::TouchPointPrimary)) { if (!l.empty ()) l += "|"; l += "TouchPointPrimary"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_TouchPointState_Enums (const Qt_TouchPointState_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_TouchPointState_Enums (const Qt_TouchPointState_Enums *e, const Qt_TouchPointState_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_TouchPointState_Enums> decl_Qt_TouchPointState_Enums ("Qt_QFlags_TouchPointState",
  gsi::method_ext ("|", &qt_gsi::oropQt_TouchPointState_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_TouchPointState_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_TouchPointState_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TouchPointState_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TouchPointState_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_TouchPointState_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::TouchPointState> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_TouchPointState_Enum> decl_Qt_TouchPointState_Enum (decl_Qt_TouchPointState_Enums, "Qt_TouchPointState",
  qt_gsi::mkdefs_Qt_TouchPointState () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TouchPointState_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TouchPointState_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_TouchPointState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_TouchPointState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_TouchPointState_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::TouchPointState enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_TouchPointState_Enum_in_parent (qt_gsi::mkdefs_Qt_TouchPointState ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_TouchPointState_Enum_as_child (decl_Qt_TouchPointState_Enum, "TouchPointState");

}


//  Implementation of the enum wrapper class for Qt::TransformationMode
namespace qt_gsi
{

static Qt_TransformationMode_Enum *c_1_Qt_TransformationMode_Enum () { return new Qt_TransformationMode_Enum (Qt::FastTransformation); }
static Qt_TransformationMode_Enum *c_2_Qt_TransformationMode_Enum () { return new Qt_TransformationMode_Enum (Qt::SmoothTransformation); }

static gsi::Methods mkdefs_Qt_TransformationMode () {
  return
    gsi::constant ("FastTransformation", &qt_gsi::c_1_Qt_TransformationMode_Enum, "@brief Enum constant Qt::FastTransformation") +
    gsi::constant ("SmoothTransformation", &qt_gsi::c_2_Qt_TransformationMode_Enum, "@brief Enum constant Qt::SmoothTransformation");
}

static std::string to_s_Qt_TransformationMode_Enum (const Qt_TransformationMode_Enum *e)
{
  if (e->value () == Qt::FastTransformation) { return tl::sprintf ("FastTransformation (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SmoothTransformation) { return tl::sprintf ("SmoothTransformation (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_TransformationMode_Enum (const Qt_TransformationMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_TransformationMode_Enum *from_i_Qt_TransformationMode_Enum (unsigned int i)
{
  return new Qt_TransformationMode_Enum ((Qt::TransformationMode) i);
}

static bool equalQt_TransformationMode_Enum (const Qt_TransformationMode_Enum *e, Qt_TransformationMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_TransformationMode_Enum (const Qt_TransformationMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_TransformationMode_Enums oropQt_TransformationMode_Enums (const Qt_TransformationMode_Enums *e, const Qt_TransformationMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_TransformationMode_Enums andopQt_TransformationMode_Enums (const Qt_TransformationMode_Enums *e, const Qt_TransformationMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_TransformationMode_Enums xoropQt_TransformationMode_Enums (const Qt_TransformationMode_Enums *e, const Qt_TransformationMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_TransformationMode_Enums (const Qt_TransformationMode_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::FastTransformation)) { if (!l.empty ()) l += "|"; l += "FastTransformation"; }
  if (e->testFlag (Qt::SmoothTransformation)) { if (!l.empty ()) l += "|"; l += "SmoothTransformation"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_TransformationMode_Enums (const Qt_TransformationMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_TransformationMode_Enums (const Qt_TransformationMode_Enums *e, const Qt_TransformationMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_TransformationMode_Enums> decl_Qt_TransformationMode_Enums ("Qt_QFlags_TransformationMode",
  gsi::method_ext ("|", &qt_gsi::oropQt_TransformationMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_TransformationMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_TransformationMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TransformationMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TransformationMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_TransformationMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::TransformationMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_TransformationMode_Enum> decl_Qt_TransformationMode_Enum (decl_Qt_TransformationMode_Enums, "Qt_TransformationMode",
  qt_gsi::mkdefs_Qt_TransformationMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_TransformationMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_TransformationMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_TransformationMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_TransformationMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_TransformationMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::TransformationMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_TransformationMode_Enum_in_parent (qt_gsi::mkdefs_Qt_TransformationMode ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_TransformationMode_Enum_as_child (decl_Qt_TransformationMode_Enum, "TransformationMode");

}


//  Implementation of the enum wrapper class for Qt::UIEffect
namespace qt_gsi
{

static Qt_UIEffect_Enum *c_1_Qt_UIEffect_Enum () { return new Qt_UIEffect_Enum (Qt::UI_General); }
static Qt_UIEffect_Enum *c_2_Qt_UIEffect_Enum () { return new Qt_UIEffect_Enum (Qt::UI_AnimateMenu); }
static Qt_UIEffect_Enum *c_3_Qt_UIEffect_Enum () { return new Qt_UIEffect_Enum (Qt::UI_FadeMenu); }
static Qt_UIEffect_Enum *c_4_Qt_UIEffect_Enum () { return new Qt_UIEffect_Enum (Qt::UI_AnimateCombo); }
static Qt_UIEffect_Enum *c_5_Qt_UIEffect_Enum () { return new Qt_UIEffect_Enum (Qt::UI_AnimateTooltip); }
static Qt_UIEffect_Enum *c_6_Qt_UIEffect_Enum () { return new Qt_UIEffect_Enum (Qt::UI_FadeTooltip); }
static Qt_UIEffect_Enum *c_7_Qt_UIEffect_Enum () { return new Qt_UIEffect_Enum (Qt::UI_AnimateToolBox); }

static gsi::Methods mkdefs_Qt_UIEffect () {
  return
    gsi::constant ("UI_General", &qt_gsi::c_1_Qt_UIEffect_Enum, "@brief Enum constant Qt::UI_General") +
    gsi::constant ("UI_AnimateMenu", &qt_gsi::c_2_Qt_UIEffect_Enum, "@brief Enum constant Qt::UI_AnimateMenu") +
    gsi::constant ("UI_FadeMenu", &qt_gsi::c_3_Qt_UIEffect_Enum, "@brief Enum constant Qt::UI_FadeMenu") +
    gsi::constant ("UI_AnimateCombo", &qt_gsi::c_4_Qt_UIEffect_Enum, "@brief Enum constant Qt::UI_AnimateCombo") +
    gsi::constant ("UI_AnimateTooltip", &qt_gsi::c_5_Qt_UIEffect_Enum, "@brief Enum constant Qt::UI_AnimateTooltip") +
    gsi::constant ("UI_FadeTooltip", &qt_gsi::c_6_Qt_UIEffect_Enum, "@brief Enum constant Qt::UI_FadeTooltip") +
    gsi::constant ("UI_AnimateToolBox", &qt_gsi::c_7_Qt_UIEffect_Enum, "@brief Enum constant Qt::UI_AnimateToolBox");
}

static std::string to_s_Qt_UIEffect_Enum (const Qt_UIEffect_Enum *e)
{
  if (e->value () == Qt::UI_General) { return tl::sprintf ("UI_General (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UI_AnimateMenu) { return tl::sprintf ("UI_AnimateMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UI_FadeMenu) { return tl::sprintf ("UI_FadeMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UI_AnimateCombo) { return tl::sprintf ("UI_AnimateCombo (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UI_AnimateTooltip) { return tl::sprintf ("UI_AnimateTooltip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UI_FadeTooltip) { return tl::sprintf ("UI_FadeTooltip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::UI_AnimateToolBox) { return tl::sprintf ("UI_AnimateToolBox (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_UIEffect_Enum (const Qt_UIEffect_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_UIEffect_Enum *from_i_Qt_UIEffect_Enum (unsigned int i)
{
  return new Qt_UIEffect_Enum ((Qt::UIEffect) i);
}

static bool equalQt_UIEffect_Enum (const Qt_UIEffect_Enum *e, Qt_UIEffect_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_UIEffect_Enum (const Qt_UIEffect_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_UIEffect_Enums oropQt_UIEffect_Enums (const Qt_UIEffect_Enums *e, const Qt_UIEffect_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_UIEffect_Enums andopQt_UIEffect_Enums (const Qt_UIEffect_Enums *e, const Qt_UIEffect_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_UIEffect_Enums xoropQt_UIEffect_Enums (const Qt_UIEffect_Enums *e, const Qt_UIEffect_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_UIEffect_Enums (const Qt_UIEffect_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::UI_General)) { if (!l.empty ()) l += "|"; l += "UI_General"; }
  if (e->testFlag (Qt::UI_AnimateMenu)) { if (!l.empty ()) l += "|"; l += "UI_AnimateMenu"; }
  if (e->testFlag (Qt::UI_FadeMenu)) { if (!l.empty ()) l += "|"; l += "UI_FadeMenu"; }
  if (e->testFlag (Qt::UI_AnimateCombo)) { if (!l.empty ()) l += "|"; l += "UI_AnimateCombo"; }
  if (e->testFlag (Qt::UI_AnimateTooltip)) { if (!l.empty ()) l += "|"; l += "UI_AnimateTooltip"; }
  if (e->testFlag (Qt::UI_FadeTooltip)) { if (!l.empty ()) l += "|"; l += "UI_FadeTooltip"; }
  if (e->testFlag (Qt::UI_AnimateToolBox)) { if (!l.empty ()) l += "|"; l += "UI_AnimateToolBox"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_UIEffect_Enums (const Qt_UIEffect_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_UIEffect_Enums (const Qt_UIEffect_Enums *e, const Qt_UIEffect_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_UIEffect_Enums> decl_Qt_UIEffect_Enums ("Qt_QFlags_UIEffect",
  gsi::method_ext ("|", &qt_gsi::oropQt_UIEffect_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_UIEffect_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_UIEffect_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_UIEffect_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_UIEffect_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_UIEffect_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::UIEffect> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_UIEffect_Enum> decl_Qt_UIEffect_Enum (decl_Qt_UIEffect_Enums, "Qt_UIEffect",
  qt_gsi::mkdefs_Qt_UIEffect () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_UIEffect_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_UIEffect_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_UIEffect_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_UIEffect_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_UIEffect_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::UIEffect enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_UIEffect_Enum_in_parent (qt_gsi::mkdefs_Qt_UIEffect ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_UIEffect_Enum_as_child (decl_Qt_UIEffect_Enum, "UIEffect");

}


//  Implementation of the enum wrapper class for Qt::WhiteSpaceMode
namespace qt_gsi
{

static Qt_WhiteSpaceMode_Enum *c_1_Qt_WhiteSpaceMode_Enum () { return new Qt_WhiteSpaceMode_Enum (Qt::WhiteSpaceNormal); }
static Qt_WhiteSpaceMode_Enum *c_2_Qt_WhiteSpaceMode_Enum () { return new Qt_WhiteSpaceMode_Enum (Qt::WhiteSpacePre); }
static Qt_WhiteSpaceMode_Enum *c_3_Qt_WhiteSpaceMode_Enum () { return new Qt_WhiteSpaceMode_Enum (Qt::WhiteSpaceNoWrap); }
static Qt_WhiteSpaceMode_Enum *c_4_Qt_WhiteSpaceMode_Enum () { return new Qt_WhiteSpaceMode_Enum (Qt::WhiteSpaceModeUndefined); }

static gsi::Methods mkdefs_Qt_WhiteSpaceMode () {
  return
    gsi::constant ("WhiteSpaceNormal", &qt_gsi::c_1_Qt_WhiteSpaceMode_Enum, "@brief Enum constant Qt::WhiteSpaceNormal") +
    gsi::constant ("WhiteSpacePre", &qt_gsi::c_2_Qt_WhiteSpaceMode_Enum, "@brief Enum constant Qt::WhiteSpacePre") +
    gsi::constant ("WhiteSpaceNoWrap", &qt_gsi::c_3_Qt_WhiteSpaceMode_Enum, "@brief Enum constant Qt::WhiteSpaceNoWrap") +
    gsi::constant ("WhiteSpaceModeUndefined", &qt_gsi::c_4_Qt_WhiteSpaceMode_Enum, "@brief Enum constant Qt::WhiteSpaceModeUndefined");
}

static std::string to_s_Qt_WhiteSpaceMode_Enum (const Qt_WhiteSpaceMode_Enum *e)
{
  if (e->value () == Qt::WhiteSpaceNormal) { return tl::sprintf ("WhiteSpaceNormal (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WhiteSpacePre) { return tl::sprintf ("WhiteSpacePre (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WhiteSpaceNoWrap) { return tl::sprintf ("WhiteSpaceNoWrap (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WhiteSpaceModeUndefined) { return tl::sprintf ("WhiteSpaceModeUndefined (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_WhiteSpaceMode_Enum (const Qt_WhiteSpaceMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_WhiteSpaceMode_Enum *from_i_Qt_WhiteSpaceMode_Enum (unsigned int i)
{
  return new Qt_WhiteSpaceMode_Enum ((Qt::WhiteSpaceMode) i);
}

static bool equalQt_WhiteSpaceMode_Enum (const Qt_WhiteSpaceMode_Enum *e, Qt_WhiteSpaceMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_WhiteSpaceMode_Enum (const Qt_WhiteSpaceMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_WhiteSpaceMode_Enums oropQt_WhiteSpaceMode_Enums (const Qt_WhiteSpaceMode_Enums *e, const Qt_WhiteSpaceMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_WhiteSpaceMode_Enums andopQt_WhiteSpaceMode_Enums (const Qt_WhiteSpaceMode_Enums *e, const Qt_WhiteSpaceMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_WhiteSpaceMode_Enums xoropQt_WhiteSpaceMode_Enums (const Qt_WhiteSpaceMode_Enums *e, const Qt_WhiteSpaceMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_WhiteSpaceMode_Enums (const Qt_WhiteSpaceMode_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::WhiteSpaceNormal)) { if (!l.empty ()) l += "|"; l += "WhiteSpaceNormal"; }
  if (e->testFlag (Qt::WhiteSpacePre)) { if (!l.empty ()) l += "|"; l += "WhiteSpacePre"; }
  if (e->testFlag (Qt::WhiteSpaceNoWrap)) { if (!l.empty ()) l += "|"; l += "WhiteSpaceNoWrap"; }
  if (e->testFlag (Qt::WhiteSpaceModeUndefined)) { if (!l.empty ()) l += "|"; l += "WhiteSpaceModeUndefined"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_WhiteSpaceMode_Enums (const Qt_WhiteSpaceMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_WhiteSpaceMode_Enums (const Qt_WhiteSpaceMode_Enums *e, const Qt_WhiteSpaceMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_WhiteSpaceMode_Enums> decl_Qt_WhiteSpaceMode_Enums ("Qt_QFlags_WhiteSpaceMode",
  gsi::method_ext ("|", &qt_gsi::oropQt_WhiteSpaceMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_WhiteSpaceMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_WhiteSpaceMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WhiteSpaceMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WhiteSpaceMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_WhiteSpaceMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::WhiteSpaceMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_WhiteSpaceMode_Enum> decl_Qt_WhiteSpaceMode_Enum (decl_Qt_WhiteSpaceMode_Enums, "Qt_WhiteSpaceMode",
  qt_gsi::mkdefs_Qt_WhiteSpaceMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WhiteSpaceMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WhiteSpaceMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_WhiteSpaceMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_WhiteSpaceMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_WhiteSpaceMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::WhiteSpaceMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_WhiteSpaceMode_Enum_in_parent (qt_gsi::mkdefs_Qt_WhiteSpaceMode ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_WhiteSpaceMode_Enum_as_child (decl_Qt_WhiteSpaceMode_Enum, "WhiteSpaceMode");

}


//  Implementation of the enum wrapper class for Qt::WidgetAttribute
namespace qt_gsi
{

static Qt_WidgetAttribute_Enum *c_1_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_Disabled); }
static Qt_WidgetAttribute_Enum *c_2_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_UnderMouse); }
static Qt_WidgetAttribute_Enum *c_3_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MouseTracking); }
static Qt_WidgetAttribute_Enum *c_4_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_ContentsPropagated); }
static Qt_WidgetAttribute_Enum *c_5_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_OpaquePaintEvent); }
static Qt_WidgetAttribute_Enum *c_6_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_NoBackground); }
static Qt_WidgetAttribute_Enum *c_7_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_StaticContents); }
static Qt_WidgetAttribute_Enum *c_8_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_LaidOut); }
static Qt_WidgetAttribute_Enum *c_9_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_PaintOnScreen); }
static Qt_WidgetAttribute_Enum *c_10_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_NoSystemBackground); }
static Qt_WidgetAttribute_Enum *c_11_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_UpdatesDisabled); }
static Qt_WidgetAttribute_Enum *c_12_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_Mapped); }
static Qt_WidgetAttribute_Enum *c_13_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacNoClickThrough); }
static Qt_WidgetAttribute_Enum *c_14_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_PaintOutsidePaintEvent); }
static Qt_WidgetAttribute_Enum *c_15_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_InputMethodEnabled); }
static Qt_WidgetAttribute_Enum *c_16_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_Visible); }
static Qt_WidgetAttribute_Enum *c_17_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_Hidden); }
static Qt_WidgetAttribute_Enum *c_18_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_ForceDisabled); }
static Qt_WidgetAttribute_Enum *c_19_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_KeyCompression); }
static Qt_WidgetAttribute_Enum *c_20_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_PendingMoveEvent); }
static Qt_WidgetAttribute_Enum *c_21_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_PendingResizeEvent); }
static Qt_WidgetAttribute_Enum *c_22_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_SetPalette); }
static Qt_WidgetAttribute_Enum *c_23_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_SetFont); }
static Qt_WidgetAttribute_Enum *c_24_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_SetCursor); }
static Qt_WidgetAttribute_Enum *c_25_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_NoChildEventsFromChildren); }
static Qt_WidgetAttribute_Enum *c_26_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WindowModified); }
static Qt_WidgetAttribute_Enum *c_27_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_Resized); }
static Qt_WidgetAttribute_Enum *c_28_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_Moved); }
static Qt_WidgetAttribute_Enum *c_29_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_PendingUpdate); }
static Qt_WidgetAttribute_Enum *c_30_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_InvalidSize); }
static Qt_WidgetAttribute_Enum *c_31_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacBrushedMetal); }
static Qt_WidgetAttribute_Enum *c_32_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacMetalStyle); }
static Qt_WidgetAttribute_Enum *c_33_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_CustomWhatsThis); }
static Qt_WidgetAttribute_Enum *c_34_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_LayoutOnEntireRect); }
static Qt_WidgetAttribute_Enum *c_35_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_OutsideWSRange); }
static Qt_WidgetAttribute_Enum *c_36_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_GrabbedShortcut); }
static Qt_WidgetAttribute_Enum *c_37_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_TransparentForMouseEvents); }
static Qt_WidgetAttribute_Enum *c_38_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_PaintUnclipped); }
static Qt_WidgetAttribute_Enum *c_39_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_SetWindowIcon); }
static Qt_WidgetAttribute_Enum *c_40_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_NoMouseReplay); }
static Qt_WidgetAttribute_Enum *c_41_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_DeleteOnClose); }
static Qt_WidgetAttribute_Enum *c_42_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_RightToLeft); }
static Qt_WidgetAttribute_Enum *c_43_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_SetLayoutDirection); }
static Qt_WidgetAttribute_Enum *c_44_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_NoChildEventsForParent); }
static Qt_WidgetAttribute_Enum *c_45_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_ForceUpdatesDisabled); }
static Qt_WidgetAttribute_Enum *c_46_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_Created); }
static Qt_WidgetAttribute_Enum *c_47_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_CompressKeys); }
static Qt_WidgetAttribute_Enum *c_48_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_InPaintEvent); }
static Qt_WidgetAttribute_Enum *c_49_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_Reparented); }
static Qt_WidgetAttribute_Enum *c_50_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_ConfigPending); }
static Qt_WidgetAttribute_Enum *c_51_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_Polished); }
static Qt_WidgetAttribute_Enum *c_52_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_DND); }
static Qt_WidgetAttribute_Enum *c_53_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_OwnSizePolicy); }
static Qt_WidgetAttribute_Enum *c_54_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_ExplicitShowHide); }
static Qt_WidgetAttribute_Enum *c_55_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_ShowModal); }
static Qt_WidgetAttribute_Enum *c_56_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MouseNoMask); }
static Qt_WidgetAttribute_Enum *c_57_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_GroupLeader); }
static Qt_WidgetAttribute_Enum *c_58_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_NoMousePropagation); }
static Qt_WidgetAttribute_Enum *c_59_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_Hover); }
static Qt_WidgetAttribute_Enum *c_60_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_InputMethodTransparent); }
static Qt_WidgetAttribute_Enum *c_61_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_QuitOnClose); }
static Qt_WidgetAttribute_Enum *c_62_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_KeyboardFocusChange); }
static Qt_WidgetAttribute_Enum *c_63_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_AcceptDrops); }
static Qt_WidgetAttribute_Enum *c_64_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_DropSiteRegistered); }
static Qt_WidgetAttribute_Enum *c_65_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_ForceAcceptDrops); }
static Qt_WidgetAttribute_Enum *c_66_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WindowPropagation); }
static Qt_WidgetAttribute_Enum *c_67_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_NoX11EventCompression); }
static Qt_WidgetAttribute_Enum *c_68_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_TintedBackground); }
static Qt_WidgetAttribute_Enum *c_69_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11OpenGLOverlay); }
static Qt_WidgetAttribute_Enum *c_70_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_AlwaysShowToolTips); }
static Qt_WidgetAttribute_Enum *c_71_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacOpaqueSizeGrip); }
static Qt_WidgetAttribute_Enum *c_72_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_SetStyle); }
static Qt_WidgetAttribute_Enum *c_73_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_SetLocale); }
static Qt_WidgetAttribute_Enum *c_74_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacShowFocusRect); }
static Qt_WidgetAttribute_Enum *c_75_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacNormalSize); }
static Qt_WidgetAttribute_Enum *c_76_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacSmallSize); }
static Qt_WidgetAttribute_Enum *c_77_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacMiniSize); }
static Qt_WidgetAttribute_Enum *c_78_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_LayoutUsesWidgetRect); }
static Qt_WidgetAttribute_Enum *c_79_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_StyledBackground); }
static Qt_WidgetAttribute_Enum *c_80_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MSWindowsUseDirect3D); }
static Qt_WidgetAttribute_Enum *c_81_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_CanHostQMdiSubWindowTitleBar); }
static Qt_WidgetAttribute_Enum *c_82_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacAlwaysShowToolWindow); }
static Qt_WidgetAttribute_Enum *c_83_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_StyleSheet); }
static Qt_WidgetAttribute_Enum *c_84_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_ShowWithoutActivating); }
static Qt_WidgetAttribute_Enum *c_85_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11BypassTransientForHint); }
static Qt_WidgetAttribute_Enum *c_86_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_NativeWindow); }
static Qt_WidgetAttribute_Enum *c_87_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_DontCreateNativeAncestors); }
static Qt_WidgetAttribute_Enum *c_88_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacVariableSize); }
static Qt_WidgetAttribute_Enum *c_89_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_DontShowOnScreen); }
static Qt_WidgetAttribute_Enum *c_90_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeDesktop); }
static Qt_WidgetAttribute_Enum *c_91_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeDock); }
static Qt_WidgetAttribute_Enum *c_92_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeToolBar); }
static Qt_WidgetAttribute_Enum *c_93_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeMenu); }
static Qt_WidgetAttribute_Enum *c_94_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeUtility); }
static Qt_WidgetAttribute_Enum *c_95_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeSplash); }
static Qt_WidgetAttribute_Enum *c_96_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeDialog); }
static Qt_WidgetAttribute_Enum *c_97_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeDropDownMenu); }
static Qt_WidgetAttribute_Enum *c_98_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypePopupMenu); }
static Qt_WidgetAttribute_Enum *c_99_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeToolTip); }
static Qt_WidgetAttribute_Enum *c_100_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeNotification); }
static Qt_WidgetAttribute_Enum *c_101_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeCombo); }
static Qt_WidgetAttribute_Enum *c_102_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_X11NetWmWindowTypeDND); }
static Qt_WidgetAttribute_Enum *c_103_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MacFrameworkScaled); }
static Qt_WidgetAttribute_Enum *c_104_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_SetWindowModality); }
static Qt_WidgetAttribute_Enum *c_105_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_WindowOpacitySet); }
static Qt_WidgetAttribute_Enum *c_106_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_TranslucentBackground); }
static Qt_WidgetAttribute_Enum *c_107_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_AcceptTouchEvents); }
static Qt_WidgetAttribute_Enum *c_108_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_WState_AcceptedTouchBeginEvent); }
static Qt_WidgetAttribute_Enum *c_109_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_TouchPadAcceptSingleTouchEvents); }
static Qt_WidgetAttribute_Enum *c_110_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MergeSoftkeys); }
static Qt_WidgetAttribute_Enum *c_111_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_MergeSoftkeysRecursively); }
static Qt_WidgetAttribute_Enum *c_112_Qt_WidgetAttribute_Enum () { return new Qt_WidgetAttribute_Enum (Qt::WA_AttributeCount); }

static gsi::Methods mkdefs_Qt_WidgetAttribute () {
  return
    gsi::constant ("WA_Disabled", &qt_gsi::c_1_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_Disabled") +
    gsi::constant ("WA_UnderMouse", &qt_gsi::c_2_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_UnderMouse") +
    gsi::constant ("WA_MouseTracking", &qt_gsi::c_3_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MouseTracking") +
    gsi::constant ("WA_ContentsPropagated", &qt_gsi::c_4_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_ContentsPropagated") +
    gsi::constant ("WA_OpaquePaintEvent", &qt_gsi::c_5_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_OpaquePaintEvent") +
    gsi::constant ("WA_NoBackground", &qt_gsi::c_6_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_NoBackground") +
    gsi::constant ("WA_StaticContents", &qt_gsi::c_7_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_StaticContents") +
    gsi::constant ("WA_LaidOut", &qt_gsi::c_8_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_LaidOut") +
    gsi::constant ("WA_PaintOnScreen", &qt_gsi::c_9_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_PaintOnScreen") +
    gsi::constant ("WA_NoSystemBackground", &qt_gsi::c_10_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_NoSystemBackground") +
    gsi::constant ("WA_UpdatesDisabled", &qt_gsi::c_11_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_UpdatesDisabled") +
    gsi::constant ("WA_Mapped", &qt_gsi::c_12_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_Mapped") +
    gsi::constant ("WA_MacNoClickThrough", &qt_gsi::c_13_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacNoClickThrough") +
    gsi::constant ("WA_PaintOutsidePaintEvent", &qt_gsi::c_14_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_PaintOutsidePaintEvent") +
    gsi::constant ("WA_InputMethodEnabled", &qt_gsi::c_15_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_InputMethodEnabled") +
    gsi::constant ("WA_WState_Visible", &qt_gsi::c_16_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_Visible") +
    gsi::constant ("WA_WState_Hidden", &qt_gsi::c_17_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_Hidden") +
    gsi::constant ("WA_ForceDisabled", &qt_gsi::c_18_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_ForceDisabled") +
    gsi::constant ("WA_KeyCompression", &qt_gsi::c_19_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_KeyCompression") +
    gsi::constant ("WA_PendingMoveEvent", &qt_gsi::c_20_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_PendingMoveEvent") +
    gsi::constant ("WA_PendingResizeEvent", &qt_gsi::c_21_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_PendingResizeEvent") +
    gsi::constant ("WA_SetPalette", &qt_gsi::c_22_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_SetPalette") +
    gsi::constant ("WA_SetFont", &qt_gsi::c_23_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_SetFont") +
    gsi::constant ("WA_SetCursor", &qt_gsi::c_24_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_SetCursor") +
    gsi::constant ("WA_NoChildEventsFromChildren", &qt_gsi::c_25_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_NoChildEventsFromChildren") +
    gsi::constant ("WA_WindowModified", &qt_gsi::c_26_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WindowModified") +
    gsi::constant ("WA_Resized", &qt_gsi::c_27_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_Resized") +
    gsi::constant ("WA_Moved", &qt_gsi::c_28_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_Moved") +
    gsi::constant ("WA_PendingUpdate", &qt_gsi::c_29_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_PendingUpdate") +
    gsi::constant ("WA_InvalidSize", &qt_gsi::c_30_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_InvalidSize") +
    gsi::constant ("WA_MacBrushedMetal", &qt_gsi::c_31_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacBrushedMetal") +
    gsi::constant ("WA_MacMetalStyle", &qt_gsi::c_32_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacMetalStyle") +
    gsi::constant ("WA_CustomWhatsThis", &qt_gsi::c_33_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_CustomWhatsThis") +
    gsi::constant ("WA_LayoutOnEntireRect", &qt_gsi::c_34_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_LayoutOnEntireRect") +
    gsi::constant ("WA_OutsideWSRange", &qt_gsi::c_35_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_OutsideWSRange") +
    gsi::constant ("WA_GrabbedShortcut", &qt_gsi::c_36_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_GrabbedShortcut") +
    gsi::constant ("WA_TransparentForMouseEvents", &qt_gsi::c_37_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_TransparentForMouseEvents") +
    gsi::constant ("WA_PaintUnclipped", &qt_gsi::c_38_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_PaintUnclipped") +
    gsi::constant ("WA_SetWindowIcon", &qt_gsi::c_39_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_SetWindowIcon") +
    gsi::constant ("WA_NoMouseReplay", &qt_gsi::c_40_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_NoMouseReplay") +
    gsi::constant ("WA_DeleteOnClose", &qt_gsi::c_41_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_DeleteOnClose") +
    gsi::constant ("WA_RightToLeft", &qt_gsi::c_42_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_RightToLeft") +
    gsi::constant ("WA_SetLayoutDirection", &qt_gsi::c_43_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_SetLayoutDirection") +
    gsi::constant ("WA_NoChildEventsForParent", &qt_gsi::c_44_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_NoChildEventsForParent") +
    gsi::constant ("WA_ForceUpdatesDisabled", &qt_gsi::c_45_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_ForceUpdatesDisabled") +
    gsi::constant ("WA_WState_Created", &qt_gsi::c_46_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_Created") +
    gsi::constant ("WA_WState_CompressKeys", &qt_gsi::c_47_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_CompressKeys") +
    gsi::constant ("WA_WState_InPaintEvent", &qt_gsi::c_48_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_InPaintEvent") +
    gsi::constant ("WA_WState_Reparented", &qt_gsi::c_49_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_Reparented") +
    gsi::constant ("WA_WState_ConfigPending", &qt_gsi::c_50_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_ConfigPending") +
    gsi::constant ("WA_WState_Polished", &qt_gsi::c_51_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_Polished") +
    gsi::constant ("WA_WState_DND", &qt_gsi::c_52_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_DND") +
    gsi::constant ("WA_WState_OwnSizePolicy", &qt_gsi::c_53_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_OwnSizePolicy") +
    gsi::constant ("WA_WState_ExplicitShowHide", &qt_gsi::c_54_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_ExplicitShowHide") +
    gsi::constant ("WA_ShowModal", &qt_gsi::c_55_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_ShowModal") +
    gsi::constant ("WA_MouseNoMask", &qt_gsi::c_56_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MouseNoMask") +
    gsi::constant ("WA_GroupLeader", &qt_gsi::c_57_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_GroupLeader") +
    gsi::constant ("WA_NoMousePropagation", &qt_gsi::c_58_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_NoMousePropagation") +
    gsi::constant ("WA_Hover", &qt_gsi::c_59_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_Hover") +
    gsi::constant ("WA_InputMethodTransparent", &qt_gsi::c_60_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_InputMethodTransparent") +
    gsi::constant ("WA_QuitOnClose", &qt_gsi::c_61_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_QuitOnClose") +
    gsi::constant ("WA_KeyboardFocusChange", &qt_gsi::c_62_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_KeyboardFocusChange") +
    gsi::constant ("WA_AcceptDrops", &qt_gsi::c_63_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_AcceptDrops") +
    gsi::constant ("WA_DropSiteRegistered", &qt_gsi::c_64_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_DropSiteRegistered") +
    gsi::constant ("WA_ForceAcceptDrops", &qt_gsi::c_65_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_ForceAcceptDrops") +
    gsi::constant ("WA_WindowPropagation", &qt_gsi::c_66_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WindowPropagation") +
    gsi::constant ("WA_NoX11EventCompression", &qt_gsi::c_67_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_NoX11EventCompression") +
    gsi::constant ("WA_TintedBackground", &qt_gsi::c_68_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_TintedBackground") +
    gsi::constant ("WA_X11OpenGLOverlay", &qt_gsi::c_69_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11OpenGLOverlay") +
    gsi::constant ("WA_AlwaysShowToolTips", &qt_gsi::c_70_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_AlwaysShowToolTips") +
    gsi::constant ("WA_MacOpaqueSizeGrip", &qt_gsi::c_71_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacOpaqueSizeGrip") +
    gsi::constant ("WA_SetStyle", &qt_gsi::c_72_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_SetStyle") +
    gsi::constant ("WA_SetLocale", &qt_gsi::c_73_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_SetLocale") +
    gsi::constant ("WA_MacShowFocusRect", &qt_gsi::c_74_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacShowFocusRect") +
    gsi::constant ("WA_MacNormalSize", &qt_gsi::c_75_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacNormalSize") +
    gsi::constant ("WA_MacSmallSize", &qt_gsi::c_76_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacSmallSize") +
    gsi::constant ("WA_MacMiniSize", &qt_gsi::c_77_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacMiniSize") +
    gsi::constant ("WA_LayoutUsesWidgetRect", &qt_gsi::c_78_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_LayoutUsesWidgetRect") +
    gsi::constant ("WA_StyledBackground", &qt_gsi::c_79_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_StyledBackground") +
    gsi::constant ("WA_MSWindowsUseDirect3D", &qt_gsi::c_80_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MSWindowsUseDirect3D") +
    gsi::constant ("WA_CanHostQMdiSubWindowTitleBar", &qt_gsi::c_81_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_CanHostQMdiSubWindowTitleBar") +
    gsi::constant ("WA_MacAlwaysShowToolWindow", &qt_gsi::c_82_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacAlwaysShowToolWindow") +
    gsi::constant ("WA_StyleSheet", &qt_gsi::c_83_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_StyleSheet") +
    gsi::constant ("WA_ShowWithoutActivating", &qt_gsi::c_84_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_ShowWithoutActivating") +
    gsi::constant ("WA_X11BypassTransientForHint", &qt_gsi::c_85_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11BypassTransientForHint") +
    gsi::constant ("WA_NativeWindow", &qt_gsi::c_86_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_NativeWindow") +
    gsi::constant ("WA_DontCreateNativeAncestors", &qt_gsi::c_87_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_DontCreateNativeAncestors") +
    gsi::constant ("WA_MacVariableSize", &qt_gsi::c_88_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacVariableSize") +
    gsi::constant ("WA_DontShowOnScreen", &qt_gsi::c_89_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_DontShowOnScreen") +
    gsi::constant ("WA_X11NetWmWindowTypeDesktop", &qt_gsi::c_90_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeDesktop") +
    gsi::constant ("WA_X11NetWmWindowTypeDock", &qt_gsi::c_91_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeDock") +
    gsi::constant ("WA_X11NetWmWindowTypeToolBar", &qt_gsi::c_92_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeToolBar") +
    gsi::constant ("WA_X11NetWmWindowTypeMenu", &qt_gsi::c_93_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeMenu") +
    gsi::constant ("WA_X11NetWmWindowTypeUtility", &qt_gsi::c_94_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeUtility") +
    gsi::constant ("WA_X11NetWmWindowTypeSplash", &qt_gsi::c_95_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeSplash") +
    gsi::constant ("WA_X11NetWmWindowTypeDialog", &qt_gsi::c_96_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeDialog") +
    gsi::constant ("WA_X11NetWmWindowTypeDropDownMenu", &qt_gsi::c_97_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeDropDownMenu") +
    gsi::constant ("WA_X11NetWmWindowTypePopupMenu", &qt_gsi::c_98_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypePopupMenu") +
    gsi::constant ("WA_X11NetWmWindowTypeToolTip", &qt_gsi::c_99_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeToolTip") +
    gsi::constant ("WA_X11NetWmWindowTypeNotification", &qt_gsi::c_100_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeNotification") +
    gsi::constant ("WA_X11NetWmWindowTypeCombo", &qt_gsi::c_101_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeCombo") +
    gsi::constant ("WA_X11NetWmWindowTypeDND", &qt_gsi::c_102_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_X11NetWmWindowTypeDND") +
    gsi::constant ("WA_MacFrameworkScaled", &qt_gsi::c_103_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MacFrameworkScaled") +
    gsi::constant ("WA_SetWindowModality", &qt_gsi::c_104_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_SetWindowModality") +
    gsi::constant ("WA_WState_WindowOpacitySet", &qt_gsi::c_105_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_WindowOpacitySet") +
    gsi::constant ("WA_TranslucentBackground", &qt_gsi::c_106_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_TranslucentBackground") +
    gsi::constant ("WA_AcceptTouchEvents", &qt_gsi::c_107_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_AcceptTouchEvents") +
    gsi::constant ("WA_WState_AcceptedTouchBeginEvent", &qt_gsi::c_108_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_WState_AcceptedTouchBeginEvent") +
    gsi::constant ("WA_TouchPadAcceptSingleTouchEvents", &qt_gsi::c_109_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_TouchPadAcceptSingleTouchEvents") +
    gsi::constant ("WA_MergeSoftkeys", &qt_gsi::c_110_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MergeSoftkeys") +
    gsi::constant ("WA_MergeSoftkeysRecursively", &qt_gsi::c_111_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_MergeSoftkeysRecursively") +
    gsi::constant ("WA_AttributeCount", &qt_gsi::c_112_Qt_WidgetAttribute_Enum, "@brief Enum constant Qt::WA_AttributeCount");
}

static std::string to_s_Qt_WidgetAttribute_Enum (const Qt_WidgetAttribute_Enum *e)
{
  if (e->value () == Qt::WA_Disabled) { return tl::sprintf ("WA_Disabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_UnderMouse) { return tl::sprintf ("WA_UnderMouse (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MouseTracking) { return tl::sprintf ("WA_MouseTracking (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_ContentsPropagated) { return tl::sprintf ("WA_ContentsPropagated (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_OpaquePaintEvent) { return tl::sprintf ("WA_OpaquePaintEvent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_NoBackground) { return tl::sprintf ("WA_NoBackground (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_StaticContents) { return tl::sprintf ("WA_StaticContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_LaidOut) { return tl::sprintf ("WA_LaidOut (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_PaintOnScreen) { return tl::sprintf ("WA_PaintOnScreen (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_NoSystemBackground) { return tl::sprintf ("WA_NoSystemBackground (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_UpdatesDisabled) { return tl::sprintf ("WA_UpdatesDisabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_Mapped) { return tl::sprintf ("WA_Mapped (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacNoClickThrough) { return tl::sprintf ("WA_MacNoClickThrough (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_PaintOutsidePaintEvent) { return tl::sprintf ("WA_PaintOutsidePaintEvent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_InputMethodEnabled) { return tl::sprintf ("WA_InputMethodEnabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_Visible) { return tl::sprintf ("WA_WState_Visible (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_Hidden) { return tl::sprintf ("WA_WState_Hidden (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_ForceDisabled) { return tl::sprintf ("WA_ForceDisabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_KeyCompression) { return tl::sprintf ("WA_KeyCompression (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_PendingMoveEvent) { return tl::sprintf ("WA_PendingMoveEvent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_PendingResizeEvent) { return tl::sprintf ("WA_PendingResizeEvent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_SetPalette) { return tl::sprintf ("WA_SetPalette (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_SetFont) { return tl::sprintf ("WA_SetFont (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_SetCursor) { return tl::sprintf ("WA_SetCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_NoChildEventsFromChildren) { return tl::sprintf ("WA_NoChildEventsFromChildren (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WindowModified) { return tl::sprintf ("WA_WindowModified (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_Resized) { return tl::sprintf ("WA_Resized (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_Moved) { return tl::sprintf ("WA_Moved (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_PendingUpdate) { return tl::sprintf ("WA_PendingUpdate (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_InvalidSize) { return tl::sprintf ("WA_InvalidSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacBrushedMetal) { return tl::sprintf ("WA_MacBrushedMetal (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacMetalStyle) { return tl::sprintf ("WA_MacMetalStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_CustomWhatsThis) { return tl::sprintf ("WA_CustomWhatsThis (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_LayoutOnEntireRect) { return tl::sprintf ("WA_LayoutOnEntireRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_OutsideWSRange) { return tl::sprintf ("WA_OutsideWSRange (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_GrabbedShortcut) { return tl::sprintf ("WA_GrabbedShortcut (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_TransparentForMouseEvents) { return tl::sprintf ("WA_TransparentForMouseEvents (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_PaintUnclipped) { return tl::sprintf ("WA_PaintUnclipped (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_SetWindowIcon) { return tl::sprintf ("WA_SetWindowIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_NoMouseReplay) { return tl::sprintf ("WA_NoMouseReplay (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_DeleteOnClose) { return tl::sprintf ("WA_DeleteOnClose (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_RightToLeft) { return tl::sprintf ("WA_RightToLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_SetLayoutDirection) { return tl::sprintf ("WA_SetLayoutDirection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_NoChildEventsForParent) { return tl::sprintf ("WA_NoChildEventsForParent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_ForceUpdatesDisabled) { return tl::sprintf ("WA_ForceUpdatesDisabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_Created) { return tl::sprintf ("WA_WState_Created (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_CompressKeys) { return tl::sprintf ("WA_WState_CompressKeys (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_InPaintEvent) { return tl::sprintf ("WA_WState_InPaintEvent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_Reparented) { return tl::sprintf ("WA_WState_Reparented (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_ConfigPending) { return tl::sprintf ("WA_WState_ConfigPending (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_Polished) { return tl::sprintf ("WA_WState_Polished (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_DND) { return tl::sprintf ("WA_WState_DND (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_OwnSizePolicy) { return tl::sprintf ("WA_WState_OwnSizePolicy (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_ExplicitShowHide) { return tl::sprintf ("WA_WState_ExplicitShowHide (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_ShowModal) { return tl::sprintf ("WA_ShowModal (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MouseNoMask) { return tl::sprintf ("WA_MouseNoMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_GroupLeader) { return tl::sprintf ("WA_GroupLeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_NoMousePropagation) { return tl::sprintf ("WA_NoMousePropagation (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_Hover) { return tl::sprintf ("WA_Hover (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_InputMethodTransparent) { return tl::sprintf ("WA_InputMethodTransparent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_QuitOnClose) { return tl::sprintf ("WA_QuitOnClose (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_KeyboardFocusChange) { return tl::sprintf ("WA_KeyboardFocusChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_AcceptDrops) { return tl::sprintf ("WA_AcceptDrops (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_DropSiteRegistered) { return tl::sprintf ("WA_DropSiteRegistered (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_ForceAcceptDrops) { return tl::sprintf ("WA_ForceAcceptDrops (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WindowPropagation) { return tl::sprintf ("WA_WindowPropagation (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_NoX11EventCompression) { return tl::sprintf ("WA_NoX11EventCompression (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_TintedBackground) { return tl::sprintf ("WA_TintedBackground (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11OpenGLOverlay) { return tl::sprintf ("WA_X11OpenGLOverlay (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_AlwaysShowToolTips) { return tl::sprintf ("WA_AlwaysShowToolTips (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacOpaqueSizeGrip) { return tl::sprintf ("WA_MacOpaqueSizeGrip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_SetStyle) { return tl::sprintf ("WA_SetStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_SetLocale) { return tl::sprintf ("WA_SetLocale (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacShowFocusRect) { return tl::sprintf ("WA_MacShowFocusRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacNormalSize) { return tl::sprintf ("WA_MacNormalSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacSmallSize) { return tl::sprintf ("WA_MacSmallSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacMiniSize) { return tl::sprintf ("WA_MacMiniSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_LayoutUsesWidgetRect) { return tl::sprintf ("WA_LayoutUsesWidgetRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_StyledBackground) { return tl::sprintf ("WA_StyledBackground (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MSWindowsUseDirect3D) { return tl::sprintf ("WA_MSWindowsUseDirect3D (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_CanHostQMdiSubWindowTitleBar) { return tl::sprintf ("WA_CanHostQMdiSubWindowTitleBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacAlwaysShowToolWindow) { return tl::sprintf ("WA_MacAlwaysShowToolWindow (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_StyleSheet) { return tl::sprintf ("WA_StyleSheet (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_ShowWithoutActivating) { return tl::sprintf ("WA_ShowWithoutActivating (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11BypassTransientForHint) { return tl::sprintf ("WA_X11BypassTransientForHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_NativeWindow) { return tl::sprintf ("WA_NativeWindow (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_DontCreateNativeAncestors) { return tl::sprintf ("WA_DontCreateNativeAncestors (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacVariableSize) { return tl::sprintf ("WA_MacVariableSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_DontShowOnScreen) { return tl::sprintf ("WA_DontShowOnScreen (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeDesktop) { return tl::sprintf ("WA_X11NetWmWindowTypeDesktop (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeDock) { return tl::sprintf ("WA_X11NetWmWindowTypeDock (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeToolBar) { return tl::sprintf ("WA_X11NetWmWindowTypeToolBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeMenu) { return tl::sprintf ("WA_X11NetWmWindowTypeMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeUtility) { return tl::sprintf ("WA_X11NetWmWindowTypeUtility (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeSplash) { return tl::sprintf ("WA_X11NetWmWindowTypeSplash (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeDialog) { return tl::sprintf ("WA_X11NetWmWindowTypeDialog (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeDropDownMenu) { return tl::sprintf ("WA_X11NetWmWindowTypeDropDownMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypePopupMenu) { return tl::sprintf ("WA_X11NetWmWindowTypePopupMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeToolTip) { return tl::sprintf ("WA_X11NetWmWindowTypeToolTip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeNotification) { return tl::sprintf ("WA_X11NetWmWindowTypeNotification (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeCombo) { return tl::sprintf ("WA_X11NetWmWindowTypeCombo (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_X11NetWmWindowTypeDND) { return tl::sprintf ("WA_X11NetWmWindowTypeDND (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MacFrameworkScaled) { return tl::sprintf ("WA_MacFrameworkScaled (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_SetWindowModality) { return tl::sprintf ("WA_SetWindowModality (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_WindowOpacitySet) { return tl::sprintf ("WA_WState_WindowOpacitySet (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_TranslucentBackground) { return tl::sprintf ("WA_TranslucentBackground (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_AcceptTouchEvents) { return tl::sprintf ("WA_AcceptTouchEvents (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_WState_AcceptedTouchBeginEvent) { return tl::sprintf ("WA_WState_AcceptedTouchBeginEvent (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_TouchPadAcceptSingleTouchEvents) { return tl::sprintf ("WA_TouchPadAcceptSingleTouchEvents (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MergeSoftkeys) { return tl::sprintf ("WA_MergeSoftkeys (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_MergeSoftkeysRecursively) { return tl::sprintf ("WA_MergeSoftkeysRecursively (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WA_AttributeCount) { return tl::sprintf ("WA_AttributeCount (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_WidgetAttribute_Enum (const Qt_WidgetAttribute_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_WidgetAttribute_Enum *from_i_Qt_WidgetAttribute_Enum (unsigned int i)
{
  return new Qt_WidgetAttribute_Enum ((Qt::WidgetAttribute) i);
}

static bool equalQt_WidgetAttribute_Enum (const Qt_WidgetAttribute_Enum *e, Qt_WidgetAttribute_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_WidgetAttribute_Enum (const Qt_WidgetAttribute_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_WidgetAttribute_Enums oropQt_WidgetAttribute_Enums (const Qt_WidgetAttribute_Enums *e, const Qt_WidgetAttribute_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_WidgetAttribute_Enums andopQt_WidgetAttribute_Enums (const Qt_WidgetAttribute_Enums *e, const Qt_WidgetAttribute_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_WidgetAttribute_Enums xoropQt_WidgetAttribute_Enums (const Qt_WidgetAttribute_Enums *e, const Qt_WidgetAttribute_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_WidgetAttribute_Enums (const Qt_WidgetAttribute_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::WA_Disabled)) { if (!l.empty ()) l += "|"; l += "WA_Disabled"; }
  if (e->testFlag (Qt::WA_UnderMouse)) { if (!l.empty ()) l += "|"; l += "WA_UnderMouse"; }
  if (e->testFlag (Qt::WA_MouseTracking)) { if (!l.empty ()) l += "|"; l += "WA_MouseTracking"; }
  if (e->testFlag (Qt::WA_ContentsPropagated)) { if (!l.empty ()) l += "|"; l += "WA_ContentsPropagated"; }
  if (e->testFlag (Qt::WA_OpaquePaintEvent)) { if (!l.empty ()) l += "|"; l += "WA_OpaquePaintEvent"; }
  if (e->testFlag (Qt::WA_NoBackground)) { if (!l.empty ()) l += "|"; l += "WA_NoBackground"; }
  if (e->testFlag (Qt::WA_StaticContents)) { if (!l.empty ()) l += "|"; l += "WA_StaticContents"; }
  if (e->testFlag (Qt::WA_LaidOut)) { if (!l.empty ()) l += "|"; l += "WA_LaidOut"; }
  if (e->testFlag (Qt::WA_PaintOnScreen)) { if (!l.empty ()) l += "|"; l += "WA_PaintOnScreen"; }
  if (e->testFlag (Qt::WA_NoSystemBackground)) { if (!l.empty ()) l += "|"; l += "WA_NoSystemBackground"; }
  if (e->testFlag (Qt::WA_UpdatesDisabled)) { if (!l.empty ()) l += "|"; l += "WA_UpdatesDisabled"; }
  if (e->testFlag (Qt::WA_Mapped)) { if (!l.empty ()) l += "|"; l += "WA_Mapped"; }
  if (e->testFlag (Qt::WA_MacNoClickThrough)) { if (!l.empty ()) l += "|"; l += "WA_MacNoClickThrough"; }
  if (e->testFlag (Qt::WA_PaintOutsidePaintEvent)) { if (!l.empty ()) l += "|"; l += "WA_PaintOutsidePaintEvent"; }
  if (e->testFlag (Qt::WA_InputMethodEnabled)) { if (!l.empty ()) l += "|"; l += "WA_InputMethodEnabled"; }
  if (e->testFlag (Qt::WA_WState_Visible)) { if (!l.empty ()) l += "|"; l += "WA_WState_Visible"; }
  if (e->testFlag (Qt::WA_WState_Hidden)) { if (!l.empty ()) l += "|"; l += "WA_WState_Hidden"; }
  if (e->testFlag (Qt::WA_ForceDisabled)) { if (!l.empty ()) l += "|"; l += "WA_ForceDisabled"; }
  if (e->testFlag (Qt::WA_KeyCompression)) { if (!l.empty ()) l += "|"; l += "WA_KeyCompression"; }
  if (e->testFlag (Qt::WA_PendingMoveEvent)) { if (!l.empty ()) l += "|"; l += "WA_PendingMoveEvent"; }
  if (e->testFlag (Qt::WA_PendingResizeEvent)) { if (!l.empty ()) l += "|"; l += "WA_PendingResizeEvent"; }
  if (e->testFlag (Qt::WA_SetPalette)) { if (!l.empty ()) l += "|"; l += "WA_SetPalette"; }
  if (e->testFlag (Qt::WA_SetFont)) { if (!l.empty ()) l += "|"; l += "WA_SetFont"; }
  if (e->testFlag (Qt::WA_SetCursor)) { if (!l.empty ()) l += "|"; l += "WA_SetCursor"; }
  if (e->testFlag (Qt::WA_NoChildEventsFromChildren)) { if (!l.empty ()) l += "|"; l += "WA_NoChildEventsFromChildren"; }
  if (e->testFlag (Qt::WA_WindowModified)) { if (!l.empty ()) l += "|"; l += "WA_WindowModified"; }
  if (e->testFlag (Qt::WA_Resized)) { if (!l.empty ()) l += "|"; l += "WA_Resized"; }
  if (e->testFlag (Qt::WA_Moved)) { if (!l.empty ()) l += "|"; l += "WA_Moved"; }
  if (e->testFlag (Qt::WA_PendingUpdate)) { if (!l.empty ()) l += "|"; l += "WA_PendingUpdate"; }
  if (e->testFlag (Qt::WA_InvalidSize)) { if (!l.empty ()) l += "|"; l += "WA_InvalidSize"; }
  if (e->testFlag (Qt::WA_MacBrushedMetal)) { if (!l.empty ()) l += "|"; l += "WA_MacBrushedMetal"; }
  if (e->testFlag (Qt::WA_MacMetalStyle)) { if (!l.empty ()) l += "|"; l += "WA_MacMetalStyle"; }
  if (e->testFlag (Qt::WA_CustomWhatsThis)) { if (!l.empty ()) l += "|"; l += "WA_CustomWhatsThis"; }
  if (e->testFlag (Qt::WA_LayoutOnEntireRect)) { if (!l.empty ()) l += "|"; l += "WA_LayoutOnEntireRect"; }
  if (e->testFlag (Qt::WA_OutsideWSRange)) { if (!l.empty ()) l += "|"; l += "WA_OutsideWSRange"; }
  if (e->testFlag (Qt::WA_GrabbedShortcut)) { if (!l.empty ()) l += "|"; l += "WA_GrabbedShortcut"; }
  if (e->testFlag (Qt::WA_TransparentForMouseEvents)) { if (!l.empty ()) l += "|"; l += "WA_TransparentForMouseEvents"; }
  if (e->testFlag (Qt::WA_PaintUnclipped)) { if (!l.empty ()) l += "|"; l += "WA_PaintUnclipped"; }
  if (e->testFlag (Qt::WA_SetWindowIcon)) { if (!l.empty ()) l += "|"; l += "WA_SetWindowIcon"; }
  if (e->testFlag (Qt::WA_NoMouseReplay)) { if (!l.empty ()) l += "|"; l += "WA_NoMouseReplay"; }
  if (e->testFlag (Qt::WA_DeleteOnClose)) { if (!l.empty ()) l += "|"; l += "WA_DeleteOnClose"; }
  if (e->testFlag (Qt::WA_RightToLeft)) { if (!l.empty ()) l += "|"; l += "WA_RightToLeft"; }
  if (e->testFlag (Qt::WA_SetLayoutDirection)) { if (!l.empty ()) l += "|"; l += "WA_SetLayoutDirection"; }
  if (e->testFlag (Qt::WA_NoChildEventsForParent)) { if (!l.empty ()) l += "|"; l += "WA_NoChildEventsForParent"; }
  if (e->testFlag (Qt::WA_ForceUpdatesDisabled)) { if (!l.empty ()) l += "|"; l += "WA_ForceUpdatesDisabled"; }
  if (e->testFlag (Qt::WA_WState_Created)) { if (!l.empty ()) l += "|"; l += "WA_WState_Created"; }
  if (e->testFlag (Qt::WA_WState_CompressKeys)) { if (!l.empty ()) l += "|"; l += "WA_WState_CompressKeys"; }
  if (e->testFlag (Qt::WA_WState_InPaintEvent)) { if (!l.empty ()) l += "|"; l += "WA_WState_InPaintEvent"; }
  if (e->testFlag (Qt::WA_WState_Reparented)) { if (!l.empty ()) l += "|"; l += "WA_WState_Reparented"; }
  if (e->testFlag (Qt::WA_WState_ConfigPending)) { if (!l.empty ()) l += "|"; l += "WA_WState_ConfigPending"; }
  if (e->testFlag (Qt::WA_WState_Polished)) { if (!l.empty ()) l += "|"; l += "WA_WState_Polished"; }
  if (e->testFlag (Qt::WA_WState_DND)) { if (!l.empty ()) l += "|"; l += "WA_WState_DND"; }
  if (e->testFlag (Qt::WA_WState_OwnSizePolicy)) { if (!l.empty ()) l += "|"; l += "WA_WState_OwnSizePolicy"; }
  if (e->testFlag (Qt::WA_WState_ExplicitShowHide)) { if (!l.empty ()) l += "|"; l += "WA_WState_ExplicitShowHide"; }
  if (e->testFlag (Qt::WA_ShowModal)) { if (!l.empty ()) l += "|"; l += "WA_ShowModal"; }
  if (e->testFlag (Qt::WA_MouseNoMask)) { if (!l.empty ()) l += "|"; l += "WA_MouseNoMask"; }
  if (e->testFlag (Qt::WA_GroupLeader)) { if (!l.empty ()) l += "|"; l += "WA_GroupLeader"; }
  if (e->testFlag (Qt::WA_NoMousePropagation)) { if (!l.empty ()) l += "|"; l += "WA_NoMousePropagation"; }
  if (e->testFlag (Qt::WA_Hover)) { if (!l.empty ()) l += "|"; l += "WA_Hover"; }
  if (e->testFlag (Qt::WA_InputMethodTransparent)) { if (!l.empty ()) l += "|"; l += "WA_InputMethodTransparent"; }
  if (e->testFlag (Qt::WA_QuitOnClose)) { if (!l.empty ()) l += "|"; l += "WA_QuitOnClose"; }
  if (e->testFlag (Qt::WA_KeyboardFocusChange)) { if (!l.empty ()) l += "|"; l += "WA_KeyboardFocusChange"; }
  if (e->testFlag (Qt::WA_AcceptDrops)) { if (!l.empty ()) l += "|"; l += "WA_AcceptDrops"; }
  if (e->testFlag (Qt::WA_DropSiteRegistered)) { if (!l.empty ()) l += "|"; l += "WA_DropSiteRegistered"; }
  if (e->testFlag (Qt::WA_ForceAcceptDrops)) { if (!l.empty ()) l += "|"; l += "WA_ForceAcceptDrops"; }
  if (e->testFlag (Qt::WA_WindowPropagation)) { if (!l.empty ()) l += "|"; l += "WA_WindowPropagation"; }
  if (e->testFlag (Qt::WA_NoX11EventCompression)) { if (!l.empty ()) l += "|"; l += "WA_NoX11EventCompression"; }
  if (e->testFlag (Qt::WA_TintedBackground)) { if (!l.empty ()) l += "|"; l += "WA_TintedBackground"; }
  if (e->testFlag (Qt::WA_X11OpenGLOverlay)) { if (!l.empty ()) l += "|"; l += "WA_X11OpenGLOverlay"; }
  if (e->testFlag (Qt::WA_AlwaysShowToolTips)) { if (!l.empty ()) l += "|"; l += "WA_AlwaysShowToolTips"; }
  if (e->testFlag (Qt::WA_MacOpaqueSizeGrip)) { if (!l.empty ()) l += "|"; l += "WA_MacOpaqueSizeGrip"; }
  if (e->testFlag (Qt::WA_SetStyle)) { if (!l.empty ()) l += "|"; l += "WA_SetStyle"; }
  if (e->testFlag (Qt::WA_SetLocale)) { if (!l.empty ()) l += "|"; l += "WA_SetLocale"; }
  if (e->testFlag (Qt::WA_MacShowFocusRect)) { if (!l.empty ()) l += "|"; l += "WA_MacShowFocusRect"; }
  if (e->testFlag (Qt::WA_MacNormalSize)) { if (!l.empty ()) l += "|"; l += "WA_MacNormalSize"; }
  if (e->testFlag (Qt::WA_MacSmallSize)) { if (!l.empty ()) l += "|"; l += "WA_MacSmallSize"; }
  if (e->testFlag (Qt::WA_MacMiniSize)) { if (!l.empty ()) l += "|"; l += "WA_MacMiniSize"; }
  if (e->testFlag (Qt::WA_LayoutUsesWidgetRect)) { if (!l.empty ()) l += "|"; l += "WA_LayoutUsesWidgetRect"; }
  if (e->testFlag (Qt::WA_StyledBackground)) { if (!l.empty ()) l += "|"; l += "WA_StyledBackground"; }
  if (e->testFlag (Qt::WA_MSWindowsUseDirect3D)) { if (!l.empty ()) l += "|"; l += "WA_MSWindowsUseDirect3D"; }
  if (e->testFlag (Qt::WA_CanHostQMdiSubWindowTitleBar)) { if (!l.empty ()) l += "|"; l += "WA_CanHostQMdiSubWindowTitleBar"; }
  if (e->testFlag (Qt::WA_MacAlwaysShowToolWindow)) { if (!l.empty ()) l += "|"; l += "WA_MacAlwaysShowToolWindow"; }
  if (e->testFlag (Qt::WA_StyleSheet)) { if (!l.empty ()) l += "|"; l += "WA_StyleSheet"; }
  if (e->testFlag (Qt::WA_ShowWithoutActivating)) { if (!l.empty ()) l += "|"; l += "WA_ShowWithoutActivating"; }
  if (e->testFlag (Qt::WA_X11BypassTransientForHint)) { if (!l.empty ()) l += "|"; l += "WA_X11BypassTransientForHint"; }
  if (e->testFlag (Qt::WA_NativeWindow)) { if (!l.empty ()) l += "|"; l += "WA_NativeWindow"; }
  if (e->testFlag (Qt::WA_DontCreateNativeAncestors)) { if (!l.empty ()) l += "|"; l += "WA_DontCreateNativeAncestors"; }
  if (e->testFlag (Qt::WA_MacVariableSize)) { if (!l.empty ()) l += "|"; l += "WA_MacVariableSize"; }
  if (e->testFlag (Qt::WA_DontShowOnScreen)) { if (!l.empty ()) l += "|"; l += "WA_DontShowOnScreen"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeDesktop)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeDesktop"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeDock)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeDock"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeToolBar)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeToolBar"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeMenu)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeMenu"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeUtility)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeUtility"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeSplash)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeSplash"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeDialog)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeDialog"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeDropDownMenu)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeDropDownMenu"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypePopupMenu)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypePopupMenu"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeToolTip)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeToolTip"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeNotification)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeNotification"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeCombo)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeCombo"; }
  if (e->testFlag (Qt::WA_X11NetWmWindowTypeDND)) { if (!l.empty ()) l += "|"; l += "WA_X11NetWmWindowTypeDND"; }
  if (e->testFlag (Qt::WA_MacFrameworkScaled)) { if (!l.empty ()) l += "|"; l += "WA_MacFrameworkScaled"; }
  if (e->testFlag (Qt::WA_SetWindowModality)) { if (!l.empty ()) l += "|"; l += "WA_SetWindowModality"; }
  if (e->testFlag (Qt::WA_WState_WindowOpacitySet)) { if (!l.empty ()) l += "|"; l += "WA_WState_WindowOpacitySet"; }
  if (e->testFlag (Qt::WA_TranslucentBackground)) { if (!l.empty ()) l += "|"; l += "WA_TranslucentBackground"; }
  if (e->testFlag (Qt::WA_AcceptTouchEvents)) { if (!l.empty ()) l += "|"; l += "WA_AcceptTouchEvents"; }
  if (e->testFlag (Qt::WA_WState_AcceptedTouchBeginEvent)) { if (!l.empty ()) l += "|"; l += "WA_WState_AcceptedTouchBeginEvent"; }
  if (e->testFlag (Qt::WA_TouchPadAcceptSingleTouchEvents)) { if (!l.empty ()) l += "|"; l += "WA_TouchPadAcceptSingleTouchEvents"; }
  if (e->testFlag (Qt::WA_MergeSoftkeys)) { if (!l.empty ()) l += "|"; l += "WA_MergeSoftkeys"; }
  if (e->testFlag (Qt::WA_MergeSoftkeysRecursively)) { if (!l.empty ()) l += "|"; l += "WA_MergeSoftkeysRecursively"; }
  if (e->testFlag (Qt::WA_AttributeCount)) { if (!l.empty ()) l += "|"; l += "WA_AttributeCount"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_WidgetAttribute_Enums (const Qt_WidgetAttribute_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_WidgetAttribute_Enums (const Qt_WidgetAttribute_Enums *e, const Qt_WidgetAttribute_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_WidgetAttribute_Enums> decl_Qt_WidgetAttribute_Enums ("Qt_QFlags_WidgetAttribute",
  gsi::method_ext ("|", &qt_gsi::oropQt_WidgetAttribute_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_WidgetAttribute_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_WidgetAttribute_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WidgetAttribute_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WidgetAttribute_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_WidgetAttribute_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::WidgetAttribute> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_WidgetAttribute_Enum> decl_Qt_WidgetAttribute_Enum (decl_Qt_WidgetAttribute_Enums, "Qt_WidgetAttribute",
  qt_gsi::mkdefs_Qt_WidgetAttribute () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WidgetAttribute_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WidgetAttribute_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_WidgetAttribute_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_WidgetAttribute_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_WidgetAttribute_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::WidgetAttribute enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_WidgetAttribute_Enum_in_parent (qt_gsi::mkdefs_Qt_WidgetAttribute ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_WidgetAttribute_Enum_as_child (decl_Qt_WidgetAttribute_Enum, "WidgetAttribute");

}


//  Implementation of the enum wrapper class for Qt::WindowFrameSection
namespace qt_gsi
{

static Qt_WindowFrameSection_Enum *c_1_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::NoSection); }
static Qt_WindowFrameSection_Enum *c_2_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::LeftSection); }
static Qt_WindowFrameSection_Enum *c_3_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::TopLeftSection); }
static Qt_WindowFrameSection_Enum *c_4_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::TopSection); }
static Qt_WindowFrameSection_Enum *c_5_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::TopRightSection); }
static Qt_WindowFrameSection_Enum *c_6_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::RightSection); }
static Qt_WindowFrameSection_Enum *c_7_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::BottomRightSection); }
static Qt_WindowFrameSection_Enum *c_8_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::BottomSection); }
static Qt_WindowFrameSection_Enum *c_9_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::BottomLeftSection); }
static Qt_WindowFrameSection_Enum *c_10_Qt_WindowFrameSection_Enum () { return new Qt_WindowFrameSection_Enum (Qt::TitleBarArea); }

static gsi::Methods mkdefs_Qt_WindowFrameSection () {
  return
    gsi::constant ("NoSection", &qt_gsi::c_1_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::NoSection") +
    gsi::constant ("LeftSection", &qt_gsi::c_2_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::LeftSection") +
    gsi::constant ("TopLeftSection", &qt_gsi::c_3_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::TopLeftSection") +
    gsi::constant ("TopSection", &qt_gsi::c_4_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::TopSection") +
    gsi::constant ("TopRightSection", &qt_gsi::c_5_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::TopRightSection") +
    gsi::constant ("RightSection", &qt_gsi::c_6_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::RightSection") +
    gsi::constant ("BottomRightSection", &qt_gsi::c_7_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::BottomRightSection") +
    gsi::constant ("BottomSection", &qt_gsi::c_8_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::BottomSection") +
    gsi::constant ("BottomLeftSection", &qt_gsi::c_9_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::BottomLeftSection") +
    gsi::constant ("TitleBarArea", &qt_gsi::c_10_Qt_WindowFrameSection_Enum, "@brief Enum constant Qt::TitleBarArea");
}

static std::string to_s_Qt_WindowFrameSection_Enum (const Qt_WindowFrameSection_Enum *e)
{
  if (e->value () == Qt::NoSection) { return tl::sprintf ("NoSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::LeftSection) { return tl::sprintf ("LeftSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TopLeftSection) { return tl::sprintf ("TopLeftSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TopSection) { return tl::sprintf ("TopSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TopRightSection) { return tl::sprintf ("TopRightSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::RightSection) { return tl::sprintf ("RightSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BottomRightSection) { return tl::sprintf ("BottomRightSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BottomSection) { return tl::sprintf ("BottomSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BottomLeftSection) { return tl::sprintf ("BottomLeftSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::TitleBarArea) { return tl::sprintf ("TitleBarArea (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_WindowFrameSection_Enum (const Qt_WindowFrameSection_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_WindowFrameSection_Enum *from_i_Qt_WindowFrameSection_Enum (unsigned int i)
{
  return new Qt_WindowFrameSection_Enum ((Qt::WindowFrameSection) i);
}

static bool equalQt_WindowFrameSection_Enum (const Qt_WindowFrameSection_Enum *e, Qt_WindowFrameSection_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_WindowFrameSection_Enum (const Qt_WindowFrameSection_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_WindowFrameSection_Enums oropQt_WindowFrameSection_Enums (const Qt_WindowFrameSection_Enums *e, const Qt_WindowFrameSection_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_WindowFrameSection_Enums andopQt_WindowFrameSection_Enums (const Qt_WindowFrameSection_Enums *e, const Qt_WindowFrameSection_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_WindowFrameSection_Enums xoropQt_WindowFrameSection_Enums (const Qt_WindowFrameSection_Enums *e, const Qt_WindowFrameSection_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_WindowFrameSection_Enums (const Qt_WindowFrameSection_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NoSection)) { if (!l.empty ()) l += "|"; l += "NoSection"; }
  if (e->testFlag (Qt::LeftSection)) { if (!l.empty ()) l += "|"; l += "LeftSection"; }
  if (e->testFlag (Qt::TopLeftSection)) { if (!l.empty ()) l += "|"; l += "TopLeftSection"; }
  if (e->testFlag (Qt::TopSection)) { if (!l.empty ()) l += "|"; l += "TopSection"; }
  if (e->testFlag (Qt::TopRightSection)) { if (!l.empty ()) l += "|"; l += "TopRightSection"; }
  if (e->testFlag (Qt::RightSection)) { if (!l.empty ()) l += "|"; l += "RightSection"; }
  if (e->testFlag (Qt::BottomRightSection)) { if (!l.empty ()) l += "|"; l += "BottomRightSection"; }
  if (e->testFlag (Qt::BottomSection)) { if (!l.empty ()) l += "|"; l += "BottomSection"; }
  if (e->testFlag (Qt::BottomLeftSection)) { if (!l.empty ()) l += "|"; l += "BottomLeftSection"; }
  if (e->testFlag (Qt::TitleBarArea)) { if (!l.empty ()) l += "|"; l += "TitleBarArea"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_WindowFrameSection_Enums (const Qt_WindowFrameSection_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_WindowFrameSection_Enums (const Qt_WindowFrameSection_Enums *e, const Qt_WindowFrameSection_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_WindowFrameSection_Enums> decl_Qt_WindowFrameSection_Enums ("Qt_QFlags_WindowFrameSection",
  gsi::method_ext ("|", &qt_gsi::oropQt_WindowFrameSection_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_WindowFrameSection_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_WindowFrameSection_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WindowFrameSection_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WindowFrameSection_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_WindowFrameSection_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::WindowFrameSection> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_WindowFrameSection_Enum> decl_Qt_WindowFrameSection_Enum (decl_Qt_WindowFrameSection_Enums, "Qt_WindowFrameSection",
  qt_gsi::mkdefs_Qt_WindowFrameSection () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WindowFrameSection_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WindowFrameSection_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_WindowFrameSection_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_WindowFrameSection_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_WindowFrameSection_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::WindowFrameSection enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_WindowFrameSection_Enum_in_parent (qt_gsi::mkdefs_Qt_WindowFrameSection ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_WindowFrameSection_Enum_as_child (decl_Qt_WindowFrameSection_Enum, "WindowFrameSection");

}


//  Implementation of the enum wrapper class for Qt::WindowModality
namespace qt_gsi
{

static Qt_WindowModality_Enum *c_1_Qt_WindowModality_Enum () { return new Qt_WindowModality_Enum (Qt::NonModal); }
static Qt_WindowModality_Enum *c_2_Qt_WindowModality_Enum () { return new Qt_WindowModality_Enum (Qt::WindowModal); }
static Qt_WindowModality_Enum *c_3_Qt_WindowModality_Enum () { return new Qt_WindowModality_Enum (Qt::ApplicationModal); }

static gsi::Methods mkdefs_Qt_WindowModality () {
  return
    gsi::constant ("NonModal", &qt_gsi::c_1_Qt_WindowModality_Enum, "@brief Enum constant Qt::NonModal") +
    gsi::constant ("WindowModal", &qt_gsi::c_2_Qt_WindowModality_Enum, "@brief Enum constant Qt::WindowModal") +
    gsi::constant ("ApplicationModal", &qt_gsi::c_3_Qt_WindowModality_Enum, "@brief Enum constant Qt::ApplicationModal");
}

static std::string to_s_Qt_WindowModality_Enum (const Qt_WindowModality_Enum *e)
{
  if (e->value () == Qt::NonModal) { return tl::sprintf ("NonModal (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowModal) { return tl::sprintf ("WindowModal (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ApplicationModal) { return tl::sprintf ("ApplicationModal (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_WindowModality_Enum (const Qt_WindowModality_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_WindowModality_Enum *from_i_Qt_WindowModality_Enum (unsigned int i)
{
  return new Qt_WindowModality_Enum ((Qt::WindowModality) i);
}

static bool equalQt_WindowModality_Enum (const Qt_WindowModality_Enum *e, Qt_WindowModality_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_WindowModality_Enum (const Qt_WindowModality_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_WindowModality_Enums oropQt_WindowModality_Enums (const Qt_WindowModality_Enums *e, const Qt_WindowModality_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_WindowModality_Enums andopQt_WindowModality_Enums (const Qt_WindowModality_Enums *e, const Qt_WindowModality_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_WindowModality_Enums xoropQt_WindowModality_Enums (const Qt_WindowModality_Enums *e, const Qt_WindowModality_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_WindowModality_Enums (const Qt_WindowModality_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::NonModal)) { if (!l.empty ()) l += "|"; l += "NonModal"; }
  if (e->testFlag (Qt::WindowModal)) { if (!l.empty ()) l += "|"; l += "WindowModal"; }
  if (e->testFlag (Qt::ApplicationModal)) { if (!l.empty ()) l += "|"; l += "ApplicationModal"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_WindowModality_Enums (const Qt_WindowModality_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_WindowModality_Enums (const Qt_WindowModality_Enums *e, const Qt_WindowModality_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_WindowModality_Enums> decl_Qt_WindowModality_Enums ("Qt_QFlags_WindowModality",
  gsi::method_ext ("|", &qt_gsi::oropQt_WindowModality_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_WindowModality_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_WindowModality_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WindowModality_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WindowModality_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_WindowModality_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::WindowModality> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_WindowModality_Enum> decl_Qt_WindowModality_Enum (decl_Qt_WindowModality_Enums, "Qt_WindowModality",
  qt_gsi::mkdefs_Qt_WindowModality () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WindowModality_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WindowModality_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_WindowModality_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_WindowModality_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_WindowModality_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::WindowModality enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_WindowModality_Enum_in_parent (qt_gsi::mkdefs_Qt_WindowModality ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_WindowModality_Enum_as_child (decl_Qt_WindowModality_Enum, "WindowModality");

}


//  Implementation of the enum wrapper class for Qt::WindowState
namespace qt_gsi
{

static Qt_WindowState_Enum *c_1_Qt_WindowState_Enum () { return new Qt_WindowState_Enum (Qt::WindowNoState); }
static Qt_WindowState_Enum *c_2_Qt_WindowState_Enum () { return new Qt_WindowState_Enum (Qt::WindowMinimized); }
static Qt_WindowState_Enum *c_3_Qt_WindowState_Enum () { return new Qt_WindowState_Enum (Qt::WindowMaximized); }
static Qt_WindowState_Enum *c_4_Qt_WindowState_Enum () { return new Qt_WindowState_Enum (Qt::WindowFullScreen); }
static Qt_WindowState_Enum *c_5_Qt_WindowState_Enum () { return new Qt_WindowState_Enum (Qt::WindowActive); }

static gsi::Methods mkdefs_Qt_WindowState () {
  return
    gsi::constant ("WindowNoState", &qt_gsi::c_1_Qt_WindowState_Enum, "@brief Enum constant Qt::WindowNoState") +
    gsi::constant ("WindowMinimized", &qt_gsi::c_2_Qt_WindowState_Enum, "@brief Enum constant Qt::WindowMinimized") +
    gsi::constant ("WindowMaximized", &qt_gsi::c_3_Qt_WindowState_Enum, "@brief Enum constant Qt::WindowMaximized") +
    gsi::constant ("WindowFullScreen", &qt_gsi::c_4_Qt_WindowState_Enum, "@brief Enum constant Qt::WindowFullScreen") +
    gsi::constant ("WindowActive", &qt_gsi::c_5_Qt_WindowState_Enum, "@brief Enum constant Qt::WindowActive");
}

static std::string to_s_Qt_WindowState_Enum (const Qt_WindowState_Enum *e)
{
  if (e->value () == Qt::WindowNoState) { return tl::sprintf ("WindowNoState (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowMinimized) { return tl::sprintf ("WindowMinimized (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowMaximized) { return tl::sprintf ("WindowMaximized (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowFullScreen) { return tl::sprintf ("WindowFullScreen (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowActive) { return tl::sprintf ("WindowActive (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_WindowState_Enum (const Qt_WindowState_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_WindowState_Enum *from_i_Qt_WindowState_Enum (unsigned int i)
{
  return new Qt_WindowState_Enum ((Qt::WindowState) i);
}

static bool equalQt_WindowState_Enum (const Qt_WindowState_Enum *e, Qt_WindowState_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_WindowState_Enum (const Qt_WindowState_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_WindowState_Enums oropQt_WindowState_Enums (const Qt_WindowState_Enums *e, const Qt_WindowState_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_WindowState_Enums andopQt_WindowState_Enums (const Qt_WindowState_Enums *e, const Qt_WindowState_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_WindowState_Enums xoropQt_WindowState_Enums (const Qt_WindowState_Enums *e, const Qt_WindowState_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_WindowState_Enums (const Qt_WindowState_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::WindowNoState)) { if (!l.empty ()) l += "|"; l += "WindowNoState"; }
  if (e->testFlag (Qt::WindowMinimized)) { if (!l.empty ()) l += "|"; l += "WindowMinimized"; }
  if (e->testFlag (Qt::WindowMaximized)) { if (!l.empty ()) l += "|"; l += "WindowMaximized"; }
  if (e->testFlag (Qt::WindowFullScreen)) { if (!l.empty ()) l += "|"; l += "WindowFullScreen"; }
  if (e->testFlag (Qt::WindowActive)) { if (!l.empty ()) l += "|"; l += "WindowActive"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_WindowState_Enums (const Qt_WindowState_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_WindowState_Enums (const Qt_WindowState_Enums *e, const Qt_WindowState_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_WindowState_Enums> decl_Qt_WindowState_Enums ("Qt_QFlags_WindowState",
  gsi::method_ext ("|", &qt_gsi::oropQt_WindowState_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_WindowState_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_WindowState_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WindowState_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WindowState_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_WindowState_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::WindowState> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_WindowState_Enum> decl_Qt_WindowState_Enum (decl_Qt_WindowState_Enums, "Qt_WindowState",
  qt_gsi::mkdefs_Qt_WindowState () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WindowState_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WindowState_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_WindowState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_WindowState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_WindowState_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::WindowState enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_WindowState_Enum_in_parent (qt_gsi::mkdefs_Qt_WindowState ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_WindowState_Enum_as_child (decl_Qt_WindowState_Enum, "WindowState");

}


//  Implementation of the enum wrapper class for Qt::WindowType
namespace qt_gsi
{

static Qt_WindowType_Enum *c_1_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::Widget); }
static Qt_WindowType_Enum *c_2_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::Window); }
static Qt_WindowType_Enum *c_3_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::Dialog); }
static Qt_WindowType_Enum *c_4_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::Sheet); }
static Qt_WindowType_Enum *c_5_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::Drawer); }
static Qt_WindowType_Enum *c_6_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::Popup); }
static Qt_WindowType_Enum *c_7_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::Tool); }
static Qt_WindowType_Enum *c_8_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::ToolTip); }
static Qt_WindowType_Enum *c_9_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::SplashScreen); }
static Qt_WindowType_Enum *c_10_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::Desktop); }
static Qt_WindowType_Enum *c_11_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::SubWindow); }
static Qt_WindowType_Enum *c_12_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowType_Mask); }
static Qt_WindowType_Enum *c_13_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::MSWindowsFixedSizeDialogHint); }
static Qt_WindowType_Enum *c_14_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::MSWindowsOwnDC); }
static Qt_WindowType_Enum *c_15_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::X11BypassWindowManagerHint); }
static Qt_WindowType_Enum *c_16_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::FramelessWindowHint); }
static Qt_WindowType_Enum *c_17_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowTitleHint); }
static Qt_WindowType_Enum *c_18_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowSystemMenuHint); }
static Qt_WindowType_Enum *c_19_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowMinimizeButtonHint); }
static Qt_WindowType_Enum *c_20_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowMaximizeButtonHint); }
static Qt_WindowType_Enum *c_21_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowMinMaxButtonsHint); }
static Qt_WindowType_Enum *c_22_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowContextHelpButtonHint); }
static Qt_WindowType_Enum *c_23_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowShadeButtonHint); }
static Qt_WindowType_Enum *c_24_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowStaysOnTopHint); }
static Qt_WindowType_Enum *c_25_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::CustomizeWindowHint); }
static Qt_WindowType_Enum *c_26_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowStaysOnBottomHint); }
static Qt_WindowType_Enum *c_27_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowCloseButtonHint); }
static Qt_WindowType_Enum *c_28_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::MacWindowToolBarButtonHint); }
static Qt_WindowType_Enum *c_29_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::BypassGraphicsProxyWidget); }
static Qt_WindowType_Enum *c_30_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowOkButtonHint); }
static Qt_WindowType_Enum *c_31_Qt_WindowType_Enum () { return new Qt_WindowType_Enum (Qt::WindowCancelButtonHint); }

static gsi::Methods mkdefs_Qt_WindowType () {
  return
    gsi::constant ("Widget", &qt_gsi::c_1_Qt_WindowType_Enum, "@brief Enum constant Qt::Widget") +
    gsi::constant ("Window", &qt_gsi::c_2_Qt_WindowType_Enum, "@brief Enum constant Qt::Window") +
    gsi::constant ("Dialog", &qt_gsi::c_3_Qt_WindowType_Enum, "@brief Enum constant Qt::Dialog") +
    gsi::constant ("Sheet", &qt_gsi::c_4_Qt_WindowType_Enum, "@brief Enum constant Qt::Sheet") +
    gsi::constant ("Drawer", &qt_gsi::c_5_Qt_WindowType_Enum, "@brief Enum constant Qt::Drawer") +
    gsi::constant ("Popup", &qt_gsi::c_6_Qt_WindowType_Enum, "@brief Enum constant Qt::Popup") +
    gsi::constant ("Tool", &qt_gsi::c_7_Qt_WindowType_Enum, "@brief Enum constant Qt::Tool") +
    gsi::constant ("ToolTip", &qt_gsi::c_8_Qt_WindowType_Enum, "@brief Enum constant Qt::ToolTip") +
    gsi::constant ("SplashScreen", &qt_gsi::c_9_Qt_WindowType_Enum, "@brief Enum constant Qt::SplashScreen") +
    gsi::constant ("Desktop", &qt_gsi::c_10_Qt_WindowType_Enum, "@brief Enum constant Qt::Desktop") +
    gsi::constant ("SubWindow", &qt_gsi::c_11_Qt_WindowType_Enum, "@brief Enum constant Qt::SubWindow") +
    gsi::constant ("WindowType_Mask", &qt_gsi::c_12_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowType_Mask") +
    gsi::constant ("MSWindowsFixedSizeDialogHint", &qt_gsi::c_13_Qt_WindowType_Enum, "@brief Enum constant Qt::MSWindowsFixedSizeDialogHint") +
    gsi::constant ("MSWindowsOwnDC", &qt_gsi::c_14_Qt_WindowType_Enum, "@brief Enum constant Qt::MSWindowsOwnDC") +
    gsi::constant ("X11BypassWindowManagerHint", &qt_gsi::c_15_Qt_WindowType_Enum, "@brief Enum constant Qt::X11BypassWindowManagerHint") +
    gsi::constant ("FramelessWindowHint", &qt_gsi::c_16_Qt_WindowType_Enum, "@brief Enum constant Qt::FramelessWindowHint") +
    gsi::constant ("WindowTitleHint", &qt_gsi::c_17_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowTitleHint") +
    gsi::constant ("WindowSystemMenuHint", &qt_gsi::c_18_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowSystemMenuHint") +
    gsi::constant ("WindowMinimizeButtonHint", &qt_gsi::c_19_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowMinimizeButtonHint") +
    gsi::constant ("WindowMaximizeButtonHint", &qt_gsi::c_20_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowMaximizeButtonHint") +
    gsi::constant ("WindowMinMaxButtonsHint", &qt_gsi::c_21_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowMinMaxButtonsHint") +
    gsi::constant ("WindowContextHelpButtonHint", &qt_gsi::c_22_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowContextHelpButtonHint") +
    gsi::constant ("WindowShadeButtonHint", &qt_gsi::c_23_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowShadeButtonHint") +
    gsi::constant ("WindowStaysOnTopHint", &qt_gsi::c_24_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowStaysOnTopHint") +
    gsi::constant ("CustomizeWindowHint", &qt_gsi::c_25_Qt_WindowType_Enum, "@brief Enum constant Qt::CustomizeWindowHint") +
    gsi::constant ("WindowStaysOnBottomHint", &qt_gsi::c_26_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowStaysOnBottomHint") +
    gsi::constant ("WindowCloseButtonHint", &qt_gsi::c_27_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowCloseButtonHint") +
    gsi::constant ("MacWindowToolBarButtonHint", &qt_gsi::c_28_Qt_WindowType_Enum, "@brief Enum constant Qt::MacWindowToolBarButtonHint") +
    gsi::constant ("BypassGraphicsProxyWidget", &qt_gsi::c_29_Qt_WindowType_Enum, "@brief Enum constant Qt::BypassGraphicsProxyWidget") +
    gsi::constant ("WindowOkButtonHint", &qt_gsi::c_30_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowOkButtonHint") +
    gsi::constant ("WindowCancelButtonHint", &qt_gsi::c_31_Qt_WindowType_Enum, "@brief Enum constant Qt::WindowCancelButtonHint");
}

static std::string to_s_Qt_WindowType_Enum (const Qt_WindowType_Enum *e)
{
  if (e->value () == Qt::Widget) { return tl::sprintf ("Widget (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Window) { return tl::sprintf ("Window (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Dialog) { return tl::sprintf ("Dialog (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Sheet) { return tl::sprintf ("Sheet (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Drawer) { return tl::sprintf ("Drawer (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Popup) { return tl::sprintf ("Popup (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Tool) { return tl::sprintf ("Tool (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::ToolTip) { return tl::sprintf ("ToolTip (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SplashScreen) { return tl::sprintf ("SplashScreen (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::Desktop) { return tl::sprintf ("Desktop (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::SubWindow) { return tl::sprintf ("SubWindow (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowType_Mask) { return tl::sprintf ("WindowType_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MSWindowsFixedSizeDialogHint) { return tl::sprintf ("MSWindowsFixedSizeDialogHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MSWindowsOwnDC) { return tl::sprintf ("MSWindowsOwnDC (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::X11BypassWindowManagerHint) { return tl::sprintf ("X11BypassWindowManagerHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::FramelessWindowHint) { return tl::sprintf ("FramelessWindowHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowTitleHint) { return tl::sprintf ("WindowTitleHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowSystemMenuHint) { return tl::sprintf ("WindowSystemMenuHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowMinimizeButtonHint) { return tl::sprintf ("WindowMinimizeButtonHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowMaximizeButtonHint) { return tl::sprintf ("WindowMaximizeButtonHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowMinMaxButtonsHint) { return tl::sprintf ("WindowMinMaxButtonsHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowContextHelpButtonHint) { return tl::sprintf ("WindowContextHelpButtonHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowShadeButtonHint) { return tl::sprintf ("WindowShadeButtonHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowStaysOnTopHint) { return tl::sprintf ("WindowStaysOnTopHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::CustomizeWindowHint) { return tl::sprintf ("CustomizeWindowHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowStaysOnBottomHint) { return tl::sprintf ("WindowStaysOnBottomHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowCloseButtonHint) { return tl::sprintf ("WindowCloseButtonHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::MacWindowToolBarButtonHint) { return tl::sprintf ("MacWindowToolBarButtonHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::BypassGraphicsProxyWidget) { return tl::sprintf ("BypassGraphicsProxyWidget (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowOkButtonHint) { return tl::sprintf ("WindowOkButtonHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == Qt::WindowCancelButtonHint) { return tl::sprintf ("WindowCancelButtonHint (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_Qt_WindowType_Enum (const Qt_WindowType_Enum *e)
{
  return (unsigned int) e->value ();
}

static Qt_WindowType_Enum *from_i_Qt_WindowType_Enum (unsigned int i)
{
  return new Qt_WindowType_Enum ((Qt::WindowType) i);
}

static bool equalQt_WindowType_Enum (const Qt_WindowType_Enum *e, Qt_WindowType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2Qt_WindowType_Enum (const Qt_WindowType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static Qt_WindowType_Enums oropQt_WindowType_Enums (const Qt_WindowType_Enums *e, const Qt_WindowType_Enums &d)
{
  return e->flags () | d.flags ();
}

static Qt_WindowType_Enums andopQt_WindowType_Enums (const Qt_WindowType_Enums *e, const Qt_WindowType_Enums &d)
{
  return e->flags () & d.flags ();
}

static Qt_WindowType_Enums xoropQt_WindowType_Enums (const Qt_WindowType_Enums *e, const Qt_WindowType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_Qt_WindowType_Enums (const Qt_WindowType_Enums *e)
{
  std::string l;
  if (e->testFlag (Qt::Widget)) { if (!l.empty ()) l += "|"; l += "Widget"; }
  if (e->testFlag (Qt::Window)) { if (!l.empty ()) l += "|"; l += "Window"; }
  if (e->testFlag (Qt::Dialog)) { if (!l.empty ()) l += "|"; l += "Dialog"; }
  if (e->testFlag (Qt::Sheet)) { if (!l.empty ()) l += "|"; l += "Sheet"; }
  if (e->testFlag (Qt::Drawer)) { if (!l.empty ()) l += "|"; l += "Drawer"; }
  if (e->testFlag (Qt::Popup)) { if (!l.empty ()) l += "|"; l += "Popup"; }
  if (e->testFlag (Qt::Tool)) { if (!l.empty ()) l += "|"; l += "Tool"; }
  if (e->testFlag (Qt::ToolTip)) { if (!l.empty ()) l += "|"; l += "ToolTip"; }
  if (e->testFlag (Qt::SplashScreen)) { if (!l.empty ()) l += "|"; l += "SplashScreen"; }
  if (e->testFlag (Qt::Desktop)) { if (!l.empty ()) l += "|"; l += "Desktop"; }
  if (e->testFlag (Qt::SubWindow)) { if (!l.empty ()) l += "|"; l += "SubWindow"; }
  if (e->testFlag (Qt::WindowType_Mask)) { if (!l.empty ()) l += "|"; l += "WindowType_Mask"; }
  if (e->testFlag (Qt::MSWindowsFixedSizeDialogHint)) { if (!l.empty ()) l += "|"; l += "MSWindowsFixedSizeDialogHint"; }
  if (e->testFlag (Qt::MSWindowsOwnDC)) { if (!l.empty ()) l += "|"; l += "MSWindowsOwnDC"; }
  if (e->testFlag (Qt::X11BypassWindowManagerHint)) { if (!l.empty ()) l += "|"; l += "X11BypassWindowManagerHint"; }
  if (e->testFlag (Qt::FramelessWindowHint)) { if (!l.empty ()) l += "|"; l += "FramelessWindowHint"; }
  if (e->testFlag (Qt::WindowTitleHint)) { if (!l.empty ()) l += "|"; l += "WindowTitleHint"; }
  if (e->testFlag (Qt::WindowSystemMenuHint)) { if (!l.empty ()) l += "|"; l += "WindowSystemMenuHint"; }
  if (e->testFlag (Qt::WindowMinimizeButtonHint)) { if (!l.empty ()) l += "|"; l += "WindowMinimizeButtonHint"; }
  if (e->testFlag (Qt::WindowMaximizeButtonHint)) { if (!l.empty ()) l += "|"; l += "WindowMaximizeButtonHint"; }
  if (e->testFlag (Qt::WindowMinMaxButtonsHint)) { if (!l.empty ()) l += "|"; l += "WindowMinMaxButtonsHint"; }
  if (e->testFlag (Qt::WindowContextHelpButtonHint)) { if (!l.empty ()) l += "|"; l += "WindowContextHelpButtonHint"; }
  if (e->testFlag (Qt::WindowShadeButtonHint)) { if (!l.empty ()) l += "|"; l += "WindowShadeButtonHint"; }
  if (e->testFlag (Qt::WindowStaysOnTopHint)) { if (!l.empty ()) l += "|"; l += "WindowStaysOnTopHint"; }
  if (e->testFlag (Qt::CustomizeWindowHint)) { if (!l.empty ()) l += "|"; l += "CustomizeWindowHint"; }
  if (e->testFlag (Qt::WindowStaysOnBottomHint)) { if (!l.empty ()) l += "|"; l += "WindowStaysOnBottomHint"; }
  if (e->testFlag (Qt::WindowCloseButtonHint)) { if (!l.empty ()) l += "|"; l += "WindowCloseButtonHint"; }
  if (e->testFlag (Qt::MacWindowToolBarButtonHint)) { if (!l.empty ()) l += "|"; l += "MacWindowToolBarButtonHint"; }
  if (e->testFlag (Qt::BypassGraphicsProxyWidget)) { if (!l.empty ()) l += "|"; l += "BypassGraphicsProxyWidget"; }
  if (e->testFlag (Qt::WindowOkButtonHint)) { if (!l.empty ()) l += "|"; l += "WindowOkButtonHint"; }
  if (e->testFlag (Qt::WindowCancelButtonHint)) { if (!l.empty ()) l += "|"; l += "WindowCancelButtonHint"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_Qt_WindowType_Enums (const Qt_WindowType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_Qt_WindowType_Enums (const Qt_WindowType_Enums *e, const Qt_WindowType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::Qt_WindowType_Enums> decl_Qt_WindowType_Enums ("Qt_QFlags_WindowType",
  gsi::method_ext ("|", &qt_gsi::oropQt_WindowType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQt_WindowType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQt_WindowType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WindowType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WindowType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_Qt_WindowType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<Qt::WindowType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::Qt_WindowType_Enum> decl_Qt_WindowType_Enum (decl_Qt_WindowType_Enums, "Qt_WindowType",
  qt_gsi::mkdefs_Qt_WindowType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_Qt_WindowType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_Qt_WindowType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQt_WindowType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2Qt_WindowType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_Qt_WindowType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the Qt::WindowType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_WindowType_Enum_in_parent (qt_gsi::mkdefs_Qt_WindowType ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_WindowType_Enum_as_child (decl_Qt_WindowType_Enum, "WindowType");

}

