
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQWidget_EventAdaptor.h"
#include "gsiDeclQWidget_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QWidget::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QWidget::acceptDrops()


static void _init_f_acceptDrops_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptDrops_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->acceptDrops ());
}

static qt_gsi::GenericMethod *_create_f_acceptDrops_c0 ()
{
  return new qt_gsi::GenericMethod (":acceptDrops", "@brief Method bool QWidget::acceptDrops()\n", true, &_init_f_acceptDrops_c0, &_call_f_acceptDrops_c0);
}

// QString QWidget::accessibleDescription()


static void _init_f_accessibleDescription_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_accessibleDescription_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->accessibleDescription ());
}

static qt_gsi::GenericMethod *_create_f_accessibleDescription_c0 ()
{
  return new qt_gsi::GenericMethod (":accessibleDescription", "@brief Method QString QWidget::accessibleDescription()\n", true, &_init_f_accessibleDescription_c0, &_call_f_accessibleDescription_c0);
}

// QString QWidget::accessibleName()


static void _init_f_accessibleName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_accessibleName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->accessibleName ());
}

static qt_gsi::GenericMethod *_create_f_accessibleName_c0 ()
{
  return new qt_gsi::GenericMethod (":accessibleName", "@brief Method QString QWidget::accessibleName()\n", true, &_init_f_accessibleName_c0, &_call_f_accessibleName_c0);
}

// QList<QAction *> QWidget::actions()


static void _init_f_actions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QAction *> >::target_type > ();
}

static void _call_f_actions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QAction *> >::target_type > ((qt_gsi::Converter<QList<QAction *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QAction *> >(((QWidget *)cls)->actions ()));
}

static qt_gsi::GenericMethod *_create_f_actions_c0 ()
{
  return new qt_gsi::GenericMethod ("actions", "@brief Method QList<QAction *> QWidget::actions()\n", true, &_init_f_actions_c0, &_call_f_actions_c0);
}

// void QWidget::activateWindow()


static void _init_f_activateWindow_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_activateWindow_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->activateWindow ();
}

static qt_gsi::GenericMethod *_create_f_activateWindow_0 ()
{
  return new qt_gsi::GenericMethod ("activateWindow", "@brief Method void QWidget::activateWindow()\n", false, &_init_f_activateWindow_0, &_call_f_activateWindow_0);
}

// void QWidget::addAction(QAction *action)


static void _init_f_addAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addAction_1309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  ((QWidget *)cls)->addAction (arg1);
}

static qt_gsi::GenericMethod *_create_f_addAction_1309 ()
{
  return new qt_gsi::GenericMethod ("addAction", "@brief Method void QWidget::addAction(QAction *action)\n", false, &_init_f_addAction_1309, &_call_f_addAction_1309);
}

// void QWidget::addActions(QList<QAction *> actions)


static void _init_f_addActions_1924 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("actions");
  decl->add_arg<const qt_gsi::Converter<QList<QAction *> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addActions_1924 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QAction *> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QAction *> >::target_type & > ();
  ((QWidget *)cls)->addActions (qt_gsi::QtToCppAdaptor<QList<QAction *> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_addActions_1924 ()
{
  return new qt_gsi::GenericMethod ("addActions", "@brief Method void QWidget::addActions(QList<QAction *> actions)\n", false, &_init_f_addActions_1924, &_call_f_addActions_1924);
}

// void QWidget::adjustSize()


static void _init_f_adjustSize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_adjustSize_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->adjustSize ();
}

static qt_gsi::GenericMethod *_create_f_adjustSize_0 ()
{
  return new qt_gsi::GenericMethod ("adjustSize", "@brief Method void QWidget::adjustSize()\n", false, &_init_f_adjustSize_0, &_call_f_adjustSize_0);
}

// bool QWidget::autoFillBackground()


static void _init_f_autoFillBackground_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoFillBackground_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->autoFillBackground ());
}

static qt_gsi::GenericMethod *_create_f_autoFillBackground_c0 ()
{
  return new qt_gsi::GenericMethod (":autoFillBackground", "@brief Method bool QWidget::autoFillBackground()\n", true, &_init_f_autoFillBackground_c0, &_call_f_autoFillBackground_c0);
}

// QPalette::ColorRole QWidget::backgroundRole()


static void _init_f_backgroundRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPalette::ColorRole>::target_type > ();
}

static void _call_f_backgroundRole_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPalette::ColorRole>::target_type > ((qt_gsi::Converter<QPalette::ColorRole>::target_type)qt_gsi::CppToQtAdaptor<QPalette::ColorRole>(((QWidget *)cls)->backgroundRole ()));
}

static qt_gsi::GenericMethod *_create_f_backgroundRole_c0 ()
{
  return new qt_gsi::GenericMethod (":backgroundRole", "@brief Method QPalette::ColorRole QWidget::backgroundRole()\n", true, &_init_f_backgroundRole_c0, &_call_f_backgroundRole_c0);
}

// QSize QWidget::baseSize()


static void _init_f_baseSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_baseSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget *)cls)->baseSize ());
}

static qt_gsi::GenericMethod *_create_f_baseSize_c0 ()
{
  return new qt_gsi::GenericMethod (":baseSize", "@brief Method QSize QWidget::baseSize()\n", true, &_init_f_baseSize_c0, &_call_f_baseSize_c0);
}

// QWidget *QWidget::childAt(int x, int y)


static void _init_f_childAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_childAt_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->childAt (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_childAt_c1426 ()
{
  return new qt_gsi::GenericMethod ("childAt", "@brief Method QWidget *QWidget::childAt(int x, int y)\n", true, &_init_f_childAt_c1426, &_call_f_childAt_c1426);
}

// QWidget *QWidget::childAt(const QPoint &p)


static void _init_f_childAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_childAt_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->childAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_childAt_c1916 ()
{
  return new qt_gsi::GenericMethod ("childAt", "@brief Method QWidget *QWidget::childAt(const QPoint &p)\n", true, &_init_f_childAt_c1916, &_call_f_childAt_c1916);
}

// QRect QWidget::childrenRect()


static void _init_f_childrenRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_childrenRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QWidget *)cls)->childrenRect ());
}

static qt_gsi::GenericMethod *_create_f_childrenRect_c0 ()
{
  return new qt_gsi::GenericMethod (":childrenRect", "@brief Method QRect QWidget::childrenRect()\n", true, &_init_f_childrenRect_c0, &_call_f_childrenRect_c0);
}

// QRegion QWidget::childrenRegion()


static void _init_f_childrenRegion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_childrenRegion_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRegion > ((QRegion)((QWidget *)cls)->childrenRegion ());
}

static qt_gsi::GenericMethod *_create_f_childrenRegion_c0 ()
{
  return new qt_gsi::GenericMethod (":childrenRegion", "@brief Method QRegion QWidget::childrenRegion()\n", true, &_init_f_childrenRegion_c0, &_call_f_childrenRegion_c0);
}

// void QWidget::clearFocus()


static void _init_f_clearFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->clearFocus ();
}

static qt_gsi::GenericMethod *_create_f_clearFocus_0 ()
{
  return new qt_gsi::GenericMethod ("clearFocus", "@brief Method void QWidget::clearFocus()\n", false, &_init_f_clearFocus_0, &_call_f_clearFocus_0);
}

// void QWidget::clearMask()


static void _init_f_clearMask_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearMask_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->clearMask ();
}

static qt_gsi::GenericMethod *_create_f_clearMask_0 ()
{
  return new qt_gsi::GenericMethod ("clearMask", "@brief Method void QWidget::clearMask()\n", false, &_init_f_clearMask_0, &_call_f_clearMask_0);
}

// bool QWidget::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->close ());
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method bool QWidget::close()\n", false, &_init_f_close_0, &_call_f_close_0);
}

// QMargins QWidget::contentsMargins()


static void _init_f_contentsMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_f_contentsMargins_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMargins > ((QMargins)((QWidget *)cls)->contentsMargins ());
}

static qt_gsi::GenericMethod *_create_f_contentsMargins_c0 ()
{
  return new qt_gsi::GenericMethod (":contentsMargins", "@brief Method QMargins QWidget::contentsMargins()\n", true, &_init_f_contentsMargins_c0, &_call_f_contentsMargins_c0);
}

// QRect QWidget::contentsRect()


static void _init_f_contentsRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_contentsRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QWidget *)cls)->contentsRect ());
}

static qt_gsi::GenericMethod *_create_f_contentsRect_c0 ()
{
  return new qt_gsi::GenericMethod ("contentsRect", "@brief Method QRect QWidget::contentsRect()\n", true, &_init_f_contentsRect_c0, &_call_f_contentsRect_c0);
}

// Qt::ContextMenuPolicy QWidget::contextMenuPolicy()


static void _init_f_contextMenuPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type > ();
}

static void _call_f_contextMenuPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type > ((qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type)qt_gsi::CppToQtAdaptor<Qt::ContextMenuPolicy>(((QWidget *)cls)->contextMenuPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_contextMenuPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":contextMenuPolicy", "@brief Method Qt::ContextMenuPolicy QWidget::contextMenuPolicy()\n", true, &_init_f_contextMenuPolicy_c0, &_call_f_contextMenuPolicy_c0);
}

// void QWidget::createWinId()


static void _init_f_createWinId_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_createWinId_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->createWinId ();
}

static qt_gsi::GenericMethod *_create_f_createWinId_0 ()
{
  return new qt_gsi::GenericMethod ("createWinId", "@brief Method void QWidget::createWinId()\n", false, &_init_f_createWinId_0, &_call_f_createWinId_0);
}

// QCursor QWidget::cursor()


static void _init_f_cursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCursor > ();
}

static void _call_f_cursor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QCursor > ((QCursor)((QWidget *)cls)->cursor ());
}

static qt_gsi::GenericMethod *_create_f_cursor_c0 ()
{
  return new qt_gsi::GenericMethod (":cursor", "@brief Method QCursor QWidget::cursor()\n", true, &_init_f_cursor_c0, &_call_f_cursor_c0);
}

// WId QWidget::effectiveWinId()


static void _init_f_effectiveWinId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<WId>::target_type > ();
}

static void _call_f_effectiveWinId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<WId>::target_type > ((qt_gsi::Converter<WId>::target_type)qt_gsi::CppToQtAdaptor<WId>(((QWidget *)cls)->effectiveWinId ()));
}

static qt_gsi::GenericMethod *_create_f_effectiveWinId_c0 ()
{
  return new qt_gsi::GenericMethod ("effectiveWinId", "@brief Method WId QWidget::effectiveWinId()\n", true, &_init_f_effectiveWinId_c0, &_call_f_effectiveWinId_c0);
}

// void QWidget::ensurePolished()


static void _init_f_ensurePolished_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ensurePolished_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->ensurePolished ();
}

static qt_gsi::GenericMethod *_create_f_ensurePolished_c0 ()
{
  return new qt_gsi::GenericMethod ("ensurePolished", "@brief Method void QWidget::ensurePolished()\n", true, &_init_f_ensurePolished_c0, &_call_f_ensurePolished_c0);
}

// Qt::FocusPolicy QWidget::focusPolicy()


static void _init_f_focusPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::FocusPolicy>::target_type > ();
}

static void _call_f_focusPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::FocusPolicy>::target_type > ((qt_gsi::Converter<Qt::FocusPolicy>::target_type)qt_gsi::CppToQtAdaptor<Qt::FocusPolicy>(((QWidget *)cls)->focusPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_focusPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":focusPolicy", "@brief Method Qt::FocusPolicy QWidget::focusPolicy()\n", true, &_init_f_focusPolicy_c0, &_call_f_focusPolicy_c0);
}

// QWidget *QWidget::focusProxy()


static void _init_f_focusProxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_focusProxy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->focusProxy ());
}

static qt_gsi::GenericMethod *_create_f_focusProxy_c0 ()
{
  return new qt_gsi::GenericMethod (":focusProxy", "@brief Method QWidget *QWidget::focusProxy()\n", true, &_init_f_focusProxy_c0, &_call_f_focusProxy_c0);
}

// QWidget *QWidget::focusWidget()


static void _init_f_focusWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_focusWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->focusWidget ());
}

static qt_gsi::GenericMethod *_create_f_focusWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("focusWidget", "@brief Method QWidget *QWidget::focusWidget()\n", true, &_init_f_focusWidget_c0, &_call_f_focusWidget_c0);
}

// const QFont &QWidget::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QFont & > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QFont & > ((const QFont &)((QWidget *)cls)->font ());
}

static qt_gsi::GenericMethod *_create_f_font_c0 ()
{
  return new qt_gsi::GenericMethod (":font", "@brief Method const QFont &QWidget::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
}

// QFontInfo QWidget::fontInfo()


static void _init_f_fontInfo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFontInfo > ();
}

static void _call_f_fontInfo_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFontInfo > ((QFontInfo)((QWidget *)cls)->fontInfo ());
}

static qt_gsi::GenericMethod *_create_f_fontInfo_c0 ()
{
  return new qt_gsi::GenericMethod ("fontInfo", "@brief Method QFontInfo QWidget::fontInfo()\n", true, &_init_f_fontInfo_c0, &_call_f_fontInfo_c0);
}

// QFontMetrics QWidget::fontMetrics()


static void _init_f_fontMetrics_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFontMetrics > ();
}

static void _call_f_fontMetrics_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFontMetrics > ((QFontMetrics)((QWidget *)cls)->fontMetrics ());
}

static qt_gsi::GenericMethod *_create_f_fontMetrics_c0 ()
{
  return new qt_gsi::GenericMethod ("fontMetrics", "@brief Method QFontMetrics QWidget::fontMetrics()\n", true, &_init_f_fontMetrics_c0, &_call_f_fontMetrics_c0);
}

// QPalette::ColorRole QWidget::foregroundRole()


static void _init_f_foregroundRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPalette::ColorRole>::target_type > ();
}

static void _call_f_foregroundRole_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QPalette::ColorRole>::target_type > ((qt_gsi::Converter<QPalette::ColorRole>::target_type)qt_gsi::CppToQtAdaptor<QPalette::ColorRole>(((QWidget *)cls)->foregroundRole ()));
}

static qt_gsi::GenericMethod *_create_f_foregroundRole_c0 ()
{
  return new qt_gsi::GenericMethod (":foregroundRole", "@brief Method QPalette::ColorRole QWidget::foregroundRole()\n", true, &_init_f_foregroundRole_c0, &_call_f_foregroundRole_c0);
}

// QRect QWidget::frameGeometry()


static void _init_f_frameGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_frameGeometry_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QWidget *)cls)->frameGeometry ());
}

static qt_gsi::GenericMethod *_create_f_frameGeometry_c0 ()
{
  return new qt_gsi::GenericMethod (":frameGeometry", "@brief Method QRect QWidget::frameGeometry()\n", true, &_init_f_frameGeometry_c0, &_call_f_frameGeometry_c0);
}

// QSize QWidget::frameSize()


static void _init_f_frameSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_frameSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget *)cls)->frameSize ());
}

static qt_gsi::GenericMethod *_create_f_frameSize_c0 ()
{
  return new qt_gsi::GenericMethod (":frameSize", "@brief Method QSize QWidget::frameSize()\n", true, &_init_f_frameSize_c0, &_call_f_frameSize_c0);
}

// const QRect &QWidget::geometry()


static void _init_f_geometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QRect & > ();
}

static void _call_f_geometry_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QRect & > ((const QRect &)((QWidget *)cls)->geometry ());
}

static qt_gsi::GenericMethod *_create_f_geometry_c0 ()
{
  return new qt_gsi::GenericMethod (":geometry", "@brief Method const QRect &QWidget::geometry()\n", true, &_init_f_geometry_c0, &_call_f_geometry_c0);
}

// void QWidget::getContentsMargins(int *left, int *top, int *right, int *bottom)


static void _init_f_getContentsMargins_c3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getContentsMargins_c3488 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int *arg1 = args.read<int * > ();
  int *arg2 = args.read<int * > ();
  int *arg3 = args.read<int * > ();
  int *arg4 = args.read<int * > ();
  ((QWidget *)cls)->getContentsMargins (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_getContentsMargins_c3488 ()
{
  return new qt_gsi::GenericMethod ("getContentsMargins", "@brief Method void QWidget::getContentsMargins(int *left, int *top, int *right, int *bottom)\n", true, &_init_f_getContentsMargins_c3488, &_call_f_getContentsMargins_c3488);
}

// void QWidget::grabGesture(Qt::GestureType type, QFlags<Qt::GestureFlag> flags)


static void _init_f_grabGesture_4352 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<Qt::GestureType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::GestureFlags()");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::GestureFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_grabGesture_4352 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::GestureType>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::GestureType>::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::GestureFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::GestureFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::GestureFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::GestureFlag> >(heap, Qt::GestureFlags()));
  ((QWidget *)cls)->grabGesture (qt_gsi::QtToCppAdaptor<Qt::GestureType>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<Qt::GestureFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_grabGesture_4352 ()
{
  return new qt_gsi::GenericMethod ("grabGesture", "@brief Method void QWidget::grabGesture(Qt::GestureType type, QFlags<Qt::GestureFlag> flags)\n", false, &_init_f_grabGesture_4352, &_call_f_grabGesture_4352);
}

// void QWidget::grabKeyboard()


static void _init_f_grabKeyboard_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_grabKeyboard_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->grabKeyboard ();
}

static qt_gsi::GenericMethod *_create_f_grabKeyboard_0 ()
{
  return new qt_gsi::GenericMethod ("grabKeyboard", "@brief Method void QWidget::grabKeyboard()\n", false, &_init_f_grabKeyboard_0, &_call_f_grabKeyboard_0);
}

// void QWidget::grabMouse()


static void _init_f_grabMouse_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_grabMouse_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->grabMouse ();
}

static qt_gsi::GenericMethod *_create_f_grabMouse_0 ()
{
  return new qt_gsi::GenericMethod ("grabMouse", "@brief Method void QWidget::grabMouse()\n", false, &_init_f_grabMouse_0, &_call_f_grabMouse_0);
}

// void QWidget::grabMouse(const QCursor &)


static void _init_f_grabMouse_2032 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_grabMouse_2032 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QCursor &arg1 = args.read<const QCursor & > ();
  ((QWidget *)cls)->grabMouse (arg1);
}

static qt_gsi::GenericMethod *_create_f_grabMouse_2032 ()
{
  return new qt_gsi::GenericMethod ("grabMouse", "@brief Method void QWidget::grabMouse(const QCursor &)\n", false, &_init_f_grabMouse_2032, &_call_f_grabMouse_2032);
}

// int QWidget::grabShortcut(const QKeySequence &key, Qt::ShortcutContext context)


static void _init_f_grabShortcut_4758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QKeySequence & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("context", true, "Qt::WindowShortcut");
  decl->add_arg<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_grabShortcut_4758 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ShortcutContext>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > () : (const qt_gsi::Converter<Qt::ShortcutContext>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ShortcutContext>(heap, Qt::WindowShortcut));
  ret.write<int > ((int)((QWidget *)cls)->grabShortcut (arg1, qt_gsi::QtToCppAdaptor<Qt::ShortcutContext>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_grabShortcut_4758 ()
{
  return new qt_gsi::GenericMethod ("grabShortcut", "@brief Method int QWidget::grabShortcut(const QKeySequence &key, Qt::ShortcutContext context)\n", false, &_init_f_grabShortcut_4758, &_call_f_grabShortcut_4758);
}

// QGraphicsEffect *QWidget::graphicsEffect()


static void _init_f_graphicsEffect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsEffect * > ();
}

static void _call_f_graphicsEffect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsEffect * > ((QGraphicsEffect *)((QWidget *)cls)->graphicsEffect ());
}

static qt_gsi::GenericMethod *_create_f_graphicsEffect_c0 ()
{
  return new qt_gsi::GenericMethod (":graphicsEffect", "@brief Method QGraphicsEffect *QWidget::graphicsEffect()\n", true, &_init_f_graphicsEffect_c0, &_call_f_graphicsEffect_c0);
}

// QGraphicsProxyWidget *QWidget::graphicsProxyWidget()


static void _init_f_graphicsProxyWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsProxyWidget * > ();
}

static void _call_f_graphicsProxyWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsProxyWidget * > ((QGraphicsProxyWidget *)((QWidget *)cls)->graphicsProxyWidget ());
}

static qt_gsi::GenericMethod *_create_f_graphicsProxyWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("graphicsProxyWidget", "@brief Method QGraphicsProxyWidget *QWidget::graphicsProxyWidget()\n", true, &_init_f_graphicsProxyWidget_c0, &_call_f_graphicsProxyWidget_c0);
}

// bool QWidget::hasFocus()


static void _init_f_hasFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFocus_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->hasFocus ());
}

static qt_gsi::GenericMethod *_create_f_hasFocus_c0 ()
{
  return new qt_gsi::GenericMethod ("hasFocus|:focus", "@brief Method bool QWidget::hasFocus()\n", true, &_init_f_hasFocus_c0, &_call_f_hasFocus_c0);
}

// bool QWidget::hasMouseTracking()


static void _init_f_hasMouseTracking_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasMouseTracking_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->hasMouseTracking ());
}

static qt_gsi::GenericMethod *_create_f_hasMouseTracking_c0 ()
{
  return new qt_gsi::GenericMethod ("hasMouseTracking|:mouseTracking", "@brief Method bool QWidget::hasMouseTracking()\n", true, &_init_f_hasMouseTracking_c0, &_call_f_hasMouseTracking_c0);
}

// int QWidget::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWidget *)cls)->height ());
}

static qt_gsi::GenericMethod *_create_f_height_c0 ()
{
  return new qt_gsi::GenericMethod (":height", "@brief Method int QWidget::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
}

// int QWidget::heightForWidth(int)


static void _init_f_heightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_heightForWidth_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QWidget *)cls)->heightForWidth (arg1));
}

static qt_gsi::GenericMethod *_create_f_heightForWidth_c767 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Method int QWidget::heightForWidth(int)\n", true, &_init_f_heightForWidth_c767, &_call_f_heightForWidth_c767);
}

// void QWidget::hide()


static void _init_f_hide_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hide_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->hide ();
}

static qt_gsi::GenericMethod *_create_f_hide_0 ()
{
  return new qt_gsi::GenericMethod ("hide", "@brief Method void QWidget::hide()\n", false, &_init_f_hide_0, &_call_f_hide_0);
}

// QInputContext *QWidget::inputContext()


static void _init_f_inputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QInputContext * > ();
}

static void _call_f_inputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QInputContext * > ((QInputContext *)((QWidget *)cls)->inputContext ());
}

static qt_gsi::GenericMethod *_create_f_inputContext_0 ()
{
  return new qt_gsi::GenericMethod (":inputContext", "@brief Method QInputContext *QWidget::inputContext()\n", false, &_init_f_inputContext_0, &_call_f_inputContext_0);
}

// QFlags<Qt::InputMethodHint> QWidget::inputMethodHints()


static void _init_f_inputMethodHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type > ();
}

static void _call_f_inputMethodHints_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type > ((qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::InputMethodHint> >(((QWidget *)cls)->inputMethodHints ()));
}

static qt_gsi::GenericMethod *_create_f_inputMethodHints_c0 ()
{
  return new qt_gsi::GenericMethod (":inputMethodHints", "@brief Method QFlags<Qt::InputMethodHint> QWidget::inputMethodHints()\n", true, &_init_f_inputMethodHints_c0, &_call_f_inputMethodHints_c0);
}

// QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QWidget *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_inputMethodQuery_c2420 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)\n", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
}

// void QWidget::insertAction(QAction *before, QAction *action)


static void _init_f_insertAction_2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<QAction * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertAction_2510 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  QAction *arg2 = args.read<QAction * > ();
  ((QWidget *)cls)->insertAction (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertAction_2510 ()
{
  return new qt_gsi::GenericMethod ("insertAction", "@brief Method void QWidget::insertAction(QAction *before, QAction *action)\n", false, &_init_f_insertAction_2510, &_call_f_insertAction_2510);
}

// void QWidget::insertActions(QAction *before, QList<QAction *> actions)


static void _init_f_insertActions_3125 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("actions");
  decl->add_arg<const qt_gsi::Converter<QList<QAction *> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertActions_3125 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  const qt_gsi::Converter<QList<QAction *> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QAction *> >::target_type & > ();
  ((QWidget *)cls)->insertActions (arg1, qt_gsi::QtToCppAdaptor<QList<QAction *> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_insertActions_3125 ()
{
  return new qt_gsi::GenericMethod ("insertActions", "@brief Method void QWidget::insertActions(QAction *before, QList<QAction *> actions)\n", false, &_init_f_insertActions_3125, &_call_f_insertActions_3125);
}

// WId QWidget::internalWinId()


static void _init_f_internalWinId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<WId>::target_type > ();
}

static void _call_f_internalWinId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<WId>::target_type > ((qt_gsi::Converter<WId>::target_type)qt_gsi::CppToQtAdaptor<WId>(((QWidget *)cls)->internalWinId ()));
}

static qt_gsi::GenericMethod *_create_f_internalWinId_c0 ()
{
  return new qt_gsi::GenericMethod ("internalWinId", "@brief Method WId QWidget::internalWinId()\n", true, &_init_f_internalWinId_c0, &_call_f_internalWinId_c0);
}

// bool QWidget::isActiveWindow()


static void _init_f_isActiveWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActiveWindow_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isActiveWindow ());
}

static qt_gsi::GenericMethod *_create_f_isActiveWindow_c0 ()
{
  return new qt_gsi::GenericMethod ("isActiveWindow?|:isActiveWindow", "@brief Method bool QWidget::isActiveWindow()\n", true, &_init_f_isActiveWindow_c0, &_call_f_isActiveWindow_c0);
}

// bool QWidget::isAncestorOf(const QWidget *child)


static void _init_f_isAncestorOf_c2010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isAncestorOf_c2010 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QWidget *arg1 = args.read<const QWidget * > ();
  ret.write<bool > ((bool)((QWidget *)cls)->isAncestorOf (arg1));
}

static qt_gsi::GenericMethod *_create_f_isAncestorOf_c2010 ()
{
  return new qt_gsi::GenericMethod ("isAncestorOf?", "@brief Method bool QWidget::isAncestorOf(const QWidget *child)\n", true, &_init_f_isAncestorOf_c2010, &_call_f_isAncestorOf_c2010);
}

// bool QWidget::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QWidget::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
}

// bool QWidget::isEnabledTo(QWidget *)


static void _init_f_isEnabledTo_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isEnabledTo_c1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<bool > ((bool)((QWidget *)cls)->isEnabledTo (arg1));
}

static qt_gsi::GenericMethod *_create_f_isEnabledTo_c1315 ()
{
  return new qt_gsi::GenericMethod ("isEnabledTo?", "@brief Method bool QWidget::isEnabledTo(QWidget *)\n", true, &_init_f_isEnabledTo_c1315, &_call_f_isEnabledTo_c1315);
}

// bool QWidget::isEnabledToTLW()


static void _init_f_isEnabledToTLW_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabledToTLW_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isEnabledToTLW ());
}

static qt_gsi::GenericMethod *_create_f_isEnabledToTLW_c0 ()
{
  return new qt_gsi::GenericMethod ("isEnabledToTLW?", "@brief Method bool QWidget::isEnabledToTLW()\n", true, &_init_f_isEnabledToTLW_c0, &_call_f_isEnabledToTLW_c0);
}

// bool QWidget::isFullScreen()


static void _init_f_isFullScreen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFullScreen_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isFullScreen ());
}

static qt_gsi::GenericMethod *_create_f_isFullScreen_c0 ()
{
  return new qt_gsi::GenericMethod ("isFullScreen?|:fullScreen", "@brief Method bool QWidget::isFullScreen()\n", true, &_init_f_isFullScreen_c0, &_call_f_isFullScreen_c0);
}

// bool QWidget::isHidden()


static void _init_f_isHidden_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isHidden_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isHidden ());
}

static qt_gsi::GenericMethod *_create_f_isHidden_c0 ()
{
  return new qt_gsi::GenericMethod ("isHidden?|:hidden", "@brief Method bool QWidget::isHidden()\n", true, &_init_f_isHidden_c0, &_call_f_isHidden_c0);
}

// bool QWidget::isLeftToRight()


static void _init_f_isLeftToRight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLeftToRight_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isLeftToRight ());
}

static qt_gsi::GenericMethod *_create_f_isLeftToRight_c0 ()
{
  return new qt_gsi::GenericMethod ("isLeftToRight?", "@brief Method bool QWidget::isLeftToRight()\n", true, &_init_f_isLeftToRight_c0, &_call_f_isLeftToRight_c0);
}

// bool QWidget::isMaximized()


static void _init_f_isMaximized_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMaximized_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isMaximized ());
}

static qt_gsi::GenericMethod *_create_f_isMaximized_c0 ()
{
  return new qt_gsi::GenericMethod ("isMaximized?|:maximized", "@brief Method bool QWidget::isMaximized()\n", true, &_init_f_isMaximized_c0, &_call_f_isMaximized_c0);
}

// bool QWidget::isMinimized()


static void _init_f_isMinimized_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMinimized_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isMinimized ());
}

static qt_gsi::GenericMethod *_create_f_isMinimized_c0 ()
{
  return new qt_gsi::GenericMethod ("isMinimized?|:minimized", "@brief Method bool QWidget::isMinimized()\n", true, &_init_f_isMinimized_c0, &_call_f_isMinimized_c0);
}

// bool QWidget::isModal()


static void _init_f_isModal_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isModal_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isModal ());
}

static qt_gsi::GenericMethod *_create_f_isModal_c0 ()
{
  return new qt_gsi::GenericMethod ("isModal?|:modal", "@brief Method bool QWidget::isModal()\n", true, &_init_f_isModal_c0, &_call_f_isModal_c0);
}

// bool QWidget::isRightToLeft()


static void _init_f_isRightToLeft_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRightToLeft_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isRightToLeft ());
}

static qt_gsi::GenericMethod *_create_f_isRightToLeft_c0 ()
{
  return new qt_gsi::GenericMethod ("isRightToLeft?", "@brief Method bool QWidget::isRightToLeft()\n", true, &_init_f_isRightToLeft_c0, &_call_f_isRightToLeft_c0);
}

// bool QWidget::isTopLevel()


static void _init_f_isTopLevel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTopLevel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isTopLevel ());
}

static qt_gsi::GenericMethod *_create_f_isTopLevel_c0 ()
{
  return new qt_gsi::GenericMethod ("isTopLevel?", "@brief Method bool QWidget::isTopLevel()\n", true, &_init_f_isTopLevel_c0, &_call_f_isTopLevel_c0);
}

// bool QWidget::isVisible()


static void _init_f_isVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVisible_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isVisible ());
}

static qt_gsi::GenericMethod *_create_f_isVisible_c0 ()
{
  return new qt_gsi::GenericMethod ("isVisible?|:visible", "@brief Method bool QWidget::isVisible()\n", true, &_init_f_isVisible_c0, &_call_f_isVisible_c0);
}

// bool QWidget::isVisibleTo(QWidget *)


static void _init_f_isVisibleTo_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isVisibleTo_c1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<bool > ((bool)((QWidget *)cls)->isVisibleTo (arg1));
}

static qt_gsi::GenericMethod *_create_f_isVisibleTo_c1315 ()
{
  return new qt_gsi::GenericMethod ("isVisibleTo?", "@brief Method bool QWidget::isVisibleTo(QWidget *)\n", true, &_init_f_isVisibleTo_c1315, &_call_f_isVisibleTo_c1315);
}

// bool QWidget::isWindow()


static void _init_f_isWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWindow_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isWindow ());
}

static qt_gsi::GenericMethod *_create_f_isWindow_c0 ()
{
  return new qt_gsi::GenericMethod ("isWindow?", "@brief Method bool QWidget::isWindow()\n", true, &_init_f_isWindow_c0, &_call_f_isWindow_c0);
}

// bool QWidget::isWindowModified()


static void _init_f_isWindowModified_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWindowModified_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->isWindowModified ());
}

static qt_gsi::GenericMethod *_create_f_isWindowModified_c0 ()
{
  return new qt_gsi::GenericMethod ("isWindowModified?|:windowModified", "@brief Method bool QWidget::isWindowModified()\n", true, &_init_f_isWindowModified_c0, &_call_f_isWindowModified_c0);
}

// QLayout *QWidget::layout()


static void _init_f_layout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_f_layout_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLayout * > ((QLayout *)((QWidget *)cls)->layout ());
}

static qt_gsi::GenericMethod *_create_f_layout_c0 ()
{
  return new qt_gsi::GenericMethod (":layout", "@brief Method QLayout *QWidget::layout()\n", true, &_init_f_layout_c0, &_call_f_layout_c0);
}

// Qt::LayoutDirection QWidget::layoutDirection()


static void _init_f_layoutDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(((QWidget *)cls)->layoutDirection ()));
}

static qt_gsi::GenericMethod *_create_f_layoutDirection_c0 ()
{
  return new qt_gsi::GenericMethod (":layoutDirection", "@brief Method Qt::LayoutDirection QWidget::layoutDirection()\n", true, &_init_f_layoutDirection_c0, &_call_f_layoutDirection_c0);
}

// QLocale QWidget::locale()


static void _init_f_locale_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_locale_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLocale > ((QLocale)((QWidget *)cls)->locale ());
}

static qt_gsi::GenericMethod *_create_f_locale_c0 ()
{
  return new qt_gsi::GenericMethod (":locale", "@brief Method QLocale QWidget::locale()\n", true, &_init_f_locale_c0, &_call_f_locale_c0);
}

// void QWidget::lower()


static void _init_f_lower_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_lower_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->lower ();
}

static qt_gsi::GenericMethod *_create_f_lower_0 ()
{
  return new qt_gsi::GenericMethod ("lower", "@brief Method void QWidget::lower()\n", false, &_init_f_lower_0, &_call_f_lower_0);
}

// QPoint QWidget::mapFrom(QWidget *, const QPoint &)


static void _init_f_mapFrom_c3123 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFrom_c3123 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QPoint &arg2 = args.read<const QPoint & > ();
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapFrom (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapFrom_c3123 ()
{
  return new qt_gsi::GenericMethod ("mapFrom", "@brief Method QPoint QWidget::mapFrom(QWidget *, const QPoint &)\n", true, &_init_f_mapFrom_c3123, &_call_f_mapFrom_c3123);
}

// QPoint QWidget::mapFromGlobal(const QPoint &)


static void _init_f_mapFromGlobal_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFromGlobal_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapFromGlobal (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromGlobal_c1916 ()
{
  return new qt_gsi::GenericMethod ("mapFromGlobal", "@brief Method QPoint QWidget::mapFromGlobal(const QPoint &)\n", true, &_init_f_mapFromGlobal_c1916, &_call_f_mapFromGlobal_c1916);
}

// QPoint QWidget::mapFromParent(const QPoint &)


static void _init_f_mapFromParent_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFromParent_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapFromParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromParent_c1916 ()
{
  return new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPoint QWidget::mapFromParent(const QPoint &)\n", true, &_init_f_mapFromParent_c1916, &_call_f_mapFromParent_c1916);
}

// QPoint QWidget::mapTo(QWidget *, const QPoint &)


static void _init_f_mapTo_c3123 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return<QPoint > ();
}

static void _call_f_mapTo_c3123 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QPoint &arg2 = args.read<const QPoint & > ();
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapTo (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapTo_c3123 ()
{
  return new qt_gsi::GenericMethod ("mapTo", "@brief Method QPoint QWidget::mapTo(QWidget *, const QPoint &)\n", true, &_init_f_mapTo_c3123, &_call_f_mapTo_c3123);
}

// QPoint QWidget::mapToGlobal(const QPoint &)


static void _init_f_mapToGlobal_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapToGlobal_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapToGlobal (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToGlobal_c1916 ()
{
  return new qt_gsi::GenericMethod ("mapToGlobal", "@brief Method QPoint QWidget::mapToGlobal(const QPoint &)\n", true, &_init_f_mapToGlobal_c1916, &_call_f_mapToGlobal_c1916);
}

// QPoint QWidget::mapToParent(const QPoint &)


static void _init_f_mapToParent_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapToParent_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->mapToParent (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToParent_c1916 ()
{
  return new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPoint QWidget::mapToParent(const QPoint &)\n", true, &_init_f_mapToParent_c1916, &_call_f_mapToParent_c1916);
}

// QRegion QWidget::mask()


static void _init_f_mask_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_mask_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRegion > ((QRegion)((QWidget *)cls)->mask ());
}

static qt_gsi::GenericMethod *_create_f_mask_c0 ()
{
  return new qt_gsi::GenericMethod ("mask", "@brief Method QRegion QWidget::mask()\n", true, &_init_f_mask_c0, &_call_f_mask_c0);
}

// int QWidget::maximumHeight()


static void _init_f_maximumHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumHeight_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWidget *)cls)->maximumHeight ());
}

static qt_gsi::GenericMethod *_create_f_maximumHeight_c0 ()
{
  return new qt_gsi::GenericMethod (":maximumHeight", "@brief Method int QWidget::maximumHeight()\n", true, &_init_f_maximumHeight_c0, &_call_f_maximumHeight_c0);
}

// QSize QWidget::maximumSize()


static void _init_f_maximumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_maximumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget *)cls)->maximumSize ());
}

static qt_gsi::GenericMethod *_create_f_maximumSize_c0 ()
{
  return new qt_gsi::GenericMethod (":maximumSize", "@brief Method QSize QWidget::maximumSize()\n", true, &_init_f_maximumSize_c0, &_call_f_maximumSize_c0);
}

// int QWidget::maximumWidth()


static void _init_f_maximumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWidget *)cls)->maximumWidth ());
}

static qt_gsi::GenericMethod *_create_f_maximumWidth_c0 ()
{
  return new qt_gsi::GenericMethod (":maximumWidth", "@brief Method int QWidget::maximumWidth()\n", true, &_init_f_maximumWidth_c0, &_call_f_maximumWidth_c0);
}

// int QWidget::minimumHeight()


static void _init_f_minimumHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumHeight_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWidget *)cls)->minimumHeight ());
}

static qt_gsi::GenericMethod *_create_f_minimumHeight_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumHeight", "@brief Method int QWidget::minimumHeight()\n", true, &_init_f_minimumHeight_c0, &_call_f_minimumHeight_c0);
}

// QSize QWidget::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget *)cls)->minimumSize ());
}

static qt_gsi::GenericMethod *_create_f_minimumSize_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumSize", "@brief Method QSize QWidget::minimumSize()\n", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
}

// QSize QWidget::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget *)cls)->minimumSizeHint ());
}

static qt_gsi::GenericMethod *_create_f_minimumSizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QWidget::minimumSizeHint()\n", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
}

// int QWidget::minimumWidth()


static void _init_f_minimumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWidget *)cls)->minimumWidth ());
}

static qt_gsi::GenericMethod *_create_f_minimumWidth_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumWidth", "@brief Method int QWidget::minimumWidth()\n", true, &_init_f_minimumWidth_c0, &_call_f_minimumWidth_c0);
}

// void QWidget::move(int x, int y)


static void _init_f_move_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_move_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QWidget *)cls)->move (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_move_1426 ()
{
  return new qt_gsi::GenericMethod ("move", "@brief Method void QWidget::move(int x, int y)\n", false, &_init_f_move_1426, &_call_f_move_1426);
}

// void QWidget::move(const QPoint &)


static void _init_f_move_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_move_1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ((QWidget *)cls)->move (arg1);
}

static qt_gsi::GenericMethod *_create_f_move_1916 ()
{
  return new qt_gsi::GenericMethod ("move", "@brief Method void QWidget::move(const QPoint &)\n", false, &_init_f_move_1916, &_call_f_move_1916);
}

// QWidget *QWidget::nativeParentWidget()


static void _init_f_nativeParentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_nativeParentWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->nativeParentWidget ());
}

static qt_gsi::GenericMethod *_create_f_nativeParentWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("nativeParentWidget", "@brief Method QWidget *QWidget::nativeParentWidget()\n", true, &_init_f_nativeParentWidget_c0, &_call_f_nativeParentWidget_c0);
}

// QWidget *QWidget::nextInFocusChain()


static void _init_f_nextInFocusChain_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_nextInFocusChain_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->nextInFocusChain ());
}

static qt_gsi::GenericMethod *_create_f_nextInFocusChain_c0 ()
{
  return new qt_gsi::GenericMethod ("nextInFocusChain", "@brief Method QWidget *QWidget::nextInFocusChain()\n", true, &_init_f_nextInFocusChain_c0, &_call_f_nextInFocusChain_c0);
}

// QRect QWidget::normalGeometry()


static void _init_f_normalGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_normalGeometry_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QWidget *)cls)->normalGeometry ());
}

static qt_gsi::GenericMethod *_create_f_normalGeometry_c0 ()
{
  return new qt_gsi::GenericMethod (":normalGeometry", "@brief Method QRect QWidget::normalGeometry()\n", true, &_init_f_normalGeometry_c0, &_call_f_normalGeometry_c0);
}

// void QWidget::overrideWindowFlags(QFlags<Qt::WindowType> type)


static void _init_f_overrideWindowFlags_2495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_overrideWindowFlags_2495 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > ();
  ((QWidget *)cls)->overrideWindowFlags (qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_overrideWindowFlags_2495 ()
{
  return new qt_gsi::GenericMethod ("overrideWindowFlags", "@brief Method void QWidget::overrideWindowFlags(QFlags<Qt::WindowType> type)\n", false, &_init_f_overrideWindowFlags_2495, &_call_f_overrideWindowFlags_2495);
}

// void QWidget::overrideWindowState(QFlags<Qt::WindowState> state)


static void _init_f_overrideWindowState_2590 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowState> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_overrideWindowState_2590 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::WindowState> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::WindowState> >::target_type & > ();
  ((QWidget *)cls)->overrideWindowState (qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowState> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_overrideWindowState_2590 ()
{
  return new qt_gsi::GenericMethod ("overrideWindowState", "@brief Method void QWidget::overrideWindowState(QFlags<Qt::WindowState> state)\n", false, &_init_f_overrideWindowState_2590, &_call_f_overrideWindowState_2590);
}

// QPaintEngine *QWidget::paintEngine()


static void _init_f_paintEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_f_paintEngine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QWidget *)cls)->paintEngine ());
}

static qt_gsi::GenericMethod *_create_f_paintEngine_c0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Method QPaintEngine *QWidget::paintEngine()\nThis is a reimplementation of QPaintDevice::paintEngine", true, &_init_f_paintEngine_c0, &_call_f_paintEngine_c0);
}

// const QPalette &QWidget::palette()


static void _init_f_palette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPalette & > ();
}

static void _call_f_palette_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QPalette & > ((const QPalette &)((QWidget *)cls)->palette ());
}

static qt_gsi::GenericMethod *_create_f_palette_c0 ()
{
  return new qt_gsi::GenericMethod (":palette", "@brief Method const QPalette &QWidget::palette()\n", true, &_init_f_palette_c0, &_call_f_palette_c0);
}

// QWidget *QWidget::parentWidget()


static void _init_f_parentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_parentWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->parentWidget ());
}

static qt_gsi::GenericMethod *_create_f_parentWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("parentWidget", "@brief Method QWidget *QWidget::parentWidget()\n", true, &_init_f_parentWidget_c0, &_call_f_parentWidget_c0);
}

// QPoint QWidget::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QWidget *)cls)->pos ());
}

static qt_gsi::GenericMethod *_create_f_pos_c0 ()
{
  return new qt_gsi::GenericMethod (":pos", "@brief Method QPoint QWidget::pos()\n", true, &_init_f_pos_c0, &_call_f_pos_c0);
}

// QWidget *QWidget::previousInFocusChain()


static void _init_f_previousInFocusChain_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_previousInFocusChain_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->previousInFocusChain ());
}

static qt_gsi::GenericMethod *_create_f_previousInFocusChain_c0 ()
{
  return new qt_gsi::GenericMethod ("previousInFocusChain", "@brief Method QWidget *QWidget::previousInFocusChain()\n", true, &_init_f_previousInFocusChain_c0, &_call_f_previousInFocusChain_c0);
}

// void QWidget::raise()


static void _init_f_raise_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_raise_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->raise ();
}

static qt_gsi::GenericMethod *_create_f_raise_0 ()
{
  return new qt_gsi::GenericMethod ("qt_raise", "@brief Method void QWidget::raise()\n", false, &_init_f_raise_0, &_call_f_raise_0);
}

// QRect QWidget::rect()


static void _init_f_rect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_rect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QWidget *)cls)->rect ());
}

static qt_gsi::GenericMethod *_create_f_rect_c0 ()
{
  return new qt_gsi::GenericMethod (":rect", "@brief Method QRect QWidget::rect()\n", true, &_init_f_rect_c0, &_call_f_rect_c0);
}

// void QWidget::releaseKeyboard()


static void _init_f_releaseKeyboard_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_releaseKeyboard_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->releaseKeyboard ();
}

static qt_gsi::GenericMethod *_create_f_releaseKeyboard_0 ()
{
  return new qt_gsi::GenericMethod ("releaseKeyboard", "@brief Method void QWidget::releaseKeyboard()\n", false, &_init_f_releaseKeyboard_0, &_call_f_releaseKeyboard_0);
}

// void QWidget::releaseMouse()


static void _init_f_releaseMouse_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_releaseMouse_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->releaseMouse ();
}

static qt_gsi::GenericMethod *_create_f_releaseMouse_0 ()
{
  return new qt_gsi::GenericMethod ("releaseMouse", "@brief Method void QWidget::releaseMouse()\n", false, &_init_f_releaseMouse_0, &_call_f_releaseMouse_0);
}

// void QWidget::releaseShortcut(int id)


static void _init_f_releaseShortcut_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_releaseShortcut_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWidget *)cls)->releaseShortcut (arg1);
}

static qt_gsi::GenericMethod *_create_f_releaseShortcut_767 ()
{
  return new qt_gsi::GenericMethod ("releaseShortcut", "@brief Method void QWidget::releaseShortcut(int id)\n", false, &_init_f_releaseShortcut_767, &_call_f_releaseShortcut_767);
}

// void QWidget::removeAction(QAction *action)


static void _init_f_removeAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAction_1309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  ((QWidget *)cls)->removeAction (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeAction_1309 ()
{
  return new qt_gsi::GenericMethod ("removeAction", "@brief Method void QWidget::removeAction(QAction *action)\n", false, &_init_f_removeAction_1309, &_call_f_removeAction_1309);
}

// void QWidget::render(QPaintDevice *target, const QPoint &targetOffset, const QRegion &sourceRegion, QFlags<QWidget::RenderFlag> renderFlags)


static void _init_f_render_8328 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QPaintDevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("targetOffset", true, "QPoint()");
  decl->add_arg<const QPoint & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRegion", true, "QRegion()");
  decl->add_arg<const QRegion & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("renderFlags", true, "QWidget::RenderFlags(QWidget::DrawWindowBackground | QWidget::DrawChildren)");
  decl->add_arg<const qt_gsi::Converter<QFlags<QWidget::RenderFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_render_8328 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintDevice *arg1 = args.read<QPaintDevice * > ();
  const QPoint &arg2 = args ? args.read<const QPoint & > () : (const QPoint &)(QPoint());
  const QRegion &arg3 = args ? args.read<const QRegion & > () : (const QRegion &)(QRegion());
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QWidget::RenderFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QWidget::RenderFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QWidget::RenderFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QWidget::RenderFlag> >(heap, QWidget::RenderFlags(QWidget::DrawWindowBackground | QWidget::DrawChildren)));
  ((QWidget *)cls)->render (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<QWidget::RenderFlag> >(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_render_8328 ()
{
  return new qt_gsi::GenericMethod ("render", "@brief Method void QWidget::render(QPaintDevice *target, const QPoint &targetOffset, const QRegion &sourceRegion, QFlags<QWidget::RenderFlag> renderFlags)\n", false, &_init_f_render_8328, &_call_f_render_8328);
}

// void QWidget::render(QPainter *painter, const QPoint &targetOffset, const QRegion &sourceRegion, QFlags<QWidget::RenderFlag> renderFlags)


static void _init_f_render_7951 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("targetOffset", true, "QPoint()");
  decl->add_arg<const QPoint & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceRegion", true, "QRegion()");
  decl->add_arg<const QRegion & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("renderFlags", true, "QWidget::RenderFlags(QWidget::DrawWindowBackground | QWidget::DrawChildren)");
  decl->add_arg<const qt_gsi::Converter<QFlags<QWidget::RenderFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_render_7951 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QPoint &arg2 = args ? args.read<const QPoint & > () : (const QPoint &)(QPoint());
  const QRegion &arg3 = args ? args.read<const QRegion & > () : (const QRegion &)(QRegion());
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QWidget::RenderFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QWidget::RenderFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QWidget::RenderFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QWidget::RenderFlag> >(heap, QWidget::RenderFlags(QWidget::DrawWindowBackground | QWidget::DrawChildren)));
  ((QWidget *)cls)->render (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<QWidget::RenderFlag> >(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_render_7951 ()
{
  return new qt_gsi::GenericMethod ("render", "@brief Method void QWidget::render(QPainter *painter, const QPoint &targetOffset, const QRegion &sourceRegion, QFlags<QWidget::RenderFlag> renderFlags)\n", false, &_init_f_render_7951, &_call_f_render_7951);
}

// void QWidget::repaint()


static void _init_f_repaint_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_repaint_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->repaint ();
}

static qt_gsi::GenericMethod *_create_f_repaint_0 ()
{
  return new qt_gsi::GenericMethod ("repaint", "@brief Method void QWidget::repaint()\n", false, &_init_f_repaint_0, &_call_f_repaint_0);
}

// void QWidget::repaint(int x, int y, int w, int h)


static void _init_f_repaint_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_repaint_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QWidget *)cls)->repaint (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_repaint_2744 ()
{
  return new qt_gsi::GenericMethod ("repaint", "@brief Method void QWidget::repaint(int x, int y, int w, int h)\n", false, &_init_f_repaint_2744, &_call_f_repaint_2744);
}

// void QWidget::repaint(const QRect &)


static void _init_f_repaint_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_repaint_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QWidget *)cls)->repaint (arg1);
}

static qt_gsi::GenericMethod *_create_f_repaint_1792 ()
{
  return new qt_gsi::GenericMethod ("repaint", "@brief Method void QWidget::repaint(const QRect &)\n", false, &_init_f_repaint_1792, &_call_f_repaint_1792);
}

// void QWidget::repaint(const QRegion &)


static void _init_f_repaint_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_repaint_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QWidget *)cls)->repaint (arg1);
}

static qt_gsi::GenericMethod *_create_f_repaint_2006 ()
{
  return new qt_gsi::GenericMethod ("repaint", "@brief Method void QWidget::repaint(const QRegion &)\n", false, &_init_f_repaint_2006, &_call_f_repaint_2006);
}

// void QWidget::resize(int w, int h)


static void _init_f_resize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_resize_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QWidget *)cls)->resize (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_resize_1426 ()
{
  return new qt_gsi::GenericMethod ("resize", "@brief Method void QWidget::resize(int w, int h)\n", false, &_init_f_resize_1426, &_call_f_resize_1426);
}

// void QWidget::resize(const QSize &)


static void _init_f_resize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QWidget *)cls)->resize (arg1);
}

static qt_gsi::GenericMethod *_create_f_resize_1805 ()
{
  return new qt_gsi::GenericMethod ("resize", "@brief Method void QWidget::resize(const QSize &)\n", false, &_init_f_resize_1805, &_call_f_resize_1805);
}

// bool QWidget::restoreGeometry(const QByteArray &geometry)


static void _init_f_restoreGeometry_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("geometry");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_restoreGeometry_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<bool > ((bool)((QWidget *)cls)->restoreGeometry (arg1));
}

static qt_gsi::GenericMethod *_create_f_restoreGeometry_2309 ()
{
  return new qt_gsi::GenericMethod ("restoreGeometry", "@brief Method bool QWidget::restoreGeometry(const QByteArray &geometry)\n", false, &_init_f_restoreGeometry_2309, &_call_f_restoreGeometry_2309);
}

// QByteArray QWidget::saveGeometry()


static void _init_f_saveGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_saveGeometry_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QWidget *)cls)->saveGeometry ());
}

static qt_gsi::GenericMethod *_create_f_saveGeometry_c0 ()
{
  return new qt_gsi::GenericMethod ("saveGeometry", "@brief Method QByteArray QWidget::saveGeometry()\n", true, &_init_f_saveGeometry_c0, &_call_f_saveGeometry_c0);
}

// void QWidget::scroll(int dx, int dy)


static void _init_f_scroll_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scroll_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QWidget *)cls)->scroll (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_scroll_1426 ()
{
  return new qt_gsi::GenericMethod ("scroll", "@brief Method void QWidget::scroll(int dx, int dy)\n", false, &_init_f_scroll_1426, &_call_f_scroll_1426);
}

// void QWidget::scroll(int dx, int dy, const QRect &)


static void _init_f_scroll_3110 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arg3");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_scroll_3110 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QRect &arg3 = args.read<const QRect & > ();
  ((QWidget *)cls)->scroll (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_scroll_3110 ()
{
  return new qt_gsi::GenericMethod ("scroll", "@brief Method void QWidget::scroll(int dx, int dy, const QRect &)\n", false, &_init_f_scroll_3110, &_call_f_scroll_3110);
}

// void QWidget::setAcceptDrops(bool on)


static void _init_f_setAcceptDrops_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("on");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptDrops_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setAcceptDrops (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAcceptDrops_864 ()
{
  return new qt_gsi::GenericMethod ("setAcceptDrops|acceptDrops=", "@brief Method void QWidget::setAcceptDrops(bool on)\n", false, &_init_f_setAcceptDrops_864, &_call_f_setAcceptDrops_864);
}

// void QWidget::setAccessibleDescription(const QString &description)


static void _init_f_setAccessibleDescription_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("description");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAccessibleDescription_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setAccessibleDescription (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAccessibleDescription_2025 ()
{
  return new qt_gsi::GenericMethod ("setAccessibleDescription|accessibleDescription=", "@brief Method void QWidget::setAccessibleDescription(const QString &description)\n", false, &_init_f_setAccessibleDescription_2025, &_call_f_setAccessibleDescription_2025);
}

// void QWidget::setAccessibleName(const QString &name)


static void _init_f_setAccessibleName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAccessibleName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setAccessibleName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAccessibleName_2025 ()
{
  return new qt_gsi::GenericMethod ("setAccessibleName|accessibleName=", "@brief Method void QWidget::setAccessibleName(const QString &name)\n", false, &_init_f_setAccessibleName_2025, &_call_f_setAccessibleName_2025);
}

// void QWidget::setAttribute(Qt::WidgetAttribute, bool on)


static void _init_f_setAttribute_3065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAttribute_3065 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QWidget *)cls)->setAttribute (qt_gsi::QtToCppAdaptor<Qt::WidgetAttribute>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setAttribute_3065 ()
{
  return new qt_gsi::GenericMethod ("setAttribute", "@brief Method void QWidget::setAttribute(Qt::WidgetAttribute, bool on)\n", false, &_init_f_setAttribute_3065, &_call_f_setAttribute_3065);
}

// void QWidget::setAutoFillBackground(bool enabled)


static void _init_f_setAutoFillBackground_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoFillBackground_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setAutoFillBackground (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoFillBackground_864 ()
{
  return new qt_gsi::GenericMethod ("setAutoFillBackground|autoFillBackground=", "@brief Method void QWidget::setAutoFillBackground(bool enabled)\n", false, &_init_f_setAutoFillBackground_864, &_call_f_setAutoFillBackground_864);
}

// void QWidget::setBackgroundRole(QPalette::ColorRole)


static void _init_f_setBackgroundRole_2265 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundRole_2265 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  ((QWidget *)cls)->setBackgroundRole (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setBackgroundRole_2265 ()
{
  return new qt_gsi::GenericMethod ("setBackgroundRole|backgroundRole=", "@brief Method void QWidget::setBackgroundRole(QPalette::ColorRole)\n", false, &_init_f_setBackgroundRole_2265, &_call_f_setBackgroundRole_2265);
}

// void QWidget::setBaseSize(const QSize &)


static void _init_f_setBaseSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBaseSize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QWidget *)cls)->setBaseSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBaseSize_1805 ()
{
  return new qt_gsi::GenericMethod ("setBaseSize|baseSize=", "@brief Method void QWidget::setBaseSize(const QSize &)\n", false, &_init_f_setBaseSize_1805, &_call_f_setBaseSize_1805);
}

// void QWidget::setBaseSize(int basew, int baseh)


static void _init_f_setBaseSize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("basew");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("baseh");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setBaseSize_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QWidget *)cls)->setBaseSize (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setBaseSize_1426 ()
{
  return new qt_gsi::GenericMethod ("setBaseSize", "@brief Method void QWidget::setBaseSize(int basew, int baseh)\n", false, &_init_f_setBaseSize_1426, &_call_f_setBaseSize_1426);
}

// void QWidget::setContentsMargins(int left, int top, int right, int bottom)


static void _init_f_setContentsMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setContentsMargins_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QWidget *)cls)->setContentsMargins (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setContentsMargins_2744 ()
{
  return new qt_gsi::GenericMethod ("setContentsMargins", "@brief Method void QWidget::setContentsMargins(int left, int top, int right, int bottom)\n", false, &_init_f_setContentsMargins_2744, &_call_f_setContentsMargins_2744);
}

// void QWidget::setContentsMargins(const QMargins &margins)


static void _init_f_setContentsMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContentsMargins_2115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMargins &arg1 = args.read<const QMargins & > ();
  ((QWidget *)cls)->setContentsMargins (arg1);
}

static qt_gsi::GenericMethod *_create_f_setContentsMargins_2115 ()
{
  return new qt_gsi::GenericMethod ("setContentsMargins|contentsMargins=", "@brief Method void QWidget::setContentsMargins(const QMargins &margins)\n", false, &_init_f_setContentsMargins_2115, &_call_f_setContentsMargins_2115);
}

// void QWidget::setContextMenuPolicy(Qt::ContextMenuPolicy policy)


static void _init_f_setContextMenuPolicy_2519 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContextMenuPolicy_2519 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::ContextMenuPolicy>::target_type & > ();
  ((QWidget *)cls)->setContextMenuPolicy (qt_gsi::QtToCppAdaptor<Qt::ContextMenuPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setContextMenuPolicy_2519 ()
{
  return new qt_gsi::GenericMethod ("setContextMenuPolicy|contextMenuPolicy=", "@brief Method void QWidget::setContextMenuPolicy(Qt::ContextMenuPolicy policy)\n", false, &_init_f_setContextMenuPolicy_2519, &_call_f_setContextMenuPolicy_2519);
}

// void QWidget::setCursor(const QCursor &)


static void _init_f_setCursor_2032 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursor_2032 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QCursor &arg1 = args.read<const QCursor & > ();
  ((QWidget *)cls)->setCursor (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCursor_2032 ()
{
  return new qt_gsi::GenericMethod ("setCursor|cursor=", "@brief Method void QWidget::setCursor(const QCursor &)\n", false, &_init_f_setCursor_2032, &_call_f_setCursor_2032);
}

// void QWidget::setDisabled(bool)


static void _init_f_setDisabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDisabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setDisabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDisabled_864 ()
{
  return new qt_gsi::GenericMethod ("setDisabled", "@brief Method void QWidget::setDisabled(bool)\n", false, &_init_f_setDisabled_864, &_call_f_setDisabled_864);
}

// void QWidget::setEnabled(bool)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QWidget::setEnabled(bool)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
}

// void QWidget::setFixedHeight(int h)


static void _init_f_setFixedHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFixedHeight_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWidget *)cls)->setFixedHeight (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFixedHeight_767 ()
{
  return new qt_gsi::GenericMethod ("setFixedHeight", "@brief Method void QWidget::setFixedHeight(int h)\n", false, &_init_f_setFixedHeight_767, &_call_f_setFixedHeight_767);
}

// void QWidget::setFixedSize(const QSize &)


static void _init_f_setFixedSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFixedSize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QWidget *)cls)->setFixedSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFixedSize_1805 ()
{
  return new qt_gsi::GenericMethod ("setFixedSize", "@brief Method void QWidget::setFixedSize(const QSize &)\n", false, &_init_f_setFixedSize_1805, &_call_f_setFixedSize_1805);
}

// void QWidget::setFixedSize(int w, int h)


static void _init_f_setFixedSize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFixedSize_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QWidget *)cls)->setFixedSize (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setFixedSize_1426 ()
{
  return new qt_gsi::GenericMethod ("setFixedSize", "@brief Method void QWidget::setFixedSize(int w, int h)\n", false, &_init_f_setFixedSize_1426, &_call_f_setFixedSize_1426);
}

// void QWidget::setFixedWidth(int w)


static void _init_f_setFixedWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFixedWidth_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWidget *)cls)->setFixedWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFixedWidth_767 ()
{
  return new qt_gsi::GenericMethod ("setFixedWidth", "@brief Method void QWidget::setFixedWidth(int w)\n", false, &_init_f_setFixedWidth_767, &_call_f_setFixedWidth_767);
}

// void QWidget::setFocus()


static void _init_f_setFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->setFocus ();
}

static qt_gsi::GenericMethod *_create_f_setFocus_0 ()
{
  return new qt_gsi::GenericMethod ("setFocus", "@brief Method void QWidget::setFocus()\n", false, &_init_f_setFocus_0, &_call_f_setFocus_0);
}

// void QWidget::setFocus(Qt::FocusReason reason)


static void _init_f_setFocus_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("reason");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusReason>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocus_1877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::FocusReason>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::FocusReason>::target_type & > ();
  ((QWidget *)cls)->setFocus (qt_gsi::QtToCppAdaptor<Qt::FocusReason>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFocus_1877 ()
{
  return new qt_gsi::GenericMethod ("setFocus", "@brief Method void QWidget::setFocus(Qt::FocusReason reason)\n", false, &_init_f_setFocus_1877, &_call_f_setFocus_1877);
}

// void QWidget::setFocusPolicy(Qt::FocusPolicy policy)


static void _init_f_setFocusPolicy_1885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusPolicy_1885 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::FocusPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::FocusPolicy>::target_type & > ();
  ((QWidget *)cls)->setFocusPolicy (qt_gsi::QtToCppAdaptor<Qt::FocusPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFocusPolicy_1885 ()
{
  return new qt_gsi::GenericMethod ("setFocusPolicy|focusPolicy=", "@brief Method void QWidget::setFocusPolicy(Qt::FocusPolicy policy)\n", false, &_init_f_setFocusPolicy_1885, &_call_f_setFocusPolicy_1885);
}

// void QWidget::setFocusProxy(QWidget *)


static void _init_f_setFocusProxy_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusProxy_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QWidget *)cls)->setFocusProxy (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFocusProxy_1315 ()
{
  return new qt_gsi::GenericMethod ("setFocusProxy|focusProxy=", "@brief Method void QWidget::setFocusProxy(QWidget *)\n", false, &_init_f_setFocusProxy_1315, &_call_f_setFocusProxy_1315);
}

// void QWidget::setFont(const QFont &)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QWidget *)cls)->setFont (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFont_1801 ()
{
  return new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QWidget::setFont(const QFont &)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
}

// void QWidget::setForegroundRole(QPalette::ColorRole)


static void _init_f_setForegroundRole_2265 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForegroundRole_2265 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg1 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  ((QWidget *)cls)->setForegroundRole (qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setForegroundRole_2265 ()
{
  return new qt_gsi::GenericMethod ("setForegroundRole|foregroundRole=", "@brief Method void QWidget::setForegroundRole(QPalette::ColorRole)\n", false, &_init_f_setForegroundRole_2265, &_call_f_setForegroundRole_2265);
}

// void QWidget::setGeometry(int x, int y, int w, int h)


static void _init_f_setGeometry_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QWidget *)cls)->setGeometry (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setGeometry_2744 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@brief Method void QWidget::setGeometry(int x, int y, int w, int h)\n", false, &_init_f_setGeometry_2744, &_call_f_setGeometry_2744);
}

// void QWidget::setGeometry(const QRect &)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QWidget *)cls)->setGeometry (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGeometry_1792 ()
{
  return new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QWidget::setGeometry(const QRect &)\n", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
}

// void QWidget::setGraphicsEffect(QGraphicsEffect *effect)


static void _init_f_setGraphicsEffect_2109 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("effect");
  decl->add_arg<QGraphicsEffect * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGraphicsEffect_2109 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsEffect *arg1 = args.read<QGraphicsEffect * > ();
  ((QWidget *)cls)->setGraphicsEffect (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGraphicsEffect_2109 ()
{
  return new qt_gsi::GenericMethod ("setGraphicsEffect|graphicsEffect=", "@brief Method void QWidget::setGraphicsEffect(QGraphicsEffect *effect)\n", false, &_init_f_setGraphicsEffect_2109, &_call_f_setGraphicsEffect_2109);
}

// void QWidget::setHidden(bool hidden)


static void _init_f_setHidden_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hidden");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHidden_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setHidden (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHidden_864 ()
{
  return new qt_gsi::GenericMethod ("setHidden|hidden=", "@brief Method void QWidget::setHidden(bool hidden)\n", false, &_init_f_setHidden_864, &_call_f_setHidden_864);
}

// void QWidget::setInputContext(QInputContext *)


static void _init_f_setInputContext_1972 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputContext * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputContext_1972 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputContext *arg1 = args.read<QInputContext * > ();
  ((QWidget *)cls)->setInputContext (arg1);
}

static qt_gsi::GenericMethod *_create_f_setInputContext_1972 ()
{
  return new qt_gsi::GenericMethod ("setInputContext|inputContext=", "@brief Method void QWidget::setInputContext(QInputContext *)\n", false, &_init_f_setInputContext_1972, &_call_f_setInputContext_1972);
}

// void QWidget::setInputMethodHints(QFlags<Qt::InputMethodHint> hints)


static void _init_f_setInputMethodHints_2985 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputMethodHints_2985 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::InputMethodHint> >::target_type & > ();
  ((QWidget *)cls)->setInputMethodHints (qt_gsi::QtToCppAdaptor<QFlags<Qt::InputMethodHint> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setInputMethodHints_2985 ()
{
  return new qt_gsi::GenericMethod ("setInputMethodHints|inputMethodHints=", "@brief Method void QWidget::setInputMethodHints(QFlags<Qt::InputMethodHint> hints)\n", false, &_init_f_setInputMethodHints_2985, &_call_f_setInputMethodHints_2985);
}

// void QWidget::setLayout(QLayout *)


static void _init_f_setLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayout_1341 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  ((QWidget *)cls)->setLayout (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLayout_1341 ()
{
  return new qt_gsi::GenericMethod ("setLayout|layout=", "@brief Method void QWidget::setLayout(QLayout *)\n", false, &_init_f_setLayout_1341, &_call_f_setLayout_1341);
}

// void QWidget::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ();
  ((QWidget *)cls)->setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setLayoutDirection_2316 ()
{
  return new qt_gsi::GenericMethod ("setLayoutDirection|layoutDirection=", "@brief Method void QWidget::setLayoutDirection(Qt::LayoutDirection direction)\n", false, &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
}

// void QWidget::setLocale(const QLocale &locale)


static void _init_f_setLocale_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLocale_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLocale &arg1 = args.read<const QLocale & > ();
  ((QWidget *)cls)->setLocale (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLocale_1986 ()
{
  return new qt_gsi::GenericMethod ("setLocale|locale=", "@brief Method void QWidget::setLocale(const QLocale &locale)\n", false, &_init_f_setLocale_1986, &_call_f_setLocale_1986);
}

// void QWidget::setMask(const QBitmap &)


static void _init_f_setMask_1999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QBitmap & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMask_1999 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBitmap &arg1 = args.read<const QBitmap & > ();
  ((QWidget *)cls)->setMask (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMask_1999 ()
{
  return new qt_gsi::GenericMethod ("setMask", "@brief Method void QWidget::setMask(const QBitmap &)\n", false, &_init_f_setMask_1999, &_call_f_setMask_1999);
}

// void QWidget::setMask(const QRegion &)


static void _init_f_setMask_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMask_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QWidget *)cls)->setMask (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMask_2006 ()
{
  return new qt_gsi::GenericMethod ("setMask", "@brief Method void QWidget::setMask(const QRegion &)\n", false, &_init_f_setMask_2006, &_call_f_setMask_2006);
}

// void QWidget::setMaximumHeight(int maxh)


static void _init_f_setMaximumHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxh");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumHeight_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWidget *)cls)->setMaximumHeight (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMaximumHeight_767 ()
{
  return new qt_gsi::GenericMethod ("setMaximumHeight|maximumHeight=", "@brief Method void QWidget::setMaximumHeight(int maxh)\n", false, &_init_f_setMaximumHeight_767, &_call_f_setMaximumHeight_767);
}

// void QWidget::setMaximumSize(const QSize &)


static void _init_f_setMaximumSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumSize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QWidget *)cls)->setMaximumSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMaximumSize_1805 ()
{
  return new qt_gsi::GenericMethod ("setMaximumSize|maximumSize=", "@brief Method void QWidget::setMaximumSize(const QSize &)\n", false, &_init_f_setMaximumSize_1805, &_call_f_setMaximumSize_1805);
}

// void QWidget::setMaximumSize(int maxw, int maxh)


static void _init_f_setMaximumSize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxw");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("maxh");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMaximumSize_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QWidget *)cls)->setMaximumSize (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setMaximumSize_1426 ()
{
  return new qt_gsi::GenericMethod ("setMaximumSize", "@brief Method void QWidget::setMaximumSize(int maxw, int maxh)\n", false, &_init_f_setMaximumSize_1426, &_call_f_setMaximumSize_1426);
}

// void QWidget::setMaximumWidth(int maxw)


static void _init_f_setMaximumWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxw");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumWidth_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWidget *)cls)->setMaximumWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMaximumWidth_767 ()
{
  return new qt_gsi::GenericMethod ("setMaximumWidth|maximumWidth=", "@brief Method void QWidget::setMaximumWidth(int maxw)\n", false, &_init_f_setMaximumWidth_767, &_call_f_setMaximumWidth_767);
}

// void QWidget::setMinimumHeight(int minh)


static void _init_f_setMinimumHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minh");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumHeight_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWidget *)cls)->setMinimumHeight (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMinimumHeight_767 ()
{
  return new qt_gsi::GenericMethod ("setMinimumHeight|minimumHeight=", "@brief Method void QWidget::setMinimumHeight(int minh)\n", false, &_init_f_setMinimumHeight_767, &_call_f_setMinimumHeight_767);
}

// void QWidget::setMinimumSize(const QSize &)


static void _init_f_setMinimumSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumSize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QWidget *)cls)->setMinimumSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMinimumSize_1805 ()
{
  return new qt_gsi::GenericMethod ("setMinimumSize|minimumSize=", "@brief Method void QWidget::setMinimumSize(const QSize &)\n", false, &_init_f_setMinimumSize_1805, &_call_f_setMinimumSize_1805);
}

// void QWidget::setMinimumSize(int minw, int minh)


static void _init_f_setMinimumSize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minw");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("minh");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMinimumSize_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QWidget *)cls)->setMinimumSize (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setMinimumSize_1426 ()
{
  return new qt_gsi::GenericMethod ("setMinimumSize", "@brief Method void QWidget::setMinimumSize(int minw, int minh)\n", false, &_init_f_setMinimumSize_1426, &_call_f_setMinimumSize_1426);
}

// void QWidget::setMinimumWidth(int minw)


static void _init_f_setMinimumWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minw");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumWidth_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWidget *)cls)->setMinimumWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMinimumWidth_767 ()
{
  return new qt_gsi::GenericMethod ("setMinimumWidth|minimumWidth=", "@brief Method void QWidget::setMinimumWidth(int minw)\n", false, &_init_f_setMinimumWidth_767, &_call_f_setMinimumWidth_767);
}

// void QWidget::setMouseTracking(bool enable)


static void _init_f_setMouseTracking_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMouseTracking_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setMouseTracking (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMouseTracking_864 ()
{
  return new qt_gsi::GenericMethod ("setMouseTracking|mouseTracking=", "@brief Method void QWidget::setMouseTracking(bool enable)\n", false, &_init_f_setMouseTracking_864, &_call_f_setMouseTracking_864);
}

// void QWidget::setPalette(const QPalette &)


static void _init_f_setPalette_2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPalette_2113 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QWidget *)cls)->setPalette (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPalette_2113 ()
{
  return new qt_gsi::GenericMethod ("setPalette|palette=", "@brief Method void QWidget::setPalette(const QPalette &)\n", false, &_init_f_setPalette_2113, &_call_f_setPalette_2113);
}

// void QWidget::setParent(QWidget *parent)


static void _init_f_setParent_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setParent_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QWidget *)cls)->setParent (arg1);
}

static qt_gsi::GenericMethod *_create_f_setParent_1315 ()
{
  return new qt_gsi::GenericMethod ("setParent", "@brief Method void QWidget::setParent(QWidget *parent)\n", false, &_init_f_setParent_1315, &_call_f_setParent_1315);
}

// void QWidget::setParent(QWidget *parent, QFlags<Qt::WindowType> f)


static void _init_f_setParent_3702 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setParent_3702 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > ();
  ((QWidget *)cls)->setParent (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setParent_3702 ()
{
  return new qt_gsi::GenericMethod ("setParent", "@brief Method void QWidget::setParent(QWidget *parent, QFlags<Qt::WindowType> f)\n", false, &_init_f_setParent_3702, &_call_f_setParent_3702);
}

// void QWidget::setShortcutAutoRepeat(int id, bool enable)


static void _init_f_setShortcutAutoRepeat_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enable", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setShortcutAutoRepeat_1523 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QWidget *)cls)->setShortcutAutoRepeat (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setShortcutAutoRepeat_1523 ()
{
  return new qt_gsi::GenericMethod ("setShortcutAutoRepeat", "@brief Method void QWidget::setShortcutAutoRepeat(int id, bool enable)\n", false, &_init_f_setShortcutAutoRepeat_1523, &_call_f_setShortcutAutoRepeat_1523);
}

// void QWidget::setShortcutEnabled(int id, bool enable)


static void _init_f_setShortcutEnabled_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enable", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setShortcutEnabled_1523 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QWidget *)cls)->setShortcutEnabled (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setShortcutEnabled_1523 ()
{
  return new qt_gsi::GenericMethod ("setShortcutEnabled", "@brief Method void QWidget::setShortcutEnabled(int id, bool enable)\n", false, &_init_f_setShortcutEnabled_1523, &_call_f_setShortcutEnabled_1523);
}

// void QWidget::setShown(bool shown)


static void _init_f_setShown_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("shown");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setShown_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setShown (arg1);
}

static qt_gsi::GenericMethod *_create_f_setShown_864 ()
{
  return new qt_gsi::GenericMethod ("setShown", "@brief Method void QWidget::setShown(bool shown)\n", false, &_init_f_setShown_864, &_call_f_setShown_864);
}

// void QWidget::setSizeIncrement(const QSize &)


static void _init_f_setSizeIncrement_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizeIncrement_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QWidget *)cls)->setSizeIncrement (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSizeIncrement_1805 ()
{
  return new qt_gsi::GenericMethod ("setSizeIncrement|sizeIncrement=", "@brief Method void QWidget::setSizeIncrement(const QSize &)\n", false, &_init_f_setSizeIncrement_1805, &_call_f_setSizeIncrement_1805);
}

// void QWidget::setSizeIncrement(int w, int h)


static void _init_f_setSizeIncrement_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSizeIncrement_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QWidget *)cls)->setSizeIncrement (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setSizeIncrement_1426 ()
{
  return new qt_gsi::GenericMethod ("setSizeIncrement", "@brief Method void QWidget::setSizeIncrement(int w, int h)\n", false, &_init_f_setSizeIncrement_1426, &_call_f_setSizeIncrement_1426);
}

// void QWidget::setSizePolicy(QSizePolicy)


static void _init_f_setSizePolicy_1552 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QSizePolicy > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizePolicy_1552 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QSizePolicy arg1 = args.read<QSizePolicy > ();
  ((QWidget *)cls)->setSizePolicy (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSizePolicy_1552 ()
{
  return new qt_gsi::GenericMethod ("setSizePolicy|sizePolicy=", "@brief Method void QWidget::setSizePolicy(QSizePolicy)\n", false, &_init_f_setSizePolicy_1552, &_call_f_setSizePolicy_1552);
}

// void QWidget::setSizePolicy(QSizePolicy::Policy horizontal, QSizePolicy::Policy vertical)


static void _init_f_setSizePolicy_4476 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("horizontal");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vertical");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSizePolicy_4476 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSizePolicy::Policy>::target_type & arg1 = args.read<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & > ();
  const qt_gsi::Converter<QSizePolicy::Policy>::target_type & arg2 = args.read<const qt_gsi::Converter<QSizePolicy::Policy>::target_type & > ();
  ((QWidget *)cls)->setSizePolicy (qt_gsi::QtToCppAdaptor<QSizePolicy::Policy>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::Policy>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setSizePolicy_4476 ()
{
  return new qt_gsi::GenericMethod ("setSizePolicy", "@brief Method void QWidget::setSizePolicy(QSizePolicy::Policy horizontal, QSizePolicy::Policy vertical)\n", false, &_init_f_setSizePolicy_4476, &_call_f_setSizePolicy_4476);
}

// void QWidget::setStatusTip(const QString &)


static void _init_f_setStatusTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatusTip_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setStatusTip (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStatusTip_2025 ()
{
  return new qt_gsi::GenericMethod ("setStatusTip|statusTip=", "@brief Method void QWidget::setStatusTip(const QString &)\n", false, &_init_f_setStatusTip_2025, &_call_f_setStatusTip_2025);
}

// void QWidget::setStyle(QStyle *)


static void _init_f_setStyle_1232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1232 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle *arg1 = args.read<QStyle * > ();
  ((QWidget *)cls)->setStyle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStyle_1232 ()
{
  return new qt_gsi::GenericMethod ("setStyle|style=", "@brief Method void QWidget::setStyle(QStyle *)\n", false, &_init_f_setStyle_1232, &_call_f_setStyle_1232);
}

// void QWidget::setStyleSheet(const QString &styleSheet)


static void _init_f_setStyleSheet_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("styleSheet");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyleSheet_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setStyleSheet (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStyleSheet_2025 ()
{
  return new qt_gsi::GenericMethod ("setStyleSheet|styleSheet=", "@brief Method void QWidget::setStyleSheet(const QString &styleSheet)\n", false, &_init_f_setStyleSheet_2025, &_call_f_setStyleSheet_2025);
}

// void QWidget::setToolTip(const QString &)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setToolTip (arg1);
}

static qt_gsi::GenericMethod *_create_f_setToolTip_2025 ()
{
  return new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QWidget::setToolTip(const QString &)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
}

// void QWidget::setUpdatesEnabled(bool enable)


static void _init_f_setUpdatesEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUpdatesEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setUpdatesEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUpdatesEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setUpdatesEnabled|updatesEnabled=", "@brief Method void QWidget::setUpdatesEnabled(bool enable)\n", false, &_init_f_setUpdatesEnabled_864, &_call_f_setUpdatesEnabled_864);
}

// void QWidget::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QWidget::setVisible(bool visible)\n", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
}

// void QWidget::setWhatsThis(const QString &)


static void _init_f_setWhatsThis_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWhatsThis_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setWhatsThis (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWhatsThis_2025 ()
{
  return new qt_gsi::GenericMethod ("setWhatsThis|whatsThis=", "@brief Method void QWidget::setWhatsThis(const QString &)\n", false, &_init_f_setWhatsThis_2025, &_call_f_setWhatsThis_2025);
}

// void QWidget::setWindowFilePath(const QString &filePath)


static void _init_f_setWindowFilePath_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filePath");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowFilePath_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setWindowFilePath (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindowFilePath_2025 ()
{
  return new qt_gsi::GenericMethod ("setWindowFilePath|windowFilePath=", "@brief Method void QWidget::setWindowFilePath(const QString &filePath)\n", false, &_init_f_setWindowFilePath_2025, &_call_f_setWindowFilePath_2025);
}

// void QWidget::setWindowFlags(QFlags<Qt::WindowType> type)


static void _init_f_setWindowFlags_2495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowFlags_2495 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > ();
  ((QWidget *)cls)->setWindowFlags (qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setWindowFlags_2495 ()
{
  return new qt_gsi::GenericMethod ("setWindowFlags|windowFlags=", "@brief Method void QWidget::setWindowFlags(QFlags<Qt::WindowType> type)\n", false, &_init_f_setWindowFlags_2495, &_call_f_setWindowFlags_2495);
}

// void QWidget::setWindowIcon(const QIcon &icon)


static void _init_f_setWindowIcon_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowIcon_1787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  ((QWidget *)cls)->setWindowIcon (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindowIcon_1787 ()
{
  return new qt_gsi::GenericMethod ("setWindowIcon|windowIcon=", "@brief Method void QWidget::setWindowIcon(const QIcon &icon)\n", false, &_init_f_setWindowIcon_1787, &_call_f_setWindowIcon_1787);
}

// void QWidget::setWindowIconText(const QString &)


static void _init_f_setWindowIconText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowIconText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setWindowIconText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindowIconText_2025 ()
{
  return new qt_gsi::GenericMethod ("setWindowIconText|windowIconText=", "@brief Method void QWidget::setWindowIconText(const QString &)\n", false, &_init_f_setWindowIconText_2025, &_call_f_setWindowIconText_2025);
}

// void QWidget::setWindowModality(Qt::WindowModality windowModality)


static void _init_f_setWindowModality_2216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowModality");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowModality_2216 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::WindowModality>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::WindowModality>::target_type & > ();
  ((QWidget *)cls)->setWindowModality (qt_gsi::QtToCppAdaptor<Qt::WindowModality>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setWindowModality_2216 ()
{
  return new qt_gsi::GenericMethod ("setWindowModality|windowModality=", "@brief Method void QWidget::setWindowModality(Qt::WindowModality windowModality)\n", false, &_init_f_setWindowModality_2216, &_call_f_setWindowModality_2216);
}

// void QWidget::setWindowModified(bool)


static void _init_f_setWindowModified_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowModified_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget *)cls)->setWindowModified (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindowModified_864 ()
{
  return new qt_gsi::GenericMethod ("setWindowModified|windowModified=", "@brief Method void QWidget::setWindowModified(bool)\n", false, &_init_f_setWindowModified_864, &_call_f_setWindowModified_864);
}

// void QWidget::setWindowOpacity(double level)


static void _init_f_setWindowOpacity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("level");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowOpacity_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QWidget *)cls)->setWindowOpacity (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindowOpacity_1071 ()
{
  return new qt_gsi::GenericMethod ("setWindowOpacity|windowOpacity=", "@brief Method void QWidget::setWindowOpacity(double level)\n", false, &_init_f_setWindowOpacity_1071, &_call_f_setWindowOpacity_1071);
}

// void QWidget::setWindowRole(const QString &)


static void _init_f_setWindowRole_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowRole_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setWindowRole (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindowRole_2025 ()
{
  return new qt_gsi::GenericMethod ("setWindowRole|windowRole=", "@brief Method void QWidget::setWindowRole(const QString &)\n", false, &_init_f_setWindowRole_2025, &_call_f_setWindowRole_2025);
}

// void QWidget::setWindowState(QFlags<Qt::WindowState> state)


static void _init_f_setWindowState_2590 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowState> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowState_2590 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::WindowState> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::WindowState> >::target_type & > ();
  ((QWidget *)cls)->setWindowState (qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowState> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setWindowState_2590 ()
{
  return new qt_gsi::GenericMethod ("setWindowState|windowState=", "@brief Method void QWidget::setWindowState(QFlags<Qt::WindowState> state)\n", false, &_init_f_setWindowState_2590, &_call_f_setWindowState_2590);
}

// void QWidget::setWindowTitle(const QString &)


static void _init_f_setWindowTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowTitle_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QWidget *)cls)->setWindowTitle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindowTitle_2025 ()
{
  return new qt_gsi::GenericMethod ("setWindowTitle|windowTitle=", "@brief Method void QWidget::setWindowTitle(const QString &)\n", false, &_init_f_setWindowTitle_2025, &_call_f_setWindowTitle_2025);
}

// void QWidget::show()


static void _init_f_show_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_show_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->show ();
}

static qt_gsi::GenericMethod *_create_f_show_0 ()
{
  return new qt_gsi::GenericMethod ("show", "@brief Method void QWidget::show()\n", false, &_init_f_show_0, &_call_f_show_0);
}

// void QWidget::showFullScreen()


static void _init_f_showFullScreen_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showFullScreen_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->showFullScreen ();
}

static qt_gsi::GenericMethod *_create_f_showFullScreen_0 ()
{
  return new qt_gsi::GenericMethod ("showFullScreen", "@brief Method void QWidget::showFullScreen()\n", false, &_init_f_showFullScreen_0, &_call_f_showFullScreen_0);
}

// void QWidget::showMaximized()


static void _init_f_showMaximized_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showMaximized_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->showMaximized ();
}

static qt_gsi::GenericMethod *_create_f_showMaximized_0 ()
{
  return new qt_gsi::GenericMethod ("showMaximized", "@brief Method void QWidget::showMaximized()\n", false, &_init_f_showMaximized_0, &_call_f_showMaximized_0);
}

// void QWidget::showMinimized()


static void _init_f_showMinimized_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showMinimized_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->showMinimized ();
}

static qt_gsi::GenericMethod *_create_f_showMinimized_0 ()
{
  return new qt_gsi::GenericMethod ("showMinimized", "@brief Method void QWidget::showMinimized()\n", false, &_init_f_showMinimized_0, &_call_f_showMinimized_0);
}

// void QWidget::showNormal()


static void _init_f_showNormal_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showNormal_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->showNormal ();
}

static qt_gsi::GenericMethod *_create_f_showNormal_0 ()
{
  return new qt_gsi::GenericMethod ("showNormal", "@brief Method void QWidget::showNormal()\n", false, &_init_f_showNormal_0, &_call_f_showNormal_0);
}

// QSize QWidget::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod (":size", "@brief Method QSize QWidget::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// QSize QWidget::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QWidget::sizeHint()\n", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// QSize QWidget::sizeIncrement()


static void _init_f_sizeIncrement_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeIncrement_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget *)cls)->sizeIncrement ());
}

static qt_gsi::GenericMethod *_create_f_sizeIncrement_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeIncrement", "@brief Method QSize QWidget::sizeIncrement()\n", true, &_init_f_sizeIncrement_c0, &_call_f_sizeIncrement_c0);
}

// QSizePolicy QWidget::sizePolicy()


static void _init_f_sizePolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizePolicy > ();
}

static void _call_f_sizePolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizePolicy > ((QSizePolicy)((QWidget *)cls)->sizePolicy ());
}

static qt_gsi::GenericMethod *_create_f_sizePolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":sizePolicy", "@brief Method QSizePolicy QWidget::sizePolicy()\n", true, &_init_f_sizePolicy_c0, &_call_f_sizePolicy_c0);
}

// void QWidget::stackUnder(QWidget *)


static void _init_f_stackUnder_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stackUnder_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QWidget *)cls)->stackUnder (arg1);
}

static qt_gsi::GenericMethod *_create_f_stackUnder_1315 ()
{
  return new qt_gsi::GenericMethod ("stackUnder", "@brief Method void QWidget::stackUnder(QWidget *)\n", false, &_init_f_stackUnder_1315, &_call_f_stackUnder_1315);
}

// QString QWidget::statusTip()


static void _init_f_statusTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_statusTip_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->statusTip ());
}

static qt_gsi::GenericMethod *_create_f_statusTip_c0 ()
{
  return new qt_gsi::GenericMethod (":statusTip", "@brief Method QString QWidget::statusTip()\n", true, &_init_f_statusTip_c0, &_call_f_statusTip_c0);
}

// QStyle *QWidget::style()


static void _init_f_style_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyle * > ();
}

static void _call_f_style_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyle * > ((QStyle *)((QWidget *)cls)->style ());
}

static qt_gsi::GenericMethod *_create_f_style_c0 ()
{
  return new qt_gsi::GenericMethod (":style", "@brief Method QStyle *QWidget::style()\n", true, &_init_f_style_c0, &_call_f_style_c0);
}

// QString QWidget::styleSheet()


static void _init_f_styleSheet_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_styleSheet_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->styleSheet ());
}

static qt_gsi::GenericMethod *_create_f_styleSheet_c0 ()
{
  return new qt_gsi::GenericMethod (":styleSheet", "@brief Method QString QWidget::styleSheet()\n", true, &_init_f_styleSheet_c0, &_call_f_styleSheet_c0);
}

// bool QWidget::testAttribute(Qt::WidgetAttribute)


static void _init_f_testAttribute_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testAttribute_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > ();
  ret.write<bool > ((bool)((QWidget *)cls)->testAttribute (qt_gsi::QtToCppAdaptor<Qt::WidgetAttribute>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_testAttribute_c2309 ()
{
  return new qt_gsi::GenericMethod ("testAttribute", "@brief Method bool QWidget::testAttribute(Qt::WidgetAttribute)\n", true, &_init_f_testAttribute_c2309, &_call_f_testAttribute_c2309);
}

// QString QWidget::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->toolTip ());
}

static qt_gsi::GenericMethod *_create_f_toolTip_c0 ()
{
  return new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QWidget::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
}

// QWidget *QWidget::topLevelWidget()


static void _init_f_topLevelWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_topLevelWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->topLevelWidget ());
}

static qt_gsi::GenericMethod *_create_f_topLevelWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("topLevelWidget", "@brief Method QWidget *QWidget::topLevelWidget()\n", true, &_init_f_topLevelWidget_c0, &_call_f_topLevelWidget_c0);
}

// bool QWidget::underMouse()


static void _init_f_underMouse_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_underMouse_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->underMouse ());
}

static qt_gsi::GenericMethod *_create_f_underMouse_c0 ()
{
  return new qt_gsi::GenericMethod ("underMouse", "@brief Method bool QWidget::underMouse()\n", true, &_init_f_underMouse_c0, &_call_f_underMouse_c0);
}

// void QWidget::ungrabGesture(Qt::GestureType type)


static void _init_f_ungrabGesture_1902 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<Qt::GestureType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ungrabGesture_1902 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::GestureType>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::GestureType>::target_type & > ();
  ((QWidget *)cls)->ungrabGesture (qt_gsi::QtToCppAdaptor<Qt::GestureType>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_ungrabGesture_1902 ()
{
  return new qt_gsi::GenericMethod ("ungrabGesture", "@brief Method void QWidget::ungrabGesture(Qt::GestureType type)\n", false, &_init_f_ungrabGesture_1902, &_call_f_ungrabGesture_1902);
}

// void QWidget::unsetCursor()


static void _init_f_unsetCursor_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetCursor_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->unsetCursor ();
}

static qt_gsi::GenericMethod *_create_f_unsetCursor_0 ()
{
  return new qt_gsi::GenericMethod ("unsetCursor", "@brief Method void QWidget::unsetCursor()\n", false, &_init_f_unsetCursor_0, &_call_f_unsetCursor_0);
}

// void QWidget::unsetLayoutDirection()


static void _init_f_unsetLayoutDirection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetLayoutDirection_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->unsetLayoutDirection ();
}

static qt_gsi::GenericMethod *_create_f_unsetLayoutDirection_0 ()
{
  return new qt_gsi::GenericMethod ("unsetLayoutDirection", "@brief Method void QWidget::unsetLayoutDirection()\n", false, &_init_f_unsetLayoutDirection_0, &_call_f_unsetLayoutDirection_0);
}

// void QWidget::unsetLocale()


static void _init_f_unsetLocale_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetLocale_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->unsetLocale ();
}

static qt_gsi::GenericMethod *_create_f_unsetLocale_0 ()
{
  return new qt_gsi::GenericMethod ("unsetLocale", "@brief Method void QWidget::unsetLocale()\n", false, &_init_f_unsetLocale_0, &_call_f_unsetLocale_0);
}

// void QWidget::update()


static void _init_f_update_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_update_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->update ();
}

static qt_gsi::GenericMethod *_create_f_update_0 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QWidget::update()\n", false, &_init_f_update_0, &_call_f_update_0);
}

// void QWidget::update(int x, int y, int w, int h)


static void _init_f_update_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_update_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QWidget *)cls)->update (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_update_2744 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QWidget::update(int x, int y, int w, int h)\n", false, &_init_f_update_2744, &_call_f_update_2744);
}

// void QWidget::update(const QRect &)


static void _init_f_update_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QWidget *)cls)->update (arg1);
}

static qt_gsi::GenericMethod *_create_f_update_1792 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QWidget::update(const QRect &)\n", false, &_init_f_update_1792, &_call_f_update_1792);
}

// void QWidget::update(const QRegion &)


static void _init_f_update_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QWidget *)cls)->update (arg1);
}

static qt_gsi::GenericMethod *_create_f_update_2006 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QWidget::update(const QRegion &)\n", false, &_init_f_update_2006, &_call_f_update_2006);
}

// void QWidget::updateGeometry()


static void _init_f_updateGeometry_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_updateGeometry_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget *)cls)->updateGeometry ();
}

static qt_gsi::GenericMethod *_create_f_updateGeometry_0 ()
{
  return new qt_gsi::GenericMethod ("updateGeometry", "@brief Method void QWidget::updateGeometry()\n", false, &_init_f_updateGeometry_0, &_call_f_updateGeometry_0);
}

// bool QWidget::updatesEnabled()


static void _init_f_updatesEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_updatesEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget *)cls)->updatesEnabled ());
}

static qt_gsi::GenericMethod *_create_f_updatesEnabled_c0 ()
{
  return new qt_gsi::GenericMethod (":updatesEnabled", "@brief Method bool QWidget::updatesEnabled()\n", true, &_init_f_updatesEnabled_c0, &_call_f_updatesEnabled_c0);
}

// QRegion QWidget::visibleRegion()


static void _init_f_visibleRegion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_visibleRegion_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRegion > ((QRegion)((QWidget *)cls)->visibleRegion ());
}

static qt_gsi::GenericMethod *_create_f_visibleRegion_c0 ()
{
  return new qt_gsi::GenericMethod ("visibleRegion", "@brief Method QRegion QWidget::visibleRegion()\n", true, &_init_f_visibleRegion_c0, &_call_f_visibleRegion_c0);
}

// QString QWidget::whatsThis()


static void _init_f_whatsThis_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_whatsThis_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->whatsThis ());
}

static qt_gsi::GenericMethod *_create_f_whatsThis_c0 ()
{
  return new qt_gsi::GenericMethod (":whatsThis", "@brief Method QString QWidget::whatsThis()\n", true, &_init_f_whatsThis_c0, &_call_f_whatsThis_c0);
}

// int QWidget::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWidget *)cls)->width ());
}

static qt_gsi::GenericMethod *_create_f_width_c0 ()
{
  return new qt_gsi::GenericMethod (":width", "@brief Method int QWidget::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
}

// WId QWidget::winId()


static void _init_f_winId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<WId>::target_type > ();
}

static void _call_f_winId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<WId>::target_type > ((qt_gsi::Converter<WId>::target_type)qt_gsi::CppToQtAdaptor<WId>(((QWidget *)cls)->winId ()));
}

static qt_gsi::GenericMethod *_create_f_winId_c0 ()
{
  return new qt_gsi::GenericMethod ("winId", "@brief Method WId QWidget::winId()\n", true, &_init_f_winId_c0, &_call_f_winId_c0);
}

// QWidget *QWidget::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QWidget *)cls)->window ());
}

static qt_gsi::GenericMethod *_create_f_window_c0 ()
{
  return new qt_gsi::GenericMethod ("window", "@brief Method QWidget *QWidget::window()\n", true, &_init_f_window_c0, &_call_f_window_c0);
}

// QString QWidget::windowFilePath()


static void _init_f_windowFilePath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowFilePath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->windowFilePath ());
}

static qt_gsi::GenericMethod *_create_f_windowFilePath_c0 ()
{
  return new qt_gsi::GenericMethod (":windowFilePath", "@brief Method QString QWidget::windowFilePath()\n", true, &_init_f_windowFilePath_c0, &_call_f_windowFilePath_c0);
}

// QFlags<Qt::WindowType> QWidget::windowFlags()


static void _init_f_windowFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type > ();
}

static void _call_f_windowFlags_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type > ((qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::WindowType> >(((QWidget *)cls)->windowFlags ()));
}

static qt_gsi::GenericMethod *_create_f_windowFlags_c0 ()
{
  return new qt_gsi::GenericMethod (":windowFlags", "@brief Method QFlags<Qt::WindowType> QWidget::windowFlags()\n", true, &_init_f_windowFlags_c0, &_call_f_windowFlags_c0);
}

// QIcon QWidget::windowIcon()


static void _init_f_windowIcon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_windowIcon_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIcon > ((QIcon)((QWidget *)cls)->windowIcon ());
}

static qt_gsi::GenericMethod *_create_f_windowIcon_c0 ()
{
  return new qt_gsi::GenericMethod (":windowIcon", "@brief Method QIcon QWidget::windowIcon()\n", true, &_init_f_windowIcon_c0, &_call_f_windowIcon_c0);
}

// QString QWidget::windowIconText()


static void _init_f_windowIconText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowIconText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->windowIconText ());
}

static qt_gsi::GenericMethod *_create_f_windowIconText_c0 ()
{
  return new qt_gsi::GenericMethod (":windowIconText", "@brief Method QString QWidget::windowIconText()\n", true, &_init_f_windowIconText_c0, &_call_f_windowIconText_c0);
}

// Qt::WindowModality QWidget::windowModality()


static void _init_f_windowModality_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::WindowModality>::target_type > ();
}

static void _call_f_windowModality_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::WindowModality>::target_type > ((qt_gsi::Converter<Qt::WindowModality>::target_type)qt_gsi::CppToQtAdaptor<Qt::WindowModality>(((QWidget *)cls)->windowModality ()));
}

static qt_gsi::GenericMethod *_create_f_windowModality_c0 ()
{
  return new qt_gsi::GenericMethod (":windowModality", "@brief Method Qt::WindowModality QWidget::windowModality()\n", true, &_init_f_windowModality_c0, &_call_f_windowModality_c0);
}

// double QWidget::windowOpacity()


static void _init_f_windowOpacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_windowOpacity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QWidget *)cls)->windowOpacity ());
}

static qt_gsi::GenericMethod *_create_f_windowOpacity_c0 ()
{
  return new qt_gsi::GenericMethod (":windowOpacity", "@brief Method double QWidget::windowOpacity()\n", true, &_init_f_windowOpacity_c0, &_call_f_windowOpacity_c0);
}

// QString QWidget::windowRole()


static void _init_f_windowRole_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowRole_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->windowRole ());
}

static qt_gsi::GenericMethod *_create_f_windowRole_c0 ()
{
  return new qt_gsi::GenericMethod (":windowRole", "@brief Method QString QWidget::windowRole()\n", true, &_init_f_windowRole_c0, &_call_f_windowRole_c0);
}

// QFlags<Qt::WindowState> QWidget::windowState()


static void _init_f_windowState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::WindowState> >::target_type > ();
}

static void _call_f_windowState_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::WindowState> >::target_type > ((qt_gsi::Converter<QFlags<Qt::WindowState> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::WindowState> >(((QWidget *)cls)->windowState ()));
}

static qt_gsi::GenericMethod *_create_f_windowState_c0 ()
{
  return new qt_gsi::GenericMethod (":windowState", "@brief Method QFlags<Qt::WindowState> QWidget::windowState()\n", true, &_init_f_windowState_c0, &_call_f_windowState_c0);
}

// QString QWidget::windowTitle()


static void _init_f_windowTitle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowTitle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QWidget *)cls)->windowTitle ());
}

static qt_gsi::GenericMethod *_create_f_windowTitle_c0 ()
{
  return new qt_gsi::GenericMethod (":windowTitle", "@brief Method QString QWidget::windowTitle()\n", true, &_init_f_windowTitle_c0, &_call_f_windowTitle_c0);
}

// Qt::WindowType QWidget::windowType()


static void _init_f_windowType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::WindowType>::target_type > ();
}

static void _call_f_windowType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::WindowType>::target_type > ((qt_gsi::Converter<Qt::WindowType>::target_type)qt_gsi::CppToQtAdaptor<Qt::WindowType>(((QWidget *)cls)->windowType ()));
}

static qt_gsi::GenericMethod *_create_f_windowType_c0 ()
{
  return new qt_gsi::GenericMethod ("windowType", "@brief Method Qt::WindowType QWidget::windowType()\n", true, &_init_f_windowType_c0, &_call_f_windowType_c0);
}

// int QWidget::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWidget *)cls)->x ());
}

static qt_gsi::GenericMethod *_create_f_x_c0 ()
{
  return new qt_gsi::GenericMethod (":x", "@brief Method int QWidget::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
}

// int QWidget::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWidget *)cls)->y ());
}

static qt_gsi::GenericMethod *_create_f_y_c0 ()
{
  return new qt_gsi::GenericMethod (":y", "@brief Method int QWidget::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
}

// static QWidget *QWidget::find(WId)


static void _init_f_find_696 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_find_696 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<WId>::target_type & arg1 = args.read<const qt_gsi::Converter<WId>::target_type & > ();
  ret.write<QWidget * > ((QWidget *)QWidget::find (qt_gsi::QtToCppAdaptor<WId>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_find_696 ()
{
  return new qt_gsi::GenericStaticMethod ("find", "@brief Static method QWidget *QWidget::find(WId)\nThis method is static and can be called without an instance.", &_init_f_find_696, &_call_f_find_696);
}

// static QWidget *QWidget::keyboardGrabber()


static void _init_f_keyboardGrabber_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_keyboardGrabber_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)QWidget::keyboardGrabber ());
}

static qt_gsi::GenericStaticMethod *_create_f_keyboardGrabber_0 ()
{
  return new qt_gsi::GenericStaticMethod ("keyboardGrabber", "@brief Static method QWidget *QWidget::keyboardGrabber()\nThis method is static and can be called without an instance.", &_init_f_keyboardGrabber_0, &_call_f_keyboardGrabber_0);
}

// static QWidget *QWidget::mouseGrabber()


static void _init_f_mouseGrabber_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_mouseGrabber_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)QWidget::mouseGrabber ());
}

static qt_gsi::GenericStaticMethod *_create_f_mouseGrabber_0 ()
{
  return new qt_gsi::GenericStaticMethod ("mouseGrabber", "@brief Static method QWidget *QWidget::mouseGrabber()\nThis method is static and can be called without an instance.", &_init_f_mouseGrabber_0, &_call_f_mouseGrabber_0);
}

// static void QWidget::setTabOrder(QWidget *, QWidget *)


static void _init_f_setTabOrder_2522 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabOrder_2522 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  QWidget *arg2 = args.read<QWidget * > ();
  QWidget::setTabOrder (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_setTabOrder_2522 ()
{
  return new qt_gsi::GenericStaticMethod ("setTabOrder", "@brief Static method void QWidget::setTabOrder(QWidget *, QWidget *)\nThis method is static and can be called without an instance.", &_init_f_setTabOrder_2522, &_call_f_setTabOrder_2522);
}

// static QString QWidget::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QWidget::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QWidget::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QWidget::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QWidget::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QWidget::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QWidget::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QWidget::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QWidget, QWidget_EventAdaptor> ea_QWidget;

//  base class cast for QObject

static void _init_f_QWidget_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QWidget_as_QObject (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QWidget *)cls);
}

static qt_gsi::GenericMethod *_create_f_QWidget_as_QObject ()
{
  return new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QWidget\nClass QWidget is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QWidget_as_QObject, &_call_f_QWidget_as_QObject);
}

static void _init_f_QWidget_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QWidget_as_const_QObject (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QWidget *)cls);
}

static qt_gsi::GenericMethod *_create_f_QWidget_as_const_QObject ()
{
  return new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QWidget\nClass QWidget is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QWidget_as_const_QObject, &_call_f_QWidget_as_const_QObject);
}

//  base class cast for QPaintDevice

static void _init_f_QWidget_as_QPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice *> ();
}

static void _call_f_QWidget_as_QPaintDevice (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintDevice *> ((QPaintDevice *)(QWidget *)cls);
}

static qt_gsi::GenericMethod *_create_f_QWidget_as_QPaintDevice ()
{
  return new qt_gsi::GenericMethod ("asQPaintDevice", "@brief Delivers the base class interface QPaintDevice of QWidget\nClass QWidget is derived from multiple base classes. This method delivers the QPaintDevice base class aspect.", false, &_init_f_QWidget_as_QPaintDevice, &_call_f_QWidget_as_QPaintDevice);
}

static void _init_f_QWidget_as_const_QPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPaintDevice *> ();
}

static void _call_f_QWidget_as_const_QPaintDevice (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QPaintDevice *> ((const QPaintDevice *)(const QWidget *)cls);
}

static qt_gsi::GenericMethod *_create_f_QWidget_as_const_QPaintDevice ()
{
  return new qt_gsi::GenericMethod ("asConstQPaintDevice", "@brief Delivers the base class interface QPaintDevice of QWidget\nClass QWidget is derived from multiple base classes. This method delivers the QPaintDevice base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QWidget_as_const_QPaintDevice, &_call_f_QWidget_as_const_QPaintDevice);
}


namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QWidget> decl_QWidget (ea_QWidget, decl_QObject, "QWidget_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_acceptDrops_c0 ()) +
  gsi::Methods(_create_f_accessibleDescription_c0 ()) +
  gsi::Methods(_create_f_accessibleName_c0 ()) +
  gsi::Methods(_create_f_actions_c0 ()) +
  gsi::Methods(_create_f_activateWindow_0 ()) +
  gsi::Methods(_create_f_addAction_1309 ()) +
  gsi::Methods(_create_f_addActions_1924 ()) +
  gsi::Methods(_create_f_adjustSize_0 ()) +
  gsi::Methods(_create_f_autoFillBackground_c0 ()) +
  gsi::Methods(_create_f_backgroundRole_c0 ()) +
  gsi::Methods(_create_f_baseSize_c0 ()) +
  gsi::Methods(_create_f_childAt_c1426 ()) +
  gsi::Methods(_create_f_childAt_c1916 ()) +
  gsi::Methods(_create_f_childrenRect_c0 ()) +
  gsi::Methods(_create_f_childrenRegion_c0 ()) +
  gsi::Methods(_create_f_clearFocus_0 ()) +
  gsi::Methods(_create_f_clearMask_0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_contentsMargins_c0 ()) +
  gsi::Methods(_create_f_contentsRect_c0 ()) +
  gsi::Methods(_create_f_contextMenuPolicy_c0 ()) +
  gsi::Methods(_create_f_createWinId_0 ()) +
  gsi::Methods(_create_f_cursor_c0 ()) +
  gsi::Methods(_create_f_effectiveWinId_c0 ()) +
  gsi::Methods(_create_f_ensurePolished_c0 ()) +
  gsi::Methods(_create_f_focusPolicy_c0 ()) +
  gsi::Methods(_create_f_focusProxy_c0 ()) +
  gsi::Methods(_create_f_focusWidget_c0 ()) +
  gsi::Methods(_create_f_font_c0 ()) +
  gsi::Methods(_create_f_fontInfo_c0 ()) +
  gsi::Methods(_create_f_fontMetrics_c0 ()) +
  gsi::Methods(_create_f_foregroundRole_c0 ()) +
  gsi::Methods(_create_f_frameGeometry_c0 ()) +
  gsi::Methods(_create_f_frameSize_c0 ()) +
  gsi::Methods(_create_f_geometry_c0 ()) +
  gsi::Methods(_create_f_getContentsMargins_c3488 ()) +
  gsi::Methods(_create_f_grabGesture_4352 ()) +
  gsi::Methods(_create_f_grabKeyboard_0 ()) +
  gsi::Methods(_create_f_grabMouse_0 ()) +
  gsi::Methods(_create_f_grabMouse_2032 ()) +
  gsi::Methods(_create_f_grabShortcut_4758 ()) +
  gsi::Methods(_create_f_graphicsEffect_c0 ()) +
  gsi::Methods(_create_f_graphicsProxyWidget_c0 ()) +
  gsi::Methods(_create_f_hasFocus_c0 ()) +
  gsi::Methods(_create_f_hasMouseTracking_c0 ()) +
  gsi::Methods(_create_f_height_c0 ()) +
  gsi::Methods(_create_f_heightForWidth_c767 ()) +
  gsi::Methods(_create_f_hide_0 ()) +
  gsi::Methods(_create_f_inputContext_0 ()) +
  gsi::Methods(_create_f_inputMethodHints_c0 ()) +
  gsi::Methods(_create_f_inputMethodQuery_c2420 ()) +
  gsi::Methods(_create_f_insertAction_2510 ()) +
  gsi::Methods(_create_f_insertActions_3125 ()) +
  gsi::Methods(_create_f_internalWinId_c0 ()) +
  gsi::Methods(_create_f_isActiveWindow_c0 ()) +
  gsi::Methods(_create_f_isAncestorOf_c2010 ()) +
  gsi::Methods(_create_f_isEnabled_c0 ()) +
  gsi::Methods(_create_f_isEnabledTo_c1315 ()) +
  gsi::Methods(_create_f_isEnabledToTLW_c0 ()) +
  gsi::Methods(_create_f_isFullScreen_c0 ()) +
  gsi::Methods(_create_f_isHidden_c0 ()) +
  gsi::Methods(_create_f_isLeftToRight_c0 ()) +
  gsi::Methods(_create_f_isMaximized_c0 ()) +
  gsi::Methods(_create_f_isMinimized_c0 ()) +
  gsi::Methods(_create_f_isModal_c0 ()) +
  gsi::Methods(_create_f_isRightToLeft_c0 ()) +
  gsi::Methods(_create_f_isTopLevel_c0 ()) +
  gsi::Methods(_create_f_isVisible_c0 ()) +
  gsi::Methods(_create_f_isVisibleTo_c1315 ()) +
  gsi::Methods(_create_f_isWindow_c0 ()) +
  gsi::Methods(_create_f_isWindowModified_c0 ()) +
  gsi::Methods(_create_f_layout_c0 ()) +
  gsi::Methods(_create_f_layoutDirection_c0 ()) +
  gsi::Methods(_create_f_locale_c0 ()) +
  gsi::Methods(_create_f_lower_0 ()) +
  gsi::Methods(_create_f_mapFrom_c3123 ()) +
  gsi::Methods(_create_f_mapFromGlobal_c1916 ()) +
  gsi::Methods(_create_f_mapFromParent_c1916 ()) +
  gsi::Methods(_create_f_mapTo_c3123 ()) +
  gsi::Methods(_create_f_mapToGlobal_c1916 ()) +
  gsi::Methods(_create_f_mapToParent_c1916 ()) +
  gsi::Methods(_create_f_mask_c0 ()) +
  gsi::Methods(_create_f_maximumHeight_c0 ()) +
  gsi::Methods(_create_f_maximumSize_c0 ()) +
  gsi::Methods(_create_f_maximumWidth_c0 ()) +
  gsi::Methods(_create_f_minimumHeight_c0 ()) +
  gsi::Methods(_create_f_minimumSize_c0 ()) +
  gsi::Methods(_create_f_minimumSizeHint_c0 ()) +
  gsi::Methods(_create_f_minimumWidth_c0 ()) +
  gsi::Methods(_create_f_move_1426 ()) +
  gsi::Methods(_create_f_move_1916 ()) +
  gsi::Methods(_create_f_nativeParentWidget_c0 ()) +
  gsi::Methods(_create_f_nextInFocusChain_c0 ()) +
  gsi::Methods(_create_f_normalGeometry_c0 ()) +
  gsi::Methods(_create_f_overrideWindowFlags_2495 ()) +
  gsi::Methods(_create_f_overrideWindowState_2590 ()) +
  gsi::Methods(_create_f_paintEngine_c0 ()) +
  gsi::Methods(_create_f_palette_c0 ()) +
  gsi::Methods(_create_f_parentWidget_c0 ()) +
  gsi::Methods(_create_f_pos_c0 ()) +
  gsi::Methods(_create_f_previousInFocusChain_c0 ()) +
  gsi::Methods(_create_f_raise_0 ()) +
  gsi::Methods(_create_f_rect_c0 ()) +
  gsi::Methods(_create_f_releaseKeyboard_0 ()) +
  gsi::Methods(_create_f_releaseMouse_0 ()) +
  gsi::Methods(_create_f_releaseShortcut_767 ()) +
  gsi::Methods(_create_f_removeAction_1309 ()) +
  gsi::Methods(_create_f_render_8328 ()) +
  gsi::Methods(_create_f_render_7951 ()) +
  gsi::Methods(_create_f_repaint_0 ()) +
  gsi::Methods(_create_f_repaint_2744 ()) +
  gsi::Methods(_create_f_repaint_1792 ()) +
  gsi::Methods(_create_f_repaint_2006 ()) +
  gsi::Methods(_create_f_resize_1426 ()) +
  gsi::Methods(_create_f_resize_1805 ()) +
  gsi::Methods(_create_f_restoreGeometry_2309 ()) +
  gsi::Methods(_create_f_saveGeometry_c0 ()) +
  gsi::Methods(_create_f_scroll_1426 ()) +
  gsi::Methods(_create_f_scroll_3110 ()) +
  gsi::Methods(_create_f_setAcceptDrops_864 ()) +
  gsi::Methods(_create_f_setAccessibleDescription_2025 ()) +
  gsi::Methods(_create_f_setAccessibleName_2025 ()) +
  gsi::Methods(_create_f_setAttribute_3065 ()) +
  gsi::Methods(_create_f_setAutoFillBackground_864 ()) +
  gsi::Methods(_create_f_setBackgroundRole_2265 ()) +
  gsi::Methods(_create_f_setBaseSize_1805 ()) +
  gsi::Methods(_create_f_setBaseSize_1426 ()) +
  gsi::Methods(_create_f_setContentsMargins_2744 ()) +
  gsi::Methods(_create_f_setContentsMargins_2115 ()) +
  gsi::Methods(_create_f_setContextMenuPolicy_2519 ()) +
  gsi::Methods(_create_f_setCursor_2032 ()) +
  gsi::Methods(_create_f_setDisabled_864 ()) +
  gsi::Methods(_create_f_setEnabled_864 ()) +
  gsi::Methods(_create_f_setFixedHeight_767 ()) +
  gsi::Methods(_create_f_setFixedSize_1805 ()) +
  gsi::Methods(_create_f_setFixedSize_1426 ()) +
  gsi::Methods(_create_f_setFixedWidth_767 ()) +
  gsi::Methods(_create_f_setFocus_0 ()) +
  gsi::Methods(_create_f_setFocus_1877 ()) +
  gsi::Methods(_create_f_setFocusPolicy_1885 ()) +
  gsi::Methods(_create_f_setFocusProxy_1315 ()) +
  gsi::Methods(_create_f_setFont_1801 ()) +
  gsi::Methods(_create_f_setForegroundRole_2265 ()) +
  gsi::Methods(_create_f_setGeometry_2744 ()) +
  gsi::Methods(_create_f_setGeometry_1792 ()) +
  gsi::Methods(_create_f_setGraphicsEffect_2109 ()) +
  gsi::Methods(_create_f_setHidden_864 ()) +
  gsi::Methods(_create_f_setInputContext_1972 ()) +
  gsi::Methods(_create_f_setInputMethodHints_2985 ()) +
  gsi::Methods(_create_f_setLayout_1341 ()) +
  gsi::Methods(_create_f_setLayoutDirection_2316 ()) +
  gsi::Methods(_create_f_setLocale_1986 ()) +
  gsi::Methods(_create_f_setMask_1999 ()) +
  gsi::Methods(_create_f_setMask_2006 ()) +
  gsi::Methods(_create_f_setMaximumHeight_767 ()) +
  gsi::Methods(_create_f_setMaximumSize_1805 ()) +
  gsi::Methods(_create_f_setMaximumSize_1426 ()) +
  gsi::Methods(_create_f_setMaximumWidth_767 ()) +
  gsi::Methods(_create_f_setMinimumHeight_767 ()) +
  gsi::Methods(_create_f_setMinimumSize_1805 ()) +
  gsi::Methods(_create_f_setMinimumSize_1426 ()) +
  gsi::Methods(_create_f_setMinimumWidth_767 ()) +
  gsi::Methods(_create_f_setMouseTracking_864 ()) +
  gsi::Methods(_create_f_setPalette_2113 ()) +
  gsi::Methods(_create_f_setParent_1315 ()) +
  gsi::Methods(_create_f_setParent_3702 ()) +
  gsi::Methods(_create_f_setShortcutAutoRepeat_1523 ()) +
  gsi::Methods(_create_f_setShortcutEnabled_1523 ()) +
  gsi::Methods(_create_f_setShown_864 ()) +
  gsi::Methods(_create_f_setSizeIncrement_1805 ()) +
  gsi::Methods(_create_f_setSizeIncrement_1426 ()) +
  gsi::Methods(_create_f_setSizePolicy_1552 ()) +
  gsi::Methods(_create_f_setSizePolicy_4476 ()) +
  gsi::Methods(_create_f_setStatusTip_2025 ()) +
  gsi::Methods(_create_f_setStyle_1232 ()) +
  gsi::Methods(_create_f_setStyleSheet_2025 ()) +
  gsi::Methods(_create_f_setToolTip_2025 ()) +
  gsi::Methods(_create_f_setUpdatesEnabled_864 ()) +
  gsi::Methods(_create_f_setVisible_864 ()) +
  gsi::Methods(_create_f_setWhatsThis_2025 ()) +
  gsi::Methods(_create_f_setWindowFilePath_2025 ()) +
  gsi::Methods(_create_f_setWindowFlags_2495 ()) +
  gsi::Methods(_create_f_setWindowIcon_1787 ()) +
  gsi::Methods(_create_f_setWindowIconText_2025 ()) +
  gsi::Methods(_create_f_setWindowModality_2216 ()) +
  gsi::Methods(_create_f_setWindowModified_864 ()) +
  gsi::Methods(_create_f_setWindowOpacity_1071 ()) +
  gsi::Methods(_create_f_setWindowRole_2025 ()) +
  gsi::Methods(_create_f_setWindowState_2590 ()) +
  gsi::Methods(_create_f_setWindowTitle_2025 ()) +
  gsi::Methods(_create_f_show_0 ()) +
  gsi::Methods(_create_f_showFullScreen_0 ()) +
  gsi::Methods(_create_f_showMaximized_0 ()) +
  gsi::Methods(_create_f_showMinimized_0 ()) +
  gsi::Methods(_create_f_showNormal_0 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_sizeIncrement_c0 ()) +
  gsi::Methods(_create_f_sizePolicy_c0 ()) +
  gsi::Methods(_create_f_stackUnder_1315 ()) +
  gsi::Methods(_create_f_statusTip_c0 ()) +
  gsi::Methods(_create_f_style_c0 ()) +
  gsi::Methods(_create_f_styleSheet_c0 ()) +
  gsi::Methods(_create_f_testAttribute_c2309 ()) +
  gsi::Methods(_create_f_toolTip_c0 ()) +
  gsi::Methods(_create_f_topLevelWidget_c0 ()) +
  gsi::Methods(_create_f_underMouse_c0 ()) +
  gsi::Methods(_create_f_ungrabGesture_1902 ()) +
  gsi::Methods(_create_f_unsetCursor_0 ()) +
  gsi::Methods(_create_f_unsetLayoutDirection_0 ()) +
  gsi::Methods(_create_f_unsetLocale_0 ()) +
  gsi::Methods(_create_f_update_0 ()) +
  gsi::Methods(_create_f_update_2744 ()) +
  gsi::Methods(_create_f_update_1792 ()) +
  gsi::Methods(_create_f_update_2006 ()) +
  gsi::Methods(_create_f_updateGeometry_0 ()) +
  gsi::Methods(_create_f_updatesEnabled_c0 ()) +
  gsi::Methods(_create_f_visibleRegion_c0 ()) +
  gsi::Methods(_create_f_whatsThis_c0 ()) +
  gsi::Methods(_create_f_width_c0 ()) +
  gsi::Methods(_create_f_winId_c0 ()) +
  gsi::Methods(_create_f_window_c0 ()) +
  gsi::Methods(_create_f_windowFilePath_c0 ()) +
  gsi::Methods(_create_f_windowFlags_c0 ()) +
  gsi::Methods(_create_f_windowIcon_c0 ()) +
  gsi::Methods(_create_f_windowIconText_c0 ()) +
  gsi::Methods(_create_f_windowModality_c0 ()) +
  gsi::Methods(_create_f_windowOpacity_c0 ()) +
  gsi::Methods(_create_f_windowRole_c0 ()) +
  gsi::Methods(_create_f_windowState_c0 ()) +
  gsi::Methods(_create_f_windowTitle_c0 ()) +
  gsi::Methods(_create_f_windowType_c0 ()) +
  gsi::Methods(_create_f_x_c0 ()) +
  gsi::Methods(_create_f_y_c0 ()) +
  qt_gsi::qt_signal<QWidget, QWidget_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QWidget_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QWidget, QWidget_EventAdaptor, QObject *> ("destroyed", &QWidget_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_find_696 ()) +
  gsi::Methods(_create_f_keyboardGrabber_0 ()) +
  gsi::Methods(_create_f_mouseGrabber_0 ()) +
  gsi::Methods(_create_f_setTabOrder_2522 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()) +
  gsi::Methods(_create_f_QWidget_as_QObject ()) +
  gsi::Methods(_create_f_QWidget_as_const_QObject ()) +
  gsi::Methods(_create_f_QWidget_as_QPaintDevice ()) +
  gsi::Methods(_create_f_QWidget_as_const_QPaintDevice ()),
  "@hide\n@alias QWidget");
}


class QWidget_Adaptor : public QWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QWidget_Adaptor();

  //  [adaptor ctor] QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f)
  QWidget_Adaptor() : QWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f)
  QWidget_Adaptor(QWidget *parent) : QWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f)
  QWidget_Adaptor(QWidget *parent, QFlags<Qt::WindowType> f) : QWidget(parent, f)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QWidget::focusNextChild()
  bool fp_QWidget_focusNextChild_0 () {
    return QWidget::focusNextChild();
  }

  //  bool QWidget::focusPreviousChild()
  bool fp_QWidget_focusPreviousChild_0 () {
    return QWidget::focusPreviousChild();
  }

  //  int QWidget::receivers(const char *signal)
  int fp_QWidget_receivers_c1731 (const char *signal) const {
    return QWidget::receivers(signal);
  }

  //  void QWidget::resetInputContext()
  void fp_QWidget_resetInputContext_0 () {
    QWidget::resetInputContext();
  }

  //  QObject *QWidget::sender()
  QObject * fp_QWidget_sender_c0 () const {
    return QWidget::sender();
  }

  //  void QWidget::updateMicroFocus()
  void fp_QWidget_updateMicroFocus_0 () {
    QWidget::updateMicroFocus();
  }

  //  [adaptor impl] bool QWidget::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QWidget::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QWidget_Adaptor, bool, QObject *, QEvent *>(&QWidget_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QWidget::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QWidget::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QWidget::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QWidget_Adaptor, int, int>(&QWidget_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QWidget::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QWidget::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QWidget_Adaptor, QSize>(&QWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QWidget::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QWidget_Adaptor, QPaintEngine *>(&QWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QWidget::paintEngine();
    }
  }

  //  [adaptor impl] void QWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QWidget_Adaptor, bool>(&QWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QWidget_Adaptor, QSize>(&QWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QWidget::sizeHint();
    }
  }

  //  [adaptor impl] void QWidget::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QWidget::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QWidget_Adaptor, QActionEvent *>(&QWidget_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QWidget::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QWidget_Adaptor, QEvent *>(&QWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QWidget::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QWidget_Adaptor, QChildEvent *>(&QWidget_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QWidget::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QWidget::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QWidget_Adaptor, QCloseEvent *>(&QWidget_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QWidget::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QWidget::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QWidget_Adaptor, QContextMenuEvent *>(&QWidget_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QWidget::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QWidget::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QWidget_Adaptor, QEvent *>(&QWidget_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QWidget::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QWidget_Adaptor, const char *>(&QWidget_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QWidget::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QWidget::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QWidget_Adaptor, QDragEnterEvent *>(&QWidget_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QWidget::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QWidget::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QWidget_Adaptor, QDragLeaveEvent *>(&QWidget_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QWidget::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QWidget::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QWidget_Adaptor, QDragMoveEvent *>(&QWidget_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QWidget::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QWidget::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QWidget_Adaptor, QDropEvent *>(&QWidget_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QWidget::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QWidget::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QWidget_Adaptor, bool>(&QWidget_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QWidget::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QWidget::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QWidget::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QWidget_Adaptor, QEvent *>(&QWidget_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QWidget::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QWidget::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QWidget::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QWidget_Adaptor, bool, QEvent *>(&QWidget_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QWidget::event(arg1);
    }
  }

  //  [adaptor impl] void QWidget::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QWidget::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QWidget_Adaptor, QFocusEvent *>(&QWidget_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QWidget::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QWidget_Adaptor, bool, bool>(&QWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QWidget::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QWidget::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QWidget_Adaptor, QFocusEvent *>(&QWidget_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QWidget::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QWidget::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QWidget_Adaptor, const QFont &>(&QWidget_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QWidget::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QWidget::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QWidget::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QWidget_Adaptor, QHideEvent *>(&QWidget_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QWidget::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QWidget::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QWidget_Adaptor, QInputMethodEvent *>(&QWidget_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QWidget::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QWidget::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QWidget_Adaptor, QKeyEvent *>(&QWidget_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QWidget::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QWidget::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QWidget_Adaptor, QKeyEvent *>(&QWidget_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QWidget::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::languageChange()
  void cbs_languageChange_0_0()
  {
    QWidget::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QWidget_Adaptor>(&QWidget_Adaptor::cbs_languageChange_0_0);
    } else {
      QWidget::languageChange();
    }
  }

  //  [adaptor impl] void QWidget::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QWidget::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QWidget_Adaptor, QEvent *>(&QWidget_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QWidget::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QWidget::metric(arg1);
    }
  }

  //  [adaptor impl] void QWidget::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QWidget::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QWidget_Adaptor, QMouseEvent *>(&QWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QWidget::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QWidget::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QWidget_Adaptor, QMouseEvent *>(&QWidget_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QWidget::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QWidget::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QWidget_Adaptor, QMouseEvent *>(&QWidget_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QWidget::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QWidget::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QWidget_Adaptor, QMouseEvent *>(&QWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QWidget::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QWidget::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QWidget_Adaptor, QMoveEvent *>(&QWidget_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QWidget::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QWidget::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QWidget_Adaptor, QPaintEvent *>(&QWidget_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QWidget::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QWidget::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QWidget_Adaptor, const QPalette &>(&QWidget_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QWidget::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QWidget::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QWidget::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QWidget_Adaptor, QResizeEvent *>(&QWidget_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QWidget::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QWidget::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QWidget_Adaptor, QShowEvent *>(&QWidget_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QWidget::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QWidget::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QWidget_Adaptor, QStyle &>(&QWidget_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QWidget::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QWidget::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QWidget::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QWidget_Adaptor, QTabletEvent *>(&QWidget_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QWidget::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QWidget::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QWidget_Adaptor, QTimerEvent *>(&QWidget_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QWidget::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QWidget::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QWidget_Adaptor, QWheelEvent *>(&QWidget_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QWidget::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QWidget::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QWidget::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QWidget_Adaptor, bool>(&QWidget_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QWidget::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QWidget_Adaptor::~QWidget_Adaptor() { }

//  Constructor QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f) (adaptor class)

static void _init_ctor_QWidget_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return_new<QWidget_Adaptor *> ();
}

static void _call_ctor_QWidget_Adaptor_3702 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QWidget_Adaptor *> (new QWidget_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QWidget_Adaptor_3702 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QWidget::QWidget(QWidget *parent, QFlags<Qt::WindowType> f)\nThis method creates an object of class QWidget.", &_init_ctor_QWidget_Adaptor_3702, &_call_ctor_QWidget_Adaptor_3702);
}

// void QWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QWidget_Adaptor *)cls)->fp_QWidget_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QWidget_Adaptor *)cls)->fp_QWidget_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->fp_QWidget_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->fp_QWidget_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QWidget_Adaptor *)cls)->fp_QWidget_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QWidget::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget_Adaptor *)cls)->fp_QWidget_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QWidget::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QWidget_Adaptor *)cls)->fp_QWidget_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QWidget::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget_Adaptor *)cls)->fp_QWidget_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QWidget::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// bool QWidget::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QWidget::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QWidget::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QWidget::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QWidget::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QWidget::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QWidget::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QWidget::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QWidget::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QWidget::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QWidget::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QWidget::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QWidget::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QWidget::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QWidget::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QWidget::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QWidget_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QWidget::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QWidget::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QWidget::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QWidget::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QWidget::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QWidget::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QWidget::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QWidget::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QWidget::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QWidget::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QWidget::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QWidget::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QWidget::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QWidget::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QWidget::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QWidget::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QWidget::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QWidget::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QWidget::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QWidget::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QWidget_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QWidget::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QWidget::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QWidget::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QWidget::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QWidget::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QWidget::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QWidget::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QWidget::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QWidget::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QWidget::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWidget_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QWidget::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QWidget::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QWidget::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QWidget::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QWidget::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QWidget::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QWidget::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QWidget::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QWidget::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QWidget::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QWidget::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QWidget::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QWidget::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QWidget::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QWidget::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QWidget::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QWidget_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QWidget::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QWidget::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QWidget::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QWidget::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QWidget::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QWidget::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QWidget_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QWidget::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QWidget::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QWidget::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QWidget::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QWidget::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QWidget::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QWidget::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QWidget::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWidget_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWidget_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QWidget::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QWidget> decl_QWidget;

gsi::Class<QWidget_Adaptor> decl_QWidget_Adaptor (decl_QWidget, "QWidget",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QWidget_Adaptor_3702 ()),
  "@qt\n@brief Binding of QWidget");

}


//  Implementation of the enum wrapper class for QWidget::RenderFlag
namespace qt_gsi
{

static QWidget_RenderFlag_Enum *c_1_QWidget_RenderFlag_Enum () { return new QWidget_RenderFlag_Enum (QWidget::DrawWindowBackground); }
static QWidget_RenderFlag_Enum *c_2_QWidget_RenderFlag_Enum () { return new QWidget_RenderFlag_Enum (QWidget::DrawChildren); }
static QWidget_RenderFlag_Enum *c_3_QWidget_RenderFlag_Enum () { return new QWidget_RenderFlag_Enum (QWidget::IgnoreMask); }

static gsi::Methods mkdefs_QWidget_RenderFlag () {
  return
    gsi::constant ("DrawWindowBackground", &qt_gsi::c_1_QWidget_RenderFlag_Enum, "@brief Enum constant QWidget::DrawWindowBackground") +
    gsi::constant ("DrawChildren", &qt_gsi::c_2_QWidget_RenderFlag_Enum, "@brief Enum constant QWidget::DrawChildren") +
    gsi::constant ("IgnoreMask", &qt_gsi::c_3_QWidget_RenderFlag_Enum, "@brief Enum constant QWidget::IgnoreMask");
}

static std::string to_s_QWidget_RenderFlag_Enum (const QWidget_RenderFlag_Enum *e)
{
  if (e->value () == QWidget::DrawWindowBackground) { return tl::sprintf ("DrawWindowBackground (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWidget::DrawChildren) { return tl::sprintf ("DrawChildren (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWidget::IgnoreMask) { return tl::sprintf ("IgnoreMask (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QWidget_RenderFlag_Enum (const QWidget_RenderFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QWidget_RenderFlag_Enum *from_i_QWidget_RenderFlag_Enum (unsigned int i)
{
  return new QWidget_RenderFlag_Enum ((QWidget::RenderFlag) i);
}

static bool equalQWidget_RenderFlag_Enum (const QWidget_RenderFlag_Enum *e, QWidget_RenderFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QWidget_RenderFlag_Enum (const QWidget_RenderFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QWidget_RenderFlag_Enums oropQWidget_RenderFlag_Enums (const QWidget_RenderFlag_Enums *e, const QWidget_RenderFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QWidget_RenderFlag_Enums andopQWidget_RenderFlag_Enums (const QWidget_RenderFlag_Enums *e, const QWidget_RenderFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QWidget_RenderFlag_Enums xoropQWidget_RenderFlag_Enums (const QWidget_RenderFlag_Enums *e, const QWidget_RenderFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QWidget_RenderFlag_Enums (const QWidget_RenderFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QWidget::DrawWindowBackground)) { if (!l.empty ()) l += "|"; l += "DrawWindowBackground"; }
  if (e->testFlag (QWidget::DrawChildren)) { if (!l.empty ()) l += "|"; l += "DrawChildren"; }
  if (e->testFlag (QWidget::IgnoreMask)) { if (!l.empty ()) l += "|"; l += "IgnoreMask"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QWidget_RenderFlag_Enums (const QWidget_RenderFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QWidget_RenderFlag_Enums (const QWidget_RenderFlag_Enums *e, const QWidget_RenderFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QWidget_RenderFlag_Enums> decl_QWidget_RenderFlag_Enums ("QWidget_QFlags_RenderFlag",
  gsi::method_ext ("|", &qt_gsi::oropQWidget_RenderFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQWidget_RenderFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQWidget_RenderFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWidget_RenderFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWidget_RenderFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QWidget_RenderFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QWidget::RenderFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QWidget_RenderFlag_Enum> decl_QWidget_RenderFlag_Enum (decl_QWidget_RenderFlag_Enums, "QWidget_RenderFlag",
  qt_gsi::mkdefs_QWidget_RenderFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWidget_RenderFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWidget_RenderFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQWidget_RenderFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QWidget_RenderFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QWidget_RenderFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QWidget::RenderFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QWidget> inject_QWidget_RenderFlag_Enum_in_parent (qt_gsi::mkdefs_QWidget_RenderFlag ());
static gsi::ClassExt<QWidget> decl_QWidget_RenderFlag_Enum_as_child (decl_QWidget_RenderFlag_Enum, "RenderFlag");

}

