
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUndoStack.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQUndoStack_EventAdaptor.h"
#include "gsiDeclQUndoStack_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUndoStack

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QUndoStack::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QUndoStack::beginMacro(const QString &text)


static void _init_f_beginMacro_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_beginMacro_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUndoStack *)cls)->beginMacro (arg1);
}

static qt_gsi::GenericMethod *_create_f_beginMacro_2025 ()
{
  return new qt_gsi::GenericMethod ("beginMacro", "@brief Method void QUndoStack::beginMacro(const QString &text)\n", false, &_init_f_beginMacro_2025, &_call_f_beginMacro_2025);
}

// bool QUndoStack::canRedo()


static void _init_f_canRedo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canRedo_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUndoStack *)cls)->canRedo ());
}

static qt_gsi::GenericMethod *_create_f_canRedo_c0 ()
{
  return new qt_gsi::GenericMethod ("canRedo", "@brief Method bool QUndoStack::canRedo()\n", true, &_init_f_canRedo_c0, &_call_f_canRedo_c0);
}

// bool QUndoStack::canUndo()


static void _init_f_canUndo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canUndo_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUndoStack *)cls)->canUndo ());
}

static qt_gsi::GenericMethod *_create_f_canUndo_c0 ()
{
  return new qt_gsi::GenericMethod ("canUndo", "@brief Method bool QUndoStack::canUndo()\n", true, &_init_f_canUndo_c0, &_call_f_canUndo_c0);
}

// int QUndoStack::cleanIndex()


static void _init_f_cleanIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cleanIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUndoStack *)cls)->cleanIndex ());
}

static qt_gsi::GenericMethod *_create_f_cleanIndex_c0 ()
{
  return new qt_gsi::GenericMethod ("cleanIndex", "@brief Method int QUndoStack::cleanIndex()\n", true, &_init_f_cleanIndex_c0, &_call_f_cleanIndex_c0);
}

// void QUndoStack::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoStack *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QUndoStack::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// const QUndoCommand *QUndoStack::command(int index)


static void _init_f_command_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<const QUndoCommand * > ();
}

static void _call_f_command_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<const QUndoCommand * > ((const QUndoCommand *)((QUndoStack *)cls)->command (arg1));
}

static qt_gsi::GenericMethod *_create_f_command_c767 ()
{
  return new qt_gsi::GenericMethod ("command", "@brief Method const QUndoCommand *QUndoStack::command(int index)\n", true, &_init_f_command_c767, &_call_f_command_c767);
}

// int QUndoStack::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUndoStack *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Method int QUndoStack::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
}

// QAction *QUndoStack::createRedoAction(QObject *parent, const QString &prefix)


static void _init_f_createRedoAction_c3219 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("prefix", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QAction * > ();
}

static void _call_f_createRedoAction_c3219 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<QAction * > ((QAction *)((QUndoStack *)cls)->createRedoAction (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_createRedoAction_c3219 ()
{
  return new qt_gsi::GenericMethod ("createRedoAction", "@brief Method QAction *QUndoStack::createRedoAction(QObject *parent, const QString &prefix)\n", true, &_init_f_createRedoAction_c3219, &_call_f_createRedoAction_c3219);
}

// QAction *QUndoStack::createUndoAction(QObject *parent, const QString &prefix)


static void _init_f_createUndoAction_c3219 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("prefix", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QAction * > ();
}

static void _call_f_createUndoAction_c3219 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<QAction * > ((QAction *)((QUndoStack *)cls)->createUndoAction (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_createUndoAction_c3219 ()
{
  return new qt_gsi::GenericMethod ("createUndoAction", "@brief Method QAction *QUndoStack::createUndoAction(QObject *parent, const QString &prefix)\n", true, &_init_f_createUndoAction_c3219, &_call_f_createUndoAction_c3219);
}

// void QUndoStack::endMacro()


static void _init_f_endMacro_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endMacro_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoStack *)cls)->endMacro ();
}

static qt_gsi::GenericMethod *_create_f_endMacro_0 ()
{
  return new qt_gsi::GenericMethod ("endMacro", "@brief Method void QUndoStack::endMacro()\n", false, &_init_f_endMacro_0, &_call_f_endMacro_0);
}

// int QUndoStack::index()


static void _init_f_index_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_index_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUndoStack *)cls)->index ());
}

static qt_gsi::GenericMethod *_create_f_index_c0 ()
{
  return new qt_gsi::GenericMethod (":index", "@brief Method int QUndoStack::index()\n", true, &_init_f_index_c0, &_call_f_index_c0);
}

// bool QUndoStack::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUndoStack *)cls)->isActive ());
}

static qt_gsi::GenericMethod *_create_f_isActive_c0 ()
{
  return new qt_gsi::GenericMethod ("isActive?|:active", "@brief Method bool QUndoStack::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
}

// bool QUndoStack::isClean()


static void _init_f_isClean_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isClean_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUndoStack *)cls)->isClean ());
}

static qt_gsi::GenericMethod *_create_f_isClean_c0 ()
{
  return new qt_gsi::GenericMethod ("isClean?", "@brief Method bool QUndoStack::isClean()\n", true, &_init_f_isClean_c0, &_call_f_isClean_c0);
}

// void QUndoStack::push(QUndoCommand *cmd)


static void _init_f_push_1812 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cmd");
  decl->add_arg<QUndoCommand * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_push_1812 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QUndoCommand *arg1 = args.read<QUndoCommand * > ();
  ((QUndoStack *)cls)->push (arg1);
}

static qt_gsi::GenericMethod *_create_f_push_1812 ()
{
  return new qt_gsi::GenericMethod ("push", "@brief Method void QUndoStack::push(QUndoCommand *cmd)\n", false, &_init_f_push_1812, &_call_f_push_1812);
}

// void QUndoStack::redo()


static void _init_f_redo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_redo_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoStack *)cls)->redo ();
}

static qt_gsi::GenericMethod *_create_f_redo_0 ()
{
  return new qt_gsi::GenericMethod ("redo", "@brief Method void QUndoStack::redo()\n", false, &_init_f_redo_0, &_call_f_redo_0);
}

// QString QUndoStack::redoText()


static void _init_f_redoText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_redoText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUndoStack *)cls)->redoText ());
}

static qt_gsi::GenericMethod *_create_f_redoText_c0 ()
{
  return new qt_gsi::GenericMethod ("redoText", "@brief Method QString QUndoStack::redoText()\n", true, &_init_f_redoText_c0, &_call_f_redoText_c0);
}

// void QUndoStack::setActive(bool active)


static void _init_f_setActive_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("active", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActive_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  ((QUndoStack *)cls)->setActive (arg1);
}

static qt_gsi::GenericMethod *_create_f_setActive_864 ()
{
  return new qt_gsi::GenericMethod ("setActive|active=", "@brief Method void QUndoStack::setActive(bool active)\n", false, &_init_f_setActive_864, &_call_f_setActive_864);
}

// void QUndoStack::setClean()


static void _init_f_setClean_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setClean_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoStack *)cls)->setClean ();
}

static qt_gsi::GenericMethod *_create_f_setClean_0 ()
{
  return new qt_gsi::GenericMethod ("setClean", "@brief Method void QUndoStack::setClean()\n", false, &_init_f_setClean_0, &_call_f_setClean_0);
}

// void QUndoStack::setIndex(int idx)


static void _init_f_setIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("idx");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIndex_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUndoStack *)cls)->setIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIndex_767 ()
{
  return new qt_gsi::GenericMethod ("setIndex|index=", "@brief Method void QUndoStack::setIndex(int idx)\n", false, &_init_f_setIndex_767, &_call_f_setIndex_767);
}

// void QUndoStack::setUndoLimit(int limit)


static void _init_f_setUndoLimit_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("limit");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUndoLimit_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUndoStack *)cls)->setUndoLimit (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUndoLimit_767 ()
{
  return new qt_gsi::GenericMethod ("setUndoLimit|undoLimit=", "@brief Method void QUndoStack::setUndoLimit(int limit)\n", false, &_init_f_setUndoLimit_767, &_call_f_setUndoLimit_767);
}

// QString QUndoStack::text(int idx)


static void _init_f_text_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("idx");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_text_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)((QUndoStack *)cls)->text (arg1));
}

static qt_gsi::GenericMethod *_create_f_text_c767 ()
{
  return new qt_gsi::GenericMethod ("text", "@brief Method QString QUndoStack::text(int idx)\n", true, &_init_f_text_c767, &_call_f_text_c767);
}

// void QUndoStack::undo()


static void _init_f_undo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_undo_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoStack *)cls)->undo ();
}

static qt_gsi::GenericMethod *_create_f_undo_0 ()
{
  return new qt_gsi::GenericMethod ("undo", "@brief Method void QUndoStack::undo()\n", false, &_init_f_undo_0, &_call_f_undo_0);
}

// int QUndoStack::undoLimit()


static void _init_f_undoLimit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_undoLimit_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUndoStack *)cls)->undoLimit ());
}

static qt_gsi::GenericMethod *_create_f_undoLimit_c0 ()
{
  return new qt_gsi::GenericMethod (":undoLimit", "@brief Method int QUndoStack::undoLimit()\n", true, &_init_f_undoLimit_c0, &_call_f_undoLimit_c0);
}

// QString QUndoStack::undoText()


static void _init_f_undoText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_undoText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUndoStack *)cls)->undoText ());
}

static qt_gsi::GenericMethod *_create_f_undoText_c0 ()
{
  return new qt_gsi::GenericMethod ("undoText", "@brief Method QString QUndoStack::undoText()\n", true, &_init_f_undoText_c0, &_call_f_undoText_c0);
}

// static QString QUndoStack::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QUndoStack::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QUndoStack::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QUndoStack::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QUndoStack::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QUndoStack::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QUndoStack::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QUndoStack::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QUndoStack::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QUndoStack::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QUndoStack::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QUndoStack::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QUndoStack, QUndoStack_EventAdaptor> ea_QUndoStack;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QUndoStack> decl_QUndoStack (ea_QUndoStack, decl_QObject, "QUndoStack_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_beginMacro_2025 ()) +
  gsi::Methods(_create_f_canRedo_c0 ()) +
  gsi::Methods(_create_f_canUndo_c0 ()) +
  gsi::Methods(_create_f_cleanIndex_c0 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_command_c767 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_createRedoAction_c3219 ()) +
  gsi::Methods(_create_f_createUndoAction_c3219 ()) +
  gsi::Methods(_create_f_endMacro_0 ()) +
  gsi::Methods(_create_f_index_c0 ()) +
  gsi::Methods(_create_f_isActive_c0 ()) +
  gsi::Methods(_create_f_isClean_c0 ()) +
  gsi::Methods(_create_f_push_1812 ()) +
  gsi::Methods(_create_f_redo_0 ()) +
  gsi::Methods(_create_f_redoText_c0 ()) +
  gsi::Methods(_create_f_setActive_864 ()) +
  gsi::Methods(_create_f_setClean_0 ()) +
  gsi::Methods(_create_f_setIndex_767 ()) +
  gsi::Methods(_create_f_setUndoLimit_767 ()) +
  gsi::Methods(_create_f_text_c767 ()) +
  gsi::Methods(_create_f_undo_0 ()) +
  gsi::Methods(_create_f_undoLimit_c0 ()) +
  gsi::Methods(_create_f_undoText_c0 ()) +
  qt_gsi::qt_signal<QUndoStack, QUndoStack_EventAdaptor, bool> ("canRedoChanged", &QUndoStack_EventAdaptor::canRedoChanged_e_864, gsi::arg("canRedo"), "@brief Signal declaration for QUndoStack::canRedoChanged(bool canRedo)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoStack, QUndoStack_EventAdaptor, bool> ("canUndoChanged", &QUndoStack_EventAdaptor::canUndoChanged_e_864, gsi::arg("canUndo"), "@brief Signal declaration for QUndoStack::canUndoChanged(bool canUndo)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoStack, QUndoStack_EventAdaptor, bool> ("cleanChanged", &QUndoStack_EventAdaptor::cleanChanged_e_864, gsi::arg("clean"), "@brief Signal declaration for QUndoStack::cleanChanged(bool clean)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoStack, QUndoStack_EventAdaptor, QObject *> ("destroyed", &QUndoStack_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QUndoStack::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoStack, QUndoStack_EventAdaptor, int> ("indexChanged", &QUndoStack_EventAdaptor::indexChanged_e_767, gsi::arg("idx"), "@brief Signal declaration for QUndoStack::indexChanged(int idx)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoStack, QUndoStack_EventAdaptor, const QString &> ("redoTextChanged", &QUndoStack_EventAdaptor::redoTextChanged_e_2025, gsi::arg("redoText"), "@brief Signal declaration for QUndoStack::redoTextChanged(const QString &redoText)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoStack, QUndoStack_EventAdaptor, const QString &> ("undoTextChanged", &QUndoStack_EventAdaptor::undoTextChanged_e_2025, gsi::arg("undoText"), "@brief Signal declaration for QUndoStack::undoTextChanged(const QString &undoText)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QUndoStack");
}


class QUndoStack_Adaptor : public QUndoStack, public qt_gsi::QtObjectBase
{
public:

  virtual ~QUndoStack_Adaptor();

  //  [adaptor ctor] QUndoStack::QUndoStack(QObject *parent)
  QUndoStack_Adaptor() : QUndoStack()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUndoStack::QUndoStack(QObject *parent)
  QUndoStack_Adaptor(QObject *parent) : QUndoStack(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QUndoStack::receivers(const char *signal)
  int fp_QUndoStack_receivers_c1731 (const char *signal) const {
    return QUndoStack::receivers(signal);
  }

  //  QObject *QUndoStack::sender()
  QObject * fp_QUndoStack_sender_c0 () const {
    return QUndoStack::sender();
  }

  //  [adaptor impl] bool QUndoStack::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QUndoStack::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QUndoStack_Adaptor, bool, QEvent *>(&QUndoStack_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QUndoStack::event(arg1);
    }
  }

  //  [adaptor impl] bool QUndoStack::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QUndoStack::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QUndoStack_Adaptor, bool, QObject *, QEvent *>(&QUndoStack_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QUndoStack::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QUndoStack::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QUndoStack::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QUndoStack_Adaptor, QChildEvent *>(&QUndoStack_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QUndoStack::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoStack::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QUndoStack::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QUndoStack_Adaptor, QEvent *>(&QUndoStack_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QUndoStack::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoStack::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QUndoStack::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QUndoStack_Adaptor, const char *>(&QUndoStack_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QUndoStack::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QUndoStack::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QUndoStack::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QUndoStack_Adaptor, QTimerEvent *>(&QUndoStack_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QUndoStack::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QUndoStack_Adaptor::~QUndoStack_Adaptor() { }

//  Constructor QUndoStack::QUndoStack(QObject *parent) (adaptor class)

static void _init_ctor_QUndoStack_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QUndoStack_Adaptor *> ();
}

static void _call_ctor_QUndoStack_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QUndoStack_Adaptor *> (new QUndoStack_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUndoStack_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUndoStack::QUndoStack(QObject *parent)\nThis method creates an object of class QUndoStack.", &_init_ctor_QUndoStack_Adaptor_1302, &_call_ctor_QUndoStack_Adaptor_1302);
}

// int QUndoStack::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QUndoStack_Adaptor *)cls)->fp_QUndoStack_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QUndoStack::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QUndoStack::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QUndoStack_Adaptor *)cls)->fp_QUndoStack_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QUndoStack::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QUndoStack::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QUndoStack_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QUndoStack::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QUndoStack::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QUndoStack_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QUndoStack::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QUndoStack::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QUndoStack_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QUndoStack::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QUndoStack::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QUndoStack_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QUndoStack::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QUndoStack::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QUndoStack_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QUndoStack::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QUndoStack::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QUndoStack_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QUndoStack::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QUndoStack> decl_QUndoStack;

gsi::Class<QUndoStack_Adaptor> decl_QUndoStack_Adaptor (decl_QUndoStack, "QUndoStack",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QUndoStack_Adaptor_1302 ()),
  "@qt\n@brief Binding of QUndoStack");

}

