
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUdpSocket.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQUdpSocket_EventAdaptor.h"
#include "gsiDeclQUdpSocket_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUdpSocket

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QUdpSocket::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

//  Constructor QUdpSocket::QUdpSocket(QObject *parent)


static void _init_ctor_QUdpSocket_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QUdpSocket *> ();
}

static void _call_ctor_QUdpSocket_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QUdpSocket *> (new QUdpSocket (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUdpSocket_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUdpSocket::QUdpSocket(QObject *parent)\nThis method creates an object of class QUdpSocket.", &_init_ctor_QUdpSocket_1302, &_call_ctor_QUdpSocket_1302);
}

// bool QUdpSocket::bind(const QHostAddress &address, quint16 port)


static void _init_f_bind_3510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QHostAddress & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_bind_3510 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QHostAddress &arg1 = args.read<const QHostAddress & > ();
  quint16 arg2 = args.read<quint16 > ();
  ret.write<bool > ((bool)((QUdpSocket *)cls)->bind (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_bind_3510 ()
{
  return new qt_gsi::GenericMethod ("bind", "@brief Method bool QUdpSocket::bind(const QHostAddress &address, quint16 port)\n", false, &_init_f_bind_3510, &_call_f_bind_3510);
}

// bool QUdpSocket::bind(quint16 port)


static void _init_f_bind_1100 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("port", true, "0");
  decl->add_arg<quint16 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_bind_1100 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  quint16 arg1 = args ? args.read<quint16 > () : (quint16)(0);
  ret.write<bool > ((bool)((QUdpSocket *)cls)->bind (arg1));
}

static qt_gsi::GenericMethod *_create_f_bind_1100 ()
{
  return new qt_gsi::GenericMethod ("bind", "@brief Method bool QUdpSocket::bind(quint16 port)\n", false, &_init_f_bind_1100, &_call_f_bind_1100);
}

// bool QUdpSocket::bind(const QHostAddress &address, quint16 port, QFlags<QUdpSocket::BindFlag> mode)


static void _init_f_bind_6404 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QHostAddress & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFlags<QUdpSocket::BindFlag> >::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_bind_6404 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QHostAddress &arg1 = args.read<const QHostAddress & > ();
  quint16 arg2 = args.read<quint16 > ();
  const qt_gsi::Converter<QFlags<QUdpSocket::BindFlag> >::target_type & arg3 = args.read<const qt_gsi::Converter<QFlags<QUdpSocket::BindFlag> >::target_type & > ();
  ret.write<bool > ((bool)((QUdpSocket *)cls)->bind (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QUdpSocket::BindFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_bind_6404 ()
{
  return new qt_gsi::GenericMethod ("bind", "@brief Method bool QUdpSocket::bind(const QHostAddress &address, quint16 port, QFlags<QUdpSocket::BindFlag> mode)\n", false, &_init_f_bind_6404, &_call_f_bind_6404);
}

// bool QUdpSocket::bind(quint16 port, QFlags<QUdpSocket::BindFlag> mode)


static void _init_f_bind_3994 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("port");
  decl->add_arg<quint16 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFlags<QUdpSocket::BindFlag> >::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_bind_3994 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  quint16 arg1 = args.read<quint16 > ();
  const qt_gsi::Converter<QFlags<QUdpSocket::BindFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QUdpSocket::BindFlag> >::target_type & > ();
  ret.write<bool > ((bool)((QUdpSocket *)cls)->bind (arg1, qt_gsi::QtToCppAdaptor<QFlags<QUdpSocket::BindFlag> >(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_bind_3994 ()
{
  return new qt_gsi::GenericMethod ("bind", "@brief Method bool QUdpSocket::bind(quint16 port, QFlags<QUdpSocket::BindFlag> mode)\n", false, &_init_f_bind_3994, &_call_f_bind_3994);
}

// bool QUdpSocket::hasPendingDatagrams()


static void _init_f_hasPendingDatagrams_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasPendingDatagrams_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUdpSocket *)cls)->hasPendingDatagrams ());
}

static qt_gsi::GenericMethod *_create_f_hasPendingDatagrams_c0 ()
{
  return new qt_gsi::GenericMethod ("hasPendingDatagrams", "@brief Method bool QUdpSocket::hasPendingDatagrams()\n", true, &_init_f_hasPendingDatagrams_c0, &_call_f_hasPendingDatagrams_c0);
}

// qint64 QUdpSocket::pendingDatagramSize()


static void _init_f_pendingDatagramSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_pendingDatagramSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QUdpSocket *)cls)->pendingDatagramSize ());
}

static qt_gsi::GenericMethod *_create_f_pendingDatagramSize_c0 ()
{
  return new qt_gsi::GenericMethod ("pendingDatagramSize", "@brief Method qint64 QUdpSocket::pendingDatagramSize()\n", true, &_init_f_pendingDatagramSize_c0, &_call_f_pendingDatagramSize_c0);
}

// qint64 QUdpSocket::writeDatagram(const char *data, qint64 len, const QHostAddress &host, quint16 port)


static void _init_f_writeDatagram_6011 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<qint64 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("host");
  decl->add_arg<const QHostAddress & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("port");
  decl->add_arg<quint16 > (argspec_3);
  decl->set_return<qint64 > ();
}

static void _call_f_writeDatagram_6011 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  qint64 arg2 = args.read<qint64 > ();
  const QHostAddress &arg3 = args.read<const QHostAddress & > ();
  quint16 arg4 = args.read<quint16 > ();
  ret.write<qint64 > ((qint64)((QUdpSocket *)cls)->writeDatagram (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_writeDatagram_6011 ()
{
  return new qt_gsi::GenericMethod ("writeDatagram", "@brief Method qint64 QUdpSocket::writeDatagram(const char *data, qint64 len, const QHostAddress &host, quint16 port)\n", false, &_init_f_writeDatagram_6011, &_call_f_writeDatagram_6011);
}

// qint64 QUdpSocket::writeDatagram(const QByteArray &datagram, const QHostAddress &host, quint16 port)


static void _init_f_writeDatagram_5711 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("datagram");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("host");
  decl->add_arg<const QHostAddress & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("port");
  decl->add_arg<quint16 > (argspec_2);
  decl->set_return<qint64 > ();
}

static void _call_f_writeDatagram_5711 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const QHostAddress &arg2 = args.read<const QHostAddress & > ();
  quint16 arg3 = args.read<quint16 > ();
  ret.write<qint64 > ((qint64)((QUdpSocket *)cls)->writeDatagram (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_writeDatagram_5711 ()
{
  return new qt_gsi::GenericMethod ("writeDatagram", "@brief Method qint64 QUdpSocket::writeDatagram(const QByteArray &datagram, const QHostAddress &host, quint16 port)\n", false, &_init_f_writeDatagram_5711, &_call_f_writeDatagram_5711);
}

// static QString QUdpSocket::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QUdpSocket::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QUdpSocket::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QUdpSocket::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QUdpSocket::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QUdpSocket::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QUdpSocket::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QUdpSocket::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QUdpSocket::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QUdpSocket::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QUdpSocket::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QUdpSocket::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QUdpSocket, QUdpSocket_EventAdaptor> ea_QUdpSocket;


namespace gsi
{
extern gsi::Class<QAbstractSocket> decl_QAbstractSocket;

gsi::Class<QUdpSocket> decl_QUdpSocket (ea_QUdpSocket, decl_QAbstractSocket, "QUdpSocket",
  gsi::Methods(_create_ctor_QUdpSocket_1302 ()) +
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_bind_3510 ()) +
  gsi::Methods(_create_f_bind_1100 ()) +
  gsi::Methods(_create_f_bind_6404 ()) +
  gsi::Methods(_create_f_bind_3994 ()) +
  gsi::Methods(_create_f_hasPendingDatagrams_c0 ()) +
  gsi::Methods(_create_f_pendingDatagramSize_c0 ()) +
  gsi::Methods(_create_f_writeDatagram_6011 ()) +
  gsi::Methods(_create_f_writeDatagram_5711 ()) +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor> ("aboutToClose", &QUdpSocket_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QUdpSocket::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor, qint64> ("bytesWritten", &QUdpSocket_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QUdpSocket::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor> ("connected", &QUdpSocket_EventAdaptor::connected_e_0, "@brief Signal declaration for QUdpSocket::connected()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor, QObject *> ("destroyed", &QUdpSocket_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QUdpSocket::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor> ("disconnected", &QUdpSocket_EventAdaptor::disconnected_e_0, "@brief Signal declaration for QUdpSocket::disconnected()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor, const qt_gsi::Converter<QAbstractSocket::SocketError>::target_type &> ("error", &QUdpSocket_EventAdaptor::error_e_3209, gsi::arg("arg1"), "@brief Signal declaration for QUdpSocket::error(QAbstractSocket::SocketError)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor> ("hostFound", &QUdpSocket_EventAdaptor::hostFound_e_0, "@brief Signal declaration for QUdpSocket::hostFound()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor, const QNetworkProxy &, QAuthenticator *> ("proxyAuthenticationRequired", &QUdpSocket_EventAdaptor::proxyAuthenticationRequired_e_4652, gsi::arg("proxy"), gsi::arg("authenticator"), "@brief Signal declaration for QUdpSocket::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor> ("readChannelFinished", &QUdpSocket_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QUdpSocket::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor> ("readyRead", &QUdpSocket_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QUdpSocket::readyRead()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUdpSocket, QUdpSocket_EventAdaptor, const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type &> ("stateChanged", &QUdpSocket_EventAdaptor::stateChanged_e_3200, gsi::arg("arg1"), "@brief Signal declaration for QUdpSocket::stateChanged(QAbstractSocket::SocketState)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QUdpSocket");

}


//  Implementation of the enum wrapper class for QUdpSocket::BindFlag
namespace qt_gsi
{

static QUdpSocket_BindFlag_Enum *c_1_QUdpSocket_BindFlag_Enum () { return new QUdpSocket_BindFlag_Enum (QUdpSocket::DefaultForPlatform); }
static QUdpSocket_BindFlag_Enum *c_2_QUdpSocket_BindFlag_Enum () { return new QUdpSocket_BindFlag_Enum (QUdpSocket::ShareAddress); }
static QUdpSocket_BindFlag_Enum *c_3_QUdpSocket_BindFlag_Enum () { return new QUdpSocket_BindFlag_Enum (QUdpSocket::DontShareAddress); }
static QUdpSocket_BindFlag_Enum *c_4_QUdpSocket_BindFlag_Enum () { return new QUdpSocket_BindFlag_Enum (QUdpSocket::ReuseAddressHint); }

static gsi::Methods mkdefs_QUdpSocket_BindFlag () {
  return
    gsi::constant ("DefaultForPlatform", &qt_gsi::c_1_QUdpSocket_BindFlag_Enum, "@brief Enum constant QUdpSocket::DefaultForPlatform") +
    gsi::constant ("ShareAddress", &qt_gsi::c_2_QUdpSocket_BindFlag_Enum, "@brief Enum constant QUdpSocket::ShareAddress") +
    gsi::constant ("DontShareAddress", &qt_gsi::c_3_QUdpSocket_BindFlag_Enum, "@brief Enum constant QUdpSocket::DontShareAddress") +
    gsi::constant ("ReuseAddressHint", &qt_gsi::c_4_QUdpSocket_BindFlag_Enum, "@brief Enum constant QUdpSocket::ReuseAddressHint");
}

static std::string to_s_QUdpSocket_BindFlag_Enum (const QUdpSocket_BindFlag_Enum *e)
{
  if (e->value () == QUdpSocket::DefaultForPlatform) { return tl::sprintf ("DefaultForPlatform (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUdpSocket::ShareAddress) { return tl::sprintf ("ShareAddress (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUdpSocket::DontShareAddress) { return tl::sprintf ("DontShareAddress (%u)", (unsigned int) e->value ()); }
  if (e->value () == QUdpSocket::ReuseAddressHint) { return tl::sprintf ("ReuseAddressHint (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QUdpSocket_BindFlag_Enum (const QUdpSocket_BindFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QUdpSocket_BindFlag_Enum *from_i_QUdpSocket_BindFlag_Enum (unsigned int i)
{
  return new QUdpSocket_BindFlag_Enum ((QUdpSocket::BindFlag) i);
}

static bool equalQUdpSocket_BindFlag_Enum (const QUdpSocket_BindFlag_Enum *e, QUdpSocket_BindFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QUdpSocket_BindFlag_Enum (const QUdpSocket_BindFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QUdpSocket_BindFlag_Enums oropQUdpSocket_BindFlag_Enums (const QUdpSocket_BindFlag_Enums *e, const QUdpSocket_BindFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QUdpSocket_BindFlag_Enums andopQUdpSocket_BindFlag_Enums (const QUdpSocket_BindFlag_Enums *e, const QUdpSocket_BindFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QUdpSocket_BindFlag_Enums xoropQUdpSocket_BindFlag_Enums (const QUdpSocket_BindFlag_Enums *e, const QUdpSocket_BindFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QUdpSocket_BindFlag_Enums (const QUdpSocket_BindFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QUdpSocket::DefaultForPlatform)) { if (!l.empty ()) l += "|"; l += "DefaultForPlatform"; }
  if (e->testFlag (QUdpSocket::ShareAddress)) { if (!l.empty ()) l += "|"; l += "ShareAddress"; }
  if (e->testFlag (QUdpSocket::DontShareAddress)) { if (!l.empty ()) l += "|"; l += "DontShareAddress"; }
  if (e->testFlag (QUdpSocket::ReuseAddressHint)) { if (!l.empty ()) l += "|"; l += "ReuseAddressHint"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QUdpSocket_BindFlag_Enums (const QUdpSocket_BindFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QUdpSocket_BindFlag_Enums (const QUdpSocket_BindFlag_Enums *e, const QUdpSocket_BindFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QUdpSocket_BindFlag_Enums> decl_QUdpSocket_BindFlag_Enums ("QUdpSocket_QFlags_BindFlag",
  gsi::method_ext ("|", &qt_gsi::oropQUdpSocket_BindFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQUdpSocket_BindFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQUdpSocket_BindFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QUdpSocket_BindFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QUdpSocket_BindFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QUdpSocket_BindFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QUdpSocket::BindFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QUdpSocket_BindFlag_Enum> decl_QUdpSocket_BindFlag_Enum (decl_QUdpSocket_BindFlag_Enums, "QUdpSocket_BindFlag",
  qt_gsi::mkdefs_QUdpSocket_BindFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QUdpSocket_BindFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QUdpSocket_BindFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQUdpSocket_BindFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QUdpSocket_BindFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QUdpSocket_BindFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QUdpSocket::BindFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QUdpSocket> inject_QUdpSocket_BindFlag_Enum_in_parent (qt_gsi::mkdefs_QUdpSocket_BindFlag ());
static gsi::ClassExt<QUdpSocket> decl_QUdpSocket_BindFlag_Enum_as_child (decl_QUdpSocket_BindFlag_Enum, "BindFlag");

}

