
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTransform.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTransform_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTransform

//  Constructor QTransform::QTransform(Qt::Initialization)


static void _init_ctor_QTransform_2229 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::Initialization>::target_type & > (argspec_0);
  decl->set_return_new<QTransform *> ();
}

static void _call_ctor_QTransform_2229 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::Initialization>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Initialization>::target_type & > ();
  ret.write<QTransform *> (new QTransform (qt_gsi::QtToCppAdaptor<Qt::Initialization>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTransform_2229 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransform::QTransform(Qt::Initialization)\nThis method creates an object of class QTransform.", &_init_ctor_QTransform_2229, &_call_ctor_QTransform_2229);
}

//  Constructor QTransform::QTransform()


static void _init_ctor_QTransform_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTransform *> ();
}

static void _call_ctor_QTransform_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTransform *> (new QTransform ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTransform_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransform::QTransform()\nThis method creates an object of class QTransform.", &_init_ctor_QTransform_0, &_call_ctor_QTransform_0);
}

//  Constructor QTransform::QTransform(double h11, double h12, double h13, double h21, double h22, double h23, double h31, double h32, double h33)


static void _init_ctor_QTransform_8775 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h11");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h12");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h13");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h21");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h22");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("h23");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("h31");
  decl->add_arg<double > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("h32");
  decl->add_arg<double > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("h33", true, "1.0");
  decl->add_arg<double > (argspec_8);
  decl->set_return_new<QTransform *> ();
}

static void _call_ctor_QTransform_8775 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  double arg7 = args.read<double > ();
  double arg8 = args.read<double > ();
  double arg9 = args ? args.read<double > () : (double)(1.0);
  ret.write<QTransform *> (new QTransform (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTransform_8775 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransform::QTransform(double h11, double h12, double h13, double h21, double h22, double h23, double h31, double h32, double h33)\nThis method creates an object of class QTransform.", &_init_ctor_QTransform_8775, &_call_ctor_QTransform_8775);
}

//  Constructor QTransform::QTransform(double h11, double h12, double h21, double h22, double dx, double dy)


static void _init_ctor_QTransform_5886 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h11");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h12");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h21");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h22");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("dx");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("dy");
  decl->add_arg<double > (argspec_5);
  decl->set_return_new<QTransform *> ();
}

static void _call_ctor_QTransform_5886 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  ret.write<QTransform *> (new QTransform (arg1, arg2, arg3, arg4, arg5, arg6));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTransform_5886 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransform::QTransform(double h11, double h12, double h21, double h22, double dx, double dy)\nThis method creates an object of class QTransform.", &_init_ctor_QTransform_5886, &_call_ctor_QTransform_5886);
}

//  Constructor QTransform::QTransform(const QMatrix &mtx)


static void _init_ctor_QTransform_2023 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mtx");
  decl->add_arg<const QMatrix & > (argspec_0);
  decl->set_return_new<QTransform *> ();
}

static void _call_ctor_QTransform_2023 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  ret.write<QTransform *> (new QTransform (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTransform_2023 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTransform::QTransform(const QMatrix &mtx)\nThis method creates an object of class QTransform.", &_init_ctor_QTransform_2023, &_call_ctor_QTransform_2023);
}

// QTransform QTransform::adjoint()


static void _init_f_adjoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_adjoint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTransform > ((QTransform)((QTransform *)cls)->adjoint ());
}

static qt_gsi::GenericMethod *_create_f_adjoint_c0 ()
{
  return new qt_gsi::GenericMethod ("adjoint", "@brief Method QTransform QTransform::adjoint()\n", true, &_init_f_adjoint_c0, &_call_f_adjoint_c0);
}

// double QTransform::det()


static void _init_f_det_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_det_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->det ());
}

static qt_gsi::GenericMethod *_create_f_det_c0 ()
{
  return new qt_gsi::GenericMethod ("det", "@brief Method double QTransform::det()\n", true, &_init_f_det_c0, &_call_f_det_c0);
}

// double QTransform::determinant()


static void _init_f_determinant_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_determinant_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->determinant ());
}

static qt_gsi::GenericMethod *_create_f_determinant_c0 ()
{
  return new qt_gsi::GenericMethod ("determinant", "@brief Method double QTransform::determinant()\n", true, &_init_f_determinant_c0, &_call_f_determinant_c0);
}

// double QTransform::dx()


static void _init_f_dx_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_dx_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->dx ());
}

static qt_gsi::GenericMethod *_create_f_dx_c0 ()
{
  return new qt_gsi::GenericMethod ("dx", "@brief Method double QTransform::dx()\n", true, &_init_f_dx_c0, &_call_f_dx_c0);
}

// double QTransform::dy()


static void _init_f_dy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_dy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->dy ());
}

static qt_gsi::GenericMethod *_create_f_dy_c0 ()
{
  return new qt_gsi::GenericMethod ("dy", "@brief Method double QTransform::dy()\n", true, &_init_f_dy_c0, &_call_f_dy_c0);
}

// QTransform QTransform::inverted(bool *invertible)


static void _init_f_inverted_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("invertible", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<QTransform > ();
}

static void _call_f_inverted_c1050 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool *arg1 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<QTransform > ((QTransform)((QTransform *)cls)->inverted (arg1));
}

static qt_gsi::GenericMethod *_create_f_inverted_c1050 ()
{
  return new qt_gsi::GenericMethod ("inverted", "@brief Method QTransform QTransform::inverted(bool *invertible)\n", true, &_init_f_inverted_c1050, &_call_f_inverted_c1050);
}

// bool QTransform::isAffine()


static void _init_f_isAffine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAffine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTransform *)cls)->isAffine ());
}

static qt_gsi::GenericMethod *_create_f_isAffine_c0 ()
{
  return new qt_gsi::GenericMethod ("isAffine?", "@brief Method bool QTransform::isAffine()\n", true, &_init_f_isAffine_c0, &_call_f_isAffine_c0);
}

// bool QTransform::isIdentity()


static void _init_f_isIdentity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isIdentity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTransform *)cls)->isIdentity ());
}

static qt_gsi::GenericMethod *_create_f_isIdentity_c0 ()
{
  return new qt_gsi::GenericMethod ("isIdentity?", "@brief Method bool QTransform::isIdentity()\n", true, &_init_f_isIdentity_c0, &_call_f_isIdentity_c0);
}

// bool QTransform::isInvertible()


static void _init_f_isInvertible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isInvertible_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTransform *)cls)->isInvertible ());
}

static qt_gsi::GenericMethod *_create_f_isInvertible_c0 ()
{
  return new qt_gsi::GenericMethod ("isInvertible?", "@brief Method bool QTransform::isInvertible()\n", true, &_init_f_isInvertible_c0, &_call_f_isInvertible_c0);
}

// bool QTransform::isRotating()


static void _init_f_isRotating_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRotating_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTransform *)cls)->isRotating ());
}

static qt_gsi::GenericMethod *_create_f_isRotating_c0 ()
{
  return new qt_gsi::GenericMethod ("isRotating?", "@brief Method bool QTransform::isRotating()\n", true, &_init_f_isRotating_c0, &_call_f_isRotating_c0);
}

// bool QTransform::isScaling()


static void _init_f_isScaling_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isScaling_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTransform *)cls)->isScaling ());
}

static qt_gsi::GenericMethod *_create_f_isScaling_c0 ()
{
  return new qt_gsi::GenericMethod ("isScaling?", "@brief Method bool QTransform::isScaling()\n", true, &_init_f_isScaling_c0, &_call_f_isScaling_c0);
}

// bool QTransform::isTranslating()


static void _init_f_isTranslating_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTranslating_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTransform *)cls)->isTranslating ());
}

static qt_gsi::GenericMethod *_create_f_isTranslating_c0 ()
{
  return new qt_gsi::GenericMethod ("isTranslating?", "@brief Method bool QTransform::isTranslating()\n", true, &_init_f_isTranslating_c0, &_call_f_isTranslating_c0);
}

// double QTransform::m11()


static void _init_f_m11_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m11_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->m11 ());
}

static qt_gsi::GenericMethod *_create_f_m11_c0 ()
{
  return new qt_gsi::GenericMethod ("m11", "@brief Method double QTransform::m11()\n", true, &_init_f_m11_c0, &_call_f_m11_c0);
}

// double QTransform::m12()


static void _init_f_m12_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m12_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->m12 ());
}

static qt_gsi::GenericMethod *_create_f_m12_c0 ()
{
  return new qt_gsi::GenericMethod ("m12", "@brief Method double QTransform::m12()\n", true, &_init_f_m12_c0, &_call_f_m12_c0);
}

// double QTransform::m13()


static void _init_f_m13_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m13_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->m13 ());
}

static qt_gsi::GenericMethod *_create_f_m13_c0 ()
{
  return new qt_gsi::GenericMethod ("m13", "@brief Method double QTransform::m13()\n", true, &_init_f_m13_c0, &_call_f_m13_c0);
}

// double QTransform::m21()


static void _init_f_m21_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m21_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->m21 ());
}

static qt_gsi::GenericMethod *_create_f_m21_c0 ()
{
  return new qt_gsi::GenericMethod ("m21", "@brief Method double QTransform::m21()\n", true, &_init_f_m21_c0, &_call_f_m21_c0);
}

// double QTransform::m22()


static void _init_f_m22_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m22_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->m22 ());
}

static qt_gsi::GenericMethod *_create_f_m22_c0 ()
{
  return new qt_gsi::GenericMethod ("m22", "@brief Method double QTransform::m22()\n", true, &_init_f_m22_c0, &_call_f_m22_c0);
}

// double QTransform::m23()


static void _init_f_m23_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m23_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->m23 ());
}

static qt_gsi::GenericMethod *_create_f_m23_c0 ()
{
  return new qt_gsi::GenericMethod ("m23", "@brief Method double QTransform::m23()\n", true, &_init_f_m23_c0, &_call_f_m23_c0);
}

// double QTransform::m31()


static void _init_f_m31_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m31_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->m31 ());
}

static qt_gsi::GenericMethod *_create_f_m31_c0 ()
{
  return new qt_gsi::GenericMethod ("m31", "@brief Method double QTransform::m31()\n", true, &_init_f_m31_c0, &_call_f_m31_c0);
}

// double QTransform::m32()


static void _init_f_m32_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m32_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->m32 ());
}

static qt_gsi::GenericMethod *_create_f_m32_c0 ()
{
  return new qt_gsi::GenericMethod ("m32", "@brief Method double QTransform::m32()\n", true, &_init_f_m32_c0, &_call_f_m32_c0);
}

// double QTransform::m33()


static void _init_f_m33_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_m33_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTransform *)cls)->m33 ());
}

static qt_gsi::GenericMethod *_create_f_m33_c0 ()
{
  return new qt_gsi::GenericMethod ("m33", "@brief Method double QTransform::m33()\n", true, &_init_f_m33_c0, &_call_f_m33_c0);
}

// QPoint QTransform::map(const QPoint &p)


static void _init_f_map_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_map_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPoint > ((QPoint)((QTransform *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c1916 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QPoint QTransform::map(const QPoint &p)\n", true, &_init_f_map_c1916, &_call_f_map_c1916);
}

// QPointF QTransform::map(const QPointF &p)


static void _init_f_map_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_map_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QPointF > ((QPointF)((QTransform *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c1986 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QPointF QTransform::map(const QPointF &p)\n", true, &_init_f_map_c1986, &_call_f_map_c1986);
}

// QLine QTransform::map(const QLine &l)


static void _init_f_map_c1786 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<const QLine & > (argspec_0);
  decl->set_return<QLine > ();
}

static void _call_f_map_c1786 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLine &arg1 = args.read<const QLine & > ();
  ret.write<QLine > ((QLine)((QTransform *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c1786 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QLine QTransform::map(const QLine &l)\n", true, &_init_f_map_c1786, &_call_f_map_c1786);
}

// QLineF QTransform::map(const QLineF &l)


static void _init_f_map_c1856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<const QLineF & > (argspec_0);
  decl->set_return<QLineF > ();
}

static void _call_f_map_c1856 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLineF &arg1 = args.read<const QLineF & > ();
  ret.write<QLineF > ((QLineF)((QTransform *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c1856 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QLineF QTransform::map(const QLineF &l)\n", true, &_init_f_map_c1856, &_call_f_map_c1856);
}

// QPolygonF QTransform::map(const QPolygonF &a)


static void _init_f_map_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_map_c2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ret.write<QPolygonF > ((QPolygonF)((QTransform *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c2208 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QPolygonF QTransform::map(const QPolygonF &a)\n", true, &_init_f_map_c2208, &_call_f_map_c2208);
}

// QPolygon QTransform::map(const QPolygon &a)


static void _init_f_map_c2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_map_c2138 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  ret.write<QPolygon > ((QPolygon)((QTransform *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c2138 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QPolygon QTransform::map(const QPolygon &a)\n", true, &_init_f_map_c2138, &_call_f_map_c2138);
}

// QRegion QTransform::map(const QRegion &r)


static void _init_f_map_c2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_f_map_c2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ret.write<QRegion > ((QRegion)((QTransform *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c2006 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QRegion QTransform::map(const QRegion &r)\n", true, &_init_f_map_c2006, &_call_f_map_c2006);
}

// QPainterPath QTransform::map(const QPainterPath &p)


static void _init_f_map_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_map_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QTransform *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c2514 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QPainterPath QTransform::map(const QPainterPath &p)\n", true, &_init_f_map_c2514, &_call_f_map_c2514);
}

// void QTransform::map(int x, int y, int *tx, int *ty)


static void _init_f_map_c3116 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("tx");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("ty");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_map_c3116 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int *arg3 = args.read<int * > ();
  int *arg4 = args.read<int * > ();
  ((QTransform *)cls)->map (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_map_c3116 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method void QTransform::map(int x, int y, int *tx, int *ty)\n", true, &_init_f_map_c3116, &_call_f_map_c3116);
}

// void QTransform::map(double x, double y, double *tx, double *ty)


static void _init_f_map_c4332 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("tx");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("ty");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_map_c4332 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double *arg3 = args.read<double * > ();
  double *arg4 = args.read<double * > ();
  ((QTransform *)cls)->map (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_map_c4332 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method void QTransform::map(double x, double y, double *tx, double *ty)\n", true, &_init_f_map_c4332, &_call_f_map_c4332);
}

// QRect QTransform::mapRect(const QRect &)


static void _init_f_mapRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_mapRect_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QRect > ((QRect)((QTransform *)cls)->mapRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapRect_c1792 ()
{
  return new qt_gsi::GenericMethod ("mapRect", "@brief Method QRect QTransform::mapRect(const QRect &)\n", true, &_init_f_mapRect_c1792, &_call_f_mapRect_c1792);
}

// QRectF QTransform::mapRect(const QRectF &)


static void _init_f_mapRect_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRect_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QTransform *)cls)->mapRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapRect_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapRect", "@brief Method QRectF QTransform::mapRect(const QRectF &)\n", true, &_init_f_mapRect_c1862, &_call_f_mapRect_c1862);
}

// QPolygon QTransform::mapToPolygon(const QRect &r)


static void _init_f_mapToPolygon_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_mapToPolygon_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QPolygon > ((QPolygon)((QTransform *)cls)->mapToPolygon (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToPolygon_c1792 ()
{
  return new qt_gsi::GenericMethod ("mapToPolygon", "@brief Method QPolygon QTransform::mapToPolygon(const QRect &r)\n", true, &_init_f_mapToPolygon_c1792, &_call_f_mapToPolygon_c1792);
}

// bool QTransform::operator!=(const QTransform &)


static void _init_f_operator_excl__eq__c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<bool > ((bool)((QTransform *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2350 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QTransform::operator!=(const QTransform &)\n", true, &_init_f_operator_excl__eq__c2350, &_call_f_operator_excl__eq__c2350);
}

// QTransform QTransform::operator*(const QTransform &o)


static void _init_f_operator_star__c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("o");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QTransform > ();
}

static void _call_f_operator_star__c2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<QTransform > ((QTransform)((QTransform *)cls)->operator* (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__c2350 ()
{
  return new qt_gsi::GenericMethod ("*", "@brief Method QTransform QTransform::operator*(const QTransform &o)\n", true, &_init_f_operator_star__c2350, &_call_f_operator_star__c2350);
}

// QTransform &QTransform::operator*=(const QTransform &)


static void _init_f_operator_star__eq__2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_star__eq__2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator*= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__eq__2350 ()
{
  return new qt_gsi::GenericMethod ("*=", "@brief Method QTransform &QTransform::operator*=(const QTransform &)\n", false, &_init_f_operator_star__eq__2350, &_call_f_operator_star__eq__2350);
}

// QTransform &QTransform::operator*=(double div)


static void _init_f_operator_star__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("div");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_star__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator*= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("*=", "@brief Method QTransform &QTransform::operator*=(double div)\n", false, &_init_f_operator_star__eq__1071, &_call_f_operator_star__eq__1071);
}

// QTransform &QTransform::operator+=(double div)


static void _init_f_operator_plus__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("div");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_plus__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator+= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_plus__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("+=", "@brief Method QTransform &QTransform::operator+=(double div)\n", false, &_init_f_operator_plus__eq__1071, &_call_f_operator_plus__eq__1071);
}

// QTransform &QTransform::operator-=(double div)


static void _init_f_operator_minus__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("div");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_minus__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator-= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_minus__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("-=", "@brief Method QTransform &QTransform::operator-=(double div)\n", false, &_init_f_operator_minus__eq__1071, &_call_f_operator_minus__eq__1071);
}

// QTransform &QTransform::operator/=(double div)


static void _init_f_operator_slash__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("div");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_slash__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator/= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_slash__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("/=", "@brief Method QTransform &QTransform::operator/=(double div)\n", false, &_init_f_operator_slash__eq__1071, &_call_f_operator_slash__eq__1071);
}

// QTransform &QTransform::operator=(const QTransform &)


static void _init_f_operator_eq__2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QTransform & > ();
}

static void _call_f_operator_eq__2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2350 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QTransform &QTransform::operator=(const QTransform &)\n", false, &_init_f_operator_eq__2350, &_call_f_operator_eq__2350);
}

// bool QTransform::operator==(const QTransform &)


static void _init_f_operator_eq__eq__c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<bool > ((bool)((QTransform *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2350 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QTransform::operator==(const QTransform &)\n", true, &_init_f_operator_eq__eq__c2350, &_call_f_operator_eq__eq__c2350);
}

// void QTransform::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTransform *)cls)->reset ();
}

static qt_gsi::GenericMethod *_create_f_reset_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Method void QTransform::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
}

// QTransform &QTransform::rotate(double a, Qt::Axis axis)


static void _init_f_rotate_2117 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("axis", true, "Qt::ZAxis");
  decl->add_arg<const qt_gsi::Converter<Qt::Axis>::target_type & > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_rotate_2117 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Axis>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::Axis>::target_type & > () : (const qt_gsi::Converter<Qt::Axis>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::Axis>(heap, Qt::ZAxis));
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->rotate (arg1, qt_gsi::QtToCppAdaptor<Qt::Axis>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_rotate_2117 ()
{
  return new qt_gsi::GenericMethod ("rotate", "@brief Method QTransform &QTransform::rotate(double a, Qt::Axis axis)\n", false, &_init_f_rotate_2117, &_call_f_rotate_2117);
}

// QTransform &QTransform::rotateRadians(double a, Qt::Axis axis)


static void _init_f_rotateRadians_2117 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("axis", true, "Qt::ZAxis");
  decl->add_arg<const qt_gsi::Converter<Qt::Axis>::target_type & > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_rotateRadians_2117 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Axis>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::Axis>::target_type & > () : (const qt_gsi::Converter<Qt::Axis>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::Axis>(heap, Qt::ZAxis));
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->rotateRadians (arg1, qt_gsi::QtToCppAdaptor<Qt::Axis>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_rotateRadians_2117 ()
{
  return new qt_gsi::GenericMethod ("rotateRadians", "@brief Method QTransform &QTransform::rotateRadians(double a, Qt::Axis axis)\n", false, &_init_f_rotateRadians_2117, &_call_f_rotateRadians_2117);
}

// QTransform &QTransform::scale(double sx, double sy)


static void _init_f_scale_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_scale_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->scale (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_scale_2034 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method QTransform &QTransform::scale(double sx, double sy)\n", false, &_init_f_scale_2034, &_call_f_scale_2034);
}

// void QTransform::setMatrix(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33)


static void _init_f_setMatrix_8775 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m11");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m12");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("m13");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("m21");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("m22");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("m23");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("m31");
  decl->add_arg<double > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("m32");
  decl->add_arg<double > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("m33");
  decl->add_arg<double > (argspec_8);
  decl->set_return<void > ();
}

static void _call_f_setMatrix_8775 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  double arg7 = args.read<double > ();
  double arg8 = args.read<double > ();
  double arg9 = args.read<double > ();
  ((QTransform *)cls)->setMatrix (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
}

static qt_gsi::GenericMethod *_create_f_setMatrix_8775 ()
{
  return new qt_gsi::GenericMethod ("setMatrix", "@brief Method void QTransform::setMatrix(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33)\n", false, &_init_f_setMatrix_8775, &_call_f_setMatrix_8775);
}

// QTransform &QTransform::shear(double sh, double sv)


static void _init_f_shear_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sv");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_shear_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->shear (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_shear_2034 ()
{
  return new qt_gsi::GenericMethod ("shear", "@brief Method QTransform &QTransform::shear(double sh, double sv)\n", false, &_init_f_shear_2034, &_call_f_shear_2034);
}

// const QMatrix &QTransform::toAffine()


static void _init_f_toAffine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMatrix & > ();
}

static void _call_f_toAffine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMatrix & > ((const QMatrix &)((QTransform *)cls)->toAffine ());
}

static qt_gsi::GenericMethod *_create_f_toAffine_c0 ()
{
  return new qt_gsi::GenericMethod ("toAffine", "@brief Method const QMatrix &QTransform::toAffine()\n", true, &_init_f_toAffine_c0, &_call_f_toAffine_c0);
}

// QTransform &QTransform::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform & > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QTransform & > ((QTransform &)((QTransform *)cls)->translate (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_translate_2034 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method QTransform &QTransform::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
}

// QTransform QTransform::transposed()


static void _init_f_transposed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_transposed_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTransform > ((QTransform)((QTransform *)cls)->transposed ());
}

static qt_gsi::GenericMethod *_create_f_transposed_c0 ()
{
  return new qt_gsi::GenericMethod ("transposed", "@brief Method QTransform QTransform::transposed()\n", true, &_init_f_transposed_c0, &_call_f_transposed_c0);
}

// QTransform::TransformationType QTransform::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTransform::TransformationType>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTransform::TransformationType>::target_type > ((qt_gsi::Converter<QTransform::TransformationType>::target_type)qt_gsi::CppToQtAdaptor<QTransform::TransformationType>(((QTransform *)cls)->type ()));
}

static qt_gsi::GenericMethod *_create_f_type_c0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method QTransform::TransformationType QTransform::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
}

// static QTransform QTransform::fromScale(double dx, double dy)


static void _init_f_fromScale_2034 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform > ();
}

static void _call_f_fromScale_2034 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QTransform > ((QTransform)QTransform::fromScale (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_fromScale_2034 ()
{
  return new qt_gsi::GenericStaticMethod ("fromScale", "@brief Static method QTransform QTransform::fromScale(double dx, double dy)\nThis method is static and can be called without an instance.", &_init_f_fromScale_2034, &_call_f_fromScale_2034);
}

// static QTransform QTransform::fromTranslate(double dx, double dy)


static void _init_f_fromTranslate_2034 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QTransform > ();
}

static void _call_f_fromTranslate_2034 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QTransform > ((QTransform)QTransform::fromTranslate (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_fromTranslate_2034 ()
{
  return new qt_gsi::GenericStaticMethod ("fromTranslate", "@brief Static method QTransform QTransform::fromTranslate(double dx, double dy)\nThis method is static and can be called without an instance.", &_init_f_fromTranslate_2034, &_call_f_fromTranslate_2034);
}

// static bool QTransform::quadToQuad(const QPolygonF &one, const QPolygonF &two, QTransform &result)


static void _init_f_quadToQuad_5855 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("one");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("two");
  decl->add_arg<const QPolygonF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QTransform & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_quadToQuad_5855 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  const QPolygonF &arg2 = args.read<const QPolygonF & > ();
  QTransform &arg3 = args.read<QTransform & > ();
  ret.write<bool > ((bool)QTransform::quadToQuad (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_quadToQuad_5855 ()
{
  return new qt_gsi::GenericStaticMethod ("quadToQuad", "@brief Static method bool QTransform::quadToQuad(const QPolygonF &one, const QPolygonF &two, QTransform &result)\nThis method is static and can be called without an instance.", &_init_f_quadToQuad_5855, &_call_f_quadToQuad_5855);
}

// static bool QTransform::quadToSquare(const QPolygonF &quad, QTransform &result)


static void _init_f_quadToSquare_3755 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quad");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("result");
  decl->add_arg<QTransform & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_quadToSquare_3755 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  QTransform &arg2 = args.read<QTransform & > ();
  ret.write<bool > ((bool)QTransform::quadToSquare (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_quadToSquare_3755 ()
{
  return new qt_gsi::GenericStaticMethod ("quadToSquare", "@brief Static method bool QTransform::quadToSquare(const QPolygonF &quad, QTransform &result)\nThis method is static and can be called without an instance.", &_init_f_quadToSquare_3755, &_call_f_quadToSquare_3755);
}

// static bool QTransform::squareToQuad(const QPolygonF &square, QTransform &result)


static void _init_f_squareToQuad_3755 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("square");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("result");
  decl->add_arg<QTransform & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_squareToQuad_3755 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  QTransform &arg2 = args.read<QTransform & > ();
  ret.write<bool > ((bool)QTransform::squareToQuad (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_squareToQuad_3755 ()
{
  return new qt_gsi::GenericStaticMethod ("squareToQuad", "@brief Static method bool QTransform::squareToQuad(const QPolygonF &square, QTransform &result)\nThis method is static and can be called without an instance.", &_init_f_squareToQuad_3755, &_call_f_squareToQuad_3755);
}

//  QTransform ::operator *(const QTransform &a, qreal n)
static QTransform op_QTransform_operator_star__3211(const QTransform *_self, qreal n) {
  return ::operator *(*_self, n);
}

//  QTransform ::operator /(const QTransform &a, qreal n)
static QTransform op_QTransform_operator_slash__3211(const QTransform *_self, qreal n) {
  return ::operator /(*_self, n);
}

//  QTransform ::operator +(const QTransform &a, qreal n)
static QTransform op_QTransform_operator_plus__3211(const QTransform *_self, qreal n) {
  return ::operator +(*_self, n);
}

//  QTransform ::operator -(const QTransform &a, qreal n)
static QTransform op_QTransform_operator_minus__3211(const QTransform *_self, qreal n) {
  return ::operator -(*_self, n);
}


namespace gsi
{
gsi::Class<QTransform> decl_QTransform ("QTransform",
  gsi::Methods(_create_ctor_QTransform_2229 ()) +
  gsi::Methods(_create_ctor_QTransform_0 ()) +
  gsi::Methods(_create_ctor_QTransform_8775 ()) +
  gsi::Methods(_create_ctor_QTransform_5886 ()) +
  gsi::Methods(_create_ctor_QTransform_2023 ()) +
  gsi::Methods(_create_f_adjoint_c0 ()) +
  gsi::Methods(_create_f_det_c0 ()) +
  gsi::Methods(_create_f_determinant_c0 ()) +
  gsi::Methods(_create_f_dx_c0 ()) +
  gsi::Methods(_create_f_dy_c0 ()) +
  gsi::Methods(_create_f_inverted_c1050 ()) +
  gsi::Methods(_create_f_isAffine_c0 ()) +
  gsi::Methods(_create_f_isIdentity_c0 ()) +
  gsi::Methods(_create_f_isInvertible_c0 ()) +
  gsi::Methods(_create_f_isRotating_c0 ()) +
  gsi::Methods(_create_f_isScaling_c0 ()) +
  gsi::Methods(_create_f_isTranslating_c0 ()) +
  gsi::Methods(_create_f_m11_c0 ()) +
  gsi::Methods(_create_f_m12_c0 ()) +
  gsi::Methods(_create_f_m13_c0 ()) +
  gsi::Methods(_create_f_m21_c0 ()) +
  gsi::Methods(_create_f_m22_c0 ()) +
  gsi::Methods(_create_f_m23_c0 ()) +
  gsi::Methods(_create_f_m31_c0 ()) +
  gsi::Methods(_create_f_m32_c0 ()) +
  gsi::Methods(_create_f_m33_c0 ()) +
  gsi::Methods(_create_f_map_c1916 ()) +
  gsi::Methods(_create_f_map_c1986 ()) +
  gsi::Methods(_create_f_map_c1786 ()) +
  gsi::Methods(_create_f_map_c1856 ()) +
  gsi::Methods(_create_f_map_c2208 ()) +
  gsi::Methods(_create_f_map_c2138 ()) +
  gsi::Methods(_create_f_map_c2006 ()) +
  gsi::Methods(_create_f_map_c2514 ()) +
  gsi::Methods(_create_f_map_c3116 ()) +
  gsi::Methods(_create_f_map_c4332 ()) +
  gsi::Methods(_create_f_mapRect_c1792 ()) +
  gsi::Methods(_create_f_mapRect_c1862 ()) +
  gsi::Methods(_create_f_mapToPolygon_c1792 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2350 ()) +
  gsi::Methods(_create_f_operator_star__c2350 ()) +
  gsi::Methods(_create_f_operator_star__eq__2350 ()) +
  gsi::Methods(_create_f_operator_star__eq__1071 ()) +
  gsi::Methods(_create_f_operator_plus__eq__1071 ()) +
  gsi::Methods(_create_f_operator_minus__eq__1071 ()) +
  gsi::Methods(_create_f_operator_slash__eq__1071 ()) +
  gsi::Methods(_create_f_operator_eq__2350 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2350 ()) +
  gsi::Methods(_create_f_reset_0 ()) +
  gsi::Methods(_create_f_rotate_2117 ()) +
  gsi::Methods(_create_f_rotateRadians_2117 ()) +
  gsi::Methods(_create_f_scale_2034 ()) +
  gsi::Methods(_create_f_setMatrix_8775 ()) +
  gsi::Methods(_create_f_shear_2034 ()) +
  gsi::Methods(_create_f_toAffine_c0 ()) +
  gsi::Methods(_create_f_translate_2034 ()) +
  gsi::Methods(_create_f_transposed_c0 ()) +
  gsi::Methods(_create_f_type_c0 ()) +
  gsi::Methods(_create_f_fromScale_2034 ()) +
  gsi::Methods(_create_f_fromTranslate_2034 ()) +
  gsi::Methods(_create_f_quadToQuad_5855 ()) +
  gsi::Methods(_create_f_quadToSquare_3755 ()) +
  gsi::Methods(_create_f_squareToQuad_3755 ()) +
  gsi::method_ext("*", &::op_QTransform_operator_star__3211, gsi::arg ("n"), "@brief Operator QTransform ::operator *(const QTransform &a, qreal n)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("/", &::op_QTransform_operator_slash__3211, gsi::arg ("n"), "@brief Operator QTransform ::operator /(const QTransform &a, qreal n)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("+", &::op_QTransform_operator_plus__3211, gsi::arg ("n"), "@brief Operator QTransform ::operator +(const QTransform &a, qreal n)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("-", &::op_QTransform_operator_minus__3211, gsi::arg ("n"), "@brief Operator QTransform ::operator -(const QTransform &a, qreal n)\nThis is the mapping of the global operator to the instance method."),
  "@qt\n@brief Binding of QTransform");

}


//  Implementation of the enum wrapper class for QTransform::TransformationType
namespace qt_gsi
{

static QTransform_TransformationType_Enum *c_1_QTransform_TransformationType_Enum () { return new QTransform_TransformationType_Enum (QTransform::TxNone); }
static QTransform_TransformationType_Enum *c_2_QTransform_TransformationType_Enum () { return new QTransform_TransformationType_Enum (QTransform::TxTranslate); }
static QTransform_TransformationType_Enum *c_3_QTransform_TransformationType_Enum () { return new QTransform_TransformationType_Enum (QTransform::TxScale); }
static QTransform_TransformationType_Enum *c_4_QTransform_TransformationType_Enum () { return new QTransform_TransformationType_Enum (QTransform::TxRotate); }
static QTransform_TransformationType_Enum *c_5_QTransform_TransformationType_Enum () { return new QTransform_TransformationType_Enum (QTransform::TxShear); }
static QTransform_TransformationType_Enum *c_6_QTransform_TransformationType_Enum () { return new QTransform_TransformationType_Enum (QTransform::TxProject); }

static gsi::Methods mkdefs_QTransform_TransformationType () {
  return
    gsi::constant ("TxNone", &qt_gsi::c_1_QTransform_TransformationType_Enum, "@brief Enum constant QTransform::TxNone") +
    gsi::constant ("TxTranslate", &qt_gsi::c_2_QTransform_TransformationType_Enum, "@brief Enum constant QTransform::TxTranslate") +
    gsi::constant ("TxScale", &qt_gsi::c_3_QTransform_TransformationType_Enum, "@brief Enum constant QTransform::TxScale") +
    gsi::constant ("TxRotate", &qt_gsi::c_4_QTransform_TransformationType_Enum, "@brief Enum constant QTransform::TxRotate") +
    gsi::constant ("TxShear", &qt_gsi::c_5_QTransform_TransformationType_Enum, "@brief Enum constant QTransform::TxShear") +
    gsi::constant ("TxProject", &qt_gsi::c_6_QTransform_TransformationType_Enum, "@brief Enum constant QTransform::TxProject");
}

static std::string to_s_QTransform_TransformationType_Enum (const QTransform_TransformationType_Enum *e)
{
  if (e->value () == QTransform::TxNone) { return tl::sprintf ("TxNone (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTransform::TxTranslate) { return tl::sprintf ("TxTranslate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTransform::TxScale) { return tl::sprintf ("TxScale (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTransform::TxRotate) { return tl::sprintf ("TxRotate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTransform::TxShear) { return tl::sprintf ("TxShear (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTransform::TxProject) { return tl::sprintf ("TxProject (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTransform_TransformationType_Enum (const QTransform_TransformationType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTransform_TransformationType_Enum *from_i_QTransform_TransformationType_Enum (unsigned int i)
{
  return new QTransform_TransformationType_Enum ((QTransform::TransformationType) i);
}

static bool equalQTransform_TransformationType_Enum (const QTransform_TransformationType_Enum *e, QTransform_TransformationType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTransform_TransformationType_Enum (const QTransform_TransformationType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTransform_TransformationType_Enums oropQTransform_TransformationType_Enums (const QTransform_TransformationType_Enums *e, const QTransform_TransformationType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTransform_TransformationType_Enums andopQTransform_TransformationType_Enums (const QTransform_TransformationType_Enums *e, const QTransform_TransformationType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTransform_TransformationType_Enums xoropQTransform_TransformationType_Enums (const QTransform_TransformationType_Enums *e, const QTransform_TransformationType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTransform_TransformationType_Enums (const QTransform_TransformationType_Enums *e)
{
  std::string l;
  if (e->testFlag (QTransform::TxNone)) { if (!l.empty ()) l += "|"; l += "TxNone"; }
  if (e->testFlag (QTransform::TxTranslate)) { if (!l.empty ()) l += "|"; l += "TxTranslate"; }
  if (e->testFlag (QTransform::TxScale)) { if (!l.empty ()) l += "|"; l += "TxScale"; }
  if (e->testFlag (QTransform::TxRotate)) { if (!l.empty ()) l += "|"; l += "TxRotate"; }
  if (e->testFlag (QTransform::TxShear)) { if (!l.empty ()) l += "|"; l += "TxShear"; }
  if (e->testFlag (QTransform::TxProject)) { if (!l.empty ()) l += "|"; l += "TxProject"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTransform_TransformationType_Enums (const QTransform_TransformationType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTransform_TransformationType_Enums (const QTransform_TransformationType_Enums *e, const QTransform_TransformationType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTransform_TransformationType_Enums> decl_QTransform_TransformationType_Enums ("QTransform_QFlags_TransformationType",
  gsi::method_ext ("|", &qt_gsi::oropQTransform_TransformationType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTransform_TransformationType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTransform_TransformationType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTransform_TransformationType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTransform_TransformationType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTransform_TransformationType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTransform::TransformationType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTransform_TransformationType_Enum> decl_QTransform_TransformationType_Enum (decl_QTransform_TransformationType_Enums, "QTransform_TransformationType",
  qt_gsi::mkdefs_QTransform_TransformationType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTransform_TransformationType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTransform_TransformationType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTransform_TransformationType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTransform_TransformationType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTransform_TransformationType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTransform::TransformationType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTransform> inject_QTransform_TransformationType_Enum_in_parent (qt_gsi::mkdefs_QTransform_TransformationType ());
static gsi::ClassExt<QTransform> decl_QTransform_TransformationType_Enum_as_child (decl_QTransform_TransformationType_Enum, "TransformationType");

}

