
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file generated/gsiDeclQTextDocument_EventAdaptor.cc
*  @brief Event adaptor implementations for QTextDocument
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQTextDocument_EventAdaptor.h"

// -----------------------------------------------------------------------
// class QTextDocument_EventAdaptor

QTextDocument_EventAdaptor::QTextDocument_EventAdaptor (QObject *host)
  : QObject ()
{
  connect (host, SIGNAL(blockCountChanged(int)), this, SLOT(blockCountChanged(int)));
  connect (host, SIGNAL(contentsChange(int, int, int)), this, SLOT(contentsChange(int, int, int)));
  connect (host, SIGNAL(contentsChanged()), this, SLOT(contentsChanged()));
  connect (host, SIGNAL(cursorPositionChanged(const QTextCursor &)), this, SLOT(cursorPositionChanged(const QTextCursor &)));
  connect (host, SIGNAL(destroyed(QObject *)), this, SLOT(destroyed(QObject *)));
  connect (host, SIGNAL(documentLayoutChanged()), this, SLOT(documentLayoutChanged()));
  connect (host, SIGNAL(modificationChanged(bool)), this, SLOT(modificationChanged(bool)));
  connect (host, SIGNAL(redoAvailable(bool)), this, SLOT(redoAvailable(bool)));
  connect (host, SIGNAL(undoAvailable(bool)), this, SLOT(undoAvailable(bool)));
  connect (host, SIGNAL(undoCommandAdded()), this, SLOT(undoCommandAdded()));
}

//  Event QTextDocument::blockCountChanged(int newBlockCount)
void QTextDocument_EventAdaptor::blockCountChanged(int newBlockCount) {
BEGIN_PROTECTED
  blockCountChanged_e_767(newBlockCount);
END_PROTECTED
}

//  Event QTextDocument::contentsChange(int from, int charsRemoves, int charsAdded)
void QTextDocument_EventAdaptor::contentsChange(int from, int charsRemoves, int charsAdded) {
BEGIN_PROTECTED
  contentsChange_e_2085(from, charsRemoves, charsAdded);
END_PROTECTED
}

//  Event QTextDocument::contentsChanged()
void QTextDocument_EventAdaptor::contentsChanged() {
BEGIN_PROTECTED
  contentsChanged_e_0();
END_PROTECTED
}

//  Event QTextDocument::cursorPositionChanged(const QTextCursor &cursor)
void QTextDocument_EventAdaptor::cursorPositionChanged(const QTextCursor &cursor) {
BEGIN_PROTECTED
  cursorPositionChanged_e_2453(cursor);
END_PROTECTED
}

//  Event QTextDocument::destroyed(QObject *arg1)
void QTextDocument_EventAdaptor::destroyed(QObject *arg1) {
BEGIN_PROTECTED
  destroyed_e_1302(arg1);
END_PROTECTED
}

//  Event QTextDocument::documentLayoutChanged()
void QTextDocument_EventAdaptor::documentLayoutChanged() {
BEGIN_PROTECTED
  documentLayoutChanged_e_0();
END_PROTECTED
}

//  Event QTextDocument::modificationChanged(bool m)
void QTextDocument_EventAdaptor::modificationChanged(bool m) {
BEGIN_PROTECTED
  modificationChanged_e_864(m);
END_PROTECTED
}

//  Event QTextDocument::redoAvailable(bool arg1)
void QTextDocument_EventAdaptor::redoAvailable(bool arg1) {
BEGIN_PROTECTED
  redoAvailable_e_864(arg1);
END_PROTECTED
}

//  Event QTextDocument::undoAvailable(bool arg1)
void QTextDocument_EventAdaptor::undoAvailable(bool arg1) {
BEGIN_PROTECTED
  undoAvailable_e_864(arg1);
END_PROTECTED
}

//  Event QTextDocument::undoCommandAdded()
void QTextDocument_EventAdaptor::undoCommandAdded() {
BEGIN_PROTECTED
  undoCommandAdded_e_0();
END_PROTECTED
}
