
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTemporaryFile.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTemporaryFile_EventAdaptor.h"
#include "gsiDeclQTemporaryFile_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTemporaryFile

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTemporaryFile::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

//  Constructor QTemporaryFile::QTemporaryFile()


static void _init_ctor_QTemporaryFile_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTemporaryFile *> ();
}

static void _call_ctor_QTemporaryFile_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTemporaryFile *> (new QTemporaryFile ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTemporaryFile_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTemporaryFile::QTemporaryFile()\nThis method creates an object of class QTemporaryFile.", &_init_ctor_QTemporaryFile_0, &_call_ctor_QTemporaryFile_0);
}

//  Constructor QTemporaryFile::QTemporaryFile(const QString &templateName)


static void _init_ctor_QTemporaryFile_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("templateName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QTemporaryFile *> ();
}

static void _call_ctor_QTemporaryFile_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QTemporaryFile *> (new QTemporaryFile (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTemporaryFile_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTemporaryFile::QTemporaryFile(const QString &templateName)\nThis method creates an object of class QTemporaryFile.", &_init_ctor_QTemporaryFile_2025, &_call_ctor_QTemporaryFile_2025);
}

//  Constructor QTemporaryFile::QTemporaryFile(QObject *parent)


static void _init_ctor_QTemporaryFile_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QTemporaryFile *> ();
}

static void _call_ctor_QTemporaryFile_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ret.write<QTemporaryFile *> (new QTemporaryFile (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTemporaryFile_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTemporaryFile::QTemporaryFile(QObject *parent)\nThis method creates an object of class QTemporaryFile.", &_init_ctor_QTemporaryFile_1302, &_call_ctor_QTemporaryFile_1302);
}

//  Constructor QTemporaryFile::QTemporaryFile(const QString &templateName, QObject *parent)


static void _init_ctor_QTemporaryFile_3219 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("templateName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QTemporaryFile *> ();
}

static void _call_ctor_QTemporaryFile_3219 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QObject *arg2 = args.read<QObject * > ();
  ret.write<QTemporaryFile *> (new QTemporaryFile (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTemporaryFile_3219 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTemporaryFile::QTemporaryFile(const QString &templateName, QObject *parent)\nThis method creates an object of class QTemporaryFile.", &_init_ctor_QTemporaryFile_3219, &_call_ctor_QTemporaryFile_3219);
}

// bool QTemporaryFile::autoRemove()


static void _init_f_autoRemove_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoRemove_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTemporaryFile *)cls)->autoRemove ());
}

static qt_gsi::GenericMethod *_create_f_autoRemove_c0 ()
{
  return new qt_gsi::GenericMethod (":autoRemove", "@brief Method bool QTemporaryFile::autoRemove()\n", true, &_init_f_autoRemove_c0, &_call_f_autoRemove_c0);
}

// QString QTemporaryFile::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QTemporaryFile *)cls)->fileName ());
}

static qt_gsi::GenericMethod *_create_f_fileName_c0 ()
{
  return new qt_gsi::GenericMethod (":fileName", "@brief Method QString QTemporaryFile::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
}

// QString QTemporaryFile::fileTemplate()


static void _init_f_fileTemplate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileTemplate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QTemporaryFile *)cls)->fileTemplate ());
}

static qt_gsi::GenericMethod *_create_f_fileTemplate_c0 ()
{
  return new qt_gsi::GenericMethod (":fileTemplate", "@brief Method QString QTemporaryFile::fileTemplate()\n", true, &_init_f_fileTemplate_c0, &_call_f_fileTemplate_c0);
}

// bool QTemporaryFile::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTemporaryFile *)cls)->open ());
}

static qt_gsi::GenericMethod *_create_f_open_0 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method bool QTemporaryFile::open()\n", false, &_init_f_open_0, &_call_f_open_0);
}

// void QTemporaryFile::setAutoRemove(bool b)


static void _init_f_setAutoRemove_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoRemove_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTemporaryFile *)cls)->setAutoRemove (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoRemove_864 ()
{
  return new qt_gsi::GenericMethod ("setAutoRemove|autoRemove=", "@brief Method void QTemporaryFile::setAutoRemove(bool b)\n", false, &_init_f_setAutoRemove_864, &_call_f_setAutoRemove_864);
}

// void QTemporaryFile::setFileTemplate(const QString &name)


static void _init_f_setFileTemplate_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileTemplate_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTemporaryFile *)cls)->setFileTemplate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFileTemplate_2025 ()
{
  return new qt_gsi::GenericMethod ("setFileTemplate|fileTemplate=", "@brief Method void QTemporaryFile::setFileTemplate(const QString &name)\n", false, &_init_f_setFileTemplate_2025, &_call_f_setFileTemplate_2025);
}

// static QTemporaryFile *QTemporaryFile::createLocalFile(const QString &fileName)


static void _init_f_createLocalFile_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QTemporaryFile * > ();
}

static void _call_f_createLocalFile_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QTemporaryFile * > ((QTemporaryFile *)QTemporaryFile::createLocalFile (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_createLocalFile_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("createLocalFile", "@brief Static method QTemporaryFile *QTemporaryFile::createLocalFile(const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_createLocalFile_2025, &_call_f_createLocalFile_2025);
}

// static QTemporaryFile *QTemporaryFile::createLocalFile(QFile &file)


static void _init_f_createLocalFile_1083 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<QFile & > (argspec_0);
  decl->set_return<QTemporaryFile * > ();
}

static void _call_f_createLocalFile_1083 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFile &arg1 = args.read<QFile & > ();
  ret.write<QTemporaryFile * > ((QTemporaryFile *)QTemporaryFile::createLocalFile (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_createLocalFile_1083 ()
{
  return new qt_gsi::GenericStaticMethod ("createLocalFile", "@brief Static method QTemporaryFile *QTemporaryFile::createLocalFile(QFile &file)\nThis method is static and can be called without an instance.", &_init_f_createLocalFile_1083, &_call_f_createLocalFile_1083);
}

// static QString QTemporaryFile::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTemporaryFile::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTemporaryFile::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QTemporaryFile::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTemporaryFile::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTemporaryFile::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QTemporaryFile::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTemporaryFile::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTemporaryFile::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QTemporaryFile::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTemporaryFile::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTemporaryFile::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QTemporaryFile, QTemporaryFile_EventAdaptor> ea_QTemporaryFile;


namespace gsi
{
extern gsi::Class<QFile> decl_QFile;

gsi::Class<QTemporaryFile> decl_QTemporaryFile (ea_QTemporaryFile, decl_QFile, "QTemporaryFile",
  gsi::Methods(_create_ctor_QTemporaryFile_0 ()) +
  gsi::Methods(_create_ctor_QTemporaryFile_2025 ()) +
  gsi::Methods(_create_ctor_QTemporaryFile_1302 ()) +
  gsi::Methods(_create_ctor_QTemporaryFile_3219 ()) +
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_autoRemove_c0 ()) +
  gsi::Methods(_create_f_fileName_c0 ()) +
  gsi::Methods(_create_f_fileTemplate_c0 ()) +
  gsi::Methods(_create_f_open_0 ()) +
  gsi::Methods(_create_f_setAutoRemove_864 ()) +
  gsi::Methods(_create_f_setFileTemplate_2025 ()) +
  qt_gsi::qt_signal<QTemporaryFile, QTemporaryFile_EventAdaptor> ("aboutToClose", &QTemporaryFile_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QTemporaryFile::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTemporaryFile, QTemporaryFile_EventAdaptor, qint64> ("bytesWritten", &QTemporaryFile_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QTemporaryFile::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTemporaryFile, QTemporaryFile_EventAdaptor, QObject *> ("destroyed", &QTemporaryFile_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QTemporaryFile::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTemporaryFile, QTemporaryFile_EventAdaptor> ("readChannelFinished", &QTemporaryFile_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QTemporaryFile::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTemporaryFile, QTemporaryFile_EventAdaptor> ("readyRead", &QTemporaryFile_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QTemporaryFile::readyRead()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_createLocalFile_2025 ()) +
  gsi::Methods(_create_f_createLocalFile_1083 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QTemporaryFile");

}

