
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file generated/gsiDeclQTableWidget_EventAdaptor.h
*  @brief Event adaptor implementations for QTableWidget
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#ifndef _HDR_gsiDeclQTableWidget_EventAdaptor
#define _HDR_gsiDeclQTableWidget_EventAdaptor

#include "gsiDecl.h"
#include "gsiQtEvents.h"
#include "gsiQtGui.h"
#include "gsiDeclQTableWidget_Enums.h"

#include "layExceptions.h"

#include <QtCore/QObject>

// -----------------------------------------------------------------------
// class QTableWidget_EventAdaptor

class QTableWidget_EventAdaptor
  : public QObject, public qt_gsi::EventAdaptorBase, public gsi::ObjectBase
{
Q_OBJECT

public:
  QTableWidget_EventAdaptor (QObject *host);

public slots:
  void activated(const QModelIndex &);
  void cellActivated(int, int);
  void cellChanged(int, int);
  void cellClicked(int, int);
  void cellDoubleClicked(int, int);
  void cellEntered(int, int);
  void cellPressed(int, int);
  void clicked(const QModelIndex &);
  void currentCellChanged(int, int, int, int);
  void currentItemChanged(QTableWidgetItem *, QTableWidgetItem *);
  void customContextMenuRequested(const QPoint &);
  void destroyed(QObject *);
  void doubleClicked(const QModelIndex &);
  void entered(const QModelIndex &);
  void itemActivated(QTableWidgetItem *);
  void itemChanged(QTableWidgetItem *);
  void itemClicked(QTableWidgetItem *);
  void itemDoubleClicked(QTableWidgetItem *);
  void itemEntered(QTableWidgetItem *);
  void itemPressed(QTableWidgetItem *);
  void itemSelectionChanged();
  void pressed(const QModelIndex &);
  void viewportEntered();

public:
  gsi::event<const QModelIndex &> activated_e_2395;
  gsi::event<int, int> cellActivated_e_1426;
  gsi::event<int, int> cellChanged_e_1426;
  gsi::event<int, int> cellClicked_e_1426;
  gsi::event<int, int> cellDoubleClicked_e_1426;
  gsi::event<int, int> cellEntered_e_1426;
  gsi::event<int, int> cellPressed_e_1426;
  gsi::event<const QModelIndex &> clicked_e_2395;
  gsi::event<int, int, int, int> currentCellChanged_e_2744;
  gsi::event<QTableWidgetItem *, QTableWidgetItem *> currentItemChanged_e_4296;
  gsi::event<const QPoint &> customContextMenuRequested_e_1916;
  gsi::event<QObject *> destroyed_e_1302;
  gsi::event<const QModelIndex &> doubleClicked_e_2395;
  gsi::event<const QModelIndex &> entered_e_2395;
  gsi::event<QTableWidgetItem *> itemActivated_e_2202;
  gsi::event<QTableWidgetItem *> itemChanged_e_2202;
  gsi::event<QTableWidgetItem *> itemClicked_e_2202;
  gsi::event<QTableWidgetItem *> itemDoubleClicked_e_2202;
  gsi::event<QTableWidgetItem *> itemEntered_e_2202;
  gsi::event<QTableWidgetItem *> itemPressed_e_2202;
  gsi::event<> itemSelectionChanged_e_0;
  gsi::event<const QModelIndex &> pressed_e_2395;
  gsi::event<> viewportEntered_e_0;
};

#endif
