
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSystemTrayIcon.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSystemTrayIcon_EventAdaptor.h"
#include "gsiDeclQSystemTrayIcon_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSystemTrayIcon

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSystemTrayIcon::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QMenu *QSystemTrayIcon::contextMenu()


static void _init_f_contextMenu_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenu * > ();
}

static void _call_f_contextMenu_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMenu * > ((QMenu *)((QSystemTrayIcon *)cls)->contextMenu ());
}

static qt_gsi::GenericMethod *_create_f_contextMenu_c0 ()
{
  return new qt_gsi::GenericMethod (":contextMenu", "@brief Method QMenu *QSystemTrayIcon::contextMenu()\n", true, &_init_f_contextMenu_c0, &_call_f_contextMenu_c0);
}

// QRect QSystemTrayIcon::geometry()


static void _init_f_geometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_geometry_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QSystemTrayIcon *)cls)->geometry ());
}

static qt_gsi::GenericMethod *_create_f_geometry_c0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@brief Method QRect QSystemTrayIcon::geometry()\n", true, &_init_f_geometry_c0, &_call_f_geometry_c0);
}

// void QSystemTrayIcon::hide()


static void _init_f_hide_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hide_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSystemTrayIcon *)cls)->hide ();
}

static qt_gsi::GenericMethod *_create_f_hide_0 ()
{
  return new qt_gsi::GenericMethod ("hide", "@brief Method void QSystemTrayIcon::hide()\n", false, &_init_f_hide_0, &_call_f_hide_0);
}

// QIcon QSystemTrayIcon::icon()


static void _init_f_icon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_icon_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIcon > ((QIcon)((QSystemTrayIcon *)cls)->icon ());
}

static qt_gsi::GenericMethod *_create_f_icon_c0 ()
{
  return new qt_gsi::GenericMethod (":icon", "@brief Method QIcon QSystemTrayIcon::icon()\n", true, &_init_f_icon_c0, &_call_f_icon_c0);
}

// bool QSystemTrayIcon::isVisible()


static void _init_f_isVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVisible_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSystemTrayIcon *)cls)->isVisible ());
}

static qt_gsi::GenericMethod *_create_f_isVisible_c0 ()
{
  return new qt_gsi::GenericMethod ("isVisible?|:visible", "@brief Method bool QSystemTrayIcon::isVisible()\n", true, &_init_f_isVisible_c0, &_call_f_isVisible_c0);
}

// void QSystemTrayIcon::setContextMenu(QMenu *menu)


static void _init_f_setContextMenu_1108 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("menu");
  decl->add_arg<QMenu * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContextMenu_1108 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMenu *arg1 = args.read<QMenu * > ();
  ((QSystemTrayIcon *)cls)->setContextMenu (arg1);
}

static qt_gsi::GenericMethod *_create_f_setContextMenu_1108 ()
{
  return new qt_gsi::GenericMethod ("setContextMenu|contextMenu=", "@brief Method void QSystemTrayIcon::setContextMenu(QMenu *menu)\n", false, &_init_f_setContextMenu_1108, &_call_f_setContextMenu_1108);
}

// void QSystemTrayIcon::setIcon(const QIcon &icon)


static void _init_f_setIcon_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIcon_1787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  ((QSystemTrayIcon *)cls)->setIcon (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIcon_1787 ()
{
  return new qt_gsi::GenericMethod ("setIcon|icon=", "@brief Method void QSystemTrayIcon::setIcon(const QIcon &icon)\n", false, &_init_f_setIcon_1787, &_call_f_setIcon_1787);
}

// void QSystemTrayIcon::setToolTip(const QString &tip)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QSystemTrayIcon *)cls)->setToolTip (arg1);
}

static qt_gsi::GenericMethod *_create_f_setToolTip_2025 ()
{
  return new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QSystemTrayIcon::setToolTip(const QString &tip)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
}

// void QSystemTrayIcon::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QSystemTrayIcon *)cls)->setVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QSystemTrayIcon::setVisible(bool visible)\n", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
}

// void QSystemTrayIcon::show()


static void _init_f_show_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_show_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSystemTrayIcon *)cls)->show ();
}

static qt_gsi::GenericMethod *_create_f_show_0 ()
{
  return new qt_gsi::GenericMethod ("show", "@brief Method void QSystemTrayIcon::show()\n", false, &_init_f_show_0, &_call_f_show_0);
}

// void QSystemTrayIcon::showMessage(const QString &title, const QString &msg, QSystemTrayIcon::MessageIcon icon, int msecs)


static void _init_f_showMessage_7682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("msg");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("icon", true, "QSystemTrayIcon::Information");
  decl->add_arg<const qt_gsi::Converter<QSystemTrayIcon::MessageIcon>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("msecs", true, "10000");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_showMessage_7682 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QSystemTrayIcon::MessageIcon>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QSystemTrayIcon::MessageIcon>::target_type & > () : (const qt_gsi::Converter<QSystemTrayIcon::MessageIcon>::target_type &)(qt_gsi::CppToQtReadAdaptor<QSystemTrayIcon::MessageIcon>(heap, QSystemTrayIcon::Information));
  int arg4 = args ? args.read<int > () : (int)(10000);
  ((QSystemTrayIcon *)cls)->showMessage (arg1, arg2, qt_gsi::QtToCppAdaptor<QSystemTrayIcon::MessageIcon>(arg3).cref(), arg4);
}

static qt_gsi::GenericMethod *_create_f_showMessage_7682 ()
{
  return new qt_gsi::GenericMethod ("showMessage", "@brief Method void QSystemTrayIcon::showMessage(const QString &title, const QString &msg, QSystemTrayIcon::MessageIcon icon, int msecs)\n", false, &_init_f_showMessage_7682, &_call_f_showMessage_7682);
}

// QString QSystemTrayIcon::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QSystemTrayIcon *)cls)->toolTip ());
}

static qt_gsi::GenericMethod *_create_f_toolTip_c0 ()
{
  return new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QSystemTrayIcon::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
}

// static bool QSystemTrayIcon::isSystemTrayAvailable()


static void _init_f_isSystemTrayAvailable_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSystemTrayAvailable_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QSystemTrayIcon::isSystemTrayAvailable ());
}

static qt_gsi::GenericStaticMethod *_create_f_isSystemTrayAvailable_0 ()
{
  return new qt_gsi::GenericStaticMethod ("isSystemTrayAvailable?", "@brief Static method bool QSystemTrayIcon::isSystemTrayAvailable()\nThis method is static and can be called without an instance.", &_init_f_isSystemTrayAvailable_0, &_call_f_isSystemTrayAvailable_0);
}

// static bool QSystemTrayIcon::supportsMessages()


static void _init_f_supportsMessages_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_supportsMessages_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QSystemTrayIcon::supportsMessages ());
}

static qt_gsi::GenericStaticMethod *_create_f_supportsMessages_0 ()
{
  return new qt_gsi::GenericStaticMethod ("supportsMessages", "@brief Static method bool QSystemTrayIcon::supportsMessages()\nThis method is static and can be called without an instance.", &_init_f_supportsMessages_0, &_call_f_supportsMessages_0);
}

// static QString QSystemTrayIcon::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSystemTrayIcon::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSystemTrayIcon::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QSystemTrayIcon::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSystemTrayIcon::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSystemTrayIcon::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QSystemTrayIcon::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSystemTrayIcon::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSystemTrayIcon::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QSystemTrayIcon::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSystemTrayIcon::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSystemTrayIcon::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QSystemTrayIcon, QSystemTrayIcon_EventAdaptor> ea_QSystemTrayIcon;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QSystemTrayIcon> decl_QSystemTrayIcon (ea_QSystemTrayIcon, decl_QObject, "QSystemTrayIcon_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_contextMenu_c0 ()) +
  gsi::Methods(_create_f_geometry_c0 ()) +
  gsi::Methods(_create_f_hide_0 ()) +
  gsi::Methods(_create_f_icon_c0 ()) +
  gsi::Methods(_create_f_isVisible_c0 ()) +
  gsi::Methods(_create_f_setContextMenu_1108 ()) +
  gsi::Methods(_create_f_setIcon_1787 ()) +
  gsi::Methods(_create_f_setToolTip_2025 ()) +
  gsi::Methods(_create_f_setVisible_864 ()) +
  gsi::Methods(_create_f_show_0 ()) +
  gsi::Methods(_create_f_showMessage_7682 ()) +
  gsi::Methods(_create_f_toolTip_c0 ()) +
  qt_gsi::qt_signal<QSystemTrayIcon, QSystemTrayIcon_EventAdaptor, const qt_gsi::Converter<QSystemTrayIcon::ActivationReason>::target_type &> ("activated", &QSystemTrayIcon_EventAdaptor::activated_e_3745, gsi::arg("reason"), "@brief Signal declaration for QSystemTrayIcon::activated(QSystemTrayIcon::ActivationReason reason)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSystemTrayIcon, QSystemTrayIcon_EventAdaptor, QObject *> ("destroyed", &QSystemTrayIcon_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QSystemTrayIcon::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSystemTrayIcon, QSystemTrayIcon_EventAdaptor> ("messageClicked", &QSystemTrayIcon_EventAdaptor::messageClicked_e_0, "@brief Signal declaration for QSystemTrayIcon::messageClicked()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_isSystemTrayAvailable_0 ()) +
  gsi::Methods(_create_f_supportsMessages_0 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QSystemTrayIcon");
}


class QSystemTrayIcon_Adaptor : public QSystemTrayIcon, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSystemTrayIcon_Adaptor();

  //  [adaptor ctor] QSystemTrayIcon::QSystemTrayIcon(QObject *parent)
  QSystemTrayIcon_Adaptor() : QSystemTrayIcon()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSystemTrayIcon::QSystemTrayIcon(QObject *parent)
  QSystemTrayIcon_Adaptor(QObject *parent) : QSystemTrayIcon(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSystemTrayIcon::QSystemTrayIcon(const QIcon &icon, QObject *parent)
  QSystemTrayIcon_Adaptor(const QIcon &icon) : QSystemTrayIcon(icon)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSystemTrayIcon::QSystemTrayIcon(const QIcon &icon, QObject *parent)
  QSystemTrayIcon_Adaptor(const QIcon &icon, QObject *parent) : QSystemTrayIcon(icon, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QSystemTrayIcon::receivers(const char *signal)
  int fp_QSystemTrayIcon_receivers_c1731 (const char *signal) const {
    return QSystemTrayIcon::receivers(signal);
  }

  //  QObject *QSystemTrayIcon::sender()
  QObject * fp_QSystemTrayIcon_sender_c0 () const {
    return QSystemTrayIcon::sender();
  }

  //  [adaptor impl] bool QSystemTrayIcon::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSystemTrayIcon::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSystemTrayIcon_Adaptor, bool, QObject *, QEvent *>(&QSystemTrayIcon_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSystemTrayIcon::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QSystemTrayIcon::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSystemTrayIcon::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSystemTrayIcon_Adaptor, QChildEvent *>(&QSystemTrayIcon_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSystemTrayIcon::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSystemTrayIcon::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSystemTrayIcon::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSystemTrayIcon_Adaptor, QEvent *>(&QSystemTrayIcon_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSystemTrayIcon::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QSystemTrayIcon::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QSystemTrayIcon::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QSystemTrayIcon_Adaptor, const char *>(&QSystemTrayIcon_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QSystemTrayIcon::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QSystemTrayIcon::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QSystemTrayIcon::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSystemTrayIcon_Adaptor, bool, QEvent *>(&QSystemTrayIcon_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QSystemTrayIcon::event(_event);
    }
  }

  //  [adaptor impl] void QSystemTrayIcon::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSystemTrayIcon::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSystemTrayIcon_Adaptor, QTimerEvent *>(&QSystemTrayIcon_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSystemTrayIcon::timerEvent(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSystemTrayIcon_Adaptor::~QSystemTrayIcon_Adaptor() { }

//  Constructor QSystemTrayIcon::QSystemTrayIcon(QObject *parent) (adaptor class)

static void _init_ctor_QSystemTrayIcon_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSystemTrayIcon_Adaptor *> ();
}

static void _call_ctor_QSystemTrayIcon_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSystemTrayIcon_Adaptor *> (new QSystemTrayIcon_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSystemTrayIcon_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSystemTrayIcon::QSystemTrayIcon(QObject *parent)\nThis method creates an object of class QSystemTrayIcon.", &_init_ctor_QSystemTrayIcon_Adaptor_1302, &_call_ctor_QSystemTrayIcon_Adaptor_1302);
}

//  Constructor QSystemTrayIcon::QSystemTrayIcon(const QIcon &icon, QObject *parent) (adaptor class)

static void _init_ctor_QSystemTrayIcon_Adaptor_2981 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QSystemTrayIcon_Adaptor *> ();
}

static void _call_ctor_QSystemTrayIcon_Adaptor_2981 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  QObject *arg2 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSystemTrayIcon_Adaptor *> (new QSystemTrayIcon_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSystemTrayIcon_Adaptor_2981 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSystemTrayIcon::QSystemTrayIcon(const QIcon &icon, QObject *parent)\nThis method creates an object of class QSystemTrayIcon.", &_init_ctor_QSystemTrayIcon_Adaptor_2981, &_call_ctor_QSystemTrayIcon_Adaptor_2981);
}

// int QSystemTrayIcon::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QSystemTrayIcon_Adaptor *)cls)->fp_QSystemTrayIcon_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QSystemTrayIcon::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QSystemTrayIcon::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QSystemTrayIcon_Adaptor *)cls)->fp_QSystemTrayIcon_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QSystemTrayIcon::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QSystemTrayIcon::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSystemTrayIcon_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSystemTrayIcon_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSystemTrayIcon::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QSystemTrayIcon::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QSystemTrayIcon_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSystemTrayIcon_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSystemTrayIcon::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QSystemTrayIcon::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QSystemTrayIcon_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSystemTrayIcon_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSystemTrayIcon::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QSystemTrayIcon::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QSystemTrayIcon_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QSystemTrayIcon_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSystemTrayIcon::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QSystemTrayIcon::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSystemTrayIcon_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSystemTrayIcon_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QSystemTrayIcon::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QSystemTrayIcon::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QSystemTrayIcon_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSystemTrayIcon_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSystemTrayIcon::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QSystemTrayIcon> decl_QSystemTrayIcon;

gsi::Class<QSystemTrayIcon_Adaptor> decl_QSystemTrayIcon_Adaptor (decl_QSystemTrayIcon, "QSystemTrayIcon",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QSystemTrayIcon_Adaptor_1302 ()) +
  gsi::Methods(_create_ctor_QSystemTrayIcon_Adaptor_2981 ()),
  "@qt\n@brief Binding of QSystemTrayIcon");

}


//  Implementation of the enum wrapper class for QSystemTrayIcon::ActivationReason
namespace qt_gsi
{

static QSystemTrayIcon_ActivationReason_Enum *c_1_QSystemTrayIcon_ActivationReason_Enum () { return new QSystemTrayIcon_ActivationReason_Enum (QSystemTrayIcon::Unknown); }
static QSystemTrayIcon_ActivationReason_Enum *c_2_QSystemTrayIcon_ActivationReason_Enum () { return new QSystemTrayIcon_ActivationReason_Enum (QSystemTrayIcon::Context); }
static QSystemTrayIcon_ActivationReason_Enum *c_3_QSystemTrayIcon_ActivationReason_Enum () { return new QSystemTrayIcon_ActivationReason_Enum (QSystemTrayIcon::DoubleClick); }
static QSystemTrayIcon_ActivationReason_Enum *c_4_QSystemTrayIcon_ActivationReason_Enum () { return new QSystemTrayIcon_ActivationReason_Enum (QSystemTrayIcon::Trigger); }
static QSystemTrayIcon_ActivationReason_Enum *c_5_QSystemTrayIcon_ActivationReason_Enum () { return new QSystemTrayIcon_ActivationReason_Enum (QSystemTrayIcon::MiddleClick); }

static gsi::Methods mkdefs_QSystemTrayIcon_ActivationReason () {
  return
    gsi::constant ("Unknown", &qt_gsi::c_1_QSystemTrayIcon_ActivationReason_Enum, "@brief Enum constant QSystemTrayIcon::Unknown") +
    gsi::constant ("Context", &qt_gsi::c_2_QSystemTrayIcon_ActivationReason_Enum, "@brief Enum constant QSystemTrayIcon::Context") +
    gsi::constant ("DoubleClick", &qt_gsi::c_3_QSystemTrayIcon_ActivationReason_Enum, "@brief Enum constant QSystemTrayIcon::DoubleClick") +
    gsi::constant ("Trigger", &qt_gsi::c_4_QSystemTrayIcon_ActivationReason_Enum, "@brief Enum constant QSystemTrayIcon::Trigger") +
    gsi::constant ("MiddleClick", &qt_gsi::c_5_QSystemTrayIcon_ActivationReason_Enum, "@brief Enum constant QSystemTrayIcon::MiddleClick");
}

static std::string to_s_QSystemTrayIcon_ActivationReason_Enum (const QSystemTrayIcon_ActivationReason_Enum *e)
{
  if (e->value () == QSystemTrayIcon::Unknown) { return tl::sprintf ("Unknown (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSystemTrayIcon::Context) { return tl::sprintf ("Context (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSystemTrayIcon::DoubleClick) { return tl::sprintf ("DoubleClick (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSystemTrayIcon::Trigger) { return tl::sprintf ("Trigger (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSystemTrayIcon::MiddleClick) { return tl::sprintf ("MiddleClick (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSystemTrayIcon_ActivationReason_Enum (const QSystemTrayIcon_ActivationReason_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSystemTrayIcon_ActivationReason_Enum *from_i_QSystemTrayIcon_ActivationReason_Enum (unsigned int i)
{
  return new QSystemTrayIcon_ActivationReason_Enum ((QSystemTrayIcon::ActivationReason) i);
}

static bool equalQSystemTrayIcon_ActivationReason_Enum (const QSystemTrayIcon_ActivationReason_Enum *e, QSystemTrayIcon_ActivationReason_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSystemTrayIcon_ActivationReason_Enum (const QSystemTrayIcon_ActivationReason_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSystemTrayIcon_ActivationReason_Enums oropQSystemTrayIcon_ActivationReason_Enums (const QSystemTrayIcon_ActivationReason_Enums *e, const QSystemTrayIcon_ActivationReason_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSystemTrayIcon_ActivationReason_Enums andopQSystemTrayIcon_ActivationReason_Enums (const QSystemTrayIcon_ActivationReason_Enums *e, const QSystemTrayIcon_ActivationReason_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSystemTrayIcon_ActivationReason_Enums xoropQSystemTrayIcon_ActivationReason_Enums (const QSystemTrayIcon_ActivationReason_Enums *e, const QSystemTrayIcon_ActivationReason_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSystemTrayIcon_ActivationReason_Enums (const QSystemTrayIcon_ActivationReason_Enums *e)
{
  std::string l;
  if (e->testFlag (QSystemTrayIcon::Unknown)) { if (!l.empty ()) l += "|"; l += "Unknown"; }
  if (e->testFlag (QSystemTrayIcon::Context)) { if (!l.empty ()) l += "|"; l += "Context"; }
  if (e->testFlag (QSystemTrayIcon::DoubleClick)) { if (!l.empty ()) l += "|"; l += "DoubleClick"; }
  if (e->testFlag (QSystemTrayIcon::Trigger)) { if (!l.empty ()) l += "|"; l += "Trigger"; }
  if (e->testFlag (QSystemTrayIcon::MiddleClick)) { if (!l.empty ()) l += "|"; l += "MiddleClick"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSystemTrayIcon_ActivationReason_Enums (const QSystemTrayIcon_ActivationReason_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSystemTrayIcon_ActivationReason_Enums (const QSystemTrayIcon_ActivationReason_Enums *e, const QSystemTrayIcon_ActivationReason_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSystemTrayIcon_ActivationReason_Enums> decl_QSystemTrayIcon_ActivationReason_Enums ("QSystemTrayIcon_QFlags_ActivationReason",
  gsi::method_ext ("|", &qt_gsi::oropQSystemTrayIcon_ActivationReason_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSystemTrayIcon_ActivationReason_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSystemTrayIcon_ActivationReason_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSystemTrayIcon_ActivationReason_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSystemTrayIcon_ActivationReason_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSystemTrayIcon_ActivationReason_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSystemTrayIcon::ActivationReason> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSystemTrayIcon_ActivationReason_Enum> decl_QSystemTrayIcon_ActivationReason_Enum (decl_QSystemTrayIcon_ActivationReason_Enums, "QSystemTrayIcon_ActivationReason",
  qt_gsi::mkdefs_QSystemTrayIcon_ActivationReason () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSystemTrayIcon_ActivationReason_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSystemTrayIcon_ActivationReason_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSystemTrayIcon_ActivationReason_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSystemTrayIcon_ActivationReason_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSystemTrayIcon_ActivationReason_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSystemTrayIcon::ActivationReason enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSystemTrayIcon> inject_QSystemTrayIcon_ActivationReason_Enum_in_parent (qt_gsi::mkdefs_QSystemTrayIcon_ActivationReason ());
static gsi::ClassExt<QSystemTrayIcon> decl_QSystemTrayIcon_ActivationReason_Enum_as_child (decl_QSystemTrayIcon_ActivationReason_Enum, "ActivationReason");

}


//  Implementation of the enum wrapper class for QSystemTrayIcon::MessageIcon
namespace qt_gsi
{

static QSystemTrayIcon_MessageIcon_Enum *c_1_QSystemTrayIcon_MessageIcon_Enum () { return new QSystemTrayIcon_MessageIcon_Enum (QSystemTrayIcon::NoIcon); }
static QSystemTrayIcon_MessageIcon_Enum *c_2_QSystemTrayIcon_MessageIcon_Enum () { return new QSystemTrayIcon_MessageIcon_Enum (QSystemTrayIcon::Information); }
static QSystemTrayIcon_MessageIcon_Enum *c_3_QSystemTrayIcon_MessageIcon_Enum () { return new QSystemTrayIcon_MessageIcon_Enum (QSystemTrayIcon::Warning); }
static QSystemTrayIcon_MessageIcon_Enum *c_4_QSystemTrayIcon_MessageIcon_Enum () { return new QSystemTrayIcon_MessageIcon_Enum (QSystemTrayIcon::Critical); }

static gsi::Methods mkdefs_QSystemTrayIcon_MessageIcon () {
  return
    gsi::constant ("NoIcon", &qt_gsi::c_1_QSystemTrayIcon_MessageIcon_Enum, "@brief Enum constant QSystemTrayIcon::NoIcon") +
    gsi::constant ("Information", &qt_gsi::c_2_QSystemTrayIcon_MessageIcon_Enum, "@brief Enum constant QSystemTrayIcon::Information") +
    gsi::constant ("Warning", &qt_gsi::c_3_QSystemTrayIcon_MessageIcon_Enum, "@brief Enum constant QSystemTrayIcon::Warning") +
    gsi::constant ("Critical", &qt_gsi::c_4_QSystemTrayIcon_MessageIcon_Enum, "@brief Enum constant QSystemTrayIcon::Critical");
}

static std::string to_s_QSystemTrayIcon_MessageIcon_Enum (const QSystemTrayIcon_MessageIcon_Enum *e)
{
  if (e->value () == QSystemTrayIcon::NoIcon) { return tl::sprintf ("NoIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSystemTrayIcon::Information) { return tl::sprintf ("Information (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSystemTrayIcon::Warning) { return tl::sprintf ("Warning (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSystemTrayIcon::Critical) { return tl::sprintf ("Critical (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSystemTrayIcon_MessageIcon_Enum (const QSystemTrayIcon_MessageIcon_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSystemTrayIcon_MessageIcon_Enum *from_i_QSystemTrayIcon_MessageIcon_Enum (unsigned int i)
{
  return new QSystemTrayIcon_MessageIcon_Enum ((QSystemTrayIcon::MessageIcon) i);
}

static bool equalQSystemTrayIcon_MessageIcon_Enum (const QSystemTrayIcon_MessageIcon_Enum *e, QSystemTrayIcon_MessageIcon_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSystemTrayIcon_MessageIcon_Enum (const QSystemTrayIcon_MessageIcon_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSystemTrayIcon_MessageIcon_Enums oropQSystemTrayIcon_MessageIcon_Enums (const QSystemTrayIcon_MessageIcon_Enums *e, const QSystemTrayIcon_MessageIcon_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSystemTrayIcon_MessageIcon_Enums andopQSystemTrayIcon_MessageIcon_Enums (const QSystemTrayIcon_MessageIcon_Enums *e, const QSystemTrayIcon_MessageIcon_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSystemTrayIcon_MessageIcon_Enums xoropQSystemTrayIcon_MessageIcon_Enums (const QSystemTrayIcon_MessageIcon_Enums *e, const QSystemTrayIcon_MessageIcon_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSystemTrayIcon_MessageIcon_Enums (const QSystemTrayIcon_MessageIcon_Enums *e)
{
  std::string l;
  if (e->testFlag (QSystemTrayIcon::NoIcon)) { if (!l.empty ()) l += "|"; l += "NoIcon"; }
  if (e->testFlag (QSystemTrayIcon::Information)) { if (!l.empty ()) l += "|"; l += "Information"; }
  if (e->testFlag (QSystemTrayIcon::Warning)) { if (!l.empty ()) l += "|"; l += "Warning"; }
  if (e->testFlag (QSystemTrayIcon::Critical)) { if (!l.empty ()) l += "|"; l += "Critical"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSystemTrayIcon_MessageIcon_Enums (const QSystemTrayIcon_MessageIcon_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSystemTrayIcon_MessageIcon_Enums (const QSystemTrayIcon_MessageIcon_Enums *e, const QSystemTrayIcon_MessageIcon_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSystemTrayIcon_MessageIcon_Enums> decl_QSystemTrayIcon_MessageIcon_Enums ("QSystemTrayIcon_QFlags_MessageIcon",
  gsi::method_ext ("|", &qt_gsi::oropQSystemTrayIcon_MessageIcon_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSystemTrayIcon_MessageIcon_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSystemTrayIcon_MessageIcon_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSystemTrayIcon_MessageIcon_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSystemTrayIcon_MessageIcon_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSystemTrayIcon_MessageIcon_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSystemTrayIcon::MessageIcon> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSystemTrayIcon_MessageIcon_Enum> decl_QSystemTrayIcon_MessageIcon_Enum (decl_QSystemTrayIcon_MessageIcon_Enums, "QSystemTrayIcon_MessageIcon",
  qt_gsi::mkdefs_QSystemTrayIcon_MessageIcon () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSystemTrayIcon_MessageIcon_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSystemTrayIcon_MessageIcon_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSystemTrayIcon_MessageIcon_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSystemTrayIcon_MessageIcon_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSystemTrayIcon_MessageIcon_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSystemTrayIcon::MessageIcon enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSystemTrayIcon> inject_QSystemTrayIcon_MessageIcon_Enum_in_parent (qt_gsi::mkdefs_QSystemTrayIcon_MessageIcon ());
static gsi::ClassExt<QSystemTrayIcon> decl_QSystemTrayIcon_MessageIcon_Enum_as_child (decl_QSystemTrayIcon_MessageIcon_Enum, "MessageIcon");

}

