
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSwipeGesture.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSwipeGesture_EventAdaptor.h"
#include "gsiDeclQSwipeGesture_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSwipeGesture

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSwipeGesture::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QSwipeGesture::SwipeDirection QSwipeGesture::horizontalDirection()


static void _init_f_horizontalDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSwipeGesture::SwipeDirection>::target_type > ();
}

static void _call_f_horizontalDirection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSwipeGesture::SwipeDirection>::target_type > ((qt_gsi::Converter<QSwipeGesture::SwipeDirection>::target_type)qt_gsi::CppToQtAdaptor<QSwipeGesture::SwipeDirection>(((QSwipeGesture *)cls)->horizontalDirection ()));
}

static qt_gsi::GenericMethod *_create_f_horizontalDirection_c0 ()
{
  return new qt_gsi::GenericMethod (":horizontalDirection", "@brief Method QSwipeGesture::SwipeDirection QSwipeGesture::horizontalDirection()\n", true, &_init_f_horizontalDirection_c0, &_call_f_horizontalDirection_c0);
}

// void QSwipeGesture::setSwipeAngle(double value)


static void _init_f_setSwipeAngle_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSwipeAngle_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QSwipeGesture *)cls)->setSwipeAngle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSwipeAngle_1071 ()
{
  return new qt_gsi::GenericMethod ("setSwipeAngle|swipeAngle=", "@brief Method void QSwipeGesture::setSwipeAngle(double value)\n", false, &_init_f_setSwipeAngle_1071, &_call_f_setSwipeAngle_1071);
}

// double QSwipeGesture::swipeAngle()


static void _init_f_swipeAngle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_swipeAngle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QSwipeGesture *)cls)->swipeAngle ());
}

static qt_gsi::GenericMethod *_create_f_swipeAngle_c0 ()
{
  return new qt_gsi::GenericMethod (":swipeAngle", "@brief Method double QSwipeGesture::swipeAngle()\n", true, &_init_f_swipeAngle_c0, &_call_f_swipeAngle_c0);
}

// QSwipeGesture::SwipeDirection QSwipeGesture::verticalDirection()


static void _init_f_verticalDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSwipeGesture::SwipeDirection>::target_type > ();
}

static void _call_f_verticalDirection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSwipeGesture::SwipeDirection>::target_type > ((qt_gsi::Converter<QSwipeGesture::SwipeDirection>::target_type)qt_gsi::CppToQtAdaptor<QSwipeGesture::SwipeDirection>(((QSwipeGesture *)cls)->verticalDirection ()));
}

static qt_gsi::GenericMethod *_create_f_verticalDirection_c0 ()
{
  return new qt_gsi::GenericMethod (":verticalDirection", "@brief Method QSwipeGesture::SwipeDirection QSwipeGesture::verticalDirection()\n", true, &_init_f_verticalDirection_c0, &_call_f_verticalDirection_c0);
}

// static QString QSwipeGesture::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSwipeGesture::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSwipeGesture::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QSwipeGesture::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSwipeGesture::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSwipeGesture::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QSwipeGesture::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSwipeGesture::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSwipeGesture::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QSwipeGesture::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSwipeGesture::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSwipeGesture::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QSwipeGesture, QSwipeGesture_EventAdaptor> ea_QSwipeGesture;

namespace gsi
{
extern gsi::Class<QGesture> decl_QGesture;

gsi::Class<QSwipeGesture> decl_QSwipeGesture (ea_QSwipeGesture, decl_QGesture, "QSwipeGesture_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_horizontalDirection_c0 ()) +
  gsi::Methods(_create_f_setSwipeAngle_1071 ()) +
  gsi::Methods(_create_f_swipeAngle_c0 ()) +
  gsi::Methods(_create_f_verticalDirection_c0 ()) +
  qt_gsi::qt_signal<QSwipeGesture, QSwipeGesture_EventAdaptor, QObject *> ("destroyed", &QSwipeGesture_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QSwipeGesture::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QSwipeGesture");
}


class QSwipeGesture_Adaptor : public QSwipeGesture, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSwipeGesture_Adaptor();

  //  [adaptor ctor] QSwipeGesture::QSwipeGesture(QObject *parent)
  QSwipeGesture_Adaptor() : QSwipeGesture()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSwipeGesture::QSwipeGesture(QObject *parent)
  QSwipeGesture_Adaptor(QObject *parent) : QSwipeGesture(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QSwipeGesture::receivers(const char *signal)
  int fp_QSwipeGesture_receivers_c1731 (const char *signal) const {
    return QSwipeGesture::receivers(signal);
  }

  //  QObject *QSwipeGesture::sender()
  QObject * fp_QSwipeGesture_sender_c0 () const {
    return QSwipeGesture::sender();
  }

  //  [adaptor impl] bool QSwipeGesture::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QSwipeGesture::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSwipeGesture_Adaptor, bool, QEvent *>(&QSwipeGesture_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QSwipeGesture::event(arg1);
    }
  }

  //  [adaptor impl] bool QSwipeGesture::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSwipeGesture::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSwipeGesture_Adaptor, bool, QObject *, QEvent *>(&QSwipeGesture_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSwipeGesture::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QSwipeGesture::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSwipeGesture::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSwipeGesture_Adaptor, QChildEvent *>(&QSwipeGesture_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSwipeGesture::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSwipeGesture::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSwipeGesture::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSwipeGesture_Adaptor, QEvent *>(&QSwipeGesture_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSwipeGesture::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QSwipeGesture::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QSwipeGesture::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QSwipeGesture_Adaptor, const char *>(&QSwipeGesture_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QSwipeGesture::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QSwipeGesture::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSwipeGesture::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSwipeGesture_Adaptor, QTimerEvent *>(&QSwipeGesture_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSwipeGesture::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSwipeGesture_Adaptor::~QSwipeGesture_Adaptor() { }

//  Constructor QSwipeGesture::QSwipeGesture(QObject *parent) (adaptor class)

static void _init_ctor_QSwipeGesture_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSwipeGesture_Adaptor *> ();
}

static void _call_ctor_QSwipeGesture_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSwipeGesture_Adaptor *> (new QSwipeGesture_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSwipeGesture_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSwipeGesture::QSwipeGesture(QObject *parent)\nThis method creates an object of class QSwipeGesture.", &_init_ctor_QSwipeGesture_Adaptor_1302, &_call_ctor_QSwipeGesture_Adaptor_1302);
}

// int QSwipeGesture::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QSwipeGesture_Adaptor *)cls)->fp_QSwipeGesture_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QSwipeGesture::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QSwipeGesture::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QSwipeGesture_Adaptor *)cls)->fp_QSwipeGesture_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QSwipeGesture::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QSwipeGesture::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSwipeGesture_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSwipeGesture_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSwipeGesture::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QSwipeGesture::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSwipeGesture_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSwipeGesture_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSwipeGesture::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QSwipeGesture::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QSwipeGesture_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSwipeGesture_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSwipeGesture::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QSwipeGesture::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QSwipeGesture_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSwipeGesture_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSwipeGesture::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QSwipeGesture::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QSwipeGesture_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QSwipeGesture_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSwipeGesture::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QSwipeGesture::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QSwipeGesture_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSwipeGesture_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSwipeGesture::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QSwipeGesture> decl_QSwipeGesture;

gsi::Class<QSwipeGesture_Adaptor> decl_QSwipeGesture_Adaptor (decl_QSwipeGesture, "QSwipeGesture",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QSwipeGesture_Adaptor_1302 ()),
  "@qt\n@brief Binding of QSwipeGesture");

}


//  Implementation of the enum wrapper class for QSwipeGesture::SwipeDirection
namespace qt_gsi
{

static QSwipeGesture_SwipeDirection_Enum *c_1_QSwipeGesture_SwipeDirection_Enum () { return new QSwipeGesture_SwipeDirection_Enum (QSwipeGesture::NoDirection); }
static QSwipeGesture_SwipeDirection_Enum *c_2_QSwipeGesture_SwipeDirection_Enum () { return new QSwipeGesture_SwipeDirection_Enum (QSwipeGesture::Left); }
static QSwipeGesture_SwipeDirection_Enum *c_3_QSwipeGesture_SwipeDirection_Enum () { return new QSwipeGesture_SwipeDirection_Enum (QSwipeGesture::Right); }
static QSwipeGesture_SwipeDirection_Enum *c_4_QSwipeGesture_SwipeDirection_Enum () { return new QSwipeGesture_SwipeDirection_Enum (QSwipeGesture::Up); }
static QSwipeGesture_SwipeDirection_Enum *c_5_QSwipeGesture_SwipeDirection_Enum () { return new QSwipeGesture_SwipeDirection_Enum (QSwipeGesture::Down); }

static gsi::Methods mkdefs_QSwipeGesture_SwipeDirection () {
  return
    gsi::constant ("NoDirection", &qt_gsi::c_1_QSwipeGesture_SwipeDirection_Enum, "@brief Enum constant QSwipeGesture::NoDirection") +
    gsi::constant ("Left", &qt_gsi::c_2_QSwipeGesture_SwipeDirection_Enum, "@brief Enum constant QSwipeGesture::Left") +
    gsi::constant ("Right", &qt_gsi::c_3_QSwipeGesture_SwipeDirection_Enum, "@brief Enum constant QSwipeGesture::Right") +
    gsi::constant ("Up", &qt_gsi::c_4_QSwipeGesture_SwipeDirection_Enum, "@brief Enum constant QSwipeGesture::Up") +
    gsi::constant ("Down", &qt_gsi::c_5_QSwipeGesture_SwipeDirection_Enum, "@brief Enum constant QSwipeGesture::Down");
}

static std::string to_s_QSwipeGesture_SwipeDirection_Enum (const QSwipeGesture_SwipeDirection_Enum *e)
{
  if (e->value () == QSwipeGesture::NoDirection) { return tl::sprintf ("NoDirection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSwipeGesture::Left) { return tl::sprintf ("Left (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSwipeGesture::Right) { return tl::sprintf ("Right (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSwipeGesture::Up) { return tl::sprintf ("Up (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSwipeGesture::Down) { return tl::sprintf ("Down (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSwipeGesture_SwipeDirection_Enum (const QSwipeGesture_SwipeDirection_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSwipeGesture_SwipeDirection_Enum *from_i_QSwipeGesture_SwipeDirection_Enum (unsigned int i)
{
  return new QSwipeGesture_SwipeDirection_Enum ((QSwipeGesture::SwipeDirection) i);
}

static bool equalQSwipeGesture_SwipeDirection_Enum (const QSwipeGesture_SwipeDirection_Enum *e, QSwipeGesture_SwipeDirection_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSwipeGesture_SwipeDirection_Enum (const QSwipeGesture_SwipeDirection_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSwipeGesture_SwipeDirection_Enums oropQSwipeGesture_SwipeDirection_Enums (const QSwipeGesture_SwipeDirection_Enums *e, const QSwipeGesture_SwipeDirection_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSwipeGesture_SwipeDirection_Enums andopQSwipeGesture_SwipeDirection_Enums (const QSwipeGesture_SwipeDirection_Enums *e, const QSwipeGesture_SwipeDirection_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSwipeGesture_SwipeDirection_Enums xoropQSwipeGesture_SwipeDirection_Enums (const QSwipeGesture_SwipeDirection_Enums *e, const QSwipeGesture_SwipeDirection_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSwipeGesture_SwipeDirection_Enums (const QSwipeGesture_SwipeDirection_Enums *e)
{
  std::string l;
  if (e->testFlag (QSwipeGesture::NoDirection)) { if (!l.empty ()) l += "|"; l += "NoDirection"; }
  if (e->testFlag (QSwipeGesture::Left)) { if (!l.empty ()) l += "|"; l += "Left"; }
  if (e->testFlag (QSwipeGesture::Right)) { if (!l.empty ()) l += "|"; l += "Right"; }
  if (e->testFlag (QSwipeGesture::Up)) { if (!l.empty ()) l += "|"; l += "Up"; }
  if (e->testFlag (QSwipeGesture::Down)) { if (!l.empty ()) l += "|"; l += "Down"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSwipeGesture_SwipeDirection_Enums (const QSwipeGesture_SwipeDirection_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSwipeGesture_SwipeDirection_Enums (const QSwipeGesture_SwipeDirection_Enums *e, const QSwipeGesture_SwipeDirection_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSwipeGesture_SwipeDirection_Enums> decl_QSwipeGesture_SwipeDirection_Enums ("QSwipeGesture_QFlags_SwipeDirection",
  gsi::method_ext ("|", &qt_gsi::oropQSwipeGesture_SwipeDirection_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSwipeGesture_SwipeDirection_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSwipeGesture_SwipeDirection_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSwipeGesture_SwipeDirection_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSwipeGesture_SwipeDirection_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSwipeGesture_SwipeDirection_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSwipeGesture::SwipeDirection> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSwipeGesture_SwipeDirection_Enum> decl_QSwipeGesture_SwipeDirection_Enum (decl_QSwipeGesture_SwipeDirection_Enums, "QSwipeGesture_SwipeDirection",
  qt_gsi::mkdefs_QSwipeGesture_SwipeDirection () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSwipeGesture_SwipeDirection_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSwipeGesture_SwipeDirection_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSwipeGesture_SwipeDirection_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSwipeGesture_SwipeDirection_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSwipeGesture_SwipeDirection_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSwipeGesture::SwipeDirection enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSwipeGesture> inject_QSwipeGesture_SwipeDirection_Enum_in_parent (qt_gsi::mkdefs_QSwipeGesture_SwipeDirection ());
static gsi::ClassExt<QSwipeGesture> decl_QSwipeGesture_SwipeDirection_Enum_as_child (decl_QSwipeGesture_SwipeDirection_Enum, "SwipeDirection");

}

