
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStyle.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQStyle_EventAdaptor.h"
#include "gsiDeclQStyle_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStyle

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStyle::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// int QStyle::combinedLayoutSpacing(QFlags<QSizePolicy::ControlType> controls1, QFlags<QSizePolicy::ControlType> controls2, Qt::Orientation orientation, QStyleOption *option, QWidget *widget)


static void _init_f_combinedLayoutSpacing_c11699 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("controls1");
  decl->add_arg<const qt_gsi::Converter<QFlags<QSizePolicy::ControlType> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("controls2");
  decl->add_arg<const qt_gsi::Converter<QFlags<QSizePolicy::ControlType> >::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option", true, "0");
  decl->add_arg<QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget", true, "0");
  decl->add_arg<QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_f_combinedLayoutSpacing_c11699 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QSizePolicy::ControlType> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QSizePolicy::ControlType> >::target_type & > ();
  const qt_gsi::Converter<QFlags<QSizePolicy::ControlType> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QSizePolicy::ControlType> >::target_type & > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  QStyleOption *arg4 = args ? args.read<QStyleOption * > () : (QStyleOption *)(0);
  QWidget *arg5 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<int > ((int)((QStyle *)cls)->combinedLayoutSpacing (qt_gsi::QtToCppAdaptor<QFlags<QSizePolicy::ControlType> >(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<QSizePolicy::ControlType> >(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg3).cref(), arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_combinedLayoutSpacing_c11699 ()
{
  return new qt_gsi::GenericMethod ("combinedLayoutSpacing", "@brief Method int QStyle::combinedLayoutSpacing(QFlags<QSizePolicy::ControlType> controls1, QFlags<QSizePolicy::ControlType> controls2, Qt::Orientation orientation, QStyleOption *option, QWidget *widget)\n", true, &_init_f_combinedLayoutSpacing_c11699, &_call_f_combinedLayoutSpacing_c11699);
}

// void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)


static void _init_f_drawComplexControl_c9027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawComplexControl_c9027 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > ();
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ((QStyle *)cls)->drawComplexControl (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawComplexControl_c9027 ()
{
  return new qt_gsi::GenericMethod ("drawComplexControl", "@brief Method void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)\n", true, &_init_f_drawComplexControl_c9027, &_call_f_drawComplexControl_c9027);
}

// void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawControl_c8285 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawControl_c8285 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ((QStyle *)cls)->drawControl (qt_gsi::QtToCppAdaptor<QStyle::ControlElement>(arg1).cref(), arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawControl_c8285 ()
{
  return new qt_gsi::GenericMethod ("drawControl", "@brief Method void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\n", true, &_init_f_drawControl_c8285, &_call_f_drawControl_c8285);
}

// void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)


static void _init_f_drawItemPixmap_c5678 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alignment");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawItemPixmap_c5678 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  const QPixmap &arg4 = args.read<const QPixmap & > ();
  ((QStyle *)cls)->drawItemPixmap (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawItemPixmap_c5678 ()
{
  return new qt_gsi::GenericMethod ("drawItemPixmap", "@brief Method void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)\n", true, &_init_f_drawItemPixmap_c5678, &_call_f_drawItemPixmap_c5678);
}

// void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)


static void _init_f_drawItemText_c10604 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pal");
  decl->add_arg<const QPalette & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("enabled");
  decl->add_arg<bool > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("textRole", true, "QPalette::NoRole");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_drawItemText_c10604 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  const QPalette &arg4 = args.read<const QPalette & > ();
  bool arg5 = args.read<bool > ();
  const QString &arg6 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg7 = args ? args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > () : (const qt_gsi::Converter<QPalette::ColorRole>::target_type &)(qt_gsi::CppToQtReadAdaptor<QPalette::ColorRole>(heap, QPalette::NoRole));
  ((QStyle *)cls)->drawItemText (arg1, arg2, arg3, arg4, arg5, arg6, qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(arg7).cref());
}

static qt_gsi::GenericMethod *_create_f_drawItemText_c10604 ()
{
  return new qt_gsi::GenericMethod ("drawItemText", "@brief Method void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)\n", true, &_init_f_drawItemText_c10604, &_call_f_drawItemText_c10604);
}

// void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawPrimitive_c8501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawPrimitive_c8501 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ((QStyle *)cls)->drawPrimitive (qt_gsi::QtToCppAdaptor<QStyle::PrimitiveElement>(arg1).cref(), arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawPrimitive_c8501 ()
{
  return new qt_gsi::GenericMethod ("drawPrimitive", "@brief Method void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\n", true, &_init_f_drawPrimitive_c8501, &_call_f_drawPrimitive_c8501);
}

// QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)


static void _init_f_generatedIconPixmap_c5776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconMode");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_generatedIconPixmap_c5776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg1 = args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QStyleOption *arg3 = args.read<const QStyleOption * > ();
  ret.write<QPixmap > ((QPixmap)((QStyle *)cls)->generatedIconPixmap (qt_gsi::QtToCppAdaptor<QIcon::Mode>(arg1).cref(), arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_generatedIconPixmap_c5776 ()
{
  return new qt_gsi::GenericMethod ("generatedIconPixmap", "@brief Method QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)\n", true, &_init_f_generatedIconPixmap_c5776, &_call_f_generatedIconPixmap_c5776);
}

// QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)


static void _init_f_hitTestComplexControl_c9517 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pt");
  decl->add_arg<const QPoint & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<qt_gsi::Converter<QStyle::SubControl>::target_type > ();
}

static void _call_f_hitTestComplexControl_c9517 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > ();
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > ();
  const QPoint &arg3 = args.read<const QPoint & > ();
  const QWidget *arg4 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<qt_gsi::Converter<QStyle::SubControl>::target_type > ((qt_gsi::Converter<QStyle::SubControl>::target_type)qt_gsi::CppToQtAdaptor<QStyle::SubControl>(((QStyle *)cls)->hitTestComplexControl (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, arg3, arg4)));
}

static qt_gsi::GenericMethod *_create_f_hitTestComplexControl_c9517 ()
{
  return new qt_gsi::GenericMethod ("hitTestComplexControl", "@brief Method QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)\n", true, &_init_f_hitTestComplexControl_c9517, &_call_f_hitTestComplexControl_c9517);
}

// QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)


static void _init_f_itemPixmapRect_c4360 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_itemPixmapRect_c4360 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  int arg2 = args.read<int > ();
  const QPixmap &arg3 = args.read<const QPixmap & > ();
  ret.write<QRect > ((QRect)((QStyle *)cls)->itemPixmapRect (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_itemPixmapRect_c4360 ()
{
  return new qt_gsi::GenericMethod ("itemPixmapRect", "@brief Method QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)\n", true, &_init_f_itemPixmapRect_c4360, &_call_f_itemPixmapRect_c4360);
}

// QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)


static void _init_f_itemTextRect_c7544 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fm");
  decl->add_arg<const QFontMetrics & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("r");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("enabled");
  decl->add_arg<bool > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("text");
  decl->add_arg<const QString & > (argspec_4);
  decl->set_return<QRect > ();
}

static void _call_f_itemTextRect_c7544 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFontMetrics &arg1 = args.read<const QFontMetrics & > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  bool arg4 = args.read<bool > ();
  const QString &arg5 = args.read<const QString & > ();
  ret.write<QRect > ((QRect)((QStyle *)cls)->itemTextRect (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_itemTextRect_c7544 ()
{
  return new qt_gsi::GenericMethod ("itemTextRect", "@brief Method QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)\n", true, &_init_f_itemTextRect_c7544, &_call_f_itemTextRect_c7544);
}

// int QStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)


static void _init_f_layoutSpacing_c11697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("control1");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("control2");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_f_layoutSpacing_c11697 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > ();
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QStyleOption *arg4 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg5 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<int > ((int)((QStyle *)cls)->layoutSpacing (qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg3).cref(), arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_layoutSpacing_c11697 ()
{
  return new qt_gsi::GenericMethod ("layoutSpacing", "@brief Method int QStyle::layoutSpacing(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)\n", true, &_init_f_layoutSpacing_c11697, &_call_f_layoutSpacing_c11697);
}

// int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)


static void _init_f_pixelMetric_c6642 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_pixelMetric_c6642 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > ();
  const QStyleOption *arg2 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg3 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<int > ((int)((QStyle *)cls)->pixelMetric (qt_gsi::QtToCppAdaptor<QStyle::PixelMetric>(arg1).cref(), arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_pixelMetric_c6642 ()
{
  return new qt_gsi::GenericMethod ("pixelMetric", "@brief Method int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)\n", true, &_init_f_pixelMetric_c6642, &_call_f_pixelMetric_c6642);
}

// void QStyle::polish(QWidget *)


static void _init_f_polish_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QStyle *)cls)->polish (arg1);
}

static qt_gsi::GenericMethod *_create_f_polish_1315 ()
{
  return new qt_gsi::GenericMethod ("polish", "@brief Method void QStyle::polish(QWidget *)\n", false, &_init_f_polish_1315, &_call_f_polish_1315);
}

// void QStyle::polish(QApplication *)


static void _init_f_polish_1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1843 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication *arg1 = args.read<QApplication * > ();
  ((QStyle *)cls)->polish (arg1);
}

static qt_gsi::GenericMethod *_create_f_polish_1843 ()
{
  return new qt_gsi::GenericMethod ("polish", "@brief Method void QStyle::polish(QApplication *)\n", false, &_init_f_polish_1843, &_call_f_polish_1843);
}

// void QStyle::polish(QPalette &)


static void _init_f_polish_1418 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1418 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPalette &arg1 = args.read<QPalette & > ();
  ((QStyle *)cls)->polish (arg1);
}

static qt_gsi::GenericMethod *_create_f_polish_1418 ()
{
  return new qt_gsi::GenericMethod ("polish", "@brief Method void QStyle::polish(QPalette &)\n", false, &_init_f_polish_1418, &_call_f_polish_1418);
}

// const QStyle *QStyle::proxy()


static void _init_f_proxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QStyle * > ();
}

static void _call_f_proxy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QStyle * > ((const QStyle *)((QStyle *)cls)->proxy ());
}

static qt_gsi::GenericMethod *_create_f_proxy_c0 ()
{
  return new qt_gsi::GenericMethod ("proxy", "@brief Method const QStyle *QStyle::proxy()\n", true, &_init_f_proxy_c0, &_call_f_proxy_c0);
}

// QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)


static void _init_f_sizeFromContents_c8477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ct");
  decl->add_arg<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("contentsSize");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QSize > ();
}

static void _call_f_sizeFromContents_c8477 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ContentsType>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QSize &arg3 = args.read<const QSize & > ();
  const QWidget *arg4 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<QSize > ((QSize)((QStyle *)cls)->sizeFromContents (qt_gsi::QtToCppAdaptor<QStyle::ContentsType>(arg1).cref(), arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_sizeFromContents_c8477 ()
{
  return new qt_gsi::GenericMethod ("sizeFromContents", "@brief Method QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)\n", true, &_init_f_sizeFromContents_c8477, &_call_f_sizeFromContents_c8477);
}

// QIcon QStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *option, const QWidget *widget)


static void _init_f_standardIcon_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardIcon");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QIcon > ();
}

static void _call_f_standardIcon_c6956 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > ();
  const QStyleOption *arg2 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg3 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<QIcon > ((QIcon)((QStyle *)cls)->standardIcon (qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(arg1).cref(), arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_standardIcon_c6956 ()
{
  return new qt_gsi::GenericMethod ("standardIcon", "@brief Method QIcon QStyle::standardIcon(QStyle::StandardPixmap standardIcon, const QStyleOption *option, const QWidget *widget)\n", true, &_init_f_standardIcon_c6956, &_call_f_standardIcon_c6956);
}

// QPalette QStyle::standardPalette()


static void _init_f_standardPalette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_standardPalette_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPalette > ((QPalette)((QStyle *)cls)->standardPalette ());
}

static qt_gsi::GenericMethod *_create_f_standardPalette_c0 ()
{
  return new qt_gsi::GenericMethod ("standardPalette", "@brief Method QPalette QStyle::standardPalette()\n", true, &_init_f_standardPalette_c0, &_call_f_standardPalette_c0);
}

// QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)


static void _init_f_standardPixmap_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardPixmap");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_standardPixmap_c6956 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > ();
  const QStyleOption *arg2 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg3 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<QPixmap > ((QPixmap)((QStyle *)cls)->standardPixmap (qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(arg1).cref(), arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_standardPixmap_c6956 ()
{
  return new qt_gsi::GenericMethod ("standardPixmap", "@brief Method QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)\n", true, &_init_f_standardPixmap_c6956, &_call_f_standardPixmap_c6956);
}

// int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)


static void _init_f_styleHint_c8615 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stylehint");
  decl->add_arg<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("returnData", true, "0");
  decl->add_arg<QStyleHintReturn * > (argspec_3);
  decl->set_return<int > ();
}

static void _call_f_styleHint_c8615 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::StyleHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > ();
  const QStyleOption *arg2 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg3 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  QStyleHintReturn *arg4 = args ? args.read<QStyleHintReturn * > () : (QStyleHintReturn *)(0);
  ret.write<int > ((int)((QStyle *)cls)->styleHint (qt_gsi::QtToCppAdaptor<QStyle::StyleHint>(arg1).cref(), arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_styleHint_c8615 ()
{
  return new qt_gsi::GenericMethod ("styleHint", "@brief Method int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)\n", true, &_init_f_styleHint_c8615, &_call_f_styleHint_c8615);
}

// QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)


static void _init_f_subControlRect_c9798 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sc");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_f_subControlRect_c9798 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > ();
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > ();
  const qt_gsi::Converter<QStyle::SubControl>::target_type & arg3 = args.read<const qt_gsi::Converter<QStyle::SubControl>::target_type & > ();
  const QWidget *arg4 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<QRect > ((QRect)((QStyle *)cls)->subControlRect (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, qt_gsi::QtToCppAdaptor<QStyle::SubControl>(arg3).cref(), arg4));
}

static qt_gsi::GenericMethod *_create_f_subControlRect_c9798 ()
{
  return new qt_gsi::GenericMethod ("subControlRect", "@brief Method QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)\n", true, &_init_f_subControlRect_c9798, &_call_f_subControlRect_c9798);
}

// QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)


static void _init_f_subElementRect_c6528 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subElement");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_subElementRect_c6528 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::SubElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::SubElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QWidget *arg3 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<QRect > ((QRect)((QStyle *)cls)->subElementRect (qt_gsi::QtToCppAdaptor<QStyle::SubElement>(arg1).cref(), arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_subElementRect_c6528 ()
{
  return new qt_gsi::GenericMethod ("subElementRect", "@brief Method QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)\n", true, &_init_f_subElementRect_c6528, &_call_f_subElementRect_c6528);
}

// void QStyle::unpolish(QWidget *)


static void _init_f_unpolish_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unpolish_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QStyle *)cls)->unpolish (arg1);
}

static qt_gsi::GenericMethod *_create_f_unpolish_1315 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@brief Method void QStyle::unpolish(QWidget *)\n", false, &_init_f_unpolish_1315, &_call_f_unpolish_1315);
}

// void QStyle::unpolish(QApplication *)


static void _init_f_unpolish_1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unpolish_1843 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication *arg1 = args.read<QApplication * > ();
  ((QStyle *)cls)->unpolish (arg1);
}

static qt_gsi::GenericMethod *_create_f_unpolish_1843 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@brief Method void QStyle::unpolish(QApplication *)\n", false, &_init_f_unpolish_1843, &_call_f_unpolish_1843);
}

// static QRect QStyle::alignedRect(Qt::LayoutDirection direction, QFlags<Qt::AlignmentFlag> alignment, const QSize &size, const QRect &rectangle)


static void _init_f_alignedRect_8339 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("size");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("rectangle");
  decl->add_arg<const QRect & > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_f_alignedRect_8339 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ();
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > ();
  const QSize &arg3 = args.read<const QSize & > ();
  const QRect &arg4 = args.read<const QRect & > ();
  ret.write<QRect > ((QRect)QStyle::alignedRect (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg2).cref(), arg3, arg4));
}

static qt_gsi::GenericStaticMethod *_create_f_alignedRect_8339 ()
{
  return new qt_gsi::GenericStaticMethod ("alignedRect", "@brief Static method QRect QStyle::alignedRect(Qt::LayoutDirection direction, QFlags<Qt::AlignmentFlag> alignment, const QSize &size, const QRect &rectangle)\nThis method is static and can be called without an instance.", &_init_f_alignedRect_8339, &_call_f_alignedRect_8339);
}

// static int QStyle::sliderPositionFromValue(int min, int max, int val, int space, bool upsideDown)


static void _init_f_sliderPositionFromValue_3500 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("val");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("space");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("upsideDown", true, "false");
  decl->add_arg<bool > (argspec_4);
  decl->set_return<int > ();
}

static void _call_f_sliderPositionFromValue_3500 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  bool arg5 = args ? args.read<bool > () : (bool)(false);
  ret.write<int > ((int)QStyle::sliderPositionFromValue (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericStaticMethod *_create_f_sliderPositionFromValue_3500 ()
{
  return new qt_gsi::GenericStaticMethod ("sliderPositionFromValue", "@brief Static method int QStyle::sliderPositionFromValue(int min, int max, int val, int space, bool upsideDown)\nThis method is static and can be called without an instance.", &_init_f_sliderPositionFromValue_3500, &_call_f_sliderPositionFromValue_3500);
}

// static int QStyle::sliderValueFromPosition(int min, int max, int pos, int space, bool upsideDown)


static void _init_f_sliderValueFromPosition_3500 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pos");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("space");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("upsideDown", true, "false");
  decl->add_arg<bool > (argspec_4);
  decl->set_return<int > ();
}

static void _call_f_sliderValueFromPosition_3500 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  bool arg5 = args ? args.read<bool > () : (bool)(false);
  ret.write<int > ((int)QStyle::sliderValueFromPosition (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericStaticMethod *_create_f_sliderValueFromPosition_3500 ()
{
  return new qt_gsi::GenericStaticMethod ("sliderValueFromPosition", "@brief Static method int QStyle::sliderValueFromPosition(int min, int max, int pos, int space, bool upsideDown)\nThis method is static and can be called without an instance.", &_init_f_sliderValueFromPosition_3500, &_call_f_sliderValueFromPosition_3500);
}

// static QString QStyle::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStyle::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStyle::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QStyle::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStyle::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStyle::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QStyle::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStyle::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStyle::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QStyle::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStyle::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStyle::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

// static QFlags<Qt::AlignmentFlag> QStyle::visualAlignment(Qt::LayoutDirection direction, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_visualAlignment_4958 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ();
}

static void _call_f_visualAlignment_4958 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ();
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::AlignmentFlag> >(QStyle::visualAlignment (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg2).cref())));
}

static qt_gsi::GenericStaticMethod *_create_f_visualAlignment_4958 ()
{
  return new qt_gsi::GenericStaticMethod ("visualAlignment", "@brief Static method QFlags<Qt::AlignmentFlag> QStyle::visualAlignment(Qt::LayoutDirection direction, QFlags<Qt::AlignmentFlag> alignment)\nThis method is static and can be called without an instance.", &_init_f_visualAlignment_4958, &_call_f_visualAlignment_4958);
}

// static QPoint QStyle::visualPos(Qt::LayoutDirection direction, const QRect &boundingRect, const QPoint &logicalPos)


static void _init_f_visualPos_5808 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundingRect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("logicalPos");
  decl->add_arg<const QPoint & > (argspec_2);
  decl->set_return<QPoint > ();
}

static void _call_f_visualPos_5808 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ();
  const QRect &arg2 = args.read<const QRect & > ();
  const QPoint &arg3 = args.read<const QPoint & > ();
  ret.write<QPoint > ((QPoint)QStyle::visualPos (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref(), arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_visualPos_5808 ()
{
  return new qt_gsi::GenericStaticMethod ("visualPos", "@brief Static method QPoint QStyle::visualPos(Qt::LayoutDirection direction, const QRect &boundingRect, const QPoint &logicalPos)\nThis method is static and can be called without an instance.", &_init_f_visualPos_5808, &_call_f_visualPos_5808);
}

// static QRect QStyle::visualRect(Qt::LayoutDirection direction, const QRect &boundingRect, const QRect &logicalRect)


static void _init_f_visualRect_5684 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundingRect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("logicalRect");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_visualRect_5684 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ();
  const QRect &arg2 = args.read<const QRect & > ();
  const QRect &arg3 = args.read<const QRect & > ();
  ret.write<QRect > ((QRect)QStyle::visualRect (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref(), arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_visualRect_5684 ()
{
  return new qt_gsi::GenericStaticMethod ("visualRect", "@brief Static method QRect QStyle::visualRect(Qt::LayoutDirection direction, const QRect &boundingRect, const QRect &logicalRect)\nThis method is static and can be called without an instance.", &_init_f_visualRect_5684, &_call_f_visualRect_5684);
}

static qt_gsi::QObjectConnector<QStyle, QStyle_EventAdaptor> ea_QStyle;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QStyle> decl_QStyle (ea_QStyle, decl_QObject, "QStyle_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_combinedLayoutSpacing_c11699 ()) +
  gsi::Methods(_create_f_drawComplexControl_c9027 ()) +
  gsi::Methods(_create_f_drawControl_c8285 ()) +
  gsi::Methods(_create_f_drawItemPixmap_c5678 ()) +
  gsi::Methods(_create_f_drawItemText_c10604 ()) +
  gsi::Methods(_create_f_drawPrimitive_c8501 ()) +
  gsi::Methods(_create_f_generatedIconPixmap_c5776 ()) +
  gsi::Methods(_create_f_hitTestComplexControl_c9517 ()) +
  gsi::Methods(_create_f_itemPixmapRect_c4360 ()) +
  gsi::Methods(_create_f_itemTextRect_c7544 ()) +
  gsi::Methods(_create_f_layoutSpacing_c11697 ()) +
  gsi::Methods(_create_f_pixelMetric_c6642 ()) +
  gsi::Methods(_create_f_polish_1315 ()) +
  gsi::Methods(_create_f_polish_1843 ()) +
  gsi::Methods(_create_f_polish_1418 ()) +
  gsi::Methods(_create_f_proxy_c0 ()) +
  gsi::Methods(_create_f_sizeFromContents_c8477 ()) +
  gsi::Methods(_create_f_standardIcon_c6956 ()) +
  gsi::Methods(_create_f_standardPalette_c0 ()) +
  gsi::Methods(_create_f_standardPixmap_c6956 ()) +
  gsi::Methods(_create_f_styleHint_c8615 ()) +
  gsi::Methods(_create_f_subControlRect_c9798 ()) +
  gsi::Methods(_create_f_subElementRect_c6528 ()) +
  gsi::Methods(_create_f_unpolish_1315 ()) +
  gsi::Methods(_create_f_unpolish_1843 ()) +
  qt_gsi::qt_signal<QStyle, QStyle_EventAdaptor, QObject *> ("destroyed", &QStyle_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QStyle::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_alignedRect_8339 ()) +
  gsi::Methods(_create_f_sliderPositionFromValue_3500 ()) +
  gsi::Methods(_create_f_sliderValueFromPosition_3500 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()) +
  gsi::Methods(_create_f_visualAlignment_4958 ()) +
  gsi::Methods(_create_f_visualPos_5808 ()) +
  gsi::Methods(_create_f_visualRect_5684 ()),
  "@hide\n@alias QStyle");
}


class QStyle_Adaptor : public QStyle, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStyle_Adaptor();

  //  [adaptor ctor] QStyle::QStyle()
  QStyle_Adaptor() : QStyle()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QStyle::layoutSpacingImplementation(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)
  int fp_QStyle_layoutSpacingImplementation_c11697 (const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control1, const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control2, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QStyleOption *option, const QWidget *widget) const {
    return QStyle::layoutSpacingImplementation(qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(control1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(control2).cref(), qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), option, widget);
  }

  //  int QStyle::receivers(const char *signal)
  int fp_QStyle_receivers_c1731 (const char *signal) const {
    return QStyle::receivers(signal);
  }

  //  QObject *QStyle::sender()
  QObject * fp_QStyle_sender_c0 () const {
    return QStyle::sender();
  }

  //  QIcon QStyle::standardIconImplementation(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)
  QIcon fp_QStyle_standardIconImplementation_c6956 (const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & standardIcon, const QStyleOption *opt, const QWidget *widget) const {
    return QStyle::standardIconImplementation(qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(standardIcon).cref(), opt, widget);
  }

  //  [adaptor impl] void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)
  void cbs_drawComplexControl_c9027_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget) const
  {
    throw qt_gsi::AbstractMethodCalledException("drawComplexControl");
  }

  virtual void drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget) const
  {
    if (cb_drawComplexControl_c9027_1.can_issue()) {
      cb_drawComplexControl_c9027_1.issue<QStyle_Adaptor, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, QPainter *, const QWidget *>(&QStyle_Adaptor::cbs_drawComplexControl_c9027_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, p, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("drawComplexControl");
    }
  }

  //  [adaptor impl] void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawControl_c8285_1(const qt_gsi::Converter<QStyle::ControlElement>::target_type & element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    throw qt_gsi::AbstractMethodCalledException("drawControl");
  }

  virtual void drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawControl_c8285_1.can_issue()) {
      cb_drawControl_c8285_1.issue<QStyle_Adaptor, const qt_gsi::Converter<QStyle::ControlElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QStyle_Adaptor::cbs_drawControl_c8285_1, qt_gsi::CppToQtAdaptor<QStyle::ControlElement>(element), opt, p, w);
    } else {
      throw qt_gsi::AbstractMethodCalledException("drawControl");
    }
  }

  //  [adaptor impl] void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)
  void cbs_drawItemPixmap_c5678_0(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    QStyle::drawItemPixmap(painter, rect, alignment, pixmap);
  }

  virtual void drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    if (cb_drawItemPixmap_c5678_0.can_issue()) {
      cb_drawItemPixmap_c5678_0.issue<QStyle_Adaptor, QPainter *, const QRect &, int, const QPixmap &>(&QStyle_Adaptor::cbs_drawItemPixmap_c5678_0, painter, rect, alignment, pixmap);
    } else {
      QStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }
  }

  //  [adaptor impl] void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)
  void cbs_drawItemText_c10604_1(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, const qt_gsi::Converter<QPalette::ColorRole>::target_type & textRole) const
  {
    QStyle::drawItemText(painter, rect, flags, pal, enabled, text, qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(textRole).cref());
  }

  virtual void drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole) const
  {
    if (cb_drawItemText_c10604_1.can_issue()) {
      cb_drawItemText_c10604_1.issue<QStyle_Adaptor, QPainter *, const QRect &, int, const QPalette &, bool, const QString &, const qt_gsi::Converter<QPalette::ColorRole>::target_type &>(&QStyle_Adaptor::cbs_drawItemText_c10604_1, painter, rect, flags, pal, enabled, text, qt_gsi::CppToQtAdaptor<QPalette::ColorRole>(textRole));
    } else {
      QStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }
  }

  //  [adaptor impl] void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawPrimitive_c8501_1(const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    throw qt_gsi::AbstractMethodCalledException("drawPrimitive");
  }

  virtual void drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawPrimitive_c8501_1.can_issue()) {
      cb_drawPrimitive_c8501_1.issue<QStyle_Adaptor, const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QStyle_Adaptor::cbs_drawPrimitive_c8501_1, qt_gsi::CppToQtAdaptor<QStyle::PrimitiveElement>(pe), opt, p, w);
    } else {
      throw qt_gsi::AbstractMethodCalledException("drawPrimitive");
    }
  }

  //  [adaptor impl] bool QStyle::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QStyle::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStyle_Adaptor, bool, QEvent *>(&QStyle_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QStyle::event(arg1);
    }
  }

  //  [adaptor impl] bool QStyle::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QStyle::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStyle_Adaptor, bool, QObject *, QEvent *>(&QStyle_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QStyle::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)
  QPixmap cbs_generatedIconPixmap_c5776_0(const qt_gsi::Converter<QIcon::Mode>::target_type & iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    throw qt_gsi::AbstractMethodCalledException("generatedIconPixmap");
  }

  virtual QPixmap generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    if (cb_generatedIconPixmap_c5776_0.can_issue()) {
      return cb_generatedIconPixmap_c5776_0.issue<QStyle_Adaptor, QPixmap, const qt_gsi::Converter<QIcon::Mode>::target_type &, const QPixmap &, const QStyleOption *>(&QStyle_Adaptor::cbs_generatedIconPixmap_c5776_0, qt_gsi::CppToQtAdaptor<QIcon::Mode>(iconMode), pixmap, opt);
    } else {
      throw qt_gsi::AbstractMethodCalledException("generatedIconPixmap");
    }
  }

  //  [adaptor impl] QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)
  qt_gsi::Converter<QStyle::SubControl>::target_type cbs_hitTestComplexControl_c9517_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget) const
  {
    throw qt_gsi::AbstractMethodCalledException("hitTestComplexControl");
  }

  virtual QStyle::SubControl hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget) const
  {
    if (cb_hitTestComplexControl_c9517_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStyle::SubControl>(cb_hitTestComplexControl_c9517_1.issue<QStyle_Adaptor, qt_gsi::Converter<QStyle::SubControl>::target_type, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const QPoint &, const QWidget *>(&QStyle_Adaptor::cbs_hitTestComplexControl_c9517_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, pt, widget)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("hitTestComplexControl");
    }
  }

  //  [adaptor impl] QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)
  QRect cbs_itemPixmapRect_c4360_0(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    return QStyle::itemPixmapRect(r, flags, pixmap);
  }

  virtual QRect itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    if (cb_itemPixmapRect_c4360_0.can_issue()) {
      return cb_itemPixmapRect_c4360_0.issue<QStyle_Adaptor, QRect, const QRect &, int, const QPixmap &>(&QStyle_Adaptor::cbs_itemPixmapRect_c4360_0, r, flags, pixmap);
    } else {
      return QStyle::itemPixmapRect(r, flags, pixmap);
    }
  }

  //  [adaptor impl] QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)
  QRect cbs_itemTextRect_c7544_0(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    return QStyle::itemTextRect(fm, r, flags, enabled, text);
  }

  virtual QRect itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    if (cb_itemTextRect_c7544_0.can_issue()) {
      return cb_itemTextRect_c7544_0.issue<QStyle_Adaptor, QRect, const QFontMetrics &, const QRect &, int, bool, const QString &>(&QStyle_Adaptor::cbs_itemTextRect_c7544_0, fm, r, flags, enabled, text);
    } else {
      return QStyle::itemTextRect(fm, r, flags, enabled, text);
    }
  }

  //  [adaptor impl] int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)
  int cbs_pixelMetric_c6642_2(const qt_gsi::Converter<QStyle::PixelMetric>::target_type & metric, const QStyleOption *option, const QWidget *widget) const
  {
    throw qt_gsi::AbstractMethodCalledException("pixelMetric");
  }

  virtual int pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget) const
  {
    if (cb_pixelMetric_c6642_2.can_issue()) {
      return cb_pixelMetric_c6642_2.issue<QStyle_Adaptor, int, const qt_gsi::Converter<QStyle::PixelMetric>::target_type &, const QStyleOption *, const QWidget *>(&QStyle_Adaptor::cbs_pixelMetric_c6642_2, qt_gsi::CppToQtAdaptor<QStyle::PixelMetric>(metric), option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("pixelMetric");
    }
  }

  //  [adaptor impl] void QStyle::polish(QWidget *)
  void cbs_polish_1315_0(QWidget *arg1)
  {
    QStyle::polish(arg1);
  }

  virtual void polish(QWidget *arg1)
  {
    if (cb_polish_1315_0.can_issue()) {
      cb_polish_1315_0.issue<QStyle_Adaptor, QWidget *>(&QStyle_Adaptor::cbs_polish_1315_0, arg1);
    } else {
      QStyle::polish(arg1);
    }
  }

  //  [adaptor impl] void QStyle::polish(QApplication *)
  void cbs_polish_1843_0(QApplication *arg1)
  {
    QStyle::polish(arg1);
  }

  virtual void polish(QApplication *arg1)
  {
    if (cb_polish_1843_0.can_issue()) {
      cb_polish_1843_0.issue<QStyle_Adaptor, QApplication *>(&QStyle_Adaptor::cbs_polish_1843_0, arg1);
    } else {
      QStyle::polish(arg1);
    }
  }

  //  [adaptor impl] void QStyle::polish(QPalette &)
  void cbs_polish_1418_0(QPalette &arg1)
  {
    QStyle::polish(arg1);
  }

  virtual void polish(QPalette &arg1)
  {
    if (cb_polish_1418_0.can_issue()) {
      cb_polish_1418_0.issue<QStyle_Adaptor, QPalette &>(&QStyle_Adaptor::cbs_polish_1418_0, arg1);
    } else {
      QStyle::polish(arg1);
    }
  }

  //  [adaptor impl] QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)
  QSize cbs_sizeFromContents_c8477_1(const qt_gsi::Converter<QStyle::ContentsType>::target_type & ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w) const
  {
    throw qt_gsi::AbstractMethodCalledException("sizeFromContents");
  }

  virtual QSize sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w) const
  {
    if (cb_sizeFromContents_c8477_1.can_issue()) {
      return cb_sizeFromContents_c8477_1.issue<QStyle_Adaptor, QSize, const qt_gsi::Converter<QStyle::ContentsType>::target_type &, const QStyleOption *, const QSize &, const QWidget *>(&QStyle_Adaptor::cbs_sizeFromContents_c8477_1, qt_gsi::CppToQtAdaptor<QStyle::ContentsType>(ct), opt, contentsSize, w);
    } else {
      throw qt_gsi::AbstractMethodCalledException("sizeFromContents");
    }
  }

  //  [adaptor impl] QPalette QStyle::standardPalette()
  QPalette cbs_standardPalette_c0_0() const
  {
    return QStyle::standardPalette();
  }

  virtual QPalette standardPalette() const
  {
    if (cb_standardPalette_c0_0.can_issue()) {
      return cb_standardPalette_c0_0.issue<QStyle_Adaptor, QPalette>(&QStyle_Adaptor::cbs_standardPalette_c0_0);
    } else {
      return QStyle::standardPalette();
    }
  }

  //  [adaptor impl] QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)
  QPixmap cbs_standardPixmap_c6956_2(const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & _standardPixmap, const QStyleOption *opt, const QWidget *widget) const
  {
    throw qt_gsi::AbstractMethodCalledException("standardPixmap");
  }

  virtual QPixmap standardPixmap(QStyle::StandardPixmap _standardPixmap, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_standardPixmap_c6956_2.can_issue()) {
      return cb_standardPixmap_c6956_2.issue<QStyle_Adaptor, QPixmap, const qt_gsi::Converter<QStyle::StandardPixmap>::target_type &, const QStyleOption *, const QWidget *>(&QStyle_Adaptor::cbs_standardPixmap_c6956_2, qt_gsi::CppToQtAdaptor<QStyle::StandardPixmap>(_standardPixmap), opt, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("standardPixmap");
    }
  }

  //  [adaptor impl] int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)
  int cbs_styleHint_c8615_3(const qt_gsi::Converter<QStyle::StyleHint>::target_type & stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData) const
  {
    throw qt_gsi::AbstractMethodCalledException("styleHint");
  }

  virtual int styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData) const
  {
    if (cb_styleHint_c8615_3.can_issue()) {
      return cb_styleHint_c8615_3.issue<QStyle_Adaptor, int, const qt_gsi::Converter<QStyle::StyleHint>::target_type &, const QStyleOption *, const QWidget *, QStyleHintReturn *>(&QStyle_Adaptor::cbs_styleHint_c8615_3, qt_gsi::CppToQtAdaptor<QStyle::StyleHint>(stylehint), opt, widget, returnData);
    } else {
      throw qt_gsi::AbstractMethodCalledException("styleHint");
    }
  }

  //  [adaptor impl] QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)
  QRect cbs_subControlRect_c9798_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const qt_gsi::Converter<QStyle::SubControl>::target_type & sc, const QWidget *widget) const
  {
    throw qt_gsi::AbstractMethodCalledException("subControlRect");
  }

  virtual QRect subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget) const
  {
    if (cb_subControlRect_c9798_1.can_issue()) {
      return cb_subControlRect_c9798_1.issue<QStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const qt_gsi::Converter<QStyle::SubControl>::target_type &, const QWidget *>(&QStyle_Adaptor::cbs_subControlRect_c9798_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, qt_gsi::CppToQtAdaptor<QStyle::SubControl>(sc), widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("subControlRect");
    }
  }

  //  [adaptor impl] QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)
  QRect cbs_subElementRect_c6528_1(const qt_gsi::Converter<QStyle::SubElement>::target_type & subElement, const QStyleOption *option, const QWidget *widget) const
  {
    throw qt_gsi::AbstractMethodCalledException("subElementRect");
  }

  virtual QRect subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget) const
  {
    if (cb_subElementRect_c6528_1.can_issue()) {
      return cb_subElementRect_c6528_1.issue<QStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::SubElement>::target_type &, const QStyleOption *, const QWidget *>(&QStyle_Adaptor::cbs_subElementRect_c6528_1, qt_gsi::CppToQtAdaptor<QStyle::SubElement>(subElement), option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("subElementRect");
    }
  }

  //  [adaptor impl] void QStyle::unpolish(QWidget *)
  void cbs_unpolish_1315_0(QWidget *arg1)
  {
    QStyle::unpolish(arg1);
  }

  virtual void unpolish(QWidget *arg1)
  {
    if (cb_unpolish_1315_0.can_issue()) {
      cb_unpolish_1315_0.issue<QStyle_Adaptor, QWidget *>(&QStyle_Adaptor::cbs_unpolish_1315_0, arg1);
    } else {
      QStyle::unpolish(arg1);
    }
  }

  //  [adaptor impl] void QStyle::unpolish(QApplication *)
  void cbs_unpolish_1843_0(QApplication *arg1)
  {
    QStyle::unpolish(arg1);
  }

  virtual void unpolish(QApplication *arg1)
  {
    if (cb_unpolish_1843_0.can_issue()) {
      cb_unpolish_1843_0.issue<QStyle_Adaptor, QApplication *>(&QStyle_Adaptor::cbs_unpolish_1843_0, arg1);
    } else {
      QStyle::unpolish(arg1);
    }
  }

  //  [adaptor impl] void QStyle::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QStyle::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStyle_Adaptor, QChildEvent *>(&QStyle_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QStyle::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QStyle::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QStyle::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStyle_Adaptor, QEvent *>(&QStyle_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QStyle::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QStyle::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QStyle::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QStyle_Adaptor, const char *>(&QStyle_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QStyle::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QStyle::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QStyle::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStyle_Adaptor, QTimerEvent *>(&QStyle_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QStyle::timerEvent(arg1);
    }
  }

  gsi::Callback cb_drawComplexControl_c9027_1;
  gsi::Callback cb_drawControl_c8285_1;
  gsi::Callback cb_drawItemPixmap_c5678_0;
  gsi::Callback cb_drawItemText_c10604_1;
  gsi::Callback cb_drawPrimitive_c8501_1;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_generatedIconPixmap_c5776_0;
  gsi::Callback cb_hitTestComplexControl_c9517_1;
  gsi::Callback cb_itemPixmapRect_c4360_0;
  gsi::Callback cb_itemTextRect_c7544_0;
  gsi::Callback cb_pixelMetric_c6642_2;
  gsi::Callback cb_polish_1315_0;
  gsi::Callback cb_polish_1843_0;
  gsi::Callback cb_polish_1418_0;
  gsi::Callback cb_sizeFromContents_c8477_1;
  gsi::Callback cb_standardPalette_c0_0;
  gsi::Callback cb_standardPixmap_c6956_2;
  gsi::Callback cb_styleHint_c8615_3;
  gsi::Callback cb_subControlRect_c9798_1;
  gsi::Callback cb_subElementRect_c6528_1;
  gsi::Callback cb_unpolish_1315_0;
  gsi::Callback cb_unpolish_1843_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStyle_Adaptor::~QStyle_Adaptor() { }

//  Constructor QStyle::QStyle() (adaptor class)

static void _init_ctor_QStyle_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QStyle_Adaptor *> ();
}

static void _call_ctor_QStyle_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyle_Adaptor *> (new QStyle_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QStyle_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStyle::QStyle()\nThis method creates an object of class QStyle.", &_init_ctor_QStyle_Adaptor_0, &_call_ctor_QStyle_Adaptor_0);
}

// int QStyle::layoutSpacingImplementation(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)

static void _init_fp_layoutSpacingImplementation_c11697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("control1");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("control2");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_fp_layoutSpacingImplementation_c11697 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > ();
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QStyleOption *arg4 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg5 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<int > ((int)((QStyle_Adaptor *)cls)->fp_QStyle_layoutSpacingImplementation_c11697 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_layoutSpacingImplementation_c11697 ()
{
  return new qt_gsi::GenericMethod("*layoutSpacingImplementation", "@brief Method int QStyle::layoutSpacingImplementation(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_layoutSpacingImplementation_c11697, &_call_fp_layoutSpacingImplementation_c11697);
}


// int QStyle::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QStyle_Adaptor *)cls)->fp_QStyle_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QStyle::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QStyle::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QStyle_Adaptor *)cls)->fp_QStyle_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QStyle::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QIcon QStyle::standardIconImplementation(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)

static void _init_fp_standardIconImplementation_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardIcon");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QIcon > ();
}

static void _call_fp_standardIconImplementation_c6956 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > ();
  const QStyleOption *arg2 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg3 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<QIcon > ((QIcon)((QStyle_Adaptor *)cls)->fp_QStyle_standardIconImplementation_c6956 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_standardIconImplementation_c6956 ()
{
  return new qt_gsi::GenericMethod("*standardIconImplementation", "@brief Method QIcon QStyle::standardIconImplementation(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_standardIconImplementation_c6956, &_call_fp_standardIconImplementation_c6956);
}


// void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)

static void _init_cbs_drawComplexControl_c9027_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawComplexControl_c9027_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > ();
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ((QStyle_Adaptor *)cls)->cbs_drawComplexControl_c9027_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawComplexControl_c9027_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawComplexControl_c9027_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawComplexControl_c9027_1 ()
{
  return new qt_gsi::GenericMethod ("drawComplexControl", "@hide", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawComplexControl_c9027_1 ()
{
  return new qt_gsi::GenericMethod ("drawComplexControl", "@brief Virtual method void QStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1, &_set_callback_cbs_drawComplexControl_c9027_1);
}


// void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawControl_c8285_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawControl_c8285_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ((QStyle_Adaptor *)cls)->cbs_drawControl_c8285_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawControl_c8285_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawControl_c8285_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawControl_c8285_1 ()
{
  return new qt_gsi::GenericMethod ("drawControl", "@hide", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawControl_c8285_1 ()
{
  return new qt_gsi::GenericMethod ("drawControl", "@brief Virtual method void QStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1, &_set_callback_cbs_drawControl_c8285_1);
}


// void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)

static void _init_cbs_drawItemPixmap_c5678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alignment");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemPixmap_c5678_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  const QPixmap &arg4 = args.read<const QPixmap & > ();
  ((QStyle_Adaptor *)cls)->cbs_drawItemPixmap_c5678_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawItemPixmap_c5678_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawItemPixmap_c5678_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawItemPixmap_c5678_0 ()
{
  return new qt_gsi::GenericMethod ("drawItemPixmap", "@hide", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawItemPixmap_c5678_0 ()
{
  return new qt_gsi::GenericMethod ("drawItemPixmap", "@brief Virtual method void QStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0, &_set_callback_cbs_drawItemPixmap_c5678_0);
}


// void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)

static void _init_cbs_drawItemText_c10604_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pal");
  decl->add_arg<const QPalette & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("enabled");
  decl->add_arg<bool > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("textRole");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemText_c10604_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  const QPalette &arg4 = args.read<const QPalette & > ();
  bool arg5 = args.read<bool > ();
  const QString &arg6 = args.read<const QString & > ();
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg7 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  ((QStyle_Adaptor *)cls)->cbs_drawItemText_c10604_1 (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

static void _set_callback_cbs_drawItemText_c10604_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawItemText_c10604_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawItemText_c10604_1 ()
{
  return new qt_gsi::GenericMethod ("drawItemText", "@hide", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawItemText_c10604_1 ()
{
  return new qt_gsi::GenericMethod ("drawItemText", "@brief Virtual method void QStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1, &_set_callback_cbs_drawItemText_c10604_1);
}


// void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawPrimitive_c8501_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawPrimitive_c8501_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ((QStyle_Adaptor *)cls)->cbs_drawPrimitive_c8501_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawPrimitive_c8501_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_drawPrimitive_c8501_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawPrimitive_c8501_1 ()
{
  return new qt_gsi::GenericMethod ("drawPrimitive", "@hide", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawPrimitive_c8501_1 ()
{
  return new qt_gsi::GenericMethod ("drawPrimitive", "@brief Virtual method void QStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1, &_set_callback_cbs_drawPrimitive_c8501_1);
}


// bool QStyle::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStyle_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QStyle::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QStyle::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStyle_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QStyle::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)

static void _init_cbs_generatedIconPixmap_c5776_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconMode");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_generatedIconPixmap_c5776_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg1 = args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QStyleOption *arg3 = args.read<const QStyleOption * > ();
  ret.write<QPixmap > ((QPixmap)((QStyle_Adaptor *)cls)->cbs_generatedIconPixmap_c5776_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_generatedIconPixmap_c5776_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_generatedIconPixmap_c5776_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_generatedIconPixmap_c5776_0 ()
{
  return new qt_gsi::GenericMethod ("generatedIconPixmap", "@hide", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_generatedIconPixmap_c5776_0 ()
{
  return new qt_gsi::GenericMethod ("generatedIconPixmap", "@brief Virtual method QPixmap QStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0, &_set_callback_cbs_generatedIconPixmap_c5776_0);
}


// QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)

static void _init_cbs_hitTestComplexControl_c9517_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pt");
  decl->add_arg<const QPoint & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<qt_gsi::Converter<QStyle::SubControl>::target_type > ();
}

static void _call_cbs_hitTestComplexControl_c9517_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > ();
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > ();
  const QPoint &arg3 = args.read<const QPoint & > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ret.write<qt_gsi::Converter<QStyle::SubControl>::target_type > ((qt_gsi::Converter<QStyle::SubControl>::target_type)((QStyle_Adaptor *)cls)->cbs_hitTestComplexControl_c9517_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_hitTestComplexControl_c9517_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_hitTestComplexControl_c9517_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hitTestComplexControl_c9517_1 ()
{
  return new qt_gsi::GenericMethod ("hitTestComplexControl", "@hide", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hitTestComplexControl_c9517_1 ()
{
  return new qt_gsi::GenericMethod ("hitTestComplexControl", "@brief Virtual method QStyle::SubControl QStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1, &_set_callback_cbs_hitTestComplexControl_c9517_1);
}


// QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)

static void _init_cbs_itemPixmapRect_c4360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemPixmapRect_c4360_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  int arg2 = args.read<int > ();
  const QPixmap &arg3 = args.read<const QPixmap & > ();
  ret.write<QRect > ((QRect)((QStyle_Adaptor *)cls)->cbs_itemPixmapRect_c4360_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_itemPixmapRect_c4360_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_itemPixmapRect_c4360_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemPixmapRect_c4360_0 ()
{
  return new qt_gsi::GenericMethod ("itemPixmapRect", "@hide", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemPixmapRect_c4360_0 ()
{
  return new qt_gsi::GenericMethod ("itemPixmapRect", "@brief Virtual method QRect QStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0, &_set_callback_cbs_itemPixmapRect_c4360_0);
}


// QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)

static void _init_cbs_itemTextRect_c7544_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fm");
  decl->add_arg<const QFontMetrics & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("r");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("enabled");
  decl->add_arg<bool > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("text");
  decl->add_arg<const QString & > (argspec_4);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemTextRect_c7544_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFontMetrics &arg1 = args.read<const QFontMetrics & > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  bool arg4 = args.read<bool > ();
  const QString &arg5 = args.read<const QString & > ();
  ret.write<QRect > ((QRect)((QStyle_Adaptor *)cls)->cbs_itemTextRect_c7544_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_itemTextRect_c7544_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_itemTextRect_c7544_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemTextRect_c7544_0 ()
{
  return new qt_gsi::GenericMethod ("itemTextRect", "@hide", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemTextRect_c7544_0 ()
{
  return new qt_gsi::GenericMethod ("itemTextRect", "@brief Virtual method QRect QStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0, &_set_callback_cbs_itemTextRect_c7544_0);
}


// int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)

static void _init_cbs_pixelMetric_c6642_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_cbs_pixelMetric_c6642_2 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QWidget *arg3 = args.read<const QWidget * > ();
  ret.write<int > ((int)((QStyle_Adaptor *)cls)->cbs_pixelMetric_c6642_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_pixelMetric_c6642_2 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_pixelMetric_c6642_2 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_pixelMetric_c6642_2 ()
{
  return new qt_gsi::GenericMethod ("pixelMetric", "@hide", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2);
}

static qt_gsi::GenericMethod *_create_callback_cbs_pixelMetric_c6642_2 ()
{
  return new qt_gsi::GenericMethod ("pixelMetric", "@brief Virtual method int QStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2, &_set_callback_cbs_pixelMetric_c6642_2);
}


// void QStyle::polish(QWidget *)

static void _init_cbs_polish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QStyle_Adaptor *)cls)->cbs_polish_1315_0 (arg1);
}

static void _set_callback_cbs_polish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_polish_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_polish_1315_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_polish_1315_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QStyle::polish(QWidget *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0, &_set_callback_cbs_polish_1315_0);
}


// void QStyle::polish(QApplication *)

static void _init_cbs_polish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication *arg1 = args.read<QApplication * > ();
  ((QStyle_Adaptor *)cls)->cbs_polish_1843_0 (arg1);
}

static void _set_callback_cbs_polish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_polish_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_polish_1843_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_polish_1843_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QStyle::polish(QApplication *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0, &_set_callback_cbs_polish_1843_0);
}


// void QStyle::polish(QPalette &)

static void _init_cbs_polish_1418_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1418_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPalette &arg1 = args.read<QPalette & > ();
  ((QStyle_Adaptor *)cls)->cbs_polish_1418_0 (arg1);
}

static void _set_callback_cbs_polish_1418_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_polish_1418_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_polish_1418_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_polish_1418_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QStyle::polish(QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0, &_set_callback_cbs_polish_1418_0);
}


// QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)

static void _init_cbs_sizeFromContents_c8477_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ct");
  decl->add_arg<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("contentsSize");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeFromContents_c8477_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ContentsType>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QSize &arg3 = args.read<const QSize & > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ret.write<QSize > ((QSize)((QStyle_Adaptor *)cls)->cbs_sizeFromContents_c8477_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_sizeFromContents_c8477_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_sizeFromContents_c8477_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeFromContents_c8477_1 ()
{
  return new qt_gsi::GenericMethod ("sizeFromContents", "@hide", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeFromContents_c8477_1 ()
{
  return new qt_gsi::GenericMethod ("sizeFromContents", "@brief Virtual method QSize QStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1, &_set_callback_cbs_sizeFromContents_c8477_1);
}


// QPalette QStyle::standardPalette()

static void _init_cbs_standardPalette_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_cbs_standardPalette_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPalette > ((QPalette)((QStyle_Adaptor *)cls)->cbs_standardPalette_c0_0 ());
}

static void _set_callback_cbs_standardPalette_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_standardPalette_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_standardPalette_c0_0 ()
{
  return new qt_gsi::GenericMethod ("standardPalette", "@hide", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_standardPalette_c0_0 ()
{
  return new qt_gsi::GenericMethod ("standardPalette", "@brief Virtual method QPalette QStyle::standardPalette()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0, &_set_callback_cbs_standardPalette_c0_0);
}


// QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_standardPixmap_c6956_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardPixmap");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_standardPixmap_c6956_2 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QWidget *arg3 = args.read<const QWidget * > ();
  ret.write<QPixmap > ((QPixmap)((QStyle_Adaptor *)cls)->cbs_standardPixmap_c6956_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_standardPixmap_c6956_2 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_standardPixmap_c6956_2 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_standardPixmap_c6956_2 ()
{
  return new qt_gsi::GenericMethod ("standardPixmap", "@hide", true, &_init_cbs_standardPixmap_c6956_2, &_call_cbs_standardPixmap_c6956_2);
}

static qt_gsi::GenericMethod *_create_callback_cbs_standardPixmap_c6956_2 ()
{
  return new qt_gsi::GenericMethod ("standardPixmap", "@brief Virtual method QPixmap QStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPixmap_c6956_2, &_call_cbs_standardPixmap_c6956_2, &_set_callback_cbs_standardPixmap_c6956_2);
}


// int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)

static void _init_cbs_styleHint_c8615_3 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stylehint");
  decl->add_arg<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("returnData");
  decl->add_arg<QStyleHintReturn * > (argspec_3);
  decl->set_return<int > ();
}

static void _call_cbs_styleHint_c8615_3 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::StyleHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QWidget *arg3 = args.read<const QWidget * > ();
  QStyleHintReturn *arg4 = args.read<QStyleHintReturn * > ();
  ret.write<int > ((int)((QStyle_Adaptor *)cls)->cbs_styleHint_c8615_3 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_styleHint_c8615_3 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_styleHint_c8615_3 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleHint_c8615_3 ()
{
  return new qt_gsi::GenericMethod ("styleHint", "@hide", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleHint_c8615_3 ()
{
  return new qt_gsi::GenericMethod ("styleHint", "@brief Virtual method int QStyle::styleHint(QStyle::StyleHint stylehint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3, &_set_callback_cbs_styleHint_c8615_3);
}


// QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)

static void _init_cbs_subControlRect_c9798_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sc");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_cbs_subControlRect_c9798_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > ();
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > ();
  const qt_gsi::Converter<QStyle::SubControl>::target_type & arg3 = args.read<const qt_gsi::Converter<QStyle::SubControl>::target_type & > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ret.write<QRect > ((QRect)((QStyle_Adaptor *)cls)->cbs_subControlRect_c9798_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_subControlRect_c9798_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_subControlRect_c9798_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_subControlRect_c9798_1 ()
{
  return new qt_gsi::GenericMethod ("subControlRect", "@hide", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_subControlRect_c9798_1 ()
{
  return new qt_gsi::GenericMethod ("subControlRect", "@brief Virtual method QRect QStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1, &_set_callback_cbs_subControlRect_c9798_1);
}


// QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)

static void _init_cbs_subElementRect_c6528_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subElement");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_subElementRect_c6528_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::SubElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::SubElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QWidget *arg3 = args.read<const QWidget * > ();
  ret.write<QRect > ((QRect)((QStyle_Adaptor *)cls)->cbs_subElementRect_c6528_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_subElementRect_c6528_1 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_subElementRect_c6528_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_subElementRect_c6528_1 ()
{
  return new qt_gsi::GenericMethod ("subElementRect", "@hide", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_subElementRect_c6528_1 ()
{
  return new qt_gsi::GenericMethod ("subElementRect", "@brief Virtual method QRect QStyle::subElementRect(QStyle::SubElement subElement, const QStyleOption *option, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1, &_set_callback_cbs_subElementRect_c6528_1);
}


// void QStyle::unpolish(QWidget *)

static void _init_cbs_unpolish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QStyle_Adaptor *)cls)->cbs_unpolish_1315_0 (arg1);
}

static void _set_callback_cbs_unpolish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_unpolish_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_unpolish_1315_0 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_unpolish_1315_0 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QStyle::unpolish(QWidget *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0, &_set_callback_cbs_unpolish_1315_0);
}


// void QStyle::unpolish(QApplication *)

static void _init_cbs_unpolish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication *arg1 = args.read<QApplication * > ();
  ((QStyle_Adaptor *)cls)->cbs_unpolish_1843_0 (arg1);
}

static void _set_callback_cbs_unpolish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_unpolish_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_unpolish_1843_0 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_unpolish_1843_0 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QStyle::unpolish(QApplication *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0, &_set_callback_cbs_unpolish_1843_0);
}


// void QStyle::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QStyle_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStyle::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QStyle::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QStyle_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStyle::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QStyle::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QStyle_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStyle::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QStyle::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QStyle_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyle_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStyle::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QStyle> decl_QStyle;

gsi::Class<QStyle_Adaptor> decl_QStyle_Adaptor (decl_QStyle, "QStyle",
  gsi::Methods(_create_fp_layoutSpacingImplementation_c11697 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_standardIconImplementation_c6956 ()) +
  gsi::Methods(_create_cbs_drawComplexControl_c9027_1 ()) +
  gsi::Methods(_create_callback_cbs_drawComplexControl_c9027_1 ()) +
  gsi::Methods(_create_cbs_drawControl_c8285_1 ()) +
  gsi::Methods(_create_callback_cbs_drawControl_c8285_1 ()) +
  gsi::Methods(_create_cbs_drawItemPixmap_c5678_0 ()) +
  gsi::Methods(_create_callback_cbs_drawItemPixmap_c5678_0 ()) +
  gsi::Methods(_create_cbs_drawItemText_c10604_1 ()) +
  gsi::Methods(_create_callback_cbs_drawItemText_c10604_1 ()) +
  gsi::Methods(_create_cbs_drawPrimitive_c8501_1 ()) +
  gsi::Methods(_create_callback_cbs_drawPrimitive_c8501_1 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_generatedIconPixmap_c5776_0 ()) +
  gsi::Methods(_create_callback_cbs_generatedIconPixmap_c5776_0 ()) +
  gsi::Methods(_create_cbs_hitTestComplexControl_c9517_1 ()) +
  gsi::Methods(_create_callback_cbs_hitTestComplexControl_c9517_1 ()) +
  gsi::Methods(_create_cbs_itemPixmapRect_c4360_0 ()) +
  gsi::Methods(_create_callback_cbs_itemPixmapRect_c4360_0 ()) +
  gsi::Methods(_create_cbs_itemTextRect_c7544_0 ()) +
  gsi::Methods(_create_callback_cbs_itemTextRect_c7544_0 ()) +
  gsi::Methods(_create_cbs_pixelMetric_c6642_2 ()) +
  gsi::Methods(_create_callback_cbs_pixelMetric_c6642_2 ()) +
  gsi::Methods(_create_cbs_polish_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_polish_1315_0 ()) +
  gsi::Methods(_create_cbs_polish_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_polish_1843_0 ()) +
  gsi::Methods(_create_cbs_polish_1418_0 ()) +
  gsi::Methods(_create_callback_cbs_polish_1418_0 ()) +
  gsi::Methods(_create_cbs_sizeFromContents_c8477_1 ()) +
  gsi::Methods(_create_callback_cbs_sizeFromContents_c8477_1 ()) +
  gsi::Methods(_create_cbs_standardPalette_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_standardPalette_c0_0 ()) +
  gsi::Methods(_create_cbs_standardPixmap_c6956_2 ()) +
  gsi::Methods(_create_callback_cbs_standardPixmap_c6956_2 ()) +
  gsi::Methods(_create_cbs_styleHint_c8615_3 ()) +
  gsi::Methods(_create_callback_cbs_styleHint_c8615_3 ()) +
  gsi::Methods(_create_cbs_subControlRect_c9798_1 ()) +
  gsi::Methods(_create_callback_cbs_subControlRect_c9798_1 ()) +
  gsi::Methods(_create_cbs_subElementRect_c6528_1 ()) +
  gsi::Methods(_create_callback_cbs_subElementRect_c6528_1 ()) +
  gsi::Methods(_create_cbs_unpolish_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_unpolish_1315_0 ()) +
  gsi::Methods(_create_cbs_unpolish_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_unpolish_1843_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QStyle_Adaptor_0 ()),
  "@qt\n@brief Binding of QStyle");

}


//  Implementation of the enum wrapper class for QStyle::ComplexControl
namespace qt_gsi
{

static QStyle_ComplexControl_Enum *c_1_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_SpinBox); }
static QStyle_ComplexControl_Enum *c_2_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_ComboBox); }
static QStyle_ComplexControl_Enum *c_3_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_ScrollBar); }
static QStyle_ComplexControl_Enum *c_4_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_Slider); }
static QStyle_ComplexControl_Enum *c_5_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_ToolButton); }
static QStyle_ComplexControl_Enum *c_6_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_TitleBar); }
static QStyle_ComplexControl_Enum *c_7_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_Q3ListView); }
static QStyle_ComplexControl_Enum *c_8_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_Dial); }
static QStyle_ComplexControl_Enum *c_9_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_GroupBox); }
static QStyle_ComplexControl_Enum *c_10_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_MdiControls); }
static QStyle_ComplexControl_Enum *c_11_QStyle_ComplexControl_Enum () { return new QStyle_ComplexControl_Enum (QStyle::CC_CustomBase); }

static gsi::Methods mkdefs_QStyle_ComplexControl () {
  return
    gsi::constant ("CC_SpinBox", &qt_gsi::c_1_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_SpinBox") +
    gsi::constant ("CC_ComboBox", &qt_gsi::c_2_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_ComboBox") +
    gsi::constant ("CC_ScrollBar", &qt_gsi::c_3_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_ScrollBar") +
    gsi::constant ("CC_Slider", &qt_gsi::c_4_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_Slider") +
    gsi::constant ("CC_ToolButton", &qt_gsi::c_5_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_ToolButton") +
    gsi::constant ("CC_TitleBar", &qt_gsi::c_6_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_TitleBar") +
    gsi::constant ("CC_Q3ListView", &qt_gsi::c_7_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_Q3ListView") +
    gsi::constant ("CC_Dial", &qt_gsi::c_8_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_Dial") +
    gsi::constant ("CC_GroupBox", &qt_gsi::c_9_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_GroupBox") +
    gsi::constant ("CC_MdiControls", &qt_gsi::c_10_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_MdiControls") +
    gsi::constant ("CC_CustomBase", &qt_gsi::c_11_QStyle_ComplexControl_Enum, "@brief Enum constant QStyle::CC_CustomBase");
}

static std::string to_s_QStyle_ComplexControl_Enum (const QStyle_ComplexControl_Enum *e)
{
  if (e->value () == QStyle::CC_SpinBox) { return tl::sprintf ("CC_SpinBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_ComboBox) { return tl::sprintf ("CC_ComboBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_ScrollBar) { return tl::sprintf ("CC_ScrollBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_Slider) { return tl::sprintf ("CC_Slider (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_ToolButton) { return tl::sprintf ("CC_ToolButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_TitleBar) { return tl::sprintf ("CC_TitleBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_Q3ListView) { return tl::sprintf ("CC_Q3ListView (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_Dial) { return tl::sprintf ("CC_Dial (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_GroupBox) { return tl::sprintf ("CC_GroupBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_MdiControls) { return tl::sprintf ("CC_MdiControls (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CC_CustomBase) { return tl::sprintf ("CC_CustomBase (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStyle_ComplexControl_Enum (const QStyle_ComplexControl_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStyle_ComplexControl_Enum *from_i_QStyle_ComplexControl_Enum (unsigned int i)
{
  return new QStyle_ComplexControl_Enum ((QStyle::ComplexControl) i);
}

static bool equalQStyle_ComplexControl_Enum (const QStyle_ComplexControl_Enum *e, QStyle_ComplexControl_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStyle_ComplexControl_Enum (const QStyle_ComplexControl_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStyle_ComplexControl_Enums oropQStyle_ComplexControl_Enums (const QStyle_ComplexControl_Enums *e, const QStyle_ComplexControl_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStyle_ComplexControl_Enums andopQStyle_ComplexControl_Enums (const QStyle_ComplexControl_Enums *e, const QStyle_ComplexControl_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStyle_ComplexControl_Enums xoropQStyle_ComplexControl_Enums (const QStyle_ComplexControl_Enums *e, const QStyle_ComplexControl_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStyle_ComplexControl_Enums (const QStyle_ComplexControl_Enums *e)
{
  std::string l;
  if (e->testFlag (QStyle::CC_SpinBox)) { if (!l.empty ()) l += "|"; l += "CC_SpinBox"; }
  if (e->testFlag (QStyle::CC_ComboBox)) { if (!l.empty ()) l += "|"; l += "CC_ComboBox"; }
  if (e->testFlag (QStyle::CC_ScrollBar)) { if (!l.empty ()) l += "|"; l += "CC_ScrollBar"; }
  if (e->testFlag (QStyle::CC_Slider)) { if (!l.empty ()) l += "|"; l += "CC_Slider"; }
  if (e->testFlag (QStyle::CC_ToolButton)) { if (!l.empty ()) l += "|"; l += "CC_ToolButton"; }
  if (e->testFlag (QStyle::CC_TitleBar)) { if (!l.empty ()) l += "|"; l += "CC_TitleBar"; }
  if (e->testFlag (QStyle::CC_Q3ListView)) { if (!l.empty ()) l += "|"; l += "CC_Q3ListView"; }
  if (e->testFlag (QStyle::CC_Dial)) { if (!l.empty ()) l += "|"; l += "CC_Dial"; }
  if (e->testFlag (QStyle::CC_GroupBox)) { if (!l.empty ()) l += "|"; l += "CC_GroupBox"; }
  if (e->testFlag (QStyle::CC_MdiControls)) { if (!l.empty ()) l += "|"; l += "CC_MdiControls"; }
  if (e->testFlag (QStyle::CC_CustomBase)) { if (!l.empty ()) l += "|"; l += "CC_CustomBase"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStyle_ComplexControl_Enums (const QStyle_ComplexControl_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStyle_ComplexControl_Enums (const QStyle_ComplexControl_Enums *e, const QStyle_ComplexControl_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStyle_ComplexControl_Enums> decl_QStyle_ComplexControl_Enums ("QStyle_QFlags_ComplexControl",
  gsi::method_ext ("|", &qt_gsi::oropQStyle_ComplexControl_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStyle_ComplexControl_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStyle_ComplexControl_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_ComplexControl_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_ComplexControl_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStyle_ComplexControl_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStyle::ComplexControl> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStyle_ComplexControl_Enum> decl_QStyle_ComplexControl_Enum (decl_QStyle_ComplexControl_Enums, "QStyle_ComplexControl",
  qt_gsi::mkdefs_QStyle_ComplexControl () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_ComplexControl_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_ComplexControl_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStyle_ComplexControl_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStyle_ComplexControl_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStyle_ComplexControl_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStyle::ComplexControl enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_ComplexControl_Enum_in_parent (qt_gsi::mkdefs_QStyle_ComplexControl ());
static gsi::ClassExt<QStyle> decl_QStyle_ComplexControl_Enum_as_child (decl_QStyle_ComplexControl_Enum, "ComplexControl");

}


//  Implementation of the enum wrapper class for QStyle::ContentsType
namespace qt_gsi
{

static QStyle_ContentsType_Enum *c_1_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_PushButton); }
static QStyle_ContentsType_Enum *c_2_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_CheckBox); }
static QStyle_ContentsType_Enum *c_3_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_RadioButton); }
static QStyle_ContentsType_Enum *c_4_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_ToolButton); }
static QStyle_ContentsType_Enum *c_5_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_ComboBox); }
static QStyle_ContentsType_Enum *c_6_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_Splitter); }
static QStyle_ContentsType_Enum *c_7_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_Q3DockWindow); }
static QStyle_ContentsType_Enum *c_8_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_ProgressBar); }
static QStyle_ContentsType_Enum *c_9_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_MenuItem); }
static QStyle_ContentsType_Enum *c_10_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_MenuBarItem); }
static QStyle_ContentsType_Enum *c_11_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_MenuBar); }
static QStyle_ContentsType_Enum *c_12_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_Menu); }
static QStyle_ContentsType_Enum *c_13_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_TabBarTab); }
static QStyle_ContentsType_Enum *c_14_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_Slider); }
static QStyle_ContentsType_Enum *c_15_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_ScrollBar); }
static QStyle_ContentsType_Enum *c_16_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_Q3Header); }
static QStyle_ContentsType_Enum *c_17_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_LineEdit); }
static QStyle_ContentsType_Enum *c_18_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_SpinBox); }
static QStyle_ContentsType_Enum *c_19_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_SizeGrip); }
static QStyle_ContentsType_Enum *c_20_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_TabWidget); }
static QStyle_ContentsType_Enum *c_21_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_DialogButtons); }
static QStyle_ContentsType_Enum *c_22_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_HeaderSection); }
static QStyle_ContentsType_Enum *c_23_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_GroupBox); }
static QStyle_ContentsType_Enum *c_24_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_MdiControls); }
static QStyle_ContentsType_Enum *c_25_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_ItemViewItem); }
static QStyle_ContentsType_Enum *c_26_QStyle_ContentsType_Enum () { return new QStyle_ContentsType_Enum (QStyle::CT_CustomBase); }

static gsi::Methods mkdefs_QStyle_ContentsType () {
  return
    gsi::constant ("CT_PushButton", &qt_gsi::c_1_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_PushButton") +
    gsi::constant ("CT_CheckBox", &qt_gsi::c_2_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_CheckBox") +
    gsi::constant ("CT_RadioButton", &qt_gsi::c_3_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_RadioButton") +
    gsi::constant ("CT_ToolButton", &qt_gsi::c_4_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_ToolButton") +
    gsi::constant ("CT_ComboBox", &qt_gsi::c_5_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_ComboBox") +
    gsi::constant ("CT_Splitter", &qt_gsi::c_6_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_Splitter") +
    gsi::constant ("CT_Q3DockWindow", &qt_gsi::c_7_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_Q3DockWindow") +
    gsi::constant ("CT_ProgressBar", &qt_gsi::c_8_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_ProgressBar") +
    gsi::constant ("CT_MenuItem", &qt_gsi::c_9_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_MenuItem") +
    gsi::constant ("CT_MenuBarItem", &qt_gsi::c_10_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_MenuBarItem") +
    gsi::constant ("CT_MenuBar", &qt_gsi::c_11_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_MenuBar") +
    gsi::constant ("CT_Menu", &qt_gsi::c_12_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_Menu") +
    gsi::constant ("CT_TabBarTab", &qt_gsi::c_13_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_TabBarTab") +
    gsi::constant ("CT_Slider", &qt_gsi::c_14_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_Slider") +
    gsi::constant ("CT_ScrollBar", &qt_gsi::c_15_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_ScrollBar") +
    gsi::constant ("CT_Q3Header", &qt_gsi::c_16_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_Q3Header") +
    gsi::constant ("CT_LineEdit", &qt_gsi::c_17_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_LineEdit") +
    gsi::constant ("CT_SpinBox", &qt_gsi::c_18_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_SpinBox") +
    gsi::constant ("CT_SizeGrip", &qt_gsi::c_19_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_SizeGrip") +
    gsi::constant ("CT_TabWidget", &qt_gsi::c_20_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_TabWidget") +
    gsi::constant ("CT_DialogButtons", &qt_gsi::c_21_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_DialogButtons") +
    gsi::constant ("CT_HeaderSection", &qt_gsi::c_22_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_HeaderSection") +
    gsi::constant ("CT_GroupBox", &qt_gsi::c_23_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_GroupBox") +
    gsi::constant ("CT_MdiControls", &qt_gsi::c_24_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_MdiControls") +
    gsi::constant ("CT_ItemViewItem", &qt_gsi::c_25_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_ItemViewItem") +
    gsi::constant ("CT_CustomBase", &qt_gsi::c_26_QStyle_ContentsType_Enum, "@brief Enum constant QStyle::CT_CustomBase");
}

static std::string to_s_QStyle_ContentsType_Enum (const QStyle_ContentsType_Enum *e)
{
  if (e->value () == QStyle::CT_PushButton) { return tl::sprintf ("CT_PushButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_CheckBox) { return tl::sprintf ("CT_CheckBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_RadioButton) { return tl::sprintf ("CT_RadioButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_ToolButton) { return tl::sprintf ("CT_ToolButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_ComboBox) { return tl::sprintf ("CT_ComboBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_Splitter) { return tl::sprintf ("CT_Splitter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_Q3DockWindow) { return tl::sprintf ("CT_Q3DockWindow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_ProgressBar) { return tl::sprintf ("CT_ProgressBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_MenuItem) { return tl::sprintf ("CT_MenuItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_MenuBarItem) { return tl::sprintf ("CT_MenuBarItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_MenuBar) { return tl::sprintf ("CT_MenuBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_Menu) { return tl::sprintf ("CT_Menu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_TabBarTab) { return tl::sprintf ("CT_TabBarTab (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_Slider) { return tl::sprintf ("CT_Slider (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_ScrollBar) { return tl::sprintf ("CT_ScrollBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_Q3Header) { return tl::sprintf ("CT_Q3Header (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_LineEdit) { return tl::sprintf ("CT_LineEdit (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_SpinBox) { return tl::sprintf ("CT_SpinBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_SizeGrip) { return tl::sprintf ("CT_SizeGrip (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_TabWidget) { return tl::sprintf ("CT_TabWidget (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_DialogButtons) { return tl::sprintf ("CT_DialogButtons (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_HeaderSection) { return tl::sprintf ("CT_HeaderSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_GroupBox) { return tl::sprintf ("CT_GroupBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_MdiControls) { return tl::sprintf ("CT_MdiControls (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_ItemViewItem) { return tl::sprintf ("CT_ItemViewItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CT_CustomBase) { return tl::sprintf ("CT_CustomBase (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStyle_ContentsType_Enum (const QStyle_ContentsType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStyle_ContentsType_Enum *from_i_QStyle_ContentsType_Enum (unsigned int i)
{
  return new QStyle_ContentsType_Enum ((QStyle::ContentsType) i);
}

static bool equalQStyle_ContentsType_Enum (const QStyle_ContentsType_Enum *e, QStyle_ContentsType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStyle_ContentsType_Enum (const QStyle_ContentsType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStyle_ContentsType_Enums oropQStyle_ContentsType_Enums (const QStyle_ContentsType_Enums *e, const QStyle_ContentsType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStyle_ContentsType_Enums andopQStyle_ContentsType_Enums (const QStyle_ContentsType_Enums *e, const QStyle_ContentsType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStyle_ContentsType_Enums xoropQStyle_ContentsType_Enums (const QStyle_ContentsType_Enums *e, const QStyle_ContentsType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStyle_ContentsType_Enums (const QStyle_ContentsType_Enums *e)
{
  std::string l;
  if (e->testFlag (QStyle::CT_PushButton)) { if (!l.empty ()) l += "|"; l += "CT_PushButton"; }
  if (e->testFlag (QStyle::CT_CheckBox)) { if (!l.empty ()) l += "|"; l += "CT_CheckBox"; }
  if (e->testFlag (QStyle::CT_RadioButton)) { if (!l.empty ()) l += "|"; l += "CT_RadioButton"; }
  if (e->testFlag (QStyle::CT_ToolButton)) { if (!l.empty ()) l += "|"; l += "CT_ToolButton"; }
  if (e->testFlag (QStyle::CT_ComboBox)) { if (!l.empty ()) l += "|"; l += "CT_ComboBox"; }
  if (e->testFlag (QStyle::CT_Splitter)) { if (!l.empty ()) l += "|"; l += "CT_Splitter"; }
  if (e->testFlag (QStyle::CT_Q3DockWindow)) { if (!l.empty ()) l += "|"; l += "CT_Q3DockWindow"; }
  if (e->testFlag (QStyle::CT_ProgressBar)) { if (!l.empty ()) l += "|"; l += "CT_ProgressBar"; }
  if (e->testFlag (QStyle::CT_MenuItem)) { if (!l.empty ()) l += "|"; l += "CT_MenuItem"; }
  if (e->testFlag (QStyle::CT_MenuBarItem)) { if (!l.empty ()) l += "|"; l += "CT_MenuBarItem"; }
  if (e->testFlag (QStyle::CT_MenuBar)) { if (!l.empty ()) l += "|"; l += "CT_MenuBar"; }
  if (e->testFlag (QStyle::CT_Menu)) { if (!l.empty ()) l += "|"; l += "CT_Menu"; }
  if (e->testFlag (QStyle::CT_TabBarTab)) { if (!l.empty ()) l += "|"; l += "CT_TabBarTab"; }
  if (e->testFlag (QStyle::CT_Slider)) { if (!l.empty ()) l += "|"; l += "CT_Slider"; }
  if (e->testFlag (QStyle::CT_ScrollBar)) { if (!l.empty ()) l += "|"; l += "CT_ScrollBar"; }
  if (e->testFlag (QStyle::CT_Q3Header)) { if (!l.empty ()) l += "|"; l += "CT_Q3Header"; }
  if (e->testFlag (QStyle::CT_LineEdit)) { if (!l.empty ()) l += "|"; l += "CT_LineEdit"; }
  if (e->testFlag (QStyle::CT_SpinBox)) { if (!l.empty ()) l += "|"; l += "CT_SpinBox"; }
  if (e->testFlag (QStyle::CT_SizeGrip)) { if (!l.empty ()) l += "|"; l += "CT_SizeGrip"; }
  if (e->testFlag (QStyle::CT_TabWidget)) { if (!l.empty ()) l += "|"; l += "CT_TabWidget"; }
  if (e->testFlag (QStyle::CT_DialogButtons)) { if (!l.empty ()) l += "|"; l += "CT_DialogButtons"; }
  if (e->testFlag (QStyle::CT_HeaderSection)) { if (!l.empty ()) l += "|"; l += "CT_HeaderSection"; }
  if (e->testFlag (QStyle::CT_GroupBox)) { if (!l.empty ()) l += "|"; l += "CT_GroupBox"; }
  if (e->testFlag (QStyle::CT_MdiControls)) { if (!l.empty ()) l += "|"; l += "CT_MdiControls"; }
  if (e->testFlag (QStyle::CT_ItemViewItem)) { if (!l.empty ()) l += "|"; l += "CT_ItemViewItem"; }
  if (e->testFlag (QStyle::CT_CustomBase)) { if (!l.empty ()) l += "|"; l += "CT_CustomBase"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStyle_ContentsType_Enums (const QStyle_ContentsType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStyle_ContentsType_Enums (const QStyle_ContentsType_Enums *e, const QStyle_ContentsType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStyle_ContentsType_Enums> decl_QStyle_ContentsType_Enums ("QStyle_QFlags_ContentsType",
  gsi::method_ext ("|", &qt_gsi::oropQStyle_ContentsType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStyle_ContentsType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStyle_ContentsType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_ContentsType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_ContentsType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStyle_ContentsType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStyle::ContentsType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStyle_ContentsType_Enum> decl_QStyle_ContentsType_Enum (decl_QStyle_ContentsType_Enums, "QStyle_ContentsType",
  qt_gsi::mkdefs_QStyle_ContentsType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_ContentsType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_ContentsType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStyle_ContentsType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStyle_ContentsType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStyle_ContentsType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStyle::ContentsType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_ContentsType_Enum_in_parent (qt_gsi::mkdefs_QStyle_ContentsType ());
static gsi::ClassExt<QStyle> decl_QStyle_ContentsType_Enum_as_child (decl_QStyle_ContentsType_Enum, "ContentsType");

}


//  Implementation of the enum wrapper class for QStyle::ControlElement
namespace qt_gsi
{

static QStyle_ControlElement_Enum *c_1_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_PushButton); }
static QStyle_ControlElement_Enum *c_2_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_PushButtonBevel); }
static QStyle_ControlElement_Enum *c_3_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_PushButtonLabel); }
static QStyle_ControlElement_Enum *c_4_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_CheckBox); }
static QStyle_ControlElement_Enum *c_5_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_CheckBoxLabel); }
static QStyle_ControlElement_Enum *c_6_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_RadioButton); }
static QStyle_ControlElement_Enum *c_7_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_RadioButtonLabel); }
static QStyle_ControlElement_Enum *c_8_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_TabBarTab); }
static QStyle_ControlElement_Enum *c_9_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_TabBarTabShape); }
static QStyle_ControlElement_Enum *c_10_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_TabBarTabLabel); }
static QStyle_ControlElement_Enum *c_11_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ProgressBar); }
static QStyle_ControlElement_Enum *c_12_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ProgressBarGroove); }
static QStyle_ControlElement_Enum *c_13_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ProgressBarContents); }
static QStyle_ControlElement_Enum *c_14_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ProgressBarLabel); }
static QStyle_ControlElement_Enum *c_15_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_MenuItem); }
static QStyle_ControlElement_Enum *c_16_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_MenuScroller); }
static QStyle_ControlElement_Enum *c_17_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_MenuVMargin); }
static QStyle_ControlElement_Enum *c_18_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_MenuHMargin); }
static QStyle_ControlElement_Enum *c_19_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_MenuTearoff); }
static QStyle_ControlElement_Enum *c_20_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_MenuEmptyArea); }
static QStyle_ControlElement_Enum *c_21_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_MenuBarItem); }
static QStyle_ControlElement_Enum *c_22_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_MenuBarEmptyArea); }
static QStyle_ControlElement_Enum *c_23_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ToolButtonLabel); }
static QStyle_ControlElement_Enum *c_24_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_Header); }
static QStyle_ControlElement_Enum *c_25_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_HeaderSection); }
static QStyle_ControlElement_Enum *c_26_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_HeaderLabel); }
static QStyle_ControlElement_Enum *c_27_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_Q3DockWindowEmptyArea); }
static QStyle_ControlElement_Enum *c_28_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ToolBoxTab); }
static QStyle_ControlElement_Enum *c_29_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_SizeGrip); }
static QStyle_ControlElement_Enum *c_30_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_Splitter); }
static QStyle_ControlElement_Enum *c_31_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_RubberBand); }
static QStyle_ControlElement_Enum *c_32_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_DockWidgetTitle); }
static QStyle_ControlElement_Enum *c_33_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ScrollBarAddLine); }
static QStyle_ControlElement_Enum *c_34_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ScrollBarSubLine); }
static QStyle_ControlElement_Enum *c_35_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ScrollBarAddPage); }
static QStyle_ControlElement_Enum *c_36_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ScrollBarSubPage); }
static QStyle_ControlElement_Enum *c_37_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ScrollBarSlider); }
static QStyle_ControlElement_Enum *c_38_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ScrollBarFirst); }
static QStyle_ControlElement_Enum *c_39_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ScrollBarLast); }
static QStyle_ControlElement_Enum *c_40_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_FocusFrame); }
static QStyle_ControlElement_Enum *c_41_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ComboBoxLabel); }
static QStyle_ControlElement_Enum *c_42_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ToolBar); }
static QStyle_ControlElement_Enum *c_43_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ToolBoxTabShape); }
static QStyle_ControlElement_Enum *c_44_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ToolBoxTabLabel); }
static QStyle_ControlElement_Enum *c_45_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_HeaderEmptyArea); }
static QStyle_ControlElement_Enum *c_46_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ColumnViewGrip); }
static QStyle_ControlElement_Enum *c_47_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ItemViewItem); }
static QStyle_ControlElement_Enum *c_48_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_ShapedFrame); }
static QStyle_ControlElement_Enum *c_49_QStyle_ControlElement_Enum () { return new QStyle_ControlElement_Enum (QStyle::CE_CustomBase); }

static gsi::Methods mkdefs_QStyle_ControlElement () {
  return
    gsi::constant ("CE_PushButton", &qt_gsi::c_1_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_PushButton") +
    gsi::constant ("CE_PushButtonBevel", &qt_gsi::c_2_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_PushButtonBevel") +
    gsi::constant ("CE_PushButtonLabel", &qt_gsi::c_3_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_PushButtonLabel") +
    gsi::constant ("CE_CheckBox", &qt_gsi::c_4_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_CheckBox") +
    gsi::constant ("CE_CheckBoxLabel", &qt_gsi::c_5_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_CheckBoxLabel") +
    gsi::constant ("CE_RadioButton", &qt_gsi::c_6_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_RadioButton") +
    gsi::constant ("CE_RadioButtonLabel", &qt_gsi::c_7_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_RadioButtonLabel") +
    gsi::constant ("CE_TabBarTab", &qt_gsi::c_8_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_TabBarTab") +
    gsi::constant ("CE_TabBarTabShape", &qt_gsi::c_9_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_TabBarTabShape") +
    gsi::constant ("CE_TabBarTabLabel", &qt_gsi::c_10_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_TabBarTabLabel") +
    gsi::constant ("CE_ProgressBar", &qt_gsi::c_11_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ProgressBar") +
    gsi::constant ("CE_ProgressBarGroove", &qt_gsi::c_12_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ProgressBarGroove") +
    gsi::constant ("CE_ProgressBarContents", &qt_gsi::c_13_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ProgressBarContents") +
    gsi::constant ("CE_ProgressBarLabel", &qt_gsi::c_14_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ProgressBarLabel") +
    gsi::constant ("CE_MenuItem", &qt_gsi::c_15_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_MenuItem") +
    gsi::constant ("CE_MenuScroller", &qt_gsi::c_16_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_MenuScroller") +
    gsi::constant ("CE_MenuVMargin", &qt_gsi::c_17_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_MenuVMargin") +
    gsi::constant ("CE_MenuHMargin", &qt_gsi::c_18_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_MenuHMargin") +
    gsi::constant ("CE_MenuTearoff", &qt_gsi::c_19_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_MenuTearoff") +
    gsi::constant ("CE_MenuEmptyArea", &qt_gsi::c_20_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_MenuEmptyArea") +
    gsi::constant ("CE_MenuBarItem", &qt_gsi::c_21_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_MenuBarItem") +
    gsi::constant ("CE_MenuBarEmptyArea", &qt_gsi::c_22_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_MenuBarEmptyArea") +
    gsi::constant ("CE_ToolButtonLabel", &qt_gsi::c_23_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ToolButtonLabel") +
    gsi::constant ("CE_Header", &qt_gsi::c_24_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_Header") +
    gsi::constant ("CE_HeaderSection", &qt_gsi::c_25_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_HeaderSection") +
    gsi::constant ("CE_HeaderLabel", &qt_gsi::c_26_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_HeaderLabel") +
    gsi::constant ("CE_Q3DockWindowEmptyArea", &qt_gsi::c_27_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_Q3DockWindowEmptyArea") +
    gsi::constant ("CE_ToolBoxTab", &qt_gsi::c_28_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ToolBoxTab") +
    gsi::constant ("CE_SizeGrip", &qt_gsi::c_29_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_SizeGrip") +
    gsi::constant ("CE_Splitter", &qt_gsi::c_30_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_Splitter") +
    gsi::constant ("CE_RubberBand", &qt_gsi::c_31_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_RubberBand") +
    gsi::constant ("CE_DockWidgetTitle", &qt_gsi::c_32_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_DockWidgetTitle") +
    gsi::constant ("CE_ScrollBarAddLine", &qt_gsi::c_33_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ScrollBarAddLine") +
    gsi::constant ("CE_ScrollBarSubLine", &qt_gsi::c_34_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ScrollBarSubLine") +
    gsi::constant ("CE_ScrollBarAddPage", &qt_gsi::c_35_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ScrollBarAddPage") +
    gsi::constant ("CE_ScrollBarSubPage", &qt_gsi::c_36_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ScrollBarSubPage") +
    gsi::constant ("CE_ScrollBarSlider", &qt_gsi::c_37_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ScrollBarSlider") +
    gsi::constant ("CE_ScrollBarFirst", &qt_gsi::c_38_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ScrollBarFirst") +
    gsi::constant ("CE_ScrollBarLast", &qt_gsi::c_39_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ScrollBarLast") +
    gsi::constant ("CE_FocusFrame", &qt_gsi::c_40_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_FocusFrame") +
    gsi::constant ("CE_ComboBoxLabel", &qt_gsi::c_41_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ComboBoxLabel") +
    gsi::constant ("CE_ToolBar", &qt_gsi::c_42_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ToolBar") +
    gsi::constant ("CE_ToolBoxTabShape", &qt_gsi::c_43_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ToolBoxTabShape") +
    gsi::constant ("CE_ToolBoxTabLabel", &qt_gsi::c_44_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ToolBoxTabLabel") +
    gsi::constant ("CE_HeaderEmptyArea", &qt_gsi::c_45_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_HeaderEmptyArea") +
    gsi::constant ("CE_ColumnViewGrip", &qt_gsi::c_46_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ColumnViewGrip") +
    gsi::constant ("CE_ItemViewItem", &qt_gsi::c_47_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ItemViewItem") +
    gsi::constant ("CE_ShapedFrame", &qt_gsi::c_48_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_ShapedFrame") +
    gsi::constant ("CE_CustomBase", &qt_gsi::c_49_QStyle_ControlElement_Enum, "@brief Enum constant QStyle::CE_CustomBase");
}

static std::string to_s_QStyle_ControlElement_Enum (const QStyle_ControlElement_Enum *e)
{
  if (e->value () == QStyle::CE_PushButton) { return tl::sprintf ("CE_PushButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_PushButtonBevel) { return tl::sprintf ("CE_PushButtonBevel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_PushButtonLabel) { return tl::sprintf ("CE_PushButtonLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_CheckBox) { return tl::sprintf ("CE_CheckBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_CheckBoxLabel) { return tl::sprintf ("CE_CheckBoxLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_RadioButton) { return tl::sprintf ("CE_RadioButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_RadioButtonLabel) { return tl::sprintf ("CE_RadioButtonLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_TabBarTab) { return tl::sprintf ("CE_TabBarTab (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_TabBarTabShape) { return tl::sprintf ("CE_TabBarTabShape (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_TabBarTabLabel) { return tl::sprintf ("CE_TabBarTabLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ProgressBar) { return tl::sprintf ("CE_ProgressBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ProgressBarGroove) { return tl::sprintf ("CE_ProgressBarGroove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ProgressBarContents) { return tl::sprintf ("CE_ProgressBarContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ProgressBarLabel) { return tl::sprintf ("CE_ProgressBarLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_MenuItem) { return tl::sprintf ("CE_MenuItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_MenuScroller) { return tl::sprintf ("CE_MenuScroller (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_MenuVMargin) { return tl::sprintf ("CE_MenuVMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_MenuHMargin) { return tl::sprintf ("CE_MenuHMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_MenuTearoff) { return tl::sprintf ("CE_MenuTearoff (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_MenuEmptyArea) { return tl::sprintf ("CE_MenuEmptyArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_MenuBarItem) { return tl::sprintf ("CE_MenuBarItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_MenuBarEmptyArea) { return tl::sprintf ("CE_MenuBarEmptyArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ToolButtonLabel) { return tl::sprintf ("CE_ToolButtonLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_Header) { return tl::sprintf ("CE_Header (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_HeaderSection) { return tl::sprintf ("CE_HeaderSection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_HeaderLabel) { return tl::sprintf ("CE_HeaderLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_Q3DockWindowEmptyArea) { return tl::sprintf ("CE_Q3DockWindowEmptyArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ToolBoxTab) { return tl::sprintf ("CE_ToolBoxTab (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_SizeGrip) { return tl::sprintf ("CE_SizeGrip (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_Splitter) { return tl::sprintf ("CE_Splitter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_RubberBand) { return tl::sprintf ("CE_RubberBand (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_DockWidgetTitle) { return tl::sprintf ("CE_DockWidgetTitle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ScrollBarAddLine) { return tl::sprintf ("CE_ScrollBarAddLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ScrollBarSubLine) { return tl::sprintf ("CE_ScrollBarSubLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ScrollBarAddPage) { return tl::sprintf ("CE_ScrollBarAddPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ScrollBarSubPage) { return tl::sprintf ("CE_ScrollBarSubPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ScrollBarSlider) { return tl::sprintf ("CE_ScrollBarSlider (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ScrollBarFirst) { return tl::sprintf ("CE_ScrollBarFirst (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ScrollBarLast) { return tl::sprintf ("CE_ScrollBarLast (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_FocusFrame) { return tl::sprintf ("CE_FocusFrame (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ComboBoxLabel) { return tl::sprintf ("CE_ComboBoxLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ToolBar) { return tl::sprintf ("CE_ToolBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ToolBoxTabShape) { return tl::sprintf ("CE_ToolBoxTabShape (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ToolBoxTabLabel) { return tl::sprintf ("CE_ToolBoxTabLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_HeaderEmptyArea) { return tl::sprintf ("CE_HeaderEmptyArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ColumnViewGrip) { return tl::sprintf ("CE_ColumnViewGrip (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ItemViewItem) { return tl::sprintf ("CE_ItemViewItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_ShapedFrame) { return tl::sprintf ("CE_ShapedFrame (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::CE_CustomBase) { return tl::sprintf ("CE_CustomBase (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStyle_ControlElement_Enum (const QStyle_ControlElement_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStyle_ControlElement_Enum *from_i_QStyle_ControlElement_Enum (unsigned int i)
{
  return new QStyle_ControlElement_Enum ((QStyle::ControlElement) i);
}

static bool equalQStyle_ControlElement_Enum (const QStyle_ControlElement_Enum *e, QStyle_ControlElement_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStyle_ControlElement_Enum (const QStyle_ControlElement_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStyle_ControlElement_Enums oropQStyle_ControlElement_Enums (const QStyle_ControlElement_Enums *e, const QStyle_ControlElement_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStyle_ControlElement_Enums andopQStyle_ControlElement_Enums (const QStyle_ControlElement_Enums *e, const QStyle_ControlElement_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStyle_ControlElement_Enums xoropQStyle_ControlElement_Enums (const QStyle_ControlElement_Enums *e, const QStyle_ControlElement_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStyle_ControlElement_Enums (const QStyle_ControlElement_Enums *e)
{
  std::string l;
  if (e->testFlag (QStyle::CE_PushButton)) { if (!l.empty ()) l += "|"; l += "CE_PushButton"; }
  if (e->testFlag (QStyle::CE_PushButtonBevel)) { if (!l.empty ()) l += "|"; l += "CE_PushButtonBevel"; }
  if (e->testFlag (QStyle::CE_PushButtonLabel)) { if (!l.empty ()) l += "|"; l += "CE_PushButtonLabel"; }
  if (e->testFlag (QStyle::CE_CheckBox)) { if (!l.empty ()) l += "|"; l += "CE_CheckBox"; }
  if (e->testFlag (QStyle::CE_CheckBoxLabel)) { if (!l.empty ()) l += "|"; l += "CE_CheckBoxLabel"; }
  if (e->testFlag (QStyle::CE_RadioButton)) { if (!l.empty ()) l += "|"; l += "CE_RadioButton"; }
  if (e->testFlag (QStyle::CE_RadioButtonLabel)) { if (!l.empty ()) l += "|"; l += "CE_RadioButtonLabel"; }
  if (e->testFlag (QStyle::CE_TabBarTab)) { if (!l.empty ()) l += "|"; l += "CE_TabBarTab"; }
  if (e->testFlag (QStyle::CE_TabBarTabShape)) { if (!l.empty ()) l += "|"; l += "CE_TabBarTabShape"; }
  if (e->testFlag (QStyle::CE_TabBarTabLabel)) { if (!l.empty ()) l += "|"; l += "CE_TabBarTabLabel"; }
  if (e->testFlag (QStyle::CE_ProgressBar)) { if (!l.empty ()) l += "|"; l += "CE_ProgressBar"; }
  if (e->testFlag (QStyle::CE_ProgressBarGroove)) { if (!l.empty ()) l += "|"; l += "CE_ProgressBarGroove"; }
  if (e->testFlag (QStyle::CE_ProgressBarContents)) { if (!l.empty ()) l += "|"; l += "CE_ProgressBarContents"; }
  if (e->testFlag (QStyle::CE_ProgressBarLabel)) { if (!l.empty ()) l += "|"; l += "CE_ProgressBarLabel"; }
  if (e->testFlag (QStyle::CE_MenuItem)) { if (!l.empty ()) l += "|"; l += "CE_MenuItem"; }
  if (e->testFlag (QStyle::CE_MenuScroller)) { if (!l.empty ()) l += "|"; l += "CE_MenuScroller"; }
  if (e->testFlag (QStyle::CE_MenuVMargin)) { if (!l.empty ()) l += "|"; l += "CE_MenuVMargin"; }
  if (e->testFlag (QStyle::CE_MenuHMargin)) { if (!l.empty ()) l += "|"; l += "CE_MenuHMargin"; }
  if (e->testFlag (QStyle::CE_MenuTearoff)) { if (!l.empty ()) l += "|"; l += "CE_MenuTearoff"; }
  if (e->testFlag (QStyle::CE_MenuEmptyArea)) { if (!l.empty ()) l += "|"; l += "CE_MenuEmptyArea"; }
  if (e->testFlag (QStyle::CE_MenuBarItem)) { if (!l.empty ()) l += "|"; l += "CE_MenuBarItem"; }
  if (e->testFlag (QStyle::CE_MenuBarEmptyArea)) { if (!l.empty ()) l += "|"; l += "CE_MenuBarEmptyArea"; }
  if (e->testFlag (QStyle::CE_ToolButtonLabel)) { if (!l.empty ()) l += "|"; l += "CE_ToolButtonLabel"; }
  if (e->testFlag (QStyle::CE_Header)) { if (!l.empty ()) l += "|"; l += "CE_Header"; }
  if (e->testFlag (QStyle::CE_HeaderSection)) { if (!l.empty ()) l += "|"; l += "CE_HeaderSection"; }
  if (e->testFlag (QStyle::CE_HeaderLabel)) { if (!l.empty ()) l += "|"; l += "CE_HeaderLabel"; }
  if (e->testFlag (QStyle::CE_Q3DockWindowEmptyArea)) { if (!l.empty ()) l += "|"; l += "CE_Q3DockWindowEmptyArea"; }
  if (e->testFlag (QStyle::CE_ToolBoxTab)) { if (!l.empty ()) l += "|"; l += "CE_ToolBoxTab"; }
  if (e->testFlag (QStyle::CE_SizeGrip)) { if (!l.empty ()) l += "|"; l += "CE_SizeGrip"; }
  if (e->testFlag (QStyle::CE_Splitter)) { if (!l.empty ()) l += "|"; l += "CE_Splitter"; }
  if (e->testFlag (QStyle::CE_RubberBand)) { if (!l.empty ()) l += "|"; l += "CE_RubberBand"; }
  if (e->testFlag (QStyle::CE_DockWidgetTitle)) { if (!l.empty ()) l += "|"; l += "CE_DockWidgetTitle"; }
  if (e->testFlag (QStyle::CE_ScrollBarAddLine)) { if (!l.empty ()) l += "|"; l += "CE_ScrollBarAddLine"; }
  if (e->testFlag (QStyle::CE_ScrollBarSubLine)) { if (!l.empty ()) l += "|"; l += "CE_ScrollBarSubLine"; }
  if (e->testFlag (QStyle::CE_ScrollBarAddPage)) { if (!l.empty ()) l += "|"; l += "CE_ScrollBarAddPage"; }
  if (e->testFlag (QStyle::CE_ScrollBarSubPage)) { if (!l.empty ()) l += "|"; l += "CE_ScrollBarSubPage"; }
  if (e->testFlag (QStyle::CE_ScrollBarSlider)) { if (!l.empty ()) l += "|"; l += "CE_ScrollBarSlider"; }
  if (e->testFlag (QStyle::CE_ScrollBarFirst)) { if (!l.empty ()) l += "|"; l += "CE_ScrollBarFirst"; }
  if (e->testFlag (QStyle::CE_ScrollBarLast)) { if (!l.empty ()) l += "|"; l += "CE_ScrollBarLast"; }
  if (e->testFlag (QStyle::CE_FocusFrame)) { if (!l.empty ()) l += "|"; l += "CE_FocusFrame"; }
  if (e->testFlag (QStyle::CE_ComboBoxLabel)) { if (!l.empty ()) l += "|"; l += "CE_ComboBoxLabel"; }
  if (e->testFlag (QStyle::CE_ToolBar)) { if (!l.empty ()) l += "|"; l += "CE_ToolBar"; }
  if (e->testFlag (QStyle::CE_ToolBoxTabShape)) { if (!l.empty ()) l += "|"; l += "CE_ToolBoxTabShape"; }
  if (e->testFlag (QStyle::CE_ToolBoxTabLabel)) { if (!l.empty ()) l += "|"; l += "CE_ToolBoxTabLabel"; }
  if (e->testFlag (QStyle::CE_HeaderEmptyArea)) { if (!l.empty ()) l += "|"; l += "CE_HeaderEmptyArea"; }
  if (e->testFlag (QStyle::CE_ColumnViewGrip)) { if (!l.empty ()) l += "|"; l += "CE_ColumnViewGrip"; }
  if (e->testFlag (QStyle::CE_ItemViewItem)) { if (!l.empty ()) l += "|"; l += "CE_ItemViewItem"; }
  if (e->testFlag (QStyle::CE_ShapedFrame)) { if (!l.empty ()) l += "|"; l += "CE_ShapedFrame"; }
  if (e->testFlag (QStyle::CE_CustomBase)) { if (!l.empty ()) l += "|"; l += "CE_CustomBase"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStyle_ControlElement_Enums (const QStyle_ControlElement_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStyle_ControlElement_Enums (const QStyle_ControlElement_Enums *e, const QStyle_ControlElement_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStyle_ControlElement_Enums> decl_QStyle_ControlElement_Enums ("QStyle_QFlags_ControlElement",
  gsi::method_ext ("|", &qt_gsi::oropQStyle_ControlElement_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStyle_ControlElement_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStyle_ControlElement_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_ControlElement_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_ControlElement_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStyle_ControlElement_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStyle::ControlElement> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStyle_ControlElement_Enum> decl_QStyle_ControlElement_Enum (decl_QStyle_ControlElement_Enums, "QStyle_ControlElement",
  qt_gsi::mkdefs_QStyle_ControlElement () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_ControlElement_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_ControlElement_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStyle_ControlElement_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStyle_ControlElement_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStyle_ControlElement_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStyle::ControlElement enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_ControlElement_Enum_in_parent (qt_gsi::mkdefs_QStyle_ControlElement ());
static gsi::ClassExt<QStyle> decl_QStyle_ControlElement_Enum_as_child (decl_QStyle_ControlElement_Enum, "ControlElement");

}


//  Implementation of the enum wrapper class for QStyle::PixelMetric
namespace qt_gsi
{

static QStyle_PixelMetric_Enum *c_1_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ButtonMargin); }
static QStyle_PixelMetric_Enum *c_2_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ButtonDefaultIndicator); }
static QStyle_PixelMetric_Enum *c_3_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuButtonIndicator); }
static QStyle_PixelMetric_Enum *c_4_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ButtonShiftHorizontal); }
static QStyle_PixelMetric_Enum *c_5_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ButtonShiftVertical); }
static QStyle_PixelMetric_Enum *c_6_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DefaultFrameWidth); }
static QStyle_PixelMetric_Enum *c_7_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SpinBoxFrameWidth); }
static QStyle_PixelMetric_Enum *c_8_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ComboBoxFrameWidth); }
static QStyle_PixelMetric_Enum *c_9_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MaximumDragDistance); }
static QStyle_PixelMetric_Enum *c_10_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ScrollBarExtent); }
static QStyle_PixelMetric_Enum *c_11_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ScrollBarSliderMin); }
static QStyle_PixelMetric_Enum *c_12_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SliderThickness); }
static QStyle_PixelMetric_Enum *c_13_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SliderControlThickness); }
static QStyle_PixelMetric_Enum *c_14_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SliderLength); }
static QStyle_PixelMetric_Enum *c_15_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SliderTickmarkOffset); }
static QStyle_PixelMetric_Enum *c_16_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SliderSpaceAvailable); }
static QStyle_PixelMetric_Enum *c_17_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DockWidgetSeparatorExtent); }
static QStyle_PixelMetric_Enum *c_18_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DockWidgetHandleExtent); }
static QStyle_PixelMetric_Enum *c_19_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DockWidgetFrameWidth); }
static QStyle_PixelMetric_Enum *c_20_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBarTabOverlap); }
static QStyle_PixelMetric_Enum *c_21_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBarTabHSpace); }
static QStyle_PixelMetric_Enum *c_22_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBarTabVSpace); }
static QStyle_PixelMetric_Enum *c_23_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBarBaseHeight); }
static QStyle_PixelMetric_Enum *c_24_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBarBaseOverlap); }
static QStyle_PixelMetric_Enum *c_25_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ProgressBarChunkWidth); }
static QStyle_PixelMetric_Enum *c_26_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SplitterWidth); }
static QStyle_PixelMetric_Enum *c_27_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TitleBarHeight); }
static QStyle_PixelMetric_Enum *c_28_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuScrollerHeight); }
static QStyle_PixelMetric_Enum *c_29_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuHMargin); }
static QStyle_PixelMetric_Enum *c_30_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuVMargin); }
static QStyle_PixelMetric_Enum *c_31_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuPanelWidth); }
static QStyle_PixelMetric_Enum *c_32_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuTearoffHeight); }
static QStyle_PixelMetric_Enum *c_33_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuDesktopFrameWidth); }
static QStyle_PixelMetric_Enum *c_34_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuBarPanelWidth); }
static QStyle_PixelMetric_Enum *c_35_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuBarItemSpacing); }
static QStyle_PixelMetric_Enum *c_36_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuBarVMargin); }
static QStyle_PixelMetric_Enum *c_37_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MenuBarHMargin); }
static QStyle_PixelMetric_Enum *c_38_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_IndicatorWidth); }
static QStyle_PixelMetric_Enum *c_39_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_IndicatorHeight); }
static QStyle_PixelMetric_Enum *c_40_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ExclusiveIndicatorWidth); }
static QStyle_PixelMetric_Enum *c_41_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ExclusiveIndicatorHeight); }
static QStyle_PixelMetric_Enum *c_42_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_CheckListButtonSize); }
static QStyle_PixelMetric_Enum *c_43_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_CheckListControllerSize); }
static QStyle_PixelMetric_Enum *c_44_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DialogButtonsSeparator); }
static QStyle_PixelMetric_Enum *c_45_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DialogButtonsButtonWidth); }
static QStyle_PixelMetric_Enum *c_46_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DialogButtonsButtonHeight); }
static QStyle_PixelMetric_Enum *c_47_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MdiSubWindowFrameWidth); }
static QStyle_PixelMetric_Enum *c_48_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MDIFrameWidth); }
static QStyle_PixelMetric_Enum *c_49_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MdiSubWindowMinimizedWidth); }
static QStyle_PixelMetric_Enum *c_50_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MDIMinimizedWidth); }
static QStyle_PixelMetric_Enum *c_51_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_HeaderMargin); }
static QStyle_PixelMetric_Enum *c_52_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_HeaderMarkSize); }
static QStyle_PixelMetric_Enum *c_53_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_HeaderGripMargin); }
static QStyle_PixelMetric_Enum *c_54_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBarTabShiftHorizontal); }
static QStyle_PixelMetric_Enum *c_55_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBarTabShiftVertical); }
static QStyle_PixelMetric_Enum *c_56_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBarScrollButtonWidth); }
static QStyle_PixelMetric_Enum *c_57_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ToolBarFrameWidth); }
static QStyle_PixelMetric_Enum *c_58_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ToolBarHandleExtent); }
static QStyle_PixelMetric_Enum *c_59_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ToolBarItemSpacing); }
static QStyle_PixelMetric_Enum *c_60_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ToolBarItemMargin); }
static QStyle_PixelMetric_Enum *c_61_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ToolBarSeparatorExtent); }
static QStyle_PixelMetric_Enum *c_62_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ToolBarExtensionExtent); }
static QStyle_PixelMetric_Enum *c_63_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SpinBoxSliderHeight); }
static QStyle_PixelMetric_Enum *c_64_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DefaultTopLevelMargin); }
static QStyle_PixelMetric_Enum *c_65_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DefaultChildMargin); }
static QStyle_PixelMetric_Enum *c_66_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DefaultLayoutSpacing); }
static QStyle_PixelMetric_Enum *c_67_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ToolBarIconSize); }
static QStyle_PixelMetric_Enum *c_68_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ListViewIconSize); }
static QStyle_PixelMetric_Enum *c_69_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_IconViewIconSize); }
static QStyle_PixelMetric_Enum *c_70_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SmallIconSize); }
static QStyle_PixelMetric_Enum *c_71_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_LargeIconSize); }
static QStyle_PixelMetric_Enum *c_72_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_FocusFrameVMargin); }
static QStyle_PixelMetric_Enum *c_73_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_FocusFrameHMargin); }
static QStyle_PixelMetric_Enum *c_74_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ToolTipLabelFrameWidth); }
static QStyle_PixelMetric_Enum *c_75_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_CheckBoxLabelSpacing); }
static QStyle_PixelMetric_Enum *c_76_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBarIconSize); }
static QStyle_PixelMetric_Enum *c_77_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SizeGripSize); }
static QStyle_PixelMetric_Enum *c_78_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DockWidgetTitleMargin); }
static QStyle_PixelMetric_Enum *c_79_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_MessageBoxIconSize); }
static QStyle_PixelMetric_Enum *c_80_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ButtonIconSize); }
static QStyle_PixelMetric_Enum *c_81_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_DockWidgetTitleBarButtonMargin); }
static QStyle_PixelMetric_Enum *c_82_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_RadioButtonLabelSpacing); }
static QStyle_PixelMetric_Enum *c_83_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_LayoutLeftMargin); }
static QStyle_PixelMetric_Enum *c_84_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_LayoutTopMargin); }
static QStyle_PixelMetric_Enum *c_85_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_LayoutRightMargin); }
static QStyle_PixelMetric_Enum *c_86_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_LayoutBottomMargin); }
static QStyle_PixelMetric_Enum *c_87_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_LayoutHorizontalSpacing); }
static QStyle_PixelMetric_Enum *c_88_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_LayoutVerticalSpacing); }
static QStyle_PixelMetric_Enum *c_89_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabBar_ScrollButtonOverlap); }
static QStyle_PixelMetric_Enum *c_90_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TextCursorWidth); }
static QStyle_PixelMetric_Enum *c_91_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabCloseIndicatorWidth); }
static QStyle_PixelMetric_Enum *c_92_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_TabCloseIndicatorHeight); }
static QStyle_PixelMetric_Enum *c_93_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_ScrollView_ScrollBarSpacing); }
static QStyle_PixelMetric_Enum *c_94_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_SubMenuOverlap); }
static QStyle_PixelMetric_Enum *c_95_QStyle_PixelMetric_Enum () { return new QStyle_PixelMetric_Enum (QStyle::PM_CustomBase); }

static gsi::Methods mkdefs_QStyle_PixelMetric () {
  return
    gsi::constant ("PM_ButtonMargin", &qt_gsi::c_1_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ButtonMargin") +
    gsi::constant ("PM_ButtonDefaultIndicator", &qt_gsi::c_2_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ButtonDefaultIndicator") +
    gsi::constant ("PM_MenuButtonIndicator", &qt_gsi::c_3_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuButtonIndicator") +
    gsi::constant ("PM_ButtonShiftHorizontal", &qt_gsi::c_4_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ButtonShiftHorizontal") +
    gsi::constant ("PM_ButtonShiftVertical", &qt_gsi::c_5_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ButtonShiftVertical") +
    gsi::constant ("PM_DefaultFrameWidth", &qt_gsi::c_6_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DefaultFrameWidth") +
    gsi::constant ("PM_SpinBoxFrameWidth", &qt_gsi::c_7_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SpinBoxFrameWidth") +
    gsi::constant ("PM_ComboBoxFrameWidth", &qt_gsi::c_8_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ComboBoxFrameWidth") +
    gsi::constant ("PM_MaximumDragDistance", &qt_gsi::c_9_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MaximumDragDistance") +
    gsi::constant ("PM_ScrollBarExtent", &qt_gsi::c_10_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ScrollBarExtent") +
    gsi::constant ("PM_ScrollBarSliderMin", &qt_gsi::c_11_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ScrollBarSliderMin") +
    gsi::constant ("PM_SliderThickness", &qt_gsi::c_12_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SliderThickness") +
    gsi::constant ("PM_SliderControlThickness", &qt_gsi::c_13_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SliderControlThickness") +
    gsi::constant ("PM_SliderLength", &qt_gsi::c_14_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SliderLength") +
    gsi::constant ("PM_SliderTickmarkOffset", &qt_gsi::c_15_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SliderTickmarkOffset") +
    gsi::constant ("PM_SliderSpaceAvailable", &qt_gsi::c_16_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SliderSpaceAvailable") +
    gsi::constant ("PM_DockWidgetSeparatorExtent", &qt_gsi::c_17_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DockWidgetSeparatorExtent") +
    gsi::constant ("PM_DockWidgetHandleExtent", &qt_gsi::c_18_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DockWidgetHandleExtent") +
    gsi::constant ("PM_DockWidgetFrameWidth", &qt_gsi::c_19_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DockWidgetFrameWidth") +
    gsi::constant ("PM_TabBarTabOverlap", &qt_gsi::c_20_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBarTabOverlap") +
    gsi::constant ("PM_TabBarTabHSpace", &qt_gsi::c_21_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBarTabHSpace") +
    gsi::constant ("PM_TabBarTabVSpace", &qt_gsi::c_22_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBarTabVSpace") +
    gsi::constant ("PM_TabBarBaseHeight", &qt_gsi::c_23_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBarBaseHeight") +
    gsi::constant ("PM_TabBarBaseOverlap", &qt_gsi::c_24_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBarBaseOverlap") +
    gsi::constant ("PM_ProgressBarChunkWidth", &qt_gsi::c_25_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ProgressBarChunkWidth") +
    gsi::constant ("PM_SplitterWidth", &qt_gsi::c_26_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SplitterWidth") +
    gsi::constant ("PM_TitleBarHeight", &qt_gsi::c_27_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TitleBarHeight") +
    gsi::constant ("PM_MenuScrollerHeight", &qt_gsi::c_28_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuScrollerHeight") +
    gsi::constant ("PM_MenuHMargin", &qt_gsi::c_29_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuHMargin") +
    gsi::constant ("PM_MenuVMargin", &qt_gsi::c_30_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuVMargin") +
    gsi::constant ("PM_MenuPanelWidth", &qt_gsi::c_31_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuPanelWidth") +
    gsi::constant ("PM_MenuTearoffHeight", &qt_gsi::c_32_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuTearoffHeight") +
    gsi::constant ("PM_MenuDesktopFrameWidth", &qt_gsi::c_33_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuDesktopFrameWidth") +
    gsi::constant ("PM_MenuBarPanelWidth", &qt_gsi::c_34_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuBarPanelWidth") +
    gsi::constant ("PM_MenuBarItemSpacing", &qt_gsi::c_35_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuBarItemSpacing") +
    gsi::constant ("PM_MenuBarVMargin", &qt_gsi::c_36_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuBarVMargin") +
    gsi::constant ("PM_MenuBarHMargin", &qt_gsi::c_37_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MenuBarHMargin") +
    gsi::constant ("PM_IndicatorWidth", &qt_gsi::c_38_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_IndicatorWidth") +
    gsi::constant ("PM_IndicatorHeight", &qt_gsi::c_39_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_IndicatorHeight") +
    gsi::constant ("PM_ExclusiveIndicatorWidth", &qt_gsi::c_40_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ExclusiveIndicatorWidth") +
    gsi::constant ("PM_ExclusiveIndicatorHeight", &qt_gsi::c_41_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ExclusiveIndicatorHeight") +
    gsi::constant ("PM_CheckListButtonSize", &qt_gsi::c_42_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_CheckListButtonSize") +
    gsi::constant ("PM_CheckListControllerSize", &qt_gsi::c_43_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_CheckListControllerSize") +
    gsi::constant ("PM_DialogButtonsSeparator", &qt_gsi::c_44_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DialogButtonsSeparator") +
    gsi::constant ("PM_DialogButtonsButtonWidth", &qt_gsi::c_45_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DialogButtonsButtonWidth") +
    gsi::constant ("PM_DialogButtonsButtonHeight", &qt_gsi::c_46_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DialogButtonsButtonHeight") +
    gsi::constant ("PM_MdiSubWindowFrameWidth", &qt_gsi::c_47_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MdiSubWindowFrameWidth") +
    gsi::constant ("PM_MDIFrameWidth", &qt_gsi::c_48_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MDIFrameWidth") +
    gsi::constant ("PM_MdiSubWindowMinimizedWidth", &qt_gsi::c_49_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MdiSubWindowMinimizedWidth") +
    gsi::constant ("PM_MDIMinimizedWidth", &qt_gsi::c_50_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MDIMinimizedWidth") +
    gsi::constant ("PM_HeaderMargin", &qt_gsi::c_51_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_HeaderMargin") +
    gsi::constant ("PM_HeaderMarkSize", &qt_gsi::c_52_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_HeaderMarkSize") +
    gsi::constant ("PM_HeaderGripMargin", &qt_gsi::c_53_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_HeaderGripMargin") +
    gsi::constant ("PM_TabBarTabShiftHorizontal", &qt_gsi::c_54_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBarTabShiftHorizontal") +
    gsi::constant ("PM_TabBarTabShiftVertical", &qt_gsi::c_55_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBarTabShiftVertical") +
    gsi::constant ("PM_TabBarScrollButtonWidth", &qt_gsi::c_56_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBarScrollButtonWidth") +
    gsi::constant ("PM_ToolBarFrameWidth", &qt_gsi::c_57_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ToolBarFrameWidth") +
    gsi::constant ("PM_ToolBarHandleExtent", &qt_gsi::c_58_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ToolBarHandleExtent") +
    gsi::constant ("PM_ToolBarItemSpacing", &qt_gsi::c_59_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ToolBarItemSpacing") +
    gsi::constant ("PM_ToolBarItemMargin", &qt_gsi::c_60_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ToolBarItemMargin") +
    gsi::constant ("PM_ToolBarSeparatorExtent", &qt_gsi::c_61_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ToolBarSeparatorExtent") +
    gsi::constant ("PM_ToolBarExtensionExtent", &qt_gsi::c_62_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ToolBarExtensionExtent") +
    gsi::constant ("PM_SpinBoxSliderHeight", &qt_gsi::c_63_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SpinBoxSliderHeight") +
    gsi::constant ("PM_DefaultTopLevelMargin", &qt_gsi::c_64_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DefaultTopLevelMargin") +
    gsi::constant ("PM_DefaultChildMargin", &qt_gsi::c_65_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DefaultChildMargin") +
    gsi::constant ("PM_DefaultLayoutSpacing", &qt_gsi::c_66_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DefaultLayoutSpacing") +
    gsi::constant ("PM_ToolBarIconSize", &qt_gsi::c_67_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ToolBarIconSize") +
    gsi::constant ("PM_ListViewIconSize", &qt_gsi::c_68_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ListViewIconSize") +
    gsi::constant ("PM_IconViewIconSize", &qt_gsi::c_69_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_IconViewIconSize") +
    gsi::constant ("PM_SmallIconSize", &qt_gsi::c_70_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SmallIconSize") +
    gsi::constant ("PM_LargeIconSize", &qt_gsi::c_71_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_LargeIconSize") +
    gsi::constant ("PM_FocusFrameVMargin", &qt_gsi::c_72_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_FocusFrameVMargin") +
    gsi::constant ("PM_FocusFrameHMargin", &qt_gsi::c_73_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_FocusFrameHMargin") +
    gsi::constant ("PM_ToolTipLabelFrameWidth", &qt_gsi::c_74_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ToolTipLabelFrameWidth") +
    gsi::constant ("PM_CheckBoxLabelSpacing", &qt_gsi::c_75_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_CheckBoxLabelSpacing") +
    gsi::constant ("PM_TabBarIconSize", &qt_gsi::c_76_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBarIconSize") +
    gsi::constant ("PM_SizeGripSize", &qt_gsi::c_77_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SizeGripSize") +
    gsi::constant ("PM_DockWidgetTitleMargin", &qt_gsi::c_78_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DockWidgetTitleMargin") +
    gsi::constant ("PM_MessageBoxIconSize", &qt_gsi::c_79_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_MessageBoxIconSize") +
    gsi::constant ("PM_ButtonIconSize", &qt_gsi::c_80_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ButtonIconSize") +
    gsi::constant ("PM_DockWidgetTitleBarButtonMargin", &qt_gsi::c_81_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_DockWidgetTitleBarButtonMargin") +
    gsi::constant ("PM_RadioButtonLabelSpacing", &qt_gsi::c_82_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_RadioButtonLabelSpacing") +
    gsi::constant ("PM_LayoutLeftMargin", &qt_gsi::c_83_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_LayoutLeftMargin") +
    gsi::constant ("PM_LayoutTopMargin", &qt_gsi::c_84_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_LayoutTopMargin") +
    gsi::constant ("PM_LayoutRightMargin", &qt_gsi::c_85_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_LayoutRightMargin") +
    gsi::constant ("PM_LayoutBottomMargin", &qt_gsi::c_86_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_LayoutBottomMargin") +
    gsi::constant ("PM_LayoutHorizontalSpacing", &qt_gsi::c_87_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_LayoutHorizontalSpacing") +
    gsi::constant ("PM_LayoutVerticalSpacing", &qt_gsi::c_88_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_LayoutVerticalSpacing") +
    gsi::constant ("PM_TabBar_ScrollButtonOverlap", &qt_gsi::c_89_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabBar_ScrollButtonOverlap") +
    gsi::constant ("PM_TextCursorWidth", &qt_gsi::c_90_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TextCursorWidth") +
    gsi::constant ("PM_TabCloseIndicatorWidth", &qt_gsi::c_91_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabCloseIndicatorWidth") +
    gsi::constant ("PM_TabCloseIndicatorHeight", &qt_gsi::c_92_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_TabCloseIndicatorHeight") +
    gsi::constant ("PM_ScrollView_ScrollBarSpacing", &qt_gsi::c_93_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_ScrollView_ScrollBarSpacing") +
    gsi::constant ("PM_SubMenuOverlap", &qt_gsi::c_94_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_SubMenuOverlap") +
    gsi::constant ("PM_CustomBase", &qt_gsi::c_95_QStyle_PixelMetric_Enum, "@brief Enum constant QStyle::PM_CustomBase");
}

static std::string to_s_QStyle_PixelMetric_Enum (const QStyle_PixelMetric_Enum *e)
{
  if (e->value () == QStyle::PM_ButtonMargin) { return tl::sprintf ("PM_ButtonMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ButtonDefaultIndicator) { return tl::sprintf ("PM_ButtonDefaultIndicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuButtonIndicator) { return tl::sprintf ("PM_MenuButtonIndicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ButtonShiftHorizontal) { return tl::sprintf ("PM_ButtonShiftHorizontal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ButtonShiftVertical) { return tl::sprintf ("PM_ButtonShiftVertical (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DefaultFrameWidth) { return tl::sprintf ("PM_DefaultFrameWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SpinBoxFrameWidth) { return tl::sprintf ("PM_SpinBoxFrameWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ComboBoxFrameWidth) { return tl::sprintf ("PM_ComboBoxFrameWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MaximumDragDistance) { return tl::sprintf ("PM_MaximumDragDistance (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ScrollBarExtent) { return tl::sprintf ("PM_ScrollBarExtent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ScrollBarSliderMin) { return tl::sprintf ("PM_ScrollBarSliderMin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SliderThickness) { return tl::sprintf ("PM_SliderThickness (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SliderControlThickness) { return tl::sprintf ("PM_SliderControlThickness (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SliderLength) { return tl::sprintf ("PM_SliderLength (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SliderTickmarkOffset) { return tl::sprintf ("PM_SliderTickmarkOffset (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SliderSpaceAvailable) { return tl::sprintf ("PM_SliderSpaceAvailable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DockWidgetSeparatorExtent) { return tl::sprintf ("PM_DockWidgetSeparatorExtent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DockWidgetHandleExtent) { return tl::sprintf ("PM_DockWidgetHandleExtent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DockWidgetFrameWidth) { return tl::sprintf ("PM_DockWidgetFrameWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBarTabOverlap) { return tl::sprintf ("PM_TabBarTabOverlap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBarTabHSpace) { return tl::sprintf ("PM_TabBarTabHSpace (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBarTabVSpace) { return tl::sprintf ("PM_TabBarTabVSpace (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBarBaseHeight) { return tl::sprintf ("PM_TabBarBaseHeight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBarBaseOverlap) { return tl::sprintf ("PM_TabBarBaseOverlap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ProgressBarChunkWidth) { return tl::sprintf ("PM_ProgressBarChunkWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SplitterWidth) { return tl::sprintf ("PM_SplitterWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TitleBarHeight) { return tl::sprintf ("PM_TitleBarHeight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuScrollerHeight) { return tl::sprintf ("PM_MenuScrollerHeight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuHMargin) { return tl::sprintf ("PM_MenuHMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuVMargin) { return tl::sprintf ("PM_MenuVMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuPanelWidth) { return tl::sprintf ("PM_MenuPanelWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuTearoffHeight) { return tl::sprintf ("PM_MenuTearoffHeight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuDesktopFrameWidth) { return tl::sprintf ("PM_MenuDesktopFrameWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuBarPanelWidth) { return tl::sprintf ("PM_MenuBarPanelWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuBarItemSpacing) { return tl::sprintf ("PM_MenuBarItemSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuBarVMargin) { return tl::sprintf ("PM_MenuBarVMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MenuBarHMargin) { return tl::sprintf ("PM_MenuBarHMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_IndicatorWidth) { return tl::sprintf ("PM_IndicatorWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_IndicatorHeight) { return tl::sprintf ("PM_IndicatorHeight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ExclusiveIndicatorWidth) { return tl::sprintf ("PM_ExclusiveIndicatorWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ExclusiveIndicatorHeight) { return tl::sprintf ("PM_ExclusiveIndicatorHeight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_CheckListButtonSize) { return tl::sprintf ("PM_CheckListButtonSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_CheckListControllerSize) { return tl::sprintf ("PM_CheckListControllerSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DialogButtonsSeparator) { return tl::sprintf ("PM_DialogButtonsSeparator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DialogButtonsButtonWidth) { return tl::sprintf ("PM_DialogButtonsButtonWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DialogButtonsButtonHeight) { return tl::sprintf ("PM_DialogButtonsButtonHeight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MdiSubWindowFrameWidth) { return tl::sprintf ("PM_MdiSubWindowFrameWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MDIFrameWidth) { return tl::sprintf ("PM_MDIFrameWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MdiSubWindowMinimizedWidth) { return tl::sprintf ("PM_MdiSubWindowMinimizedWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MDIMinimizedWidth) { return tl::sprintf ("PM_MDIMinimizedWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_HeaderMargin) { return tl::sprintf ("PM_HeaderMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_HeaderMarkSize) { return tl::sprintf ("PM_HeaderMarkSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_HeaderGripMargin) { return tl::sprintf ("PM_HeaderGripMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBarTabShiftHorizontal) { return tl::sprintf ("PM_TabBarTabShiftHorizontal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBarTabShiftVertical) { return tl::sprintf ("PM_TabBarTabShiftVertical (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBarScrollButtonWidth) { return tl::sprintf ("PM_TabBarScrollButtonWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ToolBarFrameWidth) { return tl::sprintf ("PM_ToolBarFrameWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ToolBarHandleExtent) { return tl::sprintf ("PM_ToolBarHandleExtent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ToolBarItemSpacing) { return tl::sprintf ("PM_ToolBarItemSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ToolBarItemMargin) { return tl::sprintf ("PM_ToolBarItemMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ToolBarSeparatorExtent) { return tl::sprintf ("PM_ToolBarSeparatorExtent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ToolBarExtensionExtent) { return tl::sprintf ("PM_ToolBarExtensionExtent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SpinBoxSliderHeight) { return tl::sprintf ("PM_SpinBoxSliderHeight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DefaultTopLevelMargin) { return tl::sprintf ("PM_DefaultTopLevelMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DefaultChildMargin) { return tl::sprintf ("PM_DefaultChildMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DefaultLayoutSpacing) { return tl::sprintf ("PM_DefaultLayoutSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ToolBarIconSize) { return tl::sprintf ("PM_ToolBarIconSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ListViewIconSize) { return tl::sprintf ("PM_ListViewIconSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_IconViewIconSize) { return tl::sprintf ("PM_IconViewIconSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SmallIconSize) { return tl::sprintf ("PM_SmallIconSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_LargeIconSize) { return tl::sprintf ("PM_LargeIconSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_FocusFrameVMargin) { return tl::sprintf ("PM_FocusFrameVMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_FocusFrameHMargin) { return tl::sprintf ("PM_FocusFrameHMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ToolTipLabelFrameWidth) { return tl::sprintf ("PM_ToolTipLabelFrameWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_CheckBoxLabelSpacing) { return tl::sprintf ("PM_CheckBoxLabelSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBarIconSize) { return tl::sprintf ("PM_TabBarIconSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SizeGripSize) { return tl::sprintf ("PM_SizeGripSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DockWidgetTitleMargin) { return tl::sprintf ("PM_DockWidgetTitleMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_MessageBoxIconSize) { return tl::sprintf ("PM_MessageBoxIconSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ButtonIconSize) { return tl::sprintf ("PM_ButtonIconSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_DockWidgetTitleBarButtonMargin) { return tl::sprintf ("PM_DockWidgetTitleBarButtonMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_RadioButtonLabelSpacing) { return tl::sprintf ("PM_RadioButtonLabelSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_LayoutLeftMargin) { return tl::sprintf ("PM_LayoutLeftMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_LayoutTopMargin) { return tl::sprintf ("PM_LayoutTopMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_LayoutRightMargin) { return tl::sprintf ("PM_LayoutRightMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_LayoutBottomMargin) { return tl::sprintf ("PM_LayoutBottomMargin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_LayoutHorizontalSpacing) { return tl::sprintf ("PM_LayoutHorizontalSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_LayoutVerticalSpacing) { return tl::sprintf ("PM_LayoutVerticalSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabBar_ScrollButtonOverlap) { return tl::sprintf ("PM_TabBar_ScrollButtonOverlap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TextCursorWidth) { return tl::sprintf ("PM_TextCursorWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabCloseIndicatorWidth) { return tl::sprintf ("PM_TabCloseIndicatorWidth (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_TabCloseIndicatorHeight) { return tl::sprintf ("PM_TabCloseIndicatorHeight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_ScrollView_ScrollBarSpacing) { return tl::sprintf ("PM_ScrollView_ScrollBarSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_SubMenuOverlap) { return tl::sprintf ("PM_SubMenuOverlap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PM_CustomBase) { return tl::sprintf ("PM_CustomBase (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStyle_PixelMetric_Enum (const QStyle_PixelMetric_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStyle_PixelMetric_Enum *from_i_QStyle_PixelMetric_Enum (unsigned int i)
{
  return new QStyle_PixelMetric_Enum ((QStyle::PixelMetric) i);
}

static bool equalQStyle_PixelMetric_Enum (const QStyle_PixelMetric_Enum *e, QStyle_PixelMetric_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStyle_PixelMetric_Enum (const QStyle_PixelMetric_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStyle_PixelMetric_Enums oropQStyle_PixelMetric_Enums (const QStyle_PixelMetric_Enums *e, const QStyle_PixelMetric_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStyle_PixelMetric_Enums andopQStyle_PixelMetric_Enums (const QStyle_PixelMetric_Enums *e, const QStyle_PixelMetric_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStyle_PixelMetric_Enums xoropQStyle_PixelMetric_Enums (const QStyle_PixelMetric_Enums *e, const QStyle_PixelMetric_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStyle_PixelMetric_Enums (const QStyle_PixelMetric_Enums *e)
{
  std::string l;
  if (e->testFlag (QStyle::PM_ButtonMargin)) { if (!l.empty ()) l += "|"; l += "PM_ButtonMargin"; }
  if (e->testFlag (QStyle::PM_ButtonDefaultIndicator)) { if (!l.empty ()) l += "|"; l += "PM_ButtonDefaultIndicator"; }
  if (e->testFlag (QStyle::PM_MenuButtonIndicator)) { if (!l.empty ()) l += "|"; l += "PM_MenuButtonIndicator"; }
  if (e->testFlag (QStyle::PM_ButtonShiftHorizontal)) { if (!l.empty ()) l += "|"; l += "PM_ButtonShiftHorizontal"; }
  if (e->testFlag (QStyle::PM_ButtonShiftVertical)) { if (!l.empty ()) l += "|"; l += "PM_ButtonShiftVertical"; }
  if (e->testFlag (QStyle::PM_DefaultFrameWidth)) { if (!l.empty ()) l += "|"; l += "PM_DefaultFrameWidth"; }
  if (e->testFlag (QStyle::PM_SpinBoxFrameWidth)) { if (!l.empty ()) l += "|"; l += "PM_SpinBoxFrameWidth"; }
  if (e->testFlag (QStyle::PM_ComboBoxFrameWidth)) { if (!l.empty ()) l += "|"; l += "PM_ComboBoxFrameWidth"; }
  if (e->testFlag (QStyle::PM_MaximumDragDistance)) { if (!l.empty ()) l += "|"; l += "PM_MaximumDragDistance"; }
  if (e->testFlag (QStyle::PM_ScrollBarExtent)) { if (!l.empty ()) l += "|"; l += "PM_ScrollBarExtent"; }
  if (e->testFlag (QStyle::PM_ScrollBarSliderMin)) { if (!l.empty ()) l += "|"; l += "PM_ScrollBarSliderMin"; }
  if (e->testFlag (QStyle::PM_SliderThickness)) { if (!l.empty ()) l += "|"; l += "PM_SliderThickness"; }
  if (e->testFlag (QStyle::PM_SliderControlThickness)) { if (!l.empty ()) l += "|"; l += "PM_SliderControlThickness"; }
  if (e->testFlag (QStyle::PM_SliderLength)) { if (!l.empty ()) l += "|"; l += "PM_SliderLength"; }
  if (e->testFlag (QStyle::PM_SliderTickmarkOffset)) { if (!l.empty ()) l += "|"; l += "PM_SliderTickmarkOffset"; }
  if (e->testFlag (QStyle::PM_SliderSpaceAvailable)) { if (!l.empty ()) l += "|"; l += "PM_SliderSpaceAvailable"; }
  if (e->testFlag (QStyle::PM_DockWidgetSeparatorExtent)) { if (!l.empty ()) l += "|"; l += "PM_DockWidgetSeparatorExtent"; }
  if (e->testFlag (QStyle::PM_DockWidgetHandleExtent)) { if (!l.empty ()) l += "|"; l += "PM_DockWidgetHandleExtent"; }
  if (e->testFlag (QStyle::PM_DockWidgetFrameWidth)) { if (!l.empty ()) l += "|"; l += "PM_DockWidgetFrameWidth"; }
  if (e->testFlag (QStyle::PM_TabBarTabOverlap)) { if (!l.empty ()) l += "|"; l += "PM_TabBarTabOverlap"; }
  if (e->testFlag (QStyle::PM_TabBarTabHSpace)) { if (!l.empty ()) l += "|"; l += "PM_TabBarTabHSpace"; }
  if (e->testFlag (QStyle::PM_TabBarTabVSpace)) { if (!l.empty ()) l += "|"; l += "PM_TabBarTabVSpace"; }
  if (e->testFlag (QStyle::PM_TabBarBaseHeight)) { if (!l.empty ()) l += "|"; l += "PM_TabBarBaseHeight"; }
  if (e->testFlag (QStyle::PM_TabBarBaseOverlap)) { if (!l.empty ()) l += "|"; l += "PM_TabBarBaseOverlap"; }
  if (e->testFlag (QStyle::PM_ProgressBarChunkWidth)) { if (!l.empty ()) l += "|"; l += "PM_ProgressBarChunkWidth"; }
  if (e->testFlag (QStyle::PM_SplitterWidth)) { if (!l.empty ()) l += "|"; l += "PM_SplitterWidth"; }
  if (e->testFlag (QStyle::PM_TitleBarHeight)) { if (!l.empty ()) l += "|"; l += "PM_TitleBarHeight"; }
  if (e->testFlag (QStyle::PM_MenuScrollerHeight)) { if (!l.empty ()) l += "|"; l += "PM_MenuScrollerHeight"; }
  if (e->testFlag (QStyle::PM_MenuHMargin)) { if (!l.empty ()) l += "|"; l += "PM_MenuHMargin"; }
  if (e->testFlag (QStyle::PM_MenuVMargin)) { if (!l.empty ()) l += "|"; l += "PM_MenuVMargin"; }
  if (e->testFlag (QStyle::PM_MenuPanelWidth)) { if (!l.empty ()) l += "|"; l += "PM_MenuPanelWidth"; }
  if (e->testFlag (QStyle::PM_MenuTearoffHeight)) { if (!l.empty ()) l += "|"; l += "PM_MenuTearoffHeight"; }
  if (e->testFlag (QStyle::PM_MenuDesktopFrameWidth)) { if (!l.empty ()) l += "|"; l += "PM_MenuDesktopFrameWidth"; }
  if (e->testFlag (QStyle::PM_MenuBarPanelWidth)) { if (!l.empty ()) l += "|"; l += "PM_MenuBarPanelWidth"; }
  if (e->testFlag (QStyle::PM_MenuBarItemSpacing)) { if (!l.empty ()) l += "|"; l += "PM_MenuBarItemSpacing"; }
  if (e->testFlag (QStyle::PM_MenuBarVMargin)) { if (!l.empty ()) l += "|"; l += "PM_MenuBarVMargin"; }
  if (e->testFlag (QStyle::PM_MenuBarHMargin)) { if (!l.empty ()) l += "|"; l += "PM_MenuBarHMargin"; }
  if (e->testFlag (QStyle::PM_IndicatorWidth)) { if (!l.empty ()) l += "|"; l += "PM_IndicatorWidth"; }
  if (e->testFlag (QStyle::PM_IndicatorHeight)) { if (!l.empty ()) l += "|"; l += "PM_IndicatorHeight"; }
  if (e->testFlag (QStyle::PM_ExclusiveIndicatorWidth)) { if (!l.empty ()) l += "|"; l += "PM_ExclusiveIndicatorWidth"; }
  if (e->testFlag (QStyle::PM_ExclusiveIndicatorHeight)) { if (!l.empty ()) l += "|"; l += "PM_ExclusiveIndicatorHeight"; }
  if (e->testFlag (QStyle::PM_CheckListButtonSize)) { if (!l.empty ()) l += "|"; l += "PM_CheckListButtonSize"; }
  if (e->testFlag (QStyle::PM_CheckListControllerSize)) { if (!l.empty ()) l += "|"; l += "PM_CheckListControllerSize"; }
  if (e->testFlag (QStyle::PM_DialogButtonsSeparator)) { if (!l.empty ()) l += "|"; l += "PM_DialogButtonsSeparator"; }
  if (e->testFlag (QStyle::PM_DialogButtonsButtonWidth)) { if (!l.empty ()) l += "|"; l += "PM_DialogButtonsButtonWidth"; }
  if (e->testFlag (QStyle::PM_DialogButtonsButtonHeight)) { if (!l.empty ()) l += "|"; l += "PM_DialogButtonsButtonHeight"; }
  if (e->testFlag (QStyle::PM_MdiSubWindowFrameWidth)) { if (!l.empty ()) l += "|"; l += "PM_MdiSubWindowFrameWidth"; }
  if (e->testFlag (QStyle::PM_MDIFrameWidth)) { if (!l.empty ()) l += "|"; l += "PM_MDIFrameWidth"; }
  if (e->testFlag (QStyle::PM_MdiSubWindowMinimizedWidth)) { if (!l.empty ()) l += "|"; l += "PM_MdiSubWindowMinimizedWidth"; }
  if (e->testFlag (QStyle::PM_MDIMinimizedWidth)) { if (!l.empty ()) l += "|"; l += "PM_MDIMinimizedWidth"; }
  if (e->testFlag (QStyle::PM_HeaderMargin)) { if (!l.empty ()) l += "|"; l += "PM_HeaderMargin"; }
  if (e->testFlag (QStyle::PM_HeaderMarkSize)) { if (!l.empty ()) l += "|"; l += "PM_HeaderMarkSize"; }
  if (e->testFlag (QStyle::PM_HeaderGripMargin)) { if (!l.empty ()) l += "|"; l += "PM_HeaderGripMargin"; }
  if (e->testFlag (QStyle::PM_TabBarTabShiftHorizontal)) { if (!l.empty ()) l += "|"; l += "PM_TabBarTabShiftHorizontal"; }
  if (e->testFlag (QStyle::PM_TabBarTabShiftVertical)) { if (!l.empty ()) l += "|"; l += "PM_TabBarTabShiftVertical"; }
  if (e->testFlag (QStyle::PM_TabBarScrollButtonWidth)) { if (!l.empty ()) l += "|"; l += "PM_TabBarScrollButtonWidth"; }
  if (e->testFlag (QStyle::PM_ToolBarFrameWidth)) { if (!l.empty ()) l += "|"; l += "PM_ToolBarFrameWidth"; }
  if (e->testFlag (QStyle::PM_ToolBarHandleExtent)) { if (!l.empty ()) l += "|"; l += "PM_ToolBarHandleExtent"; }
  if (e->testFlag (QStyle::PM_ToolBarItemSpacing)) { if (!l.empty ()) l += "|"; l += "PM_ToolBarItemSpacing"; }
  if (e->testFlag (QStyle::PM_ToolBarItemMargin)) { if (!l.empty ()) l += "|"; l += "PM_ToolBarItemMargin"; }
  if (e->testFlag (QStyle::PM_ToolBarSeparatorExtent)) { if (!l.empty ()) l += "|"; l += "PM_ToolBarSeparatorExtent"; }
  if (e->testFlag (QStyle::PM_ToolBarExtensionExtent)) { if (!l.empty ()) l += "|"; l += "PM_ToolBarExtensionExtent"; }
  if (e->testFlag (QStyle::PM_SpinBoxSliderHeight)) { if (!l.empty ()) l += "|"; l += "PM_SpinBoxSliderHeight"; }
  if (e->testFlag (QStyle::PM_DefaultTopLevelMargin)) { if (!l.empty ()) l += "|"; l += "PM_DefaultTopLevelMargin"; }
  if (e->testFlag (QStyle::PM_DefaultChildMargin)) { if (!l.empty ()) l += "|"; l += "PM_DefaultChildMargin"; }
  if (e->testFlag (QStyle::PM_DefaultLayoutSpacing)) { if (!l.empty ()) l += "|"; l += "PM_DefaultLayoutSpacing"; }
  if (e->testFlag (QStyle::PM_ToolBarIconSize)) { if (!l.empty ()) l += "|"; l += "PM_ToolBarIconSize"; }
  if (e->testFlag (QStyle::PM_ListViewIconSize)) { if (!l.empty ()) l += "|"; l += "PM_ListViewIconSize"; }
  if (e->testFlag (QStyle::PM_IconViewIconSize)) { if (!l.empty ()) l += "|"; l += "PM_IconViewIconSize"; }
  if (e->testFlag (QStyle::PM_SmallIconSize)) { if (!l.empty ()) l += "|"; l += "PM_SmallIconSize"; }
  if (e->testFlag (QStyle::PM_LargeIconSize)) { if (!l.empty ()) l += "|"; l += "PM_LargeIconSize"; }
  if (e->testFlag (QStyle::PM_FocusFrameVMargin)) { if (!l.empty ()) l += "|"; l += "PM_FocusFrameVMargin"; }
  if (e->testFlag (QStyle::PM_FocusFrameHMargin)) { if (!l.empty ()) l += "|"; l += "PM_FocusFrameHMargin"; }
  if (e->testFlag (QStyle::PM_ToolTipLabelFrameWidth)) { if (!l.empty ()) l += "|"; l += "PM_ToolTipLabelFrameWidth"; }
  if (e->testFlag (QStyle::PM_CheckBoxLabelSpacing)) { if (!l.empty ()) l += "|"; l += "PM_CheckBoxLabelSpacing"; }
  if (e->testFlag (QStyle::PM_TabBarIconSize)) { if (!l.empty ()) l += "|"; l += "PM_TabBarIconSize"; }
  if (e->testFlag (QStyle::PM_SizeGripSize)) { if (!l.empty ()) l += "|"; l += "PM_SizeGripSize"; }
  if (e->testFlag (QStyle::PM_DockWidgetTitleMargin)) { if (!l.empty ()) l += "|"; l += "PM_DockWidgetTitleMargin"; }
  if (e->testFlag (QStyle::PM_MessageBoxIconSize)) { if (!l.empty ()) l += "|"; l += "PM_MessageBoxIconSize"; }
  if (e->testFlag (QStyle::PM_ButtonIconSize)) { if (!l.empty ()) l += "|"; l += "PM_ButtonIconSize"; }
  if (e->testFlag (QStyle::PM_DockWidgetTitleBarButtonMargin)) { if (!l.empty ()) l += "|"; l += "PM_DockWidgetTitleBarButtonMargin"; }
  if (e->testFlag (QStyle::PM_RadioButtonLabelSpacing)) { if (!l.empty ()) l += "|"; l += "PM_RadioButtonLabelSpacing"; }
  if (e->testFlag (QStyle::PM_LayoutLeftMargin)) { if (!l.empty ()) l += "|"; l += "PM_LayoutLeftMargin"; }
  if (e->testFlag (QStyle::PM_LayoutTopMargin)) { if (!l.empty ()) l += "|"; l += "PM_LayoutTopMargin"; }
  if (e->testFlag (QStyle::PM_LayoutRightMargin)) { if (!l.empty ()) l += "|"; l += "PM_LayoutRightMargin"; }
  if (e->testFlag (QStyle::PM_LayoutBottomMargin)) { if (!l.empty ()) l += "|"; l += "PM_LayoutBottomMargin"; }
  if (e->testFlag (QStyle::PM_LayoutHorizontalSpacing)) { if (!l.empty ()) l += "|"; l += "PM_LayoutHorizontalSpacing"; }
  if (e->testFlag (QStyle::PM_LayoutVerticalSpacing)) { if (!l.empty ()) l += "|"; l += "PM_LayoutVerticalSpacing"; }
  if (e->testFlag (QStyle::PM_TabBar_ScrollButtonOverlap)) { if (!l.empty ()) l += "|"; l += "PM_TabBar_ScrollButtonOverlap"; }
  if (e->testFlag (QStyle::PM_TextCursorWidth)) { if (!l.empty ()) l += "|"; l += "PM_TextCursorWidth"; }
  if (e->testFlag (QStyle::PM_TabCloseIndicatorWidth)) { if (!l.empty ()) l += "|"; l += "PM_TabCloseIndicatorWidth"; }
  if (e->testFlag (QStyle::PM_TabCloseIndicatorHeight)) { if (!l.empty ()) l += "|"; l += "PM_TabCloseIndicatorHeight"; }
  if (e->testFlag (QStyle::PM_ScrollView_ScrollBarSpacing)) { if (!l.empty ()) l += "|"; l += "PM_ScrollView_ScrollBarSpacing"; }
  if (e->testFlag (QStyle::PM_SubMenuOverlap)) { if (!l.empty ()) l += "|"; l += "PM_SubMenuOverlap"; }
  if (e->testFlag (QStyle::PM_CustomBase)) { if (!l.empty ()) l += "|"; l += "PM_CustomBase"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStyle_PixelMetric_Enums (const QStyle_PixelMetric_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStyle_PixelMetric_Enums (const QStyle_PixelMetric_Enums *e, const QStyle_PixelMetric_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStyle_PixelMetric_Enums> decl_QStyle_PixelMetric_Enums ("QStyle_QFlags_PixelMetric",
  gsi::method_ext ("|", &qt_gsi::oropQStyle_PixelMetric_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStyle_PixelMetric_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStyle_PixelMetric_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_PixelMetric_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_PixelMetric_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStyle_PixelMetric_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStyle::PixelMetric> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStyle_PixelMetric_Enum> decl_QStyle_PixelMetric_Enum (decl_QStyle_PixelMetric_Enums, "QStyle_PixelMetric",
  qt_gsi::mkdefs_QStyle_PixelMetric () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_PixelMetric_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_PixelMetric_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStyle_PixelMetric_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStyle_PixelMetric_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStyle_PixelMetric_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStyle::PixelMetric enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_PixelMetric_Enum_in_parent (qt_gsi::mkdefs_QStyle_PixelMetric ());
static gsi::ClassExt<QStyle> decl_QStyle_PixelMetric_Enum_as_child (decl_QStyle_PixelMetric_Enum, "PixelMetric");

}


//  Implementation of the enum wrapper class for QStyle::PrimitiveElement
namespace qt_gsi
{

static QStyle_PrimitiveElement_Enum *c_1_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_Q3CheckListController); }
static QStyle_PrimitiveElement_Enum *c_2_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_Q3CheckListExclusiveIndicator); }
static QStyle_PrimitiveElement_Enum *c_3_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_Q3CheckListIndicator); }
static QStyle_PrimitiveElement_Enum *c_4_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_Q3DockWindowSeparator); }
static QStyle_PrimitiveElement_Enum *c_5_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_Q3Separator); }
static QStyle_PrimitiveElement_Enum *c_6_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_Frame); }
static QStyle_PrimitiveElement_Enum *c_7_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameDefaultButton); }
static QStyle_PrimitiveElement_Enum *c_8_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameDockWidget); }
static QStyle_PrimitiveElement_Enum *c_9_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameFocusRect); }
static QStyle_PrimitiveElement_Enum *c_10_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameGroupBox); }
static QStyle_PrimitiveElement_Enum *c_11_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameLineEdit); }
static QStyle_PrimitiveElement_Enum *c_12_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameMenu); }
static QStyle_PrimitiveElement_Enum *c_13_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameStatusBar); }
static QStyle_PrimitiveElement_Enum *c_14_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameStatusBarItem); }
static QStyle_PrimitiveElement_Enum *c_15_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameTabWidget); }
static QStyle_PrimitiveElement_Enum *c_16_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameWindow); }
static QStyle_PrimitiveElement_Enum *c_17_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameButtonBevel); }
static QStyle_PrimitiveElement_Enum *c_18_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameButtonTool); }
static QStyle_PrimitiveElement_Enum *c_19_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_FrameTabBarBase); }
static QStyle_PrimitiveElement_Enum *c_20_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelButtonCommand); }
static QStyle_PrimitiveElement_Enum *c_21_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelButtonBevel); }
static QStyle_PrimitiveElement_Enum *c_22_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelButtonTool); }
static QStyle_PrimitiveElement_Enum *c_23_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelMenuBar); }
static QStyle_PrimitiveElement_Enum *c_24_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelToolBar); }
static QStyle_PrimitiveElement_Enum *c_25_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelLineEdit); }
static QStyle_PrimitiveElement_Enum *c_26_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorArrowDown); }
static QStyle_PrimitiveElement_Enum *c_27_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorArrowLeft); }
static QStyle_PrimitiveElement_Enum *c_28_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorArrowRight); }
static QStyle_PrimitiveElement_Enum *c_29_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorArrowUp); }
static QStyle_PrimitiveElement_Enum *c_30_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorBranch); }
static QStyle_PrimitiveElement_Enum *c_31_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorButtonDropDown); }
static QStyle_PrimitiveElement_Enum *c_32_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorViewItemCheck); }
static QStyle_PrimitiveElement_Enum *c_33_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorItemViewItemCheck); }
static QStyle_PrimitiveElement_Enum *c_34_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorCheckBox); }
static QStyle_PrimitiveElement_Enum *c_35_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorDockWidgetResizeHandle); }
static QStyle_PrimitiveElement_Enum *c_36_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorHeaderArrow); }
static QStyle_PrimitiveElement_Enum *c_37_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorMenuCheckMark); }
static QStyle_PrimitiveElement_Enum *c_38_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorProgressChunk); }
static QStyle_PrimitiveElement_Enum *c_39_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorRadioButton); }
static QStyle_PrimitiveElement_Enum *c_40_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorSpinDown); }
static QStyle_PrimitiveElement_Enum *c_41_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorSpinMinus); }
static QStyle_PrimitiveElement_Enum *c_42_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorSpinPlus); }
static QStyle_PrimitiveElement_Enum *c_43_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorSpinUp); }
static QStyle_PrimitiveElement_Enum *c_44_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorToolBarHandle); }
static QStyle_PrimitiveElement_Enum *c_45_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorToolBarSeparator); }
static QStyle_PrimitiveElement_Enum *c_46_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelTipLabel); }
static QStyle_PrimitiveElement_Enum *c_47_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorTabTear); }
static QStyle_PrimitiveElement_Enum *c_48_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelScrollAreaCorner); }
static QStyle_PrimitiveElement_Enum *c_49_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_Widget); }
static QStyle_PrimitiveElement_Enum *c_50_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorColumnViewArrow); }
static QStyle_PrimitiveElement_Enum *c_51_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorItemViewItemDrop); }
static QStyle_PrimitiveElement_Enum *c_52_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelItemViewItem); }
static QStyle_PrimitiveElement_Enum *c_53_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelItemViewRow); }
static QStyle_PrimitiveElement_Enum *c_54_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelStatusBar); }
static QStyle_PrimitiveElement_Enum *c_55_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_IndicatorTabClose); }
static QStyle_PrimitiveElement_Enum *c_56_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_PanelMenu); }
static QStyle_PrimitiveElement_Enum *c_57_QStyle_PrimitiveElement_Enum () { return new QStyle_PrimitiveElement_Enum (QStyle::PE_CustomBase); }

static gsi::Methods mkdefs_QStyle_PrimitiveElement () {
  return
    gsi::constant ("PE_Q3CheckListController", &qt_gsi::c_1_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_Q3CheckListController") +
    gsi::constant ("PE_Q3CheckListExclusiveIndicator", &qt_gsi::c_2_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_Q3CheckListExclusiveIndicator") +
    gsi::constant ("PE_Q3CheckListIndicator", &qt_gsi::c_3_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_Q3CheckListIndicator") +
    gsi::constant ("PE_Q3DockWindowSeparator", &qt_gsi::c_4_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_Q3DockWindowSeparator") +
    gsi::constant ("PE_Q3Separator", &qt_gsi::c_5_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_Q3Separator") +
    gsi::constant ("PE_Frame", &qt_gsi::c_6_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_Frame") +
    gsi::constant ("PE_FrameDefaultButton", &qt_gsi::c_7_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameDefaultButton") +
    gsi::constant ("PE_FrameDockWidget", &qt_gsi::c_8_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameDockWidget") +
    gsi::constant ("PE_FrameFocusRect", &qt_gsi::c_9_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameFocusRect") +
    gsi::constant ("PE_FrameGroupBox", &qt_gsi::c_10_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameGroupBox") +
    gsi::constant ("PE_FrameLineEdit", &qt_gsi::c_11_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameLineEdit") +
    gsi::constant ("PE_FrameMenu", &qt_gsi::c_12_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameMenu") +
    gsi::constant ("PE_FrameStatusBar", &qt_gsi::c_13_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameStatusBar") +
    gsi::constant ("PE_FrameStatusBarItem", &qt_gsi::c_14_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameStatusBarItem") +
    gsi::constant ("PE_FrameTabWidget", &qt_gsi::c_15_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameTabWidget") +
    gsi::constant ("PE_FrameWindow", &qt_gsi::c_16_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameWindow") +
    gsi::constant ("PE_FrameButtonBevel", &qt_gsi::c_17_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameButtonBevel") +
    gsi::constant ("PE_FrameButtonTool", &qt_gsi::c_18_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameButtonTool") +
    gsi::constant ("PE_FrameTabBarBase", &qt_gsi::c_19_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_FrameTabBarBase") +
    gsi::constant ("PE_PanelButtonCommand", &qt_gsi::c_20_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelButtonCommand") +
    gsi::constant ("PE_PanelButtonBevel", &qt_gsi::c_21_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelButtonBevel") +
    gsi::constant ("PE_PanelButtonTool", &qt_gsi::c_22_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelButtonTool") +
    gsi::constant ("PE_PanelMenuBar", &qt_gsi::c_23_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelMenuBar") +
    gsi::constant ("PE_PanelToolBar", &qt_gsi::c_24_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelToolBar") +
    gsi::constant ("PE_PanelLineEdit", &qt_gsi::c_25_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelLineEdit") +
    gsi::constant ("PE_IndicatorArrowDown", &qt_gsi::c_26_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorArrowDown") +
    gsi::constant ("PE_IndicatorArrowLeft", &qt_gsi::c_27_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorArrowLeft") +
    gsi::constant ("PE_IndicatorArrowRight", &qt_gsi::c_28_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorArrowRight") +
    gsi::constant ("PE_IndicatorArrowUp", &qt_gsi::c_29_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorArrowUp") +
    gsi::constant ("PE_IndicatorBranch", &qt_gsi::c_30_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorBranch") +
    gsi::constant ("PE_IndicatorButtonDropDown", &qt_gsi::c_31_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorButtonDropDown") +
    gsi::constant ("PE_IndicatorViewItemCheck", &qt_gsi::c_32_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorViewItemCheck") +
    gsi::constant ("PE_IndicatorItemViewItemCheck", &qt_gsi::c_33_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorItemViewItemCheck") +
    gsi::constant ("PE_IndicatorCheckBox", &qt_gsi::c_34_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorCheckBox") +
    gsi::constant ("PE_IndicatorDockWidgetResizeHandle", &qt_gsi::c_35_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorDockWidgetResizeHandle") +
    gsi::constant ("PE_IndicatorHeaderArrow", &qt_gsi::c_36_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorHeaderArrow") +
    gsi::constant ("PE_IndicatorMenuCheckMark", &qt_gsi::c_37_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorMenuCheckMark") +
    gsi::constant ("PE_IndicatorProgressChunk", &qt_gsi::c_38_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorProgressChunk") +
    gsi::constant ("PE_IndicatorRadioButton", &qt_gsi::c_39_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorRadioButton") +
    gsi::constant ("PE_IndicatorSpinDown", &qt_gsi::c_40_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorSpinDown") +
    gsi::constant ("PE_IndicatorSpinMinus", &qt_gsi::c_41_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorSpinMinus") +
    gsi::constant ("PE_IndicatorSpinPlus", &qt_gsi::c_42_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorSpinPlus") +
    gsi::constant ("PE_IndicatorSpinUp", &qt_gsi::c_43_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorSpinUp") +
    gsi::constant ("PE_IndicatorToolBarHandle", &qt_gsi::c_44_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorToolBarHandle") +
    gsi::constant ("PE_IndicatorToolBarSeparator", &qt_gsi::c_45_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorToolBarSeparator") +
    gsi::constant ("PE_PanelTipLabel", &qt_gsi::c_46_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelTipLabel") +
    gsi::constant ("PE_IndicatorTabTear", &qt_gsi::c_47_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorTabTear") +
    gsi::constant ("PE_PanelScrollAreaCorner", &qt_gsi::c_48_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelScrollAreaCorner") +
    gsi::constant ("PE_Widget", &qt_gsi::c_49_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_Widget") +
    gsi::constant ("PE_IndicatorColumnViewArrow", &qt_gsi::c_50_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorColumnViewArrow") +
    gsi::constant ("PE_IndicatorItemViewItemDrop", &qt_gsi::c_51_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorItemViewItemDrop") +
    gsi::constant ("PE_PanelItemViewItem", &qt_gsi::c_52_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelItemViewItem") +
    gsi::constant ("PE_PanelItemViewRow", &qt_gsi::c_53_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelItemViewRow") +
    gsi::constant ("PE_PanelStatusBar", &qt_gsi::c_54_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelStatusBar") +
    gsi::constant ("PE_IndicatorTabClose", &qt_gsi::c_55_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_IndicatorTabClose") +
    gsi::constant ("PE_PanelMenu", &qt_gsi::c_56_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_PanelMenu") +
    gsi::constant ("PE_CustomBase", &qt_gsi::c_57_QStyle_PrimitiveElement_Enum, "@brief Enum constant QStyle::PE_CustomBase");
}

static std::string to_s_QStyle_PrimitiveElement_Enum (const QStyle_PrimitiveElement_Enum *e)
{
  if (e->value () == QStyle::PE_Q3CheckListController) { return tl::sprintf ("PE_Q3CheckListController (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_Q3CheckListExclusiveIndicator) { return tl::sprintf ("PE_Q3CheckListExclusiveIndicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_Q3CheckListIndicator) { return tl::sprintf ("PE_Q3CheckListIndicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_Q3DockWindowSeparator) { return tl::sprintf ("PE_Q3DockWindowSeparator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_Q3Separator) { return tl::sprintf ("PE_Q3Separator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_Frame) { return tl::sprintf ("PE_Frame (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameDefaultButton) { return tl::sprintf ("PE_FrameDefaultButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameDockWidget) { return tl::sprintf ("PE_FrameDockWidget (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameFocusRect) { return tl::sprintf ("PE_FrameFocusRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameGroupBox) { return tl::sprintf ("PE_FrameGroupBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameLineEdit) { return tl::sprintf ("PE_FrameLineEdit (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameMenu) { return tl::sprintf ("PE_FrameMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameStatusBar) { return tl::sprintf ("PE_FrameStatusBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameStatusBarItem) { return tl::sprintf ("PE_FrameStatusBarItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameTabWidget) { return tl::sprintf ("PE_FrameTabWidget (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameWindow) { return tl::sprintf ("PE_FrameWindow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameButtonBevel) { return tl::sprintf ("PE_FrameButtonBevel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameButtonTool) { return tl::sprintf ("PE_FrameButtonTool (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_FrameTabBarBase) { return tl::sprintf ("PE_FrameTabBarBase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelButtonCommand) { return tl::sprintf ("PE_PanelButtonCommand (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelButtonBevel) { return tl::sprintf ("PE_PanelButtonBevel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelButtonTool) { return tl::sprintf ("PE_PanelButtonTool (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelMenuBar) { return tl::sprintf ("PE_PanelMenuBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelToolBar) { return tl::sprintf ("PE_PanelToolBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelLineEdit) { return tl::sprintf ("PE_PanelLineEdit (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorArrowDown) { return tl::sprintf ("PE_IndicatorArrowDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorArrowLeft) { return tl::sprintf ("PE_IndicatorArrowLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorArrowRight) { return tl::sprintf ("PE_IndicatorArrowRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorArrowUp) { return tl::sprintf ("PE_IndicatorArrowUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorBranch) { return tl::sprintf ("PE_IndicatorBranch (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorButtonDropDown) { return tl::sprintf ("PE_IndicatorButtonDropDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorViewItemCheck) { return tl::sprintf ("PE_IndicatorViewItemCheck (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorItemViewItemCheck) { return tl::sprintf ("PE_IndicatorItemViewItemCheck (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorCheckBox) { return tl::sprintf ("PE_IndicatorCheckBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorDockWidgetResizeHandle) { return tl::sprintf ("PE_IndicatorDockWidgetResizeHandle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorHeaderArrow) { return tl::sprintf ("PE_IndicatorHeaderArrow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorMenuCheckMark) { return tl::sprintf ("PE_IndicatorMenuCheckMark (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorProgressChunk) { return tl::sprintf ("PE_IndicatorProgressChunk (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorRadioButton) { return tl::sprintf ("PE_IndicatorRadioButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorSpinDown) { return tl::sprintf ("PE_IndicatorSpinDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorSpinMinus) { return tl::sprintf ("PE_IndicatorSpinMinus (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorSpinPlus) { return tl::sprintf ("PE_IndicatorSpinPlus (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorSpinUp) { return tl::sprintf ("PE_IndicatorSpinUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorToolBarHandle) { return tl::sprintf ("PE_IndicatorToolBarHandle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorToolBarSeparator) { return tl::sprintf ("PE_IndicatorToolBarSeparator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelTipLabel) { return tl::sprintf ("PE_PanelTipLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorTabTear) { return tl::sprintf ("PE_IndicatorTabTear (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelScrollAreaCorner) { return tl::sprintf ("PE_PanelScrollAreaCorner (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_Widget) { return tl::sprintf ("PE_Widget (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorColumnViewArrow) { return tl::sprintf ("PE_IndicatorColumnViewArrow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorItemViewItemDrop) { return tl::sprintf ("PE_IndicatorItemViewItemDrop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelItemViewItem) { return tl::sprintf ("PE_PanelItemViewItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelItemViewRow) { return tl::sprintf ("PE_PanelItemViewRow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelStatusBar) { return tl::sprintf ("PE_PanelStatusBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_IndicatorTabClose) { return tl::sprintf ("PE_IndicatorTabClose (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_PanelMenu) { return tl::sprintf ("PE_PanelMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::PE_CustomBase) { return tl::sprintf ("PE_CustomBase (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStyle_PrimitiveElement_Enum (const QStyle_PrimitiveElement_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStyle_PrimitiveElement_Enum *from_i_QStyle_PrimitiveElement_Enum (unsigned int i)
{
  return new QStyle_PrimitiveElement_Enum ((QStyle::PrimitiveElement) i);
}

static bool equalQStyle_PrimitiveElement_Enum (const QStyle_PrimitiveElement_Enum *e, QStyle_PrimitiveElement_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStyle_PrimitiveElement_Enum (const QStyle_PrimitiveElement_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStyle_PrimitiveElement_Enums oropQStyle_PrimitiveElement_Enums (const QStyle_PrimitiveElement_Enums *e, const QStyle_PrimitiveElement_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStyle_PrimitiveElement_Enums andopQStyle_PrimitiveElement_Enums (const QStyle_PrimitiveElement_Enums *e, const QStyle_PrimitiveElement_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStyle_PrimitiveElement_Enums xoropQStyle_PrimitiveElement_Enums (const QStyle_PrimitiveElement_Enums *e, const QStyle_PrimitiveElement_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStyle_PrimitiveElement_Enums (const QStyle_PrimitiveElement_Enums *e)
{
  std::string l;
  if (e->testFlag (QStyle::PE_Q3CheckListController)) { if (!l.empty ()) l += "|"; l += "PE_Q3CheckListController"; }
  if (e->testFlag (QStyle::PE_Q3CheckListExclusiveIndicator)) { if (!l.empty ()) l += "|"; l += "PE_Q3CheckListExclusiveIndicator"; }
  if (e->testFlag (QStyle::PE_Q3CheckListIndicator)) { if (!l.empty ()) l += "|"; l += "PE_Q3CheckListIndicator"; }
  if (e->testFlag (QStyle::PE_Q3DockWindowSeparator)) { if (!l.empty ()) l += "|"; l += "PE_Q3DockWindowSeparator"; }
  if (e->testFlag (QStyle::PE_Q3Separator)) { if (!l.empty ()) l += "|"; l += "PE_Q3Separator"; }
  if (e->testFlag (QStyle::PE_Frame)) { if (!l.empty ()) l += "|"; l += "PE_Frame"; }
  if (e->testFlag (QStyle::PE_FrameDefaultButton)) { if (!l.empty ()) l += "|"; l += "PE_FrameDefaultButton"; }
  if (e->testFlag (QStyle::PE_FrameDockWidget)) { if (!l.empty ()) l += "|"; l += "PE_FrameDockWidget"; }
  if (e->testFlag (QStyle::PE_FrameFocusRect)) { if (!l.empty ()) l += "|"; l += "PE_FrameFocusRect"; }
  if (e->testFlag (QStyle::PE_FrameGroupBox)) { if (!l.empty ()) l += "|"; l += "PE_FrameGroupBox"; }
  if (e->testFlag (QStyle::PE_FrameLineEdit)) { if (!l.empty ()) l += "|"; l += "PE_FrameLineEdit"; }
  if (e->testFlag (QStyle::PE_FrameMenu)) { if (!l.empty ()) l += "|"; l += "PE_FrameMenu"; }
  if (e->testFlag (QStyle::PE_FrameStatusBar)) { if (!l.empty ()) l += "|"; l += "PE_FrameStatusBar"; }
  if (e->testFlag (QStyle::PE_FrameStatusBarItem)) { if (!l.empty ()) l += "|"; l += "PE_FrameStatusBarItem"; }
  if (e->testFlag (QStyle::PE_FrameTabWidget)) { if (!l.empty ()) l += "|"; l += "PE_FrameTabWidget"; }
  if (e->testFlag (QStyle::PE_FrameWindow)) { if (!l.empty ()) l += "|"; l += "PE_FrameWindow"; }
  if (e->testFlag (QStyle::PE_FrameButtonBevel)) { if (!l.empty ()) l += "|"; l += "PE_FrameButtonBevel"; }
  if (e->testFlag (QStyle::PE_FrameButtonTool)) { if (!l.empty ()) l += "|"; l += "PE_FrameButtonTool"; }
  if (e->testFlag (QStyle::PE_FrameTabBarBase)) { if (!l.empty ()) l += "|"; l += "PE_FrameTabBarBase"; }
  if (e->testFlag (QStyle::PE_PanelButtonCommand)) { if (!l.empty ()) l += "|"; l += "PE_PanelButtonCommand"; }
  if (e->testFlag (QStyle::PE_PanelButtonBevel)) { if (!l.empty ()) l += "|"; l += "PE_PanelButtonBevel"; }
  if (e->testFlag (QStyle::PE_PanelButtonTool)) { if (!l.empty ()) l += "|"; l += "PE_PanelButtonTool"; }
  if (e->testFlag (QStyle::PE_PanelMenuBar)) { if (!l.empty ()) l += "|"; l += "PE_PanelMenuBar"; }
  if (e->testFlag (QStyle::PE_PanelToolBar)) { if (!l.empty ()) l += "|"; l += "PE_PanelToolBar"; }
  if (e->testFlag (QStyle::PE_PanelLineEdit)) { if (!l.empty ()) l += "|"; l += "PE_PanelLineEdit"; }
  if (e->testFlag (QStyle::PE_IndicatorArrowDown)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorArrowDown"; }
  if (e->testFlag (QStyle::PE_IndicatorArrowLeft)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorArrowLeft"; }
  if (e->testFlag (QStyle::PE_IndicatorArrowRight)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorArrowRight"; }
  if (e->testFlag (QStyle::PE_IndicatorArrowUp)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorArrowUp"; }
  if (e->testFlag (QStyle::PE_IndicatorBranch)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorBranch"; }
  if (e->testFlag (QStyle::PE_IndicatorButtonDropDown)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorButtonDropDown"; }
  if (e->testFlag (QStyle::PE_IndicatorViewItemCheck)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorViewItemCheck"; }
  if (e->testFlag (QStyle::PE_IndicatorItemViewItemCheck)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorItemViewItemCheck"; }
  if (e->testFlag (QStyle::PE_IndicatorCheckBox)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorCheckBox"; }
  if (e->testFlag (QStyle::PE_IndicatorDockWidgetResizeHandle)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorDockWidgetResizeHandle"; }
  if (e->testFlag (QStyle::PE_IndicatorHeaderArrow)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorHeaderArrow"; }
  if (e->testFlag (QStyle::PE_IndicatorMenuCheckMark)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorMenuCheckMark"; }
  if (e->testFlag (QStyle::PE_IndicatorProgressChunk)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorProgressChunk"; }
  if (e->testFlag (QStyle::PE_IndicatorRadioButton)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorRadioButton"; }
  if (e->testFlag (QStyle::PE_IndicatorSpinDown)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorSpinDown"; }
  if (e->testFlag (QStyle::PE_IndicatorSpinMinus)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorSpinMinus"; }
  if (e->testFlag (QStyle::PE_IndicatorSpinPlus)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorSpinPlus"; }
  if (e->testFlag (QStyle::PE_IndicatorSpinUp)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorSpinUp"; }
  if (e->testFlag (QStyle::PE_IndicatorToolBarHandle)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorToolBarHandle"; }
  if (e->testFlag (QStyle::PE_IndicatorToolBarSeparator)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorToolBarSeparator"; }
  if (e->testFlag (QStyle::PE_PanelTipLabel)) { if (!l.empty ()) l += "|"; l += "PE_PanelTipLabel"; }
  if (e->testFlag (QStyle::PE_IndicatorTabTear)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorTabTear"; }
  if (e->testFlag (QStyle::PE_PanelScrollAreaCorner)) { if (!l.empty ()) l += "|"; l += "PE_PanelScrollAreaCorner"; }
  if (e->testFlag (QStyle::PE_Widget)) { if (!l.empty ()) l += "|"; l += "PE_Widget"; }
  if (e->testFlag (QStyle::PE_IndicatorColumnViewArrow)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorColumnViewArrow"; }
  if (e->testFlag (QStyle::PE_IndicatorItemViewItemDrop)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorItemViewItemDrop"; }
  if (e->testFlag (QStyle::PE_PanelItemViewItem)) { if (!l.empty ()) l += "|"; l += "PE_PanelItemViewItem"; }
  if (e->testFlag (QStyle::PE_PanelItemViewRow)) { if (!l.empty ()) l += "|"; l += "PE_PanelItemViewRow"; }
  if (e->testFlag (QStyle::PE_PanelStatusBar)) { if (!l.empty ()) l += "|"; l += "PE_PanelStatusBar"; }
  if (e->testFlag (QStyle::PE_IndicatorTabClose)) { if (!l.empty ()) l += "|"; l += "PE_IndicatorTabClose"; }
  if (e->testFlag (QStyle::PE_PanelMenu)) { if (!l.empty ()) l += "|"; l += "PE_PanelMenu"; }
  if (e->testFlag (QStyle::PE_CustomBase)) { if (!l.empty ()) l += "|"; l += "PE_CustomBase"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStyle_PrimitiveElement_Enums (const QStyle_PrimitiveElement_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStyle_PrimitiveElement_Enums (const QStyle_PrimitiveElement_Enums *e, const QStyle_PrimitiveElement_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStyle_PrimitiveElement_Enums> decl_QStyle_PrimitiveElement_Enums ("QStyle_QFlags_PrimitiveElement",
  gsi::method_ext ("|", &qt_gsi::oropQStyle_PrimitiveElement_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStyle_PrimitiveElement_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStyle_PrimitiveElement_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_PrimitiveElement_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_PrimitiveElement_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStyle_PrimitiveElement_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStyle::PrimitiveElement> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStyle_PrimitiveElement_Enum> decl_QStyle_PrimitiveElement_Enum (decl_QStyle_PrimitiveElement_Enums, "QStyle_PrimitiveElement",
  qt_gsi::mkdefs_QStyle_PrimitiveElement () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_PrimitiveElement_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_PrimitiveElement_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStyle_PrimitiveElement_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStyle_PrimitiveElement_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStyle_PrimitiveElement_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStyle::PrimitiveElement enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_PrimitiveElement_Enum_in_parent (qt_gsi::mkdefs_QStyle_PrimitiveElement ());
static gsi::ClassExt<QStyle> decl_QStyle_PrimitiveElement_Enum_as_child (decl_QStyle_PrimitiveElement_Enum, "PrimitiveElement");

}


//  Implementation of the enum wrapper class for QStyle::StandardPixmap
namespace qt_gsi
{

static QStyle_StandardPixmap_Enum *c_1_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_TitleBarMenuButton); }
static QStyle_StandardPixmap_Enum *c_2_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_TitleBarMinButton); }
static QStyle_StandardPixmap_Enum *c_3_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_TitleBarMaxButton); }
static QStyle_StandardPixmap_Enum *c_4_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_TitleBarCloseButton); }
static QStyle_StandardPixmap_Enum *c_5_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_TitleBarNormalButton); }
static QStyle_StandardPixmap_Enum *c_6_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_TitleBarShadeButton); }
static QStyle_StandardPixmap_Enum *c_7_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_TitleBarUnshadeButton); }
static QStyle_StandardPixmap_Enum *c_8_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_TitleBarContextHelpButton); }
static QStyle_StandardPixmap_Enum *c_9_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DockWidgetCloseButton); }
static QStyle_StandardPixmap_Enum *c_10_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MessageBoxInformation); }
static QStyle_StandardPixmap_Enum *c_11_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MessageBoxWarning); }
static QStyle_StandardPixmap_Enum *c_12_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MessageBoxCritical); }
static QStyle_StandardPixmap_Enum *c_13_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MessageBoxQuestion); }
static QStyle_StandardPixmap_Enum *c_14_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DesktopIcon); }
static QStyle_StandardPixmap_Enum *c_15_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_TrashIcon); }
static QStyle_StandardPixmap_Enum *c_16_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_ComputerIcon); }
static QStyle_StandardPixmap_Enum *c_17_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DriveFDIcon); }
static QStyle_StandardPixmap_Enum *c_18_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DriveHDIcon); }
static QStyle_StandardPixmap_Enum *c_19_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DriveCDIcon); }
static QStyle_StandardPixmap_Enum *c_20_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DriveDVDIcon); }
static QStyle_StandardPixmap_Enum *c_21_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DriveNetIcon); }
static QStyle_StandardPixmap_Enum *c_22_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DirOpenIcon); }
static QStyle_StandardPixmap_Enum *c_23_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DirClosedIcon); }
static QStyle_StandardPixmap_Enum *c_24_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DirLinkIcon); }
static QStyle_StandardPixmap_Enum *c_25_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileIcon); }
static QStyle_StandardPixmap_Enum *c_26_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileLinkIcon); }
static QStyle_StandardPixmap_Enum *c_27_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_ToolBarHorizontalExtensionButton); }
static QStyle_StandardPixmap_Enum *c_28_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_ToolBarVerticalExtensionButton); }
static QStyle_StandardPixmap_Enum *c_29_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileDialogStart); }
static QStyle_StandardPixmap_Enum *c_30_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileDialogEnd); }
static QStyle_StandardPixmap_Enum *c_31_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileDialogToParent); }
static QStyle_StandardPixmap_Enum *c_32_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileDialogNewFolder); }
static QStyle_StandardPixmap_Enum *c_33_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileDialogDetailedView); }
static QStyle_StandardPixmap_Enum *c_34_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileDialogInfoView); }
static QStyle_StandardPixmap_Enum *c_35_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileDialogContentsView); }
static QStyle_StandardPixmap_Enum *c_36_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileDialogListView); }
static QStyle_StandardPixmap_Enum *c_37_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_FileDialogBack); }
static QStyle_StandardPixmap_Enum *c_38_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DirIcon); }
static QStyle_StandardPixmap_Enum *c_39_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogOkButton); }
static QStyle_StandardPixmap_Enum *c_40_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogCancelButton); }
static QStyle_StandardPixmap_Enum *c_41_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogHelpButton); }
static QStyle_StandardPixmap_Enum *c_42_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogOpenButton); }
static QStyle_StandardPixmap_Enum *c_43_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogSaveButton); }
static QStyle_StandardPixmap_Enum *c_44_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogCloseButton); }
static QStyle_StandardPixmap_Enum *c_45_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogApplyButton); }
static QStyle_StandardPixmap_Enum *c_46_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogResetButton); }
static QStyle_StandardPixmap_Enum *c_47_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogDiscardButton); }
static QStyle_StandardPixmap_Enum *c_48_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogYesButton); }
static QStyle_StandardPixmap_Enum *c_49_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DialogNoButton); }
static QStyle_StandardPixmap_Enum *c_50_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_ArrowUp); }
static QStyle_StandardPixmap_Enum *c_51_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_ArrowDown); }
static QStyle_StandardPixmap_Enum *c_52_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_ArrowLeft); }
static QStyle_StandardPixmap_Enum *c_53_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_ArrowRight); }
static QStyle_StandardPixmap_Enum *c_54_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_ArrowBack); }
static QStyle_StandardPixmap_Enum *c_55_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_ArrowForward); }
static QStyle_StandardPixmap_Enum *c_56_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_DirHomeIcon); }
static QStyle_StandardPixmap_Enum *c_57_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_CommandLink); }
static QStyle_StandardPixmap_Enum *c_58_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_VistaShield); }
static QStyle_StandardPixmap_Enum *c_59_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_BrowserReload); }
static QStyle_StandardPixmap_Enum *c_60_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_BrowserStop); }
static QStyle_StandardPixmap_Enum *c_61_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MediaPlay); }
static QStyle_StandardPixmap_Enum *c_62_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MediaStop); }
static QStyle_StandardPixmap_Enum *c_63_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MediaPause); }
static QStyle_StandardPixmap_Enum *c_64_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MediaSkipForward); }
static QStyle_StandardPixmap_Enum *c_65_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MediaSkipBackward); }
static QStyle_StandardPixmap_Enum *c_66_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MediaSeekForward); }
static QStyle_StandardPixmap_Enum *c_67_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MediaSeekBackward); }
static QStyle_StandardPixmap_Enum *c_68_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MediaVolume); }
static QStyle_StandardPixmap_Enum *c_69_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_MediaVolumeMuted); }
static QStyle_StandardPixmap_Enum *c_70_QStyle_StandardPixmap_Enum () { return new QStyle_StandardPixmap_Enum (QStyle::SP_CustomBase); }

static gsi::Methods mkdefs_QStyle_StandardPixmap () {
  return
    gsi::constant ("SP_TitleBarMenuButton", &qt_gsi::c_1_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_TitleBarMenuButton") +
    gsi::constant ("SP_TitleBarMinButton", &qt_gsi::c_2_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_TitleBarMinButton") +
    gsi::constant ("SP_TitleBarMaxButton", &qt_gsi::c_3_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_TitleBarMaxButton") +
    gsi::constant ("SP_TitleBarCloseButton", &qt_gsi::c_4_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_TitleBarCloseButton") +
    gsi::constant ("SP_TitleBarNormalButton", &qt_gsi::c_5_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_TitleBarNormalButton") +
    gsi::constant ("SP_TitleBarShadeButton", &qt_gsi::c_6_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_TitleBarShadeButton") +
    gsi::constant ("SP_TitleBarUnshadeButton", &qt_gsi::c_7_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_TitleBarUnshadeButton") +
    gsi::constant ("SP_TitleBarContextHelpButton", &qt_gsi::c_8_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_TitleBarContextHelpButton") +
    gsi::constant ("SP_DockWidgetCloseButton", &qt_gsi::c_9_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DockWidgetCloseButton") +
    gsi::constant ("SP_MessageBoxInformation", &qt_gsi::c_10_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MessageBoxInformation") +
    gsi::constant ("SP_MessageBoxWarning", &qt_gsi::c_11_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MessageBoxWarning") +
    gsi::constant ("SP_MessageBoxCritical", &qt_gsi::c_12_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MessageBoxCritical") +
    gsi::constant ("SP_MessageBoxQuestion", &qt_gsi::c_13_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MessageBoxQuestion") +
    gsi::constant ("SP_DesktopIcon", &qt_gsi::c_14_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DesktopIcon") +
    gsi::constant ("SP_TrashIcon", &qt_gsi::c_15_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_TrashIcon") +
    gsi::constant ("SP_ComputerIcon", &qt_gsi::c_16_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_ComputerIcon") +
    gsi::constant ("SP_DriveFDIcon", &qt_gsi::c_17_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DriveFDIcon") +
    gsi::constant ("SP_DriveHDIcon", &qt_gsi::c_18_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DriveHDIcon") +
    gsi::constant ("SP_DriveCDIcon", &qt_gsi::c_19_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DriveCDIcon") +
    gsi::constant ("SP_DriveDVDIcon", &qt_gsi::c_20_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DriveDVDIcon") +
    gsi::constant ("SP_DriveNetIcon", &qt_gsi::c_21_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DriveNetIcon") +
    gsi::constant ("SP_DirOpenIcon", &qt_gsi::c_22_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DirOpenIcon") +
    gsi::constant ("SP_DirClosedIcon", &qt_gsi::c_23_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DirClosedIcon") +
    gsi::constant ("SP_DirLinkIcon", &qt_gsi::c_24_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DirLinkIcon") +
    gsi::constant ("SP_FileIcon", &qt_gsi::c_25_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileIcon") +
    gsi::constant ("SP_FileLinkIcon", &qt_gsi::c_26_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileLinkIcon") +
    gsi::constant ("SP_ToolBarHorizontalExtensionButton", &qt_gsi::c_27_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_ToolBarHorizontalExtensionButton") +
    gsi::constant ("SP_ToolBarVerticalExtensionButton", &qt_gsi::c_28_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_ToolBarVerticalExtensionButton") +
    gsi::constant ("SP_FileDialogStart", &qt_gsi::c_29_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileDialogStart") +
    gsi::constant ("SP_FileDialogEnd", &qt_gsi::c_30_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileDialogEnd") +
    gsi::constant ("SP_FileDialogToParent", &qt_gsi::c_31_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileDialogToParent") +
    gsi::constant ("SP_FileDialogNewFolder", &qt_gsi::c_32_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileDialogNewFolder") +
    gsi::constant ("SP_FileDialogDetailedView", &qt_gsi::c_33_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileDialogDetailedView") +
    gsi::constant ("SP_FileDialogInfoView", &qt_gsi::c_34_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileDialogInfoView") +
    gsi::constant ("SP_FileDialogContentsView", &qt_gsi::c_35_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileDialogContentsView") +
    gsi::constant ("SP_FileDialogListView", &qt_gsi::c_36_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileDialogListView") +
    gsi::constant ("SP_FileDialogBack", &qt_gsi::c_37_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_FileDialogBack") +
    gsi::constant ("SP_DirIcon", &qt_gsi::c_38_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DirIcon") +
    gsi::constant ("SP_DialogOkButton", &qt_gsi::c_39_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogOkButton") +
    gsi::constant ("SP_DialogCancelButton", &qt_gsi::c_40_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogCancelButton") +
    gsi::constant ("SP_DialogHelpButton", &qt_gsi::c_41_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogHelpButton") +
    gsi::constant ("SP_DialogOpenButton", &qt_gsi::c_42_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogOpenButton") +
    gsi::constant ("SP_DialogSaveButton", &qt_gsi::c_43_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogSaveButton") +
    gsi::constant ("SP_DialogCloseButton", &qt_gsi::c_44_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogCloseButton") +
    gsi::constant ("SP_DialogApplyButton", &qt_gsi::c_45_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogApplyButton") +
    gsi::constant ("SP_DialogResetButton", &qt_gsi::c_46_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogResetButton") +
    gsi::constant ("SP_DialogDiscardButton", &qt_gsi::c_47_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogDiscardButton") +
    gsi::constant ("SP_DialogYesButton", &qt_gsi::c_48_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogYesButton") +
    gsi::constant ("SP_DialogNoButton", &qt_gsi::c_49_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DialogNoButton") +
    gsi::constant ("SP_ArrowUp", &qt_gsi::c_50_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_ArrowUp") +
    gsi::constant ("SP_ArrowDown", &qt_gsi::c_51_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_ArrowDown") +
    gsi::constant ("SP_ArrowLeft", &qt_gsi::c_52_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_ArrowLeft") +
    gsi::constant ("SP_ArrowRight", &qt_gsi::c_53_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_ArrowRight") +
    gsi::constant ("SP_ArrowBack", &qt_gsi::c_54_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_ArrowBack") +
    gsi::constant ("SP_ArrowForward", &qt_gsi::c_55_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_ArrowForward") +
    gsi::constant ("SP_DirHomeIcon", &qt_gsi::c_56_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_DirHomeIcon") +
    gsi::constant ("SP_CommandLink", &qt_gsi::c_57_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_CommandLink") +
    gsi::constant ("SP_VistaShield", &qt_gsi::c_58_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_VistaShield") +
    gsi::constant ("SP_BrowserReload", &qt_gsi::c_59_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_BrowserReload") +
    gsi::constant ("SP_BrowserStop", &qt_gsi::c_60_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_BrowserStop") +
    gsi::constant ("SP_MediaPlay", &qt_gsi::c_61_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MediaPlay") +
    gsi::constant ("SP_MediaStop", &qt_gsi::c_62_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MediaStop") +
    gsi::constant ("SP_MediaPause", &qt_gsi::c_63_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MediaPause") +
    gsi::constant ("SP_MediaSkipForward", &qt_gsi::c_64_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MediaSkipForward") +
    gsi::constant ("SP_MediaSkipBackward", &qt_gsi::c_65_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MediaSkipBackward") +
    gsi::constant ("SP_MediaSeekForward", &qt_gsi::c_66_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MediaSeekForward") +
    gsi::constant ("SP_MediaSeekBackward", &qt_gsi::c_67_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MediaSeekBackward") +
    gsi::constant ("SP_MediaVolume", &qt_gsi::c_68_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MediaVolume") +
    gsi::constant ("SP_MediaVolumeMuted", &qt_gsi::c_69_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_MediaVolumeMuted") +
    gsi::constant ("SP_CustomBase", &qt_gsi::c_70_QStyle_StandardPixmap_Enum, "@brief Enum constant QStyle::SP_CustomBase");
}

static std::string to_s_QStyle_StandardPixmap_Enum (const QStyle_StandardPixmap_Enum *e)
{
  if (e->value () == QStyle::SP_TitleBarMenuButton) { return tl::sprintf ("SP_TitleBarMenuButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_TitleBarMinButton) { return tl::sprintf ("SP_TitleBarMinButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_TitleBarMaxButton) { return tl::sprintf ("SP_TitleBarMaxButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_TitleBarCloseButton) { return tl::sprintf ("SP_TitleBarCloseButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_TitleBarNormalButton) { return tl::sprintf ("SP_TitleBarNormalButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_TitleBarShadeButton) { return tl::sprintf ("SP_TitleBarShadeButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_TitleBarUnshadeButton) { return tl::sprintf ("SP_TitleBarUnshadeButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_TitleBarContextHelpButton) { return tl::sprintf ("SP_TitleBarContextHelpButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DockWidgetCloseButton) { return tl::sprintf ("SP_DockWidgetCloseButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MessageBoxInformation) { return tl::sprintf ("SP_MessageBoxInformation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MessageBoxWarning) { return tl::sprintf ("SP_MessageBoxWarning (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MessageBoxCritical) { return tl::sprintf ("SP_MessageBoxCritical (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MessageBoxQuestion) { return tl::sprintf ("SP_MessageBoxQuestion (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DesktopIcon) { return tl::sprintf ("SP_DesktopIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_TrashIcon) { return tl::sprintf ("SP_TrashIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_ComputerIcon) { return tl::sprintf ("SP_ComputerIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DriveFDIcon) { return tl::sprintf ("SP_DriveFDIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DriveHDIcon) { return tl::sprintf ("SP_DriveHDIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DriveCDIcon) { return tl::sprintf ("SP_DriveCDIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DriveDVDIcon) { return tl::sprintf ("SP_DriveDVDIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DriveNetIcon) { return tl::sprintf ("SP_DriveNetIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DirOpenIcon) { return tl::sprintf ("SP_DirOpenIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DirClosedIcon) { return tl::sprintf ("SP_DirClosedIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DirLinkIcon) { return tl::sprintf ("SP_DirLinkIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileIcon) { return tl::sprintf ("SP_FileIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileLinkIcon) { return tl::sprintf ("SP_FileLinkIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_ToolBarHorizontalExtensionButton) { return tl::sprintf ("SP_ToolBarHorizontalExtensionButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_ToolBarVerticalExtensionButton) { return tl::sprintf ("SP_ToolBarVerticalExtensionButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileDialogStart) { return tl::sprintf ("SP_FileDialogStart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileDialogEnd) { return tl::sprintf ("SP_FileDialogEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileDialogToParent) { return tl::sprintf ("SP_FileDialogToParent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileDialogNewFolder) { return tl::sprintf ("SP_FileDialogNewFolder (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileDialogDetailedView) { return tl::sprintf ("SP_FileDialogDetailedView (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileDialogInfoView) { return tl::sprintf ("SP_FileDialogInfoView (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileDialogContentsView) { return tl::sprintf ("SP_FileDialogContentsView (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileDialogListView) { return tl::sprintf ("SP_FileDialogListView (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_FileDialogBack) { return tl::sprintf ("SP_FileDialogBack (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DirIcon) { return tl::sprintf ("SP_DirIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogOkButton) { return tl::sprintf ("SP_DialogOkButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogCancelButton) { return tl::sprintf ("SP_DialogCancelButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogHelpButton) { return tl::sprintf ("SP_DialogHelpButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogOpenButton) { return tl::sprintf ("SP_DialogOpenButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogSaveButton) { return tl::sprintf ("SP_DialogSaveButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogCloseButton) { return tl::sprintf ("SP_DialogCloseButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogApplyButton) { return tl::sprintf ("SP_DialogApplyButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogResetButton) { return tl::sprintf ("SP_DialogResetButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogDiscardButton) { return tl::sprintf ("SP_DialogDiscardButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogYesButton) { return tl::sprintf ("SP_DialogYesButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DialogNoButton) { return tl::sprintf ("SP_DialogNoButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_ArrowUp) { return tl::sprintf ("SP_ArrowUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_ArrowDown) { return tl::sprintf ("SP_ArrowDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_ArrowLeft) { return tl::sprintf ("SP_ArrowLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_ArrowRight) { return tl::sprintf ("SP_ArrowRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_ArrowBack) { return tl::sprintf ("SP_ArrowBack (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_ArrowForward) { return tl::sprintf ("SP_ArrowForward (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_DirHomeIcon) { return tl::sprintf ("SP_DirHomeIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_CommandLink) { return tl::sprintf ("SP_CommandLink (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_VistaShield) { return tl::sprintf ("SP_VistaShield (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_BrowserReload) { return tl::sprintf ("SP_BrowserReload (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_BrowserStop) { return tl::sprintf ("SP_BrowserStop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MediaPlay) { return tl::sprintf ("SP_MediaPlay (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MediaStop) { return tl::sprintf ("SP_MediaStop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MediaPause) { return tl::sprintf ("SP_MediaPause (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MediaSkipForward) { return tl::sprintf ("SP_MediaSkipForward (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MediaSkipBackward) { return tl::sprintf ("SP_MediaSkipBackward (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MediaSeekForward) { return tl::sprintf ("SP_MediaSeekForward (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MediaSeekBackward) { return tl::sprintf ("SP_MediaSeekBackward (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MediaVolume) { return tl::sprintf ("SP_MediaVolume (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_MediaVolumeMuted) { return tl::sprintf ("SP_MediaVolumeMuted (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SP_CustomBase) { return tl::sprintf ("SP_CustomBase (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStyle_StandardPixmap_Enum (const QStyle_StandardPixmap_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStyle_StandardPixmap_Enum *from_i_QStyle_StandardPixmap_Enum (unsigned int i)
{
  return new QStyle_StandardPixmap_Enum ((QStyle::StandardPixmap) i);
}

static bool equalQStyle_StandardPixmap_Enum (const QStyle_StandardPixmap_Enum *e, QStyle_StandardPixmap_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStyle_StandardPixmap_Enum (const QStyle_StandardPixmap_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStyle_StandardPixmap_Enums oropQStyle_StandardPixmap_Enums (const QStyle_StandardPixmap_Enums *e, const QStyle_StandardPixmap_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStyle_StandardPixmap_Enums andopQStyle_StandardPixmap_Enums (const QStyle_StandardPixmap_Enums *e, const QStyle_StandardPixmap_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStyle_StandardPixmap_Enums xoropQStyle_StandardPixmap_Enums (const QStyle_StandardPixmap_Enums *e, const QStyle_StandardPixmap_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStyle_StandardPixmap_Enums (const QStyle_StandardPixmap_Enums *e)
{
  std::string l;
  if (e->testFlag (QStyle::SP_TitleBarMenuButton)) { if (!l.empty ()) l += "|"; l += "SP_TitleBarMenuButton"; }
  if (e->testFlag (QStyle::SP_TitleBarMinButton)) { if (!l.empty ()) l += "|"; l += "SP_TitleBarMinButton"; }
  if (e->testFlag (QStyle::SP_TitleBarMaxButton)) { if (!l.empty ()) l += "|"; l += "SP_TitleBarMaxButton"; }
  if (e->testFlag (QStyle::SP_TitleBarCloseButton)) { if (!l.empty ()) l += "|"; l += "SP_TitleBarCloseButton"; }
  if (e->testFlag (QStyle::SP_TitleBarNormalButton)) { if (!l.empty ()) l += "|"; l += "SP_TitleBarNormalButton"; }
  if (e->testFlag (QStyle::SP_TitleBarShadeButton)) { if (!l.empty ()) l += "|"; l += "SP_TitleBarShadeButton"; }
  if (e->testFlag (QStyle::SP_TitleBarUnshadeButton)) { if (!l.empty ()) l += "|"; l += "SP_TitleBarUnshadeButton"; }
  if (e->testFlag (QStyle::SP_TitleBarContextHelpButton)) { if (!l.empty ()) l += "|"; l += "SP_TitleBarContextHelpButton"; }
  if (e->testFlag (QStyle::SP_DockWidgetCloseButton)) { if (!l.empty ()) l += "|"; l += "SP_DockWidgetCloseButton"; }
  if (e->testFlag (QStyle::SP_MessageBoxInformation)) { if (!l.empty ()) l += "|"; l += "SP_MessageBoxInformation"; }
  if (e->testFlag (QStyle::SP_MessageBoxWarning)) { if (!l.empty ()) l += "|"; l += "SP_MessageBoxWarning"; }
  if (e->testFlag (QStyle::SP_MessageBoxCritical)) { if (!l.empty ()) l += "|"; l += "SP_MessageBoxCritical"; }
  if (e->testFlag (QStyle::SP_MessageBoxQuestion)) { if (!l.empty ()) l += "|"; l += "SP_MessageBoxQuestion"; }
  if (e->testFlag (QStyle::SP_DesktopIcon)) { if (!l.empty ()) l += "|"; l += "SP_DesktopIcon"; }
  if (e->testFlag (QStyle::SP_TrashIcon)) { if (!l.empty ()) l += "|"; l += "SP_TrashIcon"; }
  if (e->testFlag (QStyle::SP_ComputerIcon)) { if (!l.empty ()) l += "|"; l += "SP_ComputerIcon"; }
  if (e->testFlag (QStyle::SP_DriveFDIcon)) { if (!l.empty ()) l += "|"; l += "SP_DriveFDIcon"; }
  if (e->testFlag (QStyle::SP_DriveHDIcon)) { if (!l.empty ()) l += "|"; l += "SP_DriveHDIcon"; }
  if (e->testFlag (QStyle::SP_DriveCDIcon)) { if (!l.empty ()) l += "|"; l += "SP_DriveCDIcon"; }
  if (e->testFlag (QStyle::SP_DriveDVDIcon)) { if (!l.empty ()) l += "|"; l += "SP_DriveDVDIcon"; }
  if (e->testFlag (QStyle::SP_DriveNetIcon)) { if (!l.empty ()) l += "|"; l += "SP_DriveNetIcon"; }
  if (e->testFlag (QStyle::SP_DirOpenIcon)) { if (!l.empty ()) l += "|"; l += "SP_DirOpenIcon"; }
  if (e->testFlag (QStyle::SP_DirClosedIcon)) { if (!l.empty ()) l += "|"; l += "SP_DirClosedIcon"; }
  if (e->testFlag (QStyle::SP_DirLinkIcon)) { if (!l.empty ()) l += "|"; l += "SP_DirLinkIcon"; }
  if (e->testFlag (QStyle::SP_FileIcon)) { if (!l.empty ()) l += "|"; l += "SP_FileIcon"; }
  if (e->testFlag (QStyle::SP_FileLinkIcon)) { if (!l.empty ()) l += "|"; l += "SP_FileLinkIcon"; }
  if (e->testFlag (QStyle::SP_ToolBarHorizontalExtensionButton)) { if (!l.empty ()) l += "|"; l += "SP_ToolBarHorizontalExtensionButton"; }
  if (e->testFlag (QStyle::SP_ToolBarVerticalExtensionButton)) { if (!l.empty ()) l += "|"; l += "SP_ToolBarVerticalExtensionButton"; }
  if (e->testFlag (QStyle::SP_FileDialogStart)) { if (!l.empty ()) l += "|"; l += "SP_FileDialogStart"; }
  if (e->testFlag (QStyle::SP_FileDialogEnd)) { if (!l.empty ()) l += "|"; l += "SP_FileDialogEnd"; }
  if (e->testFlag (QStyle::SP_FileDialogToParent)) { if (!l.empty ()) l += "|"; l += "SP_FileDialogToParent"; }
  if (e->testFlag (QStyle::SP_FileDialogNewFolder)) { if (!l.empty ()) l += "|"; l += "SP_FileDialogNewFolder"; }
  if (e->testFlag (QStyle::SP_FileDialogDetailedView)) { if (!l.empty ()) l += "|"; l += "SP_FileDialogDetailedView"; }
  if (e->testFlag (QStyle::SP_FileDialogInfoView)) { if (!l.empty ()) l += "|"; l += "SP_FileDialogInfoView"; }
  if (e->testFlag (QStyle::SP_FileDialogContentsView)) { if (!l.empty ()) l += "|"; l += "SP_FileDialogContentsView"; }
  if (e->testFlag (QStyle::SP_FileDialogListView)) { if (!l.empty ()) l += "|"; l += "SP_FileDialogListView"; }
  if (e->testFlag (QStyle::SP_FileDialogBack)) { if (!l.empty ()) l += "|"; l += "SP_FileDialogBack"; }
  if (e->testFlag (QStyle::SP_DirIcon)) { if (!l.empty ()) l += "|"; l += "SP_DirIcon"; }
  if (e->testFlag (QStyle::SP_DialogOkButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogOkButton"; }
  if (e->testFlag (QStyle::SP_DialogCancelButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogCancelButton"; }
  if (e->testFlag (QStyle::SP_DialogHelpButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogHelpButton"; }
  if (e->testFlag (QStyle::SP_DialogOpenButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogOpenButton"; }
  if (e->testFlag (QStyle::SP_DialogSaveButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogSaveButton"; }
  if (e->testFlag (QStyle::SP_DialogCloseButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogCloseButton"; }
  if (e->testFlag (QStyle::SP_DialogApplyButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogApplyButton"; }
  if (e->testFlag (QStyle::SP_DialogResetButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogResetButton"; }
  if (e->testFlag (QStyle::SP_DialogDiscardButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogDiscardButton"; }
  if (e->testFlag (QStyle::SP_DialogYesButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogYesButton"; }
  if (e->testFlag (QStyle::SP_DialogNoButton)) { if (!l.empty ()) l += "|"; l += "SP_DialogNoButton"; }
  if (e->testFlag (QStyle::SP_ArrowUp)) { if (!l.empty ()) l += "|"; l += "SP_ArrowUp"; }
  if (e->testFlag (QStyle::SP_ArrowDown)) { if (!l.empty ()) l += "|"; l += "SP_ArrowDown"; }
  if (e->testFlag (QStyle::SP_ArrowLeft)) { if (!l.empty ()) l += "|"; l += "SP_ArrowLeft"; }
  if (e->testFlag (QStyle::SP_ArrowRight)) { if (!l.empty ()) l += "|"; l += "SP_ArrowRight"; }
  if (e->testFlag (QStyle::SP_ArrowBack)) { if (!l.empty ()) l += "|"; l += "SP_ArrowBack"; }
  if (e->testFlag (QStyle::SP_ArrowForward)) { if (!l.empty ()) l += "|"; l += "SP_ArrowForward"; }
  if (e->testFlag (QStyle::SP_DirHomeIcon)) { if (!l.empty ()) l += "|"; l += "SP_DirHomeIcon"; }
  if (e->testFlag (QStyle::SP_CommandLink)) { if (!l.empty ()) l += "|"; l += "SP_CommandLink"; }
  if (e->testFlag (QStyle::SP_VistaShield)) { if (!l.empty ()) l += "|"; l += "SP_VistaShield"; }
  if (e->testFlag (QStyle::SP_BrowserReload)) { if (!l.empty ()) l += "|"; l += "SP_BrowserReload"; }
  if (e->testFlag (QStyle::SP_BrowserStop)) { if (!l.empty ()) l += "|"; l += "SP_BrowserStop"; }
  if (e->testFlag (QStyle::SP_MediaPlay)) { if (!l.empty ()) l += "|"; l += "SP_MediaPlay"; }
  if (e->testFlag (QStyle::SP_MediaStop)) { if (!l.empty ()) l += "|"; l += "SP_MediaStop"; }
  if (e->testFlag (QStyle::SP_MediaPause)) { if (!l.empty ()) l += "|"; l += "SP_MediaPause"; }
  if (e->testFlag (QStyle::SP_MediaSkipForward)) { if (!l.empty ()) l += "|"; l += "SP_MediaSkipForward"; }
  if (e->testFlag (QStyle::SP_MediaSkipBackward)) { if (!l.empty ()) l += "|"; l += "SP_MediaSkipBackward"; }
  if (e->testFlag (QStyle::SP_MediaSeekForward)) { if (!l.empty ()) l += "|"; l += "SP_MediaSeekForward"; }
  if (e->testFlag (QStyle::SP_MediaSeekBackward)) { if (!l.empty ()) l += "|"; l += "SP_MediaSeekBackward"; }
  if (e->testFlag (QStyle::SP_MediaVolume)) { if (!l.empty ()) l += "|"; l += "SP_MediaVolume"; }
  if (e->testFlag (QStyle::SP_MediaVolumeMuted)) { if (!l.empty ()) l += "|"; l += "SP_MediaVolumeMuted"; }
  if (e->testFlag (QStyle::SP_CustomBase)) { if (!l.empty ()) l += "|"; l += "SP_CustomBase"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStyle_StandardPixmap_Enums (const QStyle_StandardPixmap_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStyle_StandardPixmap_Enums (const QStyle_StandardPixmap_Enums *e, const QStyle_StandardPixmap_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStyle_StandardPixmap_Enums> decl_QStyle_StandardPixmap_Enums ("QStyle_QFlags_StandardPixmap",
  gsi::method_ext ("|", &qt_gsi::oropQStyle_StandardPixmap_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStyle_StandardPixmap_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStyle_StandardPixmap_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_StandardPixmap_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_StandardPixmap_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStyle_StandardPixmap_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStyle::StandardPixmap> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStyle_StandardPixmap_Enum> decl_QStyle_StandardPixmap_Enum (decl_QStyle_StandardPixmap_Enums, "QStyle_StandardPixmap",
  qt_gsi::mkdefs_QStyle_StandardPixmap () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_StandardPixmap_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_StandardPixmap_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStyle_StandardPixmap_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStyle_StandardPixmap_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStyle_StandardPixmap_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStyle::StandardPixmap enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_StandardPixmap_Enum_in_parent (qt_gsi::mkdefs_QStyle_StandardPixmap ());
static gsi::ClassExt<QStyle> decl_QStyle_StandardPixmap_Enum_as_child (decl_QStyle_StandardPixmap_Enum, "StandardPixmap");

}


//  Implementation of the enum wrapper class for QStyle::StyleHint
namespace qt_gsi
{

static QStyle_StyleHint_Enum *c_1_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_EtchDisabledText); }
static QStyle_StyleHint_Enum *c_2_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_DitherDisabledText); }
static QStyle_StyleHint_Enum *c_3_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ScrollBar_MiddleClickAbsolutePosition); }
static QStyle_StyleHint_Enum *c_4_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ScrollBar_ScrollWhenPointerLeavesControl); }
static QStyle_StyleHint_Enum *c_5_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TabBar_SelectMouseType); }
static QStyle_StyleHint_Enum *c_6_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TabBar_Alignment); }
static QStyle_StyleHint_Enum *c_7_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Header_ArrowAlignment); }
static QStyle_StyleHint_Enum *c_8_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Slider_SnapToValue); }
static QStyle_StyleHint_Enum *c_9_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Slider_SloppyKeyEvents); }
static QStyle_StyleHint_Enum *c_10_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ProgressDialog_CenterCancelButton); }
static QStyle_StyleHint_Enum *c_11_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ProgressDialog_TextLabelAlignment); }
static QStyle_StyleHint_Enum *c_12_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_PrintDialog_RightAlignButtons); }
static QStyle_StyleHint_Enum *c_13_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_MainWindow_SpaceBelowMenuBar); }
static QStyle_StyleHint_Enum *c_14_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_FontDialog_SelectAssociatedText); }
static QStyle_StyleHint_Enum *c_15_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_AllowActiveAndDisabled); }
static QStyle_StyleHint_Enum *c_16_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_SpaceActivatesItem); }
static QStyle_StyleHint_Enum *c_17_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_SubMenuPopupDelay); }
static QStyle_StyleHint_Enum *c_18_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ScrollView_FrameOnlyAroundContents); }
static QStyle_StyleHint_Enum *c_19_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_MenuBar_AltKeyNavigation); }
static QStyle_StyleHint_Enum *c_20_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ComboBox_ListMouseTracking); }
static QStyle_StyleHint_Enum *c_21_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_MouseTracking); }
static QStyle_StyleHint_Enum *c_22_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_MenuBar_MouseTracking); }
static QStyle_StyleHint_Enum *c_23_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ItemView_ChangeHighlightOnFocus); }
static QStyle_StyleHint_Enum *c_24_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Widget_ShareActivation); }
static QStyle_StyleHint_Enum *c_25_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Workspace_FillSpaceOnMaximize); }
static QStyle_StyleHint_Enum *c_26_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ComboBox_Popup); }
static QStyle_StyleHint_Enum *c_27_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TitleBar_NoBorder); }
static QStyle_StyleHint_Enum *c_28_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Slider_StopMouseOverSlider); }
static QStyle_StyleHint_Enum *c_29_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ScrollBar_StopMouseOverSlider); }
static QStyle_StyleHint_Enum *c_30_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_BlinkCursorWhenTextSelected); }
static QStyle_StyleHint_Enum *c_31_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_RichText_FullWidthSelection); }
static QStyle_StyleHint_Enum *c_32_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_Scrollable); }
static QStyle_StyleHint_Enum *c_33_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_GroupBox_TextLabelVerticalAlignment); }
static QStyle_StyleHint_Enum *c_34_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_GroupBox_TextLabelColor); }
static QStyle_StyleHint_Enum *c_35_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_SloppySubMenus); }
static QStyle_StyleHint_Enum *c_36_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Table_GridLineColor); }
static QStyle_StyleHint_Enum *c_37_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_LineEdit_PasswordCharacter); }
static QStyle_StyleHint_Enum *c_38_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_DialogButtons_DefaultButton); }
static QStyle_StyleHint_Enum *c_39_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ToolBox_SelectedPageTitleBold); }
static QStyle_StyleHint_Enum *c_40_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TabBar_PreferNoArrows); }
static QStyle_StyleHint_Enum *c_41_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ScrollBar_LeftClickAbsolutePosition); }
static QStyle_StyleHint_Enum *c_42_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Q3ListViewExpand_SelectMouseType); }
static QStyle_StyleHint_Enum *c_43_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_UnderlineShortcut); }
static QStyle_StyleHint_Enum *c_44_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_SpinBox_AnimateButton); }
static QStyle_StyleHint_Enum *c_45_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_SpinBox_KeyPressAutoRepeatRate); }
static QStyle_StyleHint_Enum *c_46_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_SpinBox_ClickAutoRepeatRate); }
static QStyle_StyleHint_Enum *c_47_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_FillScreenWithScroll); }
static QStyle_StyleHint_Enum *c_48_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ToolTipLabel_Opacity); }
static QStyle_StyleHint_Enum *c_49_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_DrawMenuBarSeparator); }
static QStyle_StyleHint_Enum *c_50_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TitleBar_ModifyNotification); }
static QStyle_StyleHint_Enum *c_51_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Button_FocusPolicy); }
static QStyle_StyleHint_Enum *c_52_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_MenuBar_DismissOnSecondClick); }
static QStyle_StyleHint_Enum *c_53_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_MessageBox_UseBorderForButtonSpacing); }
static QStyle_StyleHint_Enum *c_54_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TitleBar_AutoRaise); }
static QStyle_StyleHint_Enum *c_55_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ToolButton_PopupDelay); }
static QStyle_StyleHint_Enum *c_56_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_FocusFrame_Mask); }
static QStyle_StyleHint_Enum *c_57_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_RubberBand_Mask); }
static QStyle_StyleHint_Enum *c_58_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_WindowFrame_Mask); }
static QStyle_StyleHint_Enum *c_59_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_SpinControls_DisableOnBounds); }
static QStyle_StyleHint_Enum *c_60_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Dial_BackgroundRole); }
static QStyle_StyleHint_Enum *c_61_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ComboBox_LayoutDirection); }
static QStyle_StyleHint_Enum *c_62_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ItemView_EllipsisLocation); }
static QStyle_StyleHint_Enum *c_63_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ItemView_ShowDecorationSelected); }
static QStyle_StyleHint_Enum *c_64_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ItemView_ActivateItemOnSingleClick); }
static QStyle_StyleHint_Enum *c_65_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ScrollBar_ContextMenu); }
static QStyle_StyleHint_Enum *c_66_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ScrollBar_RollBetweenButtons); }
static QStyle_StyleHint_Enum *c_67_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Slider_AbsoluteSetButtons); }
static QStyle_StyleHint_Enum *c_68_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Slider_PageSetButtons); }
static QStyle_StyleHint_Enum *c_69_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_KeyboardSearch); }
static QStyle_StyleHint_Enum *c_70_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TabBar_ElideMode); }
static QStyle_StyleHint_Enum *c_71_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_DialogButtonLayout); }
static QStyle_StyleHint_Enum *c_72_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ComboBox_PopupFrameStyle); }
static QStyle_StyleHint_Enum *c_73_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_MessageBox_TextInteractionFlags); }
static QStyle_StyleHint_Enum *c_74_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_DialogButtonBox_ButtonsHaveIcons); }
static QStyle_StyleHint_Enum *c_75_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_SpellCheckUnderlineStyle); }
static QStyle_StyleHint_Enum *c_76_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_MessageBox_CenterButtons); }
static QStyle_StyleHint_Enum *c_77_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_SelectionWrap); }
static QStyle_StyleHint_Enum *c_78_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ItemView_MovementWithoutUpdatingSelection); }
static QStyle_StyleHint_Enum *c_79_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ToolTip_Mask); }
static QStyle_StyleHint_Enum *c_80_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_FocusFrame_AboveWidget); }
static QStyle_StyleHint_Enum *c_81_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TextControl_FocusIndicatorTextCharFormat); }
static QStyle_StyleHint_Enum *c_82_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_WizardStyle); }
static QStyle_StyleHint_Enum *c_83_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ItemView_ArrowKeysNavigateIntoChildren); }
static QStyle_StyleHint_Enum *c_84_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_Mask); }
static QStyle_StyleHint_Enum *c_85_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_FlashTriggeredItem); }
static QStyle_StyleHint_Enum *c_86_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_Menu_FadeOutOnHide); }
static QStyle_StyleHint_Enum *c_87_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_SpinBox_ClickAutoRepeatThreshold); }
static QStyle_StyleHint_Enum *c_88_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ItemView_PaintAlternatingRowColorsForEmptyArea); }
static QStyle_StyleHint_Enum *c_89_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_FormLayoutWrapPolicy); }
static QStyle_StyleHint_Enum *c_90_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TabWidget_DefaultTabPosition); }
static QStyle_StyleHint_Enum *c_91_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ToolBar_Movable); }
static QStyle_StyleHint_Enum *c_92_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_FormLayoutFieldGrowthPolicy); }
static QStyle_StyleHint_Enum *c_93_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_FormLayoutFormAlignment); }
static QStyle_StyleHint_Enum *c_94_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_FormLayoutLabelAlignment); }
static QStyle_StyleHint_Enum *c_95_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ItemView_DrawDelegateFrame); }
static QStyle_StyleHint_Enum *c_96_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_TabBar_CloseButtonPosition); }
static QStyle_StyleHint_Enum *c_97_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_DockWidget_ButtonsHaveFrame); }
static QStyle_StyleHint_Enum *c_98_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_ToolButtonStyle); }
static QStyle_StyleHint_Enum *c_99_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_RequestSoftwareInputPanel); }
static QStyle_StyleHint_Enum *c_100_QStyle_StyleHint_Enum () { return new QStyle_StyleHint_Enum (QStyle::SH_CustomBase); }

static gsi::Methods mkdefs_QStyle_StyleHint () {
  return
    gsi::constant ("SH_EtchDisabledText", &qt_gsi::c_1_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_EtchDisabledText") +
    gsi::constant ("SH_DitherDisabledText", &qt_gsi::c_2_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_DitherDisabledText") +
    gsi::constant ("SH_ScrollBar_MiddleClickAbsolutePosition", &qt_gsi::c_3_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ScrollBar_MiddleClickAbsolutePosition") +
    gsi::constant ("SH_ScrollBar_ScrollWhenPointerLeavesControl", &qt_gsi::c_4_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ScrollBar_ScrollWhenPointerLeavesControl") +
    gsi::constant ("SH_TabBar_SelectMouseType", &qt_gsi::c_5_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TabBar_SelectMouseType") +
    gsi::constant ("SH_TabBar_Alignment", &qt_gsi::c_6_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TabBar_Alignment") +
    gsi::constant ("SH_Header_ArrowAlignment", &qt_gsi::c_7_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Header_ArrowAlignment") +
    gsi::constant ("SH_Slider_SnapToValue", &qt_gsi::c_8_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Slider_SnapToValue") +
    gsi::constant ("SH_Slider_SloppyKeyEvents", &qt_gsi::c_9_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Slider_SloppyKeyEvents") +
    gsi::constant ("SH_ProgressDialog_CenterCancelButton", &qt_gsi::c_10_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ProgressDialog_CenterCancelButton") +
    gsi::constant ("SH_ProgressDialog_TextLabelAlignment", &qt_gsi::c_11_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ProgressDialog_TextLabelAlignment") +
    gsi::constant ("SH_PrintDialog_RightAlignButtons", &qt_gsi::c_12_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_PrintDialog_RightAlignButtons") +
    gsi::constant ("SH_MainWindow_SpaceBelowMenuBar", &qt_gsi::c_13_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_MainWindow_SpaceBelowMenuBar") +
    gsi::constant ("SH_FontDialog_SelectAssociatedText", &qt_gsi::c_14_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_FontDialog_SelectAssociatedText") +
    gsi::constant ("SH_Menu_AllowActiveAndDisabled", &qt_gsi::c_15_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_AllowActiveAndDisabled") +
    gsi::constant ("SH_Menu_SpaceActivatesItem", &qt_gsi::c_16_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_SpaceActivatesItem") +
    gsi::constant ("SH_Menu_SubMenuPopupDelay", &qt_gsi::c_17_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_SubMenuPopupDelay") +
    gsi::constant ("SH_ScrollView_FrameOnlyAroundContents", &qt_gsi::c_18_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ScrollView_FrameOnlyAroundContents") +
    gsi::constant ("SH_MenuBar_AltKeyNavigation", &qt_gsi::c_19_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_MenuBar_AltKeyNavigation") +
    gsi::constant ("SH_ComboBox_ListMouseTracking", &qt_gsi::c_20_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ComboBox_ListMouseTracking") +
    gsi::constant ("SH_Menu_MouseTracking", &qt_gsi::c_21_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_MouseTracking") +
    gsi::constant ("SH_MenuBar_MouseTracking", &qt_gsi::c_22_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_MenuBar_MouseTracking") +
    gsi::constant ("SH_ItemView_ChangeHighlightOnFocus", &qt_gsi::c_23_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ItemView_ChangeHighlightOnFocus") +
    gsi::constant ("SH_Widget_ShareActivation", &qt_gsi::c_24_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Widget_ShareActivation") +
    gsi::constant ("SH_Workspace_FillSpaceOnMaximize", &qt_gsi::c_25_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Workspace_FillSpaceOnMaximize") +
    gsi::constant ("SH_ComboBox_Popup", &qt_gsi::c_26_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ComboBox_Popup") +
    gsi::constant ("SH_TitleBar_NoBorder", &qt_gsi::c_27_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TitleBar_NoBorder") +
    gsi::constant ("SH_Slider_StopMouseOverSlider", &qt_gsi::c_28_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Slider_StopMouseOverSlider") +
    gsi::constant ("SH_ScrollBar_StopMouseOverSlider", &qt_gsi::c_29_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ScrollBar_StopMouseOverSlider") +
    gsi::constant ("SH_BlinkCursorWhenTextSelected", &qt_gsi::c_30_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_BlinkCursorWhenTextSelected") +
    gsi::constant ("SH_RichText_FullWidthSelection", &qt_gsi::c_31_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_RichText_FullWidthSelection") +
    gsi::constant ("SH_Menu_Scrollable", &qt_gsi::c_32_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_Scrollable") +
    gsi::constant ("SH_GroupBox_TextLabelVerticalAlignment", &qt_gsi::c_33_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_GroupBox_TextLabelVerticalAlignment") +
    gsi::constant ("SH_GroupBox_TextLabelColor", &qt_gsi::c_34_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_GroupBox_TextLabelColor") +
    gsi::constant ("SH_Menu_SloppySubMenus", &qt_gsi::c_35_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_SloppySubMenus") +
    gsi::constant ("SH_Table_GridLineColor", &qt_gsi::c_36_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Table_GridLineColor") +
    gsi::constant ("SH_LineEdit_PasswordCharacter", &qt_gsi::c_37_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_LineEdit_PasswordCharacter") +
    gsi::constant ("SH_DialogButtons_DefaultButton", &qt_gsi::c_38_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_DialogButtons_DefaultButton") +
    gsi::constant ("SH_ToolBox_SelectedPageTitleBold", &qt_gsi::c_39_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ToolBox_SelectedPageTitleBold") +
    gsi::constant ("SH_TabBar_PreferNoArrows", &qt_gsi::c_40_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TabBar_PreferNoArrows") +
    gsi::constant ("SH_ScrollBar_LeftClickAbsolutePosition", &qt_gsi::c_41_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ScrollBar_LeftClickAbsolutePosition") +
    gsi::constant ("SH_Q3ListViewExpand_SelectMouseType", &qt_gsi::c_42_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Q3ListViewExpand_SelectMouseType") +
    gsi::constant ("SH_UnderlineShortcut", &qt_gsi::c_43_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_UnderlineShortcut") +
    gsi::constant ("SH_SpinBox_AnimateButton", &qt_gsi::c_44_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_SpinBox_AnimateButton") +
    gsi::constant ("SH_SpinBox_KeyPressAutoRepeatRate", &qt_gsi::c_45_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_SpinBox_KeyPressAutoRepeatRate") +
    gsi::constant ("SH_SpinBox_ClickAutoRepeatRate", &qt_gsi::c_46_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_SpinBox_ClickAutoRepeatRate") +
    gsi::constant ("SH_Menu_FillScreenWithScroll", &qt_gsi::c_47_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_FillScreenWithScroll") +
    gsi::constant ("SH_ToolTipLabel_Opacity", &qt_gsi::c_48_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ToolTipLabel_Opacity") +
    gsi::constant ("SH_DrawMenuBarSeparator", &qt_gsi::c_49_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_DrawMenuBarSeparator") +
    gsi::constant ("SH_TitleBar_ModifyNotification", &qt_gsi::c_50_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TitleBar_ModifyNotification") +
    gsi::constant ("SH_Button_FocusPolicy", &qt_gsi::c_51_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Button_FocusPolicy") +
    gsi::constant ("SH_MenuBar_DismissOnSecondClick", &qt_gsi::c_52_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_MenuBar_DismissOnSecondClick") +
    gsi::constant ("SH_MessageBox_UseBorderForButtonSpacing", &qt_gsi::c_53_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_MessageBox_UseBorderForButtonSpacing") +
    gsi::constant ("SH_TitleBar_AutoRaise", &qt_gsi::c_54_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TitleBar_AutoRaise") +
    gsi::constant ("SH_ToolButton_PopupDelay", &qt_gsi::c_55_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ToolButton_PopupDelay") +
    gsi::constant ("SH_FocusFrame_Mask", &qt_gsi::c_56_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_FocusFrame_Mask") +
    gsi::constant ("SH_RubberBand_Mask", &qt_gsi::c_57_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_RubberBand_Mask") +
    gsi::constant ("SH_WindowFrame_Mask", &qt_gsi::c_58_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_WindowFrame_Mask") +
    gsi::constant ("SH_SpinControls_DisableOnBounds", &qt_gsi::c_59_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_SpinControls_DisableOnBounds") +
    gsi::constant ("SH_Dial_BackgroundRole", &qt_gsi::c_60_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Dial_BackgroundRole") +
    gsi::constant ("SH_ComboBox_LayoutDirection", &qt_gsi::c_61_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ComboBox_LayoutDirection") +
    gsi::constant ("SH_ItemView_EllipsisLocation", &qt_gsi::c_62_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ItemView_EllipsisLocation") +
    gsi::constant ("SH_ItemView_ShowDecorationSelected", &qt_gsi::c_63_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ItemView_ShowDecorationSelected") +
    gsi::constant ("SH_ItemView_ActivateItemOnSingleClick", &qt_gsi::c_64_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ItemView_ActivateItemOnSingleClick") +
    gsi::constant ("SH_ScrollBar_ContextMenu", &qt_gsi::c_65_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ScrollBar_ContextMenu") +
    gsi::constant ("SH_ScrollBar_RollBetweenButtons", &qt_gsi::c_66_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ScrollBar_RollBetweenButtons") +
    gsi::constant ("SH_Slider_AbsoluteSetButtons", &qt_gsi::c_67_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Slider_AbsoluteSetButtons") +
    gsi::constant ("SH_Slider_PageSetButtons", &qt_gsi::c_68_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Slider_PageSetButtons") +
    gsi::constant ("SH_Menu_KeyboardSearch", &qt_gsi::c_69_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_KeyboardSearch") +
    gsi::constant ("SH_TabBar_ElideMode", &qt_gsi::c_70_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TabBar_ElideMode") +
    gsi::constant ("SH_DialogButtonLayout", &qt_gsi::c_71_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_DialogButtonLayout") +
    gsi::constant ("SH_ComboBox_PopupFrameStyle", &qt_gsi::c_72_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ComboBox_PopupFrameStyle") +
    gsi::constant ("SH_MessageBox_TextInteractionFlags", &qt_gsi::c_73_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_MessageBox_TextInteractionFlags") +
    gsi::constant ("SH_DialogButtonBox_ButtonsHaveIcons", &qt_gsi::c_74_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_DialogButtonBox_ButtonsHaveIcons") +
    gsi::constant ("SH_SpellCheckUnderlineStyle", &qt_gsi::c_75_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_SpellCheckUnderlineStyle") +
    gsi::constant ("SH_MessageBox_CenterButtons", &qt_gsi::c_76_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_MessageBox_CenterButtons") +
    gsi::constant ("SH_Menu_SelectionWrap", &qt_gsi::c_77_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_SelectionWrap") +
    gsi::constant ("SH_ItemView_MovementWithoutUpdatingSelection", &qt_gsi::c_78_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ItemView_MovementWithoutUpdatingSelection") +
    gsi::constant ("SH_ToolTip_Mask", &qt_gsi::c_79_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ToolTip_Mask") +
    gsi::constant ("SH_FocusFrame_AboveWidget", &qt_gsi::c_80_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_FocusFrame_AboveWidget") +
    gsi::constant ("SH_TextControl_FocusIndicatorTextCharFormat", &qt_gsi::c_81_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TextControl_FocusIndicatorTextCharFormat") +
    gsi::constant ("SH_WizardStyle", &qt_gsi::c_82_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_WizardStyle") +
    gsi::constant ("SH_ItemView_ArrowKeysNavigateIntoChildren", &qt_gsi::c_83_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ItemView_ArrowKeysNavigateIntoChildren") +
    gsi::constant ("SH_Menu_Mask", &qt_gsi::c_84_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_Mask") +
    gsi::constant ("SH_Menu_FlashTriggeredItem", &qt_gsi::c_85_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_FlashTriggeredItem") +
    gsi::constant ("SH_Menu_FadeOutOnHide", &qt_gsi::c_86_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_Menu_FadeOutOnHide") +
    gsi::constant ("SH_SpinBox_ClickAutoRepeatThreshold", &qt_gsi::c_87_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_SpinBox_ClickAutoRepeatThreshold") +
    gsi::constant ("SH_ItemView_PaintAlternatingRowColorsForEmptyArea", &qt_gsi::c_88_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ItemView_PaintAlternatingRowColorsForEmptyArea") +
    gsi::constant ("SH_FormLayoutWrapPolicy", &qt_gsi::c_89_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_FormLayoutWrapPolicy") +
    gsi::constant ("SH_TabWidget_DefaultTabPosition", &qt_gsi::c_90_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TabWidget_DefaultTabPosition") +
    gsi::constant ("SH_ToolBar_Movable", &qt_gsi::c_91_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ToolBar_Movable") +
    gsi::constant ("SH_FormLayoutFieldGrowthPolicy", &qt_gsi::c_92_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_FormLayoutFieldGrowthPolicy") +
    gsi::constant ("SH_FormLayoutFormAlignment", &qt_gsi::c_93_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_FormLayoutFormAlignment") +
    gsi::constant ("SH_FormLayoutLabelAlignment", &qt_gsi::c_94_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_FormLayoutLabelAlignment") +
    gsi::constant ("SH_ItemView_DrawDelegateFrame", &qt_gsi::c_95_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ItemView_DrawDelegateFrame") +
    gsi::constant ("SH_TabBar_CloseButtonPosition", &qt_gsi::c_96_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_TabBar_CloseButtonPosition") +
    gsi::constant ("SH_DockWidget_ButtonsHaveFrame", &qt_gsi::c_97_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_DockWidget_ButtonsHaveFrame") +
    gsi::constant ("SH_ToolButtonStyle", &qt_gsi::c_98_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_ToolButtonStyle") +
    gsi::constant ("SH_RequestSoftwareInputPanel", &qt_gsi::c_99_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_RequestSoftwareInputPanel") +
    gsi::constant ("SH_CustomBase", &qt_gsi::c_100_QStyle_StyleHint_Enum, "@brief Enum constant QStyle::SH_CustomBase");
}

static std::string to_s_QStyle_StyleHint_Enum (const QStyle_StyleHint_Enum *e)
{
  if (e->value () == QStyle::SH_EtchDisabledText) { return tl::sprintf ("SH_EtchDisabledText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_DitherDisabledText) { return tl::sprintf ("SH_DitherDisabledText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ScrollBar_MiddleClickAbsolutePosition) { return tl::sprintf ("SH_ScrollBar_MiddleClickAbsolutePosition (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ScrollBar_ScrollWhenPointerLeavesControl) { return tl::sprintf ("SH_ScrollBar_ScrollWhenPointerLeavesControl (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TabBar_SelectMouseType) { return tl::sprintf ("SH_TabBar_SelectMouseType (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TabBar_Alignment) { return tl::sprintf ("SH_TabBar_Alignment (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Header_ArrowAlignment) { return tl::sprintf ("SH_Header_ArrowAlignment (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Slider_SnapToValue) { return tl::sprintf ("SH_Slider_SnapToValue (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Slider_SloppyKeyEvents) { return tl::sprintf ("SH_Slider_SloppyKeyEvents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ProgressDialog_CenterCancelButton) { return tl::sprintf ("SH_ProgressDialog_CenterCancelButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ProgressDialog_TextLabelAlignment) { return tl::sprintf ("SH_ProgressDialog_TextLabelAlignment (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_PrintDialog_RightAlignButtons) { return tl::sprintf ("SH_PrintDialog_RightAlignButtons (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_MainWindow_SpaceBelowMenuBar) { return tl::sprintf ("SH_MainWindow_SpaceBelowMenuBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_FontDialog_SelectAssociatedText) { return tl::sprintf ("SH_FontDialog_SelectAssociatedText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_AllowActiveAndDisabled) { return tl::sprintf ("SH_Menu_AllowActiveAndDisabled (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_SpaceActivatesItem) { return tl::sprintf ("SH_Menu_SpaceActivatesItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_SubMenuPopupDelay) { return tl::sprintf ("SH_Menu_SubMenuPopupDelay (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ScrollView_FrameOnlyAroundContents) { return tl::sprintf ("SH_ScrollView_FrameOnlyAroundContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_MenuBar_AltKeyNavigation) { return tl::sprintf ("SH_MenuBar_AltKeyNavigation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ComboBox_ListMouseTracking) { return tl::sprintf ("SH_ComboBox_ListMouseTracking (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_MouseTracking) { return tl::sprintf ("SH_Menu_MouseTracking (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_MenuBar_MouseTracking) { return tl::sprintf ("SH_MenuBar_MouseTracking (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ItemView_ChangeHighlightOnFocus) { return tl::sprintf ("SH_ItemView_ChangeHighlightOnFocus (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Widget_ShareActivation) { return tl::sprintf ("SH_Widget_ShareActivation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Workspace_FillSpaceOnMaximize) { return tl::sprintf ("SH_Workspace_FillSpaceOnMaximize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ComboBox_Popup) { return tl::sprintf ("SH_ComboBox_Popup (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TitleBar_NoBorder) { return tl::sprintf ("SH_TitleBar_NoBorder (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Slider_StopMouseOverSlider) { return tl::sprintf ("SH_Slider_StopMouseOverSlider (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ScrollBar_StopMouseOverSlider) { return tl::sprintf ("SH_ScrollBar_StopMouseOverSlider (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_BlinkCursorWhenTextSelected) { return tl::sprintf ("SH_BlinkCursorWhenTextSelected (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_RichText_FullWidthSelection) { return tl::sprintf ("SH_RichText_FullWidthSelection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_Scrollable) { return tl::sprintf ("SH_Menu_Scrollable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_GroupBox_TextLabelVerticalAlignment) { return tl::sprintf ("SH_GroupBox_TextLabelVerticalAlignment (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_GroupBox_TextLabelColor) { return tl::sprintf ("SH_GroupBox_TextLabelColor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_SloppySubMenus) { return tl::sprintf ("SH_Menu_SloppySubMenus (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Table_GridLineColor) { return tl::sprintf ("SH_Table_GridLineColor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_LineEdit_PasswordCharacter) { return tl::sprintf ("SH_LineEdit_PasswordCharacter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_DialogButtons_DefaultButton) { return tl::sprintf ("SH_DialogButtons_DefaultButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ToolBox_SelectedPageTitleBold) { return tl::sprintf ("SH_ToolBox_SelectedPageTitleBold (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TabBar_PreferNoArrows) { return tl::sprintf ("SH_TabBar_PreferNoArrows (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ScrollBar_LeftClickAbsolutePosition) { return tl::sprintf ("SH_ScrollBar_LeftClickAbsolutePosition (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Q3ListViewExpand_SelectMouseType) { return tl::sprintf ("SH_Q3ListViewExpand_SelectMouseType (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_UnderlineShortcut) { return tl::sprintf ("SH_UnderlineShortcut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_SpinBox_AnimateButton) { return tl::sprintf ("SH_SpinBox_AnimateButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_SpinBox_KeyPressAutoRepeatRate) { return tl::sprintf ("SH_SpinBox_KeyPressAutoRepeatRate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_SpinBox_ClickAutoRepeatRate) { return tl::sprintf ("SH_SpinBox_ClickAutoRepeatRate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_FillScreenWithScroll) { return tl::sprintf ("SH_Menu_FillScreenWithScroll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ToolTipLabel_Opacity) { return tl::sprintf ("SH_ToolTipLabel_Opacity (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_DrawMenuBarSeparator) { return tl::sprintf ("SH_DrawMenuBarSeparator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TitleBar_ModifyNotification) { return tl::sprintf ("SH_TitleBar_ModifyNotification (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Button_FocusPolicy) { return tl::sprintf ("SH_Button_FocusPolicy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_MenuBar_DismissOnSecondClick) { return tl::sprintf ("SH_MenuBar_DismissOnSecondClick (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_MessageBox_UseBorderForButtonSpacing) { return tl::sprintf ("SH_MessageBox_UseBorderForButtonSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TitleBar_AutoRaise) { return tl::sprintf ("SH_TitleBar_AutoRaise (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ToolButton_PopupDelay) { return tl::sprintf ("SH_ToolButton_PopupDelay (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_FocusFrame_Mask) { return tl::sprintf ("SH_FocusFrame_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_RubberBand_Mask) { return tl::sprintf ("SH_RubberBand_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_WindowFrame_Mask) { return tl::sprintf ("SH_WindowFrame_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_SpinControls_DisableOnBounds) { return tl::sprintf ("SH_SpinControls_DisableOnBounds (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Dial_BackgroundRole) { return tl::sprintf ("SH_Dial_BackgroundRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ComboBox_LayoutDirection) { return tl::sprintf ("SH_ComboBox_LayoutDirection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ItemView_EllipsisLocation) { return tl::sprintf ("SH_ItemView_EllipsisLocation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ItemView_ShowDecorationSelected) { return tl::sprintf ("SH_ItemView_ShowDecorationSelected (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ItemView_ActivateItemOnSingleClick) { return tl::sprintf ("SH_ItemView_ActivateItemOnSingleClick (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ScrollBar_ContextMenu) { return tl::sprintf ("SH_ScrollBar_ContextMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ScrollBar_RollBetweenButtons) { return tl::sprintf ("SH_ScrollBar_RollBetweenButtons (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Slider_AbsoluteSetButtons) { return tl::sprintf ("SH_Slider_AbsoluteSetButtons (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Slider_PageSetButtons) { return tl::sprintf ("SH_Slider_PageSetButtons (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_KeyboardSearch) { return tl::sprintf ("SH_Menu_KeyboardSearch (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TabBar_ElideMode) { return tl::sprintf ("SH_TabBar_ElideMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_DialogButtonLayout) { return tl::sprintf ("SH_DialogButtonLayout (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ComboBox_PopupFrameStyle) { return tl::sprintf ("SH_ComboBox_PopupFrameStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_MessageBox_TextInteractionFlags) { return tl::sprintf ("SH_MessageBox_TextInteractionFlags (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_DialogButtonBox_ButtonsHaveIcons) { return tl::sprintf ("SH_DialogButtonBox_ButtonsHaveIcons (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_SpellCheckUnderlineStyle) { return tl::sprintf ("SH_SpellCheckUnderlineStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_MessageBox_CenterButtons) { return tl::sprintf ("SH_MessageBox_CenterButtons (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_SelectionWrap) { return tl::sprintf ("SH_Menu_SelectionWrap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ItemView_MovementWithoutUpdatingSelection) { return tl::sprintf ("SH_ItemView_MovementWithoutUpdatingSelection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ToolTip_Mask) { return tl::sprintf ("SH_ToolTip_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_FocusFrame_AboveWidget) { return tl::sprintf ("SH_FocusFrame_AboveWidget (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TextControl_FocusIndicatorTextCharFormat) { return tl::sprintf ("SH_TextControl_FocusIndicatorTextCharFormat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_WizardStyle) { return tl::sprintf ("SH_WizardStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ItemView_ArrowKeysNavigateIntoChildren) { return tl::sprintf ("SH_ItemView_ArrowKeysNavigateIntoChildren (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_Mask) { return tl::sprintf ("SH_Menu_Mask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_FlashTriggeredItem) { return tl::sprintf ("SH_Menu_FlashTriggeredItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_Menu_FadeOutOnHide) { return tl::sprintf ("SH_Menu_FadeOutOnHide (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_SpinBox_ClickAutoRepeatThreshold) { return tl::sprintf ("SH_SpinBox_ClickAutoRepeatThreshold (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ItemView_PaintAlternatingRowColorsForEmptyArea) { return tl::sprintf ("SH_ItemView_PaintAlternatingRowColorsForEmptyArea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_FormLayoutWrapPolicy) { return tl::sprintf ("SH_FormLayoutWrapPolicy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TabWidget_DefaultTabPosition) { return tl::sprintf ("SH_TabWidget_DefaultTabPosition (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ToolBar_Movable) { return tl::sprintf ("SH_ToolBar_Movable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_FormLayoutFieldGrowthPolicy) { return tl::sprintf ("SH_FormLayoutFieldGrowthPolicy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_FormLayoutFormAlignment) { return tl::sprintf ("SH_FormLayoutFormAlignment (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_FormLayoutLabelAlignment) { return tl::sprintf ("SH_FormLayoutLabelAlignment (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ItemView_DrawDelegateFrame) { return tl::sprintf ("SH_ItemView_DrawDelegateFrame (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_TabBar_CloseButtonPosition) { return tl::sprintf ("SH_TabBar_CloseButtonPosition (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_DockWidget_ButtonsHaveFrame) { return tl::sprintf ("SH_DockWidget_ButtonsHaveFrame (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_ToolButtonStyle) { return tl::sprintf ("SH_ToolButtonStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_RequestSoftwareInputPanel) { return tl::sprintf ("SH_RequestSoftwareInputPanel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SH_CustomBase) { return tl::sprintf ("SH_CustomBase (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStyle_StyleHint_Enum (const QStyle_StyleHint_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStyle_StyleHint_Enum *from_i_QStyle_StyleHint_Enum (unsigned int i)
{
  return new QStyle_StyleHint_Enum ((QStyle::StyleHint) i);
}

static bool equalQStyle_StyleHint_Enum (const QStyle_StyleHint_Enum *e, QStyle_StyleHint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStyle_StyleHint_Enum (const QStyle_StyleHint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStyle_StyleHint_Enums oropQStyle_StyleHint_Enums (const QStyle_StyleHint_Enums *e, const QStyle_StyleHint_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStyle_StyleHint_Enums andopQStyle_StyleHint_Enums (const QStyle_StyleHint_Enums *e, const QStyle_StyleHint_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStyle_StyleHint_Enums xoropQStyle_StyleHint_Enums (const QStyle_StyleHint_Enums *e, const QStyle_StyleHint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStyle_StyleHint_Enums (const QStyle_StyleHint_Enums *e)
{
  std::string l;
  if (e->testFlag (QStyle::SH_EtchDisabledText)) { if (!l.empty ()) l += "|"; l += "SH_EtchDisabledText"; }
  if (e->testFlag (QStyle::SH_DitherDisabledText)) { if (!l.empty ()) l += "|"; l += "SH_DitherDisabledText"; }
  if (e->testFlag (QStyle::SH_ScrollBar_MiddleClickAbsolutePosition)) { if (!l.empty ()) l += "|"; l += "SH_ScrollBar_MiddleClickAbsolutePosition"; }
  if (e->testFlag (QStyle::SH_ScrollBar_ScrollWhenPointerLeavesControl)) { if (!l.empty ()) l += "|"; l += "SH_ScrollBar_ScrollWhenPointerLeavesControl"; }
  if (e->testFlag (QStyle::SH_TabBar_SelectMouseType)) { if (!l.empty ()) l += "|"; l += "SH_TabBar_SelectMouseType"; }
  if (e->testFlag (QStyle::SH_TabBar_Alignment)) { if (!l.empty ()) l += "|"; l += "SH_TabBar_Alignment"; }
  if (e->testFlag (QStyle::SH_Header_ArrowAlignment)) { if (!l.empty ()) l += "|"; l += "SH_Header_ArrowAlignment"; }
  if (e->testFlag (QStyle::SH_Slider_SnapToValue)) { if (!l.empty ()) l += "|"; l += "SH_Slider_SnapToValue"; }
  if (e->testFlag (QStyle::SH_Slider_SloppyKeyEvents)) { if (!l.empty ()) l += "|"; l += "SH_Slider_SloppyKeyEvents"; }
  if (e->testFlag (QStyle::SH_ProgressDialog_CenterCancelButton)) { if (!l.empty ()) l += "|"; l += "SH_ProgressDialog_CenterCancelButton"; }
  if (e->testFlag (QStyle::SH_ProgressDialog_TextLabelAlignment)) { if (!l.empty ()) l += "|"; l += "SH_ProgressDialog_TextLabelAlignment"; }
  if (e->testFlag (QStyle::SH_PrintDialog_RightAlignButtons)) { if (!l.empty ()) l += "|"; l += "SH_PrintDialog_RightAlignButtons"; }
  if (e->testFlag (QStyle::SH_MainWindow_SpaceBelowMenuBar)) { if (!l.empty ()) l += "|"; l += "SH_MainWindow_SpaceBelowMenuBar"; }
  if (e->testFlag (QStyle::SH_FontDialog_SelectAssociatedText)) { if (!l.empty ()) l += "|"; l += "SH_FontDialog_SelectAssociatedText"; }
  if (e->testFlag (QStyle::SH_Menu_AllowActiveAndDisabled)) { if (!l.empty ()) l += "|"; l += "SH_Menu_AllowActiveAndDisabled"; }
  if (e->testFlag (QStyle::SH_Menu_SpaceActivatesItem)) { if (!l.empty ()) l += "|"; l += "SH_Menu_SpaceActivatesItem"; }
  if (e->testFlag (QStyle::SH_Menu_SubMenuPopupDelay)) { if (!l.empty ()) l += "|"; l += "SH_Menu_SubMenuPopupDelay"; }
  if (e->testFlag (QStyle::SH_ScrollView_FrameOnlyAroundContents)) { if (!l.empty ()) l += "|"; l += "SH_ScrollView_FrameOnlyAroundContents"; }
  if (e->testFlag (QStyle::SH_MenuBar_AltKeyNavigation)) { if (!l.empty ()) l += "|"; l += "SH_MenuBar_AltKeyNavigation"; }
  if (e->testFlag (QStyle::SH_ComboBox_ListMouseTracking)) { if (!l.empty ()) l += "|"; l += "SH_ComboBox_ListMouseTracking"; }
  if (e->testFlag (QStyle::SH_Menu_MouseTracking)) { if (!l.empty ()) l += "|"; l += "SH_Menu_MouseTracking"; }
  if (e->testFlag (QStyle::SH_MenuBar_MouseTracking)) { if (!l.empty ()) l += "|"; l += "SH_MenuBar_MouseTracking"; }
  if (e->testFlag (QStyle::SH_ItemView_ChangeHighlightOnFocus)) { if (!l.empty ()) l += "|"; l += "SH_ItemView_ChangeHighlightOnFocus"; }
  if (e->testFlag (QStyle::SH_Widget_ShareActivation)) { if (!l.empty ()) l += "|"; l += "SH_Widget_ShareActivation"; }
  if (e->testFlag (QStyle::SH_Workspace_FillSpaceOnMaximize)) { if (!l.empty ()) l += "|"; l += "SH_Workspace_FillSpaceOnMaximize"; }
  if (e->testFlag (QStyle::SH_ComboBox_Popup)) { if (!l.empty ()) l += "|"; l += "SH_ComboBox_Popup"; }
  if (e->testFlag (QStyle::SH_TitleBar_NoBorder)) { if (!l.empty ()) l += "|"; l += "SH_TitleBar_NoBorder"; }
  if (e->testFlag (QStyle::SH_Slider_StopMouseOverSlider)) { if (!l.empty ()) l += "|"; l += "SH_Slider_StopMouseOverSlider"; }
  if (e->testFlag (QStyle::SH_ScrollBar_StopMouseOverSlider)) { if (!l.empty ()) l += "|"; l += "SH_ScrollBar_StopMouseOverSlider"; }
  if (e->testFlag (QStyle::SH_BlinkCursorWhenTextSelected)) { if (!l.empty ()) l += "|"; l += "SH_BlinkCursorWhenTextSelected"; }
  if (e->testFlag (QStyle::SH_RichText_FullWidthSelection)) { if (!l.empty ()) l += "|"; l += "SH_RichText_FullWidthSelection"; }
  if (e->testFlag (QStyle::SH_Menu_Scrollable)) { if (!l.empty ()) l += "|"; l += "SH_Menu_Scrollable"; }
  if (e->testFlag (QStyle::SH_GroupBox_TextLabelVerticalAlignment)) { if (!l.empty ()) l += "|"; l += "SH_GroupBox_TextLabelVerticalAlignment"; }
  if (e->testFlag (QStyle::SH_GroupBox_TextLabelColor)) { if (!l.empty ()) l += "|"; l += "SH_GroupBox_TextLabelColor"; }
  if (e->testFlag (QStyle::SH_Menu_SloppySubMenus)) { if (!l.empty ()) l += "|"; l += "SH_Menu_SloppySubMenus"; }
  if (e->testFlag (QStyle::SH_Table_GridLineColor)) { if (!l.empty ()) l += "|"; l += "SH_Table_GridLineColor"; }
  if (e->testFlag (QStyle::SH_LineEdit_PasswordCharacter)) { if (!l.empty ()) l += "|"; l += "SH_LineEdit_PasswordCharacter"; }
  if (e->testFlag (QStyle::SH_DialogButtons_DefaultButton)) { if (!l.empty ()) l += "|"; l += "SH_DialogButtons_DefaultButton"; }
  if (e->testFlag (QStyle::SH_ToolBox_SelectedPageTitleBold)) { if (!l.empty ()) l += "|"; l += "SH_ToolBox_SelectedPageTitleBold"; }
  if (e->testFlag (QStyle::SH_TabBar_PreferNoArrows)) { if (!l.empty ()) l += "|"; l += "SH_TabBar_PreferNoArrows"; }
  if (e->testFlag (QStyle::SH_ScrollBar_LeftClickAbsolutePosition)) { if (!l.empty ()) l += "|"; l += "SH_ScrollBar_LeftClickAbsolutePosition"; }
  if (e->testFlag (QStyle::SH_Q3ListViewExpand_SelectMouseType)) { if (!l.empty ()) l += "|"; l += "SH_Q3ListViewExpand_SelectMouseType"; }
  if (e->testFlag (QStyle::SH_UnderlineShortcut)) { if (!l.empty ()) l += "|"; l += "SH_UnderlineShortcut"; }
  if (e->testFlag (QStyle::SH_SpinBox_AnimateButton)) { if (!l.empty ()) l += "|"; l += "SH_SpinBox_AnimateButton"; }
  if (e->testFlag (QStyle::SH_SpinBox_KeyPressAutoRepeatRate)) { if (!l.empty ()) l += "|"; l += "SH_SpinBox_KeyPressAutoRepeatRate"; }
  if (e->testFlag (QStyle::SH_SpinBox_ClickAutoRepeatRate)) { if (!l.empty ()) l += "|"; l += "SH_SpinBox_ClickAutoRepeatRate"; }
  if (e->testFlag (QStyle::SH_Menu_FillScreenWithScroll)) { if (!l.empty ()) l += "|"; l += "SH_Menu_FillScreenWithScroll"; }
  if (e->testFlag (QStyle::SH_ToolTipLabel_Opacity)) { if (!l.empty ()) l += "|"; l += "SH_ToolTipLabel_Opacity"; }
  if (e->testFlag (QStyle::SH_DrawMenuBarSeparator)) { if (!l.empty ()) l += "|"; l += "SH_DrawMenuBarSeparator"; }
  if (e->testFlag (QStyle::SH_TitleBar_ModifyNotification)) { if (!l.empty ()) l += "|"; l += "SH_TitleBar_ModifyNotification"; }
  if (e->testFlag (QStyle::SH_Button_FocusPolicy)) { if (!l.empty ()) l += "|"; l += "SH_Button_FocusPolicy"; }
  if (e->testFlag (QStyle::SH_MenuBar_DismissOnSecondClick)) { if (!l.empty ()) l += "|"; l += "SH_MenuBar_DismissOnSecondClick"; }
  if (e->testFlag (QStyle::SH_MessageBox_UseBorderForButtonSpacing)) { if (!l.empty ()) l += "|"; l += "SH_MessageBox_UseBorderForButtonSpacing"; }
  if (e->testFlag (QStyle::SH_TitleBar_AutoRaise)) { if (!l.empty ()) l += "|"; l += "SH_TitleBar_AutoRaise"; }
  if (e->testFlag (QStyle::SH_ToolButton_PopupDelay)) { if (!l.empty ()) l += "|"; l += "SH_ToolButton_PopupDelay"; }
  if (e->testFlag (QStyle::SH_FocusFrame_Mask)) { if (!l.empty ()) l += "|"; l += "SH_FocusFrame_Mask"; }
  if (e->testFlag (QStyle::SH_RubberBand_Mask)) { if (!l.empty ()) l += "|"; l += "SH_RubberBand_Mask"; }
  if (e->testFlag (QStyle::SH_WindowFrame_Mask)) { if (!l.empty ()) l += "|"; l += "SH_WindowFrame_Mask"; }
  if (e->testFlag (QStyle::SH_SpinControls_DisableOnBounds)) { if (!l.empty ()) l += "|"; l += "SH_SpinControls_DisableOnBounds"; }
  if (e->testFlag (QStyle::SH_Dial_BackgroundRole)) { if (!l.empty ()) l += "|"; l += "SH_Dial_BackgroundRole"; }
  if (e->testFlag (QStyle::SH_ComboBox_LayoutDirection)) { if (!l.empty ()) l += "|"; l += "SH_ComboBox_LayoutDirection"; }
  if (e->testFlag (QStyle::SH_ItemView_EllipsisLocation)) { if (!l.empty ()) l += "|"; l += "SH_ItemView_EllipsisLocation"; }
  if (e->testFlag (QStyle::SH_ItemView_ShowDecorationSelected)) { if (!l.empty ()) l += "|"; l += "SH_ItemView_ShowDecorationSelected"; }
  if (e->testFlag (QStyle::SH_ItemView_ActivateItemOnSingleClick)) { if (!l.empty ()) l += "|"; l += "SH_ItemView_ActivateItemOnSingleClick"; }
  if (e->testFlag (QStyle::SH_ScrollBar_ContextMenu)) { if (!l.empty ()) l += "|"; l += "SH_ScrollBar_ContextMenu"; }
  if (e->testFlag (QStyle::SH_ScrollBar_RollBetweenButtons)) { if (!l.empty ()) l += "|"; l += "SH_ScrollBar_RollBetweenButtons"; }
  if (e->testFlag (QStyle::SH_Slider_AbsoluteSetButtons)) { if (!l.empty ()) l += "|"; l += "SH_Slider_AbsoluteSetButtons"; }
  if (e->testFlag (QStyle::SH_Slider_PageSetButtons)) { if (!l.empty ()) l += "|"; l += "SH_Slider_PageSetButtons"; }
  if (e->testFlag (QStyle::SH_Menu_KeyboardSearch)) { if (!l.empty ()) l += "|"; l += "SH_Menu_KeyboardSearch"; }
  if (e->testFlag (QStyle::SH_TabBar_ElideMode)) { if (!l.empty ()) l += "|"; l += "SH_TabBar_ElideMode"; }
  if (e->testFlag (QStyle::SH_DialogButtonLayout)) { if (!l.empty ()) l += "|"; l += "SH_DialogButtonLayout"; }
  if (e->testFlag (QStyle::SH_ComboBox_PopupFrameStyle)) { if (!l.empty ()) l += "|"; l += "SH_ComboBox_PopupFrameStyle"; }
  if (e->testFlag (QStyle::SH_MessageBox_TextInteractionFlags)) { if (!l.empty ()) l += "|"; l += "SH_MessageBox_TextInteractionFlags"; }
  if (e->testFlag (QStyle::SH_DialogButtonBox_ButtonsHaveIcons)) { if (!l.empty ()) l += "|"; l += "SH_DialogButtonBox_ButtonsHaveIcons"; }
  if (e->testFlag (QStyle::SH_SpellCheckUnderlineStyle)) { if (!l.empty ()) l += "|"; l += "SH_SpellCheckUnderlineStyle"; }
  if (e->testFlag (QStyle::SH_MessageBox_CenterButtons)) { if (!l.empty ()) l += "|"; l += "SH_MessageBox_CenterButtons"; }
  if (e->testFlag (QStyle::SH_Menu_SelectionWrap)) { if (!l.empty ()) l += "|"; l += "SH_Menu_SelectionWrap"; }
  if (e->testFlag (QStyle::SH_ItemView_MovementWithoutUpdatingSelection)) { if (!l.empty ()) l += "|"; l += "SH_ItemView_MovementWithoutUpdatingSelection"; }
  if (e->testFlag (QStyle::SH_ToolTip_Mask)) { if (!l.empty ()) l += "|"; l += "SH_ToolTip_Mask"; }
  if (e->testFlag (QStyle::SH_FocusFrame_AboveWidget)) { if (!l.empty ()) l += "|"; l += "SH_FocusFrame_AboveWidget"; }
  if (e->testFlag (QStyle::SH_TextControl_FocusIndicatorTextCharFormat)) { if (!l.empty ()) l += "|"; l += "SH_TextControl_FocusIndicatorTextCharFormat"; }
  if (e->testFlag (QStyle::SH_WizardStyle)) { if (!l.empty ()) l += "|"; l += "SH_WizardStyle"; }
  if (e->testFlag (QStyle::SH_ItemView_ArrowKeysNavigateIntoChildren)) { if (!l.empty ()) l += "|"; l += "SH_ItemView_ArrowKeysNavigateIntoChildren"; }
  if (e->testFlag (QStyle::SH_Menu_Mask)) { if (!l.empty ()) l += "|"; l += "SH_Menu_Mask"; }
  if (e->testFlag (QStyle::SH_Menu_FlashTriggeredItem)) { if (!l.empty ()) l += "|"; l += "SH_Menu_FlashTriggeredItem"; }
  if (e->testFlag (QStyle::SH_Menu_FadeOutOnHide)) { if (!l.empty ()) l += "|"; l += "SH_Menu_FadeOutOnHide"; }
  if (e->testFlag (QStyle::SH_SpinBox_ClickAutoRepeatThreshold)) { if (!l.empty ()) l += "|"; l += "SH_SpinBox_ClickAutoRepeatThreshold"; }
  if (e->testFlag (QStyle::SH_ItemView_PaintAlternatingRowColorsForEmptyArea)) { if (!l.empty ()) l += "|"; l += "SH_ItemView_PaintAlternatingRowColorsForEmptyArea"; }
  if (e->testFlag (QStyle::SH_FormLayoutWrapPolicy)) { if (!l.empty ()) l += "|"; l += "SH_FormLayoutWrapPolicy"; }
  if (e->testFlag (QStyle::SH_TabWidget_DefaultTabPosition)) { if (!l.empty ()) l += "|"; l += "SH_TabWidget_DefaultTabPosition"; }
  if (e->testFlag (QStyle::SH_ToolBar_Movable)) { if (!l.empty ()) l += "|"; l += "SH_ToolBar_Movable"; }
  if (e->testFlag (QStyle::SH_FormLayoutFieldGrowthPolicy)) { if (!l.empty ()) l += "|"; l += "SH_FormLayoutFieldGrowthPolicy"; }
  if (e->testFlag (QStyle::SH_FormLayoutFormAlignment)) { if (!l.empty ()) l += "|"; l += "SH_FormLayoutFormAlignment"; }
  if (e->testFlag (QStyle::SH_FormLayoutLabelAlignment)) { if (!l.empty ()) l += "|"; l += "SH_FormLayoutLabelAlignment"; }
  if (e->testFlag (QStyle::SH_ItemView_DrawDelegateFrame)) { if (!l.empty ()) l += "|"; l += "SH_ItemView_DrawDelegateFrame"; }
  if (e->testFlag (QStyle::SH_TabBar_CloseButtonPosition)) { if (!l.empty ()) l += "|"; l += "SH_TabBar_CloseButtonPosition"; }
  if (e->testFlag (QStyle::SH_DockWidget_ButtonsHaveFrame)) { if (!l.empty ()) l += "|"; l += "SH_DockWidget_ButtonsHaveFrame"; }
  if (e->testFlag (QStyle::SH_ToolButtonStyle)) { if (!l.empty ()) l += "|"; l += "SH_ToolButtonStyle"; }
  if (e->testFlag (QStyle::SH_RequestSoftwareInputPanel)) { if (!l.empty ()) l += "|"; l += "SH_RequestSoftwareInputPanel"; }
  if (e->testFlag (QStyle::SH_CustomBase)) { if (!l.empty ()) l += "|"; l += "SH_CustomBase"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStyle_StyleHint_Enums (const QStyle_StyleHint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStyle_StyleHint_Enums (const QStyle_StyleHint_Enums *e, const QStyle_StyleHint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStyle_StyleHint_Enums> decl_QStyle_StyleHint_Enums ("QStyle_QFlags_StyleHint",
  gsi::method_ext ("|", &qt_gsi::oropQStyle_StyleHint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStyle_StyleHint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStyle_StyleHint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_StyleHint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_StyleHint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStyle_StyleHint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStyle::StyleHint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStyle_StyleHint_Enum> decl_QStyle_StyleHint_Enum (decl_QStyle_StyleHint_Enums, "QStyle_StyleHint",
  qt_gsi::mkdefs_QStyle_StyleHint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_StyleHint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_StyleHint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStyle_StyleHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStyle_StyleHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStyle_StyleHint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStyle::StyleHint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_StyleHint_Enum_in_parent (qt_gsi::mkdefs_QStyle_StyleHint ());
static gsi::ClassExt<QStyle> decl_QStyle_StyleHint_Enum_as_child (decl_QStyle_StyleHint_Enum, "StyleHint");

}


//  Implementation of the enum wrapper class for QStyle::SubControl
namespace qt_gsi
{

static QStyle_SubControl_Enum *c_1_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_None); }
static QStyle_SubControl_Enum *c_2_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ScrollBarAddLine); }
static QStyle_SubControl_Enum *c_3_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ScrollBarSubLine); }
static QStyle_SubControl_Enum *c_4_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ScrollBarAddPage); }
static QStyle_SubControl_Enum *c_5_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ScrollBarSubPage); }
static QStyle_SubControl_Enum *c_6_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ScrollBarFirst); }
static QStyle_SubControl_Enum *c_7_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ScrollBarLast); }
static QStyle_SubControl_Enum *c_8_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ScrollBarSlider); }
static QStyle_SubControl_Enum *c_9_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ScrollBarGroove); }
static QStyle_SubControl_Enum *c_10_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_SpinBoxUp); }
static QStyle_SubControl_Enum *c_11_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_SpinBoxDown); }
static QStyle_SubControl_Enum *c_12_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_SpinBoxFrame); }
static QStyle_SubControl_Enum *c_13_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_SpinBoxEditField); }
static QStyle_SubControl_Enum *c_14_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ComboBoxFrame); }
static QStyle_SubControl_Enum *c_15_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ComboBoxEditField); }
static QStyle_SubControl_Enum *c_16_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ComboBoxArrow); }
static QStyle_SubControl_Enum *c_17_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ComboBoxListBoxPopup); }
static QStyle_SubControl_Enum *c_18_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_SliderGroove); }
static QStyle_SubControl_Enum *c_19_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_SliderHandle); }
static QStyle_SubControl_Enum *c_20_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_SliderTickmarks); }
static QStyle_SubControl_Enum *c_21_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ToolButton); }
static QStyle_SubControl_Enum *c_22_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_ToolButtonMenu); }
static QStyle_SubControl_Enum *c_23_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_TitleBarSysMenu); }
static QStyle_SubControl_Enum *c_24_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_TitleBarMinButton); }
static QStyle_SubControl_Enum *c_25_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_TitleBarMaxButton); }
static QStyle_SubControl_Enum *c_26_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_TitleBarCloseButton); }
static QStyle_SubControl_Enum *c_27_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_TitleBarNormalButton); }
static QStyle_SubControl_Enum *c_28_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_TitleBarShadeButton); }
static QStyle_SubControl_Enum *c_29_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_TitleBarUnshadeButton); }
static QStyle_SubControl_Enum *c_30_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_TitleBarContextHelpButton); }
static QStyle_SubControl_Enum *c_31_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_TitleBarLabel); }
static QStyle_SubControl_Enum *c_32_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_Q3ListView); }
static QStyle_SubControl_Enum *c_33_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_Q3ListViewBranch); }
static QStyle_SubControl_Enum *c_34_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_Q3ListViewExpand); }
static QStyle_SubControl_Enum *c_35_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_DialGroove); }
static QStyle_SubControl_Enum *c_36_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_DialHandle); }
static QStyle_SubControl_Enum *c_37_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_DialTickmarks); }
static QStyle_SubControl_Enum *c_38_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_GroupBoxCheckBox); }
static QStyle_SubControl_Enum *c_39_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_GroupBoxLabel); }
static QStyle_SubControl_Enum *c_40_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_GroupBoxContents); }
static QStyle_SubControl_Enum *c_41_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_GroupBoxFrame); }
static QStyle_SubControl_Enum *c_42_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_MdiMinButton); }
static QStyle_SubControl_Enum *c_43_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_MdiNormalButton); }
static QStyle_SubControl_Enum *c_44_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_MdiCloseButton); }
static QStyle_SubControl_Enum *c_45_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_CustomBase); }
static QStyle_SubControl_Enum *c_46_QStyle_SubControl_Enum () { return new QStyle_SubControl_Enum (QStyle::SC_All); }

static gsi::Methods mkdefs_QStyle_SubControl () {
  return
    gsi::constant ("SC_None", &qt_gsi::c_1_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_None") +
    gsi::constant ("SC_ScrollBarAddLine", &qt_gsi::c_2_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ScrollBarAddLine") +
    gsi::constant ("SC_ScrollBarSubLine", &qt_gsi::c_3_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ScrollBarSubLine") +
    gsi::constant ("SC_ScrollBarAddPage", &qt_gsi::c_4_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ScrollBarAddPage") +
    gsi::constant ("SC_ScrollBarSubPage", &qt_gsi::c_5_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ScrollBarSubPage") +
    gsi::constant ("SC_ScrollBarFirst", &qt_gsi::c_6_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ScrollBarFirst") +
    gsi::constant ("SC_ScrollBarLast", &qt_gsi::c_7_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ScrollBarLast") +
    gsi::constant ("SC_ScrollBarSlider", &qt_gsi::c_8_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ScrollBarSlider") +
    gsi::constant ("SC_ScrollBarGroove", &qt_gsi::c_9_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ScrollBarGroove") +
    gsi::constant ("SC_SpinBoxUp", &qt_gsi::c_10_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_SpinBoxUp") +
    gsi::constant ("SC_SpinBoxDown", &qt_gsi::c_11_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_SpinBoxDown") +
    gsi::constant ("SC_SpinBoxFrame", &qt_gsi::c_12_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_SpinBoxFrame") +
    gsi::constant ("SC_SpinBoxEditField", &qt_gsi::c_13_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_SpinBoxEditField") +
    gsi::constant ("SC_ComboBoxFrame", &qt_gsi::c_14_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ComboBoxFrame") +
    gsi::constant ("SC_ComboBoxEditField", &qt_gsi::c_15_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ComboBoxEditField") +
    gsi::constant ("SC_ComboBoxArrow", &qt_gsi::c_16_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ComboBoxArrow") +
    gsi::constant ("SC_ComboBoxListBoxPopup", &qt_gsi::c_17_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ComboBoxListBoxPopup") +
    gsi::constant ("SC_SliderGroove", &qt_gsi::c_18_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_SliderGroove") +
    gsi::constant ("SC_SliderHandle", &qt_gsi::c_19_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_SliderHandle") +
    gsi::constant ("SC_SliderTickmarks", &qt_gsi::c_20_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_SliderTickmarks") +
    gsi::constant ("SC_ToolButton", &qt_gsi::c_21_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ToolButton") +
    gsi::constant ("SC_ToolButtonMenu", &qt_gsi::c_22_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_ToolButtonMenu") +
    gsi::constant ("SC_TitleBarSysMenu", &qt_gsi::c_23_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_TitleBarSysMenu") +
    gsi::constant ("SC_TitleBarMinButton", &qt_gsi::c_24_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_TitleBarMinButton") +
    gsi::constant ("SC_TitleBarMaxButton", &qt_gsi::c_25_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_TitleBarMaxButton") +
    gsi::constant ("SC_TitleBarCloseButton", &qt_gsi::c_26_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_TitleBarCloseButton") +
    gsi::constant ("SC_TitleBarNormalButton", &qt_gsi::c_27_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_TitleBarNormalButton") +
    gsi::constant ("SC_TitleBarShadeButton", &qt_gsi::c_28_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_TitleBarShadeButton") +
    gsi::constant ("SC_TitleBarUnshadeButton", &qt_gsi::c_29_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_TitleBarUnshadeButton") +
    gsi::constant ("SC_TitleBarContextHelpButton", &qt_gsi::c_30_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_TitleBarContextHelpButton") +
    gsi::constant ("SC_TitleBarLabel", &qt_gsi::c_31_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_TitleBarLabel") +
    gsi::constant ("SC_Q3ListView", &qt_gsi::c_32_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_Q3ListView") +
    gsi::constant ("SC_Q3ListViewBranch", &qt_gsi::c_33_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_Q3ListViewBranch") +
    gsi::constant ("SC_Q3ListViewExpand", &qt_gsi::c_34_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_Q3ListViewExpand") +
    gsi::constant ("SC_DialGroove", &qt_gsi::c_35_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_DialGroove") +
    gsi::constant ("SC_DialHandle", &qt_gsi::c_36_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_DialHandle") +
    gsi::constant ("SC_DialTickmarks", &qt_gsi::c_37_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_DialTickmarks") +
    gsi::constant ("SC_GroupBoxCheckBox", &qt_gsi::c_38_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_GroupBoxCheckBox") +
    gsi::constant ("SC_GroupBoxLabel", &qt_gsi::c_39_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_GroupBoxLabel") +
    gsi::constant ("SC_GroupBoxContents", &qt_gsi::c_40_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_GroupBoxContents") +
    gsi::constant ("SC_GroupBoxFrame", &qt_gsi::c_41_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_GroupBoxFrame") +
    gsi::constant ("SC_MdiMinButton", &qt_gsi::c_42_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_MdiMinButton") +
    gsi::constant ("SC_MdiNormalButton", &qt_gsi::c_43_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_MdiNormalButton") +
    gsi::constant ("SC_MdiCloseButton", &qt_gsi::c_44_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_MdiCloseButton") +
    gsi::constant ("SC_CustomBase", &qt_gsi::c_45_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_CustomBase") +
    gsi::constant ("SC_All", &qt_gsi::c_46_QStyle_SubControl_Enum, "@brief Enum constant QStyle::SC_All");
}

static std::string to_s_QStyle_SubControl_Enum (const QStyle_SubControl_Enum *e)
{
  if (e->value () == QStyle::SC_None) { return tl::sprintf ("SC_None (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ScrollBarAddLine) { return tl::sprintf ("SC_ScrollBarAddLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ScrollBarSubLine) { return tl::sprintf ("SC_ScrollBarSubLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ScrollBarAddPage) { return tl::sprintf ("SC_ScrollBarAddPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ScrollBarSubPage) { return tl::sprintf ("SC_ScrollBarSubPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ScrollBarFirst) { return tl::sprintf ("SC_ScrollBarFirst (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ScrollBarLast) { return tl::sprintf ("SC_ScrollBarLast (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ScrollBarSlider) { return tl::sprintf ("SC_ScrollBarSlider (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ScrollBarGroove) { return tl::sprintf ("SC_ScrollBarGroove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_SpinBoxUp) { return tl::sprintf ("SC_SpinBoxUp (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_SpinBoxDown) { return tl::sprintf ("SC_SpinBoxDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_SpinBoxFrame) { return tl::sprintf ("SC_SpinBoxFrame (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_SpinBoxEditField) { return tl::sprintf ("SC_SpinBoxEditField (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ComboBoxFrame) { return tl::sprintf ("SC_ComboBoxFrame (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ComboBoxEditField) { return tl::sprintf ("SC_ComboBoxEditField (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ComboBoxArrow) { return tl::sprintf ("SC_ComboBoxArrow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ComboBoxListBoxPopup) { return tl::sprintf ("SC_ComboBoxListBoxPopup (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_SliderGroove) { return tl::sprintf ("SC_SliderGroove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_SliderHandle) { return tl::sprintf ("SC_SliderHandle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_SliderTickmarks) { return tl::sprintf ("SC_SliderTickmarks (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ToolButton) { return tl::sprintf ("SC_ToolButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_ToolButtonMenu) { return tl::sprintf ("SC_ToolButtonMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_TitleBarSysMenu) { return tl::sprintf ("SC_TitleBarSysMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_TitleBarMinButton) { return tl::sprintf ("SC_TitleBarMinButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_TitleBarMaxButton) { return tl::sprintf ("SC_TitleBarMaxButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_TitleBarCloseButton) { return tl::sprintf ("SC_TitleBarCloseButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_TitleBarNormalButton) { return tl::sprintf ("SC_TitleBarNormalButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_TitleBarShadeButton) { return tl::sprintf ("SC_TitleBarShadeButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_TitleBarUnshadeButton) { return tl::sprintf ("SC_TitleBarUnshadeButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_TitleBarContextHelpButton) { return tl::sprintf ("SC_TitleBarContextHelpButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_TitleBarLabel) { return tl::sprintf ("SC_TitleBarLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_Q3ListView) { return tl::sprintf ("SC_Q3ListView (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_Q3ListViewBranch) { return tl::sprintf ("SC_Q3ListViewBranch (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_Q3ListViewExpand) { return tl::sprintf ("SC_Q3ListViewExpand (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_DialGroove) { return tl::sprintf ("SC_DialGroove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_DialHandle) { return tl::sprintf ("SC_DialHandle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_DialTickmarks) { return tl::sprintf ("SC_DialTickmarks (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_GroupBoxCheckBox) { return tl::sprintf ("SC_GroupBoxCheckBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_GroupBoxLabel) { return tl::sprintf ("SC_GroupBoxLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_GroupBoxContents) { return tl::sprintf ("SC_GroupBoxContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_GroupBoxFrame) { return tl::sprintf ("SC_GroupBoxFrame (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_MdiMinButton) { return tl::sprintf ("SC_MdiMinButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_MdiNormalButton) { return tl::sprintf ("SC_MdiNormalButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_MdiCloseButton) { return tl::sprintf ("SC_MdiCloseButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_CustomBase) { return tl::sprintf ("SC_CustomBase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SC_All) { return tl::sprintf ("SC_All (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStyle_SubControl_Enum (const QStyle_SubControl_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStyle_SubControl_Enum *from_i_QStyle_SubControl_Enum (unsigned int i)
{
  return new QStyle_SubControl_Enum ((QStyle::SubControl) i);
}

static bool equalQStyle_SubControl_Enum (const QStyle_SubControl_Enum *e, QStyle_SubControl_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStyle_SubControl_Enum (const QStyle_SubControl_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStyle_SubControl_Enums oropQStyle_SubControl_Enums (const QStyle_SubControl_Enums *e, const QStyle_SubControl_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStyle_SubControl_Enums andopQStyle_SubControl_Enums (const QStyle_SubControl_Enums *e, const QStyle_SubControl_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStyle_SubControl_Enums xoropQStyle_SubControl_Enums (const QStyle_SubControl_Enums *e, const QStyle_SubControl_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStyle_SubControl_Enums (const QStyle_SubControl_Enums *e)
{
  std::string l;
  if (e->testFlag (QStyle::SC_None)) { if (!l.empty ()) l += "|"; l += "SC_None"; }
  if (e->testFlag (QStyle::SC_ScrollBarAddLine)) { if (!l.empty ()) l += "|"; l += "SC_ScrollBarAddLine"; }
  if (e->testFlag (QStyle::SC_ScrollBarSubLine)) { if (!l.empty ()) l += "|"; l += "SC_ScrollBarSubLine"; }
  if (e->testFlag (QStyle::SC_ScrollBarAddPage)) { if (!l.empty ()) l += "|"; l += "SC_ScrollBarAddPage"; }
  if (e->testFlag (QStyle::SC_ScrollBarSubPage)) { if (!l.empty ()) l += "|"; l += "SC_ScrollBarSubPage"; }
  if (e->testFlag (QStyle::SC_ScrollBarFirst)) { if (!l.empty ()) l += "|"; l += "SC_ScrollBarFirst"; }
  if (e->testFlag (QStyle::SC_ScrollBarLast)) { if (!l.empty ()) l += "|"; l += "SC_ScrollBarLast"; }
  if (e->testFlag (QStyle::SC_ScrollBarSlider)) { if (!l.empty ()) l += "|"; l += "SC_ScrollBarSlider"; }
  if (e->testFlag (QStyle::SC_ScrollBarGroove)) { if (!l.empty ()) l += "|"; l += "SC_ScrollBarGroove"; }
  if (e->testFlag (QStyle::SC_SpinBoxUp)) { if (!l.empty ()) l += "|"; l += "SC_SpinBoxUp"; }
  if (e->testFlag (QStyle::SC_SpinBoxDown)) { if (!l.empty ()) l += "|"; l += "SC_SpinBoxDown"; }
  if (e->testFlag (QStyle::SC_SpinBoxFrame)) { if (!l.empty ()) l += "|"; l += "SC_SpinBoxFrame"; }
  if (e->testFlag (QStyle::SC_SpinBoxEditField)) { if (!l.empty ()) l += "|"; l += "SC_SpinBoxEditField"; }
  if (e->testFlag (QStyle::SC_ComboBoxFrame)) { if (!l.empty ()) l += "|"; l += "SC_ComboBoxFrame"; }
  if (e->testFlag (QStyle::SC_ComboBoxEditField)) { if (!l.empty ()) l += "|"; l += "SC_ComboBoxEditField"; }
  if (e->testFlag (QStyle::SC_ComboBoxArrow)) { if (!l.empty ()) l += "|"; l += "SC_ComboBoxArrow"; }
  if (e->testFlag (QStyle::SC_ComboBoxListBoxPopup)) { if (!l.empty ()) l += "|"; l += "SC_ComboBoxListBoxPopup"; }
  if (e->testFlag (QStyle::SC_SliderGroove)) { if (!l.empty ()) l += "|"; l += "SC_SliderGroove"; }
  if (e->testFlag (QStyle::SC_SliderHandle)) { if (!l.empty ()) l += "|"; l += "SC_SliderHandle"; }
  if (e->testFlag (QStyle::SC_SliderTickmarks)) { if (!l.empty ()) l += "|"; l += "SC_SliderTickmarks"; }
  if (e->testFlag (QStyle::SC_ToolButton)) { if (!l.empty ()) l += "|"; l += "SC_ToolButton"; }
  if (e->testFlag (QStyle::SC_ToolButtonMenu)) { if (!l.empty ()) l += "|"; l += "SC_ToolButtonMenu"; }
  if (e->testFlag (QStyle::SC_TitleBarSysMenu)) { if (!l.empty ()) l += "|"; l += "SC_TitleBarSysMenu"; }
  if (e->testFlag (QStyle::SC_TitleBarMinButton)) { if (!l.empty ()) l += "|"; l += "SC_TitleBarMinButton"; }
  if (e->testFlag (QStyle::SC_TitleBarMaxButton)) { if (!l.empty ()) l += "|"; l += "SC_TitleBarMaxButton"; }
  if (e->testFlag (QStyle::SC_TitleBarCloseButton)) { if (!l.empty ()) l += "|"; l += "SC_TitleBarCloseButton"; }
  if (e->testFlag (QStyle::SC_TitleBarNormalButton)) { if (!l.empty ()) l += "|"; l += "SC_TitleBarNormalButton"; }
  if (e->testFlag (QStyle::SC_TitleBarShadeButton)) { if (!l.empty ()) l += "|"; l += "SC_TitleBarShadeButton"; }
  if (e->testFlag (QStyle::SC_TitleBarUnshadeButton)) { if (!l.empty ()) l += "|"; l += "SC_TitleBarUnshadeButton"; }
  if (e->testFlag (QStyle::SC_TitleBarContextHelpButton)) { if (!l.empty ()) l += "|"; l += "SC_TitleBarContextHelpButton"; }
  if (e->testFlag (QStyle::SC_TitleBarLabel)) { if (!l.empty ()) l += "|"; l += "SC_TitleBarLabel"; }
  if (e->testFlag (QStyle::SC_Q3ListView)) { if (!l.empty ()) l += "|"; l += "SC_Q3ListView"; }
  if (e->testFlag (QStyle::SC_Q3ListViewBranch)) { if (!l.empty ()) l += "|"; l += "SC_Q3ListViewBranch"; }
  if (e->testFlag (QStyle::SC_Q3ListViewExpand)) { if (!l.empty ()) l += "|"; l += "SC_Q3ListViewExpand"; }
  if (e->testFlag (QStyle::SC_DialGroove)) { if (!l.empty ()) l += "|"; l += "SC_DialGroove"; }
  if (e->testFlag (QStyle::SC_DialHandle)) { if (!l.empty ()) l += "|"; l += "SC_DialHandle"; }
  if (e->testFlag (QStyle::SC_DialTickmarks)) { if (!l.empty ()) l += "|"; l += "SC_DialTickmarks"; }
  if (e->testFlag (QStyle::SC_GroupBoxCheckBox)) { if (!l.empty ()) l += "|"; l += "SC_GroupBoxCheckBox"; }
  if (e->testFlag (QStyle::SC_GroupBoxLabel)) { if (!l.empty ()) l += "|"; l += "SC_GroupBoxLabel"; }
  if (e->testFlag (QStyle::SC_GroupBoxContents)) { if (!l.empty ()) l += "|"; l += "SC_GroupBoxContents"; }
  if (e->testFlag (QStyle::SC_GroupBoxFrame)) { if (!l.empty ()) l += "|"; l += "SC_GroupBoxFrame"; }
  if (e->testFlag (QStyle::SC_MdiMinButton)) { if (!l.empty ()) l += "|"; l += "SC_MdiMinButton"; }
  if (e->testFlag (QStyle::SC_MdiNormalButton)) { if (!l.empty ()) l += "|"; l += "SC_MdiNormalButton"; }
  if (e->testFlag (QStyle::SC_MdiCloseButton)) { if (!l.empty ()) l += "|"; l += "SC_MdiCloseButton"; }
  if (e->testFlag (QStyle::SC_CustomBase)) { if (!l.empty ()) l += "|"; l += "SC_CustomBase"; }
  if (e->testFlag (QStyle::SC_All)) { if (!l.empty ()) l += "|"; l += "SC_All"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStyle_SubControl_Enums (const QStyle_SubControl_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStyle_SubControl_Enums (const QStyle_SubControl_Enums *e, const QStyle_SubControl_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStyle_SubControl_Enums> decl_QStyle_SubControl_Enums ("QStyle_QFlags_SubControl",
  gsi::method_ext ("|", &qt_gsi::oropQStyle_SubControl_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStyle_SubControl_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStyle_SubControl_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_SubControl_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_SubControl_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStyle_SubControl_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStyle::SubControl> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStyle_SubControl_Enum> decl_QStyle_SubControl_Enum (decl_QStyle_SubControl_Enums, "QStyle_SubControl",
  qt_gsi::mkdefs_QStyle_SubControl () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_SubControl_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_SubControl_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStyle_SubControl_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStyle_SubControl_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStyle_SubControl_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStyle::SubControl enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_SubControl_Enum_in_parent (qt_gsi::mkdefs_QStyle_SubControl ());
static gsi::ClassExt<QStyle> decl_QStyle_SubControl_Enum_as_child (decl_QStyle_SubControl_Enum, "SubControl");

}


//  Implementation of the enum wrapper class for QStyle::SubElement
namespace qt_gsi
{

static QStyle_SubElement_Enum *c_1_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_PushButtonContents); }
static QStyle_SubElement_Enum *c_2_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_PushButtonFocusRect); }
static QStyle_SubElement_Enum *c_3_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_CheckBoxIndicator); }
static QStyle_SubElement_Enum *c_4_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_CheckBoxContents); }
static QStyle_SubElement_Enum *c_5_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_CheckBoxFocusRect); }
static QStyle_SubElement_Enum *c_6_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_CheckBoxClickRect); }
static QStyle_SubElement_Enum *c_7_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_RadioButtonIndicator); }
static QStyle_SubElement_Enum *c_8_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_RadioButtonContents); }
static QStyle_SubElement_Enum *c_9_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_RadioButtonFocusRect); }
static QStyle_SubElement_Enum *c_10_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_RadioButtonClickRect); }
static QStyle_SubElement_Enum *c_11_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ComboBoxFocusRect); }
static QStyle_SubElement_Enum *c_12_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_SliderFocusRect); }
static QStyle_SubElement_Enum *c_13_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_Q3DockWindowHandleRect); }
static QStyle_SubElement_Enum *c_14_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ProgressBarGroove); }
static QStyle_SubElement_Enum *c_15_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ProgressBarContents); }
static QStyle_SubElement_Enum *c_16_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ProgressBarLabel); }
static QStyle_SubElement_Enum *c_17_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonAccept); }
static QStyle_SubElement_Enum *c_18_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonReject); }
static QStyle_SubElement_Enum *c_19_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonApply); }
static QStyle_SubElement_Enum *c_20_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonHelp); }
static QStyle_SubElement_Enum *c_21_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonAll); }
static QStyle_SubElement_Enum *c_22_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonAbort); }
static QStyle_SubElement_Enum *c_23_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonIgnore); }
static QStyle_SubElement_Enum *c_24_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonRetry); }
static QStyle_SubElement_Enum *c_25_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonCustom); }
static QStyle_SubElement_Enum *c_26_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ToolBoxTabContents); }
static QStyle_SubElement_Enum *c_27_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_HeaderLabel); }
static QStyle_SubElement_Enum *c_28_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_HeaderArrow); }
static QStyle_SubElement_Enum *c_29_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabWidgetTabBar); }
static QStyle_SubElement_Enum *c_30_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabWidgetTabPane); }
static QStyle_SubElement_Enum *c_31_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabWidgetTabContents); }
static QStyle_SubElement_Enum *c_32_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabWidgetLeftCorner); }
static QStyle_SubElement_Enum *c_33_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabWidgetRightCorner); }
static QStyle_SubElement_Enum *c_34_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ViewItemCheckIndicator); }
static QStyle_SubElement_Enum *c_35_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ItemViewItemCheckIndicator); }
static QStyle_SubElement_Enum *c_36_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabBarTearIndicator); }
static QStyle_SubElement_Enum *c_37_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TreeViewDisclosureItem); }
static QStyle_SubElement_Enum *c_38_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_LineEditContents); }
static QStyle_SubElement_Enum *c_39_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_FrameContents); }
static QStyle_SubElement_Enum *c_40_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DockWidgetCloseButton); }
static QStyle_SubElement_Enum *c_41_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DockWidgetFloatButton); }
static QStyle_SubElement_Enum *c_42_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DockWidgetTitleBarText); }
static QStyle_SubElement_Enum *c_43_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DockWidgetIcon); }
static QStyle_SubElement_Enum *c_44_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_CheckBoxLayoutItem); }
static QStyle_SubElement_Enum *c_45_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ComboBoxLayoutItem); }
static QStyle_SubElement_Enum *c_46_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DateTimeEditLayoutItem); }
static QStyle_SubElement_Enum *c_47_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_DialogButtonBoxLayoutItem); }
static QStyle_SubElement_Enum *c_48_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_LabelLayoutItem); }
static QStyle_SubElement_Enum *c_49_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ProgressBarLayoutItem); }
static QStyle_SubElement_Enum *c_50_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_PushButtonLayoutItem); }
static QStyle_SubElement_Enum *c_51_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_RadioButtonLayoutItem); }
static QStyle_SubElement_Enum *c_52_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_SliderLayoutItem); }
static QStyle_SubElement_Enum *c_53_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_SpinBoxLayoutItem); }
static QStyle_SubElement_Enum *c_54_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ToolButtonLayoutItem); }
static QStyle_SubElement_Enum *c_55_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_FrameLayoutItem); }
static QStyle_SubElement_Enum *c_56_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_GroupBoxLayoutItem); }
static QStyle_SubElement_Enum *c_57_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabWidgetLayoutItem); }
static QStyle_SubElement_Enum *c_58_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ItemViewItemDecoration); }
static QStyle_SubElement_Enum *c_59_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ItemViewItemText); }
static QStyle_SubElement_Enum *c_60_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ItemViewItemFocusRect); }
static QStyle_SubElement_Enum *c_61_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabBarTabLeftButton); }
static QStyle_SubElement_Enum *c_62_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabBarTabRightButton); }
static QStyle_SubElement_Enum *c_63_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_TabBarTabText); }
static QStyle_SubElement_Enum *c_64_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ShapedFrameContents); }
static QStyle_SubElement_Enum *c_65_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_ToolBarHandle); }
static QStyle_SubElement_Enum *c_66_QStyle_SubElement_Enum () { return new QStyle_SubElement_Enum (QStyle::SE_CustomBase); }

static gsi::Methods mkdefs_QStyle_SubElement () {
  return
    gsi::constant ("SE_PushButtonContents", &qt_gsi::c_1_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_PushButtonContents") +
    gsi::constant ("SE_PushButtonFocusRect", &qt_gsi::c_2_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_PushButtonFocusRect") +
    gsi::constant ("SE_CheckBoxIndicator", &qt_gsi::c_3_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_CheckBoxIndicator") +
    gsi::constant ("SE_CheckBoxContents", &qt_gsi::c_4_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_CheckBoxContents") +
    gsi::constant ("SE_CheckBoxFocusRect", &qt_gsi::c_5_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_CheckBoxFocusRect") +
    gsi::constant ("SE_CheckBoxClickRect", &qt_gsi::c_6_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_CheckBoxClickRect") +
    gsi::constant ("SE_RadioButtonIndicator", &qt_gsi::c_7_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_RadioButtonIndicator") +
    gsi::constant ("SE_RadioButtonContents", &qt_gsi::c_8_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_RadioButtonContents") +
    gsi::constant ("SE_RadioButtonFocusRect", &qt_gsi::c_9_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_RadioButtonFocusRect") +
    gsi::constant ("SE_RadioButtonClickRect", &qt_gsi::c_10_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_RadioButtonClickRect") +
    gsi::constant ("SE_ComboBoxFocusRect", &qt_gsi::c_11_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ComboBoxFocusRect") +
    gsi::constant ("SE_SliderFocusRect", &qt_gsi::c_12_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_SliderFocusRect") +
    gsi::constant ("SE_Q3DockWindowHandleRect", &qt_gsi::c_13_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_Q3DockWindowHandleRect") +
    gsi::constant ("SE_ProgressBarGroove", &qt_gsi::c_14_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ProgressBarGroove") +
    gsi::constant ("SE_ProgressBarContents", &qt_gsi::c_15_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ProgressBarContents") +
    gsi::constant ("SE_ProgressBarLabel", &qt_gsi::c_16_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ProgressBarLabel") +
    gsi::constant ("SE_DialogButtonAccept", &qt_gsi::c_17_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonAccept") +
    gsi::constant ("SE_DialogButtonReject", &qt_gsi::c_18_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonReject") +
    gsi::constant ("SE_DialogButtonApply", &qt_gsi::c_19_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonApply") +
    gsi::constant ("SE_DialogButtonHelp", &qt_gsi::c_20_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonHelp") +
    gsi::constant ("SE_DialogButtonAll", &qt_gsi::c_21_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonAll") +
    gsi::constant ("SE_DialogButtonAbort", &qt_gsi::c_22_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonAbort") +
    gsi::constant ("SE_DialogButtonIgnore", &qt_gsi::c_23_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonIgnore") +
    gsi::constant ("SE_DialogButtonRetry", &qt_gsi::c_24_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonRetry") +
    gsi::constant ("SE_DialogButtonCustom", &qt_gsi::c_25_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonCustom") +
    gsi::constant ("SE_ToolBoxTabContents", &qt_gsi::c_26_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ToolBoxTabContents") +
    gsi::constant ("SE_HeaderLabel", &qt_gsi::c_27_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_HeaderLabel") +
    gsi::constant ("SE_HeaderArrow", &qt_gsi::c_28_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_HeaderArrow") +
    gsi::constant ("SE_TabWidgetTabBar", &qt_gsi::c_29_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabWidgetTabBar") +
    gsi::constant ("SE_TabWidgetTabPane", &qt_gsi::c_30_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabWidgetTabPane") +
    gsi::constant ("SE_TabWidgetTabContents", &qt_gsi::c_31_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabWidgetTabContents") +
    gsi::constant ("SE_TabWidgetLeftCorner", &qt_gsi::c_32_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabWidgetLeftCorner") +
    gsi::constant ("SE_TabWidgetRightCorner", &qt_gsi::c_33_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabWidgetRightCorner") +
    gsi::constant ("SE_ViewItemCheckIndicator", &qt_gsi::c_34_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ViewItemCheckIndicator") +
    gsi::constant ("SE_ItemViewItemCheckIndicator", &qt_gsi::c_35_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ItemViewItemCheckIndicator") +
    gsi::constant ("SE_TabBarTearIndicator", &qt_gsi::c_36_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabBarTearIndicator") +
    gsi::constant ("SE_TreeViewDisclosureItem", &qt_gsi::c_37_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TreeViewDisclosureItem") +
    gsi::constant ("SE_LineEditContents", &qt_gsi::c_38_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_LineEditContents") +
    gsi::constant ("SE_FrameContents", &qt_gsi::c_39_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_FrameContents") +
    gsi::constant ("SE_DockWidgetCloseButton", &qt_gsi::c_40_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DockWidgetCloseButton") +
    gsi::constant ("SE_DockWidgetFloatButton", &qt_gsi::c_41_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DockWidgetFloatButton") +
    gsi::constant ("SE_DockWidgetTitleBarText", &qt_gsi::c_42_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DockWidgetTitleBarText") +
    gsi::constant ("SE_DockWidgetIcon", &qt_gsi::c_43_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DockWidgetIcon") +
    gsi::constant ("SE_CheckBoxLayoutItem", &qt_gsi::c_44_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_CheckBoxLayoutItem") +
    gsi::constant ("SE_ComboBoxLayoutItem", &qt_gsi::c_45_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ComboBoxLayoutItem") +
    gsi::constant ("SE_DateTimeEditLayoutItem", &qt_gsi::c_46_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DateTimeEditLayoutItem") +
    gsi::constant ("SE_DialogButtonBoxLayoutItem", &qt_gsi::c_47_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_DialogButtonBoxLayoutItem") +
    gsi::constant ("SE_LabelLayoutItem", &qt_gsi::c_48_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_LabelLayoutItem") +
    gsi::constant ("SE_ProgressBarLayoutItem", &qt_gsi::c_49_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ProgressBarLayoutItem") +
    gsi::constant ("SE_PushButtonLayoutItem", &qt_gsi::c_50_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_PushButtonLayoutItem") +
    gsi::constant ("SE_RadioButtonLayoutItem", &qt_gsi::c_51_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_RadioButtonLayoutItem") +
    gsi::constant ("SE_SliderLayoutItem", &qt_gsi::c_52_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_SliderLayoutItem") +
    gsi::constant ("SE_SpinBoxLayoutItem", &qt_gsi::c_53_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_SpinBoxLayoutItem") +
    gsi::constant ("SE_ToolButtonLayoutItem", &qt_gsi::c_54_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ToolButtonLayoutItem") +
    gsi::constant ("SE_FrameLayoutItem", &qt_gsi::c_55_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_FrameLayoutItem") +
    gsi::constant ("SE_GroupBoxLayoutItem", &qt_gsi::c_56_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_GroupBoxLayoutItem") +
    gsi::constant ("SE_TabWidgetLayoutItem", &qt_gsi::c_57_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabWidgetLayoutItem") +
    gsi::constant ("SE_ItemViewItemDecoration", &qt_gsi::c_58_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ItemViewItemDecoration") +
    gsi::constant ("SE_ItemViewItemText", &qt_gsi::c_59_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ItemViewItemText") +
    gsi::constant ("SE_ItemViewItemFocusRect", &qt_gsi::c_60_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ItemViewItemFocusRect") +
    gsi::constant ("SE_TabBarTabLeftButton", &qt_gsi::c_61_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabBarTabLeftButton") +
    gsi::constant ("SE_TabBarTabRightButton", &qt_gsi::c_62_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabBarTabRightButton") +
    gsi::constant ("SE_TabBarTabText", &qt_gsi::c_63_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_TabBarTabText") +
    gsi::constant ("SE_ShapedFrameContents", &qt_gsi::c_64_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ShapedFrameContents") +
    gsi::constant ("SE_ToolBarHandle", &qt_gsi::c_65_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_ToolBarHandle") +
    gsi::constant ("SE_CustomBase", &qt_gsi::c_66_QStyle_SubElement_Enum, "@brief Enum constant QStyle::SE_CustomBase");
}

static std::string to_s_QStyle_SubElement_Enum (const QStyle_SubElement_Enum *e)
{
  if (e->value () == QStyle::SE_PushButtonContents) { return tl::sprintf ("SE_PushButtonContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_PushButtonFocusRect) { return tl::sprintf ("SE_PushButtonFocusRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_CheckBoxIndicator) { return tl::sprintf ("SE_CheckBoxIndicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_CheckBoxContents) { return tl::sprintf ("SE_CheckBoxContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_CheckBoxFocusRect) { return tl::sprintf ("SE_CheckBoxFocusRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_CheckBoxClickRect) { return tl::sprintf ("SE_CheckBoxClickRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_RadioButtonIndicator) { return tl::sprintf ("SE_RadioButtonIndicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_RadioButtonContents) { return tl::sprintf ("SE_RadioButtonContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_RadioButtonFocusRect) { return tl::sprintf ("SE_RadioButtonFocusRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_RadioButtonClickRect) { return tl::sprintf ("SE_RadioButtonClickRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ComboBoxFocusRect) { return tl::sprintf ("SE_ComboBoxFocusRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_SliderFocusRect) { return tl::sprintf ("SE_SliderFocusRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_Q3DockWindowHandleRect) { return tl::sprintf ("SE_Q3DockWindowHandleRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ProgressBarGroove) { return tl::sprintf ("SE_ProgressBarGroove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ProgressBarContents) { return tl::sprintf ("SE_ProgressBarContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ProgressBarLabel) { return tl::sprintf ("SE_ProgressBarLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonAccept) { return tl::sprintf ("SE_DialogButtonAccept (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonReject) { return tl::sprintf ("SE_DialogButtonReject (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonApply) { return tl::sprintf ("SE_DialogButtonApply (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonHelp) { return tl::sprintf ("SE_DialogButtonHelp (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonAll) { return tl::sprintf ("SE_DialogButtonAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonAbort) { return tl::sprintf ("SE_DialogButtonAbort (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonIgnore) { return tl::sprintf ("SE_DialogButtonIgnore (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonRetry) { return tl::sprintf ("SE_DialogButtonRetry (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonCustom) { return tl::sprintf ("SE_DialogButtonCustom (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ToolBoxTabContents) { return tl::sprintf ("SE_ToolBoxTabContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_HeaderLabel) { return tl::sprintf ("SE_HeaderLabel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_HeaderArrow) { return tl::sprintf ("SE_HeaderArrow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabWidgetTabBar) { return tl::sprintf ("SE_TabWidgetTabBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabWidgetTabPane) { return tl::sprintf ("SE_TabWidgetTabPane (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabWidgetTabContents) { return tl::sprintf ("SE_TabWidgetTabContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabWidgetLeftCorner) { return tl::sprintf ("SE_TabWidgetLeftCorner (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabWidgetRightCorner) { return tl::sprintf ("SE_TabWidgetRightCorner (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ViewItemCheckIndicator) { return tl::sprintf ("SE_ViewItemCheckIndicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ItemViewItemCheckIndicator) { return tl::sprintf ("SE_ItemViewItemCheckIndicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabBarTearIndicator) { return tl::sprintf ("SE_TabBarTearIndicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TreeViewDisclosureItem) { return tl::sprintf ("SE_TreeViewDisclosureItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_LineEditContents) { return tl::sprintf ("SE_LineEditContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_FrameContents) { return tl::sprintf ("SE_FrameContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DockWidgetCloseButton) { return tl::sprintf ("SE_DockWidgetCloseButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DockWidgetFloatButton) { return tl::sprintf ("SE_DockWidgetFloatButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DockWidgetTitleBarText) { return tl::sprintf ("SE_DockWidgetTitleBarText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DockWidgetIcon) { return tl::sprintf ("SE_DockWidgetIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_CheckBoxLayoutItem) { return tl::sprintf ("SE_CheckBoxLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ComboBoxLayoutItem) { return tl::sprintf ("SE_ComboBoxLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DateTimeEditLayoutItem) { return tl::sprintf ("SE_DateTimeEditLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_DialogButtonBoxLayoutItem) { return tl::sprintf ("SE_DialogButtonBoxLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_LabelLayoutItem) { return tl::sprintf ("SE_LabelLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ProgressBarLayoutItem) { return tl::sprintf ("SE_ProgressBarLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_PushButtonLayoutItem) { return tl::sprintf ("SE_PushButtonLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_RadioButtonLayoutItem) { return tl::sprintf ("SE_RadioButtonLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_SliderLayoutItem) { return tl::sprintf ("SE_SliderLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_SpinBoxLayoutItem) { return tl::sprintf ("SE_SpinBoxLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ToolButtonLayoutItem) { return tl::sprintf ("SE_ToolButtonLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_FrameLayoutItem) { return tl::sprintf ("SE_FrameLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_GroupBoxLayoutItem) { return tl::sprintf ("SE_GroupBoxLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabWidgetLayoutItem) { return tl::sprintf ("SE_TabWidgetLayoutItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ItemViewItemDecoration) { return tl::sprintf ("SE_ItemViewItemDecoration (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ItemViewItemText) { return tl::sprintf ("SE_ItemViewItemText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ItemViewItemFocusRect) { return tl::sprintf ("SE_ItemViewItemFocusRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabBarTabLeftButton) { return tl::sprintf ("SE_TabBarTabLeftButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabBarTabRightButton) { return tl::sprintf ("SE_TabBarTabRightButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_TabBarTabText) { return tl::sprintf ("SE_TabBarTabText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ShapedFrameContents) { return tl::sprintf ("SE_ShapedFrameContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_ToolBarHandle) { return tl::sprintf ("SE_ToolBarHandle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStyle::SE_CustomBase) { return tl::sprintf ("SE_CustomBase (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStyle_SubElement_Enum (const QStyle_SubElement_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStyle_SubElement_Enum *from_i_QStyle_SubElement_Enum (unsigned int i)
{
  return new QStyle_SubElement_Enum ((QStyle::SubElement) i);
}

static bool equalQStyle_SubElement_Enum (const QStyle_SubElement_Enum *e, QStyle_SubElement_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStyle_SubElement_Enum (const QStyle_SubElement_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStyle_SubElement_Enums oropQStyle_SubElement_Enums (const QStyle_SubElement_Enums *e, const QStyle_SubElement_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStyle_SubElement_Enums andopQStyle_SubElement_Enums (const QStyle_SubElement_Enums *e, const QStyle_SubElement_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStyle_SubElement_Enums xoropQStyle_SubElement_Enums (const QStyle_SubElement_Enums *e, const QStyle_SubElement_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStyle_SubElement_Enums (const QStyle_SubElement_Enums *e)
{
  std::string l;
  if (e->testFlag (QStyle::SE_PushButtonContents)) { if (!l.empty ()) l += "|"; l += "SE_PushButtonContents"; }
  if (e->testFlag (QStyle::SE_PushButtonFocusRect)) { if (!l.empty ()) l += "|"; l += "SE_PushButtonFocusRect"; }
  if (e->testFlag (QStyle::SE_CheckBoxIndicator)) { if (!l.empty ()) l += "|"; l += "SE_CheckBoxIndicator"; }
  if (e->testFlag (QStyle::SE_CheckBoxContents)) { if (!l.empty ()) l += "|"; l += "SE_CheckBoxContents"; }
  if (e->testFlag (QStyle::SE_CheckBoxFocusRect)) { if (!l.empty ()) l += "|"; l += "SE_CheckBoxFocusRect"; }
  if (e->testFlag (QStyle::SE_CheckBoxClickRect)) { if (!l.empty ()) l += "|"; l += "SE_CheckBoxClickRect"; }
  if (e->testFlag (QStyle::SE_RadioButtonIndicator)) { if (!l.empty ()) l += "|"; l += "SE_RadioButtonIndicator"; }
  if (e->testFlag (QStyle::SE_RadioButtonContents)) { if (!l.empty ()) l += "|"; l += "SE_RadioButtonContents"; }
  if (e->testFlag (QStyle::SE_RadioButtonFocusRect)) { if (!l.empty ()) l += "|"; l += "SE_RadioButtonFocusRect"; }
  if (e->testFlag (QStyle::SE_RadioButtonClickRect)) { if (!l.empty ()) l += "|"; l += "SE_RadioButtonClickRect"; }
  if (e->testFlag (QStyle::SE_ComboBoxFocusRect)) { if (!l.empty ()) l += "|"; l += "SE_ComboBoxFocusRect"; }
  if (e->testFlag (QStyle::SE_SliderFocusRect)) { if (!l.empty ()) l += "|"; l += "SE_SliderFocusRect"; }
  if (e->testFlag (QStyle::SE_Q3DockWindowHandleRect)) { if (!l.empty ()) l += "|"; l += "SE_Q3DockWindowHandleRect"; }
  if (e->testFlag (QStyle::SE_ProgressBarGroove)) { if (!l.empty ()) l += "|"; l += "SE_ProgressBarGroove"; }
  if (e->testFlag (QStyle::SE_ProgressBarContents)) { if (!l.empty ()) l += "|"; l += "SE_ProgressBarContents"; }
  if (e->testFlag (QStyle::SE_ProgressBarLabel)) { if (!l.empty ()) l += "|"; l += "SE_ProgressBarLabel"; }
  if (e->testFlag (QStyle::SE_DialogButtonAccept)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonAccept"; }
  if (e->testFlag (QStyle::SE_DialogButtonReject)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonReject"; }
  if (e->testFlag (QStyle::SE_DialogButtonApply)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonApply"; }
  if (e->testFlag (QStyle::SE_DialogButtonHelp)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonHelp"; }
  if (e->testFlag (QStyle::SE_DialogButtonAll)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonAll"; }
  if (e->testFlag (QStyle::SE_DialogButtonAbort)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonAbort"; }
  if (e->testFlag (QStyle::SE_DialogButtonIgnore)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonIgnore"; }
  if (e->testFlag (QStyle::SE_DialogButtonRetry)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonRetry"; }
  if (e->testFlag (QStyle::SE_DialogButtonCustom)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonCustom"; }
  if (e->testFlag (QStyle::SE_ToolBoxTabContents)) { if (!l.empty ()) l += "|"; l += "SE_ToolBoxTabContents"; }
  if (e->testFlag (QStyle::SE_HeaderLabel)) { if (!l.empty ()) l += "|"; l += "SE_HeaderLabel"; }
  if (e->testFlag (QStyle::SE_HeaderArrow)) { if (!l.empty ()) l += "|"; l += "SE_HeaderArrow"; }
  if (e->testFlag (QStyle::SE_TabWidgetTabBar)) { if (!l.empty ()) l += "|"; l += "SE_TabWidgetTabBar"; }
  if (e->testFlag (QStyle::SE_TabWidgetTabPane)) { if (!l.empty ()) l += "|"; l += "SE_TabWidgetTabPane"; }
  if (e->testFlag (QStyle::SE_TabWidgetTabContents)) { if (!l.empty ()) l += "|"; l += "SE_TabWidgetTabContents"; }
  if (e->testFlag (QStyle::SE_TabWidgetLeftCorner)) { if (!l.empty ()) l += "|"; l += "SE_TabWidgetLeftCorner"; }
  if (e->testFlag (QStyle::SE_TabWidgetRightCorner)) { if (!l.empty ()) l += "|"; l += "SE_TabWidgetRightCorner"; }
  if (e->testFlag (QStyle::SE_ViewItemCheckIndicator)) { if (!l.empty ()) l += "|"; l += "SE_ViewItemCheckIndicator"; }
  if (e->testFlag (QStyle::SE_ItemViewItemCheckIndicator)) { if (!l.empty ()) l += "|"; l += "SE_ItemViewItemCheckIndicator"; }
  if (e->testFlag (QStyle::SE_TabBarTearIndicator)) { if (!l.empty ()) l += "|"; l += "SE_TabBarTearIndicator"; }
  if (e->testFlag (QStyle::SE_TreeViewDisclosureItem)) { if (!l.empty ()) l += "|"; l += "SE_TreeViewDisclosureItem"; }
  if (e->testFlag (QStyle::SE_LineEditContents)) { if (!l.empty ()) l += "|"; l += "SE_LineEditContents"; }
  if (e->testFlag (QStyle::SE_FrameContents)) { if (!l.empty ()) l += "|"; l += "SE_FrameContents"; }
  if (e->testFlag (QStyle::SE_DockWidgetCloseButton)) { if (!l.empty ()) l += "|"; l += "SE_DockWidgetCloseButton"; }
  if (e->testFlag (QStyle::SE_DockWidgetFloatButton)) { if (!l.empty ()) l += "|"; l += "SE_DockWidgetFloatButton"; }
  if (e->testFlag (QStyle::SE_DockWidgetTitleBarText)) { if (!l.empty ()) l += "|"; l += "SE_DockWidgetTitleBarText"; }
  if (e->testFlag (QStyle::SE_DockWidgetIcon)) { if (!l.empty ()) l += "|"; l += "SE_DockWidgetIcon"; }
  if (e->testFlag (QStyle::SE_CheckBoxLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_CheckBoxLayoutItem"; }
  if (e->testFlag (QStyle::SE_ComboBoxLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_ComboBoxLayoutItem"; }
  if (e->testFlag (QStyle::SE_DateTimeEditLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_DateTimeEditLayoutItem"; }
  if (e->testFlag (QStyle::SE_DialogButtonBoxLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_DialogButtonBoxLayoutItem"; }
  if (e->testFlag (QStyle::SE_LabelLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_LabelLayoutItem"; }
  if (e->testFlag (QStyle::SE_ProgressBarLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_ProgressBarLayoutItem"; }
  if (e->testFlag (QStyle::SE_PushButtonLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_PushButtonLayoutItem"; }
  if (e->testFlag (QStyle::SE_RadioButtonLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_RadioButtonLayoutItem"; }
  if (e->testFlag (QStyle::SE_SliderLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_SliderLayoutItem"; }
  if (e->testFlag (QStyle::SE_SpinBoxLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_SpinBoxLayoutItem"; }
  if (e->testFlag (QStyle::SE_ToolButtonLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_ToolButtonLayoutItem"; }
  if (e->testFlag (QStyle::SE_FrameLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_FrameLayoutItem"; }
  if (e->testFlag (QStyle::SE_GroupBoxLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_GroupBoxLayoutItem"; }
  if (e->testFlag (QStyle::SE_TabWidgetLayoutItem)) { if (!l.empty ()) l += "|"; l += "SE_TabWidgetLayoutItem"; }
  if (e->testFlag (QStyle::SE_ItemViewItemDecoration)) { if (!l.empty ()) l += "|"; l += "SE_ItemViewItemDecoration"; }
  if (e->testFlag (QStyle::SE_ItemViewItemText)) { if (!l.empty ()) l += "|"; l += "SE_ItemViewItemText"; }
  if (e->testFlag (QStyle::SE_ItemViewItemFocusRect)) { if (!l.empty ()) l += "|"; l += "SE_ItemViewItemFocusRect"; }
  if (e->testFlag (QStyle::SE_TabBarTabLeftButton)) { if (!l.empty ()) l += "|"; l += "SE_TabBarTabLeftButton"; }
  if (e->testFlag (QStyle::SE_TabBarTabRightButton)) { if (!l.empty ()) l += "|"; l += "SE_TabBarTabRightButton"; }
  if (e->testFlag (QStyle::SE_TabBarTabText)) { if (!l.empty ()) l += "|"; l += "SE_TabBarTabText"; }
  if (e->testFlag (QStyle::SE_ShapedFrameContents)) { if (!l.empty ()) l += "|"; l += "SE_ShapedFrameContents"; }
  if (e->testFlag (QStyle::SE_ToolBarHandle)) { if (!l.empty ()) l += "|"; l += "SE_ToolBarHandle"; }
  if (e->testFlag (QStyle::SE_CustomBase)) { if (!l.empty ()) l += "|"; l += "SE_CustomBase"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStyle_SubElement_Enums (const QStyle_SubElement_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStyle_SubElement_Enums (const QStyle_SubElement_Enums *e, const QStyle_SubElement_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStyle_SubElement_Enums> decl_QStyle_SubElement_Enums ("QStyle_QFlags_SubElement",
  gsi::method_ext ("|", &qt_gsi::oropQStyle_SubElement_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStyle_SubElement_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStyle_SubElement_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_SubElement_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_SubElement_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStyle_SubElement_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStyle::SubElement> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStyle_SubElement_Enum> decl_QStyle_SubElement_Enum (decl_QStyle_SubElement_Enums, "QStyle_SubElement",
  qt_gsi::mkdefs_QStyle_SubElement () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStyle_SubElement_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStyle_SubElement_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStyle_SubElement_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStyle_SubElement_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStyle_SubElement_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStyle::SubElement enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStyle> inject_QStyle_SubElement_Enum_in_parent (qt_gsi::mkdefs_QStyle_SubElement ());
static gsi::ClassExt<QStyle> decl_QStyle_SubElement_Enum_as_child (decl_QStyle_SubElement_Enum, "SubElement");

}

