
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStackedLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQStackedLayout_EventAdaptor.h"
#include "gsiDeclQStackedLayout_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStackedLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStackedLayout::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QStackedLayout::addItem(QLayoutItem *item)


static void _init_f_addItem_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_1740 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  ((QStackedLayout *)cls)->addItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_addItem_1740 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Method void QStackedLayout::addItem(QLayoutItem *item)\nThis is a reimplementation of QLayout::addItem", false, &_init_f_addItem_1740, &_call_f_addItem_1740);
}

// int QStackedLayout::addWidget(QWidget *w)


static void _init_f_addWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_addWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<int > ((int)((QStackedLayout *)cls)->addWidget (arg1));
}

static qt_gsi::GenericMethod *_create_f_addWidget_1315 ()
{
  return new qt_gsi::GenericMethod ("addWidget", "@brief Method int QStackedLayout::addWidget(QWidget *w)\n", false, &_init_f_addWidget_1315, &_call_f_addWidget_1315);
}

// int QStackedLayout::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QStackedLayout *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Method int QStackedLayout::count()\nThis is a reimplementation of QLayout::count", true, &_init_f_count_c0, &_call_f_count_c0);
}

// int QStackedLayout::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QStackedLayout *)cls)->currentIndex ());
}

static qt_gsi::GenericMethod *_create_f_currentIndex_c0 ()
{
  return new qt_gsi::GenericMethod (":currentIndex", "@brief Method int QStackedLayout::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
}

// QWidget *QStackedLayout::currentWidget()


static void _init_f_currentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_currentWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QStackedLayout *)cls)->currentWidget ());
}

static qt_gsi::GenericMethod *_create_f_currentWidget_c0 ()
{
  return new qt_gsi::GenericMethod (":currentWidget", "@brief Method QWidget *QStackedLayout::currentWidget()\n", true, &_init_f_currentWidget_c0, &_call_f_currentWidget_c0);
}

// int QStackedLayout::insertWidget(int index, QWidget *w)


static void _init_f_insertWidget_1974 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("w");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_insertWidget_1974 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QWidget *arg2 = args.read<QWidget * > ();
  ret.write<int > ((int)((QStackedLayout *)cls)->insertWidget (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertWidget_1974 ()
{
  return new qt_gsi::GenericMethod ("insertWidget", "@brief Method int QStackedLayout::insertWidget(int index, QWidget *w)\n", false, &_init_f_insertWidget_1974, &_call_f_insertWidget_1974);
}

// QLayoutItem *QStackedLayout::itemAt(int)


static void _init_f_itemAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QStackedLayout *)cls)->itemAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c767 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QLayoutItem *QStackedLayout::itemAt(int)\nThis is a reimplementation of QLayout::itemAt", true, &_init_f_itemAt_c767, &_call_f_itemAt_c767);
}

// QSize QStackedLayout::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QStackedLayout *)cls)->minimumSize ());
}

static qt_gsi::GenericMethod *_create_f_minimumSize_c0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@brief Method QSize QStackedLayout::minimumSize()\nThis is a reimplementation of QLayout::minimumSize", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
}

// void QStackedLayout::setCurrentIndex(int index)


static void _init_f_setCurrentIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QStackedLayout *)cls)->setCurrentIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentIndex_767 ()
{
  return new qt_gsi::GenericMethod ("setCurrentIndex|currentIndex=", "@brief Method void QStackedLayout::setCurrentIndex(int index)\n", false, &_init_f_setCurrentIndex_767, &_call_f_setCurrentIndex_767);
}

// void QStackedLayout::setCurrentWidget(QWidget *w)


static void _init_f_setCurrentWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QStackedLayout *)cls)->setCurrentWidget (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCurrentWidget_1315 ()
{
  return new qt_gsi::GenericMethod ("setCurrentWidget|currentWidget=", "@brief Method void QStackedLayout::setCurrentWidget(QWidget *w)\n", false, &_init_f_setCurrentWidget_1315, &_call_f_setCurrentWidget_1315);
}

// void QStackedLayout::setGeometry(const QRect &rect)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QStackedLayout *)cls)->setGeometry (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGeometry_1792 ()
{
  return new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QStackedLayout::setGeometry(const QRect &rect)\nThis is a reimplementation of QLayout::setGeometry", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
}

// void QStackedLayout::setStackingMode(QStackedLayout::StackingMode stackingMode)


static void _init_f_setStackingMode_3183 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stackingMode");
  decl->add_arg<const qt_gsi::Converter<QStackedLayout::StackingMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStackingMode_3183 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStackedLayout::StackingMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QStackedLayout::StackingMode>::target_type & > ();
  ((QStackedLayout *)cls)->setStackingMode (qt_gsi::QtToCppAdaptor<QStackedLayout::StackingMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setStackingMode_3183 ()
{
  return new qt_gsi::GenericMethod ("setStackingMode|stackingMode=", "@brief Method void QStackedLayout::setStackingMode(QStackedLayout::StackingMode stackingMode)\n", false, &_init_f_setStackingMode_3183, &_call_f_setStackingMode_3183);
}

// QSize QStackedLayout::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QStackedLayout *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QStackedLayout::sizeHint()\nThis is a reimplementation of QLayoutItem::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// QStackedLayout::StackingMode QStackedLayout::stackingMode()


static void _init_f_stackingMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStackedLayout::StackingMode>::target_type > ();
}

static void _call_f_stackingMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStackedLayout::StackingMode>::target_type > ((qt_gsi::Converter<QStackedLayout::StackingMode>::target_type)qt_gsi::CppToQtAdaptor<QStackedLayout::StackingMode>(((QStackedLayout *)cls)->stackingMode ()));
}

static qt_gsi::GenericMethod *_create_f_stackingMode_c0 ()
{
  return new qt_gsi::GenericMethod (":stackingMode", "@brief Method QStackedLayout::StackingMode QStackedLayout::stackingMode()\n", true, &_init_f_stackingMode_c0, &_call_f_stackingMode_c0);
}

// QLayoutItem *QStackedLayout::takeAt(int)


static void _init_f_takeAt_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QLayoutItem * > ();
}

static void _call_f_takeAt_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QStackedLayout *)cls)->takeAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_takeAt_767 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@brief Method QLayoutItem *QStackedLayout::takeAt(int)\nThis is a reimplementation of QLayout::takeAt", false, &_init_f_takeAt_767, &_call_f_takeAt_767);
}

// QWidget *QStackedLayout::widget()


static void _init_f_widget_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_widget_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QStackedLayout *)cls)->widget ());
}

static qt_gsi::GenericMethod *_create_f_widget_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@brief Method QWidget *QStackedLayout::widget()\nThis is a reimplementation of QLayoutItem::widget", false, &_init_f_widget_0, &_call_f_widget_0);
}

// QWidget *QStackedLayout::widget(int)


static void _init_f_widget_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_widget_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QWidget * > ((QWidget *)((QStackedLayout *)cls)->widget (arg1));
}

static qt_gsi::GenericMethod *_create_f_widget_c767 ()
{
  return new qt_gsi::GenericMethod ("widget", "@brief Method QWidget *QStackedLayout::widget(int)\n", true, &_init_f_widget_c767, &_call_f_widget_c767);
}

// static QString QStackedLayout::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStackedLayout::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStackedLayout::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QStackedLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStackedLayout::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStackedLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QStackedLayout::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStackedLayout::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStackedLayout::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QStackedLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStackedLayout::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStackedLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QStackedLayout, QStackedLayout_EventAdaptor> ea_QStackedLayout;

namespace gsi
{
extern gsi::Class<QLayout> decl_QLayout;

gsi::Class<QStackedLayout> decl_QStackedLayout (ea_QStackedLayout, decl_QLayout, "QStackedLayout_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addItem_1740 ()) +
  gsi::Methods(_create_f_addWidget_1315 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_currentIndex_c0 ()) +
  gsi::Methods(_create_f_currentWidget_c0 ()) +
  gsi::Methods(_create_f_insertWidget_1974 ()) +
  gsi::Methods(_create_f_itemAt_c767 ()) +
  gsi::Methods(_create_f_minimumSize_c0 ()) +
  gsi::Methods(_create_f_setCurrentIndex_767 ()) +
  gsi::Methods(_create_f_setCurrentWidget_1315 ()) +
  gsi::Methods(_create_f_setGeometry_1792 ()) +
  gsi::Methods(_create_f_setStackingMode_3183 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_stackingMode_c0 ()) +
  gsi::Methods(_create_f_takeAt_767 ()) +
  gsi::Methods(_create_f_widget_0 ()) +
  gsi::Methods(_create_f_widget_c767 ()) +
  qt_gsi::qt_signal<QStackedLayout, QStackedLayout_EventAdaptor, int> ("currentChanged", &QStackedLayout_EventAdaptor::currentChanged_e_767, gsi::arg("index"), "@brief Signal declaration for QStackedLayout::currentChanged(int index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStackedLayout, QStackedLayout_EventAdaptor, QObject *> ("destroyed", &QStackedLayout_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QStackedLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStackedLayout, QStackedLayout_EventAdaptor, int> ("widgetRemoved", &QStackedLayout_EventAdaptor::widgetRemoved_e_767, gsi::arg("index"), "@brief Signal declaration for QStackedLayout::widgetRemoved(int index)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QStackedLayout");
}


class QStackedLayout_Adaptor : public QStackedLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStackedLayout_Adaptor();

  //  [adaptor ctor] QStackedLayout::QStackedLayout()
  QStackedLayout_Adaptor() : QStackedLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStackedLayout::QStackedLayout(QWidget *parent)
  QStackedLayout_Adaptor(QWidget *parent) : QStackedLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStackedLayout::QStackedLayout(QLayout *parentLayout)
  QStackedLayout_Adaptor(QLayout *parentLayout) : QStackedLayout(parentLayout)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QStackedLayout::addChildLayout(QLayout *l)
  void fp_QStackedLayout_addChildLayout_1341 (QLayout *l) {
    QStackedLayout::addChildLayout(l);
  }

  //  void QStackedLayout::addChildWidget(QWidget *w)
  void fp_QStackedLayout_addChildWidget_1315 (QWidget *w) {
    QStackedLayout::addChildWidget(w);
  }

  //  QRect QStackedLayout::alignmentRect(const QRect &)
  QRect fp_QStackedLayout_alignmentRect_c1792 (const QRect &arg1) const {
    return QStackedLayout::alignmentRect(arg1);
  }

  //  int QStackedLayout::receivers(const char *signal)
  int fp_QStackedLayout_receivers_c1731 (const char *signal) const {
    return QStackedLayout::receivers(signal);
  }

  //  QObject *QStackedLayout::sender()
  QObject * fp_QStackedLayout_sender_c0 () const {
    return QStackedLayout::sender();
  }

  //  void QStackedLayout::widgetEvent(QEvent *)
  void fp_QStackedLayout_widgetEvent_1217 (QEvent *arg1) {
    QStackedLayout::widgetEvent(arg1);
  }

  //  [adaptor impl] void QStackedLayout::addItem(QLayoutItem *item)
  void cbs_addItem_1740_0(QLayoutItem *item)
  {
    QStackedLayout::addItem(item);
  }

  virtual void addItem(QLayoutItem *item)
  {
    if (cb_addItem_1740_0.can_issue()) {
      cb_addItem_1740_0.issue<QStackedLayout_Adaptor, QLayoutItem *>(&QStackedLayout_Adaptor::cbs_addItem_1740_0, item);
    } else {
      QStackedLayout::addItem(item);
    }
  }

  //  [adaptor impl] int QStackedLayout::count()
  int cbs_count_c0_0() const
  {
    return QStackedLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QStackedLayout_Adaptor, int>(&QStackedLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QStackedLayout::count();
    }
  }

  //  [adaptor impl] bool QStackedLayout::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QStackedLayout::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStackedLayout_Adaptor, bool, QEvent *>(&QStackedLayout_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QStackedLayout::event(arg1);
    }
  }

  //  [adaptor impl] bool QStackedLayout::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QStackedLayout::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStackedLayout_Adaptor, bool, QObject *, QEvent *>(&QStackedLayout_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QStackedLayout::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QFlags<Qt::Orientation> QStackedLayout::expandingDirections()
  qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type cbs_expandingDirections_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::Orientation> >(QStackedLayout::expandingDirections());
  }

  virtual QFlags<Qt::Orientation> expandingDirections() const
  {
    if (cb_expandingDirections_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::Orientation> >(cb_expandingDirections_c0_0.issue<QStackedLayout_Adaptor, qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type>(&QStackedLayout_Adaptor::cbs_expandingDirections_c0_0)).cref();
    } else {
      return QStackedLayout::expandingDirections();
    }
  }

  //  [adaptor impl] QRect QStackedLayout::geometry()
  QRect cbs_geometry_c0_0() const
  {
    return QStackedLayout::geometry();
  }

  virtual QRect geometry() const
  {
    if (cb_geometry_c0_0.can_issue()) {
      return cb_geometry_c0_0.issue<QStackedLayout_Adaptor, QRect>(&QStackedLayout_Adaptor::cbs_geometry_c0_0);
    } else {
      return QStackedLayout::geometry();
    }
  }

  //  [adaptor impl] bool QStackedLayout::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QStackedLayout::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QStackedLayout_Adaptor, bool>(&QStackedLayout_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QStackedLayout::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QStackedLayout::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QStackedLayout::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QStackedLayout_Adaptor, int, int>(&QStackedLayout_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QStackedLayout::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] int QStackedLayout::indexOf(QWidget *)
  int cbs_indexOf_c1315_0(QWidget *arg1) const
  {
    return QStackedLayout::indexOf(arg1);
  }

  virtual int indexOf(QWidget *arg1) const
  {
    if (cb_indexOf_c1315_0.can_issue()) {
      return cb_indexOf_c1315_0.issue<QStackedLayout_Adaptor, int, QWidget *>(&QStackedLayout_Adaptor::cbs_indexOf_c1315_0, arg1);
    } else {
      return QStackedLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] void QStackedLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QStackedLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QStackedLayout_Adaptor>(&QStackedLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QStackedLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QStackedLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QStackedLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QStackedLayout_Adaptor, bool>(&QStackedLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QStackedLayout::isEmpty();
    }
  }

  //  [adaptor impl] QLayoutItem *QStackedLayout::itemAt(int)
  QLayoutItem * cbs_itemAt_c767_0(int arg1) const
  {
    return QStackedLayout::itemAt(arg1);
  }

  virtual QLayoutItem * itemAt(int arg1) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QStackedLayout_Adaptor, QLayoutItem *, int>(&QStackedLayout_Adaptor::cbs_itemAt_c767_0, arg1);
    } else {
      return QStackedLayout::itemAt(arg1);
    }
  }

  //  [adaptor impl] QLayout *QStackedLayout::layout()
  QLayout * cbs_layout_0_0()
  {
    return QStackedLayout::layout();
  }

  virtual QLayout * layout()
  {
    if (cb_layout_0_0.can_issue()) {
      return cb_layout_0_0.issue<QStackedLayout_Adaptor, QLayout *>(&QStackedLayout_Adaptor::cbs_layout_0_0);
    } else {
      return QStackedLayout::layout();
    }
  }

  //  [adaptor impl] QSize QStackedLayout::maximumSize()
  QSize cbs_maximumSize_c0_0() const
  {
    return QStackedLayout::maximumSize();
  }

  virtual QSize maximumSize() const
  {
    if (cb_maximumSize_c0_0.can_issue()) {
      return cb_maximumSize_c0_0.issue<QStackedLayout_Adaptor, QSize>(&QStackedLayout_Adaptor::cbs_maximumSize_c0_0);
    } else {
      return QStackedLayout::maximumSize();
    }
  }

  //  [adaptor impl] int QStackedLayout::minimumHeightForWidth(int)
  int cbs_minimumHeightForWidth_c767_0(int arg1) const
  {
    return QStackedLayout::minimumHeightForWidth(arg1);
  }

  virtual int minimumHeightForWidth(int arg1) const
  {
    if (cb_minimumHeightForWidth_c767_0.can_issue()) {
      return cb_minimumHeightForWidth_c767_0.issue<QStackedLayout_Adaptor, int, int>(&QStackedLayout_Adaptor::cbs_minimumHeightForWidth_c767_0, arg1);
    } else {
      return QStackedLayout::minimumHeightForWidth(arg1);
    }
  }

  //  [adaptor impl] QSize QStackedLayout::minimumSize()
  QSize cbs_minimumSize_c0_0() const
  {
    return QStackedLayout::minimumSize();
  }

  virtual QSize minimumSize() const
  {
    if (cb_minimumSize_c0_0.can_issue()) {
      return cb_minimumSize_c0_0.issue<QStackedLayout_Adaptor, QSize>(&QStackedLayout_Adaptor::cbs_minimumSize_c0_0);
    } else {
      return QStackedLayout::minimumSize();
    }
  }

  //  [adaptor impl] void QStackedLayout::setGeometry(const QRect &rect)
  void cbs_setGeometry_1792_0(const QRect &rect)
  {
    QStackedLayout::setGeometry(rect);
  }

  virtual void setGeometry(const QRect &rect)
  {
    if (cb_setGeometry_1792_0.can_issue()) {
      cb_setGeometry_1792_0.issue<QStackedLayout_Adaptor, const QRect &>(&QStackedLayout_Adaptor::cbs_setGeometry_1792_0, rect);
    } else {
      QStackedLayout::setGeometry(rect);
    }
  }

  //  [adaptor impl] QSize QStackedLayout::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QStackedLayout::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QStackedLayout_Adaptor, QSize>(&QStackedLayout_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QStackedLayout::sizeHint();
    }
  }

  //  [adaptor impl] QSpacerItem *QStackedLayout::spacerItem()
  QSpacerItem * cbs_spacerItem_0_0()
  {
    return QStackedLayout::spacerItem();
  }

  virtual QSpacerItem * spacerItem()
  {
    if (cb_spacerItem_0_0.can_issue()) {
      return cb_spacerItem_0_0.issue<QStackedLayout_Adaptor, QSpacerItem *>(&QStackedLayout_Adaptor::cbs_spacerItem_0_0);
    } else {
      return QStackedLayout::spacerItem();
    }
  }

  //  [adaptor impl] QLayoutItem *QStackedLayout::takeAt(int)
  QLayoutItem * cbs_takeAt_767_0(int arg1)
  {
    return QStackedLayout::takeAt(arg1);
  }

  virtual QLayoutItem * takeAt(int arg1)
  {
    if (cb_takeAt_767_0.can_issue()) {
      return cb_takeAt_767_0.issue<QStackedLayout_Adaptor, QLayoutItem *, int>(&QStackedLayout_Adaptor::cbs_takeAt_767_0, arg1);
    } else {
      return QStackedLayout::takeAt(arg1);
    }
  }

  //  [adaptor impl] QWidget *QStackedLayout::widget()
  QWidget * cbs_widget_0_0()
  {
    return QStackedLayout::widget();
  }

  virtual QWidget * widget()
  {
    if (cb_widget_0_0.can_issue()) {
      return cb_widget_0_0.issue<QStackedLayout_Adaptor, QWidget *>(&QStackedLayout_Adaptor::cbs_widget_0_0);
    } else {
      return QStackedLayout::widget();
    }
  }

  //  [adaptor impl] void QStackedLayout::childEvent(QChildEvent *e)
  void cbs_childEvent_1701_0(QChildEvent *e)
  {
    QStackedLayout::childEvent(e);
  }

  virtual void childEvent(QChildEvent *e)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStackedLayout_Adaptor, QChildEvent *>(&QStackedLayout_Adaptor::cbs_childEvent_1701_0, e);
    } else {
      QStackedLayout::childEvent(e);
    }
  }

  //  [adaptor impl] void QStackedLayout::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QStackedLayout::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStackedLayout_Adaptor, QEvent *>(&QStackedLayout_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QStackedLayout::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QStackedLayout::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QStackedLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QStackedLayout_Adaptor, const char *>(&QStackedLayout_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QStackedLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QStackedLayout::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QStackedLayout::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStackedLayout_Adaptor, QTimerEvent *>(&QStackedLayout_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QStackedLayout::timerEvent(arg1);
    }
  }

  gsi::Callback cb_addItem_1740_0;
  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_expandingDirections_c0_0;
  gsi::Callback cb_geometry_c0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexOf_c1315_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_layout_0_0;
  gsi::Callback cb_maximumSize_c0_0;
  gsi::Callback cb_minimumHeightForWidth_c767_0;
  gsi::Callback cb_minimumSize_c0_0;
  gsi::Callback cb_setGeometry_1792_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_spacerItem_0_0;
  gsi::Callback cb_takeAt_767_0;
  gsi::Callback cb_widget_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStackedLayout_Adaptor::~QStackedLayout_Adaptor() { }

//  Constructor QStackedLayout::QStackedLayout() (adaptor class)

static void _init_ctor_QStackedLayout_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QStackedLayout_Adaptor *> ();
}

static void _call_ctor_QStackedLayout_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStackedLayout_Adaptor *> (new QStackedLayout_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QStackedLayout_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStackedLayout::QStackedLayout()\nThis method creates an object of class QStackedLayout.", &_init_ctor_QStackedLayout_Adaptor_0, &_call_ctor_QStackedLayout_Adaptor_0);
}

//  Constructor QStackedLayout::QStackedLayout(QWidget *parent) (adaptor class)

static void _init_ctor_QStackedLayout_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QStackedLayout_Adaptor *> ();
}

static void _call_ctor_QStackedLayout_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<QStackedLayout_Adaptor *> (new QStackedLayout_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QStackedLayout_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStackedLayout::QStackedLayout(QWidget *parent)\nThis method creates an object of class QStackedLayout.", &_init_ctor_QStackedLayout_Adaptor_1315, &_call_ctor_QStackedLayout_Adaptor_1315);
}

//  Constructor QStackedLayout::QStackedLayout(QLayout *parentLayout) (adaptor class)

static void _init_ctor_QStackedLayout_Adaptor_1341 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parentLayout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return_new<QStackedLayout_Adaptor *> ();
}

static void _call_ctor_QStackedLayout_Adaptor_1341 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  ret.write<QStackedLayout_Adaptor *> (new QStackedLayout_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QStackedLayout_Adaptor_1341 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStackedLayout::QStackedLayout(QLayout *parentLayout)\nThis method creates an object of class QStackedLayout.", &_init_ctor_QStackedLayout_Adaptor_1341, &_call_ctor_QStackedLayout_Adaptor_1341);
}

// void QStackedLayout::addChildLayout(QLayout *l)

static void _init_fp_addChildLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayout_1341 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  qt_gsi::qt_keep (arg1);
  ((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_addChildLayout_1341 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildLayout_1341 ()
{
  return new qt_gsi::GenericMethod("*addChildLayout", "@brief Method void QStackedLayout::addChildLayout(QLayout *l)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayout_1341, &_call_fp_addChildLayout_1341);
}


// void QStackedLayout::addChildWidget(QWidget *w)

static void _init_fp_addChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_addChildWidget_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildWidget_1315 ()
{
  return new qt_gsi::GenericMethod("*addChildWidget", "@brief Method void QStackedLayout::addChildWidget(QWidget *w)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildWidget_1315, &_call_fp_addChildWidget_1315);
}


// QRect QStackedLayout::alignmentRect(const QRect &)

static void _init_fp_alignmentRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_alignmentRect_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QRect > ((QRect)((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_alignmentRect_c1792 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_alignmentRect_c1792 ()
{
  return new qt_gsi::GenericMethod("*alignmentRect", "@brief Method QRect QStackedLayout::alignmentRect(const QRect &)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_alignmentRect_c1792, &_call_fp_alignmentRect_c1792);
}


// int QStackedLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QStackedLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QStackedLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QStackedLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QStackedLayout::widgetEvent(QEvent *)

static void _init_fp_widgetEvent_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_widgetEvent_1217 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_widgetEvent_1217 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_widgetEvent_1217 ()
{
  return new qt_gsi::GenericMethod("*widgetEvent", "@brief Method void QStackedLayout::widgetEvent(QEvent *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_widgetEvent_1217, &_call_fp_widgetEvent_1217);
}


// void QStackedLayout::addItem(QLayoutItem *item)

static void _init_cbs_addItem_1740_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_addItem_1740_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  ((QStackedLayout_Adaptor *)cls)->cbs_addItem_1740_0 (arg1);
}

static void _set_callback_cbs_addItem_1740_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_addItem_1740_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@hide", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Virtual method void QStackedLayout::addItem(QLayoutItem *item)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0, &_set_callback_cbs_addItem_1740_0);
}


// int QStackedLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Virtual method int QStackedLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
}


// bool QStackedLayout::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QStackedLayout::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QStackedLayout::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QStackedLayout::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// QFlags<Qt::Orientation> QStackedLayout::expandingDirections()

static void _init_cbs_expandingDirections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ();
}

static void _call_cbs_expandingDirections_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ((qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type)((QStackedLayout_Adaptor *)cls)->cbs_expandingDirections_c0_0 ());
}

static void _set_callback_cbs_expandingDirections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_expandingDirections_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@hide", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@brief Virtual method QFlags<Qt::Orientation> QStackedLayout::expandingDirections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0, &_set_callback_cbs_expandingDirections_c0_0);
}


// QRect QStackedLayout::geometry()

static void _init_cbs_geometry_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_geometry_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QStackedLayout_Adaptor *)cls)->cbs_geometry_c0_0 ());
}

static void _set_callback_cbs_geometry_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_geometry_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@hide", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@brief Virtual method QRect QStackedLayout::geometry()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0, &_set_callback_cbs_geometry_c0_0);
}


// bool QStackedLayout::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QStackedLayout::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
}


// int QStackedLayout::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QStackedLayout::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// int QStackedLayout::indexOf(QWidget *)

static void _init_cbs_indexOf_c1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_indexOf_c1315_0 (arg1));
}

static void _set_callback_cbs_indexOf_c1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_indexOf_c1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QStackedLayout::indexOf(QWidget *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0, &_set_callback_cbs_indexOf_c1315_0);
}


// void QStackedLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStackedLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QStackedLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
}


// bool QStackedLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QStackedLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
}


// QLayoutItem *QStackedLayout::itemAt(int)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QStackedLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QLayoutItem *QStackedLayout::itemAt(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
}


// QLayout *QStackedLayout::layout()

static void _init_cbs_layout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_cbs_layout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLayout * > ((QLayout *)((QStackedLayout_Adaptor *)cls)->cbs_layout_0_0 ());
}

static void _set_callback_cbs_layout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_layout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@hide", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@brief Virtual method QLayout *QStackedLayout::layout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0, &_set_callback_cbs_layout_0_0);
}


// QSize QStackedLayout::maximumSize()

static void _init_cbs_maximumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_maximumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QStackedLayout_Adaptor *)cls)->cbs_maximumSize_c0_0 ());
}

static void _set_callback_cbs_maximumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_maximumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@hide", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@brief Virtual method QSize QStackedLayout::maximumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0, &_set_callback_cbs_maximumSize_c0_0);
}


// int QStackedLayout::minimumHeightForWidth(int)

static void _init_cbs_minimumHeightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_minimumHeightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_minimumHeightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_minimumHeightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_minimumHeightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@hide", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Virtual method int QStackedLayout::minimumHeightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0, &_set_callback_cbs_minimumHeightForWidth_c767_0);
}


// QSize QStackedLayout::minimumSize()

static void _init_cbs_minimumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QStackedLayout_Adaptor *)cls)->cbs_minimumSize_c0_0 ());
}

static void _set_callback_cbs_minimumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_minimumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@hide", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@brief Virtual method QSize QStackedLayout::minimumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0, &_set_callback_cbs_minimumSize_c0_0);
}


// void QStackedLayout::setGeometry(const QRect &rect)

static void _init_cbs_setGeometry_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1792_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QStackedLayout_Adaptor *)cls)->cbs_setGeometry_1792_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_setGeometry_1792_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QStackedLayout::setGeometry(const QRect &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0, &_set_callback_cbs_setGeometry_1792_0);
}


// QSize QStackedLayout::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QStackedLayout_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QStackedLayout::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// QSpacerItem *QStackedLayout::spacerItem()

static void _init_cbs_spacerItem_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSpacerItem * > ();
}

static void _call_cbs_spacerItem_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSpacerItem * > ((QSpacerItem *)((QStackedLayout_Adaptor *)cls)->cbs_spacerItem_0_0 ());
}

static void _set_callback_cbs_spacerItem_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_spacerItem_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@hide", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@brief Virtual method QSpacerItem *QStackedLayout::spacerItem()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0, &_set_callback_cbs_spacerItem_0_0);
}


// QLayoutItem *QStackedLayout::takeAt(int)

static void _init_cbs_takeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_takeAt_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QStackedLayout_Adaptor *)cls)->cbs_takeAt_767_0 (arg1));
}

static void _set_callback_cbs_takeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_takeAt_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@hide", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@brief Virtual method QLayoutItem *QStackedLayout::takeAt(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0, &_set_callback_cbs_takeAt_767_0);
}


// QWidget *QStackedLayout::widget()

static void _init_cbs_widget_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_cbs_widget_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QStackedLayout_Adaptor *)cls)->cbs_widget_0_0 ());
}

static void _set_callback_cbs_widget_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_widget_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@hide", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@brief Virtual method QWidget *QStackedLayout::widget()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0, &_set_callback_cbs_widget_0_0);
}


// void QStackedLayout::childEvent(QChildEvent *e)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QStackedLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStackedLayout::childEvent(QChildEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QStackedLayout::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QStackedLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStackedLayout::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QStackedLayout::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QStackedLayout_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStackedLayout::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QStackedLayout::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QStackedLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStackedLayout::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QStackedLayout> decl_QStackedLayout;

gsi::Class<QStackedLayout_Adaptor> decl_QStackedLayout_Adaptor (decl_QStackedLayout, "QStackedLayout",
  gsi::Methods(_create_fp_addChildLayout_1341 ()) +
  gsi::Methods(_create_fp_addChildWidget_1315 ()) +
  gsi::Methods(_create_fp_alignmentRect_c1792 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_widgetEvent_1217 ()) +
  gsi::Methods(_create_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_callback_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_cbs_count_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_count_c0_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_callback_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_callback_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_cbs_layout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_layout_0_0 ()) +
  gsi::Methods(_create_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_callback_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_callback_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_callback_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_cbs_widget_0_0 ()) +
  gsi::Methods(_create_callback_cbs_widget_0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QStackedLayout_Adaptor_0 ()) +
  gsi::Methods(_create_ctor_QStackedLayout_Adaptor_1315 ()) +
  gsi::Methods(_create_ctor_QStackedLayout_Adaptor_1341 ()),
  "@qt\n@brief Binding of QStackedLayout");

}


//  Implementation of the enum wrapper class for QStackedLayout::StackingMode
namespace qt_gsi
{

static QStackedLayout_StackingMode_Enum *c_1_QStackedLayout_StackingMode_Enum () { return new QStackedLayout_StackingMode_Enum (QStackedLayout::StackOne); }
static QStackedLayout_StackingMode_Enum *c_2_QStackedLayout_StackingMode_Enum () { return new QStackedLayout_StackingMode_Enum (QStackedLayout::StackAll); }

static gsi::Methods mkdefs_QStackedLayout_StackingMode () {
  return
    gsi::constant ("StackOne", &qt_gsi::c_1_QStackedLayout_StackingMode_Enum, "@brief Enum constant QStackedLayout::StackOne") +
    gsi::constant ("StackAll", &qt_gsi::c_2_QStackedLayout_StackingMode_Enum, "@brief Enum constant QStackedLayout::StackAll");
}

static std::string to_s_QStackedLayout_StackingMode_Enum (const QStackedLayout_StackingMode_Enum *e)
{
  if (e->value () == QStackedLayout::StackOne) { return tl::sprintf ("StackOne (%u)", (unsigned int) e->value ()); }
  if (e->value () == QStackedLayout::StackAll) { return tl::sprintf ("StackAll (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QStackedLayout_StackingMode_Enum (const QStackedLayout_StackingMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QStackedLayout_StackingMode_Enum *from_i_QStackedLayout_StackingMode_Enum (unsigned int i)
{
  return new QStackedLayout_StackingMode_Enum ((QStackedLayout::StackingMode) i);
}

static bool equalQStackedLayout_StackingMode_Enum (const QStackedLayout_StackingMode_Enum *e, QStackedLayout_StackingMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QStackedLayout_StackingMode_Enum (const QStackedLayout_StackingMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QStackedLayout_StackingMode_Enums oropQStackedLayout_StackingMode_Enums (const QStackedLayout_StackingMode_Enums *e, const QStackedLayout_StackingMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QStackedLayout_StackingMode_Enums andopQStackedLayout_StackingMode_Enums (const QStackedLayout_StackingMode_Enums *e, const QStackedLayout_StackingMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QStackedLayout_StackingMode_Enums xoropQStackedLayout_StackingMode_Enums (const QStackedLayout_StackingMode_Enums *e, const QStackedLayout_StackingMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QStackedLayout_StackingMode_Enums (const QStackedLayout_StackingMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QStackedLayout::StackOne)) { if (!l.empty ()) l += "|"; l += "StackOne"; }
  if (e->testFlag (QStackedLayout::StackAll)) { if (!l.empty ()) l += "|"; l += "StackAll"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QStackedLayout_StackingMode_Enums (const QStackedLayout_StackingMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QStackedLayout_StackingMode_Enums (const QStackedLayout_StackingMode_Enums *e, const QStackedLayout_StackingMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QStackedLayout_StackingMode_Enums> decl_QStackedLayout_StackingMode_Enums ("QStackedLayout_QFlags_StackingMode",
  gsi::method_ext ("|", &qt_gsi::oropQStackedLayout_StackingMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQStackedLayout_StackingMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQStackedLayout_StackingMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStackedLayout_StackingMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStackedLayout_StackingMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QStackedLayout_StackingMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QStackedLayout::StackingMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QStackedLayout_StackingMode_Enum> decl_QStackedLayout_StackingMode_Enum (decl_QStackedLayout_StackingMode_Enums, "QStackedLayout_StackingMode",
  qt_gsi::mkdefs_QStackedLayout_StackingMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QStackedLayout_StackingMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QStackedLayout_StackingMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQStackedLayout_StackingMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QStackedLayout_StackingMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QStackedLayout_StackingMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QStackedLayout::StackingMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QStackedLayout> inject_QStackedLayout_StackingMode_Enum_in_parent (qt_gsi::mkdefs_QStackedLayout_StackingMode ());
static gsi::ClassExt<QStackedLayout> decl_QStackedLayout_StackingMode_Enum_as_child (decl_QStackedLayout_StackingMode_Enum, "StackingMode");

}

