
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSqlTableModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtSql.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSqlTableModel_EventAdaptor.h"
#include "gsiDeclQSqlTableModel_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSqlTableModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSqlTableModel::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

//  Constructor QSqlTableModel::QSqlTableModel(QObject *parent, QSqlDatabase db)


static void _init_ctor_QSqlTableModel_2804 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("db", true, "QSqlDatabase()");
  decl->add_arg<QSqlDatabase > (argspec_1);
  decl->set_return_new<QSqlTableModel *> ();
}

static void _call_ctor_QSqlTableModel_2804 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  QSqlDatabase arg2 = args ? args.read<QSqlDatabase > () : (QSqlDatabase)(QSqlDatabase());
  ret.write<QSqlTableModel *> (new QSqlTableModel (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSqlTableModel_2804 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlTableModel::QSqlTableModel(QObject *parent, QSqlDatabase db)\nThis method creates an object of class QSqlTableModel.", &_init_ctor_QSqlTableModel_2804, &_call_ctor_QSqlTableModel_2804);
}

// void QSqlTableModel::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSqlTableModel *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QSqlTableModel::clear()\nThis is a reimplementation of QSqlQueryModel::clear", false, &_init_f_clear_0, &_call_f_clear_0);
}

// QVariant QSqlTableModel::data(const QModelIndex &idx, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args ? args.read<int > () : (int)(Qt::DisplayRole);
  ret.write<QVariant > ((QVariant)((QSqlTableModel *)cls)->data (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_data_c3054 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method QVariant QSqlTableModel::data(const QModelIndex &idx, int role)\nThis is a reimplementation of QSqlQueryModel::data", true, &_init_f_data_c3054, &_call_f_data_c3054);
}

// QSqlDatabase QSqlTableModel::database()


static void _init_f_database_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlDatabase > ();
}

static void _call_f_database_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSqlDatabase > ((QSqlDatabase)((QSqlTableModel *)cls)->database ());
}

static qt_gsi::GenericMethod *_create_f_database_c0 ()
{
  return new qt_gsi::GenericMethod ("database", "@brief Method QSqlDatabase QSqlTableModel::database()\n", true, &_init_f_database_c0, &_call_f_database_c0);
}

// QSqlTableModel::EditStrategy QSqlTableModel::editStrategy()


static void _init_f_editStrategy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type > ();
}

static void _call_f_editStrategy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type > ((qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type)qt_gsi::CppToQtAdaptor<QSqlTableModel::EditStrategy>(((QSqlTableModel *)cls)->editStrategy ()));
}

static qt_gsi::GenericMethod *_create_f_editStrategy_c0 ()
{
  return new qt_gsi::GenericMethod (":editStrategy", "@brief Method QSqlTableModel::EditStrategy QSqlTableModel::editStrategy()\n", true, &_init_f_editStrategy_c0, &_call_f_editStrategy_c0);
}

// int QSqlTableModel::fieldIndex(const QString &fieldName)


static void _init_f_fieldIndex_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fieldName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_fieldIndex_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<int > ((int)((QSqlTableModel *)cls)->fieldIndex (arg1));
}

static qt_gsi::GenericMethod *_create_f_fieldIndex_c2025 ()
{
  return new qt_gsi::GenericMethod ("fieldIndex", "@brief Method int QSqlTableModel::fieldIndex(const QString &fieldName)\n", true, &_init_f_fieldIndex_c2025, &_call_f_fieldIndex_c2025);
}

// QString QSqlTableModel::filter()


static void _init_f_filter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_filter_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QSqlTableModel *)cls)->filter ());
}

static qt_gsi::GenericMethod *_create_f_filter_c0 ()
{
  return new qt_gsi::GenericMethod (":filter", "@brief Method QString QSqlTableModel::filter()\n", true, &_init_f_filter_c0, &_call_f_filter_c0);
}

// QFlags<Qt::ItemFlag> QSqlTableModel::flags(const QModelIndex &index)


static void _init_f_flags_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_f_flags_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(((QSqlTableModel *)cls)->flags (arg1)));
}

static qt_gsi::GenericMethod *_create_f_flags_c2395 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<Qt::ItemFlag> QSqlTableModel::flags(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::flags", true, &_init_f_flags_c2395, &_call_f_flags_c2395);
}

// QVariant QSqlTableModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::DisplayRole);
  ret.write<QVariant > ((QVariant)((QSqlTableModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}

static qt_gsi::GenericMethod *_create_f_headerData_c3231 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QSqlTableModel::headerData(int section, Qt::Orientation orientation, int role)\nThis is a reimplementation of QSqlQueryModel::headerData", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
}

// bool QSqlTableModel::insertRecord(int row, const QSqlRecord &record)


static void _init_f_insertRecord_2964 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("record");
  decl->add_arg<const QSqlRecord & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_insertRecord_2964 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QSqlRecord &arg2 = args.read<const QSqlRecord & > ();
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->insertRecord (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertRecord_2964 ()
{
  return new qt_gsi::GenericMethod ("insertRecord", "@brief Method bool QSqlTableModel::insertRecord(int row, const QSqlRecord &record)\n", false, &_init_f_insertRecord_2964, &_call_f_insertRecord_2964);
}

// bool QSqlTableModel::insertRows(int row, int count, const QModelIndex &parent)


static void _init_f_insertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->insertRows (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_insertRows_3713 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Method bool QSqlTableModel::insertRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertRows", false, &_init_f_insertRows_3713, &_call_f_insertRows_3713);
}

// bool QSqlTableModel::isDirty(const QModelIndex &index)


static void _init_f_isDirty_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isDirty_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->isDirty (arg1));
}

static qt_gsi::GenericMethod *_create_f_isDirty_c2395 ()
{
  return new qt_gsi::GenericMethod ("isDirty?", "@brief Method bool QSqlTableModel::isDirty(const QModelIndex &index)\n", true, &_init_f_isDirty_c2395, &_call_f_isDirty_c2395);
}

// QSqlIndex QSqlTableModel::primaryKey()


static void _init_f_primaryKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlIndex > ();
}

static void _call_f_primaryKey_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSqlIndex > ((QSqlIndex)((QSqlTableModel *)cls)->primaryKey ());
}

static qt_gsi::GenericMethod *_create_f_primaryKey_c0 ()
{
  return new qt_gsi::GenericMethod ("primaryKey", "@brief Method QSqlIndex QSqlTableModel::primaryKey()\n", true, &_init_f_primaryKey_c0, &_call_f_primaryKey_c0);
}

// bool QSqlTableModel::removeColumns(int column, int count, const QModelIndex &parent)


static void _init_f_removeColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->removeColumns (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_removeColumns_3713 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@brief Method bool QSqlTableModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QSqlQueryModel::removeColumns", false, &_init_f_removeColumns_3713, &_call_f_removeColumns_3713);
}

// bool QSqlTableModel::removeRows(int row, int count, const QModelIndex &parent)


static void _init_f_removeRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->removeRows (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_removeRows_3713 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Method bool QSqlTableModel::removeRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeRows", false, &_init_f_removeRows_3713, &_call_f_removeRows_3713);
}

// void QSqlTableModel::revert()


static void _init_f_revert_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_revert_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSqlTableModel *)cls)->revert ();
}

static qt_gsi::GenericMethod *_create_f_revert_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@brief Method void QSqlTableModel::revert()\nThis is a reimplementation of QAbstractItemModel::revert", false, &_init_f_revert_0, &_call_f_revert_0);
}

// void QSqlTableModel::revertAll()


static void _init_f_revertAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_revertAll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSqlTableModel *)cls)->revertAll ();
}

static qt_gsi::GenericMethod *_create_f_revertAll_0 ()
{
  return new qt_gsi::GenericMethod ("revertAll", "@brief Method void QSqlTableModel::revertAll()\n", false, &_init_f_revertAll_0, &_call_f_revertAll_0);
}

// void QSqlTableModel::revertRow(int row)


static void _init_f_revertRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_revertRow_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QSqlTableModel *)cls)->revertRow (arg1);
}

static qt_gsi::GenericMethod *_create_f_revertRow_767 ()
{
  return new qt_gsi::GenericMethod ("revertRow", "@brief Method void QSqlTableModel::revertRow(int row)\n", false, &_init_f_revertRow_767, &_call_f_revertRow_767);
}

// int QSqlTableModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<int > ((int)((QSqlTableModel *)cls)->rowCount (arg1));
}

static qt_gsi::GenericMethod *_create_f_rowCount_c2395 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Method int QSqlTableModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QSqlQueryModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
}

// bool QSqlTableModel::select()


static void _init_f_select_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_select_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->select ());
}

static qt_gsi::GenericMethod *_create_f_select_0 ()
{
  return new qt_gsi::GenericMethod ("select", "@brief Method bool QSqlTableModel::select()\n", false, &_init_f_select_0, &_call_f_select_0);
}

// bool QSqlTableModel::setData(const QModelIndex &index, const QVariant &value, int role)


static void _init_f_setData_5065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setData_5065 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::EditRole);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->setData (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_setData_5065 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Method bool QSqlTableModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis is a reimplementation of QAbstractItemModel::setData", false, &_init_f_setData_5065, &_call_f_setData_5065);
}

// void QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)


static void _init_f_setEditStrategy_3163 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strategy");
  decl->add_arg<const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEditStrategy_3163 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & arg1 = args.read<const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & > ();
  ((QSqlTableModel *)cls)->setEditStrategy (qt_gsi::QtToCppAdaptor<QSqlTableModel::EditStrategy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setEditStrategy_3163 ()
{
  return new qt_gsi::GenericMethod ("setEditStrategy|editStrategy=", "@brief Method void QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)\n", false, &_init_f_setEditStrategy_3163, &_call_f_setEditStrategy_3163);
}

// void QSqlTableModel::setFilter(const QString &filter)


static void _init_f_setFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QSqlTableModel *)cls)->setFilter (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFilter_2025 ()
{
  return new qt_gsi::GenericMethod ("setFilter|filter=", "@brief Method void QSqlTableModel::setFilter(const QString &filter)\n", false, &_init_f_setFilter_2025, &_call_f_setFilter_2025);
}

// bool QSqlTableModel::setRecord(int row, const QSqlRecord &record)


static void _init_f_setRecord_2964 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("record");
  decl->add_arg<const QSqlRecord & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setRecord_2964 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QSqlRecord &arg2 = args.read<const QSqlRecord & > ();
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->setRecord (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_setRecord_2964 ()
{
  return new qt_gsi::GenericMethod ("setRecord", "@brief Method bool QSqlTableModel::setRecord(int row, const QSqlRecord &record)\n", false, &_init_f_setRecord_2964, &_call_f_setRecord_2964);
}

// void QSqlTableModel::setSort(int column, Qt::SortOrder order)


static void _init_f_setSort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSort_2340 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ((QSqlTableModel *)cls)->setSort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setSort_2340 ()
{
  return new qt_gsi::GenericMethod ("setSort", "@brief Method void QSqlTableModel::setSort(int column, Qt::SortOrder order)\n", false, &_init_f_setSort_2340, &_call_f_setSort_2340);
}

// void QSqlTableModel::setTable(const QString &tableName)


static void _init_f_setTable_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTable_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QSqlTableModel *)cls)->setTable (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTable_2025 ()
{
  return new qt_gsi::GenericMethod ("setTable", "@brief Method void QSqlTableModel::setTable(const QString &tableName)\n", false, &_init_f_setTable_2025, &_call_f_setTable_2025);
}

// void QSqlTableModel::sort(int column, Qt::SortOrder order)


static void _init_f_sort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sort_2340 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ((QSqlTableModel *)cls)->sort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_sort_2340 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Method void QSqlTableModel::sort(int column, Qt::SortOrder order)\nThis is a reimplementation of QAbstractItemModel::sort", false, &_init_f_sort_2340, &_call_f_sort_2340);
}

// bool QSqlTableModel::submit()


static void _init_f_submit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_submit_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->submit ());
}

static qt_gsi::GenericMethod *_create_f_submit_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@brief Method bool QSqlTableModel::submit()\nThis is a reimplementation of QAbstractItemModel::submit", false, &_init_f_submit_0, &_call_f_submit_0);
}

// bool QSqlTableModel::submitAll()


static void _init_f_submitAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_submitAll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->submitAll ());
}

static qt_gsi::GenericMethod *_create_f_submitAll_0 ()
{
  return new qt_gsi::GenericMethod ("submitAll", "@brief Method bool QSqlTableModel::submitAll()\n", false, &_init_f_submitAll_0, &_call_f_submitAll_0);
}

// QString QSqlTableModel::tableName()


static void _init_f_tableName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_tableName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QSqlTableModel *)cls)->tableName ());
}

static qt_gsi::GenericMethod *_create_f_tableName_c0 ()
{
  return new qt_gsi::GenericMethod ("tableName", "@brief Method QString QSqlTableModel::tableName()\n", true, &_init_f_tableName_c0, &_call_f_tableName_c0);
}

// static QString QSqlTableModel::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSqlTableModel::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSqlTableModel::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QSqlTableModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSqlTableModel::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSqlTableModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QSqlTableModel::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSqlTableModel::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSqlTableModel::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QSqlTableModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSqlTableModel::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSqlTableModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QSqlTableModel, QSqlTableModel_EventAdaptor> ea_QSqlTableModel;


namespace gsi
{
extern gsi::Class<QSqlQueryModel> decl_QSqlQueryModel;

gsi::Class<QSqlTableModel> decl_QSqlTableModel (ea_QSqlTableModel, decl_QSqlQueryModel, "QSqlTableModel",
  gsi::Methods(_create_ctor_QSqlTableModel_2804 ()) +
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_data_c3054 ()) +
  gsi::Methods(_create_f_database_c0 ()) +
  gsi::Methods(_create_f_editStrategy_c0 ()) +
  gsi::Methods(_create_f_fieldIndex_c2025 ()) +
  gsi::Methods(_create_f_filter_c0 ()) +
  gsi::Methods(_create_f_flags_c2395 ()) +
  gsi::Methods(_create_f_headerData_c3231 ()) +
  gsi::Methods(_create_f_insertRecord_2964 ()) +
  gsi::Methods(_create_f_insertRows_3713 ()) +
  gsi::Methods(_create_f_isDirty_c2395 ()) +
  gsi::Methods(_create_f_primaryKey_c0 ()) +
  gsi::Methods(_create_f_removeColumns_3713 ()) +
  gsi::Methods(_create_f_removeRows_3713 ()) +
  gsi::Methods(_create_f_revert_0 ()) +
  gsi::Methods(_create_f_revertAll_0 ()) +
  gsi::Methods(_create_f_revertRow_767 ()) +
  gsi::Methods(_create_f_rowCount_c2395 ()) +
  gsi::Methods(_create_f_select_0 ()) +
  gsi::Methods(_create_f_setData_5065 ()) +
  gsi::Methods(_create_f_setEditStrategy_3163 ()) +
  gsi::Methods(_create_f_setFilter_2025 ()) +
  gsi::Methods(_create_f_setRecord_2964 ()) +
  gsi::Methods(_create_f_setSort_2340 ()) +
  gsi::Methods(_create_f_setTable_2025 ()) +
  gsi::Methods(_create_f_sort_2340 ()) +
  gsi::Methods(_create_f_submit_0 ()) +
  gsi::Methods(_create_f_submitAll_0 ()) +
  gsi::Methods(_create_f_tableName_c0 ()) +
  qt_gsi::qt_signal<QSqlTableModel, QSqlTableModel_EventAdaptor, int> ("beforeDelete", &QSqlTableModel_EventAdaptor::beforeDelete_e_767, gsi::arg("row"), "@brief Signal declaration for QSqlTableModel::beforeDelete(int row)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSqlTableModel, QSqlTableModel_EventAdaptor, QSqlRecord &> ("beforeInsert", &QSqlTableModel_EventAdaptor::beforeInsert_e_1610, gsi::arg("record"), "@brief Signal declaration for QSqlTableModel::beforeInsert(QSqlRecord &record)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSqlTableModel, QSqlTableModel_EventAdaptor, int, QSqlRecord &> ("beforeUpdate", &QSqlTableModel_EventAdaptor::beforeUpdate_e_2269, gsi::arg("row"), gsi::arg("record"), "@brief Signal declaration for QSqlTableModel::beforeUpdate(int row, QSqlRecord &record)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSqlTableModel, QSqlTableModel_EventAdaptor, const QModelIndex &, const QModelIndex &> ("dataChanged", &QSqlTableModel_EventAdaptor::dataChanged_e_4682, gsi::arg("topLeft"), gsi::arg("bottomRight"), "@brief Signal declaration for QSqlTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSqlTableModel, QSqlTableModel_EventAdaptor, QObject *> ("destroyed", &QSqlTableModel_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QSqlTableModel::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSqlTableModel, QSqlTableModel_EventAdaptor, const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int> ("headerDataChanged", &QSqlTableModel_EventAdaptor::headerDataChanged_e_3231, gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSqlTableModel, QSqlTableModel_EventAdaptor> ("layoutAboutToBeChanged", &QSqlTableModel_EventAdaptor::layoutAboutToBeChanged_e_0, "@brief Signal declaration for QSqlTableModel::layoutAboutToBeChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSqlTableModel, QSqlTableModel_EventAdaptor> ("layoutChanged", &QSqlTableModel_EventAdaptor::layoutChanged_e_0, "@brief Signal declaration for QSqlTableModel::layoutChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSqlTableModel, QSqlTableModel_EventAdaptor, int, QSqlRecord &> ("primeInsert", &QSqlTableModel_EventAdaptor::primeInsert_e_2269, gsi::arg("row"), gsi::arg("record"), "@brief Signal declaration for QSqlTableModel::primeInsert(int row, QSqlRecord &record)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QSqlTableModel");

}


//  Implementation of the enum wrapper class for QSqlTableModel::EditStrategy
namespace qt_gsi
{

static QSqlTableModel_EditStrategy_Enum *c_1_QSqlTableModel_EditStrategy_Enum () { return new QSqlTableModel_EditStrategy_Enum (QSqlTableModel::OnFieldChange); }
static QSqlTableModel_EditStrategy_Enum *c_2_QSqlTableModel_EditStrategy_Enum () { return new QSqlTableModel_EditStrategy_Enum (QSqlTableModel::OnRowChange); }
static QSqlTableModel_EditStrategy_Enum *c_3_QSqlTableModel_EditStrategy_Enum () { return new QSqlTableModel_EditStrategy_Enum (QSqlTableModel::OnManualSubmit); }

static gsi::Methods mkdefs_QSqlTableModel_EditStrategy () {
  return
    gsi::constant ("OnFieldChange", &qt_gsi::c_1_QSqlTableModel_EditStrategy_Enum, "@brief Enum constant QSqlTableModel::OnFieldChange") +
    gsi::constant ("OnRowChange", &qt_gsi::c_2_QSqlTableModel_EditStrategy_Enum, "@brief Enum constant QSqlTableModel::OnRowChange") +
    gsi::constant ("OnManualSubmit", &qt_gsi::c_3_QSqlTableModel_EditStrategy_Enum, "@brief Enum constant QSqlTableModel::OnManualSubmit");
}

static std::string to_s_QSqlTableModel_EditStrategy_Enum (const QSqlTableModel_EditStrategy_Enum *e)
{
  if (e->value () == QSqlTableModel::OnFieldChange) { return tl::sprintf ("OnFieldChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlTableModel::OnRowChange) { return tl::sprintf ("OnRowChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlTableModel::OnManualSubmit) { return tl::sprintf ("OnManualSubmit (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSqlTableModel_EditStrategy_Enum (const QSqlTableModel_EditStrategy_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSqlTableModel_EditStrategy_Enum *from_i_QSqlTableModel_EditStrategy_Enum (unsigned int i)
{
  return new QSqlTableModel_EditStrategy_Enum ((QSqlTableModel::EditStrategy) i);
}

static bool equalQSqlTableModel_EditStrategy_Enum (const QSqlTableModel_EditStrategy_Enum *e, QSqlTableModel_EditStrategy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSqlTableModel_EditStrategy_Enum (const QSqlTableModel_EditStrategy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSqlTableModel_EditStrategy_Enums oropQSqlTableModel_EditStrategy_Enums (const QSqlTableModel_EditStrategy_Enums *e, const QSqlTableModel_EditStrategy_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSqlTableModel_EditStrategy_Enums andopQSqlTableModel_EditStrategy_Enums (const QSqlTableModel_EditStrategy_Enums *e, const QSqlTableModel_EditStrategy_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSqlTableModel_EditStrategy_Enums xoropQSqlTableModel_EditStrategy_Enums (const QSqlTableModel_EditStrategy_Enums *e, const QSqlTableModel_EditStrategy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSqlTableModel_EditStrategy_Enums (const QSqlTableModel_EditStrategy_Enums *e)
{
  std::string l;
  if (e->testFlag (QSqlTableModel::OnFieldChange)) { if (!l.empty ()) l += "|"; l += "OnFieldChange"; }
  if (e->testFlag (QSqlTableModel::OnRowChange)) { if (!l.empty ()) l += "|"; l += "OnRowChange"; }
  if (e->testFlag (QSqlTableModel::OnManualSubmit)) { if (!l.empty ()) l += "|"; l += "OnManualSubmit"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSqlTableModel_EditStrategy_Enums (const QSqlTableModel_EditStrategy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSqlTableModel_EditStrategy_Enums (const QSqlTableModel_EditStrategy_Enums *e, const QSqlTableModel_EditStrategy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSqlTableModel_EditStrategy_Enums> decl_QSqlTableModel_EditStrategy_Enums ("QSqlTableModel_QFlags_EditStrategy",
  gsi::method_ext ("|", &qt_gsi::oropQSqlTableModel_EditStrategy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSqlTableModel_EditStrategy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSqlTableModel_EditStrategy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlTableModel_EditStrategy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlTableModel_EditStrategy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSqlTableModel_EditStrategy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSqlTableModel::EditStrategy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSqlTableModel_EditStrategy_Enum> decl_QSqlTableModel_EditStrategy_Enum (decl_QSqlTableModel_EditStrategy_Enums, "QSqlTableModel_EditStrategy",
  qt_gsi::mkdefs_QSqlTableModel_EditStrategy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlTableModel_EditStrategy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlTableModel_EditStrategy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSqlTableModel_EditStrategy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSqlTableModel_EditStrategy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSqlTableModel_EditStrategy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSqlTableModel::EditStrategy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlTableModel> inject_QSqlTableModel_EditStrategy_Enum_in_parent (qt_gsi::mkdefs_QSqlTableModel_EditStrategy ());
static gsi::ClassExt<QSqlTableModel> decl_QSqlTableModel_EditStrategy_Enum_as_child (decl_QSqlTableModel_EditStrategy_Enum, "EditStrategy");

}

