
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSocketNotifier.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSocketNotifier_EventAdaptor.h"
#include "gsiDeclQSocketNotifier_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSocketNotifier

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSocketNotifier::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QSocketNotifier::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSocketNotifier *)cls)->isEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QSocketNotifier::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
}

// void QSocketNotifier::setEnabled(bool)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QSocketNotifier *)cls)->setEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QSocketNotifier::setEnabled(bool)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
}

// int QSocketNotifier::socket()


static void _init_f_socket_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_socket_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QSocketNotifier *)cls)->socket ());
}

static qt_gsi::GenericMethod *_create_f_socket_c0 ()
{
  return new qt_gsi::GenericMethod ("socket", "@brief Method int QSocketNotifier::socket()\n", true, &_init_f_socket_c0, &_call_f_socket_c0);
}

// QSocketNotifier::Type QSocketNotifier::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSocketNotifier::Type>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSocketNotifier::Type>::target_type > ((qt_gsi::Converter<QSocketNotifier::Type>::target_type)qt_gsi::CppToQtAdaptor<QSocketNotifier::Type>(((QSocketNotifier *)cls)->type ()));
}

static qt_gsi::GenericMethod *_create_f_type_c0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method QSocketNotifier::Type QSocketNotifier::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
}

// static QString QSocketNotifier::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSocketNotifier::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSocketNotifier::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QSocketNotifier::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSocketNotifier::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSocketNotifier::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QSocketNotifier::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSocketNotifier::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSocketNotifier::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QSocketNotifier::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSocketNotifier::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSocketNotifier::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QSocketNotifier, QSocketNotifier_EventAdaptor> ea_QSocketNotifier;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QSocketNotifier> decl_QSocketNotifier (ea_QSocketNotifier, decl_QObject, "QSocketNotifier_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_isEnabled_c0 ()) +
  gsi::Methods(_create_f_setEnabled_864 ()) +
  gsi::Methods(_create_f_socket_c0 ()) +
  gsi::Methods(_create_f_type_c0 ()) +
  qt_gsi::qt_signal<QSocketNotifier, QSocketNotifier_EventAdaptor, int> ("activated", &QSocketNotifier_EventAdaptor::activated_e_767, gsi::arg("socket"), "@brief Signal declaration for QSocketNotifier::activated(int socket)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSocketNotifier, QSocketNotifier_EventAdaptor, QObject *> ("destroyed", &QSocketNotifier_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QSocketNotifier::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QSocketNotifier");
}


class QSocketNotifier_Adaptor : public QSocketNotifier, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSocketNotifier_Adaptor();

  //  [adaptor ctor] QSocketNotifier::QSocketNotifier(int socket, QSocketNotifier::Type, QObject *parent)
  QSocketNotifier_Adaptor(int socket, QSocketNotifier::Type arg2) : QSocketNotifier(socket, arg2)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSocketNotifier::QSocketNotifier(int socket, QSocketNotifier::Type, QObject *parent)
  QSocketNotifier_Adaptor(int socket, QSocketNotifier::Type arg2, QObject *parent) : QSocketNotifier(socket, arg2, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QSocketNotifier::receivers(const char *signal)
  int fp_QSocketNotifier_receivers_c1731 (const char *signal) const {
    return QSocketNotifier::receivers(signal);
  }

  //  QObject *QSocketNotifier::sender()
  QObject * fp_QSocketNotifier_sender_c0 () const {
    return QSocketNotifier::sender();
  }

  //  [adaptor impl] bool QSocketNotifier::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSocketNotifier::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSocketNotifier_Adaptor, bool, QObject *, QEvent *>(&QSocketNotifier_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSocketNotifier::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QSocketNotifier::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSocketNotifier::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSocketNotifier_Adaptor, QChildEvent *>(&QSocketNotifier_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSocketNotifier::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSocketNotifier::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSocketNotifier::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSocketNotifier_Adaptor, QEvent *>(&QSocketNotifier_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSocketNotifier::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QSocketNotifier::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QSocketNotifier::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QSocketNotifier_Adaptor, const char *>(&QSocketNotifier_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QSocketNotifier::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QSocketNotifier::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QSocketNotifier::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSocketNotifier_Adaptor, bool, QEvent *>(&QSocketNotifier_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QSocketNotifier::event(arg1);
    }
  }

  //  [adaptor impl] void QSocketNotifier::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSocketNotifier::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSocketNotifier_Adaptor, QTimerEvent *>(&QSocketNotifier_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSocketNotifier::timerEvent(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSocketNotifier_Adaptor::~QSocketNotifier_Adaptor() { }

//  Constructor QSocketNotifier::QSocketNotifier(int socket, QSocketNotifier::Type, QObject *parent) (adaptor class)

static void _init_ctor_QSocketNotifier_Adaptor_4353 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socket");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const qt_gsi::Converter<QSocketNotifier::Type>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QSocketNotifier_Adaptor *> ();
}

static void _call_ctor_QSocketNotifier_Adaptor_4353 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QSocketNotifier::Type>::target_type & arg2 = args.read<const qt_gsi::Converter<QSocketNotifier::Type>::target_type & > ();
  QObject *arg3 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSocketNotifier_Adaptor *> (new QSocketNotifier_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QSocketNotifier::Type>(arg2).cref(), arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSocketNotifier_Adaptor_4353 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSocketNotifier::QSocketNotifier(int socket, QSocketNotifier::Type, QObject *parent)\nThis method creates an object of class QSocketNotifier.", &_init_ctor_QSocketNotifier_Adaptor_4353, &_call_ctor_QSocketNotifier_Adaptor_4353);
}

// int QSocketNotifier::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QSocketNotifier_Adaptor *)cls)->fp_QSocketNotifier_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QSocketNotifier::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QSocketNotifier::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QSocketNotifier_Adaptor *)cls)->fp_QSocketNotifier_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QSocketNotifier::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QSocketNotifier::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSocketNotifier_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSocketNotifier_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSocketNotifier::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QSocketNotifier::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QSocketNotifier_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSocketNotifier_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSocketNotifier::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QSocketNotifier::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QSocketNotifier_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSocketNotifier_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSocketNotifier::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QSocketNotifier::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QSocketNotifier_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QSocketNotifier_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSocketNotifier::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QSocketNotifier::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSocketNotifier_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSocketNotifier_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QSocketNotifier::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QSocketNotifier::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QSocketNotifier_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSocketNotifier_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSocketNotifier::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QSocketNotifier> decl_QSocketNotifier;

gsi::Class<QSocketNotifier_Adaptor> decl_QSocketNotifier_Adaptor (decl_QSocketNotifier, "QSocketNotifier",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QSocketNotifier_Adaptor_4353 ()),
  "@qt\n@brief Binding of QSocketNotifier");

}


//  Implementation of the enum wrapper class for QSocketNotifier::Type
namespace qt_gsi
{

static QSocketNotifier_Type_Enum *c_1_QSocketNotifier_Type_Enum () { return new QSocketNotifier_Type_Enum (QSocketNotifier::Read); }
static QSocketNotifier_Type_Enum *c_2_QSocketNotifier_Type_Enum () { return new QSocketNotifier_Type_Enum (QSocketNotifier::Write); }
static QSocketNotifier_Type_Enum *c_3_QSocketNotifier_Type_Enum () { return new QSocketNotifier_Type_Enum (QSocketNotifier::Exception); }

static gsi::Methods mkdefs_QSocketNotifier_Type () {
  return
    gsi::constant ("Read", &qt_gsi::c_1_QSocketNotifier_Type_Enum, "@brief Enum constant QSocketNotifier::Read") +
    gsi::constant ("Write", &qt_gsi::c_2_QSocketNotifier_Type_Enum, "@brief Enum constant QSocketNotifier::Write") +
    gsi::constant ("Exception", &qt_gsi::c_3_QSocketNotifier_Type_Enum, "@brief Enum constant QSocketNotifier::Exception");
}

static std::string to_s_QSocketNotifier_Type_Enum (const QSocketNotifier_Type_Enum *e)
{
  if (e->value () == QSocketNotifier::Read) { return tl::sprintf ("Read (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSocketNotifier::Write) { return tl::sprintf ("Write (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSocketNotifier::Exception) { return tl::sprintf ("Exception (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSocketNotifier_Type_Enum (const QSocketNotifier_Type_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSocketNotifier_Type_Enum *from_i_QSocketNotifier_Type_Enum (unsigned int i)
{
  return new QSocketNotifier_Type_Enum ((QSocketNotifier::Type) i);
}

static bool equalQSocketNotifier_Type_Enum (const QSocketNotifier_Type_Enum *e, QSocketNotifier_Type_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSocketNotifier_Type_Enum (const QSocketNotifier_Type_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSocketNotifier_Type_Enums oropQSocketNotifier_Type_Enums (const QSocketNotifier_Type_Enums *e, const QSocketNotifier_Type_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSocketNotifier_Type_Enums andopQSocketNotifier_Type_Enums (const QSocketNotifier_Type_Enums *e, const QSocketNotifier_Type_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSocketNotifier_Type_Enums xoropQSocketNotifier_Type_Enums (const QSocketNotifier_Type_Enums *e, const QSocketNotifier_Type_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSocketNotifier_Type_Enums (const QSocketNotifier_Type_Enums *e)
{
  std::string l;
  if (e->testFlag (QSocketNotifier::Read)) { if (!l.empty ()) l += "|"; l += "Read"; }
  if (e->testFlag (QSocketNotifier::Write)) { if (!l.empty ()) l += "|"; l += "Write"; }
  if (e->testFlag (QSocketNotifier::Exception)) { if (!l.empty ()) l += "|"; l += "Exception"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSocketNotifier_Type_Enums (const QSocketNotifier_Type_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSocketNotifier_Type_Enums (const QSocketNotifier_Type_Enums *e, const QSocketNotifier_Type_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSocketNotifier_Type_Enums> decl_QSocketNotifier_Type_Enums ("QSocketNotifier_QFlags_Type",
  gsi::method_ext ("|", &qt_gsi::oropQSocketNotifier_Type_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSocketNotifier_Type_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSocketNotifier_Type_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSocketNotifier_Type_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSocketNotifier_Type_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSocketNotifier_Type_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSocketNotifier::Type> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSocketNotifier_Type_Enum> decl_QSocketNotifier_Type_Enum (decl_QSocketNotifier_Type_Enums, "QSocketNotifier_Type",
  qt_gsi::mkdefs_QSocketNotifier_Type () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSocketNotifier_Type_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSocketNotifier_Type_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSocketNotifier_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSocketNotifier_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSocketNotifier_Type_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSocketNotifier::Type enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSocketNotifier> inject_QSocketNotifier_Type_Enum_in_parent (qt_gsi::mkdefs_QSocketNotifier_Type ());
static gsi::ClassExt<QSocketNotifier> decl_QSocketNotifier_Type_Enum_as_child (decl_QSocketNotifier_Type_Enum, "Type");

}

