
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSize.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSize_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSize

//  Constructor QSize::QSize()


static void _init_ctor_QSize_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QSize *> ();
}

static void _call_ctor_QSize_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize *> (new QSize ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSize_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSize::QSize()\nThis method creates an object of class QSize.", &_init_ctor_QSize_0, &_call_ctor_QSize_0);
}

//  Constructor QSize::QSize(int w, int h)


static void _init_ctor_QSize_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return_new<QSize *> ();
}

static void _call_ctor_QSize_1426 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QSize *> (new QSize (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSize_1426 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSize::QSize(int w, int h)\nThis method creates an object of class QSize.", &_init_ctor_QSize_1426, &_call_ctor_QSize_1426);
}

// QSize QSize::boundedTo(const QSize &)


static void _init_f_boundedTo_c1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_f_boundedTo_c1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ret.write<QSize > ((QSize)((QSize *)cls)->boundedTo (arg1));
}

static qt_gsi::GenericMethod *_create_f_boundedTo_c1805 ()
{
  return new qt_gsi::GenericMethod ("boundedTo", "@brief Method QSize QSize::boundedTo(const QSize &)\n", true, &_init_f_boundedTo_c1805, &_call_f_boundedTo_c1805);
}

// QSize QSize::expandedTo(const QSize &)


static void _init_f_expandedTo_c1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_f_expandedTo_c1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ret.write<QSize > ((QSize)((QSize *)cls)->expandedTo (arg1));
}

static qt_gsi::GenericMethod *_create_f_expandedTo_c1805 ()
{
  return new qt_gsi::GenericMethod ("expandedTo", "@brief Method QSize QSize::expandedTo(const QSize &)\n", true, &_init_f_expandedTo_c1805, &_call_f_expandedTo_c1805);
}

// int QSize::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QSize *)cls)->height ());
}

static qt_gsi::GenericMethod *_create_f_height_c0 ()
{
  return new qt_gsi::GenericMethod (":height", "@brief Method int QSize::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
}

// bool QSize::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSize *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QSize::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// bool QSize::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSize *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QSize::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// bool QSize::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSize *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QSize::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// QSize &QSize::operator*=(double c)


static void _init_f_operator_star__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QSize & > ();
}

static void _call_f_operator_star__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QSize & > ((QSize &)((QSize *)cls)->operator*= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("*=", "@brief Method QSize &QSize::operator*=(double c)\n", false, &_init_f_operator_star__eq__1071, &_call_f_operator_star__eq__1071);
}

// QSize &QSize::operator+=(const QSize &)


static void _init_f_operator_plus__eq__1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<QSize & > ();
}

static void _call_f_operator_plus__eq__1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ret.write<QSize & > ((QSize &)((QSize *)cls)->operator+= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_plus__eq__1805 ()
{
  return new qt_gsi::GenericMethod ("+=", "@brief Method QSize &QSize::operator+=(const QSize &)\n", false, &_init_f_operator_plus__eq__1805, &_call_f_operator_plus__eq__1805);
}

// QSize &QSize::operator-=(const QSize &)


static void _init_f_operator_minus__eq__1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<QSize & > ();
}

static void _call_f_operator_minus__eq__1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ret.write<QSize & > ((QSize &)((QSize *)cls)->operator-= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_minus__eq__1805 ()
{
  return new qt_gsi::GenericMethod ("-=", "@brief Method QSize &QSize::operator-=(const QSize &)\n", false, &_init_f_operator_minus__eq__1805, &_call_f_operator_minus__eq__1805);
}

// QSize &QSize::operator/=(double c)


static void _init_f_operator_slash__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QSize & > ();
}

static void _call_f_operator_slash__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QSize & > ((QSize &)((QSize *)cls)->operator/= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_slash__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("/=", "@brief Method QSize &QSize::operator/=(double c)\n", false, &_init_f_operator_slash__eq__1071, &_call_f_operator_slash__eq__1071);
}

// int &QSize::rheight()


static void _init_f_rheight_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int & > ();
}

static void _call_f_rheight_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int & > ((int &)((QSize *)cls)->rheight ());
}

static qt_gsi::GenericMethod *_create_f_rheight_0 ()
{
  return new qt_gsi::GenericMethod ("rheight", "@brief Method int &QSize::rheight()\n", false, &_init_f_rheight_0, &_call_f_rheight_0);
}

// int &QSize::rwidth()


static void _init_f_rwidth_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int & > ();
}

static void _call_f_rwidth_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int & > ((int &)((QSize *)cls)->rwidth ());
}

static qt_gsi::GenericMethod *_create_f_rwidth_0 ()
{
  return new qt_gsi::GenericMethod ("rwidth", "@brief Method int &QSize::rwidth()\n", false, &_init_f_rwidth_0, &_call_f_rwidth_0);
}

// void QSize::scale(int w, int h, Qt::AspectRatioMode mode)


static void _init_f_scale_3575 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_scale_3575 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > ();
  ((QSize *)cls)->scale (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_scale_3575 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QSize::scale(int w, int h, Qt::AspectRatioMode mode)\n", false, &_init_f_scale_3575, &_call_f_scale_3575);
}

// void QSize::scale(const QSize &s, Qt::AspectRatioMode mode)


static void _init_f_scale_3954 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scale_3954 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > ();
  ((QSize *)cls)->scale (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_scale_3954 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QSize::scale(const QSize &s, Qt::AspectRatioMode mode)\n", false, &_init_f_scale_3954, &_call_f_scale_3954);
}

// void QSize::setHeight(int h)


static void _init_f_setHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeight_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QSize *)cls)->setHeight (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHeight_767 ()
{
  return new qt_gsi::GenericMethod ("setHeight|height=", "@brief Method void QSize::setHeight(int h)\n", false, &_init_f_setHeight_767, &_call_f_setHeight_767);
}

// void QSize::setWidth(int w)


static void _init_f_setWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidth_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QSize *)cls)->setWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWidth_767 ()
{
  return new qt_gsi::GenericMethod ("setWidth|width=", "@brief Method void QSize::setWidth(int w)\n", false, &_init_f_setWidth_767, &_call_f_setWidth_767);
}

// void QSize::transpose()


static void _init_f_transpose_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_transpose_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSize *)cls)->transpose ();
}

static qt_gsi::GenericMethod *_create_f_transpose_0 ()
{
  return new qt_gsi::GenericMethod ("transpose", "@brief Method void QSize::transpose()\n", false, &_init_f_transpose_0, &_call_f_transpose_0);
}

// int QSize::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QSize *)cls)->width ());
}

static qt_gsi::GenericMethod *_create_f_width_c0 ()
{
  return new qt_gsi::GenericMethod (":width", "@brief Method int QSize::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
}

//  bool ::operator==(const QSize &s1, const QSize &s2)
static bool op_QSize_operator_eq__eq__3502(const QSize *_self, const QSize &s2) {
  return ::operator==(*_self, s2);
}

//  bool ::operator!=(const QSize &s1, const QSize &s2)
static bool op_QSize_operator_excl__eq__3502(const QSize *_self, const QSize &s2) {
  return ::operator!=(*_self, s2);
}

//  const QSize ::operator+(const QSize &s1, const QSize &s2)
static const QSize op_QSize_operator_plus__3502(const QSize *_self, const QSize &s2) {
  return ::operator+(*_self, s2);
}

//  const QSize ::operator-(const QSize &s1, const QSize &s2)
static const QSize op_QSize_operator_minus__3502(const QSize *_self, const QSize &s2) {
  return ::operator-(*_self, s2);
}

//  const QSize ::operator*(const QSize &s, qreal c)
static const QSize op_QSize_operator_star__2666(const QSize *_self, qreal c) {
  return ::operator*(*_self, c);
}

//  const QSize ::operator/(const QSize &s, qreal c)
static const QSize op_QSize_operator_slash__2666(const QSize *_self, qreal c) {
  return ::operator/(*_self, c);
}


namespace gsi
{
gsi::Class<QSize> decl_QSize ("QSize",
  gsi::Methods(_create_ctor_QSize_0 ()) +
  gsi::Methods(_create_ctor_QSize_1426 ()) +
  gsi::Methods(_create_f_boundedTo_c1805 ()) +
  gsi::Methods(_create_f_expandedTo_c1805 ()) +
  gsi::Methods(_create_f_height_c0 ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_operator_star__eq__1071 ()) +
  gsi::Methods(_create_f_operator_plus__eq__1805 ()) +
  gsi::Methods(_create_f_operator_minus__eq__1805 ()) +
  gsi::Methods(_create_f_operator_slash__eq__1071 ()) +
  gsi::Methods(_create_f_rheight_0 ()) +
  gsi::Methods(_create_f_rwidth_0 ()) +
  gsi::Methods(_create_f_scale_3575 ()) +
  gsi::Methods(_create_f_scale_3954 ()) +
  gsi::Methods(_create_f_setHeight_767 ()) +
  gsi::Methods(_create_f_setWidth_767 ()) +
  gsi::Methods(_create_f_transpose_0 ()) +
  gsi::Methods(_create_f_width_c0 ()) +
  gsi::method_ext("==", &::op_QSize_operator_eq__eq__3502, gsi::arg ("s2"), "@brief Operator bool ::operator==(const QSize &s1, const QSize &s2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("!=", &::op_QSize_operator_excl__eq__3502, gsi::arg ("s2"), "@brief Operator bool ::operator!=(const QSize &s1, const QSize &s2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("+", &::op_QSize_operator_plus__3502, gsi::arg ("s2"), "@brief Operator const QSize ::operator+(const QSize &s1, const QSize &s2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("-", &::op_QSize_operator_minus__3502, gsi::arg ("s2"), "@brief Operator const QSize ::operator-(const QSize &s1, const QSize &s2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QSize_operator_star__2666, gsi::arg ("c"), "@brief Operator const QSize ::operator*(const QSize &s, qreal c)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("/", &::op_QSize_operator_slash__2666, gsi::arg ("c"), "@brief Operator const QSize ::operator/(const QSize &s, qreal c)\nThis is the mapping of the global operator to the instance method."),
  "@qt\n@brief Binding of QSize");

}

