
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQShortcut.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQShortcut_EventAdaptor.h"
#include "gsiDeclQShortcut_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QShortcut

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QShortcut::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QShortcut::autoRepeat()


static void _init_f_autoRepeat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoRepeat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QShortcut *)cls)->autoRepeat ());
}

static qt_gsi::GenericMethod *_create_f_autoRepeat_c0 ()
{
  return new qt_gsi::GenericMethod (":autoRepeat", "@brief Method bool QShortcut::autoRepeat()\n", true, &_init_f_autoRepeat_c0, &_call_f_autoRepeat_c0);
}

// Qt::ShortcutContext QShortcut::context()


static void _init_f_context_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ShortcutContext>::target_type > ();
}

static void _call_f_context_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::ShortcutContext>::target_type > ((qt_gsi::Converter<Qt::ShortcutContext>::target_type)qt_gsi::CppToQtAdaptor<Qt::ShortcutContext>(((QShortcut *)cls)->context ()));
}

static qt_gsi::GenericMethod *_create_f_context_0 ()
{
  return new qt_gsi::GenericMethod (":context", "@brief Method Qt::ShortcutContext QShortcut::context()\n", false, &_init_f_context_0, &_call_f_context_0);
}

// int QShortcut::id()


static void _init_f_id_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_id_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QShortcut *)cls)->id ());
}

static qt_gsi::GenericMethod *_create_f_id_c0 ()
{
  return new qt_gsi::GenericMethod ("id", "@brief Method int QShortcut::id()\n", true, &_init_f_id_c0, &_call_f_id_c0);
}

// bool QShortcut::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QShortcut *)cls)->isEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QShortcut::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
}

// QKeySequence QShortcut::key()


static void _init_f_key_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QKeySequence > ();
}

static void _call_f_key_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QKeySequence > ((QKeySequence)((QShortcut *)cls)->key ());
}

static qt_gsi::GenericMethod *_create_f_key_c0 ()
{
  return new qt_gsi::GenericMethod (":key", "@brief Method QKeySequence QShortcut::key()\n", true, &_init_f_key_c0, &_call_f_key_c0);
}

// QWidget *QShortcut::parentWidget()


static void _init_f_parentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_parentWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QShortcut *)cls)->parentWidget ());
}

static qt_gsi::GenericMethod *_create_f_parentWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("parentWidget", "@brief Method QWidget *QShortcut::parentWidget()\n", true, &_init_f_parentWidget_c0, &_call_f_parentWidget_c0);
}

// void QShortcut::setAutoRepeat(bool on)


static void _init_f_setAutoRepeat_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("on");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoRepeat_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QShortcut *)cls)->setAutoRepeat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoRepeat_864 ()
{
  return new qt_gsi::GenericMethod ("setAutoRepeat|autoRepeat=", "@brief Method void QShortcut::setAutoRepeat(bool on)\n", false, &_init_f_setAutoRepeat_864, &_call_f_setAutoRepeat_864);
}

// void QShortcut::setContext(Qt::ShortcutContext context)


static void _init_f_setContext_2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContext_2350 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::ShortcutContext>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > ();
  ((QShortcut *)cls)->setContext (qt_gsi::QtToCppAdaptor<Qt::ShortcutContext>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setContext_2350 ()
{
  return new qt_gsi::GenericMethod ("setContext|context=", "@brief Method void QShortcut::setContext(Qt::ShortcutContext context)\n", false, &_init_f_setContext_2350, &_call_f_setContext_2350);
}

// void QShortcut::setEnabled(bool enable)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QShortcut *)cls)->setEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QShortcut::setEnabled(bool enable)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
}

// void QShortcut::setKey(const QKeySequence &key)


static void _init_f_setKey_2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKey_2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ((QShortcut *)cls)->setKey (arg1);
}

static qt_gsi::GenericMethod *_create_f_setKey_2516 ()
{
  return new qt_gsi::GenericMethod ("setKey|key=", "@brief Method void QShortcut::setKey(const QKeySequence &key)\n", false, &_init_f_setKey_2516, &_call_f_setKey_2516);
}

// void QShortcut::setWhatsThis(const QString &text)


static void _init_f_setWhatsThis_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWhatsThis_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QShortcut *)cls)->setWhatsThis (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWhatsThis_2025 ()
{
  return new qt_gsi::GenericMethod ("setWhatsThis|whatsThis=", "@brief Method void QShortcut::setWhatsThis(const QString &text)\n", false, &_init_f_setWhatsThis_2025, &_call_f_setWhatsThis_2025);
}

// QString QShortcut::whatsThis()


static void _init_f_whatsThis_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_whatsThis_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QShortcut *)cls)->whatsThis ());
}

static qt_gsi::GenericMethod *_create_f_whatsThis_c0 ()
{
  return new qt_gsi::GenericMethod (":whatsThis", "@brief Method QString QShortcut::whatsThis()\n", true, &_init_f_whatsThis_c0, &_call_f_whatsThis_c0);
}

// static QString QShortcut::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QShortcut::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QShortcut::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QShortcut::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QShortcut::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QShortcut::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QShortcut::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QShortcut::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QShortcut::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QShortcut::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QShortcut::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QShortcut::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QShortcut, QShortcut_EventAdaptor> ea_QShortcut;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QShortcut> decl_QShortcut (ea_QShortcut, decl_QObject, "QShortcut_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_autoRepeat_c0 ()) +
  gsi::Methods(_create_f_context_0 ()) +
  gsi::Methods(_create_f_id_c0 ()) +
  gsi::Methods(_create_f_isEnabled_c0 ()) +
  gsi::Methods(_create_f_key_c0 ()) +
  gsi::Methods(_create_f_parentWidget_c0 ()) +
  gsi::Methods(_create_f_setAutoRepeat_864 ()) +
  gsi::Methods(_create_f_setContext_2350 ()) +
  gsi::Methods(_create_f_setEnabled_864 ()) +
  gsi::Methods(_create_f_setKey_2516 ()) +
  gsi::Methods(_create_f_setWhatsThis_2025 ()) +
  gsi::Methods(_create_f_whatsThis_c0 ()) +
  qt_gsi::qt_signal<QShortcut, QShortcut_EventAdaptor> ("activated", &QShortcut_EventAdaptor::activated_e_0, "@brief Signal declaration for QShortcut::activated()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QShortcut, QShortcut_EventAdaptor> ("activatedAmbiguously", &QShortcut_EventAdaptor::activatedAmbiguously_e_0, "@brief Signal declaration for QShortcut::activatedAmbiguously()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QShortcut, QShortcut_EventAdaptor, QObject *> ("destroyed", &QShortcut_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QShortcut::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QShortcut");
}


class QShortcut_Adaptor : public QShortcut, public qt_gsi::QtObjectBase
{
public:

  virtual ~QShortcut_Adaptor();

  //  [adaptor ctor] QShortcut::QShortcut(QWidget *parent)
  QShortcut_Adaptor(QWidget *parent) : QShortcut(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QShortcut::QShortcut(const QKeySequence &key, QWidget *parent, const char *member, const char *ambiguousMember, Qt::ShortcutContext context)
  QShortcut_Adaptor(const QKeySequence &key, QWidget *parent) : QShortcut(key, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QShortcut::QShortcut(const QKeySequence &key, QWidget *parent, const char *member, const char *ambiguousMember, Qt::ShortcutContext context)
  QShortcut_Adaptor(const QKeySequence &key, QWidget *parent, const char *member) : QShortcut(key, parent, member)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QShortcut::QShortcut(const QKeySequence &key, QWidget *parent, const char *member, const char *ambiguousMember, Qt::ShortcutContext context)
  QShortcut_Adaptor(const QKeySequence &key, QWidget *parent, const char *member, const char *ambiguousMember) : QShortcut(key, parent, member, ambiguousMember)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QShortcut::QShortcut(const QKeySequence &key, QWidget *parent, const char *member, const char *ambiguousMember, Qt::ShortcutContext context)
  QShortcut_Adaptor(const QKeySequence &key, QWidget *parent, const char *member, const char *ambiguousMember, Qt::ShortcutContext context) : QShortcut(key, parent, member, ambiguousMember, context)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QShortcut::receivers(const char *signal)
  int fp_QShortcut_receivers_c1731 (const char *signal) const {
    return QShortcut::receivers(signal);
  }

  //  QObject *QShortcut::sender()
  QObject * fp_QShortcut_sender_c0 () const {
    return QShortcut::sender();
  }

  //  [adaptor impl] bool QShortcut::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QShortcut::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QShortcut_Adaptor, bool, QObject *, QEvent *>(&QShortcut_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QShortcut::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QShortcut::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QShortcut::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QShortcut_Adaptor, QChildEvent *>(&QShortcut_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QShortcut::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QShortcut::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QShortcut::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QShortcut_Adaptor, QEvent *>(&QShortcut_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QShortcut::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QShortcut::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QShortcut::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QShortcut_Adaptor, const char *>(&QShortcut_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QShortcut::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QShortcut::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QShortcut::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QShortcut_Adaptor, bool, QEvent *>(&QShortcut_Adaptor::cbs_event_1217_0, e);
    } else {
      return QShortcut::event(e);
    }
  }

  //  [adaptor impl] void QShortcut::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QShortcut::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QShortcut_Adaptor, QTimerEvent *>(&QShortcut_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QShortcut::timerEvent(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QShortcut_Adaptor::~QShortcut_Adaptor() { }

//  Constructor QShortcut::QShortcut(QWidget *parent) (adaptor class)

static void _init_ctor_QShortcut_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QShortcut_Adaptor *> ();
}

static void _call_ctor_QShortcut_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<QShortcut_Adaptor *> (new QShortcut_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QShortcut_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QShortcut::QShortcut(QWidget *parent)\nThis method creates an object of class QShortcut.", &_init_ctor_QShortcut_Adaptor_1315, &_call_ctor_QShortcut_Adaptor_1315);
}

//  Constructor QShortcut::QShortcut(const QKeySequence &key, QWidget *parent, const char *member, const char *ambiguousMember, Qt::ShortcutContext context) (adaptor class)

static void _init_ctor_QShortcut_Adaptor_9211 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QKeySequence & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("member", true, "0");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("ambiguousMember", true, "0");
  decl->add_arg<const char * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("context", true, "Qt::WindowShortcut");
  decl->add_arg<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > (argspec_4);
  decl->set_return_new<QShortcut_Adaptor *> ();
}

static void _call_ctor_QShortcut_Adaptor_9211 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  QWidget *arg2 = args.read<QWidget * > ();
  const char *arg3 = args ? args.read<const char * > () : (const char *)(0);
  const char *arg4 = args ? args.read<const char * > () : (const char *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ShortcutContext>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > () : (const qt_gsi::Converter<Qt::ShortcutContext>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ShortcutContext>(heap, Qt::WindowShortcut));
  ret.write<QShortcut_Adaptor *> (new QShortcut_Adaptor (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ShortcutContext>(arg5).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QShortcut_Adaptor_9211 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QShortcut::QShortcut(const QKeySequence &key, QWidget *parent, const char *member, const char *ambiguousMember, Qt::ShortcutContext context)\nThis method creates an object of class QShortcut.", &_init_ctor_QShortcut_Adaptor_9211, &_call_ctor_QShortcut_Adaptor_9211);
}

// int QShortcut::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QShortcut_Adaptor *)cls)->fp_QShortcut_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QShortcut::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QShortcut::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QShortcut_Adaptor *)cls)->fp_QShortcut_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QShortcut::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QShortcut::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QShortcut_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QShortcut_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QShortcut::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QShortcut::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QShortcut_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QShortcut_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QShortcut::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QShortcut::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QShortcut_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QShortcut_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QShortcut::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QShortcut::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QShortcut_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QShortcut_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QShortcut::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QShortcut::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QShortcut_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QShortcut_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QShortcut::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QShortcut::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QShortcut_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QShortcut_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QShortcut::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QShortcut> decl_QShortcut;

gsi::Class<QShortcut_Adaptor> decl_QShortcut_Adaptor (decl_QShortcut, "QShortcut",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QShortcut_Adaptor_1315 ()) +
  gsi::Methods(_create_ctor_QShortcut_Adaptor_9211 ()),
  "@qt\n@brief Binding of QShortcut");

}

