
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSettings.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSettings_EventAdaptor.h"
#include "gsiDeclQSettings_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSettings

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSettings::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QStringList QSettings::allKeys()


static void _init_f_allKeys_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_allKeys_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QSettings *)cls)->allKeys ()));
}

static qt_gsi::GenericMethod *_create_f_allKeys_c0 ()
{
  return new qt_gsi::GenericMethod ("allKeys", "@brief Method QStringList QSettings::allKeys()\n", true, &_init_f_allKeys_c0, &_call_f_allKeys_c0);
}

// QString QSettings::applicationName()


static void _init_f_applicationName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QSettings *)cls)->applicationName ());
}

static qt_gsi::GenericMethod *_create_f_applicationName_c0 ()
{
  return new qt_gsi::GenericMethod ("applicationName", "@brief Method QString QSettings::applicationName()\n", true, &_init_f_applicationName_c0, &_call_f_applicationName_c0);
}

// void QSettings::beginGroup(const QString &prefix)


static void _init_f_beginGroup_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_beginGroup_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QSettings *)cls)->beginGroup (arg1);
}

static qt_gsi::GenericMethod *_create_f_beginGroup_2025 ()
{
  return new qt_gsi::GenericMethod ("beginGroup", "@brief Method void QSettings::beginGroup(const QString &prefix)\n", false, &_init_f_beginGroup_2025, &_call_f_beginGroup_2025);
}

// int QSettings::beginReadArray(const QString &prefix)


static void _init_f_beginReadArray_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_beginReadArray_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<int > ((int)((QSettings *)cls)->beginReadArray (arg1));
}

static qt_gsi::GenericMethod *_create_f_beginReadArray_2025 ()
{
  return new qt_gsi::GenericMethod ("beginReadArray", "@brief Method int QSettings::beginReadArray(const QString &prefix)\n", false, &_init_f_beginReadArray_2025, &_call_f_beginReadArray_2025);
}

// void QSettings::beginWriteArray(const QString &prefix, int size)


static void _init_f_beginWriteArray_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("size", true, "-1");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_beginWriteArray_2684 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  int arg2 = args ? args.read<int > () : (int)(-1);
  ((QSettings *)cls)->beginWriteArray (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_beginWriteArray_2684 ()
{
  return new qt_gsi::GenericMethod ("beginWriteArray", "@brief Method void QSettings::beginWriteArray(const QString &prefix, int size)\n", false, &_init_f_beginWriteArray_2684, &_call_f_beginWriteArray_2684);
}

// QStringList QSettings::childGroups()


static void _init_f_childGroups_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_childGroups_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QSettings *)cls)->childGroups ()));
}

static qt_gsi::GenericMethod *_create_f_childGroups_c0 ()
{
  return new qt_gsi::GenericMethod ("childGroups", "@brief Method QStringList QSettings::childGroups()\n", true, &_init_f_childGroups_c0, &_call_f_childGroups_c0);
}

// QStringList QSettings::childKeys()


static void _init_f_childKeys_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_childKeys_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QSettings *)cls)->childKeys ()));
}

static qt_gsi::GenericMethod *_create_f_childKeys_c0 ()
{
  return new qt_gsi::GenericMethod ("childKeys", "@brief Method QStringList QSettings::childKeys()\n", true, &_init_f_childKeys_c0, &_call_f_childKeys_c0);
}

// void QSettings::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSettings *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QSettings::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// bool QSettings::contains(const QString &key)


static void _init_f_contains_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QSettings *)cls)->contains (arg1));
}

static qt_gsi::GenericMethod *_create_f_contains_c2025 ()
{
  return new qt_gsi::GenericMethod ("contains", "@brief Method bool QSettings::contains(const QString &key)\n", true, &_init_f_contains_c2025, &_call_f_contains_c2025);
}

// void QSettings::endArray()


static void _init_f_endArray_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endArray_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSettings *)cls)->endArray ();
}

static qt_gsi::GenericMethod *_create_f_endArray_0 ()
{
  return new qt_gsi::GenericMethod ("endArray", "@brief Method void QSettings::endArray()\n", false, &_init_f_endArray_0, &_call_f_endArray_0);
}

// void QSettings::endGroup()


static void _init_f_endGroup_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endGroup_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSettings *)cls)->endGroup ();
}

static qt_gsi::GenericMethod *_create_f_endGroup_0 ()
{
  return new qt_gsi::GenericMethod ("endGroup", "@brief Method void QSettings::endGroup()\n", false, &_init_f_endGroup_0, &_call_f_endGroup_0);
}

// bool QSettings::fallbacksEnabled()


static void _init_f_fallbacksEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fallbacksEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSettings *)cls)->fallbacksEnabled ());
}

static qt_gsi::GenericMethod *_create_f_fallbacksEnabled_c0 ()
{
  return new qt_gsi::GenericMethod (":fallbacksEnabled", "@brief Method bool QSettings::fallbacksEnabled()\n", true, &_init_f_fallbacksEnabled_c0, &_call_f_fallbacksEnabled_c0);
}

// QString QSettings::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QSettings *)cls)->fileName ());
}

static qt_gsi::GenericMethod *_create_f_fileName_c0 ()
{
  return new qt_gsi::GenericMethod ("fileName", "@brief Method QString QSettings::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
}

// QSettings::Format QSettings::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSettings::Format>::target_type > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSettings::Format>::target_type > ((qt_gsi::Converter<QSettings::Format>::target_type)qt_gsi::CppToQtAdaptor<QSettings::Format>(((QSettings *)cls)->format ()));
}

static qt_gsi::GenericMethod *_create_f_format_c0 ()
{
  return new qt_gsi::GenericMethod ("format", "@brief Method QSettings::Format QSettings::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
}

// QString QSettings::group()


static void _init_f_group_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_group_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QSettings *)cls)->group ());
}

static qt_gsi::GenericMethod *_create_f_group_c0 ()
{
  return new qt_gsi::GenericMethod ("group", "@brief Method QString QSettings::group()\n", true, &_init_f_group_c0, &_call_f_group_c0);
}

// bool QSettings::isWritable()


static void _init_f_isWritable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWritable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSettings *)cls)->isWritable ());
}

static qt_gsi::GenericMethod *_create_f_isWritable_c0 ()
{
  return new qt_gsi::GenericMethod ("isWritable?", "@brief Method bool QSettings::isWritable()\n", true, &_init_f_isWritable_c0, &_call_f_isWritable_c0);
}

// QString QSettings::organizationName()


static void _init_f_organizationName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_organizationName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QSettings *)cls)->organizationName ());
}

static qt_gsi::GenericMethod *_create_f_organizationName_c0 ()
{
  return new qt_gsi::GenericMethod ("organizationName", "@brief Method QString QSettings::organizationName()\n", true, &_init_f_organizationName_c0, &_call_f_organizationName_c0);
}

// void QSettings::remove(const QString &key)


static void _init_f_remove_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_remove_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QSettings *)cls)->remove (arg1);
}

static qt_gsi::GenericMethod *_create_f_remove_2025 ()
{
  return new qt_gsi::GenericMethod ("remove", "@brief Method void QSettings::remove(const QString &key)\n", false, &_init_f_remove_2025, &_call_f_remove_2025);
}

// QSettings::Scope QSettings::scope()


static void _init_f_scope_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSettings::Scope>::target_type > ();
}

static void _call_f_scope_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSettings::Scope>::target_type > ((qt_gsi::Converter<QSettings::Scope>::target_type)qt_gsi::CppToQtAdaptor<QSettings::Scope>(((QSettings *)cls)->scope ()));
}

static qt_gsi::GenericMethod *_create_f_scope_c0 ()
{
  return new qt_gsi::GenericMethod ("scope", "@brief Method QSettings::Scope QSettings::scope()\n", true, &_init_f_scope_c0, &_call_f_scope_c0);
}

// void QSettings::setArrayIndex(int i)


static void _init_f_setArrayIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setArrayIndex_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QSettings *)cls)->setArrayIndex (arg1);
}

static qt_gsi::GenericMethod *_create_f_setArrayIndex_767 ()
{
  return new qt_gsi::GenericMethod ("setArrayIndex", "@brief Method void QSettings::setArrayIndex(int i)\n", false, &_init_f_setArrayIndex_767, &_call_f_setArrayIndex_767);
}

// void QSettings::setFallbacksEnabled(bool b)


static void _init_f_setFallbacksEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFallbacksEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QSettings *)cls)->setFallbacksEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFallbacksEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setFallbacksEnabled|fallbacksEnabled=", "@brief Method void QSettings::setFallbacksEnabled(bool b)\n", false, &_init_f_setFallbacksEnabled_864, &_call_f_setFallbacksEnabled_864);
}

// void QSettings::setValue(const QString &key, const QVariant &value)


static void _init_f_setValue_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setValue_4036 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QSettings *)cls)->setValue (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setValue_4036 ()
{
  return new qt_gsi::GenericMethod ("setValue", "@brief Method void QSettings::setValue(const QString &key, const QVariant &value)\n", false, &_init_f_setValue_4036, &_call_f_setValue_4036);
}

// QSettings::Status QSettings::status()


static void _init_f_status_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSettings::Status>::target_type > ();
}

static void _call_f_status_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSettings::Status>::target_type > ((qt_gsi::Converter<QSettings::Status>::target_type)qt_gsi::CppToQtAdaptor<QSettings::Status>(((QSettings *)cls)->status ()));
}

static qt_gsi::GenericMethod *_create_f_status_c0 ()
{
  return new qt_gsi::GenericMethod ("status", "@brief Method QSettings::Status QSettings::status()\n", true, &_init_f_status_c0, &_call_f_status_c0);
}

// void QSettings::sync()


static void _init_f_sync_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_sync_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSettings *)cls)->sync ();
}

static qt_gsi::GenericMethod *_create_f_sync_0 ()
{
  return new qt_gsi::GenericMethod ("sync", "@brief Method void QSettings::sync()\n", false, &_init_f_sync_0, &_call_f_sync_0);
}

// QVariant QSettings::value(const QString &key, const QVariant &defaultValue)


static void _init_f_value_c4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("defaultValue", true, "QVariant()");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_value_c4036 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QVariant &arg2 = args ? args.read<const QVariant & > () : (const QVariant &)(QVariant());
  ret.write<QVariant > ((QVariant)((QSettings *)cls)->value (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_value_c4036 ()
{
  return new qt_gsi::GenericMethod ("value", "@brief Method QVariant QSettings::value(const QString &key, const QVariant &defaultValue)\n", true, &_init_f_value_c4036, &_call_f_value_c4036);
}

// static QSettings::Format QSettings::defaultFormat()


static void _init_f_defaultFormat_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSettings::Format>::target_type > ();
}

static void _call_f_defaultFormat_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSettings::Format>::target_type > ((qt_gsi::Converter<QSettings::Format>::target_type)qt_gsi::CppToQtAdaptor<QSettings::Format>(QSettings::defaultFormat ()));
}

static qt_gsi::GenericStaticMethod *_create_f_defaultFormat_0 ()
{
  return new qt_gsi::GenericStaticMethod (":defaultFormat", "@brief Static method QSettings::Format QSettings::defaultFormat()\nThis method is static and can be called without an instance.", &_init_f_defaultFormat_0, &_call_f_defaultFormat_0);
}

// static void QSettings::setDefaultFormat(QSettings::Format format)


static void _init_f_setDefaultFormat_2099 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QSettings::Format>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultFormat_2099 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSettings::Format>::target_type & arg1 = args.read<const qt_gsi::Converter<QSettings::Format>::target_type & > ();
  QSettings::setDefaultFormat (qt_gsi::QtToCppAdaptor<QSettings::Format>(arg1).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_setDefaultFormat_2099 ()
{
  return new qt_gsi::GenericStaticMethod ("setDefaultFormat|defaultFormat=", "@brief Static method void QSettings::setDefaultFormat(QSettings::Format format)\nThis method is static and can be called without an instance.", &_init_f_setDefaultFormat_2099, &_call_f_setDefaultFormat_2099);
}

// static void QSettings::setPath(QSettings::Format format, QSettings::Scope scope, const QString &path)


static void _init_f_setPath_5896 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QSettings::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("scope");
  decl->add_arg<const qt_gsi::Converter<QSettings::Scope>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("path");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setPath_5896 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSettings::Format>::target_type & arg1 = args.read<const qt_gsi::Converter<QSettings::Format>::target_type & > ();
  const qt_gsi::Converter<QSettings::Scope>::target_type & arg2 = args.read<const qt_gsi::Converter<QSettings::Scope>::target_type & > ();
  const QString &arg3 = args.read<const QString & > ();
  QSettings::setPath (qt_gsi::QtToCppAdaptor<QSettings::Format>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSettings::Scope>(arg2).cref(), arg3);
}

static qt_gsi::GenericStaticMethod *_create_f_setPath_5896 ()
{
  return new qt_gsi::GenericStaticMethod ("setPath", "@brief Static method void QSettings::setPath(QSettings::Format format, QSettings::Scope scope, const QString &path)\nThis method is static and can be called without an instance.", &_init_f_setPath_5896, &_call_f_setPath_5896);
}

// static void QSettings::setSystemIniPath(const QString &dir)


static void _init_f_setSystemIniPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSystemIniPath_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QSettings::setSystemIniPath (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setSystemIniPath_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setSystemIniPath", "@brief Static method void QSettings::setSystemIniPath(const QString &dir)\nThis method is static and can be called without an instance.", &_init_f_setSystemIniPath_2025, &_call_f_setSystemIniPath_2025);
}

// static void QSettings::setUserIniPath(const QString &dir)


static void _init_f_setUserIniPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUserIniPath_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QSettings::setUserIniPath (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setUserIniPath_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setUserIniPath", "@brief Static method void QSettings::setUserIniPath(const QString &dir)\nThis method is static and can be called without an instance.", &_init_f_setUserIniPath_2025, &_call_f_setUserIniPath_2025);
}

// static QString QSettings::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSettings::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSettings::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QSettings::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSettings::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSettings::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QSettings::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSettings::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSettings::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QSettings::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSettings::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSettings::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QSettings, QSettings_EventAdaptor> ea_QSettings;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QSettings> decl_QSettings (ea_QSettings, decl_QObject, "QSettings_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_allKeys_c0 ()) +
  gsi::Methods(_create_f_applicationName_c0 ()) +
  gsi::Methods(_create_f_beginGroup_2025 ()) +
  gsi::Methods(_create_f_beginReadArray_2025 ()) +
  gsi::Methods(_create_f_beginWriteArray_2684 ()) +
  gsi::Methods(_create_f_childGroups_c0 ()) +
  gsi::Methods(_create_f_childKeys_c0 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_contains_c2025 ()) +
  gsi::Methods(_create_f_endArray_0 ()) +
  gsi::Methods(_create_f_endGroup_0 ()) +
  gsi::Methods(_create_f_fallbacksEnabled_c0 ()) +
  gsi::Methods(_create_f_fileName_c0 ()) +
  gsi::Methods(_create_f_format_c0 ()) +
  gsi::Methods(_create_f_group_c0 ()) +
  gsi::Methods(_create_f_isWritable_c0 ()) +
  gsi::Methods(_create_f_organizationName_c0 ()) +
  gsi::Methods(_create_f_remove_2025 ()) +
  gsi::Methods(_create_f_scope_c0 ()) +
  gsi::Methods(_create_f_setArrayIndex_767 ()) +
  gsi::Methods(_create_f_setFallbacksEnabled_864 ()) +
  gsi::Methods(_create_f_setValue_4036 ()) +
  gsi::Methods(_create_f_status_c0 ()) +
  gsi::Methods(_create_f_sync_0 ()) +
  gsi::Methods(_create_f_value_c4036 ()) +
  qt_gsi::qt_signal<QSettings, QSettings_EventAdaptor, QObject *> ("destroyed", &QSettings_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QSettings::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_defaultFormat_0 ()) +
  gsi::Methods(_create_f_setDefaultFormat_2099 ()) +
  gsi::Methods(_create_f_setPath_5896 ()) +
  gsi::Methods(_create_f_setSystemIniPath_2025 ()) +
  gsi::Methods(_create_f_setUserIniPath_2025 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QSettings");
}


class QSettings_Adaptor : public QSettings, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSettings_Adaptor();

  //  [adaptor ctor] QSettings::QSettings(const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(const QString &organization) : QSettings(organization)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(const QString &organization, const QString &application) : QSettings(organization, application)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(const QString &organization, const QString &application, QObject *parent) : QSettings(organization, application, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Scope scope, const QString &organization) : QSettings(scope, organization)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Scope scope, const QString &organization, const QString &application) : QSettings(scope, organization, application)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent) : QSettings(scope, organization, application, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Format format, QSettings::Scope scope, const QString &organization) : QSettings(format, scope, organization)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application) : QSettings(format, scope, organization, application)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)
  QSettings_Adaptor(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent) : QSettings(format, scope, organization, application, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(const QString &fileName, QSettings::Format format, QObject *parent)
  QSettings_Adaptor(const QString &fileName, QSettings::Format format) : QSettings(fileName, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(const QString &fileName, QSettings::Format format, QObject *parent)
  QSettings_Adaptor(const QString &fileName, QSettings::Format format, QObject *parent) : QSettings(fileName, format, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QObject *parent)
  QSettings_Adaptor() : QSettings()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSettings::QSettings(QObject *parent)
  QSettings_Adaptor(QObject *parent) : QSettings(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QSettings::receivers(const char *signal)
  int fp_QSettings_receivers_c1731 (const char *signal) const {
    return QSettings::receivers(signal);
  }

  //  QObject *QSettings::sender()
  QObject * fp_QSettings_sender_c0 () const {
    return QSettings::sender();
  }

  //  [adaptor impl] bool QSettings::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSettings::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSettings_Adaptor, bool, QObject *, QEvent *>(&QSettings_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSettings::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QSettings::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSettings::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSettings_Adaptor, QChildEvent *>(&QSettings_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSettings::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSettings::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSettings::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSettings_Adaptor, QEvent *>(&QSettings_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSettings::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QSettings::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QSettings::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QSettings_Adaptor, const char *>(&QSettings_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QSettings::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QSettings::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QSettings::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSettings_Adaptor, bool, QEvent *>(&QSettings_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QSettings::event(_event);
    }
  }

  //  [adaptor impl] void QSettings::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSettings::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSettings_Adaptor, QTimerEvent *>(&QSettings_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSettings::timerEvent(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSettings_Adaptor::~QSettings_Adaptor() { }

//  Constructor QSettings::QSettings(const QString &organization, const QString &application, QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_5136 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("organization");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("application", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QSettings_Adaptor *> ();
}

static void _call_ctor_QSettings_Adaptor_5136 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  QObject *arg3 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSettings_Adaptor_5136 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(const QString &organization, const QString &application, QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_5136, &_call_ctor_QSettings_Adaptor_5136);
}

//  Constructor QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_7016 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scope");
  decl->add_arg<const qt_gsi::Converter<QSettings::Scope>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("organization");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("application", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_3);
  decl->set_return_new<QSettings_Adaptor *> ();
}

static void _call_ctor_QSettings_Adaptor_7016 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSettings::Scope>::target_type & arg1 = args.read<const qt_gsi::Converter<QSettings::Scope>::target_type & > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args ? args.read<const QString & > () : (const QString &)(QString());
  QObject *arg4 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (qt_gsi::QtToCppAdaptor<QSettings::Scope>(arg1).cref(), arg2, arg3, arg4));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSettings_Adaptor_7016 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_7016, &_call_ctor_QSettings_Adaptor_7016);
}

//  Constructor QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_9007 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QSettings::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("scope");
  decl->add_arg<const qt_gsi::Converter<QSettings::Scope>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("organization");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("application", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_4);
  decl->set_return_new<QSettings_Adaptor *> ();
}

static void _call_ctor_QSettings_Adaptor_9007 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSettings::Format>::target_type & arg1 = args.read<const qt_gsi::Converter<QSettings::Format>::target_type & > ();
  const qt_gsi::Converter<QSettings::Scope>::target_type & arg2 = args.read<const qt_gsi::Converter<QSettings::Scope>::target_type & > ();
  const QString &arg3 = args.read<const QString & > ();
  const QString &arg4 = args ? args.read<const QString & > () : (const QString &)(QString());
  QObject *arg5 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (qt_gsi::QtToCppAdaptor<QSettings::Format>(arg1).cref(), qt_gsi::QtToCppAdaptor<QSettings::Scope>(arg2).cref(), arg3, arg4, arg5));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSettings_Adaptor_9007 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(QSettings::Format format, QSettings::Scope scope, const QString &organization, const QString &application, QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_9007, &_call_ctor_QSettings_Adaptor_9007);
}

//  Constructor QSettings::QSettings(const QString &fileName, QSettings::Format format, QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_5210 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const qt_gsi::Converter<QSettings::Format>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QSettings_Adaptor *> ();
}

static void _call_ctor_QSettings_Adaptor_5210 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QSettings::Format>::target_type & arg2 = args.read<const qt_gsi::Converter<QSettings::Format>::target_type & > ();
  QObject *arg3 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QSettings::Format>(arg2).cref(), arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSettings_Adaptor_5210 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(const QString &fileName, QSettings::Format format, QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_5210, &_call_ctor_QSettings_Adaptor_5210);
}

//  Constructor QSettings::QSettings(QObject *parent) (adaptor class)

static void _init_ctor_QSettings_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSettings_Adaptor *> ();
}

static void _call_ctor_QSettings_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSettings_Adaptor *> (new QSettings_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSettings_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSettings::QSettings(QObject *parent)\nThis method creates an object of class QSettings.", &_init_ctor_QSettings_Adaptor_1302, &_call_ctor_QSettings_Adaptor_1302);
}

// int QSettings::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QSettings_Adaptor *)cls)->fp_QSettings_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QSettings::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QSettings::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QSettings_Adaptor *)cls)->fp_QSettings_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QSettings::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QSettings::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSettings_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSettings::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QSettings::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QSettings_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSettings::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QSettings::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QSettings_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSettings::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QSettings::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QSettings_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSettings::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QSettings::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSettings_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QSettings::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QSettings::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QSettings_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSettings_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSettings::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QSettings> decl_QSettings;

gsi::Class<QSettings_Adaptor> decl_QSettings_Adaptor (decl_QSettings, "QSettings",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QSettings_Adaptor_5136 ()) +
  gsi::Methods(_create_ctor_QSettings_Adaptor_7016 ()) +
  gsi::Methods(_create_ctor_QSettings_Adaptor_9007 ()) +
  gsi::Methods(_create_ctor_QSettings_Adaptor_5210 ()) +
  gsi::Methods(_create_ctor_QSettings_Adaptor_1302 ()),
  "@qt\n@brief Binding of QSettings");

}


//  Implementation of the enum wrapper class for QSettings::Format
namespace qt_gsi
{

static QSettings_Format_Enum *c_1_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::NativeFormat); }
static QSettings_Format_Enum *c_2_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::IniFormat); }
static QSettings_Format_Enum *c_3_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::InvalidFormat); }
static QSettings_Format_Enum *c_4_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat1); }
static QSettings_Format_Enum *c_5_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat2); }
static QSettings_Format_Enum *c_6_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat3); }
static QSettings_Format_Enum *c_7_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat4); }
static QSettings_Format_Enum *c_8_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat5); }
static QSettings_Format_Enum *c_9_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat6); }
static QSettings_Format_Enum *c_10_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat7); }
static QSettings_Format_Enum *c_11_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat8); }
static QSettings_Format_Enum *c_12_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat9); }
static QSettings_Format_Enum *c_13_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat10); }
static QSettings_Format_Enum *c_14_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat11); }
static QSettings_Format_Enum *c_15_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat12); }
static QSettings_Format_Enum *c_16_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat13); }
static QSettings_Format_Enum *c_17_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat14); }
static QSettings_Format_Enum *c_18_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat15); }
static QSettings_Format_Enum *c_19_QSettings_Format_Enum () { return new QSettings_Format_Enum (QSettings::CustomFormat16); }

static gsi::Methods mkdefs_QSettings_Format () {
  return
    gsi::constant ("NativeFormat", &qt_gsi::c_1_QSettings_Format_Enum, "@brief Enum constant QSettings::NativeFormat") +
    gsi::constant ("IniFormat", &qt_gsi::c_2_QSettings_Format_Enum, "@brief Enum constant QSettings::IniFormat") +
    gsi::constant ("InvalidFormat", &qt_gsi::c_3_QSettings_Format_Enum, "@brief Enum constant QSettings::InvalidFormat") +
    gsi::constant ("CustomFormat1", &qt_gsi::c_4_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat1") +
    gsi::constant ("CustomFormat2", &qt_gsi::c_5_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat2") +
    gsi::constant ("CustomFormat3", &qt_gsi::c_6_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat3") +
    gsi::constant ("CustomFormat4", &qt_gsi::c_7_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat4") +
    gsi::constant ("CustomFormat5", &qt_gsi::c_8_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat5") +
    gsi::constant ("CustomFormat6", &qt_gsi::c_9_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat6") +
    gsi::constant ("CustomFormat7", &qt_gsi::c_10_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat7") +
    gsi::constant ("CustomFormat8", &qt_gsi::c_11_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat8") +
    gsi::constant ("CustomFormat9", &qt_gsi::c_12_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat9") +
    gsi::constant ("CustomFormat10", &qt_gsi::c_13_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat10") +
    gsi::constant ("CustomFormat11", &qt_gsi::c_14_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat11") +
    gsi::constant ("CustomFormat12", &qt_gsi::c_15_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat12") +
    gsi::constant ("CustomFormat13", &qt_gsi::c_16_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat13") +
    gsi::constant ("CustomFormat14", &qt_gsi::c_17_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat14") +
    gsi::constant ("CustomFormat15", &qt_gsi::c_18_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat15") +
    gsi::constant ("CustomFormat16", &qt_gsi::c_19_QSettings_Format_Enum, "@brief Enum constant QSettings::CustomFormat16");
}

static std::string to_s_QSettings_Format_Enum (const QSettings_Format_Enum *e)
{
  if (e->value () == QSettings::NativeFormat) { return tl::sprintf ("NativeFormat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::IniFormat) { return tl::sprintf ("IniFormat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::InvalidFormat) { return tl::sprintf ("InvalidFormat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat1) { return tl::sprintf ("CustomFormat1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat2) { return tl::sprintf ("CustomFormat2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat3) { return tl::sprintf ("CustomFormat3 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat4) { return tl::sprintf ("CustomFormat4 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat5) { return tl::sprintf ("CustomFormat5 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat6) { return tl::sprintf ("CustomFormat6 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat7) { return tl::sprintf ("CustomFormat7 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat8) { return tl::sprintf ("CustomFormat8 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat9) { return tl::sprintf ("CustomFormat9 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat10) { return tl::sprintf ("CustomFormat10 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat11) { return tl::sprintf ("CustomFormat11 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat12) { return tl::sprintf ("CustomFormat12 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat13) { return tl::sprintf ("CustomFormat13 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat14) { return tl::sprintf ("CustomFormat14 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat15) { return tl::sprintf ("CustomFormat15 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::CustomFormat16) { return tl::sprintf ("CustomFormat16 (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSettings_Format_Enum (const QSettings_Format_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSettings_Format_Enum *from_i_QSettings_Format_Enum (unsigned int i)
{
  return new QSettings_Format_Enum ((QSettings::Format) i);
}

static bool equalQSettings_Format_Enum (const QSettings_Format_Enum *e, QSettings_Format_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSettings_Format_Enum (const QSettings_Format_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSettings_Format_Enums oropQSettings_Format_Enums (const QSettings_Format_Enums *e, const QSettings_Format_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSettings_Format_Enums andopQSettings_Format_Enums (const QSettings_Format_Enums *e, const QSettings_Format_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSettings_Format_Enums xoropQSettings_Format_Enums (const QSettings_Format_Enums *e, const QSettings_Format_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSettings_Format_Enums (const QSettings_Format_Enums *e)
{
  std::string l;
  if (e->testFlag (QSettings::NativeFormat)) { if (!l.empty ()) l += "|"; l += "NativeFormat"; }
  if (e->testFlag (QSettings::IniFormat)) { if (!l.empty ()) l += "|"; l += "IniFormat"; }
  if (e->testFlag (QSettings::InvalidFormat)) { if (!l.empty ()) l += "|"; l += "InvalidFormat"; }
  if (e->testFlag (QSettings::CustomFormat1)) { if (!l.empty ()) l += "|"; l += "CustomFormat1"; }
  if (e->testFlag (QSettings::CustomFormat2)) { if (!l.empty ()) l += "|"; l += "CustomFormat2"; }
  if (e->testFlag (QSettings::CustomFormat3)) { if (!l.empty ()) l += "|"; l += "CustomFormat3"; }
  if (e->testFlag (QSettings::CustomFormat4)) { if (!l.empty ()) l += "|"; l += "CustomFormat4"; }
  if (e->testFlag (QSettings::CustomFormat5)) { if (!l.empty ()) l += "|"; l += "CustomFormat5"; }
  if (e->testFlag (QSettings::CustomFormat6)) { if (!l.empty ()) l += "|"; l += "CustomFormat6"; }
  if (e->testFlag (QSettings::CustomFormat7)) { if (!l.empty ()) l += "|"; l += "CustomFormat7"; }
  if (e->testFlag (QSettings::CustomFormat8)) { if (!l.empty ()) l += "|"; l += "CustomFormat8"; }
  if (e->testFlag (QSettings::CustomFormat9)) { if (!l.empty ()) l += "|"; l += "CustomFormat9"; }
  if (e->testFlag (QSettings::CustomFormat10)) { if (!l.empty ()) l += "|"; l += "CustomFormat10"; }
  if (e->testFlag (QSettings::CustomFormat11)) { if (!l.empty ()) l += "|"; l += "CustomFormat11"; }
  if (e->testFlag (QSettings::CustomFormat12)) { if (!l.empty ()) l += "|"; l += "CustomFormat12"; }
  if (e->testFlag (QSettings::CustomFormat13)) { if (!l.empty ()) l += "|"; l += "CustomFormat13"; }
  if (e->testFlag (QSettings::CustomFormat14)) { if (!l.empty ()) l += "|"; l += "CustomFormat14"; }
  if (e->testFlag (QSettings::CustomFormat15)) { if (!l.empty ()) l += "|"; l += "CustomFormat15"; }
  if (e->testFlag (QSettings::CustomFormat16)) { if (!l.empty ()) l += "|"; l += "CustomFormat16"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSettings_Format_Enums (const QSettings_Format_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSettings_Format_Enums (const QSettings_Format_Enums *e, const QSettings_Format_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSettings_Format_Enums> decl_QSettings_Format_Enums ("QSettings_QFlags_Format",
  gsi::method_ext ("|", &qt_gsi::oropQSettings_Format_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSettings_Format_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSettings_Format_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSettings_Format_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSettings_Format_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSettings_Format_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSettings::Format> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSettings_Format_Enum> decl_QSettings_Format_Enum (decl_QSettings_Format_Enums, "QSettings_Format",
  qt_gsi::mkdefs_QSettings_Format () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSettings_Format_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSettings_Format_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSettings_Format_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSettings_Format_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSettings_Format_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSettings::Format enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSettings> inject_QSettings_Format_Enum_in_parent (qt_gsi::mkdefs_QSettings_Format ());
static gsi::ClassExt<QSettings> decl_QSettings_Format_Enum_as_child (decl_QSettings_Format_Enum, "Format");

}


//  Implementation of the enum wrapper class for QSettings::Scope
namespace qt_gsi
{

static QSettings_Scope_Enum *c_1_QSettings_Scope_Enum () { return new QSettings_Scope_Enum (QSettings::UserScope); }
static QSettings_Scope_Enum *c_2_QSettings_Scope_Enum () { return new QSettings_Scope_Enum (QSettings::SystemScope); }

static gsi::Methods mkdefs_QSettings_Scope () {
  return
    gsi::constant ("UserScope", &qt_gsi::c_1_QSettings_Scope_Enum, "@brief Enum constant QSettings::UserScope") +
    gsi::constant ("SystemScope", &qt_gsi::c_2_QSettings_Scope_Enum, "@brief Enum constant QSettings::SystemScope");
}

static std::string to_s_QSettings_Scope_Enum (const QSettings_Scope_Enum *e)
{
  if (e->value () == QSettings::UserScope) { return tl::sprintf ("UserScope (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::SystemScope) { return tl::sprintf ("SystemScope (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSettings_Scope_Enum (const QSettings_Scope_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSettings_Scope_Enum *from_i_QSettings_Scope_Enum (unsigned int i)
{
  return new QSettings_Scope_Enum ((QSettings::Scope) i);
}

static bool equalQSettings_Scope_Enum (const QSettings_Scope_Enum *e, QSettings_Scope_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSettings_Scope_Enum (const QSettings_Scope_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSettings_Scope_Enums oropQSettings_Scope_Enums (const QSettings_Scope_Enums *e, const QSettings_Scope_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSettings_Scope_Enums andopQSettings_Scope_Enums (const QSettings_Scope_Enums *e, const QSettings_Scope_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSettings_Scope_Enums xoropQSettings_Scope_Enums (const QSettings_Scope_Enums *e, const QSettings_Scope_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSettings_Scope_Enums (const QSettings_Scope_Enums *e)
{
  std::string l;
  if (e->testFlag (QSettings::UserScope)) { if (!l.empty ()) l += "|"; l += "UserScope"; }
  if (e->testFlag (QSettings::SystemScope)) { if (!l.empty ()) l += "|"; l += "SystemScope"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSettings_Scope_Enums (const QSettings_Scope_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSettings_Scope_Enums (const QSettings_Scope_Enums *e, const QSettings_Scope_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSettings_Scope_Enums> decl_QSettings_Scope_Enums ("QSettings_QFlags_Scope",
  gsi::method_ext ("|", &qt_gsi::oropQSettings_Scope_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSettings_Scope_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSettings_Scope_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSettings_Scope_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSettings_Scope_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSettings_Scope_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSettings::Scope> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSettings_Scope_Enum> decl_QSettings_Scope_Enum (decl_QSettings_Scope_Enums, "QSettings_Scope",
  qt_gsi::mkdefs_QSettings_Scope () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSettings_Scope_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSettings_Scope_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSettings_Scope_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSettings_Scope_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSettings_Scope_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSettings::Scope enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSettings> inject_QSettings_Scope_Enum_in_parent (qt_gsi::mkdefs_QSettings_Scope ());
static gsi::ClassExt<QSettings> decl_QSettings_Scope_Enum_as_child (decl_QSettings_Scope_Enum, "Scope");

}


//  Implementation of the enum wrapper class for QSettings::Status
namespace qt_gsi
{

static QSettings_Status_Enum *c_1_QSettings_Status_Enum () { return new QSettings_Status_Enum (QSettings::NoError); }
static QSettings_Status_Enum *c_2_QSettings_Status_Enum () { return new QSettings_Status_Enum (QSettings::AccessError); }
static QSettings_Status_Enum *c_3_QSettings_Status_Enum () { return new QSettings_Status_Enum (QSettings::FormatError); }

static gsi::Methods mkdefs_QSettings_Status () {
  return
    gsi::constant ("NoError", &qt_gsi::c_1_QSettings_Status_Enum, "@brief Enum constant QSettings::NoError") +
    gsi::constant ("AccessError", &qt_gsi::c_2_QSettings_Status_Enum, "@brief Enum constant QSettings::AccessError") +
    gsi::constant ("FormatError", &qt_gsi::c_3_QSettings_Status_Enum, "@brief Enum constant QSettings::FormatError");
}

static std::string to_s_QSettings_Status_Enum (const QSettings_Status_Enum *e)
{
  if (e->value () == QSettings::NoError) { return tl::sprintf ("NoError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::AccessError) { return tl::sprintf ("AccessError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSettings::FormatError) { return tl::sprintf ("FormatError (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSettings_Status_Enum (const QSettings_Status_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSettings_Status_Enum *from_i_QSettings_Status_Enum (unsigned int i)
{
  return new QSettings_Status_Enum ((QSettings::Status) i);
}

static bool equalQSettings_Status_Enum (const QSettings_Status_Enum *e, QSettings_Status_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSettings_Status_Enum (const QSettings_Status_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSettings_Status_Enums oropQSettings_Status_Enums (const QSettings_Status_Enums *e, const QSettings_Status_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSettings_Status_Enums andopQSettings_Status_Enums (const QSettings_Status_Enums *e, const QSettings_Status_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSettings_Status_Enums xoropQSettings_Status_Enums (const QSettings_Status_Enums *e, const QSettings_Status_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSettings_Status_Enums (const QSettings_Status_Enums *e)
{
  std::string l;
  if (e->testFlag (QSettings::NoError)) { if (!l.empty ()) l += "|"; l += "NoError"; }
  if (e->testFlag (QSettings::AccessError)) { if (!l.empty ()) l += "|"; l += "AccessError"; }
  if (e->testFlag (QSettings::FormatError)) { if (!l.empty ()) l += "|"; l += "FormatError"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSettings_Status_Enums (const QSettings_Status_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSettings_Status_Enums (const QSettings_Status_Enums *e, const QSettings_Status_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSettings_Status_Enums> decl_QSettings_Status_Enums ("QSettings_QFlags_Status",
  gsi::method_ext ("|", &qt_gsi::oropQSettings_Status_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSettings_Status_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSettings_Status_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSettings_Status_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSettings_Status_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSettings_Status_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSettings::Status> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSettings_Status_Enum> decl_QSettings_Status_Enum (decl_QSettings_Status_Enums, "QSettings_Status",
  qt_gsi::mkdefs_QSettings_Status () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSettings_Status_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSettings_Status_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSettings_Status_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSettings_Status_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSettings_Status_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSettings::Status enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSettings> inject_QSettings_Status_Enum_in_parent (qt_gsi::mkdefs_QSettings_Status ());
static gsi::ClassExt<QSettings> decl_QSettings_Status_Enum_as_child (decl_QSettings_Status_Enum, "Status");

}

