
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file generated/gsiDeclQProcess_EventAdaptor.cc
*  @brief Event adaptor implementations for QProcess
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQProcess_EventAdaptor.h"

// -----------------------------------------------------------------------
// class QProcess_EventAdaptor

QProcess_EventAdaptor::QProcess_EventAdaptor (QObject *host)
  : QObject ()
{
  connect (host, SIGNAL(aboutToClose()), this, SLOT(aboutToClose()));
  connect (host, SIGNAL(bytesWritten(qint64)), this, SLOT(bytesWritten(qint64)));
  connect (host, SIGNAL(destroyed(QObject *)), this, SLOT(destroyed(QObject *)));
  connect (host, SIGNAL(error(QProcess::ProcessError)), this, SLOT(error(QProcess::ProcessError)));
  connect (host, SIGNAL(finished(int)), this, SLOT(finished(int)));
  connect (host, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(finished(int, QProcess::ExitStatus)));
  connect (host, SIGNAL(readChannelFinished()), this, SLOT(readChannelFinished()));
  connect (host, SIGNAL(readyRead()), this, SLOT(readyRead()));
  connect (host, SIGNAL(readyReadStandardError()), this, SLOT(readyReadStandardError()));
  connect (host, SIGNAL(readyReadStandardOutput()), this, SLOT(readyReadStandardOutput()));
  connect (host, SIGNAL(started()), this, SLOT(started()));
  connect (host, SIGNAL(stateChanged(QProcess::ProcessState)), this, SLOT(stateChanged(QProcess::ProcessState)));
}

//  Event QProcess::aboutToClose()
void QProcess_EventAdaptor::aboutToClose() {
BEGIN_PROTECTED
  aboutToClose_e_0();
END_PROTECTED
}

//  Event QProcess::bytesWritten(qint64 bytes)
void QProcess_EventAdaptor::bytesWritten(qint64 bytes) {
BEGIN_PROTECTED
  bytesWritten_e_986(bytes);
END_PROTECTED
}

//  Event QProcess::destroyed(QObject *arg1)
void QProcess_EventAdaptor::destroyed(QObject *arg1) {
BEGIN_PROTECTED
  destroyed_e_1302(arg1);
END_PROTECTED
}

//  Event QProcess::error(QProcess::ProcessError error)
void QProcess_EventAdaptor::error(QProcess::ProcessError error) {
BEGIN_PROTECTED
  error_e_2625(qt_gsi::CppToQtAdaptor<QProcess::ProcessError>(error));
END_PROTECTED
}

//  Event QProcess::finished(int exitCode)
void QProcess_EventAdaptor::finished(int exitCode) {
BEGIN_PROTECTED
  finished_e_767(exitCode);
END_PROTECTED
}

//  Event QProcess::finished(int exitCode, QProcess::ExitStatus exitStatus)
void QProcess_EventAdaptor::finished(int exitCode, QProcess::ExitStatus exitStatus) {
BEGIN_PROTECTED
  finished_e_3081(exitCode, qt_gsi::CppToQtAdaptor<QProcess::ExitStatus>(exitStatus));
END_PROTECTED
}

//  Event QProcess::readChannelFinished()
void QProcess_EventAdaptor::readChannelFinished() {
BEGIN_PROTECTED
  readChannelFinished_e_0();
END_PROTECTED
}

//  Event QProcess::readyRead()
void QProcess_EventAdaptor::readyRead() {
BEGIN_PROTECTED
  readyRead_e_0();
END_PROTECTED
}

//  Event QProcess::readyReadStandardError()
void QProcess_EventAdaptor::readyReadStandardError() {
BEGIN_PROTECTED
  readyReadStandardError_e_0();
END_PROTECTED
}

//  Event QProcess::readyReadStandardOutput()
void QProcess_EventAdaptor::readyReadStandardOutput() {
BEGIN_PROTECTED
  readyReadStandardOutput_e_0();
END_PROTECTED
}

//  Event QProcess::started()
void QProcess_EventAdaptor::started() {
BEGIN_PROTECTED
  started_e_0();
END_PROTECTED
}

//  Event QProcess::stateChanged(QProcess::ProcessState state)
void QProcess_EventAdaptor::stateChanged(QProcess::ProcessState state) {
BEGIN_PROTECTED
  stateChanged_e_2616(qt_gsi::CppToQtAdaptor<QProcess::ProcessState>(state));
END_PROTECTED
}
