
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQProcess.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQProcess_EventAdaptor.h"
#include "gsiDeclQProcess_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QProcess

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QProcess::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

//  Constructor QProcess::QProcess(QObject *parent)


static void _init_ctor_QProcess_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QProcess *> ();
}

static void _call_ctor_QProcess_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QProcess *> (new QProcess (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QProcess_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QProcess::QProcess(QObject *parent)\nThis method creates an object of class QProcess.", &_init_ctor_QProcess_1302, &_call_ctor_QProcess_1302);
}

// bool QProcess::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QProcess *)cls)->atEnd ());
}

static qt_gsi::GenericMethod *_create_f_atEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QProcess::atEnd()\nThis is a reimplementation of QIODevice::atEnd", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
}

// qint64 QProcess::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QProcess *)cls)->bytesAvailable ());
}

static qt_gsi::GenericMethod *_create_f_bytesAvailable_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QProcess::bytesAvailable()\nThis is a reimplementation of QIODevice::bytesAvailable", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
}

// qint64 QProcess::bytesToWrite()


static void _init_f_bytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesToWrite_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QProcess *)cls)->bytesToWrite ());
}

static qt_gsi::GenericMethod *_create_f_bytesToWrite_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesToWrite", "@brief Method qint64 QProcess::bytesToWrite()\nThis is a reimplementation of QIODevice::bytesToWrite", true, &_init_f_bytesToWrite_c0, &_call_f_bytesToWrite_c0);
}

// bool QProcess::canReadLine()


static void _init_f_canReadLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canReadLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QProcess *)cls)->canReadLine ());
}

static qt_gsi::GenericMethod *_create_f_canReadLine_c0 ()
{
  return new qt_gsi::GenericMethod ("canReadLine", "@brief Method bool QProcess::canReadLine()\nThis is a reimplementation of QIODevice::canReadLine", true, &_init_f_canReadLine_c0, &_call_f_canReadLine_c0);
}

// void QProcess::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QProcess *)cls)->close ();
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method void QProcess::close()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
}

// void QProcess::closeReadChannel(QProcess::ProcessChannel channel)


static void _init_f_closeReadChannel_2800 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("channel");
  decl->add_arg<const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_closeReadChannel_2800 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & arg1 = args.read<const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & > ();
  ((QProcess *)cls)->closeReadChannel (qt_gsi::QtToCppAdaptor<QProcess::ProcessChannel>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_closeReadChannel_2800 ()
{
  return new qt_gsi::GenericMethod ("closeReadChannel", "@brief Method void QProcess::closeReadChannel(QProcess::ProcessChannel channel)\n", false, &_init_f_closeReadChannel_2800, &_call_f_closeReadChannel_2800);
}

// void QProcess::closeWriteChannel()


static void _init_f_closeWriteChannel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeWriteChannel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QProcess *)cls)->closeWriteChannel ();
}

static qt_gsi::GenericMethod *_create_f_closeWriteChannel_0 ()
{
  return new qt_gsi::GenericMethod ("closeWriteChannel", "@brief Method void QProcess::closeWriteChannel()\n", false, &_init_f_closeWriteChannel_0, &_call_f_closeWriteChannel_0);
}

// QStringList QProcess::environment()


static void _init_f_environment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_environment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QProcess *)cls)->environment ()));
}

static qt_gsi::GenericMethod *_create_f_environment_c0 ()
{
  return new qt_gsi::GenericMethod (":environment", "@brief Method QStringList QProcess::environment()\n", true, &_init_f_environment_c0, &_call_f_environment_c0);
}

// QProcess::ProcessError QProcess::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QProcess::ProcessError>::target_type > ((qt_gsi::Converter<QProcess::ProcessError>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessError>(((QProcess *)cls)->error ()));
}

static qt_gsi::GenericMethod *_create_f_error_c0 ()
{
  return new qt_gsi::GenericMethod ("error", "@brief Method QProcess::ProcessError QProcess::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
}

// int QProcess::exitCode()


static void _init_f_exitCode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_exitCode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QProcess *)cls)->exitCode ());
}

static qt_gsi::GenericMethod *_create_f_exitCode_c0 ()
{
  return new qt_gsi::GenericMethod ("exitCode", "@brief Method int QProcess::exitCode()\n", true, &_init_f_exitCode_c0, &_call_f_exitCode_c0);
}

// QProcess::ExitStatus QProcess::exitStatus()


static void _init_f_exitStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ExitStatus>::target_type > ();
}

static void _call_f_exitStatus_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QProcess::ExitStatus>::target_type > ((qt_gsi::Converter<QProcess::ExitStatus>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ExitStatus>(((QProcess *)cls)->exitStatus ()));
}

static qt_gsi::GenericMethod *_create_f_exitStatus_c0 ()
{
  return new qt_gsi::GenericMethod ("exitStatus", "@brief Method QProcess::ExitStatus QProcess::exitStatus()\n", true, &_init_f_exitStatus_c0, &_call_f_exitStatus_c0);
}

// bool QProcess::isSequential()


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QProcess *)cls)->isSequential ());
}

static qt_gsi::GenericMethod *_create_f_isSequential_c0 ()
{
  return new qt_gsi::GenericMethod ("isSequential?", "@brief Method bool QProcess::isSequential()\nThis is a reimplementation of QIODevice::isSequential", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
}

// void QProcess::kill()


static void _init_f_kill_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_kill_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QProcess *)cls)->kill ();
}

static qt_gsi::GenericMethod *_create_f_kill_0 ()
{
  return new qt_gsi::GenericMethod ("kill", "@brief Method void QProcess::kill()\n", false, &_init_f_kill_0, &_call_f_kill_0);
}

// Q_PID QProcess::pid()


static void _init_f_pid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Q_PID>::target_type > ();
}

static void _call_f_pid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Q_PID>::target_type > ((qt_gsi::Converter<Q_PID>::target_type)qt_gsi::CppToQtAdaptor<Q_PID>(((QProcess *)cls)->pid ()));
}

static qt_gsi::GenericMethod *_create_f_pid_c0 ()
{
  return new qt_gsi::GenericMethod ("pid", "@brief Method Q_PID QProcess::pid()\n", true, &_init_f_pid_c0, &_call_f_pid_c0);
}

// QProcess::ProcessChannelMode QProcess::processChannelMode()


static void _init_f_processChannelMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type > ();
}

static void _call_f_processChannelMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type > ((qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessChannelMode>(((QProcess *)cls)->processChannelMode ()));
}

static qt_gsi::GenericMethod *_create_f_processChannelMode_c0 ()
{
  return new qt_gsi::GenericMethod (":processChannelMode", "@brief Method QProcess::ProcessChannelMode QProcess::processChannelMode()\n", true, &_init_f_processChannelMode_c0, &_call_f_processChannelMode_c0);
}

// QProcessEnvironment QProcess::processEnvironment()


static void _init_f_processEnvironment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QProcessEnvironment > ();
}

static void _call_f_processEnvironment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QProcessEnvironment > ((QProcessEnvironment)((QProcess *)cls)->processEnvironment ());
}

static qt_gsi::GenericMethod *_create_f_processEnvironment_c0 ()
{
  return new qt_gsi::GenericMethod (":processEnvironment", "@brief Method QProcessEnvironment QProcess::processEnvironment()\n", true, &_init_f_processEnvironment_c0, &_call_f_processEnvironment_c0);
}

// QByteArray QProcess::readAllStandardError()


static void _init_f_readAllStandardError_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_readAllStandardError_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QProcess *)cls)->readAllStandardError ());
}

static qt_gsi::GenericMethod *_create_f_readAllStandardError_0 ()
{
  return new qt_gsi::GenericMethod ("readAllStandardError", "@brief Method QByteArray QProcess::readAllStandardError()\n", false, &_init_f_readAllStandardError_0, &_call_f_readAllStandardError_0);
}

// QByteArray QProcess::readAllStandardOutput()


static void _init_f_readAllStandardOutput_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_readAllStandardOutput_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QProcess *)cls)->readAllStandardOutput ());
}

static qt_gsi::GenericMethod *_create_f_readAllStandardOutput_0 ()
{
  return new qt_gsi::GenericMethod ("readAllStandardOutput", "@brief Method QByteArray QProcess::readAllStandardOutput()\n", false, &_init_f_readAllStandardOutput_0, &_call_f_readAllStandardOutput_0);
}

// QProcess::ProcessChannel QProcess::readChannel()


static void _init_f_readChannel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessChannel>::target_type > ();
}

static void _call_f_readChannel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QProcess::ProcessChannel>::target_type > ((qt_gsi::Converter<QProcess::ProcessChannel>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessChannel>(((QProcess *)cls)->readChannel ()));
}

static qt_gsi::GenericMethod *_create_f_readChannel_c0 ()
{
  return new qt_gsi::GenericMethod (":readChannel", "@brief Method QProcess::ProcessChannel QProcess::readChannel()\n", true, &_init_f_readChannel_c0, &_call_f_readChannel_c0);
}

// QProcess::ProcessChannelMode QProcess::readChannelMode()


static void _init_f_readChannelMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type > ();
}

static void _call_f_readChannelMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type > ((qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessChannelMode>(((QProcess *)cls)->readChannelMode ()));
}

static qt_gsi::GenericMethod *_create_f_readChannelMode_c0 ()
{
  return new qt_gsi::GenericMethod (":readChannelMode", "@brief Method QProcess::ProcessChannelMode QProcess::readChannelMode()\n", true, &_init_f_readChannelMode_c0, &_call_f_readChannelMode_c0);
}

// void QProcess::setEnvironment(const QStringList &environment)


static void _init_f_setEnvironment_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("environment");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnvironment_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QProcess *)cls)->setEnvironment (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setEnvironment_2437 ()
{
  return new qt_gsi::GenericMethod ("setEnvironment|environment=", "@brief Method void QProcess::setEnvironment(const QStringList &environment)\n", false, &_init_f_setEnvironment_2437, &_call_f_setEnvironment_2437);
}

// void QProcess::setProcessChannelMode(QProcess::ProcessChannelMode mode)


static void _init_f_setProcessChannelMode_3189 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProcessChannelMode_3189 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & > ();
  ((QProcess *)cls)->setProcessChannelMode (qt_gsi::QtToCppAdaptor<QProcess::ProcessChannelMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setProcessChannelMode_3189 ()
{
  return new qt_gsi::GenericMethod ("setProcessChannelMode|processChannelMode=", "@brief Method void QProcess::setProcessChannelMode(QProcess::ProcessChannelMode mode)\n", false, &_init_f_setProcessChannelMode_3189, &_call_f_setProcessChannelMode_3189);
}

// void QProcess::setProcessEnvironment(const QProcessEnvironment &environment)


static void _init_f_setProcessEnvironment_3302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("environment");
  decl->add_arg<const QProcessEnvironment & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProcessEnvironment_3302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QProcessEnvironment &arg1 = args.read<const QProcessEnvironment & > ();
  ((QProcess *)cls)->setProcessEnvironment (arg1);
}

static qt_gsi::GenericMethod *_create_f_setProcessEnvironment_3302 ()
{
  return new qt_gsi::GenericMethod ("setProcessEnvironment|processEnvironment=", "@brief Method void QProcess::setProcessEnvironment(const QProcessEnvironment &environment)\n", false, &_init_f_setProcessEnvironment_3302, &_call_f_setProcessEnvironment_3302);
}

// void QProcess::setReadChannel(QProcess::ProcessChannel channel)


static void _init_f_setReadChannel_2800 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("channel");
  decl->add_arg<const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadChannel_2800 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & arg1 = args.read<const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & > ();
  ((QProcess *)cls)->setReadChannel (qt_gsi::QtToCppAdaptor<QProcess::ProcessChannel>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setReadChannel_2800 ()
{
  return new qt_gsi::GenericMethod ("setReadChannel|readChannel=", "@brief Method void QProcess::setReadChannel(QProcess::ProcessChannel channel)\n", false, &_init_f_setReadChannel_2800, &_call_f_setReadChannel_2800);
}

// void QProcess::setReadChannelMode(QProcess::ProcessChannelMode mode)


static void _init_f_setReadChannelMode_3189 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadChannelMode_3189 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & > ();
  ((QProcess *)cls)->setReadChannelMode (qt_gsi::QtToCppAdaptor<QProcess::ProcessChannelMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setReadChannelMode_3189 ()
{
  return new qt_gsi::GenericMethod ("setReadChannelMode|readChannelMode=", "@brief Method void QProcess::setReadChannelMode(QProcess::ProcessChannelMode mode)\n", false, &_init_f_setReadChannelMode_3189, &_call_f_setReadChannelMode_3189);
}

// void QProcess::setStandardErrorFile(const QString &fileName, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_setStandardErrorFile_5159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIODevice::Truncate");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setStandardErrorFile_5159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::Truncate));
  ((QProcess *)cls)->setStandardErrorFile (arg1, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setStandardErrorFile_5159 ()
{
  return new qt_gsi::GenericMethod ("setStandardErrorFile", "@brief Method void QProcess::setStandardErrorFile(const QString &fileName, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_setStandardErrorFile_5159, &_call_f_setStandardErrorFile_5159);
}

// void QProcess::setStandardInputFile(const QString &fileName)


static void _init_f_setStandardInputFile_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStandardInputFile_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QProcess *)cls)->setStandardInputFile (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStandardInputFile_2025 ()
{
  return new qt_gsi::GenericMethod ("setStandardInputFile", "@brief Method void QProcess::setStandardInputFile(const QString &fileName)\n", false, &_init_f_setStandardInputFile_2025, &_call_f_setStandardInputFile_2025);
}

// void QProcess::setStandardOutputFile(const QString &fileName, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_setStandardOutputFile_5159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIODevice::Truncate");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setStandardOutputFile_5159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::Truncate));
  ((QProcess *)cls)->setStandardOutputFile (arg1, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setStandardOutputFile_5159 ()
{
  return new qt_gsi::GenericMethod ("setStandardOutputFile", "@brief Method void QProcess::setStandardOutputFile(const QString &fileName, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_setStandardOutputFile_5159, &_call_f_setStandardOutputFile_5159);
}

// void QProcess::setStandardOutputProcess(QProcess *destination)


static void _init_f_setStandardOutputProcess_1438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destination");
  decl->add_arg<QProcess * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStandardOutputProcess_1438 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QProcess *arg1 = args.read<QProcess * > ();
  ((QProcess *)cls)->setStandardOutputProcess (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStandardOutputProcess_1438 ()
{
  return new qt_gsi::GenericMethod ("setStandardOutputProcess", "@brief Method void QProcess::setStandardOutputProcess(QProcess *destination)\n", false, &_init_f_setStandardOutputProcess_1438, &_call_f_setStandardOutputProcess_1438);
}

// void QProcess::setWorkingDirectory(const QString &dir)


static void _init_f_setWorkingDirectory_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWorkingDirectory_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QProcess *)cls)->setWorkingDirectory (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWorkingDirectory_2025 ()
{
  return new qt_gsi::GenericMethod ("setWorkingDirectory|workingDirectory=", "@brief Method void QProcess::setWorkingDirectory(const QString &dir)\n", false, &_init_f_setWorkingDirectory_2025, &_call_f_setWorkingDirectory_2025);
}

// void QProcess::start(const QString &program, const QStringList &arguments, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_start_7488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arguments");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_start_7488 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QStringList>::target_type & arg2 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ((QProcess *)cls)->start (arg1, qt_gsi::QtToCppAdaptor<QStringList>(arg2).cref(), qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_start_7488 ()
{
  return new qt_gsi::GenericMethod ("start", "@brief Method void QProcess::start(const QString &program, const QStringList &arguments, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_start_7488, &_call_f_start_7488);
}

// void QProcess::start(const QString &program, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_start_5159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_start_5159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ((QProcess *)cls)->start (arg1, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_start_5159 ()
{
  return new qt_gsi::GenericMethod ("start", "@brief Method void QProcess::start(const QString &program, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_start_5159, &_call_f_start_5159);
}

// QProcess::ProcessState QProcess::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessState>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QProcess::ProcessState>::target_type > ((qt_gsi::Converter<QProcess::ProcessState>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessState>(((QProcess *)cls)->state ()));
}

static qt_gsi::GenericMethod *_create_f_state_c0 ()
{
  return new qt_gsi::GenericMethod ("state", "@brief Method QProcess::ProcessState QProcess::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
}

// void QProcess::terminate()


static void _init_f_terminate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_terminate_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QProcess *)cls)->terminate ();
}

static qt_gsi::GenericMethod *_create_f_terminate_0 ()
{
  return new qt_gsi::GenericMethod ("terminate", "@brief Method void QProcess::terminate()\n", false, &_init_f_terminate_0, &_call_f_terminate_0);
}

// bool QProcess::waitForBytesWritten(int msecs)


static void _init_f_waitForBytesWritten_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForBytesWritten_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QProcess *)cls)->waitForBytesWritten (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForBytesWritten_767 ()
{
  return new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Method bool QProcess::waitForBytesWritten(int msecs)\nThis is a reimplementation of QIODevice::waitForBytesWritten", false, &_init_f_waitForBytesWritten_767, &_call_f_waitForBytesWritten_767);
}

// bool QProcess::waitForFinished(int msecs)


static void _init_f_waitForFinished_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForFinished_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QProcess *)cls)->waitForFinished (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForFinished_767 ()
{
  return new qt_gsi::GenericMethod ("waitForFinished", "@brief Method bool QProcess::waitForFinished(int msecs)\n", false, &_init_f_waitForFinished_767, &_call_f_waitForFinished_767);
}

// bool QProcess::waitForReadyRead(int msecs)


static void _init_f_waitForReadyRead_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForReadyRead_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QProcess *)cls)->waitForReadyRead (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForReadyRead_767 ()
{
  return new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Method bool QProcess::waitForReadyRead(int msecs)\nThis is a reimplementation of QIODevice::waitForReadyRead", false, &_init_f_waitForReadyRead_767, &_call_f_waitForReadyRead_767);
}

// bool QProcess::waitForStarted(int msecs)


static void _init_f_waitForStarted_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForStarted_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QProcess *)cls)->waitForStarted (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForStarted_767 ()
{
  return new qt_gsi::GenericMethod ("waitForStarted", "@brief Method bool QProcess::waitForStarted(int msecs)\n", false, &_init_f_waitForStarted_767, &_call_f_waitForStarted_767);
}

// QString QProcess::workingDirectory()


static void _init_f_workingDirectory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_workingDirectory_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QProcess *)cls)->workingDirectory ());
}

static qt_gsi::GenericMethod *_create_f_workingDirectory_c0 ()
{
  return new qt_gsi::GenericMethod (":workingDirectory", "@brief Method QString QProcess::workingDirectory()\n", true, &_init_f_workingDirectory_c0, &_call_f_workingDirectory_c0);
}

// static int QProcess::execute(const QString &program, const QStringList &arguments)


static void _init_f_execute_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arguments");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_execute_4354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QStringList>::target_type & arg2 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ret.write<int > ((int)QProcess::execute (arg1, qt_gsi::QtToCppAdaptor<QStringList>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_execute_4354 ()
{
  return new qt_gsi::GenericStaticMethod ("execute", "@brief Static method int QProcess::execute(const QString &program, const QStringList &arguments)\nThis method is static and can be called without an instance.", &_init_f_execute_4354, &_call_f_execute_4354);
}

// static int QProcess::execute(const QString &program)


static void _init_f_execute_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_execute_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<int > ((int)QProcess::execute (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_execute_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("execute", "@brief Static method int QProcess::execute(const QString &program)\nThis method is static and can be called without an instance.", &_init_f_execute_2025, &_call_f_execute_2025);
}

// static bool QProcess::startDetached(const QString &program, const QStringList &arguments, const QString &workingDirectory, qint64 *pid)


static void _init_f_startDetached_7335 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arguments");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("workingDirectory");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pid", true, "0");
  decl->add_arg<qint64 * > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_startDetached_7335 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QStringList>::target_type & arg2 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  const QString &arg3 = args.read<const QString & > ();
  qint64 *arg4 = args ? args.read<qint64 * > () : (qint64 *)(0);
  ret.write<bool > ((bool)QProcess::startDetached (arg1, qt_gsi::QtToCppAdaptor<QStringList>(arg2).cref(), arg3, arg4));
}

static qt_gsi::GenericStaticMethod *_create_f_startDetached_7335 ()
{
  return new qt_gsi::GenericStaticMethod ("startDetached", "@brief Static method bool QProcess::startDetached(const QString &program, const QStringList &arguments, const QString &workingDirectory, qint64 *pid)\nThis method is static and can be called without an instance.", &_init_f_startDetached_7335, &_call_f_startDetached_7335);
}

// static bool QProcess::startDetached(const QString &program, const QStringList &arguments)


static void _init_f_startDetached_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arguments");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_startDetached_4354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QStringList>::target_type & arg2 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ret.write<bool > ((bool)QProcess::startDetached (arg1, qt_gsi::QtToCppAdaptor<QStringList>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_startDetached_4354 ()
{
  return new qt_gsi::GenericStaticMethod ("startDetached", "@brief Static method bool QProcess::startDetached(const QString &program, const QStringList &arguments)\nThis method is static and can be called without an instance.", &_init_f_startDetached_4354, &_call_f_startDetached_4354);
}

// static bool QProcess::startDetached(const QString &program)


static void _init_f_startDetached_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_startDetached_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)QProcess::startDetached (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_startDetached_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("startDetached", "@brief Static method bool QProcess::startDetached(const QString &program)\nThis method is static and can be called without an instance.", &_init_f_startDetached_2025, &_call_f_startDetached_2025);
}

// static QStringList QProcess::systemEnvironment()


static void _init_f_systemEnvironment_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_systemEnvironment_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QProcess::systemEnvironment ()));
}

static qt_gsi::GenericStaticMethod *_create_f_systemEnvironment_0 ()
{
  return new qt_gsi::GenericStaticMethod ("systemEnvironment", "@brief Static method QStringList QProcess::systemEnvironment()\nThis method is static and can be called without an instance.", &_init_f_systemEnvironment_0, &_call_f_systemEnvironment_0);
}

// static QString QProcess::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QProcess::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QProcess::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QProcess::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QProcess::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QProcess::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QProcess::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QProcess::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QProcess::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QProcess::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QProcess::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QProcess::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QProcess, QProcess_EventAdaptor> ea_QProcess;


namespace gsi
{
extern gsi::Class<QIODevice> decl_QIODevice;

gsi::Class<QProcess> decl_QProcess (ea_QProcess, decl_QIODevice, "QProcess",
  gsi::Methods(_create_ctor_QProcess_1302 ()) +
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_atEnd_c0 ()) +
  gsi::Methods(_create_f_bytesAvailable_c0 ()) +
  gsi::Methods(_create_f_bytesToWrite_c0 ()) +
  gsi::Methods(_create_f_canReadLine_c0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_closeReadChannel_2800 ()) +
  gsi::Methods(_create_f_closeWriteChannel_0 ()) +
  gsi::Methods(_create_f_environment_c0 ()) +
  gsi::Methods(_create_f_error_c0 ()) +
  gsi::Methods(_create_f_exitCode_c0 ()) +
  gsi::Methods(_create_f_exitStatus_c0 ()) +
  gsi::Methods(_create_f_isSequential_c0 ()) +
  gsi::Methods(_create_f_kill_0 ()) +
  gsi::Methods(_create_f_pid_c0 ()) +
  gsi::Methods(_create_f_processChannelMode_c0 ()) +
  gsi::Methods(_create_f_processEnvironment_c0 ()) +
  gsi::Methods(_create_f_readAllStandardError_0 ()) +
  gsi::Methods(_create_f_readAllStandardOutput_0 ()) +
  gsi::Methods(_create_f_readChannel_c0 ()) +
  gsi::Methods(_create_f_readChannelMode_c0 ()) +
  gsi::Methods(_create_f_setEnvironment_2437 ()) +
  gsi::Methods(_create_f_setProcessChannelMode_3189 ()) +
  gsi::Methods(_create_f_setProcessEnvironment_3302 ()) +
  gsi::Methods(_create_f_setReadChannel_2800 ()) +
  gsi::Methods(_create_f_setReadChannelMode_3189 ()) +
  gsi::Methods(_create_f_setStandardErrorFile_5159 ()) +
  gsi::Methods(_create_f_setStandardInputFile_2025 ()) +
  gsi::Methods(_create_f_setStandardOutputFile_5159 ()) +
  gsi::Methods(_create_f_setStandardOutputProcess_1438 ()) +
  gsi::Methods(_create_f_setWorkingDirectory_2025 ()) +
  gsi::Methods(_create_f_start_7488 ()) +
  gsi::Methods(_create_f_start_5159 ()) +
  gsi::Methods(_create_f_state_c0 ()) +
  gsi::Methods(_create_f_terminate_0 ()) +
  gsi::Methods(_create_f_waitForBytesWritten_767 ()) +
  gsi::Methods(_create_f_waitForFinished_767 ()) +
  gsi::Methods(_create_f_waitForReadyRead_767 ()) +
  gsi::Methods(_create_f_waitForStarted_767 ()) +
  gsi::Methods(_create_f_workingDirectory_c0 ()) +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor> ("aboutToClose", &QProcess_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QProcess::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor, qint64> ("bytesWritten", &QProcess_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QProcess::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor, QObject *> ("destroyed", &QProcess_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QProcess::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor, const qt_gsi::Converter<QProcess::ProcessError>::target_type &> ("error", &QProcess_EventAdaptor::error_e_2625, gsi::arg("error"), "@brief Signal declaration for QProcess::error(QProcess::ProcessError error)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor, int> ("finished", &QProcess_EventAdaptor::finished_e_767, gsi::arg("exitCode"), "@brief Signal declaration for QProcess::finished(int exitCode)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor, int, const qt_gsi::Converter<QProcess::ExitStatus>::target_type &> ("finished", &QProcess_EventAdaptor::finished_e_3081, gsi::arg("exitCode"), gsi::arg("exitStatus"), "@brief Signal declaration for QProcess::finished(int exitCode, QProcess::ExitStatus exitStatus)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor> ("readChannelFinished", &QProcess_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QProcess::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor> ("readyRead", &QProcess_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QProcess::readyRead()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor> ("readyReadStandardError", &QProcess_EventAdaptor::readyReadStandardError_e_0, "@brief Signal declaration for QProcess::readyReadStandardError()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor> ("readyReadStandardOutput", &QProcess_EventAdaptor::readyReadStandardOutput_e_0, "@brief Signal declaration for QProcess::readyReadStandardOutput()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor> ("started", &QProcess_EventAdaptor::started_e_0, "@brief Signal declaration for QProcess::started()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QProcess, QProcess_EventAdaptor, const qt_gsi::Converter<QProcess::ProcessState>::target_type &> ("stateChanged", &QProcess_EventAdaptor::stateChanged_e_2616, gsi::arg("state"), "@brief Signal declaration for QProcess::stateChanged(QProcess::ProcessState state)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_execute_4354 ()) +
  gsi::Methods(_create_f_execute_2025 ()) +
  gsi::Methods(_create_f_startDetached_7335 ()) +
  gsi::Methods(_create_f_startDetached_4354 ()) +
  gsi::Methods(_create_f_startDetached_2025 ()) +
  gsi::Methods(_create_f_systemEnvironment_0 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QProcess");

}


//  Implementation of the enum wrapper class for QProcess::ExitStatus
namespace qt_gsi
{

static QProcess_ExitStatus_Enum *c_1_QProcess_ExitStatus_Enum () { return new QProcess_ExitStatus_Enum (QProcess::NormalExit); }
static QProcess_ExitStatus_Enum *c_2_QProcess_ExitStatus_Enum () { return new QProcess_ExitStatus_Enum (QProcess::CrashExit); }

static gsi::Methods mkdefs_QProcess_ExitStatus () {
  return
    gsi::constant ("NormalExit", &qt_gsi::c_1_QProcess_ExitStatus_Enum, "@brief Enum constant QProcess::NormalExit") +
    gsi::constant ("CrashExit", &qt_gsi::c_2_QProcess_ExitStatus_Enum, "@brief Enum constant QProcess::CrashExit");
}

static std::string to_s_QProcess_ExitStatus_Enum (const QProcess_ExitStatus_Enum *e)
{
  if (e->value () == QProcess::NormalExit) { return tl::sprintf ("NormalExit (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::CrashExit) { return tl::sprintf ("CrashExit (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QProcess_ExitStatus_Enum (const QProcess_ExitStatus_Enum *e)
{
  return (unsigned int) e->value ();
}

static QProcess_ExitStatus_Enum *from_i_QProcess_ExitStatus_Enum (unsigned int i)
{
  return new QProcess_ExitStatus_Enum ((QProcess::ExitStatus) i);
}

static bool equalQProcess_ExitStatus_Enum (const QProcess_ExitStatus_Enum *e, QProcess_ExitStatus_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QProcess_ExitStatus_Enum (const QProcess_ExitStatus_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QProcess_ExitStatus_Enums oropQProcess_ExitStatus_Enums (const QProcess_ExitStatus_Enums *e, const QProcess_ExitStatus_Enums &d)
{
  return e->flags () | d.flags ();
}

static QProcess_ExitStatus_Enums andopQProcess_ExitStatus_Enums (const QProcess_ExitStatus_Enums *e, const QProcess_ExitStatus_Enums &d)
{
  return e->flags () & d.flags ();
}

static QProcess_ExitStatus_Enums xoropQProcess_ExitStatus_Enums (const QProcess_ExitStatus_Enums *e, const QProcess_ExitStatus_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QProcess_ExitStatus_Enums (const QProcess_ExitStatus_Enums *e)
{
  std::string l;
  if (e->testFlag (QProcess::NormalExit)) { if (!l.empty ()) l += "|"; l += "NormalExit"; }
  if (e->testFlag (QProcess::CrashExit)) { if (!l.empty ()) l += "|"; l += "CrashExit"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QProcess_ExitStatus_Enums (const QProcess_ExitStatus_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QProcess_ExitStatus_Enums (const QProcess_ExitStatus_Enums *e, const QProcess_ExitStatus_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QProcess_ExitStatus_Enums> decl_QProcess_ExitStatus_Enums ("QProcess_QFlags_ExitStatus",
  gsi::method_ext ("|", &qt_gsi::oropQProcess_ExitStatus_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQProcess_ExitStatus_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQProcess_ExitStatus_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ExitStatus_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ExitStatus_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QProcess_ExitStatus_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QProcess::ExitStatus> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QProcess_ExitStatus_Enum> decl_QProcess_ExitStatus_Enum (decl_QProcess_ExitStatus_Enums, "QProcess_ExitStatus",
  qt_gsi::mkdefs_QProcess_ExitStatus () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ExitStatus_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ExitStatus_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQProcess_ExitStatus_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QProcess_ExitStatus_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QProcess_ExitStatus_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QProcess::ExitStatus enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ExitStatus_Enum_in_parent (qt_gsi::mkdefs_QProcess_ExitStatus ());
static gsi::ClassExt<QProcess> decl_QProcess_ExitStatus_Enum_as_child (decl_QProcess_ExitStatus_Enum, "ExitStatus");

}


//  Implementation of the enum wrapper class for QProcess::ProcessChannel
namespace qt_gsi
{

static QProcess_ProcessChannel_Enum *c_1_QProcess_ProcessChannel_Enum () { return new QProcess_ProcessChannel_Enum (QProcess::StandardOutput); }
static QProcess_ProcessChannel_Enum *c_2_QProcess_ProcessChannel_Enum () { return new QProcess_ProcessChannel_Enum (QProcess::StandardError); }

static gsi::Methods mkdefs_QProcess_ProcessChannel () {
  return
    gsi::constant ("StandardOutput", &qt_gsi::c_1_QProcess_ProcessChannel_Enum, "@brief Enum constant QProcess::StandardOutput") +
    gsi::constant ("StandardError", &qt_gsi::c_2_QProcess_ProcessChannel_Enum, "@brief Enum constant QProcess::StandardError");
}

static std::string to_s_QProcess_ProcessChannel_Enum (const QProcess_ProcessChannel_Enum *e)
{
  if (e->value () == QProcess::StandardOutput) { return tl::sprintf ("StandardOutput (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::StandardError) { return tl::sprintf ("StandardError (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QProcess_ProcessChannel_Enum (const QProcess_ProcessChannel_Enum *e)
{
  return (unsigned int) e->value ();
}

static QProcess_ProcessChannel_Enum *from_i_QProcess_ProcessChannel_Enum (unsigned int i)
{
  return new QProcess_ProcessChannel_Enum ((QProcess::ProcessChannel) i);
}

static bool equalQProcess_ProcessChannel_Enum (const QProcess_ProcessChannel_Enum *e, QProcess_ProcessChannel_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QProcess_ProcessChannel_Enum (const QProcess_ProcessChannel_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QProcess_ProcessChannel_Enums oropQProcess_ProcessChannel_Enums (const QProcess_ProcessChannel_Enums *e, const QProcess_ProcessChannel_Enums &d)
{
  return e->flags () | d.flags ();
}

static QProcess_ProcessChannel_Enums andopQProcess_ProcessChannel_Enums (const QProcess_ProcessChannel_Enums *e, const QProcess_ProcessChannel_Enums &d)
{
  return e->flags () & d.flags ();
}

static QProcess_ProcessChannel_Enums xoropQProcess_ProcessChannel_Enums (const QProcess_ProcessChannel_Enums *e, const QProcess_ProcessChannel_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QProcess_ProcessChannel_Enums (const QProcess_ProcessChannel_Enums *e)
{
  std::string l;
  if (e->testFlag (QProcess::StandardOutput)) { if (!l.empty ()) l += "|"; l += "StandardOutput"; }
  if (e->testFlag (QProcess::StandardError)) { if (!l.empty ()) l += "|"; l += "StandardError"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QProcess_ProcessChannel_Enums (const QProcess_ProcessChannel_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QProcess_ProcessChannel_Enums (const QProcess_ProcessChannel_Enums *e, const QProcess_ProcessChannel_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QProcess_ProcessChannel_Enums> decl_QProcess_ProcessChannel_Enums ("QProcess_QFlags_ProcessChannel",
  gsi::method_ext ("|", &qt_gsi::oropQProcess_ProcessChannel_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQProcess_ProcessChannel_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQProcess_ProcessChannel_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ProcessChannel_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ProcessChannel_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QProcess_ProcessChannel_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QProcess::ProcessChannel> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QProcess_ProcessChannel_Enum> decl_QProcess_ProcessChannel_Enum (decl_QProcess_ProcessChannel_Enums, "QProcess_ProcessChannel",
  qt_gsi::mkdefs_QProcess_ProcessChannel () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ProcessChannel_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ProcessChannel_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQProcess_ProcessChannel_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QProcess_ProcessChannel_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QProcess_ProcessChannel_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QProcess::ProcessChannel enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ProcessChannel_Enum_in_parent (qt_gsi::mkdefs_QProcess_ProcessChannel ());
static gsi::ClassExt<QProcess> decl_QProcess_ProcessChannel_Enum_as_child (decl_QProcess_ProcessChannel_Enum, "ProcessChannel");

}


//  Implementation of the enum wrapper class for QProcess::ProcessChannelMode
namespace qt_gsi
{

static QProcess_ProcessChannelMode_Enum *c_1_QProcess_ProcessChannelMode_Enum () { return new QProcess_ProcessChannelMode_Enum (QProcess::SeparateChannels); }
static QProcess_ProcessChannelMode_Enum *c_2_QProcess_ProcessChannelMode_Enum () { return new QProcess_ProcessChannelMode_Enum (QProcess::MergedChannels); }
static QProcess_ProcessChannelMode_Enum *c_3_QProcess_ProcessChannelMode_Enum () { return new QProcess_ProcessChannelMode_Enum (QProcess::ForwardedChannels); }

static gsi::Methods mkdefs_QProcess_ProcessChannelMode () {
  return
    gsi::constant ("SeparateChannels", &qt_gsi::c_1_QProcess_ProcessChannelMode_Enum, "@brief Enum constant QProcess::SeparateChannels") +
    gsi::constant ("MergedChannels", &qt_gsi::c_2_QProcess_ProcessChannelMode_Enum, "@brief Enum constant QProcess::MergedChannels") +
    gsi::constant ("ForwardedChannels", &qt_gsi::c_3_QProcess_ProcessChannelMode_Enum, "@brief Enum constant QProcess::ForwardedChannels");
}

static std::string to_s_QProcess_ProcessChannelMode_Enum (const QProcess_ProcessChannelMode_Enum *e)
{
  if (e->value () == QProcess::SeparateChannels) { return tl::sprintf ("SeparateChannels (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::MergedChannels) { return tl::sprintf ("MergedChannels (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::ForwardedChannels) { return tl::sprintf ("ForwardedChannels (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QProcess_ProcessChannelMode_Enum (const QProcess_ProcessChannelMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QProcess_ProcessChannelMode_Enum *from_i_QProcess_ProcessChannelMode_Enum (unsigned int i)
{
  return new QProcess_ProcessChannelMode_Enum ((QProcess::ProcessChannelMode) i);
}

static bool equalQProcess_ProcessChannelMode_Enum (const QProcess_ProcessChannelMode_Enum *e, QProcess_ProcessChannelMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QProcess_ProcessChannelMode_Enum (const QProcess_ProcessChannelMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QProcess_ProcessChannelMode_Enums oropQProcess_ProcessChannelMode_Enums (const QProcess_ProcessChannelMode_Enums *e, const QProcess_ProcessChannelMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QProcess_ProcessChannelMode_Enums andopQProcess_ProcessChannelMode_Enums (const QProcess_ProcessChannelMode_Enums *e, const QProcess_ProcessChannelMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QProcess_ProcessChannelMode_Enums xoropQProcess_ProcessChannelMode_Enums (const QProcess_ProcessChannelMode_Enums *e, const QProcess_ProcessChannelMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QProcess_ProcessChannelMode_Enums (const QProcess_ProcessChannelMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QProcess::SeparateChannels)) { if (!l.empty ()) l += "|"; l += "SeparateChannels"; }
  if (e->testFlag (QProcess::MergedChannels)) { if (!l.empty ()) l += "|"; l += "MergedChannels"; }
  if (e->testFlag (QProcess::ForwardedChannels)) { if (!l.empty ()) l += "|"; l += "ForwardedChannels"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QProcess_ProcessChannelMode_Enums (const QProcess_ProcessChannelMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QProcess_ProcessChannelMode_Enums (const QProcess_ProcessChannelMode_Enums *e, const QProcess_ProcessChannelMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QProcess_ProcessChannelMode_Enums> decl_QProcess_ProcessChannelMode_Enums ("QProcess_QFlags_ProcessChannelMode",
  gsi::method_ext ("|", &qt_gsi::oropQProcess_ProcessChannelMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQProcess_ProcessChannelMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQProcess_ProcessChannelMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ProcessChannelMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ProcessChannelMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QProcess_ProcessChannelMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QProcess::ProcessChannelMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QProcess_ProcessChannelMode_Enum> decl_QProcess_ProcessChannelMode_Enum (decl_QProcess_ProcessChannelMode_Enums, "QProcess_ProcessChannelMode",
  qt_gsi::mkdefs_QProcess_ProcessChannelMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ProcessChannelMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ProcessChannelMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQProcess_ProcessChannelMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QProcess_ProcessChannelMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QProcess_ProcessChannelMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QProcess::ProcessChannelMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ProcessChannelMode_Enum_in_parent (qt_gsi::mkdefs_QProcess_ProcessChannelMode ());
static gsi::ClassExt<QProcess> decl_QProcess_ProcessChannelMode_Enum_as_child (decl_QProcess_ProcessChannelMode_Enum, "ProcessChannelMode");

}


//  Implementation of the enum wrapper class for QProcess::ProcessError
namespace qt_gsi
{

static QProcess_ProcessError_Enum *c_1_QProcess_ProcessError_Enum () { return new QProcess_ProcessError_Enum (QProcess::FailedToStart); }
static QProcess_ProcessError_Enum *c_2_QProcess_ProcessError_Enum () { return new QProcess_ProcessError_Enum (QProcess::Crashed); }
static QProcess_ProcessError_Enum *c_3_QProcess_ProcessError_Enum () { return new QProcess_ProcessError_Enum (QProcess::Timedout); }
static QProcess_ProcessError_Enum *c_4_QProcess_ProcessError_Enum () { return new QProcess_ProcessError_Enum (QProcess::ReadError); }
static QProcess_ProcessError_Enum *c_5_QProcess_ProcessError_Enum () { return new QProcess_ProcessError_Enum (QProcess::WriteError); }
static QProcess_ProcessError_Enum *c_6_QProcess_ProcessError_Enum () { return new QProcess_ProcessError_Enum (QProcess::UnknownError); }

static gsi::Methods mkdefs_QProcess_ProcessError () {
  return
    gsi::constant ("FailedToStart", &qt_gsi::c_1_QProcess_ProcessError_Enum, "@brief Enum constant QProcess::FailedToStart") +
    gsi::constant ("Crashed", &qt_gsi::c_2_QProcess_ProcessError_Enum, "@brief Enum constant QProcess::Crashed") +
    gsi::constant ("Timedout", &qt_gsi::c_3_QProcess_ProcessError_Enum, "@brief Enum constant QProcess::Timedout") +
    gsi::constant ("ReadError", &qt_gsi::c_4_QProcess_ProcessError_Enum, "@brief Enum constant QProcess::ReadError") +
    gsi::constant ("WriteError", &qt_gsi::c_5_QProcess_ProcessError_Enum, "@brief Enum constant QProcess::WriteError") +
    gsi::constant ("UnknownError", &qt_gsi::c_6_QProcess_ProcessError_Enum, "@brief Enum constant QProcess::UnknownError");
}

static std::string to_s_QProcess_ProcessError_Enum (const QProcess_ProcessError_Enum *e)
{
  if (e->value () == QProcess::FailedToStart) { return tl::sprintf ("FailedToStart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::Crashed) { return tl::sprintf ("Crashed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::Timedout) { return tl::sprintf ("Timedout (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::ReadError) { return tl::sprintf ("ReadError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::WriteError) { return tl::sprintf ("WriteError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::UnknownError) { return tl::sprintf ("UnknownError (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QProcess_ProcessError_Enum (const QProcess_ProcessError_Enum *e)
{
  return (unsigned int) e->value ();
}

static QProcess_ProcessError_Enum *from_i_QProcess_ProcessError_Enum (unsigned int i)
{
  return new QProcess_ProcessError_Enum ((QProcess::ProcessError) i);
}

static bool equalQProcess_ProcessError_Enum (const QProcess_ProcessError_Enum *e, QProcess_ProcessError_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QProcess_ProcessError_Enum (const QProcess_ProcessError_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QProcess_ProcessError_Enums oropQProcess_ProcessError_Enums (const QProcess_ProcessError_Enums *e, const QProcess_ProcessError_Enums &d)
{
  return e->flags () | d.flags ();
}

static QProcess_ProcessError_Enums andopQProcess_ProcessError_Enums (const QProcess_ProcessError_Enums *e, const QProcess_ProcessError_Enums &d)
{
  return e->flags () & d.flags ();
}

static QProcess_ProcessError_Enums xoropQProcess_ProcessError_Enums (const QProcess_ProcessError_Enums *e, const QProcess_ProcessError_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QProcess_ProcessError_Enums (const QProcess_ProcessError_Enums *e)
{
  std::string l;
  if (e->testFlag (QProcess::FailedToStart)) { if (!l.empty ()) l += "|"; l += "FailedToStart"; }
  if (e->testFlag (QProcess::Crashed)) { if (!l.empty ()) l += "|"; l += "Crashed"; }
  if (e->testFlag (QProcess::Timedout)) { if (!l.empty ()) l += "|"; l += "Timedout"; }
  if (e->testFlag (QProcess::ReadError)) { if (!l.empty ()) l += "|"; l += "ReadError"; }
  if (e->testFlag (QProcess::WriteError)) { if (!l.empty ()) l += "|"; l += "WriteError"; }
  if (e->testFlag (QProcess::UnknownError)) { if (!l.empty ()) l += "|"; l += "UnknownError"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QProcess_ProcessError_Enums (const QProcess_ProcessError_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QProcess_ProcessError_Enums (const QProcess_ProcessError_Enums *e, const QProcess_ProcessError_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QProcess_ProcessError_Enums> decl_QProcess_ProcessError_Enums ("QProcess_QFlags_ProcessError",
  gsi::method_ext ("|", &qt_gsi::oropQProcess_ProcessError_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQProcess_ProcessError_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQProcess_ProcessError_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ProcessError_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ProcessError_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QProcess_ProcessError_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QProcess::ProcessError> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QProcess_ProcessError_Enum> decl_QProcess_ProcessError_Enum (decl_QProcess_ProcessError_Enums, "QProcess_ProcessError",
  qt_gsi::mkdefs_QProcess_ProcessError () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ProcessError_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ProcessError_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQProcess_ProcessError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QProcess_ProcessError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QProcess_ProcessError_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QProcess::ProcessError enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ProcessError_Enum_in_parent (qt_gsi::mkdefs_QProcess_ProcessError ());
static gsi::ClassExt<QProcess> decl_QProcess_ProcessError_Enum_as_child (decl_QProcess_ProcessError_Enum, "ProcessError");

}


//  Implementation of the enum wrapper class for QProcess::ProcessState
namespace qt_gsi
{

static QProcess_ProcessState_Enum *c_1_QProcess_ProcessState_Enum () { return new QProcess_ProcessState_Enum (QProcess::NotRunning); }
static QProcess_ProcessState_Enum *c_2_QProcess_ProcessState_Enum () { return new QProcess_ProcessState_Enum (QProcess::Starting); }
static QProcess_ProcessState_Enum *c_3_QProcess_ProcessState_Enum () { return new QProcess_ProcessState_Enum (QProcess::Running); }

static gsi::Methods mkdefs_QProcess_ProcessState () {
  return
    gsi::constant ("NotRunning", &qt_gsi::c_1_QProcess_ProcessState_Enum, "@brief Enum constant QProcess::NotRunning") +
    gsi::constant ("Starting", &qt_gsi::c_2_QProcess_ProcessState_Enum, "@brief Enum constant QProcess::Starting") +
    gsi::constant ("Running", &qt_gsi::c_3_QProcess_ProcessState_Enum, "@brief Enum constant QProcess::Running");
}

static std::string to_s_QProcess_ProcessState_Enum (const QProcess_ProcessState_Enum *e)
{
  if (e->value () == QProcess::NotRunning) { return tl::sprintf ("NotRunning (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::Starting) { return tl::sprintf ("Starting (%u)", (unsigned int) e->value ()); }
  if (e->value () == QProcess::Running) { return tl::sprintf ("Running (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QProcess_ProcessState_Enum (const QProcess_ProcessState_Enum *e)
{
  return (unsigned int) e->value ();
}

static QProcess_ProcessState_Enum *from_i_QProcess_ProcessState_Enum (unsigned int i)
{
  return new QProcess_ProcessState_Enum ((QProcess::ProcessState) i);
}

static bool equalQProcess_ProcessState_Enum (const QProcess_ProcessState_Enum *e, QProcess_ProcessState_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QProcess_ProcessState_Enum (const QProcess_ProcessState_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QProcess_ProcessState_Enums oropQProcess_ProcessState_Enums (const QProcess_ProcessState_Enums *e, const QProcess_ProcessState_Enums &d)
{
  return e->flags () | d.flags ();
}

static QProcess_ProcessState_Enums andopQProcess_ProcessState_Enums (const QProcess_ProcessState_Enums *e, const QProcess_ProcessState_Enums &d)
{
  return e->flags () & d.flags ();
}

static QProcess_ProcessState_Enums xoropQProcess_ProcessState_Enums (const QProcess_ProcessState_Enums *e, const QProcess_ProcessState_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QProcess_ProcessState_Enums (const QProcess_ProcessState_Enums *e)
{
  std::string l;
  if (e->testFlag (QProcess::NotRunning)) { if (!l.empty ()) l += "|"; l += "NotRunning"; }
  if (e->testFlag (QProcess::Starting)) { if (!l.empty ()) l += "|"; l += "Starting"; }
  if (e->testFlag (QProcess::Running)) { if (!l.empty ()) l += "|"; l += "Running"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QProcess_ProcessState_Enums (const QProcess_ProcessState_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QProcess_ProcessState_Enums (const QProcess_ProcessState_Enums *e, const QProcess_ProcessState_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QProcess_ProcessState_Enums> decl_QProcess_ProcessState_Enums ("QProcess_QFlags_ProcessState",
  gsi::method_ext ("|", &qt_gsi::oropQProcess_ProcessState_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQProcess_ProcessState_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQProcess_ProcessState_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ProcessState_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ProcessState_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QProcess_ProcessState_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QProcess::ProcessState> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QProcess_ProcessState_Enum> decl_QProcess_ProcessState_Enum (decl_QProcess_ProcessState_Enums, "QProcess_ProcessState",
  qt_gsi::mkdefs_QProcess_ProcessState () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QProcess_ProcessState_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QProcess_ProcessState_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQProcess_ProcessState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QProcess_ProcessState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QProcess_ProcessState_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QProcess::ProcessState enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ProcessState_Enum_in_parent (qt_gsi::mkdefs_QProcess_ProcessState ());
static gsi::ClassExt<QProcess> decl_QProcess_ProcessState_Enum_as_child (decl_QProcess_ProcessState_Enum, "ProcessState");

}

