
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPoint.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QtGui/QMatrix>
#include <QtGui/QMatrix4x4>
#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPoint_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPoint

//  Constructor QPoint::QPoint()


static void _init_ctor_QPoint_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPoint *> ();
}

static void _call_ctor_QPoint_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint *> (new QPoint ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPoint_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPoint::QPoint()\nThis method creates an object of class QPoint.", &_init_ctor_QPoint_0, &_call_ctor_QPoint_0);
}

//  Constructor QPoint::QPoint(int xpos, int ypos)


static void _init_ctor_QPoint_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("xpos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ypos");
  decl->add_arg<int > (argspec_1);
  decl->set_return_new<QPoint *> ();
}

static void _call_ctor_QPoint_1426 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QPoint *> (new QPoint (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPoint_1426 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPoint::QPoint(int xpos, int ypos)\nThis method creates an object of class QPoint.", &_init_ctor_QPoint_1426, &_call_ctor_QPoint_1426);
}

// bool QPoint::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPoint *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QPoint::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// int QPoint::manhattanLength()


static void _init_f_manhattanLength_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_manhattanLength_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPoint *)cls)->manhattanLength ());
}

static qt_gsi::GenericMethod *_create_f_manhattanLength_c0 ()
{
  return new qt_gsi::GenericMethod ("manhattanLength", "@brief Method int QPoint::manhattanLength()\n", true, &_init_f_manhattanLength_c0, &_call_f_manhattanLength_c0);
}

// QPoint &QPoint::operator*=(double c)


static void _init_f_operator_star__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QPoint & > ();
}

static void _call_f_operator_star__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QPoint & > ((QPoint &)((QPoint *)cls)->operator*= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("*=", "@brief Method QPoint &QPoint::operator*=(double c)\n", false, &_init_f_operator_star__eq__1071, &_call_f_operator_star__eq__1071);
}

// QPoint &QPoint::operator+=(const QPoint &p)


static void _init_f_operator_plus__eq__1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint & > ();
}

static void _call_f_operator_plus__eq__1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPoint & > ((QPoint &)((QPoint *)cls)->operator+= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_plus__eq__1916 ()
{
  return new qt_gsi::GenericMethod ("+=", "@brief Method QPoint &QPoint::operator+=(const QPoint &p)\n", false, &_init_f_operator_plus__eq__1916, &_call_f_operator_plus__eq__1916);
}

// QPoint &QPoint::operator-=(const QPoint &p)


static void _init_f_operator_minus__eq__1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint & > ();
}

static void _call_f_operator_minus__eq__1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPoint & > ((QPoint &)((QPoint *)cls)->operator-= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_minus__eq__1916 ()
{
  return new qt_gsi::GenericMethod ("-=", "@brief Method QPoint &QPoint::operator-=(const QPoint &p)\n", false, &_init_f_operator_minus__eq__1916, &_call_f_operator_minus__eq__1916);
}

// QPoint &QPoint::operator/=(double c)


static void _init_f_operator_slash__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QPoint & > ();
}

static void _call_f_operator_slash__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QPoint & > ((QPoint &)((QPoint *)cls)->operator/= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_slash__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("/=", "@brief Method QPoint &QPoint::operator/=(double c)\n", false, &_init_f_operator_slash__eq__1071, &_call_f_operator_slash__eq__1071);
}

// int &QPoint::rx()


static void _init_f_rx_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int & > ();
}

static void _call_f_rx_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int & > ((int &)((QPoint *)cls)->rx ());
}

static qt_gsi::GenericMethod *_create_f_rx_0 ()
{
  return new qt_gsi::GenericMethod ("rx", "@brief Method int &QPoint::rx()\n", false, &_init_f_rx_0, &_call_f_rx_0);
}

// int &QPoint::ry()


static void _init_f_ry_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int & > ();
}

static void _call_f_ry_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int & > ((int &)((QPoint *)cls)->ry ());
}

static qt_gsi::GenericMethod *_create_f_ry_0 ()
{
  return new qt_gsi::GenericMethod ("ry", "@brief Method int &QPoint::ry()\n", false, &_init_f_ry_0, &_call_f_ry_0);
}

// void QPoint::setX(int x)


static void _init_f_setX_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setX_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QPoint *)cls)->setX (arg1);
}

static qt_gsi::GenericMethod *_create_f_setX_767 ()
{
  return new qt_gsi::GenericMethod ("setX|x=", "@brief Method void QPoint::setX(int x)\n", false, &_init_f_setX_767, &_call_f_setX_767);
}

// void QPoint::setY(int y)


static void _init_f_setY_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setY_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QPoint *)cls)->setY (arg1);
}

static qt_gsi::GenericMethod *_create_f_setY_767 ()
{
  return new qt_gsi::GenericMethod ("setY|y=", "@brief Method void QPoint::setY(int y)\n", false, &_init_f_setY_767, &_call_f_setY_767);
}

// int QPoint::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPoint *)cls)->x ());
}

static qt_gsi::GenericMethod *_create_f_x_c0 ()
{
  return new qt_gsi::GenericMethod (":x", "@brief Method int QPoint::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
}

// int QPoint::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPoint *)cls)->y ());
}

static qt_gsi::GenericMethod *_create_f_y_c0 ()
{
  return new qt_gsi::GenericMethod (":y", "@brief Method int QPoint::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
}

//  bool ::operator==(const QPoint &p1, const QPoint &p2)
static bool op_QPoint_operator_eq__eq__3724(const QPoint *_self, const QPoint &p2) {
  return ::operator==(*_self, p2);
}

//  bool ::operator!=(const QPoint &p1, const QPoint &p2)
static bool op_QPoint_operator_excl__eq__3724(const QPoint *_self, const QPoint &p2) {
  return ::operator!=(*_self, p2);
}

//  const QPoint ::operator+(const QPoint &p1, const QPoint &p2)
static const QPoint op_QPoint_operator_plus__3724(const QPoint *_self, const QPoint &p2) {
  return ::operator+(*_self, p2);
}

//  const QPoint ::operator-(const QPoint &p1, const QPoint &p2)
static const QPoint op_QPoint_operator_minus__3724(const QPoint *_self, const QPoint &p2) {
  return ::operator-(*_self, p2);
}

//  const QPoint ::operator*(const QPoint &p, qreal c)
static const QPoint op_QPoint_operator_star__2777(const QPoint *_self, qreal c) {
  return ::operator*(*_self, c);
}

//  const QPoint ::operator-(const QPoint &p)
static const QPoint op_QPoint_operator_minus__1916(const QPoint *_self) {
  return ::operator-(*_self);
}

//  const QPoint ::operator/(const QPoint &p, qreal c)
static const QPoint op_QPoint_operator_slash__2777(const QPoint *_self, qreal c) {
  return ::operator/(*_self, c);
}

//  QPoint ::operator*(const QPoint &p, const QMatrix &m)
static QPoint op_QPoint_operator_star__3831(const QPoint *_self, const QMatrix &m) {
  return ::operator*(*_self, m);
}

//  QPoint ::operator*(const QPoint &p, const QTransform &m)
static QPoint op_QPoint_operator_star__4158(const QPoint *_self, const QTransform &m) {
  return ::operator*(*_self, m);
}

//  QPoint ::operator*(const QPoint &point, const QMatrix4x4 &matrix)
static QPoint op_QPoint_operator_star__4055u1(const QPoint *_self, const QMatrix4x4 &matrix) {
  return ::operator*(*_self, matrix);
}


namespace gsi
{
gsi::Class<QPoint> decl_QPoint ("QPoint",
  gsi::Methods(_create_ctor_QPoint_0 ()) +
  gsi::Methods(_create_ctor_QPoint_1426 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_manhattanLength_c0 ()) +
  gsi::Methods(_create_f_operator_star__eq__1071 ()) +
  gsi::Methods(_create_f_operator_plus__eq__1916 ()) +
  gsi::Methods(_create_f_operator_minus__eq__1916 ()) +
  gsi::Methods(_create_f_operator_slash__eq__1071 ()) +
  gsi::Methods(_create_f_rx_0 ()) +
  gsi::Methods(_create_f_ry_0 ()) +
  gsi::Methods(_create_f_setX_767 ()) +
  gsi::Methods(_create_f_setY_767 ()) +
  gsi::Methods(_create_f_x_c0 ()) +
  gsi::Methods(_create_f_y_c0 ()) +
  gsi::method_ext("==", &::op_QPoint_operator_eq__eq__3724, gsi::arg ("p2"), "@brief Operator bool ::operator==(const QPoint &p1, const QPoint &p2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("!=", &::op_QPoint_operator_excl__eq__3724, gsi::arg ("p2"), "@brief Operator bool ::operator!=(const QPoint &p1, const QPoint &p2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("+", &::op_QPoint_operator_plus__3724, gsi::arg ("p2"), "@brief Operator const QPoint ::operator+(const QPoint &p1, const QPoint &p2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("-", &::op_QPoint_operator_minus__3724, gsi::arg ("p2"), "@brief Operator const QPoint ::operator-(const QPoint &p1, const QPoint &p2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QPoint_operator_star__2777, gsi::arg ("c"), "@brief Operator const QPoint ::operator*(const QPoint &p, qreal c)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("-", &::op_QPoint_operator_minus__1916, "@brief Operator const QPoint ::operator-(const QPoint &p)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("/", &::op_QPoint_operator_slash__2777, gsi::arg ("c"), "@brief Operator const QPoint ::operator/(const QPoint &p, qreal c)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QPoint_operator_star__3831, gsi::arg ("m"), "@brief Operator QPoint ::operator*(const QPoint &p, const QMatrix &m)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QPoint_operator_star__4158, gsi::arg ("m"), "@brief Operator QPoint ::operator*(const QPoint &p, const QTransform &m)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QPoint_operator_star__4055u1, gsi::arg ("matrix"), "@brief Operator QPoint ::operator*(const QPoint &point, const QMatrix4x4 &matrix)\nThis is the mapping of the global operator to the instance method."),
  "@qt\n@brief Binding of QPoint");

}

