
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPlainTextDocumentLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPlainTextDocumentLayout_EventAdaptor.h"
#include "gsiDeclQPlainTextDocumentLayout_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPlainTextDocumentLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPlainTextDocumentLayout::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)


static void _init_f_blockBoundingRect_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_blockBoundingRect_c2306 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ret.write<QRectF > ((QRectF)((QPlainTextDocumentLayout *)cls)->blockBoundingRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_blockBoundingRect_c2306 ()
{
  return new qt_gsi::GenericMethod ("blockBoundingRect", "@brief Method QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)\nThis is a reimplementation of QAbstractTextDocumentLayout::blockBoundingRect", true, &_init_f_blockBoundingRect_c2306, &_call_f_blockBoundingRect_c2306);
}

// int QPlainTextDocumentLayout::cursorWidth()


static void _init_f_cursorWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cursorWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPlainTextDocumentLayout *)cls)->cursorWidth ());
}

static qt_gsi::GenericMethod *_create_f_cursorWidth_c0 ()
{
  return new qt_gsi::GenericMethod (":cursorWidth", "@brief Method int QPlainTextDocumentLayout::cursorWidth()\n", true, &_init_f_cursorWidth_c0, &_call_f_cursorWidth_c0);
}

// QSizeF QPlainTextDocumentLayout::documentSize()


static void _init_f_documentSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_documentSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizeF > ((QSizeF)((QPlainTextDocumentLayout *)cls)->documentSize ());
}

static qt_gsi::GenericMethod *_create_f_documentSize_c0 ()
{
  return new qt_gsi::GenericMethod ("documentSize", "@brief Method QSizeF QPlainTextDocumentLayout::documentSize()\nThis is a reimplementation of QAbstractTextDocumentLayout::documentSize", true, &_init_f_documentSize_c0, &_call_f_documentSize_c0);
}

// void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)


static void _init_f_draw_6787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QAbstractTextDocumentLayout::PaintContext & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_draw_6787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QAbstractTextDocumentLayout::PaintContext &arg2 = args.read<const QAbstractTextDocumentLayout::PaintContext & > ();
  ((QPlainTextDocumentLayout *)cls)->draw (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_draw_6787 ()
{
  return new qt_gsi::GenericMethod ("draw", "@brief Method void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)\nThis is a reimplementation of QAbstractTextDocumentLayout::draw", false, &_init_f_draw_6787, &_call_f_draw_6787);
}

// void QPlainTextDocumentLayout::ensureBlockLayout(const QTextBlock &block)


static void _init_f_ensureBlockLayout_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ensureBlockLayout_c2306 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ((QPlainTextDocumentLayout *)cls)->ensureBlockLayout (arg1);
}

static qt_gsi::GenericMethod *_create_f_ensureBlockLayout_c2306 ()
{
  return new qt_gsi::GenericMethod ("ensureBlockLayout", "@brief Method void QPlainTextDocumentLayout::ensureBlockLayout(const QTextBlock &block)\n", true, &_init_f_ensureBlockLayout_c2306, &_call_f_ensureBlockLayout_c2306);
}

// QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)


static void _init_f_frameBoundingRect_c1615 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_frameBoundingRect_c1615 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextFrame *arg1 = args.read<QTextFrame * > ();
  ret.write<QRectF > ((QRectF)((QPlainTextDocumentLayout *)cls)->frameBoundingRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_frameBoundingRect_c1615 ()
{
  return new qt_gsi::GenericMethod ("frameBoundingRect", "@brief Method QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)\nThis is a reimplementation of QAbstractTextDocumentLayout::frameBoundingRect", true, &_init_f_frameBoundingRect_c1615, &_call_f_frameBoundingRect_c1615);
}

// int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)


static void _init_f_hitTest_c4147 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_hitTest_c4147 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > ();
  ret.write<int > ((int)((QPlainTextDocumentLayout *)cls)->hitTest (arg1, qt_gsi::QtToCppAdaptor<Qt::HitTestAccuracy>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_hitTest_c4147 ()
{
  return new qt_gsi::GenericMethod ("hitTest", "@brief Method int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)\nThis is a reimplementation of QAbstractTextDocumentLayout::hitTest", true, &_init_f_hitTest_c4147, &_call_f_hitTest_c4147);
}

// int QPlainTextDocumentLayout::pageCount()


static void _init_f_pageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pageCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPlainTextDocumentLayout *)cls)->pageCount ());
}

static qt_gsi::GenericMethod *_create_f_pageCount_c0 ()
{
  return new qt_gsi::GenericMethod ("pageCount", "@brief Method int QPlainTextDocumentLayout::pageCount()\nThis is a reimplementation of QAbstractTextDocumentLayout::pageCount", true, &_init_f_pageCount_c0, &_call_f_pageCount_c0);
}

// void QPlainTextDocumentLayout::requestUpdate()


static void _init_f_requestUpdate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_requestUpdate_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPlainTextDocumentLayout *)cls)->requestUpdate ();
}

static qt_gsi::GenericMethod *_create_f_requestUpdate_0 ()
{
  return new qt_gsi::GenericMethod ("requestUpdate", "@brief Method void QPlainTextDocumentLayout::requestUpdate()\n", false, &_init_f_requestUpdate_0, &_call_f_requestUpdate_0);
}

// void QPlainTextDocumentLayout::setCursorWidth(int width)


static void _init_f_setCursorWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursorWidth_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QPlainTextDocumentLayout *)cls)->setCursorWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCursorWidth_767 ()
{
  return new qt_gsi::GenericMethod ("setCursorWidth|cursorWidth=", "@brief Method void QPlainTextDocumentLayout::setCursorWidth(int width)\n", false, &_init_f_setCursorWidth_767, &_call_f_setCursorWidth_767);
}

// static QString QPlainTextDocumentLayout::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QPlainTextDocumentLayout::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPlainTextDocumentLayout::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QPlainTextDocumentLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QPlainTextDocumentLayout::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPlainTextDocumentLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QPlainTextDocumentLayout::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QPlainTextDocumentLayout::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPlainTextDocumentLayout::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QPlainTextDocumentLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QPlainTextDocumentLayout::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPlainTextDocumentLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QPlainTextDocumentLayout, QPlainTextDocumentLayout_EventAdaptor> ea_QPlainTextDocumentLayout;

namespace gsi
{
extern gsi::Class<QAbstractTextDocumentLayout> decl_QAbstractTextDocumentLayout;

gsi::Class<QPlainTextDocumentLayout> decl_QPlainTextDocumentLayout (ea_QPlainTextDocumentLayout, decl_QAbstractTextDocumentLayout, "QPlainTextDocumentLayout_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_blockBoundingRect_c2306 ()) +
  gsi::Methods(_create_f_cursorWidth_c0 ()) +
  gsi::Methods(_create_f_documentSize_c0 ()) +
  gsi::Methods(_create_f_draw_6787 ()) +
  gsi::Methods(_create_f_ensureBlockLayout_c2306 ()) +
  gsi::Methods(_create_f_frameBoundingRect_c1615 ()) +
  gsi::Methods(_create_f_hitTest_c4147 ()) +
  gsi::Methods(_create_f_pageCount_c0 ()) +
  gsi::Methods(_create_f_requestUpdate_0 ()) +
  gsi::Methods(_create_f_setCursorWidth_767 ()) +
  qt_gsi::qt_signal<QPlainTextDocumentLayout, QPlainTextDocumentLayout_EventAdaptor, QObject *> ("destroyed", &QPlainTextDocumentLayout_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QPlainTextDocumentLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPlainTextDocumentLayout, QPlainTextDocumentLayout_EventAdaptor, const QSizeF &> ("documentSizeChanged", &QPlainTextDocumentLayout_EventAdaptor::documentSizeChanged_e_1875, gsi::arg("newSize"), "@brief Signal declaration for QPlainTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPlainTextDocumentLayout, QPlainTextDocumentLayout_EventAdaptor, int> ("pageCountChanged", &QPlainTextDocumentLayout_EventAdaptor::pageCountChanged_e_767, gsi::arg("newPages"), "@brief Signal declaration for QPlainTextDocumentLayout::pageCountChanged(int newPages)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPlainTextDocumentLayout, QPlainTextDocumentLayout_EventAdaptor, const QRectF &> ("update", &QPlainTextDocumentLayout_EventAdaptor::update_e_1862, gsi::arg("arg1"), "@brief Signal declaration for QPlainTextDocumentLayout::update(const QRectF &)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPlainTextDocumentLayout, QPlainTextDocumentLayout_EventAdaptor, const QTextBlock &> ("updateBlock", &QPlainTextDocumentLayout_EventAdaptor::updateBlock_e_2306, gsi::arg("block"), "@brief Signal declaration for QPlainTextDocumentLayout::updateBlock(const QTextBlock &block)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QPlainTextDocumentLayout");
}


class QPlainTextDocumentLayout_Adaptor : public QPlainTextDocumentLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPlainTextDocumentLayout_Adaptor();

  //  [adaptor ctor] QPlainTextDocumentLayout::QPlainTextDocumentLayout(QTextDocument *document)
  QPlainTextDocumentLayout_Adaptor(QTextDocument *document) : QPlainTextDocumentLayout(document)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  QTextCharFormat QPlainTextDocumentLayout::format(int pos)
  QTextCharFormat fp_QPlainTextDocumentLayout_format_767 (int pos) {
    return QPlainTextDocumentLayout::format(pos);
  }

  //  int QPlainTextDocumentLayout::formatIndex(int pos)
  int fp_QPlainTextDocumentLayout_formatIndex_767 (int pos) {
    return QPlainTextDocumentLayout::formatIndex(pos);
  }

  //  int QPlainTextDocumentLayout::receivers(const char *signal)
  int fp_QPlainTextDocumentLayout_receivers_c1731 (const char *signal) const {
    return QPlainTextDocumentLayout::receivers(signal);
  }

  //  QObject *QPlainTextDocumentLayout::sender()
  QObject * fp_QPlainTextDocumentLayout_sender_c0 () const {
    return QPlainTextDocumentLayout::sender();
  }

  //  [adaptor impl] QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)
  QRectF cbs_blockBoundingRect_c2306_0(const QTextBlock &block) const
  {
    return QPlainTextDocumentLayout::blockBoundingRect(block);
  }

  virtual QRectF blockBoundingRect(const QTextBlock &block) const
  {
    if (cb_blockBoundingRect_c2306_0.can_issue()) {
      return cb_blockBoundingRect_c2306_0.issue<QPlainTextDocumentLayout_Adaptor, QRectF, const QTextBlock &>(&QPlainTextDocumentLayout_Adaptor::cbs_blockBoundingRect_c2306_0, block);
    } else {
      return QPlainTextDocumentLayout::blockBoundingRect(block);
    }
  }

  //  [adaptor impl] QSizeF QPlainTextDocumentLayout::documentSize()
  QSizeF cbs_documentSize_c0_0() const
  {
    return QPlainTextDocumentLayout::documentSize();
  }

  virtual QSizeF documentSize() const
  {
    if (cb_documentSize_c0_0.can_issue()) {
      return cb_documentSize_c0_0.issue<QPlainTextDocumentLayout_Adaptor, QSizeF>(&QPlainTextDocumentLayout_Adaptor::cbs_documentSize_c0_0);
    } else {
      return QPlainTextDocumentLayout::documentSize();
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)
  void cbs_draw_6787_0(QPainter *arg1, const QAbstractTextDocumentLayout::PaintContext &arg2)
  {
    QPlainTextDocumentLayout::draw(arg1, arg2);
  }

  virtual void draw(QPainter *arg1, const QAbstractTextDocumentLayout::PaintContext &arg2)
  {
    if (cb_draw_6787_0.can_issue()) {
      cb_draw_6787_0.issue<QPlainTextDocumentLayout_Adaptor, QPainter *, const QAbstractTextDocumentLayout::PaintContext &>(&QPlainTextDocumentLayout_Adaptor::cbs_draw_6787_0, arg1, arg2);
    } else {
      QPlainTextDocumentLayout::draw(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QPlainTextDocumentLayout::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QPlainTextDocumentLayout::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPlainTextDocumentLayout_Adaptor, bool, QEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QPlainTextDocumentLayout::event(arg1);
    }
  }

  //  [adaptor impl] bool QPlainTextDocumentLayout::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QPlainTextDocumentLayout::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPlainTextDocumentLayout_Adaptor, bool, QObject *, QEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QPlainTextDocumentLayout::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)
  QRectF cbs_frameBoundingRect_c1615_0(QTextFrame *arg1) const
  {
    return QPlainTextDocumentLayout::frameBoundingRect(arg1);
  }

  virtual QRectF frameBoundingRect(QTextFrame *arg1) const
  {
    if (cb_frameBoundingRect_c1615_0.can_issue()) {
      return cb_frameBoundingRect_c1615_0.issue<QPlainTextDocumentLayout_Adaptor, QRectF, QTextFrame *>(&QPlainTextDocumentLayout_Adaptor::cbs_frameBoundingRect_c1615_0, arg1);
    } else {
      return QPlainTextDocumentLayout::frameBoundingRect(arg1);
    }
  }

  //  [adaptor impl] int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)
  int cbs_hitTest_c4147_0(const QPointF &arg1, const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2) const
  {
    return QPlainTextDocumentLayout::hitTest(arg1, qt_gsi::QtToCppAdaptor<Qt::HitTestAccuracy>(arg2).cref());
  }

  virtual int hitTest(const QPointF &arg1, Qt::HitTestAccuracy arg2) const
  {
    if (cb_hitTest_c4147_0.can_issue()) {
      return cb_hitTest_c4147_0.issue<QPlainTextDocumentLayout_Adaptor, int, const QPointF &, const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type &>(&QPlainTextDocumentLayout_Adaptor::cbs_hitTest_c4147_0, arg1, qt_gsi::CppToQtAdaptor<Qt::HitTestAccuracy>(arg2));
    } else {
      return QPlainTextDocumentLayout::hitTest(arg1, arg2);
    }
  }

  //  [adaptor impl] int QPlainTextDocumentLayout::pageCount()
  int cbs_pageCount_c0_0() const
  {
    return QPlainTextDocumentLayout::pageCount();
  }

  virtual int pageCount() const
  {
    if (cb_pageCount_c0_0.can_issue()) {
      return cb_pageCount_c0_0.issue<QPlainTextDocumentLayout_Adaptor, int>(&QPlainTextDocumentLayout_Adaptor::cbs_pageCount_c0_0);
    } else {
      return QPlainTextDocumentLayout::pageCount();
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QPlainTextDocumentLayout::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPlainTextDocumentLayout_Adaptor, QChildEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QPlainTextDocumentLayout::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QPlainTextDocumentLayout::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPlainTextDocumentLayout_Adaptor, QEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QPlainTextDocumentLayout::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QPlainTextDocumentLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QPlainTextDocumentLayout_Adaptor, const char *>(&QPlainTextDocumentLayout_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QPlainTextDocumentLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::documentChanged(int from, int, int charsAdded)
  void cbs_documentChanged_2085_0(int from, int arg2, int charsAdded)
  {
    QPlainTextDocumentLayout::documentChanged(from, arg2, charsAdded);
  }

  virtual void documentChanged(int from, int arg2, int charsAdded)
  {
    if (cb_documentChanged_2085_0.can_issue()) {
      cb_documentChanged_2085_0.issue<QPlainTextDocumentLayout_Adaptor, int, int, int>(&QPlainTextDocumentLayout_Adaptor::cbs_documentChanged_2085_0, from, arg2, charsAdded);
    } else {
      QPlainTextDocumentLayout::documentChanged(from, arg2, charsAdded);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  void cbs_drawInlineObject_8199_0(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  {
    QPlainTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
  }

  virtual void drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  {
    if (cb_drawInlineObject_8199_0.can_issue()) {
      cb_drawInlineObject_8199_0.issue<QPlainTextDocumentLayout_Adaptor, QPainter *, const QRectF &, QTextInlineObject, int, const QTextFormat &>(&QPlainTextDocumentLayout_Adaptor::cbs_drawInlineObject_8199_0, painter, rect, object, posInDocument, format);
    } else {
      QPlainTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  void cbs_positionInlineObject_5127_0(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    QPlainTextDocumentLayout::positionInlineObject(item, posInDocument, format);
  }

  virtual void positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    if (cb_positionInlineObject_5127_0.can_issue()) {
      cb_positionInlineObject_5127_0.issue<QPlainTextDocumentLayout_Adaptor, QTextInlineObject, int, const QTextFormat &>(&QPlainTextDocumentLayout_Adaptor::cbs_positionInlineObject_5127_0, item, posInDocument, format);
    } else {
      QPlainTextDocumentLayout::positionInlineObject(item, posInDocument, format);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  void cbs_resizeInlineObject_5127_0(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    QPlainTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
  }

  virtual void resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    if (cb_resizeInlineObject_5127_0.can_issue()) {
      cb_resizeInlineObject_5127_0.issue<QPlainTextDocumentLayout_Adaptor, QTextInlineObject, int, const QTextFormat &>(&QPlainTextDocumentLayout_Adaptor::cbs_resizeInlineObject_5127_0, item, posInDocument, format);
    } else {
      QPlainTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
    }
  }

  //  [adaptor impl] void QPlainTextDocumentLayout::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QPlainTextDocumentLayout::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPlainTextDocumentLayout_Adaptor, QTimerEvent *>(&QPlainTextDocumentLayout_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QPlainTextDocumentLayout::timerEvent(arg1);
    }
  }

  gsi::Callback cb_blockBoundingRect_c2306_0;
  gsi::Callback cb_documentSize_c0_0;
  gsi::Callback cb_draw_6787_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_frameBoundingRect_c1615_0;
  gsi::Callback cb_hitTest_c4147_0;
  gsi::Callback cb_pageCount_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_documentChanged_2085_0;
  gsi::Callback cb_drawInlineObject_8199_0;
  gsi::Callback cb_positionInlineObject_5127_0;
  gsi::Callback cb_resizeInlineObject_5127_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QPlainTextDocumentLayout_Adaptor::~QPlainTextDocumentLayout_Adaptor() { }

//  Constructor QPlainTextDocumentLayout::QPlainTextDocumentLayout(QTextDocument *document) (adaptor class)

static void _init_ctor_QPlainTextDocumentLayout_Adaptor_1955 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("document");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return_new<QPlainTextDocumentLayout_Adaptor *> ();
}

static void _call_ctor_QPlainTextDocumentLayout_Adaptor_1955 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextDocument *arg1 = args.read<QTextDocument * > ();
  ret.write<QPlainTextDocumentLayout_Adaptor *> (new QPlainTextDocumentLayout_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPlainTextDocumentLayout_Adaptor_1955 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPlainTextDocumentLayout::QPlainTextDocumentLayout(QTextDocument *document)\nThis method creates an object of class QPlainTextDocumentLayout.", &_init_ctor_QPlainTextDocumentLayout_Adaptor_1955, &_call_ctor_QPlainTextDocumentLayout_Adaptor_1955);
}

// QTextCharFormat QPlainTextDocumentLayout::format(int pos)

static void _init_fp_format_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextCharFormat > ();
}

static void _call_fp_format_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextCharFormat > ((QTextCharFormat)((QPlainTextDocumentLayout_Adaptor *)cls)->fp_QPlainTextDocumentLayout_format_767 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_format_767 ()
{
  return new qt_gsi::GenericMethod("*format", "@brief Method QTextCharFormat QPlainTextDocumentLayout::format(int pos)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_format_767, &_call_fp_format_767);
}


// int QPlainTextDocumentLayout::formatIndex(int pos)

static void _init_fp_formatIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_formatIndex_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QPlainTextDocumentLayout_Adaptor *)cls)->fp_QPlainTextDocumentLayout_formatIndex_767 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_formatIndex_767 ()
{
  return new qt_gsi::GenericMethod("*formatIndex", "@brief Method int QPlainTextDocumentLayout::formatIndex(int pos)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_formatIndex_767, &_call_fp_formatIndex_767);
}


// int QPlainTextDocumentLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QPlainTextDocumentLayout_Adaptor *)cls)->fp_QPlainTextDocumentLayout_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QPlainTextDocumentLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QPlainTextDocumentLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QPlainTextDocumentLayout_Adaptor *)cls)->fp_QPlainTextDocumentLayout_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QPlainTextDocumentLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)

static void _init_cbs_blockBoundingRect_c2306_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_blockBoundingRect_c2306_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ret.write<QRectF > ((QRectF)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_blockBoundingRect_c2306_0 (arg1));
}

static void _set_callback_cbs_blockBoundingRect_c2306_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_blockBoundingRect_c2306_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_blockBoundingRect_c2306_0 ()
{
  return new qt_gsi::GenericMethod ("blockBoundingRect", "@hide", true, &_init_cbs_blockBoundingRect_c2306_0, &_call_cbs_blockBoundingRect_c2306_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_blockBoundingRect_c2306_0 ()
{
  return new qt_gsi::GenericMethod ("blockBoundingRect", "@brief Virtual method QRectF QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock &block)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_blockBoundingRect_c2306_0, &_call_cbs_blockBoundingRect_c2306_0, &_set_callback_cbs_blockBoundingRect_c2306_0);
}


// QSizeF QPlainTextDocumentLayout::documentSize()

static void _init_cbs_documentSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_cbs_documentSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizeF > ((QSizeF)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_documentSize_c0_0 ());
}

static void _set_callback_cbs_documentSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_documentSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_documentSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("documentSize", "@hide", true, &_init_cbs_documentSize_c0_0, &_call_cbs_documentSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_documentSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("documentSize", "@brief Virtual method QSizeF QPlainTextDocumentLayout::documentSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_documentSize_c0_0, &_call_cbs_documentSize_c0_0, &_set_callback_cbs_documentSize_c0_0);
}


// void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)

static void _init_cbs_draw_6787_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QAbstractTextDocumentLayout::PaintContext & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_draw_6787_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QAbstractTextDocumentLayout::PaintContext &arg2 = args.read<const QAbstractTextDocumentLayout::PaintContext & > ();
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_draw_6787_0 (arg1, arg2);
}

static void _set_callback_cbs_draw_6787_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_draw_6787_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_draw_6787_0 ()
{
  return new qt_gsi::GenericMethod ("draw", "@hide", false, &_init_cbs_draw_6787_0, &_call_cbs_draw_6787_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_draw_6787_0 ()
{
  return new qt_gsi::GenericMethod ("draw", "@brief Virtual method void QPlainTextDocumentLayout::draw(QPainter *, const QAbstractTextDocumentLayout::PaintContext &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_6787_0, &_call_cbs_draw_6787_0, &_set_callback_cbs_draw_6787_0);
}


// bool QPlainTextDocumentLayout::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QPlainTextDocumentLayout::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QPlainTextDocumentLayout::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPlainTextDocumentLayout::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)

static void _init_cbs_frameBoundingRect_c1615_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_frameBoundingRect_c1615_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextFrame *arg1 = args.read<QTextFrame * > ();
  ret.write<QRectF > ((QRectF)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_frameBoundingRect_c1615_0 (arg1));
}

static void _set_callback_cbs_frameBoundingRect_c1615_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_frameBoundingRect_c1615_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_frameBoundingRect_c1615_0 ()
{
  return new qt_gsi::GenericMethod ("frameBoundingRect", "@hide", true, &_init_cbs_frameBoundingRect_c1615_0, &_call_cbs_frameBoundingRect_c1615_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_frameBoundingRect_c1615_0 ()
{
  return new qt_gsi::GenericMethod ("frameBoundingRect", "@brief Virtual method QRectF QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_frameBoundingRect_c1615_0, &_call_cbs_frameBoundingRect_c1615_0, &_set_callback_cbs_frameBoundingRect_c1615_0);
}


// int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)

static void _init_cbs_hitTest_c4147_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_cbs_hitTest_c4147_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > ();
  ret.write<int > ((int)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_hitTest_c4147_0 (arg1, arg2));
}

static void _set_callback_cbs_hitTest_c4147_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_hitTest_c4147_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hitTest_c4147_0 ()
{
  return new qt_gsi::GenericMethod ("hitTest", "@hide", true, &_init_cbs_hitTest_c4147_0, &_call_cbs_hitTest_c4147_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hitTest_c4147_0 ()
{
  return new qt_gsi::GenericMethod ("hitTest", "@brief Virtual method int QPlainTextDocumentLayout::hitTest(const QPointF &, Qt::HitTestAccuracy)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitTest_c4147_0, &_call_cbs_hitTest_c4147_0, &_set_callback_cbs_hitTest_c4147_0);
}


// int QPlainTextDocumentLayout::pageCount()

static void _init_cbs_pageCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_pageCount_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_pageCount_c0_0 ());
}

static void _set_callback_cbs_pageCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_pageCount_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_pageCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("pageCount", "@hide", true, &_init_cbs_pageCount_c0_0, &_call_cbs_pageCount_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_pageCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("pageCount", "@brief Virtual method int QPlainTextDocumentLayout::pageCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pageCount_c0_0, &_call_cbs_pageCount_c0_0, &_set_callback_cbs_pageCount_c0_0);
}


// void QPlainTextDocumentLayout::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPlainTextDocumentLayout::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QPlainTextDocumentLayout::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPlainTextDocumentLayout::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QPlainTextDocumentLayout::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPlainTextDocumentLayout::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QPlainTextDocumentLayout::documentChanged(int from, int, int charsAdded)

static void _init_cbs_documentChanged_2085_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("charsAdded");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_documentChanged_2085_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_documentChanged_2085_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_documentChanged_2085_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_documentChanged_2085_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_documentChanged_2085_0 ()
{
  return new qt_gsi::GenericMethod ("*documentChanged", "@hide", false, &_init_cbs_documentChanged_2085_0, &_call_cbs_documentChanged_2085_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_documentChanged_2085_0 ()
{
  return new qt_gsi::GenericMethod ("*documentChanged", "@brief Virtual method void QPlainTextDocumentLayout::documentChanged(int from, int, int charsAdded)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_documentChanged_2085_0, &_call_cbs_documentChanged_2085_0, &_set_callback_cbs_documentChanged_2085_0);
}


// void QPlainTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)

static void _init_cbs_drawInlineObject_8199_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("object");
  decl->add_arg<QTextInlineObject > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("posInDocument");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("format");
  decl->add_arg<const QTextFormat & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_cbs_drawInlineObject_8199_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  QTextInlineObject arg3 = args.read<QTextInlineObject > ();
  int arg4 = args.read<int > ();
  const QTextFormat &arg5 = args.read<const QTextFormat & > ();
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_drawInlineObject_8199_0 (arg1, arg2, arg3, arg4, arg5);
}

static void _set_callback_cbs_drawInlineObject_8199_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_drawInlineObject_8199_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawInlineObject_8199_0 ()
{
  return new qt_gsi::GenericMethod ("*drawInlineObject", "@hide", false, &_init_cbs_drawInlineObject_8199_0, &_call_cbs_drawInlineObject_8199_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawInlineObject_8199_0 ()
{
  return new qt_gsi::GenericMethod ("*drawInlineObject", "@brief Virtual method void QPlainTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawInlineObject_8199_0, &_call_cbs_drawInlineObject_8199_0, &_set_callback_cbs_drawInlineObject_8199_0);
}


// void QPlainTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)

static void _init_cbs_positionInlineObject_5127_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTextInlineObject > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posInDocument");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextFormat & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_positionInlineObject_5127_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextInlineObject arg1 = args.read<QTextInlineObject > ();
  int arg2 = args.read<int > ();
  const QTextFormat &arg3 = args.read<const QTextFormat & > ();
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_positionInlineObject_5127_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_positionInlineObject_5127_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_positionInlineObject_5127_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_positionInlineObject_5127_0 ()
{
  return new qt_gsi::GenericMethod ("*positionInlineObject", "@hide", false, &_init_cbs_positionInlineObject_5127_0, &_call_cbs_positionInlineObject_5127_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_positionInlineObject_5127_0 ()
{
  return new qt_gsi::GenericMethod ("*positionInlineObject", "@brief Virtual method void QPlainTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_positionInlineObject_5127_0, &_call_cbs_positionInlineObject_5127_0, &_set_callback_cbs_positionInlineObject_5127_0);
}


// void QPlainTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)

static void _init_cbs_resizeInlineObject_5127_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTextInlineObject > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posInDocument");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextFormat & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_resizeInlineObject_5127_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextInlineObject arg1 = args.read<QTextInlineObject > ();
  int arg2 = args.read<int > ();
  const QTextFormat &arg3 = args.read<const QTextFormat & > ();
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_resizeInlineObject_5127_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_resizeInlineObject_5127_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_resizeInlineObject_5127_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeInlineObject_5127_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeInlineObject", "@hide", false, &_init_cbs_resizeInlineObject_5127_0, &_call_cbs_resizeInlineObject_5127_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeInlineObject_5127_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeInlineObject", "@brief Virtual method void QPlainTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeInlineObject_5127_0, &_call_cbs_resizeInlineObject_5127_0, &_set_callback_cbs_resizeInlineObject_5127_0);
}


// void QPlainTextDocumentLayout::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPlainTextDocumentLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPlainTextDocumentLayout::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QPlainTextDocumentLayout> decl_QPlainTextDocumentLayout;

gsi::Class<QPlainTextDocumentLayout_Adaptor> decl_QPlainTextDocumentLayout_Adaptor (decl_QPlainTextDocumentLayout, "QPlainTextDocumentLayout",
  gsi::Methods(_create_fp_format_767 ()) +
  gsi::Methods(_create_fp_formatIndex_767 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_blockBoundingRect_c2306_0 ()) +
  gsi::Methods(_create_callback_cbs_blockBoundingRect_c2306_0 ()) +
  gsi::Methods(_create_cbs_documentSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_documentSize_c0_0 ()) +
  gsi::Methods(_create_cbs_draw_6787_0 ()) +
  gsi::Methods(_create_callback_cbs_draw_6787_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_frameBoundingRect_c1615_0 ()) +
  gsi::Methods(_create_callback_cbs_frameBoundingRect_c1615_0 ()) +
  gsi::Methods(_create_cbs_hitTest_c4147_0 ()) +
  gsi::Methods(_create_callback_cbs_hitTest_c4147_0 ()) +
  gsi::Methods(_create_cbs_pageCount_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_pageCount_c0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_documentChanged_2085_0 ()) +
  gsi::Methods(_create_callback_cbs_documentChanged_2085_0 ()) +
  gsi::Methods(_create_cbs_drawInlineObject_8199_0 ()) +
  gsi::Methods(_create_callback_cbs_drawInlineObject_8199_0 ()) +
  gsi::Methods(_create_cbs_positionInlineObject_5127_0 ()) +
  gsi::Methods(_create_callback_cbs_positionInlineObject_5127_0 ()) +
  gsi::Methods(_create_cbs_resizeInlineObject_5127_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeInlineObject_5127_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QPlainTextDocumentLayout_Adaptor_1955 ()),
  "@qt\n@brief Binding of QPlainTextDocumentLayout");

}

