
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPixmap.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPixmap_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPixmap

// QPixmap QPixmap::alphaChannel()


static void _init_f_alphaChannel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPixmap > ();
}

static void _call_f_alphaChannel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->alphaChannel ());
}

static qt_gsi::GenericMethod *_create_f_alphaChannel_c0 ()
{
  return new qt_gsi::GenericMethod (":alphaChannel", "@brief Method QPixmap QPixmap::alphaChannel()\n", true, &_init_f_alphaChannel_c0, &_call_f_alphaChannel_c0);
}

// qint64 QPixmap::cacheKey()


static void _init_f_cacheKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_cacheKey_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QPixmap *)cls)->cacheKey ());
}

static qt_gsi::GenericMethod *_create_f_cacheKey_c0 ()
{
  return new qt_gsi::GenericMethod ("cacheKey", "@brief Method qint64 QPixmap::cacheKey()\n", true, &_init_f_cacheKey_c0, &_call_f_cacheKey_c0);
}

// QPixmap QPixmap::copy(int x, int y, int width, int height)


static void _init_f_copy_c2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("width");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("height");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QPixmap > ();
}

static void _call_f_copy_c2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->copy (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_copy_c2744 ()
{
  return new qt_gsi::GenericMethod ("copy", "@brief Method QPixmap QPixmap::copy(int x, int y, int width, int height)\n", true, &_init_f_copy_c2744, &_call_f_copy_c2744);
}

// QPixmap QPixmap::copy(const QRect &rect)


static void _init_f_copy_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRect()");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QPixmap > ();
}

static void _call_f_copy_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args ? args.read<const QRect & > () : (const QRect &)(QRect());
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->copy (arg1));
}

static qt_gsi::GenericMethod *_create_f_copy_c1792 ()
{
  return new qt_gsi::GenericMethod ("copy", "@brief Method QPixmap QPixmap::copy(const QRect &rect)\n", true, &_init_f_copy_c1792, &_call_f_copy_c1792);
}

// QBitmap QPixmap::createHeuristicMask(bool clipTight)


static void _init_f_createHeuristicMask_c864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("clipTight", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<QBitmap > ();
}

static void _call_f_createHeuristicMask_c864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  ret.write<QBitmap > ((QBitmap)((QPixmap *)cls)->createHeuristicMask (arg1));
}

static qt_gsi::GenericMethod *_create_f_createHeuristicMask_c864 ()
{
  return new qt_gsi::GenericMethod ("createHeuristicMask", "@brief Method QBitmap QPixmap::createHeuristicMask(bool clipTight)\n", true, &_init_f_createHeuristicMask_c864, &_call_f_createHeuristicMask_c864);
}

// QBitmap QPixmap::createMaskFromColor(const QColor &maskColor)


static void _init_f_createMaskFromColor_c1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maskColor");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<QBitmap > ();
}

static void _call_f_createMaskFromColor_c1905 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args.read<const QColor & > ();
  ret.write<QBitmap > ((QBitmap)((QPixmap *)cls)->createMaskFromColor (arg1));
}

static qt_gsi::GenericMethod *_create_f_createMaskFromColor_c1905 ()
{
  return new qt_gsi::GenericMethod ("createMaskFromColor", "@brief Method QBitmap QPixmap::createMaskFromColor(const QColor &maskColor)\n", true, &_init_f_createMaskFromColor_c1905, &_call_f_createMaskFromColor_c1905);
}

// QBitmap QPixmap::createMaskFromColor(const QColor &maskColor, Qt::MaskMode mode)


static void _init_f_createMaskFromColor_c3331 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maskColor");
  decl->add_arg<const QColor & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::MaskMode>::target_type & > (argspec_1);
  decl->set_return<QBitmap > ();
}

static void _call_f_createMaskFromColor_c3331 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args.read<const QColor & > ();
  const qt_gsi::Converter<Qt::MaskMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::MaskMode>::target_type & > ();
  ret.write<QBitmap > ((QBitmap)((QPixmap *)cls)->createMaskFromColor (arg1, qt_gsi::QtToCppAdaptor<Qt::MaskMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_createMaskFromColor_c3331 ()
{
  return new qt_gsi::GenericMethod ("createMaskFromColor", "@brief Method QBitmap QPixmap::createMaskFromColor(const QColor &maskColor, Qt::MaskMode mode)\n", true, &_init_f_createMaskFromColor_c3331, &_call_f_createMaskFromColor_c3331);
}

// int QPixmap::depth()


static void _init_f_depth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_depth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPixmap *)cls)->depth ());
}

static qt_gsi::GenericMethod *_create_f_depth_c0 ()
{
  return new qt_gsi::GenericMethod ("depth", "@brief Method int QPixmap::depth()\n", true, &_init_f_depth_c0, &_call_f_depth_c0);
}

// void QPixmap::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPixmap *)cls)->detach ();
}

static qt_gsi::GenericMethod *_create_f_detach_0 ()
{
  return new qt_gsi::GenericMethod ("detach", "@brief Method void QPixmap::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
}

// void QPixmap::fill(const QColor &fillColor)


static void _init_f_fill_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fillColor", true, "Qt::white");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fill_1905 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args ? args.read<const QColor & > () : (const QColor &)(Qt::white);
  ((QPixmap *)cls)->fill (arg1);
}

static qt_gsi::GenericMethod *_create_f_fill_1905 ()
{
  return new qt_gsi::GenericMethod ("fill", "@brief Method void QPixmap::fill(const QColor &fillColor)\n", false, &_init_f_fill_1905, &_call_f_fill_1905);
}

// void QPixmap::fill(const QWidget *widget, const QPoint &ofs)


static void _init_f_fill_3818 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<const QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ofs");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fill_3818 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QWidget *arg1 = args.read<const QWidget * > ();
  const QPoint &arg2 = args.read<const QPoint & > ();
  ((QPixmap *)cls)->fill (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_fill_3818 ()
{
  return new qt_gsi::GenericMethod ("fill", "@brief Method void QPixmap::fill(const QWidget *widget, const QPoint &ofs)\n", false, &_init_f_fill_3818, &_call_f_fill_3818);
}

// void QPixmap::fill(const QWidget *widget, int xofs, int yofs)


static void _init_f_fill_3328 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<const QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xofs");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("yofs");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_fill_3328 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QWidget *arg1 = args.read<const QWidget * > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPixmap *)cls)->fill (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_fill_3328 ()
{
  return new qt_gsi::GenericMethod ("fill", "@brief Method void QPixmap::fill(const QWidget *widget, int xofs, int yofs)\n", false, &_init_f_fill_3328, &_call_f_fill_3328);
}

// bool QPixmap::hasAlpha()


static void _init_f_hasAlpha_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAlpha_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPixmap *)cls)->hasAlpha ());
}

static qt_gsi::GenericMethod *_create_f_hasAlpha_c0 ()
{
  return new qt_gsi::GenericMethod ("hasAlpha", "@brief Method bool QPixmap::hasAlpha()\n", true, &_init_f_hasAlpha_c0, &_call_f_hasAlpha_c0);
}

// bool QPixmap::hasAlphaChannel()


static void _init_f_hasAlphaChannel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAlphaChannel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPixmap *)cls)->hasAlphaChannel ());
}

static qt_gsi::GenericMethod *_create_f_hasAlphaChannel_c0 ()
{
  return new qt_gsi::GenericMethod ("hasAlphaChannel", "@brief Method bool QPixmap::hasAlphaChannel()\n", true, &_init_f_hasAlphaChannel_c0, &_call_f_hasAlphaChannel_c0);
}

// int QPixmap::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPixmap *)cls)->height ());
}

static qt_gsi::GenericMethod *_create_f_height_c0 ()
{
  return new qt_gsi::GenericMethod ("height", "@brief Method int QPixmap::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
}

// bool QPixmap::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPixmap *)cls)->isDetached ());
}

static qt_gsi::GenericMethod *_create_f_isDetached_c0 ()
{
  return new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QPixmap::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
}

// bool QPixmap::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPixmap *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QPixmap::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// bool QPixmap::isQBitmap()


static void _init_f_isQBitmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isQBitmap_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPixmap *)cls)->isQBitmap ());
}

static qt_gsi::GenericMethod *_create_f_isQBitmap_c0 ()
{
  return new qt_gsi::GenericMethod ("isQBitmap?", "@brief Method bool QPixmap::isQBitmap()\n", true, &_init_f_isQBitmap_c0, &_call_f_isQBitmap_c0);
}

// bool QPixmap::load(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_load_6908 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_load_6908 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ret.write<bool > ((bool)((QPixmap *)cls)->load (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_load_6908 ()
{
  return new qt_gsi::GenericMethod ("load", "@brief Method bool QPixmap::load(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_load_6908, &_call_f_load_6908);
}

// bool QPixmap::loadFromData(const unsigned char *buf, unsigned int len, const char *format, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_loadFromData_9283 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buf");
  decl->add_arg<const unsigned char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<unsigned int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "0");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_loadFromData_9283 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const unsigned char *arg1 = args.read<const unsigned char * > ();
  unsigned int arg2 = args.read<unsigned int > ();
  const char *arg3 = args ? args.read<const char * > () : (const char *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ret.write<bool > ((bool)((QPixmap *)cls)->loadFromData (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg4).cref()));
}

static qt_gsi::GenericMethod *_create_f_loadFromData_9283 ()
{
  return new qt_gsi::GenericMethod ("loadFromData", "@brief Method bool QPixmap::loadFromData(const unsigned char *buf, unsigned int len, const char *format, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_loadFromData_9283, &_call_f_loadFromData_9283);
}

// bool QPixmap::loadFromData(const QByteArray &data, const char *format, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_loadFromData_7192 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_loadFromData_7192 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ret.write<bool > ((bool)((QPixmap *)cls)->loadFromData (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_loadFromData_7192 ()
{
  return new qt_gsi::GenericMethod ("loadFromData", "@brief Method bool QPixmap::loadFromData(const QByteArray &data, const char *format, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_loadFromData_7192, &_call_f_loadFromData_7192);
}

// QBitmap QPixmap::mask()


static void _init_f_mask_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBitmap > ();
}

static void _call_f_mask_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBitmap > ((QBitmap)((QPixmap *)cls)->mask ());
}

static qt_gsi::GenericMethod *_create_f_mask_c0 ()
{
  return new qt_gsi::GenericMethod (":mask", "@brief Method QBitmap QPixmap::mask()\n", true, &_init_f_mask_c0, &_call_f_mask_c0);
}

// bool QPixmap::operator!()


static void _init_f_operator_excl__c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPixmap *)cls)->operator! ());
}

static qt_gsi::GenericMethod *_create_f_operator_excl__c0 ()
{
  return new qt_gsi::GenericMethod ("!", "@brief Method bool QPixmap::operator!()\n", true, &_init_f_operator_excl__c0, &_call_f_operator_excl__c0);
}

// QPixmap &QPixmap::operator=(const QPixmap &)


static void _init_f_operator_eq__2017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return<QPixmap & > ();
}

static void _call_f_operator_eq__2017 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPixmap &arg1 = args.read<const QPixmap & > ();
  ret.write<QPixmap & > ((QPixmap &)((QPixmap *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2017 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QPixmap &QPixmap::operator=(const QPixmap &)\n", false, &_init_f_operator_eq__2017, &_call_f_operator_eq__2017);
}

// QPaintEngine *QPixmap::paintEngine()


static void _init_f_paintEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_f_paintEngine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPixmap *)cls)->paintEngine ());
}

static qt_gsi::GenericMethod *_create_f_paintEngine_c0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Method QPaintEngine *QPixmap::paintEngine()\nThis is a reimplementation of QPaintDevice::paintEngine", true, &_init_f_paintEngine_c0, &_call_f_paintEngine_c0);
}

// QRect QPixmap::rect()


static void _init_f_rect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_rect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QPixmap *)cls)->rect ());
}

static qt_gsi::GenericMethod *_create_f_rect_c0 ()
{
  return new qt_gsi::GenericMethod ("rect", "@brief Method QRect QPixmap::rect()\n", true, &_init_f_rect_c0, &_call_f_rect_c0);
}

// bool QPixmap::save(const QString &fileName, const char *format, int quality)


static void _init_f_save_c4307 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("quality", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_save_c4307 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  int arg3 = args ? args.read<int > () : (int)(-1);
  ret.write<bool > ((bool)((QPixmap *)cls)->save (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_save_c4307 ()
{
  return new qt_gsi::GenericMethod ("save", "@brief Method bool QPixmap::save(const QString &fileName, const char *format, int quality)\n", true, &_init_f_save_c4307, &_call_f_save_c4307);
}

// bool QPixmap::save(QIODevice *device, const char *format, int quality)


static void _init_f_save_c3729 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("quality", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_save_c3729 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  int arg3 = args ? args.read<int > () : (int)(-1);
  ret.write<bool > ((bool)((QPixmap *)cls)->save (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_save_c3729 ()
{
  return new qt_gsi::GenericMethod ("save", "@brief Method bool QPixmap::save(QIODevice *device, const char *format, int quality)\n", true, &_init_f_save_c3729, &_call_f_save_c3729);
}

// QPixmap QPixmap::scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)


static void _init_f_scaled_c6100 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("aspectMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_3);
  decl->set_return<QPixmap > ();
}

static void _call_f_scaled_c6100 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > () : (const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio));
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->scaled (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg3).cref(), qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg4).cref()));
}

static qt_gsi::GenericMethod *_create_f_scaled_c6100 ()
{
  return new qt_gsi::GenericMethod ("scaled", "@brief Method QPixmap QPixmap::scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)\n", true, &_init_f_scaled_c6100, &_call_f_scaled_c6100);
}

// QPixmap QPixmap::scaled(const QSize &s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)


static void _init_f_scaled_c6479 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aspectMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_scaled_c6479 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > () : (const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio));
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->scaled (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_scaled_c6479 ()
{
  return new qt_gsi::GenericMethod ("scaled", "@brief Method QPixmap QPixmap::scaled(const QSize &s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)\n", true, &_init_f_scaled_c6479, &_call_f_scaled_c6479);
}

// QPixmap QPixmap::scaledToHeight(int h, Qt::TransformationMode mode)


static void _init_f_scaledToHeight_c3292 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_scaledToHeight_c3292 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->scaledToHeight (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_scaledToHeight_c3292 ()
{
  return new qt_gsi::GenericMethod ("scaledToHeight", "@brief Method QPixmap QPixmap::scaledToHeight(int h, Qt::TransformationMode mode)\n", true, &_init_f_scaledToHeight_c3292, &_call_f_scaledToHeight_c3292);
}

// QPixmap QPixmap::scaledToWidth(int w, Qt::TransformationMode mode)


static void _init_f_scaledToWidth_c3292 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_scaledToWidth_c3292 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->scaledToWidth (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_scaledToWidth_c3292 ()
{
  return new qt_gsi::GenericMethod ("scaledToWidth", "@brief Method QPixmap QPixmap::scaledToWidth(int w, Qt::TransformationMode mode)\n", true, &_init_f_scaledToWidth_c3292, &_call_f_scaledToWidth_c3292);
}

// void QPixmap::scroll(int dx, int dy, int x, int y, int width, int height, QRegion *exposed)


static void _init_f_scroll_5269 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("width");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("height");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("exposed", true, "0");
  decl->add_arg<QRegion * > (argspec_6);
  decl->set_return<void > ();
}

static void _call_f_scroll_5269 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  int arg5 = args.read<int > ();
  int arg6 = args.read<int > ();
  QRegion *arg7 = args ? args.read<QRegion * > () : (QRegion *)(0);
  ((QPixmap *)cls)->scroll (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

static qt_gsi::GenericMethod *_create_f_scroll_5269 ()
{
  return new qt_gsi::GenericMethod ("scroll", "@brief Method void QPixmap::scroll(int dx, int dy, int x, int y, int width, int height, QRegion *exposed)\n", false, &_init_f_scroll_5269, &_call_f_scroll_5269);
}

// void QPixmap::scroll(int dx, int dy, const QRect &rect, QRegion *exposed)


static void _init_f_scroll_4317 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("exposed", true, "0");
  decl->add_arg<QRegion * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_scroll_4317 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QRect &arg3 = args.read<const QRect & > ();
  QRegion *arg4 = args ? args.read<QRegion * > () : (QRegion *)(0);
  ((QPixmap *)cls)->scroll (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_scroll_4317 ()
{
  return new qt_gsi::GenericMethod ("scroll", "@brief Method void QPixmap::scroll(int dx, int dy, const QRect &rect, QRegion *exposed)\n", false, &_init_f_scroll_4317, &_call_f_scroll_4317);
}

// int QPixmap::serialNumber()


static void _init_f_serialNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_serialNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPixmap *)cls)->serialNumber ());
}

static qt_gsi::GenericMethod *_create_f_serialNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("serialNumber", "@brief Method int QPixmap::serialNumber()\n", true, &_init_f_serialNumber_c0, &_call_f_serialNumber_c0);
}

// void QPixmap::setAlphaChannel(const QPixmap &)


static void _init_f_setAlphaChannel_2017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlphaChannel_2017 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPixmap &arg1 = args.read<const QPixmap & > ();
  ((QPixmap *)cls)->setAlphaChannel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAlphaChannel_2017 ()
{
  return new qt_gsi::GenericMethod ("setAlphaChannel|alphaChannel=", "@brief Method void QPixmap::setAlphaChannel(const QPixmap &)\n", false, &_init_f_setAlphaChannel_2017, &_call_f_setAlphaChannel_2017);
}

// void QPixmap::setMask(const QBitmap &)


static void _init_f_setMask_1999 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QBitmap & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMask_1999 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBitmap &arg1 = args.read<const QBitmap & > ();
  ((QPixmap *)cls)->setMask (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMask_1999 ()
{
  return new qt_gsi::GenericMethod ("setMask|mask=", "@brief Method void QPixmap::setMask(const QBitmap &)\n", false, &_init_f_setMask_1999, &_call_f_setMask_1999);
}

// QSize QPixmap::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QPixmap *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod ("size", "@brief Method QSize QPixmap::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// QImage QPixmap::toImage()


static void _init_f_toImage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_f_toImage_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QImage > ((QImage)((QPixmap *)cls)->toImage ());
}

static qt_gsi::GenericMethod *_create_f_toImage_c0 ()
{
  return new qt_gsi::GenericMethod ("toImage", "@brief Method QImage QPixmap::toImage()\n", true, &_init_f_toImage_c0, &_call_f_toImage_c0);
}

// QPixmap QPixmap::transformed(const QMatrix &, Qt::TransformationMode mode)


static void _init_f_transformed_c4548 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_transformed_c4548 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->transformed (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_transformed_c4548 ()
{
  return new qt_gsi::GenericMethod ("transformed", "@brief Method QPixmap QPixmap::transformed(const QMatrix &, Qt::TransformationMode mode)\n", true, &_init_f_transformed_c4548, &_call_f_transformed_c4548);
}

// QPixmap QPixmap::transformed(const QTransform &, Qt::TransformationMode mode)


static void _init_f_transformed_c4875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_transformed_c4875 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QPixmap > ((QPixmap)((QPixmap *)cls)->transformed (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_transformed_c4875 ()
{
  return new qt_gsi::GenericMethod ("transformed", "@brief Method QPixmap QPixmap::transformed(const QTransform &, Qt::TransformationMode mode)\n", true, &_init_f_transformed_c4875, &_call_f_transformed_c4875);
}

// int QPixmap::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QPixmap *)cls)->width ());
}

static qt_gsi::GenericMethod *_create_f_width_c0 ()
{
  return new qt_gsi::GenericMethod ("width", "@brief Method int QPixmap::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
}

// static int QPixmap::defaultDepth()


static void _init_f_defaultDepth_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_defaultDepth_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QPixmap::defaultDepth ());
}

static qt_gsi::GenericStaticMethod *_create_f_defaultDepth_0 ()
{
  return new qt_gsi::GenericStaticMethod ("defaultDepth", "@brief Static method int QPixmap::defaultDepth()\nThis method is static and can be called without an instance.", &_init_f_defaultDepth_0, &_call_f_defaultDepth_0);
}

// static QPixmap QPixmap::fromImage(const QImage &image, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_fromImage_5137 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<const QImage & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_fromImage_5137 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ret.write<QPixmap > ((QPixmap)QPixmap::fromImage (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_fromImage_5137 ()
{
  return new qt_gsi::GenericStaticMethod ("fromImage", "@brief Static method QPixmap QPixmap::fromImage(const QImage &image, QFlags<Qt::ImageConversionFlag> flags)\nThis method is static and can be called without an instance.", &_init_f_fromImage_5137, &_call_f_fromImage_5137);
}

// static QPixmap QPixmap::grabWidget(QWidget *widget, const QRect &rect)


static void _init_f_grabWidget_2999 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_f_grabWidget_2999 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  ret.write<QPixmap > ((QPixmap)QPixmap::grabWidget (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_grabWidget_2999 ()
{
  return new qt_gsi::GenericStaticMethod ("grabWidget", "@brief Static method QPixmap QPixmap::grabWidget(QWidget *widget, const QRect &rect)\nThis method is static and can be called without an instance.", &_init_f_grabWidget_2999, &_call_f_grabWidget_2999);
}

// static QPixmap QPixmap::grabWidget(QWidget *widget, int x, int y, int w, int h)


static void _init_f_grabWidget_3951 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y", true, "0");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "-1");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h", true, "-1");
  decl->add_arg<int > (argspec_4);
  decl->set_return<QPixmap > ();
}

static void _call_f_grabWidget_3951 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  int arg3 = args ? args.read<int > () : (int)(0);
  int arg4 = args ? args.read<int > () : (int)(-1);
  int arg5 = args ? args.read<int > () : (int)(-1);
  ret.write<QPixmap > ((QPixmap)QPixmap::grabWidget (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericStaticMethod *_create_f_grabWidget_3951 ()
{
  return new qt_gsi::GenericStaticMethod ("grabWidget", "@brief Static method QPixmap QPixmap::grabWidget(QWidget *widget, int x, int y, int w, int h)\nThis method is static and can be called without an instance.", &_init_f_grabWidget_3951, &_call_f_grabWidget_3951);
}

// static QPixmap QPixmap::grabWindow(WId, int x, int y, int w, int h)


static void _init_f_grabWindow_3332 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y", true, "0");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "-1");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h", true, "-1");
  decl->add_arg<int > (argspec_4);
  decl->set_return<QPixmap > ();
}

static void _call_f_grabWindow_3332 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<WId>::target_type & arg1 = args.read<const qt_gsi::Converter<WId>::target_type & > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  int arg3 = args ? args.read<int > () : (int)(0);
  int arg4 = args ? args.read<int > () : (int)(-1);
  int arg5 = args ? args.read<int > () : (int)(-1);
  ret.write<QPixmap > ((QPixmap)QPixmap::grabWindow (qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericStaticMethod *_create_f_grabWindow_3332 ()
{
  return new qt_gsi::GenericStaticMethod ("grabWindow", "@brief Static method QPixmap QPixmap::grabWindow(WId, int x, int y, int w, int h)\nThis method is static and can be called without an instance.", &_init_f_grabWindow_3332, &_call_f_grabWindow_3332);
}

// static QMatrix QPixmap::trueMatrix(const QMatrix &m, int w, int h)


static void _init_f_trueMatrix_3341 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("w");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QMatrix > ();
}

static void _call_f_trueMatrix_3341 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QMatrix > ((QMatrix)QPixmap::trueMatrix (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trueMatrix_3341 ()
{
  return new qt_gsi::GenericStaticMethod ("trueMatrix", "@brief Static method QMatrix QPixmap::trueMatrix(const QMatrix &m, int w, int h)\nThis method is static and can be called without an instance.", &_init_f_trueMatrix_3341, &_call_f_trueMatrix_3341);
}

// static QTransform QPixmap::trueMatrix(const QTransform &m, int w, int h)


static void _init_f_trueMatrix_3668 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("w");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QTransform > ();
}

static void _call_f_trueMatrix_3668 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QTransform > ((QTransform)QPixmap::trueMatrix (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trueMatrix_3668 ()
{
  return new qt_gsi::GenericStaticMethod ("trueMatrix", "@brief Static method QTransform QPixmap::trueMatrix(const QTransform &m, int w, int h)\nThis method is static and can be called without an instance.", &_init_f_trueMatrix_3668, &_call_f_trueMatrix_3668);
}

namespace gsi
{
extern gsi::Class<QPaintDevice> decl_QPaintDevice;

gsi::Class<QPixmap> decl_QPixmap (decl_QPaintDevice, "QPixmap_Native",
  gsi::Methods(_create_f_alphaChannel_c0 ()) +
  gsi::Methods(_create_f_cacheKey_c0 ()) +
  gsi::Methods(_create_f_copy_c2744 ()) +
  gsi::Methods(_create_f_copy_c1792 ()) +
  gsi::Methods(_create_f_createHeuristicMask_c864 ()) +
  gsi::Methods(_create_f_createMaskFromColor_c1905 ()) +
  gsi::Methods(_create_f_createMaskFromColor_c3331 ()) +
  gsi::Methods(_create_f_depth_c0 ()) +
  gsi::Methods(_create_f_detach_0 ()) +
  gsi::Methods(_create_f_fill_1905 ()) +
  gsi::Methods(_create_f_fill_3818 ()) +
  gsi::Methods(_create_f_fill_3328 ()) +
  gsi::Methods(_create_f_hasAlpha_c0 ()) +
  gsi::Methods(_create_f_hasAlphaChannel_c0 ()) +
  gsi::Methods(_create_f_height_c0 ()) +
  gsi::Methods(_create_f_isDetached_c0 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_isQBitmap_c0 ()) +
  gsi::Methods(_create_f_load_6908 ()) +
  gsi::Methods(_create_f_loadFromData_9283 ()) +
  gsi::Methods(_create_f_loadFromData_7192 ()) +
  gsi::Methods(_create_f_mask_c0 ()) +
  gsi::Methods(_create_f_operator_excl__c0 ()) +
  gsi::Methods(_create_f_operator_eq__2017 ()) +
  gsi::Methods(_create_f_paintEngine_c0 ()) +
  gsi::Methods(_create_f_rect_c0 ()) +
  gsi::Methods(_create_f_save_c4307 ()) +
  gsi::Methods(_create_f_save_c3729 ()) +
  gsi::Methods(_create_f_scaled_c6100 ()) +
  gsi::Methods(_create_f_scaled_c6479 ()) +
  gsi::Methods(_create_f_scaledToHeight_c3292 ()) +
  gsi::Methods(_create_f_scaledToWidth_c3292 ()) +
  gsi::Methods(_create_f_scroll_5269 ()) +
  gsi::Methods(_create_f_scroll_4317 ()) +
  gsi::Methods(_create_f_serialNumber_c0 ()) +
  gsi::Methods(_create_f_setAlphaChannel_2017 ()) +
  gsi::Methods(_create_f_setMask_1999 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_toImage_c0 ()) +
  gsi::Methods(_create_f_transformed_c4548 ()) +
  gsi::Methods(_create_f_transformed_c4875 ()) +
  gsi::Methods(_create_f_width_c0 ()) +
  gsi::Methods(_create_f_defaultDepth_0 ()) +
  gsi::Methods(_create_f_fromImage_5137 ()) +
  gsi::Methods(_create_f_grabWidget_2999 ()) +
  gsi::Methods(_create_f_grabWidget_3951 ()) +
  gsi::Methods(_create_f_grabWindow_3332 ()) +
  gsi::Methods(_create_f_trueMatrix_3341 ()) +
  gsi::Methods(_create_f_trueMatrix_3668 ()),
  "@hide\n@alias QPixmap");
}


class QPixmap_Adaptor : public QPixmap, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPixmap_Adaptor();

  //  [adaptor ctor] QPixmap::QPixmap()
  QPixmap_Adaptor() : QPixmap()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(int w, int h)
  QPixmap_Adaptor(int w, int h) : QPixmap(w, h)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QSize &)
  QPixmap_Adaptor(const QSize &arg1) : QPixmap(arg1)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)
  QPixmap_Adaptor(const QString &fileName) : QPixmap(fileName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)
  QPixmap_Adaptor(const QString &fileName, const char *format) : QPixmap(fileName, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)
  QPixmap_Adaptor(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags) : QPixmap(fileName, format, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPixmap::QPixmap(const QPixmap &)
  QPixmap_Adaptor(const QPixmap &arg1) : QPixmap(arg1)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] QPaintEngine *QPixmap::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPixmap::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPixmap_Adaptor, QPaintEngine *>(&QPixmap_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPixmap::paintEngine();
    }
  }

  //  [adaptor impl] int QPixmap::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QPixmap::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPixmap_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPixmap_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QPixmap::metric(arg1);
    }
  }

  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_metric_c3445_0;
};

QPixmap_Adaptor::~QPixmap_Adaptor() { }

//  Constructor QPixmap::QPixmap() (adaptor class)

static void _init_ctor_QPixmap_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPixmap_Adaptor *> ();
}

static void _call_ctor_QPixmap_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPixmap_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap()\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_0, &_call_ctor_QPixmap_Adaptor_0);
}

//  Constructor QPixmap::QPixmap(int w, int h) (adaptor class)

static void _init_ctor_QPixmap_Adaptor_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return_new<QPixmap_Adaptor *> ();
}

static void _call_ctor_QPixmap_Adaptor_1426 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPixmap_Adaptor_1426 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap(int w, int h)\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_1426, &_call_ctor_QPixmap_Adaptor_1426);
}

//  Constructor QPixmap::QPixmap(const QSize &) (adaptor class)

static void _init_ctor_QPixmap_Adaptor_1805 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return_new<QPixmap_Adaptor *> ();
}

static void _call_ctor_QPixmap_Adaptor_1805 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPixmap_Adaptor_1805 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap(const QSize &)\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_1805, &_call_ctor_QPixmap_Adaptor_1805);
}

//  Constructor QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags) (adaptor class)

static void _init_ctor_QPixmap_Adaptor_6908 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_2);
  decl->set_return_new<QPixmap_Adaptor *> ();
}

static void _call_ctor_QPixmap_Adaptor_6908 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg3).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPixmap_Adaptor_6908 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap(const QString &fileName, const char *format, QFlags<Qt::ImageConversionFlag> flags)\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_6908, &_call_ctor_QPixmap_Adaptor_6908);
}

//  Constructor QPixmap::QPixmap(const QPixmap &) (adaptor class)

static void _init_ctor_QPixmap_Adaptor_2017 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return_new<QPixmap_Adaptor *> ();
}

static void _call_ctor_QPixmap_Adaptor_2017 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPixmap &arg1 = args.read<const QPixmap & > ();
  ret.write<QPixmap_Adaptor *> (new QPixmap_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPixmap_Adaptor_2017 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPixmap::QPixmap(const QPixmap &)\nThis method creates an object of class QPixmap.", &_init_ctor_QPixmap_Adaptor_2017, &_call_ctor_QPixmap_Adaptor_2017);
}

// QPaintEngine *QPixmap::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPixmap_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPixmap_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QPixmap::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// int QPixmap::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QPixmap_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPixmap_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPixmap::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


namespace gsi
{

extern gsi::Class<QPixmap> decl_QPixmap;

gsi::Class<QPixmap_Adaptor> decl_QPixmap_Adaptor (decl_QPixmap, "QPixmap",
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_ctor_QPixmap_Adaptor_0 ()) +
  gsi::Methods(_create_ctor_QPixmap_Adaptor_1426 ()) +
  gsi::Methods(_create_ctor_QPixmap_Adaptor_1805 ()) +
  gsi::Methods(_create_ctor_QPixmap_Adaptor_6908 ()) +
  gsi::Methods(_create_ctor_QPixmap_Adaptor_2017 ()),
  "@qt\n@brief Binding of QPixmap");

}

