
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file generated/gsiDeclQNetworkReply_EventAdaptor.cc
*  @brief Event adaptor implementations for QNetworkReply
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQNetworkReply_EventAdaptor.h"

// -----------------------------------------------------------------------
// class QNetworkReply_EventAdaptor

QNetworkReply_EventAdaptor::QNetworkReply_EventAdaptor (QObject *host)
  : QObject ()
{
  connect (host, SIGNAL(aboutToClose()), this, SLOT(aboutToClose()));
  connect (host, SIGNAL(bytesWritten(qint64)), this, SLOT(bytesWritten(qint64)));
  connect (host, SIGNAL(destroyed(QObject *)), this, SLOT(destroyed(QObject *)));
  connect (host, SIGNAL(downloadProgress(qint64, qint64)), this, SLOT(downloadProgress(qint64, qint64)));
  connect (host, SIGNAL(error(QNetworkReply::NetworkError)), this, SLOT(error(QNetworkReply::NetworkError)));
  connect (host, SIGNAL(finished()), this, SLOT(finished()));
  connect (host, SIGNAL(metaDataChanged()), this, SLOT(metaDataChanged()));
  connect (host, SIGNAL(readChannelFinished()), this, SLOT(readChannelFinished()));
  connect (host, SIGNAL(readyRead()), this, SLOT(readyRead()));
  connect (host, SIGNAL(sslErrors(const QList<QSslError> &)), this, SLOT(sslErrors(const QList<QSslError> &)));
  connect (host, SIGNAL(uploadProgress(qint64, qint64)), this, SLOT(uploadProgress(qint64, qint64)));
}

//  Event QNetworkReply::aboutToClose()
void QNetworkReply_EventAdaptor::aboutToClose() {
BEGIN_PROTECTED
  aboutToClose_e_0();
END_PROTECTED
}

//  Event QNetworkReply::bytesWritten(qint64 bytes)
void QNetworkReply_EventAdaptor::bytesWritten(qint64 bytes) {
BEGIN_PROTECTED
  bytesWritten_e_986(bytes);
END_PROTECTED
}

//  Event QNetworkReply::destroyed(QObject *arg1)
void QNetworkReply_EventAdaptor::destroyed(QObject *arg1) {
BEGIN_PROTECTED
  destroyed_e_1302(arg1);
END_PROTECTED
}

//  Event QNetworkReply::downloadProgress(qint64 bytesReceived, qint64 bytesTotal)
void QNetworkReply_EventAdaptor::downloadProgress(qint64 bytesReceived, qint64 bytesTotal) {
BEGIN_PROTECTED
  downloadProgress_e_1864(bytesReceived, bytesTotal);
END_PROTECTED
}

//  Event QNetworkReply::error(QNetworkReply::NetworkError arg1)
void QNetworkReply_EventAdaptor::error(QNetworkReply::NetworkError arg1) {
BEGIN_PROTECTED
  error_e_3171(qt_gsi::CppToQtAdaptor<QNetworkReply::NetworkError>(arg1));
END_PROTECTED
}

//  Event QNetworkReply::finished()
void QNetworkReply_EventAdaptor::finished() {
BEGIN_PROTECTED
  finished_e_0();
END_PROTECTED
}

//  Event QNetworkReply::metaDataChanged()
void QNetworkReply_EventAdaptor::metaDataChanged() {
BEGIN_PROTECTED
  metaDataChanged_e_0();
END_PROTECTED
}

//  Event QNetworkReply::readChannelFinished()
void QNetworkReply_EventAdaptor::readChannelFinished() {
BEGIN_PROTECTED
  readChannelFinished_e_0();
END_PROTECTED
}

//  Event QNetworkReply::readyRead()
void QNetworkReply_EventAdaptor::readyRead() {
BEGIN_PROTECTED
  readyRead_e_0();
END_PROTECTED
}

//  Event QNetworkReply::sslErrors(const QList<QSslError> &errors)
void QNetworkReply_EventAdaptor::sslErrors(const QList<QSslError> &errors) {
BEGIN_PROTECTED
  sslErrors_e_2837(qt_gsi::CppToQtAdaptor<QList<QSslError> >(errors));
END_PROTECTED
}

//  Event QNetworkReply::uploadProgress(qint64 bytesSent, qint64 bytesTotal)
void QNetworkReply_EventAdaptor::uploadProgress(qint64 bytesSent, qint64 bytesTotal) {
BEGIN_PROTECTED
  uploadProgress_e_1864(bytesSent, bytesTotal);
END_PROTECTED
}
