
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMenuBar.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQMenuBar_EventAdaptor.h"
#include "gsiDeclQMenuBar_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMenuBar

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMenuBar::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QAction *QMenuBar::actionAt(const QPoint &)


static void _init_f_actionAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QAction * > ();
}

static void _call_f_actionAt_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QAction * > ((QAction *)((QMenuBar *)cls)->actionAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_actionAt_c1916 ()
{
  return new qt_gsi::GenericMethod ("actionAt", "@brief Method QAction *QMenuBar::actionAt(const QPoint &)\n", true, &_init_f_actionAt_c1916, &_call_f_actionAt_c1916);
}

// QRect QMenuBar::actionGeometry(QAction *)


static void _init_f_actionGeometry_c1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_actionGeometry_c1309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  ret.write<QRect > ((QRect)((QMenuBar *)cls)->actionGeometry (arg1));
}

static qt_gsi::GenericMethod *_create_f_actionGeometry_c1309 ()
{
  return new qt_gsi::GenericMethod ("actionGeometry", "@brief Method QRect QMenuBar::actionGeometry(QAction *)\n", true, &_init_f_actionGeometry_c1309, &_call_f_actionGeometry_c1309);
}

// QAction *QMenuBar::activeAction()


static void _init_f_activeAction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAction * > ();
}

static void _call_f_activeAction_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAction * > ((QAction *)((QMenuBar *)cls)->activeAction ());
}

static qt_gsi::GenericMethod *_create_f_activeAction_c0 ()
{
  return new qt_gsi::GenericMethod (":activeAction", "@brief Method QAction *QMenuBar::activeAction()\n", true, &_init_f_activeAction_c0, &_call_f_activeAction_c0);
}

// void QMenuBar::addAction(QAction *action)


static void _init_f_addAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addAction_1309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  ((QMenuBar *)cls)->addAction (arg1);
}

static qt_gsi::GenericMethod *_create_f_addAction_1309 ()
{
  return new qt_gsi::GenericMethod ("addAction", "@brief Method void QMenuBar::addAction(QAction *action)\n", false, &_init_f_addAction_1309, &_call_f_addAction_1309);
}

// QAction *QMenuBar::addAction(const QString &text)


static void _init_f_addAction_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QAction * > ();
}

static void _call_f_addAction_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QAction * > ((QAction *)((QMenuBar *)cls)->addAction (arg1));
}

static qt_gsi::GenericMethod *_create_f_addAction_2025 ()
{
  return new qt_gsi::GenericMethod ("addAction", "@brief Method QAction *QMenuBar::addAction(const QString &text)\n", false, &_init_f_addAction_2025, &_call_f_addAction_2025);
}

// QAction *QMenuBar::addAction(const QString &text, const QObject *receiver, const char *member)


static void _init_f_addAction_5537 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("receiver");
  decl->add_arg<const QObject * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("member");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<QAction * > ();
}

static void _call_f_addAction_5537 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QObject *arg2 = args.read<const QObject * > ();
  const char *arg3 = args.read<const char * > ();
  ret.write<QAction * > ((QAction *)((QMenuBar *)cls)->addAction (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_addAction_5537 ()
{
  return new qt_gsi::GenericMethod ("addAction", "@brief Method QAction *QMenuBar::addAction(const QString &text, const QObject *receiver, const char *member)\n", false, &_init_f_addAction_5537, &_call_f_addAction_5537);
}

// QAction *QMenuBar::addMenu(QMenu *menu)


static void _init_f_addMenu_1108 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("menu");
  decl->add_arg<QMenu * > (argspec_0);
  decl->set_return<QAction * > ();
}

static void _call_f_addMenu_1108 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMenu *arg1 = args.read<QMenu * > ();
  ret.write<QAction * > ((QAction *)((QMenuBar *)cls)->addMenu (arg1));
}

static qt_gsi::GenericMethod *_create_f_addMenu_1108 ()
{
  return new qt_gsi::GenericMethod ("addMenu", "@brief Method QAction *QMenuBar::addMenu(QMenu *menu)\n", false, &_init_f_addMenu_1108, &_call_f_addMenu_1108);
}

// QMenu *QMenuBar::addMenu(const QString &title)


static void _init_f_addMenu_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QMenu * > ();
}

static void _call_f_addMenu_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QMenu * > ((QMenu *)((QMenuBar *)cls)->addMenu (arg1));
}

static qt_gsi::GenericMethod *_create_f_addMenu_2025 ()
{
  return new qt_gsi::GenericMethod ("addMenu", "@brief Method QMenu *QMenuBar::addMenu(const QString &title)\n", false, &_init_f_addMenu_2025, &_call_f_addMenu_2025);
}

// QMenu *QMenuBar::addMenu(const QIcon &icon, const QString &title)


static void _init_f_addMenu_3704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QMenu * > ();
}

static void _call_f_addMenu_3704 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QMenu * > ((QMenu *)((QMenuBar *)cls)->addMenu (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_addMenu_3704 ()
{
  return new qt_gsi::GenericMethod ("addMenu", "@brief Method QMenu *QMenuBar::addMenu(const QIcon &icon, const QString &title)\n", false, &_init_f_addMenu_3704, &_call_f_addMenu_3704);
}

// QAction *QMenuBar::addSeparator()


static void _init_f_addSeparator_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAction * > ();
}

static void _call_f_addSeparator_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAction * > ((QAction *)((QMenuBar *)cls)->addSeparator ());
}

static qt_gsi::GenericMethod *_create_f_addSeparator_0 ()
{
  return new qt_gsi::GenericMethod ("addSeparator", "@brief Method QAction *QMenuBar::addSeparator()\n", false, &_init_f_addSeparator_0, &_call_f_addSeparator_0);
}

// void QMenuBar::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMenuBar *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QMenuBar::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// QWidget *QMenuBar::cornerWidget(Qt::Corner corner)


static void _init_f_cornerWidget_c1366 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("corner", true, "Qt::TopRightCorner");
  decl->add_arg<const qt_gsi::Converter<Qt::Corner>::target_type & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_cornerWidget_c1366 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Corner>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::Corner>::target_type & > () : (const qt_gsi::Converter<Qt::Corner>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::Corner>(heap, Qt::TopRightCorner));
  ret.write<QWidget * > ((QWidget *)((QMenuBar *)cls)->cornerWidget (qt_gsi::QtToCppAdaptor<Qt::Corner>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_cornerWidget_c1366 ()
{
  return new qt_gsi::GenericMethod ("cornerWidget", "@brief Method QWidget *QMenuBar::cornerWidget(Qt::Corner corner)\n", true, &_init_f_cornerWidget_c1366, &_call_f_cornerWidget_c1366);
}

// int QMenuBar::heightForWidth(int)


static void _init_f_heightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_heightForWidth_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QMenuBar *)cls)->heightForWidth (arg1));
}

static qt_gsi::GenericMethod *_create_f_heightForWidth_c767 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Method int QMenuBar::heightForWidth(int)\nThis is a reimplementation of QWidget::heightForWidth", true, &_init_f_heightForWidth_c767, &_call_f_heightForWidth_c767);
}

// QAction *QMenuBar::insertMenu(QAction *before, QMenu *menu)


static void _init_f_insertMenu_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("menu");
  decl->add_arg<QMenu * > (argspec_1);
  decl->set_return<QAction * > ();
}

static void _call_f_insertMenu_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  QMenu *arg2 = args.read<QMenu * > ();
  ret.write<QAction * > ((QAction *)((QMenuBar *)cls)->insertMenu (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertMenu_2309 ()
{
  return new qt_gsi::GenericMethod ("insertMenu", "@brief Method QAction *QMenuBar::insertMenu(QAction *before, QMenu *menu)\n", false, &_init_f_insertMenu_2309, &_call_f_insertMenu_2309);
}

// QAction *QMenuBar::insertSeparator(QAction *before)


static void _init_f_insertSeparator_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<QAction * > ();
}

static void _call_f_insertSeparator_1309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  ret.write<QAction * > ((QAction *)((QMenuBar *)cls)->insertSeparator (arg1));
}

static qt_gsi::GenericMethod *_create_f_insertSeparator_1309 ()
{
  return new qt_gsi::GenericMethod ("insertSeparator", "@brief Method QAction *QMenuBar::insertSeparator(QAction *before)\n", false, &_init_f_insertSeparator_1309, &_call_f_insertSeparator_1309);
}

// bool QMenuBar::isDefaultUp()


static void _init_f_isDefaultUp_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDefaultUp_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMenuBar *)cls)->isDefaultUp ());
}

static qt_gsi::GenericMethod *_create_f_isDefaultUp_c0 ()
{
  return new qt_gsi::GenericMethod ("isDefaultUp?|:defaultUp", "@brief Method bool QMenuBar::isDefaultUp()\n", true, &_init_f_isDefaultUp_c0, &_call_f_isDefaultUp_c0);
}

// bool QMenuBar::isNativeMenuBar()


static void _init_f_isNativeMenuBar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNativeMenuBar_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMenuBar *)cls)->isNativeMenuBar ());
}

static qt_gsi::GenericMethod *_create_f_isNativeMenuBar_c0 ()
{
  return new qt_gsi::GenericMethod ("isNativeMenuBar?|:nativeMenuBar", "@brief Method bool QMenuBar::isNativeMenuBar()\n", true, &_init_f_isNativeMenuBar_c0, &_call_f_isNativeMenuBar_c0);
}

// QSize QMenuBar::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMenuBar *)cls)->minimumSizeHint ());
}

static qt_gsi::GenericMethod *_create_f_minimumSizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QMenuBar::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
}

// void QMenuBar::setActiveAction(QAction *action)


static void _init_f_setActiveAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveAction_1309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  ((QMenuBar *)cls)->setActiveAction (arg1);
}

static qt_gsi::GenericMethod *_create_f_setActiveAction_1309 ()
{
  return new qt_gsi::GenericMethod ("setActiveAction|activeAction=", "@brief Method void QMenuBar::setActiveAction(QAction *action)\n", false, &_init_f_setActiveAction_1309, &_call_f_setActiveAction_1309);
}

// void QMenuBar::setCornerWidget(QWidget *w, Qt::Corner corner)


static void _init_f_setCornerWidget_2573 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("corner", true, "Qt::TopRightCorner");
  decl->add_arg<const qt_gsi::Converter<Qt::Corner>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCornerWidget_2573 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Corner>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::Corner>::target_type & > () : (const qt_gsi::Converter<Qt::Corner>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::Corner>(heap, Qt::TopRightCorner));
  ((QMenuBar *)cls)->setCornerWidget (arg1, qt_gsi::QtToCppAdaptor<Qt::Corner>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setCornerWidget_2573 ()
{
  return new qt_gsi::GenericMethod ("setCornerWidget", "@brief Method void QMenuBar::setCornerWidget(QWidget *w, Qt::Corner corner)\n", false, &_init_f_setCornerWidget_2573, &_call_f_setCornerWidget_2573);
}

// void QMenuBar::setDefaultUp(bool)


static void _init_f_setDefaultUp_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultUp_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMenuBar *)cls)->setDefaultUp (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDefaultUp_864 ()
{
  return new qt_gsi::GenericMethod ("setDefaultUp|defaultUp=", "@brief Method void QMenuBar::setDefaultUp(bool)\n", false, &_init_f_setDefaultUp_864, &_call_f_setDefaultUp_864);
}

// void QMenuBar::setNativeMenuBar(bool nativeMenuBar)


static void _init_f_setNativeMenuBar_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nativeMenuBar");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNativeMenuBar_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMenuBar *)cls)->setNativeMenuBar (arg1);
}

static qt_gsi::GenericMethod *_create_f_setNativeMenuBar_864 ()
{
  return new qt_gsi::GenericMethod ("setNativeMenuBar|nativeMenuBar=", "@brief Method void QMenuBar::setNativeMenuBar(bool nativeMenuBar)\n", false, &_init_f_setNativeMenuBar_864, &_call_f_setNativeMenuBar_864);
}

// void QMenuBar::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMenuBar *)cls)->setVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QMenuBar::setVisible(bool visible)\nThis is a reimplementation of QWidget::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
}

// QSize QMenuBar::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMenuBar *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QMenuBar::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// static QString QMenuBar::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMenuBar::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMenuBar::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QMenuBar::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMenuBar::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMenuBar::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QMenuBar::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMenuBar::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMenuBar::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QMenuBar::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMenuBar::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMenuBar::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QMenuBar, QMenuBar_EventAdaptor> ea_QMenuBar;

namespace gsi
{
extern gsi::Class<QWidget> decl_QWidget;

gsi::Class<QMenuBar> decl_QMenuBar (ea_QMenuBar, decl_QWidget, "QMenuBar_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_actionAt_c1916 ()) +
  gsi::Methods(_create_f_actionGeometry_c1309 ()) +
  gsi::Methods(_create_f_activeAction_c0 ()) +
  gsi::Methods(_create_f_addAction_1309 ()) +
  gsi::Methods(_create_f_addAction_2025 ()) +
  gsi::Methods(_create_f_addAction_5537 ()) +
  gsi::Methods(_create_f_addMenu_1108 ()) +
  gsi::Methods(_create_f_addMenu_2025 ()) +
  gsi::Methods(_create_f_addMenu_3704 ()) +
  gsi::Methods(_create_f_addSeparator_0 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_cornerWidget_c1366 ()) +
  gsi::Methods(_create_f_heightForWidth_c767 ()) +
  gsi::Methods(_create_f_insertMenu_2309 ()) +
  gsi::Methods(_create_f_insertSeparator_1309 ()) +
  gsi::Methods(_create_f_isDefaultUp_c0 ()) +
  gsi::Methods(_create_f_isNativeMenuBar_c0 ()) +
  gsi::Methods(_create_f_minimumSizeHint_c0 ()) +
  gsi::Methods(_create_f_setActiveAction_1309 ()) +
  gsi::Methods(_create_f_setCornerWidget_2573 ()) +
  gsi::Methods(_create_f_setDefaultUp_864 ()) +
  gsi::Methods(_create_f_setNativeMenuBar_864 ()) +
  gsi::Methods(_create_f_setVisible_864 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  qt_gsi::qt_signal<QMenuBar, QMenuBar_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QMenuBar_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QMenuBar::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMenuBar, QMenuBar_EventAdaptor, QObject *> ("destroyed", &QMenuBar_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QMenuBar::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMenuBar, QMenuBar_EventAdaptor, QAction *> ("hovered", &QMenuBar_EventAdaptor::hovered_e_1309, gsi::arg("action"), "@brief Signal declaration for QMenuBar::hovered(QAction *action)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMenuBar, QMenuBar_EventAdaptor, QAction *> ("triggered", &QMenuBar_EventAdaptor::triggered_e_1309, gsi::arg("action"), "@brief Signal declaration for QMenuBar::triggered(QAction *action)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QMenuBar");
}


class QMenuBar_Adaptor : public QMenuBar, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMenuBar_Adaptor();

  //  [adaptor ctor] QMenuBar::QMenuBar(QWidget *parent)
  QMenuBar_Adaptor() : QMenuBar()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMenuBar::QMenuBar(QWidget *parent)
  QMenuBar_Adaptor(QWidget *parent) : QMenuBar(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QMenuBar::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QMenuBar_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QMenuBar::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QMenuBar::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QMenuBar_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QMenuBar::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QMenuBar::focusNextChild()
  bool fp_QMenuBar_focusNextChild_0 () {
    return QMenuBar::focusNextChild();
  }

  //  bool QMenuBar::focusPreviousChild()
  bool fp_QMenuBar_focusPreviousChild_0 () {
    return QMenuBar::focusPreviousChild();
  }

  //  void QMenuBar::initStyleOption(QStyleOptionMenuItem *option, const QAction *action)
  void fp_QMenuBar_initStyleOption_c4565 (QStyleOptionMenuItem *option, const QAction *action) const {
    QMenuBar::initStyleOption(option, action);
  }

  //  int QMenuBar::receivers(const char *signal)
  int fp_QMenuBar_receivers_c1731 (const char *signal) const {
    return QMenuBar::receivers(signal);
  }

  //  void QMenuBar::resetInputContext()
  void fp_QMenuBar_resetInputContext_0 () {
    QMenuBar::resetInputContext();
  }

  //  QObject *QMenuBar::sender()
  QObject * fp_QMenuBar_sender_c0 () const {
    return QMenuBar::sender();
  }

  //  void QMenuBar::updateMicroFocus()
  void fp_QMenuBar_updateMicroFocus_0 () {
    QMenuBar::updateMicroFocus();
  }

  //  [adaptor impl] int QMenuBar::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QMenuBar::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QMenuBar_Adaptor, int, int>(&QMenuBar_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QMenuBar::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QMenuBar::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QMenuBar::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QMenuBar_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QMenuBar_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QMenuBar::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QMenuBar::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QMenuBar::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QMenuBar_Adaptor, QSize>(&QMenuBar_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QMenuBar::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QMenuBar::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QMenuBar::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QMenuBar_Adaptor, QPaintEngine *>(&QMenuBar_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QMenuBar::paintEngine();
    }
  }

  //  [adaptor impl] void QMenuBar::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QMenuBar::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QMenuBar_Adaptor, bool>(&QMenuBar_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QMenuBar::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QMenuBar::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QMenuBar::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QMenuBar_Adaptor, QSize>(&QMenuBar_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QMenuBar::sizeHint();
    }
  }

  //  [adaptor impl] void QMenuBar::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QMenuBar::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QMenuBar_Adaptor, QActionEvent *>(&QMenuBar_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QMenuBar::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QMenuBar::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QMenuBar_Adaptor, QEvent *>(&QMenuBar_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QMenuBar::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMenuBar::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMenuBar_Adaptor, QChildEvent *>(&QMenuBar_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMenuBar::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QMenuBar::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QMenuBar_Adaptor, QCloseEvent *>(&QMenuBar_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QMenuBar::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QMenuBar::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QMenuBar_Adaptor, QContextMenuEvent *>(&QMenuBar_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QMenuBar::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMenuBar::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMenuBar_Adaptor, QEvent *>(&QMenuBar_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMenuBar::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QMenuBar::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QMenuBar_Adaptor, const char *>(&QMenuBar_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QMenuBar::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMenuBar::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QMenuBar::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QMenuBar_Adaptor, QDragEnterEvent *>(&QMenuBar_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QMenuBar::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QMenuBar::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QMenuBar_Adaptor, QDragLeaveEvent *>(&QMenuBar_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QMenuBar::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QMenuBar::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QMenuBar_Adaptor, QDragMoveEvent *>(&QMenuBar_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QMenuBar::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QMenuBar::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QMenuBar_Adaptor, QDropEvent *>(&QMenuBar_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QMenuBar::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QMenuBar::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QMenuBar_Adaptor, bool>(&QMenuBar_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QMenuBar::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QMenuBar::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QMenuBar_Adaptor, QEvent *>(&QMenuBar_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QMenuBar::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QMenuBar::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QMenuBar::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMenuBar_Adaptor, bool, QEvent *>(&QMenuBar_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QMenuBar::event(arg1);
    }
  }

  //  [adaptor impl] bool QMenuBar::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMenuBar::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMenuBar_Adaptor, bool, QObject *, QEvent *>(&QMenuBar_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMenuBar::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QMenuBar::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QMenuBar::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QMenuBar_Adaptor, QFocusEvent *>(&QMenuBar_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QMenuBar::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QMenuBar::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QMenuBar::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QMenuBar_Adaptor, bool, bool>(&QMenuBar_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QMenuBar::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QMenuBar::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QMenuBar::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QMenuBar_Adaptor, QFocusEvent *>(&QMenuBar_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QMenuBar::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QMenuBar::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QMenuBar_Adaptor, const QFont &>(&QMenuBar_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QMenuBar::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QMenuBar::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QMenuBar_Adaptor, QHideEvent *>(&QMenuBar_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QMenuBar::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QMenuBar::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QMenuBar_Adaptor, QInputMethodEvent *>(&QMenuBar_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QMenuBar::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QMenuBar::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QMenuBar_Adaptor, QKeyEvent *>(&QMenuBar_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QMenuBar::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QMenuBar::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QMenuBar_Adaptor, QKeyEvent *>(&QMenuBar_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QMenuBar::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::languageChange()
  void cbs_languageChange_0_0()
  {
    QMenuBar::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QMenuBar_Adaptor>(&QMenuBar_Adaptor::cbs_languageChange_0_0);
    } else {
      QMenuBar::languageChange();
    }
  }

  //  [adaptor impl] void QMenuBar::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QMenuBar::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QMenuBar_Adaptor, QEvent *>(&QMenuBar_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QMenuBar::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QMenuBar::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QMenuBar::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QMenuBar_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QMenuBar_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QMenuBar::metric(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QMenuBar::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QMenuBar_Adaptor, QMouseEvent *>(&QMenuBar_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QMenuBar::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QMenuBar::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QMenuBar_Adaptor, QMouseEvent *>(&QMenuBar_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QMenuBar::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QMenuBar::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QMenuBar_Adaptor, QMouseEvent *>(&QMenuBar_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QMenuBar::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QMenuBar::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QMenuBar_Adaptor, QMouseEvent *>(&QMenuBar_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QMenuBar::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QMenuBar::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QMenuBar_Adaptor, QMoveEvent *>(&QMenuBar_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QMenuBar::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QMenuBar::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QMenuBar_Adaptor, QPaintEvent *>(&QMenuBar_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QMenuBar::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QMenuBar::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QMenuBar_Adaptor, const QPalette &>(&QMenuBar_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QMenuBar::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QMenuBar::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QMenuBar_Adaptor, QResizeEvent *>(&QMenuBar_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QMenuBar::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QMenuBar::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QMenuBar_Adaptor, QShowEvent *>(&QMenuBar_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QMenuBar::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QMenuBar::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QMenuBar_Adaptor, QStyle &>(&QMenuBar_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QMenuBar::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QMenuBar::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QMenuBar_Adaptor, QTabletEvent *>(&QMenuBar_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QMenuBar::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QMenuBar::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMenuBar_Adaptor, QTimerEvent *>(&QMenuBar_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QMenuBar::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QMenuBar::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QMenuBar_Adaptor, QWheelEvent *>(&QMenuBar_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QMenuBar::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QMenuBar::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QMenuBar::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QMenuBar_Adaptor, bool>(&QMenuBar_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QMenuBar::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QMenuBar_Adaptor::~QMenuBar_Adaptor() { }

//  Constructor QMenuBar::QMenuBar(QWidget *parent) (adaptor class)

static void _init_ctor_QMenuBar_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QMenuBar_Adaptor *> ();
}

static void _call_ctor_QMenuBar_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QMenuBar_Adaptor *> (new QMenuBar_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMenuBar_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMenuBar::QMenuBar(QWidget *parent)\nThis method creates an object of class QMenuBar.", &_init_ctor_QMenuBar_Adaptor_1315, &_call_ctor_QMenuBar_Adaptor_1315);
}

// void QMenuBar::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QMenuBar_Adaptor *)cls)->fp_QMenuBar_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QMenuBar::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QMenuBar::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QMenuBar_Adaptor *)cls)->fp_QMenuBar_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QMenuBar::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QMenuBar::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMenuBar_Adaptor *)cls)->fp_QMenuBar_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QMenuBar::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QMenuBar::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMenuBar_Adaptor *)cls)->fp_QMenuBar_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QMenuBar::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// void QMenuBar::initStyleOption(QStyleOptionMenuItem *option, const QAction *action)

static void _init_fp_initStyleOption_c4565 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionMenuItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const QAction * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c4565 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyleOptionMenuItem *arg1 = args.read<QStyleOptionMenuItem * > ();
  const QAction *arg2 = args.read<const QAction * > ();
  ((QMenuBar_Adaptor *)cls)->fp_QMenuBar_initStyleOption_c4565 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_initStyleOption_c4565 ()
{
  return new qt_gsi::GenericMethod("*initStyleOption", "@brief Method void QMenuBar::initStyleOption(QStyleOptionMenuItem *option, const QAction *action)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c4565, &_call_fp_initStyleOption_c4565);
}


// int QMenuBar::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QMenuBar_Adaptor *)cls)->fp_QMenuBar_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QMenuBar::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QMenuBar::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMenuBar_Adaptor *)cls)->fp_QMenuBar_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QMenuBar::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QMenuBar::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QMenuBar_Adaptor *)cls)->fp_QMenuBar_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QMenuBar::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QMenuBar::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMenuBar_Adaptor *)cls)->fp_QMenuBar_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QMenuBar::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// int QMenuBar::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QMenuBar_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QMenuBar::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QMenuBar::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QMenuBar_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QMenuBar::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QMenuBar::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMenuBar_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QMenuBar::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QMenuBar::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QMenuBar_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QMenuBar::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QMenuBar::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMenuBar_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QMenuBar::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QMenuBar::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMenuBar_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QMenuBar::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QMenuBar::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QMenuBar::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QMenuBar::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QMenuBar::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QMenuBar::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMenuBar::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QMenuBar::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QMenuBar::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QMenuBar::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QMenuBar::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QMenuBar::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMenuBar::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QMenuBar::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMenuBar::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QMenuBar::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QMenuBar::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QMenuBar::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QMenuBar::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QMenuBar::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QMenuBar::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QMenuBar::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QMenuBar::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QMenuBar::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMenuBar_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QMenuBar::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QMenuBar::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QMenuBar::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QMenuBar::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMenuBar_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QMenuBar::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QMenuBar::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMenuBar_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QMenuBar::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QMenuBar::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QMenuBar::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QMenuBar::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QMenuBar_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QMenuBar::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QMenuBar::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QMenuBar::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QMenuBar::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QMenuBar_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QMenuBar::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QMenuBar::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QMenuBar::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QMenuBar::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QMenuBar::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QMenuBar::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QMenuBar::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QMenuBar::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QMenuBar::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QMenuBar::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMenuBar_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QMenuBar::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QMenuBar::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QMenuBar::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QMenuBar::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QMenuBar_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QMenuBar::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QMenuBar::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QMenuBar::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QMenuBar::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QMenuBar::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QMenuBar::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QMenuBar::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QMenuBar::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QMenuBar::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QMenuBar::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QMenuBar::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QMenuBar::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QMenuBar::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QMenuBar::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QMenuBar_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QMenuBar::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QMenuBar::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QMenuBar::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QMenuBar::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QMenuBar::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QMenuBar::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QMenuBar_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QMenuBar::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QMenuBar::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QMenuBar::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QMenuBar::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMenuBar::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QMenuBar::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QMenuBar_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QMenuBar::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QMenuBar::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMenuBar_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMenuBar_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QMenuBar::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QMenuBar> decl_QMenuBar;

gsi::Class<QMenuBar_Adaptor> decl_QMenuBar_Adaptor (decl_QMenuBar, "QMenuBar",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_initStyleOption_c4565 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QMenuBar_Adaptor_1315 ()),
  "@qt\n@brief Binding of QMenuBar");

}

