
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMdiArea.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQMdiArea_EventAdaptor.h"
#include "gsiDeclQMdiArea_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMdiArea

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMdiArea::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QMdiArea::activateNextSubWindow()


static void _init_f_activateNextSubWindow_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_activateNextSubWindow_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMdiArea *)cls)->activateNextSubWindow ();
}

static qt_gsi::GenericMethod *_create_f_activateNextSubWindow_0 ()
{
  return new qt_gsi::GenericMethod ("activateNextSubWindow", "@brief Method void QMdiArea::activateNextSubWindow()\n", false, &_init_f_activateNextSubWindow_0, &_call_f_activateNextSubWindow_0);
}

// void QMdiArea::activatePreviousSubWindow()


static void _init_f_activatePreviousSubWindow_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_activatePreviousSubWindow_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMdiArea *)cls)->activatePreviousSubWindow ();
}

static qt_gsi::GenericMethod *_create_f_activatePreviousSubWindow_0 ()
{
  return new qt_gsi::GenericMethod ("activatePreviousSubWindow", "@brief Method void QMdiArea::activatePreviousSubWindow()\n", false, &_init_f_activatePreviousSubWindow_0, &_call_f_activatePreviousSubWindow_0);
}

// QMdiArea::WindowOrder QMdiArea::activationOrder()


static void _init_f_activationOrder_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMdiArea::WindowOrder>::target_type > ();
}

static void _call_f_activationOrder_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QMdiArea::WindowOrder>::target_type > ((qt_gsi::Converter<QMdiArea::WindowOrder>::target_type)qt_gsi::CppToQtAdaptor<QMdiArea::WindowOrder>(((QMdiArea *)cls)->activationOrder ()));
}

static qt_gsi::GenericMethod *_create_f_activationOrder_c0 ()
{
  return new qt_gsi::GenericMethod (":activationOrder", "@brief Method QMdiArea::WindowOrder QMdiArea::activationOrder()\n", true, &_init_f_activationOrder_c0, &_call_f_activationOrder_c0);
}

// QMdiSubWindow *QMdiArea::activeSubWindow()


static void _init_f_activeSubWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMdiSubWindow * > ();
}

static void _call_f_activeSubWindow_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMdiSubWindow * > ((QMdiSubWindow *)((QMdiArea *)cls)->activeSubWindow ());
}

static qt_gsi::GenericMethod *_create_f_activeSubWindow_c0 ()
{
  return new qt_gsi::GenericMethod (":activeSubWindow", "@brief Method QMdiSubWindow *QMdiArea::activeSubWindow()\n", true, &_init_f_activeSubWindow_c0, &_call_f_activeSubWindow_c0);
}

// QMdiSubWindow *QMdiArea::addSubWindow(QWidget *widget, QFlags<Qt::WindowType> flags)


static void _init_f_addSubWindow_3702 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return<QMdiSubWindow * > ();
}

static void _call_f_addSubWindow_3702 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QMdiSubWindow * > ((QMdiSubWindow *)((QMdiArea *)cls)->addSubWindow (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_addSubWindow_3702 ()
{
  return new qt_gsi::GenericMethod ("addSubWindow", "@brief Method QMdiSubWindow *QMdiArea::addSubWindow(QWidget *widget, QFlags<Qt::WindowType> flags)\n", false, &_init_f_addSubWindow_3702, &_call_f_addSubWindow_3702);
}

// QBrush QMdiArea::background()


static void _init_f_background_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_background_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QMdiArea *)cls)->background ());
}

static qt_gsi::GenericMethod *_create_f_background_c0 ()
{
  return new qt_gsi::GenericMethod (":background", "@brief Method QBrush QMdiArea::background()\n", true, &_init_f_background_c0, &_call_f_background_c0);
}

// void QMdiArea::cascadeSubWindows()


static void _init_f_cascadeSubWindows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cascadeSubWindows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMdiArea *)cls)->cascadeSubWindows ();
}

static qt_gsi::GenericMethod *_create_f_cascadeSubWindows_0 ()
{
  return new qt_gsi::GenericMethod ("cascadeSubWindows", "@brief Method void QMdiArea::cascadeSubWindows()\n", false, &_init_f_cascadeSubWindows_0, &_call_f_cascadeSubWindows_0);
}

// void QMdiArea::closeActiveSubWindow()


static void _init_f_closeActiveSubWindow_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeActiveSubWindow_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMdiArea *)cls)->closeActiveSubWindow ();
}

static qt_gsi::GenericMethod *_create_f_closeActiveSubWindow_0 ()
{
  return new qt_gsi::GenericMethod ("closeActiveSubWindow", "@brief Method void QMdiArea::closeActiveSubWindow()\n", false, &_init_f_closeActiveSubWindow_0, &_call_f_closeActiveSubWindow_0);
}

// void QMdiArea::closeAllSubWindows()


static void _init_f_closeAllSubWindows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeAllSubWindows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMdiArea *)cls)->closeAllSubWindows ();
}

static qt_gsi::GenericMethod *_create_f_closeAllSubWindows_0 ()
{
  return new qt_gsi::GenericMethod ("closeAllSubWindows", "@brief Method void QMdiArea::closeAllSubWindows()\n", false, &_init_f_closeAllSubWindows_0, &_call_f_closeAllSubWindows_0);
}

// QMdiSubWindow *QMdiArea::currentSubWindow()


static void _init_f_currentSubWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMdiSubWindow * > ();
}

static void _call_f_currentSubWindow_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMdiSubWindow * > ((QMdiSubWindow *)((QMdiArea *)cls)->currentSubWindow ());
}

static qt_gsi::GenericMethod *_create_f_currentSubWindow_c0 ()
{
  return new qt_gsi::GenericMethod ("currentSubWindow", "@brief Method QMdiSubWindow *QMdiArea::currentSubWindow()\n", true, &_init_f_currentSubWindow_c0, &_call_f_currentSubWindow_c0);
}

// bool QMdiArea::documentMode()


static void _init_f_documentMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_documentMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMdiArea *)cls)->documentMode ());
}

static qt_gsi::GenericMethod *_create_f_documentMode_c0 ()
{
  return new qt_gsi::GenericMethod (":documentMode", "@brief Method bool QMdiArea::documentMode()\n", true, &_init_f_documentMode_c0, &_call_f_documentMode_c0);
}

// QSize QMdiArea::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMdiArea *)cls)->minimumSizeHint ());
}

static qt_gsi::GenericMethod *_create_f_minimumSizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QMdiArea::minimumSizeHint()\nThis is a reimplementation of QAbstractScrollArea::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
}

// void QMdiArea::removeSubWindow(QWidget *widget)


static void _init_f_removeSubWindow_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeSubWindow_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QMdiArea *)cls)->removeSubWindow (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeSubWindow_1315 ()
{
  return new qt_gsi::GenericMethod ("removeSubWindow", "@brief Method void QMdiArea::removeSubWindow(QWidget *widget)\n", false, &_init_f_removeSubWindow_1315, &_call_f_removeSubWindow_1315);
}

// void QMdiArea::setActivationOrder(QMdiArea::WindowOrder order)


static void _init_f_setActivationOrder_2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("order");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActivationOrder_2432 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & arg1 = args.read<const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & > ();
  ((QMdiArea *)cls)->setActivationOrder (qt_gsi::QtToCppAdaptor<QMdiArea::WindowOrder>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setActivationOrder_2432 ()
{
  return new qt_gsi::GenericMethod ("setActivationOrder|activationOrder=", "@brief Method void QMdiArea::setActivationOrder(QMdiArea::WindowOrder order)\n", false, &_init_f_setActivationOrder_2432, &_call_f_setActivationOrder_2432);
}

// void QMdiArea::setActiveSubWindow(QMdiSubWindow *window)


static void _init_f_setActiveSubWindow_1915 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("window");
  decl->add_arg<QMdiSubWindow * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveSubWindow_1915 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMdiSubWindow *arg1 = args.read<QMdiSubWindow * > ();
  ((QMdiArea *)cls)->setActiveSubWindow (arg1);
}

static qt_gsi::GenericMethod *_create_f_setActiveSubWindow_1915 ()
{
  return new qt_gsi::GenericMethod ("setActiveSubWindow|activeSubWindow=", "@brief Method void QMdiArea::setActiveSubWindow(QMdiSubWindow *window)\n", false, &_init_f_setActiveSubWindow_1915, &_call_f_setActiveSubWindow_1915);
}

// void QMdiArea::setBackground(const QBrush &background)


static void _init_f_setBackground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("background");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackground_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QMdiArea *)cls)->setBackground (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBackground_1910 ()
{
  return new qt_gsi::GenericMethod ("setBackground|background=", "@brief Method void QMdiArea::setBackground(const QBrush &background)\n", false, &_init_f_setBackground_1910, &_call_f_setBackground_1910);
}

// void QMdiArea::setDocumentMode(bool enabled)


static void _init_f_setDocumentMode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentMode_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMdiArea *)cls)->setDocumentMode (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDocumentMode_864 ()
{
  return new qt_gsi::GenericMethod ("setDocumentMode|documentMode=", "@brief Method void QMdiArea::setDocumentMode(bool enabled)\n", false, &_init_f_setDocumentMode_864, &_call_f_setDocumentMode_864);
}

// void QMdiArea::setOption(QMdiArea::AreaOption option, bool on)


static void _init_f_setOption_3058 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_3058 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QMdiArea *)cls)->setOption (qt_gsi::QtToCppAdaptor<QMdiArea::AreaOption>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setOption_3058 ()
{
  return new qt_gsi::GenericMethod ("setOption", "@brief Method void QMdiArea::setOption(QMdiArea::AreaOption option, bool on)\n", false, &_init_f_setOption_3058, &_call_f_setOption_3058);
}

// void QMdiArea::setTabPosition(QTabWidget::TabPosition position)


static void _init_f_setTabPosition_2656 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabPosition_2656 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & arg1 = args.read<const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & > ();
  ((QMdiArea *)cls)->setTabPosition (qt_gsi::QtToCppAdaptor<QTabWidget::TabPosition>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTabPosition_2656 ()
{
  return new qt_gsi::GenericMethod ("setTabPosition|tabPosition=", "@brief Method void QMdiArea::setTabPosition(QTabWidget::TabPosition position)\n", false, &_init_f_setTabPosition_2656, &_call_f_setTabPosition_2656);
}

// void QMdiArea::setTabShape(QTabWidget::TabShape shape)


static void _init_f_setTabShape_2300 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("shape");
  decl->add_arg<const qt_gsi::Converter<QTabWidget::TabShape>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabShape_2300 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTabWidget::TabShape>::target_type & arg1 = args.read<const qt_gsi::Converter<QTabWidget::TabShape>::target_type & > ();
  ((QMdiArea *)cls)->setTabShape (qt_gsi::QtToCppAdaptor<QTabWidget::TabShape>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTabShape_2300 ()
{
  return new qt_gsi::GenericMethod ("setTabShape|tabShape=", "@brief Method void QMdiArea::setTabShape(QTabWidget::TabShape shape)\n", false, &_init_f_setTabShape_2300, &_call_f_setTabShape_2300);
}

// void QMdiArea::setViewMode(QMdiArea::ViewMode mode)


static void _init_f_setViewMode_2092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::ViewMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewMode_2092 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMdiArea::ViewMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QMdiArea::ViewMode>::target_type & > ();
  ((QMdiArea *)cls)->setViewMode (qt_gsi::QtToCppAdaptor<QMdiArea::ViewMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setViewMode_2092 ()
{
  return new qt_gsi::GenericMethod ("setViewMode|viewMode=", "@brief Method void QMdiArea::setViewMode(QMdiArea::ViewMode mode)\n", false, &_init_f_setViewMode_2092, &_call_f_setViewMode_2092);
}

// QSize QMdiArea::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMdiArea *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QMdiArea::sizeHint()\nThis is a reimplementation of QAbstractScrollArea::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// QList<QMdiSubWindow *> QMdiArea::subWindowList(QMdiArea::WindowOrder order)


static void _init_f_subWindowList_c2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("order", true, "QMdiArea::CreationOrder");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QMdiSubWindow *> >::target_type > ();
}

static void _call_f_subWindowList_c2432 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type & > () : (const qt_gsi::Converter<QMdiArea::WindowOrder>::target_type &)(qt_gsi::CppToQtReadAdaptor<QMdiArea::WindowOrder>(heap, QMdiArea::CreationOrder));
  ret.write<qt_gsi::Converter<QList<QMdiSubWindow *> >::target_type > ((qt_gsi::Converter<QList<QMdiSubWindow *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QMdiSubWindow *> >(((QMdiArea *)cls)->subWindowList (qt_gsi::QtToCppAdaptor<QMdiArea::WindowOrder>(arg1).cref())));
}

static qt_gsi::GenericMethod *_create_f_subWindowList_c2432 ()
{
  return new qt_gsi::GenericMethod ("subWindowList", "@brief Method QList<QMdiSubWindow *> QMdiArea::subWindowList(QMdiArea::WindowOrder order)\n", true, &_init_f_subWindowList_c2432, &_call_f_subWindowList_c2432);
}

// QTabWidget::TabPosition QMdiArea::tabPosition()


static void _init_f_tabPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTabWidget::TabPosition>::target_type > ();
}

static void _call_f_tabPosition_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTabWidget::TabPosition>::target_type > ((qt_gsi::Converter<QTabWidget::TabPosition>::target_type)qt_gsi::CppToQtAdaptor<QTabWidget::TabPosition>(((QMdiArea *)cls)->tabPosition ()));
}

static qt_gsi::GenericMethod *_create_f_tabPosition_c0 ()
{
  return new qt_gsi::GenericMethod (":tabPosition", "@brief Method QTabWidget::TabPosition QMdiArea::tabPosition()\n", true, &_init_f_tabPosition_c0, &_call_f_tabPosition_c0);
}

// QTabWidget::TabShape QMdiArea::tabShape()


static void _init_f_tabShape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTabWidget::TabShape>::target_type > ();
}

static void _call_f_tabShape_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTabWidget::TabShape>::target_type > ((qt_gsi::Converter<QTabWidget::TabShape>::target_type)qt_gsi::CppToQtAdaptor<QTabWidget::TabShape>(((QMdiArea *)cls)->tabShape ()));
}

static qt_gsi::GenericMethod *_create_f_tabShape_c0 ()
{
  return new qt_gsi::GenericMethod (":tabShape", "@brief Method QTabWidget::TabShape QMdiArea::tabShape()\n", true, &_init_f_tabShape_c0, &_call_f_tabShape_c0);
}

// bool QMdiArea::testOption(QMdiArea::AreaOption opton)


static void _init_f_testOption_c2302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opton");
  decl->add_arg<const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c2302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QMdiArea::AreaOption>::target_type & > ();
  ret.write<bool > ((bool)((QMdiArea *)cls)->testOption (qt_gsi::QtToCppAdaptor<QMdiArea::AreaOption>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_testOption_c2302 ()
{
  return new qt_gsi::GenericMethod ("testOption", "@brief Method bool QMdiArea::testOption(QMdiArea::AreaOption opton)\n", true, &_init_f_testOption_c2302, &_call_f_testOption_c2302);
}

// void QMdiArea::tileSubWindows()


static void _init_f_tileSubWindows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_tileSubWindows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMdiArea *)cls)->tileSubWindows ();
}

static qt_gsi::GenericMethod *_create_f_tileSubWindows_0 ()
{
  return new qt_gsi::GenericMethod ("tileSubWindows", "@brief Method void QMdiArea::tileSubWindows()\n", false, &_init_f_tileSubWindows_0, &_call_f_tileSubWindows_0);
}

// QMdiArea::ViewMode QMdiArea::viewMode()


static void _init_f_viewMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMdiArea::ViewMode>::target_type > ();
}

static void _call_f_viewMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QMdiArea::ViewMode>::target_type > ((qt_gsi::Converter<QMdiArea::ViewMode>::target_type)qt_gsi::CppToQtAdaptor<QMdiArea::ViewMode>(((QMdiArea *)cls)->viewMode ()));
}

static qt_gsi::GenericMethod *_create_f_viewMode_c0 ()
{
  return new qt_gsi::GenericMethod (":viewMode", "@brief Method QMdiArea::ViewMode QMdiArea::viewMode()\n", true, &_init_f_viewMode_c0, &_call_f_viewMode_c0);
}

// static QString QMdiArea::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMdiArea::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMdiArea::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QMdiArea::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMdiArea::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMdiArea::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QMdiArea::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMdiArea::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMdiArea::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QMdiArea::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMdiArea::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMdiArea::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QMdiArea, QMdiArea_EventAdaptor> ea_QMdiArea;

namespace gsi
{
extern gsi::Class<QAbstractScrollArea> decl_QAbstractScrollArea;

gsi::Class<QMdiArea> decl_QMdiArea (ea_QMdiArea, decl_QAbstractScrollArea, "QMdiArea_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_activateNextSubWindow_0 ()) +
  gsi::Methods(_create_f_activatePreviousSubWindow_0 ()) +
  gsi::Methods(_create_f_activationOrder_c0 ()) +
  gsi::Methods(_create_f_activeSubWindow_c0 ()) +
  gsi::Methods(_create_f_addSubWindow_3702 ()) +
  gsi::Methods(_create_f_background_c0 ()) +
  gsi::Methods(_create_f_cascadeSubWindows_0 ()) +
  gsi::Methods(_create_f_closeActiveSubWindow_0 ()) +
  gsi::Methods(_create_f_closeAllSubWindows_0 ()) +
  gsi::Methods(_create_f_currentSubWindow_c0 ()) +
  gsi::Methods(_create_f_documentMode_c0 ()) +
  gsi::Methods(_create_f_minimumSizeHint_c0 ()) +
  gsi::Methods(_create_f_removeSubWindow_1315 ()) +
  gsi::Methods(_create_f_setActivationOrder_2432 ()) +
  gsi::Methods(_create_f_setActiveSubWindow_1915 ()) +
  gsi::Methods(_create_f_setBackground_1910 ()) +
  gsi::Methods(_create_f_setDocumentMode_864 ()) +
  gsi::Methods(_create_f_setOption_3058 ()) +
  gsi::Methods(_create_f_setTabPosition_2656 ()) +
  gsi::Methods(_create_f_setTabShape_2300 ()) +
  gsi::Methods(_create_f_setViewMode_2092 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_subWindowList_c2432 ()) +
  gsi::Methods(_create_f_tabPosition_c0 ()) +
  gsi::Methods(_create_f_tabShape_c0 ()) +
  gsi::Methods(_create_f_testOption_c2302 ()) +
  gsi::Methods(_create_f_tileSubWindows_0 ()) +
  gsi::Methods(_create_f_viewMode_c0 ()) +
  qt_gsi::qt_signal<QMdiArea, QMdiArea_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QMdiArea_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QMdiArea::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMdiArea, QMdiArea_EventAdaptor, QObject *> ("destroyed", &QMdiArea_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QMdiArea::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMdiArea, QMdiArea_EventAdaptor, QMdiSubWindow *> ("subWindowActivated", &QMdiArea_EventAdaptor::subWindowActivated_e_1915, gsi::arg("arg1"), "@brief Signal declaration for QMdiArea::subWindowActivated(QMdiSubWindow *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QMdiArea");
}


class QMdiArea_Adaptor : public QMdiArea, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMdiArea_Adaptor();

  //  [adaptor ctor] QMdiArea::QMdiArea(QWidget *parent)
  QMdiArea_Adaptor() : QMdiArea()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMdiArea::QMdiArea(QWidget *parent)
  QMdiArea_Adaptor(QWidget *parent) : QMdiArea(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QMdiArea::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QMdiArea_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QMdiArea::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QMdiArea::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QMdiArea_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QMdiArea::destroy(destroyWindow, destroySubWindows);
  }

  //  void QMdiArea::drawFrame(QPainter *)
  void fp_QMdiArea_drawFrame_1426 (QPainter *arg1) {
    QMdiArea::drawFrame(arg1);
  }

  //  bool QMdiArea::focusNextChild()
  bool fp_QMdiArea_focusNextChild_0 () {
    return QMdiArea::focusNextChild();
  }

  //  bool QMdiArea::focusPreviousChild()
  bool fp_QMdiArea_focusPreviousChild_0 () {
    return QMdiArea::focusPreviousChild();
  }

  //  int QMdiArea::receivers(const char *signal)
  int fp_QMdiArea_receivers_c1731 (const char *signal) const {
    return QMdiArea::receivers(signal);
  }

  //  void QMdiArea::resetInputContext()
  void fp_QMdiArea_resetInputContext_0 () {
    QMdiArea::resetInputContext();
  }

  //  QObject *QMdiArea::sender()
  QObject * fp_QMdiArea_sender_c0 () const {
    return QMdiArea::sender();
  }

  //  void QMdiArea::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QMdiArea_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QMdiArea::setViewportMargins(left, top, right, bottom);
  }

  //  void QMdiArea::setViewportMargins(const QMargins &margins)
  void fp_QMdiArea_setViewportMargins_2115 (const QMargins &margins) {
    QMdiArea::setViewportMargins(margins);
  }

  //  void QMdiArea::setupViewport(QWidget *viewport)
  void fp_QMdiArea_setupViewport_1315 (QWidget *viewport) {
    QMdiArea::setupViewport(viewport);
  }

  //  void QMdiArea::updateMicroFocus()
  void fp_QMdiArea_updateMicroFocus_0 () {
    QMdiArea::updateMicroFocus();
  }

  //  [adaptor impl] int QMdiArea::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QMdiArea::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QMdiArea_Adaptor, int, int>(&QMdiArea_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QMdiArea::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QMdiArea::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QMdiArea::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QMdiArea_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QMdiArea_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QMdiArea::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QMdiArea::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QMdiArea::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QMdiArea_Adaptor, QSize>(&QMdiArea_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QMdiArea::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QMdiArea::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QMdiArea::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QMdiArea_Adaptor, QPaintEngine *>(&QMdiArea_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QMdiArea::paintEngine();
    }
  }

  //  [adaptor impl] void QMdiArea::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QMdiArea::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QMdiArea_Adaptor, bool>(&QMdiArea_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QMdiArea::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QMdiArea::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QMdiArea::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QMdiArea_Adaptor, QSize>(&QMdiArea_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QMdiArea::sizeHint();
    }
  }

  //  [adaptor impl] void QMdiArea::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QMdiArea::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QMdiArea_Adaptor, QActionEvent *>(&QMdiArea_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QMdiArea::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QMdiArea::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QMdiArea_Adaptor, QEvent *>(&QMdiArea_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QMdiArea::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::childEvent(QChildEvent *childEvent)
  void cbs_childEvent_1701_0(QChildEvent *_childEvent)
  {
    QMdiArea::childEvent(_childEvent);
  }

  virtual void childEvent(QChildEvent *_childEvent)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMdiArea_Adaptor, QChildEvent *>(&QMdiArea_Adaptor::cbs_childEvent_1701_0, _childEvent);
    } else {
      QMdiArea::childEvent(_childEvent);
    }
  }

  //  [adaptor impl] void QMdiArea::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QMdiArea::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QMdiArea_Adaptor, QCloseEvent *>(&QMdiArea_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QMdiArea::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QMdiArea::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QMdiArea_Adaptor, QContextMenuEvent *>(&QMdiArea_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QMdiArea::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMdiArea::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMdiArea_Adaptor, QEvent *>(&QMdiArea_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMdiArea::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QMdiArea::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QMdiArea_Adaptor, const char *>(&QMdiArea_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QMdiArea::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMdiArea::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QMdiArea::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QMdiArea_Adaptor, QDragEnterEvent *>(&QMdiArea_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QMdiArea::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QMdiArea::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QMdiArea_Adaptor, QDragLeaveEvent *>(&QMdiArea_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QMdiArea::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QMdiArea::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QMdiArea_Adaptor, QDragMoveEvent *>(&QMdiArea_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QMdiArea::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QMdiArea::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QMdiArea_Adaptor, QDropEvent *>(&QMdiArea_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QMdiArea::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QMdiArea::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QMdiArea_Adaptor, bool>(&QMdiArea_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QMdiArea::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QMdiArea::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QMdiArea_Adaptor, QEvent *>(&QMdiArea_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QMdiArea::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QMdiArea::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMdiArea::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMdiArea_Adaptor, bool, QEvent *>(&QMdiArea_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMdiArea::event(_event);
    }
  }

  //  [adaptor impl] bool QMdiArea::eventFilter(QObject *object, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *object, QEvent *event)
  {
    return QMdiArea::eventFilter(object, event);
  }

  virtual bool eventFilter(QObject *object, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMdiArea_Adaptor, bool, QObject *, QEvent *>(&QMdiArea_Adaptor::cbs_eventFilter_2411_0, object, event);
    } else {
      return QMdiArea::eventFilter(object, event);
    }
  }

  //  [adaptor impl] void QMdiArea::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QMdiArea::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QMdiArea_Adaptor, QFocusEvent *>(&QMdiArea_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QMdiArea::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QMdiArea::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QMdiArea::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QMdiArea_Adaptor, bool, bool>(&QMdiArea_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QMdiArea::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QMdiArea::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QMdiArea::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QMdiArea_Adaptor, QFocusEvent *>(&QMdiArea_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QMdiArea::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QMdiArea::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QMdiArea_Adaptor, const QFont &>(&QMdiArea_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QMdiArea::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QMdiArea::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QMdiArea_Adaptor, QHideEvent *>(&QMdiArea_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QMdiArea::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QMdiArea::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QMdiArea_Adaptor, QInputMethodEvent *>(&QMdiArea_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QMdiArea::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QMdiArea::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QMdiArea_Adaptor, QKeyEvent *>(&QMdiArea_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QMdiArea::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QMdiArea::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QMdiArea_Adaptor, QKeyEvent *>(&QMdiArea_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QMdiArea::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::languageChange()
  void cbs_languageChange_0_0()
  {
    QMdiArea::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QMdiArea_Adaptor>(&QMdiArea_Adaptor::cbs_languageChange_0_0);
    } else {
      QMdiArea::languageChange();
    }
  }

  //  [adaptor impl] void QMdiArea::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QMdiArea::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QMdiArea_Adaptor, QEvent *>(&QMdiArea_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QMdiArea::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QMdiArea::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QMdiArea::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QMdiArea_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QMdiArea_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QMdiArea::metric(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QMdiArea::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QMdiArea_Adaptor, QMouseEvent *>(&QMdiArea_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QMdiArea::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QMdiArea::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QMdiArea_Adaptor, QMouseEvent *>(&QMdiArea_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QMdiArea::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QMdiArea::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QMdiArea_Adaptor, QMouseEvent *>(&QMdiArea_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QMdiArea::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QMdiArea::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QMdiArea_Adaptor, QMouseEvent *>(&QMdiArea_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QMdiArea::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QMdiArea::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QMdiArea_Adaptor, QMoveEvent *>(&QMdiArea_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QMdiArea::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::paintEvent(QPaintEvent *paintEvent)
  void cbs_paintEvent_1725_0(QPaintEvent *_paintEvent)
  {
    QMdiArea::paintEvent(_paintEvent);
  }

  virtual void paintEvent(QPaintEvent *_paintEvent)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QMdiArea_Adaptor, QPaintEvent *>(&QMdiArea_Adaptor::cbs_paintEvent_1725_0, _paintEvent);
    } else {
      QMdiArea::paintEvent(_paintEvent);
    }
  }

  //  [adaptor impl] void QMdiArea::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QMdiArea::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QMdiArea_Adaptor, const QPalette &>(&QMdiArea_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QMdiArea::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::resizeEvent(QResizeEvent *resizeEvent)
  void cbs_resizeEvent_1843_0(QResizeEvent *_resizeEvent)
  {
    QMdiArea::resizeEvent(_resizeEvent);
  }

  virtual void resizeEvent(QResizeEvent *_resizeEvent)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QMdiArea_Adaptor, QResizeEvent *>(&QMdiArea_Adaptor::cbs_resizeEvent_1843_0, _resizeEvent);
    } else {
      QMdiArea::resizeEvent(_resizeEvent);
    }
  }

  //  [adaptor impl] void QMdiArea::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QMdiArea::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QMdiArea_Adaptor, int, int>(&QMdiArea_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QMdiArea::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] void QMdiArea::showEvent(QShowEvent *showEvent)
  void cbs_showEvent_1634_0(QShowEvent *_showEvent)
  {
    QMdiArea::showEvent(_showEvent);
  }

  virtual void showEvent(QShowEvent *_showEvent)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QMdiArea_Adaptor, QShowEvent *>(&QMdiArea_Adaptor::cbs_showEvent_1634_0, _showEvent);
    } else {
      QMdiArea::showEvent(_showEvent);
    }
  }

  //  [adaptor impl] void QMdiArea::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QMdiArea::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QMdiArea_Adaptor, QStyle &>(&QMdiArea_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QMdiArea::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QMdiArea::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QMdiArea_Adaptor, QTabletEvent *>(&QMdiArea_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QMdiArea::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::timerEvent(QTimerEvent *timerEvent)
  void cbs_timerEvent_1730_0(QTimerEvent *_timerEvent)
  {
    QMdiArea::timerEvent(_timerEvent);
  }

  virtual void timerEvent(QTimerEvent *_timerEvent)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMdiArea_Adaptor, QTimerEvent *>(&QMdiArea_Adaptor::cbs_timerEvent_1730_0, _timerEvent);
    } else {
      QMdiArea::timerEvent(_timerEvent);
    }
  }

  //  [adaptor impl] bool QMdiArea::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QMdiArea::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QMdiArea_Adaptor, bool, QEvent *>(&QMdiArea_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QMdiArea::viewportEvent(event);
    }
  }

  //  [adaptor impl] void QMdiArea::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QMdiArea::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QMdiArea_Adaptor, QWheelEvent *>(&QMdiArea_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QMdiArea::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiArea::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QMdiArea::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QMdiArea_Adaptor, bool>(&QMdiArea_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QMdiArea::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QMdiArea_Adaptor::~QMdiArea_Adaptor() { }

//  Constructor QMdiArea::QMdiArea(QWidget *parent) (adaptor class)

static void _init_ctor_QMdiArea_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QMdiArea_Adaptor *> ();
}

static void _call_ctor_QMdiArea_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QMdiArea_Adaptor *> (new QMdiArea_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMdiArea_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMdiArea::QMdiArea(QWidget *parent)\nThis method creates an object of class QMdiArea.", &_init_ctor_QMdiArea_Adaptor_1315, &_call_ctor_QMdiArea_Adaptor_1315);
}

// void QMdiArea::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QMdiArea::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QMdiArea::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QMdiArea::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// void QMdiArea::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_drawFrame_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawFrame_1426 ()
{
  return new qt_gsi::GenericMethod("*drawFrame", "@brief Method void QMdiArea::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
}


// bool QMdiArea::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QMdiArea::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QMdiArea::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QMdiArea::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QMdiArea::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QMdiArea::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QMdiArea::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QMdiArea::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QMdiArea::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QMdiArea_Adaptor *)cls)->fp_QMdiArea_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QMdiArea::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QMdiArea::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2744 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QMdiArea::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
}


// void QMdiArea::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMargins &arg1 = args.read<const QMargins & > ();
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_setViewportMargins_2115 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2115 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QMdiArea::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
}


// void QMdiArea::setupViewport(QWidget *viewport)

static void _init_fp_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setupViewport_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_setupViewport_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setupViewport_1315 ()
{
  return new qt_gsi::GenericMethod("*setupViewport", "@brief Method void QMdiArea::setupViewport(QWidget *viewport)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setupViewport_1315, &_call_fp_setupViewport_1315);
}


// void QMdiArea::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMdiArea_Adaptor *)cls)->fp_QMdiArea_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QMdiArea::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// int QMdiArea::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QMdiArea_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QMdiArea::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QMdiArea::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QMdiArea_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QMdiArea::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QMdiArea::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMdiArea_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QMdiArea::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QMdiArea::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QMdiArea_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QMdiArea::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QMdiArea::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMdiArea_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QMdiArea::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QMdiArea::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMdiArea_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QMdiArea::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QMdiArea::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QMdiArea::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QMdiArea::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QMdiArea::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QMdiArea::childEvent(QChildEvent *childEvent)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("childEvent");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMdiArea::childEvent(QChildEvent *childEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QMdiArea::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QMdiArea::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QMdiArea::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QMdiArea::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QMdiArea::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMdiArea::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QMdiArea::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMdiArea::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QMdiArea::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QMdiArea::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QMdiArea::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QMdiArea::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QMdiArea::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QMdiArea::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QMdiArea::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QMdiArea::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QMdiArea::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMdiArea_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QMdiArea::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QMdiArea::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QMdiArea::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QMdiArea::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QMdiArea::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QMdiArea::eventFilter(QObject *object, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QMdiArea::eventFilter(QObject *object, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QMdiArea::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QMdiArea::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QMdiArea::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QMdiArea::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QMdiArea::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QMdiArea::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QMdiArea::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QMdiArea_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QMdiArea::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QMdiArea::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QMdiArea::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QMdiArea::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QMdiArea::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QMdiArea::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QMdiArea::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QMdiArea::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QMdiArea::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QMdiArea::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMdiArea_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QMdiArea::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QMdiArea::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QMdiArea::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QMdiArea::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QMdiArea_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QMdiArea::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QMdiArea::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QMdiArea::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QMdiArea::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QMdiArea::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QMdiArea::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QMdiArea::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QMdiArea::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QMdiArea::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QMdiArea::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QMdiArea::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QMdiArea::paintEvent(QPaintEvent *paintEvent)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paintEvent");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QMdiArea::paintEvent(QPaintEvent *paintEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QMdiArea::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QMdiArea_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QMdiArea::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QMdiArea::resizeEvent(QResizeEvent *resizeEvent)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resizeEvent");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QMdiArea::resizeEvent(QResizeEvent *resizeEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QMdiArea::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QMdiArea_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QMdiArea::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
}


// void QMdiArea::showEvent(QShowEvent *showEvent)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("showEvent");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QMdiArea::showEvent(QShowEvent *showEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QMdiArea::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QMdiArea_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QMdiArea::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QMdiArea::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QMdiArea::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QMdiArea::timerEvent(QTimerEvent *timerEvent)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timerEvent");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMdiArea::timerEvent(QTimerEvent *timerEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// bool QMdiArea::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMdiArea_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QMdiArea::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
}


// void QMdiArea::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QMdiArea_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QMdiArea::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QMdiArea::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMdiArea_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiArea_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QMdiArea::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QMdiArea> decl_QMdiArea;

gsi::Class<QMdiArea_Adaptor> decl_QMdiArea_Adaptor (decl_QMdiArea, "QMdiArea",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_drawFrame_1426 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2744 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2115 ()) +
  gsi::Methods(_create_fp_setupViewport_1315 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QMdiArea_Adaptor_1315 ()),
  "@qt\n@brief Binding of QMdiArea");

}


//  Implementation of the enum wrapper class for QMdiArea::AreaOption
namespace qt_gsi
{

static QMdiArea_AreaOption_Enum *c_1_QMdiArea_AreaOption_Enum () { return new QMdiArea_AreaOption_Enum (QMdiArea::DontMaximizeSubWindowOnActivation); }

static gsi::Methods mkdefs_QMdiArea_AreaOption () {
  return
    gsi::constant ("DontMaximizeSubWindowOnActivation", &qt_gsi::c_1_QMdiArea_AreaOption_Enum, "@brief Enum constant QMdiArea::DontMaximizeSubWindowOnActivation");
}

static std::string to_s_QMdiArea_AreaOption_Enum (const QMdiArea_AreaOption_Enum *e)
{
  if (e->value () == QMdiArea::DontMaximizeSubWindowOnActivation) { return tl::sprintf ("DontMaximizeSubWindowOnActivation (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QMdiArea_AreaOption_Enum (const QMdiArea_AreaOption_Enum *e)
{
  return (unsigned int) e->value ();
}

static QMdiArea_AreaOption_Enum *from_i_QMdiArea_AreaOption_Enum (unsigned int i)
{
  return new QMdiArea_AreaOption_Enum ((QMdiArea::AreaOption) i);
}

static bool equalQMdiArea_AreaOption_Enum (const QMdiArea_AreaOption_Enum *e, QMdiArea_AreaOption_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QMdiArea_AreaOption_Enum (const QMdiArea_AreaOption_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QMdiArea_AreaOption_Enums oropQMdiArea_AreaOption_Enums (const QMdiArea_AreaOption_Enums *e, const QMdiArea_AreaOption_Enums &d)
{
  return e->flags () | d.flags ();
}

static QMdiArea_AreaOption_Enums andopQMdiArea_AreaOption_Enums (const QMdiArea_AreaOption_Enums *e, const QMdiArea_AreaOption_Enums &d)
{
  return e->flags () & d.flags ();
}

static QMdiArea_AreaOption_Enums xoropQMdiArea_AreaOption_Enums (const QMdiArea_AreaOption_Enums *e, const QMdiArea_AreaOption_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QMdiArea_AreaOption_Enums (const QMdiArea_AreaOption_Enums *e)
{
  std::string l;
  if (e->testFlag (QMdiArea::DontMaximizeSubWindowOnActivation)) { if (!l.empty ()) l += "|"; l += "DontMaximizeSubWindowOnActivation"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QMdiArea_AreaOption_Enums (const QMdiArea_AreaOption_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QMdiArea_AreaOption_Enums (const QMdiArea_AreaOption_Enums *e, const QMdiArea_AreaOption_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QMdiArea_AreaOption_Enums> decl_QMdiArea_AreaOption_Enums ("QMdiArea_QFlags_AreaOption",
  gsi::method_ext ("|", &qt_gsi::oropQMdiArea_AreaOption_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQMdiArea_AreaOption_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQMdiArea_AreaOption_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMdiArea_AreaOption_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMdiArea_AreaOption_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QMdiArea_AreaOption_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QMdiArea::AreaOption> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QMdiArea_AreaOption_Enum> decl_QMdiArea_AreaOption_Enum (decl_QMdiArea_AreaOption_Enums, "QMdiArea_AreaOption",
  qt_gsi::mkdefs_QMdiArea_AreaOption () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMdiArea_AreaOption_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMdiArea_AreaOption_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQMdiArea_AreaOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QMdiArea_AreaOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QMdiArea_AreaOption_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QMdiArea::AreaOption enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QMdiArea> inject_QMdiArea_AreaOption_Enum_in_parent (qt_gsi::mkdefs_QMdiArea_AreaOption ());
static gsi::ClassExt<QMdiArea> decl_QMdiArea_AreaOption_Enum_as_child (decl_QMdiArea_AreaOption_Enum, "AreaOption");

}


//  Implementation of the enum wrapper class for QMdiArea::ViewMode
namespace qt_gsi
{

static QMdiArea_ViewMode_Enum *c_1_QMdiArea_ViewMode_Enum () { return new QMdiArea_ViewMode_Enum (QMdiArea::SubWindowView); }
static QMdiArea_ViewMode_Enum *c_2_QMdiArea_ViewMode_Enum () { return new QMdiArea_ViewMode_Enum (QMdiArea::TabbedView); }

static gsi::Methods mkdefs_QMdiArea_ViewMode () {
  return
    gsi::constant ("SubWindowView", &qt_gsi::c_1_QMdiArea_ViewMode_Enum, "@brief Enum constant QMdiArea::SubWindowView") +
    gsi::constant ("TabbedView", &qt_gsi::c_2_QMdiArea_ViewMode_Enum, "@brief Enum constant QMdiArea::TabbedView");
}

static std::string to_s_QMdiArea_ViewMode_Enum (const QMdiArea_ViewMode_Enum *e)
{
  if (e->value () == QMdiArea::SubWindowView) { return tl::sprintf ("SubWindowView (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMdiArea::TabbedView) { return tl::sprintf ("TabbedView (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QMdiArea_ViewMode_Enum (const QMdiArea_ViewMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QMdiArea_ViewMode_Enum *from_i_QMdiArea_ViewMode_Enum (unsigned int i)
{
  return new QMdiArea_ViewMode_Enum ((QMdiArea::ViewMode) i);
}

static bool equalQMdiArea_ViewMode_Enum (const QMdiArea_ViewMode_Enum *e, QMdiArea_ViewMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QMdiArea_ViewMode_Enum (const QMdiArea_ViewMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QMdiArea_ViewMode_Enums oropQMdiArea_ViewMode_Enums (const QMdiArea_ViewMode_Enums *e, const QMdiArea_ViewMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QMdiArea_ViewMode_Enums andopQMdiArea_ViewMode_Enums (const QMdiArea_ViewMode_Enums *e, const QMdiArea_ViewMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QMdiArea_ViewMode_Enums xoropQMdiArea_ViewMode_Enums (const QMdiArea_ViewMode_Enums *e, const QMdiArea_ViewMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QMdiArea_ViewMode_Enums (const QMdiArea_ViewMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QMdiArea::SubWindowView)) { if (!l.empty ()) l += "|"; l += "SubWindowView"; }
  if (e->testFlag (QMdiArea::TabbedView)) { if (!l.empty ()) l += "|"; l += "TabbedView"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QMdiArea_ViewMode_Enums (const QMdiArea_ViewMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QMdiArea_ViewMode_Enums (const QMdiArea_ViewMode_Enums *e, const QMdiArea_ViewMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QMdiArea_ViewMode_Enums> decl_QMdiArea_ViewMode_Enums ("QMdiArea_QFlags_ViewMode",
  gsi::method_ext ("|", &qt_gsi::oropQMdiArea_ViewMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQMdiArea_ViewMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQMdiArea_ViewMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMdiArea_ViewMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMdiArea_ViewMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QMdiArea_ViewMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QMdiArea::ViewMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QMdiArea_ViewMode_Enum> decl_QMdiArea_ViewMode_Enum (decl_QMdiArea_ViewMode_Enums, "QMdiArea_ViewMode",
  qt_gsi::mkdefs_QMdiArea_ViewMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMdiArea_ViewMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMdiArea_ViewMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQMdiArea_ViewMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QMdiArea_ViewMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QMdiArea_ViewMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QMdiArea::ViewMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QMdiArea> inject_QMdiArea_ViewMode_Enum_in_parent (qt_gsi::mkdefs_QMdiArea_ViewMode ());
static gsi::ClassExt<QMdiArea> decl_QMdiArea_ViewMode_Enum_as_child (decl_QMdiArea_ViewMode_Enum, "ViewMode");

}


//  Implementation of the enum wrapper class for QMdiArea::WindowOrder
namespace qt_gsi
{

static QMdiArea_WindowOrder_Enum *c_1_QMdiArea_WindowOrder_Enum () { return new QMdiArea_WindowOrder_Enum (QMdiArea::CreationOrder); }
static QMdiArea_WindowOrder_Enum *c_2_QMdiArea_WindowOrder_Enum () { return new QMdiArea_WindowOrder_Enum (QMdiArea::StackingOrder); }
static QMdiArea_WindowOrder_Enum *c_3_QMdiArea_WindowOrder_Enum () { return new QMdiArea_WindowOrder_Enum (QMdiArea::ActivationHistoryOrder); }

static gsi::Methods mkdefs_QMdiArea_WindowOrder () {
  return
    gsi::constant ("CreationOrder", &qt_gsi::c_1_QMdiArea_WindowOrder_Enum, "@brief Enum constant QMdiArea::CreationOrder") +
    gsi::constant ("StackingOrder", &qt_gsi::c_2_QMdiArea_WindowOrder_Enum, "@brief Enum constant QMdiArea::StackingOrder") +
    gsi::constant ("ActivationHistoryOrder", &qt_gsi::c_3_QMdiArea_WindowOrder_Enum, "@brief Enum constant QMdiArea::ActivationHistoryOrder");
}

static std::string to_s_QMdiArea_WindowOrder_Enum (const QMdiArea_WindowOrder_Enum *e)
{
  if (e->value () == QMdiArea::CreationOrder) { return tl::sprintf ("CreationOrder (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMdiArea::StackingOrder) { return tl::sprintf ("StackingOrder (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMdiArea::ActivationHistoryOrder) { return tl::sprintf ("ActivationHistoryOrder (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QMdiArea_WindowOrder_Enum (const QMdiArea_WindowOrder_Enum *e)
{
  return (unsigned int) e->value ();
}

static QMdiArea_WindowOrder_Enum *from_i_QMdiArea_WindowOrder_Enum (unsigned int i)
{
  return new QMdiArea_WindowOrder_Enum ((QMdiArea::WindowOrder) i);
}

static bool equalQMdiArea_WindowOrder_Enum (const QMdiArea_WindowOrder_Enum *e, QMdiArea_WindowOrder_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QMdiArea_WindowOrder_Enum (const QMdiArea_WindowOrder_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QMdiArea_WindowOrder_Enums oropQMdiArea_WindowOrder_Enums (const QMdiArea_WindowOrder_Enums *e, const QMdiArea_WindowOrder_Enums &d)
{
  return e->flags () | d.flags ();
}

static QMdiArea_WindowOrder_Enums andopQMdiArea_WindowOrder_Enums (const QMdiArea_WindowOrder_Enums *e, const QMdiArea_WindowOrder_Enums &d)
{
  return e->flags () & d.flags ();
}

static QMdiArea_WindowOrder_Enums xoropQMdiArea_WindowOrder_Enums (const QMdiArea_WindowOrder_Enums *e, const QMdiArea_WindowOrder_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QMdiArea_WindowOrder_Enums (const QMdiArea_WindowOrder_Enums *e)
{
  std::string l;
  if (e->testFlag (QMdiArea::CreationOrder)) { if (!l.empty ()) l += "|"; l += "CreationOrder"; }
  if (e->testFlag (QMdiArea::StackingOrder)) { if (!l.empty ()) l += "|"; l += "StackingOrder"; }
  if (e->testFlag (QMdiArea::ActivationHistoryOrder)) { if (!l.empty ()) l += "|"; l += "ActivationHistoryOrder"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QMdiArea_WindowOrder_Enums (const QMdiArea_WindowOrder_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QMdiArea_WindowOrder_Enums (const QMdiArea_WindowOrder_Enums *e, const QMdiArea_WindowOrder_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QMdiArea_WindowOrder_Enums> decl_QMdiArea_WindowOrder_Enums ("QMdiArea_QFlags_WindowOrder",
  gsi::method_ext ("|", &qt_gsi::oropQMdiArea_WindowOrder_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQMdiArea_WindowOrder_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQMdiArea_WindowOrder_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMdiArea_WindowOrder_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMdiArea_WindowOrder_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QMdiArea_WindowOrder_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QMdiArea::WindowOrder> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QMdiArea_WindowOrder_Enum> decl_QMdiArea_WindowOrder_Enum (decl_QMdiArea_WindowOrder_Enums, "QMdiArea_WindowOrder",
  qt_gsi::mkdefs_QMdiArea_WindowOrder () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMdiArea_WindowOrder_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMdiArea_WindowOrder_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQMdiArea_WindowOrder_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QMdiArea_WindowOrder_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QMdiArea_WindowOrder_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QMdiArea::WindowOrder enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QMdiArea> inject_QMdiArea_WindowOrder_Enum_in_parent (qt_gsi::mkdefs_QMdiArea_WindowOrder ());
static gsi::ClassExt<QMdiArea> decl_QMdiArea_WindowOrder_Enum_as_child (decl_QMdiArea_WindowOrder_Enum, "WindowOrder");

}

