
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMatrix4x4.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQMatrix4x4_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMatrix4x4

//  Constructor QMatrix4x4::QMatrix4x4()


static void _init_ctor_QMatrix4x4_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QMatrix4x4 *> ();
}

static void _call_ctor_QMatrix4x4_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMatrix4x4 *> (new QMatrix4x4 ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMatrix4x4_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMatrix4x4::QMatrix4x4()\nThis method creates an object of class QMatrix4x4.", &_init_ctor_QMatrix4x4_0, &_call_ctor_QMatrix4x4_0);
}

//  Constructor QMatrix4x4::QMatrix4x4(const double *values)


static void _init_ctor_QMatrix4x4_1952 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("values");
  decl->add_arg<const double * > (argspec_0);
  decl->set_return_new<QMatrix4x4 *> ();
}

static void _call_ctor_QMatrix4x4_1952 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const double *arg1 = args.read<const double * > ();
  ret.write<QMatrix4x4 *> (new QMatrix4x4 (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMatrix4x4_1952 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMatrix4x4::QMatrix4x4(const double *values)\nThis method creates an object of class QMatrix4x4.", &_init_ctor_QMatrix4x4_1952, &_call_ctor_QMatrix4x4_1952);
}

//  Constructor QMatrix4x4::QMatrix4x4(double m11, double m12, double m13, double m14, double m21, double m22, double m23, double m24, double m31, double m32, double m33, double m34, double m41, double m42, double m43, double m44)


static void _init_ctor_QMatrix4x4_15516 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m11");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m12");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("m13");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("m14");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("m21");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("m22");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("m23");
  decl->add_arg<double > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("m24");
  decl->add_arg<double > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("m31");
  decl->add_arg<double > (argspec_8);
  static gsi::ArgSpecBase argspec_9 ("m32");
  decl->add_arg<double > (argspec_9);
  static gsi::ArgSpecBase argspec_10 ("m33");
  decl->add_arg<double > (argspec_10);
  static gsi::ArgSpecBase argspec_11 ("m34");
  decl->add_arg<double > (argspec_11);
  static gsi::ArgSpecBase argspec_12 ("m41");
  decl->add_arg<double > (argspec_12);
  static gsi::ArgSpecBase argspec_13 ("m42");
  decl->add_arg<double > (argspec_13);
  static gsi::ArgSpecBase argspec_14 ("m43");
  decl->add_arg<double > (argspec_14);
  static gsi::ArgSpecBase argspec_15 ("m44");
  decl->add_arg<double > (argspec_15);
  decl->set_return_new<QMatrix4x4 *> ();
}

static void _call_ctor_QMatrix4x4_15516 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  double arg7 = args.read<double > ();
  double arg8 = args.read<double > ();
  double arg9 = args.read<double > ();
  double arg10 = args.read<double > ();
  double arg11 = args.read<double > ();
  double arg12 = args.read<double > ();
  double arg13 = args.read<double > ();
  double arg14 = args.read<double > ();
  double arg15 = args.read<double > ();
  double arg16 = args.read<double > ();
  ret.write<QMatrix4x4 *> (new QMatrix4x4 (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMatrix4x4_15516 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMatrix4x4::QMatrix4x4(double m11, double m12, double m13, double m14, double m21, double m22, double m23, double m24, double m31, double m32, double m33, double m34, double m41, double m42, double m43, double m44)\nThis method creates an object of class QMatrix4x4.", &_init_ctor_QMatrix4x4_15516, &_call_ctor_QMatrix4x4_15516);
}

//  Constructor QMatrix4x4::QMatrix4x4(const double *values, int cols, int rows)


static void _init_ctor_QMatrix4x4_3270 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("values");
  decl->add_arg<const double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cols");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rows");
  decl->add_arg<int > (argspec_2);
  decl->set_return_new<QMatrix4x4 *> ();
}

static void _call_ctor_QMatrix4x4_3270 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const double *arg1 = args.read<const double * > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QMatrix4x4 *> (new QMatrix4x4 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMatrix4x4_3270 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMatrix4x4::QMatrix4x4(const double *values, int cols, int rows)\nThis method creates an object of class QMatrix4x4.", &_init_ctor_QMatrix4x4_3270, &_call_ctor_QMatrix4x4_3270);
}

//  Constructor QMatrix4x4::QMatrix4x4(const QTransform &transform)


static void _init_ctor_QMatrix4x4_2350 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("transform");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return_new<QMatrix4x4 *> ();
}

static void _call_ctor_QMatrix4x4_2350 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  ret.write<QMatrix4x4 *> (new QMatrix4x4 (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMatrix4x4_2350 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMatrix4x4::QMatrix4x4(const QTransform &transform)\nThis method creates an object of class QMatrix4x4.", &_init_ctor_QMatrix4x4_2350, &_call_ctor_QMatrix4x4_2350);
}

//  Constructor QMatrix4x4::QMatrix4x4(const QMatrix &matrix)


static void _init_ctor_QMatrix4x4_2023 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  decl->set_return_new<QMatrix4x4 *> ();
}

static void _call_ctor_QMatrix4x4_2023 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  ret.write<QMatrix4x4 *> (new QMatrix4x4 (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMatrix4x4_2023 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMatrix4x4::QMatrix4x4(const QMatrix &matrix)\nThis method creates an object of class QMatrix4x4.", &_init_ctor_QMatrix4x4_2023, &_call_ctor_QMatrix4x4_2023);
}

// QVector4D QMatrix4x4::column(int index)


static void _init_f_column_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVector4D > ();
}

static void _call_f_column_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QVector4D > ((QVector4D)((QMatrix4x4 *)cls)->column (arg1));
}

static qt_gsi::GenericMethod *_create_f_column_c767 ()
{
  return new qt_gsi::GenericMethod ("column", "@brief Method QVector4D QMatrix4x4::column(int index)\n", true, &_init_f_column_c767, &_call_f_column_c767);
}

// const double *QMatrix4x4::constData()


static void _init_f_constData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const double * > ();
}

static void _call_f_constData_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const double * > ((const double *)((QMatrix4x4 *)cls)->constData ());
}

static qt_gsi::GenericMethod *_create_f_constData_c0 ()
{
  return new qt_gsi::GenericMethod ("constData", "@brief Method const double *QMatrix4x4::constData()\n", true, &_init_f_constData_c0, &_call_f_constData_c0);
}

// void QMatrix4x4::copyDataTo(double *values)


static void _init_f_copyDataTo_c1257 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("values");
  decl->add_arg<double * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_copyDataTo_c1257 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double *arg1 = args.read<double * > ();
  ((QMatrix4x4 *)cls)->copyDataTo (arg1);
}

static qt_gsi::GenericMethod *_create_f_copyDataTo_c1257 ()
{
  return new qt_gsi::GenericMethod ("copyDataTo", "@brief Method void QMatrix4x4::copyDataTo(double *values)\n", true, &_init_f_copyDataTo_c1257, &_call_f_copyDataTo_c1257);
}

// double *QMatrix4x4::data()


static void _init_f_data_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double * > ();
}

static void _call_f_data_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double * > ((double *)((QMatrix4x4 *)cls)->data ());
}

static qt_gsi::GenericMethod *_create_f_data_0 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method double *QMatrix4x4::data()\n", false, &_init_f_data_0, &_call_f_data_0);
}

// const double *QMatrix4x4::data()


static void _init_f_data_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const double * > ();
}

static void _call_f_data_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const double * > ((const double *)((QMatrix4x4 *)cls)->data ());
}

static qt_gsi::GenericMethod *_create_f_data_c0 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method const double *QMatrix4x4::data()\n", true, &_init_f_data_c0, &_call_f_data_c0);
}

// double QMatrix4x4::determinant()


static void _init_f_determinant_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_determinant_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QMatrix4x4 *)cls)->determinant ());
}

static qt_gsi::GenericMethod *_create_f_determinant_c0 ()
{
  return new qt_gsi::GenericMethod ("determinant", "@brief Method double QMatrix4x4::determinant()\n", true, &_init_f_determinant_c0, &_call_f_determinant_c0);
}

// void QMatrix4x4::fill(double value)


static void _init_f_fill_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fill_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QMatrix4x4 *)cls)->fill (arg1);
}

static qt_gsi::GenericMethod *_create_f_fill_1071 ()
{
  return new qt_gsi::GenericMethod ("fill", "@brief Method void QMatrix4x4::fill(double value)\n", false, &_init_f_fill_1071, &_call_f_fill_1071);
}

// void QMatrix4x4::flipCoordinates()


static void _init_f_flipCoordinates_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_flipCoordinates_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMatrix4x4 *)cls)->flipCoordinates ();
}

static qt_gsi::GenericMethod *_create_f_flipCoordinates_0 ()
{
  return new qt_gsi::GenericMethod ("flipCoordinates", "@brief Method void QMatrix4x4::flipCoordinates()\n", false, &_init_f_flipCoordinates_0, &_call_f_flipCoordinates_0);
}

// void QMatrix4x4::frustum(double left, double right, double bottom, double top, double nearPlane, double farPlane)


static void _init_f_frustum_5886 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("right");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("bottom");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("top");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("nearPlane");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("farPlane");
  decl->add_arg<double > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_frustum_5886 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  ((QMatrix4x4 *)cls)->frustum (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_frustum_5886 ()
{
  return new qt_gsi::GenericMethod ("frustum", "@brief Method void QMatrix4x4::frustum(double left, double right, double bottom, double top, double nearPlane, double farPlane)\n", false, &_init_f_frustum_5886, &_call_f_frustum_5886);
}

// QMatrix4x4 QMatrix4x4::inverted(bool *invertible)


static void _init_f_inverted_c1050 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("invertible", true, "0");
  decl->add_arg<bool * > (argspec_0);
  decl->set_return<QMatrix4x4 > ();
}

static void _call_f_inverted_c1050 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool *arg1 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<QMatrix4x4 > ((QMatrix4x4)((QMatrix4x4 *)cls)->inverted (arg1));
}

static qt_gsi::GenericMethod *_create_f_inverted_c1050 ()
{
  return new qt_gsi::GenericMethod ("inverted", "@brief Method QMatrix4x4 QMatrix4x4::inverted(bool *invertible)\n", true, &_init_f_inverted_c1050, &_call_f_inverted_c1050);
}

// bool QMatrix4x4::isIdentity()


static void _init_f_isIdentity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isIdentity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMatrix4x4 *)cls)->isIdentity ());
}

static qt_gsi::GenericMethod *_create_f_isIdentity_c0 ()
{
  return new qt_gsi::GenericMethod ("isIdentity?", "@brief Method bool QMatrix4x4::isIdentity()\n", true, &_init_f_isIdentity_c0, &_call_f_isIdentity_c0);
}

// void QMatrix4x4::lookAt(const QVector3D &eye, const QVector3D &center, const QVector3D &up)


static void _init_f_lookAt_6204 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eye");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("center");
  decl->add_arg<const QVector3D & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("up");
  decl->add_arg<const QVector3D & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_lookAt_6204 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  const QVector3D &arg2 = args.read<const QVector3D & > ();
  const QVector3D &arg3 = args.read<const QVector3D & > ();
  ((QMatrix4x4 *)cls)->lookAt (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_lookAt_6204 ()
{
  return new qt_gsi::GenericMethod ("lookAt", "@brief Method void QMatrix4x4::lookAt(const QVector3D &eye, const QVector3D &center, const QVector3D &up)\n", false, &_init_f_lookAt_6204, &_call_f_lookAt_6204);
}

// QPoint QMatrix4x4::map(const QPoint &point)


static void _init_f_map_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_map_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPoint > ((QPoint)((QMatrix4x4 *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c1916 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QPoint QMatrix4x4::map(const QPoint &point)\n", true, &_init_f_map_c1916, &_call_f_map_c1916);
}

// QPointF QMatrix4x4::map(const QPointF &point)


static void _init_f_map_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_map_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QPointF > ((QPointF)((QMatrix4x4 *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c1986 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QPointF QMatrix4x4::map(const QPointF &point)\n", true, &_init_f_map_c1986, &_call_f_map_c1986);
}

// QVector3D QMatrix4x4::map(const QVector3D &point)


static void _init_f_map_c2140 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<QVector3D > ();
}

static void _call_f_map_c2140 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  ret.write<QVector3D > ((QVector3D)((QMatrix4x4 *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c2140 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QVector3D QMatrix4x4::map(const QVector3D &point)\n", true, &_init_f_map_c2140, &_call_f_map_c2140);
}

// QVector4D QMatrix4x4::map(const QVector4D &point)


static void _init_f_map_c2141 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QVector4D & > (argspec_0);
  decl->set_return<QVector4D > ();
}

static void _call_f_map_c2141 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector4D &arg1 = args.read<const QVector4D & > ();
  ret.write<QVector4D > ((QVector4D)((QMatrix4x4 *)cls)->map (arg1));
}

static qt_gsi::GenericMethod *_create_f_map_c2141 ()
{
  return new qt_gsi::GenericMethod ("map", "@brief Method QVector4D QMatrix4x4::map(const QVector4D &point)\n", true, &_init_f_map_c2141, &_call_f_map_c2141);
}

// QRect QMatrix4x4::mapRect(const QRect &rect)


static void _init_f_mapRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_mapRect_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QRect > ((QRect)((QMatrix4x4 *)cls)->mapRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapRect_c1792 ()
{
  return new qt_gsi::GenericMethod ("mapRect", "@brief Method QRect QMatrix4x4::mapRect(const QRect &rect)\n", true, &_init_f_mapRect_c1792, &_call_f_mapRect_c1792);
}

// QRectF QMatrix4x4::mapRect(const QRectF &rect)


static void _init_f_mapRect_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRect_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QMatrix4x4 *)cls)->mapRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapRect_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapRect", "@brief Method QRectF QMatrix4x4::mapRect(const QRectF &rect)\n", true, &_init_f_mapRect_c1862, &_call_f_mapRect_c1862);
}

// QVector3D QMatrix4x4::mapVector(const QVector3D &vector)


static void _init_f_mapVector_c2140 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<QVector3D > ();
}

static void _call_f_mapVector_c2140 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  ret.write<QVector3D > ((QVector3D)((QMatrix4x4 *)cls)->mapVector (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapVector_c2140 ()
{
  return new qt_gsi::GenericMethod ("mapVector", "@brief Method QVector3D QMatrix4x4::mapVector(const QVector3D &vector)\n", true, &_init_f_mapVector_c2140, &_call_f_mapVector_c2140);
}

// bool QMatrix4x4::operator!=(const QMatrix4x4 &other)


static void _init_f_operator_excl__eq__c2247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QMatrix4x4 & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2247 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix4x4 &arg1 = args.read<const QMatrix4x4 & > ();
  ret.write<bool > ((bool)((QMatrix4x4 *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2247 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QMatrix4x4::operator!=(const QMatrix4x4 &other)\n", true, &_init_f_operator_excl__eq__c2247, &_call_f_operator_excl__eq__c2247);
}

// const double &QMatrix4x4::operator()(int row, int column)


static void _init_f_operator_func__c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<const double & > ();
}

static void _call_f_operator_func__c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<const double & > ((const double &)((QMatrix4x4 *)cls)->operator() (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_operator_func__c1426 ()
{
  return new qt_gsi::GenericMethod ("()", "@brief Method const double &QMatrix4x4::operator()(int row, int column)\n", true, &_init_f_operator_func__c1426, &_call_f_operator_func__c1426);
}

// double &QMatrix4x4::operator()(int row, int column)


static void _init_f_operator_func__1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<double & > ();
}

static void _call_f_operator_func__1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<double & > ((double &)((QMatrix4x4 *)cls)->operator() (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_operator_func__1426 ()
{
  return new qt_gsi::GenericMethod ("()", "@brief Method double &QMatrix4x4::operator()(int row, int column)\n", false, &_init_f_operator_func__1426, &_call_f_operator_func__1426);
}

// QMatrix4x4 &QMatrix4x4::operator*=(const QMatrix4x4 &other)


static void _init_f_operator_star__eq__2247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QMatrix4x4 & > (argspec_0);
  decl->set_return<QMatrix4x4 & > ();
}

static void _call_f_operator_star__eq__2247 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix4x4 &arg1 = args.read<const QMatrix4x4 & > ();
  ret.write<QMatrix4x4 & > ((QMatrix4x4 &)((QMatrix4x4 *)cls)->operator*= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__eq__2247 ()
{
  return new qt_gsi::GenericMethod ("*=", "@brief Method QMatrix4x4 &QMatrix4x4::operator*=(const QMatrix4x4 &other)\n", false, &_init_f_operator_star__eq__2247, &_call_f_operator_star__eq__2247);
}

// QMatrix4x4 &QMatrix4x4::operator*=(double factor)


static void _init_f_operator_star__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factor");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QMatrix4x4 & > ();
}

static void _call_f_operator_star__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QMatrix4x4 & > ((QMatrix4x4 &)((QMatrix4x4 *)cls)->operator*= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_star__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("*=", "@brief Method QMatrix4x4 &QMatrix4x4::operator*=(double factor)\n", false, &_init_f_operator_star__eq__1071, &_call_f_operator_star__eq__1071);
}

// QMatrix4x4 &QMatrix4x4::operator+=(const QMatrix4x4 &other)


static void _init_f_operator_plus__eq__2247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QMatrix4x4 & > (argspec_0);
  decl->set_return<QMatrix4x4 & > ();
}

static void _call_f_operator_plus__eq__2247 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix4x4 &arg1 = args.read<const QMatrix4x4 & > ();
  ret.write<QMatrix4x4 & > ((QMatrix4x4 &)((QMatrix4x4 *)cls)->operator+= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_plus__eq__2247 ()
{
  return new qt_gsi::GenericMethod ("+=", "@brief Method QMatrix4x4 &QMatrix4x4::operator+=(const QMatrix4x4 &other)\n", false, &_init_f_operator_plus__eq__2247, &_call_f_operator_plus__eq__2247);
}

// QMatrix4x4 &QMatrix4x4::operator-=(const QMatrix4x4 &other)


static void _init_f_operator_minus__eq__2247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QMatrix4x4 & > (argspec_0);
  decl->set_return<QMatrix4x4 & > ();
}

static void _call_f_operator_minus__eq__2247 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix4x4 &arg1 = args.read<const QMatrix4x4 & > ();
  ret.write<QMatrix4x4 & > ((QMatrix4x4 &)((QMatrix4x4 *)cls)->operator-= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_minus__eq__2247 ()
{
  return new qt_gsi::GenericMethod ("-=", "@brief Method QMatrix4x4 &QMatrix4x4::operator-=(const QMatrix4x4 &other)\n", false, &_init_f_operator_minus__eq__2247, &_call_f_operator_minus__eq__2247);
}

// QMatrix4x4 &QMatrix4x4::operator/=(double divisor)


static void _init_f_operator_slash__eq__1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("divisor");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QMatrix4x4 & > ();
}

static void _call_f_operator_slash__eq__1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QMatrix4x4 & > ((QMatrix4x4 &)((QMatrix4x4 *)cls)->operator/= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_slash__eq__1071 ()
{
  return new qt_gsi::GenericMethod ("/=", "@brief Method QMatrix4x4 &QMatrix4x4::operator/=(double divisor)\n", false, &_init_f_operator_slash__eq__1071, &_call_f_operator_slash__eq__1071);
}

// bool QMatrix4x4::operator==(const QMatrix4x4 &other)


static void _init_f_operator_eq__eq__c2247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QMatrix4x4 & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2247 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix4x4 &arg1 = args.read<const QMatrix4x4 & > ();
  ret.write<bool > ((bool)((QMatrix4x4 *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2247 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QMatrix4x4::operator==(const QMatrix4x4 &other)\n", true, &_init_f_operator_eq__eq__c2247, &_call_f_operator_eq__eq__c2247);
}

// void QMatrix4x4::optimize()


static void _init_f_optimize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_optimize_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMatrix4x4 *)cls)->optimize ();
}

static qt_gsi::GenericMethod *_create_f_optimize_0 ()
{
  return new qt_gsi::GenericMethod ("optimize", "@brief Method void QMatrix4x4::optimize()\n", false, &_init_f_optimize_0, &_call_f_optimize_0);
}

// void QMatrix4x4::ortho(const QRect &rect)


static void _init_f_ortho_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ortho_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QMatrix4x4 *)cls)->ortho (arg1);
}

static qt_gsi::GenericMethod *_create_f_ortho_1792 ()
{
  return new qt_gsi::GenericMethod ("ortho", "@brief Method void QMatrix4x4::ortho(const QRect &rect)\n", false, &_init_f_ortho_1792, &_call_f_ortho_1792);
}

// void QMatrix4x4::ortho(const QRectF &rect)


static void _init_f_ortho_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ortho_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QMatrix4x4 *)cls)->ortho (arg1);
}

static qt_gsi::GenericMethod *_create_f_ortho_1862 ()
{
  return new qt_gsi::GenericMethod ("ortho", "@brief Method void QMatrix4x4::ortho(const QRectF &rect)\n", false, &_init_f_ortho_1862, &_call_f_ortho_1862);
}

// void QMatrix4x4::ortho(double left, double right, double bottom, double top, double nearPlane, double farPlane)


static void _init_f_ortho_5886 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("right");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("bottom");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("top");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("nearPlane");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("farPlane");
  decl->add_arg<double > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_ortho_5886 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  double arg5 = args.read<double > ();
  double arg6 = args.read<double > ();
  ((QMatrix4x4 *)cls)->ortho (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_ortho_5886 ()
{
  return new qt_gsi::GenericMethod ("ortho", "@brief Method void QMatrix4x4::ortho(double left, double right, double bottom, double top, double nearPlane, double farPlane)\n", false, &_init_f_ortho_5886, &_call_f_ortho_5886);
}

// void QMatrix4x4::perspective(double angle, double aspect, double nearPlane, double farPlane)


static void _init_f_perspective_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aspect");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("nearPlane");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("farPlane");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_perspective_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QMatrix4x4 *)cls)->perspective (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_perspective_3960 ()
{
  return new qt_gsi::GenericMethod ("perspective", "@brief Method void QMatrix4x4::perspective(double angle, double aspect, double nearPlane, double farPlane)\n", false, &_init_f_perspective_3960, &_call_f_perspective_3960);
}

// void QMatrix4x4::rotate(double angle, const QVector3D &vector)


static void _init_f_rotate_3103 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vector");
  decl->add_arg<const QVector3D & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_rotate_3103 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  const QVector3D &arg2 = args.read<const QVector3D & > ();
  ((QMatrix4x4 *)cls)->rotate (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_rotate_3103 ()
{
  return new qt_gsi::GenericMethod ("rotate", "@brief Method void QMatrix4x4::rotate(double angle, const QVector3D &vector)\n", false, &_init_f_rotate_3103, &_call_f_rotate_3103);
}

// void QMatrix4x4::rotate(double angle, double x, double y, double z)


static void _init_f_rotate_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("z", true, "0.0f");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_rotate_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args ? args.read<double > () : (double)(0.0f);
  ((QMatrix4x4 *)cls)->rotate (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_rotate_3960 ()
{
  return new qt_gsi::GenericMethod ("rotate", "@brief Method void QMatrix4x4::rotate(double angle, double x, double y, double z)\n", false, &_init_f_rotate_3960, &_call_f_rotate_3960);
}

// void QMatrix4x4::rotate(const QQuaternion &quaternion)


static void _init_f_rotate_2456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quaternion");
  decl->add_arg<const QQuaternion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_rotate_2456 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QQuaternion &arg1 = args.read<const QQuaternion & > ();
  ((QMatrix4x4 *)cls)->rotate (arg1);
}

static qt_gsi::GenericMethod *_create_f_rotate_2456 ()
{
  return new qt_gsi::GenericMethod ("rotate", "@brief Method void QMatrix4x4::rotate(const QQuaternion &quaternion)\n", false, &_init_f_rotate_2456, &_call_f_rotate_2456);
}

// QVector4D QMatrix4x4::row(int index)


static void _init_f_row_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVector4D > ();
}

static void _call_f_row_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QVector4D > ((QVector4D)((QMatrix4x4 *)cls)->row (arg1));
}

static qt_gsi::GenericMethod *_create_f_row_c767 ()
{
  return new qt_gsi::GenericMethod ("row", "@brief Method QVector4D QMatrix4x4::row(int index)\n", true, &_init_f_row_c767, &_call_f_row_c767);
}

// void QMatrix4x4::scale(const QVector3D &vector)


static void _init_f_scale_2140 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_scale_2140 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  ((QMatrix4x4 *)cls)->scale (arg1);
}

static qt_gsi::GenericMethod *_create_f_scale_2140 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QMatrix4x4::scale(const QVector3D &vector)\n", false, &_init_f_scale_2140, &_call_f_scale_2140);
}

// void QMatrix4x4::scale(double x, double y)


static void _init_f_scale_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scale_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QMatrix4x4 *)cls)->scale (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_scale_2034 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QMatrix4x4::scale(double x, double y)\n", false, &_init_f_scale_2034, &_call_f_scale_2034);
}

// void QMatrix4x4::scale(double x, double y, double z)


static void _init_f_scale_2997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("z");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_scale_2997 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ((QMatrix4x4 *)cls)->scale (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_scale_2997 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QMatrix4x4::scale(double x, double y, double z)\n", false, &_init_f_scale_2997, &_call_f_scale_2997);
}

// void QMatrix4x4::scale(double factor)


static void _init_f_scale_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factor");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_scale_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QMatrix4x4 *)cls)->scale (arg1);
}

static qt_gsi::GenericMethod *_create_f_scale_1071 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QMatrix4x4::scale(double factor)\n", false, &_init_f_scale_1071, &_call_f_scale_1071);
}

// void QMatrix4x4::setColumn(int index, const QVector4D &value)


static void _init_f_setColumn_2800 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVector4D & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumn_2800 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QVector4D &arg2 = args.read<const QVector4D & > ();
  ((QMatrix4x4 *)cls)->setColumn (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setColumn_2800 ()
{
  return new qt_gsi::GenericMethod ("setColumn", "@brief Method void QMatrix4x4::setColumn(int index, const QVector4D &value)\n", false, &_init_f_setColumn_2800, &_call_f_setColumn_2800);
}

// void QMatrix4x4::setRow(int index, const QVector4D &value)


static void _init_f_setRow_2800 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVector4D & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRow_2800 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QVector4D &arg2 = args.read<const QVector4D & > ();
  ((QMatrix4x4 *)cls)->setRow (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setRow_2800 ()
{
  return new qt_gsi::GenericMethod ("setRow", "@brief Method void QMatrix4x4::setRow(int index, const QVector4D &value)\n", false, &_init_f_setRow_2800, &_call_f_setRow_2800);
}

// void QMatrix4x4::setToIdentity()


static void _init_f_setToIdentity_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setToIdentity_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMatrix4x4 *)cls)->setToIdentity ();
}

static qt_gsi::GenericMethod *_create_f_setToIdentity_0 ()
{
  return new qt_gsi::GenericMethod ("setToIdentity", "@brief Method void QMatrix4x4::setToIdentity()\n", false, &_init_f_setToIdentity_0, &_call_f_setToIdentity_0);
}

// QMatrix QMatrix4x4::toAffine()


static void _init_f_toAffine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMatrix > ();
}

static void _call_f_toAffine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMatrix > ((QMatrix)((QMatrix4x4 *)cls)->toAffine ());
}

static qt_gsi::GenericMethod *_create_f_toAffine_c0 ()
{
  return new qt_gsi::GenericMethod ("toAffine", "@brief Method QMatrix QMatrix4x4::toAffine()\n", true, &_init_f_toAffine_c0, &_call_f_toAffine_c0);
}

// QTransform QMatrix4x4::toTransform()


static void _init_f_toTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_toTransform_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTransform > ((QTransform)((QMatrix4x4 *)cls)->toTransform ());
}

static qt_gsi::GenericMethod *_create_f_toTransform_c0 ()
{
  return new qt_gsi::GenericMethod ("toTransform", "@brief Method QTransform QMatrix4x4::toTransform()\n", true, &_init_f_toTransform_c0, &_call_f_toTransform_c0);
}

// QTransform QMatrix4x4::toTransform(double distanceToPlane)


static void _init_f_toTransform_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("distanceToPlane");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QTransform > ();
}

static void _call_f_toTransform_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QTransform > ((QTransform)((QMatrix4x4 *)cls)->toTransform (arg1));
}

static qt_gsi::GenericMethod *_create_f_toTransform_c1071 ()
{
  return new qt_gsi::GenericMethod ("toTransform", "@brief Method QTransform QMatrix4x4::toTransform(double distanceToPlane)\n", true, &_init_f_toTransform_c1071, &_call_f_toTransform_c1071);
}

// void QMatrix4x4::translate(const QVector3D &vector)


static void _init_f_translate_2140 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_2140 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVector3D &arg1 = args.read<const QVector3D & > ();
  ((QMatrix4x4 *)cls)->translate (arg1);
}

static qt_gsi::GenericMethod *_create_f_translate_2140 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QMatrix4x4::translate(const QVector3D &vector)\n", false, &_init_f_translate_2140, &_call_f_translate_2140);
}

// void QMatrix4x4::translate(double x, double y)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QMatrix4x4 *)cls)->translate (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_translate_2034 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QMatrix4x4::translate(double x, double y)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
}

// void QMatrix4x4::translate(double x, double y, double z)


static void _init_f_translate_2997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("z");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_translate_2997 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ((QMatrix4x4 *)cls)->translate (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_translate_2997 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QMatrix4x4::translate(double x, double y, double z)\n", false, &_init_f_translate_2997, &_call_f_translate_2997);
}

// QMatrix4x4 QMatrix4x4::transposed()


static void _init_f_transposed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMatrix4x4 > ();
}

static void _call_f_transposed_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMatrix4x4 > ((QMatrix4x4)((QMatrix4x4 *)cls)->transposed ());
}

static qt_gsi::GenericMethod *_create_f_transposed_c0 ()
{
  return new qt_gsi::GenericMethod ("transposed", "@brief Method QMatrix4x4 QMatrix4x4::transposed()\n", true, &_init_f_transposed_c0, &_call_f_transposed_c0);
}

//  QMatrix4x4 ::operator/(const QMatrix4x4 &matrix, qreal divisor)
static QMatrix4x4 op_QMatrix4x4_operator_slash__3108(const QMatrix4x4 *_self, qreal divisor) {
  return ::operator/(*_self, divisor);
}

//  QMatrix4x4 ::operator+(const QMatrix4x4 &m1, const QMatrix4x4 &m2)
static QMatrix4x4 op_QMatrix4x4_operator_plus__4386(const QMatrix4x4 *_self, const QMatrix4x4 &m2) {
  return ::operator+(*_self, m2);
}

//  QMatrix4x4 ::operator-(const QMatrix4x4 &m1, const QMatrix4x4 &m2)
static QMatrix4x4 op_QMatrix4x4_operator_minus__4386(const QMatrix4x4 *_self, const QMatrix4x4 &m2) {
  return ::operator-(*_self, m2);
}

//  QMatrix4x4 ::operator*(const QMatrix4x4 &m1, const QMatrix4x4 &m2)
static QMatrix4x4 op_QMatrix4x4_operator_star__4386(const QMatrix4x4 *_self, const QMatrix4x4 &m2) {
  return ::operator*(*_self, m2);
}

//  QVector3D ::operator*(const QMatrix4x4 &matrix, const QVector3D &vector)
static QVector3D op_QMatrix4x4_operator_star__4279(const QMatrix4x4 *_self, const QVector3D &vector) {
  return ::operator*(*_self, vector);
}

//  QVector4D ::operator*(const QMatrix4x4 &matrix, const QVector4D &vector)
static QVector4D op_QMatrix4x4_operator_star__4280(const QMatrix4x4 *_self, const QVector4D &vector) {
  return ::operator*(*_self, vector);
}

//  QPoint ::operator*(const QMatrix4x4 &matrix, const QPoint &point)
static QPoint op_QMatrix4x4_operator_star__4055(const QMatrix4x4 *_self, const QPoint &point) {
  return ::operator*(*_self, point);
}

//  QPointF ::operator*(const QMatrix4x4 &matrix, const QPointF &point)
static QPointF op_QMatrix4x4_operator_star__4125(const QMatrix4x4 *_self, const QPointF &point) {
  return ::operator*(*_self, point);
}

//  QMatrix4x4 ::operator-(const QMatrix4x4 &matrix)
static QMatrix4x4 op_QMatrix4x4_operator_minus__2247(const QMatrix4x4 *_self) {
  return ::operator-(*_self);
}

//  QMatrix4x4 ::operator*(const QMatrix4x4 &matrix, qreal factor)
static QMatrix4x4 op_QMatrix4x4_operator_star__3108(const QMatrix4x4 *_self, qreal factor) {
  return ::operator*(*_self, factor);
}


namespace gsi
{
gsi::Class<QMatrix4x4> decl_QMatrix4x4 ("QMatrix4x4",
  gsi::Methods(_create_ctor_QMatrix4x4_0 ()) +
  gsi::Methods(_create_ctor_QMatrix4x4_1952 ()) +
  gsi::Methods(_create_ctor_QMatrix4x4_15516 ()) +
  gsi::Methods(_create_ctor_QMatrix4x4_3270 ()) +
  gsi::Methods(_create_ctor_QMatrix4x4_2350 ()) +
  gsi::Methods(_create_ctor_QMatrix4x4_2023 ()) +
  gsi::Methods(_create_f_column_c767 ()) +
  gsi::Methods(_create_f_constData_c0 ()) +
  gsi::Methods(_create_f_copyDataTo_c1257 ()) +
  gsi::Methods(_create_f_data_0 ()) +
  gsi::Methods(_create_f_data_c0 ()) +
  gsi::Methods(_create_f_determinant_c0 ()) +
  gsi::Methods(_create_f_fill_1071 ()) +
  gsi::Methods(_create_f_flipCoordinates_0 ()) +
  gsi::Methods(_create_f_frustum_5886 ()) +
  gsi::Methods(_create_f_inverted_c1050 ()) +
  gsi::Methods(_create_f_isIdentity_c0 ()) +
  gsi::Methods(_create_f_lookAt_6204 ()) +
  gsi::Methods(_create_f_map_c1916 ()) +
  gsi::Methods(_create_f_map_c1986 ()) +
  gsi::Methods(_create_f_map_c2140 ()) +
  gsi::Methods(_create_f_map_c2141 ()) +
  gsi::Methods(_create_f_mapRect_c1792 ()) +
  gsi::Methods(_create_f_mapRect_c1862 ()) +
  gsi::Methods(_create_f_mapVector_c2140 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2247 ()) +
  gsi::Methods(_create_f_operator_func__c1426 ()) +
  gsi::Methods(_create_f_operator_func__1426 ()) +
  gsi::Methods(_create_f_operator_star__eq__2247 ()) +
  gsi::Methods(_create_f_operator_star__eq__1071 ()) +
  gsi::Methods(_create_f_operator_plus__eq__2247 ()) +
  gsi::Methods(_create_f_operator_minus__eq__2247 ()) +
  gsi::Methods(_create_f_operator_slash__eq__1071 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2247 ()) +
  gsi::Methods(_create_f_optimize_0 ()) +
  gsi::Methods(_create_f_ortho_1792 ()) +
  gsi::Methods(_create_f_ortho_1862 ()) +
  gsi::Methods(_create_f_ortho_5886 ()) +
  gsi::Methods(_create_f_perspective_3960 ()) +
  gsi::Methods(_create_f_rotate_3103 ()) +
  gsi::Methods(_create_f_rotate_3960 ()) +
  gsi::Methods(_create_f_rotate_2456 ()) +
  gsi::Methods(_create_f_row_c767 ()) +
  gsi::Methods(_create_f_scale_2140 ()) +
  gsi::Methods(_create_f_scale_2034 ()) +
  gsi::Methods(_create_f_scale_2997 ()) +
  gsi::Methods(_create_f_scale_1071 ()) +
  gsi::Methods(_create_f_setColumn_2800 ()) +
  gsi::Methods(_create_f_setRow_2800 ()) +
  gsi::Methods(_create_f_setToIdentity_0 ()) +
  gsi::Methods(_create_f_toAffine_c0 ()) +
  gsi::Methods(_create_f_toTransform_c0 ()) +
  gsi::Methods(_create_f_toTransform_c1071 ()) +
  gsi::Methods(_create_f_translate_2140 ()) +
  gsi::Methods(_create_f_translate_2034 ()) +
  gsi::Methods(_create_f_translate_2997 ()) +
  gsi::Methods(_create_f_transposed_c0 ()) +
  gsi::method_ext("/", &::op_QMatrix4x4_operator_slash__3108, gsi::arg ("divisor"), "@brief Operator QMatrix4x4 ::operator/(const QMatrix4x4 &matrix, qreal divisor)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("+", &::op_QMatrix4x4_operator_plus__4386, gsi::arg ("m2"), "@brief Operator QMatrix4x4 ::operator+(const QMatrix4x4 &m1, const QMatrix4x4 &m2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("-", &::op_QMatrix4x4_operator_minus__4386, gsi::arg ("m2"), "@brief Operator QMatrix4x4 ::operator-(const QMatrix4x4 &m1, const QMatrix4x4 &m2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QMatrix4x4_operator_star__4386, gsi::arg ("m2"), "@brief Operator QMatrix4x4 ::operator*(const QMatrix4x4 &m1, const QMatrix4x4 &m2)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QMatrix4x4_operator_star__4279, gsi::arg ("vector"), "@brief Operator QVector3D ::operator*(const QMatrix4x4 &matrix, const QVector3D &vector)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QMatrix4x4_operator_star__4280, gsi::arg ("vector"), "@brief Operator QVector4D ::operator*(const QMatrix4x4 &matrix, const QVector4D &vector)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QMatrix4x4_operator_star__4055, gsi::arg ("point"), "@brief Operator QPoint ::operator*(const QMatrix4x4 &matrix, const QPoint &point)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QMatrix4x4_operator_star__4125, gsi::arg ("point"), "@brief Operator QPointF ::operator*(const QMatrix4x4 &matrix, const QPointF &point)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("-", &::op_QMatrix4x4_operator_minus__2247, "@brief Operator QMatrix4x4 ::operator-(const QMatrix4x4 &matrix)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QMatrix4x4_operator_star__3108, gsi::arg ("factor"), "@brief Operator QMatrix4x4 ::operator*(const QMatrix4x4 &matrix, qreal factor)\nThis is the mapping of the global operator to the instance method."),
  "@qt\n@brief Binding of QMatrix4x4");

}

