
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLineF.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQLineF_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLineF

//  Constructor QLineF::QLineF()


static void _init_ctor_QLineF_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QLineF *> ();
}

static void _call_ctor_QLineF_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLineF *> (new QLineF ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLineF_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLineF::QLineF()\nThis method creates an object of class QLineF.", &_init_ctor_QLineF_0, &_call_ctor_QLineF_0);
}

//  Constructor QLineF::QLineF(const QPointF &pt1, const QPointF &pt2)


static void _init_ctor_QLineF_3864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt1");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pt2");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return_new<QLineF *> ();
}

static void _call_ctor_QLineF_3864 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  ret.write<QLineF *> (new QLineF (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLineF_3864 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLineF::QLineF(const QPointF &pt1, const QPointF &pt2)\nThis method creates an object of class QLineF.", &_init_ctor_QLineF_3864, &_call_ctor_QLineF_3864);
}

//  Constructor QLineF::QLineF(double x1, double y1, double x2, double y2)


static void _init_ctor_QLineF_3960 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<double > (argspec_3);
  decl->set_return_new<QLineF *> ();
}

static void _call_ctor_QLineF_3960 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QLineF *> (new QLineF (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLineF_3960 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLineF::QLineF(double x1, double y1, double x2, double y2)\nThis method creates an object of class QLineF.", &_init_ctor_QLineF_3960, &_call_ctor_QLineF_3960);
}

//  Constructor QLineF::QLineF(const QLine &line)


static void _init_ctor_QLineF_1786 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<const QLine & > (argspec_0);
  decl->set_return_new<QLineF *> ();
}

static void _call_ctor_QLineF_1786 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLine &arg1 = args.read<const QLine & > ();
  ret.write<QLineF *> (new QLineF (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLineF_1786 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLineF::QLineF(const QLine &line)\nThis method creates an object of class QLineF.", &_init_ctor_QLineF_1786, &_call_ctor_QLineF_1786);
}

// double QLineF::angle()


static void _init_f_angle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_angle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QLineF *)cls)->angle ());
}

static qt_gsi::GenericMethod *_create_f_angle_c0 ()
{
  return new qt_gsi::GenericMethod (":angle", "@brief Method double QLineF::angle()\n", true, &_init_f_angle_c0, &_call_f_angle_c0);
}

// double QLineF::angle(const QLineF &l)


static void _init_f_angle_c1856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<const QLineF & > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_angle_c1856 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLineF &arg1 = args.read<const QLineF & > ();
  ret.write<double > ((double)((QLineF *)cls)->angle (arg1));
}

static qt_gsi::GenericMethod *_create_f_angle_c1856 ()
{
  return new qt_gsi::GenericMethod ("angle", "@brief Method double QLineF::angle(const QLineF &l)\n", true, &_init_f_angle_c1856, &_call_f_angle_c1856);
}

// double QLineF::angleTo(const QLineF &l)


static void _init_f_angleTo_c1856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<const QLineF & > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_angleTo_c1856 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLineF &arg1 = args.read<const QLineF & > ();
  ret.write<double > ((double)((QLineF *)cls)->angleTo (arg1));
}

static qt_gsi::GenericMethod *_create_f_angleTo_c1856 ()
{
  return new qt_gsi::GenericMethod ("angleTo", "@brief Method double QLineF::angleTo(const QLineF &l)\n", true, &_init_f_angleTo_c1856, &_call_f_angleTo_c1856);
}

// double QLineF::dx()


static void _init_f_dx_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_dx_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QLineF *)cls)->dx ());
}

static qt_gsi::GenericMethod *_create_f_dx_c0 ()
{
  return new qt_gsi::GenericMethod ("dx", "@brief Method double QLineF::dx()\n", true, &_init_f_dx_c0, &_call_f_dx_c0);
}

// double QLineF::dy()


static void _init_f_dy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_dy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QLineF *)cls)->dy ());
}

static qt_gsi::GenericMethod *_create_f_dy_c0 ()
{
  return new qt_gsi::GenericMethod ("dy", "@brief Method double QLineF::dy()\n", true, &_init_f_dy_c0, &_call_f_dy_c0);
}

// QLineF::IntersectType QLineF::intersect(const QLineF &l, QPointF *intersectionPoint)


static void _init_f_intersect_c3043 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<const QLineF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("intersectionPoint");
  decl->add_arg<QPointF * > (argspec_1);
  decl->set_return<qt_gsi::Converter<QLineF::IntersectType>::target_type > ();
}

static void _call_f_intersect_c3043 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLineF &arg1 = args.read<const QLineF & > ();
  QPointF *arg2 = args.read<QPointF * > ();
  ret.write<qt_gsi::Converter<QLineF::IntersectType>::target_type > ((qt_gsi::Converter<QLineF::IntersectType>::target_type)qt_gsi::CppToQtAdaptor<QLineF::IntersectType>(((QLineF *)cls)->intersect (arg1, arg2)));
}

static qt_gsi::GenericMethod *_create_f_intersect_c3043 ()
{
  return new qt_gsi::GenericMethod ("intersect", "@brief Method QLineF::IntersectType QLineF::intersect(const QLineF &l, QPointF *intersectionPoint)\n", true, &_init_f_intersect_c3043, &_call_f_intersect_c3043);
}

// bool QLineF::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLineF *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QLineF::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// double QLineF::length()


static void _init_f_length_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_length_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QLineF *)cls)->length ());
}

static qt_gsi::GenericMethod *_create_f_length_c0 ()
{
  return new qt_gsi::GenericMethod (":length", "@brief Method double QLineF::length()\n", true, &_init_f_length_c0, &_call_f_length_c0);
}

// QLineF QLineF::normalVector()


static void _init_f_normalVector_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLineF > ();
}

static void _call_f_normalVector_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLineF > ((QLineF)((QLineF *)cls)->normalVector ());
}

static qt_gsi::GenericMethod *_create_f_normalVector_c0 ()
{
  return new qt_gsi::GenericMethod ("normalVector", "@brief Method QLineF QLineF::normalVector()\n", true, &_init_f_normalVector_c0, &_call_f_normalVector_c0);
}

// bool QLineF::operator!=(const QLineF &d)


static void _init_f_operator_excl__eq__c1856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("d");
  decl->add_arg<const QLineF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1856 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLineF &arg1 = args.read<const QLineF & > ();
  ret.write<bool > ((bool)((QLineF *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c1856 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QLineF::operator!=(const QLineF &d)\n", true, &_init_f_operator_excl__eq__c1856, &_call_f_operator_excl__eq__c1856);
}

// bool QLineF::operator==(const QLineF &d)


static void _init_f_operator_eq__eq__c1856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("d");
  decl->add_arg<const QLineF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1856 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLineF &arg1 = args.read<const QLineF & > ();
  ret.write<bool > ((bool)((QLineF *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c1856 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QLineF::operator==(const QLineF &d)\n", true, &_init_f_operator_eq__eq__c1856, &_call_f_operator_eq__eq__c1856);
}

// QPointF QLineF::p1()


static void _init_f_p1_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_p1_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QLineF *)cls)->p1 ());
}

static qt_gsi::GenericMethod *_create_f_p1_c0 ()
{
  return new qt_gsi::GenericMethod (":p1", "@brief Method QPointF QLineF::p1()\n", true, &_init_f_p1_c0, &_call_f_p1_c0);
}

// QPointF QLineF::p2()


static void _init_f_p2_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_p2_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QLineF *)cls)->p2 ());
}

static qt_gsi::GenericMethod *_create_f_p2_c0 ()
{
  return new qt_gsi::GenericMethod (":p2", "@brief Method QPointF QLineF::p2()\n", true, &_init_f_p2_c0, &_call_f_p2_c0);
}

// QPointF QLineF::pointAt(double t)


static void _init_f_pointAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_pointAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QPointF > ((QPointF)((QLineF *)cls)->pointAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_pointAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("pointAt", "@brief Method QPointF QLineF::pointAt(double t)\n", true, &_init_f_pointAt_c1071, &_call_f_pointAt_c1071);
}

// void QLineF::setAngle(double angle)


static void _init_f_setAngle_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAngle_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QLineF *)cls)->setAngle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAngle_1071 ()
{
  return new qt_gsi::GenericMethod ("setAngle|angle=", "@brief Method void QLineF::setAngle(double angle)\n", false, &_init_f_setAngle_1071, &_call_f_setAngle_1071);
}

// void QLineF::setLength(double len)


static void _init_f_setLength_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("len");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLength_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QLineF *)cls)->setLength (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLength_1071 ()
{
  return new qt_gsi::GenericMethod ("setLength|length=", "@brief Method void QLineF::setLength(double len)\n", false, &_init_f_setLength_1071, &_call_f_setLength_1071);
}

// void QLineF::setLine(double x1, double y1, double x2, double y2)


static void _init_f_setLine_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setLine_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QLineF *)cls)->setLine (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setLine_3960 ()
{
  return new qt_gsi::GenericMethod ("setLine", "@brief Method void QLineF::setLine(double x1, double y1, double x2, double y2)\n", false, &_init_f_setLine_3960, &_call_f_setLine_3960);
}

// void QLineF::setP1(const QPointF &p1)


static void _init_f_setP1_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p1");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setP1_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QLineF *)cls)->setP1 (arg1);
}

static qt_gsi::GenericMethod *_create_f_setP1_1986 ()
{
  return new qt_gsi::GenericMethod ("setP1|p1=", "@brief Method void QLineF::setP1(const QPointF &p1)\n", false, &_init_f_setP1_1986, &_call_f_setP1_1986);
}

// void QLineF::setP2(const QPointF &p2)


static void _init_f_setP2_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p2");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setP2_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QLineF *)cls)->setP2 (arg1);
}

static qt_gsi::GenericMethod *_create_f_setP2_1986 ()
{
  return new qt_gsi::GenericMethod ("setP2|p2=", "@brief Method void QLineF::setP2(const QPointF &p2)\n", false, &_init_f_setP2_1986, &_call_f_setP2_1986);
}

// void QLineF::setPoints(const QPointF &p1, const QPointF &p2)


static void _init_f_setPoints_3864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p1");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("p2");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPoints_3864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  ((QLineF *)cls)->setPoints (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setPoints_3864 ()
{
  return new qt_gsi::GenericMethod ("setPoints", "@brief Method void QLineF::setPoints(const QPointF &p1, const QPointF &p2)\n", false, &_init_f_setPoints_3864, &_call_f_setPoints_3864);
}

// QLine QLineF::toLine()


static void _init_f_toLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLine > ();
}

static void _call_f_toLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLine > ((QLine)((QLineF *)cls)->toLine ());
}

static qt_gsi::GenericMethod *_create_f_toLine_c0 ()
{
  return new qt_gsi::GenericMethod ("toLine", "@brief Method QLine QLineF::toLine()\n", true, &_init_f_toLine_c0, &_call_f_toLine_c0);
}

// void QLineF::translate(const QPointF &p)


static void _init_f_translate_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QLineF *)cls)->translate (arg1);
}

static qt_gsi::GenericMethod *_create_f_translate_1986 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QLineF::translate(const QPointF &p)\n", false, &_init_f_translate_1986, &_call_f_translate_1986);
}

// void QLineF::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QLineF *)cls)->translate (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_translate_2034 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QLineF::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
}

// QLineF QLineF::translated(const QPointF &p)


static void _init_f_translated_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QLineF > ();
}

static void _call_f_translated_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QLineF > ((QLineF)((QLineF *)cls)->translated (arg1));
}

static qt_gsi::GenericMethod *_create_f_translated_c1986 ()
{
  return new qt_gsi::GenericMethod ("translated", "@brief Method QLineF QLineF::translated(const QPointF &p)\n", true, &_init_f_translated_c1986, &_call_f_translated_c1986);
}

// QLineF QLineF::translated(double dx, double dy)


static void _init_f_translated_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QLineF > ();
}

static void _call_f_translated_c2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QLineF > ((QLineF)((QLineF *)cls)->translated (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_translated_c2034 ()
{
  return new qt_gsi::GenericMethod ("translated", "@brief Method QLineF QLineF::translated(double dx, double dy)\n", true, &_init_f_translated_c2034, &_call_f_translated_c2034);
}

// QLineF QLineF::unitVector()


static void _init_f_unitVector_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLineF > ();
}

static void _call_f_unitVector_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLineF > ((QLineF)((QLineF *)cls)->unitVector ());
}

static qt_gsi::GenericMethod *_create_f_unitVector_c0 ()
{
  return new qt_gsi::GenericMethod ("unitVector", "@brief Method QLineF QLineF::unitVector()\n", true, &_init_f_unitVector_c0, &_call_f_unitVector_c0);
}

// double QLineF::x1()


static void _init_f_x1_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_x1_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QLineF *)cls)->x1 ());
}

static qt_gsi::GenericMethod *_create_f_x1_c0 ()
{
  return new qt_gsi::GenericMethod ("x1", "@brief Method double QLineF::x1()\n", true, &_init_f_x1_c0, &_call_f_x1_c0);
}

// double QLineF::x2()


static void _init_f_x2_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_x2_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QLineF *)cls)->x2 ());
}

static qt_gsi::GenericMethod *_create_f_x2_c0 ()
{
  return new qt_gsi::GenericMethod ("x2", "@brief Method double QLineF::x2()\n", true, &_init_f_x2_c0, &_call_f_x2_c0);
}

// double QLineF::y1()


static void _init_f_y1_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_y1_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QLineF *)cls)->y1 ());
}

static qt_gsi::GenericMethod *_create_f_y1_c0 ()
{
  return new qt_gsi::GenericMethod ("y1", "@brief Method double QLineF::y1()\n", true, &_init_f_y1_c0, &_call_f_y1_c0);
}

// double QLineF::y2()


static void _init_f_y2_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_y2_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QLineF *)cls)->y2 ());
}

static qt_gsi::GenericMethod *_create_f_y2_c0 ()
{
  return new qt_gsi::GenericMethod ("y2", "@brief Method double QLineF::y2()\n", true, &_init_f_y2_c0, &_call_f_y2_c0);
}

// static QLineF QLineF::fromPolar(double length, double angle)


static void _init_f_fromPolar_2034 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("length");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("angle");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QLineF > ();
}

static void _call_f_fromPolar_2034 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QLineF > ((QLineF)QLineF::fromPolar (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_fromPolar_2034 ()
{
  return new qt_gsi::GenericStaticMethod ("fromPolar", "@brief Static method QLineF QLineF::fromPolar(double length, double angle)\nThis method is static and can be called without an instance.", &_init_f_fromPolar_2034, &_call_f_fromPolar_2034);
}

//  QLineF ::operator*(const QLineF &l, const QMatrix &m)
static QLineF op_QLineF_operator_star__3771(const QLineF *_self, const QMatrix &m) {
  return ::operator*(*_self, m);
}

//  QLineF ::operator*(const QLineF &l, const QTransform &m)
static QLineF op_QLineF_operator_star__4098(const QLineF *_self, const QTransform &m) {
  return ::operator*(*_self, m);
}


namespace gsi
{
gsi::Class<QLineF> decl_QLineF ("QLineF",
  gsi::Methods(_create_ctor_QLineF_0 ()) +
  gsi::Methods(_create_ctor_QLineF_3864 ()) +
  gsi::Methods(_create_ctor_QLineF_3960 ()) +
  gsi::Methods(_create_ctor_QLineF_1786 ()) +
  gsi::Methods(_create_f_angle_c0 ()) +
  gsi::Methods(_create_f_angle_c1856 ()) +
  gsi::Methods(_create_f_angleTo_c1856 ()) +
  gsi::Methods(_create_f_dx_c0 ()) +
  gsi::Methods(_create_f_dy_c0 ()) +
  gsi::Methods(_create_f_intersect_c3043 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_length_c0 ()) +
  gsi::Methods(_create_f_normalVector_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c1856 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c1856 ()) +
  gsi::Methods(_create_f_p1_c0 ()) +
  gsi::Methods(_create_f_p2_c0 ()) +
  gsi::Methods(_create_f_pointAt_c1071 ()) +
  gsi::Methods(_create_f_setAngle_1071 ()) +
  gsi::Methods(_create_f_setLength_1071 ()) +
  gsi::Methods(_create_f_setLine_3960 ()) +
  gsi::Methods(_create_f_setP1_1986 ()) +
  gsi::Methods(_create_f_setP2_1986 ()) +
  gsi::Methods(_create_f_setPoints_3864 ()) +
  gsi::Methods(_create_f_toLine_c0 ()) +
  gsi::Methods(_create_f_translate_1986 ()) +
  gsi::Methods(_create_f_translate_2034 ()) +
  gsi::Methods(_create_f_translated_c1986 ()) +
  gsi::Methods(_create_f_translated_c2034 ()) +
  gsi::Methods(_create_f_unitVector_c0 ()) +
  gsi::Methods(_create_f_x1_c0 ()) +
  gsi::Methods(_create_f_x2_c0 ()) +
  gsi::Methods(_create_f_y1_c0 ()) +
  gsi::Methods(_create_f_y2_c0 ()) +
  gsi::Methods(_create_f_fromPolar_2034 ()) +
  gsi::method_ext("*", &::op_QLineF_operator_star__3771, gsi::arg ("m"), "@brief Operator QLineF ::operator*(const QLineF &l, const QMatrix &m)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QLineF_operator_star__4098, gsi::arg ("m"), "@brief Operator QLineF ::operator*(const QLineF &l, const QTransform &m)\nThis is the mapping of the global operator to the instance method."),
  "@qt\n@brief Binding of QLineF");

}


//  Implementation of the enum wrapper class for QLineF::IntersectType
namespace qt_gsi
{

static QLineF_IntersectType_Enum *c_1_QLineF_IntersectType_Enum () { return new QLineF_IntersectType_Enum (QLineF::NoIntersection); }
static QLineF_IntersectType_Enum *c_2_QLineF_IntersectType_Enum () { return new QLineF_IntersectType_Enum (QLineF::BoundedIntersection); }
static QLineF_IntersectType_Enum *c_3_QLineF_IntersectType_Enum () { return new QLineF_IntersectType_Enum (QLineF::UnboundedIntersection); }

static gsi::Methods mkdefs_QLineF_IntersectType () {
  return
    gsi::constant ("NoIntersection", &qt_gsi::c_1_QLineF_IntersectType_Enum, "@brief Enum constant QLineF::NoIntersection") +
    gsi::constant ("BoundedIntersection", &qt_gsi::c_2_QLineF_IntersectType_Enum, "@brief Enum constant QLineF::BoundedIntersection") +
    gsi::constant ("UnboundedIntersection", &qt_gsi::c_3_QLineF_IntersectType_Enum, "@brief Enum constant QLineF::UnboundedIntersection");
}

static std::string to_s_QLineF_IntersectType_Enum (const QLineF_IntersectType_Enum *e)
{
  if (e->value () == QLineF::NoIntersection) { return tl::sprintf ("NoIntersection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLineF::BoundedIntersection) { return tl::sprintf ("BoundedIntersection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLineF::UnboundedIntersection) { return tl::sprintf ("UnboundedIntersection (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLineF_IntersectType_Enum (const QLineF_IntersectType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLineF_IntersectType_Enum *from_i_QLineF_IntersectType_Enum (unsigned int i)
{
  return new QLineF_IntersectType_Enum ((QLineF::IntersectType) i);
}

static bool equalQLineF_IntersectType_Enum (const QLineF_IntersectType_Enum *e, QLineF_IntersectType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLineF_IntersectType_Enum (const QLineF_IntersectType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLineF_IntersectType_Enums oropQLineF_IntersectType_Enums (const QLineF_IntersectType_Enums *e, const QLineF_IntersectType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLineF_IntersectType_Enums andopQLineF_IntersectType_Enums (const QLineF_IntersectType_Enums *e, const QLineF_IntersectType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLineF_IntersectType_Enums xoropQLineF_IntersectType_Enums (const QLineF_IntersectType_Enums *e, const QLineF_IntersectType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLineF_IntersectType_Enums (const QLineF_IntersectType_Enums *e)
{
  std::string l;
  if (e->testFlag (QLineF::NoIntersection)) { if (!l.empty ()) l += "|"; l += "NoIntersection"; }
  if (e->testFlag (QLineF::BoundedIntersection)) { if (!l.empty ()) l += "|"; l += "BoundedIntersection"; }
  if (e->testFlag (QLineF::UnboundedIntersection)) { if (!l.empty ()) l += "|"; l += "UnboundedIntersection"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLineF_IntersectType_Enums (const QLineF_IntersectType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLineF_IntersectType_Enums (const QLineF_IntersectType_Enums *e, const QLineF_IntersectType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLineF_IntersectType_Enums> decl_QLineF_IntersectType_Enums ("QLineF_QFlags_IntersectType",
  gsi::method_ext ("|", &qt_gsi::oropQLineF_IntersectType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLineF_IntersectType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLineF_IntersectType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLineF_IntersectType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLineF_IntersectType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLineF_IntersectType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLineF::IntersectType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLineF_IntersectType_Enum> decl_QLineF_IntersectType_Enum (decl_QLineF_IntersectType_Enums, "QLineF_IntersectType",
  qt_gsi::mkdefs_QLineF_IntersectType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLineF_IntersectType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLineF_IntersectType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLineF_IntersectType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLineF_IntersectType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLineF_IntersectType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLineF::IntersectType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLineF> inject_QLineF_IntersectType_Enum_in_parent (qt_gsi::mkdefs_QLineF_IntersectType ());
static gsi::ClassExt<QLineF> decl_QLineF_IntersectType_Enum_as_child (decl_QLineF_IntersectType_Enum, "IntersectType");

}

