
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQLayout_EventAdaptor.h"
#include "gsiDeclQLayout_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QLayout::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QLayout::activate()


static void _init_f_activate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_activate_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLayout *)cls)->activate ());
}

static qt_gsi::GenericMethod *_create_f_activate_0 ()
{
  return new qt_gsi::GenericMethod ("activate", "@brief Method bool QLayout::activate()\n", false, &_init_f_activate_0, &_call_f_activate_0);
}

// void QLayout::addItem(QLayoutItem *)


static void _init_f_addItem_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_1740 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  qt_gsi::qt_keep (arg1);
  ((QLayout *)cls)->addItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_addItem_1740 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Method void QLayout::addItem(QLayoutItem *)\n", false, &_init_f_addItem_1740, &_call_f_addItem_1740);
}

// void QLayout::addWidget(QWidget *w)


static void _init_f_addWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QLayout *)cls)->addWidget (arg1);
}

static qt_gsi::GenericMethod *_create_f_addWidget_1315 ()
{
  return new qt_gsi::GenericMethod ("addWidget", "@brief Method void QLayout::addWidget(QWidget *w)\n", false, &_init_f_addWidget_1315, &_call_f_addWidget_1315);
}

// QMargins QLayout::contentsMargins()


static void _init_f_contentsMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_f_contentsMargins_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMargins > ((QMargins)((QLayout *)cls)->contentsMargins ());
}

static qt_gsi::GenericMethod *_create_f_contentsMargins_c0 ()
{
  return new qt_gsi::GenericMethod (":contentsMargins", "@brief Method QMargins QLayout::contentsMargins()\n", true, &_init_f_contentsMargins_c0, &_call_f_contentsMargins_c0);
}

// QRect QLayout::contentsRect()


static void _init_f_contentsRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_contentsRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QLayout *)cls)->contentsRect ());
}

static qt_gsi::GenericMethod *_create_f_contentsRect_c0 ()
{
  return new qt_gsi::GenericMethod ("contentsRect", "@brief Method QRect QLayout::contentsRect()\n", true, &_init_f_contentsRect_c0, &_call_f_contentsRect_c0);
}

// int QLayout::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QLayout *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Method int QLayout::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
}

// QFlags<Qt::Orientation> QLayout::expandingDirections()


static void _init_f_expandingDirections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ();
}

static void _call_f_expandingDirections_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ((qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::Orientation> >(((QLayout *)cls)->expandingDirections ()));
}

static qt_gsi::GenericMethod *_create_f_expandingDirections_c0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@brief Method QFlags<Qt::Orientation> QLayout::expandingDirections()\nThis is a reimplementation of QLayoutItem::expandingDirections", true, &_init_f_expandingDirections_c0, &_call_f_expandingDirections_c0);
}

// QRect QLayout::geometry()


static void _init_f_geometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_geometry_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QLayout *)cls)->geometry ());
}

static qt_gsi::GenericMethod *_create_f_geometry_c0 ()
{
  return new qt_gsi::GenericMethod (":geometry", "@brief Method QRect QLayout::geometry()\nThis is a reimplementation of QLayoutItem::geometry", true, &_init_f_geometry_c0, &_call_f_geometry_c0);
}

// void QLayout::getContentsMargins(int *left, int *top, int *right, int *bottom)


static void _init_f_getContentsMargins_c3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getContentsMargins_c3488 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int *arg1 = args.read<int * > ();
  int *arg2 = args.read<int * > ();
  int *arg3 = args.read<int * > ();
  int *arg4 = args.read<int * > ();
  ((QLayout *)cls)->getContentsMargins (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_getContentsMargins_c3488 ()
{
  return new qt_gsi::GenericMethod ("getContentsMargins", "@brief Method void QLayout::getContentsMargins(int *left, int *top, int *right, int *bottom)\n", true, &_init_f_getContentsMargins_c3488, &_call_f_getContentsMargins_c3488);
}

// int QLayout::indexOf(QWidget *)


static void _init_f_indexOf_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_indexOf_c1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<int > ((int)((QLayout *)cls)->indexOf (arg1));
}

static qt_gsi::GenericMethod *_create_f_indexOf_c1315 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@brief Method int QLayout::indexOf(QWidget *)\n", true, &_init_f_indexOf_c1315, &_call_f_indexOf_c1315);
}

// void QLayout::invalidate()


static void _init_f_invalidate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_invalidate_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QLayout *)cls)->invalidate ();
}

static qt_gsi::GenericMethod *_create_f_invalidate_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Method void QLayout::invalidate()\nThis is a reimplementation of QLayoutItem::invalidate", false, &_init_f_invalidate_0, &_call_f_invalidate_0);
}

// bool QLayout::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLayout *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QLayout::isEmpty()\nThis is a reimplementation of QLayoutItem::isEmpty", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// bool QLayout::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLayout *)cls)->isEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QLayout::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
}

// QLayoutItem *QLayout::itemAt(int index)


static void _init_f_itemAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QLayout *)cls)->itemAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c767 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QLayoutItem *QLayout::itemAt(int index)\n", true, &_init_f_itemAt_c767, &_call_f_itemAt_c767);
}

// QLayout *QLayout::layout()


static void _init_f_layout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_f_layout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLayout * > ((QLayout *)((QLayout *)cls)->layout ());
}

static qt_gsi::GenericMethod *_create_f_layout_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@brief Method QLayout *QLayout::layout()\nThis is a reimplementation of QLayoutItem::layout", false, &_init_f_layout_0, &_call_f_layout_0);
}

// int QLayout::margin()


static void _init_f_margin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_margin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QLayout *)cls)->margin ());
}

static qt_gsi::GenericMethod *_create_f_margin_c0 ()
{
  return new qt_gsi::GenericMethod (":margin", "@brief Method int QLayout::margin()\n", true, &_init_f_margin_c0, &_call_f_margin_c0);
}

// QSize QLayout::maximumSize()


static void _init_f_maximumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_maximumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QLayout *)cls)->maximumSize ());
}

static qt_gsi::GenericMethod *_create_f_maximumSize_c0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@brief Method QSize QLayout::maximumSize()\nThis is a reimplementation of QLayoutItem::maximumSize", true, &_init_f_maximumSize_c0, &_call_f_maximumSize_c0);
}

// QWidget *QLayout::menuBar()


static void _init_f_menuBar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_menuBar_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QLayout *)cls)->menuBar ());
}

static qt_gsi::GenericMethod *_create_f_menuBar_c0 ()
{
  return new qt_gsi::GenericMethod (":menuBar", "@brief Method QWidget *QLayout::menuBar()\n", true, &_init_f_menuBar_c0, &_call_f_menuBar_c0);
}

// QSize QLayout::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QLayout *)cls)->minimumSize ());
}

static qt_gsi::GenericMethod *_create_f_minimumSize_c0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@brief Method QSize QLayout::minimumSize()\nThis is a reimplementation of QLayoutItem::minimumSize", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
}

// QWidget *QLayout::parentWidget()


static void _init_f_parentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_parentWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QLayout *)cls)->parentWidget ());
}

static qt_gsi::GenericMethod *_create_f_parentWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("parentWidget", "@brief Method QWidget *QLayout::parentWidget()\n", true, &_init_f_parentWidget_c0, &_call_f_parentWidget_c0);
}

// void QLayout::removeItem(QLayoutItem *)


static void _init_f_removeItem_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeItem_1740 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  ((QLayout *)cls)->removeItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeItem_1740 ()
{
  return new qt_gsi::GenericMethod ("removeItem", "@brief Method void QLayout::removeItem(QLayoutItem *)\n", false, &_init_f_removeItem_1740, &_call_f_removeItem_1740);
}

// void QLayout::removeWidget(QWidget *w)


static void _init_f_removeWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QLayout *)cls)->removeWidget (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeWidget_1315 ()
{
  return new qt_gsi::GenericMethod ("removeWidget", "@brief Method void QLayout::removeWidget(QWidget *w)\n", false, &_init_f_removeWidget_1315, &_call_f_removeWidget_1315);
}

// bool QLayout::setAlignment(QWidget *w, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setAlignment_3957 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setAlignment_3957 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > ();
  ret.write<bool > ((bool)((QLayout *)cls)->setAlignment (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_setAlignment_3957 ()
{
  return new qt_gsi::GenericMethod ("setAlignment", "@brief Method bool QLayout::setAlignment(QWidget *w, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setAlignment_3957, &_call_f_setAlignment_3957);
}

// bool QLayout::setAlignment(QLayout *l, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setAlignment_3983 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setAlignment_3983 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > ();
  ret.write<bool > ((bool)((QLayout *)cls)->setAlignment (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_setAlignment_3983 ()
{
  return new qt_gsi::GenericMethod ("setAlignment", "@brief Method bool QLayout::setAlignment(QLayout *l, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setAlignment_3983, &_call_f_setAlignment_3983);
}

// void QLayout::setAlignment(QFlags<Qt::AlignmentFlag> a)


static void _init_f_setAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlignment_2750 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > ();
  ((QLayout *)cls)->setAlignment (qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setAlignment_2750 ()
{
  return new qt_gsi::GenericMethod ("setAlignment|alignment=", "@brief Method void QLayout::setAlignment(QFlags<Qt::AlignmentFlag> a)\n", false, &_init_f_setAlignment_2750, &_call_f_setAlignment_2750);
}

// void QLayout::setContentsMargins(int left, int top, int right, int bottom)


static void _init_f_setContentsMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setContentsMargins_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QLayout *)cls)->setContentsMargins (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setContentsMargins_2744 ()
{
  return new qt_gsi::GenericMethod ("setContentsMargins", "@brief Method void QLayout::setContentsMargins(int left, int top, int right, int bottom)\n", false, &_init_f_setContentsMargins_2744, &_call_f_setContentsMargins_2744);
}

// void QLayout::setContentsMargins(const QMargins &margins)


static void _init_f_setContentsMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContentsMargins_2115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMargins &arg1 = args.read<const QMargins & > ();
  ((QLayout *)cls)->setContentsMargins (arg1);
}

static qt_gsi::GenericMethod *_create_f_setContentsMargins_2115 ()
{
  return new qt_gsi::GenericMethod ("setContentsMargins|contentsMargins=", "@brief Method void QLayout::setContentsMargins(const QMargins &margins)\n", false, &_init_f_setContentsMargins_2115, &_call_f_setContentsMargins_2115);
}

// void QLayout::setEnabled(bool)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QLayout *)cls)->setEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QLayout::setEnabled(bool)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
}

// void QLayout::setGeometry(const QRect &)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QLayout *)cls)->setGeometry (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGeometry_1792 ()
{
  return new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QLayout::setGeometry(const QRect &)\nThis is a reimplementation of QLayoutItem::setGeometry", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
}

// void QLayout::setMargin(int)


static void _init_f_setMargin_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMargin_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QLayout *)cls)->setMargin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMargin_767 ()
{
  return new qt_gsi::GenericMethod ("setMargin|margin=", "@brief Method void QLayout::setMargin(int)\n", false, &_init_f_setMargin_767, &_call_f_setMargin_767);
}

// void QLayout::setMenuBar(QWidget *w)


static void _init_f_setMenuBar_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMenuBar_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QLayout *)cls)->setMenuBar (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMenuBar_1315 ()
{
  return new qt_gsi::GenericMethod ("setMenuBar|menuBar=", "@brief Method void QLayout::setMenuBar(QWidget *w)\n", false, &_init_f_setMenuBar_1315, &_call_f_setMenuBar_1315);
}

// void QLayout::setSizeConstraint(QLayout::SizeConstraint)


static void _init_f_setSizeConstraint_2743 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QLayout::SizeConstraint>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizeConstraint_2743 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QLayout::SizeConstraint>::target_type & arg1 = args.read<const qt_gsi::Converter<QLayout::SizeConstraint>::target_type & > ();
  ((QLayout *)cls)->setSizeConstraint (qt_gsi::QtToCppAdaptor<QLayout::SizeConstraint>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSizeConstraint_2743 ()
{
  return new qt_gsi::GenericMethod ("setSizeConstraint|sizeConstraint=", "@brief Method void QLayout::setSizeConstraint(QLayout::SizeConstraint)\n", false, &_init_f_setSizeConstraint_2743, &_call_f_setSizeConstraint_2743);
}

// void QLayout::setSpacing(int)


static void _init_f_setSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpacing_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QLayout *)cls)->setSpacing (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSpacing_767 ()
{
  return new qt_gsi::GenericMethod ("setSpacing|spacing=", "@brief Method void QLayout::setSpacing(int)\n", false, &_init_f_setSpacing_767, &_call_f_setSpacing_767);
}

// QLayout::SizeConstraint QLayout::sizeConstraint()


static void _init_f_sizeConstraint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLayout::SizeConstraint>::target_type > ();
}

static void _call_f_sizeConstraint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QLayout::SizeConstraint>::target_type > ((qt_gsi::Converter<QLayout::SizeConstraint>::target_type)qt_gsi::CppToQtAdaptor<QLayout::SizeConstraint>(((QLayout *)cls)->sizeConstraint ()));
}

static qt_gsi::GenericMethod *_create_f_sizeConstraint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeConstraint", "@brief Method QLayout::SizeConstraint QLayout::sizeConstraint()\n", true, &_init_f_sizeConstraint_c0, &_call_f_sizeConstraint_c0);
}

// int QLayout::spacing()


static void _init_f_spacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_spacing_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QLayout *)cls)->spacing ());
}

static qt_gsi::GenericMethod *_create_f_spacing_c0 ()
{
  return new qt_gsi::GenericMethod (":spacing", "@brief Method int QLayout::spacing()\n", true, &_init_f_spacing_c0, &_call_f_spacing_c0);
}

// QLayoutItem *QLayout::takeAt(int index)


static void _init_f_takeAt_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QLayoutItem * > ();
}

static void _call_f_takeAt_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QLayout *)cls)->takeAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_takeAt_767 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@brief Method QLayoutItem *QLayout::takeAt(int index)\n", false, &_init_f_takeAt_767, &_call_f_takeAt_767);
}

// int QLayout::totalHeightForWidth(int w)


static void _init_f_totalHeightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_totalHeightForWidth_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QLayout *)cls)->totalHeightForWidth (arg1));
}

static qt_gsi::GenericMethod *_create_f_totalHeightForWidth_c767 ()
{
  return new qt_gsi::GenericMethod ("totalHeightForWidth", "@brief Method int QLayout::totalHeightForWidth(int w)\n", true, &_init_f_totalHeightForWidth_c767, &_call_f_totalHeightForWidth_c767);
}

// QSize QLayout::totalMaximumSize()


static void _init_f_totalMaximumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_totalMaximumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QLayout *)cls)->totalMaximumSize ());
}

static qt_gsi::GenericMethod *_create_f_totalMaximumSize_c0 ()
{
  return new qt_gsi::GenericMethod ("totalMaximumSize", "@brief Method QSize QLayout::totalMaximumSize()\n", true, &_init_f_totalMaximumSize_c0, &_call_f_totalMaximumSize_c0);
}

// QSize QLayout::totalMinimumSize()


static void _init_f_totalMinimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_totalMinimumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QLayout *)cls)->totalMinimumSize ());
}

static qt_gsi::GenericMethod *_create_f_totalMinimumSize_c0 ()
{
  return new qt_gsi::GenericMethod ("totalMinimumSize", "@brief Method QSize QLayout::totalMinimumSize()\n", true, &_init_f_totalMinimumSize_c0, &_call_f_totalMinimumSize_c0);
}

// QSize QLayout::totalSizeHint()


static void _init_f_totalSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_totalSizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QLayout *)cls)->totalSizeHint ());
}

static qt_gsi::GenericMethod *_create_f_totalSizeHint_c0 ()
{
  return new qt_gsi::GenericMethod ("totalSizeHint", "@brief Method QSize QLayout::totalSizeHint()\n", true, &_init_f_totalSizeHint_c0, &_call_f_totalSizeHint_c0);
}

// void QLayout::update()


static void _init_f_update_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_update_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QLayout *)cls)->update ();
}

static qt_gsi::GenericMethod *_create_f_update_0 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QLayout::update()\n", false, &_init_f_update_0, &_call_f_update_0);
}

// static QSize QLayout::closestAcceptableSize(const QWidget *w, const QSize &s)


static void _init_f_closestAcceptableSize_3707 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<const QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("s");
  decl->add_arg<const QSize & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_f_closestAcceptableSize_3707 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QWidget *arg1 = args.read<const QWidget * > ();
  const QSize &arg2 = args.read<const QSize & > ();
  ret.write<QSize > ((QSize)QLayout::closestAcceptableSize (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_closestAcceptableSize_3707 ()
{
  return new qt_gsi::GenericStaticMethod ("closestAcceptableSize", "@brief Static method QSize QLayout::closestAcceptableSize(const QWidget *w, const QSize &s)\nThis method is static and can be called without an instance.", &_init_f_closestAcceptableSize_3707, &_call_f_closestAcceptableSize_3707);
}

// static QString QLayout::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QLayout::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLayout::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QLayout::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QLayout::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QLayout::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLayout::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QLayout::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QLayout, QLayout_EventAdaptor> ea_QLayout;

//  base class cast for QObject

static void _init_f_QLayout_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QLayout_as_QObject (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QLayout *)cls);
}

static qt_gsi::GenericMethod *_create_f_QLayout_as_QObject ()
{
  return new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QLayout\nClass QLayout is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QLayout_as_QObject, &_call_f_QLayout_as_QObject);
}

static void _init_f_QLayout_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QLayout_as_const_QObject (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QLayout *)cls);
}

static qt_gsi::GenericMethod *_create_f_QLayout_as_const_QObject ()
{
  return new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QLayout\nClass QLayout is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QLayout_as_const_QObject, &_call_f_QLayout_as_const_QObject);
}

//  base class cast for QLayoutItem

static void _init_f_QLayout_as_QLayoutItem (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayoutItem *> ();
}

static void _call_f_QLayout_as_QLayoutItem (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLayoutItem *> ((QLayoutItem *)(QLayout *)cls);
}

static qt_gsi::GenericMethod *_create_f_QLayout_as_QLayoutItem ()
{
  return new qt_gsi::GenericMethod ("asQLayoutItem", "@brief Delivers the base class interface QLayoutItem of QLayout\nClass QLayout is derived from multiple base classes. This method delivers the QLayoutItem base class aspect.", false, &_init_f_QLayout_as_QLayoutItem, &_call_f_QLayout_as_QLayoutItem);
}

static void _init_f_QLayout_as_const_QLayoutItem (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QLayoutItem *> ();
}

static void _call_f_QLayout_as_const_QLayoutItem (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QLayoutItem *> ((const QLayoutItem *)(const QLayout *)cls);
}

static qt_gsi::GenericMethod *_create_f_QLayout_as_const_QLayoutItem ()
{
  return new qt_gsi::GenericMethod ("asConstQLayoutItem", "@brief Delivers the base class interface QLayoutItem of QLayout\nClass QLayout is derived from multiple base classes. This method delivers the QLayoutItem base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QLayout_as_const_QLayoutItem, &_call_f_QLayout_as_const_QLayoutItem);
}


namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QLayout> decl_QLayout (ea_QLayout, decl_QObject, "QLayout_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_activate_0 ()) +
  gsi::Methods(_create_f_addItem_1740 ()) +
  gsi::Methods(_create_f_addWidget_1315 ()) +
  gsi::Methods(_create_f_contentsMargins_c0 ()) +
  gsi::Methods(_create_f_contentsRect_c0 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_expandingDirections_c0 ()) +
  gsi::Methods(_create_f_geometry_c0 ()) +
  gsi::Methods(_create_f_getContentsMargins_c3488 ()) +
  gsi::Methods(_create_f_indexOf_c1315 ()) +
  gsi::Methods(_create_f_invalidate_0 ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_isEnabled_c0 ()) +
  gsi::Methods(_create_f_itemAt_c767 ()) +
  gsi::Methods(_create_f_layout_0 ()) +
  gsi::Methods(_create_f_margin_c0 ()) +
  gsi::Methods(_create_f_maximumSize_c0 ()) +
  gsi::Methods(_create_f_menuBar_c0 ()) +
  gsi::Methods(_create_f_minimumSize_c0 ()) +
  gsi::Methods(_create_f_parentWidget_c0 ()) +
  gsi::Methods(_create_f_removeItem_1740 ()) +
  gsi::Methods(_create_f_removeWidget_1315 ()) +
  gsi::Methods(_create_f_setAlignment_3957 ()) +
  gsi::Methods(_create_f_setAlignment_3983 ()) +
  gsi::Methods(_create_f_setAlignment_2750 ()) +
  gsi::Methods(_create_f_setContentsMargins_2744 ()) +
  gsi::Methods(_create_f_setContentsMargins_2115 ()) +
  gsi::Methods(_create_f_setEnabled_864 ()) +
  gsi::Methods(_create_f_setGeometry_1792 ()) +
  gsi::Methods(_create_f_setMargin_767 ()) +
  gsi::Methods(_create_f_setMenuBar_1315 ()) +
  gsi::Methods(_create_f_setSizeConstraint_2743 ()) +
  gsi::Methods(_create_f_setSpacing_767 ()) +
  gsi::Methods(_create_f_sizeConstraint_c0 ()) +
  gsi::Methods(_create_f_spacing_c0 ()) +
  gsi::Methods(_create_f_takeAt_767 ()) +
  gsi::Methods(_create_f_totalHeightForWidth_c767 ()) +
  gsi::Methods(_create_f_totalMaximumSize_c0 ()) +
  gsi::Methods(_create_f_totalMinimumSize_c0 ()) +
  gsi::Methods(_create_f_totalSizeHint_c0 ()) +
  gsi::Methods(_create_f_update_0 ()) +
  qt_gsi::qt_signal<QLayout, QLayout_EventAdaptor, QObject *> ("destroyed", &QLayout_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_closestAcceptableSize_3707 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()) +
  gsi::Methods(_create_f_QLayout_as_QObject ()) +
  gsi::Methods(_create_f_QLayout_as_const_QObject ()) +
  gsi::Methods(_create_f_QLayout_as_QLayoutItem ()) +
  gsi::Methods(_create_f_QLayout_as_const_QLayoutItem ()),
  "@hide\n@alias QLayout");
}


class QLayout_Adaptor : public QLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QLayout_Adaptor();

  //  [adaptor ctor] QLayout::QLayout(QWidget *parent)
  QLayout_Adaptor(QWidget *parent) : QLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLayout::QLayout()
  QLayout_Adaptor() : QLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QLayout::addChildLayout(QLayout *l)
  void fp_QLayout_addChildLayout_1341 (QLayout *l) {
    QLayout::addChildLayout(l);
  }

  //  void QLayout::addChildWidget(QWidget *w)
  void fp_QLayout_addChildWidget_1315 (QWidget *w) {
    QLayout::addChildWidget(w);
  }

  //  QRect QLayout::alignmentRect(const QRect &)
  QRect fp_QLayout_alignmentRect_c1792 (const QRect &arg1) const {
    return QLayout::alignmentRect(arg1);
  }

  //  int QLayout::receivers(const char *signal)
  int fp_QLayout_receivers_c1731 (const char *signal) const {
    return QLayout::receivers(signal);
  }

  //  QObject *QLayout::sender()
  QObject * fp_QLayout_sender_c0 () const {
    return QLayout::sender();
  }

  //  void QLayout::widgetEvent(QEvent *)
  void fp_QLayout_widgetEvent_1217 (QEvent *arg1) {
    QLayout::widgetEvent(arg1);
  }

  //  [adaptor impl] void QLayout::addItem(QLayoutItem *)
  void cbs_addItem_1740_0(QLayoutItem *arg1)
  {
    throw qt_gsi::AbstractMethodCalledException("addItem");
  }

  virtual void addItem(QLayoutItem *arg1)
  {
    if (cb_addItem_1740_0.can_issue()) {
      cb_addItem_1740_0.issue<QLayout_Adaptor, QLayoutItem *>(&QLayout_Adaptor::cbs_addItem_1740_0, arg1);
    } else {
      throw qt_gsi::AbstractMethodCalledException("addItem");
    }
  }

  //  [adaptor impl] int QLayout::count()
  int cbs_count_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("count");
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QLayout_Adaptor, int>(&QLayout_Adaptor::cbs_count_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("count");
    }
  }

  //  [adaptor impl] bool QLayout::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QLayout::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QLayout_Adaptor, bool, QEvent *>(&QLayout_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QLayout::event(arg1);
    }
  }

  //  [adaptor impl] bool QLayout::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QLayout::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QLayout_Adaptor, bool, QObject *, QEvent *>(&QLayout_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QLayout::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QFlags<Qt::Orientation> QLayout::expandingDirections()
  qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type cbs_expandingDirections_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::Orientation> >(QLayout::expandingDirections());
  }

  virtual QFlags<Qt::Orientation> expandingDirections() const
  {
    if (cb_expandingDirections_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::Orientation> >(cb_expandingDirections_c0_0.issue<QLayout_Adaptor, qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type>(&QLayout_Adaptor::cbs_expandingDirections_c0_0)).cref();
    } else {
      return QLayout::expandingDirections();
    }
  }

  //  [adaptor impl] QRect QLayout::geometry()
  QRect cbs_geometry_c0_0() const
  {
    return QLayout::geometry();
  }

  virtual QRect geometry() const
  {
    if (cb_geometry_c0_0.can_issue()) {
      return cb_geometry_c0_0.issue<QLayout_Adaptor, QRect>(&QLayout_Adaptor::cbs_geometry_c0_0);
    } else {
      return QLayout::geometry();
    }
  }

  //  [adaptor impl] bool QLayout::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QLayout::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QLayout_Adaptor, bool>(&QLayout_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QLayout::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QLayout::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QLayout::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QLayout_Adaptor, int, int>(&QLayout_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QLayout::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] int QLayout::indexOf(QWidget *)
  int cbs_indexOf_c1315_0(QWidget *arg1) const
  {
    return QLayout::indexOf(arg1);
  }

  virtual int indexOf(QWidget *arg1) const
  {
    if (cb_indexOf_c1315_0.can_issue()) {
      return cb_indexOf_c1315_0.issue<QLayout_Adaptor, int, QWidget *>(&QLayout_Adaptor::cbs_indexOf_c1315_0, arg1);
    } else {
      return QLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] void QLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QLayout_Adaptor>(&QLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QLayout_Adaptor, bool>(&QLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QLayout::isEmpty();
    }
  }

  //  [adaptor impl] QLayoutItem *QLayout::itemAt(int index)
  QLayoutItem * cbs_itemAt_c767_0(int index) const
  {
    throw qt_gsi::AbstractMethodCalledException("itemAt");
  }

  virtual QLayoutItem * itemAt(int index) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QLayout_Adaptor, QLayoutItem *, int>(&QLayout_Adaptor::cbs_itemAt_c767_0, index);
    } else {
      throw qt_gsi::AbstractMethodCalledException("itemAt");
    }
  }

  //  [adaptor impl] QLayout *QLayout::layout()
  QLayout * cbs_layout_0_0()
  {
    return QLayout::layout();
  }

  virtual QLayout * layout()
  {
    if (cb_layout_0_0.can_issue()) {
      return cb_layout_0_0.issue<QLayout_Adaptor, QLayout *>(&QLayout_Adaptor::cbs_layout_0_0);
    } else {
      return QLayout::layout();
    }
  }

  //  [adaptor impl] QSize QLayout::maximumSize()
  QSize cbs_maximumSize_c0_0() const
  {
    return QLayout::maximumSize();
  }

  virtual QSize maximumSize() const
  {
    if (cb_maximumSize_c0_0.can_issue()) {
      return cb_maximumSize_c0_0.issue<QLayout_Adaptor, QSize>(&QLayout_Adaptor::cbs_maximumSize_c0_0);
    } else {
      return QLayout::maximumSize();
    }
  }

  //  [adaptor impl] int QLayout::minimumHeightForWidth(int)
  int cbs_minimumHeightForWidth_c767_0(int arg1) const
  {
    return QLayout::minimumHeightForWidth(arg1);
  }

  virtual int minimumHeightForWidth(int arg1) const
  {
    if (cb_minimumHeightForWidth_c767_0.can_issue()) {
      return cb_minimumHeightForWidth_c767_0.issue<QLayout_Adaptor, int, int>(&QLayout_Adaptor::cbs_minimumHeightForWidth_c767_0, arg1);
    } else {
      return QLayout::minimumHeightForWidth(arg1);
    }
  }

  //  [adaptor impl] QSize QLayout::minimumSize()
  QSize cbs_minimumSize_c0_0() const
  {
    return QLayout::minimumSize();
  }

  virtual QSize minimumSize() const
  {
    if (cb_minimumSize_c0_0.can_issue()) {
      return cb_minimumSize_c0_0.issue<QLayout_Adaptor, QSize>(&QLayout_Adaptor::cbs_minimumSize_c0_0);
    } else {
      return QLayout::minimumSize();
    }
  }

  //  [adaptor impl] void QLayout::setGeometry(const QRect &)
  void cbs_setGeometry_1792_0(const QRect &arg1)
  {
    QLayout::setGeometry(arg1);
  }

  virtual void setGeometry(const QRect &arg1)
  {
    if (cb_setGeometry_1792_0.can_issue()) {
      cb_setGeometry_1792_0.issue<QLayout_Adaptor, const QRect &>(&QLayout_Adaptor::cbs_setGeometry_1792_0, arg1);
    } else {
      QLayout::setGeometry(arg1);
    }
  }

  //  [adaptor impl] QSize QLayout::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("sizeHint");
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QLayout_Adaptor, QSize>(&QLayout_Adaptor::cbs_sizeHint_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("sizeHint");
    }
  }

  //  [adaptor impl] QSpacerItem *QLayout::spacerItem()
  QSpacerItem * cbs_spacerItem_0_0()
  {
    return QLayout::spacerItem();
  }

  virtual QSpacerItem * spacerItem()
  {
    if (cb_spacerItem_0_0.can_issue()) {
      return cb_spacerItem_0_0.issue<QLayout_Adaptor, QSpacerItem *>(&QLayout_Adaptor::cbs_spacerItem_0_0);
    } else {
      return QLayout::spacerItem();
    }
  }

  //  [adaptor impl] QLayoutItem *QLayout::takeAt(int index)
  QLayoutItem * cbs_takeAt_767_0(int index)
  {
    throw qt_gsi::AbstractMethodCalledException("takeAt");
  }

  virtual QLayoutItem * takeAt(int index)
  {
    if (cb_takeAt_767_0.can_issue()) {
      return cb_takeAt_767_0.issue<QLayout_Adaptor, QLayoutItem *, int>(&QLayout_Adaptor::cbs_takeAt_767_0, index);
    } else {
      throw qt_gsi::AbstractMethodCalledException("takeAt");
    }
  }

  //  [adaptor impl] QWidget *QLayout::widget()
  QWidget * cbs_widget_0_0()
  {
    return QLayout::widget();
  }

  virtual QWidget * widget()
  {
    if (cb_widget_0_0.can_issue()) {
      return cb_widget_0_0.issue<QLayout_Adaptor, QWidget *>(&QLayout_Adaptor::cbs_widget_0_0);
    } else {
      return QLayout::widget();
    }
  }

  //  [adaptor impl] void QLayout::childEvent(QChildEvent *e)
  void cbs_childEvent_1701_0(QChildEvent *e)
  {
    QLayout::childEvent(e);
  }

  virtual void childEvent(QChildEvent *e)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QLayout_Adaptor, QChildEvent *>(&QLayout_Adaptor::cbs_childEvent_1701_0, e);
    } else {
      QLayout::childEvent(e);
    }
  }

  //  [adaptor impl] void QLayout::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QLayout::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QLayout_Adaptor, QEvent *>(&QLayout_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QLayout::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QLayout::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QLayout_Adaptor, const char *>(&QLayout_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QLayout::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QLayout::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QLayout_Adaptor, QTimerEvent *>(&QLayout_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QLayout::timerEvent(arg1);
    }
  }

  gsi::Callback cb_addItem_1740_0;
  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_expandingDirections_c0_0;
  gsi::Callback cb_geometry_c0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexOf_c1315_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_layout_0_0;
  gsi::Callback cb_maximumSize_c0_0;
  gsi::Callback cb_minimumHeightForWidth_c767_0;
  gsi::Callback cb_minimumSize_c0_0;
  gsi::Callback cb_setGeometry_1792_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_spacerItem_0_0;
  gsi::Callback cb_takeAt_767_0;
  gsi::Callback cb_widget_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QLayout_Adaptor::~QLayout_Adaptor() { }

//  Constructor QLayout::QLayout(QWidget *parent) (adaptor class)

static void _init_ctor_QLayout_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QLayout_Adaptor *> ();
}

static void _call_ctor_QLayout_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<QLayout_Adaptor *> (new QLayout_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLayout_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLayout::QLayout(QWidget *parent)\nThis method creates an object of class QLayout.", &_init_ctor_QLayout_Adaptor_1315, &_call_ctor_QLayout_Adaptor_1315);
}

//  Constructor QLayout::QLayout() (adaptor class)

static void _init_ctor_QLayout_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QLayout_Adaptor *> ();
}

static void _call_ctor_QLayout_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLayout_Adaptor *> (new QLayout_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLayout_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLayout::QLayout()\nThis method creates an object of class QLayout.", &_init_ctor_QLayout_Adaptor_0, &_call_ctor_QLayout_Adaptor_0);
}

// void QLayout::addChildLayout(QLayout *l)

static void _init_fp_addChildLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayout_1341 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  qt_gsi::qt_keep (arg1);
  ((QLayout_Adaptor *)cls)->fp_QLayout_addChildLayout_1341 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildLayout_1341 ()
{
  return new qt_gsi::GenericMethod("*addChildLayout", "@brief Method void QLayout::addChildLayout(QLayout *l)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayout_1341, &_call_fp_addChildLayout_1341);
}


// void QLayout::addChildWidget(QWidget *w)

static void _init_fp_addChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QLayout_Adaptor *)cls)->fp_QLayout_addChildWidget_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildWidget_1315 ()
{
  return new qt_gsi::GenericMethod("*addChildWidget", "@brief Method void QLayout::addChildWidget(QWidget *w)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildWidget_1315, &_call_fp_addChildWidget_1315);
}


// QRect QLayout::alignmentRect(const QRect &)

static void _init_fp_alignmentRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_alignmentRect_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QRect > ((QRect)((QLayout_Adaptor *)cls)->fp_QLayout_alignmentRect_c1792 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_alignmentRect_c1792 ()
{
  return new qt_gsi::GenericMethod("*alignmentRect", "@brief Method QRect QLayout::alignmentRect(const QRect &)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_alignmentRect_c1792, &_call_fp_alignmentRect_c1792);
}


// int QLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QLayout_Adaptor *)cls)->fp_QLayout_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QLayout_Adaptor *)cls)->fp_QLayout_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QLayout::widgetEvent(QEvent *)

static void _init_fp_widgetEvent_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_widgetEvent_1217 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QLayout_Adaptor *)cls)->fp_QLayout_widgetEvent_1217 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_widgetEvent_1217 ()
{
  return new qt_gsi::GenericMethod("*widgetEvent", "@brief Method void QLayout::widgetEvent(QEvent *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_widgetEvent_1217, &_call_fp_widgetEvent_1217);
}


// void QLayout::addItem(QLayoutItem *)

static void _init_cbs_addItem_1740_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_addItem_1740_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  ((QLayout_Adaptor *)cls)->cbs_addItem_1740_0 (arg1);
}

static void _set_callback_cbs_addItem_1740_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_addItem_1740_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@hide", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Virtual method void QLayout::addItem(QLayoutItem *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0, &_set_callback_cbs_addItem_1740_0);
}


// int QLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Virtual method int QLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
}


// bool QLayout::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QLayout::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QLayout::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QLayout::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// QFlags<Qt::Orientation> QLayout::expandingDirections()

static void _init_cbs_expandingDirections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ();
}

static void _call_cbs_expandingDirections_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ((qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type)((QLayout_Adaptor *)cls)->cbs_expandingDirections_c0_0 ());
}

static void _set_callback_cbs_expandingDirections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_expandingDirections_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@hide", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@brief Virtual method QFlags<Qt::Orientation> QLayout::expandingDirections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0, &_set_callback_cbs_expandingDirections_c0_0);
}


// QRect QLayout::geometry()

static void _init_cbs_geometry_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_geometry_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QLayout_Adaptor *)cls)->cbs_geometry_c0_0 ());
}

static void _set_callback_cbs_geometry_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_geometry_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@hide", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@brief Virtual method QRect QLayout::geometry()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0, &_set_callback_cbs_geometry_c0_0);
}


// bool QLayout::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLayout_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QLayout::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
}


// int QLayout::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QLayout_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QLayout::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// int QLayout::indexOf(QWidget *)

static void _init_cbs_indexOf_c1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<int > ((int)((QLayout_Adaptor *)cls)->cbs_indexOf_c1315_0 (arg1));
}

static void _set_callback_cbs_indexOf_c1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_indexOf_c1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QLayout::indexOf(QWidget *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0, &_set_callback_cbs_indexOf_c1315_0);
}


// void QLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
}


// bool QLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
}


// QLayoutItem *QLayout::itemAt(int index)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QLayoutItem *QLayout::itemAt(int index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
}


// QLayout *QLayout::layout()

static void _init_cbs_layout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_cbs_layout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLayout * > ((QLayout *)((QLayout_Adaptor *)cls)->cbs_layout_0_0 ());
}

static void _set_callback_cbs_layout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_layout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@hide", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@brief Virtual method QLayout *QLayout::layout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0, &_set_callback_cbs_layout_0_0);
}


// QSize QLayout::maximumSize()

static void _init_cbs_maximumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_maximumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QLayout_Adaptor *)cls)->cbs_maximumSize_c0_0 ());
}

static void _set_callback_cbs_maximumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_maximumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@hide", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@brief Virtual method QSize QLayout::maximumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0, &_set_callback_cbs_maximumSize_c0_0);
}


// int QLayout::minimumHeightForWidth(int)

static void _init_cbs_minimumHeightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_minimumHeightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QLayout_Adaptor *)cls)->cbs_minimumHeightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_minimumHeightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_minimumHeightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@hide", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Virtual method int QLayout::minimumHeightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0, &_set_callback_cbs_minimumHeightForWidth_c767_0);
}


// QSize QLayout::minimumSize()

static void _init_cbs_minimumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QLayout_Adaptor *)cls)->cbs_minimumSize_c0_0 ());
}

static void _set_callback_cbs_minimumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_minimumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@hide", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@brief Virtual method QSize QLayout::minimumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0, &_set_callback_cbs_minimumSize_c0_0);
}


// void QLayout::setGeometry(const QRect &)

static void _init_cbs_setGeometry_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1792_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QLayout_Adaptor *)cls)->cbs_setGeometry_1792_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_setGeometry_1792_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QLayout::setGeometry(const QRect &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0, &_set_callback_cbs_setGeometry_1792_0);
}


// QSize QLayout::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QLayout_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QLayout::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// QSpacerItem *QLayout::spacerItem()

static void _init_cbs_spacerItem_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSpacerItem * > ();
}

static void _call_cbs_spacerItem_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSpacerItem * > ((QSpacerItem *)((QLayout_Adaptor *)cls)->cbs_spacerItem_0_0 ());
}

static void _set_callback_cbs_spacerItem_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_spacerItem_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@hide", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@brief Virtual method QSpacerItem *QLayout::spacerItem()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0, &_set_callback_cbs_spacerItem_0_0);
}


// QLayoutItem *QLayout::takeAt(int index)

static void _init_cbs_takeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_takeAt_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QLayout_Adaptor *)cls)->cbs_takeAt_767_0 (arg1));
}

static void _set_callback_cbs_takeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_takeAt_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@hide", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@brief Virtual method QLayoutItem *QLayout::takeAt(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0, &_set_callback_cbs_takeAt_767_0);
}


// QWidget *QLayout::widget()

static void _init_cbs_widget_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_cbs_widget_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QLayout_Adaptor *)cls)->cbs_widget_0_0 ());
}

static void _set_callback_cbs_widget_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_widget_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@hide", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@brief Virtual method QWidget *QLayout::widget()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0, &_set_callback_cbs_widget_0_0);
}


// void QLayout::childEvent(QChildEvent *e)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QLayout::childEvent(QChildEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QLayout::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QLayout::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QLayout::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QLayout_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QLayout::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QLayout::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QLayout::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QLayout> decl_QLayout;

gsi::Class<QLayout_Adaptor> decl_QLayout_Adaptor (decl_QLayout, "QLayout",
  gsi::Methods(_create_fp_addChildLayout_1341 ()) +
  gsi::Methods(_create_fp_addChildWidget_1315 ()) +
  gsi::Methods(_create_fp_alignmentRect_c1792 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_widgetEvent_1217 ()) +
  gsi::Methods(_create_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_callback_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_cbs_count_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_count_c0_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_callback_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_callback_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_cbs_layout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_layout_0_0 ()) +
  gsi::Methods(_create_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_callback_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_callback_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_callback_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_cbs_widget_0_0 ()) +
  gsi::Methods(_create_callback_cbs_widget_0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QLayout_Adaptor_1315 ()) +
  gsi::Methods(_create_ctor_QLayout_Adaptor_0 ()),
  "@qt\n@brief Binding of QLayout");

}


//  Implementation of the enum wrapper class for QLayout::SizeConstraint
namespace qt_gsi
{

static QLayout_SizeConstraint_Enum *c_1_QLayout_SizeConstraint_Enum () { return new QLayout_SizeConstraint_Enum (QLayout::SetDefaultConstraint); }
static QLayout_SizeConstraint_Enum *c_2_QLayout_SizeConstraint_Enum () { return new QLayout_SizeConstraint_Enum (QLayout::SetNoConstraint); }
static QLayout_SizeConstraint_Enum *c_3_QLayout_SizeConstraint_Enum () { return new QLayout_SizeConstraint_Enum (QLayout::SetMinimumSize); }
static QLayout_SizeConstraint_Enum *c_4_QLayout_SizeConstraint_Enum () { return new QLayout_SizeConstraint_Enum (QLayout::SetFixedSize); }
static QLayout_SizeConstraint_Enum *c_5_QLayout_SizeConstraint_Enum () { return new QLayout_SizeConstraint_Enum (QLayout::SetMaximumSize); }
static QLayout_SizeConstraint_Enum *c_6_QLayout_SizeConstraint_Enum () { return new QLayout_SizeConstraint_Enum (QLayout::SetMinAndMaxSize); }

static gsi::Methods mkdefs_QLayout_SizeConstraint () {
  return
    gsi::constant ("SetDefaultConstraint", &qt_gsi::c_1_QLayout_SizeConstraint_Enum, "@brief Enum constant QLayout::SetDefaultConstraint") +
    gsi::constant ("SetNoConstraint", &qt_gsi::c_2_QLayout_SizeConstraint_Enum, "@brief Enum constant QLayout::SetNoConstraint") +
    gsi::constant ("SetMinimumSize", &qt_gsi::c_3_QLayout_SizeConstraint_Enum, "@brief Enum constant QLayout::SetMinimumSize") +
    gsi::constant ("SetFixedSize", &qt_gsi::c_4_QLayout_SizeConstraint_Enum, "@brief Enum constant QLayout::SetFixedSize") +
    gsi::constant ("SetMaximumSize", &qt_gsi::c_5_QLayout_SizeConstraint_Enum, "@brief Enum constant QLayout::SetMaximumSize") +
    gsi::constant ("SetMinAndMaxSize", &qt_gsi::c_6_QLayout_SizeConstraint_Enum, "@brief Enum constant QLayout::SetMinAndMaxSize");
}

static std::string to_s_QLayout_SizeConstraint_Enum (const QLayout_SizeConstraint_Enum *e)
{
  if (e->value () == QLayout::SetDefaultConstraint) { return tl::sprintf ("SetDefaultConstraint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLayout::SetNoConstraint) { return tl::sprintf ("SetNoConstraint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLayout::SetMinimumSize) { return tl::sprintf ("SetMinimumSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLayout::SetFixedSize) { return tl::sprintf ("SetFixedSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLayout::SetMaximumSize) { return tl::sprintf ("SetMaximumSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLayout::SetMinAndMaxSize) { return tl::sprintf ("SetMinAndMaxSize (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLayout_SizeConstraint_Enum (const QLayout_SizeConstraint_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLayout_SizeConstraint_Enum *from_i_QLayout_SizeConstraint_Enum (unsigned int i)
{
  return new QLayout_SizeConstraint_Enum ((QLayout::SizeConstraint) i);
}

static bool equalQLayout_SizeConstraint_Enum (const QLayout_SizeConstraint_Enum *e, QLayout_SizeConstraint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLayout_SizeConstraint_Enum (const QLayout_SizeConstraint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLayout_SizeConstraint_Enums oropQLayout_SizeConstraint_Enums (const QLayout_SizeConstraint_Enums *e, const QLayout_SizeConstraint_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLayout_SizeConstraint_Enums andopQLayout_SizeConstraint_Enums (const QLayout_SizeConstraint_Enums *e, const QLayout_SizeConstraint_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLayout_SizeConstraint_Enums xoropQLayout_SizeConstraint_Enums (const QLayout_SizeConstraint_Enums *e, const QLayout_SizeConstraint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLayout_SizeConstraint_Enums (const QLayout_SizeConstraint_Enums *e)
{
  std::string l;
  if (e->testFlag (QLayout::SetDefaultConstraint)) { if (!l.empty ()) l += "|"; l += "SetDefaultConstraint"; }
  if (e->testFlag (QLayout::SetNoConstraint)) { if (!l.empty ()) l += "|"; l += "SetNoConstraint"; }
  if (e->testFlag (QLayout::SetMinimumSize)) { if (!l.empty ()) l += "|"; l += "SetMinimumSize"; }
  if (e->testFlag (QLayout::SetFixedSize)) { if (!l.empty ()) l += "|"; l += "SetFixedSize"; }
  if (e->testFlag (QLayout::SetMaximumSize)) { if (!l.empty ()) l += "|"; l += "SetMaximumSize"; }
  if (e->testFlag (QLayout::SetMinAndMaxSize)) { if (!l.empty ()) l += "|"; l += "SetMinAndMaxSize"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLayout_SizeConstraint_Enums (const QLayout_SizeConstraint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLayout_SizeConstraint_Enums (const QLayout_SizeConstraint_Enums *e, const QLayout_SizeConstraint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLayout_SizeConstraint_Enums> decl_QLayout_SizeConstraint_Enums ("QLayout_QFlags_SizeConstraint",
  gsi::method_ext ("|", &qt_gsi::oropQLayout_SizeConstraint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLayout_SizeConstraint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLayout_SizeConstraint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLayout_SizeConstraint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLayout_SizeConstraint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLayout_SizeConstraint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLayout::SizeConstraint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLayout_SizeConstraint_Enum> decl_QLayout_SizeConstraint_Enum (decl_QLayout_SizeConstraint_Enums, "QLayout_SizeConstraint",
  qt_gsi::mkdefs_QLayout_SizeConstraint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLayout_SizeConstraint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLayout_SizeConstraint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLayout_SizeConstraint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLayout_SizeConstraint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLayout_SizeConstraint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLayout::SizeConstraint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLayout> inject_QLayout_SizeConstraint_Enum_in_parent (qt_gsi::mkdefs_QLayout_SizeConstraint ());
static gsi::ClassExt<QLayout> decl_QLayout_SizeConstraint_Enum_as_child (decl_QLayout_SizeConstraint_Enum, "SizeConstraint");

}

