
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQItemSelectionModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQItemSelectionModel_EventAdaptor.h"
#include "gsiDeclQItemSelectionModel_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QItemSelectionModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QItemSelectionModel::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QItemSelectionModel::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QItemSelectionModel *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QItemSelectionModel::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// void QItemSelectionModel::clearSelection()


static void _init_f_clearSelection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearSelection_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QItemSelectionModel *)cls)->clearSelection ();
}

static qt_gsi::GenericMethod *_create_f_clearSelection_0 ()
{
  return new qt_gsi::GenericMethod ("clearSelection", "@brief Method void QItemSelectionModel::clearSelection()\n", false, &_init_f_clearSelection_0, &_call_f_clearSelection_0);
}

// bool QItemSelectionModel::columnIntersectsSelection(int column, const QModelIndex &parent)


static void _init_f_columnIntersectsSelection_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_columnIntersectsSelection_c3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->columnIntersectsSelection (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_columnIntersectsSelection_c3054 ()
{
  return new qt_gsi::GenericMethod ("columnIntersectsSelection", "@brief Method bool QItemSelectionModel::columnIntersectsSelection(int column, const QModelIndex &parent)\n", true, &_init_f_columnIntersectsSelection_c3054, &_call_f_columnIntersectsSelection_c3054);
}

// QModelIndex QItemSelectionModel::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QModelIndex > ((QModelIndex)((QItemSelectionModel *)cls)->currentIndex ());
}

static qt_gsi::GenericMethod *_create_f_currentIndex_c0 ()
{
  return new qt_gsi::GenericMethod ("currentIndex", "@brief Method QModelIndex QItemSelectionModel::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
}

// bool QItemSelectionModel::hasSelection()


static void _init_f_hasSelection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasSelection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->hasSelection ());
}

static qt_gsi::GenericMethod *_create_f_hasSelection_c0 ()
{
  return new qt_gsi::GenericMethod ("hasSelection", "@brief Method bool QItemSelectionModel::hasSelection()\n", true, &_init_f_hasSelection_c0, &_call_f_hasSelection_c0);
}

// bool QItemSelectionModel::isColumnSelected(int column, const QModelIndex &parent)


static void _init_f_isColumnSelected_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isColumnSelected_c3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->isColumnSelected (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_isColumnSelected_c3054 ()
{
  return new qt_gsi::GenericMethod ("isColumnSelected?", "@brief Method bool QItemSelectionModel::isColumnSelected(int column, const QModelIndex &parent)\n", true, &_init_f_isColumnSelected_c3054, &_call_f_isColumnSelected_c3054);
}

// bool QItemSelectionModel::isRowSelected(int row, const QModelIndex &parent)


static void _init_f_isRowSelected_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isRowSelected_c3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->isRowSelected (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_isRowSelected_c3054 ()
{
  return new qt_gsi::GenericMethod ("isRowSelected?", "@brief Method bool QItemSelectionModel::isRowSelected(int row, const QModelIndex &parent)\n", true, &_init_f_isRowSelected_c3054, &_call_f_isRowSelected_c3054);
}

// bool QItemSelectionModel::isSelected(const QModelIndex &index)


static void _init_f_isSelected_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isSelected_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->isSelected (arg1));
}

static qt_gsi::GenericMethod *_create_f_isSelected_c2395 ()
{
  return new qt_gsi::GenericMethod ("isSelected?", "@brief Method bool QItemSelectionModel::isSelected(const QModelIndex &index)\n", true, &_init_f_isSelected_c2395, &_call_f_isSelected_c2395);
}

// const QAbstractItemModel *QItemSelectionModel::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QAbstractItemModel * > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QAbstractItemModel * > ((const QAbstractItemModel *)((QItemSelectionModel *)cls)->model ());
}

static qt_gsi::GenericMethod *_create_f_model_c0 ()
{
  return new qt_gsi::GenericMethod ("model", "@brief Method const QAbstractItemModel *QItemSelectionModel::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
}

// void QItemSelectionModel::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QItemSelectionModel *)cls)->reset ();
}

static qt_gsi::GenericMethod *_create_f_reset_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Method void QItemSelectionModel::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
}

// bool QItemSelectionModel::rowIntersectsSelection(int row, const QModelIndex &parent)


static void _init_f_rowIntersectsSelection_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_rowIntersectsSelection_c3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->rowIntersectsSelection (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_rowIntersectsSelection_c3054 ()
{
  return new qt_gsi::GenericMethod ("rowIntersectsSelection", "@brief Method bool QItemSelectionModel::rowIntersectsSelection(int row, const QModelIndex &parent)\n", true, &_init_f_rowIntersectsSelection_c3054, &_call_f_rowIntersectsSelection_c3054);
}

// void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_select_6758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_select_6758 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QItemSelectionModel *)cls)->select (arg1, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_select_6758 ()
{
  return new qt_gsi::GenericMethod ("select", "@brief Method void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_select_6758, &_call_f_select_6758);
}

// void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_select_7090 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_select_7090 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QItemSelectionModel *)cls)->select (arg1, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_select_7090 ()
{
  return new qt_gsi::GenericMethod ("select", "@brief Method void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_select_7090, &_call_f_select_7090);
}

// QList<QModelIndex> QItemSelectionModel::selectedColumns(int row)


static void _init_f_selectedColumns_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_f_selectedColumns_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(((QItemSelectionModel *)cls)->selectedColumns (arg1)));
}

static qt_gsi::GenericMethod *_create_f_selectedColumns_c767 ()
{
  return new qt_gsi::GenericMethod ("selectedColumns", "@brief Method QList<QModelIndex> QItemSelectionModel::selectedColumns(int row)\n", true, &_init_f_selectedColumns_c767, &_call_f_selectedColumns_c767);
}

// QList<QModelIndex> QItemSelectionModel::selectedIndexes()


static void _init_f_selectedIndexes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_f_selectedIndexes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(((QItemSelectionModel *)cls)->selectedIndexes ()));
}

static qt_gsi::GenericMethod *_create_f_selectedIndexes_c0 ()
{
  return new qt_gsi::GenericMethod ("selectedIndexes", "@brief Method QList<QModelIndex> QItemSelectionModel::selectedIndexes()\n", true, &_init_f_selectedIndexes_c0, &_call_f_selectedIndexes_c0);
}

// QList<QModelIndex> QItemSelectionModel::selectedRows(int column)


static void _init_f_selectedRows_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_f_selectedRows_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(((QItemSelectionModel *)cls)->selectedRows (arg1)));
}

static qt_gsi::GenericMethod *_create_f_selectedRows_c767 ()
{
  return new qt_gsi::GenericMethod ("selectedRows", "@brief Method QList<QModelIndex> QItemSelectionModel::selectedRows(int column)\n", true, &_init_f_selectedRows_c767, &_call_f_selectedRows_c767);
}

// const QItemSelection QItemSelectionModel::selection()


static void _init_f_selection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QItemSelection > ();
}

static void _call_f_selection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QItemSelection > ((const QItemSelection)((QItemSelectionModel *)cls)->selection ());
}

static qt_gsi::GenericMethod *_create_f_selection_c0 ()
{
  return new qt_gsi::GenericMethod ("selection", "@brief Method const QItemSelection QItemSelectionModel::selection()\n", true, &_init_f_selection_c0, &_call_f_selection_c0);
}

// void QItemSelectionModel::setCurrentIndex(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_setCurrentIndex_6758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_6758 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QItemSelectionModel *)cls)->setCurrentIndex (arg1, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setCurrentIndex_6758 ()
{
  return new qt_gsi::GenericMethod ("setCurrentIndex", "@brief Method void QItemSelectionModel::setCurrentIndex(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_setCurrentIndex_6758, &_call_f_setCurrentIndex_6758);
}

// static QString QItemSelectionModel::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QItemSelectionModel::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QItemSelectionModel::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QItemSelectionModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QItemSelectionModel::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QItemSelectionModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QItemSelectionModel::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QItemSelectionModel::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QItemSelectionModel::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QItemSelectionModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QItemSelectionModel::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QItemSelectionModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QItemSelectionModel, QItemSelectionModel_EventAdaptor> ea_QItemSelectionModel;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QItemSelectionModel> decl_QItemSelectionModel (ea_QItemSelectionModel, decl_QObject, "QItemSelectionModel_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_clearSelection_0 ()) +
  gsi::Methods(_create_f_columnIntersectsSelection_c3054 ()) +
  gsi::Methods(_create_f_currentIndex_c0 ()) +
  gsi::Methods(_create_f_hasSelection_c0 ()) +
  gsi::Methods(_create_f_isColumnSelected_c3054 ()) +
  gsi::Methods(_create_f_isRowSelected_c3054 ()) +
  gsi::Methods(_create_f_isSelected_c2395 ()) +
  gsi::Methods(_create_f_model_c0 ()) +
  gsi::Methods(_create_f_reset_0 ()) +
  gsi::Methods(_create_f_rowIntersectsSelection_c3054 ()) +
  gsi::Methods(_create_f_select_6758 ()) +
  gsi::Methods(_create_f_select_7090 ()) +
  gsi::Methods(_create_f_selectedColumns_c767 ()) +
  gsi::Methods(_create_f_selectedIndexes_c0 ()) +
  gsi::Methods(_create_f_selectedRows_c767 ()) +
  gsi::Methods(_create_f_selection_c0 ()) +
  gsi::Methods(_create_f_setCurrentIndex_6758 ()) +
  qt_gsi::qt_signal<QItemSelectionModel, QItemSelectionModel_EventAdaptor, const QModelIndex &, const QModelIndex &> ("currentChanged", &QItemSelectionModel_EventAdaptor::currentChanged_e_4682, gsi::arg("current"), gsi::arg("previous"), "@brief Signal declaration for QItemSelectionModel::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QItemSelectionModel, QItemSelectionModel_EventAdaptor, const QModelIndex &, const QModelIndex &> ("currentColumnChanged", &QItemSelectionModel_EventAdaptor::currentColumnChanged_e_4682, gsi::arg("current"), gsi::arg("previous"), "@brief Signal declaration for QItemSelectionModel::currentColumnChanged(const QModelIndex &current, const QModelIndex &previous)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QItemSelectionModel, QItemSelectionModel_EventAdaptor, const QModelIndex &, const QModelIndex &> ("currentRowChanged", &QItemSelectionModel_EventAdaptor::currentRowChanged_e_4682, gsi::arg("current"), gsi::arg("previous"), "@brief Signal declaration for QItemSelectionModel::currentRowChanged(const QModelIndex &current, const QModelIndex &previous)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QItemSelectionModel, QItemSelectionModel_EventAdaptor, QObject *> ("destroyed", &QItemSelectionModel_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QItemSelectionModel::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QItemSelectionModel, QItemSelectionModel_EventAdaptor, const QItemSelection &, const QItemSelection &> ("selectionChanged", &QItemSelectionModel_EventAdaptor::selectionChanged_e_5346, gsi::arg("selected"), gsi::arg("deselected"), "@brief Signal declaration for QItemSelectionModel::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QItemSelectionModel");
}


class QItemSelectionModel_Adaptor : public QItemSelectionModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QItemSelectionModel_Adaptor();

  //  [adaptor ctor] QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model)
  QItemSelectionModel_Adaptor(QAbstractItemModel *model) : QItemSelectionModel(model)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model, QObject *parent)
  QItemSelectionModel_Adaptor(QAbstractItemModel *model, QObject *parent) : QItemSelectionModel(model, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QItemSelectionModel::emitSelectionChanged(const QItemSelection &newSelection, const QItemSelection &oldSelection)
  void fp_QItemSelectionModel_emitSelectionChanged_5346 (const QItemSelection &newSelection, const QItemSelection &oldSelection) {
    QItemSelectionModel::emitSelectionChanged(newSelection, oldSelection);
  }

  //  int QItemSelectionModel::receivers(const char *signal)
  int fp_QItemSelectionModel_receivers_c1731 (const char *signal) const {
    return QItemSelectionModel::receivers(signal);
  }

  //  QObject *QItemSelectionModel::sender()
  QObject * fp_QItemSelectionModel_sender_c0 () const {
    return QItemSelectionModel::sender();
  }

  //  [adaptor impl] void QItemSelectionModel::clear()
  void cbs_clear_0_0()
  {
    QItemSelectionModel::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QItemSelectionModel_Adaptor>(&QItemSelectionModel_Adaptor::cbs_clear_0_0);
    } else {
      QItemSelectionModel::clear();
    }
  }

  //  [adaptor impl] bool QItemSelectionModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QItemSelectionModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QItemSelectionModel_Adaptor, bool, QEvent *>(&QItemSelectionModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QItemSelectionModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QItemSelectionModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QItemSelectionModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QItemSelectionModel_Adaptor, bool, QObject *, QEvent *>(&QItemSelectionModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QItemSelectionModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::reset()
  void cbs_reset_0_0()
  {
    QItemSelectionModel::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QItemSelectionModel_Adaptor>(&QItemSelectionModel_Adaptor::cbs_reset_0_0);
    } else {
      QItemSelectionModel::reset();
    }
  }

  //  [adaptor impl] void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_select_6758_0(const QModelIndex &index, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & command)
  {
    QItemSelectionModel::select(index, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command).cref());
  }

  virtual void select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_select_6758_0.can_issue()) {
      cb_select_6758_0.issue<QItemSelectionModel_Adaptor, const QModelIndex &, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type &>(&QItemSelectionModel_Adaptor::cbs_select_6758_0, index, qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command));
    } else {
      QItemSelectionModel::select(index, command);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_select_7090_0(const QItemSelection &selection, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & command)
  {
    QItemSelectionModel::select(selection, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command).cref());
  }

  virtual void select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_select_7090_0.can_issue()) {
      cb_select_7090_0.issue<QItemSelectionModel_Adaptor, const QItemSelection &, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type &>(&QItemSelectionModel_Adaptor::cbs_select_7090_0, selection, qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command));
    } else {
      QItemSelectionModel::select(selection, command);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QItemSelectionModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QItemSelectionModel_Adaptor, QChildEvent *>(&QItemSelectionModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QItemSelectionModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QItemSelectionModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QItemSelectionModel_Adaptor, QEvent *>(&QItemSelectionModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QItemSelectionModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QItemSelectionModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QItemSelectionModel_Adaptor, const char *>(&QItemSelectionModel_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QItemSelectionModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QItemSelectionModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QItemSelectionModel_Adaptor, QTimerEvent *>(&QItemSelectionModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QItemSelectionModel::timerEvent(arg1);
    }
  }

  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_select_6758_0;
  gsi::Callback cb_select_7090_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QItemSelectionModel_Adaptor::~QItemSelectionModel_Adaptor() { }

//  Constructor QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model) (adaptor class)

static void _init_ctor_QItemSelectionModel_Adaptor_2419 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return_new<QItemSelectionModel_Adaptor *> ();
}

static void _call_ctor_QItemSelectionModel_Adaptor_2419 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > ();
  ret.write<QItemSelectionModel_Adaptor *> (new QItemSelectionModel_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QItemSelectionModel_Adaptor_2419 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model)\nThis method creates an object of class QItemSelectionModel.", &_init_ctor_QItemSelectionModel_Adaptor_2419, &_call_ctor_QItemSelectionModel_Adaptor_2419);
}

//  Constructor QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model, QObject *parent) (adaptor class)

static void _init_ctor_QItemSelectionModel_Adaptor_3613 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QItemSelectionModel_Adaptor *> ();
}

static void _call_ctor_QItemSelectionModel_Adaptor_3613 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > ();
  QObject *arg2 = args.read<QObject * > ();
  ret.write<QItemSelectionModel_Adaptor *> (new QItemSelectionModel_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QItemSelectionModel_Adaptor_3613 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model, QObject *parent)\nThis method creates an object of class QItemSelectionModel.", &_init_ctor_QItemSelectionModel_Adaptor_3613, &_call_ctor_QItemSelectionModel_Adaptor_3613);
}

// void QItemSelectionModel::emitSelectionChanged(const QItemSelection &newSelection, const QItemSelection &oldSelection)

static void _init_fp_emitSelectionChanged_5346 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newSelection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldSelection");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_emitSelectionChanged_5346 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  const QItemSelection &arg2 = args.read<const QItemSelection & > ();
  ((QItemSelectionModel_Adaptor *)cls)->fp_QItemSelectionModel_emitSelectionChanged_5346 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_emitSelectionChanged_5346 ()
{
  return new qt_gsi::GenericMethod("*emitSelectionChanged", "@brief Method void QItemSelectionModel::emitSelectionChanged(const QItemSelection &newSelection, const QItemSelection &oldSelection)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_emitSelectionChanged_5346, &_call_fp_emitSelectionChanged_5346);
}


// int QItemSelectionModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QItemSelectionModel_Adaptor *)cls)->fp_QItemSelectionModel_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QItemSelectionModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QItemSelectionModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QItemSelectionModel_Adaptor *)cls)->fp_QItemSelectionModel_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QItemSelectionModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QItemSelectionModel::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QItemSelectionModel_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_clear_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_clear_0_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_clear_0_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QItemSelectionModel::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
}


// bool QItemSelectionModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QItemSelectionModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QItemSelectionModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QItemSelectionModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QItemSelectionModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QItemSelectionModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QItemSelectionModel::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QItemSelectionModel_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_reset_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QItemSelectionModel::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
}


// void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_select_6758_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_select_6758_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QItemSelectionModel_Adaptor *)cls)->cbs_select_6758_0 (arg1, arg2);
}

static void _set_callback_cbs_select_6758_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_select_6758_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_select_6758_0 ()
{
  return new qt_gsi::GenericMethod ("select", "@hide", false, &_init_cbs_select_6758_0, &_call_cbs_select_6758_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_select_6758_0 ()
{
  return new qt_gsi::GenericMethod ("select", "@brief Virtual method void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_select_6758_0, &_call_cbs_select_6758_0, &_set_callback_cbs_select_6758_0);
}


// void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_select_7090_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_select_7090_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QItemSelectionModel_Adaptor *)cls)->cbs_select_7090_0 (arg1, arg2);
}

static void _set_callback_cbs_select_7090_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_select_7090_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_select_7090_0 ()
{
  return new qt_gsi::GenericMethod ("select", "@hide", false, &_init_cbs_select_7090_0, &_call_cbs_select_7090_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_select_7090_0 ()
{
  return new qt_gsi::GenericMethod ("select", "@brief Virtual method void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_select_7090_0, &_call_cbs_select_7090_0, &_set_callback_cbs_select_7090_0);
}


// void QItemSelectionModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QItemSelectionModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QItemSelectionModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QItemSelectionModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QItemSelectionModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QItemSelectionModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QItemSelectionModel::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QItemSelectionModel_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QItemSelectionModel::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QItemSelectionModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QItemSelectionModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QItemSelectionModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QItemSelectionModel> decl_QItemSelectionModel;

gsi::Class<QItemSelectionModel_Adaptor> decl_QItemSelectionModel_Adaptor (decl_QItemSelectionModel, "QItemSelectionModel",
  gsi::Methods(_create_fp_emitSelectionChanged_5346 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_clear_0_0 ()) +
  gsi::Methods(_create_callback_cbs_clear_0_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_reset_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reset_0_0 ()) +
  gsi::Methods(_create_cbs_select_6758_0 ()) +
  gsi::Methods(_create_callback_cbs_select_6758_0 ()) +
  gsi::Methods(_create_cbs_select_7090_0 ()) +
  gsi::Methods(_create_callback_cbs_select_7090_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QItemSelectionModel_Adaptor_2419 ()) +
  gsi::Methods(_create_ctor_QItemSelectionModel_Adaptor_3613 ()),
  "@qt\n@brief Binding of QItemSelectionModel");

}


//  Implementation of the enum wrapper class for QItemSelectionModel::SelectionFlag
namespace qt_gsi
{

static QItemSelectionModel_SelectionFlag_Enum *c_1_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::NoUpdate); }
static QItemSelectionModel_SelectionFlag_Enum *c_2_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::Clear); }
static QItemSelectionModel_SelectionFlag_Enum *c_3_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::Select); }
static QItemSelectionModel_SelectionFlag_Enum *c_4_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::Deselect); }
static QItemSelectionModel_SelectionFlag_Enum *c_5_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::Toggle); }
static QItemSelectionModel_SelectionFlag_Enum *c_6_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::Current); }
static QItemSelectionModel_SelectionFlag_Enum *c_7_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::Rows); }
static QItemSelectionModel_SelectionFlag_Enum *c_8_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::Columns); }
static QItemSelectionModel_SelectionFlag_Enum *c_9_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::SelectCurrent); }
static QItemSelectionModel_SelectionFlag_Enum *c_10_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::ToggleCurrent); }
static QItemSelectionModel_SelectionFlag_Enum *c_11_QItemSelectionModel_SelectionFlag_Enum () { return new QItemSelectionModel_SelectionFlag_Enum (QItemSelectionModel::ClearAndSelect); }

static gsi::Methods mkdefs_QItemSelectionModel_SelectionFlag () {
  return
    gsi::constant ("NoUpdate", &qt_gsi::c_1_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::NoUpdate") +
    gsi::constant ("Clear", &qt_gsi::c_2_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::Clear") +
    gsi::constant ("Select", &qt_gsi::c_3_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::Select") +
    gsi::constant ("Deselect", &qt_gsi::c_4_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::Deselect") +
    gsi::constant ("Toggle", &qt_gsi::c_5_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::Toggle") +
    gsi::constant ("Current", &qt_gsi::c_6_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::Current") +
    gsi::constant ("Rows", &qt_gsi::c_7_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::Rows") +
    gsi::constant ("Columns", &qt_gsi::c_8_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::Columns") +
    gsi::constant ("SelectCurrent", &qt_gsi::c_9_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::SelectCurrent") +
    gsi::constant ("ToggleCurrent", &qt_gsi::c_10_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::ToggleCurrent") +
    gsi::constant ("ClearAndSelect", &qt_gsi::c_11_QItemSelectionModel_SelectionFlag_Enum, "@brief Enum constant QItemSelectionModel::ClearAndSelect");
}

static std::string to_s_QItemSelectionModel_SelectionFlag_Enum (const QItemSelectionModel_SelectionFlag_Enum *e)
{
  if (e->value () == QItemSelectionModel::NoUpdate) { return tl::sprintf ("NoUpdate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::Clear) { return tl::sprintf ("Clear (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::Select) { return tl::sprintf ("Select (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::Deselect) { return tl::sprintf ("Deselect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::Toggle) { return tl::sprintf ("Toggle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::Current) { return tl::sprintf ("Current (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::Rows) { return tl::sprintf ("Rows (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::Columns) { return tl::sprintf ("Columns (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::SelectCurrent) { return tl::sprintf ("SelectCurrent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::ToggleCurrent) { return tl::sprintf ("ToggleCurrent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QItemSelectionModel::ClearAndSelect) { return tl::sprintf ("ClearAndSelect (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QItemSelectionModel_SelectionFlag_Enum (const QItemSelectionModel_SelectionFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QItemSelectionModel_SelectionFlag_Enum *from_i_QItemSelectionModel_SelectionFlag_Enum (unsigned int i)
{
  return new QItemSelectionModel_SelectionFlag_Enum ((QItemSelectionModel::SelectionFlag) i);
}

static bool equalQItemSelectionModel_SelectionFlag_Enum (const QItemSelectionModel_SelectionFlag_Enum *e, QItemSelectionModel_SelectionFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QItemSelectionModel_SelectionFlag_Enum (const QItemSelectionModel_SelectionFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QItemSelectionModel_SelectionFlag_Enums oropQItemSelectionModel_SelectionFlag_Enums (const QItemSelectionModel_SelectionFlag_Enums *e, const QItemSelectionModel_SelectionFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QItemSelectionModel_SelectionFlag_Enums andopQItemSelectionModel_SelectionFlag_Enums (const QItemSelectionModel_SelectionFlag_Enums *e, const QItemSelectionModel_SelectionFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QItemSelectionModel_SelectionFlag_Enums xoropQItemSelectionModel_SelectionFlag_Enums (const QItemSelectionModel_SelectionFlag_Enums *e, const QItemSelectionModel_SelectionFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QItemSelectionModel_SelectionFlag_Enums (const QItemSelectionModel_SelectionFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QItemSelectionModel::NoUpdate)) { if (!l.empty ()) l += "|"; l += "NoUpdate"; }
  if (e->testFlag (QItemSelectionModel::Clear)) { if (!l.empty ()) l += "|"; l += "Clear"; }
  if (e->testFlag (QItemSelectionModel::Select)) { if (!l.empty ()) l += "|"; l += "Select"; }
  if (e->testFlag (QItemSelectionModel::Deselect)) { if (!l.empty ()) l += "|"; l += "Deselect"; }
  if (e->testFlag (QItemSelectionModel::Toggle)) { if (!l.empty ()) l += "|"; l += "Toggle"; }
  if (e->testFlag (QItemSelectionModel::Current)) { if (!l.empty ()) l += "|"; l += "Current"; }
  if (e->testFlag (QItemSelectionModel::Rows)) { if (!l.empty ()) l += "|"; l += "Rows"; }
  if (e->testFlag (QItemSelectionModel::Columns)) { if (!l.empty ()) l += "|"; l += "Columns"; }
  if (e->testFlag (QItemSelectionModel::SelectCurrent)) { if (!l.empty ()) l += "|"; l += "SelectCurrent"; }
  if (e->testFlag (QItemSelectionModel::ToggleCurrent)) { if (!l.empty ()) l += "|"; l += "ToggleCurrent"; }
  if (e->testFlag (QItemSelectionModel::ClearAndSelect)) { if (!l.empty ()) l += "|"; l += "ClearAndSelect"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QItemSelectionModel_SelectionFlag_Enums (const QItemSelectionModel_SelectionFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QItemSelectionModel_SelectionFlag_Enums (const QItemSelectionModel_SelectionFlag_Enums *e, const QItemSelectionModel_SelectionFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QItemSelectionModel_SelectionFlag_Enums> decl_QItemSelectionModel_SelectionFlag_Enums ("QItemSelectionModel_QFlags_SelectionFlag",
  gsi::method_ext ("|", &qt_gsi::oropQItemSelectionModel_SelectionFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQItemSelectionModel_SelectionFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQItemSelectionModel_SelectionFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QItemSelectionModel_SelectionFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QItemSelectionModel_SelectionFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QItemSelectionModel_SelectionFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QItemSelectionModel::SelectionFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QItemSelectionModel_SelectionFlag_Enum> decl_QItemSelectionModel_SelectionFlag_Enum (decl_QItemSelectionModel_SelectionFlag_Enums, "QItemSelectionModel_SelectionFlag",
  qt_gsi::mkdefs_QItemSelectionModel_SelectionFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QItemSelectionModel_SelectionFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QItemSelectionModel_SelectionFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQItemSelectionModel_SelectionFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QItemSelectionModel_SelectionFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QItemSelectionModel_SelectionFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QItemSelectionModel::SelectionFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QItemSelectionModel> inject_QItemSelectionModel_SelectionFlag_Enum_in_parent (qt_gsi::mkdefs_QItemSelectionModel_SelectionFlag ());
static gsi::ClassExt<QItemSelectionModel> decl_QItemSelectionModel_SelectionFlag_Enum_as_child (decl_QItemSelectionModel_SelectionFlag_Enum, "SelectionFlag");

}

