
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQItemDelegate.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQItemDelegate_EventAdaptor.h"
#include "gsiDeclQItemDelegate_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QItemDelegate

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QItemDelegate::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_createEditor_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_f_createEditor_c6860 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QWidget * > ((QWidget *)((QItemDelegate *)cls)->createEditor (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_createEditor_c6860 ()
{
  return new qt_gsi::GenericMethod ("createEditor", "@brief Method QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::createEditor", true, &_init_f_createEditor_c6860, &_call_f_createEditor_c6860);
}

// bool QItemDelegate::hasClipping()


static void _init_f_hasClipping_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasClipping_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QItemDelegate *)cls)->hasClipping ());
}

static qt_gsi::GenericMethod *_create_f_hasClipping_c0 ()
{
  return new qt_gsi::GenericMethod ("hasClipping|:clipping", "@brief Method bool QItemDelegate::hasClipping()\n", true, &_init_f_hasClipping_c0, &_call_f_hasClipping_c0);
}

// QItemEditorFactory *QItemDelegate::itemEditorFactory()


static void _init_f_itemEditorFactory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QItemEditorFactory * > ();
}

static void _call_f_itemEditorFactory_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QItemEditorFactory * > ((QItemEditorFactory *)((QItemDelegate *)cls)->itemEditorFactory ());
}

static qt_gsi::GenericMethod *_create_f_itemEditorFactory_c0 ()
{
  return new qt_gsi::GenericMethod (":itemEditorFactory", "@brief Method QItemEditorFactory *QItemDelegate::itemEditorFactory()\n", true, &_init_f_itemEditorFactory_c0, &_call_f_itemEditorFactory_c0);
}

// void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_paint_c6971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_c6971 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QItemDelegate *)cls)->paint (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_paint_c6971 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Method void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::paint", true, &_init_f_paint_c6971, &_call_f_paint_c6971);
}

// void QItemDelegate::setClipping(bool clip)


static void _init_f_setClipping_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("clip");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setClipping_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QItemDelegate *)cls)->setClipping (arg1);
}

static qt_gsi::GenericMethod *_create_f_setClipping_864 ()
{
  return new qt_gsi::GenericMethod ("setClipping|clipping=", "@brief Method void QItemDelegate::setClipping(bool clip)\n", false, &_init_f_setClipping_864, &_call_f_setClipping_864);
}

// void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)


static void _init_f_setEditorData_c3602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEditorData_c3602 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QItemDelegate *)cls)->setEditorData (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setEditorData_c3602 ()
{
  return new qt_gsi::GenericMethod ("setEditorData", "@brief Method void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::setEditorData", true, &_init_f_setEditorData_c3602, &_call_f_setEditorData_c3602);
}

// void QItemDelegate::setItemEditorFactory(QItemEditorFactory *factory)


static void _init_f_setItemEditorFactory_2445 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factory");
  decl->add_arg<QItemEditorFactory * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemEditorFactory_2445 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QItemEditorFactory *arg1 = args.read<QItemEditorFactory * > ();
  ((QItemDelegate *)cls)->setItemEditorFactory (arg1);
}

static qt_gsi::GenericMethod *_create_f_setItemEditorFactory_2445 ()
{
  return new qt_gsi::GenericMethod ("setItemEditorFactory|itemEditorFactory=", "@brief Method void QItemDelegate::setItemEditorFactory(QItemEditorFactory *factory)\n", false, &_init_f_setItemEditorFactory_2445, &_call_f_setItemEditorFactory_2445);
}

// void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)


static void _init_f_setModelData_c5913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setModelData_c5913 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QItemDelegate *)cls)->setModelData (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setModelData_c5913 ()
{
  return new qt_gsi::GenericMethod ("setModelData", "@brief Method void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::setModelData", true, &_init_f_setModelData_c5913, &_call_f_setModelData_c5913);
}

// QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_sizeHint_c5653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c5653 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QItemDelegate *)cls)->sizeHint (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c5653 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::sizeHint", true, &_init_f_sizeHint_c5653, &_call_f_sizeHint_c5653);
}

// void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_updateEditorGeometry_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_updateEditorGeometry_c6860 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QItemDelegate *)cls)->updateEditorGeometry (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_updateEditorGeometry_c6860 ()
{
  return new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Method void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::updateEditorGeometry", true, &_init_f_updateEditorGeometry_c6860, &_call_f_updateEditorGeometry_c6860);
}

// static QString QItemDelegate::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QItemDelegate::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QItemDelegate::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QItemDelegate::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QItemDelegate::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QItemDelegate::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QItemDelegate::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QItemDelegate::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QItemDelegate::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QItemDelegate::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QItemDelegate::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QItemDelegate::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QItemDelegate, QItemDelegate_EventAdaptor> ea_QItemDelegate;

namespace gsi
{
extern gsi::Class<QAbstractItemDelegate> decl_QAbstractItemDelegate;

gsi::Class<QItemDelegate> decl_QItemDelegate (ea_QItemDelegate, decl_QAbstractItemDelegate, "QItemDelegate_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_createEditor_c6860 ()) +
  gsi::Methods(_create_f_hasClipping_c0 ()) +
  gsi::Methods(_create_f_itemEditorFactory_c0 ()) +
  gsi::Methods(_create_f_paint_c6971 ()) +
  gsi::Methods(_create_f_setClipping_864 ()) +
  gsi::Methods(_create_f_setEditorData_c3602 ()) +
  gsi::Methods(_create_f_setItemEditorFactory_2445 ()) +
  gsi::Methods(_create_f_setModelData_c5913 ()) +
  gsi::Methods(_create_f_sizeHint_c5653 ()) +
  gsi::Methods(_create_f_updateEditorGeometry_c6860 ()) +
  qt_gsi::qt_signal<QItemDelegate, QItemDelegate_EventAdaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &> ("closeEditor", &QItemDelegate_EventAdaptor::closeEditor_e_4926, gsi::arg("editor"), gsi::arg("hint"), "@brief Signal declaration for QItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QItemDelegate, QItemDelegate_EventAdaptor, QWidget *> ("commitData", &QItemDelegate_EventAdaptor::commitData_e_1315, gsi::arg("editor"), "@brief Signal declaration for QItemDelegate::commitData(QWidget *editor)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QItemDelegate, QItemDelegate_EventAdaptor, QObject *> ("destroyed", &QItemDelegate_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QItemDelegate::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QItemDelegate, QItemDelegate_EventAdaptor, const QModelIndex &> ("sizeHintChanged", &QItemDelegate_EventAdaptor::sizeHintChanged_e_2395, gsi::arg("arg1"), "@brief Signal declaration for QItemDelegate::sizeHintChanged(const QModelIndex &)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QItemDelegate");
}


class QItemDelegate_Adaptor : public QItemDelegate, public qt_gsi::QtObjectBase
{
public:

  virtual ~QItemDelegate_Adaptor();

  //  [adaptor ctor] QItemDelegate::QItemDelegate(QObject *parent)
  QItemDelegate_Adaptor() : QItemDelegate()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QItemDelegate::QItemDelegate(QObject *parent)
  QItemDelegate_Adaptor(QObject *parent) : QItemDelegate(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  QRect QItemDelegate::check(const QStyleOptionViewItem &option, const QRect &bounding, const QVariant &variant)
  QRect fp_QItemDelegate_check_c7061 (const QStyleOptionViewItem &option, const QRect &bounding, const QVariant &variant) const {
    return QItemDelegate::check(option, bounding, variant);
  }

  //  QPixmap QItemDelegate::decoration(const QStyleOptionViewItem &option, const QVariant &variant)
  QPixmap fp_QItemDelegate_decoration_c5377 (const QStyleOptionViewItem &option, const QVariant &variant) const {
    return QItemDelegate::decoration(option, variant);
  }

  //  void QItemDelegate::doLayout(const QStyleOptionViewItem &option, QRect *checkRect, QRect *iconRect, QRect *textRect, bool hint)
  void fp_QItemDelegate_doLayout_c7101 (const QStyleOptionViewItem &option, QRect *checkRect, QRect *iconRect, QRect *textRect, bool hint) const {
    QItemDelegate::doLayout(option, checkRect, iconRect, textRect, hint);
  }

  //  void QItemDelegate::drawBackground(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)
  void fp_QItemDelegate_drawBackground_c6971 (QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    QItemDelegate::drawBackground(painter, option, index);
  }

  //  int QItemDelegate::receivers(const char *signal)
  int fp_QItemDelegate_receivers_c1731 (const char *signal) const {
    return QItemDelegate::receivers(signal);
  }

  //  QRect QItemDelegate::rect(const QStyleOptionViewItem &option, const QModelIndex &index, int role)
  QRect fp_QItemDelegate_rect_c6312 (const QStyleOptionViewItem &option, const QModelIndex &index, int role) const {
    return QItemDelegate::rect(option, index, role);
  }

  //  QPixmap *QItemDelegate::selected(const QPixmap &pixmap, const QPalette &palette, bool enabled)
  QPixmap * fp_QItemDelegate_selected_c4778 (const QPixmap &pixmap, const QPalette &palette, bool enabled) const {
    return QItemDelegate::selected(pixmap, palette, enabled);
  }

  //  QObject *QItemDelegate::sender()
  QObject * fp_QItemDelegate_sender_c0 () const {
    return QItemDelegate::sender();
  }

  //  QStyleOptionViewItem QItemDelegate::setOptions(const QModelIndex &index, const QStyleOptionViewItem &option)
  QStyleOptionViewItem fp_QItemDelegate_setOptions_c5653 (const QModelIndex &index, const QStyleOptionViewItem &option) const {
    return QItemDelegate::setOptions(index, option);
  }

  //  QRect QItemDelegate::textRectangle(QPainter *painter, const QRect &rect, const QFont &font, const QString &text)
  QRect fp_QItemDelegate_textRectangle_c6720 (QPainter *painter, const QRect &rect, const QFont &font, const QString &text) const {
    return QItemDelegate::textRectangle(painter, rect, font, text);
  }

  //  [adaptor impl] QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)
  QWidget * cbs_createEditor_c6860_0(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    return QItemDelegate::createEditor(parent, option, index);
  }

  virtual QWidget * createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_createEditor_c6860_0.can_issue()) {
      return cb_createEditor_c6860_0.issue<QItemDelegate_Adaptor, QWidget *, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_createEditor_c6860_0, parent, option, index);
    } else {
      return QItemDelegate::createEditor(parent, option, index);
    }
  }

  //  [adaptor impl] bool QItemDelegate::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QItemDelegate::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QItemDelegate_Adaptor, bool, QEvent *>(&QItemDelegate_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QItemDelegate::event(arg1);
    }
  }

  //  [adaptor impl] void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_paint_c6971_0(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    QItemDelegate::paint(painter, option, index);
  }

  virtual void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_paint_c6971_0.can_issue()) {
      cb_paint_c6971_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_paint_c6971_0, painter, option, index);
    } else {
      QItemDelegate::paint(painter, option, index);
    }
  }

  //  [adaptor impl] void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)
  void cbs_setEditorData_c3602_0(QWidget *editor, const QModelIndex &index) const
  {
    QItemDelegate::setEditorData(editor, index);
  }

  virtual void setEditorData(QWidget *editor, const QModelIndex &index) const
  {
    if (cb_setEditorData_c3602_0.can_issue()) {
      cb_setEditorData_c3602_0.issue<QItemDelegate_Adaptor, QWidget *, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_setEditorData_c3602_0, editor, index);
    } else {
      QItemDelegate::setEditorData(editor, index);
    }
  }

  //  [adaptor impl] void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)
  void cbs_setModelData_c5913_0(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    QItemDelegate::setModelData(editor, model, index);
  }

  virtual void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    if (cb_setModelData_c5913_0.can_issue()) {
      cb_setModelData_c5913_0.issue<QItemDelegate_Adaptor, QWidget *, QAbstractItemModel *, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_setModelData_c5913_0, editor, model, index);
    } else {
      QItemDelegate::setModelData(editor, model, index);
    }
  }

  //  [adaptor impl] QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)
  QSize cbs_sizeHint_c5653_0(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    return QItemDelegate::sizeHint(option, index);
  }

  virtual QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_sizeHint_c5653_0.can_issue()) {
      return cb_sizeHint_c5653_0.issue<QItemDelegate_Adaptor, QSize, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_sizeHint_c5653_0, option, index);
    } else {
      return QItemDelegate::sizeHint(option, index);
    }
  }

  //  [adaptor impl] void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_updateEditorGeometry_c6860_0(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    QItemDelegate::updateEditorGeometry(editor, option, index);
  }

  virtual void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_updateEditorGeometry_c6860_0.can_issue()) {
      cb_updateEditorGeometry_c6860_0.issue<QItemDelegate_Adaptor, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_updateEditorGeometry_c6860_0, editor, option, index);
    } else {
      QItemDelegate::updateEditorGeometry(editor, option, index);
    }
  }

  //  [adaptor impl] void QItemDelegate::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QItemDelegate::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QItemDelegate_Adaptor, QChildEvent *>(&QItemDelegate_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QItemDelegate::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QItemDelegate::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QItemDelegate::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QItemDelegate_Adaptor, QEvent *>(&QItemDelegate_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QItemDelegate::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QItemDelegate::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QItemDelegate::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QItemDelegate_Adaptor, const char *>(&QItemDelegate_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QItemDelegate::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QItemDelegate::drawCheck(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, Qt::CheckState state)
  void cbs_drawCheck_c8000_0(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const qt_gsi::Converter<Qt::CheckState>::target_type & state) const
  {
    QItemDelegate::drawCheck(painter, option, rect, qt_gsi::QtToCppAdaptor<Qt::CheckState>(state).cref());
  }

  virtual void drawCheck(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, Qt::CheckState state) const
  {
    if (cb_drawCheck_c8000_0.can_issue()) {
      cb_drawCheck_c8000_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QRect &, const qt_gsi::Converter<Qt::CheckState>::target_type &>(&QItemDelegate_Adaptor::cbs_drawCheck_c8000_0, painter, option, rect, qt_gsi::CppToQtAdaptor<Qt::CheckState>(state));
    } else {
      QItemDelegate::drawCheck(painter, option, rect, state);
    }
  }

  //  [adaptor impl] void QItemDelegate::drawDecoration(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap)
  void cbs_drawDecoration_c8277_0(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap) const
  {
    QItemDelegate::drawDecoration(painter, option, rect, pixmap);
  }

  virtual void drawDecoration(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap) const
  {
    if (cb_drawDecoration_c8277_0.can_issue()) {
      cb_drawDecoration_c8277_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QRect &, const QPixmap &>(&QItemDelegate_Adaptor::cbs_drawDecoration_c8277_0, painter, option, rect, pixmap);
    } else {
      QItemDelegate::drawDecoration(painter, option, rect, pixmap);
    }
  }

  //  [adaptor impl] void QItemDelegate::drawDisplay(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text)
  void cbs_drawDisplay_c8285_0(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text) const
  {
    QItemDelegate::drawDisplay(painter, option, rect, text);
  }

  virtual void drawDisplay(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text) const
  {
    if (cb_drawDisplay_c8285_0.can_issue()) {
      cb_drawDisplay_c8285_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QRect &, const QString &>(&QItemDelegate_Adaptor::cbs_drawDisplay_c8285_0, painter, option, rect, text);
    } else {
      QItemDelegate::drawDisplay(painter, option, rect, text);
    }
  }

  //  [adaptor impl] void QItemDelegate::drawFocus(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect)
  void cbs_drawFocus_c6368_0(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect) const
  {
    QItemDelegate::drawFocus(painter, option, rect);
  }

  virtual void drawFocus(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect) const
  {
    if (cb_drawFocus_c6368_0.can_issue()) {
      cb_drawFocus_c6368_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QRect &>(&QItemDelegate_Adaptor::cbs_drawFocus_c6368_0, painter, option, rect);
    } else {
      QItemDelegate::drawFocus(painter, option, rect);
    }
  }

  //  [adaptor impl] bool QItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  bool cbs_editorEvent_9073_0(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    return QItemDelegate::editorEvent(event, model, option, index);
  }

  virtual bool editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    if (cb_editorEvent_9073_0.can_issue()) {
      return cb_editorEvent_9073_0.issue<QItemDelegate_Adaptor, bool, QEvent *, QAbstractItemModel *, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_editorEvent_9073_0, event, model, option, index);
    } else {
      return QItemDelegate::editorEvent(event, model, option, index);
    }
  }

  //  [adaptor impl] bool QItemDelegate::eventFilter(QObject *object, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *object, QEvent *event)
  {
    return QItemDelegate::eventFilter(object, event);
  }

  virtual bool eventFilter(QObject *object, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QItemDelegate_Adaptor, bool, QObject *, QEvent *>(&QItemDelegate_Adaptor::cbs_eventFilter_2411_0, object, event);
    } else {
      return QItemDelegate::eventFilter(object, event);
    }
  }

  //  [adaptor impl] void QItemDelegate::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QItemDelegate::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QItemDelegate_Adaptor, QTimerEvent *>(&QItemDelegate_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QItemDelegate::timerEvent(arg1);
    }
  }

  gsi::Callback cb_createEditor_c6860_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_paint_c6971_0;
  gsi::Callback cb_setEditorData_c3602_0;
  gsi::Callback cb_setModelData_c5913_0;
  gsi::Callback cb_sizeHint_c5653_0;
  gsi::Callback cb_updateEditorGeometry_c6860_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_drawCheck_c8000_0;
  gsi::Callback cb_drawDecoration_c8277_0;
  gsi::Callback cb_drawDisplay_c8285_0;
  gsi::Callback cb_drawFocus_c6368_0;
  gsi::Callback cb_editorEvent_9073_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QItemDelegate_Adaptor::~QItemDelegate_Adaptor() { }

//  Constructor QItemDelegate::QItemDelegate(QObject *parent) (adaptor class)

static void _init_ctor_QItemDelegate_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QItemDelegate_Adaptor *> ();
}

static void _call_ctor_QItemDelegate_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QItemDelegate_Adaptor *> (new QItemDelegate_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QItemDelegate_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QItemDelegate::QItemDelegate(QObject *parent)\nThis method creates an object of class QItemDelegate.", &_init_ctor_QItemDelegate_Adaptor_1302, &_call_ctor_QItemDelegate_Adaptor_1302);
}

// QRect QItemDelegate::check(const QStyleOptionViewItem &option, const QRect &bounding, const QVariant &variant)

static void _init_fp_check_c7061 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bounding");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("variant");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_fp_check_c7061 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > ();
  const QRect &arg2 = args.read<const QRect & > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  ret.write<QRect > ((QRect)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_check_c7061 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_check_c7061 ()
{
  return new qt_gsi::GenericMethod("*check", "@brief Method QRect QItemDelegate::check(const QStyleOptionViewItem &option, const QRect &bounding, const QVariant &variant)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_check_c7061, &_call_fp_check_c7061);
}


// QPixmap QItemDelegate::decoration(const QStyleOptionViewItem &option, const QVariant &variant)

static void _init_fp_decoration_c5377 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_fp_decoration_c5377 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ret.write<QPixmap > ((QPixmap)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_decoration_c5377 (arg1, arg2));
}

static qt_gsi::GenericMethod*_create_fp_decoration_c5377 ()
{
  return new qt_gsi::GenericMethod("*decoration", "@brief Method QPixmap QItemDelegate::decoration(const QStyleOptionViewItem &option, const QVariant &variant)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_decoration_c5377, &_call_fp_decoration_c5377);
}


// void QItemDelegate::doLayout(const QStyleOptionViewItem &option, QRect *checkRect, QRect *iconRect, QRect *textRect, bool hint)

static void _init_fp_doLayout_c7101 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("checkRect");
  decl->add_arg<QRect * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("iconRect");
  decl->add_arg<QRect * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("textRect");
  decl->add_arg<QRect * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("hint");
  decl->add_arg<bool > (argspec_4);
  decl->set_return<void > ();
}

static void _call_fp_doLayout_c7101 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > ();
  QRect *arg2 = args.read<QRect * > ();
  QRect *arg3 = args.read<QRect * > ();
  QRect *arg4 = args.read<QRect * > ();
  bool arg5 = args.read<bool > ();
  ((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_doLayout_c7101 (arg1, arg2, arg3, arg4, arg5);
}

static qt_gsi::GenericMethod*_create_fp_doLayout_c7101 ()
{
  return new qt_gsi::GenericMethod("*doLayout", "@brief Method void QItemDelegate::doLayout(const QStyleOptionViewItem &option, QRect *checkRect, QRect *iconRect, QRect *textRect, bool hint)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_doLayout_c7101, &_call_fp_doLayout_c7101);
}


// void QItemDelegate::drawBackground(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_fp_drawBackground_c6971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_drawBackground_c6971 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_drawBackground_c6971 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_drawBackground_c6971 ()
{
  return new qt_gsi::GenericMethod("*drawBackground", "@brief Method void QItemDelegate::drawBackground(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_drawBackground_c6971, &_call_fp_drawBackground_c6971);
}


// int QItemDelegate::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QItemDelegate::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QRect QItemDelegate::rect(const QStyleOptionViewItem &option, const QModelIndex &index, int role)

static void _init_fp_rect_c6312 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_fp_rect_c6312 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  int arg3 = args.read<int > ();
  ret.write<QRect > ((QRect)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_rect_c6312 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_rect_c6312 ()
{
  return new qt_gsi::GenericMethod("*rect", "@brief Method QRect QItemDelegate::rect(const QStyleOptionViewItem &option, const QModelIndex &index, int role)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_rect_c6312, &_call_fp_rect_c6312);
}


// QPixmap *QItemDelegate::selected(const QPixmap &pixmap, const QPalette &palette, bool enabled)

static void _init_fp_selected_c4778 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("palette");
  decl->add_arg<const QPalette & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("enabled");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<QPixmap * > ();
}

static void _call_fp_selected_c4778 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPixmap &arg1 = args.read<const QPixmap & > ();
  const QPalette &arg2 = args.read<const QPalette & > ();
  bool arg3 = args.read<bool > ();
  ret.write<QPixmap * > ((QPixmap *)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_selected_c4778 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_selected_c4778 ()
{
  return new qt_gsi::GenericMethod("*selected", "@brief Method QPixmap *QItemDelegate::selected(const QPixmap &pixmap, const QPalette &palette, bool enabled)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_selected_c4778, &_call_fp_selected_c4778);
}


// QObject *QItemDelegate::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QItemDelegate::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QStyleOptionViewItem QItemDelegate::setOptions(const QModelIndex &index, const QStyleOptionViewItem &option)

static void _init_fp_setOptions_c5653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  decl->set_return<QStyleOptionViewItem > ();
}

static void _call_fp_setOptions_c5653 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  ret.write<QStyleOptionViewItem > ((QStyleOptionViewItem)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_setOptions_c5653 (arg1, arg2));
}

static qt_gsi::GenericMethod*_create_fp_setOptions_c5653 ()
{
  return new qt_gsi::GenericMethod("*setOptions", "@brief Method QStyleOptionViewItem QItemDelegate::setOptions(const QModelIndex &index, const QStyleOptionViewItem &option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_setOptions_c5653, &_call_fp_setOptions_c5653);
}


// QRect QItemDelegate::textRectangle(QPainter *painter, const QRect &rect, const QFont &font, const QString &text)

static void _init_fp_textRectangle_c6720 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("font");
  decl->add_arg<const QFont & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("text");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_fp_textRectangle_c6720 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  const QFont &arg3 = args.read<const QFont & > ();
  const QString &arg4 = args.read<const QString & > ();
  ret.write<QRect > ((QRect)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_textRectangle_c6720 (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod*_create_fp_textRectangle_c6720 ()
{
  return new qt_gsi::GenericMethod("*textRectangle", "@brief Method QRect QItemDelegate::textRectangle(QPainter *painter, const QRect &rect, const QFont &font, const QString &text)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_textRectangle_c6720, &_call_fp_textRectangle_c6720);
}


// QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_createEditor_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_cbs_createEditor_c6860_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QWidget * > ((QWidget *)((QItemDelegate_Adaptor *)cls)->cbs_createEditor_c6860_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_createEditor_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_createEditor_c6860_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_createEditor_c6860_0 ()
{
  return new qt_gsi::GenericMethod ("createEditor", "@hide", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_createEditor_c6860_0 ()
{
  return new qt_gsi::GenericMethod ("createEditor", "@brief Virtual method QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0, &_set_callback_cbs_createEditor_c6860_0);
}


// bool QItemDelegate::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QItemDelegate_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QItemDelegate::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_paint_c6971_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_c6971_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_paint_c6971_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_c6971_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_paint_c6971_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paint_c6971_0 ()
{
  return new qt_gsi::GenericMethod ("paint", "@hide", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paint_c6971_0 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0, &_set_callback_cbs_paint_c6971_0);
}


// void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)

static void _init_cbs_setEditorData_c3602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setEditorData_c3602_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_setEditorData_c3602_0 (arg1, arg2);
}

static void _set_callback_cbs_setEditorData_c3602_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_setEditorData_c3602_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setEditorData_c3602_0 ()
{
  return new qt_gsi::GenericMethod ("setEditorData", "@hide", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setEditorData_c3602_0 ()
{
  return new qt_gsi::GenericMethod ("setEditorData", "@brief Virtual method void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0, &_set_callback_cbs_setEditorData_c3602_0);
}


// void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)

static void _init_cbs_setModelData_c5913_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_setModelData_c5913_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_setModelData_c5913_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_setModelData_c5913_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_setModelData_c5913_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setModelData_c5913_0 ()
{
  return new qt_gsi::GenericMethod ("setModelData", "@hide", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setModelData_c5913_0 ()
{
  return new qt_gsi::GenericMethod ("setModelData", "@brief Virtual method void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0, &_set_callback_cbs_setModelData_c5913_0);
}


// QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_sizeHint_c5653_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c5653_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QItemDelegate_Adaptor *)cls)->cbs_sizeHint_c5653_0 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c5653_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_sizeHint_c5653_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c5653_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c5653_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0, &_set_callback_cbs_sizeHint_c5653_0);
}


// void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_updateEditorGeometry_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometry_c6860_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_updateEditorGeometry_c6860_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_updateEditorGeometry_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_updateEditorGeometry_c6860_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorGeometry_c6860_0 ()
{
  return new qt_gsi::GenericMethod ("updateEditorGeometry", "@hide", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorGeometry_c6860_0 ()
{
  return new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Virtual method void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0, &_set_callback_cbs_updateEditorGeometry_c6860_0);
}


// void QItemDelegate::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QItemDelegate::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QItemDelegate::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QItemDelegate::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QItemDelegate::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QItemDelegate::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QItemDelegate::drawCheck(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, Qt::CheckState state)

static void _init_cbs_drawCheck_c8000_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("state");
  decl->add_arg<const qt_gsi::Converter<Qt::CheckState>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawCheck_c8000_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QRect &arg3 = args.read<const QRect & > ();
  const qt_gsi::Converter<Qt::CheckState>::target_type & arg4 = args.read<const qt_gsi::Converter<Qt::CheckState>::target_type & > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_drawCheck_c8000_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawCheck_c8000_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_drawCheck_c8000_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawCheck_c8000_0 ()
{
  return new qt_gsi::GenericMethod ("*drawCheck", "@hide", true, &_init_cbs_drawCheck_c8000_0, &_call_cbs_drawCheck_c8000_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawCheck_c8000_0 ()
{
  return new qt_gsi::GenericMethod ("*drawCheck", "@brief Virtual method void QItemDelegate::drawCheck(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, Qt::CheckState state)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawCheck_c8000_0, &_call_cbs_drawCheck_c8000_0, &_set_callback_cbs_drawCheck_c8000_0);
}


// void QItemDelegate::drawDecoration(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap)

static void _init_cbs_drawDecoration_c8277_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawDecoration_c8277_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QRect &arg3 = args.read<const QRect & > ();
  const QPixmap &arg4 = args.read<const QPixmap & > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_drawDecoration_c8277_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawDecoration_c8277_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_drawDecoration_c8277_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawDecoration_c8277_0 ()
{
  return new qt_gsi::GenericMethod ("*drawDecoration", "@hide", true, &_init_cbs_drawDecoration_c8277_0, &_call_cbs_drawDecoration_c8277_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawDecoration_c8277_0 ()
{
  return new qt_gsi::GenericMethod ("*drawDecoration", "@brief Virtual method void QItemDelegate::drawDecoration(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawDecoration_c8277_0, &_call_cbs_drawDecoration_c8277_0, &_set_callback_cbs_drawDecoration_c8277_0);
}


// void QItemDelegate::drawDisplay(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text)

static void _init_cbs_drawDisplay_c8285_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("text");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawDisplay_c8285_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QRect &arg3 = args.read<const QRect & > ();
  const QString &arg4 = args.read<const QString & > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_drawDisplay_c8285_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawDisplay_c8285_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_drawDisplay_c8285_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawDisplay_c8285_0 ()
{
  return new qt_gsi::GenericMethod ("*drawDisplay", "@hide", true, &_init_cbs_drawDisplay_c8285_0, &_call_cbs_drawDisplay_c8285_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawDisplay_c8285_0 ()
{
  return new qt_gsi::GenericMethod ("*drawDisplay", "@brief Virtual method void QItemDelegate::drawDisplay(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawDisplay_c8285_0, &_call_cbs_drawDisplay_c8285_0, &_set_callback_cbs_drawDisplay_c8285_0);
}


// void QItemDelegate::drawFocus(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect)

static void _init_cbs_drawFocus_c6368_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawFocus_c6368_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > ();
  const QRect &arg3 = args.read<const QRect & > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_drawFocus_c6368_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawFocus_c6368_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_drawFocus_c6368_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawFocus_c6368_0 ()
{
  return new qt_gsi::GenericMethod ("*drawFocus", "@hide", true, &_init_cbs_drawFocus_c6368_0, &_call_cbs_drawFocus_c6368_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawFocus_c6368_0 ()
{
  return new qt_gsi::GenericMethod ("*drawFocus", "@brief Virtual method void QItemDelegate::drawFocus(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawFocus_c6368_0, &_call_cbs_drawFocus_c6368_0, &_set_callback_cbs_drawFocus_c6368_0);
}


// bool QItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_editorEvent_9073_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("index");
  decl->add_arg<const QModelIndex & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_editorEvent_9073_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > ();
  const QStyleOptionViewItem &arg3 = args.read<const QStyleOptionViewItem & > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QItemDelegate_Adaptor *)cls)->cbs_editorEvent_9073_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_editorEvent_9073_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_editorEvent_9073_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_editorEvent_9073_0 ()
{
  return new qt_gsi::GenericMethod ("*editorEvent", "@hide", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_editorEvent_9073_0 ()
{
  return new qt_gsi::GenericMethod ("*editorEvent", "@brief Virtual method bool QItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0, &_set_callback_cbs_editorEvent_9073_0);
}


// bool QItemDelegate::eventFilter(QObject *object, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QItemDelegate_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QItemDelegate::eventFilter(QObject *object, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QItemDelegate::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QItemDelegate_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QItemDelegate::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QItemDelegate> decl_QItemDelegate;

gsi::Class<QItemDelegate_Adaptor> decl_QItemDelegate_Adaptor (decl_QItemDelegate, "QItemDelegate",
  gsi::Methods(_create_fp_check_c7061 ()) +
  gsi::Methods(_create_fp_decoration_c5377 ()) +
  gsi::Methods(_create_fp_doLayout_c7101 ()) +
  gsi::Methods(_create_fp_drawBackground_c6971 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_rect_c6312 ()) +
  gsi::Methods(_create_fp_selected_c4778 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setOptions_c5653 ()) +
  gsi::Methods(_create_fp_textRectangle_c6720 ()) +
  gsi::Methods(_create_cbs_createEditor_c6860_0 ()) +
  gsi::Methods(_create_callback_cbs_createEditor_c6860_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_paint_c6971_0 ()) +
  gsi::Methods(_create_callback_cbs_paint_c6971_0 ()) +
  gsi::Methods(_create_cbs_setEditorData_c3602_0 ()) +
  gsi::Methods(_create_callback_cbs_setEditorData_c3602_0 ()) +
  gsi::Methods(_create_cbs_setModelData_c5913_0 ()) +
  gsi::Methods(_create_callback_cbs_setModelData_c5913_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c5653_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c5653_0 ()) +
  gsi::Methods(_create_cbs_updateEditorGeometry_c6860_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorGeometry_c6860_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_drawCheck_c8000_0 ()) +
  gsi::Methods(_create_callback_cbs_drawCheck_c8000_0 ()) +
  gsi::Methods(_create_cbs_drawDecoration_c8277_0 ()) +
  gsi::Methods(_create_callback_cbs_drawDecoration_c8277_0 ()) +
  gsi::Methods(_create_cbs_drawDisplay_c8285_0 ()) +
  gsi::Methods(_create_callback_cbs_drawDisplay_c8285_0 ()) +
  gsi::Methods(_create_cbs_drawFocus_c6368_0 ()) +
  gsi::Methods(_create_callback_cbs_drawFocus_c6368_0 ()) +
  gsi::Methods(_create_cbs_editorEvent_9073_0 ()) +
  gsi::Methods(_create_callback_cbs_editorEvent_9073_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QItemDelegate_Adaptor_1302 ()),
  "@qt\n@brief Binding of QItemDelegate");

}

