
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQImageReader.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQImageReader_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QImageReader

//  Constructor QImageReader::QImageReader()


static void _init_ctor_QImageReader_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QImageReader *> ();
}

static void _call_ctor_QImageReader_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QImageReader *> (new QImageReader ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImageReader_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImageReader::QImageReader()\nThis method creates an object of class QImageReader.", &_init_ctor_QImageReader_0, &_call_ctor_QImageReader_0);
}

//  Constructor QImageReader::QImageReader(QIODevice *device, const QByteArray &format)


static void _init_ctor_QImageReader_3648 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return_new<QImageReader *> ();
}

static void _call_ctor_QImageReader_3648 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  const QByteArray &arg2 = args ? args.read<const QByteArray & > () : (const QByteArray &)(QByteArray());
  ret.write<QImageReader *> (new QImageReader (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImageReader_3648 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImageReader::QImageReader(QIODevice *device, const QByteArray &format)\nThis method creates an object of class QImageReader.", &_init_ctor_QImageReader_3648, &_call_ctor_QImageReader_3648);
}

//  Constructor QImageReader::QImageReader(const QString &fileName, const QByteArray &format)


static void _init_ctor_QImageReader_4226 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return_new<QImageReader *> ();
}

static void _call_ctor_QImageReader_4226 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QByteArray &arg2 = args ? args.read<const QByteArray & > () : (const QByteArray &)(QByteArray());
  ret.write<QImageReader *> (new QImageReader (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImageReader_4226 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImageReader::QImageReader(const QString &fileName, const QByteArray &format)\nThis method creates an object of class QImageReader.", &_init_ctor_QImageReader_4226, &_call_ctor_QImageReader_4226);
}

// bool QImageReader::autoDetectImageFormat()


static void _init_f_autoDetectImageFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoDetectImageFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageReader *)cls)->autoDetectImageFormat ());
}

static qt_gsi::GenericMethod *_create_f_autoDetectImageFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":autoDetectImageFormat", "@brief Method bool QImageReader::autoDetectImageFormat()\n", true, &_init_f_autoDetectImageFormat_c0, &_call_f_autoDetectImageFormat_c0);
}

// QColor QImageReader::backgroundColor()


static void _init_f_backgroundColor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_backgroundColor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QColor > ((QColor)((QImageReader *)cls)->backgroundColor ());
}

static qt_gsi::GenericMethod *_create_f_backgroundColor_c0 ()
{
  return new qt_gsi::GenericMethod (":backgroundColor", "@brief Method QColor QImageReader::backgroundColor()\n", true, &_init_f_backgroundColor_c0, &_call_f_backgroundColor_c0);
}

// bool QImageReader::canRead()


static void _init_f_canRead_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canRead_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageReader *)cls)->canRead ());
}

static qt_gsi::GenericMethod *_create_f_canRead_c0 ()
{
  return new qt_gsi::GenericMethod ("canRead", "@brief Method bool QImageReader::canRead()\n", true, &_init_f_canRead_c0, &_call_f_canRead_c0);
}

// QRect QImageReader::clipRect()


static void _init_f_clipRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_clipRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QImageReader *)cls)->clipRect ());
}

static qt_gsi::GenericMethod *_create_f_clipRect_c0 ()
{
  return new qt_gsi::GenericMethod (":clipRect", "@brief Method QRect QImageReader::clipRect()\n", true, &_init_f_clipRect_c0, &_call_f_clipRect_c0);
}

// int QImageReader::currentImageNumber()


static void _init_f_currentImageNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentImageNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageReader *)cls)->currentImageNumber ());
}

static qt_gsi::GenericMethod *_create_f_currentImageNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("currentImageNumber", "@brief Method int QImageReader::currentImageNumber()\n", true, &_init_f_currentImageNumber_c0, &_call_f_currentImageNumber_c0);
}

// QRect QImageReader::currentImageRect()


static void _init_f_currentImageRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_currentImageRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QImageReader *)cls)->currentImageRect ());
}

static qt_gsi::GenericMethod *_create_f_currentImageRect_c0 ()
{
  return new qt_gsi::GenericMethod ("currentImageRect", "@brief Method QRect QImageReader::currentImageRect()\n", true, &_init_f_currentImageRect_c0, &_call_f_currentImageRect_c0);
}

// bool QImageReader::decideFormatFromContent()


static void _init_f_decideFormatFromContent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_decideFormatFromContent_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageReader *)cls)->decideFormatFromContent ());
}

static qt_gsi::GenericMethod *_create_f_decideFormatFromContent_c0 ()
{
  return new qt_gsi::GenericMethod (":decideFormatFromContent", "@brief Method bool QImageReader::decideFormatFromContent()\n", true, &_init_f_decideFormatFromContent_c0, &_call_f_decideFormatFromContent_c0);
}

// QIODevice *QImageReader::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIODevice * > ((QIODevice *)((QImageReader *)cls)->device ());
}

static qt_gsi::GenericMethod *_create_f_device_c0 ()
{
  return new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QImageReader::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
}

// QImageReader::ImageReaderError QImageReader::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QImageReader::ImageReaderError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QImageReader::ImageReaderError>::target_type > ((qt_gsi::Converter<QImageReader::ImageReaderError>::target_type)qt_gsi::CppToQtAdaptor<QImageReader::ImageReaderError>(((QImageReader *)cls)->error ()));
}

static qt_gsi::GenericMethod *_create_f_error_c0 ()
{
  return new qt_gsi::GenericMethod ("error", "@brief Method QImageReader::ImageReaderError QImageReader::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
}

// QString QImageReader::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QImageReader *)cls)->errorString ());
}

static qt_gsi::GenericMethod *_create_f_errorString_c0 ()
{
  return new qt_gsi::GenericMethod ("errorString", "@brief Method QString QImageReader::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
}

// QString QImageReader::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QImageReader *)cls)->fileName ());
}

static qt_gsi::GenericMethod *_create_f_fileName_c0 ()
{
  return new qt_gsi::GenericMethod (":fileName", "@brief Method QString QImageReader::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
}

// QByteArray QImageReader::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QImageReader *)cls)->format ());
}

static qt_gsi::GenericMethod *_create_f_format_c0 ()
{
  return new qt_gsi::GenericMethod (":format", "@brief Method QByteArray QImageReader::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
}

// int QImageReader::imageCount()


static void _init_f_imageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_imageCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageReader *)cls)->imageCount ());
}

static qt_gsi::GenericMethod *_create_f_imageCount_c0 ()
{
  return new qt_gsi::GenericMethod ("imageCount", "@brief Method int QImageReader::imageCount()\n", true, &_init_f_imageCount_c0, &_call_f_imageCount_c0);
}

// QImage::Format QImageReader::imageFormat()


static void _init_f_imageFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QImage::Format>::target_type > ();
}

static void _call_f_imageFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QImage::Format>::target_type > ((qt_gsi::Converter<QImage::Format>::target_type)qt_gsi::CppToQtAdaptor<QImage::Format>(((QImageReader *)cls)->imageFormat ()));
}

static qt_gsi::GenericMethod *_create_f_imageFormat_c0 ()
{
  return new qt_gsi::GenericMethod ("imageFormat", "@brief Method QImage::Format QImageReader::imageFormat()\n", true, &_init_f_imageFormat_c0, &_call_f_imageFormat_c0);
}

// bool QImageReader::jumpToImage(int imageNumber)


static void _init_f_jumpToImage_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("imageNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_jumpToImage_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QImageReader *)cls)->jumpToImage (arg1));
}

static qt_gsi::GenericMethod *_create_f_jumpToImage_767 ()
{
  return new qt_gsi::GenericMethod ("jumpToImage", "@brief Method bool QImageReader::jumpToImage(int imageNumber)\n", false, &_init_f_jumpToImage_767, &_call_f_jumpToImage_767);
}

// bool QImageReader::jumpToNextImage()


static void _init_f_jumpToNextImage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_jumpToNextImage_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageReader *)cls)->jumpToNextImage ());
}

static qt_gsi::GenericMethod *_create_f_jumpToNextImage_0 ()
{
  return new qt_gsi::GenericMethod ("jumpToNextImage", "@brief Method bool QImageReader::jumpToNextImage()\n", false, &_init_f_jumpToNextImage_0, &_call_f_jumpToNextImage_0);
}

// int QImageReader::loopCount()


static void _init_f_loopCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_loopCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageReader *)cls)->loopCount ());
}

static qt_gsi::GenericMethod *_create_f_loopCount_c0 ()
{
  return new qt_gsi::GenericMethod ("loopCount", "@brief Method int QImageReader::loopCount()\n", true, &_init_f_loopCount_c0, &_call_f_loopCount_c0);
}

// int QImageReader::nextImageDelay()


static void _init_f_nextImageDelay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_nextImageDelay_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageReader *)cls)->nextImageDelay ());
}

static qt_gsi::GenericMethod *_create_f_nextImageDelay_c0 ()
{
  return new qt_gsi::GenericMethod ("nextImageDelay", "@brief Method int QImageReader::nextImageDelay()\n", true, &_init_f_nextImageDelay_c0, &_call_f_nextImageDelay_c0);
}

// int QImageReader::quality()


static void _init_f_quality_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_quality_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageReader *)cls)->quality ());
}

static qt_gsi::GenericMethod *_create_f_quality_c0 ()
{
  return new qt_gsi::GenericMethod (":quality", "@brief Method int QImageReader::quality()\n", true, &_init_f_quality_c0, &_call_f_quality_c0);
}

// QImage QImageReader::read()


static void _init_f_read_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_f_read_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QImage > ((QImage)((QImageReader *)cls)->read ());
}

static qt_gsi::GenericMethod *_create_f_read_0 ()
{
  return new qt_gsi::GenericMethod ("read", "@brief Method QImage QImageReader::read()\n", false, &_init_f_read_0, &_call_f_read_0);
}

// bool QImageReader::read(QImage *image)


static void _init_f_read_1186 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<QImage * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_read_1186 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QImage *arg1 = args.read<QImage * > ();
  ret.write<bool > ((bool)((QImageReader *)cls)->read (arg1));
}

static qt_gsi::GenericMethod *_create_f_read_1186 ()
{
  return new qt_gsi::GenericMethod ("read", "@brief Method bool QImageReader::read(QImage *image)\n", false, &_init_f_read_1186, &_call_f_read_1186);
}

// QRect QImageReader::scaledClipRect()


static void _init_f_scaledClipRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_scaledClipRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QImageReader *)cls)->scaledClipRect ());
}

static qt_gsi::GenericMethod *_create_f_scaledClipRect_c0 ()
{
  return new qt_gsi::GenericMethod (":scaledClipRect", "@brief Method QRect QImageReader::scaledClipRect()\n", true, &_init_f_scaledClipRect_c0, &_call_f_scaledClipRect_c0);
}

// QSize QImageReader::scaledSize()


static void _init_f_scaledSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_scaledSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QImageReader *)cls)->scaledSize ());
}

static qt_gsi::GenericMethod *_create_f_scaledSize_c0 ()
{
  return new qt_gsi::GenericMethod (":scaledSize", "@brief Method QSize QImageReader::scaledSize()\n", true, &_init_f_scaledSize_c0, &_call_f_scaledSize_c0);
}

// void QImageReader::setAutoDetectImageFormat(bool enabled)


static void _init_f_setAutoDetectImageFormat_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoDetectImageFormat_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QImageReader *)cls)->setAutoDetectImageFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoDetectImageFormat_864 ()
{
  return new qt_gsi::GenericMethod ("setAutoDetectImageFormat|autoDetectImageFormat=", "@brief Method void QImageReader::setAutoDetectImageFormat(bool enabled)\n", false, &_init_f_setAutoDetectImageFormat_864, &_call_f_setAutoDetectImageFormat_864);
}

// void QImageReader::setBackgroundColor(const QColor &color)


static void _init_f_setBackgroundColor_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundColor_1905 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args.read<const QColor & > ();
  ((QImageReader *)cls)->setBackgroundColor (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBackgroundColor_1905 ()
{
  return new qt_gsi::GenericMethod ("setBackgroundColor|backgroundColor=", "@brief Method void QImageReader::setBackgroundColor(const QColor &color)\n", false, &_init_f_setBackgroundColor_1905, &_call_f_setBackgroundColor_1905);
}

// void QImageReader::setClipRect(const QRect &rect)


static void _init_f_setClipRect_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setClipRect_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QImageReader *)cls)->setClipRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_setClipRect_1792 ()
{
  return new qt_gsi::GenericMethod ("setClipRect|clipRect=", "@brief Method void QImageReader::setClipRect(const QRect &rect)\n", false, &_init_f_setClipRect_1792, &_call_f_setClipRect_1792);
}

// void QImageReader::setDecideFormatFromContent(bool ignored)


static void _init_f_setDecideFormatFromContent_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ignored");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDecideFormatFromContent_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QImageReader *)cls)->setDecideFormatFromContent (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDecideFormatFromContent_864 ()
{
  return new qt_gsi::GenericMethod ("setDecideFormatFromContent|decideFormatFromContent=", "@brief Method void QImageReader::setDecideFormatFromContent(bool ignored)\n", false, &_init_f_setDecideFormatFromContent_864, &_call_f_setDecideFormatFromContent_864);
}

// void QImageReader::setDevice(QIODevice *device)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  ((QImageReader *)cls)->setDevice (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDevice_1447 ()
{
  return new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QImageReader::setDevice(QIODevice *device)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
}

// void QImageReader::setFileName(const QString &fileName)


static void _init_f_setFileName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QImageReader *)cls)->setFileName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFileName_2025 ()
{
  return new qt_gsi::GenericMethod ("setFileName|fileName=", "@brief Method void QImageReader::setFileName(const QString &fileName)\n", false, &_init_f_setFileName_2025, &_call_f_setFileName_2025);
}

// void QImageReader::setFormat(const QByteArray &format)


static void _init_f_setFormat_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QImageReader *)cls)->setFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFormat_2309 ()
{
  return new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QImageReader::setFormat(const QByteArray &format)\n", false, &_init_f_setFormat_2309, &_call_f_setFormat_2309);
}

// void QImageReader::setQuality(int quality)


static void _init_f_setQuality_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quality");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQuality_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QImageReader *)cls)->setQuality (arg1);
}

static qt_gsi::GenericMethod *_create_f_setQuality_767 ()
{
  return new qt_gsi::GenericMethod ("setQuality|quality=", "@brief Method void QImageReader::setQuality(int quality)\n", false, &_init_f_setQuality_767, &_call_f_setQuality_767);
}

// void QImageReader::setScaledClipRect(const QRect &rect)


static void _init_f_setScaledClipRect_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScaledClipRect_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QImageReader *)cls)->setScaledClipRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_setScaledClipRect_1792 ()
{
  return new qt_gsi::GenericMethod ("setScaledClipRect|scaledClipRect=", "@brief Method void QImageReader::setScaledClipRect(const QRect &rect)\n", false, &_init_f_setScaledClipRect_1792, &_call_f_setScaledClipRect_1792);
}

// void QImageReader::setScaledSize(const QSize &size)


static void _init_f_setScaledSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScaledSize_1805 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  ((QImageReader *)cls)->setScaledSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setScaledSize_1805 ()
{
  return new qt_gsi::GenericMethod ("setScaledSize|scaledSize=", "@brief Method void QImageReader::setScaledSize(const QSize &size)\n", false, &_init_f_setScaledSize_1805, &_call_f_setScaledSize_1805);
}

// QSize QImageReader::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QImageReader *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod ("size", "@brief Method QSize QImageReader::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// bool QImageReader::supportsAnimation()


static void _init_f_supportsAnimation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_supportsAnimation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageReader *)cls)->supportsAnimation ());
}

static qt_gsi::GenericMethod *_create_f_supportsAnimation_c0 ()
{
  return new qt_gsi::GenericMethod ("supportsAnimation", "@brief Method bool QImageReader::supportsAnimation()\n", true, &_init_f_supportsAnimation_c0, &_call_f_supportsAnimation_c0);
}

// bool QImageReader::supportsOption(QImageIOHandler::ImageOption option)


static void _init_f_supportsOption_c3086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_supportsOption_c3086 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > ();
  ret.write<bool > ((bool)((QImageReader *)cls)->supportsOption (qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_supportsOption_c3086 ()
{
  return new qt_gsi::GenericMethod ("supportsOption", "@brief Method bool QImageReader::supportsOption(QImageIOHandler::ImageOption option)\n", true, &_init_f_supportsOption_c3086, &_call_f_supportsOption_c3086);
}

// QString QImageReader::text(const QString &key)


static void _init_f_text_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_text_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)((QImageReader *)cls)->text (arg1));
}

static qt_gsi::GenericMethod *_create_f_text_c2025 ()
{
  return new qt_gsi::GenericMethod ("text", "@brief Method QString QImageReader::text(const QString &key)\n", true, &_init_f_text_c2025, &_call_f_text_c2025);
}

// QStringList QImageReader::textKeys()


static void _init_f_textKeys_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_textKeys_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QImageReader *)cls)->textKeys ()));
}

static qt_gsi::GenericMethod *_create_f_textKeys_c0 ()
{
  return new qt_gsi::GenericMethod ("textKeys", "@brief Method QStringList QImageReader::textKeys()\n", true, &_init_f_textKeys_c0, &_call_f_textKeys_c0);
}

// static QByteArray QImageReader::imageFormat(const QString &fileName)


static void _init_f_imageFormat_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_imageFormat_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QByteArray > ((QByteArray)QImageReader::imageFormat (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_imageFormat_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("imageFormat", "@brief Static method QByteArray QImageReader::imageFormat(const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_imageFormat_2025, &_call_f_imageFormat_2025);
}

// static QByteArray QImageReader::imageFormat(QIODevice *device)


static void _init_f_imageFormat_1447 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_imageFormat_1447 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  ret.write<QByteArray > ((QByteArray)QImageReader::imageFormat (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_imageFormat_1447 ()
{
  return new qt_gsi::GenericStaticMethod ("imageFormat", "@brief Static method QByteArray QImageReader::imageFormat(QIODevice *device)\nThis method is static and can be called without an instance.", &_init_f_imageFormat_1447, &_call_f_imageFormat_1447);
}

// static QList<QByteArray> QImageReader::supportedImageFormats()


static void _init_f_supportedImageFormats_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_f_supportedImageFormats_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)qt_gsi::CppToQtAdaptor<QList<QByteArray> >(QImageReader::supportedImageFormats ()));
}

static qt_gsi::GenericStaticMethod *_create_f_supportedImageFormats_0 ()
{
  return new qt_gsi::GenericStaticMethod ("supportedImageFormats", "@brief Static method QList<QByteArray> QImageReader::supportedImageFormats()\nThis method is static and can be called without an instance.", &_init_f_supportedImageFormats_0, &_call_f_supportedImageFormats_0);
}


namespace gsi
{
gsi::Class<QImageReader> decl_QImageReader ("QImageReader",
  gsi::Methods(_create_ctor_QImageReader_0 ()) +
  gsi::Methods(_create_ctor_QImageReader_3648 ()) +
  gsi::Methods(_create_ctor_QImageReader_4226 ()) +
  gsi::Methods(_create_f_autoDetectImageFormat_c0 ()) +
  gsi::Methods(_create_f_backgroundColor_c0 ()) +
  gsi::Methods(_create_f_canRead_c0 ()) +
  gsi::Methods(_create_f_clipRect_c0 ()) +
  gsi::Methods(_create_f_currentImageNumber_c0 ()) +
  gsi::Methods(_create_f_currentImageRect_c0 ()) +
  gsi::Methods(_create_f_decideFormatFromContent_c0 ()) +
  gsi::Methods(_create_f_device_c0 ()) +
  gsi::Methods(_create_f_error_c0 ()) +
  gsi::Methods(_create_f_errorString_c0 ()) +
  gsi::Methods(_create_f_fileName_c0 ()) +
  gsi::Methods(_create_f_format_c0 ()) +
  gsi::Methods(_create_f_imageCount_c0 ()) +
  gsi::Methods(_create_f_imageFormat_c0 ()) +
  gsi::Methods(_create_f_jumpToImage_767 ()) +
  gsi::Methods(_create_f_jumpToNextImage_0 ()) +
  gsi::Methods(_create_f_loopCount_c0 ()) +
  gsi::Methods(_create_f_nextImageDelay_c0 ()) +
  gsi::Methods(_create_f_quality_c0 ()) +
  gsi::Methods(_create_f_read_0 ()) +
  gsi::Methods(_create_f_read_1186 ()) +
  gsi::Methods(_create_f_scaledClipRect_c0 ()) +
  gsi::Methods(_create_f_scaledSize_c0 ()) +
  gsi::Methods(_create_f_setAutoDetectImageFormat_864 ()) +
  gsi::Methods(_create_f_setBackgroundColor_1905 ()) +
  gsi::Methods(_create_f_setClipRect_1792 ()) +
  gsi::Methods(_create_f_setDecideFormatFromContent_864 ()) +
  gsi::Methods(_create_f_setDevice_1447 ()) +
  gsi::Methods(_create_f_setFileName_2025 ()) +
  gsi::Methods(_create_f_setFormat_2309 ()) +
  gsi::Methods(_create_f_setQuality_767 ()) +
  gsi::Methods(_create_f_setScaledClipRect_1792 ()) +
  gsi::Methods(_create_f_setScaledSize_1805 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_supportsAnimation_c0 ()) +
  gsi::Methods(_create_f_supportsOption_c3086 ()) +
  gsi::Methods(_create_f_text_c2025 ()) +
  gsi::Methods(_create_f_textKeys_c0 ()) +
  gsi::Methods(_create_f_imageFormat_2025 ()) +
  gsi::Methods(_create_f_imageFormat_1447 ()) +
  gsi::Methods(_create_f_supportedImageFormats_0 ()),
  "@qt\n@brief Binding of QImageReader");

}


//  Implementation of the enum wrapper class for QImageReader::ImageReaderError
namespace qt_gsi
{

static QImageReader_ImageReaderError_Enum *c_1_QImageReader_ImageReaderError_Enum () { return new QImageReader_ImageReaderError_Enum (QImageReader::UnknownError); }
static QImageReader_ImageReaderError_Enum *c_2_QImageReader_ImageReaderError_Enum () { return new QImageReader_ImageReaderError_Enum (QImageReader::FileNotFoundError); }
static QImageReader_ImageReaderError_Enum *c_3_QImageReader_ImageReaderError_Enum () { return new QImageReader_ImageReaderError_Enum (QImageReader::DeviceError); }
static QImageReader_ImageReaderError_Enum *c_4_QImageReader_ImageReaderError_Enum () { return new QImageReader_ImageReaderError_Enum (QImageReader::UnsupportedFormatError); }
static QImageReader_ImageReaderError_Enum *c_5_QImageReader_ImageReaderError_Enum () { return new QImageReader_ImageReaderError_Enum (QImageReader::InvalidDataError); }

static gsi::Methods mkdefs_QImageReader_ImageReaderError () {
  return
    gsi::constant ("UnknownError", &qt_gsi::c_1_QImageReader_ImageReaderError_Enum, "@brief Enum constant QImageReader::UnknownError") +
    gsi::constant ("FileNotFoundError", &qt_gsi::c_2_QImageReader_ImageReaderError_Enum, "@brief Enum constant QImageReader::FileNotFoundError") +
    gsi::constant ("DeviceError", &qt_gsi::c_3_QImageReader_ImageReaderError_Enum, "@brief Enum constant QImageReader::DeviceError") +
    gsi::constant ("UnsupportedFormatError", &qt_gsi::c_4_QImageReader_ImageReaderError_Enum, "@brief Enum constant QImageReader::UnsupportedFormatError") +
    gsi::constant ("InvalidDataError", &qt_gsi::c_5_QImageReader_ImageReaderError_Enum, "@brief Enum constant QImageReader::InvalidDataError");
}

static std::string to_s_QImageReader_ImageReaderError_Enum (const QImageReader_ImageReaderError_Enum *e)
{
  if (e->value () == QImageReader::UnknownError) { return tl::sprintf ("UnknownError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageReader::FileNotFoundError) { return tl::sprintf ("FileNotFoundError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageReader::DeviceError) { return tl::sprintf ("DeviceError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageReader::UnsupportedFormatError) { return tl::sprintf ("UnsupportedFormatError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageReader::InvalidDataError) { return tl::sprintf ("InvalidDataError (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QImageReader_ImageReaderError_Enum (const QImageReader_ImageReaderError_Enum *e)
{
  return (unsigned int) e->value ();
}

static QImageReader_ImageReaderError_Enum *from_i_QImageReader_ImageReaderError_Enum (unsigned int i)
{
  return new QImageReader_ImageReaderError_Enum ((QImageReader::ImageReaderError) i);
}

static bool equalQImageReader_ImageReaderError_Enum (const QImageReader_ImageReaderError_Enum *e, QImageReader_ImageReaderError_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QImageReader_ImageReaderError_Enum (const QImageReader_ImageReaderError_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QImageReader_ImageReaderError_Enums oropQImageReader_ImageReaderError_Enums (const QImageReader_ImageReaderError_Enums *e, const QImageReader_ImageReaderError_Enums &d)
{
  return e->flags () | d.flags ();
}

static QImageReader_ImageReaderError_Enums andopQImageReader_ImageReaderError_Enums (const QImageReader_ImageReaderError_Enums *e, const QImageReader_ImageReaderError_Enums &d)
{
  return e->flags () & d.flags ();
}

static QImageReader_ImageReaderError_Enums xoropQImageReader_ImageReaderError_Enums (const QImageReader_ImageReaderError_Enums *e, const QImageReader_ImageReaderError_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QImageReader_ImageReaderError_Enums (const QImageReader_ImageReaderError_Enums *e)
{
  std::string l;
  if (e->testFlag (QImageReader::UnknownError)) { if (!l.empty ()) l += "|"; l += "UnknownError"; }
  if (e->testFlag (QImageReader::FileNotFoundError)) { if (!l.empty ()) l += "|"; l += "FileNotFoundError"; }
  if (e->testFlag (QImageReader::DeviceError)) { if (!l.empty ()) l += "|"; l += "DeviceError"; }
  if (e->testFlag (QImageReader::UnsupportedFormatError)) { if (!l.empty ()) l += "|"; l += "UnsupportedFormatError"; }
  if (e->testFlag (QImageReader::InvalidDataError)) { if (!l.empty ()) l += "|"; l += "InvalidDataError"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QImageReader_ImageReaderError_Enums (const QImageReader_ImageReaderError_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QImageReader_ImageReaderError_Enums (const QImageReader_ImageReaderError_Enums *e, const QImageReader_ImageReaderError_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QImageReader_ImageReaderError_Enums> decl_QImageReader_ImageReaderError_Enums ("QImageReader_QFlags_ImageReaderError",
  gsi::method_ext ("|", &qt_gsi::oropQImageReader_ImageReaderError_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQImageReader_ImageReaderError_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQImageReader_ImageReaderError_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImageReader_ImageReaderError_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImageReader_ImageReaderError_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QImageReader_ImageReaderError_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QImageReader::ImageReaderError> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QImageReader_ImageReaderError_Enum> decl_QImageReader_ImageReaderError_Enum (decl_QImageReader_ImageReaderError_Enums, "QImageReader_ImageReaderError",
  qt_gsi::mkdefs_QImageReader_ImageReaderError () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImageReader_ImageReaderError_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImageReader_ImageReaderError_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQImageReader_ImageReaderError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QImageReader_ImageReaderError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QImageReader_ImageReaderError_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QImageReader::ImageReaderError enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QImageReader> inject_QImageReader_ImageReaderError_Enum_in_parent (qt_gsi::mkdefs_QImageReader_ImageReaderError ());
static gsi::ClassExt<QImageReader> decl_QImageReader_ImageReaderError_Enum_as_child (decl_QImageReader_ImageReaderError_Enum, "ImageReaderError");

}

