
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQImageIOHandler.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQImageIOHandler_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QImageIOHandler

// bool QImageIOHandler::canRead()


static void _init_f_canRead_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canRead_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->canRead ());
}

static qt_gsi::GenericMethod *_create_f_canRead_c0 ()
{
  return new qt_gsi::GenericMethod ("canRead", "@brief Method bool QImageIOHandler::canRead()\n", true, &_init_f_canRead_c0, &_call_f_canRead_c0);
}

// int QImageIOHandler::currentImageNumber()


static void _init_f_currentImageNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentImageNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageIOHandler *)cls)->currentImageNumber ());
}

static qt_gsi::GenericMethod *_create_f_currentImageNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("currentImageNumber", "@brief Method int QImageIOHandler::currentImageNumber()\n", true, &_init_f_currentImageNumber_c0, &_call_f_currentImageNumber_c0);
}

// QRect QImageIOHandler::currentImageRect()


static void _init_f_currentImageRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_currentImageRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QImageIOHandler *)cls)->currentImageRect ());
}

static qt_gsi::GenericMethod *_create_f_currentImageRect_c0 ()
{
  return new qt_gsi::GenericMethod ("currentImageRect", "@brief Method QRect QImageIOHandler::currentImageRect()\n", true, &_init_f_currentImageRect_c0, &_call_f_currentImageRect_c0);
}

// QIODevice *QImageIOHandler::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIODevice * > ((QIODevice *)((QImageIOHandler *)cls)->device ());
}

static qt_gsi::GenericMethod *_create_f_device_c0 ()
{
  return new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QImageIOHandler::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
}

// QByteArray QImageIOHandler::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QImageIOHandler *)cls)->format ());
}

static qt_gsi::GenericMethod *_create_f_format_c0 ()
{
  return new qt_gsi::GenericMethod (":format", "@brief Method QByteArray QImageIOHandler::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
}

// int QImageIOHandler::imageCount()


static void _init_f_imageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_imageCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageIOHandler *)cls)->imageCount ());
}

static qt_gsi::GenericMethod *_create_f_imageCount_c0 ()
{
  return new qt_gsi::GenericMethod ("imageCount", "@brief Method int QImageIOHandler::imageCount()\n", true, &_init_f_imageCount_c0, &_call_f_imageCount_c0);
}

// bool QImageIOHandler::jumpToImage(int imageNumber)


static void _init_f_jumpToImage_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("imageNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_jumpToImage_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->jumpToImage (arg1));
}

static qt_gsi::GenericMethod *_create_f_jumpToImage_767 ()
{
  return new qt_gsi::GenericMethod ("jumpToImage", "@brief Method bool QImageIOHandler::jumpToImage(int imageNumber)\n", false, &_init_f_jumpToImage_767, &_call_f_jumpToImage_767);
}

// bool QImageIOHandler::jumpToNextImage()


static void _init_f_jumpToNextImage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_jumpToNextImage_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->jumpToNextImage ());
}

static qt_gsi::GenericMethod *_create_f_jumpToNextImage_0 ()
{
  return new qt_gsi::GenericMethod ("jumpToNextImage", "@brief Method bool QImageIOHandler::jumpToNextImage()\n", false, &_init_f_jumpToNextImage_0, &_call_f_jumpToNextImage_0);
}

// int QImageIOHandler::loopCount()


static void _init_f_loopCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_loopCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageIOHandler *)cls)->loopCount ());
}

static qt_gsi::GenericMethod *_create_f_loopCount_c0 ()
{
  return new qt_gsi::GenericMethod ("loopCount", "@brief Method int QImageIOHandler::loopCount()\n", true, &_init_f_loopCount_c0, &_call_f_loopCount_c0);
}

// QByteArray QImageIOHandler::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QImageIOHandler *)cls)->name ());
}

static qt_gsi::GenericMethod *_create_f_name_c0 ()
{
  return new qt_gsi::GenericMethod ("name", "@brief Method QByteArray QImageIOHandler::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
}

// int QImageIOHandler::nextImageDelay()


static void _init_f_nextImageDelay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_nextImageDelay_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageIOHandler *)cls)->nextImageDelay ());
}

static qt_gsi::GenericMethod *_create_f_nextImageDelay_c0 ()
{
  return new qt_gsi::GenericMethod ("nextImageDelay", "@brief Method int QImageIOHandler::nextImageDelay()\n", true, &_init_f_nextImageDelay_c0, &_call_f_nextImageDelay_c0);
}

// QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)


static void _init_f_option_c3086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_option_c3086 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QImageIOHandler *)cls)->option (qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_option_c3086 ()
{
  return new qt_gsi::GenericMethod ("option", "@brief Method QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)\n", true, &_init_f_option_c3086, &_call_f_option_c3086);
}

// bool QImageIOHandler::read(QImage *image)


static void _init_f_read_1186 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<QImage * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_read_1186 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QImage *arg1 = args.read<QImage * > ();
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->read (arg1));
}

static qt_gsi::GenericMethod *_create_f_read_1186 ()
{
  return new qt_gsi::GenericMethod ("read", "@brief Method bool QImageIOHandler::read(QImage *image)\n", false, &_init_f_read_1186, &_call_f_read_1186);
}

// void QImageIOHandler::setDevice(QIODevice *device)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  ((QImageIOHandler *)cls)->setDevice (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDevice_1447 ()
{
  return new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QImageIOHandler::setDevice(QIODevice *device)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
}

// void QImageIOHandler::setFormat(const QByteArray &format)


static void _init_f_setFormat_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QImageIOHandler *)cls)->setFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFormat_2309 ()
{
  return new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QImageIOHandler::setFormat(const QByteArray &format)\n", false, &_init_f_setFormat_2309, &_call_f_setFormat_2309);
}

// void QImageIOHandler::setFormat(const QByteArray &format)


static void _init_f_setFormat_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QImageIOHandler *)cls)->setFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFormat_c2309 ()
{
  return new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QImageIOHandler::setFormat(const QByteArray &format)\n", true, &_init_f_setFormat_c2309, &_call_f_setFormat_c2309);
}

// void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)


static void _init_f_setOption_5097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_5097 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QImageIOHandler *)cls)->setOption (qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setOption_5097 ()
{
  return new qt_gsi::GenericMethod ("setOption", "@brief Method void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)\n", false, &_init_f_setOption_5097, &_call_f_setOption_5097);
}

// bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)


static void _init_f_supportsOption_c3086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_supportsOption_c3086 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > ();
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->supportsOption (qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_supportsOption_c3086 ()
{
  return new qt_gsi::GenericMethod ("supportsOption", "@brief Method bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)\n", true, &_init_f_supportsOption_c3086, &_call_f_supportsOption_c3086);
}

// bool QImageIOHandler::write(const QImage &image)


static void _init_f_write_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_write_1877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->write (arg1));
}

static qt_gsi::GenericMethod *_create_f_write_1877 ()
{
  return new qt_gsi::GenericMethod ("write", "@brief Method bool QImageIOHandler::write(const QImage &image)\n", false, &_init_f_write_1877, &_call_f_write_1877);
}

namespace gsi
{
gsi::Class<QImageIOHandler> decl_QImageIOHandler ("QImageIOHandler_Native",
  gsi::Methods(_create_f_canRead_c0 ()) +
  gsi::Methods(_create_f_currentImageNumber_c0 ()) +
  gsi::Methods(_create_f_currentImageRect_c0 ()) +
  gsi::Methods(_create_f_device_c0 ()) +
  gsi::Methods(_create_f_format_c0 ()) +
  gsi::Methods(_create_f_imageCount_c0 ()) +
  gsi::Methods(_create_f_jumpToImage_767 ()) +
  gsi::Methods(_create_f_jumpToNextImage_0 ()) +
  gsi::Methods(_create_f_loopCount_c0 ()) +
  gsi::Methods(_create_f_name_c0 ()) +
  gsi::Methods(_create_f_nextImageDelay_c0 ()) +
  gsi::Methods(_create_f_option_c3086 ()) +
  gsi::Methods(_create_f_read_1186 ()) +
  gsi::Methods(_create_f_setDevice_1447 ()) +
  gsi::Methods(_create_f_setFormat_2309 ()) +
  gsi::Methods(_create_f_setFormat_c2309 ()) +
  gsi::Methods(_create_f_setOption_5097 ()) +
  gsi::Methods(_create_f_supportsOption_c3086 ()) +
  gsi::Methods(_create_f_write_1877 ()),
  "@hide\n@alias QImageIOHandler");
}


class QImageIOHandler_Adaptor : public QImageIOHandler, public qt_gsi::QtObjectBase
{
public:

  virtual ~QImageIOHandler_Adaptor();

  //  [adaptor ctor] QImageIOHandler::QImageIOHandler()
  QImageIOHandler_Adaptor() : QImageIOHandler()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] bool QImageIOHandler::canRead()
  bool cbs_canRead_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("canRead");
  }

  virtual bool canRead() const
  {
    if (cb_canRead_c0_0.can_issue()) {
      return cb_canRead_c0_0.issue<QImageIOHandler_Adaptor, bool>(&QImageIOHandler_Adaptor::cbs_canRead_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("canRead");
    }
  }

  //  [adaptor impl] int QImageIOHandler::currentImageNumber()
  int cbs_currentImageNumber_c0_0() const
  {
    return QImageIOHandler::currentImageNumber();
  }

  virtual int currentImageNumber() const
  {
    if (cb_currentImageNumber_c0_0.can_issue()) {
      return cb_currentImageNumber_c0_0.issue<QImageIOHandler_Adaptor, int>(&QImageIOHandler_Adaptor::cbs_currentImageNumber_c0_0);
    } else {
      return QImageIOHandler::currentImageNumber();
    }
  }

  //  [adaptor impl] QRect QImageIOHandler::currentImageRect()
  QRect cbs_currentImageRect_c0_0() const
  {
    return QImageIOHandler::currentImageRect();
  }

  virtual QRect currentImageRect() const
  {
    if (cb_currentImageRect_c0_0.can_issue()) {
      return cb_currentImageRect_c0_0.issue<QImageIOHandler_Adaptor, QRect>(&QImageIOHandler_Adaptor::cbs_currentImageRect_c0_0);
    } else {
      return QImageIOHandler::currentImageRect();
    }
  }

  //  [adaptor impl] int QImageIOHandler::imageCount()
  int cbs_imageCount_c0_0() const
  {
    return QImageIOHandler::imageCount();
  }

  virtual int imageCount() const
  {
    if (cb_imageCount_c0_0.can_issue()) {
      return cb_imageCount_c0_0.issue<QImageIOHandler_Adaptor, int>(&QImageIOHandler_Adaptor::cbs_imageCount_c0_0);
    } else {
      return QImageIOHandler::imageCount();
    }
  }

  //  [adaptor impl] bool QImageIOHandler::jumpToImage(int imageNumber)
  bool cbs_jumpToImage_767_0(int imageNumber)
  {
    return QImageIOHandler::jumpToImage(imageNumber);
  }

  virtual bool jumpToImage(int imageNumber)
  {
    if (cb_jumpToImage_767_0.can_issue()) {
      return cb_jumpToImage_767_0.issue<QImageIOHandler_Adaptor, bool, int>(&QImageIOHandler_Adaptor::cbs_jumpToImage_767_0, imageNumber);
    } else {
      return QImageIOHandler::jumpToImage(imageNumber);
    }
  }

  //  [adaptor impl] bool QImageIOHandler::jumpToNextImage()
  bool cbs_jumpToNextImage_0_0()
  {
    return QImageIOHandler::jumpToNextImage();
  }

  virtual bool jumpToNextImage()
  {
    if (cb_jumpToNextImage_0_0.can_issue()) {
      return cb_jumpToNextImage_0_0.issue<QImageIOHandler_Adaptor, bool>(&QImageIOHandler_Adaptor::cbs_jumpToNextImage_0_0);
    } else {
      return QImageIOHandler::jumpToNextImage();
    }
  }

  //  [adaptor impl] int QImageIOHandler::loopCount()
  int cbs_loopCount_c0_0() const
  {
    return QImageIOHandler::loopCount();
  }

  virtual int loopCount() const
  {
    if (cb_loopCount_c0_0.can_issue()) {
      return cb_loopCount_c0_0.issue<QImageIOHandler_Adaptor, int>(&QImageIOHandler_Adaptor::cbs_loopCount_c0_0);
    } else {
      return QImageIOHandler::loopCount();
    }
  }

  //  [adaptor impl] QByteArray QImageIOHandler::name()
  QByteArray cbs_name_c0_0() const
  {
    return QImageIOHandler::name();
  }

  virtual QByteArray name() const
  {
    if (cb_name_c0_0.can_issue()) {
      return cb_name_c0_0.issue<QImageIOHandler_Adaptor, QByteArray>(&QImageIOHandler_Adaptor::cbs_name_c0_0);
    } else {
      return QImageIOHandler::name();
    }
  }

  //  [adaptor impl] int QImageIOHandler::nextImageDelay()
  int cbs_nextImageDelay_c0_0() const
  {
    return QImageIOHandler::nextImageDelay();
  }

  virtual int nextImageDelay() const
  {
    if (cb_nextImageDelay_c0_0.can_issue()) {
      return cb_nextImageDelay_c0_0.issue<QImageIOHandler_Adaptor, int>(&QImageIOHandler_Adaptor::cbs_nextImageDelay_c0_0);
    } else {
      return QImageIOHandler::nextImageDelay();
    }
  }

  //  [adaptor impl] QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)
  QVariant cbs_option_c3086_0(const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & _option) const
  {
    return QImageIOHandler::option(qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(_option).cref());
  }

  virtual QVariant option(QImageIOHandler::ImageOption _option) const
  {
    if (cb_option_c3086_0.can_issue()) {
      return cb_option_c3086_0.issue<QImageIOHandler_Adaptor, QVariant, const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type &>(&QImageIOHandler_Adaptor::cbs_option_c3086_0, qt_gsi::CppToQtAdaptor<QImageIOHandler::ImageOption>(_option));
    } else {
      return QImageIOHandler::option(_option);
    }
  }

  //  [adaptor impl] bool QImageIOHandler::read(QImage *image)
  bool cbs_read_1186_0(QImage *image)
  {
    throw qt_gsi::AbstractMethodCalledException("read");
  }

  virtual bool read(QImage *image)
  {
    if (cb_read_1186_0.can_issue()) {
      return cb_read_1186_0.issue<QImageIOHandler_Adaptor, bool, QImage *>(&QImageIOHandler_Adaptor::cbs_read_1186_0, image);
    } else {
      throw qt_gsi::AbstractMethodCalledException("read");
    }
  }

  //  [adaptor impl] void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)
  void cbs_setOption_5097_0(const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & option, const QVariant &value)
  {
    QImageIOHandler::setOption(qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(option).cref(), value);
  }

  virtual void setOption(QImageIOHandler::ImageOption option, const QVariant &value)
  {
    if (cb_setOption_5097_0.can_issue()) {
      cb_setOption_5097_0.issue<QImageIOHandler_Adaptor, const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type &, const QVariant &>(&QImageIOHandler_Adaptor::cbs_setOption_5097_0, qt_gsi::CppToQtAdaptor<QImageIOHandler::ImageOption>(option), value);
    } else {
      QImageIOHandler::setOption(option, value);
    }
  }

  //  [adaptor impl] bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)
  bool cbs_supportsOption_c3086_0(const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & option) const
  {
    return QImageIOHandler::supportsOption(qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(option).cref());
  }

  virtual bool supportsOption(QImageIOHandler::ImageOption option) const
  {
    if (cb_supportsOption_c3086_0.can_issue()) {
      return cb_supportsOption_c3086_0.issue<QImageIOHandler_Adaptor, bool, const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type &>(&QImageIOHandler_Adaptor::cbs_supportsOption_c3086_0, qt_gsi::CppToQtAdaptor<QImageIOHandler::ImageOption>(option));
    } else {
      return QImageIOHandler::supportsOption(option);
    }
  }

  //  [adaptor impl] bool QImageIOHandler::write(const QImage &image)
  bool cbs_write_1877_0(const QImage &image)
  {
    return QImageIOHandler::write(image);
  }

  virtual bool write(const QImage &image)
  {
    if (cb_write_1877_0.can_issue()) {
      return cb_write_1877_0.issue<QImageIOHandler_Adaptor, bool, const QImage &>(&QImageIOHandler_Adaptor::cbs_write_1877_0, image);
    } else {
      return QImageIOHandler::write(image);
    }
  }

  gsi::Callback cb_canRead_c0_0;
  gsi::Callback cb_currentImageNumber_c0_0;
  gsi::Callback cb_currentImageRect_c0_0;
  gsi::Callback cb_imageCount_c0_0;
  gsi::Callback cb_jumpToImage_767_0;
  gsi::Callback cb_jumpToNextImage_0_0;
  gsi::Callback cb_loopCount_c0_0;
  gsi::Callback cb_name_c0_0;
  gsi::Callback cb_nextImageDelay_c0_0;
  gsi::Callback cb_option_c3086_0;
  gsi::Callback cb_read_1186_0;
  gsi::Callback cb_setOption_5097_0;
  gsi::Callback cb_supportsOption_c3086_0;
  gsi::Callback cb_write_1877_0;
};

QImageIOHandler_Adaptor::~QImageIOHandler_Adaptor() { }

//  Constructor QImageIOHandler::QImageIOHandler() (adaptor class)

static void _init_ctor_QImageIOHandler_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QImageIOHandler_Adaptor *> ();
}

static void _call_ctor_QImageIOHandler_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QImageIOHandler_Adaptor *> (new QImageIOHandler_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImageIOHandler_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImageIOHandler::QImageIOHandler()\nThis method creates an object of class QImageIOHandler.", &_init_ctor_QImageIOHandler_Adaptor_0, &_call_ctor_QImageIOHandler_Adaptor_0);
}

// bool QImageIOHandler::canRead()

static void _init_cbs_canRead_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_canRead_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_canRead_c0_0 ());
}

static void _set_callback_cbs_canRead_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_canRead_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_canRead_c0_0 ()
{
  return new qt_gsi::GenericMethod ("canRead", "@hide", true, &_init_cbs_canRead_c0_0, &_call_cbs_canRead_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_canRead_c0_0 ()
{
  return new qt_gsi::GenericMethod ("canRead", "@brief Virtual method bool QImageIOHandler::canRead()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canRead_c0_0, &_call_cbs_canRead_c0_0, &_set_callback_cbs_canRead_c0_0);
}


// int QImageIOHandler::currentImageNumber()

static void _init_cbs_currentImageNumber_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_currentImageNumber_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageIOHandler_Adaptor *)cls)->cbs_currentImageNumber_c0_0 ());
}

static void _set_callback_cbs_currentImageNumber_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_currentImageNumber_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_currentImageNumber_c0_0 ()
{
  return new qt_gsi::GenericMethod ("currentImageNumber", "@hide", true, &_init_cbs_currentImageNumber_c0_0, &_call_cbs_currentImageNumber_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_currentImageNumber_c0_0 ()
{
  return new qt_gsi::GenericMethod ("currentImageNumber", "@brief Virtual method int QImageIOHandler::currentImageNumber()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_currentImageNumber_c0_0, &_call_cbs_currentImageNumber_c0_0, &_set_callback_cbs_currentImageNumber_c0_0);
}


// QRect QImageIOHandler::currentImageRect()

static void _init_cbs_currentImageRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_currentImageRect_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QImageIOHandler_Adaptor *)cls)->cbs_currentImageRect_c0_0 ());
}

static void _set_callback_cbs_currentImageRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_currentImageRect_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_currentImageRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("currentImageRect", "@hide", true, &_init_cbs_currentImageRect_c0_0, &_call_cbs_currentImageRect_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_currentImageRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("currentImageRect", "@brief Virtual method QRect QImageIOHandler::currentImageRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_currentImageRect_c0_0, &_call_cbs_currentImageRect_c0_0, &_set_callback_cbs_currentImageRect_c0_0);
}


// int QImageIOHandler::imageCount()

static void _init_cbs_imageCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_imageCount_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageIOHandler_Adaptor *)cls)->cbs_imageCount_c0_0 ());
}

static void _set_callback_cbs_imageCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_imageCount_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_imageCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("imageCount", "@hide", true, &_init_cbs_imageCount_c0_0, &_call_cbs_imageCount_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_imageCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("imageCount", "@brief Virtual method int QImageIOHandler::imageCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_imageCount_c0_0, &_call_cbs_imageCount_c0_0, &_set_callback_cbs_imageCount_c0_0);
}


// bool QImageIOHandler::jumpToImage(int imageNumber)

static void _init_cbs_jumpToImage_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("imageNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_jumpToImage_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_jumpToImage_767_0 (arg1));
}

static void _set_callback_cbs_jumpToImage_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_jumpToImage_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_jumpToImage_767_0 ()
{
  return new qt_gsi::GenericMethod ("jumpToImage", "@hide", false, &_init_cbs_jumpToImage_767_0, &_call_cbs_jumpToImage_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_jumpToImage_767_0 ()
{
  return new qt_gsi::GenericMethod ("jumpToImage", "@brief Virtual method bool QImageIOHandler::jumpToImage(int imageNumber)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_jumpToImage_767_0, &_call_cbs_jumpToImage_767_0, &_set_callback_cbs_jumpToImage_767_0);
}


// bool QImageIOHandler::jumpToNextImage()

static void _init_cbs_jumpToNextImage_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_jumpToNextImage_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_jumpToNextImage_0_0 ());
}

static void _set_callback_cbs_jumpToNextImage_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_jumpToNextImage_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_jumpToNextImage_0_0 ()
{
  return new qt_gsi::GenericMethod ("jumpToNextImage", "@hide", false, &_init_cbs_jumpToNextImage_0_0, &_call_cbs_jumpToNextImage_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_jumpToNextImage_0_0 ()
{
  return new qt_gsi::GenericMethod ("jumpToNextImage", "@brief Virtual method bool QImageIOHandler::jumpToNextImage()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_jumpToNextImage_0_0, &_call_cbs_jumpToNextImage_0_0, &_set_callback_cbs_jumpToNextImage_0_0);
}


// int QImageIOHandler::loopCount()

static void _init_cbs_loopCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_loopCount_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageIOHandler_Adaptor *)cls)->cbs_loopCount_c0_0 ());
}

static void _set_callback_cbs_loopCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_loopCount_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_loopCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("loopCount", "@hide", true, &_init_cbs_loopCount_c0_0, &_call_cbs_loopCount_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_loopCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("loopCount", "@brief Virtual method int QImageIOHandler::loopCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_loopCount_c0_0, &_call_cbs_loopCount_c0_0, &_set_callback_cbs_loopCount_c0_0);
}


// QByteArray QImageIOHandler::name()

static void _init_cbs_name_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_cbs_name_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QImageIOHandler_Adaptor *)cls)->cbs_name_c0_0 ());
}

static void _set_callback_cbs_name_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_name_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_name_c0_0 ()
{
  return new qt_gsi::GenericMethod ("name", "@hide", true, &_init_cbs_name_c0_0, &_call_cbs_name_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_name_c0_0 ()
{
  return new qt_gsi::GenericMethod ("name", "@brief Virtual method QByteArray QImageIOHandler::name()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_name_c0_0, &_call_cbs_name_c0_0, &_set_callback_cbs_name_c0_0);
}


// int QImageIOHandler::nextImageDelay()

static void _init_cbs_nextImageDelay_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_nextImageDelay_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageIOHandler_Adaptor *)cls)->cbs_nextImageDelay_c0_0 ());
}

static void _set_callback_cbs_nextImageDelay_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_nextImageDelay_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_nextImageDelay_c0_0 ()
{
  return new qt_gsi::GenericMethod ("nextImageDelay", "@hide", true, &_init_cbs_nextImageDelay_c0_0, &_call_cbs_nextImageDelay_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_nextImageDelay_c0_0 ()
{
  return new qt_gsi::GenericMethod ("nextImageDelay", "@brief Virtual method int QImageIOHandler::nextImageDelay()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_nextImageDelay_c0_0, &_call_cbs_nextImageDelay_c0_0, &_set_callback_cbs_nextImageDelay_c0_0);
}


// QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)

static void _init_cbs_option_c3086_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_option_c3086_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QImageIOHandler_Adaptor *)cls)->cbs_option_c3086_0 (arg1));
}

static void _set_callback_cbs_option_c3086_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_option_c3086_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_option_c3086_0 ()
{
  return new qt_gsi::GenericMethod ("option", "@hide", true, &_init_cbs_option_c3086_0, &_call_cbs_option_c3086_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_option_c3086_0 ()
{
  return new qt_gsi::GenericMethod ("option", "@brief Virtual method QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_option_c3086_0, &_call_cbs_option_c3086_0, &_set_callback_cbs_option_c3086_0);
}


// bool QImageIOHandler::read(QImage *image)

static void _init_cbs_read_1186_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<QImage * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_read_1186_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QImage *arg1 = args.read<QImage * > ();
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_read_1186_0 (arg1));
}

static void _set_callback_cbs_read_1186_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_read_1186_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_read_1186_0 ()
{
  return new qt_gsi::GenericMethod ("read", "@hide", false, &_init_cbs_read_1186_0, &_call_cbs_read_1186_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_read_1186_0 ()
{
  return new qt_gsi::GenericMethod ("read", "@brief Virtual method bool QImageIOHandler::read(QImage *image)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_read_1186_0, &_call_cbs_read_1186_0, &_set_callback_cbs_read_1186_0);
}


// void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)

static void _init_cbs_setOption_5097_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setOption_5097_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QImageIOHandler_Adaptor *)cls)->cbs_setOption_5097_0 (arg1, arg2);
}

static void _set_callback_cbs_setOption_5097_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_setOption_5097_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setOption_5097_0 ()
{
  return new qt_gsi::GenericMethod ("setOption", "@hide", false, &_init_cbs_setOption_5097_0, &_call_cbs_setOption_5097_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setOption_5097_0 ()
{
  return new qt_gsi::GenericMethod ("setOption", "@brief Virtual method void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setOption_5097_0, &_call_cbs_setOption_5097_0, &_set_callback_cbs_setOption_5097_0);
}


// bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)

static void _init_cbs_supportsOption_c3086_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsOption_c3086_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > ();
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_supportsOption_c3086_0 (arg1));
}

static void _set_callback_cbs_supportsOption_c3086_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_supportsOption_c3086_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportsOption_c3086_0 ()
{
  return new qt_gsi::GenericMethod ("supportsOption", "@hide", true, &_init_cbs_supportsOption_c3086_0, &_call_cbs_supportsOption_c3086_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportsOption_c3086_0 ()
{
  return new qt_gsi::GenericMethod ("supportsOption", "@brief Virtual method bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsOption_c3086_0, &_call_cbs_supportsOption_c3086_0, &_set_callback_cbs_supportsOption_c3086_0);
}


// bool QImageIOHandler::write(const QImage &image)

static void _init_cbs_write_1877_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_write_1877_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_write_1877_0 (arg1));
}

static void _set_callback_cbs_write_1877_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_write_1877_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_write_1877_0 ()
{
  return new qt_gsi::GenericMethod ("write", "@hide", false, &_init_cbs_write_1877_0, &_call_cbs_write_1877_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_write_1877_0 ()
{
  return new qt_gsi::GenericMethod ("write", "@brief Virtual method bool QImageIOHandler::write(const QImage &image)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_write_1877_0, &_call_cbs_write_1877_0, &_set_callback_cbs_write_1877_0);
}


namespace gsi
{

extern gsi::Class<QImageIOHandler> decl_QImageIOHandler;

gsi::Class<QImageIOHandler_Adaptor> decl_QImageIOHandler_Adaptor (decl_QImageIOHandler, "QImageIOHandler",
  gsi::Methods(_create_cbs_canRead_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_canRead_c0_0 ()) +
  gsi::Methods(_create_cbs_currentImageNumber_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_currentImageNumber_c0_0 ()) +
  gsi::Methods(_create_cbs_currentImageRect_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_currentImageRect_c0_0 ()) +
  gsi::Methods(_create_cbs_imageCount_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_imageCount_c0_0 ()) +
  gsi::Methods(_create_cbs_jumpToImage_767_0 ()) +
  gsi::Methods(_create_callback_cbs_jumpToImage_767_0 ()) +
  gsi::Methods(_create_cbs_jumpToNextImage_0_0 ()) +
  gsi::Methods(_create_callback_cbs_jumpToNextImage_0_0 ()) +
  gsi::Methods(_create_cbs_loopCount_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_loopCount_c0_0 ()) +
  gsi::Methods(_create_cbs_name_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_name_c0_0 ()) +
  gsi::Methods(_create_cbs_nextImageDelay_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_nextImageDelay_c0_0 ()) +
  gsi::Methods(_create_cbs_option_c3086_0 ()) +
  gsi::Methods(_create_callback_cbs_option_c3086_0 ()) +
  gsi::Methods(_create_cbs_read_1186_0 ()) +
  gsi::Methods(_create_callback_cbs_read_1186_0 ()) +
  gsi::Methods(_create_cbs_setOption_5097_0 ()) +
  gsi::Methods(_create_callback_cbs_setOption_5097_0 ()) +
  gsi::Methods(_create_cbs_supportsOption_c3086_0 ()) +
  gsi::Methods(_create_callback_cbs_supportsOption_c3086_0 ()) +
  gsi::Methods(_create_cbs_write_1877_0 ()) +
  gsi::Methods(_create_callback_cbs_write_1877_0 ()) +
  gsi::Methods(_create_ctor_QImageIOHandler_Adaptor_0 ()),
  "@qt\n@brief Binding of QImageIOHandler");

}


//  Implementation of the enum wrapper class for QImageIOHandler::ImageOption
namespace qt_gsi
{

static QImageIOHandler_ImageOption_Enum *c_1_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::Size); }
static QImageIOHandler_ImageOption_Enum *c_2_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::ClipRect); }
static QImageIOHandler_ImageOption_Enum *c_3_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::Description); }
static QImageIOHandler_ImageOption_Enum *c_4_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::ScaledClipRect); }
static QImageIOHandler_ImageOption_Enum *c_5_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::ScaledSize); }
static QImageIOHandler_ImageOption_Enum *c_6_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::CompressionRatio); }
static QImageIOHandler_ImageOption_Enum *c_7_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::Gamma); }
static QImageIOHandler_ImageOption_Enum *c_8_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::Quality); }
static QImageIOHandler_ImageOption_Enum *c_9_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::Name); }
static QImageIOHandler_ImageOption_Enum *c_10_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::SubType); }
static QImageIOHandler_ImageOption_Enum *c_11_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::IncrementalReading); }
static QImageIOHandler_ImageOption_Enum *c_12_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::Endianness); }
static QImageIOHandler_ImageOption_Enum *c_13_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::Animation); }
static QImageIOHandler_ImageOption_Enum *c_14_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::BackgroundColor); }
static QImageIOHandler_ImageOption_Enum *c_15_QImageIOHandler_ImageOption_Enum () { return new QImageIOHandler_ImageOption_Enum (QImageIOHandler::ImageFormat); }

static gsi::Methods mkdefs_QImageIOHandler_ImageOption () {
  return
    gsi::constant ("Size", &qt_gsi::c_1_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::Size") +
    gsi::constant ("ClipRect", &qt_gsi::c_2_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::ClipRect") +
    gsi::constant ("Description", &qt_gsi::c_3_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::Description") +
    gsi::constant ("ScaledClipRect", &qt_gsi::c_4_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::ScaledClipRect") +
    gsi::constant ("ScaledSize", &qt_gsi::c_5_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::ScaledSize") +
    gsi::constant ("CompressionRatio", &qt_gsi::c_6_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::CompressionRatio") +
    gsi::constant ("Gamma", &qt_gsi::c_7_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::Gamma") +
    gsi::constant ("Quality", &qt_gsi::c_8_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::Quality") +
    gsi::constant ("Name", &qt_gsi::c_9_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::Name") +
    gsi::constant ("SubType", &qt_gsi::c_10_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::SubType") +
    gsi::constant ("IncrementalReading", &qt_gsi::c_11_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::IncrementalReading") +
    gsi::constant ("Endianness", &qt_gsi::c_12_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::Endianness") +
    gsi::constant ("Animation", &qt_gsi::c_13_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::Animation") +
    gsi::constant ("BackgroundColor", &qt_gsi::c_14_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::BackgroundColor") +
    gsi::constant ("ImageFormat", &qt_gsi::c_15_QImageIOHandler_ImageOption_Enum, "@brief Enum constant QImageIOHandler::ImageFormat");
}

static std::string to_s_QImageIOHandler_ImageOption_Enum (const QImageIOHandler_ImageOption_Enum *e)
{
  if (e->value () == QImageIOHandler::Size) { return tl::sprintf ("Size (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::ClipRect) { return tl::sprintf ("ClipRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::Description) { return tl::sprintf ("Description (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::ScaledClipRect) { return tl::sprintf ("ScaledClipRect (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::ScaledSize) { return tl::sprintf ("ScaledSize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::CompressionRatio) { return tl::sprintf ("CompressionRatio (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::Gamma) { return tl::sprintf ("Gamma (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::Quality) { return tl::sprintf ("Quality (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::Name) { return tl::sprintf ("Name (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::SubType) { return tl::sprintf ("SubType (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::IncrementalReading) { return tl::sprintf ("IncrementalReading (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::Endianness) { return tl::sprintf ("Endianness (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::Animation) { return tl::sprintf ("Animation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::BackgroundColor) { return tl::sprintf ("BackgroundColor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageIOHandler::ImageFormat) { return tl::sprintf ("ImageFormat (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QImageIOHandler_ImageOption_Enum (const QImageIOHandler_ImageOption_Enum *e)
{
  return (unsigned int) e->value ();
}

static QImageIOHandler_ImageOption_Enum *from_i_QImageIOHandler_ImageOption_Enum (unsigned int i)
{
  return new QImageIOHandler_ImageOption_Enum ((QImageIOHandler::ImageOption) i);
}

static bool equalQImageIOHandler_ImageOption_Enum (const QImageIOHandler_ImageOption_Enum *e, QImageIOHandler_ImageOption_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QImageIOHandler_ImageOption_Enum (const QImageIOHandler_ImageOption_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QImageIOHandler_ImageOption_Enums oropQImageIOHandler_ImageOption_Enums (const QImageIOHandler_ImageOption_Enums *e, const QImageIOHandler_ImageOption_Enums &d)
{
  return e->flags () | d.flags ();
}

static QImageIOHandler_ImageOption_Enums andopQImageIOHandler_ImageOption_Enums (const QImageIOHandler_ImageOption_Enums *e, const QImageIOHandler_ImageOption_Enums &d)
{
  return e->flags () & d.flags ();
}

static QImageIOHandler_ImageOption_Enums xoropQImageIOHandler_ImageOption_Enums (const QImageIOHandler_ImageOption_Enums *e, const QImageIOHandler_ImageOption_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QImageIOHandler_ImageOption_Enums (const QImageIOHandler_ImageOption_Enums *e)
{
  std::string l;
  if (e->testFlag (QImageIOHandler::Size)) { if (!l.empty ()) l += "|"; l += "Size"; }
  if (e->testFlag (QImageIOHandler::ClipRect)) { if (!l.empty ()) l += "|"; l += "ClipRect"; }
  if (e->testFlag (QImageIOHandler::Description)) { if (!l.empty ()) l += "|"; l += "Description"; }
  if (e->testFlag (QImageIOHandler::ScaledClipRect)) { if (!l.empty ()) l += "|"; l += "ScaledClipRect"; }
  if (e->testFlag (QImageIOHandler::ScaledSize)) { if (!l.empty ()) l += "|"; l += "ScaledSize"; }
  if (e->testFlag (QImageIOHandler::CompressionRatio)) { if (!l.empty ()) l += "|"; l += "CompressionRatio"; }
  if (e->testFlag (QImageIOHandler::Gamma)) { if (!l.empty ()) l += "|"; l += "Gamma"; }
  if (e->testFlag (QImageIOHandler::Quality)) { if (!l.empty ()) l += "|"; l += "Quality"; }
  if (e->testFlag (QImageIOHandler::Name)) { if (!l.empty ()) l += "|"; l += "Name"; }
  if (e->testFlag (QImageIOHandler::SubType)) { if (!l.empty ()) l += "|"; l += "SubType"; }
  if (e->testFlag (QImageIOHandler::IncrementalReading)) { if (!l.empty ()) l += "|"; l += "IncrementalReading"; }
  if (e->testFlag (QImageIOHandler::Endianness)) { if (!l.empty ()) l += "|"; l += "Endianness"; }
  if (e->testFlag (QImageIOHandler::Animation)) { if (!l.empty ()) l += "|"; l += "Animation"; }
  if (e->testFlag (QImageIOHandler::BackgroundColor)) { if (!l.empty ()) l += "|"; l += "BackgroundColor"; }
  if (e->testFlag (QImageIOHandler::ImageFormat)) { if (!l.empty ()) l += "|"; l += "ImageFormat"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QImageIOHandler_ImageOption_Enums (const QImageIOHandler_ImageOption_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QImageIOHandler_ImageOption_Enums (const QImageIOHandler_ImageOption_Enums *e, const QImageIOHandler_ImageOption_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QImageIOHandler_ImageOption_Enums> decl_QImageIOHandler_ImageOption_Enums ("QImageIOHandler_QFlags_ImageOption",
  gsi::method_ext ("|", &qt_gsi::oropQImageIOHandler_ImageOption_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQImageIOHandler_ImageOption_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQImageIOHandler_ImageOption_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImageIOHandler_ImageOption_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImageIOHandler_ImageOption_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QImageIOHandler_ImageOption_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QImageIOHandler::ImageOption> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QImageIOHandler_ImageOption_Enum> decl_QImageIOHandler_ImageOption_Enum (decl_QImageIOHandler_ImageOption_Enums, "QImageIOHandler_ImageOption",
  qt_gsi::mkdefs_QImageIOHandler_ImageOption () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImageIOHandler_ImageOption_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImageIOHandler_ImageOption_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQImageIOHandler_ImageOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QImageIOHandler_ImageOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QImageIOHandler_ImageOption_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QImageIOHandler::ImageOption enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QImageIOHandler> inject_QImageIOHandler_ImageOption_Enum_in_parent (qt_gsi::mkdefs_QImageIOHandler_ImageOption ());
static gsi::ClassExt<QImageIOHandler> decl_QImageIOHandler_ImageOption_Enum_as_child (decl_QImageIOHandler_ImageOption_Enum, "ImageOption");

}

