
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQImage.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQImage_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QImage

// bool QImage::allGray()


static void _init_f_allGray_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_allGray_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImage *)cls)->allGray ());
}

static qt_gsi::GenericMethod *_create_f_allGray_c0 ()
{
  return new qt_gsi::GenericMethod ("allGray", "@brief Method bool QImage::allGray()\n", true, &_init_f_allGray_c0, &_call_f_allGray_c0);
}

// QImage QImage::alphaChannel()


static void _init_f_alphaChannel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_f_alphaChannel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QImage > ((QImage)((QImage *)cls)->alphaChannel ());
}

static qt_gsi::GenericMethod *_create_f_alphaChannel_c0 ()
{
  return new qt_gsi::GenericMethod (":alphaChannel", "@brief Method QImage QImage::alphaChannel()\n", true, &_init_f_alphaChannel_c0, &_call_f_alphaChannel_c0);
}

// const unsigned char *QImage::bits()


static void _init_f_bits_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const unsigned char * > ();
}

static void _call_f_bits_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const unsigned char * > ((const unsigned char *)((QImage *)cls)->bits ());
}

static qt_gsi::GenericMethod *_create_f_bits_c0 ()
{
  return new qt_gsi::GenericMethod ("bits", "@brief Method const unsigned char *QImage::bits()\n", true, &_init_f_bits_c0, &_call_f_bits_c0);
}

// int QImage::byteCount()


static void _init_f_byteCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_byteCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->byteCount ());
}

static qt_gsi::GenericMethod *_create_f_byteCount_c0 ()
{
  return new qt_gsi::GenericMethod ("byteCount", "@brief Method int QImage::byteCount()\n", true, &_init_f_byteCount_c0, &_call_f_byteCount_c0);
}

// int QImage::bytesPerLine()


static void _init_f_bytesPerLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bytesPerLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->bytesPerLine ());
}

static qt_gsi::GenericMethod *_create_f_bytesPerLine_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesPerLine", "@brief Method int QImage::bytesPerLine()\n", true, &_init_f_bytesPerLine_c0, &_call_f_bytesPerLine_c0);
}

// qint64 QImage::cacheKey()


static void _init_f_cacheKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_cacheKey_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QImage *)cls)->cacheKey ());
}

static qt_gsi::GenericMethod *_create_f_cacheKey_c0 ()
{
  return new qt_gsi::GenericMethod ("cacheKey", "@brief Method qint64 QImage::cacheKey()\n", true, &_init_f_cacheKey_c0, &_call_f_cacheKey_c0);
}

// unsigned int QImage::color(int i)


static void _init_f_color_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<unsigned int > ();
}

static void _call_f_color_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<unsigned int > ((unsigned int)((QImage *)cls)->color (arg1));
}

static qt_gsi::GenericMethod *_create_f_color_c767 ()
{
  return new qt_gsi::GenericMethod ("color", "@brief Method unsigned int QImage::color(int i)\n", true, &_init_f_color_c767, &_call_f_color_c767);
}

// int QImage::colorCount()


static void _init_f_colorCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_colorCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->colorCount ());
}

static qt_gsi::GenericMethod *_create_f_colorCount_c0 ()
{
  return new qt_gsi::GenericMethod (":colorCount", "@brief Method int QImage::colorCount()\n", true, &_init_f_colorCount_c0, &_call_f_colorCount_c0);
}

// QVector<unsigned int> QImage::colorTable()


static void _init_f_colorTable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QVector<unsigned int> >::target_type > ();
}

static void _call_f_colorTable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QVector<unsigned int> >::target_type > ((qt_gsi::Converter<QVector<unsigned int> >::target_type)qt_gsi::CppToQtAdaptor<QVector<unsigned int> >(((QImage *)cls)->colorTable ()));
}

static qt_gsi::GenericMethod *_create_f_colorTable_c0 ()
{
  return new qt_gsi::GenericMethod (":colorTable", "@brief Method QVector<unsigned int> QImage::colorTable()\n", true, &_init_f_colorTable_c0, &_call_f_colorTable_c0);
}

// QImage QImage::convertToFormat(QImage::Format f, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_convertToFormat_c4993 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_convertToFormat_c4993 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImage::Format>::target_type & arg1 = args.read<const qt_gsi::Converter<QImage::Format>::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ret.write<QImage > ((QImage)((QImage *)cls)->convertToFormat (qt_gsi::QtToCppAdaptor<QImage::Format>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_convertToFormat_c4993 ()
{
  return new qt_gsi::GenericMethod ("convertToFormat", "@brief Method QImage QImage::convertToFormat(QImage::Format f, QFlags<Qt::ImageConversionFlag> flags)\n", true, &_init_f_convertToFormat_c4993, &_call_f_convertToFormat_c4993);
}

// QImage QImage::convertToFormat(QImage::Format f, const QVector<unsigned int> &colorTable, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_convertToFormat_c8364 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("colorTable");
  decl->add_arg<const qt_gsi::Converter<QVector<unsigned int> >::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_2);
  decl->set_return<QImage > ();
}

static void _call_f_convertToFormat_c8364 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImage::Format>::target_type & arg1 = args.read<const qt_gsi::Converter<QImage::Format>::target_type & > ();
  const qt_gsi::Converter<QVector<unsigned int> >::target_type & arg2 = args.read<const qt_gsi::Converter<QVector<unsigned int> >::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ret.write<QImage > ((QImage)((QImage *)cls)->convertToFormat (qt_gsi::QtToCppAdaptor<QImage::Format>(arg1).cref(), qt_gsi::QtToCppAdaptor<QVector<unsigned int> >(arg2).cref(), qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_convertToFormat_c8364 ()
{
  return new qt_gsi::GenericMethod ("convertToFormat", "@brief Method QImage QImage::convertToFormat(QImage::Format f, const QVector<unsigned int> &colorTable, QFlags<Qt::ImageConversionFlag> flags)\n", true, &_init_f_convertToFormat_c8364, &_call_f_convertToFormat_c8364);
}

// QImage QImage::copy(const QRect &rect)


static void _init_f_copy_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRect()");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QImage > ();
}

static void _call_f_copy_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args ? args.read<const QRect & > () : (const QRect &)(QRect());
  ret.write<QImage > ((QImage)((QImage *)cls)->copy (arg1));
}

static qt_gsi::GenericMethod *_create_f_copy_c1792 ()
{
  return new qt_gsi::GenericMethod ("copy", "@brief Method QImage QImage::copy(const QRect &rect)\n", true, &_init_f_copy_c1792, &_call_f_copy_c1792);
}

// QImage QImage::copy(int x, int y, int w, int h)


static void _init_f_copy_c2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QImage > ();
}

static void _call_f_copy_c2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ret.write<QImage > ((QImage)((QImage *)cls)->copy (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_copy_c2744 ()
{
  return new qt_gsi::GenericMethod ("copy", "@brief Method QImage QImage::copy(int x, int y, int w, int h)\n", true, &_init_f_copy_c2744, &_call_f_copy_c2744);
}

// QImage QImage::createAlphaMask(QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_createAlphaMask_c3368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags", true, "Qt::AutoColor");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > (argspec_0);
  decl->set_return<QImage > ();
}

static void _call_f_createAlphaMask_c3368 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::ImageConversionFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::ImageConversionFlag> >(heap, Qt::AutoColor));
  ret.write<QImage > ((QImage)((QImage *)cls)->createAlphaMask (qt_gsi::QtToCppAdaptor<QFlags<Qt::ImageConversionFlag> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_createAlphaMask_c3368 ()
{
  return new qt_gsi::GenericMethod ("createAlphaMask", "@brief Method QImage QImage::createAlphaMask(QFlags<Qt::ImageConversionFlag> flags)\n", true, &_init_f_createAlphaMask_c3368, &_call_f_createAlphaMask_c3368);
}

// QImage QImage::createHeuristicMask(bool clipTight)


static void _init_f_createHeuristicMask_c864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("clipTight", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<QImage > ();
}

static void _call_f_createHeuristicMask_c864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  ret.write<QImage > ((QImage)((QImage *)cls)->createHeuristicMask (arg1));
}

static qt_gsi::GenericMethod *_create_f_createHeuristicMask_c864 ()
{
  return new qt_gsi::GenericMethod ("createHeuristicMask", "@brief Method QImage QImage::createHeuristicMask(bool clipTight)\n", true, &_init_f_createHeuristicMask_c864, &_call_f_createHeuristicMask_c864);
}

// QImage QImage::createMaskFromColor(unsigned int color, Qt::MaskMode mode)


static void _init_f_createMaskFromColor_c3198 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::MaskInColor");
  decl->add_arg<const qt_gsi::Converter<Qt::MaskMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_createMaskFromColor_c3198 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::MaskMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::MaskMode>::target_type & > () : (const qt_gsi::Converter<Qt::MaskMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::MaskMode>(heap, Qt::MaskInColor));
  ret.write<QImage > ((QImage)((QImage *)cls)->createMaskFromColor (arg1, qt_gsi::QtToCppAdaptor<Qt::MaskMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_createMaskFromColor_c3198 ()
{
  return new qt_gsi::GenericMethod ("createMaskFromColor", "@brief Method QImage QImage::createMaskFromColor(unsigned int color, Qt::MaskMode mode)\n", true, &_init_f_createMaskFromColor_c3198, &_call_f_createMaskFromColor_c3198);
}

// int QImage::depth()


static void _init_f_depth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_depth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->depth ());
}

static qt_gsi::GenericMethod *_create_f_depth_c0 ()
{
  return new qt_gsi::GenericMethod ("depth", "@brief Method int QImage::depth()\n", true, &_init_f_depth_c0, &_call_f_depth_c0);
}

// void QImage::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QImage *)cls)->detach ();
}

static qt_gsi::GenericMethod *_create_f_detach_0 ()
{
  return new qt_gsi::GenericMethod ("detach", "@brief Method void QImage::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
}

// int QImage::dotsPerMeterX()


static void _init_f_dotsPerMeterX_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dotsPerMeterX_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->dotsPerMeterX ());
}

static qt_gsi::GenericMethod *_create_f_dotsPerMeterX_c0 ()
{
  return new qt_gsi::GenericMethod (":dotsPerMeterX", "@brief Method int QImage::dotsPerMeterX()\n", true, &_init_f_dotsPerMeterX_c0, &_call_f_dotsPerMeterX_c0);
}

// int QImage::dotsPerMeterY()


static void _init_f_dotsPerMeterY_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dotsPerMeterY_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->dotsPerMeterY ());
}

static qt_gsi::GenericMethod *_create_f_dotsPerMeterY_c0 ()
{
  return new qt_gsi::GenericMethod (":dotsPerMeterY", "@brief Method int QImage::dotsPerMeterY()\n", true, &_init_f_dotsPerMeterY_c0, &_call_f_dotsPerMeterY_c0);
}

// void QImage::fill(unsigned int pixel)


static void _init_f_fill_1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixel");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fill_1772 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ((QImage *)cls)->fill (arg1);
}

static qt_gsi::GenericMethod *_create_f_fill_1772 ()
{
  return new qt_gsi::GenericMethod ("fill", "@brief Method void QImage::fill(unsigned int pixel)\n", false, &_init_f_fill_1772, &_call_f_fill_1772);
}

// QImage::Format QImage::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QImage::Format>::target_type > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QImage::Format>::target_type > ((qt_gsi::Converter<QImage::Format>::target_type)qt_gsi::CppToQtAdaptor<QImage::Format>(((QImage *)cls)->format ()));
}

static qt_gsi::GenericMethod *_create_f_format_c0 ()
{
  return new qt_gsi::GenericMethod ("format", "@brief Method QImage::Format QImage::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
}

// bool QImage::hasAlphaChannel()


static void _init_f_hasAlphaChannel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAlphaChannel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImage *)cls)->hasAlphaChannel ());
}

static qt_gsi::GenericMethod *_create_f_hasAlphaChannel_c0 ()
{
  return new qt_gsi::GenericMethod ("hasAlphaChannel", "@brief Method bool QImage::hasAlphaChannel()\n", true, &_init_f_hasAlphaChannel_c0, &_call_f_hasAlphaChannel_c0);
}

// int QImage::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->height ());
}

static qt_gsi::GenericMethod *_create_f_height_c0 ()
{
  return new qt_gsi::GenericMethod ("height", "@brief Method int QImage::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
}

// void QImage::invertPixels(QImage::InvertMode)


static void _init_f_invertPixels_2137 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QImage::InvertRgb");
  decl->add_arg<const qt_gsi::Converter<QImage::InvertMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_invertPixels_2137 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QImage::InvertMode>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QImage::InvertMode>::target_type & > () : (const qt_gsi::Converter<QImage::InvertMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QImage::InvertMode>(heap, QImage::InvertRgb));
  ((QImage *)cls)->invertPixels (qt_gsi::QtToCppAdaptor<QImage::InvertMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_invertPixels_2137 ()
{
  return new qt_gsi::GenericMethod ("invertPixels", "@brief Method void QImage::invertPixels(QImage::InvertMode)\n", false, &_init_f_invertPixels_2137, &_call_f_invertPixels_2137);
}

// bool QImage::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImage *)cls)->isDetached ());
}

static qt_gsi::GenericMethod *_create_f_isDetached_c0 ()
{
  return new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QImage::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
}

// bool QImage::isGrayscale()


static void _init_f_isGrayscale_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isGrayscale_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImage *)cls)->isGrayscale ());
}

static qt_gsi::GenericMethod *_create_f_isGrayscale_c0 ()
{
  return new qt_gsi::GenericMethod ("isGrayscale?", "@brief Method bool QImage::isGrayscale()\n", true, &_init_f_isGrayscale_c0, &_call_f_isGrayscale_c0);
}

// bool QImage::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImage *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QImage::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// bool QImage::load(QIODevice *device, const char *format)


static void _init_f_load_3070 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_load_3070 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  const char *arg2 = args.read<const char * > ();
  ret.write<bool > ((bool)((QImage *)cls)->load (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_load_3070 ()
{
  return new qt_gsi::GenericMethod ("load", "@brief Method bool QImage::load(QIODevice *device, const char *format)\n", false, &_init_f_load_3070, &_call_f_load_3070);
}

// bool QImage::load(const QString &fileName, const char *format)


static void _init_f_load_3648 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_load_3648 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<bool > ((bool)((QImage *)cls)->load (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_load_3648 ()
{
  return new qt_gsi::GenericMethod ("load", "@brief Method bool QImage::load(const QString &fileName, const char *format)\n", false, &_init_f_load_3648, &_call_f_load_3648);
}

// bool QImage::loadFromData(const unsigned char *buf, int len, const char *format)


static void _init_f_loadFromData_5018 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buf");
  decl->add_arg<const unsigned char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "0");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_loadFromData_5018 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const unsigned char *arg1 = args.read<const unsigned char * > ();
  int arg2 = args.read<int > ();
  const char *arg3 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<bool > ((bool)((QImage *)cls)->loadFromData (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_loadFromData_5018 ()
{
  return new qt_gsi::GenericMethod ("loadFromData", "@brief Method bool QImage::loadFromData(const unsigned char *buf, int len, const char *format)\n", false, &_init_f_loadFromData_5018, &_call_f_loadFromData_5018);
}

// bool QImage::loadFromData(const QByteArray &data, const char *aformat)


static void _init_f_loadFromData_3932 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aformat", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_loadFromData_3932 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<bool > ((bool)((QImage *)cls)->loadFromData (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_loadFromData_3932 ()
{
  return new qt_gsi::GenericMethod ("loadFromData", "@brief Method bool QImage::loadFromData(const QByteArray &data, const char *aformat)\n", false, &_init_f_loadFromData_3932, &_call_f_loadFromData_3932);
}

// QImage QImage::mirrored(bool horizontally, bool vertically)


static void _init_f_mirrored_c1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("horizontally", true, "false");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vertically", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_mirrored_c1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(false);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ret.write<QImage > ((QImage)((QImage *)cls)->mirrored (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mirrored_c1620 ()
{
  return new qt_gsi::GenericMethod ("mirrored", "@brief Method QImage QImage::mirrored(bool horizontally, bool vertically)\n", true, &_init_f_mirrored_c1620, &_call_f_mirrored_c1620);
}

// int QImage::numBytes()


static void _init_f_numBytes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_numBytes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->numBytes ());
}

static qt_gsi::GenericMethod *_create_f_numBytes_c0 ()
{
  return new qt_gsi::GenericMethod ("numBytes", "@brief Method int QImage::numBytes()\n", true, &_init_f_numBytes_c0, &_call_f_numBytes_c0);
}

// int QImage::numColors()


static void _init_f_numColors_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_numColors_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->numColors ());
}

static qt_gsi::GenericMethod *_create_f_numColors_c0 ()
{
  return new qt_gsi::GenericMethod (":numColors", "@brief Method int QImage::numColors()\n", true, &_init_f_numColors_c0, &_call_f_numColors_c0);
}

// QPoint QImage::offset()


static void _init_f_offset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_offset_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QImage *)cls)->offset ());
}

static qt_gsi::GenericMethod *_create_f_offset_c0 ()
{
  return new qt_gsi::GenericMethod (":offset", "@brief Method QPoint QImage::offset()\n", true, &_init_f_offset_c0, &_call_f_offset_c0);
}

// bool QImage::operator!=(const QImage &)


static void _init_f_operator_excl__eq__c1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  ret.write<bool > ((bool)((QImage *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c1877 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QImage::operator!=(const QImage &)\n", true, &_init_f_operator_excl__eq__c1877, &_call_f_operator_excl__eq__c1877);
}

// QImage &QImage::operator=(const QImage &)


static void _init_f_operator_eq__1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<QImage & > ();
}

static void _call_f_operator_eq__1877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  ret.write<QImage & > ((QImage &)((QImage *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__1877 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QImage &QImage::operator=(const QImage &)\n", false, &_init_f_operator_eq__1877, &_call_f_operator_eq__1877);
}

// bool QImage::operator==(const QImage &)


static void _init_f_operator_eq__eq__c1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  ret.write<bool > ((bool)((QImage *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c1877 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QImage::operator==(const QImage &)\n", true, &_init_f_operator_eq__eq__c1877, &_call_f_operator_eq__eq__c1877);
}

// QPaintEngine *QImage::paintEngine()


static void _init_f_paintEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_f_paintEngine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QImage *)cls)->paintEngine ());
}

static qt_gsi::GenericMethod *_create_f_paintEngine_c0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Method QPaintEngine *QImage::paintEngine()\nThis is a reimplementation of QPaintDevice::paintEngine", true, &_init_f_paintEngine_c0, &_call_f_paintEngine_c0);
}

// unsigned int QImage::pixel(int x, int y)


static void _init_f_pixel_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<unsigned int > ();
}

static void _call_f_pixel_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<unsigned int > ((unsigned int)((QImage *)cls)->pixel (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_pixel_c1426 ()
{
  return new qt_gsi::GenericMethod ("pixel", "@brief Method unsigned int QImage::pixel(int x, int y)\n", true, &_init_f_pixel_c1426, &_call_f_pixel_c1426);
}

// unsigned int QImage::pixel(const QPoint &pt)


static void _init_f_pixel_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<unsigned int > ();
}

static void _call_f_pixel_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<unsigned int > ((unsigned int)((QImage *)cls)->pixel (arg1));
}

static qt_gsi::GenericMethod *_create_f_pixel_c1916 ()
{
  return new qt_gsi::GenericMethod ("pixel", "@brief Method unsigned int QImage::pixel(const QPoint &pt)\n", true, &_init_f_pixel_c1916, &_call_f_pixel_c1916);
}

// int QImage::pixelIndex(int x, int y)


static void _init_f_pixelIndex_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_pixelIndex_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<int > ((int)((QImage *)cls)->pixelIndex (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_pixelIndex_c1426 ()
{
  return new qt_gsi::GenericMethod ("pixelIndex", "@brief Method int QImage::pixelIndex(int x, int y)\n", true, &_init_f_pixelIndex_c1426, &_call_f_pixelIndex_c1426);
}

// int QImage::pixelIndex(const QPoint &pt)


static void _init_f_pixelIndex_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_pixelIndex_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<int > ((int)((QImage *)cls)->pixelIndex (arg1));
}

static qt_gsi::GenericMethod *_create_f_pixelIndex_c1916 ()
{
  return new qt_gsi::GenericMethod ("pixelIndex", "@brief Method int QImage::pixelIndex(const QPoint &pt)\n", true, &_init_f_pixelIndex_c1916, &_call_f_pixelIndex_c1916);
}

// QRect QImage::rect()


static void _init_f_rect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_rect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QImage *)cls)->rect ());
}

static qt_gsi::GenericMethod *_create_f_rect_c0 ()
{
  return new qt_gsi::GenericMethod ("rect", "@brief Method QRect QImage::rect()\n", true, &_init_f_rect_c0, &_call_f_rect_c0);
}

// QImage QImage::rgbSwapped()


static void _init_f_rgbSwapped_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_f_rgbSwapped_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QImage > ((QImage)((QImage *)cls)->rgbSwapped ());
}

static qt_gsi::GenericMethod *_create_f_rgbSwapped_c0 ()
{
  return new qt_gsi::GenericMethod ("rgbSwapped", "@brief Method QImage QImage::rgbSwapped()\n", true, &_init_f_rgbSwapped_c0, &_call_f_rgbSwapped_c0);
}

// bool QImage::save(const QString &fileName, const char *format, int quality)


static void _init_f_save_c4307 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("quality", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_save_c4307 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  int arg3 = args ? args.read<int > () : (int)(-1);
  ret.write<bool > ((bool)((QImage *)cls)->save (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_save_c4307 ()
{
  return new qt_gsi::GenericMethod ("save", "@brief Method bool QImage::save(const QString &fileName, const char *format, int quality)\n", true, &_init_f_save_c4307, &_call_f_save_c4307);
}

// bool QImage::save(QIODevice *device, const char *format, int quality)


static void _init_f_save_c3729 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("quality", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_save_c3729 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  int arg3 = args ? args.read<int > () : (int)(-1);
  ret.write<bool > ((bool)((QImage *)cls)->save (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_save_c3729 ()
{
  return new qt_gsi::GenericMethod ("save", "@brief Method bool QImage::save(QIODevice *device, const char *format, int quality)\n", true, &_init_f_save_c3729, &_call_f_save_c3729);
}

// QImage QImage::scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)


static void _init_f_scaled_c6100 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("aspectMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_3);
  decl->set_return<QImage > ();
}

static void _call_f_scaled_c6100 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > () : (const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio));
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QImage > ((QImage)((QImage *)cls)->scaled (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg3).cref(), qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg4).cref()));
}

static qt_gsi::GenericMethod *_create_f_scaled_c6100 ()
{
  return new qt_gsi::GenericMethod ("scaled", "@brief Method QImage QImage::scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)\n", true, &_init_f_scaled_c6100, &_call_f_scaled_c6100);
}

// QImage QImage::scaled(const QSize &s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)


static void _init_f_scaled_c6479 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aspectMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_2);
  decl->set_return<QImage > ();
}

static void _call_f_scaled_c6479 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > () : (const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio));
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QImage > ((QImage)((QImage *)cls)->scaled (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_scaled_c6479 ()
{
  return new qt_gsi::GenericMethod ("scaled", "@brief Method QImage QImage::scaled(const QSize &s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)\n", true, &_init_f_scaled_c6479, &_call_f_scaled_c6479);
}

// QImage QImage::scaledToHeight(int h, Qt::TransformationMode mode)


static void _init_f_scaledToHeight_c3292 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_scaledToHeight_c3292 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QImage > ((QImage)((QImage *)cls)->scaledToHeight (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_scaledToHeight_c3292 ()
{
  return new qt_gsi::GenericMethod ("scaledToHeight", "@brief Method QImage QImage::scaledToHeight(int h, Qt::TransformationMode mode)\n", true, &_init_f_scaledToHeight_c3292, &_call_f_scaledToHeight_c3292);
}

// QImage QImage::scaledToWidth(int w, Qt::TransformationMode mode)


static void _init_f_scaledToWidth_c3292 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_scaledToWidth_c3292 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QImage > ((QImage)((QImage *)cls)->scaledToWidth (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_scaledToWidth_c3292 ()
{
  return new qt_gsi::GenericMethod ("scaledToWidth", "@brief Method QImage QImage::scaledToWidth(int w, Qt::TransformationMode mode)\n", true, &_init_f_scaledToWidth_c3292, &_call_f_scaledToWidth_c3292);
}

// const unsigned char *QImage::scanLine(int)


static void _init_f_scanLine_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<const unsigned char * > ();
}

static void _call_f_scanLine_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<const unsigned char * > ((const unsigned char *)((QImage *)cls)->scanLine (arg1));
}

static qt_gsi::GenericMethod *_create_f_scanLine_c767 ()
{
  return new qt_gsi::GenericMethod ("scanLine", "@brief Method const unsigned char *QImage::scanLine(int)\n", true, &_init_f_scanLine_c767, &_call_f_scanLine_c767);
}

// int QImage::serialNumber()


static void _init_f_serialNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_serialNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->serialNumber ());
}

static qt_gsi::GenericMethod *_create_f_serialNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("serialNumber", "@brief Method int QImage::serialNumber()\n", true, &_init_f_serialNumber_c0, &_call_f_serialNumber_c0);
}

// void QImage::setAlphaChannel(const QImage &alphaChannel)


static void _init_f_setAlphaChannel_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alphaChannel");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlphaChannel_1877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  ((QImage *)cls)->setAlphaChannel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAlphaChannel_1877 ()
{
  return new qt_gsi::GenericMethod ("setAlphaChannel|alphaChannel=", "@brief Method void QImage::setAlphaChannel(const QImage &alphaChannel)\n", false, &_init_f_setAlphaChannel_1877, &_call_f_setAlphaChannel_1877);
}

// void QImage::setColor(int i, unsigned int c)


static void _init_f_setColor_2431 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<unsigned int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColor_2431 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  unsigned int arg2 = args.read<unsigned int > ();
  ((QImage *)cls)->setColor (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setColor_2431 ()
{
  return new qt_gsi::GenericMethod ("setColor", "@brief Method void QImage::setColor(int i, unsigned int c)\n", false, &_init_f_setColor_2431, &_call_f_setColor_2431);
}

// void QImage::setColorCount(int)


static void _init_f_setColorCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColorCount_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QImage *)cls)->setColorCount (arg1);
}

static qt_gsi::GenericMethod *_create_f_setColorCount_767 ()
{
  return new qt_gsi::GenericMethod ("setColorCount|colorCount=", "@brief Method void QImage::setColorCount(int)\n", false, &_init_f_setColorCount_767, &_call_f_setColorCount_767);
}

// void QImage::setColorTable(const QVector<unsigned int> colors)


static void _init_f_setColorTable_3297 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("colors");
  decl->add_arg<const qt_gsi::Converter<QVector<unsigned int> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColorTable_3297 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVector<unsigned int> >::target_type & arg1 = args.read<const qt_gsi::Converter<QVector<unsigned int> >::target_type & > ();
  ((QImage *)cls)->setColorTable (qt_gsi::QtToCppAdaptor<QVector<unsigned int> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setColorTable_3297 ()
{
  return new qt_gsi::GenericMethod ("setColorTable|colorTable=", "@brief Method void QImage::setColorTable(const QVector<unsigned int> colors)\n", false, &_init_f_setColorTable_3297, &_call_f_setColorTable_3297);
}

// void QImage::setDotsPerMeterX(int)


static void _init_f_setDotsPerMeterX_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDotsPerMeterX_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QImage *)cls)->setDotsPerMeterX (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDotsPerMeterX_767 ()
{
  return new qt_gsi::GenericMethod ("setDotsPerMeterX|dotsPerMeterX=", "@brief Method void QImage::setDotsPerMeterX(int)\n", false, &_init_f_setDotsPerMeterX_767, &_call_f_setDotsPerMeterX_767);
}

// void QImage::setDotsPerMeterY(int)


static void _init_f_setDotsPerMeterY_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDotsPerMeterY_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QImage *)cls)->setDotsPerMeterY (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDotsPerMeterY_767 ()
{
  return new qt_gsi::GenericMethod ("setDotsPerMeterY|dotsPerMeterY=", "@brief Method void QImage::setDotsPerMeterY(int)\n", false, &_init_f_setDotsPerMeterY_767, &_call_f_setDotsPerMeterY_767);
}

// void QImage::setNumColors(int)


static void _init_f_setNumColors_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumColors_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QImage *)cls)->setNumColors (arg1);
}

static qt_gsi::GenericMethod *_create_f_setNumColors_767 ()
{
  return new qt_gsi::GenericMethod ("setNumColors|numColors=", "@brief Method void QImage::setNumColors(int)\n", false, &_init_f_setNumColors_767, &_call_f_setNumColors_767);
}

// void QImage::setOffset(const QPoint &)


static void _init_f_setOffset_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOffset_1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ((QImage *)cls)->setOffset (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOffset_1916 ()
{
  return new qt_gsi::GenericMethod ("setOffset|offset=", "@brief Method void QImage::setOffset(const QPoint &)\n", false, &_init_f_setOffset_1916, &_call_f_setOffset_1916);
}

// void QImage::setPixel(int x, int y, unsigned int index_or_rgb)


static void _init_f_setPixel_3090 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index_or_rgb");
  decl->add_arg<unsigned int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setPixel_3090 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  unsigned int arg3 = args.read<unsigned int > ();
  ((QImage *)cls)->setPixel (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setPixel_3090 ()
{
  return new qt_gsi::GenericMethod ("setPixel", "@brief Method void QImage::setPixel(int x, int y, unsigned int index_or_rgb)\n", false, &_init_f_setPixel_3090, &_call_f_setPixel_3090);
}

// void QImage::setPixel(const QPoint &pt, unsigned int index_or_rgb)


static void _init_f_setPixel_3580 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index_or_rgb");
  decl->add_arg<unsigned int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPixel_3580 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  unsigned int arg2 = args.read<unsigned int > ();
  ((QImage *)cls)->setPixel (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setPixel_3580 ()
{
  return new qt_gsi::GenericMethod ("setPixel", "@brief Method void QImage::setPixel(const QPoint &pt, unsigned int index_or_rgb)\n", false, &_init_f_setPixel_3580, &_call_f_setPixel_3580);
}

// void QImage::setText(const QString &key, const QString &value)


static void _init_f_setText_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setText_3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QImage *)cls)->setText (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setText_3942 ()
{
  return new qt_gsi::GenericMethod ("setText", "@brief Method void QImage::setText(const QString &key, const QString &value)\n", false, &_init_f_setText_3942, &_call_f_setText_3942);
}

// void QImage::setText(const char *key, const char *lang, const QString &)


static void _init_f_setText_5271 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("lang");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arg3");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setText_5271 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  const QString &arg3 = args.read<const QString & > ();
  ((QImage *)cls)->setText (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setText_5271 ()
{
  return new qt_gsi::GenericMethod ("setText", "@brief Method void QImage::setText(const char *key, const char *lang, const QString &)\n", false, &_init_f_setText_5271, &_call_f_setText_5271);
}

// QSize QImage::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QImage *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod ("size", "@brief Method QSize QImage::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// QString QImage::text(const char *key, const char *lang)


static void _init_f_text_c3354 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("lang", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_text_c3354 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)((QImage *)cls)->text (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_text_c3354 ()
{
  return new qt_gsi::GenericMethod ("text", "@brief Method QString QImage::text(const char *key, const char *lang)\n", true, &_init_f_text_c3354, &_call_f_text_c3354);
}

// QString QImage::text(const QImageTextKeyLang &)


static void _init_f_text_c2981 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QImageTextKeyLang & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_text_c2981 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImageTextKeyLang &arg1 = args.read<const QImageTextKeyLang & > ();
  ret.write<QString > ((QString)((QImage *)cls)->text (arg1));
}

static qt_gsi::GenericMethod *_create_f_text_c2981 ()
{
  return new qt_gsi::GenericMethod ("text", "@brief Method QString QImage::text(const QImageTextKeyLang &)\n", true, &_init_f_text_c2981, &_call_f_text_c2981);
}

// QStringList QImage::textKeys()


static void _init_f_textKeys_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_textKeys_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QImage *)cls)->textKeys ()));
}

static qt_gsi::GenericMethod *_create_f_textKeys_c0 ()
{
  return new qt_gsi::GenericMethod ("textKeys", "@brief Method QStringList QImage::textKeys()\n", true, &_init_f_textKeys_c0, &_call_f_textKeys_c0);
}

// QStringList QImage::textLanguages()


static void _init_f_textLanguages_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_textLanguages_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QImage *)cls)->textLanguages ()));
}

static qt_gsi::GenericMethod *_create_f_textLanguages_c0 ()
{
  return new qt_gsi::GenericMethod ("textLanguages", "@brief Method QStringList QImage::textLanguages()\n", true, &_init_f_textLanguages_c0, &_call_f_textLanguages_c0);
}

// QList<QImageTextKeyLang> QImage::textList()


static void _init_f_textList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QImageTextKeyLang> >::target_type > ();
}

static void _call_f_textList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QImageTextKeyLang> >::target_type > ((qt_gsi::Converter<QList<QImageTextKeyLang> >::target_type)qt_gsi::CppToQtAdaptor<QList<QImageTextKeyLang> >(((QImage *)cls)->textList ()));
}

static qt_gsi::GenericMethod *_create_f_textList_c0 ()
{
  return new qt_gsi::GenericMethod ("textList", "@brief Method QList<QImageTextKeyLang> QImage::textList()\n", true, &_init_f_textList_c0, &_call_f_textList_c0);
}

// QImage QImage::transformed(const QMatrix &matrix, Qt::TransformationMode mode)


static void _init_f_transformed_c4548 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_transformed_c4548 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QImage > ((QImage)((QImage *)cls)->transformed (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_transformed_c4548 ()
{
  return new qt_gsi::GenericMethod ("transformed", "@brief Method QImage QImage::transformed(const QMatrix &matrix, Qt::TransformationMode mode)\n", true, &_init_f_transformed_c4548, &_call_f_transformed_c4548);
}

// QImage QImage::transformed(const QTransform &matrix, Qt::TransformationMode mode)


static void _init_f_transformed_c4875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_transformed_c4875 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > () : (const qt_gsi::Converter<Qt::TransformationMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation));
  ret.write<QImage > ((QImage)((QImage *)cls)->transformed (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_transformed_c4875 ()
{
  return new qt_gsi::GenericMethod ("transformed", "@brief Method QImage QImage::transformed(const QTransform &matrix, Qt::TransformationMode mode)\n", true, &_init_f_transformed_c4875, &_call_f_transformed_c4875);
}

// bool QImage::valid(int x, int y)


static void _init_f_valid_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_valid_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<bool > ((bool)((QImage *)cls)->valid (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_valid_c1426 ()
{
  return new qt_gsi::GenericMethod ("valid", "@brief Method bool QImage::valid(int x, int y)\n", true, &_init_f_valid_c1426, &_call_f_valid_c1426);
}

// bool QImage::valid(const QPoint &pt)


static void _init_f_valid_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_valid_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<bool > ((bool)((QImage *)cls)->valid (arg1));
}

static qt_gsi::GenericMethod *_create_f_valid_c1916 ()
{
  return new qt_gsi::GenericMethod ("valid", "@brief Method bool QImage::valid(const QPoint &pt)\n", true, &_init_f_valid_c1916, &_call_f_valid_c1916);
}

// int QImage::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImage *)cls)->width ());
}

static qt_gsi::GenericMethod *_create_f_width_c0 ()
{
  return new qt_gsi::GenericMethod ("width", "@brief Method int QImage::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
}

// static QImage QImage::fromData(const unsigned char *data, int size, const char *format)


static void _init_f_fromData_5018 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const unsigned char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("size");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "0");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<QImage > ();
}

static void _call_f_fromData_5018 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const unsigned char *arg1 = args.read<const unsigned char * > ();
  int arg2 = args.read<int > ();
  const char *arg3 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QImage > ((QImage)QImage::fromData (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_fromData_5018 ()
{
  return new qt_gsi::GenericStaticMethod ("fromData", "@brief Static method QImage QImage::fromData(const unsigned char *data, int size, const char *format)\nThis method is static and can be called without an instance.", &_init_f_fromData_5018, &_call_f_fromData_5018);
}

// static QImage QImage::fromData(const QByteArray &data, const char *format)


static void _init_f_fromData_3932 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_fromData_3932 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QImage > ((QImage)QImage::fromData (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_fromData_3932 ()
{
  return new qt_gsi::GenericStaticMethod ("fromData", "@brief Static method QImage QImage::fromData(const QByteArray &data, const char *format)\nThis method is static and can be called without an instance.", &_init_f_fromData_3932, &_call_f_fromData_3932);
}

// static QMatrix QImage::trueMatrix(const QMatrix &, int w, int h)


static void _init_f_trueMatrix_3341 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("w");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QMatrix > ();
}

static void _call_f_trueMatrix_3341 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QMatrix > ((QMatrix)QImage::trueMatrix (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trueMatrix_3341 ()
{
  return new qt_gsi::GenericStaticMethod ("trueMatrix", "@brief Static method QMatrix QImage::trueMatrix(const QMatrix &, int w, int h)\nThis method is static and can be called without an instance.", &_init_f_trueMatrix_3341, &_call_f_trueMatrix_3341);
}

// static QTransform QImage::trueMatrix(const QTransform &, int w, int h)


static void _init_f_trueMatrix_3668 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("w");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QTransform > ();
}

static void _call_f_trueMatrix_3668 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QTransform > ((QTransform)QImage::trueMatrix (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trueMatrix_3668 ()
{
  return new qt_gsi::GenericStaticMethod ("trueMatrix", "@brief Static method QTransform QImage::trueMatrix(const QTransform &, int w, int h)\nThis method is static and can be called without an instance.", &_init_f_trueMatrix_3668, &_call_f_trueMatrix_3668);
}

namespace gsi
{
extern gsi::Class<QPaintDevice> decl_QPaintDevice;

gsi::Class<QImage> decl_QImage (decl_QPaintDevice, "QImage_Native",
  gsi::Methods(_create_f_allGray_c0 ()) +
  gsi::Methods(_create_f_alphaChannel_c0 ()) +
  gsi::Methods(_create_f_bits_c0 ()) +
  gsi::Methods(_create_f_byteCount_c0 ()) +
  gsi::Methods(_create_f_bytesPerLine_c0 ()) +
  gsi::Methods(_create_f_cacheKey_c0 ()) +
  gsi::Methods(_create_f_color_c767 ()) +
  gsi::Methods(_create_f_colorCount_c0 ()) +
  gsi::Methods(_create_f_colorTable_c0 ()) +
  gsi::Methods(_create_f_convertToFormat_c4993 ()) +
  gsi::Methods(_create_f_convertToFormat_c8364 ()) +
  gsi::Methods(_create_f_copy_c1792 ()) +
  gsi::Methods(_create_f_copy_c2744 ()) +
  gsi::Methods(_create_f_createAlphaMask_c3368 ()) +
  gsi::Methods(_create_f_createHeuristicMask_c864 ()) +
  gsi::Methods(_create_f_createMaskFromColor_c3198 ()) +
  gsi::Methods(_create_f_depth_c0 ()) +
  gsi::Methods(_create_f_detach_0 ()) +
  gsi::Methods(_create_f_dotsPerMeterX_c0 ()) +
  gsi::Methods(_create_f_dotsPerMeterY_c0 ()) +
  gsi::Methods(_create_f_fill_1772 ()) +
  gsi::Methods(_create_f_format_c0 ()) +
  gsi::Methods(_create_f_hasAlphaChannel_c0 ()) +
  gsi::Methods(_create_f_height_c0 ()) +
  gsi::Methods(_create_f_invertPixels_2137 ()) +
  gsi::Methods(_create_f_isDetached_c0 ()) +
  gsi::Methods(_create_f_isGrayscale_c0 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_load_3070 ()) +
  gsi::Methods(_create_f_load_3648 ()) +
  gsi::Methods(_create_f_loadFromData_5018 ()) +
  gsi::Methods(_create_f_loadFromData_3932 ()) +
  gsi::Methods(_create_f_mirrored_c1620 ()) +
  gsi::Methods(_create_f_numBytes_c0 ()) +
  gsi::Methods(_create_f_numColors_c0 ()) +
  gsi::Methods(_create_f_offset_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c1877 ()) +
  gsi::Methods(_create_f_operator_eq__1877 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c1877 ()) +
  gsi::Methods(_create_f_paintEngine_c0 ()) +
  gsi::Methods(_create_f_pixel_c1426 ()) +
  gsi::Methods(_create_f_pixel_c1916 ()) +
  gsi::Methods(_create_f_pixelIndex_c1426 ()) +
  gsi::Methods(_create_f_pixelIndex_c1916 ()) +
  gsi::Methods(_create_f_rect_c0 ()) +
  gsi::Methods(_create_f_rgbSwapped_c0 ()) +
  gsi::Methods(_create_f_save_c4307 ()) +
  gsi::Methods(_create_f_save_c3729 ()) +
  gsi::Methods(_create_f_scaled_c6100 ()) +
  gsi::Methods(_create_f_scaled_c6479 ()) +
  gsi::Methods(_create_f_scaledToHeight_c3292 ()) +
  gsi::Methods(_create_f_scaledToWidth_c3292 ()) +
  gsi::Methods(_create_f_scanLine_c767 ()) +
  gsi::Methods(_create_f_serialNumber_c0 ()) +
  gsi::Methods(_create_f_setAlphaChannel_1877 ()) +
  gsi::Methods(_create_f_setColor_2431 ()) +
  gsi::Methods(_create_f_setColorCount_767 ()) +
  gsi::Methods(_create_f_setColorTable_3297 ()) +
  gsi::Methods(_create_f_setDotsPerMeterX_767 ()) +
  gsi::Methods(_create_f_setDotsPerMeterY_767 ()) +
  gsi::Methods(_create_f_setNumColors_767 ()) +
  gsi::Methods(_create_f_setOffset_1916 ()) +
  gsi::Methods(_create_f_setPixel_3090 ()) +
  gsi::Methods(_create_f_setPixel_3580 ()) +
  gsi::Methods(_create_f_setText_3942 ()) +
  gsi::Methods(_create_f_setText_5271 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_text_c3354 ()) +
  gsi::Methods(_create_f_text_c2981 ()) +
  gsi::Methods(_create_f_textKeys_c0 ()) +
  gsi::Methods(_create_f_textLanguages_c0 ()) +
  gsi::Methods(_create_f_textList_c0 ()) +
  gsi::Methods(_create_f_transformed_c4548 ()) +
  gsi::Methods(_create_f_transformed_c4875 ()) +
  gsi::Methods(_create_f_valid_c1426 ()) +
  gsi::Methods(_create_f_valid_c1916 ()) +
  gsi::Methods(_create_f_width_c0 ()) +
  gsi::Methods(_create_f_fromData_5018 ()) +
  gsi::Methods(_create_f_fromData_3932 ()) +
  gsi::Methods(_create_f_trueMatrix_3341 ()) +
  gsi::Methods(_create_f_trueMatrix_3668 ()),
  "@hide\n@alias QImage");
}


class QImage_Adaptor : public QImage, public qt_gsi::QtObjectBase
{
public:

  virtual ~QImage_Adaptor();

  //  [adaptor ctor] QImage::QImage()
  QImage_Adaptor() : QImage()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const QSize &size, QImage::Format format)
  QImage_Adaptor(const QSize &size, QImage::Format format) : QImage(size, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(int width, int height, QImage::Format format)
  QImage_Adaptor(int width, int height, QImage::Format format) : QImage(width, height, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const unsigned char *data, int width, int height, QImage::Format format)
  QImage_Adaptor(const unsigned char *data, int width, int height, QImage::Format format) : QImage(data, width, height, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const unsigned char *data, int width, int height, int bytesPerLine, QImage::Format format)
  QImage_Adaptor(const unsigned char *data, int width, int height, int bytesPerLine, QImage::Format format) : QImage(data, width, height, bytesPerLine, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const QString &fileName, const char *format)
  QImage_Adaptor(const QString &fileName) : QImage(fileName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const QString &fileName, const char *format)
  QImage_Adaptor(const QString &fileName, const char *format) : QImage(fileName, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const QImage &)
  QImage_Adaptor(const QImage &arg1) : QImage(arg1)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] QPaintEngine *QImage::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QImage::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QImage_Adaptor, QPaintEngine *>(&QImage_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QImage::paintEngine();
    }
  }

  //  [adaptor impl] int QImage::metric(QPaintDevice::PaintDeviceMetric metric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & _metric) const
  {
    return QImage::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(_metric).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric _metric) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QImage_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QImage_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(_metric));
    } else {
      return QImage::metric(_metric);
    }
  }

  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_metric_c3445_0;
};

QImage_Adaptor::~QImage_Adaptor() { }

//  Constructor QImage::QImage() (adaptor class)

static void _init_ctor_QImage_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QImage_Adaptor *> ();
}

static void _call_ctor_QImage_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QImage_Adaptor *> (new QImage_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImage_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage()\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_0, &_call_ctor_QImage_Adaptor_0);
}

//  Constructor QImage::QImage(const QSize &size, QImage::Format format) (adaptor class)

static void _init_ctor_QImage_Adaptor_3430 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_1);
  decl->set_return_new<QImage_Adaptor *> ();
}

static void _call_ctor_QImage_Adaptor_3430 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  const qt_gsi::Converter<QImage::Format>::target_type & arg2 = args.read<const qt_gsi::Converter<QImage::Format>::target_type & > ();
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QImage::Format>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImage_Adaptor_3430 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(const QSize &size, QImage::Format format)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_3430, &_call_ctor_QImage_Adaptor_3430);
}

//  Constructor QImage::QImage(int width, int height, QImage::Format format) (adaptor class)

static void _init_ctor_QImage_Adaptor_3051 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_2);
  decl->set_return_new<QImage_Adaptor *> ();
}

static void _call_ctor_QImage_Adaptor_3051 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const qt_gsi::Converter<QImage::Format>::target_type & arg3 = args.read<const qt_gsi::Converter<QImage::Format>::target_type & > ();
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1, arg2, qt_gsi::QtToCppAdaptor<QImage::Format>(arg3).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImage_Adaptor_3051 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(int width, int height, QImage::Format format)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_3051, &_call_ctor_QImage_Adaptor_3051);
}

//  Constructor QImage::QImage(const unsigned char *data, int width, int height, QImage::Format format) (adaptor class)

static void _init_ctor_QImage_Adaptor_5679 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const unsigned char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("width");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("height");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_3);
  decl->set_return_new<QImage_Adaptor *> ();
}

static void _call_ctor_QImage_Adaptor_5679 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const unsigned char *arg1 = args.read<const unsigned char * > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const qt_gsi::Converter<QImage::Format>::target_type & arg4 = args.read<const qt_gsi::Converter<QImage::Format>::target_type & > ();
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QImage::Format>(arg4).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImage_Adaptor_5679 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(const unsigned char *data, int width, int height, QImage::Format format)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_5679, &_call_ctor_QImage_Adaptor_5679);
}

//  Constructor QImage::QImage(const unsigned char *data, int width, int height, int bytesPerLine, QImage::Format format) (adaptor class)

static void _init_ctor_QImage_Adaptor_6338 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const unsigned char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("width");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("height");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bytesPerLine");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_4);
  decl->set_return_new<QImage_Adaptor *> ();
}

static void _call_ctor_QImage_Adaptor_6338 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const unsigned char *arg1 = args.read<const unsigned char * > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const qt_gsi::Converter<QImage::Format>::target_type & arg5 = args.read<const qt_gsi::Converter<QImage::Format>::target_type & > ();
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<QImage::Format>(arg5).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImage_Adaptor_6338 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(const unsigned char *data, int width, int height, int bytesPerLine, QImage::Format format)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_6338, &_call_ctor_QImage_Adaptor_6338);
}

//  Constructor QImage::QImage(const QString &fileName, const char *format) (adaptor class)

static void _init_ctor_QImage_Adaptor_3648 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return_new<QImage_Adaptor *> ();
}

static void _call_ctor_QImage_Adaptor_3648 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImage_Adaptor_3648 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(const QString &fileName, const char *format)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_3648, &_call_ctor_QImage_Adaptor_3648);
}

//  Constructor QImage::QImage(const QImage &) (adaptor class)

static void _init_ctor_QImage_Adaptor_1877 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return_new<QImage_Adaptor *> ();
}

static void _call_ctor_QImage_Adaptor_1877 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImage_Adaptor_1877 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(const QImage &)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_1877, &_call_ctor_QImage_Adaptor_1877);
}

// QPaintEngine *QImage::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QImage_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImage_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QImage::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// int QImage::metric(QPaintDevice::PaintDeviceMetric metric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QImage_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QImage_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QImage::metric(QPaintDevice::PaintDeviceMetric metric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


namespace gsi
{

extern gsi::Class<QImage> decl_QImage;

gsi::Class<QImage_Adaptor> decl_QImage_Adaptor (decl_QImage, "QImage",
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_ctor_QImage_Adaptor_0 ()) +
  gsi::Methods(_create_ctor_QImage_Adaptor_3430 ()) +
  gsi::Methods(_create_ctor_QImage_Adaptor_3051 ()) +
  gsi::Methods(_create_ctor_QImage_Adaptor_5679 ()) +
  gsi::Methods(_create_ctor_QImage_Adaptor_6338 ()) +
  gsi::Methods(_create_ctor_QImage_Adaptor_3648 ()) +
  gsi::Methods(_create_ctor_QImage_Adaptor_1877 ()),
  "@qt\n@brief Binding of QImage");

}


//  Implementation of the enum wrapper class for QImage::Format
namespace qt_gsi
{

static QImage_Format_Enum *c_1_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_Invalid); }
static QImage_Format_Enum *c_2_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_Mono); }
static QImage_Format_Enum *c_3_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_MonoLSB); }
static QImage_Format_Enum *c_4_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_Indexed8); }
static QImage_Format_Enum *c_5_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_RGB32); }
static QImage_Format_Enum *c_6_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_ARGB32); }
static QImage_Format_Enum *c_7_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_ARGB32_Premultiplied); }
static QImage_Format_Enum *c_8_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_RGB16); }
static QImage_Format_Enum *c_9_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_ARGB8565_Premultiplied); }
static QImage_Format_Enum *c_10_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_RGB666); }
static QImage_Format_Enum *c_11_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_ARGB6666_Premultiplied); }
static QImage_Format_Enum *c_12_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_RGB555); }
static QImage_Format_Enum *c_13_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_ARGB8555_Premultiplied); }
static QImage_Format_Enum *c_14_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_RGB888); }
static QImage_Format_Enum *c_15_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_RGB444); }
static QImage_Format_Enum *c_16_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::Format_ARGB4444_Premultiplied); }
static QImage_Format_Enum *c_17_QImage_Format_Enum () { return new QImage_Format_Enum (QImage::NImageFormats); }

static gsi::Methods mkdefs_QImage_Format () {
  return
    gsi::constant ("Format_Invalid", &qt_gsi::c_1_QImage_Format_Enum, "@brief Enum constant QImage::Format_Invalid") +
    gsi::constant ("Format_Mono", &qt_gsi::c_2_QImage_Format_Enum, "@brief Enum constant QImage::Format_Mono") +
    gsi::constant ("Format_MonoLSB", &qt_gsi::c_3_QImage_Format_Enum, "@brief Enum constant QImage::Format_MonoLSB") +
    gsi::constant ("Format_Indexed8", &qt_gsi::c_4_QImage_Format_Enum, "@brief Enum constant QImage::Format_Indexed8") +
    gsi::constant ("Format_RGB32", &qt_gsi::c_5_QImage_Format_Enum, "@brief Enum constant QImage::Format_RGB32") +
    gsi::constant ("Format_ARGB32", &qt_gsi::c_6_QImage_Format_Enum, "@brief Enum constant QImage::Format_ARGB32") +
    gsi::constant ("Format_ARGB32_Premultiplied", &qt_gsi::c_7_QImage_Format_Enum, "@brief Enum constant QImage::Format_ARGB32_Premultiplied") +
    gsi::constant ("Format_RGB16", &qt_gsi::c_8_QImage_Format_Enum, "@brief Enum constant QImage::Format_RGB16") +
    gsi::constant ("Format_ARGB8565_Premultiplied", &qt_gsi::c_9_QImage_Format_Enum, "@brief Enum constant QImage::Format_ARGB8565_Premultiplied") +
    gsi::constant ("Format_RGB666", &qt_gsi::c_10_QImage_Format_Enum, "@brief Enum constant QImage::Format_RGB666") +
    gsi::constant ("Format_ARGB6666_Premultiplied", &qt_gsi::c_11_QImage_Format_Enum, "@brief Enum constant QImage::Format_ARGB6666_Premultiplied") +
    gsi::constant ("Format_RGB555", &qt_gsi::c_12_QImage_Format_Enum, "@brief Enum constant QImage::Format_RGB555") +
    gsi::constant ("Format_ARGB8555_Premultiplied", &qt_gsi::c_13_QImage_Format_Enum, "@brief Enum constant QImage::Format_ARGB8555_Premultiplied") +
    gsi::constant ("Format_RGB888", &qt_gsi::c_14_QImage_Format_Enum, "@brief Enum constant QImage::Format_RGB888") +
    gsi::constant ("Format_RGB444", &qt_gsi::c_15_QImage_Format_Enum, "@brief Enum constant QImage::Format_RGB444") +
    gsi::constant ("Format_ARGB4444_Premultiplied", &qt_gsi::c_16_QImage_Format_Enum, "@brief Enum constant QImage::Format_ARGB4444_Premultiplied") +
    gsi::constant ("NImageFormats", &qt_gsi::c_17_QImage_Format_Enum, "@brief Enum constant QImage::NImageFormats");
}

static std::string to_s_QImage_Format_Enum (const QImage_Format_Enum *e)
{
  if (e->value () == QImage::Format_Invalid) { return tl::sprintf ("Format_Invalid (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_Mono) { return tl::sprintf ("Format_Mono (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_MonoLSB) { return tl::sprintf ("Format_MonoLSB (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_Indexed8) { return tl::sprintf ("Format_Indexed8 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_RGB32) { return tl::sprintf ("Format_RGB32 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_ARGB32) { return tl::sprintf ("Format_ARGB32 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_ARGB32_Premultiplied) { return tl::sprintf ("Format_ARGB32_Premultiplied (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_RGB16) { return tl::sprintf ("Format_RGB16 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_ARGB8565_Premultiplied) { return tl::sprintf ("Format_ARGB8565_Premultiplied (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_RGB666) { return tl::sprintf ("Format_RGB666 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_ARGB6666_Premultiplied) { return tl::sprintf ("Format_ARGB6666_Premultiplied (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_RGB555) { return tl::sprintf ("Format_RGB555 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_ARGB8555_Premultiplied) { return tl::sprintf ("Format_ARGB8555_Premultiplied (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_RGB888) { return tl::sprintf ("Format_RGB888 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_RGB444) { return tl::sprintf ("Format_RGB444 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::Format_ARGB4444_Premultiplied) { return tl::sprintf ("Format_ARGB4444_Premultiplied (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::NImageFormats) { return tl::sprintf ("NImageFormats (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QImage_Format_Enum (const QImage_Format_Enum *e)
{
  return (unsigned int) e->value ();
}

static QImage_Format_Enum *from_i_QImage_Format_Enum (unsigned int i)
{
  return new QImage_Format_Enum ((QImage::Format) i);
}

static bool equalQImage_Format_Enum (const QImage_Format_Enum *e, QImage_Format_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QImage_Format_Enum (const QImage_Format_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QImage_Format_Enums oropQImage_Format_Enums (const QImage_Format_Enums *e, const QImage_Format_Enums &d)
{
  return e->flags () | d.flags ();
}

static QImage_Format_Enums andopQImage_Format_Enums (const QImage_Format_Enums *e, const QImage_Format_Enums &d)
{
  return e->flags () & d.flags ();
}

static QImage_Format_Enums xoropQImage_Format_Enums (const QImage_Format_Enums *e, const QImage_Format_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QImage_Format_Enums (const QImage_Format_Enums *e)
{
  std::string l;
  if (e->testFlag (QImage::Format_Invalid)) { if (!l.empty ()) l += "|"; l += "Format_Invalid"; }
  if (e->testFlag (QImage::Format_Mono)) { if (!l.empty ()) l += "|"; l += "Format_Mono"; }
  if (e->testFlag (QImage::Format_MonoLSB)) { if (!l.empty ()) l += "|"; l += "Format_MonoLSB"; }
  if (e->testFlag (QImage::Format_Indexed8)) { if (!l.empty ()) l += "|"; l += "Format_Indexed8"; }
  if (e->testFlag (QImage::Format_RGB32)) { if (!l.empty ()) l += "|"; l += "Format_RGB32"; }
  if (e->testFlag (QImage::Format_ARGB32)) { if (!l.empty ()) l += "|"; l += "Format_ARGB32"; }
  if (e->testFlag (QImage::Format_ARGB32_Premultiplied)) { if (!l.empty ()) l += "|"; l += "Format_ARGB32_Premultiplied"; }
  if (e->testFlag (QImage::Format_RGB16)) { if (!l.empty ()) l += "|"; l += "Format_RGB16"; }
  if (e->testFlag (QImage::Format_ARGB8565_Premultiplied)) { if (!l.empty ()) l += "|"; l += "Format_ARGB8565_Premultiplied"; }
  if (e->testFlag (QImage::Format_RGB666)) { if (!l.empty ()) l += "|"; l += "Format_RGB666"; }
  if (e->testFlag (QImage::Format_ARGB6666_Premultiplied)) { if (!l.empty ()) l += "|"; l += "Format_ARGB6666_Premultiplied"; }
  if (e->testFlag (QImage::Format_RGB555)) { if (!l.empty ()) l += "|"; l += "Format_RGB555"; }
  if (e->testFlag (QImage::Format_ARGB8555_Premultiplied)) { if (!l.empty ()) l += "|"; l += "Format_ARGB8555_Premultiplied"; }
  if (e->testFlag (QImage::Format_RGB888)) { if (!l.empty ()) l += "|"; l += "Format_RGB888"; }
  if (e->testFlag (QImage::Format_RGB444)) { if (!l.empty ()) l += "|"; l += "Format_RGB444"; }
  if (e->testFlag (QImage::Format_ARGB4444_Premultiplied)) { if (!l.empty ()) l += "|"; l += "Format_ARGB4444_Premultiplied"; }
  if (e->testFlag (QImage::NImageFormats)) { if (!l.empty ()) l += "|"; l += "NImageFormats"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QImage_Format_Enums (const QImage_Format_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QImage_Format_Enums (const QImage_Format_Enums *e, const QImage_Format_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QImage_Format_Enums> decl_QImage_Format_Enums ("QImage_QFlags_Format",
  gsi::method_ext ("|", &qt_gsi::oropQImage_Format_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQImage_Format_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQImage_Format_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImage_Format_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImage_Format_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QImage_Format_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QImage::Format> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QImage_Format_Enum> decl_QImage_Format_Enum (decl_QImage_Format_Enums, "QImage_Format",
  qt_gsi::mkdefs_QImage_Format () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImage_Format_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImage_Format_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQImage_Format_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QImage_Format_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QImage_Format_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QImage::Format enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QImage> inject_QImage_Format_Enum_in_parent (qt_gsi::mkdefs_QImage_Format ());
static gsi::ClassExt<QImage> decl_QImage_Format_Enum_as_child (decl_QImage_Format_Enum, "Format");

}


//  Implementation of the enum wrapper class for QImage::InvertMode
namespace qt_gsi
{

static QImage_InvertMode_Enum *c_1_QImage_InvertMode_Enum () { return new QImage_InvertMode_Enum (QImage::InvertRgb); }
static QImage_InvertMode_Enum *c_2_QImage_InvertMode_Enum () { return new QImage_InvertMode_Enum (QImage::InvertRgba); }

static gsi::Methods mkdefs_QImage_InvertMode () {
  return
    gsi::constant ("InvertRgb", &qt_gsi::c_1_QImage_InvertMode_Enum, "@brief Enum constant QImage::InvertRgb") +
    gsi::constant ("InvertRgba", &qt_gsi::c_2_QImage_InvertMode_Enum, "@brief Enum constant QImage::InvertRgba");
}

static std::string to_s_QImage_InvertMode_Enum (const QImage_InvertMode_Enum *e)
{
  if (e->value () == QImage::InvertRgb) { return tl::sprintf ("InvertRgb (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImage::InvertRgba) { return tl::sprintf ("InvertRgba (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QImage_InvertMode_Enum (const QImage_InvertMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QImage_InvertMode_Enum *from_i_QImage_InvertMode_Enum (unsigned int i)
{
  return new QImage_InvertMode_Enum ((QImage::InvertMode) i);
}

static bool equalQImage_InvertMode_Enum (const QImage_InvertMode_Enum *e, QImage_InvertMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QImage_InvertMode_Enum (const QImage_InvertMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QImage_InvertMode_Enums oropQImage_InvertMode_Enums (const QImage_InvertMode_Enums *e, const QImage_InvertMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QImage_InvertMode_Enums andopQImage_InvertMode_Enums (const QImage_InvertMode_Enums *e, const QImage_InvertMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QImage_InvertMode_Enums xoropQImage_InvertMode_Enums (const QImage_InvertMode_Enums *e, const QImage_InvertMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QImage_InvertMode_Enums (const QImage_InvertMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QImage::InvertRgb)) { if (!l.empty ()) l += "|"; l += "InvertRgb"; }
  if (e->testFlag (QImage::InvertRgba)) { if (!l.empty ()) l += "|"; l += "InvertRgba"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QImage_InvertMode_Enums (const QImage_InvertMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QImage_InvertMode_Enums (const QImage_InvertMode_Enums *e, const QImage_InvertMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QImage_InvertMode_Enums> decl_QImage_InvertMode_Enums ("QImage_QFlags_InvertMode",
  gsi::method_ext ("|", &qt_gsi::oropQImage_InvertMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQImage_InvertMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQImage_InvertMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImage_InvertMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImage_InvertMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QImage_InvertMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QImage::InvertMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QImage_InvertMode_Enum> decl_QImage_InvertMode_Enum (decl_QImage_InvertMode_Enums, "QImage_InvertMode",
  qt_gsi::mkdefs_QImage_InvertMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImage_InvertMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImage_InvertMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQImage_InvertMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QImage_InvertMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QImage_InvertMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QImage::InvertMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QImage> inject_QImage_InvertMode_Enum_in_parent (qt_gsi::mkdefs_QImage_InvertMode ());
static gsi::ClassExt<QImage> decl_QImage_InvertMode_Enum_as_child (decl_QImage_InvertMode_Enum, "InvertMode");

}

