
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsScene.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsScene_EventAdaptor.h"
#include "gsiDeclQGraphicsScene_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsScene

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsScene::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QGraphicsItem *QGraphicsScene::activePanel()


static void _init_f_activePanel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_activePanel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->activePanel ());
}

static qt_gsi::GenericMethod *_create_f_activePanel_c0 ()
{
  return new qt_gsi::GenericMethod (":activePanel", "@brief Method QGraphicsItem *QGraphicsScene::activePanel()\n", true, &_init_f_activePanel_c0, &_call_f_activePanel_c0);
}

// QGraphicsWidget *QGraphicsScene::activeWindow()


static void _init_f_activeWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_activeWindow_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsScene *)cls)->activeWindow ());
}

static qt_gsi::GenericMethod *_create_f_activeWindow_c0 ()
{
  return new qt_gsi::GenericMethod (":activeWindow", "@brief Method QGraphicsWidget *QGraphicsScene::activeWindow()\n", true, &_init_f_activeWindow_c0, &_call_f_activeWindow_c0);
}

// QGraphicsEllipseItem *QGraphicsScene::addEllipse(const QRectF &rect, const QPen &pen, const QBrush &brush)


static void _init_f_addEllipse_5241 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<QGraphicsEllipseItem * > ();
}

static void _call_f_addEllipse_5241 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QPen &arg2 = args ? args.read<const QPen & > () : (const QPen &)(QPen());
  const QBrush &arg3 = args ? args.read<const QBrush & > () : (const QBrush &)(QBrush());
  ret.write<QGraphicsEllipseItem * > ((QGraphicsEllipseItem *)((QGraphicsScene *)cls)->addEllipse (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_addEllipse_5241 ()
{
  return new qt_gsi::GenericMethod ("addEllipse", "@brief Method QGraphicsEllipseItem *QGraphicsScene::addEllipse(const QRectF &rect, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addEllipse_5241, &_call_f_addEllipse_5241);
}

// QGraphicsEllipseItem *QGraphicsScene::addEllipse(double x, double y, double w, double h, const QPen &pen, const QBrush &brush)


static void _init_f_addEllipse_7339 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_5);
  decl->set_return<QGraphicsEllipseItem * > ();
}

static void _call_f_addEllipse_7339 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  const QPen &arg5 = args ? args.read<const QPen & > () : (const QPen &)(QPen());
  const QBrush &arg6 = args ? args.read<const QBrush & > () : (const QBrush &)(QBrush());
  ret.write<QGraphicsEllipseItem * > ((QGraphicsEllipseItem *)((QGraphicsScene *)cls)->addEllipse (arg1, arg2, arg3, arg4, arg5, arg6));
}

static qt_gsi::GenericMethod *_create_f_addEllipse_7339 ()
{
  return new qt_gsi::GenericMethod ("addEllipse", "@brief Method QGraphicsEllipseItem *QGraphicsScene::addEllipse(double x, double y, double w, double h, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addEllipse_7339, &_call_f_addEllipse_7339);
}

// void QGraphicsScene::addItem(QGraphicsItem *item)


static void _init_f_addItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  qt_gsi::qt_keep (arg1);
  ((QGraphicsScene *)cls)->addItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_addItem_1919 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Method void QGraphicsScene::addItem(QGraphicsItem *item)\n", false, &_init_f_addItem_1919, &_call_f_addItem_1919);
}

// QGraphicsLineItem *QGraphicsScene::addLine(const QLineF &line, const QPen &pen)


static void _init_f_addLine_3433 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<const QLineF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  decl->set_return<QGraphicsLineItem * > ();
}

static void _call_f_addLine_3433 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLineF &arg1 = args.read<const QLineF & > ();
  const QPen &arg2 = args ? args.read<const QPen & > () : (const QPen &)(QPen());
  ret.write<QGraphicsLineItem * > ((QGraphicsLineItem *)((QGraphicsScene *)cls)->addLine (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_addLine_3433 ()
{
  return new qt_gsi::GenericMethod ("addLine", "@brief Method QGraphicsLineItem *QGraphicsScene::addLine(const QLineF &line, const QPen &pen)\n", false, &_init_f_addLine_3433, &_call_f_addLine_3433);
}

// QGraphicsLineItem *QGraphicsScene::addLine(double x1, double y1, double x2, double y2, const QPen &pen)


static void _init_f_addLine_5537 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_4);
  decl->set_return<QGraphicsLineItem * > ();
}

static void _call_f_addLine_5537 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  const QPen &arg5 = args ? args.read<const QPen & > () : (const QPen &)(QPen());
  ret.write<QGraphicsLineItem * > ((QGraphicsLineItem *)((QGraphicsScene *)cls)->addLine (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_addLine_5537 ()
{
  return new qt_gsi::GenericMethod ("addLine", "@brief Method QGraphicsLineItem *QGraphicsScene::addLine(double x1, double y1, double x2, double y2, const QPen &pen)\n", false, &_init_f_addLine_5537, &_call_f_addLine_5537);
}

// QGraphicsPathItem *QGraphicsScene::addPath(const QPainterPath &path, const QPen &pen, const QBrush &brush)


static void _init_f_addPath_5893 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<QGraphicsPathItem * > ();
}

static void _call_f_addPath_5893 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const QPen &arg2 = args ? args.read<const QPen & > () : (const QPen &)(QPen());
  const QBrush &arg3 = args ? args.read<const QBrush & > () : (const QBrush &)(QBrush());
  ret.write<QGraphicsPathItem * > ((QGraphicsPathItem *)((QGraphicsScene *)cls)->addPath (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_addPath_5893 ()
{
  return new qt_gsi::GenericMethod ("addPath", "@brief Method QGraphicsPathItem *QGraphicsScene::addPath(const QPainterPath &path, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addPath_5893, &_call_f_addPath_5893);
}

// QGraphicsPixmapItem *QGraphicsScene::addPixmap(const QPixmap &pixmap)


static void _init_f_addPixmap_2017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return<QGraphicsPixmapItem * > ();
}

static void _call_f_addPixmap_2017 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPixmap &arg1 = args.read<const QPixmap & > ();
  ret.write<QGraphicsPixmapItem * > ((QGraphicsPixmapItem *)((QGraphicsScene *)cls)->addPixmap (arg1));
}

static qt_gsi::GenericMethod *_create_f_addPixmap_2017 ()
{
  return new qt_gsi::GenericMethod ("addPixmap", "@brief Method QGraphicsPixmapItem *QGraphicsScene::addPixmap(const QPixmap &pixmap)\n", false, &_init_f_addPixmap_2017, &_call_f_addPixmap_2017);
}

// QGraphicsPolygonItem *QGraphicsScene::addPolygon(const QPolygonF &polygon, const QPen &pen, const QBrush &brush)


static void _init_f_addPolygon_5587 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<QGraphicsPolygonItem * > ();
}

static void _call_f_addPolygon_5587 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  const QPen &arg2 = args ? args.read<const QPen & > () : (const QPen &)(QPen());
  const QBrush &arg3 = args ? args.read<const QBrush & > () : (const QBrush &)(QBrush());
  ret.write<QGraphicsPolygonItem * > ((QGraphicsPolygonItem *)((QGraphicsScene *)cls)->addPolygon (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_addPolygon_5587 ()
{
  return new qt_gsi::GenericMethod ("addPolygon", "@brief Method QGraphicsPolygonItem *QGraphicsScene::addPolygon(const QPolygonF &polygon, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addPolygon_5587, &_call_f_addPolygon_5587);
}

// QGraphicsRectItem *QGraphicsScene::addRect(const QRectF &rect, const QPen &pen, const QBrush &brush)


static void _init_f_addRect_5241 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_2);
  decl->set_return<QGraphicsRectItem * > ();
}

static void _call_f_addRect_5241 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const QPen &arg2 = args ? args.read<const QPen & > () : (const QPen &)(QPen());
  const QBrush &arg3 = args ? args.read<const QBrush & > () : (const QBrush &)(QBrush());
  ret.write<QGraphicsRectItem * > ((QGraphicsRectItem *)((QGraphicsScene *)cls)->addRect (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_addRect_5241 ()
{
  return new qt_gsi::GenericMethod ("addRect", "@brief Method QGraphicsRectItem *QGraphicsScene::addRect(const QRectF &rect, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addRect_5241, &_call_f_addRect_5241);
}

// QGraphicsRectItem *QGraphicsScene::addRect(double x, double y, double w, double h, const QPen &pen, const QBrush &brush)


static void _init_f_addRect_7339 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("pen", true, "QPen()");
  decl->add_arg<const QPen & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("brush", true, "QBrush()");
  decl->add_arg<const QBrush & > (argspec_5);
  decl->set_return<QGraphicsRectItem * > ();
}

static void _call_f_addRect_7339 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  const QPen &arg5 = args ? args.read<const QPen & > () : (const QPen &)(QPen());
  const QBrush &arg6 = args ? args.read<const QBrush & > () : (const QBrush &)(QBrush());
  ret.write<QGraphicsRectItem * > ((QGraphicsRectItem *)((QGraphicsScene *)cls)->addRect (arg1, arg2, arg3, arg4, arg5, arg6));
}

static qt_gsi::GenericMethod *_create_f_addRect_7339 ()
{
  return new qt_gsi::GenericMethod ("addRect", "@brief Method QGraphicsRectItem *QGraphicsScene::addRect(double x, double y, double w, double h, const QPen &pen, const QBrush &brush)\n", false, &_init_f_addRect_7339, &_call_f_addRect_7339);
}

// QGraphicsSimpleTextItem *QGraphicsScene::addSimpleText(const QString &text, const QFont &font)


static void _init_f_addSimpleText_3718 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("font", true, "QFont()");
  decl->add_arg<const QFont & > (argspec_1);
  decl->set_return<QGraphicsSimpleTextItem * > ();
}

static void _call_f_addSimpleText_3718 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QFont &arg2 = args ? args.read<const QFont & > () : (const QFont &)(QFont());
  ret.write<QGraphicsSimpleTextItem * > ((QGraphicsSimpleTextItem *)((QGraphicsScene *)cls)->addSimpleText (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_addSimpleText_3718 ()
{
  return new qt_gsi::GenericMethod ("addSimpleText", "@brief Method QGraphicsSimpleTextItem *QGraphicsScene::addSimpleText(const QString &text, const QFont &font)\n", false, &_init_f_addSimpleText_3718, &_call_f_addSimpleText_3718);
}

// QGraphicsTextItem *QGraphicsScene::addText(const QString &text, const QFont &font)


static void _init_f_addText_3718 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("font", true, "QFont()");
  decl->add_arg<const QFont & > (argspec_1);
  decl->set_return<QGraphicsTextItem * > ();
}

static void _call_f_addText_3718 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QFont &arg2 = args ? args.read<const QFont & > () : (const QFont &)(QFont());
  ret.write<QGraphicsTextItem * > ((QGraphicsTextItem *)((QGraphicsScene *)cls)->addText (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_addText_3718 ()
{
  return new qt_gsi::GenericMethod ("addText", "@brief Method QGraphicsTextItem *QGraphicsScene::addText(const QString &text, const QFont &font)\n", false, &_init_f_addText_3718, &_call_f_addText_3718);
}

// QGraphicsProxyWidget *QGraphicsScene::addWidget(QWidget *widget, QFlags<Qt::WindowType> wFlags)


static void _init_f_addWidget_3702 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("wFlags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return<QGraphicsProxyWidget * > ();
}

static void _call_f_addWidget_3702 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QGraphicsProxyWidget * > ((QGraphicsProxyWidget *)((QGraphicsScene *)cls)->addWidget (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_addWidget_3702 ()
{
  return new qt_gsi::GenericMethod ("addWidget", "@brief Method QGraphicsProxyWidget *QGraphicsScene::addWidget(QWidget *widget, QFlags<Qt::WindowType> wFlags)\n", false, &_init_f_addWidget_3702, &_call_f_addWidget_3702);
}

// void QGraphicsScene::advance()


static void _init_f_advance_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_advance_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsScene *)cls)->advance ();
}

static qt_gsi::GenericMethod *_create_f_advance_0 ()
{
  return new qt_gsi::GenericMethod ("advance", "@brief Method void QGraphicsScene::advance()\n", false, &_init_f_advance_0, &_call_f_advance_0);
}

// QBrush QGraphicsScene::backgroundBrush()


static void _init_f_backgroundBrush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_backgroundBrush_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QGraphicsScene *)cls)->backgroundBrush ());
}

static qt_gsi::GenericMethod *_create_f_backgroundBrush_c0 ()
{
  return new qt_gsi::GenericMethod (":backgroundBrush", "@brief Method QBrush QGraphicsScene::backgroundBrush()\n", true, &_init_f_backgroundBrush_c0, &_call_f_backgroundBrush_c0);
}

// int QGraphicsScene::bspTreeDepth()


static void _init_f_bspTreeDepth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bspTreeDepth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QGraphicsScene *)cls)->bspTreeDepth ());
}

static qt_gsi::GenericMethod *_create_f_bspTreeDepth_c0 ()
{
  return new qt_gsi::GenericMethod (":bspTreeDepth", "@brief Method int QGraphicsScene::bspTreeDepth()\n", true, &_init_f_bspTreeDepth_c0, &_call_f_bspTreeDepth_c0);
}

// void QGraphicsScene::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsScene *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QGraphicsScene::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// void QGraphicsScene::clearFocus()


static void _init_f_clearFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsScene *)cls)->clearFocus ();
}

static qt_gsi::GenericMethod *_create_f_clearFocus_0 ()
{
  return new qt_gsi::GenericMethod ("clearFocus", "@brief Method void QGraphicsScene::clearFocus()\n", false, &_init_f_clearFocus_0, &_call_f_clearFocus_0);
}

// void QGraphicsScene::clearSelection()


static void _init_f_clearSelection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearSelection_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsScene *)cls)->clearSelection ();
}

static qt_gsi::GenericMethod *_create_f_clearSelection_0 ()
{
  return new qt_gsi::GenericMethod ("clearSelection", "@brief Method void QGraphicsScene::clearSelection()\n", false, &_init_f_clearSelection_0, &_call_f_clearSelection_0);
}

// QList<QGraphicsItem *> QGraphicsScene::collidingItems(const QGraphicsItem *item, Qt::ItemSelectionMode mode)


static void _init_f_collidingItems_c4977 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_collidingItems_c4977 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->collidingItems (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_collidingItems_c4977 ()
{
  return new qt_gsi::GenericMethod ("collidingItems", "@brief Method QList<QGraphicsItem *> QGraphicsScene::collidingItems(const QGraphicsItem *item, Qt::ItemSelectionMode mode)\n", true, &_init_f_collidingItems_c4977, &_call_f_collidingItems_c4977);
}

// QGraphicsItemGroup *QGraphicsScene::createItemGroup(const QList<QGraphicsItem *> &items)


static void _init_f_createItemGroup_3411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const qt_gsi::Converter<QList<QGraphicsItem *> >::target_type & > (argspec_0);
  decl->set_return<QGraphicsItemGroup * > ();
}

static void _call_f_createItemGroup_3411 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QGraphicsItem *> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QGraphicsItem *> >::target_type & > ();
  ret.write<QGraphicsItemGroup * > ((QGraphicsItemGroup *)((QGraphicsScene *)cls)->createItemGroup (qt_gsi::QtToCppAdaptor<QList<QGraphicsItem *> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_createItemGroup_3411 ()
{
  return new qt_gsi::GenericMethod ("createItemGroup", "@brief Method QGraphicsItemGroup *QGraphicsScene::createItemGroup(const QList<QGraphicsItem *> &items)\n", false, &_init_f_createItemGroup_3411, &_call_f_createItemGroup_3411);
}

// void QGraphicsScene::destroyItemGroup(QGraphicsItemGroup *group)


static void _init_f_destroyItemGroup_2444 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("group");
  decl->add_arg<QGraphicsItemGroup * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_destroyItemGroup_2444 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItemGroup *arg1 = args.read<QGraphicsItemGroup * > ();
  ((QGraphicsScene *)cls)->destroyItemGroup (arg1);
}

static qt_gsi::GenericMethod *_create_f_destroyItemGroup_2444 ()
{
  return new qt_gsi::GenericMethod ("destroyItemGroup", "@brief Method void QGraphicsScene::destroyItemGroup(QGraphicsItemGroup *group)\n", false, &_init_f_destroyItemGroup_2444, &_call_f_destroyItemGroup_2444);
}

// QGraphicsItem *QGraphicsScene::focusItem()


static void _init_f_focusItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_focusItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->focusItem ());
}

static qt_gsi::GenericMethod *_create_f_focusItem_c0 ()
{
  return new qt_gsi::GenericMethod (":focusItem", "@brief Method QGraphicsItem *QGraphicsScene::focusItem()\n", true, &_init_f_focusItem_c0, &_call_f_focusItem_c0);
}

// QFont QGraphicsScene::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFont > ((QFont)((QGraphicsScene *)cls)->font ());
}

static qt_gsi::GenericMethod *_create_f_font_c0 ()
{
  return new qt_gsi::GenericMethod (":font", "@brief Method QFont QGraphicsScene::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
}

// QBrush QGraphicsScene::foregroundBrush()


static void _init_f_foregroundBrush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_foregroundBrush_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QGraphicsScene *)cls)->foregroundBrush ());
}

static qt_gsi::GenericMethod *_create_f_foregroundBrush_c0 ()
{
  return new qt_gsi::GenericMethod (":foregroundBrush", "@brief Method QBrush QGraphicsScene::foregroundBrush()\n", true, &_init_f_foregroundBrush_c0, &_call_f_foregroundBrush_c0);
}

// bool QGraphicsScene::hasFocus()


static void _init_f_hasFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFocus_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->hasFocus ());
}

static qt_gsi::GenericMethod *_create_f_hasFocus_c0 ()
{
  return new qt_gsi::GenericMethod ("hasFocus", "@brief Method bool QGraphicsScene::hasFocus()\n", true, &_init_f_hasFocus_c0, &_call_f_hasFocus_c0);
}

// double QGraphicsScene::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsScene *)cls)->height ());
}

static qt_gsi::GenericMethod *_create_f_height_c0 ()
{
  return new qt_gsi::GenericMethod ("height", "@brief Method double QGraphicsScene::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
}

// QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsScene *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_inputMethodQuery_c2420 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)\n", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
}

// void QGraphicsScene::invalidate(double x, double y, double w, double h, QFlags<QGraphicsScene::SceneLayer> layers)


static void _init_f_invalidate_7495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("layers", true, "QGraphicsScene::AllLayers");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_invalidate_7495 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type & arg5 = args ? args.read<const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type & > () : (const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QGraphicsScene::SceneLayer> >(heap, QGraphicsScene::AllLayers));
  ((QGraphicsScene *)cls)->invalidate (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<QFlags<QGraphicsScene::SceneLayer> >(arg5).cref());
}

static qt_gsi::GenericMethod *_create_f_invalidate_7495 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Method void QGraphicsScene::invalidate(double x, double y, double w, double h, QFlags<QGraphicsScene::SceneLayer> layers)\n", false, &_init_f_invalidate_7495, &_call_f_invalidate_7495);
}

// void QGraphicsScene::invalidate(const QRectF &rect, QFlags<QGraphicsScene::SceneLayer> layers)


static void _init_f_invalidate_5397 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("layers", true, "QGraphicsScene::AllLayers");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_invalidate_5397 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type & > () : (const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QGraphicsScene::SceneLayer> >(heap, QGraphicsScene::AllLayers));
  ((QGraphicsScene *)cls)->invalidate (arg1, qt_gsi::QtToCppAdaptor<QFlags<QGraphicsScene::SceneLayer> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_invalidate_5397 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Method void QGraphicsScene::invalidate(const QRectF &rect, QFlags<QGraphicsScene::SceneLayer> layers)\n", false, &_init_f_invalidate_5397, &_call_f_invalidate_5397);
}

// bool QGraphicsScene::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->isActive ());
}

static qt_gsi::GenericMethod *_create_f_isActive_c0 ()
{
  return new qt_gsi::GenericMethod ("isActive?", "@brief Method bool QGraphicsScene::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
}

// bool QGraphicsScene::isSortCacheEnabled()


static void _init_f_isSortCacheEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSortCacheEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->isSortCacheEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isSortCacheEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isSortCacheEnabled?|:sortCacheEnabled", "@brief Method bool QGraphicsScene::isSortCacheEnabled()\n", true, &_init_f_isSortCacheEnabled_c0, &_call_f_isSortCacheEnabled_c0);
}

// QGraphicsItem *QGraphicsScene::itemAt(const QPointF &pos)


static void _init_f_itemAt_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->itemAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c1986 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsScene::itemAt(const QPointF &pos)\n", true, &_init_f_itemAt_c1986, &_call_f_itemAt_c1986);
}

// QGraphicsItem *QGraphicsScene::itemAt(const QPointF &pos, const QTransform &deviceTransform)


static void _init_f_itemAt_c4228 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deviceTransform");
  decl->add_arg<const QTransform & > (argspec_1);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c4228 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const QTransform &arg2 = args.read<const QTransform & > ();
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->itemAt (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c4228 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsScene::itemAt(const QPointF &pos, const QTransform &deviceTransform)\n", true, &_init_f_itemAt_c4228, &_call_f_itemAt_c4228);
}

// QGraphicsItem *QGraphicsScene::itemAt(double x, double y)


static void _init_f_itemAt_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->itemAt (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c2034 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsScene::itemAt(double x, double y)\n", true, &_init_f_itemAt_c2034, &_call_f_itemAt_c2034);
}

// QGraphicsItem *QGraphicsScene::itemAt(double x, double y, const QTransform &deviceTransform)


static void _init_f_itemAt_c4276 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("deviceTransform");
  decl->add_arg<const QTransform & > (argspec_2);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c4276 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  const QTransform &arg3 = args.read<const QTransform & > ();
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->itemAt (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c4276 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsScene::itemAt(double x, double y, const QTransform &deviceTransform)\n", true, &_init_f_itemAt_c4276, &_call_f_itemAt_c4276);
}

// QGraphicsScene::ItemIndexMethod QGraphicsScene::itemIndexMethod()


static void _init_f_itemIndexMethod_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type > ();
}

static void _call_f_itemIndexMethod_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type > ((qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsScene::ItemIndexMethod>(((QGraphicsScene *)cls)->itemIndexMethod ()));
}

static qt_gsi::GenericMethod *_create_f_itemIndexMethod_c0 ()
{
  return new qt_gsi::GenericMethod (":itemIndexMethod", "@brief Method QGraphicsScene::ItemIndexMethod QGraphicsScene::itemIndexMethod()\n", true, &_init_f_itemIndexMethod_c0, &_call_f_itemIndexMethod_c0);
}

// QList<QGraphicsItem *> QGraphicsScene::items()


static void _init_f_items_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items ()));
}

static qt_gsi::GenericMethod *_create_f_items_c0 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items()\n", true, &_init_f_items_c0, &_call_f_items_c0);
}

// QList<QGraphicsItem *> QGraphicsScene::items(Qt::SortOrder order)


static void _init_f_items_c1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c1681 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg1).cref())));
}

static qt_gsi::GenericMethod *_create_f_items_c1681 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(Qt::SortOrder order)\n", true, &_init_f_items_c1681, &_call_f_items_c1681);
}

// QList<QGraphicsItem *> QGraphicsScene::items(const QPointF &pos, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c8164 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_3);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c8164 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  const QTransform &arg4 = args ? args.read<const QTransform & > () : (const QTransform &)(QTransform());
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg3).cref(), arg4)));
}

static qt_gsi::GenericMethod *_create_f_items_c8164 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QPointF &pos, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c8164, &_call_f_items_c8164);
}

// QList<QGraphicsItem *> QGraphicsScene::items(const QRectF &rect, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c8040 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_3);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c8040 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  const QTransform &arg4 = args ? args.read<const QTransform & > () : (const QTransform &)(QTransform());
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg3).cref(), arg4)));
}

static qt_gsi::GenericMethod *_create_f_items_c8040 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QRectF &rect, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c8040, &_call_f_items_c8040);
}

// QList<QGraphicsItem *> QGraphicsScene::items(const QPolygonF &polygon, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c8386 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_3);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c8386 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  const QTransform &arg4 = args ? args.read<const QTransform & > () : (const QTransform &)(QTransform());
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg3).cref(), arg4)));
}

static qt_gsi::GenericMethod *_create_f_items_c8386 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QPolygonF &polygon, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c8386, &_call_f_items_c8386);
}

// QList<QGraphicsItem *> QGraphicsScene::items(const QPainterPath &path, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c8692 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_3);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c8692 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  const QTransform &arg4 = args ? args.read<const QTransform & > () : (const QTransform &)(QTransform());
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg3).cref(), arg4)));
}

static qt_gsi::GenericMethod *_create_f_items_c8692 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QPainterPath &path, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c8692, &_call_f_items_c8692);
}

// QList<QGraphicsItem *> QGraphicsScene::items(const QPointF &pos)


static void _init_f_items_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1)));
}

static qt_gsi::GenericMethod *_create_f_items_c1986 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QPointF &pos)\n", true, &_init_f_items_c1986, &_call_f_items_c1986);
}

// QList<QGraphicsItem *> QGraphicsScene::items(const QRectF &rect, Qt::ItemSelectionMode mode)


static void _init_f_items_c4225 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c4225 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_items_c4225 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QRectF &rect, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c4225, &_call_f_items_c4225);
}

// QList<QGraphicsItem *> QGraphicsScene::items(const QPolygonF &polygon, Qt::ItemSelectionMode mode)


static void _init_f_items_c4571 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c4571 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_items_c4571 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QPolygonF &polygon, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c4571, &_call_f_items_c4571);
}

// QList<QGraphicsItem *> QGraphicsScene::items(const QPainterPath &path, Qt::ItemSelectionMode mode)


static void _init_f_items_c4877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c4877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_items_c4877 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(const QPainterPath &path, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c4877, &_call_f_items_c4877);
}

// QList<QGraphicsItem *> QGraphicsScene::items(double x, double y, double w, double h, Qt::ItemSelectionMode mode)


static void _init_f_items_c6323 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c6323 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg5).cref())));
}

static qt_gsi::GenericMethod *_create_f_items_c6323 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(double x, double y, double w, double h, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c6323, &_call_f_items_c6323);
}

// QList<QGraphicsItem *> QGraphicsScene::items(double x, double y, double w, double h, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)


static void _init_f_items_c10138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("deviceTransform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_6);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c10138 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg5 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg6 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  const QTransform &arg7 = args ? args.read<const QTransform & > () : (const QTransform &)(QTransform());
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->items (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg5).cref(), qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg6).cref(), arg7)));
}

static qt_gsi::GenericMethod *_create_f_items_c10138 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsScene::items(double x, double y, double w, double h, Qt::ItemSelectionMode mode, Qt::SortOrder order, const QTransform &deviceTransform)\n", true, &_init_f_items_c10138, &_call_f_items_c10138);
}

// QRectF QGraphicsScene::itemsBoundingRect()


static void _init_f_itemsBoundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_itemsBoundingRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsScene *)cls)->itemsBoundingRect ());
}

static qt_gsi::GenericMethod *_create_f_itemsBoundingRect_c0 ()
{
  return new qt_gsi::GenericMethod ("itemsBoundingRect", "@brief Method QRectF QGraphicsScene::itemsBoundingRect()\n", true, &_init_f_itemsBoundingRect_c0, &_call_f_itemsBoundingRect_c0);
}

// QGraphicsItem *QGraphicsScene::mouseGrabberItem()


static void _init_f_mouseGrabberItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_mouseGrabberItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsScene *)cls)->mouseGrabberItem ());
}

static qt_gsi::GenericMethod *_create_f_mouseGrabberItem_c0 ()
{
  return new qt_gsi::GenericMethod ("mouseGrabberItem", "@brief Method QGraphicsItem *QGraphicsScene::mouseGrabberItem()\n", true, &_init_f_mouseGrabberItem_c0, &_call_f_mouseGrabberItem_c0);
}

// QPalette QGraphicsScene::palette()


static void _init_f_palette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_palette_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPalette > ((QPalette)((QGraphicsScene *)cls)->palette ());
}

static qt_gsi::GenericMethod *_create_f_palette_c0 ()
{
  return new qt_gsi::GenericMethod (":palette", "@brief Method QPalette QGraphicsScene::palette()\n", true, &_init_f_palette_c0, &_call_f_palette_c0);
}

// void QGraphicsScene::removeItem(QGraphicsItem *item)


static void _init_f_removeItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeItem_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  ((QGraphicsScene *)cls)->removeItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeItem_1919 ()
{
  return new qt_gsi::GenericMethod ("removeItem", "@brief Method void QGraphicsScene::removeItem(QGraphicsItem *item)\n", false, &_init_f_removeItem_1919, &_call_f_removeItem_1919);
}

// void QGraphicsScene::render(QPainter *painter, const QRectF &target, const QRectF &source, Qt::AspectRatioMode aspectRatioMode)


static void _init_f_render_7083 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("target", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("source", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("aspectRatioMode", true, "Qt::KeepAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_render_7083 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRectF &arg2 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  const QRectF &arg3 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > () : (const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::KeepAspectRatio));
  ((QGraphicsScene *)cls)->render (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_render_7083 ()
{
  return new qt_gsi::GenericMethod ("render", "@brief Method void QGraphicsScene::render(QPainter *painter, const QRectF &target, const QRectF &source, Qt::AspectRatioMode aspectRatioMode)\n", false, &_init_f_render_7083, &_call_f_render_7083);
}

// QRectF QGraphicsScene::sceneRect()


static void _init_f_sceneRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_sceneRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsScene *)cls)->sceneRect ());
}

static qt_gsi::GenericMethod *_create_f_sceneRect_c0 ()
{
  return new qt_gsi::GenericMethod (":sceneRect", "@brief Method QRectF QGraphicsScene::sceneRect()\n", true, &_init_f_sceneRect_c0, &_call_f_sceneRect_c0);
}

// QList<QGraphicsItem *> QGraphicsScene::selectedItems()


static void _init_f_selectedItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_selectedItems_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsScene *)cls)->selectedItems ()));
}

static qt_gsi::GenericMethod *_create_f_selectedItems_c0 ()
{
  return new qt_gsi::GenericMethod ("selectedItems", "@brief Method QList<QGraphicsItem *> QGraphicsScene::selectedItems()\n", true, &_init_f_selectedItems_c0, &_call_f_selectedItems_c0);
}

// QPainterPath QGraphicsScene::selectionArea()


static void _init_f_selectionArea_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_selectionArea_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsScene *)cls)->selectionArea ());
}

static qt_gsi::GenericMethod *_create_f_selectionArea_c0 ()
{
  return new qt_gsi::GenericMethod (":selectionArea", "@brief Method QPainterPath QGraphicsScene::selectionArea()\n", true, &_init_f_selectionArea_c0, &_call_f_selectionArea_c0);
}

// bool QGraphicsScene::sendEvent(QGraphicsItem *item, QEvent *event)


static void _init_f_sendEvent_3028 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_sendEvent_3028 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->sendEvent (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_sendEvent_3028 ()
{
  return new qt_gsi::GenericMethod ("sendEvent", "@brief Method bool QGraphicsScene::sendEvent(QGraphicsItem *item, QEvent *event)\n", false, &_init_f_sendEvent_3028, &_call_f_sendEvent_3028);
}

// void QGraphicsScene::setActivePanel(QGraphicsItem *item)


static void _init_f_setActivePanel_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActivePanel_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  ((QGraphicsScene *)cls)->setActivePanel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setActivePanel_1919 ()
{
  return new qt_gsi::GenericMethod ("setActivePanel|activePanel=", "@brief Method void QGraphicsScene::setActivePanel(QGraphicsItem *item)\n", false, &_init_f_setActivePanel_1919, &_call_f_setActivePanel_1919);
}

// void QGraphicsScene::setActiveWindow(QGraphicsWidget *widget)


static void _init_f_setActiveWindow_2132 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QGraphicsWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveWindow_2132 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsWidget *arg1 = args.read<QGraphicsWidget * > ();
  ((QGraphicsScene *)cls)->setActiveWindow (arg1);
}

static qt_gsi::GenericMethod *_create_f_setActiveWindow_2132 ()
{
  return new qt_gsi::GenericMethod ("setActiveWindow|activeWindow=", "@brief Method void QGraphicsScene::setActiveWindow(QGraphicsWidget *widget)\n", false, &_init_f_setActiveWindow_2132, &_call_f_setActiveWindow_2132);
}

// void QGraphicsScene::setBackgroundBrush(const QBrush &brush)


static void _init_f_setBackgroundBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundBrush_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QGraphicsScene *)cls)->setBackgroundBrush (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBackgroundBrush_1910 ()
{
  return new qt_gsi::GenericMethod ("setBackgroundBrush|backgroundBrush=", "@brief Method void QGraphicsScene::setBackgroundBrush(const QBrush &brush)\n", false, &_init_f_setBackgroundBrush_1910, &_call_f_setBackgroundBrush_1910);
}

// void QGraphicsScene::setBspTreeDepth(int depth)


static void _init_f_setBspTreeDepth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("depth");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBspTreeDepth_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QGraphicsScene *)cls)->setBspTreeDepth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBspTreeDepth_767 ()
{
  return new qt_gsi::GenericMethod ("setBspTreeDepth|bspTreeDepth=", "@brief Method void QGraphicsScene::setBspTreeDepth(int depth)\n", false, &_init_f_setBspTreeDepth_767, &_call_f_setBspTreeDepth_767);
}

// void QGraphicsScene::setFocus(Qt::FocusReason focusReason)


static void _init_f_setFocus_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusReason", true, "Qt::OtherFocusReason");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusReason>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocus_1877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FocusReason>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::FocusReason>::target_type & > () : (const qt_gsi::Converter<Qt::FocusReason>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::FocusReason>(heap, Qt::OtherFocusReason));
  ((QGraphicsScene *)cls)->setFocus (qt_gsi::QtToCppAdaptor<Qt::FocusReason>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFocus_1877 ()
{
  return new qt_gsi::GenericMethod ("setFocus", "@brief Method void QGraphicsScene::setFocus(Qt::FocusReason focusReason)\n", false, &_init_f_setFocus_1877, &_call_f_setFocus_1877);
}

// void QGraphicsScene::setFocusItem(QGraphicsItem *item, Qt::FocusReason focusReason)


static void _init_f_setFocusItem_3688 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("focusReason", true, "Qt::OtherFocusReason");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusReason>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFocusItem_3688 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FocusReason>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::FocusReason>::target_type & > () : (const qt_gsi::Converter<Qt::FocusReason>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::FocusReason>(heap, Qt::OtherFocusReason));
  ((QGraphicsScene *)cls)->setFocusItem (arg1, qt_gsi::QtToCppAdaptor<Qt::FocusReason>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setFocusItem_3688 ()
{
  return new qt_gsi::GenericMethod ("setFocusItem", "@brief Method void QGraphicsScene::setFocusItem(QGraphicsItem *item, Qt::FocusReason focusReason)\n", false, &_init_f_setFocusItem_3688, &_call_f_setFocusItem_3688);
}

// void QGraphicsScene::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QGraphicsScene *)cls)->setFont (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFont_1801 ()
{
  return new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QGraphicsScene::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
}

// void QGraphicsScene::setForegroundBrush(const QBrush &brush)


static void _init_f_setForegroundBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForegroundBrush_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QGraphicsScene *)cls)->setForegroundBrush (arg1);
}

static qt_gsi::GenericMethod *_create_f_setForegroundBrush_1910 ()
{
  return new qt_gsi::GenericMethod ("setForegroundBrush|foregroundBrush=", "@brief Method void QGraphicsScene::setForegroundBrush(const QBrush &brush)\n", false, &_init_f_setForegroundBrush_1910, &_call_f_setForegroundBrush_1910);
}

// void QGraphicsScene::setItemIndexMethod(QGraphicsScene::ItemIndexMethod method)


static void _init_f_setItemIndexMethod_3456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("method");
  decl->add_arg<const qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemIndexMethod_3456 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsScene::ItemIndexMethod>::target_type & > ();
  ((QGraphicsScene *)cls)->setItemIndexMethod (qt_gsi::QtToCppAdaptor<QGraphicsScene::ItemIndexMethod>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setItemIndexMethod_3456 ()
{
  return new qt_gsi::GenericMethod ("setItemIndexMethod|itemIndexMethod=", "@brief Method void QGraphicsScene::setItemIndexMethod(QGraphicsScene::ItemIndexMethod method)\n", false, &_init_f_setItemIndexMethod_3456, &_call_f_setItemIndexMethod_3456);
}

// void QGraphicsScene::setPalette(const QPalette &palette)


static void _init_f_setPalette_2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPalette_2113 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QGraphicsScene *)cls)->setPalette (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPalette_2113 ()
{
  return new qt_gsi::GenericMethod ("setPalette|palette=", "@brief Method void QGraphicsScene::setPalette(const QPalette &palette)\n", false, &_init_f_setPalette_2113, &_call_f_setPalette_2113);
}

// void QGraphicsScene::setSceneRect(const QRectF &rect)


static void _init_f_setSceneRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSceneRect_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QGraphicsScene *)cls)->setSceneRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSceneRect_1862 ()
{
  return new qt_gsi::GenericMethod ("setSceneRect|sceneRect=", "@brief Method void QGraphicsScene::setSceneRect(const QRectF &rect)\n", false, &_init_f_setSceneRect_1862, &_call_f_setSceneRect_1862);
}

// void QGraphicsScene::setSceneRect(double x, double y, double w, double h)


static void _init_f_setSceneRect_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setSceneRect_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QGraphicsScene *)cls)->setSceneRect (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setSceneRect_3960 ()
{
  return new qt_gsi::GenericMethod ("setSceneRect", "@brief Method void QGraphicsScene::setSceneRect(double x, double y, double w, double h)\n", false, &_init_f_setSceneRect_3960, &_call_f_setSceneRect_3960);
}

// void QGraphicsScene::setSelectionArea(const QPainterPath &path)


static void _init_f_setSelectionArea_2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectionArea_2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ((QGraphicsScene *)cls)->setSelectionArea (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSelectionArea_2514 ()
{
  return new qt_gsi::GenericMethod ("setSelectionArea|selectionArea=", "@brief Method void QGraphicsScene::setSelectionArea(const QPainterPath &path)\n", false, &_init_f_setSelectionArea_2514, &_call_f_setSelectionArea_2514);
}

// void QGraphicsScene::setSelectionArea(const QPainterPath &path, const QTransform &deviceTransform)


static void _init_f_setSelectionArea_4756 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deviceTransform");
  decl->add_arg<const QTransform & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSelectionArea_4756 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const QTransform &arg2 = args.read<const QTransform & > ();
  ((QGraphicsScene *)cls)->setSelectionArea (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setSelectionArea_4756 ()
{
  return new qt_gsi::GenericMethod ("setSelectionArea", "@brief Method void QGraphicsScene::setSelectionArea(const QPainterPath &path, const QTransform &deviceTransform)\n", false, &_init_f_setSelectionArea_4756, &_call_f_setSelectionArea_4756);
}

// void QGraphicsScene::setSelectionArea(const QPainterPath &path, Qt::ItemSelectionMode mode)


static void _init_f_setSelectionArea_4877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSelectionArea_4877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ((QGraphicsScene *)cls)->setSelectionArea (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setSelectionArea_4877 ()
{
  return new qt_gsi::GenericMethod ("setSelectionArea", "@brief Method void QGraphicsScene::setSelectionArea(const QPainterPath &path, Qt::ItemSelectionMode mode)\n", false, &_init_f_setSelectionArea_4877, &_call_f_setSelectionArea_4877);
}

// void QGraphicsScene::setSelectionArea(const QPainterPath &path, Qt::ItemSelectionMode mode, const QTransform &deviceTransform)


static void _init_f_setSelectionArea_7119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("deviceTransform");
  decl->add_arg<const QTransform & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setSelectionArea_7119 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  const QTransform &arg3 = args.read<const QTransform & > ();
  ((QGraphicsScene *)cls)->setSelectionArea (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref(), arg3);
}

static qt_gsi::GenericMethod *_create_f_setSelectionArea_7119 ()
{
  return new qt_gsi::GenericMethod ("setSelectionArea", "@brief Method void QGraphicsScene::setSelectionArea(const QPainterPath &path, Qt::ItemSelectionMode mode, const QTransform &deviceTransform)\n", false, &_init_f_setSelectionArea_7119, &_call_f_setSelectionArea_7119);
}

// void QGraphicsScene::setSortCacheEnabled(bool enabled)


static void _init_f_setSortCacheEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortCacheEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsScene *)cls)->setSortCacheEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSortCacheEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setSortCacheEnabled|sortCacheEnabled=", "@brief Method void QGraphicsScene::setSortCacheEnabled(bool enabled)\n", false, &_init_f_setSortCacheEnabled_864, &_call_f_setSortCacheEnabled_864);
}

// void QGraphicsScene::setStickyFocus(bool enabled)


static void _init_f_setStickyFocus_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStickyFocus_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsScene *)cls)->setStickyFocus (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStickyFocus_864 ()
{
  return new qt_gsi::GenericMethod ("setStickyFocus|stickyFocus=", "@brief Method void QGraphicsScene::setStickyFocus(bool enabled)\n", false, &_init_f_setStickyFocus_864, &_call_f_setStickyFocus_864);
}

// void QGraphicsScene::setStyle(QStyle *style)


static void _init_f_setStyle_1232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<QStyle * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1232 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle *arg1 = args.read<QStyle * > ();
  ((QGraphicsScene *)cls)->setStyle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStyle_1232 ()
{
  return new qt_gsi::GenericMethod ("setStyle|style=", "@brief Method void QGraphicsScene::setStyle(QStyle *style)\n", false, &_init_f_setStyle_1232, &_call_f_setStyle_1232);
}

// bool QGraphicsScene::stickyFocus()


static void _init_f_stickyFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_stickyFocus_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsScene *)cls)->stickyFocus ());
}

static qt_gsi::GenericMethod *_create_f_stickyFocus_c0 ()
{
  return new qt_gsi::GenericMethod (":stickyFocus", "@brief Method bool QGraphicsScene::stickyFocus()\n", true, &_init_f_stickyFocus_c0, &_call_f_stickyFocus_c0);
}

// QStyle *QGraphicsScene::style()


static void _init_f_style_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyle * > ();
}

static void _call_f_style_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyle * > ((QStyle *)((QGraphicsScene *)cls)->style ());
}

static qt_gsi::GenericMethod *_create_f_style_c0 ()
{
  return new qt_gsi::GenericMethod (":style", "@brief Method QStyle *QGraphicsScene::style()\n", true, &_init_f_style_c0, &_call_f_style_c0);
}

// void QGraphicsScene::update(double x, double y, double w, double h)


static void _init_f_update_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_update_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QGraphicsScene *)cls)->update (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_update_3960 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsScene::update(double x, double y, double w, double h)\n", false, &_init_f_update_3960, &_call_f_update_3960);
}

// void QGraphicsScene::update(const QRectF &rect)


static void _init_f_update_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  ((QGraphicsScene *)cls)->update (arg1);
}

static qt_gsi::GenericMethod *_create_f_update_1862 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsScene::update(const QRectF &rect)\n", false, &_init_f_update_1862, &_call_f_update_1862);
}

// QList<QGraphicsView *> QGraphicsScene::views()


static void _init_f_views_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QGraphicsView *> >::target_type > ();
}

static void _call_f_views_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QGraphicsView *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsView *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsView *> >(((QGraphicsScene *)cls)->views ()));
}

static qt_gsi::GenericMethod *_create_f_views_c0 ()
{
  return new qt_gsi::GenericMethod ("views", "@brief Method QList<QGraphicsView *> QGraphicsScene::views()\n", true, &_init_f_views_c0, &_call_f_views_c0);
}

// double QGraphicsScene::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsScene *)cls)->width ());
}

static qt_gsi::GenericMethod *_create_f_width_c0 ()
{
  return new qt_gsi::GenericMethod ("width", "@brief Method double QGraphicsScene::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
}

// static QString QGraphicsScene::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsScene::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsScene::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QGraphicsScene::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsScene::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsScene::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QGraphicsScene::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsScene::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsScene::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QGraphicsScene::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsScene::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsScene::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QGraphicsScene, QGraphicsScene_EventAdaptor> ea_QGraphicsScene;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QGraphicsScene> decl_QGraphicsScene (ea_QGraphicsScene, decl_QObject, "QGraphicsScene_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_activePanel_c0 ()) +
  gsi::Methods(_create_f_activeWindow_c0 ()) +
  gsi::Methods(_create_f_addEllipse_5241 ()) +
  gsi::Methods(_create_f_addEllipse_7339 ()) +
  gsi::Methods(_create_f_addItem_1919 ()) +
  gsi::Methods(_create_f_addLine_3433 ()) +
  gsi::Methods(_create_f_addLine_5537 ()) +
  gsi::Methods(_create_f_addPath_5893 ()) +
  gsi::Methods(_create_f_addPixmap_2017 ()) +
  gsi::Methods(_create_f_addPolygon_5587 ()) +
  gsi::Methods(_create_f_addRect_5241 ()) +
  gsi::Methods(_create_f_addRect_7339 ()) +
  gsi::Methods(_create_f_addSimpleText_3718 ()) +
  gsi::Methods(_create_f_addText_3718 ()) +
  gsi::Methods(_create_f_addWidget_3702 ()) +
  gsi::Methods(_create_f_advance_0 ()) +
  gsi::Methods(_create_f_backgroundBrush_c0 ()) +
  gsi::Methods(_create_f_bspTreeDepth_c0 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_clearFocus_0 ()) +
  gsi::Methods(_create_f_clearSelection_0 ()) +
  gsi::Methods(_create_f_collidingItems_c4977 ()) +
  gsi::Methods(_create_f_createItemGroup_3411 ()) +
  gsi::Methods(_create_f_destroyItemGroup_2444 ()) +
  gsi::Methods(_create_f_focusItem_c0 ()) +
  gsi::Methods(_create_f_font_c0 ()) +
  gsi::Methods(_create_f_foregroundBrush_c0 ()) +
  gsi::Methods(_create_f_hasFocus_c0 ()) +
  gsi::Methods(_create_f_height_c0 ()) +
  gsi::Methods(_create_f_inputMethodQuery_c2420 ()) +
  gsi::Methods(_create_f_invalidate_7495 ()) +
  gsi::Methods(_create_f_invalidate_5397 ()) +
  gsi::Methods(_create_f_isActive_c0 ()) +
  gsi::Methods(_create_f_isSortCacheEnabled_c0 ()) +
  gsi::Methods(_create_f_itemAt_c1986 ()) +
  gsi::Methods(_create_f_itemAt_c4228 ()) +
  gsi::Methods(_create_f_itemAt_c2034 ()) +
  gsi::Methods(_create_f_itemAt_c4276 ()) +
  gsi::Methods(_create_f_itemIndexMethod_c0 ()) +
  gsi::Methods(_create_f_items_c0 ()) +
  gsi::Methods(_create_f_items_c1681 ()) +
  gsi::Methods(_create_f_items_c8164 ()) +
  gsi::Methods(_create_f_items_c8040 ()) +
  gsi::Methods(_create_f_items_c8386 ()) +
  gsi::Methods(_create_f_items_c8692 ()) +
  gsi::Methods(_create_f_items_c1986 ()) +
  gsi::Methods(_create_f_items_c4225 ()) +
  gsi::Methods(_create_f_items_c4571 ()) +
  gsi::Methods(_create_f_items_c4877 ()) +
  gsi::Methods(_create_f_items_c6323 ()) +
  gsi::Methods(_create_f_items_c10138 ()) +
  gsi::Methods(_create_f_itemsBoundingRect_c0 ()) +
  gsi::Methods(_create_f_mouseGrabberItem_c0 ()) +
  gsi::Methods(_create_f_palette_c0 ()) +
  gsi::Methods(_create_f_removeItem_1919 ()) +
  gsi::Methods(_create_f_render_7083 ()) +
  gsi::Methods(_create_f_sceneRect_c0 ()) +
  gsi::Methods(_create_f_selectedItems_c0 ()) +
  gsi::Methods(_create_f_selectionArea_c0 ()) +
  gsi::Methods(_create_f_sendEvent_3028 ()) +
  gsi::Methods(_create_f_setActivePanel_1919 ()) +
  gsi::Methods(_create_f_setActiveWindow_2132 ()) +
  gsi::Methods(_create_f_setBackgroundBrush_1910 ()) +
  gsi::Methods(_create_f_setBspTreeDepth_767 ()) +
  gsi::Methods(_create_f_setFocus_1877 ()) +
  gsi::Methods(_create_f_setFocusItem_3688 ()) +
  gsi::Methods(_create_f_setFont_1801 ()) +
  gsi::Methods(_create_f_setForegroundBrush_1910 ()) +
  gsi::Methods(_create_f_setItemIndexMethod_3456 ()) +
  gsi::Methods(_create_f_setPalette_2113 ()) +
  gsi::Methods(_create_f_setSceneRect_1862 ()) +
  gsi::Methods(_create_f_setSceneRect_3960 ()) +
  gsi::Methods(_create_f_setSelectionArea_2514 ()) +
  gsi::Methods(_create_f_setSelectionArea_4756 ()) +
  gsi::Methods(_create_f_setSelectionArea_4877 ()) +
  gsi::Methods(_create_f_setSelectionArea_7119 ()) +
  gsi::Methods(_create_f_setSortCacheEnabled_864 ()) +
  gsi::Methods(_create_f_setStickyFocus_864 ()) +
  gsi::Methods(_create_f_setStyle_1232 ()) +
  gsi::Methods(_create_f_stickyFocus_c0 ()) +
  gsi::Methods(_create_f_style_c0 ()) +
  gsi::Methods(_create_f_update_3960 ()) +
  gsi::Methods(_create_f_update_1862 ()) +
  gsi::Methods(_create_f_views_c0 ()) +
  gsi::Methods(_create_f_width_c0 ()) +
  qt_gsi::qt_signal<QGraphicsScene, QGraphicsScene_EventAdaptor, const qt_gsi::Converter<QList<QRectF> >::target_type &> ("changed", &QGraphicsScene_EventAdaptor::changed_e_2477, gsi::arg("region"), "@brief Signal declaration for QGraphicsScene::changed(const QList<QRectF> &region)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsScene, QGraphicsScene_EventAdaptor, QObject *> ("destroyed", &QGraphicsScene_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QGraphicsScene::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsScene, QGraphicsScene_EventAdaptor, const QRectF &> ("sceneRectChanged", &QGraphicsScene_EventAdaptor::sceneRectChanged_e_1862, gsi::arg("rect"), "@brief Signal declaration for QGraphicsScene::sceneRectChanged(const QRectF &rect)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsScene, QGraphicsScene_EventAdaptor> ("selectionChanged", &QGraphicsScene_EventAdaptor::selectionChanged_e_0, "@brief Signal declaration for QGraphicsScene::selectionChanged()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QGraphicsScene");
}


class QGraphicsScene_Adaptor : public QGraphicsScene, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsScene_Adaptor();

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(QObject *parent)
  QGraphicsScene_Adaptor() : QGraphicsScene()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(QObject *parent)
  QGraphicsScene_Adaptor(QObject *parent) : QGraphicsScene(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(const QRectF &sceneRect, QObject *parent)
  QGraphicsScene_Adaptor(const QRectF &sceneRect) : QGraphicsScene(sceneRect)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(const QRectF &sceneRect, QObject *parent)
  QGraphicsScene_Adaptor(const QRectF &sceneRect, QObject *parent) : QGraphicsScene(sceneRect, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(double x, double y, double width, double height, QObject *parent)
  QGraphicsScene_Adaptor(double x, double y, double width, double height) : QGraphicsScene(x, y, width, height)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsScene::QGraphicsScene(double x, double y, double width, double height, QObject *parent)
  QGraphicsScene_Adaptor(double x, double y, double width, double height, QObject *parent) : QGraphicsScene(x, y, width, height, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  bool QGraphicsScene::focusNextPrevChild(bool next)
  bool fp_QGraphicsScene_focusNextPrevChild_864 (bool next) {
    return QGraphicsScene::focusNextPrevChild(next);
  }

  //  int QGraphicsScene::receivers(const char *signal)
  int fp_QGraphicsScene_receivers_c1731 (const char *signal) const {
    return QGraphicsScene::receivers(signal);
  }

  //  QObject *QGraphicsScene::sender()
  QObject * fp_QGraphicsScene_sender_c0 () const {
    return QGraphicsScene::sender();
  }

  //  [adaptor impl] QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsScene::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsScene_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsScene_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsScene::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] void QGraphicsScene::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsScene::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsScene_Adaptor, QChildEvent *>(&QGraphicsScene_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsScene::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsScene::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QGraphicsScene::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneContextMenuEvent *>(&QGraphicsScene_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QGraphicsScene::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsScene::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsScene_Adaptor, QEvent *>(&QGraphicsScene_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsScene::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsScene::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsScene::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsScene_Adaptor, const char *>(&QGraphicsScene_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsScene::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsScene::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsScene::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsScene_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QGraphicsScene::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsScene::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsScene_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QGraphicsScene::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsScene::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsScene_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QGraphicsScene::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::drawBackground(QPainter *painter, const QRectF &rect)
  void cbs_drawBackground_3180_0(QPainter *painter, const QRectF &rect)
  {
    QGraphicsScene::drawBackground(painter, rect);
  }

  virtual void drawBackground(QPainter *painter, const QRectF &rect)
  {
    if (cb_drawBackground_3180_0.can_issue()) {
      cb_drawBackground_3180_0.issue<QGraphicsScene_Adaptor, QPainter *, const QRectF &>(&QGraphicsScene_Adaptor::cbs_drawBackground_3180_0, painter, rect);
    } else {
      QGraphicsScene::drawBackground(painter, rect);
    }
  }

  //  [adaptor impl] void QGraphicsScene::drawForeground(QPainter *painter, const QRectF &rect)
  void cbs_drawForeground_3180_0(QPainter *painter, const QRectF &rect)
  {
    QGraphicsScene::drawForeground(painter, rect);
  }

  virtual void drawForeground(QPainter *painter, const QRectF &rect)
  {
    if (cb_drawForeground_3180_0.can_issue()) {
      cb_drawForeground_3180_0.issue<QGraphicsScene_Adaptor, QPainter *, const QRectF &>(&QGraphicsScene_Adaptor::cbs_drawForeground_3180_0, painter, rect);
    } else {
      QGraphicsScene::drawForeground(painter, rect);
    }
  }

  //  [adaptor impl] void QGraphicsScene::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsScene::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsScene_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QGraphicsScene::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsScene::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsScene::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsScene_Adaptor, bool, QEvent *>(&QGraphicsScene_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsScene::event(_event);
    }
  }

  //  [adaptor impl] bool QGraphicsScene::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGraphicsScene::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsScene_Adaptor, bool, QObject *, QEvent *>(&QGraphicsScene_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGraphicsScene::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsScene::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsScene_Adaptor, QFocusEvent *>(&QGraphicsScene_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsScene::focusInEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsScene::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsScene_Adaptor, QFocusEvent *>(&QGraphicsScene_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsScene::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::helpEvent(QGraphicsSceneHelpEvent *event)
  void cbs_helpEvent_2921_0(QGraphicsSceneHelpEvent *event)
  {
    QGraphicsScene::helpEvent(event);
  }

  virtual void helpEvent(QGraphicsSceneHelpEvent *event)
  {
    if (cb_helpEvent_2921_0.can_issue()) {
      cb_helpEvent_2921_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneHelpEvent *>(&QGraphicsScene_Adaptor::cbs_helpEvent_2921_0, event);
    } else {
      QGraphicsScene::helpEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsScene::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsScene_Adaptor, QInputMethodEvent *>(&QGraphicsScene_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsScene::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsScene::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsScene_Adaptor, QKeyEvent *>(&QGraphicsScene_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsScene::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsScene::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsScene_Adaptor, QKeyEvent *>(&QGraphicsScene_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsScene::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsScene::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsScene_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QGraphicsScene::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsScene::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsScene_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QGraphicsScene::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsScene::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsScene_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QGraphicsScene::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsScene::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsScene_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QGraphicsScene::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsScene::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsScene::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsScene_Adaptor, QTimerEvent *>(&QGraphicsScene_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsScene::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsScene::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QGraphicsScene::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QGraphicsScene_Adaptor, QGraphicsSceneWheelEvent *>(&QGraphicsScene_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QGraphicsScene::wheelEvent(event);
    }
  }

  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_drawBackground_3180_0;
  gsi::Callback cb_drawForeground_3180_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_helpEvent_2921_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_3029_0;
};

QGraphicsScene_Adaptor::~QGraphicsScene_Adaptor() { }

//  Constructor QGraphicsScene::QGraphicsScene(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsScene_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsScene_Adaptor *> ();
}

static void _call_ctor_QGraphicsScene_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QGraphicsScene_Adaptor *> (new QGraphicsScene_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsScene_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsScene::QGraphicsScene(QObject *parent)\nThis method creates an object of class QGraphicsScene.", &_init_ctor_QGraphicsScene_Adaptor_1302, &_call_ctor_QGraphicsScene_Adaptor_1302);
}

//  Constructor QGraphicsScene::QGraphicsScene(const QRectF &sceneRect, QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsScene_Adaptor_3056 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sceneRect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QGraphicsScene_Adaptor *> ();
}

static void _call_ctor_QGraphicsScene_Adaptor_3056 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  QObject *arg2 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QGraphicsScene_Adaptor *> (new QGraphicsScene_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsScene_Adaptor_3056 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsScene::QGraphicsScene(const QRectF &sceneRect, QObject *parent)\nThis method creates an object of class QGraphicsScene.", &_init_ctor_QGraphicsScene_Adaptor_3056, &_call_ctor_QGraphicsScene_Adaptor_3056);
}

//  Constructor QGraphicsScene::QGraphicsScene(double x, double y, double width, double height, QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsScene_Adaptor_5154 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("width");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("height");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_4);
  decl->set_return_new<QGraphicsScene_Adaptor *> ();
}

static void _call_ctor_QGraphicsScene_Adaptor_5154 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  QObject *arg5 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QGraphicsScene_Adaptor *> (new QGraphicsScene_Adaptor (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsScene_Adaptor_5154 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsScene::QGraphicsScene(double x, double y, double width, double height, QObject *parent)\nThis method creates an object of class QGraphicsScene.", &_init_ctor_QGraphicsScene_Adaptor_5154, &_call_ctor_QGraphicsScene_Adaptor_5154);
}

// bool QGraphicsScene::focusNextPrevChild(bool next)

static void _init_fp_focusNextPrevChild_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_focusNextPrevChild_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QGraphicsScene_Adaptor *)cls)->fp_QGraphicsScene_focusNextPrevChild_864 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_focusNextPrevChild_864 ()
{
  return new qt_gsi::GenericMethod("*focusNextPrevChild", "@brief Method bool QGraphicsScene::focusNextPrevChild(bool next)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextPrevChild_864, &_call_fp_focusNextPrevChild_864);
}


// int QGraphicsScene::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QGraphicsScene_Adaptor *)cls)->fp_QGraphicsScene_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QGraphicsScene::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QGraphicsScene::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QGraphicsScene_Adaptor *)cls)->fp_QGraphicsScene_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QGraphicsScene::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsScene_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// void QGraphicsScene::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsScene::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QGraphicsScene::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsScene::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
}


// void QGraphicsScene::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsScene::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QGraphicsScene::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsScene::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QGraphicsScene::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsScene::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
}


// void QGraphicsScene::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsScene::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
}


// void QGraphicsScene::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsScene::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
}


// void QGraphicsScene::drawBackground(QPainter *painter, const QRectF &rect)

static void _init_cbs_drawBackground_3180_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawBackground_3180_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_drawBackground_3180_0 (arg1, arg2);
}

static void _set_callback_cbs_drawBackground_3180_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_drawBackground_3180_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawBackground_3180_0 ()
{
  return new qt_gsi::GenericMethod ("*drawBackground", "@hide", false, &_init_cbs_drawBackground_3180_0, &_call_cbs_drawBackground_3180_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawBackground_3180_0 ()
{
  return new qt_gsi::GenericMethod ("*drawBackground", "@brief Virtual method void QGraphicsScene::drawBackground(QPainter *painter, const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawBackground_3180_0, &_call_cbs_drawBackground_3180_0, &_set_callback_cbs_drawBackground_3180_0);
}


// void QGraphicsScene::drawForeground(QPainter *painter, const QRectF &rect)

static void _init_cbs_drawForeground_3180_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawForeground_3180_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_drawForeground_3180_0 (arg1, arg2);
}

static void _set_callback_cbs_drawForeground_3180_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_drawForeground_3180_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawForeground_3180_0 ()
{
  return new qt_gsi::GenericMethod ("*drawForeground", "@hide", false, &_init_cbs_drawForeground_3180_0, &_call_cbs_drawForeground_3180_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawForeground_3180_0 ()
{
  return new qt_gsi::GenericMethod ("*drawForeground", "@brief Virtual method void QGraphicsScene::drawForeground(QPainter *painter, const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawForeground_3180_0, &_call_cbs_drawForeground_3180_0, &_set_callback_cbs_drawForeground_3180_0);
}


// void QGraphicsScene::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsScene::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
}


// bool QGraphicsScene::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsScene_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QGraphicsScene::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QGraphicsScene::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsScene_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QGraphicsScene::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QGraphicsScene::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsScene::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// void QGraphicsScene::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsScene::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QGraphicsScene::helpEvent(QGraphicsSceneHelpEvent *event)

static void _init_cbs_helpEvent_2921_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHelpEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_helpEvent_2921_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHelpEvent *arg1 = args.read<QGraphicsSceneHelpEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_helpEvent_2921_0 (arg1);
}

static void _set_callback_cbs_helpEvent_2921_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_helpEvent_2921_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_helpEvent_2921_0 ()
{
  return new qt_gsi::GenericMethod ("*helpEvent", "@hide", false, &_init_cbs_helpEvent_2921_0, &_call_cbs_helpEvent_2921_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_helpEvent_2921_0 ()
{
  return new qt_gsi::GenericMethod ("*helpEvent", "@brief Virtual method void QGraphicsScene::helpEvent(QGraphicsSceneHelpEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_helpEvent_2921_0, &_call_cbs_helpEvent_2921_0, &_set_callback_cbs_helpEvent_2921_0);
}


// void QGraphicsScene::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsScene::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QGraphicsScene::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsScene::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QGraphicsScene::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsScene::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QGraphicsScene::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsScene::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
}


// void QGraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
}


// void QGraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
}


// void QGraphicsScene::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsScene::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
}


// void QGraphicsScene::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsScene::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QGraphicsScene::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > ();
  ((QGraphicsScene_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsScene_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsScene::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsScene> decl_QGraphicsScene;

gsi::Class<QGraphicsScene_Adaptor> decl_QGraphicsScene_Adaptor (decl_QGraphicsScene, "QGraphicsScene",
  gsi::Methods(_create_fp_focusNextPrevChild_864 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_drawBackground_3180_0 ()) +
  gsi::Methods(_create_callback_cbs_drawBackground_3180_0 ()) +
  gsi::Methods(_create_cbs_drawForeground_3180_0 ()) +
  gsi::Methods(_create_callback_cbs_drawForeground_3180_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_helpEvent_2921_0 ()) +
  gsi::Methods(_create_callback_cbs_helpEvent_2921_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsScene_Adaptor_1302 ()) +
  gsi::Methods(_create_ctor_QGraphicsScene_Adaptor_3056 ()) +
  gsi::Methods(_create_ctor_QGraphicsScene_Adaptor_5154 ()),
  "@qt\n@brief Binding of QGraphicsScene");

}


//  Implementation of the enum wrapper class for QGraphicsScene::ItemIndexMethod
namespace qt_gsi
{

static QGraphicsScene_ItemIndexMethod_Enum *c_1_QGraphicsScene_ItemIndexMethod_Enum () { return new QGraphicsScene_ItemIndexMethod_Enum (QGraphicsScene::BspTreeIndex); }
static QGraphicsScene_ItemIndexMethod_Enum *c_2_QGraphicsScene_ItemIndexMethod_Enum () { return new QGraphicsScene_ItemIndexMethod_Enum (QGraphicsScene::NoIndex); }

static gsi::Methods mkdefs_QGraphicsScene_ItemIndexMethod () {
  return
    gsi::constant ("BspTreeIndex", &qt_gsi::c_1_QGraphicsScene_ItemIndexMethod_Enum, "@brief Enum constant QGraphicsScene::BspTreeIndex") +
    gsi::constant ("NoIndex", &qt_gsi::c_2_QGraphicsScene_ItemIndexMethod_Enum, "@brief Enum constant QGraphicsScene::NoIndex");
}

static std::string to_s_QGraphicsScene_ItemIndexMethod_Enum (const QGraphicsScene_ItemIndexMethod_Enum *e)
{
  if (e->value () == QGraphicsScene::BspTreeIndex) { return tl::sprintf ("BspTreeIndex (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsScene::NoIndex) { return tl::sprintf ("NoIndex (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsScene_ItemIndexMethod_Enum (const QGraphicsScene_ItemIndexMethod_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsScene_ItemIndexMethod_Enum *from_i_QGraphicsScene_ItemIndexMethod_Enum (unsigned int i)
{
  return new QGraphicsScene_ItemIndexMethod_Enum ((QGraphicsScene::ItemIndexMethod) i);
}

static bool equalQGraphicsScene_ItemIndexMethod_Enum (const QGraphicsScene_ItemIndexMethod_Enum *e, QGraphicsScene_ItemIndexMethod_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsScene_ItemIndexMethod_Enum (const QGraphicsScene_ItemIndexMethod_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsScene_ItemIndexMethod_Enums oropQGraphicsScene_ItemIndexMethod_Enums (const QGraphicsScene_ItemIndexMethod_Enums *e, const QGraphicsScene_ItemIndexMethod_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsScene_ItemIndexMethod_Enums andopQGraphicsScene_ItemIndexMethod_Enums (const QGraphicsScene_ItemIndexMethod_Enums *e, const QGraphicsScene_ItemIndexMethod_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsScene_ItemIndexMethod_Enums xoropQGraphicsScene_ItemIndexMethod_Enums (const QGraphicsScene_ItemIndexMethod_Enums *e, const QGraphicsScene_ItemIndexMethod_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsScene_ItemIndexMethod_Enums (const QGraphicsScene_ItemIndexMethod_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsScene::BspTreeIndex)) { if (!l.empty ()) l += "|"; l += "BspTreeIndex"; }
  if (e->testFlag (QGraphicsScene::NoIndex)) { if (!l.empty ()) l += "|"; l += "NoIndex"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsScene_ItemIndexMethod_Enums (const QGraphicsScene_ItemIndexMethod_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsScene_ItemIndexMethod_Enums (const QGraphicsScene_ItemIndexMethod_Enums *e, const QGraphicsScene_ItemIndexMethod_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsScene_ItemIndexMethod_Enums> decl_QGraphicsScene_ItemIndexMethod_Enums ("QGraphicsScene_QFlags_ItemIndexMethod",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsScene_ItemIndexMethod_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsScene_ItemIndexMethod_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsScene_ItemIndexMethod_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsScene_ItemIndexMethod_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsScene_ItemIndexMethod_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsScene_ItemIndexMethod_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsScene::ItemIndexMethod> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsScene_ItemIndexMethod_Enum> decl_QGraphicsScene_ItemIndexMethod_Enum (decl_QGraphicsScene_ItemIndexMethod_Enums, "QGraphicsScene_ItemIndexMethod",
  qt_gsi::mkdefs_QGraphicsScene_ItemIndexMethod () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsScene_ItemIndexMethod_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsScene_ItemIndexMethod_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsScene_ItemIndexMethod_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsScene_ItemIndexMethod_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsScene_ItemIndexMethod_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsScene::ItemIndexMethod enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsScene> inject_QGraphicsScene_ItemIndexMethod_Enum_in_parent (qt_gsi::mkdefs_QGraphicsScene_ItemIndexMethod ());
static gsi::ClassExt<QGraphicsScene> decl_QGraphicsScene_ItemIndexMethod_Enum_as_child (decl_QGraphicsScene_ItemIndexMethod_Enum, "ItemIndexMethod");

}


//  Implementation of the enum wrapper class for QGraphicsScene::SceneLayer
namespace qt_gsi
{

static QGraphicsScene_SceneLayer_Enum *c_1_QGraphicsScene_SceneLayer_Enum () { return new QGraphicsScene_SceneLayer_Enum (QGraphicsScene::ItemLayer); }
static QGraphicsScene_SceneLayer_Enum *c_2_QGraphicsScene_SceneLayer_Enum () { return new QGraphicsScene_SceneLayer_Enum (QGraphicsScene::BackgroundLayer); }
static QGraphicsScene_SceneLayer_Enum *c_3_QGraphicsScene_SceneLayer_Enum () { return new QGraphicsScene_SceneLayer_Enum (QGraphicsScene::ForegroundLayer); }
static QGraphicsScene_SceneLayer_Enum *c_4_QGraphicsScene_SceneLayer_Enum () { return new QGraphicsScene_SceneLayer_Enum (QGraphicsScene::AllLayers); }

static gsi::Methods mkdefs_QGraphicsScene_SceneLayer () {
  return
    gsi::constant ("ItemLayer", &qt_gsi::c_1_QGraphicsScene_SceneLayer_Enum, "@brief Enum constant QGraphicsScene::ItemLayer") +
    gsi::constant ("BackgroundLayer", &qt_gsi::c_2_QGraphicsScene_SceneLayer_Enum, "@brief Enum constant QGraphicsScene::BackgroundLayer") +
    gsi::constant ("ForegroundLayer", &qt_gsi::c_3_QGraphicsScene_SceneLayer_Enum, "@brief Enum constant QGraphicsScene::ForegroundLayer") +
    gsi::constant ("AllLayers", &qt_gsi::c_4_QGraphicsScene_SceneLayer_Enum, "@brief Enum constant QGraphicsScene::AllLayers");
}

static std::string to_s_QGraphicsScene_SceneLayer_Enum (const QGraphicsScene_SceneLayer_Enum *e)
{
  if (e->value () == QGraphicsScene::ItemLayer) { return tl::sprintf ("ItemLayer (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsScene::BackgroundLayer) { return tl::sprintf ("BackgroundLayer (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsScene::ForegroundLayer) { return tl::sprintf ("ForegroundLayer (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsScene::AllLayers) { return tl::sprintf ("AllLayers (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsScene_SceneLayer_Enum (const QGraphicsScene_SceneLayer_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsScene_SceneLayer_Enum *from_i_QGraphicsScene_SceneLayer_Enum (unsigned int i)
{
  return new QGraphicsScene_SceneLayer_Enum ((QGraphicsScene::SceneLayer) i);
}

static bool equalQGraphicsScene_SceneLayer_Enum (const QGraphicsScene_SceneLayer_Enum *e, QGraphicsScene_SceneLayer_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsScene_SceneLayer_Enum (const QGraphicsScene_SceneLayer_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsScene_SceneLayer_Enums oropQGraphicsScene_SceneLayer_Enums (const QGraphicsScene_SceneLayer_Enums *e, const QGraphicsScene_SceneLayer_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsScene_SceneLayer_Enums andopQGraphicsScene_SceneLayer_Enums (const QGraphicsScene_SceneLayer_Enums *e, const QGraphicsScene_SceneLayer_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsScene_SceneLayer_Enums xoropQGraphicsScene_SceneLayer_Enums (const QGraphicsScene_SceneLayer_Enums *e, const QGraphicsScene_SceneLayer_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsScene_SceneLayer_Enums (const QGraphicsScene_SceneLayer_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsScene::ItemLayer)) { if (!l.empty ()) l += "|"; l += "ItemLayer"; }
  if (e->testFlag (QGraphicsScene::BackgroundLayer)) { if (!l.empty ()) l += "|"; l += "BackgroundLayer"; }
  if (e->testFlag (QGraphicsScene::ForegroundLayer)) { if (!l.empty ()) l += "|"; l += "ForegroundLayer"; }
  if (e->testFlag (QGraphicsScene::AllLayers)) { if (!l.empty ()) l += "|"; l += "AllLayers"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsScene_SceneLayer_Enums (const QGraphicsScene_SceneLayer_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsScene_SceneLayer_Enums (const QGraphicsScene_SceneLayer_Enums *e, const QGraphicsScene_SceneLayer_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsScene_SceneLayer_Enums> decl_QGraphicsScene_SceneLayer_Enums ("QGraphicsScene_QFlags_SceneLayer",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsScene_SceneLayer_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsScene_SceneLayer_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsScene_SceneLayer_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsScene_SceneLayer_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsScene_SceneLayer_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsScene_SceneLayer_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsScene::SceneLayer> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsScene_SceneLayer_Enum> decl_QGraphicsScene_SceneLayer_Enum (decl_QGraphicsScene_SceneLayer_Enums, "QGraphicsScene_SceneLayer",
  qt_gsi::mkdefs_QGraphicsScene_SceneLayer () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsScene_SceneLayer_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsScene_SceneLayer_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsScene_SceneLayer_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsScene_SceneLayer_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsScene_SceneLayer_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsScene::SceneLayer enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsScene> inject_QGraphicsScene_SceneLayer_Enum_in_parent (qt_gsi::mkdefs_QGraphicsScene_SceneLayer ());
static gsi::ClassExt<QGraphicsScene> decl_QGraphicsScene_SceneLayer_Enum_as_child (decl_QGraphicsScene_SceneLayer_Enum, "SceneLayer");

}

