
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsItemAnimation.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QtCore/QTimeLine>
#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsItemAnimation_EventAdaptor.h"
#include "gsiDeclQGraphicsItemAnimation_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsItemAnimation

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsItemAnimation::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QGraphicsItemAnimation::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItemAnimation *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QGraphicsItemAnimation::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// double QGraphicsItemAnimation::horizontalScaleAt(double step)


static void _init_f_horizontalScaleAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_horizontalScaleAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->horizontalScaleAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_horizontalScaleAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("horizontalScaleAt", "@brief Method double QGraphicsItemAnimation::horizontalScaleAt(double step)\n", true, &_init_f_horizontalScaleAt_c1071, &_call_f_horizontalScaleAt_c1071);
}

// double QGraphicsItemAnimation::horizontalShearAt(double step)


static void _init_f_horizontalShearAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_horizontalShearAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->horizontalShearAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_horizontalShearAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("horizontalShearAt", "@brief Method double QGraphicsItemAnimation::horizontalShearAt(double step)\n", true, &_init_f_horizontalShearAt_c1071, &_call_f_horizontalShearAt_c1071);
}

// QGraphicsItem *QGraphicsItemAnimation::item()


static void _init_f_item_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_item_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItemAnimation *)cls)->item ());
}

static qt_gsi::GenericMethod *_create_f_item_c0 ()
{
  return new qt_gsi::GenericMethod (":item", "@brief Method QGraphicsItem *QGraphicsItemAnimation::item()\n", true, &_init_f_item_c0, &_call_f_item_c0);
}

// QMatrix QGraphicsItemAnimation::matrixAt(double step)


static void _init_f_matrixAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QMatrix > ();
}

static void _call_f_matrixAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QMatrix > ((QMatrix)((QGraphicsItemAnimation *)cls)->matrixAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_matrixAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("matrixAt", "@brief Method QMatrix QGraphicsItemAnimation::matrixAt(double step)\n", true, &_init_f_matrixAt_c1071, &_call_f_matrixAt_c1071);
}

// QPointF QGraphicsItemAnimation::posAt(double step)


static void _init_f_posAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_posAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<QPointF > ((QPointF)((QGraphicsItemAnimation *)cls)->posAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_posAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("posAt", "@brief Method QPointF QGraphicsItemAnimation::posAt(double step)\n", true, &_init_f_posAt_c1071, &_call_f_posAt_c1071);
}

// QList<QPair<double, QPointF> > QGraphicsItemAnimation::posList()


static void _init_f_posList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type > ();
}

static void _call_f_posList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type > ((qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type)qt_gsi::CppToQtAdaptor<QList<QPair<double, QPointF> > >(((QGraphicsItemAnimation *)cls)->posList ()));
}

static qt_gsi::GenericMethod *_create_f_posList_c0 ()
{
  return new qt_gsi::GenericMethod ("posList", "@brief Method QList<QPair<double, QPointF> > QGraphicsItemAnimation::posList()\n", true, &_init_f_posList_c0, &_call_f_posList_c0);
}

// void QGraphicsItemAnimation::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsItemAnimation *)cls)->reset ();
}

static qt_gsi::GenericMethod *_create_f_reset_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Method void QGraphicsItemAnimation::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
}

// double QGraphicsItemAnimation::rotationAt(double step)


static void _init_f_rotationAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_rotationAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->rotationAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_rotationAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("rotationAt", "@brief Method double QGraphicsItemAnimation::rotationAt(double step)\n", true, &_init_f_rotationAt_c1071, &_call_f_rotationAt_c1071);
}

// QList<QPair<double, double> > QGraphicsItemAnimation::rotationList()


static void _init_f_rotationList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QPair<double, double> > >::target_type > ();
}

static void _call_f_rotationList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QPair<double, double> > >::target_type > ((qt_gsi::Converter<QList<QPair<double, double> > >::target_type)qt_gsi::CppToQtAdaptor<QList<QPair<double, double> > >(((QGraphicsItemAnimation *)cls)->rotationList ()));
}

static qt_gsi::GenericMethod *_create_f_rotationList_c0 ()
{
  return new qt_gsi::GenericMethod ("rotationList", "@brief Method QList<QPair<double, double> > QGraphicsItemAnimation::rotationList()\n", true, &_init_f_rotationList_c0, &_call_f_rotationList_c0);
}

// QList<QPair<double, QPointF> > QGraphicsItemAnimation::scaleList()


static void _init_f_scaleList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type > ();
}

static void _call_f_scaleList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type > ((qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type)qt_gsi::CppToQtAdaptor<QList<QPair<double, QPointF> > >(((QGraphicsItemAnimation *)cls)->scaleList ()));
}

static qt_gsi::GenericMethod *_create_f_scaleList_c0 ()
{
  return new qt_gsi::GenericMethod ("scaleList", "@brief Method QList<QPair<double, QPointF> > QGraphicsItemAnimation::scaleList()\n", true, &_init_f_scaleList_c0, &_call_f_scaleList_c0);
}

// void QGraphicsItemAnimation::setItem(QGraphicsItem *item)


static void _init_f_setItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItem_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  ((QGraphicsItemAnimation *)cls)->setItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_setItem_1919 ()
{
  return new qt_gsi::GenericMethod ("setItem|item=", "@brief Method void QGraphicsItemAnimation::setItem(QGraphicsItem *item)\n", false, &_init_f_setItem_1919, &_call_f_setItem_1919);
}

// void QGraphicsItemAnimation::setPosAt(double step, const QPointF &pos)


static void _init_f_setPosAt_2949 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pos");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPosAt_2949 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  ((QGraphicsItemAnimation *)cls)->setPosAt (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setPosAt_2949 ()
{
  return new qt_gsi::GenericMethod ("setPosAt", "@brief Method void QGraphicsItemAnimation::setPosAt(double step, const QPointF &pos)\n", false, &_init_f_setPosAt_2949, &_call_f_setPosAt_2949);
}

// void QGraphicsItemAnimation::setRotationAt(double step, double angle)


static void _init_f_setRotationAt_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("angle");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRotationAt_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsItemAnimation *)cls)->setRotationAt (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setRotationAt_2034 ()
{
  return new qt_gsi::GenericMethod ("setRotationAt", "@brief Method void QGraphicsItemAnimation::setRotationAt(double step, double angle)\n", false, &_init_f_setRotationAt_2034, &_call_f_setRotationAt_2034);
}

// void QGraphicsItemAnimation::setScaleAt(double step, double sx, double sy)


static void _init_f_setScaleAt_2997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sx");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sy");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setScaleAt_2997 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ((QGraphicsItemAnimation *)cls)->setScaleAt (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setScaleAt_2997 ()
{
  return new qt_gsi::GenericMethod ("setScaleAt", "@brief Method void QGraphicsItemAnimation::setScaleAt(double step, double sx, double sy)\n", false, &_init_f_setScaleAt_2997, &_call_f_setScaleAt_2997);
}

// void QGraphicsItemAnimation::setShearAt(double step, double sh, double sv)


static void _init_f_setShearAt_2997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sh");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sv");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setShearAt_2997 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ((QGraphicsItemAnimation *)cls)->setShearAt (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setShearAt_2997 ()
{
  return new qt_gsi::GenericMethod ("setShearAt", "@brief Method void QGraphicsItemAnimation::setShearAt(double step, double sh, double sv)\n", false, &_init_f_setShearAt_2997, &_call_f_setShearAt_2997);
}

// void QGraphicsItemAnimation::setStep(double x)


static void _init_f_setStep_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStep_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItemAnimation *)cls)->setStep (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStep_1071 ()
{
  return new qt_gsi::GenericMethod ("setStep", "@brief Method void QGraphicsItemAnimation::setStep(double x)\n", false, &_init_f_setStep_1071, &_call_f_setStep_1071);
}

// void QGraphicsItemAnimation::setTimeLine(QTimeLine *timeLine)


static void _init_f_setTimeLine_1494 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timeLine");
  decl->add_arg<QTimeLine * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTimeLine_1494 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimeLine *arg1 = args.read<QTimeLine * > ();
  ((QGraphicsItemAnimation *)cls)->setTimeLine (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTimeLine_1494 ()
{
  return new qt_gsi::GenericMethod ("setTimeLine|timeLine=", "@brief Method void QGraphicsItemAnimation::setTimeLine(QTimeLine *timeLine)\n", false, &_init_f_setTimeLine_1494, &_call_f_setTimeLine_1494);
}

// void QGraphicsItemAnimation::setTranslationAt(double step, double dx, double dy)


static void _init_f_setTranslationAt_2997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dx");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dy");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setTranslationAt_2997 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  ((QGraphicsItemAnimation *)cls)->setTranslationAt (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setTranslationAt_2997 ()
{
  return new qt_gsi::GenericMethod ("setTranslationAt", "@brief Method void QGraphicsItemAnimation::setTranslationAt(double step, double dx, double dy)\n", false, &_init_f_setTranslationAt_2997, &_call_f_setTranslationAt_2997);
}

// QList<QPair<double, QPointF> > QGraphicsItemAnimation::shearList()


static void _init_f_shearList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type > ();
}

static void _call_f_shearList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type > ((qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type)qt_gsi::CppToQtAdaptor<QList<QPair<double, QPointF> > >(((QGraphicsItemAnimation *)cls)->shearList ()));
}

static qt_gsi::GenericMethod *_create_f_shearList_c0 ()
{
  return new qt_gsi::GenericMethod ("shearList", "@brief Method QList<QPair<double, QPointF> > QGraphicsItemAnimation::shearList()\n", true, &_init_f_shearList_c0, &_call_f_shearList_c0);
}

// QTimeLine *QGraphicsItemAnimation::timeLine()


static void _init_f_timeLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTimeLine * > ();
}

static void _call_f_timeLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTimeLine * > ((QTimeLine *)((QGraphicsItemAnimation *)cls)->timeLine ());
}

static qt_gsi::GenericMethod *_create_f_timeLine_c0 ()
{
  return new qt_gsi::GenericMethod (":timeLine", "@brief Method QTimeLine *QGraphicsItemAnimation::timeLine()\n", true, &_init_f_timeLine_c0, &_call_f_timeLine_c0);
}

// QList<QPair<double, QPointF> > QGraphicsItemAnimation::translationList()


static void _init_f_translationList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type > ();
}

static void _call_f_translationList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type > ((qt_gsi::Converter<QList<QPair<double, QPointF> > >::target_type)qt_gsi::CppToQtAdaptor<QList<QPair<double, QPointF> > >(((QGraphicsItemAnimation *)cls)->translationList ()));
}

static qt_gsi::GenericMethod *_create_f_translationList_c0 ()
{
  return new qt_gsi::GenericMethod ("translationList", "@brief Method QList<QPair<double, QPointF> > QGraphicsItemAnimation::translationList()\n", true, &_init_f_translationList_c0, &_call_f_translationList_c0);
}

// double QGraphicsItemAnimation::verticalScaleAt(double step)


static void _init_f_verticalScaleAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_verticalScaleAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->verticalScaleAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_verticalScaleAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("verticalScaleAt", "@brief Method double QGraphicsItemAnimation::verticalScaleAt(double step)\n", true, &_init_f_verticalScaleAt_c1071, &_call_f_verticalScaleAt_c1071);
}

// double QGraphicsItemAnimation::verticalShearAt(double step)


static void _init_f_verticalShearAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_verticalShearAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->verticalShearAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_verticalShearAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("verticalShearAt", "@brief Method double QGraphicsItemAnimation::verticalShearAt(double step)\n", true, &_init_f_verticalShearAt_c1071, &_call_f_verticalShearAt_c1071);
}

// double QGraphicsItemAnimation::xTranslationAt(double step)


static void _init_f_xTranslationAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_xTranslationAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->xTranslationAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_xTranslationAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("xTranslationAt", "@brief Method double QGraphicsItemAnimation::xTranslationAt(double step)\n", true, &_init_f_xTranslationAt_c1071, &_call_f_xTranslationAt_c1071);
}

// double QGraphicsItemAnimation::yTranslationAt(double step)


static void _init_f_yTranslationAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_yTranslationAt_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QGraphicsItemAnimation *)cls)->yTranslationAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_yTranslationAt_c1071 ()
{
  return new qt_gsi::GenericMethod ("yTranslationAt", "@brief Method double QGraphicsItemAnimation::yTranslationAt(double step)\n", true, &_init_f_yTranslationAt_c1071, &_call_f_yTranslationAt_c1071);
}

// static QString QGraphicsItemAnimation::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsItemAnimation::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsItemAnimation::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QGraphicsItemAnimation::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsItemAnimation::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsItemAnimation::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QGraphicsItemAnimation::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsItemAnimation::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsItemAnimation::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QGraphicsItemAnimation::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsItemAnimation::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsItemAnimation::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QGraphicsItemAnimation, QGraphicsItemAnimation_EventAdaptor> ea_QGraphicsItemAnimation;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QGraphicsItemAnimation> decl_QGraphicsItemAnimation (ea_QGraphicsItemAnimation, decl_QObject, "QGraphicsItemAnimation_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_horizontalScaleAt_c1071 ()) +
  gsi::Methods(_create_f_horizontalShearAt_c1071 ()) +
  gsi::Methods(_create_f_item_c0 ()) +
  gsi::Methods(_create_f_matrixAt_c1071 ()) +
  gsi::Methods(_create_f_posAt_c1071 ()) +
  gsi::Methods(_create_f_posList_c0 ()) +
  gsi::Methods(_create_f_reset_0 ()) +
  gsi::Methods(_create_f_rotationAt_c1071 ()) +
  gsi::Methods(_create_f_rotationList_c0 ()) +
  gsi::Methods(_create_f_scaleList_c0 ()) +
  gsi::Methods(_create_f_setItem_1919 ()) +
  gsi::Methods(_create_f_setPosAt_2949 ()) +
  gsi::Methods(_create_f_setRotationAt_2034 ()) +
  gsi::Methods(_create_f_setScaleAt_2997 ()) +
  gsi::Methods(_create_f_setShearAt_2997 ()) +
  gsi::Methods(_create_f_setStep_1071 ()) +
  gsi::Methods(_create_f_setTimeLine_1494 ()) +
  gsi::Methods(_create_f_setTranslationAt_2997 ()) +
  gsi::Methods(_create_f_shearList_c0 ()) +
  gsi::Methods(_create_f_timeLine_c0 ()) +
  gsi::Methods(_create_f_translationList_c0 ()) +
  gsi::Methods(_create_f_verticalScaleAt_c1071 ()) +
  gsi::Methods(_create_f_verticalShearAt_c1071 ()) +
  gsi::Methods(_create_f_xTranslationAt_c1071 ()) +
  gsi::Methods(_create_f_yTranslationAt_c1071 ()) +
  qt_gsi::qt_signal<QGraphicsItemAnimation, QGraphicsItemAnimation_EventAdaptor, QObject *> ("destroyed", &QGraphicsItemAnimation_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QGraphicsItemAnimation::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QGraphicsItemAnimation");
}


class QGraphicsItemAnimation_Adaptor : public QGraphicsItemAnimation, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsItemAnimation_Adaptor();

  //  [adaptor ctor] QGraphicsItemAnimation::QGraphicsItemAnimation(QObject *parent)
  QGraphicsItemAnimation_Adaptor() : QGraphicsItemAnimation()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsItemAnimation::QGraphicsItemAnimation(QObject *parent)
  QGraphicsItemAnimation_Adaptor(QObject *parent) : QGraphicsItemAnimation(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QGraphicsItemAnimation::receivers(const char *signal)
  int fp_QGraphicsItemAnimation_receivers_c1731 (const char *signal) const {
    return QGraphicsItemAnimation::receivers(signal);
  }

  //  QObject *QGraphicsItemAnimation::sender()
  QObject * fp_QGraphicsItemAnimation_sender_c0 () const {
    return QGraphicsItemAnimation::sender();
  }

  //  [adaptor impl] bool QGraphicsItemAnimation::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QGraphicsItemAnimation::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsItemAnimation_Adaptor, bool, QEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QGraphicsItemAnimation::event(arg1);
    }
  }

  //  [adaptor impl] bool QGraphicsItemAnimation::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGraphicsItemAnimation::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsItemAnimation_Adaptor, bool, QObject *, QEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGraphicsItemAnimation::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::afterAnimationStep(double step)
  void cbs_afterAnimationStep_1071_0(double step)
  {
    QGraphicsItemAnimation::afterAnimationStep(step);
  }

  virtual void afterAnimationStep(double step)
  {
    if (cb_afterAnimationStep_1071_0.can_issue()) {
      cb_afterAnimationStep_1071_0.issue<QGraphicsItemAnimation_Adaptor, double>(&QGraphicsItemAnimation_Adaptor::cbs_afterAnimationStep_1071_0, step);
    } else {
      QGraphicsItemAnimation::afterAnimationStep(step);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::beforeAnimationStep(double step)
  void cbs_beforeAnimationStep_1071_0(double step)
  {
    QGraphicsItemAnimation::beforeAnimationStep(step);
  }

  virtual void beforeAnimationStep(double step)
  {
    if (cb_beforeAnimationStep_1071_0.can_issue()) {
      cb_beforeAnimationStep_1071_0.issue<QGraphicsItemAnimation_Adaptor, double>(&QGraphicsItemAnimation_Adaptor::cbs_beforeAnimationStep_1071_0, step);
    } else {
      QGraphicsItemAnimation::beforeAnimationStep(step);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsItemAnimation::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsItemAnimation_Adaptor, QChildEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsItemAnimation::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsItemAnimation::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsItemAnimation_Adaptor, QEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsItemAnimation::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsItemAnimation::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsItemAnimation_Adaptor, const char *>(&QGraphicsItemAnimation_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsItemAnimation::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsItemAnimation::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsItemAnimation::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsItemAnimation_Adaptor, QTimerEvent *>(&QGraphicsItemAnimation_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsItemAnimation::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_afterAnimationStep_1071_0;
  gsi::Callback cb_beforeAnimationStep_1071_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsItemAnimation_Adaptor::~QGraphicsItemAnimation_Adaptor() { }

//  Constructor QGraphicsItemAnimation::QGraphicsItemAnimation(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsItemAnimation_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsItemAnimation_Adaptor *> ();
}

static void _call_ctor_QGraphicsItemAnimation_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QGraphicsItemAnimation_Adaptor *> (new QGraphicsItemAnimation_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsItemAnimation_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsItemAnimation::QGraphicsItemAnimation(QObject *parent)\nThis method creates an object of class QGraphicsItemAnimation.", &_init_ctor_QGraphicsItemAnimation_Adaptor_1302, &_call_ctor_QGraphicsItemAnimation_Adaptor_1302);
}

// int QGraphicsItemAnimation::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QGraphicsItemAnimation_Adaptor *)cls)->fp_QGraphicsItemAnimation_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QGraphicsItemAnimation::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QGraphicsItemAnimation::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QGraphicsItemAnimation_Adaptor *)cls)->fp_QGraphicsItemAnimation_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QGraphicsItemAnimation::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QGraphicsItemAnimation::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsItemAnimation_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsItemAnimation::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QGraphicsItemAnimation::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsItemAnimation_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsItemAnimation::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QGraphicsItemAnimation::afterAnimationStep(double step)

static void _init_cbs_afterAnimationStep_1071_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_afterAnimationStep_1071_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_afterAnimationStep_1071_0 (arg1);
}

static void _set_callback_cbs_afterAnimationStep_1071_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_afterAnimationStep_1071_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_afterAnimationStep_1071_0 ()
{
  return new qt_gsi::GenericMethod ("*afterAnimationStep", "@hide", false, &_init_cbs_afterAnimationStep_1071_0, &_call_cbs_afterAnimationStep_1071_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_afterAnimationStep_1071_0 ()
{
  return new qt_gsi::GenericMethod ("*afterAnimationStep", "@brief Virtual method void QGraphicsItemAnimation::afterAnimationStep(double step)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_afterAnimationStep_1071_0, &_call_cbs_afterAnimationStep_1071_0, &_set_callback_cbs_afterAnimationStep_1071_0);
}


// void QGraphicsItemAnimation::beforeAnimationStep(double step)

static void _init_cbs_beforeAnimationStep_1071_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_beforeAnimationStep_1071_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_beforeAnimationStep_1071_0 (arg1);
}

static void _set_callback_cbs_beforeAnimationStep_1071_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_beforeAnimationStep_1071_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_beforeAnimationStep_1071_0 ()
{
  return new qt_gsi::GenericMethod ("*beforeAnimationStep", "@hide", false, &_init_cbs_beforeAnimationStep_1071_0, &_call_cbs_beforeAnimationStep_1071_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_beforeAnimationStep_1071_0 ()
{
  return new qt_gsi::GenericMethod ("*beforeAnimationStep", "@brief Virtual method void QGraphicsItemAnimation::beforeAnimationStep(double step)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_beforeAnimationStep_1071_0, &_call_cbs_beforeAnimationStep_1071_0, &_set_callback_cbs_beforeAnimationStep_1071_0);
}


// void QGraphicsItemAnimation::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsItemAnimation::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QGraphicsItemAnimation::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsItemAnimation::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QGraphicsItemAnimation::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsItemAnimation::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QGraphicsItemAnimation::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QGraphicsItemAnimation_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItemAnimation_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsItemAnimation::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsItemAnimation> decl_QGraphicsItemAnimation;

gsi::Class<QGraphicsItemAnimation_Adaptor> decl_QGraphicsItemAnimation_Adaptor (decl_QGraphicsItemAnimation, "QGraphicsItemAnimation",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_afterAnimationStep_1071_0 ()) +
  gsi::Methods(_create_callback_cbs_afterAnimationStep_1071_0 ()) +
  gsi::Methods(_create_cbs_beforeAnimationStep_1071_0 ()) +
  gsi::Methods(_create_callback_cbs_beforeAnimationStep_1071_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsItemAnimation_Adaptor_1302 ()),
  "@qt\n@brief Binding of QGraphicsItemAnimation");

}

