
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFontDatabase.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQFontDatabase_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFontDatabase

//  Constructor QFontDatabase::QFontDatabase()


static void _init_ctor_QFontDatabase_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QFontDatabase *> ();
}

static void _call_ctor_QFontDatabase_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFontDatabase *> (new QFontDatabase ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFontDatabase_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFontDatabase::QFontDatabase()\nThis method creates an object of class QFontDatabase.", &_init_ctor_QFontDatabase_0, &_call_ctor_QFontDatabase_0);
}

// bool QFontDatabase::bold(const QString &family, const QString &style)


static void _init_f_bold_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_bold_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QFontDatabase *)cls)->bold (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_bold_c3942 ()
{
  return new qt_gsi::GenericMethod ("bold", "@brief Method bool QFontDatabase::bold(const QString &family, const QString &style)\n", true, &_init_f_bold_c3942, &_call_f_bold_c3942);
}

// QStringList QFontDatabase::families(QFontDatabase::WritingSystem writingSystem)


static void _init_f_families_c3214 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("writingSystem", true, "QFontDatabase::Any");
  decl->add_arg<const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_families_c3214 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & > () : (const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<QFontDatabase::WritingSystem>(heap, QFontDatabase::Any));
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QFontDatabase *)cls)->families (qt_gsi::QtToCppAdaptor<QFontDatabase::WritingSystem>(arg1).cref())));
}

static qt_gsi::GenericMethod *_create_f_families_c3214 ()
{
  return new qt_gsi::GenericMethod ("families", "@brief Method QStringList QFontDatabase::families(QFontDatabase::WritingSystem writingSystem)\n", true, &_init_f_families_c3214, &_call_f_families_c3214);
}

// QFont QFontDatabase::font(const QString &family, const QString &style, int pointSize)


static void _init_f_font_c4601 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pointSize");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QFont > ();
}

static void _call_f_font_c4601 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  int arg3 = args.read<int > ();
  ret.write<QFont > ((QFont)((QFontDatabase *)cls)->font (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_font_c4601 ()
{
  return new qt_gsi::GenericMethod ("font", "@brief Method QFont QFontDatabase::font(const QString &family, const QString &style, int pointSize)\n", true, &_init_f_font_c4601, &_call_f_font_c4601);
}

// bool QFontDatabase::isBitmapScalable(const QString &family, const QString &style)


static void _init_f_isBitmapScalable_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isBitmapScalable_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<bool > ((bool)((QFontDatabase *)cls)->isBitmapScalable (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_isBitmapScalable_c3942 ()
{
  return new qt_gsi::GenericMethod ("isBitmapScalable?", "@brief Method bool QFontDatabase::isBitmapScalable(const QString &family, const QString &style)\n", true, &_init_f_isBitmapScalable_c3942, &_call_f_isBitmapScalable_c3942);
}

// bool QFontDatabase::isFixedPitch(const QString &family, const QString &style)


static void _init_f_isFixedPitch_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isFixedPitch_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<bool > ((bool)((QFontDatabase *)cls)->isFixedPitch (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_isFixedPitch_c3942 ()
{
  return new qt_gsi::GenericMethod ("isFixedPitch?", "@brief Method bool QFontDatabase::isFixedPitch(const QString &family, const QString &style)\n", true, &_init_f_isFixedPitch_c3942, &_call_f_isFixedPitch_c3942);
}

// bool QFontDatabase::isScalable(const QString &family, const QString &style)


static void _init_f_isScalable_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isScalable_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<bool > ((bool)((QFontDatabase *)cls)->isScalable (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_isScalable_c3942 ()
{
  return new qt_gsi::GenericMethod ("isScalable?", "@brief Method bool QFontDatabase::isScalable(const QString &family, const QString &style)\n", true, &_init_f_isScalable_c3942, &_call_f_isScalable_c3942);
}

// bool QFontDatabase::isSmoothlyScalable(const QString &family, const QString &style)


static void _init_f_isSmoothlyScalable_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isSmoothlyScalable_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<bool > ((bool)((QFontDatabase *)cls)->isSmoothlyScalable (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_isSmoothlyScalable_c3942 ()
{
  return new qt_gsi::GenericMethod ("isSmoothlyScalable?", "@brief Method bool QFontDatabase::isSmoothlyScalable(const QString &family, const QString &style)\n", true, &_init_f_isSmoothlyScalable_c3942, &_call_f_isSmoothlyScalable_c3942);
}

// bool QFontDatabase::italic(const QString &family, const QString &style)


static void _init_f_italic_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_italic_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QFontDatabase *)cls)->italic (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_italic_c3942 ()
{
  return new qt_gsi::GenericMethod ("italic", "@brief Method bool QFontDatabase::italic(const QString &family, const QString &style)\n", true, &_init_f_italic_c3942, &_call_f_italic_c3942);
}

// QList<int> QFontDatabase::pointSizes(const QString &family, const QString &style)


static void _init_f_pointSizes_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<int> >::target_type > ();
}

static void _call_f_pointSizes_3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<qt_gsi::Converter<QList<int> >::target_type > ((qt_gsi::Converter<QList<int> >::target_type)qt_gsi::CppToQtAdaptor<QList<int> >(((QFontDatabase *)cls)->pointSizes (arg1, arg2)));
}

static qt_gsi::GenericMethod *_create_f_pointSizes_3942 ()
{
  return new qt_gsi::GenericMethod ("pointSizes", "@brief Method QList<int> QFontDatabase::pointSizes(const QString &family, const QString &style)\n", false, &_init_f_pointSizes_3942, &_call_f_pointSizes_3942);
}

// QList<int> QFontDatabase::smoothSizes(const QString &family, const QString &style)


static void _init_f_smoothSizes_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<int> >::target_type > ();
}

static void _call_f_smoothSizes_3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<qt_gsi::Converter<QList<int> >::target_type > ((qt_gsi::Converter<QList<int> >::target_type)qt_gsi::CppToQtAdaptor<QList<int> >(((QFontDatabase *)cls)->smoothSizes (arg1, arg2)));
}

static qt_gsi::GenericMethod *_create_f_smoothSizes_3942 ()
{
  return new qt_gsi::GenericMethod ("smoothSizes", "@brief Method QList<int> QFontDatabase::smoothSizes(const QString &family, const QString &style)\n", false, &_init_f_smoothSizes_3942, &_call_f_smoothSizes_3942);
}

// QString QFontDatabase::styleString(const QFont &font)


static void _init_f_styleString_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_styleString_1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ret.write<QString > ((QString)((QFontDatabase *)cls)->styleString (arg1));
}

static qt_gsi::GenericMethod *_create_f_styleString_1801 ()
{
  return new qt_gsi::GenericMethod ("styleString", "@brief Method QString QFontDatabase::styleString(const QFont &font)\n", false, &_init_f_styleString_1801, &_call_f_styleString_1801);
}

// QString QFontDatabase::styleString(const QFontInfo &fontInfo)


static void _init_f_styleString_2197 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fontInfo");
  decl->add_arg<const QFontInfo & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_styleString_2197 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFontInfo &arg1 = args.read<const QFontInfo & > ();
  ret.write<QString > ((QString)((QFontDatabase *)cls)->styleString (arg1));
}

static qt_gsi::GenericMethod *_create_f_styleString_2197 ()
{
  return new qt_gsi::GenericMethod ("styleString", "@brief Method QString QFontDatabase::styleString(const QFontInfo &fontInfo)\n", false, &_init_f_styleString_2197, &_call_f_styleString_2197);
}

// QStringList QFontDatabase::styles(const QString &family)


static void _init_f_styles_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_styles_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QFontDatabase *)cls)->styles (arg1)));
}

static qt_gsi::GenericMethod *_create_f_styles_c2025 ()
{
  return new qt_gsi::GenericMethod ("styles", "@brief Method QStringList QFontDatabase::styles(const QString &family)\n", true, &_init_f_styles_c2025, &_call_f_styles_c2025);
}

// int QFontDatabase::weight(const QString &family, const QString &style)


static void _init_f_weight_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("style");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_weight_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<int > ((int)((QFontDatabase *)cls)->weight (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_weight_c3942 ()
{
  return new qt_gsi::GenericMethod ("weight", "@brief Method int QFontDatabase::weight(const QString &family, const QString &style)\n", true, &_init_f_weight_c3942, &_call_f_weight_c3942);
}

// QList<QFontDatabase::WritingSystem> QFontDatabase::writingSystems()


static void _init_f_writingSystems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QFontDatabase::WritingSystem> >::target_type > ();
}

static void _call_f_writingSystems_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QFontDatabase::WritingSystem> >::target_type > ((qt_gsi::Converter<QList<QFontDatabase::WritingSystem> >::target_type)qt_gsi::CppToQtAdaptor<QList<QFontDatabase::WritingSystem> >(((QFontDatabase *)cls)->writingSystems ()));
}

static qt_gsi::GenericMethod *_create_f_writingSystems_c0 ()
{
  return new qt_gsi::GenericMethod ("writingSystems", "@brief Method QList<QFontDatabase::WritingSystem> QFontDatabase::writingSystems()\n", true, &_init_f_writingSystems_c0, &_call_f_writingSystems_c0);
}

// QList<QFontDatabase::WritingSystem> QFontDatabase::writingSystems(const QString &family)


static void _init_f_writingSystems_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QFontDatabase::WritingSystem> >::target_type > ();
}

static void _call_f_writingSystems_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<qt_gsi::Converter<QList<QFontDatabase::WritingSystem> >::target_type > ((qt_gsi::Converter<QList<QFontDatabase::WritingSystem> >::target_type)qt_gsi::CppToQtAdaptor<QList<QFontDatabase::WritingSystem> >(((QFontDatabase *)cls)->writingSystems (arg1)));
}

static qt_gsi::GenericMethod *_create_f_writingSystems_c2025 ()
{
  return new qt_gsi::GenericMethod ("writingSystems", "@brief Method QList<QFontDatabase::WritingSystem> QFontDatabase::writingSystems(const QString &family)\n", true, &_init_f_writingSystems_c2025, &_call_f_writingSystems_c2025);
}

// static int QFontDatabase::addApplicationFont(const QString &fileName)


static void _init_f_addApplicationFont_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_addApplicationFont_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<int > ((int)QFontDatabase::addApplicationFont (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_addApplicationFont_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("addApplicationFont", "@brief Static method int QFontDatabase::addApplicationFont(const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_addApplicationFont_2025, &_call_f_addApplicationFont_2025);
}

// static int QFontDatabase::addApplicationFontFromData(const QByteArray &fontData)


static void _init_f_addApplicationFontFromData_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fontData");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_addApplicationFontFromData_2309 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<int > ((int)QFontDatabase::addApplicationFontFromData (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_addApplicationFontFromData_2309 ()
{
  return new qt_gsi::GenericStaticMethod ("addApplicationFontFromData", "@brief Static method int QFontDatabase::addApplicationFontFromData(const QByteArray &fontData)\nThis method is static and can be called without an instance.", &_init_f_addApplicationFontFromData_2309, &_call_f_addApplicationFontFromData_2309);
}

// static QStringList QFontDatabase::applicationFontFamilies(int id)


static void _init_f_applicationFontFamilies_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_applicationFontFamilies_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QFontDatabase::applicationFontFamilies (arg1)));
}

static qt_gsi::GenericStaticMethod *_create_f_applicationFontFamilies_767 ()
{
  return new qt_gsi::GenericStaticMethod ("applicationFontFamilies", "@brief Static method QStringList QFontDatabase::applicationFontFamilies(int id)\nThis method is static and can be called without an instance.", &_init_f_applicationFontFamilies_767, &_call_f_applicationFontFamilies_767);
}

// static bool QFontDatabase::removeAllApplicationFonts()


static void _init_f_removeAllApplicationFonts_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_removeAllApplicationFonts_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QFontDatabase::removeAllApplicationFonts ());
}

static qt_gsi::GenericStaticMethod *_create_f_removeAllApplicationFonts_0 ()
{
  return new qt_gsi::GenericStaticMethod ("removeAllApplicationFonts", "@brief Static method bool QFontDatabase::removeAllApplicationFonts()\nThis method is static and can be called without an instance.", &_init_f_removeAllApplicationFonts_0, &_call_f_removeAllApplicationFonts_0);
}

// static bool QFontDatabase::removeApplicationFont(int id)


static void _init_f_removeApplicationFont_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_removeApplicationFont_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)QFontDatabase::removeApplicationFont (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_removeApplicationFont_767 ()
{
  return new qt_gsi::GenericStaticMethod ("removeApplicationFont", "@brief Static method bool QFontDatabase::removeApplicationFont(int id)\nThis method is static and can be called without an instance.", &_init_f_removeApplicationFont_767, &_call_f_removeApplicationFont_767);
}

// static QList<int> QFontDatabase::standardSizes()


static void _init_f_standardSizes_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<int> >::target_type > ();
}

static void _call_f_standardSizes_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<int> >::target_type > ((qt_gsi::Converter<QList<int> >::target_type)qt_gsi::CppToQtAdaptor<QList<int> >(QFontDatabase::standardSizes ()));
}

static qt_gsi::GenericStaticMethod *_create_f_standardSizes_0 ()
{
  return new qt_gsi::GenericStaticMethod ("standardSizes", "@brief Static method QList<int> QFontDatabase::standardSizes()\nThis method is static and can be called without an instance.", &_init_f_standardSizes_0, &_call_f_standardSizes_0);
}

// static bool QFontDatabase::supportsThreadedFontRendering()


static void _init_f_supportsThreadedFontRendering_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_supportsThreadedFontRendering_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QFontDatabase::supportsThreadedFontRendering ());
}

static qt_gsi::GenericStaticMethod *_create_f_supportsThreadedFontRendering_0 ()
{
  return new qt_gsi::GenericStaticMethod ("supportsThreadedFontRendering", "@brief Static method bool QFontDatabase::supportsThreadedFontRendering()\nThis method is static and can be called without an instance.", &_init_f_supportsThreadedFontRendering_0, &_call_f_supportsThreadedFontRendering_0);
}

// static QString QFontDatabase::writingSystemName(QFontDatabase::WritingSystem writingSystem)


static void _init_f_writingSystemName_3214 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("writingSystem");
  decl->add_arg<const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_writingSystemName_3214 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & arg1 = args.read<const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & > ();
  ret.write<QString > ((QString)QFontDatabase::writingSystemName (qt_gsi::QtToCppAdaptor<QFontDatabase::WritingSystem>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_writingSystemName_3214 ()
{
  return new qt_gsi::GenericStaticMethod ("writingSystemName", "@brief Static method QString QFontDatabase::writingSystemName(QFontDatabase::WritingSystem writingSystem)\nThis method is static and can be called without an instance.", &_init_f_writingSystemName_3214, &_call_f_writingSystemName_3214);
}

// static QString QFontDatabase::writingSystemSample(QFontDatabase::WritingSystem writingSystem)


static void _init_f_writingSystemSample_3214 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("writingSystem");
  decl->add_arg<const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_writingSystemSample_3214 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & arg1 = args.read<const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & > ();
  ret.write<QString > ((QString)QFontDatabase::writingSystemSample (qt_gsi::QtToCppAdaptor<QFontDatabase::WritingSystem>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_writingSystemSample_3214 ()
{
  return new qt_gsi::GenericStaticMethod ("writingSystemSample", "@brief Static method QString QFontDatabase::writingSystemSample(QFontDatabase::WritingSystem writingSystem)\nThis method is static and can be called without an instance.", &_init_f_writingSystemSample_3214, &_call_f_writingSystemSample_3214);
}


namespace gsi
{
gsi::Class<QFontDatabase> decl_QFontDatabase ("QFontDatabase",
  gsi::Methods(_create_ctor_QFontDatabase_0 ()) +
  gsi::Methods(_create_f_bold_c3942 ()) +
  gsi::Methods(_create_f_families_c3214 ()) +
  gsi::Methods(_create_f_font_c4601 ()) +
  gsi::Methods(_create_f_isBitmapScalable_c3942 ()) +
  gsi::Methods(_create_f_isFixedPitch_c3942 ()) +
  gsi::Methods(_create_f_isScalable_c3942 ()) +
  gsi::Methods(_create_f_isSmoothlyScalable_c3942 ()) +
  gsi::Methods(_create_f_italic_c3942 ()) +
  gsi::Methods(_create_f_pointSizes_3942 ()) +
  gsi::Methods(_create_f_smoothSizes_3942 ()) +
  gsi::Methods(_create_f_styleString_1801 ()) +
  gsi::Methods(_create_f_styleString_2197 ()) +
  gsi::Methods(_create_f_styles_c2025 ()) +
  gsi::Methods(_create_f_weight_c3942 ()) +
  gsi::Methods(_create_f_writingSystems_c0 ()) +
  gsi::Methods(_create_f_writingSystems_c2025 ()) +
  gsi::Methods(_create_f_addApplicationFont_2025 ()) +
  gsi::Methods(_create_f_addApplicationFontFromData_2309 ()) +
  gsi::Methods(_create_f_applicationFontFamilies_767 ()) +
  gsi::Methods(_create_f_removeAllApplicationFonts_0 ()) +
  gsi::Methods(_create_f_removeApplicationFont_767 ()) +
  gsi::Methods(_create_f_standardSizes_0 ()) +
  gsi::Methods(_create_f_supportsThreadedFontRendering_0 ()) +
  gsi::Methods(_create_f_writingSystemName_3214 ()) +
  gsi::Methods(_create_f_writingSystemSample_3214 ()),
  "@qt\n@brief Binding of QFontDatabase");

}


//  Implementation of the enum wrapper class for QFontDatabase::WritingSystem
namespace qt_gsi
{

static QFontDatabase_WritingSystem_Enum *c_1_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Any); }
static QFontDatabase_WritingSystem_Enum *c_2_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Latin); }
static QFontDatabase_WritingSystem_Enum *c_3_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Greek); }
static QFontDatabase_WritingSystem_Enum *c_4_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Cyrillic); }
static QFontDatabase_WritingSystem_Enum *c_5_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Armenian); }
static QFontDatabase_WritingSystem_Enum *c_6_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Hebrew); }
static QFontDatabase_WritingSystem_Enum *c_7_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Arabic); }
static QFontDatabase_WritingSystem_Enum *c_8_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Syriac); }
static QFontDatabase_WritingSystem_Enum *c_9_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Thaana); }
static QFontDatabase_WritingSystem_Enum *c_10_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Devanagari); }
static QFontDatabase_WritingSystem_Enum *c_11_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Bengali); }
static QFontDatabase_WritingSystem_Enum *c_12_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Gurmukhi); }
static QFontDatabase_WritingSystem_Enum *c_13_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Gujarati); }
static QFontDatabase_WritingSystem_Enum *c_14_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Oriya); }
static QFontDatabase_WritingSystem_Enum *c_15_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Tamil); }
static QFontDatabase_WritingSystem_Enum *c_16_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Telugu); }
static QFontDatabase_WritingSystem_Enum *c_17_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Kannada); }
static QFontDatabase_WritingSystem_Enum *c_18_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Malayalam); }
static QFontDatabase_WritingSystem_Enum *c_19_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Sinhala); }
static QFontDatabase_WritingSystem_Enum *c_20_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Thai); }
static QFontDatabase_WritingSystem_Enum *c_21_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Lao); }
static QFontDatabase_WritingSystem_Enum *c_22_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Tibetan); }
static QFontDatabase_WritingSystem_Enum *c_23_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Myanmar); }
static QFontDatabase_WritingSystem_Enum *c_24_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Georgian); }
static QFontDatabase_WritingSystem_Enum *c_25_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Khmer); }
static QFontDatabase_WritingSystem_Enum *c_26_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::SimplifiedChinese); }
static QFontDatabase_WritingSystem_Enum *c_27_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::TraditionalChinese); }
static QFontDatabase_WritingSystem_Enum *c_28_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Japanese); }
static QFontDatabase_WritingSystem_Enum *c_29_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Korean); }
static QFontDatabase_WritingSystem_Enum *c_30_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Vietnamese); }
static QFontDatabase_WritingSystem_Enum *c_31_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Symbol); }
static QFontDatabase_WritingSystem_Enum *c_32_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Other); }
static QFontDatabase_WritingSystem_Enum *c_33_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Ogham); }
static QFontDatabase_WritingSystem_Enum *c_34_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Runic); }
static QFontDatabase_WritingSystem_Enum *c_35_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::Nko); }
static QFontDatabase_WritingSystem_Enum *c_36_QFontDatabase_WritingSystem_Enum () { return new QFontDatabase_WritingSystem_Enum (QFontDatabase::WritingSystemsCount); }

static gsi::Methods mkdefs_QFontDatabase_WritingSystem () {
  return
    gsi::constant ("Any", &qt_gsi::c_1_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Any") +
    gsi::constant ("Latin", &qt_gsi::c_2_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Latin") +
    gsi::constant ("Greek", &qt_gsi::c_3_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Greek") +
    gsi::constant ("Cyrillic", &qt_gsi::c_4_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Cyrillic") +
    gsi::constant ("Armenian", &qt_gsi::c_5_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Armenian") +
    gsi::constant ("Hebrew", &qt_gsi::c_6_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Hebrew") +
    gsi::constant ("Arabic", &qt_gsi::c_7_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Arabic") +
    gsi::constant ("Syriac", &qt_gsi::c_8_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Syriac") +
    gsi::constant ("Thaana", &qt_gsi::c_9_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Thaana") +
    gsi::constant ("Devanagari", &qt_gsi::c_10_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Devanagari") +
    gsi::constant ("Bengali", &qt_gsi::c_11_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Bengali") +
    gsi::constant ("Gurmukhi", &qt_gsi::c_12_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Gurmukhi") +
    gsi::constant ("Gujarati", &qt_gsi::c_13_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Gujarati") +
    gsi::constant ("Oriya", &qt_gsi::c_14_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Oriya") +
    gsi::constant ("Tamil", &qt_gsi::c_15_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Tamil") +
    gsi::constant ("Telugu", &qt_gsi::c_16_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Telugu") +
    gsi::constant ("Kannada", &qt_gsi::c_17_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Kannada") +
    gsi::constant ("Malayalam", &qt_gsi::c_18_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Malayalam") +
    gsi::constant ("Sinhala", &qt_gsi::c_19_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Sinhala") +
    gsi::constant ("Thai", &qt_gsi::c_20_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Thai") +
    gsi::constant ("Lao", &qt_gsi::c_21_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Lao") +
    gsi::constant ("Tibetan", &qt_gsi::c_22_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Tibetan") +
    gsi::constant ("Myanmar", &qt_gsi::c_23_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Myanmar") +
    gsi::constant ("Georgian", &qt_gsi::c_24_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Georgian") +
    gsi::constant ("Khmer", &qt_gsi::c_25_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Khmer") +
    gsi::constant ("SimplifiedChinese", &qt_gsi::c_26_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::SimplifiedChinese") +
    gsi::constant ("TraditionalChinese", &qt_gsi::c_27_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::TraditionalChinese") +
    gsi::constant ("Japanese", &qt_gsi::c_28_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Japanese") +
    gsi::constant ("Korean", &qt_gsi::c_29_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Korean") +
    gsi::constant ("Vietnamese", &qt_gsi::c_30_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Vietnamese") +
    gsi::constant ("Symbol", &qt_gsi::c_31_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Symbol") +
    gsi::constant ("Other", &qt_gsi::c_32_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Other") +
    gsi::constant ("Ogham", &qt_gsi::c_33_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Ogham") +
    gsi::constant ("Runic", &qt_gsi::c_34_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Runic") +
    gsi::constant ("Nko", &qt_gsi::c_35_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::Nko") +
    gsi::constant ("WritingSystemsCount", &qt_gsi::c_36_QFontDatabase_WritingSystem_Enum, "@brief Enum constant QFontDatabase::WritingSystemsCount");
}

static std::string to_s_QFontDatabase_WritingSystem_Enum (const QFontDatabase_WritingSystem_Enum *e)
{
  if (e->value () == QFontDatabase::Any) { return tl::sprintf ("Any (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Latin) { return tl::sprintf ("Latin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Greek) { return tl::sprintf ("Greek (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Cyrillic) { return tl::sprintf ("Cyrillic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Armenian) { return tl::sprintf ("Armenian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Hebrew) { return tl::sprintf ("Hebrew (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Arabic) { return tl::sprintf ("Arabic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Syriac) { return tl::sprintf ("Syriac (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Thaana) { return tl::sprintf ("Thaana (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Devanagari) { return tl::sprintf ("Devanagari (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Bengali) { return tl::sprintf ("Bengali (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Gurmukhi) { return tl::sprintf ("Gurmukhi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Gujarati) { return tl::sprintf ("Gujarati (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Oriya) { return tl::sprintf ("Oriya (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Tamil) { return tl::sprintf ("Tamil (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Telugu) { return tl::sprintf ("Telugu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Kannada) { return tl::sprintf ("Kannada (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Malayalam) { return tl::sprintf ("Malayalam (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Sinhala) { return tl::sprintf ("Sinhala (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Thai) { return tl::sprintf ("Thai (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Lao) { return tl::sprintf ("Lao (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Tibetan) { return tl::sprintf ("Tibetan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Myanmar) { return tl::sprintf ("Myanmar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Georgian) { return tl::sprintf ("Georgian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Khmer) { return tl::sprintf ("Khmer (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::SimplifiedChinese) { return tl::sprintf ("SimplifiedChinese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::TraditionalChinese) { return tl::sprintf ("TraditionalChinese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Japanese) { return tl::sprintf ("Japanese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Korean) { return tl::sprintf ("Korean (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Vietnamese) { return tl::sprintf ("Vietnamese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Symbol) { return tl::sprintf ("Symbol (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Other) { return tl::sprintf ("Other (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Ogham) { return tl::sprintf ("Ogham (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Runic) { return tl::sprintf ("Runic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::Nko) { return tl::sprintf ("Nko (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFontDatabase::WritingSystemsCount) { return tl::sprintf ("WritingSystemsCount (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFontDatabase_WritingSystem_Enum (const QFontDatabase_WritingSystem_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFontDatabase_WritingSystem_Enum *from_i_QFontDatabase_WritingSystem_Enum (unsigned int i)
{
  return new QFontDatabase_WritingSystem_Enum ((QFontDatabase::WritingSystem) i);
}

static bool equalQFontDatabase_WritingSystem_Enum (const QFontDatabase_WritingSystem_Enum *e, QFontDatabase_WritingSystem_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFontDatabase_WritingSystem_Enum (const QFontDatabase_WritingSystem_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFontDatabase_WritingSystem_Enums oropQFontDatabase_WritingSystem_Enums (const QFontDatabase_WritingSystem_Enums *e, const QFontDatabase_WritingSystem_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFontDatabase_WritingSystem_Enums andopQFontDatabase_WritingSystem_Enums (const QFontDatabase_WritingSystem_Enums *e, const QFontDatabase_WritingSystem_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFontDatabase_WritingSystem_Enums xoropQFontDatabase_WritingSystem_Enums (const QFontDatabase_WritingSystem_Enums *e, const QFontDatabase_WritingSystem_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFontDatabase_WritingSystem_Enums (const QFontDatabase_WritingSystem_Enums *e)
{
  std::string l;
  if (e->testFlag (QFontDatabase::Any)) { if (!l.empty ()) l += "|"; l += "Any"; }
  if (e->testFlag (QFontDatabase::Latin)) { if (!l.empty ()) l += "|"; l += "Latin"; }
  if (e->testFlag (QFontDatabase::Greek)) { if (!l.empty ()) l += "|"; l += "Greek"; }
  if (e->testFlag (QFontDatabase::Cyrillic)) { if (!l.empty ()) l += "|"; l += "Cyrillic"; }
  if (e->testFlag (QFontDatabase::Armenian)) { if (!l.empty ()) l += "|"; l += "Armenian"; }
  if (e->testFlag (QFontDatabase::Hebrew)) { if (!l.empty ()) l += "|"; l += "Hebrew"; }
  if (e->testFlag (QFontDatabase::Arabic)) { if (!l.empty ()) l += "|"; l += "Arabic"; }
  if (e->testFlag (QFontDatabase::Syriac)) { if (!l.empty ()) l += "|"; l += "Syriac"; }
  if (e->testFlag (QFontDatabase::Thaana)) { if (!l.empty ()) l += "|"; l += "Thaana"; }
  if (e->testFlag (QFontDatabase::Devanagari)) { if (!l.empty ()) l += "|"; l += "Devanagari"; }
  if (e->testFlag (QFontDatabase::Bengali)) { if (!l.empty ()) l += "|"; l += "Bengali"; }
  if (e->testFlag (QFontDatabase::Gurmukhi)) { if (!l.empty ()) l += "|"; l += "Gurmukhi"; }
  if (e->testFlag (QFontDatabase::Gujarati)) { if (!l.empty ()) l += "|"; l += "Gujarati"; }
  if (e->testFlag (QFontDatabase::Oriya)) { if (!l.empty ()) l += "|"; l += "Oriya"; }
  if (e->testFlag (QFontDatabase::Tamil)) { if (!l.empty ()) l += "|"; l += "Tamil"; }
  if (e->testFlag (QFontDatabase::Telugu)) { if (!l.empty ()) l += "|"; l += "Telugu"; }
  if (e->testFlag (QFontDatabase::Kannada)) { if (!l.empty ()) l += "|"; l += "Kannada"; }
  if (e->testFlag (QFontDatabase::Malayalam)) { if (!l.empty ()) l += "|"; l += "Malayalam"; }
  if (e->testFlag (QFontDatabase::Sinhala)) { if (!l.empty ()) l += "|"; l += "Sinhala"; }
  if (e->testFlag (QFontDatabase::Thai)) { if (!l.empty ()) l += "|"; l += "Thai"; }
  if (e->testFlag (QFontDatabase::Lao)) { if (!l.empty ()) l += "|"; l += "Lao"; }
  if (e->testFlag (QFontDatabase::Tibetan)) { if (!l.empty ()) l += "|"; l += "Tibetan"; }
  if (e->testFlag (QFontDatabase::Myanmar)) { if (!l.empty ()) l += "|"; l += "Myanmar"; }
  if (e->testFlag (QFontDatabase::Georgian)) { if (!l.empty ()) l += "|"; l += "Georgian"; }
  if (e->testFlag (QFontDatabase::Khmer)) { if (!l.empty ()) l += "|"; l += "Khmer"; }
  if (e->testFlag (QFontDatabase::SimplifiedChinese)) { if (!l.empty ()) l += "|"; l += "SimplifiedChinese"; }
  if (e->testFlag (QFontDatabase::TraditionalChinese)) { if (!l.empty ()) l += "|"; l += "TraditionalChinese"; }
  if (e->testFlag (QFontDatabase::Japanese)) { if (!l.empty ()) l += "|"; l += "Japanese"; }
  if (e->testFlag (QFontDatabase::Korean)) { if (!l.empty ()) l += "|"; l += "Korean"; }
  if (e->testFlag (QFontDatabase::Vietnamese)) { if (!l.empty ()) l += "|"; l += "Vietnamese"; }
  if (e->testFlag (QFontDatabase::Symbol)) { if (!l.empty ()) l += "|"; l += "Symbol"; }
  if (e->testFlag (QFontDatabase::Other)) { if (!l.empty ()) l += "|"; l += "Other"; }
  if (e->testFlag (QFontDatabase::Ogham)) { if (!l.empty ()) l += "|"; l += "Ogham"; }
  if (e->testFlag (QFontDatabase::Runic)) { if (!l.empty ()) l += "|"; l += "Runic"; }
  if (e->testFlag (QFontDatabase::Nko)) { if (!l.empty ()) l += "|"; l += "Nko"; }
  if (e->testFlag (QFontDatabase::WritingSystemsCount)) { if (!l.empty ()) l += "|"; l += "WritingSystemsCount"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFontDatabase_WritingSystem_Enums (const QFontDatabase_WritingSystem_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFontDatabase_WritingSystem_Enums (const QFontDatabase_WritingSystem_Enums *e, const QFontDatabase_WritingSystem_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFontDatabase_WritingSystem_Enums> decl_QFontDatabase_WritingSystem_Enums ("QFontDatabase_QFlags_WritingSystem",
  gsi::method_ext ("|", &qt_gsi::oropQFontDatabase_WritingSystem_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFontDatabase_WritingSystem_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFontDatabase_WritingSystem_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFontDatabase_WritingSystem_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFontDatabase_WritingSystem_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFontDatabase_WritingSystem_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFontDatabase::WritingSystem> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFontDatabase_WritingSystem_Enum> decl_QFontDatabase_WritingSystem_Enum (decl_QFontDatabase_WritingSystem_Enums, "QFontDatabase_WritingSystem",
  qt_gsi::mkdefs_QFontDatabase_WritingSystem () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFontDatabase_WritingSystem_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFontDatabase_WritingSystem_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFontDatabase_WritingSystem_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFontDatabase_WritingSystem_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFontDatabase_WritingSystem_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFontDatabase::WritingSystem enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFontDatabase> inject_QFontDatabase_WritingSystem_Enum_in_parent (qt_gsi::mkdefs_QFontDatabase_WritingSystem ());
static gsi::ClassExt<QFontDatabase> decl_QFontDatabase_WritingSystem_Enum_as_child (decl_QFontDatabase_WritingSystem_Enum, "WritingSystem");

}

