
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFont.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQFont_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFont
  static unsigned int font_const_light () { return (unsigned int) QFont::Light; }
  static unsigned int font_const_normal () { return (unsigned int) QFont::Normal; }
  static unsigned int font_const_demibold () { return (unsigned int) QFont::DemiBold; }
  static unsigned int font_const_bold () { return (unsigned int) QFont::Bold; }
  static unsigned int font_const_black () { return (unsigned int) QFont::Black; }

//  Constructor QFont::QFont()


static void _init_ctor_QFont_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QFont *> ();
}

static void _call_ctor_QFont_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFont *> (new QFont ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFont_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFont::QFont()\nThis method creates an object of class QFont.", &_init_ctor_QFont_0, &_call_ctor_QFont_0);
}

//  Constructor QFont::QFont(const QString &family, int pointSize, int weight, bool italic)


static void _init_ctor_QFont_4099 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pointSize", true, "-1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("weight", true, "-1");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("italic", true, "false");
  decl->add_arg<bool > (argspec_3);
  decl->set_return_new<QFont *> ();
}

static void _call_ctor_QFont_4099 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  int arg2 = args ? args.read<int > () : (int)(-1);
  int arg3 = args ? args.read<int > () : (int)(-1);
  bool arg4 = args ? args.read<bool > () : (bool)(false);
  ret.write<QFont *> (new QFont (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFont_4099 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFont::QFont(const QString &family, int pointSize, int weight, bool italic)\nThis method creates an object of class QFont.", &_init_ctor_QFont_4099, &_call_ctor_QFont_4099);
}

//  Constructor QFont::QFont(const QFont &, QPaintDevice *pd)


static void _init_ctor_QFont_3496 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pd");
  decl->add_arg<QPaintDevice * > (argspec_1);
  decl->set_return_new<QFont *> ();
}

static void _call_ctor_QFont_3496 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  QPaintDevice *arg2 = args.read<QPaintDevice * > ();
  ret.write<QFont *> (new QFont (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFont_3496 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFont::QFont(const QFont &, QPaintDevice *pd)\nThis method creates an object of class QFont.", &_init_ctor_QFont_3496, &_call_ctor_QFont_3496);
}

//  Constructor QFont::QFont(const QFont &)


static void _init_ctor_QFont_1801 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return_new<QFont *> ();
}

static void _call_ctor_QFont_1801 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ret.write<QFont *> (new QFont (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFont_1801 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFont::QFont(const QFont &)\nThis method creates an object of class QFont.", &_init_ctor_QFont_1801, &_call_ctor_QFont_1801);
}

// bool QFont::bold()


static void _init_f_bold_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_bold_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFont *)cls)->bold ());
}

static qt_gsi::GenericMethod *_create_f_bold_c0 ()
{
  return new qt_gsi::GenericMethod (":bold", "@brief Method bool QFont::bold()\n", true, &_init_f_bold_c0, &_call_f_bold_c0);
}

// QFont::Capitalization QFont::capitalization()


static void _init_f_capitalization_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::Capitalization>::target_type > ();
}

static void _call_f_capitalization_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFont::Capitalization>::target_type > ((qt_gsi::Converter<QFont::Capitalization>::target_type)qt_gsi::CppToQtAdaptor<QFont::Capitalization>(((QFont *)cls)->capitalization ()));
}

static qt_gsi::GenericMethod *_create_f_capitalization_c0 ()
{
  return new qt_gsi::GenericMethod (":capitalization", "@brief Method QFont::Capitalization QFont::capitalization()\n", true, &_init_f_capitalization_c0, &_call_f_capitalization_c0);
}

// QString QFont::defaultFamily()


static void _init_f_defaultFamily_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_defaultFamily_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFont *)cls)->defaultFamily ());
}

static qt_gsi::GenericMethod *_create_f_defaultFamily_c0 ()
{
  return new qt_gsi::GenericMethod ("defaultFamily", "@brief Method QString QFont::defaultFamily()\n", true, &_init_f_defaultFamily_c0, &_call_f_defaultFamily_c0);
}

// bool QFont::exactMatch()


static void _init_f_exactMatch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_exactMatch_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFont *)cls)->exactMatch ());
}

static qt_gsi::GenericMethod *_create_f_exactMatch_c0 ()
{
  return new qt_gsi::GenericMethod ("exactMatch", "@brief Method bool QFont::exactMatch()\n", true, &_init_f_exactMatch_c0, &_call_f_exactMatch_c0);
}

// QString QFont::family()


static void _init_f_family_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_family_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFont *)cls)->family ());
}

static qt_gsi::GenericMethod *_create_f_family_c0 ()
{
  return new qt_gsi::GenericMethod (":family", "@brief Method QString QFont::family()\n", true, &_init_f_family_c0, &_call_f_family_c0);
}

// bool QFont::fixedPitch()


static void _init_f_fixedPitch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fixedPitch_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFont *)cls)->fixedPitch ());
}

static qt_gsi::GenericMethod *_create_f_fixedPitch_c0 ()
{
  return new qt_gsi::GenericMethod (":fixedPitch", "@brief Method bool QFont::fixedPitch()\n", true, &_init_f_fixedPitch_c0, &_call_f_fixedPitch_c0);
}

// bool QFont::fromString(const QString &)


static void _init_f_fromString_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_fromString_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QFont *)cls)->fromString (arg1));
}

static qt_gsi::GenericMethod *_create_f_fromString_2025 ()
{
  return new qt_gsi::GenericMethod ("fromString", "@brief Method bool QFont::fromString(const QString &)\n", false, &_init_f_fromString_2025, &_call_f_fromString_2025);
}

// Qt::HANDLE QFont::handle()


static void _init_f_handle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<Qt::HANDLE > ();
}

static void _call_f_handle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<Qt::HANDLE > ((Qt::HANDLE)((QFont *)cls)->handle ());
}

static qt_gsi::GenericMethod *_create_f_handle_c0 ()
{
  return new qt_gsi::GenericMethod ("handle", "@brief Method Qt::HANDLE QFont::handle()\n", true, &_init_f_handle_c0, &_call_f_handle_c0);
}

// bool QFont::isCopyOf(const QFont &)


static void _init_f_isCopyOf_c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCopyOf_c1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ret.write<bool > ((bool)((QFont *)cls)->isCopyOf (arg1));
}

static qt_gsi::GenericMethod *_create_f_isCopyOf_c1801 ()
{
  return new qt_gsi::GenericMethod ("isCopyOf?", "@brief Method bool QFont::isCopyOf(const QFont &)\n", true, &_init_f_isCopyOf_c1801, &_call_f_isCopyOf_c1801);
}

// bool QFont::italic()


static void _init_f_italic_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_italic_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFont *)cls)->italic ());
}

static qt_gsi::GenericMethod *_create_f_italic_c0 ()
{
  return new qt_gsi::GenericMethod (":italic", "@brief Method bool QFont::italic()\n", true, &_init_f_italic_c0, &_call_f_italic_c0);
}

// bool QFont::kerning()


static void _init_f_kerning_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_kerning_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFont *)cls)->kerning ());
}

static qt_gsi::GenericMethod *_create_f_kerning_c0 ()
{
  return new qt_gsi::GenericMethod (":kerning", "@brief Method bool QFont::kerning()\n", true, &_init_f_kerning_c0, &_call_f_kerning_c0);
}

// QString QFont::key()


static void _init_f_key_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_key_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFont *)cls)->key ());
}

static qt_gsi::GenericMethod *_create_f_key_c0 ()
{
  return new qt_gsi::GenericMethod ("key", "@brief Method QString QFont::key()\n", true, &_init_f_key_c0, &_call_f_key_c0);
}

// QString QFont::lastResortFamily()


static void _init_f_lastResortFamily_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_lastResortFamily_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFont *)cls)->lastResortFamily ());
}

static qt_gsi::GenericMethod *_create_f_lastResortFamily_c0 ()
{
  return new qt_gsi::GenericMethod ("lastResortFamily", "@brief Method QString QFont::lastResortFamily()\n", true, &_init_f_lastResortFamily_c0, &_call_f_lastResortFamily_c0);
}

// QString QFont::lastResortFont()


static void _init_f_lastResortFont_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_lastResortFont_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFont *)cls)->lastResortFont ());
}

static qt_gsi::GenericMethod *_create_f_lastResortFont_c0 ()
{
  return new qt_gsi::GenericMethod ("lastResortFont", "@brief Method QString QFont::lastResortFont()\n", true, &_init_f_lastResortFont_c0, &_call_f_lastResortFont_c0);
}

// double QFont::letterSpacing()


static void _init_f_letterSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_letterSpacing_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QFont *)cls)->letterSpacing ());
}

static qt_gsi::GenericMethod *_create_f_letterSpacing_c0 ()
{
  return new qt_gsi::GenericMethod ("letterSpacing", "@brief Method double QFont::letterSpacing()\n", true, &_init_f_letterSpacing_c0, &_call_f_letterSpacing_c0);
}

// QFont::SpacingType QFont::letterSpacingType()


static void _init_f_letterSpacingType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::SpacingType>::target_type > ();
}

static void _call_f_letterSpacingType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFont::SpacingType>::target_type > ((qt_gsi::Converter<QFont::SpacingType>::target_type)qt_gsi::CppToQtAdaptor<QFont::SpacingType>(((QFont *)cls)->letterSpacingType ()));
}

static qt_gsi::GenericMethod *_create_f_letterSpacingType_c0 ()
{
  return new qt_gsi::GenericMethod ("letterSpacingType", "@brief Method QFont::SpacingType QFont::letterSpacingType()\n", true, &_init_f_letterSpacingType_c0, &_call_f_letterSpacingType_c0);
}

// bool QFont::operator!=(const QFont &)


static void _init_f_operator_excl__eq__c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ret.write<bool > ((bool)((QFont *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c1801 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QFont::operator!=(const QFont &)\n", true, &_init_f_operator_excl__eq__c1801, &_call_f_operator_excl__eq__c1801);
}

// bool QFont::operator<(const QFont &)


static void _init_f_operator_lt__c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ret.write<bool > ((bool)((QFont *)cls)->operator< (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_lt__c1801 ()
{
  return new qt_gsi::GenericMethod ("<", "@brief Method bool QFont::operator<(const QFont &)\n", true, &_init_f_operator_lt__c1801, &_call_f_operator_lt__c1801);
}

// QFont &QFont::operator=(const QFont &)


static void _init_f_operator_eq__1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<QFont & > ();
}

static void _call_f_operator_eq__1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ret.write<QFont & > ((QFont &)((QFont *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__1801 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QFont &QFont::operator=(const QFont &)\n", false, &_init_f_operator_eq__1801, &_call_f_operator_eq__1801);
}

// bool QFont::operator==(const QFont &)


static void _init_f_operator_eq__eq__c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ret.write<bool > ((bool)((QFont *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c1801 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QFont::operator==(const QFont &)\n", true, &_init_f_operator_eq__eq__c1801, &_call_f_operator_eq__eq__c1801);
}

// bool QFont::overline()


static void _init_f_overline_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_overline_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFont *)cls)->overline ());
}

static qt_gsi::GenericMethod *_create_f_overline_c0 ()
{
  return new qt_gsi::GenericMethod (":overline", "@brief Method bool QFont::overline()\n", true, &_init_f_overline_c0, &_call_f_overline_c0);
}

// int QFont::pixelSize()


static void _init_f_pixelSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pixelSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFont *)cls)->pixelSize ());
}

static qt_gsi::GenericMethod *_create_f_pixelSize_c0 ()
{
  return new qt_gsi::GenericMethod (":pixelSize", "@brief Method int QFont::pixelSize()\n", true, &_init_f_pixelSize_c0, &_call_f_pixelSize_c0);
}

// int QFont::pointSize()


static void _init_f_pointSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pointSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFont *)cls)->pointSize ());
}

static qt_gsi::GenericMethod *_create_f_pointSize_c0 ()
{
  return new qt_gsi::GenericMethod (":pointSize", "@brief Method int QFont::pointSize()\n", true, &_init_f_pointSize_c0, &_call_f_pointSize_c0);
}

// double QFont::pointSizeF()


static void _init_f_pointSizeF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_pointSizeF_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QFont *)cls)->pointSizeF ());
}

static qt_gsi::GenericMethod *_create_f_pointSizeF_c0 ()
{
  return new qt_gsi::GenericMethod (":pointSizeF", "@brief Method double QFont::pointSizeF()\n", true, &_init_f_pointSizeF_c0, &_call_f_pointSizeF_c0);
}

// bool QFont::rawMode()


static void _init_f_rawMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_rawMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFont *)cls)->rawMode ());
}

static qt_gsi::GenericMethod *_create_f_rawMode_c0 ()
{
  return new qt_gsi::GenericMethod (":rawMode", "@brief Method bool QFont::rawMode()\n", true, &_init_f_rawMode_c0, &_call_f_rawMode_c0);
}

// QString QFont::rawName()


static void _init_f_rawName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_rawName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFont *)cls)->rawName ());
}

static qt_gsi::GenericMethod *_create_f_rawName_c0 ()
{
  return new qt_gsi::GenericMethod (":rawName", "@brief Method QString QFont::rawName()\n", true, &_init_f_rawName_c0, &_call_f_rawName_c0);
}

// QFont QFont::resolve(const QFont &)


static void _init_f_resolve_c1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<QFont > ();
}

static void _call_f_resolve_c1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ret.write<QFont > ((QFont)((QFont *)cls)->resolve (arg1));
}

static qt_gsi::GenericMethod *_create_f_resolve_c1801 ()
{
  return new qt_gsi::GenericMethod ("resolve", "@brief Method QFont QFont::resolve(const QFont &)\n", true, &_init_f_resolve_c1801, &_call_f_resolve_c1801);
}

// void QFont::setBold(bool)


static void _init_f_setBold_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBold_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFont *)cls)->setBold (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBold_864 ()
{
  return new qt_gsi::GenericMethod ("setBold|bold=", "@brief Method void QFont::setBold(bool)\n", false, &_init_f_setBold_864, &_call_f_setBold_864);
}

// void QFont::setCapitalization(QFont::Capitalization)


static void _init_f_setCapitalization_2508 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QFont::Capitalization>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCapitalization_2508 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFont::Capitalization>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::Capitalization>::target_type & > ();
  ((QFont *)cls)->setCapitalization (qt_gsi::QtToCppAdaptor<QFont::Capitalization>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCapitalization_2508 ()
{
  return new qt_gsi::GenericMethod ("setCapitalization|capitalization=", "@brief Method void QFont::setCapitalization(QFont::Capitalization)\n", false, &_init_f_setCapitalization_2508, &_call_f_setCapitalization_2508);
}

// void QFont::setFamily(const QString &)


static void _init_f_setFamily_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFamily_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFont *)cls)->setFamily (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFamily_2025 ()
{
  return new qt_gsi::GenericMethod ("setFamily|family=", "@brief Method void QFont::setFamily(const QString &)\n", false, &_init_f_setFamily_2025, &_call_f_setFamily_2025);
}

// void QFont::setFixedPitch(bool)


static void _init_f_setFixedPitch_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFixedPitch_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFont *)cls)->setFixedPitch (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFixedPitch_864 ()
{
  return new qt_gsi::GenericMethod ("setFixedPitch|fixedPitch=", "@brief Method void QFont::setFixedPitch(bool)\n", false, &_init_f_setFixedPitch_864, &_call_f_setFixedPitch_864);
}

// void QFont::setItalic(bool b)


static void _init_f_setItalic_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItalic_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFont *)cls)->setItalic (arg1);
}

static qt_gsi::GenericMethod *_create_f_setItalic_864 ()
{
  return new qt_gsi::GenericMethod ("setItalic|italic=", "@brief Method void QFont::setItalic(bool b)\n", false, &_init_f_setItalic_864, &_call_f_setItalic_864);
}

// void QFont::setKerning(bool)


static void _init_f_setKerning_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKerning_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFont *)cls)->setKerning (arg1);
}

static qt_gsi::GenericMethod *_create_f_setKerning_864 ()
{
  return new qt_gsi::GenericMethod ("setKerning|kerning=", "@brief Method void QFont::setKerning(bool)\n", false, &_init_f_setKerning_864, &_call_f_setKerning_864);
}

// void QFont::setLetterSpacing(QFont::SpacingType type, double spacing)


static void _init_f_setLetterSpacing_3130 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QFont::SpacingType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("spacing");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setLetterSpacing_3130 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFont::SpacingType>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::SpacingType>::target_type & > ();
  double arg2 = args.read<double > ();
  ((QFont *)cls)->setLetterSpacing (qt_gsi::QtToCppAdaptor<QFont::SpacingType>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setLetterSpacing_3130 ()
{
  return new qt_gsi::GenericMethod ("setLetterSpacing", "@brief Method void QFont::setLetterSpacing(QFont::SpacingType type, double spacing)\n", false, &_init_f_setLetterSpacing_3130, &_call_f_setLetterSpacing_3130);
}

// void QFont::setOverline(bool)


static void _init_f_setOverline_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOverline_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFont *)cls)->setOverline (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOverline_864 ()
{
  return new qt_gsi::GenericMethod ("setOverline|overline=", "@brief Method void QFont::setOverline(bool)\n", false, &_init_f_setOverline_864, &_call_f_setOverline_864);
}

// void QFont::setPixelSize(int)


static void _init_f_setPixelSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPixelSize_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QFont *)cls)->setPixelSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPixelSize_767 ()
{
  return new qt_gsi::GenericMethod ("setPixelSize|pixelSize=", "@brief Method void QFont::setPixelSize(int)\n", false, &_init_f_setPixelSize_767, &_call_f_setPixelSize_767);
}

// void QFont::setPointSize(int)


static void _init_f_setPointSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPointSize_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QFont *)cls)->setPointSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPointSize_767 ()
{
  return new qt_gsi::GenericMethod ("setPointSize|pointSize=", "@brief Method void QFont::setPointSize(int)\n", false, &_init_f_setPointSize_767, &_call_f_setPointSize_767);
}

// void QFont::setPointSizeF(double)


static void _init_f_setPointSizeF_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPointSizeF_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QFont *)cls)->setPointSizeF (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPointSizeF_1071 ()
{
  return new qt_gsi::GenericMethod ("setPointSizeF|pointSizeF=", "@brief Method void QFont::setPointSizeF(double)\n", false, &_init_f_setPointSizeF_1071, &_call_f_setPointSizeF_1071);
}

// void QFont::setRawMode(bool)


static void _init_f_setRawMode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRawMode_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFont *)cls)->setRawMode (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRawMode_864 ()
{
  return new qt_gsi::GenericMethod ("setRawMode|rawMode=", "@brief Method void QFont::setRawMode(bool)\n", false, &_init_f_setRawMode_864, &_call_f_setRawMode_864);
}

// void QFont::setRawName(const QString &)


static void _init_f_setRawName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRawName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFont *)cls)->setRawName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRawName_2025 ()
{
  return new qt_gsi::GenericMethod ("setRawName|rawName=", "@brief Method void QFont::setRawName(const QString &)\n", false, &_init_f_setRawName_2025, &_call_f_setRawName_2025);
}

// void QFont::setStretch(int)


static void _init_f_setStretch_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStretch_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QFont *)cls)->setStretch (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStretch_767 ()
{
  return new qt_gsi::GenericMethod ("setStretch|stretch=", "@brief Method void QFont::setStretch(int)\n", false, &_init_f_setStretch_767, &_call_f_setStretch_767);
}

// void QFont::setStrikeOut(bool)


static void _init_f_setStrikeOut_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStrikeOut_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFont *)cls)->setStrikeOut (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStrikeOut_864 ()
{
  return new qt_gsi::GenericMethod ("setStrikeOut|strikeOut=", "@brief Method void QFont::setStrikeOut(bool)\n", false, &_init_f_setStrikeOut_864, &_call_f_setStrikeOut_864);
}

// void QFont::setStyle(QFont::Style style)


static void _init_f_setStyle_1569 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QFont::Style>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1569 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFont::Style>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::Style>::target_type & > ();
  ((QFont *)cls)->setStyle (qt_gsi::QtToCppAdaptor<QFont::Style>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setStyle_1569 ()
{
  return new qt_gsi::GenericMethod ("setStyle|style=", "@brief Method void QFont::setStyle(QFont::Style style)\n", false, &_init_f_setStyle_1569, &_call_f_setStyle_1569);
}

// void QFont::setStyleHint(QFont::StyleHint, QFont::StyleStrategy)


static void _init_f_setStyleHint_4284 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QFont::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QFont::PreferDefault");
  decl->add_arg<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setStyleHint_4284 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFont::StyleHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::StyleHint>::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFont::StyleStrategy>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > () : (const qt_gsi::Converter<QFont::StyleStrategy>::target_type &)(qt_gsi::CppToQtReadAdaptor<QFont::StyleStrategy>(heap, QFont::PreferDefault));
  ((QFont *)cls)->setStyleHint (qt_gsi::QtToCppAdaptor<QFont::StyleHint>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFont::StyleStrategy>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setStyleHint_4284 ()
{
  return new qt_gsi::GenericMethod ("setStyleHint", "@brief Method void QFont::setStyleHint(QFont::StyleHint, QFont::StyleStrategy)\n", false, &_init_f_setStyleHint_4284, &_call_f_setStyleHint_4284);
}

// void QFont::setStyleStrategy(QFont::StyleStrategy s)


static void _init_f_setStyleStrategy_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyleStrategy_2420 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFont::StyleStrategy>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > ();
  ((QFont *)cls)->setStyleStrategy (qt_gsi::QtToCppAdaptor<QFont::StyleStrategy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setStyleStrategy_2420 ()
{
  return new qt_gsi::GenericMethod ("setStyleStrategy|styleStrategy=", "@brief Method void QFont::setStyleStrategy(QFont::StyleStrategy s)\n", false, &_init_f_setStyleStrategy_2420, &_call_f_setStyleStrategy_2420);
}

// void QFont::setUnderline(bool)


static void _init_f_setUnderline_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUnderline_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFont *)cls)->setUnderline (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUnderline_864 ()
{
  return new qt_gsi::GenericMethod ("setUnderline|underline=", "@brief Method void QFont::setUnderline(bool)\n", false, &_init_f_setUnderline_864, &_call_f_setUnderline_864);
}

// void QFont::setWeight(int)


static void _init_f_setWeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWeight_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QFont *)cls)->setWeight (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWeight_767 ()
{
  return new qt_gsi::GenericMethod ("setWeight|weight=", "@brief Method void QFont::setWeight(int)\n", false, &_init_f_setWeight_767, &_call_f_setWeight_767);
}

// void QFont::setWordSpacing(double spacing)


static void _init_f_setWordSpacing_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWordSpacing_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QFont *)cls)->setWordSpacing (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWordSpacing_1071 ()
{
  return new qt_gsi::GenericMethod ("setWordSpacing|wordSpacing=", "@brief Method void QFont::setWordSpacing(double spacing)\n", false, &_init_f_setWordSpacing_1071, &_call_f_setWordSpacing_1071);
}

// int QFont::stretch()


static void _init_f_stretch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_stretch_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFont *)cls)->stretch ());
}

static qt_gsi::GenericMethod *_create_f_stretch_c0 ()
{
  return new qt_gsi::GenericMethod (":stretch", "@brief Method int QFont::stretch()\n", true, &_init_f_stretch_c0, &_call_f_stretch_c0);
}

// bool QFont::strikeOut()


static void _init_f_strikeOut_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_strikeOut_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFont *)cls)->strikeOut ());
}

static qt_gsi::GenericMethod *_create_f_strikeOut_c0 ()
{
  return new qt_gsi::GenericMethod (":strikeOut", "@brief Method bool QFont::strikeOut()\n", true, &_init_f_strikeOut_c0, &_call_f_strikeOut_c0);
}

// QFont::Style QFont::style()


static void _init_f_style_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::Style>::target_type > ();
}

static void _call_f_style_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFont::Style>::target_type > ((qt_gsi::Converter<QFont::Style>::target_type)qt_gsi::CppToQtAdaptor<QFont::Style>(((QFont *)cls)->style ()));
}

static qt_gsi::GenericMethod *_create_f_style_c0 ()
{
  return new qt_gsi::GenericMethod (":style", "@brief Method QFont::Style QFont::style()\n", true, &_init_f_style_c0, &_call_f_style_c0);
}

// QFont::StyleHint QFont::styleHint()


static void _init_f_styleHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::StyleHint>::target_type > ();
}

static void _call_f_styleHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFont::StyleHint>::target_type > ((qt_gsi::Converter<QFont::StyleHint>::target_type)qt_gsi::CppToQtAdaptor<QFont::StyleHint>(((QFont *)cls)->styleHint ()));
}

static qt_gsi::GenericMethod *_create_f_styleHint_c0 ()
{
  return new qt_gsi::GenericMethod (":styleHint", "@brief Method QFont::StyleHint QFont::styleHint()\n", true, &_init_f_styleHint_c0, &_call_f_styleHint_c0);
}

// QFont::StyleStrategy QFont::styleStrategy()


static void _init_f_styleStrategy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::StyleStrategy>::target_type > ();
}

static void _call_f_styleStrategy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFont::StyleStrategy>::target_type > ((qt_gsi::Converter<QFont::StyleStrategy>::target_type)qt_gsi::CppToQtAdaptor<QFont::StyleStrategy>(((QFont *)cls)->styleStrategy ()));
}

static qt_gsi::GenericMethod *_create_f_styleStrategy_c0 ()
{
  return new qt_gsi::GenericMethod (":styleStrategy", "@brief Method QFont::StyleStrategy QFont::styleStrategy()\n", true, &_init_f_styleStrategy_c0, &_call_f_styleStrategy_c0);
}

// QString QFont::toString()


static void _init_f_toString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFont *)cls)->toString ());
}

static qt_gsi::GenericMethod *_create_f_toString_c0 ()
{
  return new qt_gsi::GenericMethod ("toString|to_s", "@brief Method QString QFont::toString()\n", true, &_init_f_toString_c0, &_call_f_toString_c0);
}

// bool QFont::underline()


static void _init_f_underline_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_underline_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFont *)cls)->underline ());
}

static qt_gsi::GenericMethod *_create_f_underline_c0 ()
{
  return new qt_gsi::GenericMethod (":underline", "@brief Method bool QFont::underline()\n", true, &_init_f_underline_c0, &_call_f_underline_c0);
}

// int QFont::weight()


static void _init_f_weight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_weight_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFont *)cls)->weight ());
}

static qt_gsi::GenericMethod *_create_f_weight_c0 ()
{
  return new qt_gsi::GenericMethod (":weight", "@brief Method int QFont::weight()\n", true, &_init_f_weight_c0, &_call_f_weight_c0);
}

// double QFont::wordSpacing()


static void _init_f_wordSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_wordSpacing_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QFont *)cls)->wordSpacing ());
}

static qt_gsi::GenericMethod *_create_f_wordSpacing_c0 ()
{
  return new qt_gsi::GenericMethod (":wordSpacing", "@brief Method double QFont::wordSpacing()\n", true, &_init_f_wordSpacing_c0, &_call_f_wordSpacing_c0);
}

// static void QFont::cacheStatistics()


static void _init_f_cacheStatistics_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cacheStatistics_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFont::cacheStatistics ();
}

static qt_gsi::GenericStaticMethod *_create_f_cacheStatistics_0 ()
{
  return new qt_gsi::GenericStaticMethod ("cacheStatistics", "@brief Static method void QFont::cacheStatistics()\nThis method is static and can be called without an instance.", &_init_f_cacheStatistics_0, &_call_f_cacheStatistics_0);
}

// static void QFont::cleanup()


static void _init_f_cleanup_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cleanup_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFont::cleanup ();
}

static qt_gsi::GenericStaticMethod *_create_f_cleanup_0 ()
{
  return new qt_gsi::GenericStaticMethod ("cleanup", "@brief Static method void QFont::cleanup()\nThis method is static and can be called without an instance.", &_init_f_cleanup_0, &_call_f_cleanup_0);
}

// static void QFont::insertSubstitution(const QString &, const QString &)


static void _init_f_insertSubstitution_3942 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertSubstitution_3942 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  QFont::insertSubstitution (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_insertSubstitution_3942 ()
{
  return new qt_gsi::GenericStaticMethod ("insertSubstitution", "@brief Static method void QFont::insertSubstitution(const QString &, const QString &)\nThis method is static and can be called without an instance.", &_init_f_insertSubstitution_3942, &_call_f_insertSubstitution_3942);
}

// static void QFont::insertSubstitutions(const QString &, const QStringList &)


static void _init_f_insertSubstitutions_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertSubstitutions_4354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QStringList>::target_type & arg2 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  QFont::insertSubstitutions (arg1, qt_gsi::QtToCppAdaptor<QStringList>(arg2).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_insertSubstitutions_4354 ()
{
  return new qt_gsi::GenericStaticMethod ("insertSubstitutions", "@brief Static method void QFont::insertSubstitutions(const QString &, const QStringList &)\nThis method is static and can be called without an instance.", &_init_f_insertSubstitutions_4354, &_call_f_insertSubstitutions_4354);
}

// static void QFont::removeSubstitution(const QString &)


static void _init_f_removeSubstitution_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeSubstitution_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QFont::removeSubstitution (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_removeSubstitution_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("removeSubstitution", "@brief Static method void QFont::removeSubstitution(const QString &)\nThis method is static and can be called without an instance.", &_init_f_removeSubstitution_2025, &_call_f_removeSubstitution_2025);
}

// static QString QFont::substitute(const QString &)


static void _init_f_substitute_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_substitute_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QString > ((QString)QFont::substitute (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_substitute_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("substitute", "@brief Static method QString QFont::substitute(const QString &)\nThis method is static and can be called without an instance.", &_init_f_substitute_2025, &_call_f_substitute_2025);
}

// static QStringList QFont::substitutes(const QString &)


static void _init_f_substitutes_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_substitutes_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QFont::substitutes (arg1)));
}

static qt_gsi::GenericStaticMethod *_create_f_substitutes_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("substitutes", "@brief Static method QStringList QFont::substitutes(const QString &)\nThis method is static and can be called without an instance.", &_init_f_substitutes_2025, &_call_f_substitutes_2025);
}

// static QStringList QFont::substitutions()


static void _init_f_substitutions_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_substitutions_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QFont::substitutions ()));
}

static qt_gsi::GenericStaticMethod *_create_f_substitutions_0 ()
{
  return new qt_gsi::GenericStaticMethod ("substitutions", "@brief Static method QStringList QFont::substitutions()\nThis method is static and can be called without an instance.", &_init_f_substitutions_0, &_call_f_substitutions_0);
}


namespace gsi
{
gsi::Class<QFont> decl_QFont ("QFont",
  gsi::method("Light", &font_const_light, "@brief Font weight constant 'QFont::Light'.") +
  gsi::method("Normal", &font_const_normal, "@brief Font weight constant 'QFont::Normal'.") +
  gsi::method("DemiBold", &font_const_demibold, "@brief Font weight constant 'QFont::DemiBold'.") +
  gsi::method("Bold", &font_const_bold, "@brief Font weight constant 'QFont::Bold'.") +
  gsi::method("Black", &font_const_black, "@brief Font weight constant 'QFont::Black'.")
+
  gsi::Methods(_create_ctor_QFont_0 ()) +
  gsi::Methods(_create_ctor_QFont_4099 ()) +
  gsi::Methods(_create_ctor_QFont_3496 ()) +
  gsi::Methods(_create_ctor_QFont_1801 ()) +
  gsi::Methods(_create_f_bold_c0 ()) +
  gsi::Methods(_create_f_capitalization_c0 ()) +
  gsi::Methods(_create_f_defaultFamily_c0 ()) +
  gsi::Methods(_create_f_exactMatch_c0 ()) +
  gsi::Methods(_create_f_family_c0 ()) +
  gsi::Methods(_create_f_fixedPitch_c0 ()) +
  gsi::Methods(_create_f_fromString_2025 ()) +
  gsi::Methods(_create_f_handle_c0 ()) +
  gsi::Methods(_create_f_isCopyOf_c1801 ()) +
  gsi::Methods(_create_f_italic_c0 ()) +
  gsi::Methods(_create_f_kerning_c0 ()) +
  gsi::Methods(_create_f_key_c0 ()) +
  gsi::Methods(_create_f_lastResortFamily_c0 ()) +
  gsi::Methods(_create_f_lastResortFont_c0 ()) +
  gsi::Methods(_create_f_letterSpacing_c0 ()) +
  gsi::Methods(_create_f_letterSpacingType_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c1801 ()) +
  gsi::Methods(_create_f_operator_lt__c1801 ()) +
  gsi::Methods(_create_f_operator_eq__1801 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c1801 ()) +
  gsi::Methods(_create_f_overline_c0 ()) +
  gsi::Methods(_create_f_pixelSize_c0 ()) +
  gsi::Methods(_create_f_pointSize_c0 ()) +
  gsi::Methods(_create_f_pointSizeF_c0 ()) +
  gsi::Methods(_create_f_rawMode_c0 ()) +
  gsi::Methods(_create_f_rawName_c0 ()) +
  gsi::Methods(_create_f_resolve_c1801 ()) +
  gsi::Methods(_create_f_setBold_864 ()) +
  gsi::Methods(_create_f_setCapitalization_2508 ()) +
  gsi::Methods(_create_f_setFamily_2025 ()) +
  gsi::Methods(_create_f_setFixedPitch_864 ()) +
  gsi::Methods(_create_f_setItalic_864 ()) +
  gsi::Methods(_create_f_setKerning_864 ()) +
  gsi::Methods(_create_f_setLetterSpacing_3130 ()) +
  gsi::Methods(_create_f_setOverline_864 ()) +
  gsi::Methods(_create_f_setPixelSize_767 ()) +
  gsi::Methods(_create_f_setPointSize_767 ()) +
  gsi::Methods(_create_f_setPointSizeF_1071 ()) +
  gsi::Methods(_create_f_setRawMode_864 ()) +
  gsi::Methods(_create_f_setRawName_2025 ()) +
  gsi::Methods(_create_f_setStretch_767 ()) +
  gsi::Methods(_create_f_setStrikeOut_864 ()) +
  gsi::Methods(_create_f_setStyle_1569 ()) +
  gsi::Methods(_create_f_setStyleHint_4284 ()) +
  gsi::Methods(_create_f_setStyleStrategy_2420 ()) +
  gsi::Methods(_create_f_setUnderline_864 ()) +
  gsi::Methods(_create_f_setWeight_767 ()) +
  gsi::Methods(_create_f_setWordSpacing_1071 ()) +
  gsi::Methods(_create_f_stretch_c0 ()) +
  gsi::Methods(_create_f_strikeOut_c0 ()) +
  gsi::Methods(_create_f_style_c0 ()) +
  gsi::Methods(_create_f_styleHint_c0 ()) +
  gsi::Methods(_create_f_styleStrategy_c0 ()) +
  gsi::Methods(_create_f_toString_c0 ()) +
  gsi::Methods(_create_f_underline_c0 ()) +
  gsi::Methods(_create_f_weight_c0 ()) +
  gsi::Methods(_create_f_wordSpacing_c0 ()) +
  gsi::Methods(_create_f_cacheStatistics_0 ()) +
  gsi::Methods(_create_f_cleanup_0 ()) +
  gsi::Methods(_create_f_insertSubstitution_3942 ()) +
  gsi::Methods(_create_f_insertSubstitutions_4354 ()) +
  gsi::Methods(_create_f_removeSubstitution_2025 ()) +
  gsi::Methods(_create_f_substitute_2025 ()) +
  gsi::Methods(_create_f_substitutes_2025 ()) +
  gsi::Methods(_create_f_substitutions_0 ()),
  "@qt\n@brief Binding of QFont");

}


//  Implementation of the enum wrapper class for QFont::Capitalization
namespace qt_gsi
{

static QFont_Capitalization_Enum *c_1_QFont_Capitalization_Enum () { return new QFont_Capitalization_Enum (QFont::MixedCase); }
static QFont_Capitalization_Enum *c_2_QFont_Capitalization_Enum () { return new QFont_Capitalization_Enum (QFont::AllUppercase); }
static QFont_Capitalization_Enum *c_3_QFont_Capitalization_Enum () { return new QFont_Capitalization_Enum (QFont::AllLowercase); }
static QFont_Capitalization_Enum *c_4_QFont_Capitalization_Enum () { return new QFont_Capitalization_Enum (QFont::SmallCaps); }
static QFont_Capitalization_Enum *c_5_QFont_Capitalization_Enum () { return new QFont_Capitalization_Enum (QFont::Capitalize); }

static gsi::Methods mkdefs_QFont_Capitalization () {
  return
    gsi::constant ("MixedCase", &qt_gsi::c_1_QFont_Capitalization_Enum, "@brief Enum constant QFont::MixedCase") +
    gsi::constant ("AllUppercase", &qt_gsi::c_2_QFont_Capitalization_Enum, "@brief Enum constant QFont::AllUppercase") +
    gsi::constant ("AllLowercase", &qt_gsi::c_3_QFont_Capitalization_Enum, "@brief Enum constant QFont::AllLowercase") +
    gsi::constant ("SmallCaps", &qt_gsi::c_4_QFont_Capitalization_Enum, "@brief Enum constant QFont::SmallCaps") +
    gsi::constant ("Capitalize", &qt_gsi::c_5_QFont_Capitalization_Enum, "@brief Enum constant QFont::Capitalize");
}

static std::string to_s_QFont_Capitalization_Enum (const QFont_Capitalization_Enum *e)
{
  if (e->value () == QFont::MixedCase) { return tl::sprintf ("MixedCase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::AllUppercase) { return tl::sprintf ("AllUppercase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::AllLowercase) { return tl::sprintf ("AllLowercase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::SmallCaps) { return tl::sprintf ("SmallCaps (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::Capitalize) { return tl::sprintf ("Capitalize (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFont_Capitalization_Enum (const QFont_Capitalization_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFont_Capitalization_Enum *from_i_QFont_Capitalization_Enum (unsigned int i)
{
  return new QFont_Capitalization_Enum ((QFont::Capitalization) i);
}

static bool equalQFont_Capitalization_Enum (const QFont_Capitalization_Enum *e, QFont_Capitalization_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFont_Capitalization_Enum (const QFont_Capitalization_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFont_Capitalization_Enums oropQFont_Capitalization_Enums (const QFont_Capitalization_Enums *e, const QFont_Capitalization_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFont_Capitalization_Enums andopQFont_Capitalization_Enums (const QFont_Capitalization_Enums *e, const QFont_Capitalization_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFont_Capitalization_Enums xoropQFont_Capitalization_Enums (const QFont_Capitalization_Enums *e, const QFont_Capitalization_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFont_Capitalization_Enums (const QFont_Capitalization_Enums *e)
{
  std::string l;
  if (e->testFlag (QFont::MixedCase)) { if (!l.empty ()) l += "|"; l += "MixedCase"; }
  if (e->testFlag (QFont::AllUppercase)) { if (!l.empty ()) l += "|"; l += "AllUppercase"; }
  if (e->testFlag (QFont::AllLowercase)) { if (!l.empty ()) l += "|"; l += "AllLowercase"; }
  if (e->testFlag (QFont::SmallCaps)) { if (!l.empty ()) l += "|"; l += "SmallCaps"; }
  if (e->testFlag (QFont::Capitalize)) { if (!l.empty ()) l += "|"; l += "Capitalize"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFont_Capitalization_Enums (const QFont_Capitalization_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFont_Capitalization_Enums (const QFont_Capitalization_Enums *e, const QFont_Capitalization_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFont_Capitalization_Enums> decl_QFont_Capitalization_Enums ("QFont_QFlags_Capitalization",
  gsi::method_ext ("|", &qt_gsi::oropQFont_Capitalization_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFont_Capitalization_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFont_Capitalization_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_Capitalization_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_Capitalization_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFont_Capitalization_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFont::Capitalization> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFont_Capitalization_Enum> decl_QFont_Capitalization_Enum (decl_QFont_Capitalization_Enums, "QFont_Capitalization",
  qt_gsi::mkdefs_QFont_Capitalization () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_Capitalization_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_Capitalization_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFont_Capitalization_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFont_Capitalization_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFont_Capitalization_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFont::Capitalization enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_Capitalization_Enum_in_parent (qt_gsi::mkdefs_QFont_Capitalization ());
static gsi::ClassExt<QFont> decl_QFont_Capitalization_Enum_as_child (decl_QFont_Capitalization_Enum, "Capitalization");

}


//  Implementation of the enum wrapper class for QFont::SpacingType
namespace qt_gsi
{

static QFont_SpacingType_Enum *c_1_QFont_SpacingType_Enum () { return new QFont_SpacingType_Enum (QFont::PercentageSpacing); }
static QFont_SpacingType_Enum *c_2_QFont_SpacingType_Enum () { return new QFont_SpacingType_Enum (QFont::AbsoluteSpacing); }

static gsi::Methods mkdefs_QFont_SpacingType () {
  return
    gsi::constant ("PercentageSpacing", &qt_gsi::c_1_QFont_SpacingType_Enum, "@brief Enum constant QFont::PercentageSpacing") +
    gsi::constant ("AbsoluteSpacing", &qt_gsi::c_2_QFont_SpacingType_Enum, "@brief Enum constant QFont::AbsoluteSpacing");
}

static std::string to_s_QFont_SpacingType_Enum (const QFont_SpacingType_Enum *e)
{
  if (e->value () == QFont::PercentageSpacing) { return tl::sprintf ("PercentageSpacing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::AbsoluteSpacing) { return tl::sprintf ("AbsoluteSpacing (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFont_SpacingType_Enum (const QFont_SpacingType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFont_SpacingType_Enum *from_i_QFont_SpacingType_Enum (unsigned int i)
{
  return new QFont_SpacingType_Enum ((QFont::SpacingType) i);
}

static bool equalQFont_SpacingType_Enum (const QFont_SpacingType_Enum *e, QFont_SpacingType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFont_SpacingType_Enum (const QFont_SpacingType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFont_SpacingType_Enums oropQFont_SpacingType_Enums (const QFont_SpacingType_Enums *e, const QFont_SpacingType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFont_SpacingType_Enums andopQFont_SpacingType_Enums (const QFont_SpacingType_Enums *e, const QFont_SpacingType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFont_SpacingType_Enums xoropQFont_SpacingType_Enums (const QFont_SpacingType_Enums *e, const QFont_SpacingType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFont_SpacingType_Enums (const QFont_SpacingType_Enums *e)
{
  std::string l;
  if (e->testFlag (QFont::PercentageSpacing)) { if (!l.empty ()) l += "|"; l += "PercentageSpacing"; }
  if (e->testFlag (QFont::AbsoluteSpacing)) { if (!l.empty ()) l += "|"; l += "AbsoluteSpacing"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFont_SpacingType_Enums (const QFont_SpacingType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFont_SpacingType_Enums (const QFont_SpacingType_Enums *e, const QFont_SpacingType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFont_SpacingType_Enums> decl_QFont_SpacingType_Enums ("QFont_QFlags_SpacingType",
  gsi::method_ext ("|", &qt_gsi::oropQFont_SpacingType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFont_SpacingType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFont_SpacingType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_SpacingType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_SpacingType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFont_SpacingType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFont::SpacingType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFont_SpacingType_Enum> decl_QFont_SpacingType_Enum (decl_QFont_SpacingType_Enums, "QFont_SpacingType",
  qt_gsi::mkdefs_QFont_SpacingType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_SpacingType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_SpacingType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFont_SpacingType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFont_SpacingType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFont_SpacingType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFont::SpacingType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_SpacingType_Enum_in_parent (qt_gsi::mkdefs_QFont_SpacingType ());
static gsi::ClassExt<QFont> decl_QFont_SpacingType_Enum_as_child (decl_QFont_SpacingType_Enum, "SpacingType");

}


//  Implementation of the enum wrapper class for QFont::Style
namespace qt_gsi
{

static QFont_Style_Enum *c_1_QFont_Style_Enum () { return new QFont_Style_Enum (QFont::StyleNormal); }
static QFont_Style_Enum *c_2_QFont_Style_Enum () { return new QFont_Style_Enum (QFont::StyleItalic); }
static QFont_Style_Enum *c_3_QFont_Style_Enum () { return new QFont_Style_Enum (QFont::StyleOblique); }

static gsi::Methods mkdefs_QFont_Style () {
  return
    gsi::constant ("StyleNormal", &qt_gsi::c_1_QFont_Style_Enum, "@brief Enum constant QFont::StyleNormal") +
    gsi::constant ("StyleItalic", &qt_gsi::c_2_QFont_Style_Enum, "@brief Enum constant QFont::StyleItalic") +
    gsi::constant ("StyleOblique", &qt_gsi::c_3_QFont_Style_Enum, "@brief Enum constant QFont::StyleOblique");
}

static std::string to_s_QFont_Style_Enum (const QFont_Style_Enum *e)
{
  if (e->value () == QFont::StyleNormal) { return tl::sprintf ("StyleNormal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::StyleItalic) { return tl::sprintf ("StyleItalic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::StyleOblique) { return tl::sprintf ("StyleOblique (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFont_Style_Enum (const QFont_Style_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFont_Style_Enum *from_i_QFont_Style_Enum (unsigned int i)
{
  return new QFont_Style_Enum ((QFont::Style) i);
}

static bool equalQFont_Style_Enum (const QFont_Style_Enum *e, QFont_Style_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFont_Style_Enum (const QFont_Style_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFont_Style_Enums oropQFont_Style_Enums (const QFont_Style_Enums *e, const QFont_Style_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFont_Style_Enums andopQFont_Style_Enums (const QFont_Style_Enums *e, const QFont_Style_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFont_Style_Enums xoropQFont_Style_Enums (const QFont_Style_Enums *e, const QFont_Style_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFont_Style_Enums (const QFont_Style_Enums *e)
{
  std::string l;
  if (e->testFlag (QFont::StyleNormal)) { if (!l.empty ()) l += "|"; l += "StyleNormal"; }
  if (e->testFlag (QFont::StyleItalic)) { if (!l.empty ()) l += "|"; l += "StyleItalic"; }
  if (e->testFlag (QFont::StyleOblique)) { if (!l.empty ()) l += "|"; l += "StyleOblique"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFont_Style_Enums (const QFont_Style_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFont_Style_Enums (const QFont_Style_Enums *e, const QFont_Style_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFont_Style_Enums> decl_QFont_Style_Enums ("QFont_QFlags_Style",
  gsi::method_ext ("|", &qt_gsi::oropQFont_Style_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFont_Style_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFont_Style_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_Style_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_Style_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFont_Style_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFont::Style> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFont_Style_Enum> decl_QFont_Style_Enum (decl_QFont_Style_Enums, "QFont_Style",
  qt_gsi::mkdefs_QFont_Style () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_Style_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_Style_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFont_Style_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFont_Style_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFont_Style_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFont::Style enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_Style_Enum_in_parent (qt_gsi::mkdefs_QFont_Style ());
static gsi::ClassExt<QFont> decl_QFont_Style_Enum_as_child (decl_QFont_Style_Enum, "Style");

}


//  Implementation of the enum wrapper class for QFont::StyleHint
namespace qt_gsi
{

static QFont_StyleHint_Enum *c_1_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::Helvetica); }
static QFont_StyleHint_Enum *c_2_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::SansSerif); }
static QFont_StyleHint_Enum *c_3_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::Times); }
static QFont_StyleHint_Enum *c_4_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::Serif); }
static QFont_StyleHint_Enum *c_5_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::Courier); }
static QFont_StyleHint_Enum *c_6_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::TypeWriter); }
static QFont_StyleHint_Enum *c_7_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::OldEnglish); }
static QFont_StyleHint_Enum *c_8_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::Decorative); }
static QFont_StyleHint_Enum *c_9_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::System); }
static QFont_StyleHint_Enum *c_10_QFont_StyleHint_Enum () { return new QFont_StyleHint_Enum (QFont::AnyStyle); }

static gsi::Methods mkdefs_QFont_StyleHint () {
  return
    gsi::constant ("Helvetica", &qt_gsi::c_1_QFont_StyleHint_Enum, "@brief Enum constant QFont::Helvetica") +
    gsi::constant ("SansSerif", &qt_gsi::c_2_QFont_StyleHint_Enum, "@brief Enum constant QFont::SansSerif") +
    gsi::constant ("Times", &qt_gsi::c_3_QFont_StyleHint_Enum, "@brief Enum constant QFont::Times") +
    gsi::constant ("Serif", &qt_gsi::c_4_QFont_StyleHint_Enum, "@brief Enum constant QFont::Serif") +
    gsi::constant ("Courier", &qt_gsi::c_5_QFont_StyleHint_Enum, "@brief Enum constant QFont::Courier") +
    gsi::constant ("TypeWriter", &qt_gsi::c_6_QFont_StyleHint_Enum, "@brief Enum constant QFont::TypeWriter") +
    gsi::constant ("OldEnglish", &qt_gsi::c_7_QFont_StyleHint_Enum, "@brief Enum constant QFont::OldEnglish") +
    gsi::constant ("Decorative", &qt_gsi::c_8_QFont_StyleHint_Enum, "@brief Enum constant QFont::Decorative") +
    gsi::constant ("System", &qt_gsi::c_9_QFont_StyleHint_Enum, "@brief Enum constant QFont::System") +
    gsi::constant ("AnyStyle", &qt_gsi::c_10_QFont_StyleHint_Enum, "@brief Enum constant QFont::AnyStyle");
}

static std::string to_s_QFont_StyleHint_Enum (const QFont_StyleHint_Enum *e)
{
  if (e->value () == QFont::Helvetica) { return tl::sprintf ("Helvetica (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::SansSerif) { return tl::sprintf ("SansSerif (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::Times) { return tl::sprintf ("Times (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::Serif) { return tl::sprintf ("Serif (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::Courier) { return tl::sprintf ("Courier (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::TypeWriter) { return tl::sprintf ("TypeWriter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::OldEnglish) { return tl::sprintf ("OldEnglish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::Decorative) { return tl::sprintf ("Decorative (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::System) { return tl::sprintf ("System (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::AnyStyle) { return tl::sprintf ("AnyStyle (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFont_StyleHint_Enum (const QFont_StyleHint_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFont_StyleHint_Enum *from_i_QFont_StyleHint_Enum (unsigned int i)
{
  return new QFont_StyleHint_Enum ((QFont::StyleHint) i);
}

static bool equalQFont_StyleHint_Enum (const QFont_StyleHint_Enum *e, QFont_StyleHint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFont_StyleHint_Enum (const QFont_StyleHint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFont_StyleHint_Enums oropQFont_StyleHint_Enums (const QFont_StyleHint_Enums *e, const QFont_StyleHint_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFont_StyleHint_Enums andopQFont_StyleHint_Enums (const QFont_StyleHint_Enums *e, const QFont_StyleHint_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFont_StyleHint_Enums xoropQFont_StyleHint_Enums (const QFont_StyleHint_Enums *e, const QFont_StyleHint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFont_StyleHint_Enums (const QFont_StyleHint_Enums *e)
{
  std::string l;
  if (e->testFlag (QFont::Helvetica)) { if (!l.empty ()) l += "|"; l += "Helvetica"; }
  if (e->testFlag (QFont::SansSerif)) { if (!l.empty ()) l += "|"; l += "SansSerif"; }
  if (e->testFlag (QFont::Times)) { if (!l.empty ()) l += "|"; l += "Times"; }
  if (e->testFlag (QFont::Serif)) { if (!l.empty ()) l += "|"; l += "Serif"; }
  if (e->testFlag (QFont::Courier)) { if (!l.empty ()) l += "|"; l += "Courier"; }
  if (e->testFlag (QFont::TypeWriter)) { if (!l.empty ()) l += "|"; l += "TypeWriter"; }
  if (e->testFlag (QFont::OldEnglish)) { if (!l.empty ()) l += "|"; l += "OldEnglish"; }
  if (e->testFlag (QFont::Decorative)) { if (!l.empty ()) l += "|"; l += "Decorative"; }
  if (e->testFlag (QFont::System)) { if (!l.empty ()) l += "|"; l += "System"; }
  if (e->testFlag (QFont::AnyStyle)) { if (!l.empty ()) l += "|"; l += "AnyStyle"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFont_StyleHint_Enums (const QFont_StyleHint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFont_StyleHint_Enums (const QFont_StyleHint_Enums *e, const QFont_StyleHint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFont_StyleHint_Enums> decl_QFont_StyleHint_Enums ("QFont_QFlags_StyleHint",
  gsi::method_ext ("|", &qt_gsi::oropQFont_StyleHint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFont_StyleHint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFont_StyleHint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_StyleHint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_StyleHint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFont_StyleHint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFont::StyleHint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFont_StyleHint_Enum> decl_QFont_StyleHint_Enum (decl_QFont_StyleHint_Enums, "QFont_StyleHint",
  qt_gsi::mkdefs_QFont_StyleHint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_StyleHint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_StyleHint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFont_StyleHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFont_StyleHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFont_StyleHint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFont::StyleHint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_StyleHint_Enum_in_parent (qt_gsi::mkdefs_QFont_StyleHint ());
static gsi::ClassExt<QFont> decl_QFont_StyleHint_Enum_as_child (decl_QFont_StyleHint_Enum, "StyleHint");

}


//  Implementation of the enum wrapper class for QFont::StyleStrategy
namespace qt_gsi
{

static QFont_StyleStrategy_Enum *c_1_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::PreferDefault); }
static QFont_StyleStrategy_Enum *c_2_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::PreferBitmap); }
static QFont_StyleStrategy_Enum *c_3_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::PreferDevice); }
static QFont_StyleStrategy_Enum *c_4_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::PreferOutline); }
static QFont_StyleStrategy_Enum *c_5_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::ForceOutline); }
static QFont_StyleStrategy_Enum *c_6_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::PreferMatch); }
static QFont_StyleStrategy_Enum *c_7_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::PreferQuality); }
static QFont_StyleStrategy_Enum *c_8_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::PreferAntialias); }
static QFont_StyleStrategy_Enum *c_9_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::NoAntialias); }
static QFont_StyleStrategy_Enum *c_10_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::OpenGLCompatible); }
static QFont_StyleStrategy_Enum *c_11_QFont_StyleStrategy_Enum () { return new QFont_StyleStrategy_Enum (QFont::NoFontMerging); }

static gsi::Methods mkdefs_QFont_StyleStrategy () {
  return
    gsi::constant ("PreferDefault", &qt_gsi::c_1_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::PreferDefault") +
    gsi::constant ("PreferBitmap", &qt_gsi::c_2_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::PreferBitmap") +
    gsi::constant ("PreferDevice", &qt_gsi::c_3_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::PreferDevice") +
    gsi::constant ("PreferOutline", &qt_gsi::c_4_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::PreferOutline") +
    gsi::constant ("ForceOutline", &qt_gsi::c_5_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::ForceOutline") +
    gsi::constant ("PreferMatch", &qt_gsi::c_6_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::PreferMatch") +
    gsi::constant ("PreferQuality", &qt_gsi::c_7_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::PreferQuality") +
    gsi::constant ("PreferAntialias", &qt_gsi::c_8_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::PreferAntialias") +
    gsi::constant ("NoAntialias", &qt_gsi::c_9_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::NoAntialias") +
    gsi::constant ("OpenGLCompatible", &qt_gsi::c_10_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::OpenGLCompatible") +
    gsi::constant ("NoFontMerging", &qt_gsi::c_11_QFont_StyleStrategy_Enum, "@brief Enum constant QFont::NoFontMerging");
}

static std::string to_s_QFont_StyleStrategy_Enum (const QFont_StyleStrategy_Enum *e)
{
  if (e->value () == QFont::PreferDefault) { return tl::sprintf ("PreferDefault (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::PreferBitmap) { return tl::sprintf ("PreferBitmap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::PreferDevice) { return tl::sprintf ("PreferDevice (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::PreferOutline) { return tl::sprintf ("PreferOutline (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::ForceOutline) { return tl::sprintf ("ForceOutline (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::PreferMatch) { return tl::sprintf ("PreferMatch (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::PreferQuality) { return tl::sprintf ("PreferQuality (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::PreferAntialias) { return tl::sprintf ("PreferAntialias (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::NoAntialias) { return tl::sprintf ("NoAntialias (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::OpenGLCompatible) { return tl::sprintf ("OpenGLCompatible (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFont::NoFontMerging) { return tl::sprintf ("NoFontMerging (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFont_StyleStrategy_Enum (const QFont_StyleStrategy_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFont_StyleStrategy_Enum *from_i_QFont_StyleStrategy_Enum (unsigned int i)
{
  return new QFont_StyleStrategy_Enum ((QFont::StyleStrategy) i);
}

static bool equalQFont_StyleStrategy_Enum (const QFont_StyleStrategy_Enum *e, QFont_StyleStrategy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFont_StyleStrategy_Enum (const QFont_StyleStrategy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFont_StyleStrategy_Enums oropQFont_StyleStrategy_Enums (const QFont_StyleStrategy_Enums *e, const QFont_StyleStrategy_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFont_StyleStrategy_Enums andopQFont_StyleStrategy_Enums (const QFont_StyleStrategy_Enums *e, const QFont_StyleStrategy_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFont_StyleStrategy_Enums xoropQFont_StyleStrategy_Enums (const QFont_StyleStrategy_Enums *e, const QFont_StyleStrategy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFont_StyleStrategy_Enums (const QFont_StyleStrategy_Enums *e)
{
  std::string l;
  if (e->testFlag (QFont::PreferDefault)) { if (!l.empty ()) l += "|"; l += "PreferDefault"; }
  if (e->testFlag (QFont::PreferBitmap)) { if (!l.empty ()) l += "|"; l += "PreferBitmap"; }
  if (e->testFlag (QFont::PreferDevice)) { if (!l.empty ()) l += "|"; l += "PreferDevice"; }
  if (e->testFlag (QFont::PreferOutline)) { if (!l.empty ()) l += "|"; l += "PreferOutline"; }
  if (e->testFlag (QFont::ForceOutline)) { if (!l.empty ()) l += "|"; l += "ForceOutline"; }
  if (e->testFlag (QFont::PreferMatch)) { if (!l.empty ()) l += "|"; l += "PreferMatch"; }
  if (e->testFlag (QFont::PreferQuality)) { if (!l.empty ()) l += "|"; l += "PreferQuality"; }
  if (e->testFlag (QFont::PreferAntialias)) { if (!l.empty ()) l += "|"; l += "PreferAntialias"; }
  if (e->testFlag (QFont::NoAntialias)) { if (!l.empty ()) l += "|"; l += "NoAntialias"; }
  if (e->testFlag (QFont::OpenGLCompatible)) { if (!l.empty ()) l += "|"; l += "OpenGLCompatible"; }
  if (e->testFlag (QFont::NoFontMerging)) { if (!l.empty ()) l += "|"; l += "NoFontMerging"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFont_StyleStrategy_Enums (const QFont_StyleStrategy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFont_StyleStrategy_Enums (const QFont_StyleStrategy_Enums *e, const QFont_StyleStrategy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFont_StyleStrategy_Enums> decl_QFont_StyleStrategy_Enums ("QFont_QFlags_StyleStrategy",
  gsi::method_ext ("|", &qt_gsi::oropQFont_StyleStrategy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFont_StyleStrategy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFont_StyleStrategy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_StyleStrategy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_StyleStrategy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFont_StyleStrategy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFont::StyleStrategy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFont_StyleStrategy_Enum> decl_QFont_StyleStrategy_Enum (decl_QFont_StyleStrategy_Enums, "QFont_StyleStrategy",
  qt_gsi::mkdefs_QFont_StyleStrategy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFont_StyleStrategy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFont_StyleStrategy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFont_StyleStrategy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFont_StyleStrategy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFont_StyleStrategy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFont::StyleStrategy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFont> inject_QFont_StyleStrategy_Enum_in_parent (qt_gsi::mkdefs_QFont_StyleStrategy ());
static gsi::ClassExt<QFont> decl_QFont_StyleStrategy_Enum_as_child (decl_QFont_StyleStrategy_Enum, "StyleStrategy");

}

