
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFileIconProvider.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQFileIconProvider_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFileIconProvider

// QIcon QFileIconProvider::icon(QFileIconProvider::IconType type)


static void _init_f_icon_c3064 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QFileIconProvider::IconType>::target_type & > (argspec_0);
  decl->set_return<QIcon > ();
}

static void _call_f_icon_c3064 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFileIconProvider::IconType>::target_type & arg1 = args.read<const qt_gsi::Converter<QFileIconProvider::IconType>::target_type & > ();
  ret.write<QIcon > ((QIcon)((QFileIconProvider *)cls)->icon (qt_gsi::QtToCppAdaptor<QFileIconProvider::IconType>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_icon_c3064 ()
{
  return new qt_gsi::GenericMethod ("icon", "@brief Method QIcon QFileIconProvider::icon(QFileIconProvider::IconType type)\n", true, &_init_f_icon_c3064, &_call_f_icon_c3064);
}

// QIcon QFileIconProvider::icon(const QFileInfo &info)


static void _init_f_icon_c2174 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("info");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return<QIcon > ();
}

static void _call_f_icon_c2174 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<QIcon > ((QIcon)((QFileIconProvider *)cls)->icon (arg1));
}

static qt_gsi::GenericMethod *_create_f_icon_c2174 ()
{
  return new qt_gsi::GenericMethod ("icon", "@brief Method QIcon QFileIconProvider::icon(const QFileInfo &info)\n", true, &_init_f_icon_c2174, &_call_f_icon_c2174);
}

// QString QFileIconProvider::type(const QFileInfo &info)


static void _init_f_type_c2174 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("info");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_type_c2174 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<QString > ((QString)((QFileIconProvider *)cls)->type (arg1));
}

static qt_gsi::GenericMethod *_create_f_type_c2174 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method QString QFileIconProvider::type(const QFileInfo &info)\n", true, &_init_f_type_c2174, &_call_f_type_c2174);
}

namespace gsi
{
gsi::Class<QFileIconProvider> decl_QFileIconProvider ("QFileIconProvider_Native",
  gsi::Methods(_create_f_icon_c3064 ()) +
  gsi::Methods(_create_f_icon_c2174 ()) +
  gsi::Methods(_create_f_type_c2174 ()),
  "@hide\n@alias QFileIconProvider");
}


class QFileIconProvider_Adaptor : public QFileIconProvider, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFileIconProvider_Adaptor();

  //  [adaptor ctor] QFileIconProvider::QFileIconProvider()
  QFileIconProvider_Adaptor() : QFileIconProvider()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] QIcon QFileIconProvider::icon(QFileIconProvider::IconType type)
  QIcon cbs_icon_c3064_0(const qt_gsi::Converter<QFileIconProvider::IconType>::target_type & type) const
  {
    return QFileIconProvider::icon(qt_gsi::QtToCppAdaptor<QFileIconProvider::IconType>(type).cref());
  }

  virtual QIcon icon(QFileIconProvider::IconType type) const
  {
    if (cb_icon_c3064_0.can_issue()) {
      return cb_icon_c3064_0.issue<QFileIconProvider_Adaptor, QIcon, const qt_gsi::Converter<QFileIconProvider::IconType>::target_type &>(&QFileIconProvider_Adaptor::cbs_icon_c3064_0, qt_gsi::CppToQtAdaptor<QFileIconProvider::IconType>(type));
    } else {
      return QFileIconProvider::icon(type);
    }
  }

  //  [adaptor impl] QIcon QFileIconProvider::icon(const QFileInfo &info)
  QIcon cbs_icon_c2174_0(const QFileInfo &info) const
  {
    return QFileIconProvider::icon(info);
  }

  virtual QIcon icon(const QFileInfo &info) const
  {
    if (cb_icon_c2174_0.can_issue()) {
      return cb_icon_c2174_0.issue<QFileIconProvider_Adaptor, QIcon, const QFileInfo &>(&QFileIconProvider_Adaptor::cbs_icon_c2174_0, info);
    } else {
      return QFileIconProvider::icon(info);
    }
  }

  //  [adaptor impl] QString QFileIconProvider::type(const QFileInfo &info)
  QString cbs_type_c2174_0(const QFileInfo &info) const
  {
    return QFileIconProvider::type(info);
  }

  virtual QString type(const QFileInfo &info) const
  {
    if (cb_type_c2174_0.can_issue()) {
      return cb_type_c2174_0.issue<QFileIconProvider_Adaptor, QString, const QFileInfo &>(&QFileIconProvider_Adaptor::cbs_type_c2174_0, info);
    } else {
      return QFileIconProvider::type(info);
    }
  }

  gsi::Callback cb_icon_c3064_0;
  gsi::Callback cb_icon_c2174_0;
  gsi::Callback cb_type_c2174_0;
};

QFileIconProvider_Adaptor::~QFileIconProvider_Adaptor() { }

//  Constructor QFileIconProvider::QFileIconProvider() (adaptor class)

static void _init_ctor_QFileIconProvider_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QFileIconProvider_Adaptor *> ();
}

static void _call_ctor_QFileIconProvider_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFileIconProvider_Adaptor *> (new QFileIconProvider_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFileIconProvider_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileIconProvider::QFileIconProvider()\nThis method creates an object of class QFileIconProvider.", &_init_ctor_QFileIconProvider_Adaptor_0, &_call_ctor_QFileIconProvider_Adaptor_0);
}

// QIcon QFileIconProvider::icon(QFileIconProvider::IconType type)

static void _init_cbs_icon_c3064_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QFileIconProvider::IconType>::target_type & > (argspec_0);
  decl->set_return<QIcon > ();
}

static void _call_cbs_icon_c3064_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFileIconProvider::IconType>::target_type & arg1 = args.read<const qt_gsi::Converter<QFileIconProvider::IconType>::target_type & > ();
  ret.write<QIcon > ((QIcon)((QFileIconProvider_Adaptor *)cls)->cbs_icon_c3064_0 (arg1));
}

static void _set_callback_cbs_icon_c3064_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileIconProvider_Adaptor *)cls)->cb_icon_c3064_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_icon_c3064_0 ()
{
  return new qt_gsi::GenericMethod ("icon", "@hide", true, &_init_cbs_icon_c3064_0, &_call_cbs_icon_c3064_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_icon_c3064_0 ()
{
  return new qt_gsi::GenericMethod ("icon", "@brief Virtual method QIcon QFileIconProvider::icon(QFileIconProvider::IconType type)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_icon_c3064_0, &_call_cbs_icon_c3064_0, &_set_callback_cbs_icon_c3064_0);
}


// QIcon QFileIconProvider::icon(const QFileInfo &info)

static void _init_cbs_icon_c2174_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("info");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return<QIcon > ();
}

static void _call_cbs_icon_c2174_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<QIcon > ((QIcon)((QFileIconProvider_Adaptor *)cls)->cbs_icon_c2174_0 (arg1));
}

static void _set_callback_cbs_icon_c2174_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileIconProvider_Adaptor *)cls)->cb_icon_c2174_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_icon_c2174_0 ()
{
  return new qt_gsi::GenericMethod ("icon", "@hide", true, &_init_cbs_icon_c2174_0, &_call_cbs_icon_c2174_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_icon_c2174_0 ()
{
  return new qt_gsi::GenericMethod ("icon", "@brief Virtual method QIcon QFileIconProvider::icon(const QFileInfo &info)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_icon_c2174_0, &_call_cbs_icon_c2174_0, &_set_callback_cbs_icon_c2174_0);
}


// QString QFileIconProvider::type(const QFileInfo &info)

static void _init_cbs_type_c2174_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("info");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_cbs_type_c2174_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<QString > ((QString)((QFileIconProvider_Adaptor *)cls)->cbs_type_c2174_0 (arg1));
}

static void _set_callback_cbs_type_c2174_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileIconProvider_Adaptor *)cls)->cb_type_c2174_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_type_c2174_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c2174_0, &_call_cbs_type_c2174_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_type_c2174_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Virtual method QString QFileIconProvider::type(const QFileInfo &info)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c2174_0, &_call_cbs_type_c2174_0, &_set_callback_cbs_type_c2174_0);
}


namespace gsi
{

extern gsi::Class<QFileIconProvider> decl_QFileIconProvider;

gsi::Class<QFileIconProvider_Adaptor> decl_QFileIconProvider_Adaptor (decl_QFileIconProvider, "QFileIconProvider",
  gsi::Methods(_create_cbs_icon_c3064_0 ()) +
  gsi::Methods(_create_callback_cbs_icon_c3064_0 ()) +
  gsi::Methods(_create_cbs_icon_c2174_0 ()) +
  gsi::Methods(_create_callback_cbs_icon_c2174_0 ()) +
  gsi::Methods(_create_cbs_type_c2174_0 ()) +
  gsi::Methods(_create_callback_cbs_type_c2174_0 ()) +
  gsi::Methods(_create_ctor_QFileIconProvider_Adaptor_0 ()),
  "@qt\n@brief Binding of QFileIconProvider");

}


//  Implementation of the enum wrapper class for QFileIconProvider::IconType
namespace qt_gsi
{

static QFileIconProvider_IconType_Enum *c_1_QFileIconProvider_IconType_Enum () { return new QFileIconProvider_IconType_Enum (QFileIconProvider::Computer); }
static QFileIconProvider_IconType_Enum *c_2_QFileIconProvider_IconType_Enum () { return new QFileIconProvider_IconType_Enum (QFileIconProvider::Desktop); }
static QFileIconProvider_IconType_Enum *c_3_QFileIconProvider_IconType_Enum () { return new QFileIconProvider_IconType_Enum (QFileIconProvider::Trashcan); }
static QFileIconProvider_IconType_Enum *c_4_QFileIconProvider_IconType_Enum () { return new QFileIconProvider_IconType_Enum (QFileIconProvider::Network); }
static QFileIconProvider_IconType_Enum *c_5_QFileIconProvider_IconType_Enum () { return new QFileIconProvider_IconType_Enum (QFileIconProvider::Drive); }
static QFileIconProvider_IconType_Enum *c_6_QFileIconProvider_IconType_Enum () { return new QFileIconProvider_IconType_Enum (QFileIconProvider::Folder); }
static QFileIconProvider_IconType_Enum *c_7_QFileIconProvider_IconType_Enum () { return new QFileIconProvider_IconType_Enum (QFileIconProvider::File); }

static gsi::Methods mkdefs_QFileIconProvider_IconType () {
  return
    gsi::constant ("Computer", &qt_gsi::c_1_QFileIconProvider_IconType_Enum, "@brief Enum constant QFileIconProvider::Computer") +
    gsi::constant ("Desktop", &qt_gsi::c_2_QFileIconProvider_IconType_Enum, "@brief Enum constant QFileIconProvider::Desktop") +
    gsi::constant ("Trashcan", &qt_gsi::c_3_QFileIconProvider_IconType_Enum, "@brief Enum constant QFileIconProvider::Trashcan") +
    gsi::constant ("Network", &qt_gsi::c_4_QFileIconProvider_IconType_Enum, "@brief Enum constant QFileIconProvider::Network") +
    gsi::constant ("Drive", &qt_gsi::c_5_QFileIconProvider_IconType_Enum, "@brief Enum constant QFileIconProvider::Drive") +
    gsi::constant ("Folder", &qt_gsi::c_6_QFileIconProvider_IconType_Enum, "@brief Enum constant QFileIconProvider::Folder") +
    gsi::constant ("File", &qt_gsi::c_7_QFileIconProvider_IconType_Enum, "@brief Enum constant QFileIconProvider::File");
}

static std::string to_s_QFileIconProvider_IconType_Enum (const QFileIconProvider_IconType_Enum *e)
{
  if (e->value () == QFileIconProvider::Computer) { return tl::sprintf ("Computer (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileIconProvider::Desktop) { return tl::sprintf ("Desktop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileIconProvider::Trashcan) { return tl::sprintf ("Trashcan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileIconProvider::Network) { return tl::sprintf ("Network (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileIconProvider::Drive) { return tl::sprintf ("Drive (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileIconProvider::Folder) { return tl::sprintf ("Folder (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFileIconProvider::File) { return tl::sprintf ("File (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFileIconProvider_IconType_Enum (const QFileIconProvider_IconType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFileIconProvider_IconType_Enum *from_i_QFileIconProvider_IconType_Enum (unsigned int i)
{
  return new QFileIconProvider_IconType_Enum ((QFileIconProvider::IconType) i);
}

static bool equalQFileIconProvider_IconType_Enum (const QFileIconProvider_IconType_Enum *e, QFileIconProvider_IconType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFileIconProvider_IconType_Enum (const QFileIconProvider_IconType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFileIconProvider_IconType_Enums oropQFileIconProvider_IconType_Enums (const QFileIconProvider_IconType_Enums *e, const QFileIconProvider_IconType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFileIconProvider_IconType_Enums andopQFileIconProvider_IconType_Enums (const QFileIconProvider_IconType_Enums *e, const QFileIconProvider_IconType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFileIconProvider_IconType_Enums xoropQFileIconProvider_IconType_Enums (const QFileIconProvider_IconType_Enums *e, const QFileIconProvider_IconType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFileIconProvider_IconType_Enums (const QFileIconProvider_IconType_Enums *e)
{
  std::string l;
  if (e->testFlag (QFileIconProvider::Computer)) { if (!l.empty ()) l += "|"; l += "Computer"; }
  if (e->testFlag (QFileIconProvider::Desktop)) { if (!l.empty ()) l += "|"; l += "Desktop"; }
  if (e->testFlag (QFileIconProvider::Trashcan)) { if (!l.empty ()) l += "|"; l += "Trashcan"; }
  if (e->testFlag (QFileIconProvider::Network)) { if (!l.empty ()) l += "|"; l += "Network"; }
  if (e->testFlag (QFileIconProvider::Drive)) { if (!l.empty ()) l += "|"; l += "Drive"; }
  if (e->testFlag (QFileIconProvider::Folder)) { if (!l.empty ()) l += "|"; l += "Folder"; }
  if (e->testFlag (QFileIconProvider::File)) { if (!l.empty ()) l += "|"; l += "File"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFileIconProvider_IconType_Enums (const QFileIconProvider_IconType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFileIconProvider_IconType_Enums (const QFileIconProvider_IconType_Enums *e, const QFileIconProvider_IconType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFileIconProvider_IconType_Enums> decl_QFileIconProvider_IconType_Enums ("QFileIconProvider_QFlags_IconType",
  gsi::method_ext ("|", &qt_gsi::oropQFileIconProvider_IconType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFileIconProvider_IconType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFileIconProvider_IconType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileIconProvider_IconType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileIconProvider_IconType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFileIconProvider_IconType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFileIconProvider::IconType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFileIconProvider_IconType_Enum> decl_QFileIconProvider_IconType_Enum (decl_QFileIconProvider_IconType_Enums, "QFileIconProvider_IconType",
  qt_gsi::mkdefs_QFileIconProvider_IconType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFileIconProvider_IconType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFileIconProvider_IconType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFileIconProvider_IconType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFileIconProvider_IconType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFileIconProvider_IconType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFileIconProvider::IconType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileIconProvider> inject_QFileIconProvider_IconType_Enum_in_parent (qt_gsi::mkdefs_QFileIconProvider_IconType ());
static gsi::ClassExt<QFileIconProvider> decl_QFileIconProvider_IconType_Enum_as_child (decl_QFileIconProvider_IconType_Enum, "IconType");

}

