
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file generated/gsiDeclQFileDialog_EventAdaptor.cc
*  @brief Event adaptor implementations for QFileDialog
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQFileDialog_EventAdaptor.h"

// -----------------------------------------------------------------------
// class QFileDialog_EventAdaptor

QFileDialog_EventAdaptor::QFileDialog_EventAdaptor (QObject *host)
  : QObject ()
{
  connect (host, SIGNAL(accepted()), this, SLOT(accepted()));
  connect (host, SIGNAL(currentChanged(const QString &)), this, SLOT(currentChanged(const QString &)));
  connect (host, SIGNAL(customContextMenuRequested(const QPoint &)), this, SLOT(customContextMenuRequested(const QPoint &)));
  connect (host, SIGNAL(destroyed(QObject *)), this, SLOT(destroyed(QObject *)));
  connect (host, SIGNAL(directoryEntered(const QString &)), this, SLOT(directoryEntered(const QString &)));
  connect (host, SIGNAL(fileSelected(const QString &)), this, SLOT(fileSelected(const QString &)));
  connect (host, SIGNAL(filesSelected(const QStringList &)), this, SLOT(filesSelected(const QStringList &)));
  connect (host, SIGNAL(filterSelected(const QString &)), this, SLOT(filterSelected(const QString &)));
  connect (host, SIGNAL(finished(int)), this, SLOT(finished(int)));
  connect (host, SIGNAL(rejected()), this, SLOT(rejected()));
}

//  Event QFileDialog::accepted()
void QFileDialog_EventAdaptor::accepted() {
BEGIN_PROTECTED
  accepted_e_0();
END_PROTECTED
}

//  Event QFileDialog::currentChanged(const QString &path)
void QFileDialog_EventAdaptor::currentChanged(const QString &path) {
BEGIN_PROTECTED
  currentChanged_e_2025(path);
END_PROTECTED
}

//  Event QFileDialog::customContextMenuRequested(const QPoint &pos)
void QFileDialog_EventAdaptor::customContextMenuRequested(const QPoint &pos) {
BEGIN_PROTECTED
  customContextMenuRequested_e_1916(pos);
END_PROTECTED
}

//  Event QFileDialog::destroyed(QObject *arg1)
void QFileDialog_EventAdaptor::destroyed(QObject *arg1) {
BEGIN_PROTECTED
  destroyed_e_1302(arg1);
END_PROTECTED
}

//  Event QFileDialog::directoryEntered(const QString &directory)
void QFileDialog_EventAdaptor::directoryEntered(const QString &directory) {
BEGIN_PROTECTED
  directoryEntered_e_2025(directory);
END_PROTECTED
}

//  Event QFileDialog::fileSelected(const QString &file)
void QFileDialog_EventAdaptor::fileSelected(const QString &file) {
BEGIN_PROTECTED
  fileSelected_e_2025(file);
END_PROTECTED
}

//  Event QFileDialog::filesSelected(const QStringList &files)
void QFileDialog_EventAdaptor::filesSelected(const QStringList &files) {
BEGIN_PROTECTED
  filesSelected_e_2437(qt_gsi::CppToQtAdaptor<QStringList>(files));
END_PROTECTED
}

//  Event QFileDialog::filterSelected(const QString &filter)
void QFileDialog_EventAdaptor::filterSelected(const QString &filter) {
BEGIN_PROTECTED
  filterSelected_e_2025(filter);
END_PROTECTED
}

//  Event QFileDialog::finished(int result)
void QFileDialog_EventAdaptor::finished(int result) {
BEGIN_PROTECTED
  finished_e_767(result);
END_PROTECTED
}

//  Event QFileDialog::rejected()
void QFileDialog_EventAdaptor::rejected() {
BEGIN_PROTECTED
  rejected_e_0();
END_PROTECTED
}
